/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host, } from "@stencil/core";
import { getSlottedElements } from "../utils/shadow-dom";
export class MenuAvatar {
    constructor() {
        this.avatarElementId = 'ix-menu-avatar-id';
        this.top = undefined;
        this.bottom = undefined;
        this.image = undefined;
        this.initials = undefined;
        this.i18nLogout = 'Logout';
        this.showLogoutButton = true;
        this.showContextMenu = false;
    }
    onSlotChange() {
        const slot = this.hostElement.shadowRoot.querySelector('slot');
        if (!slot) {
            return;
        }
        const elements = getSlottedElements(slot);
        this.showContextMenu = elements.length !== 0;
    }
    render() {
        return (h(Host, { key: 'c1fa0cee8afddf06bb3d3920d395305a9b911b3c', slot: "ix-menu-avatar" }, h("button", { key: '5012c1e35df4627a9fddb131f545f6e35042250c', class: "nav-item top-item avatar no-hover", title: this.top, id: this.avatarElementId, tabIndex: 0 }, h("ix-avatar", { key: '2a1d4585720d023caeb9a008ee779537fca91715', image: this.image, initials: this.initials }), h("div", { key: 'de59499988b75887263c47c4d9612e8ec7ad3e9d', class: "avatar-name" }, h("span", { key: '7f824012aacf351597139c302ffccaf45df95d22', class: "text-default-single", title: this.top }, this.top), h("span", { key: '8f5d667ac1a6c82c1fd3a30994202457ee007c5a', class: "text-default-single", title: this.bottom }, this.bottom))), h("ix-dropdown", { key: '5345172d53852effd5bd360122079476c3894e24', trigger: this.hostElement, placement: 'right-start', hidden: !this.showContextMenu && !this.showLogoutButton, offset: {
                mainAxis: 16,
            } }, h("slot", { key: '5ded6f40210ba408b6dd2313568c700f5cb56797', onSlotchange: () => this.onSlotChange() }), this.showLogoutButton ? (h("ix-menu-avatar-item", { label: this.i18nLogout, icon: 'log-out', onClick: (e) => {
                this.logoutClick.emit(e);
            } })) : null)));
    }
    static get is() { return "ix-menu-avatar"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["menu-avatar.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["menu-avatar.css"]
        };
    }
    static get properties() {
        return {
            "top": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "First line of text"
                },
                "attribute": "top",
                "reflect": false
            },
            "bottom": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Second line of text"
                },
                "attribute": "bottom",
                "reflect": false
            },
            "image": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "1.4.0"
                        }],
                    "text": "Display a avatar image"
                },
                "attribute": "image",
                "reflect": false
            },
            "initials": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "1.4.0"
                        }],
                    "text": "Display the initials of the user. Will be overwritten by image"
                },
                "attribute": "initials",
                "reflect": false
            },
            "i18nLogout": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Use for translation"
                },
                "attribute": "i-1-8n-logout",
                "reflect": false,
                "defaultValue": "'Logout'"
            },
            "showLogoutButton": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "2.1.0"
                        }],
                    "text": "Control the visibility of the logout button"
                },
                "attribute": "show-logout-button",
                "reflect": false,
                "defaultValue": "true"
            }
        };
    }
    static get states() {
        return {
            "showContextMenu": {}
        };
    }
    static get events() {
        return [{
                "method": "logoutClick",
                "name": "logoutClick",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Logout click"
                },
                "complexType": {
                    "original": "any",
                    "resolved": "any",
                    "references": {}
                }
            }];
    }
    static get elementRef() { return "hostElement"; }
}
//# sourceMappingURL=menu-avatar.js.map
