/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
import { createMutationObserver } from "../utils/mutation-observer";
import { makeRef } from "../utils/make-ref";
import { menuController } from "../utils/menu-service/menu-service";
/**
 * @slot menu-item-label Custom label
 */
export class MenuItem {
    constructor() {
        this.buttonRef = makeRef();
        this.isHostedInsideCategory = false;
        this.observer = createMutationObserver(() => {
            this.setTooltip();
        });
        this.label = undefined;
        this.home = false;
        this.bottom = false;
        this.tabIcon = undefined;
        this.icon = undefined;
        this.notifications = undefined;
        this.active = false;
        this.disabled = false;
        this.isCategory = false;
        this.tooltip = undefined;
        this.menuExpanded = false;
    }
    componentWillLoad() {
        var _a;
        this.isHostedInsideCategory =
            !!this.hostElement.closest('ix-menu-category');
        this.onIconChange();
        this.onTabIconChange();
        this.menuExpanded = ((_a = menuController.nativeElement) === null || _a === void 0 ? void 0 : _a.expand) || false;
        this.menuExpandedDisposer = menuController.expandChange.on((expand) => (this.menuExpanded = expand));
    }
    componentWillRender() {
        this.setTooltip();
    }
    setTooltip() {
        var _a, _b;
        this.tooltip = (_b = (_a = this.label) !== null && _a !== void 0 ? _a : this.hostElement.textContent) !== null && _b !== void 0 ? _b : undefined;
    }
    connectedCallback() {
        this.observer.observe(this.hostElement, {
            subtree: true,
            childList: true,
            characterData: true,
        });
    }
    disconnectedCallback() {
        if (this.observer) {
            this.observer.disconnect();
        }
        if (this.menuExpandedDisposer) {
            this.menuExpandedDisposer.dispose();
        }
    }
    onIconChange() {
        if (!this.isHostedInsideCategory &&
            !this.hostElement.icon &&
            !this.hostElement.tabIcon) {
            this.icon = 'document';
        }
    }
    onTabIconChange() {
        if (!this.isHostedInsideCategory &&
            !this.hostElement.icon &&
            !this.hostElement.tabIcon) {
            this.tabIcon = 'document';
        }
    }
    render() {
        var _a;
        let extendedAttributes = {};
        if (this.home) {
            extendedAttributes = {
                slot: 'home',
            };
        }
        if (this.bottom) {
            extendedAttributes = {
                slot: 'bottom',
            };
        }
        return (h(Host, Object.assign({ key: '88e8f15c522e435f3d0cf1873cc583d241145264', class: {
                disabled: this.disabled,
                'home-tab': this.home,
                'bottom-tab': this.bottom,
                active: this.active,
                'tab-nested': this.isHostedInsideCategory,
            } }, extendedAttributes), h("button", { key: '581d840e9f95e029300a3f14bc63841b919d7639', class: "tab", tabIndex: this.disabled ? -1 : 0, ref: this.buttonRef }, (this.icon || this.tabIcon) && (h("ix-icon", { key: 'b31f3ea13d00770520b0c3a1867fb7f9a9e42a21', class: 'tab-icon', name: (_a = this.icon) !== null && _a !== void 0 ? _a : this.tabIcon })), this.notifications ? (h("div", { class: "notification" }, h("div", { class: "pill" }, this.notifications))) : null, h("span", { key: '977480b74cf07ffd13a9502d679fd3be4103fb17', class: "tab-text text-default" }, this.label, h("slot", { key: '19f5dfc4e6e8909391dc71c8593470dd8f408fd4' }))), !this.isCategory &&
            !this.isHostedInsideCategory &&
            !this.menuExpanded && (h("ix-tooltip", { key: 'e742d5f121663b823cc9a748c2fc8abafbe4d47e', for: this.buttonRef.waitForCurrent(), placement: 'right', showDelay: 1000 }, this.tooltip))));
    }
    static get is() { return "ix-menu-item"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["menu-item.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["menu-item.css"]
        };
    }
    static get properties() {
        return {
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "2.2.0"
                        }],
                    "text": "Label of the menu item. Will also be used as tooltip text"
                },
                "attribute": "label",
                "reflect": false
            },
            "home": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Move the Tab to a top position."
                },
                "attribute": "home",
                "reflect": false,
                "defaultValue": "false"
            },
            "bottom": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Caution: this is no longer working. Please use slot=\"bottom\" instead.\n\nPlace tab on bottom"
                },
                "attribute": "bottom",
                "reflect": false,
                "defaultValue": "false"
            },
            "tabIcon": {
                "type": "string",
                "mutable": true,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "link",
                            "text": "https://ix.siemens.io/docs/icon-library/icons"
                        }, {
                            "name": "deprecated",
                            "text": "since 2.0.0 use `icon` property. Will be removed in 3.0.0"
                        }],
                    "text": "Name of the icon you want to display. Icon names can be resolved from the documentation"
                },
                "attribute": "tab-icon",
                "reflect": false
            },
            "icon": {
                "type": "string",
                "mutable": true,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "link",
                            "text": "https://ix.siemens.io/docs/icon-library/icons"
                        }],
                    "text": "Name of the icon you want to display. Icon names can be resolved from the documentation"
                },
                "attribute": "icon",
                "reflect": false
            },
            "notifications": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Show notification count on tab"
                },
                "attribute": "notifications",
                "reflect": false
            },
            "active": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "State to display active"
                },
                "attribute": "active",
                "reflect": false,
                "defaultValue": "false"
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Disable tab and remove event handlers"
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "isCategory": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }],
                    "text": ""
                },
                "attribute": "is-category",
                "reflect": false,
                "defaultValue": "false"
            }
        };
    }
    static get states() {
        return {
            "tooltip": {},
            "menuExpanded": {}
        };
    }
    static get elementRef() { return "hostElement"; }
    static get watchers() {
        return [{
                "propName": "icon",
                "methodName": "onIconChange"
            }, {
                "propName": "tabIcon",
                "methodName": "onTabIconChange"
            }];
    }
}
//# sourceMappingURL=menu-item.js.map
