/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
/**
 * @since 1.6.0
 */
export class PushCard {
    constructor() {
        this.icon = undefined;
        this.notification = undefined;
        this.heading = undefined;
        this.subheading = undefined;
        this.variant = 'insight';
        this.collapse = true;
    }
    render() {
        var _a;
        const color = this.variant === 'insight' || this.variant === 'notification'
            ? 'std'
            : undefined;
        return (h(Host, { key: '4927262c7896d5db2eb939fa8337ebadb6774229' }, h("ix-card", { key: '03336f0cc37dde84b0a00ac7fd3eab26258e2ac5', variant: this.variant }, h("ix-card-content", { key: '362537f589ab27e6a2a2ac4e732e384b2f08bb52' }, h("ix-card-title", { key: 'df79854b0f6b160938c5cb8111cb68e049dc2a21' }, this.icon ? (h("ix-icon", { class: 'icon', name: this.icon, size: "32" })) : null, h("span", { key: '96a30b27bd3479dccc86974a0c356cc20db07952', class: 'notification' }, (_a = this.notification) !== null && _a !== void 0 ? _a : 0), h("slot", { key: '8c5a4c60df7d7b8785bbb71ea121d9966b531b6f', name: "title-action" })), h("ix-typography", { key: '193883ef7009f3f5b28505333ad4457f9a76bf24', color: color, format: "h4" }, this.heading), h("ix-typography", { key: '1695ab207b51d282b96311b08fd0f1dc01daac36', color: color }, this.subheading)), h("ix-card-accordion", { key: 'ae91fcfe96e7d56e47d6f4579c11e959ceb84f5f', collapse: this.collapse }, h("slot", { key: 'f51b6187302421c78a9a81085609b5f96f6017d4' })))));
    }
    static get is() { return "ix-push-card"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["push-card.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["push-card.css"]
        };
    }
    static get properties() {
        return {
            "icon": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string | undefined",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Card icon"
                },
                "attribute": "icon",
                "reflect": false,
                "defaultValue": "undefined"
            },
            "notification": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Card KPI value"
                },
                "attribute": "notification",
                "reflect": false
            },
            "heading": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Card heading"
                },
                "attribute": "heading",
                "reflect": false
            },
            "subheading": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Card subheading"
                },
                "attribute": "subheading",
                "reflect": false
            },
            "variant": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "PushCardVariant",
                    "resolved": "\"alarm\" | \"critical\" | \"filled\" | \"info\" | \"insight\" | \"neutral\" | \"notification\" | \"outline\" | \"primary\" | \"success\" | \"warning\"",
                    "references": {
                        "PushCardVariant": {
                            "location": "local",
                            "path": "/home/runner/work/ix/ix/packages/core/src/components/push-card/push-card.tsx",
                            "id": "src/components/push-card/push-card.tsx::PushCardVariant"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "variant \"insight\" and \"notification\" will be removed in 3.0. Use \"outline\" or \"filled\" instead."
                        }],
                    "text": "Card variant"
                },
                "attribute": "variant",
                "reflect": false,
                "defaultValue": "'insight'"
            },
            "collapse": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "2.1.0"
                        }],
                    "text": "Collapse the card"
                },
                "attribute": "collapse",
                "reflect": false,
                "defaultValue": "true"
            }
        };
    }
}
//# sourceMappingURL=push-card.js.map
