var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
        r = Reflect.decorate(decorators, target, key, desc);
    else
        for (var i = decorators.length - 1; i >= 0; i--)
            if (d = decorators[i])
                r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { Host, h, } from "@stencil/core";
import { HookValidationLifecycle, } from "../utils/input";
/**
 * @since 2.6.0
 * @form-ready 2.6.0
 */
export class RadiobuttonGroup {
    constructor() {
        this.observer = new MutationObserver(() => {
            this.ensureOnlyLastRadioChecked();
        });
        this.helperText = undefined;
        this.label = undefined;
        this.value = undefined;
        this.invalidText = undefined;
        this.infoText = undefined;
        this.warningText = undefined;
        this.validText = undefined;
        this.showTextAsTooltip = undefined;
        this.direction = 'column';
        this.isInvalid = false;
        this.isValid = false;
        this.isInfo = false;
        this.isWarning = false;
    }
    get radiobuttonElements() {
        return Array.from(this.hostElement.querySelectorAll('ix-radio'));
    }
    connectedCallback() {
        this.observer.observe(this.hostElement, {
            childList: true,
            subtree: true,
            attributes: true,
            attributeFilter: ['checked'],
        });
    }
    componentWillLoad() {
        this.selectInitialValue();
        this.ensureOnlyLastRadioChecked();
    }
    disconnectedCallback() {
        if (this.observer) {
            this.observer.disconnect();
        }
    }
    selectInitialValue() {
        if (!this.value) {
            return;
        }
        this.radiobuttonElements.forEach((radiobutton) => {
            radiobutton.checked = radiobutton.value === this.value;
        });
    }
    ensureOnlyLastRadioChecked() {
        const checkedRadios = this.radiobuttonElements.filter((radio) => radio.checked);
        checkedRadios.forEach((radio, index) => {
            if (index === checkedRadios.length - 1) {
                return;
            }
            radio.checked = false;
        });
    }
    onValueChangeHandler(newValue) {
        this.radiobuttonElements.forEach((radiobutton) => {
            radiobutton.checked = radiobutton.value === newValue;
        });
    }
    onCheckedChangeHandler(event) {
        this.radiobuttonElements.forEach((radiobutton) => {
            if (radiobutton !== event.target) {
                radiobutton.checked = false;
                return;
            }
            radiobutton.checked = true;
            this.valueChange.emit(radiobutton.value);
        });
    }
    onClassField({ isInvalid, isInfo, isValid, isWarning }) {
        this.isInvalid = isInvalid;
        this.isInfo = isInfo;
        this.isValid = isValid;
        this.isWarning = isWarning;
    }
    render() {
        return (h(Host, { key: 'e34f29dfa844a5d74969e0d7d4524ac0b35ed819' }, h("ix-field-wrapper", { key: 'f146673dd9ff78690cc0b52378793b0c94b20fac', label: this.label, helperText: this.helperText, invalidText: this.invalidText, infoText: this.infoText, warningText: this.warningText, validText: this.validText, showTextAsTooltip: this.showTextAsTooltip, isValid: this.isValid, isInfo: this.isInfo, isWarning: this.isWarning, isInvalid: this.isInvalid }, h("div", { key: '9280999ed1c6630ae9500e2f73de26a12ea1c417', class: {
                'checkbox-container': true,
                'row-layout': this.direction === 'row',
            } }, h("slot", { key: '7556d4a6396633bc085ebf5cb12070d7a3c673e5' })))));
    }
    static get is() { return "ix-radio-group"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["radio-group.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["radio-group.css"]
        };
    }
    static get properties() {
        return {
            "helperText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Show text below the field component"
                },
                "attribute": "helper-text",
                "reflect": false
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Label for the field component"
                },
                "attribute": "label",
                "reflect": false
            },
            "value": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Value of the radiobutton group component"
                },
                "attribute": "value",
                "reflect": false
            },
            "invalidText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Error text for the field component"
                },
                "attribute": "invalid-text",
                "reflect": false
            },
            "infoText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Info text for the field component"
                },
                "attribute": "info-text",
                "reflect": false
            },
            "warningText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Warning text for the field component"
                },
                "attribute": "warning-text",
                "reflect": false
            },
            "validText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Valid text for the field component"
                },
                "attribute": "valid-text",
                "reflect": false
            },
            "showTextAsTooltip": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Show helper, info, warning, error and valid text as tooltip"
                },
                "attribute": "show-text-as-tooltip",
                "reflect": false
            },
            "direction": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "'column' | 'row'",
                    "resolved": "\"column\" | \"row\"",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Alignment of the radio buttons in the group"
                },
                "attribute": "direction",
                "reflect": false,
                "defaultValue": "'column'"
            }
        };
    }
    static get states() {
        return {
            "isInvalid": {},
            "isValid": {},
            "isInfo": {},
            "isWarning": {}
        };
    }
    static get events() {
        return [{
                "method": "valueChange",
                "name": "valueChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Event emitted when the value of the radiobutton group changes"
                },
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                }
            }];
    }
    static get elementRef() { return "hostElement"; }
    static get watchers() {
        return [{
                "propName": "value",
                "methodName": "onValueChangeHandler"
            }];
    }
    static get listeners() {
        return [{
                "name": "checkedChange",
                "method": "onCheckedChangeHandler",
                "target": undefined,
                "capture": false,
                "passive": false
            }];
    }
}
__decorate([
    HookValidationLifecycle({
        includeChildren: true,
    })
], RadiobuttonGroup.prototype, "onClassField", null);
//# sourceMappingURL=radio-group.js.map
