/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { Host, h, } from "@stencil/core";
import { makeRef } from "../utils/make-ref";
/**
 * @since 2.6.0
 * @form-ready 2.6.0
 */
export class Radio {
    constructor() {
        /**
         * Single radio cannot be required
         * */
        this.required = false;
        this.inputRef = makeRef((radiobuttonRef) => {
            radiobuttonRef.checked = this.checked;
        });
        this.name = undefined;
        this.value = undefined;
        this.label = undefined;
        this.disabled = false;
        this.checked = false;
    }
    setCheckedState(newChecked) {
        if (this.checked) {
            return;
        }
        const result = this.checkedChange.emit(newChecked);
        if (result.defaultPrevented) {
            return;
        }
        this.checked = newChecked;
    }
    async onCheckedChange() {
        const radiobuttonRef = await this.inputRef.waitForCurrent();
        radiobuttonRef.checked = this.checked;
        this.updateFormInternalValue();
    }
    onValueChange() {
        this.valueChange.emit(this.value);
    }
    componentWillLoad() {
        this.updateFormInternalValue();
    }
    updateFormInternalValue() {
        var _a;
        if (this.checked) {
            this.formInternals.setFormValue((_a = this.value) !== null && _a !== void 0 ? _a : 'on');
        }
        else {
            this.formInternals.setFormValue(null);
        }
    }
    /** @internal */
    hasValidValue() {
        return Promise.resolve(this.checked);
    }
    /** @internal */
    getAssociatedFormElement() {
        return Promise.resolve(this.formInternals.form);
    }
    render() {
        return (h(Host, { key: '11d1cadf723d642f0591cb49635cd13771190258', "aria-checked": `${this.checked}`, "aria-disabled": `${this.disabled}`, role: "radio", class: {
                disabled: this.disabled,
                checked: this.checked,
            } }, h("label", { key: '9e93f5f146dc7798f0a7cf254a47ee1d35ef8c14' }, h("input", { key: 'fc2e99c93b347221cd905ea4572b6657a68fb314', "aria-checked": `${this.checked}`, disabled: this.disabled, checked: this.checked, ref: this.inputRef, type: "radio", onChange: () => {
                const ref = this.inputRef.current;
                if (ref) {
                    this.setCheckedState(ref.checked);
                }
            } }), h("button", { key: '3134b9849b111543886c2dd028dc7f71c1b171a2', disabled: this.disabled, class: {
                checked: this.checked,
            }, onClick: () => this.setCheckedState(!this.checked) }, this.checked && h("div", { key: 'e311bab1c26e47016ab6594d6e2dab648580d270', class: "checkmark" })), h("ix-typography", { key: 'd68fa858f9fc9856153380d69e631fad74588c31', format: "label", textColor: this.disabled ? 'weak' : 'std' }, this.label, h("slot", { key: '2b4de064a6c233b61e672a2799493b846c2586af' })))));
    }
    static get is() { return "ix-radio"; }
    static get encapsulation() { return "shadow"; }
    static get formAssociated() { return true; }
    static get originalStyleUrls() {
        return {
            "$": ["radio.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["radio.css"]
        };
    }
    static get properties() {
        return {
            "name": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Name of the radio component"
                },
                "attribute": "name",
                "reflect": true
            },
            "value": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Value of the radio component"
                },
                "attribute": "value",
                "reflect": true
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Label for the radio component"
                },
                "attribute": "label",
                "reflect": false
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Disabled state of the radio component"
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "checked": {
                "type": "boolean",
                "mutable": true,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Checked state of the radio component"
                },
                "attribute": "checked",
                "reflect": true,
                "defaultValue": "false"
            }
        };
    }
    static get events() {
        return [{
                "method": "checkedChange",
                "name": "checkedChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Event emitted when the checked state of the radio changes"
                },
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                }
            }, {
                "method": "valueChange",
                "name": "valueChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Event emitted when the value of the radio changes"
                },
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                }
            }];
    }
    static get methods() {
        return {
            "hasValidValue": {
                "complexType": {
                    "signature": "() => Promise<boolean>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<boolean>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }]
                }
            },
            "getAssociatedFormElement": {
                "complexType": {
                    "signature": "() => Promise<HTMLFormElement | null>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        },
                        "HTMLFormElement": {
                            "location": "global",
                            "id": "global::HTMLFormElement"
                        }
                    },
                    "return": "Promise<HTMLFormElement>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }]
                }
            }
        };
    }
    static get elementRef() { return "hostElement"; }
    static get watchers() {
        return [{
                "propName": "checked",
                "methodName": "onCheckedChange"
            }, {
                "propName": "value",
                "methodName": "onValueChange"
            }];
    }
    static get attachInternalsMemberName() { return "formInternals"; }
}
//# sourceMappingURL=radio.js.map
