/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
        r = Reflect.decorate(decorators, target, key, desc);
    else
        for (var i = decorators.length - 1; i >= 0; i--)
            if (d = decorators[i])
                r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { h, Host, } from "@stencil/core";
import { ArrowFocusController } from "../utils/focus";
import { OnListener } from "../utils/listener";
import { createMutationObserver } from "../utils/mutation-observer";
import { HookValidationLifecycle, } from "../utils/input";
import { makeRef } from "../utils/make-ref";
import { a11yBoolean } from "../utils/a11y";
/**
 * @form-ready 2.6.0
 */
export class Select {
    constructor() {
        this.dropdownWrapperRef = makeRef();
        this.dropdownAnchor = makeRef();
        this.itemObserver = createMutationObserver(() => {
            if (!this.arrowFocusController) {
                return;
            }
            this.arrowFocusController.items = this.visibleNonShadowItems;
        });
        this.focusControllerCallbackBind = this.focusDropdownItem.bind(this);
        this.name = undefined;
        this.required = false;
        this.label = undefined;
        this.warningText = undefined;
        this.infoText = undefined;
        this.invalidText = undefined;
        this.validText = undefined;
        this.helperText = undefined;
        this.showTextAsTooltip = undefined;
        this.selectedIndices = undefined;
        this.value = [];
        this.allowClear = false;
        this.mode = 'single';
        this.editable = false;
        this.disabled = false;
        this.readonly = false;
        this.i18nPlaceholder = 'Select an option';
        this.i18nPlaceholderEditable = 'Type of select option';
        this.i18nSelectListHeader = 'Select an option';
        this.i18nNoMatches = 'No matches';
        this.hideListHeader = false;
        this.dropdownShow = false;
        this.selectedLabels = [];
        this.isDropdownEmpty = false;
        this.navigationItem = undefined;
        this.inputFilterText = '';
        this.inputValue = '';
        this.isInvalid = false;
        this.isValid = false;
        this.isInfo = false;
        this.isWarning = false;
    }
    get nonShadowItems() {
        return Array.from(this.hostElement.querySelectorAll('ix-select-item'));
    }
    get visibleNonShadowItems() {
        return this.nonShadowItems.filter((item) => !item.classList.contains('d-none'));
    }
    get shadowItems() {
        return Array.from(this.hostElement.shadowRoot.querySelectorAll('ix-select-item'));
    }
    get visibleShadowItems() {
        return this.shadowItems.filter((item) => !item.classList.contains('d-none'));
    }
    get items() {
        return [...this.nonShadowItems, ...this.shadowItems];
    }
    get visibleItems() {
        return this.items.filter((item) => !item.classList.contains('d-none'));
    }
    get selectedItems() {
        return this.items.filter((item) => item.selected);
    }
    get addItemButton() {
        return this.hostElement.shadowRoot.querySelector('.add-item');
    }
    get isSingleMode() {
        return this.mode === 'single';
    }
    get isMultipleMode() {
        return this.mode === 'multiple';
    }
    get isEveryDropdownItemHidden() {
        return this.items.every((item) => item.classList.contains('d-none'));
    }
    watchSelectedIndices(value) {
        this.value = value;
        this.updateSelection();
    }
    watchValue(value) {
        this.selectedIndices = value;
        this.updateSelection();
    }
    watchDropdownShow(show) {
        if (show) {
            this.arrowFocusController = new ArrowFocusController(this.visibleNonShadowItems, this.dropdownRef, this.focusControllerCallbackBind);
            this.arrowFocusController.wrap = !this.editable;
            this.itemObserver.observe(this.dropdownRef, {
                childList: true,
                subtree: true,
            });
        }
        else {
            this.cleanupResources();
        }
    }
    cleanupResources() {
        var _a, _b;
        (_a = this.arrowFocusController) === null || _a === void 0 ? void 0 : _a.disconnect();
        this.arrowFocusController = undefined;
        (_b = this.itemObserver) === null || _b === void 0 ? void 0 : _b.disconnect();
    }
    onItemClicked(event) {
        const newId = event.detail;
        this.itemClick(newId);
    }
    async updateFormInternalValue(value) {
        if (Array.isArray(value)) {
            this.formInternals.setFormValue(value.join(','));
            return;
        }
        this.formInternals.setFormValue(value);
    }
    /** @internal */
    async hasValidValue() {
        return this.required && !!this.hasValue();
    }
    hasValue() {
        if (Array.isArray(this.value)) {
            return !!this.value.length;
        }
        return !!this.value;
    }
    focusDropdownItem(index) {
        var _a, _b;
        this.navigationItem = null;
        if (index < this.visibleNonShadowItems.length) {
            const nestedDropdownItem = (_b = (_a = this.visibleNonShadowItems[index]) === null || _a === void 0 ? void 0 : _a.shadowRoot) === null || _b === void 0 ? void 0 : _b.querySelector('ix-dropdown-item');
            if (!nestedDropdownItem) {
                return;
            }
            requestAnimationFrame(() => {
                var _a, _b;
                (_b = (_a = nestedDropdownItem === null || nestedDropdownItem === void 0 ? void 0 : nestedDropdownItem.shadowRoot) === null || _a === void 0 ? void 0 : _a.querySelector('button')) === null || _b === void 0 ? void 0 : _b.focus();
            });
        }
    }
    itemClick(newId) {
        const oldValue = this.value;
        const value = this.toggleValue(newId);
        this.value = value;
        const defaultPrevented = this.emitValueChange(value);
        if (defaultPrevented) {
            this.value = oldValue;
            return;
        }
        this.updateSelection();
    }
    emitAddItem(value) {
        if (value === undefined || value.trim() === '') {
            return false;
        }
        const { defaultPrevented } = this.addItem.emit(value);
        if (defaultPrevented) {
            return true;
        }
        const newItem = document.createElement('ix-select-item');
        newItem.value = value;
        newItem.label = value;
        this.customItemsContainerRef.appendChild(newItem);
        this.clearInput();
        this.itemClick(value);
        return false;
    }
    toggleValue(itemValue) {
        if (!this.isMultipleMode) {
            return itemValue;
        }
        if (!this.value) {
            return [itemValue];
        }
        let value = this.value;
        if (!Array.isArray(value)) {
            value = [value];
        }
        if (value.includes(itemValue)) {
            return value.filter((value) => value !== itemValue);
        }
        else {
            return [...value, itemValue];
        }
    }
    updateSelection() {
        var _a;
        let ids = [];
        if (this.value) {
            ids = Array.isArray(this.value) ? [...this.value] : [this.value];
        }
        this.items.forEach((item) => {
            item.selected = ids.some((i) => {
                if (typeof i !== typeof item.value) {
                    return i.toString() === item.value.toString();
                }
                else {
                    return i === item.value;
                }
            });
        });
        this.selectedLabels = this.selectedItems.map((item) => item.label);
        if (((_a = this.selectedLabels) === null || _a === void 0 ? void 0 : _a.length) && this.isSingleMode) {
            this.inputValue = this.selectedLabels[0];
        }
        else {
            this.inputValue = '';
        }
        this.inputRef && (this.inputRef.value = this.inputValue);
    }
    emitValueChange(value) {
        const { defaultPrevented } = this.valueChange.emit(value);
        if (defaultPrevented) {
            return true;
        }
        if (!value) {
            this.itemSelectionChange.emit(null);
        }
        else {
            this.itemSelectionChange.emit(Array.isArray(value) ? value : [value]);
        }
        this.updateFormInternalValue(value);
        return false;
    }
    componentDidLoad() {
        var _a;
        (_a = this.inputRef) === null || _a === void 0 ? void 0 : _a.addEventListener('input', () => {
            var _a;
            this.dropdownShow = true;
            this.inputChange.emit((_a = this.inputRef) === null || _a === void 0 ? void 0 : _a.value);
        });
    }
    componentWillLoad() {
        if (this.selectedIndices && !this.value) {
            this.value = this.selectedIndices;
        }
        this.updateSelection();
        this.updateFormInternalValue(this.value);
    }
    onLabelChange(event) {
        event.preventDefault();
        event.stopImmediatePropagation();
        this.updateSelection();
    }
    disconnectedCallback() {
        this.cleanupResources();
    }
    itemExists(item) {
        return this.items.find((i) => i.label === item);
    }
    dropdownVisibilityChanged(event) {
        var _a, _b;
        this.dropdownShow = event.detail;
        if (event.detail) {
            (_a = this.inputRef) === null || _a === void 0 ? void 0 : _a.focus();
            (_b = this.inputRef) === null || _b === void 0 ? void 0 : _b.select();
            this.removeHiddenFromItems();
            this.isDropdownEmpty = this.isEveryDropdownItemHidden;
        }
        else {
            this.navigationItem = null;
            this.updateSelection();
            this.inputFilterText = '';
        }
    }
    async onKeyDown(event) {
        if (event.code === 'ArrowDown' || event.code === 'ArrowUp') {
            await this.onArrowNavigation(event, event.code);
        }
        if (!this.dropdownShow) {
            return;
        }
        if (event.code === 'Enter' || event.code === 'NumpadEnter') {
            await this.onEnterNavigation(event.target);
        }
        if (event.code === 'Escape') {
            this.dropdownShow = false;
        }
    }
    async onEnterNavigation(el) {
        if (this.isMultipleMode) {
            return;
        }
        if (!this.itemExists(this.inputFilterText.trim()) &&
            !this.itemExists(el === null || el === void 0 ? void 0 : el.label)) {
            if (this.editable) {
                const defaultPrevented = this.emitAddItem(this.inputFilterText.trim());
                if (defaultPrevented) {
                    return;
                }
            }
        }
        this.dropdownShow = false;
        this.updateSelection();
    }
    async onArrowNavigation(event, key) {
        if (event.defaultPrevented) {
            return;
        }
        event.preventDefault();
        event.stopPropagation();
        this.dropdownShow = true;
        if (!this.navigationItem && document.activeElement === this.hostElement) {
            if (this.visibleItems.length) {
                this.applyFocusTo(this.visibleItems.shift());
            }
            else if (this.isAddItemVisible()) {
                this.focusAddItemButton();
            }
            return;
        }
        const moveUp = key === 'ArrowUp';
        const indexNonShadow = document.activeElement
            ? this.visibleNonShadowItems.indexOf(document.activeElement)
            : -1;
        // Slotted select items
        if (indexNonShadow === 0) {
            if (!this.visibleShadowItems.length && this.isAddItemVisible()) {
                this.focusAddItemButton();
            }
            else {
                this.applyFocusTo(this.visibleShadowItems.pop());
            }
            return;
        }
        else if (indexNonShadow !== -1 &&
            indexNonShadow === this.visibleNonShadowItems.length - 1) {
            if (this.visibleShadowItems.length) {
                this.applyFocusTo(this.visibleShadowItems.shift());
            }
            else if (this.isAddItemVisible()) {
                this.focusAddItemButton();
            }
            return;
        }
        if (!this.navigationItem) {
            return;
        }
        if (this.isAddItemVisible() &&
            this.addItemRef.contains(await this.navigationItem.getDropdownItemElement())) {
            if (moveUp) {
                this.applyFocusTo(this.visibleItems.pop());
            }
            else {
                if (this.visibleItems.length) {
                    this.applyFocusTo(this.visibleItems.shift());
                }
            }
            return;
        }
        // Custom select items
        const indexShadow = this.visibleShadowItems.indexOf(this.navigationItem);
        if (moveUp) {
            if (indexShadow === 0) {
                if (this.visibleNonShadowItems.length) {
                    this.applyFocusTo(this.visibleNonShadowItems.pop());
                }
                else if (this.isAddItemVisible()) {
                    this.focusAddItemButton();
                }
            }
            else {
                this.applyFocusTo(this.visibleShadowItems[indexShadow - 1]);
            }
        }
        else {
            if (indexShadow === this.visibleShadowItems.length - 1) {
                if (this.isAddItemVisible()) {
                    this.focusAddItemButton();
                }
                else {
                    this.applyFocusTo(this.visibleItems.shift());
                }
            }
            else {
                this.applyFocusTo(this.visibleShadowItems[indexShadow + 1]);
            }
        }
    }
    applyFocusTo(element) {
        if (!element) {
            return;
        }
        this.navigationItem = element;
        setTimeout(() => {
            var _a, _b, _c, _d;
            (_d = (_c = (_b = (_a = element.shadowRoot) === null || _a === void 0 ? void 0 : _a.querySelector('ix-dropdown-item')) === null || _b === void 0 ? void 0 : _b.shadowRoot) === null || _c === void 0 ? void 0 : _c.querySelector('button')) === null || _d === void 0 ? void 0 : _d.focus();
        });
    }
    focusAddItemButton() {
        var _a, _b;
        if (this.addItemButton) {
            (_b = (_a = this.addItemButton.shadowRoot) === null || _a === void 0 ? void 0 : _a.querySelector('button')) === null || _b === void 0 ? void 0 : _b.focus();
            this.navigationItem = this.addItemRef;
        }
    }
    filterItemsWithTypeahead() {
        var _a;
        this.inputFilterText = ((_a = this.inputRef) === null || _a === void 0 ? void 0 : _a.value) || '';
        if (this.isSingleMode && this.inputFilterText === this.selectedLabels[0]) {
            return;
        }
        if (this.inputFilterText) {
            this.items.forEach((item) => {
                item.classList.remove('d-none');
                if (!item.label.toLowerCase().includes(this.inputFilterText.toLowerCase())) {
                    item.classList.add('d-none');
                }
            });
        }
        else {
            this.removeHiddenFromItems();
        }
        if (this.arrowFocusController) {
            this.arrowFocusController.items = this.visibleNonShadowItems;
        }
        this.isDropdownEmpty = this.isEveryDropdownItemHidden;
    }
    removeHiddenFromItems() {
        this.items.forEach((item) => {
            item.classList.remove('d-none');
        });
    }
    clearInput() {
        if (this.inputRef) {
            this.inputRef.value = '';
        }
        this.inputFilterText = '';
    }
    clear() {
        this.clearInput();
        this.selectedLabels = [];
        this.value = [];
        this.emitValueChange([]);
        this.dropdownShow = false;
    }
    onInputBlur(event) {
        this.ixBlur.emit();
        if (this.editable) {
            return;
        }
        if (this.isSingleMode) {
            return;
        }
        const target = event.target;
        if (!this.dropdownShow && this.mode !== 'multiple') {
            target.value = this.selectedLabels.toString();
        }
    }
    placeholderValue() {
        if (this.disabled) {
            return '';
        }
        if (this.readonly) {
            return '';
        }
        if (this.editable) {
            return this.i18nPlaceholderEditable;
        }
        return this.i18nPlaceholder;
    }
    isAddItemVisible() {
        return (!this.itemExists(this.inputFilterText) &&
            this.editable &&
            this.inputFilterText);
    }
    onValidationChange({ isInvalid, isInvalidByRequired, isValid, isInfo, isWarning, }) {
        this.isInvalid = isInvalid || isInvalidByRequired;
        this.isValid = isValid;
        this.isWarning = isWarning;
        this.isInfo = isInfo;
    }
    /** @internal */
    async getAssociatedFormElement() {
        return this.formInternals.form;
    }
    /**
     * Returns the native input element used in the component.
     */
    getNativeInputElement() {
        return Promise.resolve(this.inputRef);
    }
    /**
     * Focuses the input field
     */
    async focusInput() {
        return (await this.getNativeInputElement()).focus();
    }
    render() {
        var _a, _b, _c, _d;
        return (h(Host, { key: '99abe58329d0fcd9911caacef49b66274489814f', "aria-disabled": a11yBoolean(this.disabled), class: {
                disabled: this.disabled,
            } }, h("ix-field-wrapper", { key: '89c8de8e9f35f0c5183be8dcd8e6b891016f6ef3', required: this.required, label: this.label, helperText: this.helperText, invalidText: this.invalidText, infoText: this.infoText, warningText: this.warningText, validText: this.validText, showTextAsTooltip: this.showTextAsTooltip, isInvalid: this.isInvalid, isValid: this.isValid, isInfo: this.isInfo, isWarning: this.isWarning, controlRef: this.inputRef }, h("div", { key: 'e103c45c3df1dbf9f4dd23e2d062a39b39d6b995', class: {
                select: true,
                disabled: this.disabled,
                readonly: this.readonly,
            }, ref: (ref) => {
                this.dropdownAnchor(ref);
                if (!this.editable)
                    this.dropdownWrapperRef(ref);
            } }, h("div", { key: '2bafbbf9195ac7303c2e1fb2331481cf3af078ee', class: "input-container" }, h("div", { key: 'c69296e322974fd1659d9794bc4469c7faab6ba0', class: "chips" }, this.isMultipleMode
            ? (_a = this.selectedItems) === null || _a === void 0 ? void 0 : _a.map((item) => (h("ix-filter-chip", { disabled: this.disabled || this.readonly, key: item.value, onCloseClick: (e) => {
                    e.preventDefault();
                    e.stopPropagation();
                    this.itemClick(item.value);
                } }, item.label)))
            : '', h("div", { key: '49b13da2a7e8230b41b8365394694d6f9991b367', class: "trigger" }, h("input", { key: 'fbafa635a105fec9f43756e0e767d4567355d224', autocomplete: "off", "data-testid": "input", disabled: this.disabled, readOnly: this.readonly, required: this.required, type: "text", class: {
                'allow-clear': this.allowClear && !!((_b = this.selectedLabels) === null || _b === void 0 ? void 0 : _b.length),
            }, placeholder: this.placeholderValue(), value: (_c = this.inputValue) !== null && _c !== void 0 ? _c : '', ref: (ref) => (this.inputRef = ref), onBlur: (e) => this.onInputBlur(e), onFocus: () => {
                this.navigationItem = null;
            }, onInput: () => this.filterItemsWithTypeahead(), onKeyDown: (e) => this.onKeyDown(e) }), this.allowClear &&
            (((_d = this.selectedLabels) === null || _d === void 0 ? void 0 : _d.length) || this.inputFilterText) ? (h("ix-icon-button", { class: "clear", icon: 'clear', ghost: true, oval: true, size: "16", onClick: (e) => {
                e.preventDefault();
                e.stopPropagation();
                this.clear();
            } })) : null, this.disabled || this.readonly ? null : (h("ix-icon-button", { "data-select-dropdown": true, class: { 'dropdown-visible': this.dropdownShow }, icon: "chevron-down-small", ghost: true, ref: (ref) => {
                if (this.editable)
                    this.dropdownWrapperRef(ref);
            } }))))))), h("ix-dropdown", { key: '1ce2a1c9e706231b16729de9ab6860a3040cf6b8', ref: (ref) => (this.dropdownRef = ref), show: this.dropdownShow, closeBehavior: this.isMultipleMode ? 'outside' : 'both', class: {
                'd-none': this.disabled || this.readonly,
            }, anchor: this.dropdownAnchor.waitForCurrent(), trigger: this.dropdownWrapperRef.waitForCurrent(), onShowChanged: (e) => this.dropdownVisibilityChanged(e), placement: "bottom-start", overwriteDropdownStyle: async () => {
                var _a, _b;
                const minWidth = (_b = (_a = this.hostElement.shadowRoot) === null || _a === void 0 ? void 0 : _a.querySelector('.select')) === null || _b === void 0 ? void 0 : _b.getBoundingClientRect().width;
                return {
                    minWidth: `${minWidth}px`,
                };
            } }, h("div", { key: '9a60476d90a72bb423434438d947ed5acd237a0b', class: {
                'select-list-header': true,
                hidden: this.hideListHeader || this.isDropdownEmpty,
            }, title: this.i18nSelectListHeader, onClick: (e) => e.preventDefault() }, this.i18nSelectListHeader), h("slot", { key: '375d3631327065cfed363398941c79550a34e4bd', onSlotchange: () => {
                this.updateSelection();
            } }), h("div", { key: '86946fcba90f1d30760539b778449c53c99caa18', ref: (ref) => (this.customItemsContainerRef = ref), class: "d-contents" }), this.isAddItemVisible() ? (h("ix-dropdown-item", { "data-testid": "add-item", icon: 'plus', class: {
                'add-item': true,
            }, label: this.inputFilterText, onItemClick: (e) => {
                e.preventDefault();
                e.stopPropagation();
                this.emitAddItem(this.inputFilterText);
            }, onFocus: () => (this.navigationItem = this.addItemRef), ref: (ref) => {
                this.addItemRef = ref;
            } })) : null, this.isDropdownEmpty && !this.editable ? (h("div", { class: "select-list-header" }, this.i18nNoMatches)) : (''))));
    }
    static get is() { return "ix-select"; }
    static get encapsulation() { return "shadow"; }
    static get formAssociated() { return true; }
    static get originalStyleUrls() {
        return {
            "$": ["select.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["select.css"]
        };
    }
    static get properties() {
        return {
            "name": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "2.6.0"
                        }],
                    "text": "A string that represents the element's name attribute,\ncontaining a name that identifies the element when submitting the form."
                },
                "attribute": "name",
                "reflect": true
            },
            "required": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "2.6.0"
                        }],
                    "text": "A Boolean attribute indicating that an option with a non-empty string value must be selected"
                },
                "attribute": "required",
                "reflect": true,
                "defaultValue": "false"
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "2.6.0"
                        }],
                    "text": "Label for the select component"
                },
                "attribute": "label",
                "reflect": false
            },
            "warningText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "2.6.0"
                        }],
                    "text": "Warning text for the select component"
                },
                "attribute": "warning-text",
                "reflect": false
            },
            "infoText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "2.6.0"
                        }],
                    "text": "Info text for the select component"
                },
                "attribute": "info-text",
                "reflect": false
            },
            "invalidText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "2.6.0"
                        }],
                    "text": "Error text for the select component"
                },
                "attribute": "invalid-text",
                "reflect": false
            },
            "validText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "2.6.0"
                        }],
                    "text": "Valid text for the select component"
                },
                "attribute": "valid-text",
                "reflect": false
            },
            "helperText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "2.6.0"
                        }],
                    "text": "Helper text for the select component"
                },
                "attribute": "helper-text",
                "reflect": false
            },
            "showTextAsTooltip": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "2.6.0"
                        }],
                    "text": "Show helper, error, info, warning text as tooltip"
                },
                "attribute": "show-text-as-tooltip",
                "reflect": false
            },
            "selectedIndices": {
                "type": "string",
                "mutable": true,
                "complexType": {
                    "original": "string | string[]",
                    "resolved": "string | string[]",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "since 2.0.0. Use the `value` property instead."
                        }],
                    "text": "Indices of selected items.\nThis corresponds to the value property of ix-select-items and therefor not necessarily the indices of the items in the list."
                },
                "attribute": "selected-indices",
                "reflect": false
            },
            "value": {
                "type": "string",
                "mutable": true,
                "complexType": {
                    "original": "string | string[]",
                    "resolved": "string | string[]",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "2.0.0"
                        }],
                    "text": "Current selected value.\nThis corresponds to the value property of ix-select-items"
                },
                "attribute": "value",
                "reflect": false,
                "defaultValue": "[]"
            },
            "allowClear": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Show clear button"
                },
                "attribute": "allow-clear",
                "reflect": false,
                "defaultValue": "false"
            },
            "mode": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "'single' | 'multiple'",
                    "resolved": "\"multiple\" | \"single\"",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Selection mode"
                },
                "attribute": "mode",
                "reflect": false,
                "defaultValue": "'single'"
            },
            "editable": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Select is extendable"
                },
                "attribute": "editable",
                "reflect": false,
                "defaultValue": "false"
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If true the select will be in disabled state"
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "readonly": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "If true the select will be in readonly mode"
                },
                "attribute": "readonly",
                "reflect": false,
                "defaultValue": "false"
            },
            "i18nPlaceholder": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Input field placeholder"
                },
                "attribute": "i-1-8n-placeholder",
                "reflect": false,
                "defaultValue": "'Select an option'"
            },
            "i18nPlaceholderEditable": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Input field placeholder for editable select"
                },
                "attribute": "i-1-8n-placeholder-editable",
                "reflect": false,
                "defaultValue": "'Type of select option'"
            },
            "i18nSelectListHeader": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Select list header"
                },
                "attribute": "i-1-8n-select-list-header",
                "reflect": false,
                "defaultValue": "'Select an option'"
            },
            "i18nNoMatches": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "1.5.0"
                        }],
                    "text": "Information inside of dropdown if no items where found with current filter text"
                },
                "attribute": "i-1-8n-no-matches",
                "reflect": false,
                "defaultValue": "'No matches'"
            },
            "hideListHeader": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "1.5.0"
                        }],
                    "text": "Hide list header"
                },
                "attribute": "hide-list-header",
                "reflect": false,
                "defaultValue": "false"
            }
        };
    }
    static get states() {
        return {
            "dropdownShow": {},
            "selectedLabels": {},
            "isDropdownEmpty": {},
            "navigationItem": {},
            "inputFilterText": {},
            "inputValue": {},
            "isInvalid": {},
            "isValid": {},
            "isInfo": {},
            "isWarning": {}
        };
    }
    static get events() {
        return [{
                "method": "valueChange",
                "name": "valueChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "2.0.0"
                        }],
                    "text": "Value changed"
                },
                "complexType": {
                    "original": "string | string[]",
                    "resolved": "string | string[]",
                    "references": {}
                }
            }, {
                "method": "itemSelectionChange",
                "name": "itemSelectionChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "since 2.0.0. Use `valueChange` instead."
                        }],
                    "text": "Item selection changed"
                },
                "complexType": {
                    "original": "string[]",
                    "resolved": "string[]",
                    "references": {}
                }
            }, {
                "method": "inputChange",
                "name": "inputChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "2.0.0"
                        }],
                    "text": "Event dispatched whenever the text input changes."
                },
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                }
            }, {
                "method": "addItem",
                "name": "addItem",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Item added to selection"
                },
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                }
            }, {
                "method": "ixBlur",
                "name": "ixBlur",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Blur input"
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
    static get methods() {
        return {
            "hasValidValue": {
                "complexType": {
                    "signature": "() => Promise<boolean>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<boolean>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }]
                }
            },
            "getAssociatedFormElement": {
                "complexType": {
                    "signature": "() => Promise<HTMLFormElement | null>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        },
                        "HTMLFormElement": {
                            "location": "global",
                            "id": "global::HTMLFormElement"
                        }
                    },
                    "return": "Promise<HTMLFormElement>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }]
                }
            },
            "getNativeInputElement": {
                "complexType": {
                    "signature": "() => Promise<HTMLInputElement>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        },
                        "HTMLInputElement": {
                            "location": "global",
                            "id": "global::HTMLInputElement"
                        }
                    },
                    "return": "Promise<HTMLInputElement>"
                },
                "docs": {
                    "text": "Returns the native input element used in the component.",
                    "tags": []
                }
            },
            "focusInput": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Focuses the input field",
                    "tags": []
                }
            }
        };
    }
    static get elementRef() { return "hostElement"; }
    static get watchers() {
        return [{
                "propName": "selectedIndices",
                "methodName": "watchSelectedIndices"
            }, {
                "propName": "value",
                "methodName": "watchValue"
            }, {
                "propName": "dropdownShow",
                "methodName": "watchDropdownShow"
            }];
    }
    static get listeners() {
        return [{
                "name": "itemClick",
                "method": "onItemClicked",
                "target": undefined,
                "capture": false,
                "passive": false
            }, {
                "name": "ix-select-item:valueChange",
                "method": "onLabelChange",
                "target": undefined,
                "capture": false,
                "passive": false
            }, {
                "name": "ix-select-item:labelChange",
                "method": "onLabelChange",
                "target": undefined,
                "capture": false,
                "passive": false
            }];
    }
    static get attachInternalsMemberName() { return "formInternals"; }
}
__decorate([
    OnListener('keydown', (self) => self.dropdownShow)
], Select.prototype, "onKeyDown", null);
__decorate([
    HookValidationLifecycle()
], Select.prototype, "onValidationChange", null);
//# sourceMappingURL=select.js.map
