var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
        r = Reflect.decorate(decorators, target, key, desc);
    else
        for (var i = decorators.length - 1; i >= 0; i--)
            if (d = decorators[i])
                r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { arrow, autoUpdate, computePosition, flip, hide, offset, shift, } from "@floating-ui/dom";
import { h, Host, } from "@stencil/core";
import { OnListener } from "../utils/listener";
import { tooltipController } from "./tooltip-controller";
import { resolveSelector } from "../utils/find-element";
const numberToPixel = (value) => value != null ? `${value}px` : '';
/**
 * @slot title-icon - Icon of tooltip title
 * @slot title-content - Content of tooltip title
 *
 * @since 1.4.0
 */
export class Tooltip {
    constructor() {
        this.for = undefined;
        this.titleContent = undefined;
        this.interactive = false;
        this.placement = 'top';
        this.showDelay = 0;
        this.hideDelay = 50;
        this.animationFrame = false;
        this.visible = false;
    }
    get arrowElement() {
        return this.hostElement.shadowRoot.querySelector('.arrow');
    }
    destroyAutoUpdate() {
        if (this.disposeAutoUpdate !== undefined) {
            this.disposeAutoUpdate();
        }
    }
    /** @internal */
    async showTooltip(anchorElement) {
        clearTimeout(this.hideTooltipTimeout);
        await this.applyTooltipPosition(anchorElement);
        this.showTooltipTimeout = setTimeout(() => {
            tooltipController.present(this);
            // Need to compute and apply tooltip position after initial render,
            // because arrow has no valid bounding rect before that
            this.applyTooltipPosition(anchorElement);
        }, this.showDelay);
    }
    /** @internal */
    async hideTooltip() {
        clearTimeout(this.showTooltipTimeout);
        let hideDelay = 50;
        if (this.interactive && this.hideDelay === hideDelay) {
            hideDelay = 150;
        }
        this.hideTooltipTimeout = setTimeout(() => {
            tooltipController.dismiss(this);
        }, hideDelay);
        this.destroyAutoUpdate();
    }
    computeArrowPosition({ placement, middlewareData, }) {
        let { x, y } = middlewareData.arrow;
        const resetPosition = {
            top: 'unset',
            right: 'unset',
            bottom: 'unset',
            left: 'unset',
        };
        if (placement.startsWith('top')) {
            return Object.assign(Object.assign({}, resetPosition), { left: numberToPixel(x), top: numberToPixel(y) });
        }
        if (placement.startsWith('right')) {
            return Object.assign(Object.assign({}, resetPosition), { left: numberToPixel(-6), top: numberToPixel(y) });
        }
        if (placement.startsWith('bottom')) {
            return Object.assign(Object.assign({}, resetPosition), { left: numberToPixel(x), top: numberToPixel(-6) });
        }
        if (placement.startsWith('left')) {
            return Object.assign(Object.assign({}, resetPosition), { right: numberToPixel(-6), top: numberToPixel(y) });
        }
    }
    async computeTooltipPosition(target) {
        return computePosition(target, this.hostElement, {
            strategy: 'fixed',
            placement: this.placement,
            middleware: [
                shift(),
                offset(12),
                arrow({
                    element: this.arrowElement,
                }),
                flip({
                    fallbackStrategy: 'initialPlacement',
                    fallbackAxisSideDirection: 'end',
                    padding: 10,
                }),
                hide(),
            ],
        });
    }
    applyTooltipArrowPosition(computeResponse) {
        const arrowPosition = this.computeArrowPosition(computeResponse);
        Object.assign(this.arrowElement.style, arrowPosition);
    }
    async applyTooltipPosition(target) {
        if (!target) {
            return;
        }
        return new Promise((resolve) => {
            this.destroyAutoUpdate();
            this.disposeAutoUpdate = autoUpdate(target, this.hostElement, async () => {
                setTimeout(async () => {
                    var _a;
                    const computeResponse = await this.computeTooltipPosition(target);
                    const isHidden = (_a = computeResponse.middlewareData.hide) === null || _a === void 0 ? void 0 : _a.referenceHidden;
                    if (isHidden) {
                        setTimeout(() => this.hideTooltip());
                        resolve(computeResponse);
                    }
                    if (computeResponse.middlewareData.arrow) {
                        this.applyTooltipArrowPosition(computeResponse);
                    }
                    const { x, y } = computeResponse;
                    Object.assign(this.hostElement.style, {
                        left: x !== null ? `${x}px` : '',
                        top: y !== null ? `${y}px` : '',
                    });
                    resolve(computeResponse);
                });
            }, {
                ancestorResize: true,
                ancestorScroll: true,
                elementResize: true,
                animationFrame: this.animationFrame,
            });
        });
    }
    clearHideTimeout() {
        if (this.interactive) {
            clearTimeout(this.hideTooltipTimeout);
        }
    }
    async queryAnchorElements() {
        if (typeof this.for === 'string') {
            return resolveSelector(this.for, this.hostElement);
        }
        if (this.for instanceof HTMLElement) {
            return Promise.resolve([this.for]);
        }
        if (this.for instanceof Promise) {
            const element = await this.for;
            return [element];
        }
    }
    async registerTriggerListener() {
        const triggerElementList = await this.queryAnchorElements();
        if (this.disposeListener) {
            this.disposeListener();
        }
        if (!triggerElementList) {
            return;
        }
        triggerElementList.forEach((element) => {
            const onMouseEnter = () => {
                this.showTooltip(element);
            };
            const onMouseLeave = () => {
                this.hideTooltip();
            };
            const onFocusIn = () => {
                if (this.showTooltipTimeout !== undefined) {
                    clearTimeout(this.showTooltipTimeout);
                }
                onMouseEnter();
            };
            const onFocusOut = () => {
                this.hideTooltip();
            };
            element.addEventListener('mouseenter', onMouseEnter);
            element.addEventListener('mouseleave', onMouseLeave);
            element.addEventListener('focusin', onFocusIn);
            element.addEventListener('focusout', onFocusOut);
            this.disposeListener = () => {
                element.removeEventListener('mouseenter', onMouseEnter);
                element.removeEventListener('mouseleave', onMouseLeave);
                element.removeEventListener('focusin', onFocusIn);
                element.removeEventListener('focusout', onFocusOut);
            };
        });
    }
    registerTooltipListener() {
        const { hostElement } = this;
        hostElement.addEventListener('mouseenter', () => this.clearHideTimeout());
        hostElement.addEventListener('focusin', () => this.clearHideTimeout());
        hostElement.addEventListener('mouseleave', () => this.hideTooltip());
        hostElement.addEventListener('focusout', () => this.hideTooltip());
    }
    async onKeydown(event) {
        if (event.code === 'Escape') {
            this.hideTooltip();
        }
    }
    componentWillLoad() {
        this.registerTriggerListener();
    }
    componentDidLoad() {
        this.observer = new MutationObserver(() => {
            this.registerTriggerListener();
        });
        this.observer.observe(document.body, {
            attributes: true,
            attributeFilter: ['data-ix-tooltip'],
            childList: true,
            subtree: true,
        });
        this.registerTooltipListener();
    }
    connectedCallback() {
        tooltipController.connected(this);
    }
    disconnectedCallback() {
        var _a;
        (_a = this.observer) === null || _a === void 0 ? void 0 : _a.disconnect();
        this.destroyAutoUpdate();
        tooltipController.disconnected(this);
    }
    isPresent() {
        return this.visible;
    }
    present() {
        this.visible = true;
    }
    dismiss() {
        this.visible = false;
    }
    render() {
        return (h(Host, { key: '1f46e4d330357c6f1d8770cfb407d31cc244aa64', class: {
                visible: this.visible,
            }, role: "tooltip" }, h("div", { key: '7a7896373a839c25a39fe41331223732ed40959d', class: "tooltip-container" }, h("div", { key: 'adb027026f5a668d2dbce4bceacdc1f66b7b7995', class: 'tooltip-title' }, h("slot", { key: '183340b03555b6e170f76c38e952ffa2bcad300f', name: "title-icon" }), h("ix-typography", { key: '14f5f8452aeda63a3acba3b577d2ffc81241200f', format: "h5" }, this.titleContent, h("slot", { key: '613335f4965c9e151f82a2e6b1d3f3635702dc1f', name: "title-content" }))), h("div", { key: 'c36f41b65c2e21b160bc7eee8dbee0c132d7d803', class: 'tooltip-content' }, h("slot", { key: 'f17ab01352090365d03a89d2e1c6a56823c74a5c' })), h("div", { key: '617f5fb5598ebd172591170e5400cab0e1d3f0a3', class: "arrow" }))));
    }
    static get is() { return "ix-tooltip"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["tooltip.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["tooltip.css"]
        };
    }
    static get properties() {
        return {
            "for": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "ElementReference",
                    "resolved": "HTMLElement | Promise<HTMLElement> | string",
                    "references": {
                        "ElementReference": {
                            "location": "import",
                            "path": "src/components",
                            "id": "src/components.d.ts::ElementReference"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "CSS selector for hover trigger element e.g. `for=\"[data-my-custom-select]\"`"
                },
                "attribute": "for",
                "reflect": false
            },
            "titleContent": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Title of the tooltip"
                },
                "attribute": "title-content",
                "reflect": false
            },
            "interactive": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Define if the user can access the tooltip via mouse."
                },
                "attribute": "interactive",
                "reflect": false,
                "defaultValue": "false"
            },
            "placement": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "'top' | 'right' | 'bottom' | 'left'",
                    "resolved": "\"bottom\" | \"left\" | \"right\" | \"top\"",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "1.5.0"
                        }],
                    "text": "Initial placement of the tooltip.\nIf the selected placement doesn't have enough space, the tooltip will be repositioned to another location."
                },
                "attribute": "placement",
                "reflect": false,
                "defaultValue": "'top'"
            },
            "showDelay": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }],
                    "text": ""
                },
                "attribute": "show-delay",
                "reflect": false,
                "defaultValue": "0"
            },
            "hideDelay": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }],
                    "text": ""
                },
                "attribute": "hide-delay",
                "reflect": false,
                "defaultValue": "50"
            },
            "animationFrame": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }],
                    "text": ""
                },
                "attribute": "animation-frame",
                "reflect": false,
                "defaultValue": "false"
            }
        };
    }
    static get states() {
        return {
            "visible": {}
        };
    }
    static get methods() {
        return {
            "showTooltip": {
                "complexType": {
                    "signature": "(anchorElement: Element) => Promise<void>",
                    "parameters": [{
                            "name": "anchorElement",
                            "type": "Element",
                            "docs": ""
                        }],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        },
                        "Element": {
                            "location": "import",
                            "path": "@stencil/core",
                            "id": "../../node_modules/.pnpm/@stencil+core@4.17.2/node_modules/@stencil/core/internal/stencil-core/index.d.ts::Element"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }]
                }
            },
            "hideTooltip": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }]
                }
            }
        };
    }
    static get elementRef() { return "hostElement"; }
}
__decorate([
    OnListener('keydown', (self) => self.visible)
], Tooltip.prototype, "onKeydown", null);
//# sourceMappingURL=tooltip.js.map
