/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
/**
 * @since 2.0.0
 */
export class IxTypography {
    constructor() {
        this.format = undefined;
        this.color = undefined;
        this.textColor = undefined;
        this.bold = false;
        this.textDecoration = 'none';
    }
    render() {
        var _a;
        let typographyClass = {};
        typographyClass[`typography-${(_a = this.format) !== null && _a !== void 0 ? _a : 'body'}`] = true;
        if (this.textDecoration !== 'none') {
            typographyClass[`typography-decoration-${this.textDecoration}`] = true;
        }
        typographyClass['typography-weight-bold'] = this.bold;
        let style = {};
        if (this.color) {
            style = {
                color: `var(--theme-color-${this.color}-text)`,
            };
        }
        if (this.textColor) {
            style = {
                color: `var(--theme-color-${this.textColor}-text)`,
            };
        }
        return (h(Host, { key: '41b607ef68010d1bdcf5c8446138225dee1e64a6', class: typographyClass, style: style }, h("slot", { key: '81adb077808b8625c785c4f0390886dbfc156b27' })));
    }
    static get is() { return "ix-typography"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["typography.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["typography.css"]
        };
    }
    static get properties() {
        return {
            "format": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "TypographyFormat",
                    "resolved": "TypographyFormatLabel | TypographyFormatBody | TypographyFormatDisplay | TypographyFormatHeading | TypographyFormatCode",
                    "references": {
                        "TypographyFormat": {
                            "location": "local",
                            "path": "/home/runner/work/ix/ix/packages/core/src/components/typography/typography.tsx",
                            "id": "src/components/typography/typography.tsx::TypographyFormat"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Text format"
                },
                "attribute": "format",
                "reflect": false
            },
            "color": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "TypographyColors",
                    "resolved": "\"alarm\" | \"contrast\" | \"inv-contrast\" | \"inv-soft\" | \"inv-std\" | \"inv-weak\" | \"soft\" | \"std\" | \"weak\"",
                    "references": {
                        "TypographyColors": {
                            "location": "local",
                            "path": "/home/runner/work/ix/ix/packages/core/src/components/typography/typography.tsx",
                            "id": "src/components/typography/typography.tsx::TypographyColors"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "since 2.1.0 use property `text-color`"
                        }],
                    "text": "Text color based on theme variables"
                },
                "attribute": "color",
                "reflect": false
            },
            "textColor": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "TypographyColors",
                    "resolved": "\"alarm\" | \"contrast\" | \"inv-contrast\" | \"inv-soft\" | \"inv-std\" | \"inv-weak\" | \"soft\" | \"std\" | \"weak\"",
                    "references": {
                        "TypographyColors": {
                            "location": "local",
                            "path": "/home/runner/work/ix/ix/packages/core/src/components/typography/typography.tsx",
                            "id": "src/components/typography/typography.tsx::TypographyColors"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Text color based on theme variables"
                },
                "attribute": "text-color",
                "reflect": false
            },
            "bold": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Display text bold"
                },
                "attribute": "bold",
                "reflect": false,
                "defaultValue": "false"
            },
            "textDecoration": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "TextDecoration",
                    "resolved": "\"line-through\" | \"none\" | \"underline\"",
                    "references": {
                        "TextDecoration": {
                            "location": "local",
                            "path": "/home/runner/work/ix/ix/packages/core/src/components/typography/typography.tsx",
                            "id": "src/components/typography/typography.tsx::TextDecoration"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Text decoration"
                },
                "attribute": "text-decoration",
                "reflect": false,
                "defaultValue": "'none'"
            }
        };
    }
}
//# sourceMappingURL=typography.js.map
