/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { expect } from "@playwright/test";
import { regressionTest } from "../utils/test/index";
async function changeState(page, state) {
    return page.evaluate(([state]) => {
        const elements = document.querySelectorAll('[data-field], ix-radio, ix-checkbox');
        Array.from(elements).forEach((element) => element.classList.add(`ix-${state}`));
    }, [state]);
}
async function changeToReadonly(page) {
    return page.evaluate(() => {
        const elements = document.querySelectorAll('[data-field], ix-radio, ix-checkbox');
        Array.from(elements).forEach((element) => {
            element.readOnly = true;
            element.setAttribute('readonly', '');
        });
    });
}
async function changeToDisabled(page) {
    return page.evaluate(() => {
        const elements = document.querySelectorAll('[data-field], ix-radio, ix-checkbox');
        Array.from(elements).forEach((element) => {
            element.disabled = true;
        });
    });
}
regressionTest.describe('form-fields', () => {
    regressionTest('basic', async ({ page }) => {
        await page.goto('form-fields/basic');
        expect(await page.screenshot()).toMatchSnapshot();
    });
    ['info', 'warning', 'valid', 'invalid'].forEach((state) => regressionTest(`state ${state}`, async ({ page }) => {
        await page.goto('form-fields/basic');
        await changeState(page, state);
        expect(await page.screenshot()).toMatchSnapshot();
    }));
    ['info', 'warning', 'valid', 'invalid'].forEach((state) => regressionTest(`state ${state} with readonly`, async ({ page }) => {
        await page.goto('form-fields/basic');
        await changeToReadonly(page);
        await changeState(page, state);
        expect(await page.screenshot()).toMatchSnapshot();
    }));
    ['info', 'warning', 'valid', 'invalid'].forEach((state) => regressionTest(`state ${state} with disabled`, async ({ page }) => {
        await page.goto('form-fields/basic');
        await changeToDisabled(page);
        await changeState(page, state);
        expect(await page.screenshot()).toMatchSnapshot();
    }));
});
//# sourceMappingURL=form-fields.e2e.js.map
