/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
export * from './page';
export const viewPorts = {
    sm: {
        height: 800,
        width: 360,
    },
    md: {
        height: 768,
        width: 1024,
    },
    lg: {
        height: 1080,
        width: 1920,
    },
};
export const preventFormSubmission = async (formLocator) => {
    return formLocator.evaluate((form) => form.addEventListener('submit', (submitEvent) => {
        submitEvent.preventDefault();
    }));
};
export const getFormValue = async (formLocator, key, page) => {
    await page.waitForTimeout(100);
    return formLocator.evaluate((form, key) => {
        const formData = new FormData(form);
        return formData.get(key);
    }, key);
};
//# sourceMappingURL=index.js.map
