export { I as InputState, L as LogicalFilterOperator } from './logical-filter-operator-d793d1c3.js';
export { F as FlipTileState } from './flip-tile-state-76dd224a.js';
export { r as renderDefaultItem } from './default-tree-item-25091766.js';
export { U as UploadFileState } from './upload-file-state-de676cd5.js';
import { g as getCoreDelegate } from './modal-101eef04.js';
export { c as closeModal, d as dismissModal, g as getCoreDelegate, r as registerFrameworkDelegate, a as resolveDelegate, s as showMessage, b as showModal } from './modal-101eef04.js';
import { A as Animation } from './animation-4a73b1c3.js';
export { T as TypedEvent } from './typed-event-ad6484c5.js';
export { c as convertToAbbreviationString, a as convertToRemString } from './rwd.util-d8e00a88.js';
export { g as getCurrentSystemAppearance, t as themeSwitcher } from './theme-switcher-5fcf712d.js';
export { h as handlePlatformHelpers } from './setup-d88021f8.js';
import './index-97874de0.js';

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
class FilterState {
}

function getToastContainer() {
    const containerList = Array.from(document.querySelectorAll('ix-toast-container'));
    const [container] = containerList;
    if (containerList.length > 1) {
        console.warn('Multiple toast containers were found. Only the first one will be used.');
        return container;
    }
    if (!container) {
        const toastContainer = document.createElement('ix-toast-container');
        document.body.appendChild(toastContainer);
        return toastContainer;
    }
    return container;
}
function setToastPosition(position) {
    const container = getToastContainer();
    container.position = position;
}
function toast(config) {
    const container = getToastContainer();
    return container.showToast(config);
}
toast.info = (config) => {
    return toast(Object.assign(Object.assign({}, config), { type: 'info' }));
};
toast.error = (config) => {
    return toast(Object.assign(Object.assign({}, config), { type: 'error' }));
};
toast.success = (config) => {
    return toast(Object.assign(Object.assign({}, config), { type: 'success' }));
};
toast.warning = (config) => {
    return toast(Object.assign(Object.assign({}, config), { type: 'warning' }));
};

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
function showModalLoading(message) {
    const modal = document.createElement('ix-modal');
    modal.keyboard = false;
    const loading = document.createElement('ix-modal-loading');
    loading.innerText = message;
    modal.appendChild(loading);
    getCoreDelegate().attachView(modal);
    modal.showModal();
    return {
        update: (text) => (loading.innerHTML = text),
        finish: (text, timeout = 250) => {
            if (text !== undefined) {
                loading.innerText = text;
            }
            else {
                timeout = 0;
            }
            setTimeout(() => {
                modal.closeModal(null);
                setTimeout(async () => await getCoreDelegate().removeView(modal), Animation.mediumTime);
            }, timeout);
        },
    };
}

/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
async function applyPolyfills() {
    /**
     * Placeholder to not break existing applications
     * https://github.com/ionic-team/stencil/issues/5780
     */
}

export { FilterState, applyPolyfills, getToastContainer, setToastPosition, showModalLoading, toast };

//# sourceMappingURL=index.js.map