import { r as registerInstance, c as createEvent, h, F as Fragment, H as Host, g as getElement } from './index-97874de0.js';
import { D as DateTime_1 } from './luxon-aa110584.js';
import { m as makeRef } from './make-ref-4b76e9b5.js';

const dateDropdownCss = ":host{display:inline-block;position:relative}:host *,:host *::after,:host *::before{box-sizing:border-box}:host ::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){:host *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}:host ::-webkit-scrollbar{width:0.5rem;height:0.5rem}:host ::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}:host ::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}:host ::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}:host ::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}:host ::-webkit-scrollbar-corner{display:none}@media (max-width: 48em){:host .min-width{width:-moz-min-content;width:min-content}}@media (min-width: 48em){:host .border-right{border-right:var(--theme-x-weak-bdr-2)}}:host ix-button{width:100%}:host .max-height{max-height:-moz-max-content;max-height:max-content}:host .no-margin{margin:0;padding:0}:host .pull-right{float:right;padding:0 1rem 0.75rem 1rem}";
const IxDateDropdownStyle0 = dateDropdownCss;

const DateDropdown = class {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.dateRangeChange = createEvent(this, "dateRangeChange", 7);
        this.triggerRef = makeRef();
        this.datePickerTouched = false;
        this.disabled = false;
        this.format = 'yyyy/LL/dd';
        this.range = true;
        this.from = '';
        this.to = '';
        this.minDate = '';
        this.maxDate = '';
        this.dateRangeId = 'custom';
        this.customRangeAllowed = true;
        this.dateRangeOptions = [];
        this.locale = undefined;
        this.weekStartIndex = 0;
        this.i18nCustomItem = 'Custom...';
        this.i18nDone = 'Done';
        this.i18nNoRange = 'No range set';
        this.today = DateTime_1.now().toISO();
        this.selectedDateRangeId = undefined;
        this.currentRangeValue = undefined;
    }
    onDateRangeIdChange() {
        this.onRangeListSelect(this.dateRangeId);
        this.updateCurrentDate();
        this.setDateRangeSelection(this.dateRangeId);
        if (!this.currentRangeValue) {
            return;
        }
        this.onDateSelect({
            from: this.currentRangeValue.from,
            to: this.currentRangeValue.to,
            id: this.currentRangeValue.id,
        });
    }
    onDateRangeOptionsChange() {
        this.initialize();
        this.onDateRangeIdChange();
    }
    onDisabledChange() {
        if (this.disabled) {
            this.closeDropdown();
        }
    }
    componentWillLoad() {
        this.initialize();
        this.setDateRangeSelection(this.dateRangeId);
    }
    /**
     * Retrieves the currently selected date range from the component.
     * This method returns the selected date range as a `DateChangeEvent` object.
     */
    async getDateRange() {
        return this.currentRangeValue || { id: '', from: '', to: '' };
    }
    initialize() {
        const isCustomRange = this.dateRangeId === 'custom' ||
            (!this.dateRangeId && !!this.from && !!this.to);
        if (isCustomRange && this.customRangeAllowed) {
            this.selectedDateRangeId = 'custom';
            this.updateCurrentDate();
            return;
        }
        const isValidConfiguration = !isCustomRange && !this.from;
        if (!isValidConfiguration) {
            console.warn('"from" and "range-date-id" is provided this is an invalid combination. Using "custom".');
            this.selectedDateRangeId = 'custom';
            this.updateCurrentDate();
            return;
        }
    }
    updateCurrentDate() {
        this.currentRangeValue = {
            id: this.selectedDateRangeId,
            from: this.from,
            to: this.to,
        };
    }
    onDateSelect(rangeValue, preserveDropdown = true) {
        this.dateRangeChange.emit(rangeValue);
        if (preserveDropdown) {
            this.closeDropdown();
        }
        this.datePickerTouched = false;
    }
    onRangeListSelect(id) {
        if (this.setDateRangeSelection(id) && this.currentRangeValue) {
            this.onDateSelect(this.currentRangeValue);
        }
    }
    setDateRangeSelection(id) {
        this.selectedDateRangeId = id;
        const option = this.dateRangeOptions.find((range) => range.id === id);
        if (option) {
            this.currentRangeValue = option;
        }
        return option;
    }
    closeDropdown() {
        const dropdown = this.hostElement.shadowRoot.querySelector('ix-dropdown');
        if (dropdown) {
            dropdown.show = false;
        }
    }
    getButtonLabel() {
        var _a, _b;
        if (this.selectedDateRangeId === 'custom' && ((_a = this.currentRangeValue) === null || _a === void 0 ? void 0 : _a.from)) {
            let range = this.currentRangeValue.from;
            if (this.currentRangeValue.to) {
                range += ` - ${this.currentRangeValue.to}`;
            }
            return range;
        }
        if (!this.selectedDateRangeId) {
            return this.i18nNoRange;
        }
        if (!this.dateRangeOptions || ((_b = this.dateRangeOptions) === null || _b === void 0 ? void 0 : _b.length) === 0) {
            return this.i18nNoRange;
        }
        const option = this.dateRangeOptions.find((option) => option.id === this.selectedDateRangeId);
        if (!option) {
            console.error(`Cannot find range option with id ${this.selectedDateRangeId}`);
            return this.i18nNoRange;
        }
        return option.label;
    }
    render() {
        var _a, _b, _c;
        return (h(Host, { key: '2d701ae652e6a2d69bc662cd9e18edff90f72edd' }, h("ix-button", { key: 'e5b0982166e57ef0beb50dcbc1980ccc35a0c450', "data-testid": "date-dropdown-trigger", "data-date-dropdown-trigger": true, variant: "primary", icon: "history", ref: this.triggerRef, disabled: this.disabled }, this.getButtonLabel()), h("ix-dropdown", { key: '8557bc89aaf87e603fe776c261a9292e0efed772', "data-testid": "date-dropdown", "data-date-dropdown": true, class: "min-width max-height", trigger: this.triggerRef.waitForCurrent(), closeBehavior: "outside", placement: "bottom-start", onShowChanged: ({ detail: show }) => {
                if (!show &&
                    this.selectedDateRangeId === 'custom' &&
                    this.datePickerTouched &&
                    this.currentRangeValue) {
                    this.onDateSelect(this.currentRangeValue);
                }
            } }, h("ix-layout-grid", { key: 'dd9eb5b7f91bd61ec735e52f00ded59e02f5493d', "no-margin": "true" }, h("ix-row", { key: 'ab39a5e672e4fdf432651c0c51bb703a3bb2b05a' }, ((_a = this.dateRangeOptions) === null || _a === void 0 ? void 0 : _a.length) > 1 && (h("ix-col", { key: '9414368bad83465b5fa64837f0571c0995649d63', class: {
                'no-margin': true,
                'border-right': this.selectedDateRangeId === 'custom',
            } }, this.dateRangeOptions.map((dateRangeOption) => (h("ix-dropdown-item", { label: dateRangeOption.label, onClick: () => this.onRangeListSelect(dateRangeOption.id), checked: this.selectedDateRangeId === dateRangeOption.id }))), h("div", { key: 'd35bd95d8fb119e56adfb52c57878c0561ef42db', hidden: !this.customRangeAllowed }, h("ix-dropdown-item", { key: 'df5fc3f68fcbfb612d66fe96d26efab3ff0ef268', label: this.i18nCustomItem, checked: this.selectedDateRangeId === 'custom', onClick: () => this.onRangeListSelect('custom') })))), h("ix-col", { key: '7a2652405ac4bc9d7d4b27e53d451b307dcbfbd2', class: "no-margin" }, this.selectedDateRangeId === 'custom' && (h(Fragment, { key: '474c990aa37777ae4f13b9e3ee9a7646741c97a2' }, h("ix-date-picker", { key: 'd02653d8ee654f2d2d65bcfb35c6b69977b7cda2', standaloneAppearance: false, locale: this.locale, onDateChange: (e) => {
                e.stopPropagation();
                this.currentRangeValue = Object.assign(Object.assign({}, e.detail), { id: 'custom' });
                this.datePickerTouched = true;
            }, onDateRangeChange: (e) => e.stopPropagation(), format: this.format, range: this.range, from: this.from || ((_b = this.currentRangeValue) === null || _b === void 0 ? void 0 : _b.from), to: this.to || ((_c = this.currentRangeValue) === null || _c === void 0 ? void 0 : _c.to), minDate: this.minDate, maxDate: this.maxDate, today: this.today, weekStartIndex: this.weekStartIndex }), h("div", { key: 'a9e297c52708e1d4ff682579c98909fb79adab31', class: "pull-right" }, h("ix-button", { key: '657fe51f463e6ff9b622f227ced97f3f0ec8da31', onClick: () => {
                if (this.currentRangeValue) {
                    this.onDateSelect(this.currentRangeValue);
                }
            } }, this.i18nDone))))))))));
    }
    get hostElement() { return getElement(this); }
    static get watchers() { return {
        "dateRangeId": ["onDateRangeIdChange"],
        "to": ["onDateRangeIdChange"],
        "from": ["onDateRangeIdChange"],
        "dateRangeOptions": ["onDateRangeOptionsChange"],
        "disabled": ["onDisabledChange"]
    }; }
};
DateDropdown.style = IxDateDropdownStyle0;

export { DateDropdown as ix_date_dropdown };

//# sourceMappingURL=ix-date-dropdown.entry.js.map