import { a as setPlatformHelpers } from './index-97874de0.js';

/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
async function setupIcons() {
    if (typeof window === 'undefined') {
        return;
    }
    const iconComponent = window.customElements.get('ix-icon');
    if (iconComponent) {
        return;
    }
    console.warn('ix-icon web component not loaded. Using local fallback version');
    const ixIcons = await import('./index.es2017-93ac816c.js').then(function (n) { return n.i; });
    await ixIcons.defineCustomElements();
}
function handlePlatformHelpers(config) {
    const platformHelpers = {};
    if (config.ael) {
        platformHelpers.ael = config.ael;
    }
    if (config.rel) {
        platformHelpers.rel = config.rel;
    }
    if (config.ce) {
        platformHelpers.ce = config.ce;
    }
    setPlatformHelpers(platformHelpers);
}
async function appGlobalScript (config) {
    await setupIcons();
    handlePlatformHelpers(config || {});
}

export { appGlobalScript as a, handlePlatformHelpers as h };

//# sourceMappingURL=setup-d88021f8.js.map