import { EventEmitter } from '../../stencil-public-runtime';
import { ApplicationLayoutContext } from '../utils/application-layout/context';
import { Breakpoint } from '../utils/breakpoints';
import { ContextType } from '../utils/context';
/**
 * @slot logo - Location of the logo
 */
export declare class ApplicationHeader {
    hostElement: HTMLIxApplicationHeaderElement;
    /**
     * Application name
     */
    name?: string;
    /**
     * Controls the visibility of the menu toggle button based on the context of the application header.
     *
     * When the application header is utilized outside the application frame, the menu toggle button is displayed.
     * Conversely, if the header is within the application frame, this property is ineffective.
     *
     * @since 2.5.0
     */
    showMenu?: boolean;
    /**
     * Event emitted when the menu toggle button is clicked
     *
     * @since 2.5.0
     */
    menuToggle: EventEmitter<boolean>;
    breakpoint: Breakpoint;
    menuExpanded: boolean;
    suppressResponsive: boolean;
    hasSlottedElements: boolean;
    private menuDisposable?;
    private modeDisposable?;
    private callbackUpdateAppSwitchModal?;
    applicationLayoutContext: ContextType<typeof ApplicationLayoutContext>;
    get contentBackground(): Element;
    componentWillLoad(): void;
    componentDidLoad(): void;
    disconnectedCallback(): void;
    watchApplicationLayoutContext(): void;
    watchSuppressResponsive(): void;
    private isLogoSlotted;
    private attachSiemensLogoIfLoaded;
    private onMenuClick;
    private resolveContextMenuButton;
    private tryUpdateAppSwitch;
    private showAppSwitch;
    private updateIsSlottedContent;
    private onContentBgClick;
    render(): any;
}
