import { FieldWrapperInterface, IxFormValidationState, ValidationResults } from '../utils/input';
import { IxComponent } from '../utils/internal';
/**
 * @since 2.6.0
 * @form-ready 2.6.0
 */
export declare class CheckboxGroup implements FieldWrapperInterface, IxFormValidationState, IxComponent {
    hostElement: HTMLIxCheckboxGroupElement;
    /**
     * Optional helper text displayed below the checkbox group
     */
    helperText?: string;
    /**
     * Label for the checkbox group
     */
    label?: string;
    /**
     * Alignment of the checkboxes in the group
     */
    direction: 'row' | 'column';
    /**
     * Error text for the checkbox group
     */
    invalidText?: string;
    /**
     * Info text for the checkbox group
     */
    infoText?: string;
    /**
     * Valid text for the checkbox group
     */
    validText?: string;
    /**
     * Warning text for the checkbox group
     */
    warningText?: string;
    /**
     * Show helper, info, warning, error and valid text as tooltip
     */
    showTextAsTooltip: boolean;
    isInvalid: boolean;
    isInfo: boolean;
    isValid: boolean;
    isWarning: boolean;
    onClassFieldUpdate({ isInvalid, isInvalidByRequired, isInfo, isValid, isWarning, }: ValidationResults): void;
    render(): any;
}
