import { EventEmitter } from '../../stencil-public-runtime';
import { IxFormComponent } from '../utils/input';
/**
 * @since 2.6.0
 * @form-ready 2.6.0
 */
export declare class Checkbox implements IxFormComponent<string> {
    hostElement: HTMLIxCheckboxElement;
    formInternals: ElementInternals;
    /**
     * Name of the checkbox component
     */
    name?: string;
    /**
     * Value of the checkbox component
     */
    value: string;
    /**
     * Label for the checkbox component
     */
    label?: string;
    /**
     * Checked state of the checkbox component
     */
    checked: boolean;
    /**
     * Disabled state of the checkbox component
     */
    disabled: boolean;
    /**
     * Indeterminate state of the checkbox component
     */
    indeterminate: boolean;
    /**
     * Required state of the checkbox component.
     *
     * If true, checkbox needs to be checked to be valid
     */
    required: boolean;
    /**
     * Event emitted when the checked state of the checkbox changes
     */
    checkedChange: EventEmitter<boolean>;
    /**
     * Event emitted when the value of the checkbox changes
     */
    valueChange: EventEmitter<string>;
    private readonly inputRef;
    private setCheckedState;
    onCheckedChange(): void;
    onValueChange(): void;
    componentWillLoad(): void;
    updateFormInternalValue(): void;
    /** @internal */
    hasValidValue(): Promise<boolean>;
    /** @internal */
    getAssociatedFormElement(): Promise<HTMLFormElement | null>;
    updateClassMappings(): void;
    private renderCheckmark;
    render(): any;
}
