import { FieldWrapperInterface, IxFormValidationState, ValidationResults } from '../utils/input';
import { IxComponent } from '../utils/internal';
/**
 * @since 2.6.0
 */
export declare class CustomField implements FieldWrapperInterface, IxFormValidationState, IxComponent {
    hostElement: HTMLIxCustomFieldElement;
    /**
     * A value is required or must be checked for the form to be submittable
     */
    required: boolean;
    /**
     * Label for the field component
     */
    label?: string;
    /**
     * Show text below the field component which show additional information
     */
    helperText?: string;
    /**
     * Info text for the field component
     */
    infoText?: string;
    /**
     * Warning text for the field component
     */
    warningText?: string;
    /**
     * Error text for the field component
     */
    invalidText?: string;
    /**
     * Valid text for the field component
     */
    validText?: string;
    /**
     * Show helper, info, warning, error and valid text as tooltip
     */
    showTextAsTooltip?: boolean;
    isInvalid: boolean;
    isValid: boolean;
    isInfo: boolean;
    isWarning: boolean;
    updateValidationState({ isInvalid, isValid, isInfo, isWarning, }: ValidationResults): void;
    render(): any;
}
