import { EventEmitter } from '../../stencil-public-runtime';
import { IxInputFieldComponent, ValidationResults } from '../utils/input';
export type DateInputValidityState = {
    patternMismatch: boolean;
    invalidReason?: string;
};
/**
 * @since 2.6.0
 * @form-ready 2.6.0
 */
export declare class DateInput implements IxInputFieldComponent<string> {
    hostElement: HTMLIxDateInputElement;
    formInternals: ElementInternals;
    /**
     * name of the input element
     */
    name?: string;
    /**
     * placeholder of the input element
     */
    placeholder?: string;
    /**
     * value of the input element
     */
    value: string;
    /**
     * Locale identifier (e.g. 'en' or 'de').
     *
     * @since 2.6.0
     */
    locale?: string;
    /**
     * Date format string.
     * See {@link "https://moment.github.io/luxon/#/formatting?id=table-of-tokens"} for all available tokens.
     */
    format: string;
    /**
     * required attribute
     */
    required?: boolean;
    /**
     * helper text below the input field
     */
    helperText?: string;
    /**
     * label of the input field
     */
    label?: string;
    /**
     * error text below the input field
     */
    invalidText?: string;
    /**
     * readonly attribute
     */
    readonly: boolean;
    /**
     * disabled attribute
     */
    disabled: boolean;
    /**
     * info text below the input field
     */
    infoText?: string;
    /**
     * warning text below the input field
     */
    warningText?: string;
    /**
     * valid text below the input field
     */
    validText?: string;
    /**
     * show text as tooltip
     */
    showTextAsTooltip?: boolean;
    /**
     * i18n string for the error message when the date is not parsable
     */
    i18nErrorDateUnparsable: string;
    /**
     * Input change event.
     */
    valueChange: EventEmitter<string>;
    /**
     * Validation state change event.
     */
    validityStateChange: EventEmitter<DateInputValidityState>;
    /** @internal */
    ixFocus: EventEmitter<void>;
    /** @internal */
    ixBlur: EventEmitter<void>;
    show: boolean;
    from: string | null;
    isInputInvalid: boolean;
    isInvalid: boolean;
    isValid: boolean;
    isInfo: boolean;
    isWarning: boolean;
    focus: boolean;
    private readonly slotStartRef;
    private readonly slotEndRef;
    private readonly datepickerRef;
    private readonly inputElementRef;
    private readonly dropdownElementRef;
    private classObserver?;
    private invalidReason?;
    updateFormInternalValue(value: string): void;
    connectedCallback(): void;
    componentWillLoad(): void;
    componentDidRender(): void;
    private updatePaddings;
    disconnectedCallback(): void;
    watchValue(): void;
    /** @internal */
    hasValidValue(): Promise<boolean>;
    /** @internal */
    getAssociatedFormElement(): Promise<HTMLFormElement | null>;
    onInput(value: string): Promise<void>;
    onCalenderClick(event: Event): void;
    openDropdown(): Promise<void>;
    closeDropdown(): Promise<void>;
    private checkClassList;
    private renderInput;
    hookValidationLifecycle({ isInfo, isInvalid, isInvalidByRequired, isValid, isWarning, }: ValidationResults): void;
    onInputValidationChange(): Promise<void>;
    /** @internal */
    getValidityState(): Promise<ValidityState>;
    /**
     * Get the native input element
     */
    getNativeInputElement(): Promise<HTMLInputElement>;
    /**
     * Focuses the input field
     */
    focusInput(): Promise<void>;
    render(): any;
}
