import { IxComponent } from '../utils/internal';
import { MakeRef } from '../utils/make-ref';
export declare class FormFieldLabel implements IxComponent {
    hostElement: HTMLIxFieldLabelElement;
    /**
     * A value is required or must be checked for the form to be submittable
     */
    required?: boolean;
    /**
     * The id of the form element that the label is associated with
     */
    htmlFor?: string;
    /** @internal */
    controlRef?: MakeRef<HTMLElement>;
    /** @internal */
    isInvalid: boolean;
    private readonly htmlForObserver;
    private htmlForClassObserver?;
    private controlRefClassObserver?;
    private a11yAttributes;
    private readonly labelRef;
    connectedCallback(): void;
    disconnectedCallback(): void;
    componentWillRender(): void;
    componentWillLoad(): void | Promise<void>;
    private registerHtmlForObserver;
    private registerControlRefObserver;
    private registerHtmlForClassObserver;
    private checkForInvalidState;
    private checkForInternalState;
    private focusOnClick;
    render(): any;
}
