import { FieldWrapperInterface } from '../utils/input';
import { MakeRef } from '../utils/make-ref';
/** @internal */
export declare class FieldWrapper implements FieldWrapperInterface {
    hostElement: HTMLIxFieldWrapperElement;
    /**
     * Show text below the field component
     */
    helperText?: string;
    /**
     * Label for the field component
     */
    label?: string;
    /**
     * Error text for the field component
     */
    invalidText?: string;
    /**
     * Valid text for the field component
     */
    validText?: string;
    /**
     * Info text for the field component
     */
    infoText?: string;
    /**
     * Warning text for the field component
     */
    warningText?: string;
    /**
     * Is the field component invalid
     */
    isInvalid: boolean;
    /**
     * Is the field component valid
     */
    isValid: boolean;
    /**
     * Is the field component info
     */
    isInfo: boolean;
    /**
     * Is the field component warning
     */
    isWarning: boolean;
    /**
     * Show helper, error, info, warning text as tooltip
     */
    showTextAsTooltip: boolean;
    /**
     * Show label as required
     */
    required: boolean;
    /**
     * The id of the form element that the label is associated with
     */
    htmlForLabel?: string;
    /**
     * The control element that the label is associated with
     */
    controlRef?: MakeRef<HTMLElement>;
    private readonly slotRef;
    render(): any;
}
