import { ValidationResults } from '../utils/input';
import { IxComponent } from '../utils/internal';
export declare class HelperText implements IxComponent {
    hostElement: HTMLIxHelperTextElement;
    /**
     * The id of the form element that the label is associated with
     */
    htmlFor?: string;
    /**
     * Show text below the field component
     */
    helperText?: string;
    /**
     * Error text for the field component
     */
    invalidText?: string;
    /**
     * Valid text for the field component
     */
    validText?: string;
    /**
     * Info text for the field component
     */
    infoText?: string;
    /**
     * Warning text for the field component
     */
    warningText?: string;
    validationResults: ValidationResults;
    private readonly observer;
    private classObserver?;
    connectedCallback(): void;
    disconnectedCallback(): void;
    componentWillRender(): void;
    private checkForRequired;
    render(): any;
}
