import { EventEmitter } from '../../stencil-public-runtime';
import { IxInputFieldComponent, ValidationResults } from '../utils/input';
/**
 * @since 2.6.0
 * @form-ready 2.6.0
 */
export declare class Input implements IxInputFieldComponent<string> {
    hostElement: HTMLIxInputElement;
    formInternals: ElementInternals;
    /**
     * The type of the text field. Possible values are 'text', 'email', or 'password'.
     */
    type: 'text' | 'email' | 'password' | 'tel' | 'url';
    /**
     * The name of the text field.
     */
    name?: string;
    /**
     * The placeholder text for the text field.
     */
    placeholder?: string;
    /**
     * The value of the text field.
     */
    value: string;
    /**
     * Specifies whether the text field is required.
     */
    required: boolean;
    /**
     * Specifies whether the text field is disabled.
     */
    disabled: boolean;
    /**
     * Specifies whether the text field is readonly.
     */
    readonly: boolean;
    /**
     * The helper text for the text field.
     */
    helperText?: string;
    /**
     * The info text for the text field.
     */
    infoText?: string;
    /**
     * Specifies whether to show the text as a tooltip.
     */
    showTextAsTooltip?: boolean;
    /**
     * The valid text for the text field.
     */
    validText?: string;
    /**
     * The warning text for the text field.
     */
    warningText?: string;
    /**
     * The label for the text field.
     */
    label?: string;
    /**
     * The error text for the text field.
     */
    invalidText?: string;
    /**
     * The pattern for the text field.
     */
    pattern?: string;
    /**
     * The maximum length of the text field.
     */
    maxLength?: number;
    /**
     * The minimum length of the text field.
     */
    minLength?: number;
    /**
     * The allowed characters pattern for the text field.
     */
    allowedCharactersPattern?: string;
    /**
     * Event emitted when the value of the text field changes.
     */
    valueChange: EventEmitter<string>;
    /**
     * Event emitted when the validity state of the text field changes.
     */
    validityStateChange: EventEmitter<ValidityState>;
    /**
     * Event emitted when the text field loses focus.
     */
    ixBlur: EventEmitter<void>;
    isInvalid: boolean;
    isValid: boolean;
    isInfo: boolean;
    isWarning: boolean;
    isInvalidByRequired: boolean;
    inputType: string;
    private readonly inputRef;
    private readonly slotEndRef;
    private readonly slotStartRef;
    private readonly inputId;
    updateClassMappings(result: ValidationResults): void;
    updateInputType(): void;
    componentWillLoad(): void;
    componentDidRender(): void;
    private updatePaddings;
    updateFormInternalValue(value: string): void;
    /** @internal */
    getAssociatedFormElement(): Promise<HTMLFormElement | null>;
    /** @internal */
    hasValidValue(): Promise<boolean>;
    /**
     * Returns the native input element used in the text field.
     */
    getNativeInputElement(): Promise<HTMLInputElement>;
    /**
     * Focuses the input field
     */
    focusInput(): Promise<void>;
    render(): any;
}
