import { FunctionalComponent } from '../../stencil-public-runtime';
import { MakeRef } from '../utils/make-ref';
import { A11yAttributes } from '../utils/a11y';
export declare function TextareaElement(props: {
    resizeBehavior: 'both' | 'horizontal' | 'vertical' | 'none';
    textareaHeight?: string;
    textareaWidth?: string;
    textareaRows?: number;
    textareaCols?: number;
    disabled: boolean;
    readonly: boolean;
    maxLength?: number;
    minLength?: number;
    isInvalid: boolean;
    required: boolean;
    value: string;
    placeholder?: string;
    textAreaRef: (el: HTMLTextAreaElement | undefined) => void;
    valueChange: (value: string) => void;
    updateFormInternalValue: (value: string) => void;
    onBlur: () => void;
    ariaAttributes?: A11yAttributes;
}): any;
export declare function InputElement(props: {
    id: string;
    disabled: boolean;
    readonly: boolean;
    maxLength?: string | number;
    minLength?: string | number;
    max?: string | number;
    min?: string | number;
    pattern?: string;
    type: string;
    isInvalid: boolean;
    required: boolean;
    value: string | number;
    placeholder?: string;
    inputRef: (el: HTMLInputElement | undefined) => void;
    onKeyPress: (event: KeyboardEvent) => void;
    valueChange: (value: string) => void;
    updateFormInternalValue: (value: string) => void;
    onBlur: () => void;
    ariaAttributes?: A11yAttributes;
}): any;
export declare const SlotEnd: FunctionalComponent<{
    slotEndRef: MakeRef<HTMLDivElement>;
    onSlotChange?: (e: Event) => void;
}>;
export declare const SlotStart: FunctionalComponent<{
    slotStartRef: MakeRef<HTMLDivElement>;
    onSlotChange?: (e: Event) => void;
}>;
