import { A11yAttributes } from '../utils/a11y';
import { IxFormComponent, IxInputFieldComponent, ValidationResults } from '../utils/input';
export declare function createIdIfNotExists(element: IxFormComponent, idPrefix?: string): any;
export declare function mapValidationResult<T>(ref: IxInputFieldComponent<T>, result: ValidationResults): void;
export declare function checkAllowedKeys<T>(comp: IxInputFieldComponent<T>, event: KeyboardEvent): void;
export declare function checkInternalValidity<T>(comp: IxFormComponent<T>, input: HTMLInputElement | HTMLTextAreaElement): Promise<void>;
export declare function onInputBlur<T>(comp: IxInputFieldComponent<T>, input?: HTMLInputElement | HTMLTextAreaElement | null): void;
export declare function applyPaddingEnd(inputElement: HTMLElement | null, width: number, options: {
    slotEnd: boolean;
    additionalPaddingRight?: string;
}): void;
export declare function adjustPaddingForStartAndEnd(startElement: HTMLElement | null, endElement: HTMLElement | null, inputElement: HTMLElement | null): void;
export declare function getAriaAttributesForInput(component: IxInputFieldComponent): A11yAttributes;
