import { EventEmitter } from '../../stencil-public-runtime';
import { IxInputFieldComponent, ValidationResults } from '../utils/input';
/**
 * @since 2.6.0
 * @form-ready 2.6.0
 */
export declare class NumberInput implements IxInputFieldComponent<number> {
    hostElement: HTMLIxNumberInputElement;
    formInternals: ElementInternals;
    /**
     * name of the input element
     */
    name?: string;
    /**
     * placeholder of the input element
     */
    placeholder?: string;
    /**
     * The value of the input field
     */
    value: number;
    /**
     * Indicates if the field is required
     */
    required: boolean;
    /**
     * Disables the input field
     */
    disabled: boolean;
    /**
     * Indicates if the field is read-only
     */
    readonly: boolean;
    /**
     * The helper text for the input field
     */
    helperText?: string;
    /**
     * The info text for the input field
     */
    infoText?: string;
    /**
     * Indicates if the text should be shown as a tooltip
     */
    showTextAsTooltip?: boolean;
    /**
     * The valid text for the input field
     */
    validText?: string;
    /**
     * The warning text for the input field
     */
    warningText?: string;
    /**
     * The label for the input field
     */
    label?: string;
    /**
     * The error text for the input field
     */
    invalidText?: string;
    /**
     * The pattern for the input field
     */
    pattern?: string;
    /**
     * The minimum value for the input field
     */
    min?: string | number;
    /**
     * The maximum value for the input field
     */
    max?: string | number;
    /**
     * The allowed characters pattern for the input field
     */
    allowedCharactersPattern?: string;
    /**
     * Indicates if the stepper buttons should be shown
     */
    showStepperButtons?: boolean;
    /**
     * Event emitted when the value of the input field changes
     */
    valueChange: EventEmitter<number>;
    /**
     * Event emitted when the validity state of the input field changes
     */
    validityStateChange: EventEmitter<ValidityState>;
    /**
     * Event emitted when the input field loses focus
     */
    ixBlur: EventEmitter<void>;
    isInvalid: boolean;
    isValid: boolean;
    isInfo: boolean;
    isWarning: boolean;
    isInvalidByRequired: boolean;
    private readonly inputRef;
    private readonly slotEndRef;
    private readonly slotStartRef;
    private readonly numberInputId;
    updateClassMappings(result: ValidationResults): void;
    componentWillLoad(): void;
    componentDidRender(): void;
    private updatePaddings;
    updateFormInternalValue(value: number): void;
    /** @internal */
    getAssociatedFormElement(): Promise<HTMLFormElement | null>;
    /** @internal */
    hasValidValue(): Promise<boolean>;
    /**
     * Returns the native input element used under the hood
     */
    getNativeInputElement(): Promise<HTMLInputElement>;
    /**
     * Focuses the input field
     */
    focusInput(): Promise<void>;
    render(): any;
}
