import { EventEmitter } from '../../stencil-public-runtime';
import { IxInputFieldComponent, ValidationResults } from '../utils/input';
export type TextareaResizeBehavior = 'both' | 'horizontal' | 'vertical' | 'none';
/**
 * @since 2.6.0
 * @form-ready 2.6.0
 */
export declare class Textarea implements IxInputFieldComponent<string> {
    hostElement: HTMLIxTextareaElement;
    formInternals: ElementInternals;
    /**
     * The name of the textarea field.
     */
    name?: string;
    /**
     * The placeholder text for the textarea field.
     */
    placeholder?: string;
    /**
     * The value of the textarea field.
     */
    value: string;
    /**
     * Determines if the textarea field is required.
     */
    required: boolean;
    /**
     * Determines if the textarea field is disabled.
     */
    disabled: boolean;
    /**
     * Determines if the textarea field is readonly.
     */
    readonly: boolean;
    /**
     * The helper text for the textarea field.
     */
    helperText?: string;
    /**
     * The info text for the textarea field.
     */
    infoText?: string;
    /**
     * Determines if the text should be displayed as a tooltip.
     */
    showTextAsTooltip?: boolean;
    /**
     * The valid text for the textarea field.
     */
    validText?: string;
    /**
     * The warning text for the textarea field.
     */
    warningText?: string;
    /**
     * The label for the textarea field.
     */
    label?: string;
    /**
     * The error text for the textarea field.
     */
    invalidText?: string;
    /**
     * The height of the textarea field (e.g. "52px").
     */
    textareaHeight?: string;
    /**
     * The width of the textarea field (e.g. "200px").
     */
    textareaWidth?: string;
    /**
     * The height of the textarea specified by number of rows.
     */
    textareaRows?: number;
    /**
     * The width of the textarea specified by number of characters.
     */
    textareaCols?: number;
    /**
     * Determines the resize behavior of the textarea field.
     * Resizing can be enabled in one direction, both directions or completely disabled.
     */
    resizeBehavior: TextareaResizeBehavior;
    /**
     * The maximum length of the textarea field.
     */
    maxLength?: number;
    /**
     * The minimum length of the textarea field.
     */
    minLength?: number;
    /**
     * Event emitted when the value of the textarea field changes.
     */
    valueChange: EventEmitter<string>;
    /**
     * Event emitted when the validity state of the textarea field changes.
     */
    validityStateChange: EventEmitter<ValidityState>;
    /**
     * Event emitted when the textarea field loses focus.
     */
    ixBlur: EventEmitter<void>;
    isInvalid: boolean;
    isValid: boolean;
    isInfo: boolean;
    isWarning: boolean;
    isInvalidByRequired: boolean;
    private readonly textAreaRef;
    updateClassMappings(result: ValidationResults): void;
    componentWillLoad(): void;
    updateFormInternalValue(value: string): void;
    /** @internal */
    getAssociatedFormElement(): Promise<HTMLFormElement | null>;
    /** @internal */
    hasValidValue(): Promise<boolean>;
    /**
     * Get the native textarea element.
     */
    getNativeInputElement(): Promise<HTMLTextAreaElement>;
    /**
     * Focuses the input field
     */
    focusInput(): Promise<void>;
    render(): any;
}
