import { EventEmitter } from '../../stencil-public-runtime';
import { ValidationResults, FieldWrapperInterface, IxFormValidationState } from '../utils/input';
/**
 * @since 2.6.0
 * @form-ready 2.6.0
 */
export declare class RadiobuttonGroup implements FieldWrapperInterface, IxFormValidationState {
    hostElement: HTMLIxRadioGroupElement;
    /**
     * Show text below the field component
     */
    helperText?: string;
    /**
     * Label for the field component
     */
    label?: string;
    /**
     * Value of the radiobutton group component
     */
    value?: string;
    /**
     * Error text for the field component
     */
    invalidText?: string;
    /**
     * Info text for the field component
     */
    infoText?: string;
    /**
     * Warning text for the field component
     */
    warningText?: string;
    /**
     * Valid text for the field component
     */
    validText?: string;
    /**
     * Show helper, info, warning, error and valid text as tooltip
     */
    showTextAsTooltip?: boolean;
    /**
     * Alignment of the radio buttons in the group
     */
    direction: 'column' | 'row';
    /**
     * Event emitted when the value of the radiobutton group changes
     */
    valueChange: EventEmitter<string>;
    isInvalid: boolean;
    isValid: boolean;
    isInfo: boolean;
    isWarning: boolean;
    private readonly observer;
    private get radiobuttonElements();
    connectedCallback(): void;
    componentWillLoad(): void | Promise<void>;
    disconnectedCallback(): void;
    private selectInitialValue;
    private ensureOnlyLastRadioChecked;
    onValueChangeHandler(newValue: string): void;
    onCheckedChangeHandler(event: CustomEvent<boolean>): void;
    onClassField({ isInvalid, isInfo, isValid, isWarning }: ValidationResults): void;
    render(): any;
}
