import { EventEmitter } from '../../stencil-public-runtime';
import { IxFormComponent } from '../utils/input';
/**
 * @since 2.6.0
 * @form-ready 2.6.0
 */
export declare class Radio implements IxFormComponent<string> {
    hostElement: HTMLIxRadioElement;
    formInternals: ElementInternals;
    /**
     * Name of the radio component
     */
    name?: string;
    /**
     * Value of the radio component
     */
    value?: string;
    /**
     * Label for the radio component
     */
    label?: string;
    /**
     * Disabled state of the radio component
     */
    disabled: boolean;
    /**
     * Checked state of the radio component
     */
    checked: boolean;
    /**
     * Event emitted when the checked state of the radio changes
     */
    checkedChange: EventEmitter<boolean>;
    /**
     * Event emitted when the value of the radio changes
     */
    valueChange: EventEmitter<string>;
    /**
     * Single radio cannot be required
     * */
    required: boolean;
    private readonly inputRef;
    private setCheckedState;
    onCheckedChange(): Promise<void>;
    onValueChange(): void;
    componentWillLoad(): void;
    updateFormInternalValue(): void;
    /** @internal */
    hasValidValue(): Promise<boolean>;
    /** @internal */
    getAssociatedFormElement(): Promise<HTMLFormElement | null>;
    render(): any;
}
