import { EventEmitter } from '../../stencil-public-runtime';
import { IxSelectItemLabelChangeEvent } from '../select-item/events';
import { DropdownItemWrapper } from '../dropdown/dropdown-controller';
import { ValidationResults, IxInputFieldComponent } from '../utils/input';
/**
 * @form-ready 2.6.0
 */
export declare class Select implements IxInputFieldComponent<string | string[]> {
    hostElement: HTMLIxSelectElement;
    formInternals: ElementInternals;
    /**
     * A string that represents the element's name attribute,
     * containing a name that identifies the element when submitting the form.
     *
     * @since 2.6.0
     */
    name?: string;
    /**
     * A Boolean attribute indicating that an option with a non-empty string value must be selected
     *
     * @since 2.6.0
     */
    required: boolean;
    /**
     * Label for the select component
     *
     * @since 2.6.0
     */
    label?: string;
    /**
     * Warning text for the select component
     *
     * @since 2.6.0
     **/
    warningText?: string;
    /**
     * Info text for the select component
     *
     * @since 2.6.0
     **/
    infoText?: string;
    /**
     * Error text for the select component
     *
     * @since 2.6.0
     **/
    invalidText?: string;
    /**
     * Valid text for the select component
     *
     * @since 2.6.0
     **/
    validText?: string;
    /**
     * Helper text for the select component
     *
     * @since 2.6.0
     **/
    helperText?: string;
    /**
     * Show helper, error, info, warning text as tooltip
     *
     * @since 2.6.0
     */
    showTextAsTooltip?: boolean;
    /**
     * Indices of selected items.
     * This corresponds to the value property of ix-select-items and therefor not necessarily the indices of the items in the list.
     * @deprecated since 2.0.0. Use the `value` property instead.
     */
    selectedIndices?: string | string[];
    /**
     * Current selected value.
     * This corresponds to the value property of ix-select-items
     * @since 2.0.0
     */
    value: string | string[];
    /**
     * Show clear button
     */
    allowClear: boolean;
    /**
     * Selection mode
     */
    mode: 'single' | 'multiple';
    /**
     * Select is extendable
     */
    editable: boolean;
    /**
     * If true the select will be in disabled state
     */
    disabled: boolean;
    /**
     * If true the select will be in readonly mode
     */
    readonly: boolean;
    /**
     * Input field placeholder
     */
    i18nPlaceholder: string;
    /**
     * Input field placeholder for editable select
     */
    i18nPlaceholderEditable: string;
    /**
     * Select list header
     */
    i18nSelectListHeader: string;
    /**
     * Information inside of dropdown if no items where found with current filter text
     *
     * @since 1.5.0
     */
    i18nNoMatches: string;
    /**
     * Hide list header
     *
     * @since 1.5.0
     */
    hideListHeader: boolean;
    /**
     * Value changed
     * @since 2.0.0
     */
    valueChange: EventEmitter<string | string[]>;
    /**
     * Item selection changed
     * @deprecated since 2.0.0. Use `valueChange` instead.
     */
    itemSelectionChange: EventEmitter<string[]>;
    /**
     * Event dispatched whenever the text input changes.
     *
     * @since 2.0.0
     */
    inputChange: EventEmitter<string>;
    /**
     * Item added to selection
     */
    addItem: EventEmitter<string>;
    /**
     * Blur input
     */
    ixBlur: EventEmitter<void>;
    dropdownShow: boolean;
    selectedLabels: string[];
    isDropdownEmpty: boolean;
    navigationItem?: DropdownItemWrapper;
    inputFilterText: string;
    inputValue: string;
    isInvalid: boolean;
    isValid: boolean;
    isInfo: boolean;
    isWarning: boolean;
    private readonly dropdownWrapperRef;
    private readonly dropdownAnchor;
    private inputRef?;
    private dropdownRef?;
    private customItemsContainerRef?;
    private addItemRef?;
    private arrowFocusController?;
    private readonly itemObserver;
    private readonly focusControllerCallbackBind;
    get nonShadowItems(): HTMLIxSelectItemElement[];
    get visibleNonShadowItems(): HTMLIxSelectItemElement[];
    get shadowItems(): HTMLIxSelectItemElement[];
    get visibleShadowItems(): HTMLIxSelectItemElement[];
    get items(): HTMLIxSelectItemElement[];
    get visibleItems(): HTMLIxSelectItemElement[];
    get selectedItems(): HTMLIxSelectItemElement[];
    get addItemButton(): Element;
    get isSingleMode(): boolean;
    get isMultipleMode(): boolean;
    get isEveryDropdownItemHidden(): boolean;
    watchSelectedIndices(value: string | string[]): void;
    watchValue(value: string | string[]): void;
    watchDropdownShow(show: boolean): void;
    private cleanupResources;
    onItemClicked(event: CustomEvent<string>): void;
    updateFormInternalValue(value: string | string[]): Promise<void>;
    /** @internal */
    hasValidValue(): Promise<boolean>;
    private hasValue;
    private focusDropdownItem;
    private itemClick;
    private emitAddItem;
    private toggleValue;
    private updateSelection;
    private emitValueChange;
    componentDidLoad(): void;
    componentWillLoad(): void;
    onLabelChange(event: IxSelectItemLabelChangeEvent): void;
    disconnectedCallback(): void;
    private itemExists;
    private dropdownVisibilityChanged;
    onKeyDown(event: KeyboardEvent): Promise<void>;
    private onEnterNavigation;
    private onArrowNavigation;
    private applyFocusTo;
    private focusAddItemButton;
    private filterItemsWithTypeahead;
    private removeHiddenFromItems;
    private clearInput;
    private clear;
    private onInputBlur;
    private placeholderValue;
    private isAddItemVisible;
    onValidationChange({ isInvalid, isInvalidByRequired, isValid, isInfo, isWarning, }: ValidationResults): void;
    /** @internal */
    getAssociatedFormElement(): Promise<HTMLFormElement | null>;
    /**
     * Returns the native input element used in the component.
     */
    getNativeInputElement(): Promise<HTMLInputElement>;
    /**
     * Focuses the input field
     */
    focusInput(): Promise<void>;
    render(): any;
}
