import { EventEmitter } from '../../stencil-public-runtime';
import { IxFormComponent } from '../utils/input';
/**
 * @form-ready 2.6.0
 * */
export declare class Toggle implements IxFormComponent<string> {
    formInternals: ElementInternals;
    hostElement: HTMLIxToggleElement;
    /**
     * Name of the checkbox component
     */
    name?: string;
    /**
     * Value of the checkbox component
     */
    value: string;
    /**
     * Whether the slide-toggle element is checked or not.
     */
    checked: boolean;
    /**
     * Whether the slide-toggle element is disabled or not.
     */
    disabled: boolean;
    /**
     * If true the control is in indeterminate state
     */
    indeterminate: boolean;
    /**
     * Text for on state
     */
    textOn: string;
    /**
     * Text for off state
     */
    textOff: string;
    /**
     * Text for indeterminate state
     */
    textIndeterminate: string;
    /**
     * Hide `on` and `off` text
     */
    hideText: boolean;
    /**
     * Required state of the checkbox component.
     *
     * If true, checkbox needs to be checked to be valid
     */
    required: boolean;
    /**
     * An event will be dispatched each time the slide-toggle changes its value.
     */
    checkedChange: EventEmitter<boolean>;
    /** @internal */
    valueChange: EventEmitter<string>;
    onCheckedChange(newChecked: boolean): void;
    componentWillLoad(): void;
    updateFormInternalValue(): void;
    watchCheckedChange(): void;
    /** @internal */
    hasValidValue(): Promise<boolean>;
    /** @internal */
    getAssociatedFormElement(): Promise<HTMLFormElement | null>;
    render(): any;
}
