/**
 * Will try to resolve the selector in the light dom, shadow dom or slot
 * @param selector The selector to resolve
 * @param hostElement The element to start the search from
 * @returns Promise with the resolved elements or undefined if not found
 */
export declare function resolveSelector(selector: string, hostElement?: HTMLElement): Promise<HTMLElement[] | undefined>;
/**
 * Walk up the DOM to find the nearest shadow root
 * @param element The element to get the root for
 * @param parent This will determine how far up the DOM to travel to find the root
 * @returns The root element
 */
export declare function getRootFor(element: HTMLElement, parent?: HTMLElement): HTMLElement | ShadowRoot;
export declare function waitForSelector(selector: string, node?: Document, hostElement?: HTMLElement): Promise<Element>;
/**
 * Find an element by ID or reference
 * @param element The element to find
 * @param hostElement The element to start the search from
 * @returns A promise that will resolve to the element
 */
export declare function findElement(element: string | HTMLElement | Promise<HTMLElement>, hostElement?: HTMLElement): Promise<Element>;
