import { EventEmitter } from '../../../stencil-public-runtime';
import { IxComponent } from '../internal';
export * from './validation';
export interface FieldWrapperInterface {
    /**
     * Label for the field component
     */
    label?: string;
    /**
     * Show text below the field component which show additional information
     */
    helperText?: string;
    /**
     * Info text for the field component
     */
    infoText?: string;
    /**
     * Warning text for the field component
     */
    warningText?: string;
    /**
     * Error text for the field component
     */
    invalidText?: string;
    /**
     * Valid text for the field component
     */
    validText?: string;
    /**
     * Show helper, info, warning, error and valid text as tooltip
     */
    showTextAsTooltip?: boolean;
}
export type HTMLIxFormComponentElement<T> = HTMLElement & IxFormComponent<T>;
export type HTMLIxInputFieldComponentElement<T> = HTMLIxFormComponentElement<T> & IxInputFieldComponent<T>;
export interface IxFormValidationState {
    isInvalid: boolean;
    isValid: boolean;
    isInfo: boolean;
    isWarning: boolean;
}
export interface IxFormComponent<T = string> extends IxComponent {
    formInternals: ElementInternals;
    required?: boolean;
    name?: string;
    value?: T;
    disabled: boolean;
    valueChange: EventEmitter<T>;
    updateFormInternalValue(value: T): void;
    hasValidValue(): Promise<boolean>;
    getValidityState?(): Promise<ValidityState>;
    getAssociatedFormElement(): Promise<HTMLFormElement | null>;
}
export interface IxInputFieldComponent<T = string> extends IxFormComponent<T>, IxFormValidationState, FieldWrapperInterface {
    placeholder?: string;
    readonly: boolean;
    ixBlur: EventEmitter<void>;
    getNativeInputElement(): Promise<HTMLInputElement | HTMLTextAreaElement>;
    focusInput(): void;
}
export declare function isIxInputFieldComponent(obj: HTMLElement): obj is HTMLIxInputFieldComponentElement<unknown>;
