import { HTMLIxFormComponentElement, IxFormComponent } from '.';
import { IxComponent } from '../internal';
export type ClassMutationObserver = {
    destroy: () => void;
};
export declare function shouldSuppressInternalValidation<T>(host: IxFormComponent<T>): Promise<boolean>;
export declare function createClassMutationObserver(element: HTMLElement, callback: () => void, options?: {
    includeChildren?: boolean;
}): ClassMutationObserver;
export type ValidationResultProperty = 'isInvalid' | 'isInvalidByRequired' | 'isValid' | 'isInfo' | 'isWarning';
export type ValidationResults = Record<ValidationResultProperty, boolean>;
export declare function checkFieldClasses(hostElement: HTMLIxFormComponentElement<unknown>, includeChildren?: boolean): ValidationResults;
export declare function HookValidationLifecycle(options?: {
    includeChildren?: boolean;
}): (proto: IxComponent, methodName: string) => void;
