# similarity

How similar are these two strings?

## Installation

```sh
npm install similarity --save
```

## Usage

The module exports a single function that compares two strings and returns a value between `0` and `1`. The closer the value is to `1`, the more similar the two string are:

```js
var similarity = require("similarity")

similarity("food", "food") // 1
similarity("food", "fool") // 0.75
similarity("ding", "plow") // 0
similarity("chicken", "chick") // 0.714285714
similarity("es6-shim", "es6 shim") // 0.875
similarity("ES6-Shim", "es6 shim") // 0.875 (case insensitive)
```

## See Also

Note: This module uses [Levenshtein distance](https://en.wikipedia.org/wiki/Levenshtein_distance) to measure similarity, but there are many other algorithms for string comparison. Here are a few:

- [clj-fuzzy](https://github.com/Yomguithereal/clj-fuzzy) - A handy collection of algorithms dealing with fuzzy strings and phonetics.
- [natural](https://github.com/NaturalNode/natural) - general natural language facilities for node.
- [string-similarity](https://github.com/aceakash/string-similarity) - Finds degree of similarity between two strings, based on Dice's Coefficient, which is mostly better than Levenshtein distance.
- [jaro-winkler](https://github.com/jordanthomas/jaro-winkler) - The Jaro-Winkler distance metric for node and browser.

## Tests

```sh
npm install
npm test
```

## Dependencies

- [leven](https://github.com/sindresorhus/leven): Measure the difference between two strings using the fastest JS implementation of the Levenshtein distance algorithm

## Dev Dependencies

- [tap](https://github.com/isaacs/node-tap): A Test-Anything-Protocol library

## License

ISC

_Generated by [package-json-to-readme](https://github.com/zeke/package-json-to-readme)_
