import Comment from './document/comment';
import DocumentFragment from './document/document-fragment';
import Element from './document/element';
import Node from './document/node';
import RawHTMLSection from './document/raw-html-section';
import Text from './document/text';
export default class Document extends Node {
    constructor() {
        super(9 /* DOCUMENT_NODE */, '#document', null);
        this.documentElement = new Element('html');
        this.head = new Element('head');
        this.body = new Element('body');
        this.documentElement.appendChild(this.head);
        this.documentElement.appendChild(this.body);
        this.appendChild(this.documentElement);
    }
    createElement(tagName) {
        return new Element(tagName);
    }
    createTextNode(text) {
        return new Text(text);
    }
    createComment(text) {
        return new Comment(text);
    }
    createRawHTMLSection(text) {
        return new RawHTMLSection(text);
    }
    createDocumentFragment() {
        return new DocumentFragment();
    }
}
//# sourceMappingURL=document.js.map