import Node from './node';
export default class Element extends Node {
    constructor(tagName) {
        super(1 /* ELEMENT_NODE */, tagName.toUpperCase(), null);
        this.attributes = [];
    }
    get tagName() {
        return this.nodeName;
    }
    getAttribute(name) {
        const attributes = this.attributes;
        const n = name.toLowerCase();
        let attr;
        for (let i = 0, l = attributes.length; i < l; i++) {
            attr = attributes[i];
            if (attr.name === n) {
                return attr.value;
            }
        }
        return null;
    }
    setAttribute(name, value) {
        const attributes = this.attributes;
        const n = name.toLowerCase();
        let v;
        if (typeof value === 'string') {
            v = value;
        }
        else {
            v = '' + value;
        }
        let attr;
        for (let i = 0, l = attributes.length; i < l; i++) {
            attr = attributes[i];
            if (attr.name === n) {
                attr.value = v;
                return;
            }
        }
        attributes.push({
            name: n,
            specified: true,
            value: v,
        });
    }
    removeAttribute(name) {
        const n = name.toLowerCase();
        const attributes = this.attributes;
        for (let i = 0, l = attributes.length; i < l; i++) {
            const attr = attributes[i];
            if (attr.name === n) {
                attributes.splice(i, 1);
                return;
            }
        }
    }
    _cloneNode() {
        const node = new Element(this.tagName);
        const attrs = node.attributes = [];
        for (const attr of this.attributes) {
            attrs.push({ name: attr.name, specified: attr.specified, value: attr.value });
        }
        return node;
    }
}
//# sourceMappingURL=element.js.map