export declare const enum NodeType {
    RAW = -1,
    ELEMENT_NODE = 1,
    TEXT_NODE = 3,
    COMMENT_NODE = 8,
    DOCUMENT_NODE = 9,
    DOCUMENT_FRAGMENT_NODE = 11,
}
export interface NodeList {
    item(index: number): Node;
}
export default class Node {
    readonly nodeType: number;
    readonly nodeName: string;
    nodeValue: string | null;
    static ELEMENT_NODE: number;
    static TEXT_NODE: number;
    static COMMENT_NODE: number;
    static DOCUMENT_NODE: number;
    static DOCUMENT_FRAGMENT_NODE: number;
    parentNode: Node | null;
    previousSibling: Node | null;
    nextSibling: Node | null;
    firstChild: Node | null;
    lastChild: Node | null;
    private _childNodes;
    constructor(nodeType: number, nodeName: string, nodeValue: string | null);
    readonly childNodes: NodeList;
    cloneNode(deep?: boolean): Node;
    appendChild<T extends Node>(newChild: T): T;
    insertBefore<T extends Node>(newChild: T, refChild: Node | null): T;
    removeChild<T extends Node>(oldChild: T): T;
    protected _cloneNode(): Node;
}
