export default class HTMLSerializer {
    private voidMap;
    constructor(voidMap: {
        [tagName: string]: boolean;
    });
    openTag(element: Node): string;
    closeTag(element: Node): string;
    isVoid(element: Node): boolean;
    attributes(namedNodeMap: NamedNodeMap): string;
    escapeAttrValue(attrValue: string): string;
    attr(attr: Attr): string;
    escapeText(textNodeValue: string): string;
    text(text: Node): string;
    rawHTMLSection(text: Node): string;
    comment(comment: Node): string;
    serializeChildren(node: Node): string;
    serialize(node: Node): string;
}
