import { Attribute, EntityParser, Token, TokenizerDelegate, TokenMap, TokenType, TokenizerOptions } from './types';
export default class Tokenizer implements TokenizerDelegate {
    private options;
    private token;
    private startLine;
    private startColumn;
    private tokenizer;
    private tokens;
    constructor(entityParser: EntityParser, options?: TokenizerOptions);
    tokenize(input: string): Token[];
    tokenizePart(input: string): Token[];
    tokenizeEOF(): Token;
    reset(): void;
    current<T extends TokenType, U extends TokenType>(type1: T, type2: U): TokenMap[T] | TokenMap[U];
    current<T extends TokenType>(type: T): TokenMap[T];
    current(): Token;
    push(token: Token): void;
    currentAttribute(): [string, string, boolean];
    pushAttribute(attribute: Attribute): void;
    addLocInfo(): void;
    beginData(): void;
    appendToData(char: string): void;
    finishData(): void;
    beginComment(): void;
    appendToCommentData(char: string): void;
    finishComment(): void;
    tagOpen(): void;
    beginStartTag(): void;
    beginEndTag(): void;
    finishTag(): void;
    markTagAsSelfClosing(): void;
    appendToTagName(char: string): void;
    beginAttribute(): void;
    appendToAttributeName(char: string): void;
    beginAttributeValue(isQuoted: boolean): void;
    appendToAttributeValue(char: string): void;
    finishAttributeValue(): void;
    reportSyntaxError(message: string): void;
}
