export const siDotnet={title:".NET",slug:"dotnet",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>.NET</title><path d="'+this.path+'"/></svg>'},path:"M24 8.77h-2.468v7.565h-1.425V8.77h-2.462V7.53H24zm-6.852 7.565h-4.821V7.53h4.63v1.24h-3.205v2.494h2.953v1.234h-2.953v2.604h3.396zm-6.708 0H8.882L4.78 9.863a2.896 2.896 0 0 1-.258-.51h-.036c.032.189.048.592.048 1.21v5.772H3.157V7.53h1.659l3.965 6.32c.167.261.275.442.323.54h.024c-.04-.233-.06-.629-.06-1.185V7.529h1.372zm-8.703-.693a.868.829 0 0 1-.869.829.868.829 0 0 1-.868-.83.868.829 0 0 1 .868-.828.868.829 0 0 1 .869.829Z",source:"https://github.com/dotnet/brand/",hex:"512BD4",guidelines:void 0,license:void 0},siE={title:"/e/",slug:"e",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>/e/</title><path d="'+this.path+'"/></svg>'},path:"M13.13812.05332C9.6246-.2791 6.0635.95029 3.49234 3.53409.0641 6.97916-.94746 12.17083.93662 16.65094c1.88408 4.48013 6.30246 7.38884 11.16248 7.3483a2.27493 2.27493 0 10-.03759-4.54888c-3.02833.02526-5.75722-1.77058-6.93123-4.56223-1.174-2.79164-.54918-5.99816 1.58702-8.14484 2.13619-2.14669 5.339-2.78735 8.13635-1.62703 2.07161.85929 3.59079 2.57925 4.24094 4.64104H12.0506a2.27505 2.27505 0 100 4.5501h9.67488a2.27493 2.27493 0 002.27445-2.26717c.0167-4.86014-2.91357-9.264-7.40286-11.12612-1.12232-.46552-2.28778-.74998-3.45895-.8608Z",source:"https://gitlab.e.foundation/e/cloud/my-spot/-/blob/4e5430a17ba4ce77d4cb188222e47924f032b197/searx/static/themes/eelo/img/logo.svg",hex:"000000",guidelines:void 0,license:void 0},si1password={title:"1Password",slug:"1password",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>1Password</title><path d="'+this.path+'"/></svg>'},path:"M10.51,10.013V7.299c0-0.306,0.248-0.554,0.554-0.554h1.911c0.306,0,0.554,0.248,0.554,0.554v4.968 c0,0.076-0.038,0.134-0.076,0.191l-0.478,0.478c-0.115,0.115-0.115,0.287,0,0.382l0.478,0.478c0.057,0.057,0.076,0.115,0.076,0.191 v2.713c0,0.306-0.248,0.554-0.554,0.554h-1.911c-0.306,0-0.554-0.248-0.554-0.554v-4.968c0-0.076,0.038-0.134,0.076-0.191 l0.478-0.478c0.115-0.115,0.115-0.287,0-0.382l-0.478-0.478C10.529,10.146,10.51,10.089,10.51,10.013z M19.127,12 c0-3.936-3.191-7.127-7.127-7.127S4.873,8.064,4.873,12S8.064,19.127,12,19.127S19.127,15.936,19.127,12z M21.382,12 c0,5.178-4.204,9.363-9.363,9.363c-5.178,0-9.363-4.204-9.363-9.363c0-5.178,4.204-9.363,9.363-9.363 C17.178,2.637,21.382,6.822,21.382,12z M0.764,12c0,6.21,5.025,11.236,11.236,11.236S23.236,18.21,23.236,12S18.21,0.764,12,0.764 S0.764,5.79,0.764,12z M0,12C0,5.369,5.369,0,12,0c6.631,0,12,5.369,12,12s-5.369,12-12,12S0,18.631,0,12z",source:"https://1password.com/press/",hex:"0094F5",guidelines:void 0,license:void 0},si1001tracklists={title:"1001Tracklists",slug:"1001tracklists",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>1001Tracklists</title><path d="'+this.path+'"/></svg>'},path:"M9.422 10.723h-1.35v3.807h2.458v-4.048h2.94v4.337h-1.35v1.35h-1.349v2.458h2.458v-2.7h2.699v-5.204h-1.35v-1.35H9.422zm1.35 11.952h2.457v-2.458H10.77v2.458zm-2.676-20H6.747v1.35h-1.35v1.348H4.049v1.35h-1.35v6.699H1.35v1.35H0v2.457h1.35v1.35h1.349v1.349h2.458v-7.856h-1.35v-4.24h1.35v-1.35h1.349v-1.35h1.35V3.784h8.289v1.35h1.349v1.349h1.35v1.35h1.349v4.24h-1.35v7.856h2.458v-1.35h1.35v-1.35H24v-2.457h-1.35v-1.35h-1.349V6.724h-1.35v-1.35h-1.349V4.024h-1.349v-1.35h-1.35V1.326H8.097v1.35Z",source:"https://www.1001tracklists.com/",hex:"40AEF0",guidelines:void 0,license:void 0},si42={title:"42",slug:"42",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>42</title><path d="'+this.path+'"/></svg>'},path:"M24 12.42l-4.428 4.415H24zm-4.428-4.417l-4.414 4.418v4.414h4.414V12.42L24 8.003V3.575h-4.428zm-4.414 0l4.414-4.428h-4.414zM0 15.996h8.842v4.43h4.412V12.42H4.428l8.826-8.846H8.842L0 12.421z",source:"https://www.42.fr/",hex:"000000",guidelines:void 0,license:void 0},siAframe={title:"A-Frame",slug:"aframe",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>A-Frame</title><path d="'+this.path+'"/></svg>'},path:"M17.37 17.07H6.57L4.24 24H3.01l8.23-24h1.52l8.23 24h-1.3zm-.39-1.13l-5-14.96-5.03 14.98h10.03Z",source:"https://aframe.io/docs/",hex:"EF2D5E",guidelines:void 0,license:void 0},si4chan={title:"4chan",slug:"4chan",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>4chan</title><path d="'+this.path+'"/></svg>'},path:"M11.07 8.82S9.803 1.079 5.145 1.097C2.006 1.109.78 4.124 3.055 4.802c0 0-2.698.973-2.698 2.697 0 1.725 4.274 3.54 10.713 1.32zm1.931 5.924s.904 7.791 5.558 7.991c3.136.135 4.503-2.82 2.262-3.604 0 0 2.74-.845 2.82-2.567.08-1.723-4.105-3.737-10.64-1.82zm-3.672-1.55s-7.532 2.19-6.952 6.813c.39 3.114 3.53 3.969 3.93 1.63 0 0 1.29 2.559 3.002 2.351 1.712-.208 3-4.67.02-10.794zm5.623-2.467s7.727-1.35 7.66-6.008c-.046-3.138-3.074-4.333-3.728-2.051 0 0-1-2.686-2.726-2.668-1.724.018-3.494 4.312-1.206 10.727z",source:"https://www.4chan.org/",hex:"006600",guidelines:void 0,license:void 0},si4d={title:"4D",slug:"4d",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>4D</title><path d="'+this.path+'"/></svg>'},path:"M20.64 0v24H3.36V0h17.28zM10.49 11.827c-.115.138-5.882 6.789-5.983 6.9-.058.07-.187.194-.187.36 0 .153.187.208.36.208h4.4v-1.067H5.83c.49-.61 3.38-3.824 3.696-4.226v5.34c0 .194-.005.965-.043 1.602-.029.43-.13.637-.661.693-.23.027-.533.041-.662.041-.072 0-.115.083-.115.18 0 .097.072.167.23.167.777 0 1.539-.042 1.942-.042 1.236 0 2.646.097 3.178.097 2.618 0 4.099-.97 4.746-1.607.791-.776 1.539-2.093 1.539-3.81 0-1.622-.662-2.758-1.38-3.465-1.54-1.565-3.913-1.565-5.682-1.565-.56 0-1.035.027-1.064.027-.388.042-.345-.124-.59-.138-.158-.014-.258.055-.474.305zm1.898.443c1.108 0 2.719.166 4.027 1.372.604.554 1.367 1.676 1.367 3.408 0 1.414-.288 2.66-1.194 3.409-.849.706-1.812.984-3.265.984-1.122 0-1.683-.291-1.87-.54-.115-.153-.172-.694-.186-1.04 0-.097-.015-.29-.015-.568h1.021c.245 0 .317-.055.389-.18.1-.18.244-.735.244-.86 0-.11-.057-.166-.13-.166-.086 0-.273.139-.647.139h-.877v-5.584c0-.152.058-.222.173-.277.115-.056.676-.097.963-.097z",source:"https://www.4d.com/",hex:"004088",guidelines:void 0,license:void 0},si500px={title:"500px",slug:"500px",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>500px</title><path d="'+this.path+'"/></svg>'},path:"M7.433 9.01A2.994 2.994 0 0 0 4.443 12a2.993 2.993 0 0 0 2.99 2.99 2.994 2.994 0 0 0 2.99-2.99 2.993 2.993 0 0 0-2.99-2.99m0 5.343A2.357 2.357 0 0 1 5.079 12a2.357 2.357 0 0 1 2.354-2.353A2.356 2.356 0 0 1 9.786 12a2.356 2.356 0 0 1-2.353 2.353m6.471-5.343a2.994 2.994 0 0 0-2.99 2.99 2.993 2.993 0 0 0 2.99 2.99 2.994 2.994 0 0 0 2.99-2.99 2.994 2.994 0 0 0-2.99-2.99m0 5.343A2.355 2.355 0 0 1 11.552 12a2.355 2.355 0 0 1 2.352-2.353A2.356 2.356 0 0 1 16.257 12a2.356 2.356 0 0 1-2.353 2.353m-11.61-3.55a2.1 2.1 0 0 0-1.597.423V9.641h2.687c.093 0 .16-.017.16-.292 0-.269-.108-.28-.18-.28H.39c-.174 0-.265.14-.265.294v2.602c0 .136.087.183.247.214.141.028.223.012.285-.057l.006-.01c.283-.408.9-.804 1.486-.732.699.086 1.262.644 1.34 1.327a1.512 1.512 0 0 1-1.5 1.685c-.636 0-1.19-.408-1.422-1.001-.035-.088-.092-.152-.343-.062-.229.083-.243.18-.212.268a2.11 2.11 0 0 0 1.976 1.386 2.102 2.102 0 0 0 .305-4.18M18.938 9.04c-.805.062-1.434.77-1.434 1.61v2.66c0 .155.117.187.293.187s.293-.031.293-.186v-2.668c0-.524.382-.974.868-1.024a.972.972 0 0 1 .758.247.984.984 0 0 1 .322.73c0 .08-.039.34-.217.58-.135.182-.39.399-.844.399h-.009c-.115 0-.215.005-.234.28-.013.186-.012.269.148.29.286.04.576-.016.865-.166.492-.256.822-.741.861-1.267a1.562 1.562 0 0 0-.452-1.222 1.56 1.56 0 0 0-1.218-.45m3.919 1.56l1.085-1.086c.04-.039.132-.132-.055-.324-.08-.083-.153-.125-.217-.125h-.001a.163.163 0 0 0-.121.058L22.46 10.21l-1.086-1.093c-.088-.088-.19-.067-.322.065-.135.136-.157.24-.069.328l1.086 1.092-1.064 1.064-.007.007c-.026.025-.065.063-.065.125-.001.063.042.139.126.223.07.071.138.107.2.107.069 0 .114-.045.139-.07l1.068-1.067 1.09 1.092a.162.162 0 0 0 .115.045h.002c.069 0 .142-.04.217-.118.122-.129.143-.236.06-.319z",source:"https://about.500px.com/press",hex:"0099E5",guidelines:void 0,license:void 0},si3m={title:"3M",slug:"3m",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>3M</title><path d="'+this.path+'"/></svg>'},path:"M18.903 5.954L17.17 13.03l-1.739-7.076h-5.099v2.613C9.72 6.28 7.56 5.706 5.558 5.674 3.12 5.641.563 6.701.469 9.936h3.373c0-.977.747-1.536 1.588-1.523 1.032-.008 1.508.434 1.533 1.124-.036.597-.387 1.014-1.525 1.014H4.303V12.9h1.03c.584 0 1.399.319 1.431 1.155.04.995-.652 1.435-1.501 1.443-1.517-.053-1.763-1.225-1.763-2.23H0c.015.677-.151 5.091 5.337 5.059 2.629.025 4.464-1.085 5.003-2.613v2.342h3.455v-7.632l1.867 7.634h3.018l1.875-7.626v7.634H24V5.954h-5.097zm-8.561 7.06c-.429-.893-1.034-1.284-1.376-1.407.714-.319 1.09-.751 1.376-1.614v3.021z",source:"https://www.3m.com/",hex:"FF0000",guidelines:void 0,license:void 0},siAbstract={title:"Abstract",slug:"abstract",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Abstract</title><path d="'+this.path+'"/></svg>'},path:"M12 0c9.601 0 12 2.399 12 12 0 9.601-2.399 12-12 12-9.601 0-12-2.399-12-12C0 2.399 2.399 0 12 0zm-1.969 18.564c2.524.003 4.604-2.07 4.609-4.595 0-2.521-2.074-4.595-4.595-4.595S5.45 11.449 5.45 13.969c0 2.516 2.065 4.588 4.581 4.595zm8.344-.189V5.625H5.625v2.247h10.498v10.503h2.252zm-8.344-6.748a2.343 2.343 0 11-.002 4.686 2.343 2.343 0 01.002-4.686z",source:"https://www.abstract.com/about/",hex:"191A1B",guidelines:void 0,license:void 0},siAbletonlive={title:"Ableton Live",slug:"abletonlive",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Ableton Live</title><path d="'+this.path+'"/></svg>'},path:"M0 6.4v11.2h1.6V6.4zm3.2 0v11.2h1.6V6.4zm3.2 0v11.2H8V6.4zm3.2 0v11.2h1.6V6.4zm3.2 0V8H24V6.4zm0 3.2v1.6H24V9.6zm0 3.2v1.6H24v-1.6zm0 3.2v1.6H24V16z",source:"https://www.ableton.com/en/legal/branding-trademark-guidelines/",hex:"000000",guidelines:void 0,license:void 0},siAboutdotme={title:"About.me",slug:"aboutdotme",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>About.me</title><path d="'+this.path+'"/></svg>'},path:"M19.536 9.146c-1.373 0-2.133 1.014-2.294 2.116h4.608c-.125-1.05-.867-2.115-2.314-2.115m-2.26 3.617c.235 1.156 1.193 1.97 2.532 1.97.725 0 1.77-.27 2.384-.914l1.175 1.35c-1.064 1.11-2.653 1.426-3.74 1.426-2.64 0-4.697-1.906-4.697-4.606 0-2.535 1.894-4.62 4.57-4.62 2.585 0 4.5 1.98 4.5 4.604v.766h-6.723v.023zm-6.487 3.83v-5.69c0-.976-.435-1.536-1.338-1.536-.814 0-1.355.585-1.717 1.007v6.24h-2.35v-5.7c0-.976-.415-1.532-1.318-1.532-.813 0-1.375.586-1.717 1.006v6.24H0V7.505h2.35v1.15c.4-.463 1.302-1.26 2.71-1.26 1.247 0 2.096.526 2.477 1.59.524-.761 1.5-1.59 2.91-1.59 1.7 0 2.69 1.01 2.69 2.963v6.24h-2.353l.005-.007z",source:"https://about.me/assets",hex:"00A98F",guidelines:void 0,license:void 0},siAbbott={title:"Abbott",slug:"abbott",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Abbott</title><path d="'+this.path+'"/></svg>'},path:"M20.812 2.4H0v3.197h19.773V5.6a1.03 1.03 0 0 1 1.032 1.031v10.742l-.004.007a1.034 1.034 0 0 1-1.034 1.025H4.23c-.569 0-1.033-.46-1.033-1.033v-4.34c0-.57.464-1.032 1.033-1.032H17.6V8.803H3.188A3.185 3.185 0 0 0 0 11.99v6.423A3.188 3.188 0 0 0 3.188 21.6h17.624A3.187 3.187 0 0 0 24 18.412V5.587A3.186 3.186 0 0 0 20.812 2.4",source:"https://commons.wikimedia.org/wiki/File:Logo_Abbott_Laboratories.svg",hex:"008FC7",guidelines:void 0,license:void 0},siAbbvie={title:"Abbvie",slug:"abbvie",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Abbvie</title><path d="'+this.path+'"/></svg>'},path:"M23.903 13.932c0-.25-.154-.347-.386-.347h-1.778c-.87 0-1.082-.522-1.12-.85h2.415c.734 0 .966-.542.966-.89 0-.367-.232-.888-.966-.888H21.7c-1.256 0-1.661.85-1.661 1.545 0 .754.463 1.546 1.661 1.546h2.203v-.116zM21.74 11.42h1.16c.425 0 .521.251.521.425 0 .155-.096.426-.521.426h-2.32c.04-.271.29-.85 1.16-.85zm-5.16 2.454c-.135.174-.193.252-.328.252-.174 0-.212-.078-.328-.252-.27-.386-1.894-2.898-1.894-2.898h.232c.386 0 .502.174.618.367.097.155 1.41 2.164 1.41 2.164s1.238-1.913 1.411-2.183c.116-.174.271-.348.638-.348h.174s-1.7 2.59-1.932 2.898zm-12.193.194c-.29 0-.405-.116-.444-.348l-.077-.329c-.078.136-.464.677-1.314.677h-.87C.367 14.068 0 13.178 0 12.522c0-.735.444-1.546 1.681-1.546h.928c.947 0 1.468.54 1.584 1.217.097.56.348 1.875.348 1.875h-.155zm-1.913-2.61H1.74c-.889 0-1.179.561-1.179 1.064 0 .502.29 1.063 1.18 1.063h.733c.928 0 1.18-.58 1.18-1.063 0-.425-.233-1.063-1.18-1.063zm16.638-.985c.135 0 .27-.077.27-.25v-.097c0-.155-.135-.252-.27-.252s-.27.078-.27.252v.096c0 .174.135.251.27.251zm-.251.503h.116c.251 0 .406.135.406.406v2.686h-.116c-.252 0-.406-.155-.406-.425v-2.667zm-13.45.444c.117-.116.464-.444 1.14-.444h.87c1.314 0 1.7.889 1.7 1.546 0 .734-.463 1.546-1.7 1.546h-.927c-.947 0-1.623-.6-1.623-1.546v-2.59h.154c.27 0 .387.136.387.368v1.12zm1.218 2.165h.734c.87 0 1.18-.56 1.18-1.063 0-.503-.29-1.063-1.18-1.063h-.734c-.928 0-1.179.58-1.179 1.063-.019.425.232 1.063 1.179 1.063zm3.633-2.165c.116-.116.464-.444 1.14-.444h.87c1.314 0 1.68.889 1.68 1.546 0 .734-.444 1.546-1.68 1.546h-.928c-.947 0-1.623-.6-1.623-1.546v-2.59h.154c.27 0 .387.136.387.368v1.12zm1.217 2.165h.735c.888 0 1.178-.56 1.178-1.063 0-.503-.29-1.063-1.178-1.063h-.735c-.927 0-1.178.58-1.178 1.063-.02.425.231 1.063 1.178 1.063z",source:"https://www.abbvie.com/",hex:"071D49",guidelines:void 0,license:void 0},siAbbrobotstudio={title:"ABB RobotStudio",slug:"abbrobotstudio",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>ABB RobotStudio</title><path d="'+this.path+'"/></svg>'},path:"M23.999 12.465a9.601 9.601 0 01-19.203 0h1.07a8.53 8.53 0 108.533-8.53v-1.07A9.6 9.6 0 0124 12.463zm-9.6-3.2a3.2 3.2 0 103.2 3.2 3.2 3.2 0 00-3.2-3.2zm-2 0l-.6-6.672-2.462 1.92-1.46-1.44a4.67 4.67 0 00-5.62-.37l-2.02 1.3a.54.54 0 00-.15.74.54.54 0 00.74.15l2-1.31a3.64 3.64 0 014.29.22l1.37 1.38-2.29 1.821z",source:"https://new.abb.com/products/robotics/en/robotstudio/downloads",hex:"FF9E0F",guidelines:void 0,license:void 0},siAcademia={title:"Academia",slug:"academia",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Academia</title><path d="'+this.path+'"/></svg>'},path:"M22.033 21.18L13.77.459H7.869l1.049 2.623L1.836 21.18C1.574 22.098.787 22.23 0 22.361v1.18h6.82v-1.18C4.984 22.23 3.934 21.967 4.721 20c.131-.131.656-1.574 1.311-3.41h8.393l1.18 3.016c.131.525.262.918.262 1.311 0 1.049-.918 1.443-2.623 1.443v1.18H24v-1.18c-.918-.13-1.705-.393-1.967-1.18zM6.82 14.361a363.303 363.303 0 0 0 3.279-8.525l3.41 8.525H6.82z",source:"https://www.academia.edu/",hex:"41454A",guidelines:void 0,license:void 0},siAccenture={title:"Accenture",slug:"accenture",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Accenture</title><path d="'+this.path+'"/></svg>'},path:"M23.297 14.74L.434 24v-5.263L16.8 12.11l6.497 2.631zm.27-5.371L.433 0v5.263l23.132 9.368V9.37z",source:"https://www.accenture.com/",hex:"A100FF",guidelines:void 0,license:void 0},siAcclaim={title:"Acclaim",slug:"acclaim",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Acclaim</title><path d="'+this.path+'"/></svg>'},path:"M12.468.186a.7.7 0 0 0-.95 0L1.924 9.193a1.705 1.705 0 0 0-.475 1.095v3.59c0 .358.214.452.475.207l9.601-9.01a.705.705 0 0 1 .95 0l9.603 9.01c.262.245.475.151.475-.207v-3.59a1.71 1.71 0 0 0-.475-1.095zm0 9.783a.705.705 0 0 0-.95 0l-9.595 9.002a1.705 1.705 0 0 0-.475 1.094v3.59c0 .358.214.453.475.208l9.601-9.007a.701.701 0 0 1 .95 0l9.603 9.008c.262.244.475.15.475-.208v-3.59a1.71 1.71 0 0 0-.475-1.094Z",source:"https://www.youracclaim.com/",hex:"26689A",guidelines:void 0,license:void 0},siAccusoft={title:"Accusoft",slug:"accusoft",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Accusoft</title><path d="'+this.path+'"/></svg>'},path:"M14.1774 4.2143c-.3824.0022-4.0063.02-4.3665.0222-.618.0044-.776-.0044-.8738.109-.0511.06-.1334.1645.1535.5246.2868.358 8.7775 11.221 8.9931 11.481.2735.3313.527.4447.638.4625.178.0267.4003-.0667.5203-.1134.1179-.0467 4.3243-1.7853 4.4155-1.8342.14-.0756.1312-.289.0378-.4469-.0934-.16-.229-.3335-.3069-.429-.08-.0957-7.6903-9.1956-7.7703-9.2956-.1467-.1845-.3602-.3602-.4447-.389-.0845-.029-.2045-.0935-.996-.0912zm-4.0152 5.1313s-.4492.06-.9427.5625c-.338.349-9.0776 8.9487-9.1243 9.0154-.0423.06-.1468.1756-.0645.2401.0422.0333.4513-.1.6559-.1734.0289 0 4.2931-1.3607 4.2931-1.3607.02-.0222-.0022-.0022.0222-.02-.0133-.189-.0289-.9804-.0355-1.036-.02-.1579.0556-.2223.109-.258.0533-.0355.1533-.0755.1533-.0755l3.4706-1.265c.0222-.029 3.3193-3.0638 3.3838-3.1216v-.0422c-.029-.0222-.04-.06-.0645-.0867-.0156-.0067-1.8564-2.3856-1.8564-2.3789zm1.8497 5.0624c-.1156.0089-.3601.029-.5424.109-.1823.08-5.4426 1.9787-5.6316 2.052-.189.0734-.4269.1334-.4135.2846.0066.0934.0733.1.1734.1312.1.0333 11.2786 2.5212 11.5477 2.5768.269.0556 1.1294.2934 1.5763.2045.24-.0334.3535-.0934.4313-.14.0778-.0467 4.6422-2.8503 4.7156-2.9037.0711-.0533.1223-.0889.1312-.1756.0044-.0333-.0912-.109-.1957-.1312a321.6128 321.6128 0 0 0-1.1139-.2179l-.309-.0555s-4.311 1.8897-4.4065 1.9342c-.12.0556-.2935.1-.4447.0867-.3157-.0289-.558-.2067-.9293-.6336l-2.1388-2.7724s-.936-.1512-1.2673-.1957c-.3313-.0445-1.0671-.16-1.1828-.1534z",source:"https://company-39138.frontify.com/d/7EKFm12NQSa8/accusoft-corporation-style-guide#/style-guide/logo",hex:"A9225C",guidelines:void 0,license:void 0},siActivision={title:"Activision",slug:"activision",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Activision</title><path d="'+this.path+'"/></svg>'},path:"M1.88 8.91L0 14.284h.985l.27-.718h1.252l.269.718h.985zm3.224.359l-.537.984h2.15v4.03H7.7v-4.03h1.522l1.882 4.837 1.791-4.837h4.567l-.537-.984H12.18l-1.074 2.865L9.94 9.269zm16.21 1.163v3.762h.986v-1.523l1.7 1.702v-3.76h-.896v1.342zm-15.94.09c-1.075 0-1.881.807-1.881 1.881 0 1.075.806 1.88 1.88 1.88.448 0 .895-.179 1.164-.447L6 12.94c-.18.18-.358.27-.627.27a.897.897 0 0 1-.895-.896c0-.448.358-.896.895-.896.18 0 .448.089.537.268l.627-.715c-.27-.269-.716-.448-1.164-.448zm7.522 0v3.672h.985v-3.671zm2.148 0c-.358 0-.804.18-.804.896 0 .896 1.074 1.433.985 1.792-.09.179-.27.178-.359.178h-.626v.806h1.074c.448 0 .895-.269.895-.806 0-.985-1.253-1.611-.984-1.97 0-.09.178-.09.178-.09h.628v-.805zm1.255 0v3.672h.984v-3.671zm3.045 0c-1.075 0-1.88.807-1.88 1.881 0 .985.805 1.88 1.88 1.88 1.074 0 1.88-.805 1.88-1.88 0-1.074-.806-1.88-1.88-1.88zm-11.016.09v3.672h.986v-3.672zm11.016.896c.448 0 .895.358.895.895a.897.897 0 0 1-.895.896c-.538 0-.985-.358-.896-.896 0-.448.358-.895.896-.895zm-17.464.178l.27.896h-.54z",source:"https://www.activision.com/",hex:"000000",guidelines:void 0,license:void 0},siActigraph={title:"ActiGraph",slug:"actigraph",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>ActiGraph</title><path d="'+this.path+'"/></svg>'},path:"M12.043 0c.413 0 .83.266 1.054.546.224.28.191.342.21.529.018.187.16.265.16.62s-.16.494-.272.644c-.112.15-.047.2-.14.406-.094.206-.118.168-.193.336-.075.168.123.462.319.61.196.147.378.262.938.318.56.056.683.03.963.05.28.018.453.174.882.23.43.056.449 0 .803 0 .355 0 .462.053.78.053.317 0 .75-.14 1.141-.122.393.018 1.43.115 1.86.115.43 0 .931-.442 1.38-.423.448.018.832.119.85.455.019.336-.165.762-.37.837-.206.074-.609-.067-.852-.067-.242 0-.496.03-.606.025-.133-.007-.232-.09-.381-.053-.15.038-.76.297-.984.315-.224.02-.689-.034-.875.003-.187.038-.822.15-1.083.168-.262.02-.786-.02-1.029.018-.243.037-.615.113-.839.113-.224 0-.702-.172-.866-.054-.397.288-.336.683-.532 1.247-.187.538-.488.88-.525 1.29-.038.412.224 1.738.355 2.205.13.467.504 1.083.747 1.848.242.766.58 2.31.711 2.945.131.635.004.62.11.977.108.362.616.934.878 1.83.261.896.547 2.744.64 3.23.094.485.135.558.172.707.037.15-.045.214.039.35.378.613.848.849.792 1.222-.056.374-.652.513-1.083.448-.326-.048-.523-.672-.597-.859-.075-.186.003-.239-.072-.37-.075-.13-.089-.199-.126-.535-.037-.336.016-.36-.039-.582-.294-1.197-1.144-2.367-1.35-3.07-.117-.393-.049-.444-.124-.799-.074-.355-2.402-5.42-2.883-5.42-.496 0-2.783 5.006-2.877 5.323-.093.318-.04.638-.133.899s-1.208 2.388-1.36 3.042c-.1.428-.012.556-.068.8-.056.242-.266 1.303-.659 1.509-.392.205-1.086.046-1.178-.292-.142-.52.678-.906.765-1.382.076-.41.804-4.165 1.102-4.893.299-.728.486-.654.616-1.064.042-.13.043-.514.113-.945.153-.934.433-2.294.765-3.201.486-1.326 1.157-2.611 1.032-3.893-.053-.539-.23-.606-.417-1.222-.187-.616-.428-1.347-.67-1.384-.244-.037-.449.093-.748.093s-.896-.13-1.12-.13c-.224 0-.992-.05-1.31-.05-.318 0-.54-.081-.726-.063-.187.02-.36.007-.584.007-.28 0-1.017-.34-1.204-.34-.187 0-.245.036-.413.036-.168 0-.325-.063-.512-.063-.186 0-.532.108-.71.108-.186 0-.54-.419-.484-.886.056-.466.805-.42.991-.42.263 0 .889.355 1.131.392.243.038 1.538-.101 1.818-.101s1.08.126 1.509.126c.43 0 1.014.01 1.369-.046s.68-.244.903-.262c.224-.019 1.238.091 1.807-.306.375-.261.411-.486.392-.654-.018-.168-.14-.192-.234-.36-.094-.168-.053-.305-.109-.417-.056-.112-.269-.212-.273-.623-.004-.322.035-.278.147-.596.112-.317.116-.451.378-.707.19-.184.575-.371.988-.371",source:"http://www.actigraphcorp.com/",hex:"0B2C4A",guidelines:void 0,license:void 0},siAdobe={title:"Adobe",slug:"adobe",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Adobe</title><path d="'+this.path+'"/></svg>'},path:"M13.966 22.624l-1.69-4.281H8.122l3.892-9.144 5.662 13.425zM8.884 1.376H0v21.248zm15.116 0h-8.884L24 22.624Z",source:"https://www.adobe.com/",hex:"FF0000",guidelines:void 0,license:void 0},siAdafruit={title:"Adafruit",slug:"adafruit",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Adafruit</title><path d="'+this.path+'"/></svg>'},path:"M14.399 12.794c-.924.148-1.722-.037-1.781-.412-.06-.375.64-.798 1.565-.945.924-.147 1.721.038 1.78.412.06.374-.64.798-1.564.945m-.878 3.86c-.338.172-.957-.363-1.382-1.196-.426-.834-.497-1.65-.158-1.822.338-.172.956.363 1.382 1.196.425.833.497 1.65.158 1.822m-3.64-1.552c-.662.662-1.415.981-1.683.713-.27-.268.05-1.022.71-1.684.66-.663 1.414-.982 1.683-.714.269.268-.05 1.023-.71 1.685m-2.531-4.61c.171-.339.987-.268 1.82.156.834.424 1.372 1.042 1.2 1.38-.173.338-.988.269-1.822-.155-.834-.424-1.37-1.043-1.198-1.381m4.8-2.45c.375.058.56.856.414 1.78-.145.925-.566 1.625-.942 1.567-.374-.06-.56-.857-.415-1.78.145-.925.567-1.626.943-1.568m11.835 2.53c-.078-.491-.345-.632-.989-.837l-3.762-1.2s-2.283-.863-3.974.357c-.228.164-.464.351-.7.55.198-.236.385-.472.55-.7 1.215-1.694.349-3.975.349-3.975l-1.207-3.761c-.207-.643-.347-.91-.84-.986-.492-.078-.707.132-1.101.68l-2.305 3.209s-1.524 1.903-.888 3.89c.086.266.191.549.308.836a12.215 12.215 0 0 0-.497-.74C7.693 6.215 5.258 6.332 5.258 6.332S1.82 6.32 1.308 6.32c-.676-.003-.972.05-1.198.493-.226.443-.093.714.307 1.258.303.415 2.34 3.183 2.34 3.183S4.095 13.292 6.18 13.3c.28.001.58-.012.889-.034a12.317 12.317 0 0 0-.855.244c-1.98.656-2.619 3.01-2.619 3.01L2.36 20.273c-.21.64-.252.939.1 1.29.352.353.65.31 1.291.098.489-.16 3.75-1.242 3.75-1.242s2.352-.644 3.004-2.624c.088-.266.169-.556.243-.854a11.1 11.1 0 0 0-.03.887c.01 2.085 2.051 3.421 2.051 3.421l3.186 2.333c.546.398.816.531 1.26.305.443-.226.495-.523.491-1.199l-.022-3.95s.114-2.435-1.567-3.668a11.93 11.93 0 0 0-.739-.495c.287.115.568.22.836.304 1.986.633 3.888-.894 3.888-.894l3.204-2.31c.547-.395.756-.612.679-1.104",source:"https://www.adafruit.com/",hex:"000000",guidelines:void 0,license:void 0},siAdblock={title:"AdBlock",slug:"adblock",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AdBlock</title><path d="'+this.path+'"/></svg>'},path:"M7.775 0a1.8 1.8 0 0 0-1.273.527L.528 6.503A1.8 1.8 0 0 0 0 7.775v8.45c0 .478.19.936.528 1.274l5.974 5.974A1.8 1.8 0 0 0 7.775 24h8.45a1.8 1.8 0 0 0 1.273-.527l5.975-5.974A1.8 1.8 0 0 0 24 16.225v-8.45a1.8 1.8 0 0 0-.527-1.272L17.498.527A1.8 1.8 0 0 0 16.225 0zm4.427 3c1.02 0 .958 1.108.958 1.108v6.784s-.009.218.16.218c.188 0 .175-.226.175-.226l-.002-5.63s-.05-.986.959-.986c1.01 0 .97.983.97.983v7.621s.014.158.141.158c.127 0 .944-2.122.944-2.122s.451-1.497 2.576-1.1c.038.008-.167.688-.167.688l-2.283 6.556S15.69 20.7 11.714 20.7c-5.044 0-4.808-5.407-4.814-5.405V7.562s-.016-.99.897-.99c.858 0 .849.99.849.99l.007 3.583s-.004.172.167.172c.16 0 .141-.172.141-.172l.01-5.926s-.055-1.162.966-1.162c1.04 0 .983 1.142.983 1.142v5.611s-.005.204.152.204c.168 0 .154-.206.154-.206l.01-6.693S11.18 3 12.202 3Z",source:"https://getadblock.com/",hex:"F40D12",guidelines:void 0,license:void 0},siAdblockplus={title:"Adblock Plus",slug:"adblockplus",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Adblock Plus</title><path d="'+this.path+'"/></svg>'},path:"M7.027 0L0 7.027v9.941L7.027 24h9.941L24 16.968v-9.94L16.973 0zm.202.48h9.542l6.749 6.749v9.542l-6.749 6.749H7.23L.48 16.771V7.23zm.557 1.344L1.824 7.786v8.428l5.962 5.962h8.428l5.962-5.962V7.786l-5.962-5.962zM4.396 7.68H6.38l2.285 8.41H6.917l-.447-2.002H4.238l-.446 1.997h-1.68zm5.3 0h2.491c.355-.005.71.029 1.061.096.302.058.595.173.85.34.24.164.436.385.57.644.14.269.207.605.207 1.008 0 .192-.024.384-.072.566-.048.188-.12.365-.216.528-.1.168-.23.317-.379.437-.163.13-.35.226-.547.283v.053c.523.11.917.327 1.18.643.265.317.399.759.399 1.33 0 .432-.072.802-.216 1.109-.14.302-.346.561-.605.768-.269.206-.576.36-.902.451-.36.1-.735.154-1.109.149H9.696zm6.667 0h2.669c.374-.005.749.043 1.114.134.33.082.643.236.907.452.269.225.48.513.61.84.148.345.225.772.225 1.281 0 .49-.077.917-.23 1.277-.14.34-.35.643-.624.888a2.553 2.553 0 0 1-.908.518 3.551 3.551 0 0 1-1.099.168H18.01v2.852h-1.647zM5.328 9.125c-.091.446-.182.907-.274 1.373-.09.465-.192.912-.297 1.334l-.178.773h1.555l-.168-.773a31.5 31.5 0 0 1-.302-1.34 55.623 55.623 0 0 0-.293-1.367zm6.005.029v1.92h.773c.403 0 .696-.092.878-.279.182-.187.274-.437.274-.753 0-.317-.092-.548-.279-.682-.187-.134-.475-.206-.864-.206zm6.681.038v2.54h.917c.898 0 1.344-.447 1.344-1.34 0-.437-.115-.749-.34-.931-.226-.183-.562-.269-1.004-.269zm-6.681 3.22v2.204h.931c.902 0 1.354-.384 1.354-1.147 0-.37-.11-.639-.336-.807-.226-.168-.562-.25-1.018-.25z",source:"https://adblockplus.org/",hex:"C70D2C",guidelines:void 0,license:void 0},siAddthis={title:"AddThis",slug:"addthis",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AddThis</title><path d="'+this.path+'"/></svg>'},path:"M18 13.496h-4.501v4.484h-3v-4.484H6v-2.99h4.5V6.021h3.001v4.485H18v2.99zM21 .041H3C1.348.043.008 1.379 0 3.031v17.94c.008 1.65 1.348 2.986 3 2.988h18c1.651-.002 2.991-1.338 3-2.988V3.031c-.009-1.652-1.348-2.987-3-2.99z",source:"http://www.addthis.com/",hex:"FF6550",guidelines:void 0,license:void 0},siAdguard={title:"AdGuard",slug:"adguard",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AdGuard</title><path d="'+this.path+'"/></svg>'},path:"M12 0C8.249 0 3.725.861 0 2.755 0 6.845-.051 17.037 12 24 24.051 17.037 24 6.845 24 2.755 20.275.861 15.751 0 12 0zm-.106 15.429L6.857 9.612c.331-.239 1.75-1.143 2.794.042l2.187 2.588c.009-.001 5.801-5.948 5.815-5.938.246-.22.694-.503 1.204-.101l-6.963 9.226z",source:"https://adguard.com/en/media-materials.html",hex:"68BC71",guidelines:void 0,license:void 0},siAdidas={title:"Adidas",slug:"adidas",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Adidas</title><path d="'+this.path+'"/></svg>'},path:"M11.936 17.952c0-.644.517-1.16 1.162-1.16.644 0 1.16.516 1.16 1.16a1.157 1.157 0 01-1.16 1.161 1.157 1.157 0 01-1.162-1.16m4.724 0c0-.645.517-1.162 1.161-1.162s1.161.517 1.161 1.161-.517 1.161-1.16 1.161a1.157 1.157 0 01-1.162-1.16m-10.95 0c0-.645.517-1.162 1.161-1.162s1.16.517 1.16 1.161-.516 1.161-1.16 1.161a1.157 1.157 0 01-1.161-1.16m-4.724 0c0-.645.517-1.162 1.161-1.162s1.161.517 1.161 1.161a1.157 1.157 0 01-1.161 1.161 1.157 1.157 0 01-1.16-1.16m9.55-2.052h-1.01v4.063h1.01v-4.063zM3.3 19.964h1.01v-4.063H3.3v.326a2.087 2.087 0 00-1.2-.374c-1.162 0-2.1.938-2.1 2.1 0 1.168.938 2.099 2.1 2.099.445 0 .858-.135 1.2-.374v.286zm15.674 0h1.01v-4.063h-1.01v.326a2.087 2.087 0 00-1.2-.374c-1.162 0-2.1.938-2.1 2.1a2.092 2.092 0 002.1 2.099c.445 0 .858-.135 1.2-.374v.286zm1.384-1.32c.032.82.732 1.4 1.9 1.4.955 0 1.742-.414 1.742-1.328 0-.636-.358-1.01-1.185-1.17l-.644-.126c-.414-.08-.7-.16-.7-.406 0-.27.278-.39.628-.39.51 0 .716.255.732.557h1.018c-.056-.795-.692-1.328-1.718-1.328-1.057 0-1.686.58-1.686 1.336 0 .922.748 1.073 1.392 1.193l.533.095c.382.072.549.183.549.406 0 .199-.191.397-.645.397-.66 0-.874-.342-.882-.636h-1.034zM8.024 14.517v1.71a2.087 2.087 0 00-1.2-.374c-1.162 0-2.1.938-2.1 2.1 0 1.168.938 2.099 2.1 2.099.444 0 .858-.135 1.2-.374v.286h1.01v-5.447h-1.01zm6.226 0v1.71a2.087 2.087 0 00-1.2-.374c-1.161 0-2.1.938-2.1 2.1a2.092 2.092 0 002.1 2.099c.445 0 .858-.135 1.2-.374v.286h1.01v-5.447h-1.01zm-11.626-1.2l.684 1.2h4.716l-1.869-3.229-3.53 2.028zm7.913 2.21v-1.01h3.713l-3.96-6.855L6.751 9.69l2.776 4.827v1.01h1.01zm5.217-1.01h4.723L14.37 3.948l-3.531 2.036 4.915 8.533z",source:"https://www.adidas.com",hex:"000000",guidelines:void 0,license:void 0},siAcer={title:"Acer",slug:"acer",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Acer</title><path d="'+this.path+'"/></svg>'},path:"M23.943 9.364c-.085-.113-.17-.198-.595-.226-.113 0-.453-.029-1.048-.029-1.56 0-2.636.482-3.175 1.417.142-.935-.765-1.417-2.749-1.417-2.324 0-3.798.935-4.393 2.834-.226.709-.226 1.276-.056 1.73h-.567c-.425.027-.992.056-1.36.056-.85 0-1.39-.142-1.588-.425-.17-.255-.17-.737.057-1.446.368-1.162 1.247-1.672 2.664-1.672.737 0 1.445.085 1.445.085.085 0 .142-.113.142-.198l-.028-.085-.057-.397c-.028-.255-.227-.397-.567-.453-.311-.029-.567-.029-.907-.029h-.028c-1.842 0-3.146.624-3.854 1.814.255-1.219-.596-1.814-2.551-1.814-1.105 0-1.9.029-2.353.085-.368.057-.595.199-.68.454l-.17.51c-.028.085.029.142.142.142.085 0 .425-.057.992-.086a24.816 24.816 0 0 1 1.672-.085c1.077 0 1.559.284 1.389.822-.029.114-.114.199-.255.227-1.02.17-1.842.284-2.438.369-1.7.226-2.692.736-2.947 1.587-.369 1.162.538 1.728 2.72 1.728 1.078 0 2.013-.056 2.75-.198.425-.085.652-.17.737-.453l.396-1.304c-.028 1.304.85 1.955 2.721 1.955.794 0 1.559-.028 1.927-.085.369-.056.567-.141.652-.425l.085-.396c.397.623 1.276.935 2.608.935 1.417 0 2.239-.029 2.465-.114a.523.523 0 0 0 .369-.311l.028-.085.17-.539c.029-.085-.028-.142-.142-.142l-.906.057c-.596.029-1.077.057-1.418.057-.651 0-1.076-.057-1.332-.142-.368-.142-.538-.397-.51-.822l2.863-.368c1.275-.17 2.154-.567 2.579-1.19l-.992 3.315c-.028.057 0 .114.028.142.029.028.085.057.199.057h1.19c.198 0 .283-.114.312-.199l1.048-3.656c.142-.481.567-.708 1.36-.708.71 0 1.22 0 1.56.028h.028c.057 0 .17-.028.255-.17l.17-.51c0-.085 0-.17-.057-.227zM4.841 13.73c-.368.057-.907.085-1.587.085-1.219 0-1.729-.255-1.587-.737.113-.34.425-.567.935-.624l2.75-.368zm12.669-2.95c-.114.369-.652.624-1.616.766l-2.295.311.056-.198c.199-.624.454-1.02.794-1.247.34-.227.907-.34 1.7-.34 1.05.028 1.503.255 1.36.708Z",source:"https://www.acer.com/ac/en/GB/content/home",hex:"83B81A",guidelines:void 0,license:void 0},siAcm={title:"ACM",slug:"acm",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>ACM</title><path d="'+this.path+'"/></svg>'},path:"M7.435 12.25c-.08.025-.15.072-.202.135-.048.072-.073.158-.07.245 0 .15.038.252.12.308.077.056.194.082.352.082.087 0 .174-.02.264-.06.09-.038.174-.095.245-.165v-.66c-.168.015-.303.03-.405.045-.105.01-.207.034-.305.07zM12 0L0 12l12 12 12-12L12 0zm0 19.357C7.938 19.355 4.645 16.063 4.643 12 4.645 7.938 7.938 4.644 12 4.642c4.063.002 7.355 3.295 7.357 7.358-.002 4.063-3.294 7.355-7.357 7.357zM12 5.377v.002c-3.654 0-6.62 2.966-6.62 6.62s2.966 6.62 6.62 6.62 6.62-2.966 6.62-6.62c0-3.656-2.964-6.62-6.62-6.623zm-2.862 8.246h-.995v-.336l-.182.154c-.142.108-.304.188-.477.233-.082.02-.202.035-.352.035-.262.007-.515-.097-.698-.285-.187-.19-.277-.426-.277-.716 0-.238.046-.427.14-.574.1-.15.24-.27.405-.348.205-.09.423-.152.646-.18.25-.033.516-.06.803-.078v-.017c0-.176-.066-.297-.196-.363-.13-.07-.322-.102-.58-.102-.117 0-.254.02-.41.063-.158.044-.308.1-.458.164H6.42v-.77c.097-.03.256-.062.48-.1.217-.04.438-.06.663-.06.55 0 .95.092 1.2.276.25.183.375.462.375.837v2.168zm3.22-.167c-.07.028-.134.056-.2.086-.074.03-.15.058-.23.08-.094.024-.186.044-.27.06-.084.014-.196.022-.336.022-.263 0-.506-.033-.723-.1-.21-.062-.406-.165-.57-.307-.163-.142-.292-.32-.373-.52-.09-.21-.135-.457-.135-.738-.008-.27.042-.535.146-.78.09-.204.224-.384.392-.53.165-.134.355-.233.56-.29.22-.066.447-.096.675-.096.37 0 .732.087 1.06.255v.854h-.127c-.048-.043-.096-.085-.147-.124-.06-.048-.122-.09-.188-.126-.167-.095-.357-.144-.55-.14-.254 0-.45.086-.59.263-.138.177-.21.414-.21.714 0 .32.075.56.225.715.15.157.347.235.592.235.11 0 .222-.013.33-.042.153-.043.295-.12.415-.225.048-.04.088-.082.123-.11h.13v.843zm4.333.173v-1.597c0-.157 0-.29-.007-.397-.002-.09-.02-.18-.052-.263-.023-.066-.07-.12-.13-.15-.153-.064-.325-.063-.478.002-.086.04-.168.087-.244.14v2.263h-.993v-1.595c0-.156-.003-.286-.01-.396-.003-.09-.02-.18-.05-.264-.027-.066-.076-.12-.136-.15-.06-.033-.145-.048-.25-.048-.083 0-.165.02-.24.056-.078.04-.152.086-.228.136v2.262h-.995V10.44h.993v.356c.144-.125.296-.233.46-.323.148-.08.314-.12.484-.12.182-.004.36.045.514.14.153.1.27.244.34.414.19-.177.37-.314.54-.41.17-.096.34-.145.515-.145.136-.002.27.023.396.075.115.044.22.116.3.21.09.106.16.23.2.364.045.142.066.328.066.553v2.076h-.995z",source:"http://identitystandards.acm.org/",hex:"0085CA",guidelines:void 0,license:void 0},siAdobeaftereffects={title:"Adobe After Effects",slug:"adobeaftereffects",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Adobe After Effects</title><path d="'+this.path+'"/></svg>'},path:"M8.54 10.73c-.1-.31-.19-.61-.29-.92s-.19-.6-.27-.89c-.08-.28-.15-.54-.22-.78h-.02c-.09.43-.2.86-.34 1.29-.15.48-.3.98-.46 1.48-.13.51-.29.98-.44 1.4h2.54c-.06-.21-.14-.46-.23-.72-.09-.27-.18-.56-.27-.86zm8.58-.29c-.55-.03-1.07.26-1.33.76-.12.23-.19.47-.22.72h2.109c.26 0 .45 0 .57-.01.08-.01.16-.03.23-.08v-.1c0-.13-.021-.25-.061-.37-.178-.56-.708-.94-1.298-.92zM19.75.3H4.25C1.9.3 0 2.2 0 4.55v14.9c0 2.35 1.9 4.25 4.25 4.25h15.5c2.35 0 4.25-1.9 4.25-4.25V4.55C24 2.2 22.1.3 19.75.3zm-7.04 16.511h-2.09c-.07.01-.14-.041-.16-.11l-.82-2.4H5.92l-.76 2.36c-.02.09-.1.15-.19.14H3.09c-.11 0-.14-.06-.11-.18L6.2 7.39c.03-.1.06-.19.1-.31.04-.21.06-.43.06-.65-.01-.05.03-.1.08-.11h2.59c.07 0 .12.03.13.08l3.65 10.25c.03.11.001.161-.1.161zm7.851-3.991c-.021.189-.031.33-.041.42-.01.07-.069.13-.14.13-.06 0-.17.01-.33.021-.159.02-.35.029-.579.029-.23 0-.471-.04-.73-.04h-3.17c.039.31.14.62.31.89.181.271.431.48.729.601.4.17.841.26 1.281.25.35-.011.699-.04 1.039-.11.311-.039.61-.119.891-.23.05-.039.08-.02.08.08v1.531c0 .039-.01.08-.021.119-.021.03-.04.051-.069.07-.32.14-.65.24-1 .3-.471.09-.94.13-1.42.12-.761 0-1.4-.12-1.92-.35-.49-.211-.921-.541-1.261-.95-.319-.39-.55-.83-.69-1.31-.14-.471-.209-.961-.209-1.461 0-.539.08-1.07.25-1.59.16-.5.41-.96.75-1.37.33-.4.739-.72 1.209-.95.471-.23 1.03-.31 1.67-.31.531-.01 1.06.09 1.55.31.41.18.77.45 1.05.8.26.34.47.72.601 1.14.129.4.189.81.189 1.22 0 .24-.01.45-.019.64z",source:"https://www.adobe.com/products/aftereffects.html",hex:"9999FF",guidelines:void 0,license:void 0},siAdobeaudition={title:"Adobe Audition",slug:"adobeaudition",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Adobe Audition</title><path d="'+this.path+'"/></svg>'},path:"M19.75.3H4.25C1.9.3 0 2.2 0 4.55v14.9c0 2.35 1.9 4.25 4.25 4.25h15.5c2.35 0 4.25-1.9 4.25-4.25V4.55C24 2.2 22.1.3 19.75.3zM12.5 16.8h-2.09c-.07.011-.14-.04-.16-.11l-.82-2.39H5.71l-.76 2.36c-.02.09-.1.15-.19.14H2.88c-.11 0-.14-.06-.11-.18l3.22-9.24c.03-.1.06-.21.1-.33.05-.21.08-.42.08-.64-.01-.05.03-.1.08-.11h2.59c.07 0 .12.03.13.08l3.63 10.261c.03.109 0 .159-.1.159zm7.75.011h-1.721c-.079.01-.159-.041-.189-.11-.02-.08-.04-.171-.061-.25-.02-.07-.02-.14-.02-.21-.32.289-.71.5-1.13.619-.36.101-.739.15-1.11.15-.369 0-.74-.05-1.09-.17-.32-.109-.619-.3-.85-.55-.26-.28-.45-.61-.561-.97-.14-.461-.209-.94-.199-1.42V8.94c-.01-.06.029-.12.1-.13h1.939c.061-.01.121.03.131.1v4.731c0 .439.1.789.289 1.039.191.25.58.381 1.031.381.229 0 .459-.041.68-.121.23-.08.439-.189.63-.33V8.92c0-.07.05-.11.14-.11h1.91c.051-.01.109.03.109.08v6.16c0 .271 0 .511.011.72.01.211.021.391.03.551.02.16.029.25.039.359.012.09-.028.131-.108.131zM8.33 10.73c-.1-.31-.19-.61-.29-.92s-.19-.6-.27-.89c-.08-.28-.15-.54-.22-.78h-.02c-.09.43-.2.86-.34 1.29-.15.48-.3.98-.46 1.48-.13.51-.29.98-.44 1.4h2.54c-.06-.21-.14-.46-.23-.72-.09-.27-.18-.56-.27-.86z",source:"https://www.adobe.com/creativecloud/video.html",hex:"9999FF",guidelines:void 0,license:void 0},siAdonisjs={title:"AdonisJS",slug:"adonisjs",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AdonisJS</title><path d="'+this.path+'"/></svg>'},path:"M13.333 1.333l-.596 1.193-2.404 4.807L8 2.667l-8 16h4.667l-2 4H24zm0 2.982l8.51 17.018H4.823l1.334-2.666H16l-4.922-9.843Z",source:"https://adonisjs.com/",hex:"220052",guidelines:void 0,license:void 0},siAdobecreativecloud={title:"Adobe Creative Cloud",slug:"adobecreativecloud",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Adobe Creative Cloud</title><path d="'+this.path+'"/></svg>'},path:"M14.782 3.153c-.231.02-.472.04-.703.07a8.453 8.453 0 0 0-2.832.834 8.951 8.951 0 0 0-2.46 1.777c-.03.04-.09.06-.141.05a7.44 7.44 0 0 0-1.496-.07 7.424 7.424 0 0 0-2.932.763c-1.768.884-3.013 2.26-3.736 4.108a7.089 7.089 0 0 0-.462 2.139c0 .05-.01.09-.02.13v.773c.02.201.05.392.07.593.1.813.332 1.596.703 2.33.824 1.646 2.089 2.851 3.786 3.594a7.127 7.127 0 0 0 2.45.593c.032 0 .06.004.086.01h8.576c.183-.017.362-.035.547-.06a8.344 8.344 0 0 0 2.811-.834 8.836 8.836 0 0 0 3.646-3.304 8.187 8.187 0 0 0 1.184-3.093c.05-.34.08-.692.121-1.034 0-.05.01-.09.02-.13v-.794c-.02-.23-.05-.452-.05-.662a8.345 8.345 0 0 0-.834-2.812 8.952 8.952 0 0 0-3.324-3.645 8.245 8.245 0 0 0-3.072-1.175c-.362-.06-.713-.09-1.075-.13-.05 0-.09-.01-.14-.02zm.369 1.693c2.126.005 3.93.826 5.395 2.455a6.93 6.93 0 0 1 1.616 3.323c.15.764.181 1.547.07 2.32-.19 1.346-.702 2.55-1.576 3.605a7.082 7.082 0 0 1-3.997 2.45 7.297 7.297 0 0 1-2.56.1c-1.095-.14-2.099-.501-3.003-1.154a5.2 5.2 0 0 1-.672-.573c-1.226-1.205-2.44-2.42-3.666-3.625-.301-.3-.321-.632-.18-.934a.822.822 0 0 1 .863-.472c.21.02.372.141.522.292 1.105 1.114 2.2 2.209 3.304 3.324a5.263 5.263 0 0 0 3.093 1.536c1.948.261 3.605-.341 4.92-1.798.713-.793 1.145-1.747 1.326-2.811.26-1.587-.11-3.013-1.095-4.268-.873-1.115-2.018-1.808-3.404-2.059-1.416-.25-2.751.02-3.966.794-.03.02-.1.03-.131.01a9.04 9.04 0 0 0-1.406-.854s-.01-.01-.02-.03a6.603 6.603 0 0 1 1.255-.823 6.646 6.646 0 0 1 2.641-.784 8.45 8.45 0 0 1 .67-.024zM7.546 7.509c1.455-.024 2.791.525 3.982 1.63.854.802 1.637 1.636 2.46 2.47.231.23.281.522.171.833-.11.311-.362.462-.683.512a.722.722 0 0 1-.632-.23c-.784-.784-1.567-1.557-2.34-2.35-.633-.653-1.386-1.025-2.27-1.186-1.958-.351-3.936.784-4.639 2.641-.904 2.36.522 5.031 2.982 5.594.482.11.995.11 1.497.1.14-.01.22.04.32.13.483.473.995.945 1.497 1.416.03.03.07.06.1.09-.06 0-.1.01-.14.01h-2.3a5.833 5.833 0 0 1-5.693-4.568c-.653-2.942 1.034-5.925 3.926-6.798a6.33 6.33 0 0 1 1.762-.294Z",source:"https://www.adobe.com/creativecloud/plans.html",hex:"DA1F26",guidelines:void 0,license:void 0},siAdobedreamweaver={title:"Adobe Dreamweaver",slug:"adobedreamweaver",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Adobe Dreamweaver</title><path d="'+this.path+'"/></svg>'},path:"M6.69 8.4c-.43-.13-.87-.2-1.32-.19-.2 0-.37 0-.51.01-.14 0-.3.01-.47.02v6.67c.11 0 .21 0 .31.01.09.01.19.01.28.02.1.011.21.011.33.011.46.01.92-.07 1.36-.229.4-.141.75-.371 1.05-.681.3-.319.53-.7.67-1.11.16-.479.24-.99.24-1.5.01-.48-.07-.96-.23-1.41C8.12 9.24 7.49 8.64 6.69 8.4zM19.75.3H4.25C1.9.3 0 2.2 0 4.55v14.9c0 2.35 1.9 4.25 4.25 4.25h15.5c2.35 0 4.25-1.9 4.25-4.25V4.55C24 2.2 22.1.3 19.75.3zm-9.24 13.13c-.19.561-.48 1.08-.86 1.541-.35.42-.77.779-1.23 1.069-.45.28-.95.489-1.47.63-.5.13-1.02.2-1.54.2H4.28c-.4 0-.78 0-1.12-.011-.35-.01-.61-.01-.78-.02-.07 0-.1-.061-.1-.16V6.44c-.01-.06.04-.12.1-.13h.01c.15-.01.38-.02.67-.02.3-.01.64-.01 1.04-.02s.82-.01 1.27-.01c1.22 0 2.24.22 3.04.66.77.41 1.4 1.04 1.81 1.81.4.77.6 1.65.6 2.65.01.7-.09 1.39-.31 2.05zm9.42 3.24c-.01.04-.029.08-.06.109 0 .051-.04.07-.091.061H17.91c-.04.01-.09-.01-.12-.04-.03-.04-.05-.079-.06-.12-.19-.8-.351-1.52-.48-2.13-.13-.62-.24-1.14-.32-1.569-.08-.431-.15-.791-.209-1.09-.051-.3-.101-.55-.131-.76h-.01c-.1.44-.189.87-.28 1.28-.079.41-.18.83-.28 1.25-.1.42-.209.88-.34 1.38-.119.5-.26 1.05-.41 1.64-.02.11-.069.16-.16.16h-1.87c-.051.01-.1-.01-.141-.029-.029-.031-.05-.07-.07-.11L11.08 8.97c-.03-.09.01-.13.12-.13h1.89c.09 0 .141.03.15.1.199.88.369 1.64.5 2.28.13.64.24 1.18.31 1.629.07.45.14.82.19 1.101.05.28.09.521.119.7h.031c.02-.16.039-.311.069-.471.04-.189.09-.439.149-.75.061-.31.131-.67.221-1.09s.189-.9.311-1.46c.109-.55.27-1.18.459-1.89 0-.04.021-.09.041-.13.01-.02.049-.03.109-.03h1.96c.06 0 .09.04.101.11.17.73.31 1.37.43 1.92.109.55.21 1.04.3 1.47.08.42.149.79.19 1.09.039.311.09.561.129.77.031.17.061.34.07.511h.03c.05-.2.09-.44.13-.71.04-.271.09-.57.16-.91.061-.34.13-.71.21-1.12.069-.41.17-.86.28-1.37.109-.5.23-1.05.369-1.64.021-.09.061-.13.131-.13h1.75c.09 0 .119.05.1.14l-2.159 7.71z",source:"https://www.adobe.com/products/dreamweaver.html",hex:"FF61F6",guidelines:void 0,license:void 0},siAdobefonts={title:"Adobe Fonts",slug:"adobefonts",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Adobe Fonts</title><path d="'+this.path+'"/></svg>'},path:"M19.764.375H4.236A4.236 4.236 0 0 0 0 4.611V19.39a4.236 4.236 0 0 0 4.236 4.236h15.528A4.236 4.236 0 0 0 24 19.389V4.61A4.236 4.236 0 0 0 19.764.375zm-3.25 6.536c-.242 0-.364-.181-.44-.439-.257-.97-.59-1.257-.787-1.257s-.5.364-.833 1.12c-.417.97-.754 1.97-1.007 2.994l1.732-.002c.11.28.01.6-.238.772H13.23c-.56 1.878-1.031 3.688-1.592 5.46a9.676 9.676 0 0 1-1.105 2.56 3.144 3.144 0 0 1-2.484 1.332c-.773 0-1.53-.363-1.53-1.166.036-.503.424-.91.924-.97a.46.46 0 0 1 .424.243c.379.682.742 1.075.909 1.075.166 0 .303-.227.575-1.211l1.988-7.322-1.43-.002a.685.685 0 0 1 .227-.774h1.423c.257-.895.609-1.76 1.048-2.58a3.786 3.786 0 0 1 3.272-2.195c1.136 0 1.605.545 1.605 1.242a1.144 1.144 0 0 1-.97 1.12z",source:"https://www.adobe.com/creativecloud/services.html",hex:"000B1D",guidelines:void 0,license:void 0},siAdobeillustrator={title:"Adobe Illustrator",slug:"adobeillustrator",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Adobe Illustrator</title><path d="'+this.path+'"/></svg>'},path:"M10.53 10.73c-.1-.31-.19-.61-.29-.92-.1-.31-.19-.6-.27-.89-.08-.28-.15-.54-.22-.78h-.02c-.09.43-.2.86-.34 1.29-.15.48-.3.98-.46 1.48-.14.51-.29.98-.44 1.4h2.54c-.06-.211-.14-.46-.23-.721-.09-.269-.18-.559-.27-.859zM19.75.3H4.25C1.9.3 0 2.2 0 4.55v14.9c0 2.35 1.9 4.25 4.25 4.25h15.5c2.35 0 4.25-1.9 4.25-4.25V4.55C24 2.2 22.1.3 19.75.3zM14.7 16.83h-2.091c-.069.01-.139-.04-.159-.11l-.82-2.38H7.91l-.76 2.35c-.02.09-.1.15-.19.141H5.08c-.11 0-.14-.061-.11-.18L8.19 7.38c.03-.1.06-.21.1-.33.04-.21.06-.43.06-.65-.01-.05.03-.1.08-.11h2.59c.08 0 .12.03.13.08l3.65 10.3c.03.109 0 .16-.1.16zm3.4-.15c0 .11-.039.16-.129.16H16.01c-.1 0-.15-.061-.15-.16v-7.7c0-.1.041-.14.131-.14h1.98c.09 0 .129.05.129.14v7.7zm-.209-9.03c-.231.24-.571.37-.911.35-.33.01-.65-.12-.891-.35-.23-.25-.35-.58-.34-.92-.01-.34.12-.66.359-.89.242-.23.562-.35.892-.35.391 0 .689.12.91.35.22.24.34.56.33.89.01.34-.11.67-.349.92z",source:"https://www.adobe.com/products/illustrator.html",hex:"FF9A00",guidelines:void 0,license:void 0},siAffinitypublisher={title:"Affinity Publisher",slug:"affinitypublisher",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Affinity Publisher</title><path d="'+this.path+'"/></svg>'},path:"M10.44 0L9.36 1.87 22.136 24h1.144a.72.72 0 00.72-.72v-3.119L12.36 0zm3 0L24 18.29V.72a.72.72 0 00-.72-.72zM8.82 2.806l-1.98 3.43L16.976 24h4.08zM6.24 7.274L4.76 9.837a1.941 1.941 0 000 1.942C6.531 14.842 11.816 24 11.816 24h4.08zm-2.58 4.47L0 18.082v5.197c0 .397.323.72.72.72h10.016Z",source:"https://affinity.serif.com/en-gb/publisher/",hex:"C9284D",guidelines:void 0,license:void 0},siAffinity={title:"Affinity",slug:"affinity",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Affinity</title><path d="'+this.path+'"/></svg>'},path:"M9.368 1.08h3.778l.318.55h1.082L24 18.004v.001l-2.036 3.47H13.69l.84 1.445h-.365l-.84-1.446H3.057l-.526-.923h-.652L0 17.298l.002-.001 2.41-4.176 2.23-1.288 3.69-6.39-.742-1.285L9.368 1.08zm2.224 5.652L5.066 18.008h6.25l-.723-1.246 6.808.006-5.809-10.036Z",source:"https://affinity.serif.com/",hex:"222324",guidelines:void 0,license:void 0},siAdobeindesign={title:"Adobe InDesign",slug:"adobeindesign",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Adobe InDesign</title><path d="'+this.path+'"/></svg>'},path:"M4.25.3C1.9.3 0 2.2 0 4.55v14.9c0 2.35 1.9 4.25 4.25 4.25h15.5c2.35 0 4.25-1.9 4.25-4.25V4.55C24 2.2 22.1.3 19.75.3zm11.31 5.13h2.03c.05-.01.09.03.1.07v9.54c0 .18.01.38.02.6.02.21.03.41.04.58 0 .07-.03.13-.1.16-.52.22-1.07.38-1.63.48-.5.09-1.02.14-1.54.14-.74.01-1.48-.14-2.15-.45-.63-.29-1.15-.77-1.51-1.36-.37-.61-.55-1.37-.55-2.28-.01-.74.18-1.47.55-2.11.38-.65.93-1.19 1.59-1.55.7-.39 1.54-.58 2.53-.58.05 0 .12 0 .21.01s.19.01.31.02V5.54c0-.07.03-.11.1-.11zm-8.93.86h1.95c.06-.01.12.03.13.1.01.01.01.02.01.03v10.26c0 .11-.05.16-.14.16H6.62c-.09 0-.13-.05-.13-.16V6.42c0-.09.05-.13.14-.13zm8.23 4.24c-.39 0-.78.08-1.13.26-.34.17-.63.42-.85.74-.22.32-.33.75-.33 1.27-.01.35.05.7.17 1.03.1.27.25.51.45.71.19.18.42.32.68.4.27.09.55.13.83.13.15 0 .29-.01.42-.02.13.01.25-.01.36-.05v-4.4c-.09-.02-.18-.04-.27-.05-.11-.01-.22-.02-.33-.02z",source:"https://www.adobe.com/products/indesign.html",hex:"FF3366",guidelines:void 0,license:void 0},siAdobelightroom={title:"Adobe Lightroom",slug:"adobelightroom",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Adobe Lightroom</title><path d="'+this.path+'"/></svg>'},path:"M19.75.3H4.25C1.9.3 0 2.2 0 4.55v14.9c0 2.35 1.9 4.25 4.25 4.25h15.5c2.35 0 4.25-1.9 4.25-4.25V4.55C24 2.2 22.1.3 19.75.3zm-6.99 16.389c0 .051-.029.09-.06.121-.03.02-.06.029-.101.029H6.26c-.11 0-.16-.061-.16-.18V6.44c-.01-.07.04-.13.11-.14h2c.05-.01.11.03.11.08v8.43h4.62c.101 0 .131.049.11.14l-.29 1.739zm6.25-7.859v1.95c0 .08-.05.11-.16.11-.649-.04-1.3.08-1.89.34-.2.09-.39.21-.54.37v5.1c0 .1-.04.14-.13.14h-1.95c-.08.01-.15-.04-.16-.119V11.14c0-.24 0-.49-.01-.75s-.01-.52-.02-.78c-.01-.22-.03-.44-.061-.66-.01-.05.02-.1.07-.11.01-.01.02-.01.04 0h1.75c.1 0 .18.07.21.16.04.07.07.15.08.23.02.1.039.21.05.31.01.11.021.23.021.36.299-.35.66-.64 1.069-.86.46-.25.97-.37 1.49-.36.069-.01.13.04.14.11.001.01.001.02.001.04z",source:"https://www.adobe.com/products/photoshop-lightroom.html",hex:"31A8FF",guidelines:void 0,license:void 0},siAdobelightroomclassic={title:"Adobe Lightroom Classic",slug:"adobelightroomclassic",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Adobe Lightroom Classic</title><path d="'+this.path+'"/></svg>'},path:"M19.75.3H4.25C1.9.3 0 2.2 0 4.55v14.9c0 2.35 1.9 4.25 4.25 4.25h15.5c2.35 0 4.25-1.9 4.25-4.25V4.55C24 2.2 22.1.3 19.75.3zM8.57 16.689c-.01.061-.03.101-.06.121-.03.02-.06.029-.09.029H2.71c-.1 0-.14-.061-.14-.18V6.44c0-.1.04-.14.13-.14h1.77c.07 0 .1.04.1.11v8.4h4.16c.09 0 .12.049.1.14l-.26 1.739zm5.6-5.919c0 .08-.05.11-.141.11-.319-.02-.639 0-.949.07-.26.06-.51.15-.75.27-.18.09-.35.22-.49.37v5.1c0 .101-.04.141-.12.141H9.98c-.1 0-.14-.051-.14-.16v-5.54c0-.24 0-.49-.01-.75 0-.26-.01-.52-.02-.78-.01-.221-.03-.441-.06-.661 0-.03 0-.06.02-.09.03-.01.05-.02.08-.01h1.58c.09 0 .15.05.19.16.03.07.06.15.07.23.02.1.03.21.04.31.01.11.01.23.01.36.26-.34.59-.64.96-.86.399-.24.87-.37 1.34-.36.09 0 .13.05.13.14v1.95zm7.2-1.61c.01.06-.021.11-.06.15-.041.02-.09.02-.131 0-.229-.12-.47-.2-.72-.24-.31-.06-.63-.08-.94-.08-.51-.01-1.02.12-1.459.38-.41.25-.73.62-.94 1.05-.229.5-.341 1.05-.33 1.6-.011.4.05.791.16 1.169.1.311.25.601.44.86.17.229.379.431.629.58.24.14.49.25.76.32.25.069.521.11.781.11.289 0 .58-.011.869-.041.24-.029.48-.09.7-.17.08-.06.13-.029.16-.01.04.04.06.1.05.15v1.49c.01.119-.05.22-.15.27-.26.1-.529.17-.81.2-.339.052-.679.072-1.029.072-.49 0-.99-.069-1.459-.199-.461-.12-.891-.33-1.271-.6-.38-.271-.71-.601-.979-.99-.291-.42-.5-.881-.641-1.371-.15-.58-.23-1.17-.221-1.759 0-.98.191-1.86.58-2.6.381-.73.951-1.34 1.66-1.75.711-.41 1.57-.62 2.551-.62.34 0 .68.02 1.02.06.23.03.46.08.67.17.08.05.12.14.11.24V9.16z",source:"https://www.adobe.com/products/photoshop-lightroom-classic.html",hex:"31A8FF",guidelines:void 0,license:void 0},siAidungeon={title:"AI Dungeon",slug:"aidungeon",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AI Dungeon</title><path d="'+this.path+'"/></svg>'},path:"M0 0v24h24V0zm5.646 13.002H7.21c.117 0 .213.095.213.213v.123c0 .117-.096.21-.213.21h-.457v1.68h.457c.117 0 .213.096.213.213v.123c0 .118-.096.211-.213.211H5.646a.21.21 0 01-.21-.21v-.124c0-.117.093-.212.21-.212h.46v-1.68h-.46a.21.21 0 01-.21-.211v-.123c0-.118.093-.213.21-.213zm-2.833.023h.958c.13 0 .19.093.235.235l.756 1.974h.06c.13 0 .235.105.235.235v.09c0 .13-.105.234-.235.234h-.816a.234.234 0 01-.235-.234v-.09c0-.13.105-.235.235-.235h.101l-.074-.224h-.969l-.078.224h.178a.2.2 0 01.201.202v.132a.2.2 0 01-.2.202H2.35a.2.2 0 01-.202-.202v-.132a.2.2 0 01.202-.202h.113l.625-1.707h-.276a.234.234 0 01-.234-.234v-.033c0-.13.105-.235.235-.235zm.748.557l-.317.908h.617zm14.109 3.885h.002c.736 0 1.333.649 1.332 1.449 0 .8-.597 1.448-1.332 1.447-.736 0-1.332-.647-1.332-1.447-.001-.8.595-1.448 1.33-1.45zm-4.71.002c.118 0 .212.097.212.219 0 .226-.004.447 0 .671 0 0 .036.268-.223.264-.285-.004-.198-.263-.408-.514-.085-.1-.14-.124-.377-.127-.387-.003-.736.16-.734.9 0 .391.143.931.68.956.156.007.452-.072.452-.072v-.348h-.289a.218.218 0 01-.218-.219v-.082c0-.121.097-.219.218-.219h.977c.121 0 .219.098.219.22v.081a.218.218 0 01-.219.219h-.068l.004.686s-.3.26-1.088.253c-.995-.007-1.356-.78-1.354-1.437.003-.855.61-1.433 1.244-1.441.332-.005.583.078.778.17.02-.1.093-.18.195-.18zm.868.062h1.985c.12 0 .218.098.218.219v.64a.218.218 0 01-.218.22h-.086a.218.218 0 01-.22-.22v-.312h-1.044c0 .006.006.01.006.016v.508h.375v-.055c0-.121.097-.219.219-.219h.054c.121 0 .219.098.219.219v.633a.218.218 0 01-.219.218h-.055a.218.218 0 01-.218-.218v-.055h-.375v.617c0 .003-.004.005-.004.008h1.043v-.313c0-.12.097-.218.219-.218h.086c.12 0 .218.097.218.218v.641a.218.218 0 01-.218.219h-1.985a.218.218 0 01-.219-.219v-.11c0-.12.098-.218.22-.218l.054-.008v-1.648c0-.006.005-.01.006-.016h-.06a.218.218 0 01-.22-.219v-.109c0-.121.098-.219.22-.219zm-10.264.002c.426.02 1.278.202 1.295 1.35.025 1.576-1.502 1.398-1.502 1.398h-.81a.218.218 0 01-.219-.218v-.07c0-.122.098-.22.219-.22h.062l.014-1.726h-.068a.218.218 0 01-.22-.219v-.07c0-.121.099-.219.22-.219.34 0 .673.007 1.01-.006zm1.725 0h.746c.121 0 .219.098.219.219v.088a.218.218 0 01-.219.219h-.08l.004 1.414c-.002.211.176.343.47.347.253.005.468-.132.471-.353v-1.404h-.074a.218.218 0 01-.219-.22v-.087c0-.121.098-.219.22-.219h.743c.122 0 .22.098.22.219v.088a.218.218 0 01-.22.218h-.08l-.004 1.29c0 .494-.24 1.015-1.062 1.015-.765 0-1.09-.457-1.076-1.021l-.006-1.287h-.053a.218.218 0 01-.219-.22v-.087c0-.121.098-.219.22-.219zm4.266.006h.816c.121 0 .219.098.219.219v.076a.218.218 0 01-.219.219h-.074l.017 2.16c-.014.053-.04.086-.123.105a.928.928 0 01-.308.006c-.09-.03-.14-.089-.194-.15l-.96-1.617.01 1.22h.212c.121 0 .219.098.219.22v.075a.218.218 0 01-.219.22h-.816a.218.218 0 01-.219-.22v-.076c0-.12.098-.218.219-.218h.043l.01-1.74h-.036a.218.218 0 01-.218-.22v-.054c0-.122.097-.22.218-.22h.5c.122 0 .158.054.246.22l.852 1.515.012-1.226h-.207a.218.218 0 01-.22-.219v-.076c0-.121.098-.219.22-.219zm11.25 0h.816c.121 0 .219.098.219.219v.076a.218.218 0 01-.219.219h-.074l.017 2.16c-.014.053-.04.086-.123.105a.928.928 0 01-.308.006c-.09-.03-.14-.089-.194-.15l-.96-1.617.01 1.22h.212c.121 0 .219.098.219.22v.075a.218.218 0 01-.219.22h-.816a.218.218 0 01-.219-.22v-.076c0-.12.098-.218.219-.218h.043l.01-1.74h-.036a.218.218 0 01-.218-.22v-.054c0-.121.097-.219.218-.219h.5c.122 0 .158.053.247.219L21 19.279l.012-1.226h-.207a.218.218 0 01-.22-.219v-.076c0-.121.098-.219.22-.219zm-3.768 1.377c0 .5.285.904.635.904.35 0 .634-.404.635-.904 0-.5-.284-.906-.635-.906-.39 0-.632.503-.635.906zm-13.783-.869l.006 1.707c.347-.026.924.007.922-.861-.003-.84-.673-.856-.928-.846z",source:"https://commons.wikimedia.org/wiki/File:AI_Dungeon_Logo.png",hex:"000000",guidelines:void 0,license:void 0},siAiqfome={title:"Aiqfome",slug:"aiqfome",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Aiqfome</title><path d="'+this.path+'"/></svg>'},path:"M5.748 9.195c.607.277.992 1.139 1.04 2.342.033.797-.06 1.399-.303 1.925-.564 1.209-1.578 1.252-2.163.092-.25-.488-.358-1.025-.358-1.778.006-.803.092-1.274.347-1.795.363-.742.895-1.035 1.437-.786zm9.768.076c.591.39.998 1.627.916 2.776-.092 1.371-.699 2.358-1.436 2.358-.407 0-.824-.358-1.095-.943-.45-.976-.423-2.613.065-3.567.363-.716 1.024-.981 1.55-.624zM12.388.029c.223.032.255.06.38.292.184.336.298.456.64.678.314.2.314.211.206.726-.093.434-.039.862.162 1.247.293.58 1.111 1.187 1.86 1.377.281.076.395.081.737.022.222-.033.439-.049.482-.033.049.022.163.2.26.401.217.467.76 1.025 1.193 1.226.705.33 1.47.314 2.206-.05.206-.102.412-.167.461-.151.043.016.168.14.276.271.109.136.326.309.478.385.249.13.341.146.753.14.325-.005.488.012.526.06.157.19.59 2.201.775 3.584.163 1.241.179 4.017.027 5.23-.2 1.644-.498 3.053-.91 4.321-.293.9-.553 1.491-1.09 2.456C20.997 23.675 20.682 24 20.086 24a2.01 2.01 0 0 1-.493-.06c-.353-.119-.895-.536-1.73-1.328-.986-.932-1.404-1.257-1.924-1.512-.634-.315-1.258-.342-1.8-.076-.13.065-.498.358-.807.656-.65.618-.9.753-1.47.791-.704.044-1.1-.135-2.206-.992-.471-.363-.818-.526-1.203-.558-.466-.038-.808.081-1.561.537-.743.45-1.139.59-1.654.59-1.073 0-2.006-.66-2.965-2.097C1.205 18.34.424 16.09.17 13.863c-.098-.84-.114-2.537-.033-3.367.428-4.266 2.494-7.53 5.828-9.193C7.005.783 8.149.419 9.455.197c.976-.163 2.413-.244 2.933-.168zm-2.239 1.48C7.64 1.758 5.2 3.113 3.731 5.065c-1.529 2.033-2.38 5.399-2.07 8.19.2 1.85.964 3.947 1.989 5.487.52.78.72.997 1.084 1.176.553.271 1.122.174 1.827-.309.629-.434 1.28-.623 1.978-.585.71.043.982.184 2.055 1.1.634.542 1.182.602 1.794.195.136-.092.44-.325.678-.52.764-.634 1.35-.857 2.277-.862 1.16-.006 1.913.428 2.981 1.73.868 1.05 1.204 1.268 1.68 1.089.781-.298 1.567-2.082 2.082-4.716.683-3.48.553-6.522-.352-8.37-.293-.608-.645-.998-.976-1.095-.206-.06-.27-.055-.704.086-.418.136-.564.158-1.106.158-.51 0-.689-.028-.992-.13-.58-.196-.84-.434-1.486-1.356-.298-.428-.558-.569-1.263-.71-1.3-.25-1.832-.477-2.293-.976-.434-.466-.71-1.09-.91-2.054-.055-.282-.152-.591-.212-.689-.222-.357-.759-.488-1.643-.395z",source:"https://aiqfome.com",hex:"7A1FA2",guidelines:void 0,license:void 0},siAiohttp={title:"AIOHTTP",slug:"aiohttp",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AIOHTTP</title><path d="'+this.path+'"/></svg>'},path:"M0 12C.01 5.377 5.377.01 12 0c6.623.01 11.99 5.377 12 12-.01 6.623-5.377 11.99-12 12C5.377 23.99.01 18.623 0 12zm12 11.004a10.948 10.948 0 0 0 6.81-2.367l-.303-.656a.746.746 0 0 1-.621-1.347l-.722-1.563a1.244 1.244 0 0 1-1.543-.734l-2.474.633v.012a.747.747 0 1 1-1.475-.178L8.2 15.31a1.244 1.244 0 0 1-1.278.607l-.748 2.59a.747.747 0 0 1-.17 1.388l.052 1.36A10.935 10.935 0 0 0 12 23.003zM5.75 21.05l-.044-1.142a.747.747 0 0 1 .18-1.482l.749-2.59a1.245 1.245 0 0 1-.759-1.147l-4.674-.566A11.035 11.035 0 0 0 5.75 21.05zm13.3-.608a11.083 11.083 0 0 0 2.74-3.421l-3.826-.751a1.245 1.245 0 0 1-.528.672l.732 1.588a.747.747 0 0 1 .598 1.3l.285.612zm2.878-3.698A10.934 10.934 0 0 0 23.004 12a10.95 10.95 0 0 0-2.492-6.965L19 5.551a.749.749 0 0 1-.726.922.747.747 0 0 1-.682-.442L14.449 7.1a2.492 2.492 0 0 1-1.015 2.737l2.857 4.901a1.245 1.245 0 0 1 1.732 1.236l3.904.77zm-8.846-.068l2.465-.63a1.242 1.242 0 0 1 .486-1.157l-2.856-4.9a2.478 2.478 0 0 1-2.444-.11l-2.77 3.892a1.242 1.242 0 0 1 .354 1.263l3.483 1.497a.746.746 0 0 1 1.282.143v.002zm-7.17-2.284a1.246 1.246 0 0 1 1.81-.794l2.77-3.89a2.484 2.484 0 0 1-.93-1.94c0-.603.219-1.186.617-1.64L6.476 2.487a11.013 11.013 0 0 0-5.33 11.328l4.765.578zm8.44-7.572l3.174-1.083v-.01a.747.747 0 0 1 1.345-.448l1.433-.489A10.982 10.982 0 0 0 6.745 2.333l3.64 3.581a2.49 2.49 0 0 1 3.967.904l-.002.003z",source:"https://github.com/aio-libs/aiohttp/blob/fb5fe72b1bca3b899af579d376f5fe45745410e4/docs/aiohttp-plain.svg",hex:"2C5BB4",guidelines:void 0,license:void 0},siAircanada={title:"Air Canada",slug:"aircanada",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Air Canada</title><path d="'+this.path+'"/></svg>'},path:"M12.394 16.958c0-.789.338-.902 1.127-.451a54.235 54.235 0 0 0 2.704 1.465c0-.45.451-.789 1.24-.564.789.226 1.577.338 1.577.338s-.45-1.014-.676-1.464c-.338-.789 0-1.24.338-1.352 0 0-.45-.338-.789-.564-.676-.45-.563-1.014.113-1.24.902-.45 2.141-.9 2.141-.9-.338-.226-.789-.79-.338-1.578.45-.676 1.24-1.69 1.24-1.69H18.93c-.79 0-1.015-.676-1.015-1.127 0 0-1.239.901-2.14 1.465-.79.563-1.465 0-1.352-.902a37 37 0 0 0 .338-2.93c-.451.451-1.24.339-1.69-.337-.564-1.127-1.127-2.48-1.127-2.48S11.38 4 10.817 5.128c-.338.676-1.127.788-1.578.45a37 37 0 0 0 .338 2.93c.113.789-.563 1.352-1.352.789-.901-.564-2.253-1.465-2.253-1.465 0 .45-.226 1.014-1.014 1.127H2.817s.789 1.014 1.24 1.69c.45.676 0 1.352-.339 1.577 0 0 1.127.564 2.141.902.676.338.902.788.113 1.24-.226.225-.789.563-.789.563.45.112.789.563.45 1.352-.225.45-.675 1.464-.675 1.464s.788-.225 1.577-.338c.789-.225 1.127.226 1.24.564 0 0 1.352-.789 2.704-1.465.676-.45 1.127-.225 1.127.45v1.916c0 1.127-.226 2.254-.564 2.93-5.07-.564-9.352-4.62-9.352-10.028 0-5.521 4.62-10.029 10.366-10.029 5.747 0 10.367 4.508 10.367 10.029 0 5.183-4.057 9.464-9.24 10.028v1.352C19.268 22.592 24 17.746 24 11.775 24 5.352 18.592.282 11.944.282 5.408.282 0 5.352 0 11.662c0 5.521 4.169 10.14 9.69 11.155.902.225 1.465.338 2.028.901.564-1.126.676-3.38.676-4.62Z",source:"https://www.aircanada.com/",hex:"F01428",guidelines:void 0,license:void 0},siAirasia={title:"AirAsia",slug:"airasia",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AirAsia</title><path d="'+this.path+'"/></svg>'},path:"M11.54 14.49c-1.278 0-2.264-.998-2.264-2.276 0-1.252.98-2.27 2.264-2.27 1.232 0 2.238 1.018 2.238 2.27 0 1.278-1.005 2.277-2.239 2.277zm3.074-7.854l-.214.998c-.59-1.18-2.348-1.297-3.295-1.297-2.952 0-5.527 2.841-5.527 6.746 0 3.14 1.875 5.111 4.23 5.111 1.316 0 2.432-.304 3.353-1.4l-.24 1.102h3.711l1.692-11.26c-1.238-.001-2.482.01-3.71 0zM12 0c6.63 0 12 5.37 12 12s-5.37 12-12 12S0 18.63 0 12 5.37 0 12 0Z",source:"https://www.airasia.com/shop",hex:"FF0000",guidelines:void 0,license:void 0},siAirchina={title:"Air China",slug:"airchina",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Air China</title><path d="'+this.path+'"/></svg>'},path:"M6.75 23.377c3.431.96 7.361-1.449 7.361-5.442v-4.713c0-1.377 1.147-3.19 3.212-3.19 2.17 0 3.201 1.949 3.201 3.19 0 .792-.313 2.377-1.804 2.377-1.188 0-1.95-1.21-1.574-2.2-.083.333.093.657.449.657.343 0 .532-.324.468-.73 0-.083-.104-.834-.939-.834-.698 0-.927.636-.927.948v4.193c0 4.483-4.88 7.798-9.447 5.744M3.508 19.99s2.303 2.336 5.338.573c2.012-1.167 2.075-3.598 2.075-3.598v-5.431s-.084-2.722 2.366-4.672c1.711-1.345 3.296-1.252 4.39-1.387 2.806-.344 4.057-2.116 4.057-2.116.031.302-.272 3.555-3.785 4.483-.72.188-4.578-.187-4.578 4.275v5.38c0 1.126-.27 3.118-2.377 4.526-2.169 1.439-5.683 1.21-7.486-2.033M1.047 8.759H3.85c0-.5.428-1.471 1.523-1.471.427 0 .5.095 1.052-.02.72-.24 1.043-.657 1.19-.99 0 0 .28 1.187-.845 1.813-.637.345-1.616.074-1.616.074s-.792-.115-.897.593c.449 0 1.147.449 1.147 1.22v6.528c0 .469.375.96.949.96a.95.95 0 0 0 .949-.96v-4.578c0-6.757 5.255-9.56 8.31-9.79 2.533-.188 4.244.04 7.34-2.138 0 0-.97 3.796-5.358 4.703-.804.166-3.224-.115-5.497 2.252-1.803 1.877-1.99 3.608-1.99 5.891v4.035c0 1.762-1.419 3.545-3.587 3.545-2.096 0-3.566-1.668-3.566-3.545v-6.85c0-.563-.406-1.074-1.054-1.074h-.854Z",source:"http://www.airchina.com.cn/en/investor_relations/",hex:"E30E17",guidelines:void 0,license:void 0},siAirbnb={title:"Airbnb",slug:"airbnb",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Airbnb</title><path d="'+this.path+'"/></svg>'},path:"M12.001 18.275c-1.353-1.697-2.148-3.184-2.413-4.457-.263-1.027-.16-1.848.291-2.465.477-.71 1.188-1.056 2.121-1.056s1.643.345 2.12 1.063c.446.61.558 1.432.286 2.465-.291 1.298-1.085 2.785-2.412 4.458zm9.601 1.14c-.185 1.246-1.034 2.28-2.2 2.783-2.253.98-4.483-.583-6.392-2.704 3.157-3.951 3.74-7.028 2.385-9.018-.795-1.14-1.933-1.695-3.394-1.695-2.944 0-4.563 2.49-3.927 5.382.37 1.565 1.352 3.343 2.917 5.332-.98 1.085-1.91 1.856-2.732 2.333-.636.344-1.245.558-1.828.609-2.679.399-4.778-2.2-3.825-4.88.132-.345.395-.98.845-1.961l.025-.053c1.464-3.178 3.242-6.79 5.285-10.795l.053-.132.58-1.116c.45-.822.635-1.19 1.351-1.643.346-.21.77-.315 1.246-.315.954 0 1.698.558 2.016 1.007.158.239.345.557.582.953l.558 1.089.08.159c2.041 4.004 3.821 7.608 5.279 10.794l.026.025.533 1.22.318.764c.243.613.294 1.222.213 1.858zm1.22-2.39c-.186-.583-.505-1.271-.9-2.094v-.03c-1.889-4.006-3.642-7.608-5.307-10.844l-.111-.163C15.317 1.461 14.468 0 12.001 0c-2.44 0-3.476 1.695-4.535 3.898l-.081.16c-1.669 3.236-3.421 6.843-5.303 10.847v.053l-.559 1.22c-.21.504-.317.768-.345.847C-.172 20.74 2.611 24 5.98 24c.027 0 .132 0 .265-.027h.372c1.75-.213 3.554-1.325 5.384-3.317 1.829 1.989 3.635 3.104 5.382 3.317h.372c.133.027.239.027.265.027 3.37.003 6.152-3.261 4.802-6.975z",source:"https://www.airbnb.com",hex:"FF5A5F",guidelines:void 0,license:void 0},siAirfrance={title:"Air France",slug:"airfrance",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Air France</title><path d="'+this.path+'"/></svg>'},path:"M13.776 3.9L5.184 16.332C4.051 17.969 2.208 19.548 0 19.721v.379h9.552c2.544 0 4.397-1.656 5.616-3.48L24 3.9Z",source:"https://www.airfrance.fr/",hex:"002157",guidelines:void 0,license:void 0},siAirbus={title:"Airbus",slug:"airbus",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Airbus</title><path d="'+this.path+'"/></svg>'},path:"M11.062 11.294c0 .74-.389 1.162-.993 1.305-.007 0 .967 1.53.967 1.53h-1.18L8.43 11.853h1.006c.435 0 .597-.24.597-.532 0-.285-.156-.532-.59-.532H8.266v3.342H7.228V9.867h2.206c1.096 0 1.628.616 1.628 1.427M5.49 14.13h1.038V9.867H5.49zM2.174 9.867L0 14.13h1.168l.352-.714h1.75l-.435-.895h-.873l.646-1.312h.013l1.453 2.92h1.194L3.095 9.868zm12.679 2.05c.409.144.688.52.688 1.02 0 .72-.577 1.194-1.46 1.194h-2.525V9.867h2.428c.863 0 1.376.461 1.376 1.148-.001.428-.176.72-.507.902m-2.258-.396h1.382a.368.368 0 00.376-.376.367.367 0 00-.37-.376h-1.388zm1.414 1.714a.435.435 0 00.448-.441c0-.247-.195-.428-.448-.428h-1.414v.869h1.414m4.808-.986c0 .647-.298 1.006-.89 1.006-.583 0-.881-.36-.881-1.006V9.867h-1.064v2.304c0 1.317.694 2.05 1.946 2.05s1.953-.733 1.953-2.05V9.867h-1.064zm3.834-.689c-.985-.24-1.2-.263-1.2-.545 0-.218.246-.324.662-.324.55 0 1.139.138 1.473.344l.331-.869c-.428-.227-1.058-.389-1.791-.389-1.097 0-1.713.545-1.713 1.278 0 .79.46 1.11 1.518 1.338.824.182.999.295.999.526 0 .25-.227.363-.675.363a3.565 3.565 0 01-1.706-.415l-.318.908c.513.273 1.278.448 2.05.448 1.077 0 1.719-.5 1.719-1.337.001-.673-.433-1.105-1.35-1.326",source:"https://brand.airbus.com/brand-elements/logo.html",hex:"00205B",guidelines:void 0,license:void 0},siAdobephotoshop={title:"Adobe Photoshop",slug:"adobephotoshop",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Adobe Photoshop</title><path d="'+this.path+'"/></svg>'},path:"M9.85 8.42c-.37-.15-.77-.21-1.18-.2-.26 0-.49 0-.68.01-.2-.01-.34 0-.41.01v3.36c.14.01.27.02.39.02h.53c.39 0 .78-.06 1.15-.18.32-.09.6-.28.82-.53.21-.25.31-.59.31-1.03.01-.31-.07-.62-.23-.89-.17-.26-.41-.46-.7-.57zM19.75.3H4.25C1.9.3 0 2.2 0 4.55v14.899c0 2.35 1.9 4.25 4.25 4.25h15.5c2.35 0 4.25-1.9 4.25-4.25V4.55C24 2.2 22.1.3 19.75.3zm-7.391 11.65c-.399.56-.959.98-1.609 1.22-.68.25-1.43.34-2.25.34-.24 0-.4 0-.5-.01s-.24-.01-.43-.01v3.209c.01.07-.04.131-.11.141H5.52c-.08 0-.12-.041-.12-.131V6.42c0-.07.03-.11.1-.11.17 0 .33 0 .56-.01.24-.01.49-.01.76-.02s.56-.01.87-.02c.31-.01.61-.01.91-.01.82 0 1.5.1 2.06.31.5.17.96.45 1.34.82.32.32.57.71.73 1.14.149.42.229.85.229 1.3.001.86-.199 1.57-.6 2.13zm7.091 3.89c-.28.4-.671.709-1.12.891-.49.209-1.09.318-1.811.318-.459 0-.91-.039-1.359-.129-.35-.061-.7-.17-1.02-.32-.07-.039-.121-.109-.111-.189v-1.74c0-.029.011-.07.041-.09.029-.02.06-.01.09.01.39.23.8.391 1.24.49.379.1.779.15 1.18.15.38 0 .65-.051.83-.141.16-.07.27-.24.27-.42 0-.141-.08-.27-.24-.4-.16-.129-.489-.279-.979-.471-.51-.18-.979-.42-1.42-.719-.31-.221-.569-.51-.761-.85-.159-.32-.239-.67-.229-1.021 0-.43.12-.84.341-1.21.25-.4.619-.72 1.049-.92.469-.239 1.059-.349 1.769-.349.41 0 .83.03 1.24.09.3.04.59.12.86.23.039.01.08.05.1.09.01.04.02.08.02.12v1.63c0 .04-.02.08-.05.1-.09.02-.14.02-.18 0-.3-.16-.62-.27-.96-.34-.37-.08-.74-.13-1.12-.13-.2-.01-.41.02-.601.07-.129.03-.24.1-.31.2-.05.08-.08.18-.08.27s.04.18.101.26c.09.11.209.2.34.27.229.12.47.23.709.33.541.18 1.061.43 1.541.73.33.209.6.49.789.83.16.318.24.67.23 1.029.011.471-.129.94-.389 1.331z",source:"https://www.adobe.com/products/photoshop.html",hex:"31A8FF",guidelines:void 0,license:void 0},siApachedruid={title:"Apache Druid",slug:"apachedruid",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache Druid</title><path d="'+this.path+'"/></svg>'},path:"M8.932 20.806c-.369 0-.738.007-1.109 0-.35-.007-.587-.206-.623-.5a.587.587 0 0 1 .53-.636c.79-.062 1.582-.063 2.372-.003a.548.548 0 0 1 .522.602c-.024.326-.253.526-.616.54zM1.792 8.345c-.392 0-.782.008-1.173.002-.327-.006-.577-.22-.614-.512-.037-.293.146-.544.499-.615.192-.032.388-.045.583-.039a81.515 81.515 0 0 1 1.597 0c.163 0 .325.019.483.056.288.073.445.318.411.617-.034.298-.214.477-.515.487-.424.014-.848.004-1.272.004zm7.588 8.417H4.292a2.464 2.464 0 0 1-.326-.007c-.294-.04-.48-.209-.508-.506-.029-.298.11-.501.391-.606.179-.065.365-.051.549-.051 3.347 0 6.695.005 10.042-.006 1.174-.004 2.187-.439 2.993-1.3.69-.738 1.053-1.63 1.16-2.635.085-.788-.027-1.513-.516-2.156-.544-.718-1.28-1.078-2.163-1.082-3.163-.013-6.328-.005-9.487-.01-.336 0-.673-.027-1.007-.058-.29-.027-.45-.201-.469-.492-.021-.317.141-.545.429-.6a1.55 1.55 0 0 1 .29-.015h10.177c1.71.004 3.187 1.038 3.726 2.654.383 1.147.246 2.304-.182 3.416-.824 2.135-2.762 3.448-5.055 3.454-1.652.005-3.304 0-4.956 0zm2.906-13.568c1.533 0 3.066-.008 4.598 0 2.935.018 5.629 1.892 6.653 4.626.442 1.181.538 2.403.412 3.657-.185 1.842-.735 3.552-1.776 5.084-1.608 2.365-3.873 3.68-6.679 4.118-.95.148-1.905.13-2.86.13-.397 0-.61-.181-.633-.51-.025-.351.196-.621.587-.645.434-.026.87-.004 1.305-.016 2.641-.072 4.928-.982 6.74-2.935 1.269-1.37 1.912-3.039 2.13-4.878.151-1.275.135-2.544-.37-3.752-.773-1.85-2.159-2.983-4.068-3.509-.74-.204-1.5-.243-2.26-.247-2.837-.017-5.675-.007-8.511-.007-.12 0-.24.004-.359-.006a.57.57 0 0 1-.517-.536.557.557 0 0 1 .456-.557c.13-.018.261-.024.392-.019h4.762Z",source:"https://apache.org/logos/",hex:"29F1FB",guidelines:void 0,license:void 0},siAdobepremierepro={title:"Adobe Premiere Pro",slug:"adobepremierepro",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Adobe Premiere Pro</title><path d="'+this.path+'"/></svg>'},path:"M10.15 8.42a2.93 2.93 0 00-1.18-.2 13.9 13.9 0 00-1.09.02v3.36l.39.02h.53c.39 0 .78-.06 1.15-.18.32-.09.6-.28.82-.53.21-.25.31-.59.31-1.03a1.45 1.45 0 00-.93-1.46zM19.75.3H4.25A4.25 4.25 0 000 4.55v14.9c0 2.35 1.9 4.25 4.25 4.25h15.5c2.35 0 4.25-1.9 4.25-4.25V4.55C24 2.2 22.1.3 19.75.3zm-7.09 11.65c-.4.56-.96.98-1.61 1.22-.68.25-1.43.34-2.25.34l-.5-.01-.43-.01v3.21a.12.12 0 01-.11.14H5.82c-.08 0-.12-.04-.12-.13V6.42c0-.07.03-.11.1-.11l.56-.01.76-.02.87-.02.91-.01c.82 0 1.5.1 2.06.31.5.17.96.45 1.34.82.32.32.57.71.73 1.14.15.42.23.85.23 1.3 0 .86-.2 1.57-.6 2.13zm6.82-3.15v1.95c0 .08-.05.11-.16.11a4.35 4.35 0 00-1.92.37c-.19.09-.37.21-.51.37v5.1c0 .1-.04.14-.13.14h-1.97a.14.14 0 01-.16-.12v-5.58l-.01-.75-.02-.78c0-.23-.02-.45-.04-.68a.1.1 0 01.07-.11h1.78c.1 0 .18.07.2.16a3.03 3.03 0 01.13.92c.3-.35.67-.64 1.08-.86a3.1 3.1 0 011.52-.39c.07-.01.13.04.14.11v.04z",source:"https://www.adobe.com/ie/products/premiere.html",hex:"9999FF",guidelines:void 0,license:void 0},siAnilist={title:"AniList",slug:"anilist",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AniList</title><path d="'+this.path+'"/></svg>'},path:"M6.361 2.943L0 21.056h4.942l1.077-3.133H11.4l1.052 3.133H22.9c.71 0 1.1-.392 1.1-1.101V17.53c0-.71-.39-1.101-1.1-1.101h-6.483V4.045c0-.71-.392-1.102-1.101-1.102h-2.422c-.71 0-1.101.392-1.101 1.102v1.064l-.758-2.166zm2.324 5.948l1.688 5.018H7.144z",source:"https://anilist.co/img/icons/icon.svg",hex:"02A9FF",guidelines:void 0,license:void 0},siAnsible={title:"Ansible",slug:"ansible",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Ansible</title><path d="'+this.path+'"/></svg>'},path:"M10.617 11.473l4.686 3.695-3.102-7.662zM12 0C5.371 0 0 5.371 0 12s5.371 12 12 12 12-5.371 12-12S18.629 0 12 0zm5.797 17.305c-.011.471-.403.842-.875.83-.236 0-.416-.09-.664-.293l-6.19-5-2.079 5.203H6.191L11.438 5.44c.124-.314.427-.52.764-.506.326-.014.63.189.742.506l4.774 11.494c.045.111.08.234.08.348-.001.009-.001.009-.001.023z",source:"https://www.ansible.com/logos",hex:"EE0000",guidelines:void 0,license:void 0},siAntena3={title:"Antena 3",slug:"antena3",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Antena 3</title><path d="'+this.path+'"/></svg>'},path:"M12.997 10.755a7.222 7.222 0 00-.997-.083c-.111 0-.497.008-.998.083-2.919.438-4.948 2.08-6.201 4.695-.641 1.336-.357 2.255.8 3.166.068.054.137.106.205.158.213.143.423.28.627.414 3.026 1.975 4.133 2.676 4.58 2.881.186.085.512.244.962.255h.048c.45-.011.777-.17.963-.255.446-.205 1.553-.907 4.579-2.882.205-.134.415-.272.629-.415a22.7 22.7 0 00.203-.156c1.157-.911 1.441-1.83.8-3.166-1.251-2.614-3.281-4.257-6.2-4.695zm7.252 4.36c.637.774 1.205.834 1.843.387.85-.597 1.894-2.857 1.908-4.724-.05-5.112-5.337-8.666-10.648-9.093-.212-.02-.534-.026-.777.153-.247.182-.292.457-.113.812.305.603.708 1.147 1.092 1.7 1.928 2.77 3.56 5.72 5.298 8.607.442.734.85 1.492 1.397 2.157zM5.148 12.956c1.738-2.886 3.37-5.837 5.297-8.607.385-.553.787-1.097 1.092-1.7.18-.355.135-.63-.113-.812-.243-.18-.565-.173-.777-.153C5.337 2.112.05 5.665 0 10.778c.013 1.867 1.057 4.128 1.908 4.724.638.447 1.206.387 1.843-.388.546-.665.954-1.423 1.397-2.157Z",source:"https://www.antena3.com/",hex:"FF7328",guidelines:void 0,license:void 0},siAnydesk={title:"AnyDesk",slug:"anydesk",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AnyDesk</title><path d="'+this.path+'"/></svg>'},path:"M8.322 3.677L0 12l8.322 8.323L16.645 12zm7.371.01l-1.849 1.85 6.49 6.456-6.49 6.49 1.85 1.817L24 11.993Z",source:"https://anydesk.com/",hex:"EF443B",guidelines:void 0,license:void 0},siAol={title:"AOL",slug:"aol",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AOL</title><path d="'+this.path+'"/></svg>'},path:"M13.07 9.334c2.526 0 3.74 1.997 3.74 3.706 0 1.709-1.214 3.706-3.74 3.706-2.527 0-3.74-1.997-3.74-3.706 0-1.709 1.213-3.706 3.74-3.706m0 5.465c.9 0 1.663-.741 1.663-1.759 0-1.018-.763-1.759-1.663-1.759s-1.664.741-1.664 1.759c0 1.018.764 1.76 1.664 1.76m4.913-7.546h2.104v9.298h-2.104zm4.618 6.567a1.398 1.398 0 1 0 .002 2.796 1.398 1.398 0 0 0-.002-2.796M5.536 7.254H3.662L0 16.55h2.482l.49-1.343h3.23l.452 1.343H9.16zm-1.91 6.068L4.6 10.08l.974 3.242H3.626z",source:"https://www.aol.com/",hex:"3399FF",guidelines:"https://styleguide.aol.com/",license:void 0},siApache={title:"Apache",slug:"apache",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache</title><path d="'+this.path+'"/></svg>'},path:"M17.805 2.197v.066h.156v.44h.072v-.44h.156v-.066zm.9 0l-.175.353-.172-.353h-.087v.506h.067V2.3l.172.35h.045l.172-.35v.404h.066v-.506zm-4.257 1c-.204.31-.424.66-.66 1.06l-.04.062a44.457 44.457 0 00-1.265 2.29c-.187.36-.38.742-.577 1.146l2.267-.25c.66-.302.955-.578 1.242-.976a15.5 15.5 0 00.23-.342c.23-.363.46-.763.663-1.16.197-.386.37-.767.505-1.11.083-.22.15-.422.198-.6.042-.158.074-.307.1-.45-.884.15-1.965.295-2.668.33zM11.894 7.78l-.077.16c-.078.16-.157.32-.236.488-.086.18-.172.364-.26.552l-.132.287a75.265 75.265 0 00-1.427 3.3c-.163.397-.327.807-.493 1.23-.15.38-.297.765-.45 1.164l-.02.06c-.15.396-.3.802-.453 1.22l-.01.027.72-.08a.213.213 0 01-.042-.006c.863-.106 2.01-.75 2.75-1.547.342-.367.652-.8.94-1.306.213-.377.413-.795.604-1.258.168-.405.328-.843.48-1.318-.196.105-.423.18-.673.235a2.184 2.184 0 01-.273.046c.806-.31 1.314-.905 1.683-1.64a2.816 2.816 0 01-.968.428c-.06.012-.116.022-.174.03l-.043.006h.002c.278-.118.514-.248.718-.403a2.571 2.571 0 00.637-.698l.063-.104.077-.154a8.107 8.107 0 00.367-.85l.03-.088a3.04 3.04 0 00.123-.463.733.733 0 01-.094.065c-.243.145-.66.277-.996.34l.663-.074-.664.073h-.017l-.1.017c.006-.003.01-.006.017-.008l-2.265.25-.013.022zM8.27 16.45c-.117.323-.236.654-.355.992l-.005.015c-.016.046-.032.094-.05.142-.08.227-.15.432-.31.9.264.12.475.435.675.793a1.44 1.44 0 00-.466-.99c1.293.06 2.41-.27 2.99-1.217.05-.084.096-.173.14-.268-.26.333-.59.474-1.2.44 0 0-.004 0-.005.002l.004-.002c.9-.404 1.354-.79 1.754-1.433.094-.153.186-.32.28-.503-.788.81-1.702 1.04-2.664.865l-.72.078a6.43 6.43 0 00-.067.183zM15.42.112c-.376.222-1 .85-1.748 1.763l.686 1.294c.48-.687.97-1.307 1.462-1.836l.058-.062c-.02.02-.04.04-.057.062-.16.176-.644.74-1.375 1.863.703-.035 1.784-.18 2.666-.33.262-1.47-.258-2.142-.258-2.142s-.66-1.07-1.436-.61zm-3.084 6.402a40.253 40.253 0 011.306-2.26l.04-.064c.224-.352.45-.693.677-1.02l-.685-1.293-.157.192c-.197.245-.403.51-.613.79a39.853 39.853 0 00-2.016 2.97l-.022.038.893 1.763c.19-.378.38-.752.575-1.118zm-3.73 8.32c.158-.406.319-.81.483-1.225.156-.394.32-.79.484-1.19a91.133 91.133 0 011.6-3.604l.205-.424c.12-.243.237-.485.36-.724a.125.125 0 01.02-.04l-.895-1.763-.044.07c-.207.34-.414.687-.617 1.042a38.056 38.056 0 00-1.092 2.04l-.094.193a24.573 24.573 0 00-1.258 3.087 18.492 18.492 0 00-.52 1.997l.896 1.77c.117-.317.24-.638.364-.963zm-1.376-.476a13.38 13.38 0 00-.234 1.692c0 .02-.004.04-.005.06-.28-.45-1.03-.888-1.026-.884.537.778.944 1.55 1.005 2.31-.29.058-.684-.027-1.14-.195.475.436.83.556.97.588-.434.03-.89.328-1.346.67.668-.27 1.21-.38 1.596-.29-.61 1.74-1.23 3.655-1.843 5.69a.538.538 0 00.364-.354c.11-.368.84-2.786 1.978-5.965l.097-.27.028-.078c.12-.332.246-.672.374-1.02l.09-.237v-.004L7.24 14.3c-.003.02-.01.04-.012.06z",source:"https://www.apache.org/foundation/press/kit/",hex:"D22128",guidelines:void 0,license:void 0},siApacheairflow={title:"Apache Airflow",slug:"apacheairflow",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache Airflow</title><path d="'+this.path+'"/></svg>'},path:"M17.195 16.822l4.002-4.102C23.55 10.308 23.934 5.154 24 .43a.396.396 0 0 0-.246-.373.392.392 0 0 0-.437.09l-6.495 6.658-4.102-4.003C10.309.45 5.154.066.43 0H.423a.397.397 0 0 0-.277.683l6.658 6.494-4.003 4.103C.45 13.692.065 18.846 0 23.57a.398.398 0 0 0 .683.282l6.494-6.657 3.934 3.837.17.165c2.41 2.353 7.565 2.737 12.288 2.803h.006a.397.397 0 0 0 .277-.683l-6.657-6.495zm-.409-9.476c.04.115.05.24.031.344-.17.96-1.593 2.538-4.304 3.87a.597.597 0 0 0-.08-.079c1.432-3.155 1.828-5.61 1.175-7.322l3.058 2.984.12.203zm-.131 9.44a.73.73 0 0 1-.347.031c-.96-.171-2.537-1.594-3.87-4.307a.656.656 0 0 0 .08-.078l-.001.001c3.155 1.432 5.61 1.83 7.324 1.174l-2.969 3.043M23.568.392a.05.05 0 0 1 .052-.011c.018.006.03.024.029.043-.065 4.655-.437 9.726-2.703 12.05-1.53 1.565-4.326 1.419-8.283-.377.006-.037.021-.07.02-.108 0-.044-.017-.082-.026-.123 2.83-1.39 4.315-3.037 4.506-4.115.057-.322-.009-.542-.102-.688l6.507-6.67V.392zM.393.43A.045.045 0 0 1 .382.38C.39.36.403.343.425.35c4.655.065 9.727.438 12.05 2.703l.002.002c1.56 1.527 1.415 4.323-.379 8.28-.033-.005-.062-.02-.097-.02h-.008c-.045.001-.084.019-.126.027-1.39-2.83-3.037-4.314-4.115-4.506-.323-.057-.542.01-.688.103L.393.43zm11.94 11.563a.331.331 0 0 1-.327.335H12a.332.332 0 0 1-.004-.661c.172.016.333.144.335.326h.002zm-5.12 4.661a.722.722 0 0 1-.03-.345c.17-.96 1.595-2.54 4.309-3.873.013.016.019.035.033.05.013.012.03.017.044.028-1.434 3.158-1.83 5.613-1.177 7.326l-3.041-2.967m-.006-9.659a.735.735 0 0 1 .345-.031c.961.17 2.54 1.594 3.871 4.306a.597.597 0 0 0-.079.08c-2.167-.983-4.007-1.484-5.498-1.484-.68 0-1.289.103-1.825.308L7.128 7.35M.43 23.607c-.018.018-.038.015-.052.01-.019-.007-.028-.021-.028-.043.065-4.654.437-9.725 2.703-12.049 1.527-1.565 4.325-1.419 8.286.378-.006.035-.02.067-.02.104 0 .043.018.083.026.124-2.831 1.391-4.317 3.04-4.51 4.117-.057.322.01.542.103.688L.43 23.607zm23.144.042c-4.655-.065-9.726-.437-12.05-2.703l-.005-.006c-1.56-1.526-1.412-4.322.383-8.279.033.005.064.02.098.02h.009c.043 0 .08-.018.122-.027 1.39 2.832 3.036 4.317 4.115 4.51.083.014.16.021.23.021a.776.776 0 0 0 .45-.133l6.68 6.516c.02.02.016.04.01.052a.042.042 0 0 1-.042.029z",source:"https://apache.org/logos/",hex:"017CEE",guidelines:void 0,license:void 0},siApacheant={title:"Apache Ant",slug:"apacheant",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache Ant</title><path d="'+this.path+'"/></svg>'},path:"M4.006 17.292c-.245.167-.534.36-.618.445-.148.147-.322.455-.452.643-.129.187-.486.268-.687.16-.2-.107-.12-.08.12-.147.163-.045.882-.646 1.401-1.101h.236zm2.434-5.4c-.23-.013-.444-.003-.589.047-.428.147-1.352.696-1.5 1.03-.12.276-.25.515-.263.815a1.386 1.386 0 0 0-.05.122l2.402-2.014zm17.41 1.711s-.309-.312-.576-.432c-.268-.121-.255-.242-.415-.255a2.398 2.398 0 0 1-.697-.174c-.24-.107-.923-.388-1.218-.549a4.102 4.102 0 0 1-.563-.348c-.08-.067-.214-.058-.468-.018 0 0-.724.165-.978.285-.14.067-.378.194-.579.309l.072.167c.08-.062.174-.121.28-.167.334-.148.655-.282 1.03-.309.375-.026.429-.053.429-.053s.174-.027.375.08c.2.107 1.393.71 1.567.777.174.067.442.188.63.335.186.147.334.134.334.134s.134.147.335.281c.2.134.267.2.388.228.12.026.362.151.054-.29zm-8.087 5.291c-.268-.093-.616-.32-.657-.388-.04-.067-.16-.12-.16-.12s-.359-.421-.573-.836c0 0-.043-.104-.11-.258h-.255c.193.23.436.567.668.86.255.322.11.354.19.354s.026.054.093.12c.067.068.429.282.523.349.093.067.482.2.535.16.054-.04.08-.173.08-.173s-.067.026-.334-.068zm-2.43-5.217a1.1 1.1 0 0 0 .058-.078c.197-.296.425-.53.54-.78.042.011.086.02.128.022.01.251.127.45.216.61.06.113.208.243.367.362a2.133 2.133 0 0 0-.249.053s-1.089.22-1.29.327c-.202.107-.37.248-.498.207-.128-.042.213-.16.509-.383a.562.562 0 0 0 .219-.34m.73-1.842a1.235 1.235 0 0 0-.279.075 1.198 1.198 0 0 0-.367-.333c.048-.107.101-.24.188-.362.134-.187.268-.187.308-.04.025.089.097.415.15.66m2.007 1.235c.134.016.134.05.268.25.134.201.167.469.067.57-.1.1-.218.133-.502-.252-.285-.385-.006-.59.167-.568m-7.527-2.685a9.952 9.952 0 0 0-.688.452l7.131-5.98h.086l3.24 7.59a2.985 2.985 0 0 0-.301.188s-.106 0-.146.05l-.015-.01c-.067-.04-.495-.455-.495-.455-.215-.188-.577-.576-.804-.764-.228-.187-1.145-.478-1.526-.441-.358.034-.526.267-.618.495a2.4 2.4 0 0 0-.24-.361l-.294-.349s-.241 0-.482.161c-.146.097-.351.318-.49.476a.432.432 0 0 0-.26.073c-.174.147-1.165.844-1.205 1.018-.025.108-.066.18-.119.22a.374.374 0 0 0-.417-.073l-.036.016c-.025-.483-.092-1.748-.125-1.877-.04-.16-.12-.281-.254-.214-.134.066-.255.254-.255.455 0 .2.08.308.108.388.022.067.044 1.06.09 1.448-.176.098-.338.219-.385.36-.094.281-.08.388-.16.469a.288.288 0 0 1-.045.033c-.058-.055-.125-.11-.177-.163-.028-.122-.036-.26.074-.325.134-.081.134-.603 0-.657l-.134-.053s.241-.898.188-1.406c-.054-.51-.108-1.045-.215-1.126-.107-.08-.335-.04-.335-.04s-.307.174-.696.402m2.852 4.888c.135 0 .228.147.228.147s-.013.255.175.308c.187.054.696-.187.816-.294.12-.107.362.16.469.388.107.228.67 1.179.87 1.406.05.057.104.122.16.193H3.817c.253-.172.524-.353.562-.407.066-.092 1.185-1.211 1.307-1.436a.673.673 0 0 0 .214-.158.594.594 0 0 0 .18-.04c.362-.147.937-.602 1.219-1.004a3.38 3.38 0 0 0 .384-.687c.15-.118.27-.202.312-.21.134-.027.348-.094.348.133 0 .228.228.723.429 1.018.2.295.468.536.468.536s-.013.12.121.134c.134.013.254-.027.281.04.065.161.348.04.482-.08.134-.121.188.08.375-.04a.543.543 0 0 0 .268-.496.283.283 0 0 0-.112-.224l.018-.017s.16.011.32-.04a.934.934 0 0 0 .002.28c.04.336.268.55.401.55m-7.097 1.54c-.088.088-.362.335-.677.608H0l3.988-3.343c-.083.366-.066.882.243 1.543 0 0 .241.147.616.107.083-.008.202-.012.335-.026-.329.428-.73.958-.884 1.11m13.78-3.896c.05-.042.155-.17.308-.295l2.05 4.8h-6.117a33.173 33.173 0 0 0-.312-.715c-.187-.415-.804-1.634-1.072-1.7a.953.953 0 0 0-.79.173c-.187.161-.267.107-.361.04-.094-.066.014-.227-.04-.455a1.699 1.699 0 0 0-.116-.326.17.17 0 0 0 .143-.116c.053-.147.04-.214.227-.187.028.004.07.007.12.008a.301.301 0 0 0-.043.114c-.006.15.114.422.291.488s.929.394 1.086.236c.158-.157.858-.54.982-.609.125-.068.354-.115.432-.098.079.017.24.6.515 1.099.276.498.23.707.41.637.18-.07.177.134.342.13.166-.006.196.11.292.295.097.186.198.414.437.452.238.038 1.185.284 1.293.226.11-.059.114-.208-.16-.268-.275-.06-.919-.063-1.062-.162-.143-.1-.179-.628-.33-.689-.15-.06-.38-.137-.409-.198-.024-.052-.563-1.007-.77-1.517.273.117.695.282.953.365.375.12 1.018.321 1.286.321.17 0 .237-.06.263-.103a.9.9 0 0 0 .045.103c.053.094.133.16.133.16s-.026.054.054.094.63.121.83.309c.201.187.483.549.51.883.026.335.24.697.347.71.108.013.228 0 .12-.455-.106-.456-.267-.817-.521-1.018-.255-.201-.911-.522-.991-.563-.08-.04-.187-.147-.228-.147-.04 0-.027-.04-.094-.268a4.004 4.004 0 0 1-.035-.132c.017-.045.08-.215.102-.444.027-.267-.094-.856-.2-1.004 0 0-.011-.094-.013-.171.033.016.066.019.093-.003M6.77 11.924a4.581 4.581 0 0 0-.189-.02l.764-.642c-.114.167-.544.623-.544.623l-.03.04m2.44 1.915c.09.09.165.314.242.422-.056.177-.072.26.093.315.201.067.375-.027.375-.027s.025.029.065.064c-.167.097-.324.206-.373.27-.08.108-.174.054-.174.054s-.321-.535-.455-1.031a1.886 1.886 0 0 0-.053-.166c.106.022.204.023.28.099m-.051-3.63c.12-.067.228-.04.201.16-.027.202-.16 1.019-.174 1.327-.013.307.013.937.013.937s-.167.116-.148.247c-.05-.01-.088-.015-.106-.02-.054-.013.107-.548-.094-.682-.2-.134-.576.013-.71.08-.108.054-.313.09-.387.103a.384.384 0 0 0-.188-.25c-.099-.05-.331-.112-.6-.159l.425-.457s.322-.027.55-.188c.227-.16 1.098-1.031 1.218-1.098m-1.134 3.057c-.095.047-.185.12-.284.194a.267.267 0 0 0-.015-.13.612.612 0 0 1-.023-.25c.066.04.2.124.322.186",source:"https://apache.org/logos/",hex:"A81C7D",guidelines:void 0,license:void 0},siAffinitydesigner={title:"Affinity Designer",slug:"affinitydesigner",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Affinity Designer</title><path d="'+this.path+'"/></svg>'},path:"M10.44 0L0 18.083v5.197a.72.72 0 00.713.72h10.023L5.7 15.277 14.52 0zm5.16 0l-4.86 8.418 3.718 6.439H24V.718A.72.72 0 0023.28 0zm-5.4 9.353l-2.064 3.575a1.289 1.289 0 000 1.288c.23.4.656.64 1.117.64h4.125zm-3.122 6.44L11.816 24h11.471a.72.72 0 00.713-.718v-7.49Z",source:"https://affinity.serif.com/en-gb/designer/",hex:"1B72BE",guidelines:void 0,license:void 0},siApachecassandra={title:"Apache Cassandra",slug:"apachecassandra",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache Cassandra</title><path d="'+this.path+'"/></svg>'},path:"M17.514 5.766c-.002.003-.247.256-.387.408-.366.397-.92.975-1.312 1.12h-.004a2.28 2.28 0 00-.16-.05l.705-1.425-.008.012c-.022.043-.72 1.415-1.666 1.218l-.002.002c-.014-.003-.026.002-.04-.002.455-.58.63-1.113.63-1.113s-.756 1.213-1.69.885a.075.075 0 01-.05-.047.153.153 0 010-.08c.01-.04.04-.092.067-.14.095-.176.256-.368.256-.368s-.156.152-.366.295l-.002.002c-.157.107-.345.208-.52.236a.512.512 0 01-.167 0c-.214-.037-.208-.25-.149-.455v-.002c.06-.204.174-.4.174-.4s-.19.298-.398.588c-.16.223-.311.396-.416.474l-.12.004c-.063-.176.1-.756.1-.76a4.984 4.984 0 01-.314.446 1.73 1.73 0 01-.34.336h-.027c-.082.007-.16.02-.24.031a.208.208 0 01-.063-.125c-.042-.268.123-.756.125-.762-.002.006-.09.26-.21.502V6.6c-.032.067-.07.12-.107.178-.086.136-.176.244-.261.22-.127-.039-.202-.203-.246-.357-.044-.154-.057-.299-.057-.299s-.031.251-.117.485a.8.8 0 01-.146.265c-.024.027-.057.036-.086.055a12.553 12.553 0 00-2.617.764c-.223.082-.446.159-.674.257-.75.32-1.53.726-2.344 1.248a21.335 21.335 0 00-2.56 1.945c-.449.393-.907.82-1.377 1.29C3.887 10.735 5.3 7.908 11.964 7.656c5.045-.19 7.402 2.138 8.18 2.171 1.957.083 3.258-1.4 3.673-1.947.112-.142.179-.237.183-.244-.01.011-.328.374-.781.722l-.006.004c-.46.35-1.05.68-1.577.6h-.002c-.068-.01-.138-.007-.203-.032.744-.434 1.237-1.19 1.483-1.596.076-.125.233-.36.233-.36S21.4 8.762 20.099 8.642l-.002.002c-.051-.005-.105.007-.155-.004.567-.446.985-1.045 1.278-1.55v-.004h.002c.317-.548.482-.985.484-.992-.005.008-.326.498-.766 1.037l-.01.01c-.44.54-.998 1.122-1.464 1.3-.07.026-.14.066-.205.072 1.085-.96 1.54-2.323 1.54-2.323s-1.098 1.595-2.027 1.89c-.056.017-.114.047-.17.054.568-.513.869-.92 1.057-1.24V6.89c.238-.404.281-.65.281-.65l-.004.004a9.381 9.381 0 01-.271.334l-.016.017c-.255.3-.645.733-1.045 1.078l-.005.004a4.148 4.148 0 01-.32.248c-.03.021-.06.046-.09.065a1.7 1.7 0 01-.273.139c-.022.01-.044.022-.065.03-.068-.045-.132-.092-.205-.135-.046.06-.096.117-.142.176h-.002c-.02-.006-.044-.006-.063-.016.859-.935 1.44-2.12 1.44-2.12l-.003.004c-.008.01-1.194 1.61-1.73 1.71-.07-.035-.14-.07-.216-.103a.5.5 0 01.044-.162c.122-.284.465-.717.465-.717s-.093.07-.123.096a4.251 4.251 0 01-.304.238c-.056.04-.114.072-.172.108a1.9 1.9 0 01-.188.105.71.71 0 01-.263.086c-.043 0-.082-.005-.11-.027.453-.277 1.228-1.628 1.233-1.637zm-4.79 2.166a15.085 15.085 0 00-.914.006c-.286.01-.55.033-.817.053l-.002.002a3.41 3.41 0 00-.783.46.427.427 0 01.035.168.431.431 0 01-.047.19l.885.642.022-.014-.36-1.264.623 1.114c.02-.008.042-.014.063-.02l-.02-1.236.397 1.162.476-1.15.018 1.269c.004.002.007.006.012.008l.712-1.006-.363 1.219.008.01 1.041-.692-.758 1.05v.007l.95-.34c.013-.017.03-.03.042-.047a.394.394 0 01.396-.63c.119-.245.209-.504.268-.77a13.153 13.153 0 00-1.884-.19zm-2.508.134l-.02.002c-.309.036-.607.078-.893.125-.287.047-.562.1-.824.16l-.014.002c.115.388.294.756.531 1.08.108-.24.244-.461.402-.662a.436.436 0 01.57-.557c.077-.058.166-.1.248-.15zm4.46.092a3.184 3.184 0 01-.162.826.394.394 0 01-.328.68 3.172 3.172 0 01-.55.63l.66.034-.994.236c-.026.018-.046.042-.072.06a3.195 3.195 0 011.538.69c.32-.574.504-1.235.504-1.94 0-.535-.237-.928-.594-1.216zm-6.319.226c-.296.07-.58.147-.85.23a1.462 1.462 0 00-.212.76 3.99 3.99 0 002.357 3.64l.002-.011a3.198 3.198 0 01-.58-.79.572.572 0 01-.336-1.079 3.18 3.18 0 01.14-1.39 3.16 3.16 0 01-.52-1.36zm7.633.026c.14.41.225.842.225 1.293 0 2.44-2.203 4.419-4.921 4.419-2.718 0-4.921-1.98-4.921-4.42 0-.235.023-.467.063-.693A13.08 13.08 0 004.36 10.12c-.214.388-.318.793-.283 1.2.085.986.951 1.808 2.275 2.365l-.256-.068c-2.291-.646-4.109.503-6.096-.494.46.364.984.717 2.499.722.513.002 2.158-.08 2.461.186.303.265-1.021 1.514-1.021 1.514s2.24-1.897 2.459-1.25c.137.402-.643 1.476-.643 1.476s.784-1.06 1.364-1.287c.4-.156.735-.136 1.022.266.19.265-.91 1.553-.91 1.553s1.477-1.44 1.741-1.364c.266.076 0 1.364 0 1.364s.545-1.307.835-1.403c.398-.133-.909 3.031-.909 3.031s1.596-2.926 1.894-2.992c.51-.114.852 2.044.852 2.044s-.25-1.886.02-2.007c1.694-.767.718 3.257.718 3.257s1.11-2.73.428-3.337c1.799 1.193 1.579 3.337 1.579 3.337s.472-1.02-.855-3.53c.72-.038 1.8 1.864 1.8 1.864s-1.172-2.082-.377-2.12c1.58-.075 1.74 2.765 1.74 2.765s.474-.398-.795-3.181c.808-.518 2.765 2.575 2.765 2.575s-1.805-3.018-1.515-3.22c.29-.202 1.35.96 1.35.96s-.808-1.11-.594-1.223c.216-.114 2.363 2.207 2.363 2.207s-1.895-2.271-1.567-2.55c.328-.277 1.717.784 1.717.784s-2.134-1.4-1.717-1.618c.58-.3 2.235.72 2.235.72s-.996-.82-.832-1.02c.164-.203 2.12 1.287 2.12 1.287s-1.729-1.365-1.818-1.706c-.088-.34 1.362.115 1.362.115s-1.602-.744-1.627-.959c-.026-.214 1.06.24 1.06.24s-1.49-1.225-1.855-.228c-.084.16-.187.3-.283.45.093-.27.135-.543.11-.82a1.87 1.87 0 00-.052-.28c-.683-.367-1.702-.933-3.134-1.336zm-5.831.455a.427.427 0 01-.509.164c-.054.073-.1.152-.148.23l1.278.47c.01-.013.02-.03.032-.042zM9.5 9.26c-.094.155-.18.316-.244.489.12.128.26.235.396.343l.923-.029.002-.004zm4.187.541l-.606.463.053.002c.201-.132.383-.29.553-.465zm-4.535.291c-.002.012-.007.023-.01.035a2.88 2.88 0 00-.048.958.567.567 0 01.451.474l.938-.6c-.085-.03-.17-.06-.251-.097l-1.052-.076.638-.139a3.199 3.199 0 01-.666-.555zm.793.211c.139.086.28.16.43.223l.116-.024c0-.019.005-.037.006-.056zm3.121.68l.916.9-1.198-.466.703 1.079-1.072-.833-.012.006.346 1.28-.596-1.136-.097 1.33-.403-1.326-.47 1.263.113-1.36-.016-.008-.812 1.153.297-1.11a3.299 3.299 0 00-.793 1.19c.095.102.196.198.302.289a3.985 3.985 0 004.353-1.689 3.399 3.399 0 00-1.26-.539zm-2.436.223l-1.079.39c.001.018.01.033.01.051a.57.57 0 01-.184.42c.102.218.228.424.375.616a3.2 3.2 0 01.32-.635l-.295.239zm3.634 2.791c-.186.049-.37.097-.56.137.191-.04.374-.09.56-.136zm-1.089.235c-.114.02-.225.046-.34.063-.202.03-.39.042-.586.062.315-.033.624-.074.926-.125zm-1.35.17c-.11.008-.215.007-.324.012.11-.007.214-.003.324-.012z",source:"https://upload.wikimedia.org/wikipedia/commons/5/5e/Cassandra_logo.svg",hex:"1287B1",guidelines:void 0,license:void 0},siAircall={title:"Aircall",slug:"aircall",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Aircall</title><path d="'+this.path+'"/></svg>'},path:"M23.451 5.906a6.978 6.978 0 0 0-5.375-5.39C16.727.204 14.508 0 12 0S7.273.204 5.924.516a6.978 6.978 0 0 0-5.375 5.39C.237 7.26.034 9.485.034 12s.203 4.74.515 6.094a6.978 6.978 0 0 0 5.375 5.39C7.273 23.796 9.492 24 12 24s4.727-.204 6.076-.516a6.978 6.978 0 0 0 5.375-5.39c.311-1.354.515-3.578.515-6.094 0-2.515-.203-4.74-.515-6.094zm-5.873 12.396l-.003.001c-.428.152-1.165.283-2.102.377l-.147.014a.444.444 0 0 1-.45-.271 1.816 1.816 0 0 0-1.296-1.074c-.351-.081-.928-.134-1.58-.134s-1.229.053-1.58.134a1.817 1.817 0 0 0-1.291 1.062.466.466 0 0 1-.471.281 8 8 0 0 0-.129-.012c-.938-.094-1.676-.224-2.105-.377l-.003-.001a.76.76 0 0 1-.492-.713c0-.032.003-.066.005-.098.073-.979.666-3.272 1.552-5.89C8.5 8.609 9.559 6.187 10.037 5.714a1.029 1.029 0 0 1 .404-.26l.004-.002c.314-.106.892-.178 1.554-.178.663 0 1.241.071 1.554.178l.005.002a1.025 1.025 0 0 1 .405.26c.478.472 1.537 2.895 2.549 5.887.886 2.617 1.479 4.91 1.552 5.89.002.032.005.066.005.098a.76.76 0 0 1-.491.713z",source:"https://aircall.io/",hex:"00B388",guidelines:void 0,license:void 0},siApachecloudstack={title:"Apache CloudStack",slug:"apachecloudstack",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache CloudStack</title><path d="'+this.path+'"/></svg>'},path:"M12.446 11.386c.326-.116 1.077-.462 1.228-1.23l-1.692-.114s-.458-.161-.705-.94c0 0-1.022-.55-.951-1.342 0 0 .158-.987 1.004-1.128 0 0 .882-.218 1.062 1.192 0 0 .415 1.194-.394 1.278 0 0-.175.385.46.402 0 0 .773.23 1.32-.229 0 0 .371-.341.812-.276 0 0 .095-.169-.09-.274 0 0-1.097-.939-1.289-2.267 0 0-.905-.126-1.018-.766 0 0-.211-.992.608-1.19 0 0 .522-.119.787 0 0 0 .667-1.817 2.57-2.128 0 0 1.573-.37 2.134.82 0 0 .232.647.106 1.19 0 0-.132.594.007.746 0 0 .509-.12.72.211.211.33.304 1.038-.119 1.203 0 0 .126.562-.297.945 0 0-1.342.78-1.725 1.44 0 0-.118.151-.178.204a1.354 1.354 0 01-.516.283s-.159.07-.337-.018c0 0-.053.265.245.311 0 0 .565-.078 1.18-.266l4.443-1.59s-.206-.555-.041-.826c0 0 .091-.144.174-.175.154-.059.338-.352.346-.581 0 0-.043-.58.373-.606 0 0 .4-.024.366.465l-.029.321s.61-.23.814.185c0 0 .412.836-.025 1.51 0 0-.643.633-1.489.235l-.29-.179s-5.168 2.14-5.228 2.28c0 0-.405.205-.707.753 0 0-1.037 1.85-1.572 2.34 0 0-.35.423-.601.528l.054.146c.347.037.601-.047.601-.047.965-.462 1.105-.106 1.105-.106.352.252.204.978.204.978 2.696 2.59-.204 5.128-.204 5.128-.455.198-.669 0-.669 0-.079-.119.67-.766.67-.766 1.368-1.64.156-3.412.156-3.412-2.023-2.18-4.05-.553-4.05-.553-.912 1.018-.78 2.128-.78 2.128-.159.317-.423.185-.423.185-.357-.423 0-1.533 0-1.533.529-1.23 1.652-1.732 1.652-1.732l.169-.136c.204-.935-.134-2.062-.134-2.062-.925-2.206-2.488-2.578-3.03-2.64.008.057.006.046-.001 0-.12-.013-.189-.012-.189-.012-2.317-.22-3.379 1.789-3.379 1.789-.62.55-.581 1.815-.581 1.815 1.524.343 1.898 1.295 1.898 1.295.106.396-.348.269-.348.269C5.22 13.69 4.51 13.635 4.51 13.635c-1.44-.26-2.414.664-2.414.664-.584.405-1.102 1.281-1.102 1.281C.157 17.06.68 18.472.68 18.472c.287 1.433 1.997 2.385 1.997 2.385.814.422 1.684.297 1.684.297.708-.162.544.211.544.211-.2.3-.469.304-.469.304-1.528.101-2.216-.414-2.216-.414C-1.195 19.11.347 15.59.347 15.59c1.6-3.119 4.19-2.458 4.19-2.458.052-.939.819-2.247.819-2.247 1.14-1.42 2.416-1.726 3.181-1.764l.004-.004s-.018-1.007.29-1.862c0 0 .16-.435.723-1.286.089-.134.37-.493.458-.82 0 0 .476-1.497-1.229-1.735 0 0-.543-.096-.898.19-.225.18-.437.286-.6.33 0 0-.806.277-.78-.238 0 0-.145-.767 1.68-.978 0 0 2.23-.383 2.49 1.388 0 0 .364 1.083-.958 2.709 0 0-.722 1.118-.557 2.334.045.007.068.013.068.013 2.326.404 3.211 2.212 3.211 2.212l.007.012zm.322.648l.797 1.602c1.387-.564 1.98-2.434 1.98-2.434.38-.942-.211-1.083-.211-1.083-.406-.106-.696.3-.696.3-.91 1.104-1.671 1.519-1.87 1.615zm4.284-8.153c-1.295-1.242-2.538.343-2.538.343-.766.978.08 2.353.08 2.353-.344.08-.503.317-.503.317-.237 1.19 1.11 2.009 1.11 2.009 1.031.687 1.666-.212 1.666-.212.264-.608 1.691-1.612 1.691-1.612.476-.476 0-1.004 0-1.004-.502-.357-.581-.978-.581-.978-.04-.529.04-1.176.04-1.176-.265-.476-.965-.04-.965-.04zm-3.714 1.19c-.08-.212-.35-.146-.35-.146-.535.099-.423.7-.423.7.04.417.476.483.476.483.013-.621.297-1.038.297-1.038zm4.943.468c-.06.126.066.212.066.212.177.117.343.324.343.324.08.072.205 0 .205 0 .17-.247-.125-.536-.125-.536-.198-.198-.49 0-.49 0zm-6.159 2.333s-.132-.674-.572-.86c0 0-.318-.083-.555.19 0 0-.437.445-.291.987 0 0 .251.595.916.718 0 0 .375.115.59-.454 0 0 .055-.176-.088-.581zm9.829-.328c.099.114.158.304.158.304.013.445.627.42.627.42.688.03.933-.4.933-.4.206-.357.127-1.049-.1-1.178-.228-.13-.732 0-.732 0 .122-.238.048-.615.048-.615-.044-.406-.386-.172-.386-.172-.206.154-.106.595-.106.595-.01.28-.372.405-.372.405-.276.283-.07.64-.07.64zm-5.92-1.962c-.01.12-.149.066-.149.066-.036-.26-.377-.323-.377-.323-.357.015-.356.28-.356.28-.199.123-.242-.056-.242-.056.116-.452.589-.36.589-.36.498.03.535.393.535.393zm.758.055s.027-.37.334-.44c0 0 .446-.143.64.256 0 0 .07.162.007.207 0 0-.14.051-.181-.192 0 0-.113-.22-.336-.173 0 0-.198.021-.248.23 0 0-.01.22-.216.112zm-1.676 1.235c.102-.062.247-.009.34.047.1.062.21.12.316.17.209.099.425.162.661.162.123 0 .254.012.374-.005.1-.014.203-.025.304-.035a.991.991 0 00.359-.096c.055-.029.11-.052.164-.084.05-.031.096-.072.144-.102.023-.014.082-.058.11-.053.035.006.069.103.06.136-.068.02-.133.074-.198.105-.09.044-.173.103-.255.16-.116.08-.252.192-.326.313-.173.283-.37.572-.656.749a.917.917 0 01-.495.119c-.166 0-.376-.03-.519-.12a.61.61 0 01-.29-.356c-.044-.158 0-.317 0-.478 0-.125.033-.31-.026-.42-.02-.038-.028-.027-.062-.057-.026-.022-.04-.065-.027-.113.002-.008.014-.043.022-.042zm1.291-.515a.137.137 0 01-.14.134.137.137 0 01-.14-.134c0-.074.062-.134.14-.134.077 0 .14.06.14.134zm.575-.023a.137.137 0 01-.14.134.137.137 0 01-.14-.134c0-.074.062-.134.14-.134.077 0 .14.06.14.134z",source:"http://cloudstack.apache.org/trademark-guidelines.html",hex:"2AA5DC",guidelines:void 0,license:void 0},siApachecordova={title:"Apache Cordova",slug:"apachecordova",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache Cordova</title><path d="'+this.path+'"/></svg>'},path:"M18.545,0.545H5.455L0,9.273l2.182,14.182h3.886l-0.273-3.273h1.909l0.273,3.273 h8.045l0.273-3.273h1.909l-0.273,3.273h3.886L24,9.273L18.545,0.545z M18.545,18H5.455L4.364,9.273l2.182-4.364h3.506L9.818,6.545 h4.364l-0.234-1.636h3.506l2.182,4.364L18.545,18z M15.545,11.045c0.301,0,0.545,0.908,0.545,2.029 c0,1.121-0.244,2.029-0.545,2.029c-0.301,0-0.545-0.908-0.545-2.029C15,11.954,15.244,11.045,15.545,11.045z M8.659,11.215 c0.301,0,0.545,0.908,0.545,2.029c0,1.121-0.244,2.029-0.545,2.029c-0.301,0-0.545-0.908-0.545-2.029 C8.114,12.123,8.358,11.215,8.659,11.215z",source:"https://cordova.apache.org/artwork/",hex:"E8E8E8",guidelines:void 0,license:void 0},siApachecouchdb={title:"Apache CouchDB",slug:"apachecouchdb",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache CouchDB</title><path d="'+this.path+'"/></svg>'},path:"M19.5 14.625c0 .995-.524 1.482-1.5 1.5H6c-.976-.018-1.5-.505-1.5-1.5s.524-1.482 1.5-1.5h12c.976.018 1.5.505 1.5 1.5m-1.5 2.25H6c-.976.018-1.5.505-1.5 1.5s.524 1.482 1.5 1.5h12c.976-.018 1.5-.505 1.5-1.5s-.524-1.482-1.5-1.5m3.75-8.248v-.001c-.976.017-1.5.504-1.5 1.499v8.25c0 .995.524 1.482 1.5 1.5v-.002c1.464-.052 2.25-1.514 2.25-4.498v-3.75c0-1.99-.786-2.964-2.25-2.998m-19.5-.001C.786 8.662 0 9.637 0 11.626v3.75c0 2.984.786 4.446 2.25 4.498v.001c.976-.017 1.5-.504 1.5-1.499v-8.25c0-.995-.524-1.482-1.5-1.5m19.5-.75c0-2.486-1.31-3.705-3.75-3.748v-.002H6v.002c-2.44.043-3.75 1.262-3.75 3.748v.001c1.464.026 2.25.757 2.25 2.249s.786 2.223 2.25 2.249v.001h10.5v-.001c1.464-.026 2.25-.757 2.25-2.249s.786-2.223 2.25-2.249z",source:"https://apache.org/logos/#couchdb",hex:"E42528",guidelines:void 0,license:void 0},siAdobexd={title:"Adobe XD",slug:"adobexd",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Adobe XD</title><path d="'+this.path+'"/></svg>'},path:"M18.835.3H5.165A5.165 5.165 0 0 0 0 5.465v13.07A5.165 5.165 0 0 0 5.165 23.7h13.67A5.165 5.165 0 0 0 24 18.535V5.465A5.165 5.165 0 0 0 18.835.3zm-6.106 16.491h-2.287c-.16 0-.274-.006-.338-.113-.215-.419-.43-.835-.644-1.248a45.137 45.137 0 0 0-.684-1.264 66.961 66.961 0 0 1-.717-1.305h-.016a52.7 52.7 0 0 1-.668 1.288c-.23.429-.459.856-.684 1.28A54.85 54.85 0 0 1 6 16.693c-.044.097-.119.107-.227.107H3.568c-.043 0-.067.017-.072-.026a.166.166 0 0 1 .024-.113l3.107-5.105L3.6 6.438c-.033-.043-.038-.078-.016-.107a.115.115 0 0 1 .097-.04h2.27a.36.36 0 0 1 .145.024.292.292 0 0 1 .096.089c.193.43.408.859.644 1.288.236.429.475.853.716 1.272.241.419.464.843.668 1.272h.016c.213-.44.43-.869.652-1.288.222-.419.447-.84.676-1.264.231-.425.453-.847.668-1.264a.246.246 0 0 1 .064-.106.239.239 0 0 1 .129-.024h2.109a.093.093 0 0 1 .112.067.093.093 0 0 1-.031.094l.001.004-2.995 4.943 3.204 5.249c.021.037.026.08.016.121-.01.036-.047.012-.112.023zm7.681-.42a8.02 8.02 0 0 1-1.626.483 8.63 8.63 0 0 1-1.547.145 5.006 5.006 0 0 1-2.149-.45 3.421 3.421 0 0 1-1.506-1.361 4.348 4.348 0 0 1-.548-2.278 4.202 4.202 0 0 1 .548-2.109 4.018 4.018 0 0 1 1.595-1.545 5.139 5.139 0 0 1 2.737-.572c.086.005.188.013.306.024V5.536c0-.075.032-.113.097-.113h2.028a.086.086 0 0 1 .097.073.096.096 0 0 1 0 .024v9.517c0 .183.008.381.024.596.016.214.03.407.04.579a.163.163 0 0 1-.096.159zm-2.457-5.812c.09.009.179.025.266.048v4.395a1.634 1.634 0 0 1-.354.064 4.965 4.965 0 0 1-.419.016 2.656 2.656 0 0 1-.83-.129 1.714 1.714 0 0 1-.676-.402 1.973 1.973 0 0 1-.451-.708 2.83 2.83 0 0 1-.169-1.031 2.217 2.217 0 0 1 .33-1.272c.213-.316.504-.571.845-.741.35-.173.736-.262 1.127-.258.111.002.221.007.331.018z",source:"https://www.adobe.com/products/xd.html",hex:"FF61F6",guidelines:void 0,license:void 0},siAllocine={title:"AlloCin\xE9",slug:"allocine",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AlloCin&#233;</title><path d="'+this.path+'"/></svg>'},path:"M16.434.001a.826.826 0 00-.164.008l-3.423.543a2.635 2.635 0 01-2.189 3.01 2.629 2.629 0 01-3.01-2.185l-3.417.538a.818.818 0 00-.677.931l3.24 20.467a.818.818 0 00.931.677l3.423-.543a2.635 2.635 0 012.189-3.01 2.629 2.629 0 013.01 2.185l3.422-.543a.818.818 0 00.677-.93L17.2.685a.816.816 0 00-.767-.685zm-3.22 6.534c.066 0 .128.005.185.017.423.09.975.6 1.315.955.178.187.192.519.048.73l-1.228 1.795a.89.89 0 01-.437.283c-.504.125-1.248-.95-1.771 1.507-.524 2.458.59 1.776 1.003 2.098a.828.828 0 01.283.437l.394 2.14a.613.613 0 01-.341.649c-.456.182-1.167.427-1.589.336-.907-.192-2.342-2.4-1.57-6.044.725-3.415 2.71-4.89 3.708-4.903Z",source:"http://www.allocine.fr/",hex:"FECC00",guidelines:void 0,license:void 0},siAffinityphoto={title:"Affinity Photo",slug:"affinityphoto",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Affinity Photo</title><path d="'+this.path+'"/></svg>'},path:"M10.44 0l-.48.831 5.88 10.185L22.2 0zm12.84 0l-8.577 14.856H24V.711A.72.72 0 0023.28 0zM9.42 1.767L5.76 8.106h7.32zm1.563 7.257h-.018c-.36.005-.7.216-.879.523l-1.083 1.88-.008.014a1.052 1.052 0 000 1.02 16710.388 16710.388 0 001.093 1.894c.184.31.53.5.885.501.002 0 1.38.002 2.067-.001.36-.005.699-.205.878-.512.364-.631.731-1.261 1.093-1.894.176-.314.17-.703-.007-1.011l-.01-.015-1.078-1.87-.006-.009a1.053 1.053 0 00-.879-.52h-.012zM5.22 9.04L0 18.082v.39l.003 4.871a.72.72 0 00.662.655L9.3 9.04zm2.94 3.845L1.736 24h12.84zm2.757 2.906L15.657 24h7.623a.72.72 0 00.72-.72v-7.488Z",source:"https://affinity.serif.com/en-gb/photo/",hex:"7E4DD2",guidelines:void 0,license:void 0},siAib={title:"AIB",slug:"aib",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AIB</title><path d="'+this.path+'"/></svg>'},path:"M4.8125.004c-.045.0116-.0796.0506-.0977.1073-.1266.4015-.6012 3.0184.7286 3.129 4.032.3342 3.338 3.6082 6.2832 4.2148v1.0703H9.6328l-.9453.9297h3.039v1.8183H9.1642c-2.0105 0-2.8492-1.3788-2.5196-2.4277.2838-.9032 2.2103-2.6043-.1308-3.334.7429 2.0266-2.4297 1.7762-2.4297 4.8945 0 2.4346 2.8034 3.3262 5.08 3.3262h6.3712c2.2766 0 5.08-.8916 5.08-3.3262 0-3.1183-3.1726-2.868-2.4297-4.8945-2.341.7297-.4126 2.4308-.1289 3.334.3296 1.0489-.511 2.4277-2.5214 2.4277h-2.5625V9.4551h3.039l-.9453-.9297h-2.0937V7.459c2.39-.49 2.6793-2.8833 4.3183-4.0488.7411-.5268 2.0625-.5293 2.0625-.5293s-1.8286-1.3563-2.0254-1.502c-.1964-.1456-.6423-.455-1.168-.455-.6355 0-1.5042.9231-2.1015 1.3046-1.279.818-4.0935 2.129-9.086-2.17-.059-.0509-.1151-.0663-.1601-.0546zm11.4766 1.7577c.3063 0 .5546.248.5546.5547a.5545.5545 0 01-.5546.5547.5543.5543 0 01-.5547-.5547c0-.3067.248-.5547.5547-.5547zM5.8945 15.9551L2.713 24H4.375l.7363-1.8867h3.127L8.9843 24h1.6876l-3.0137-7.625c-.0984-.2494-.3452-.42-.6133-.42zm5.17 0v.3672c.0472.0203.0956.043.1386.0625.2022.1428.3457.4904.3457.8984l.002 6.4297c0 .1582.127.2871.2851.2871h1.8243v-.3672c-.0476-.021-.0969-.043-.1407-.0625-.2022-.1428-.3457-.4925-.3457-.9004V16.242c0-.1578-.127-.287-.2851-.287zm3.832 0V24h3.8047c1.6017 0 2.586-1.0737 2.586-2.1816 0-.8782-.5965-1.6329-1.4532-1.9746.579-.3973.9531-1.0128.9531-1.707 0-1.1076-.9842-2.1817-2.586-2.1817zm1.5156 1.3887h1.8496c.534 0 .9668.4332.9668.9667 0 .5179-.4078.9386-.92.963h-1.8964zm-9.7266.8945l1 2.4765H5.6797zm9.7266 2.4433h2.3828c.534 0 .9356.4294.9356.963 0 .5335-.4349.9667-.9688.9667h-2.3496Z",source:"https://aib.ie/",hex:"7F2B7B",guidelines:void 0,license:void 0},siAnsys={title:"Ansys",slug:"ansys",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Ansys</title><path d="'+this.path+'"/></svg>'},path:"M19.0424 10.089l-.993 2.4233-.9932-2.4233h-1.227l1.6066 3.921-.7039 1.7179h1.227l2.3104-5.639zm4.667 2.1272c-.1936-.1936-.5004-.3377-.9209-.4332l-.6984-.1599c-.1678-.0447-.2858-.0923-.3531-.143-.0673-.0506-.101-.1207-.101-.2101 0-.1232.0562-.2186.1683-.2859.112-.0673.2664-.101.4628-.101.426 0 .858.1513 1.2954.4542l.3362-.841c-.2241-.1627-.4767-.2886-.757-.3784a2.8304 2.8304 0 0 0-.8663-.1347c-.3476 0-.6576.0562-.9292.1683-.2724.112-.4826.2665-.631.4624-.1485.1964-.223.4237-.223.6814 0 .3254.0939.582.282.7696.1876.188.4806.3267.8789.4165l.673.1517c.2075.0447.3492.0954.4248.1512.076.0562.1136.1346.1136.2356 0 .1124-.0546.2007-.1639.2648-.1092.0645-.262.0966-.4584.0966-.2748 0-.5468-.042-.816-.1259-.2692-.0843-.5163-.2019-.7403-.3531l-.3366.8745c.23.1628.5032.2875.8204.3746.3167.0867.6655.1302 1.0471.1302.555 0 .991-.1136 1.3081-.3408.3167-.2273.4751-.5397.4751-.938-.0008-.331-.0974-.593-.2906-.7866zm-9.3815-.4332l-.698-.1599c-.1682-.0447-.2862-.0923-.3535-.143-.0669-.0506-.1006-.1207-.1006-.2101 0-.1232.0558-.2186.168-.2859.112-.0673.2664-.101.4627-.101.426 0 .858.1513 1.2955.4542l.3365-.841c-.2245-.1627-.4767-.2886-.757-.3784a2.8323 2.8323 0 0 0-.8663-.1347c-.348 0-.6576.0562-.9296.1683-.272.112-.4822.2665-.6306.4624-.1489.1964-.223.4237-.223.6814 0 .3254.0943.582.282.7696.1876.188.481.3267.8793.4165l.673.1517c.2075.0447.3488.0954.4248.1512.0756.0562.1137.1346.1137.2356 0 .1124-.0546.2007-.164.2648-.1092.0645-.2624.0966-.4584.0966-.2748 0-.5468-.042-.816-.1259-.2688-.0843-.5159-.2019-.7403-.3531l-.3362.8745c.2297.1628.5032.2875.82.3746.3167.0867.6659.1302 1.0471.1302.5551 0 .991-.1136 1.3081-.3408.3168-.2273.4751-.5397.4751-.938 0-.3305-.0966-.593-.2902-.7862-.1944-.194-.5012-.3381-.922-.4336zM9.823 9.9828c-.2918 0-.5539.059-.7863.1766-.2328.1176-.422.2886-.5677.5131v-.5887H7.2325v4.1301h1.27v-2.3133c0-.2803.08-.5048.24-.673.1595-.1683.3713-.2526.635-.2526.219 0 .3797.0645.4838.1936.1037.129.1556.3337.1556.614v2.431h1.27v-2.49c0-.5831-.1207-1.019-.3618-1.308-.2415-.2882-.6089-.4328-1.1022-.4328zM4.4334 8.4594l-.8176 1.9954 1.5381 3.7544h1.7262zm-.3726-.1873H2.4325L0 14.2091h1.6284z",source:"https://www.ansys.com/about-ansys/brand",hex:"FFB71B",guidelines:void 0,license:void 0},siAntdesign={title:"Ant Design",slug:"antdesign",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Ant Design</title><path d="'+this.path+'"/></svg>'},path:"M17.4511 6.6808c.5091-.5064.5091-1.3316 0-1.838l-1.8729-1.873.0027.0027c-.4957-.4957-1.3478-1.3478-2.5535-2.5508-.568-.5547-1.487-.5493-2.0498.0134L.426 10.9787a1.4426 1.4426 0 0 0 0 2.047l10.549 10.541a1.4506 1.4506 0 0 0 2.0497 0l4.4238-4.4211c.509-.5064.509-1.3317 0-1.8381a1.3049 1.3049 0 0 0-1.8408 0l-3.3493 3.3546c-.1393.1394-.3564.1394-.4957 0l-8.4268-8.4188c-.1394-.1393-.1394-.3563 0-.4956L11.76 3.3289c.0107-.0108.0241-.0188.0349-.0295.1393-.1099.3322-.0992.4608.0295l3.3547 3.352c.509.509 1.3343.509 1.8407 0zm-8.2446 5.375a2.8482 2.8456 0 1 0 5.6965 0 2.8482 2.8456 0 1 0-5.6965 0zm14.3672-1.0343l-3.293-3.277c-.5092-.5063-1.3344-.5063-1.8408.0028a1.2968 1.2968 0 0 0 0 1.838l2.2239 2.2213c.1393.1393.1393.3564 0 .4957l-2.1918 2.189a1.2968 1.2968 0 0 0 0 1.8382 1.3049 1.3049 0 0 0 1.8408 0l3.2635-3.2609a1.445 1.445 0 0 0-.0026-2.047Z",source:"https://ant.design/components/icon/",hex:"0170FE",guidelines:void 0,license:void 0},siAerlingus={title:"Aer Lingus",slug:"aerlingus",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Aer Lingus</title><path d="'+this.path+'"/></svg>'},path:"M23.857 13.511c-.48 1.545-2.081 2.995-4.002 3.296.31.48.452 1.074.377 1.733-.208 1.789-1.921 3.23-3.758 3.249-1.243.009-2.928-.528-4.115-2.402-1.064-1.666-1.215-4.313-1.14-5.113-1.299 1.328-2.109 2.618-2.495 3.512-.866 2.025-1.196 4.492-1.177 5.65 0 0-.16.151-.31.18-.48-.085-.895-.264-1.206-.537-.376-.34-.461-.66-.461-.66.574-2.872 1.488-4.66 2.853-6.704 1.836-2.76 4.67-4.464 8.032-5.49 2.43-.744 4.954-.904 6.686.565.933.772.989 1.883.716 2.721zM9.544 11.986c-.575.96-2.147 2.505-3.39 3.305-2.59 1.657-4.454 1.77-5.387 1.177a1.451 1.451 0 0 1-.292-.235c-.725-.763-.602-2.119.245-3.23.415-.546.951-.932 1.47-1.111-.406-.189-.679-.584-.735-1.14-.113-1.11.725-2.57 1.883-3.164 1.017-.518 3.211-1.036 4.821 1.366.631.932 1.196 2.26 1.385 3.032zM20.184 1.89c-.14-1.384-1.62-1.893-3.248-1.196-.772.33-1.45.885-1.93 1.516.075-.63-.104-1.186-.556-1.516-.895-.65-2.524-.17-3.635 1.036-.386.424-1.648 1.95-1.714 4.19-.028 1.083.452 3.485 2.034 5.142 4.219-1.591 6.488-4.03 7.354-5.038.999-1.168 1.422-2.194 1.601-2.947.132-.594.113-1.017.094-1.187z",source:"https://www.aerlingus.com/",hex:"006272",guidelines:void 0,license:void 0},siAeroflot={title:"Aeroflot",slug:"aeroflot",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Aeroflot</title><path d="'+this.path+'"/></svg>'},path:"M9.066 12.725c-.056-.135-.097-.272-.143-.406l-6.675.406 1.35.693zm.909 1.247c-.057-.042-.115-.1-.17-.15a1.822 1.822 0 0 1-.287-.318l-3.333.67 1.419.509zm2.64-.286c.16-.025.4-.122.588-.268l-.968-2.032 1.005-.51-.848-.782c-.602.292-1.206.58-1.809.868l.43 1.025.694-.33zm1.65-4.241c.387.5.655 1.081.782 1.7h-.61a3.884 3.884 0 0 0-.172-.57c-.41-1.142-1.25-1.956-2.216-2.633-.127-.078-.241-.164-.37-.238.129.044.243.086.37.136.88.372 1.662.885 2.216 1.605m.185 6.517c-.225.114-.455.22-.682.33l-.565-1.193c-.37.139-.76.215-1.154.226-.424.02-.847-.04-1.249-.176l-.483 1.143c-.157.014-.374 0-.512-.106a.378.378 0 0 1-.169-.224c.204-.356.389-.723.579-1.087-.127-.088-.24-.152-.355-.27l.344-.437c.582.38 1.22.585 1.845.585.627.022 1.25-.192 1.832-.628.19.055.385.119.541.18-.058.046-.1.087-.157.136-.114.12-.213.242-.398.346.188.395.387.784.583 1.175zm7.785-3.431L24 11.343h-9.55c0 .422-.06.784-.185 1.1-.369 1.005-1.291 1.487-2.216 1.469-.908-.027-1.834-.524-2.244-1.441a2.745 2.745 0 0 1-.229-1.128H0l1.75 1.188 7.316-.404c.138.553.397 1.037.74 1.395a3.065 3.065 0 0 0 2.243 1.01 2.79 2.79 0 0 0 2.216-.992c.312-.362.554-.826.694-1.385zm-.48.194l-1.352.663L15 12.725a9.5 9.5 0 0 0 .129-.406zm-3.907 1.462l-1.48.52a357.77 357.77 0 0 1-2.286-.735c.069-.06.125-.117.183-.196.085-.074.157-.176.242-.254zm.711-.09l1.177-.575-4.86-.614c-.043.164-.171.298-.256.432zm-13.116 0l-1.179-.542 4.885-.635c.09.152.171.286.27.42Z",source:"https://www.aeroflot.ru/ru-en/information/onboard/press",hex:"02458D",guidelines:void 0,license:void 0},siAeromexico={title:"Aerom\xE9xico",slug:"aeromexico",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Aerom&#233;xico</title><path d="'+this.path+'"/></svg>'},path:"M22.354 12.222c.044.156 0 .422-.267.489a3.74 3.74 0 0 1-.666.11c-.377.045-.355.356-.355.534v2.264c0 .31-.244 1.354-1.443 1.354H16.87c-1.043 0-1.864-.866-1.864-1.798V9.803c-.022-.932.821-1.554 1.576-1.532.377 0 .644.111.843.222.444.2.933.444 1.577.755 0 0 1.02-.733 1.087-.777.355-.244.688-.067.8.155.377.733 1.087 2.22 1.465 3.596zm1.642-4.018a3.283 3.283 0 0 0-3.219-3.33c-1.709-.044-2.663.578-3.019.755-.022.023-.066 0-.11-.044-.311-.31-1-.777-1.754-.999-.111-.022-.133-.2 0-.2a13.3 13.3 0 0 1 3.64.111c.134.023.245-.066.178-.177-.044-.089-.067-.133-.133-.289-.156-.31-.533-.644-1.021-.777-1.266-.355-3.441-.666-5.394-.666-2.176-.022-4.484.422-5.062.555-.133.023-.333.09-.377.09-.111 0-.155.155-.089.221l.222.222c.067.089.111.222-.022.355L3.796 7.65H6.57c.177 0 .355.155.355.355 0 .177-.156.355-.333.355H2.997l-1.088.999h4.706c.178 0 .333.2.333.355 0 .155-.133.355-.333.355H1.11L0 11.09h9.501c.177 0 .333.2.333.355 0 .2-.133.378-.333.378H0v.999h9.479c.222 0 .333.2.333.377 0 .156-.156.333-.356.333H0v1h12.386c.2 0 .334.177.334.377 0 .177-.156.355-.334.355H3.33v.999h9.079c.177 0 .31.2.31.377s-.155.355-.31.355l-.178-.022H3.33v.999h10.455s.377-.866.377-1.843V9.403c0-.532.222-1.42 1.31-1.664.022 0 .067-.023.089-.023 3.085-.732 6.26-.066 8.058.71.333.156.4-.11.377-.222zM6.66 21.413h2.11c1.886-.022 3.107-1.02 3.107-1.02H6.659v1.02zm0-1.731h6.06c.29-.289.644-.8.733-.999H6.659v.999Z",source:"https://www.aeromexico.com/",hex:"0B2343",guidelines:void 0,license:void 0},siAdyen={title:"Adyen",slug:"adyen",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Adyen</title><path d="'+this.path+'"/></svg>'},path:"M11.64703 9.88245v2.93377c0 .13405.10867.24271.24272.24271h.46316V9.88245h1.76474v5.1503c0 .46916-.38033.8495-.8495.8495H9.94303v-1.23507h2.40991v-.52942h-1.62108c-.46917 0-.8495-.38033-.8495-.8495V9.88245h1.76467Zm-8.26124.00001c.46917 0 .8495.38034.8495.8495v3.3858H.8495c-.46916 0-.8495-.38033-.8495-.8495v-.94805c0-.46917.38034-.8495.8495-.8495h.91521v1.3455c0 .13406.10867.24272.24272.24272h.46316V11.184c0-.13405-.10867-.24271-.24272-.24271l-2.16719-.00002V9.88246Zm5.79068-1.76471v6.00001H5.79068c-.46917 0-.8495-.38033-.8495-.8495v-2.53631c0-.46917.38033-.8495.8495-.8495h.91515v2.93377c0 .13405.10867.24271.24272.24271h.46316l.00005-4.94118h1.76471Zm9.03286 1.76471a.8495.8495 0 0 1 .8495.8495v.94805c0 .46917-.38033.8495-.8495.8495h-.9152v-1.3455c0-.13404-.10868-.2427-.24272-.2427h-.46317v1.8749c0 .13406.10867.24272.24272.24272h2.16719v1.05883h-3.32511c-.46917 0-.8495-.38033-.8495-.8495v-3.3858Zm4.94117 0c.46916 0 .8495.38034.8495.8495v3.3858h-1.7647V11.184c-.0004-.13388-.10884-.24232-.24272-.24272h-.46316v3.1765H19.7647V9.88245Z",source:"https://www.adyen.com/press-and-media/presskit",hex:"0ABF53",guidelines:"https://www.adyen.com/press-and-media/presskit",license:void 0},siAew={title:"AEW",slug:"aew",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AEW</title><path d="'+this.path+'"/></svg>'},path:"M0 6.925v10.086h3.674v-.51H.53V7.435h4.526v-.51zm18.944 0v.511h4.526V16.5h-3.144v.511H24V6.925zm-7.727-.891v1.453h1.537v-.383H11.71V6.91h.86v-.336h-.86v-.157h1.044v-.383H11.71zm1.765 0v1.453h1.39V7.06h-.897V6.034zm1.551 0v1.453h.493V6.034zm.648 0v.427h.557v1.026h.493V6.461h.558v-.427h-1.051zm1.765 0v1.453h1.537v-.383H17.44V6.91h.86v-.336h-.86v-.157h1.044v-.383H17.44zM11.45 8.225l-3.785.006.015 3.466 1.57 4.01h5.144l-.707-1.77H9.84V10h2.32zm-1.288 2.862v1.77h3.107l-.712-1.77zM6.265 6.034l-.748 1.453h.538l.122-.278h.699l.135.278h.536l-.753-1.453zm1.363 0v1.453h1.39V7.06h-.897V6.034zm1.55 0v1.453h1.39V7.06h-.896V6.034zm-2.65.444l.187.391h-.377zm16.29 1.73l-2.148.003-1.368 3.47-.938-3.467-2.142.003-.92 3.443-1.355-3.44-2.177.004 2.966 7.483h1.633l.938-3.462.934 3.462h1.653zm-16.844.025l-1.845.003-2.946 7.472H3.37l.342-.9h2.333l-.686-1.747h-.955l.635-1.673 1.706 4.32h2.17zm13.091 8.195c-.398.002-.663.14-.805.316a.76.76 0 00.005.91c.603.625 1.574.134 1.632.008v-.622h-.892v.344h.405v.086c-.114.152-.598.143-.722-.053-.124-.225-.038-.374.008-.444.277-.3.753-.062.784.004l.365-.293a1.332 1.332 0 00-.78-.256zm-7.877.01a2.177 2.177 0 00-.269.02c-.293.06-.476.207-.517.346-.128.491.571.567.571.567.623.03.571.098.572.123-.065.136-.42.087-.529.07-.221-.042-.43-.186-.43-.186l-.271.3c.76.482 1.38.226 1.48.17.3-.171.29-.484.192-.621-.076-.093-.307-.207-.535-.232-.204-.048-.604-.011-.558-.141.06-.12.682-.04.845.095l.24-.295c-.233-.168-.517-.22-.791-.216zm-7.085.047l.504 1.397h.505l.278-.854.266.854h.506l.502-1.397h-.497l-.258.866-.297-.866h-.444l-.294.874-.265-.874zm2.693 0v1.397h.502v-.392h.31l.324.392h.591l-.384-.448c.6-.234.334-.927-.234-.95h-.06zm1.89 0v1.397h1.537v-.328H9.18v-.195h.86v-.335h-.86v-.158h1.044v-.381zm3.427 0v.413h.557v.984h.494v-.984h.557v-.413zm1.758 0v1.397h1.39V17.5h-.897v-1.016zm1.562 0v1.397h.493V16.485zm.766 0v1.397h.493v-.804l.772.804h.466v-1.396h-.493v.761l-.716-.761zm-8.904.372h.531c.19-.003.189.286 0 .292h-.53z",source:"https://commons.wikimedia.org/wiki/File:AEW_Logo_(simplified).svg",hex:"000000",guidelines:void 0,license:void 0},siAmazonfiretv={title:"Amazon Fire TV",slug:"amazonfiretv",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Amazon Fire TV</title><path d="'+this.path+'"/></svg>'},path:"M20.196 15.12c.265.337-.294 1.73-.542 2.353-.077.19.085.266.257.123 1.106-.926 1.39-2.867 1.166-3.149-.226-.277-2.16-.516-3.341.314-.183.127-.151.304.05.279.665-.08 2.147-.257 2.41.08m-.858.981c-2.064 1.523-5.056 2.333-7.632 2.333-3.611 0-6.862-1.334-9.322-3.555-.194-.176-.02-.414.21-.28 2.655 1.545 5.939 2.477 9.328 2.477 2.287 0 4.803-.476 7.115-1.458.348-.147.642.231.3.483m2.034-3.155a.388.388 0 0 1-.201-.04c-.041-.026-.087-.1-.133-.225l-1.734-4.355a1.79 1.79 0 0 0-.046-.117.266.266 0 0 1-.023-.108c0-.084.049-.128.146-.128h.58c.098 0 .165.014.205.04.04.026.082.102.127.226l1.344 3.823 1.343-3.823c.046-.124.089-.2.128-.226a.402.402 0 0 1 .205-.04h.54c.1 0 .148.044.148.128a.3.3 0 0 1-.025.108c-.016.04-.032.078-.044.117l-1.727 4.355c-.045.124-.09.199-.132.225a.388.388 0 0 1-.201.04zm-3.644.068c-.929 0-1.392-.463-1.392-1.392V8.739h-.706c-.13 0-.197-.066-.197-.196v-.246a.22.22 0 0 1 .045-.147c.03-.031.086-.055.171-.067l.717-.09.127-1.215c.013-.13.082-.196.207-.196h.41c.13 0 .196.066.196.196v1.196h1.276c.13 0 .195.065.195.197v.372c0 .13-.064.196-.195.196h-1.276v2.834c0 .243.055.411.162.51.108.098.293.147.555.147.124 0 .277-.016.46-.049.099-.02.164-.03.197-.03.052 0 .088.014.108.044.02.03.029.077.029.142v.266a.366.366 0 0 1-.04.19c-.026.043-.078.078-.157.103a3.018 3.018 0 0 1-.892.118m-4.665-2.976c.006-.052.011-.137.011-.255 0-.399-.094-.698-.28-.901-.186-.204-.46-.306-.818-.306-.412 0-.732.123-.962.369-.228.245-.36.61-.392 1.093zm-.942 3.07c-.803 0-1.411-.222-1.824-.667-.412-.444-.616-1.102-.616-1.972 0-.83.204-1.475.616-1.937.413-.46.988-.691 1.728-.691.62 0 1.098.176 1.432.524.332.351.5.846.5 1.487 0 .21-.017.422-.05.638-.014.077-.034.13-.064.156-.029.027-.077.04-.142.04h-3.08c.013.563.154.977.418 1.245.265.268.674.403 1.23.403.196 0 .385-.014.564-.04a5.04 5.04 0 0 0 .682-.166l.117-.035a.284.284 0 0 1 .09-.016c.085 0 .125.06.125.177v.276c0 .085-.012.144-.037.18a.441.441 0 0 1-.167.114 3.38 3.38 0 0 1-.701.205 4.236 4.236 0 0 1-.82.079m-5.424-.147c-.13 0-.195-.066-.195-.197v-4.58c0-.13.064-.195.195-.195h.432c.064 0 .116.012.153.039.036.025.06.076.072.146l.07.55c.176-.19.343-.34.499-.452a1.725 1.725 0 0 1 1.02-.323c.079 0 .158.003.235.01.112.014.168.072.168.176v.53c0 .117-.058.177-.178.177-.058 0-.114-.004-.17-.01a1.638 1.638 0 0 0-.18-.01c-.524 0-.973.157-1.346.47v3.472c0 .131-.066.197-.195.197zm-2.249 0c-.13 0-.196-.066-.196-.197v-4.58c0-.13.066-.195.196-.195h.579c.13 0 .195.064.195.195v4.58c0 .131-.065.197-.195.197zm.295-5.856c-.19 0-.339-.054-.447-.16a.581.581 0 0 1-.161-.428c0-.176.054-.318.16-.426.11-.109.257-.163.448-.163.189 0 .337.054.446.163.107.108.16.25.16.426a.581.581 0 0 1-.16.427.608.608 0 0 1-.446.161m-3.625 5.856c-.132 0-.197-.066-.197-.197v-4.01H.195c-.13 0-.195-.066-.195-.197v-.245c0-.065.014-.114.043-.147.03-.033.088-.055.173-.07l.705-.087v-.804c0-1.091.523-1.638 1.57-1.638.248 0 .51.036.784.109.072.019.122.047.152.088.029.038.044.107.044.205v.255c0 .124-.048.186-.148.186-.058 0-.14-.01-.248-.029-.11-.02-.23-.03-.369-.03-.3 0-.51.057-.633.172-.121.115-.181.303-.181.564v.903h1.324c.131 0 .197.064.197.195v.373c0 .13-.066.197-.197.197H1.892v4.01c0 .131-.065.197-.196.197Z",source:"https://www.amazon.com/gp/help/customer/display.html?nodeId=201348270",hex:"FC4C02",guidelines:void 0,license:void 0},siAmericanairlines={title:"American Airlines",slug:"americanairlines",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>American Airlines</title><path d="'+this.path+'"/></svg>'},path:"M0 .244h3.264c1.377 0 1.942.563 2.499 1.116.637.58 2.57 3.196 6.657 8.303H7.997c-1.809 0-2.38-.308-3.08-1.375zm10.424 17.072l-2.427-4.013c-.292-.455-.372-.854-.372-1.318 0-.51.217-.79 1.053-1.233.973-.466 2.933-.67 4.954-.67 3.283 0 4.07 1.055 4.405 2.192 0 0-.464-.185-1.554-.185-3.459 0-6.223 1.68-6.223 4.221 0 .534.164 1.006.164 1.006zm4.936-3.417c-2.547.089-5.032 1.869-4.936 3.416l2.7 4.486c.836 1.344 2.215 1.955 3.932 1.955H24l-8.13-9.852a5.55 5.55 0 0 0-.51-.005Z",source:"https://en.wikipedia.org/wiki/File:American_Airlines_logo_2013.svg",hex:"0078D2",guidelines:void 0,license:void 0},siAmericanexpress={title:"American Express",slug:"americanexpress",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>American Express</title><path d="'+this.path+'"/></svg>'},path:"M16.015 14.378c0-.32-.135-.496-.344-.622-.21-.12-.464-.135-.81-.135h-1.543v2.82h.675v-1.027h.72c.24 0 .39.024.478.125.12.13.104.38.104.55v.35h.66v-.555c-.002-.25-.017-.376-.108-.516-.06-.08-.18-.18-.33-.234l.02-.008c.18-.072.48-.297.48-.747zm-.87.407l-.028-.002c-.09.053-.195.058-.33.058h-.81v-.63h.824c.12 0 .24 0 .33.05.098.048.156.147.15.255 0 .12-.045.215-.134.27zM20.297 15.837H19v.6h1.304c.676 0 1.05-.278 1.05-.884 0-.28-.066-.448-.187-.582-.153-.133-.392-.193-.73-.207l-.376-.015c-.104 0-.18 0-.255-.03-.09-.03-.15-.105-.15-.21 0-.09.017-.166.09-.21.083-.046.177-.066.272-.06h1.23v-.602h-1.35c-.704 0-.958.437-.958.84 0 .9.776.855 1.407.87.104 0 .18.015.225.06.046.03.082.106.082.18 0 .077-.035.15-.08.18-.06.053-.15.07-.277.07zM0 0v10.096L.81 8.22h1.75l.225.464V8.22h2.043l.45 1.02.437-1.013h6.502c.295 0 .56.057.756.236v-.23h1.787v.23c.307-.17.686-.23 1.12-.23h2.606l.24.466v-.466h1.918l.254.465v-.466h1.858v3.948H20.87l-.36-.6v.585h-2.353l-.256-.63h-.583l-.27.614h-1.213c-.48 0-.84-.104-1.08-.24v.24h-2.89v-.884c0-.12-.03-.12-.105-.135h-.105v1.036H6.067v-.48l-.21.48H4.69l-.202-.48v.465H2.235l-.256-.624H1.4l-.256.624H0V24h23.786v-7.108c-.27.135-.613.18-.973.18H21.09v-.255c-.21.165-.57.255-.914.255H14.71v-.9c0-.12-.018-.12-.12-.12h-.075v1.022h-1.8v-1.066c-.298.136-.643.15-.928.136h-.214v.915h-2.18l-.54-.617-.57.6H4.742v-3.93h3.61l.518.602.554-.6h2.412c.28 0 .74.03.942.225v-.24h2.177c.202 0 .644.045.903.225v-.24h3.265v.24c.163-.164.508-.24.803-.24h1.89v.24c.194-.15.464-.24.84-.24h1.176V0H0zM21.156 14.955c.004.005.006.012.01.016.01.01.024.01.032.02l-.042-.035zM23.828 13.082h.065v.555h-.065zM23.865 15.03v-.005c-.03-.025-.046-.048-.075-.07-.15-.153-.39-.215-.764-.225l-.36-.012c-.12 0-.194-.007-.27-.03-.09-.03-.15-.105-.15-.21 0-.09.03-.16.09-.204.076-.045.15-.05.27-.05h1.223v-.588h-1.283c-.69 0-.96.437-.96.84 0 .9.78.855 1.41.87.104 0 .18.015.224.06.046.03.076.106.076.18 0 .07-.034.138-.09.18-.045.056-.136.07-.27.07h-1.288v.605h1.287c.42 0 .734-.118.9-.36h.03c.09-.134.135-.3.135-.523 0-.24-.045-.39-.135-.526zM18.597 14.208v-.583h-2.235V16.458h2.235v-.585h-1.57v-.57h1.533v-.584h-1.532v-.51M13.51 8.787h.685V11.6h-.684zM13.126 9.543l-.007.006c0-.314-.13-.5-.34-.624-.217-.125-.47-.135-.81-.135H10.43v2.82h.674v-1.034h.72c.24 0 .39.03.487.12.122.136.107.378.107.548v.354h.677v-.553c0-.25-.016-.375-.11-.516-.09-.107-.202-.19-.33-.237.172-.07.472-.3.472-.75zm-.855.396h-.015c-.09.054-.195.056-.33.056H11.1v-.623h.825c.12 0 .24.004.33.05.09.04.15.128.15.25s-.047.22-.134.266zM15.92 9.373h.632v-.6h-.644c-.464 0-.804.105-1.02.33-.286.3-.362.69-.362 1.11 0 .512.123.833.36 1.074.232.238.645.31.97.31h.78l.255-.627h1.39l.262.627h1.36v-2.11l1.272 2.11h.95l.002.002V8.786h-.684v1.963l-1.18-1.96h-1.02V11.4L18.11 8.744h-1.004l-.943 2.22h-.3c-.177 0-.362-.03-.468-.134-.125-.15-.186-.36-.186-.662 0-.285.08-.51.194-.63.133-.135.272-.165.516-.165zm1.668-.108l.464 1.118v.002h-.93l.466-1.12zM2.38 10.97l.254.628H4V9.393l.972 2.205h.584l.973-2.202.015 2.202h.69v-2.81H6.118l-.807 1.904-.876-1.905H3.343v2.663L2.205 8.787h-.997L.01 11.597h.72l.26-.626h1.39zm-.688-1.705l.46 1.118-.003.002h-.915l.457-1.12zM11.856 13.62H9.714l-.85.923-.825-.922H5.346v2.82H8l.855-.932.824.93h1.302v-.94h.838c.6 0 1.17-.164 1.17-.945l-.006-.003c0-.78-.598-.93-1.128-.93zM7.67 15.853l-.014-.002H6.02v-.557h1.47v-.574H6.02v-.51H7.7l.733.82-.764.824zm2.642.33l-1.03-1.147 1.03-1.108v2.253zm1.553-1.258h-.885v-.717h.885c.24 0 .42.098.42.344 0 .243-.15.372-.42.372zM9.967 9.373v-.586H7.73V11.6h2.237v-.58H8.4v-.564h1.527V9.88H8.4v-.507",source:"https://commons.wikimedia.org/wiki/File:American_Express_logo.svg",hex:"2E77BC",guidelines:void 0,license:void 0},siAmg={title:"AMG",slug:"amg",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AMG</title><path d="'+this.path+'"/></svg>'},path:"M23.9998 11.8942a.1216.1216 0 0 0-.127-.1271H21.607a.1216.1216 0 0 0-.1271.127v.1906a.1419.1419 0 0 0 .127.1482h1.419c.0847 0 .0847.0424.0847.1482v.0202c0 .1058 0 .1271-.0847.1271h-2.901a.1216.1216 0 0 1-.1271-.127v-.8248a.1216.1216 0 0 1 .127-.1271h3.7267a.1216.1216 0 0 0 .127-.1271v-.3177a.1216.1216 0 0 0-.127-.127h-4.616a.1216.1216 0 0 0-.127.127v2.054a.1216.1216 0 0 0 .127.127h4.616a.1216.1216 0 0 0 .127-.127v-1.1645m-7.3686.5505a.316.316 0 0 1-.1906.0847h-.5929a.316.316 0 0 1-.1907-.0847l-1.1221-.72c-.0635-.0423-.1271-.0212-.1271.0635v1.207a.1216.1216 0 0 1-.1271.1271h-.593a.1419.1419 0 0 1-.148-.127v-2.054c0-.0847.0633-.127.148-.127h.6353a.5067.5067 0 0 1 .1906.0633l1.5247.9953a.1587.1587 0 0 0 .1905 0l1.5245-.9953a.2961.2961 0 0 1 .1907-.0634h.6353a.1216.1216 0 0 1 .1269.1271v2.054a.1216.1216 0 0 1-.1269.127h-.5929a.1419.1419 0 0 1-.1484-.127v-1.2071q0-.1271-.127-.0635zm-6.6066-1.0165c-.0424 0-.0634.0203-.1058.0636l-.36.4662c-.0213.0424 0 .0635.0203.0635h2.6045c.0847 0 .0847-.0424.0847-.1058v-.318c0-.1059 0-.1482-.0847-.1482h-2.159zm-1.5245 1.7152h-.7631a.0713.0713 0 0 1-.0635-.1058L9.2825 10.92a.2145.2145 0 0 1 .1483-.0847h3.515a.1638.1638 0 0 1 .1482.1694v2.0116a.1216.1216 0 0 1-.127.1271h-.593a.1216.1216 0 0 1-.127-.127V12.72c0-.0847 0-.106-.0848-.106H9.0717a.1419.1419 0 0 0-.1271.0847v.0203l-.2329.2963a.3677.3677 0 0 1-.2329.1271zm-1.5458 0a.3217.3217 0 0 0 .2117-.127l1.5881-2.054c.0636-.0847.0203-.1482-.0424-.1482h-.3176a.2145.2145 0 0 0-.1482.0847l-1.6305 2.1174a.0716.0716 0 0 0 .0636.106h.2753zm-1.101 0a.322.322 0 0 0 .2116-.127l1.5881-2.054c.0634-.0847.0213-.1482-.0424-.1482h-.4447a.2145.2145 0 0 0-.1482.0847L5.366 13.0163a.0716.0716 0 0 0 .0636.106h.4024zm-1.8 0a.0713.0713 0 0 1-.0635-.1058L5.599 10.92a.214.214 0 0 1 .1482-.0847h.6563c.0847 0 .106.0636.0424.1484l-1.5883 2.054a.2888.2888 0 0 1-.2116.127h-.6142zm-1.5034 0a.0713.0713 0 0 1-.0634-.1058L4.0957 10.92a.2145.2145 0 0 1 .1482-.0847h.8681c.0847 0 .1058.0636.0424.1484l-1.5881 2.054a.2888.2888 0 0 1-.2118.127h-.8258zm-2.4563 0a.0713.0713 0 0 1-.0634-.1058L1.6394 10.92a.2145.2145 0 0 1 .1482-.0847h1.9268c.0847 0 .106.0636.0424.1484l-1.5881 2.054a.2888.2888 0 0 1-.2116.127H.072Z",source:"https://www.mercedes-amg.com/etc/clientlibs/amg/amg.base/assets/images/svg/amg-logo.svg",hex:"000000",guidelines:void 0,license:void 0},siAmp={title:"AMP",slug:"amp",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AMP</title><path d="'+this.path+'"/></svg>'},path:"M12 0c6.628 0 12 5.373 12 12s-5.372 12-12 12C5.373 24 0 18.627 0 12S5.373 0 12 0zm-.92 19.278l5.034-8.377a.444.444 0 00.097-.268.455.455 0 00-.455-.455l-2.851.004.924-5.468-.927-.003-5.018 8.367s-.1.183-.1.291c0 .251.204.455.455.455l2.831-.004-.901 5.458z",source:"https://amp.dev/",hex:"005AF0",guidelines:void 0,license:void 0},siAmul={title:"Amul",slug:"amul",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Amul</title><path d="'+this.path+'"/></svg>'},path:"M4.794 11.772c-.104-.443-.546-1.492-.786-1.796-.04-.031-.062-.046-.078-.068l-.718 1.748s.375.091.796.148c.271.03.558.03.786-.032zm17-1.593v3.536c0 .7-.282.59-.385.613l1.209 1.018L24 14.236c-.014-.086-.063-.171-.124-.195-.475.294-.443-.302-.443-.302V9.527c0-.528-.933-1.097-1.285-.986l-1.304 1.297c.015.054.06.162.203.186.61-.56.747 0 .747.155zm-5.576 2.184v1.5c0 .528-.2.428-.348.488.412.218.972.668 1.454 1.011l1.446-.916 1.073.94 1.266-1.236s-.016-.18-.17-.171c-.444.436-.575-.288-.575-.288v-1.833c0-.801-1.028-.98-1.244-.972l-1.035 1.01a.4.4 0 00.194.165c.484-.382.567.17.567.17v1.5c-.014.62-1.14.847-1.14.008v-2.09c-.095-.576-.912-.895-1.028-.794l-1.181.972c.055.093.06.204.207.187.523-.367.514.349.514.349zm-7.805-.287v1.632c0 .45-.334.442-.44.465l1.274 1.104 1.227-1.08a.487.487 0 00-.115-.178c-.203.107-.357.046-.357-.22v-1.654c.108-.512.838-.397.838-.047v1.696c-.018.34-.156.488-.31.535l1.156.956 1.243-1.043c-.02-.085-.02-.16-.129-.2-.124.008-.357.25-.357-.288v-1.617c.256-.653.885-.31.91.055v1.516c-.009.357-.074.583-.366.683l1.204.94 1.276-1.15c0-.077-.11-.157-.15-.178-.419.364-.396-.095-.402-.165v-2.09c-.017-.365-.7-1.125-1.61-.783l-.91.668c-.484-.824-1.19-.847-1.378-.8-.308.044-.962.838-1.038.713-.288-.713-1.053-.728-1.209-.706l-1.07.924c.054.117.141.132.2.155.289-.17.485-.132.513.157zm-5.571.491l-.334.906.79.506c.112.071.253.024.476-.18l.157.157c-.357.41-.73.8-1.096 1.212-.482-.442-1.05-.877-1.594-.877-.628.013-1.213.62-.606 1.717.017.022-.094.138-.156.09-.465-.395-.652-1.482-.286-2.095.256-.397.72-.785 1.513-.693l.313-.85c-.287-.113-.598 0-.988.308.132-.67.551-1.136 1.412-1.252l.882-2.114c-.467-.187-.903.04-1.12.436-.132-.017-.225-.063-.25-.147l.903-1.68c.44-.153.817-.153 1.151-.048 1.376.436 2.067 2.76 3.098 5.325.095.248.221.271.516-.046l.21.186-1.86 1.85-.856-2.558c0 .022-.417.125-1.107.063a5.65 5.65 0 01-1.168-.216z",source:"https://amul.com/classic/products/horeca.php",hex:"ED1D24",guidelines:void 0,license:void 0},siAna={title:"ANA",slug:"ana",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>ANA</title><path d="'+this.path+'"/></svg>'},path:"M19.11 8.975l-3.454 6.05h3.432l3.455-6.05zm3.933 0l-3.455 6.05h.959L24 8.975zm-10.01.781H14.8l.403 5.27h-1.31l-.025-.58a.206.206 0 0 0-.202-.227h-1.867l.429-.757h1.21c.151 0 .328.026.328-.202l-.202-2.37c0-.15-.126-.226-.227-.075L11.193 15h-.882zm-9.983 0h1.74l.353 5.27h-1.31l-.026-.58a.226.226 0 0 0-.227-.227H1.563l.429-.757h1.386c.151 0 .328.026.328-.202l-.151-2.37c0-.15-.126-.226-.227-.075L.882 15H0zm3.278 0h1.79l1.16 4.084c.05.126.15.101.176 0l.756-4.084h.782l-.933 5.27H8.244l-1.135-4.034c-.025-.101-.151-.127-.176 0l-.706 4.033h-.832Z",source:"https://www.ana.co.jp/en/eur/the-ana-experience/brand/",hex:"13448F",guidelines:void 0,license:void 0},siAnaconda={title:"Anaconda",slug:"anaconda",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Anaconda</title><path d="'+this.path+'"/></svg>'},path:"M12.045.033a12.181 12.182 0 00-1.361.078 17.512 17.513 0 011.813 1.433l.48.438-.465.45a15.047 15.048 0 00-1.126 1.205l-.178.215a8.527 8.527 0 01.86-.05 8.154 8.155 0 11-4.286 15.149 15.764 15.765 0 01-1.841.106h-.86a21.847 21.848 0 00.264 2.866 11.966 11.967 0 106.7-21.89zM8.17.678a12.181 12.182 0 00-2.624 1.275 15.506 15.507 0 011.813.43A18.551 18.552 0 018.17.678zM9.423.75a16.237 16.238 0 00-.995 1.998 16.15 16.152 0 011.605.66 6.98 6.98 0 01.43-.509c.234-.286.472-.559.716-.817A15.047 15.048 0 009.423.75zM4.68 2.949a14.969 14.97 0 000 2.336c.587-.065 1.196-.1 1.812-.107a16.617 16.617 0 01.48-1.748 16.48 16.481 0 00-2.292-.481zM3.62 3.5A11.938 11.938 0 001.762 5.88a17.004 17.004 0 011.877-.444A17.39 17.391 0 013.62 3.5zm4.406.287c-.143.437-.265.888-.38 1.347a8.255 8.255 0 011.67-.803c-.423-.2-.845-.38-1.29-.544zM6.3 6.216a14.051 14.052 0 00-1.555.108c.064.523.157 1.038.272 1.554a8.39 8.391 0 011.283-1.662zm-2.55.137a15.313 15.313 0 00-2.602.716h-.078v.079a17.104 17.105 0 001.267 2.544l.043.071.072-.049a16.309 16.31 0 011.734-1.083l.057-.035V8.54a16.867 16.868 0 01-.408-2.094v-.092zM.644 8.095l-.063.2A11.844 11.845 0 000 11.655v.209l.143-.152a17.706 17.707 0 011.584-1.447l.057-.043-.043-.064a16.18 16.18 0 01-1.025-1.87zm3.77 1.253l-.18.1c-.465.273-.93.573-1.375.889l-.065.05.05.064c.309.437.645.867.996 1.276l.137.165v-.208a8.176 8.176 0 01.364-2.15zM2.2 10.853l-.072.05a16.574 16.574 0 00-1.813 1.734l-.058.058.066.057a15.449 15.45 0 001.991 1.483l.072.05.043-.08a16.738 16.74 0 011.053-1.64v-.05l-.043-.05a16.99 16.99 0 01-1.19-1.54zm1.855 2.071l-.121.172a15.363 15.363 0 00-.917 1.433l-.043.072.071.043a16.61 16.61 0 001.562.766l.193.086-.086-.193a8.04 8.04 0 01-.66-2.172zm-3.976.48v.2a11.758 11.759 0 00.946 3.326l.078.186.072-.194a16.215 16.216 0 01.845-2l.057-.063-.064-.043a17.197 17.198 0 01-1.776-1.284zm2.543 1.805l-.035.08a15.764 15.765 0 00-.983 2.479v.08h.086a16.15 16.152 0 002.688.5l.072.007v-.086a17.562 17.563 0 01.164-2.056v-.065H4.55a16.266 16.266 0 01-1.849-.896zm2.544 1.169v.114a17.254 17.255 0 00-.151 1.828v.078h.931c.287 0 .624.014.946 0h.209l-.166-.129a8.011 8.011 0 01-1.64-1.834zm-3.29 2.1l.115.172a11.988 11.988 0 002.502 2.737l.157.129v-.201a22.578 22.58 0 01-.2-2.336v-.071h-.072a16.23 16.23 0 01-2.3-.387z",source:"https://www.anaconda.com",hex:"44A833",guidelines:void 0,license:void 0},siAerospike={title:"Aerospike",slug:"aerospike",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Aerospike</title><path d="'+this.path+'"/></svg>'},path:"M0 0v24h24V0zm19.295 5.386v1.64l-3.576 1.586v7.363l3.576 1.602v1.565L5.672 12.98l-1.607-.688 1.607-.743zm-4.948 3.825L7.45 12.283l6.897 3.092Z",source:"http://pages.aerospike.com/rs/aerospike/images/Acid_Whitepaper.pdf",hex:"C41E25",guidelines:void 0,license:void 0},siAnalogue={title:"Analogue",slug:"analogue",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Analogue</title><path d="'+this.path+'"/></svg>'},path:"M5.468 12.804a5.145 5.145 0 10-.644 10.27 5.145 5.145 0 00.644-10.27zm17.841 2.562L16.45 3.484a5.146 5.146 0 00-8.912 5.15l6.86 11.878a5.148 5.148 0 007.031 1.885 5.146 5.146 0 001.881-7.031z",source:"https://www.analogue.co/",hex:"1A1A1A",guidelines:void 0,license:void 0},siAndroid={title:"Android",slug:"android",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Android</title><path d="'+this.path+'"/></svg>'},path:"M17.523 15.3414c-.5511 0-.9993-.4486-.9993-.9997s.4483-.9993.9993-.9993c.5511 0 .9993.4483.9993.9993.0001.5511-.4482.9997-.9993.9997m-11.046 0c-.5511 0-.9993-.4486-.9993-.9997s.4482-.9993.9993-.9993c.5511 0 .9993.4483.9993.9993 0 .5511-.4483.9997-.9993.9997m11.4045-6.02l1.9973-3.4592a.416.416 0 00-.1521-.5676.416.416 0 00-.5676.1521l-2.0223 3.503C15.5902 8.2439 13.8533 7.8508 12 7.8508s-3.5902.3931-5.1367 1.0989L4.841 5.4467a.4161.4161 0 00-.5677-.1521.4157.4157 0 00-.1521.5676l1.9973 3.4592C2.6889 11.1867.3432 14.6589 0 18.761h24c-.3435-4.1021-2.6892-7.5743-6.1185-9.4396",source:"https://thepartnermarketinghub.withgoogle.com/brands/android/visual-identity/visual-identity/logo-lock-ups/",hex:"3DDC84",guidelines:void 0,license:void 0},siAdobeacrobatreader={title:"Adobe Acrobat Reader",slug:"adobeacrobatreader",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Adobe Acrobat Reader</title><path d="'+this.path+'"/></svg>'},path:"M23.63 15.3c-.71-.745-2.166-1.17-4.224-1.17-1.1 0-2.377.106-3.761.354a19.443 19.443 0 0 1-2.307-2.661c-.532-.71-.994-1.49-1.42-2.236.817-2.484 1.207-4.507 1.207-5.962 0-1.632-.603-3.336-2.342-3.336-.532 0-1.065.32-1.349.781-.78 1.384-.425 4.4.923 7.381a60.277 60.277 0 0 1-1.703 4.507c-.568 1.349-1.207 2.733-1.917 4.01C2.834 18.53.314 20.34.03 21.758c-.106.533.071 1.03.462 1.42.142.107.639.533 1.49.533 2.59 0 5.323-4.188 6.707-6.707 1.065-.355 2.13-.71 3.194-.994a34.963 34.963 0 0 1 3.407-.745c2.732 2.448 5.145 2.839 6.352 2.839 1.49 0 2.023-.604 2.2-1.1.32-.64.106-1.349-.213-1.704zm-1.42 1.03c-.107.532-.64.887-1.384.887-.213 0-.39-.036-.604-.071-1.348-.32-2.626-.994-3.903-2.059a17.717 17.717 0 0 1 2.98-.248c.746 0 1.385.035 1.81.142.497.106 1.278.426 1.1 1.348zm-7.524-1.668a38.01 38.01 0 0 0-2.945.674 39.68 39.68 0 0 0-2.52.745 40.05 40.05 0 0 0 1.207-2.555c.426-.994.78-2.023 1.136-2.981.354.603.745 1.207 1.135 1.739a50.127 50.127 0 0 0 1.987 2.378zM10.038 1.46a.768.768 0 0 1 .674-.425c.745 0 .887.851.887 1.526 0 1.135-.355 2.874-.958 4.861-1.03-2.768-1.1-5.074-.603-5.962zM6.134 17.997c-1.81 2.981-3.549 4.826-4.613 4.826a.872.872 0 0 1-.532-.177c-.213-.213-.32-.461-.249-.745.213-1.065 2.271-2.555 5.394-3.904Z",source:"https://acrobat.adobe.com/",hex:"EC1C24",guidelines:void 0,license:void 0},siAndroidauto={title:"Android Auto",slug:"androidauto",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Android Auto</title><path d="'+this.path+'"/></svg>'},path:"M12 0c-.6 0-1.11.32-1.39.8L.48 18.4a1.6 1.6 0 0 0 1.39 2.4h2l7.7-13.58.43-.77 8.13 14.35h2a1.6 1.6 0 0 0 1.39-2.4L13.39.8A1.6 1.6 0 0 0 12 0zm0 7.47l-9.07 16 .54.53L12 20.8l8.53 3.2.54-.53z",source:"https://thepartnermarketinghub.withgoogle.com/brands/android-auto/",hex:"3DDC84",guidelines:void 0,license:void 0},siAngularuniversal={title:"Angular Universal",slug:"angularuniversal",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Angular Universal</title><path d="'+this.path+'"/></svg>'},path:"M15.6 11.28v1.44a.48.48 0 0 1-.48.48H8.88a.48.48 0 0 1-.48-.48v-1.44a.48.48 0 0 1 .48-.48h6.24a.48.48 0 0 1 .48.48zM12 15.6a1.2 1.2 0 1 0 0 2.4 1.2 1.2 0 0 0 0-2.4zm3.12-8.4H8.88a.48.48 0 0 0-.48.48v1.44c0 .265.215.48.48.48h6.24a.48.48 0 0 0 .48-.48V7.68a.48.48 0 0 0-.48-.48zm8.04-3.204l-1.716 14.736L11.976 24 2.52 18.732.84 3.996 11.976 0 23.16 3.996zM16.8 6.24a1.44 1.44 0 0 0-1.44-1.44H8.64A1.44 1.44 0 0 0 7.2 6.24v11.52c0 .795.645 1.44 1.44 1.44h6.72a1.44 1.44 0 0 0 1.44-1.44V6.24z",source:"https://angular.io/presskit",hex:"00ACC1",guidelines:void 0,license:void 0},siAngularjs={title:"AngularJS",slug:"angularjs",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AngularJS</title><path d="'+this.path+'"/></svg>'},path:"M11.964 0L.672 3.974l1.784 14.794L11.976 24l9.568-5.303 1.784-14.794zm-.027 1.258l10.265 3.5-1.663 13.232-8.602 4.76-8.469-4.697L1.939 4.822zm0 .78L4.957 17.57l2.604-.048 1.4-3.501h6.257l1.532 3.55 2.492.046zm.02 4.98l2.355 4.93H9.878Z",source:"https://angularjs.org/",hex:"E23237",guidelines:void 0,license:void 0},siAlfaromeo={title:"Alfa Romeo",slug:"alfaromeo",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Alfa Romeo</title><path d="'+this.path+'"/></svg>'},path:"M13.539 5.4052a.2158.2158 0 1 0 0-.4318.2158.2158 0 1 0 0 .4318zm-9.3055 1.576l-.6533 1.2987-1.3365-.7-.276.5514a.4317.4317 0 0 1 .0917-.0097c.0556 0 .1107.0105.1536.0301l1.4923.7814.8869-1.764zm15.7221.4324l.3109-.1689.509.9792.3498-.1894-.5095-.9791.2969-.1608.7336 1.4093.3494-.1896-1.0138-1.9486c-.0371.0863-.1084.1592-.1651.1888l-1.451.787 1.0071 1.9358.3497-.1897zm-7.2864-2.0084a.2158.2158 0 1 0 0-.4318.2158.2158 0 1 0 0 .4318zm5.0574 1.5187l.0027.0031c1.1982 1.3498 1.9262 3.1265 1.9262 5.0732 0 3.1035-1.8496 5.7747-4.5065 6.9728-.009.0044-.0178.0093-.0271.0134l.0021-.0018.025-.0116c.4345-.2065.7352-.6488.7352-1.1619 0-.7107-.576-1.2865-1.2867-1.2865l-1.3545-.0012a.1656.1656 0 1 1 0-.3312h2.2875c1.0767 0 1.9496-.8729 1.9496-1.9497 0-1.0767-.8729-1.9497-1.9496-1.9497l-.2906.0003h-1.9184a.1656.1656 0 1 1 0-.3311l1.6868-.0019c1.7798 0 3.2227-1.4428 3.2227-3.2226a3.207 3.207 0 0 0-.5307-1.772l-.0085-.012a.023.023 0 0 1-.0046-.0135c0-.013.0106-.0235.0236-.0235.008 0 .0114.0012.0158.0074zm-3.258 12.3178a7.6339 7.6339 0 0 1-2.459.4041c-1.148 0-2.2368-.2534-3.214-.707v-6.0254h2.1652a2.4299 2.4299 0 0 1-.1227-.765c0-.4029.0986-.783.2719-1.1181H8.7957v-5.969c.9771-.4535 2.0658-.707 3.214-.707 1.3347 0 2.5898.3422 3.6818.9435h.0007c.1562.0988.26.273.26.4717a.5572.5572 0 0 1-.5573.5572l-.0122-.0004h-.1792l-.76.0009c-.2677 0-.4145.079-.5066.159-.2655.2302-.1745.5029-.7192.5029h-1.5022c.2032.4685.6696.8067.7856.8855h1.845a.1784.1784 0 0 1 .1655.112.1561.1561 0 0 1 .0102.0971.1786.1786 0 0 1-.1757.1483H12.468c-.1443.0754-.5827.3489-.785.9661h3.39a.4006.4006 0 1 1 0 .8012l-1.7171-.0002c-1.1836 0-2.1431.9595-2.1431 2.143 0 1.1837.9595 2.1432 2.143 2.1432h2.1414c.0915 0 .1656.0765.1656.168a.1638.1638 0 0 1-.1656.1634h-2.193c-.8671 0-1.5701.7028-1.5701 1.5697 0 .8671.703 1.57 1.57 1.57l.8284.0028c.4185 0 .7632.3512.7632.7667 0 .3396-.2049.5791-.427.7158zm-7.5559-8.2114H4.425c.2368-1.8715 1.1506-3.532 2.4878-4.7287zm0 6.6683c-1.3505-1.209-2.2688-2.8907-2.4943-4.7852h2.4943zm5.097-13.7579c-4.451 0-8.0594 3.6083-8.0594 8.0595 0 4.4508 3.6084 8.0594 8.0593 8.0594 4.4512 0 8.0595-3.6086 8.0595-8.0594 0-4.4512-3.6083-8.0595-8.0595-8.0595zm-.301 2.009h1.9023a.1443.1443 0 0 0 .144-.144.1445.1445 0 0 0-.144-.1442h-1.9023a.1445.1445 0 0 0-.144.1442c0 .0793.0649.144.144.144zm.072-.5445a.2159.2159 0 1 0 0-.4318.2158.2158 0 1 0 0 .4318zm.2988 2.6522l.027-.0257v-.0002l-.027-.0259c-.421-.3057-.6075-.6844-.7201-.9775-.0777-.202-.1652-.3679-.2925-.4893-.1322-.1258-.2285-.1927-.4192-.1927a.9713.9713 0 0 0-.2302.0292l-.0456.011.0283.0525c.0422.0783.1205.2238.2576.2656a.1193.1193 0 0 0 .0356.0046.386.386 0 0 0 .0332-.0019c.009-.0008.0178-.0017.0261-.0017.0093 0 .0123.0013.0124.0013.148.0856.2255.7166.2255 1.031 0 .0537-.0222.078-.0718.078-.0493 0-.1136-.027-.153-.0641-.0867-.0935-.2107-.146-.347-.146-.2223 0-.458.1499-.4673.4005v.0509c.0094.2506.245.4005.4674.4005.1362 0 .2602-.0525.3469-.146.0394-.037.1037-.0639.153-.0639.0496 0 .0718.024.0718.0778 0 .3144-.0776.9454-.2255 1.031 0 0-.003.0012-.0124.0012a.2845.2845 0 0 1-.026-.0016.386.386 0 0 0-.0333-.0019.1194.1194 0 0 0-.0356.0046c-.1371.0418-.2154.1873-.2576.2656l-.0283.0525.0456.0112a.9836.9836 0 0 0 .2302.029c.1907 0 .287-.0667.4192-.1927.1273-.1214.2148-.2873.2925-.4893.1126-.2931.299-.6718.7201-.9776zm-9.4412 2.1223l-.1222.8035-.6999-.5284zm-1.2738.6372a.2464.2464 0 0 1 .097-.0193.2522.2522 0 0 1 .1233.0318l.0028.0016 1.5266 1.1735.0775-.5098-.3103-.2336.1861-1.2242.3638-.1216.0773-.5089-2.0309.683zM12 23.52C5.6378 23.52.48 18.3622.48 12S5.6379.4803 12 .4803C18.3622.4803 23.5198 5.6378 23.5198 12c0 6.3622-5.1575 11.52-11.5198 11.52zM12 .0003C5.3727.0003 0 5.3728 0 12c0 6.6272 5.3727 11.9997 12 11.9997 6.6274 0 12-5.3725 12-11.9997C24 5.3728 18.6274.0003 12 .0003zm2.6675 2.643c.0793-.23.2747-.3568.5505-.3568.1153 0 .2378.023.364.0684.4398.1581.6498.4752.5349.8078-.0796.2313-.2755.3589-.5513.3589-.116 0-.2393-.0232-.3665-.0689-.4384-.1575-.6471-.4752-.5316-.8095zm.3924 1.2166c.195.0701.389.1057.5764.1057h.0001c.4753 0 .8395-.2332.9743-.624.0951-.276.052-.57-.1214-.828-.1655-.2464-.4383-.4475-.7682-.566-.1902-.0683-.3816-.103-.5682-.103-.4793 0-.8453.2316-.9795.6199-.1917.5552.181 1.1422.8865 1.3954zm3.0944.1594l-.1837 1.4554.023.0215 1.3938-.3266-.766 1.037.3757.3504 1.1621-1.5327-.4317-.4023-1.2158.2723.1485-1.2671-.452-.4215h-.0004l-.0554-.0512c-.0045.0915-.0427.184-.0945.234l-1.2044 1.1699.3777.3522zm3.6243 7.4815a.5396.5396 0 0 1-.0919.008c-.3011 0-.5317-.2627-.602-.6852-.0776-.4672.0937-.8074.437-.8671a.5656.5656 0 0 1 .0904-.0076c.2959 0 .5317.2678.6006.6827.078.4686-.0923.8099-.4341.8692zm.8493-.9418c-.1124-.6738-.5424-1.1443-1.0459-1.1443a.8997.8997 0 0 0-.1481.0128c-.568.0989-.8894.7165-.7643 1.4687.1143.6858.5346 1.1466 1.0457 1.1466a.883.883 0 0 0 .1512-.0132c.5663-.0983.8867-.7167.7614-1.4706zM12.4323 1.7271h.0001c.1613 0 .2707.1156.2722.288.0014.174-.104.2832-.2751.2846l-.9892.0087-.005-.5726zm-1.495 1.5232l.5109-.0045-.0045-.532.8572-.0077.3746.5292.5696-.005-.4303-.5697.053-.0254c.2187-.1048.3427-.3229.3402-.5984-.0037-.4345-.29-.7154-.7288-.7154l-1.5587.0134v.0006l-.09.0005c.0533.0645.0872.1498.0923.2213zm-3.3844.3238l-.7046.4047-.0227-.8766zm-1.1647-.4215l.0006.0034.0334 1.927.4472-.2571-.0108-.3882 1.0735-.6173.3217.209.4463-.2565-1.7995-1.1634-.64.3654a.2541.2541 0 0 1 .1276.1777zM3.748 5.5746L4.9572 6.735l.3507-.3805-.4455-.4277.744-.8074-.2887-.2772-.7443.8074-.344-.3301 1.0713-1.1627-.2887-.277-1.4859 1.6131c.0782.0052.1643.036.22.0802l.0018.0014Z",source:"http://www.fcaci.com/x/Alfa",hex:"981E32",guidelines:void 0,license:void 0},siAlfred={title:"Alfred",slug:"alfred",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Alfred</title><path d="'+this.path+'"/></svg>'},path:"m0 15.902c0-1.142 1.133-2.184 3-2.977v-1.827c0-4.142 4.029-7.5 9-7.5s9 3.358 9 7.5v1.827c1.867.793 3 1.835 3 2.977 0 2.485-5.373 4.5-12 4.5s-12-2.015-12-4.5z",source:"https://www.alfredapp.com/",hex:"5C1F87",guidelines:void 0,license:void 0},siAlliedmodders={title:"AlliedModders",slug:"alliedmodders",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AlliedModders</title><path d="'+this.path+'"/></svg>'},path:"M.588 1.077A.615.615 0 0 0 0 1.69v20.617c0 .34.275.615.615.615h8.309c.34 0 .615-.275.615-.615v-1.746l.647 1.94a.615.615 0 0 0 .584.421h6.77a.615.615 0 0 0 .585-.427l.035-.11c.04.307.3.537.61.537h4.615c.34 0 .615-.275.615-.615V8.153a.615.615 0 0 0-.447-.592l-4.307-1.23a.615.615 0 0 0-.744.37l-1.887 4.907v-5.55a.615.615 0 0 0-.443-.593l-3.385-.98a.615.615 0 0 0-.787.59v6.15l-2.809-7.48a.615.615 0 0 0-.408-.375l-8-2.272a.615.615 0 0 0-.195-.021zm.027.613l8 2.272 4 10.652v-9.54L16 6.058v8.865l3.076-8 4.309 1.231v14.154H18.77v-2.463h1.845v-7.076l-3.076 9.54h-6.77L6.155 8.46v11.078h2.77v2.77H.615zm.615.816V21.69h7.08v-1.537H6.154a.615.615 0 0 1-.615-.615V8.46c.002-.698.979-.855 1.2-.194l4.474 13.424h5.877l2.94-9.111c.215-.668 1.201-.513 1.2.19v7.075c0 .34-.275.615-.615.616h-1.23v1.23h3.385V8.616l-3.32-.947-2.876 7.474c-.245.635-1.188.46-1.19-.22V6.52l-2.154-.625v8.719c0 .685-.95.857-1.19.217L8.147 4.467zm5.54 9.747l2.224 6.67c-.734-.01-1.485 0-2.224 0zM20 16.683v2.546h-.822Z",source:"https://forums.alliedmods.net/",hex:"1578D3",guidelines:void 0,license:void 0},siAlgolia={title:"Algolia",slug:"algolia",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Algolia</title><path d="'+this.path+'"/></svg>'},path:"M3.16 0A3.156 3.156 0 000 3.152v17.69A3.161 3.161 0 003.16 24h17.68c1.747 0 3.16-1.42 3.16-3.16V3.16C24 1.413 22.58 0 20.84 0H3.16zm7.87 3.494h2.429A1.04 1.04 0 0114.5 4.535v.822a.14.14 0 01-.174.14 7.679 7.647 0 00-2.043-.276 7.564 7.533 0 00-2.113.297c-.095.021-.182-.045-.182-.14v-.843a1.044 1.04 0 011.041-1.04zm-4.35 2.22a1.04 1.035 0 01.75.306l.414.416c.058.065.051.167-.022.21a7.544 7.513 0 00-.941.801 8 7.967 0 00-.793.932c-.058.065-.153.08-.219.016l-.408-.409a1.043 1.04 0 010-1.472l.496-.494a1.04 1.035 0 01.723-.305zm5.597.35a6.774 6.774 0 016.787 6.778 6.784 6.784 0 01-6.787 6.783c-3.748 0-6.789-3.028-6.789-6.777a6.786 6.786 0 016.79-6.784zm0 2.008a4.783 4.783 0 00-4.783 4.776 4.783 4.783 0 004.783 4.775 4.777 4.777 0 004.784-4.775 4.782 4.782 0 00-4.784-4.776zm.145.838a3.935 3.919 0 013.281 1.988c.036.073.015.16-.057.196l-3.166 1.638c-.093.052-.205-.023-.205-.125V9.05h.002c0-.08.072-.139.145-.139Z",source:"https://www.algolia.com/press/?section=brand-guidelines",hex:"5468FF",guidelines:void 0,license:void 0},siAldisud={title:"Aldi S\xFCd",slug:"aldisud",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Aldi S&#252;d</title><path d="'+this.path+'"/></svg>'},path:"M18.164 10.92c-.243-.558-.558-.655-1.044-.655h-4.368l-.412 1.189a.727.727 0 0 1-.097.243h5.533c.315 0 .582.048.8.315h.049c0 .024-.437-1.02-.461-1.092zm-.898-2.135c-.243-.51-.534-.583-1.02-.583h-2.79l-.485 1.432h3.955c.364 0 .631.049.825.315h.049s-.486-1.043-.534-1.164zm-.874-2.063c-.267-.534-.534-.582-1.019-.582h-1.238l-.485 1.43h2.403c.34 0 .63.049.825.316h.048c0-.025-.485-1.02-.534-1.165zM9.355 3.519c-.68 0-.97.485-1.238 1.237L5.424 12.74h.68c.679 0 .97-.485 1.237-1.237l2.354-6.94c.194-.607.485-.947.922-.996V3.52zm4.416-.025c-.679 0-.97.486-1.237 1.238l-2.354 6.916c-.194.607-.461.947-.898.995v.049h1.213c.68 0 .971-.486 1.238-1.238l2.354-6.916c.194-.607.485-.946.922-.995v-.049zm-2.208 0c-.68 0-.97.486-1.237 1.238l-2.33 6.94c-.194.607-.461.947-.898.995v.049h1.213c.68 0 .971-.485 1.238-1.238l2.354-6.916c.194-.606.485-.946.922-.995V3.52c-.218-.025-1.213-.025-1.262-.025zm.364 16.842c-.558 0-.655-.243-.655-.825v-.923h.461v1.044c0 .267.024.388.218.388.17 0 .219-.097.219-.388v-1.044h.437v.923c0 .63-.17.825-.68.825zm.316-1.917a.217.217 0 0 1-.219-.219c0-.121.097-.242.219-.242.121 0 .218.12.218.242a.217.217 0 0 1-.218.219zm-.631 0a.217.217 0 0 1-.219-.219c0-.121.097-.242.219-.242.121 0 .218.12.218.242a.217.217 0 0 1-.218.219zm1.31 1.868v-1.699h.485c.607 0 .874.122.874.85s-.267.85-.874.85zm.558-.291c.243 0 .34-.146.34-.558 0-.388-.097-.558-.34-.558h-.097v1.116zm-3.154.34c-.267 0-.461-.049-.559-.073l.073-.316c.17.049.291.073.389.073.12 0 .266-.024.266-.17 0-.097-.12-.17-.242-.242h-.024c-.195-.122-.413-.243-.413-.51 0-.315.218-.485.63-.485.22 0 .34.024.51.073l-.072.29a.924.924 0 0 0-.364-.072c-.146 0-.243.048-.243.17 0 .097.121.17.267.242h.024c.194.122.437.243.437.51 0 .316-.218.51-.68.51zM8.36 17.569c-.049-.194-.121-.534-.17-.68H6.855c-.048.146-.12.486-.17.68H5.497c.51-1.601.728-2.257 1.31-3.688h1.457c.558 1.407.8 2.087 1.31 3.688zm-1.335-1.456h.995c-.145-.485-.412-1.31-.485-1.553-.097.219-.364 1.044-.51 1.553zm3.834 1.456c-.63 0-.97-.364-.97-.995v-2.693h1.116v2.475c0 .315.097.388.413.388h1.092l.17.825zm6.334-3.688h1.116v3.688h-1.116zm-4.077 3.688v-3.688h1.53c1.14 0 1.916.46 1.916 1.82 0 1.31-.63 1.868-1.868 1.868zm1.117-.8h.315c.68 0 .946-.316.946-1.068 0-.728-.34-1.02-.995-1.02h-.266zm5.532 4.732c0 .17-.145.29-.29.29H4.55a.295.295 0 0 1-.291-.29V2.475c0-.17.145-.291.291-.291h14.924c.17 0 .291.146.291.291zM4.065 1.626a.383.383 0 0 0-.389.388v19.948c0 .218.17.388.389.388h15.87c.219 0 .389-.17.389-.388V2.014a.383.383 0 0 0-.389-.388zM2.803 0a.808.808 0 0 0-.801.8v22.4c0 .436.364.8.8.8h18.395a.808.808 0 0 0 .801-.8V.8c0-.436-.364-.8-.8-.8zm.704.946h17.01a.54.54 0 0 1 .535.534l-.025 21.04a.539.539 0 0 1-.534.534H3.507a.539.539 0 0 1-.534-.534V1.48a.54.54 0 0 1 .534-.534z",source:"https://www.aldi-sued.de",hex:"00005F",guidelines:void 0,license:void 0},siAlibabadotcom={title:"Alibaba.com",slug:"alibabadotcom",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Alibaba.com</title><path d="'+this.path+'"/></svg>'},path:"M14.391 16.22c-.963.044-.865-.459-.302-1.234 1.32-1.768 3.82-4.236 3.906-5.982.151-2.283-2.143-3.026-4.501-3.004-1.645.022-3.344.492-4.501.906C5 8.315 2.489 10.576.909 13.076-.768 15.554-.216 17.923 3.322 18c2.716-.109 4.48-.862 6.32-1.802.01 0-5.086 1.453-6.958.383l-.008-.002c-.193-.11-.404-.264-.457-.683-.012-.885 1.46-1.802 2.283-2.097v-1.533a5.374 5.374 0 0 0 1.955.366 5.378 5.378 0 0 0 3.472-1.265c.037.13.056.278.044.447h.371c.048-.394-.172-.706-.172-.706-.333-.529-.915-.52-.915-.52s.315.137.529.466a4.953 4.953 0 0 1-4.665.932l1.21-1.2-.336-.874c2.435-.852 4.48-1.507 7.812-2.085l-.746-.624.389-.24c2.01.568 3.325.985 3.253 2.051a2.672 2.672 0 0 1-.202.611c-.584 1.158-2.326 3.09-3.029 3.898-.465.535-.92 1.06-1.245 1.562-.335.503-.54.971-.551 1.42.043 3.504 10.334-1.64 12.324-3.003-2.943 1.266-6.113 2.489-9.609 2.718Z",source:"https://www.alibabagroup.com/en/ir/reports",hex:"FF6A00",guidelines:void 0,license:void 0},siAlibabacloud={title:"Alibaba Cloud",slug:"alibabacloud",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Alibaba Cloud</title><path d="'+this.path+'"/></svg>'},path:"M3.996 4.517h5.291L8.01 6.324 4.153 7.506a1.668 1.668 0 0 0-1.165 1.601v5.786a1.668 1.668 0 0 0 1.165 1.6l3.857 1.183 1.277 1.807H3.996A3.996 3.996 0 0 1 0 15.487V8.513a3.996 3.996 0 0 1 3.996-3.996m16.008 0h-5.291l1.277 1.807 3.857 1.182c.715.227 1.17.889 1.165 1.601v5.786a1.668 1.668 0 0 1-1.165 1.6l-3.857 1.183-1.277 1.807h5.291A3.996 3.996 0 0 0 24 15.487V8.513a3.996 3.996 0 0 0-3.996-3.996m-4.007 8.345H8.002v-1.804h7.995Z",source:"https://www.alibabagroup.com/en/ir/reports",hex:"FF6A00",guidelines:void 0,license:void 0},siAlipay={title:"Alipay",slug:"alipay",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Alipay</title><path d="'+this.path+'"/></svg>'},path:"M16.076,13.732c0.862-1.494,1.55-3.196,2.003-5.045h-4.731V6.988h5.795V6.04h-5.795V3.207h-2.365 c-0.415,0-0.415,0.408-0.415,0.408V6.04H4.707v0.948h5.861v1.699H5.729v0.948h9.386c-0.343,1.18-0.805,2.288-1.352,3.294 c-3.045-1.002-6.295-1.814-8.337-1.314c-1.305,0.321-2.146,0.893-2.641,1.493c-2.267,2.751-0.641,6.929,4.147,6.929 c2.831,0,5.559-1.574,7.673-4.168C17.758,17.381,24,19.976,24,19.976v0.157c0,2.117-1.719,3.833-3.843,3.833H3.845 C1.72,23.966,0,22.249,0,20.132V3.868C0,1.75,1.72,0.034,3.845,0.034h16.312C22.281,0.034,24,1.75,24,3.868v12.409 c0,0-0.784-0.062-4.24-1.216C18.8,14.74,17.511,14.25,16.076,13.732z M5.834,13.034c-0.6,0.059-1.725,0.324-2.341,0.866 c-1.845,1.604-0.741,4.537,2.993,4.537c2.17,0,4.339-1.384,6.042-3.599C10.104,13.659,8.052,12.816,5.834,13.034z",source:"https://gw.alipayobjects.com/os/rmsportal/trUJZfSrlnRCcFgfZGjD.ai",hex:"00A1E9",guidelines:void 0,license:void 0},siAlitalia={title:"Alitalia",slug:"alitalia",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Alitalia</title><path d="'+this.path+'"/></svg>'},path:"M5.429 20.551H0l14.257-14.87c1.622-1.765 2.878-2.232 4.686-2.232H24L21.602 20.55h-4.17L19.49 5.907M15.7 20.551l1.384-9.842-9.457 9.842Z",source:"https://www.alitalia.com/it_it/fly-alitalia/in-flight/ulisse-magazine.html",hex:"006643",guidelines:void 0,license:void 0},siAliexpress={title:"AliExpress",slug:"aliexpress",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AliExpress</title><path d="'+this.path+'"/></svg>'},path:"M5.166 9.096a.022.022 0 0 0-.022.021c0 .396-.32.717-.713.717a.021.021 0 0 0-.021.022c0 .012.01.021.021.021.394 0 .713.322.713.718 0 .012.01.021.022.021.011 0 .021-.01.021-.021A.717.717 0 0 1 5.9 9.88a.021.021 0 0 0 0-.043.716.716 0 0 1-.713-.718v-.002a.021.021 0 0 0-.006-.015.022.022 0 0 0-.015-.006zm-3.693.526L0 13.462h.48l.355-.922h1.782l.354.922h.481L1.98 9.622zm2.264.002v3.838h.491V9.624zm2.375 0v3.838h2.413v-.502H6.613v-1.19H8.19v-.477H6.613v-1.166h1.773v-.502zm-4.386.592l.698 1.82H1.028zm14.689.402a1.466 1.466 0 0 0-.966.366V10.7h-.491v2.763h.49c.002-.477 0-.955.002-1.433a.969.969 0 0 1 .965-.918zm4.18.007c-.053 0-.105.003-.158.01-.315.031-.606.175-.753.377a.689.689 0 0 0-.14.465c.007.2.066.357.233.496.184.147.42.2.657.259.311.067.426.095.546.186.08.07.133.127.136.27 0 .25-.221.372-.42.41a.89.89 0 0 1-.894-.344l-.371.288c.33.382.777.505 1.09.5.54-.01.891-.217 1.029-.534.066-.153.063-.309.063-.38a.677.677 0 0 0-.267-.545c-.228-.177-.583-.228-.636-.242-.437-.078-.658-.196-.697-.341-.043-.192.102-.35.297-.411a.76.76 0 0 1 .857.277l.367-.247a1.166 1.166 0 0 0-.939-.494zm2.387 0c-.052 0-.105.003-.157.01-.316.031-.607.175-.753.377a.689.689 0 0 0-.14.465c.006.2.065.357.233.496.183.147.42.2.657.259.31.067.426.095.545.186.081.07.134.127.136.27.001.25-.221.372-.42.41a.89.89 0 0 1-.894-.344l-.371.288c.33.382.777.505 1.09.5.541-.01.891-.217 1.03-.534.065-.153.062-.309.062-.38a.677.677 0 0 0-.267-.545c-.227-.177-.583-.228-.636-.242-.437-.078-.658-.196-.696-.341-.043-.192.101-.35.297-.411a.76.76 0 0 1 .857.277l.367-.247a1.167 1.167 0 0 0-.94-.494zm-9.84.002a1.461 1.461 0 0 0-1.42 1.117 1.305 1.305 0 0 0-.041.327v2.833h.491v-1.813c.17.18.487.42.96.454a1.447 1.447 0 0 0 1.208-.627 1.457 1.457 0 0 0-1.199-2.292zm4.804 0a1.448 1.448 0 0 0-1.288 2.08c.255.53.811.87 1.412.833a1.452 1.452 0 0 0 1.012-.51l-.363-.291a.968.968 0 0 1-1.106.273 1.01 1.01 0 0 1-.602-.69h2.239l.002-.427a1.295 1.295 0 0 0-1.306-1.268zm-9.2.08l1.062 1.377-1.062 1.378h.581l.779-1.01.778 1.01h.581l-1.062-1.378 1.062-1.378h-.581l-.778 1.01-.779-1.01zm-3.825.015v2.74h.49v-2.74zm8.233.37a.96.96 0 0 1 .95.993.963.963 0 0 1-.863.998.962.962 0 0 1-1.034-.739c-.074-.382 0-.746.307-1.019a.959.959 0 0 1 .64-.233zm4.79.015a.823.823 0 0 1 .819.755h-1.76a.964.964 0 0 1 .94-.755z",source:"https://www.alibabagroup.com/en/ir/reports",hex:"FF4747",guidelines:void 0,license:void 0},siAnchor={title:"Anchor",slug:"anchor",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Anchor</title><path d="'+this.path+'"/></svg>'},path:"M23.214 8.166S22.209 7.69 21.164 8c-.782.23-1.638.824-2.125 2.055-.939 2.363-.126 6.484-.444 6.484s-1.319-3.797-2.658-7.752c-1.34-3.954-2.497-8.061-4.588-7.73-1.854.293-1.279 4.976-.553 9.362.658 3.976 1.419 7.698.984 7.698-.777.001-3.326-10.988-5.939-10.57-2.613.416.753 12.525.046 12.548-.581.019-2.006-7.37-4.121-7.031-1.602.257-.175 6.006-.109 7.61.016.402.141 1.157-.461 1.157H0v1.118h1.958c.402-.02.72-.174.881-.57.544-1.342-.884-7.042-.55-7.084.23-.028.725 1.707 1.416 3.67.69 1.963 1.383 3.995 2.696 3.995 2.83 0-.057-11.121.504-11.121.297 0 1.106 2.26 1.995 4.738 1.089 3.028 2.416 6.387 4.018 6.387 1.912 0 1.29-4.338.698-8.495-.513-3.598-1.114-6.978-.793-6.978.721 0 3.447 15.467 6.72 15.467 1.64 0 1.658-3.233 1.658-6.72 0-2.448-.204-4.68 1.331-5.217.73-.254 1.468.198 1.468.198Z",source:"https://anchor.fm/",hex:"5000B9",guidelines:void 0,license:void 0},siAndela={title:"Andela",slug:"andela",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Andela</title><path d="'+this.path+'"/></svg>'},path:"M11.996.002c-.365.01-.588.29-.828.574L8.553 3.674 10.53 4.75 12 2.943l1.469 1.805 1.978-1.074L12.83.576c-.24-.284-.462-.564-.826-.574zM8.553 3.674l-4.041-.34c-.371-.03-.727-.072-.992.178h-.002l-.002.004-.002.002c-.251.265-.21.624-.178.994l.338 4.039 2.162-.64-.24-2.315 2.314.238zM3.673 8.55L.577 11.168c-.283.24-.564.462-.574.826H0L.002 12v.004c.01.365.291.588.574.828l3.098 2.617 1.074-1.98L2.943 12l1.805-1.469zm0 6.898s-.307 3.665-.337 4.041c-.031.37-.074.727.176.992l.004.004.002.002c.265.251.624.21.994.18l4.039-.342-.64-2.158-2.315.236.238-2.314zm4.878 4.877l2.619 3.1c.239.28.461.564.826.574h.008v-.002c.365-.01.587-.291.828-.572l2.617-3.1-1.98-1.074L12 21.059l-1.469-1.807zm6.898 0l4.041.34c.368.03.727.072.992-.178l.002-.004.002-.002c.251-.265.212-.622.182-.992l-.342-4.04-2.16.64.238 2.316-2.314-.24zm4.877-4.877l3.098-2.619c.282-.239.566-.461.576-.826A.01.01 0 0 1 24 12v-.004h-.002c-.01-.365-.291-.587-.572-.828-.29-.242-3.1-2.617-3.1-2.617l-1.074 1.98L21.059 12l-1.807 1.47zm0-6.898l.34-4.041c.03-.368.072-.726-.178-.992l-.004-.002c0-.001 0-.002-.002-.002-.265-.251-.622-.212-.992-.182-.376.033-4.04.34-4.04.342l.64 2.16 2.316-.238-.24 2.314zm-8.328-1.723c-.404 0-.592.363-.666.576l-3.3 8.17c0 .005-.127.278-.102.313.025.035.067.052.12.052h1.014c.1 0 .168-.053.217-.168l.81-1.986h3.811l.817 1.986c.048.115.118.168.219.168h1.011c.053 0 .097-.017.121-.052.026-.035-.101-.309-.101-.313l-3.301-8.17c-.073-.213-.265-.576-.67-.576zM12 9.09l.002.004V9.09l1.42 3.445c-.947-.002-1.895-.002-2.842-.002z",source:"https://andela.com/press/",hex:"3359DF",guidelines:void 0,license:void 0},siAllegro={title:"Allegro",slug:"allegro",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Allegro</title><path d="'+this.path+'"/></svg>'},path:"M4.59 7.981a.124.124 0 0 0-.122.124v5.917a.124.124 0 0 0 .124.124h.72a.124.124 0 0 0 .124-.124h-.002V8.105a.124.124 0 0 0-.124-.124Zm1.691 0a.124.124 0 0 0-.124.124v5.917a.124.124 0 0 0 .124.124h.72a.124.124 0 0 0 .123-.124V8.105a.124.124 0 0 0-.122-.124Zm12.667 1.776a1.868 1.868 0 0 0-1.317.532 1.674 1.674 0 0 0-.531 1.254v2.48a.124.124 0 0 0 .123.123h.72a.124.124 0 0 0 .124-.124v-2.427c0-.752.5-1.113 1.314-.946a.13.13 0 0 0 .168-.142v-.495c0-.13-.014-.18-.1-.208a2.794 2.794 0 0 0-.501-.047Zm-4.626 0a2.193 2.193 0 0 0-1.732.849 2.355 2.355 0 0 0 0 2.678 2.13 2.131 0 0 0 1.732.849 2.21 2.21 0 0 0 1.234-.372v.53c0 .717-.627.848-1.03.873a4.73 4.73 0 0 1-.826-.045c-.11-.017-.188 0-.188.119v.636a.109.109 0 0 0 .114.103c.933.08 1.56.064 2.032-.206a1.537 1.537 0 0 0 .69-.875 2.928 2.928 0 0 0 .117-.874v-2.077h.002a2.245 2.245 0 0 0-.412-1.34 2.193 2.193 0 0 0-1.733-.848Zm-12.255.002a2.903 2.903 0 0 0-1.465.39.092.092 0 0 0-.045.08l.038.63a.112.112 0 0 0 .185.065c.627-.387 1.38-.459 1.764-.265a.67.67 0 0 1 .335.605v.092H1.832c-.45 0-1.83.167-1.83 1.434v.014a1.229 1.229 0 0 0 .45 1.017 1.768 1.768 0 0 0 1.118.32h2.118a.124.124 0 0 0 .124-.125v-2.51l-.002.004c0-.57-.127-1.004-.402-1.303-.274-.3-.827-.45-1.34-.45zm7.707 0c-1.28 0-1.84.858-2.02 1.585a2.44 2.44 0 0 0-.074.6 2.277 2.277 0 0 0 .412 1.338 2.198 2.198 0 0 0 1.733.85c.691.024 1.153-.093 1.506-.294a.196.196 0 0 0 .084-.212v-.558c0-.114-.069-.167-.167-.098a2.185 2.185 0 0 1-1.393.334 1.14 1.14 0 0 1-1.118-1.016h2.845a.117.117 0 0 0 .117-.116c.05-.778-.175-2.413-1.925-2.413Zm12.08 0a2.193 2.193 0 0 0-1.731.848 2.275 2.275 0 0 0-.412 1.34 2.275 2.275 0 0 0 .412 1.339 2.193 2.193 0 0 0 3.465 0 2.277 2.277 0 0 0 .412-1.34 2.277 2.277 0 0 0-.412-1.339 2.193 2.193 0 0 0-1.733-.848Zm-7.532.833c1.157 0 1.196 1.18 1.196 1.351 0 .171-.039 1.351-1.196 1.351-.517 0-.89-.378-1.047-.849a1.552 1.552 0 0 1 0-1.004c.157-.47.53-.849 1.047-.849zm-4.546.004a.86.86 0 0 1 .91.922H8.754a.968.968 0 0 1 1.024-.922zm12.078 0c.515-.012.89.378 1.048.848a1.553 1.553 0 0 1 0 1.003v.002c-.158.47-.531.837-1.048.848-.518.012-.89-.378-1.047-.848a1.552 1.552 0 0 1 0-1.005c.158-.47.53-.837 1.047-.848zM1.89 12.121h.99v1.246H1.63a.773.773 0 0 1-.444-.156.492.492 0 0 1-.21-.412c0-.226.153-.678.914-.678z",source:"https://allegro.pl/",hex:"FF5A00",guidelines:void 0,license:void 0},siAmazonalexa={title:"Amazon Alexa",slug:"amazonalexa",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Amazon Alexa</title><path d="'+this.path+'"/></svg>'},path:"M12 0C5.37 0 0 5.37 0 12C0 18.09 4.53 23.11 10.4 23.9V21.5A1.59 1.59 0 0 0 9.32 19.97A8.41 8.41 0 0 1 3.6 11.8A8.37 8.37 0 0 1 12.09 3.6A8.4 8.4 0 0 1 20.4 12.31L20.39 12.38A8.68 8.68 0 0 1 20.36 12.76C20.36 12.83 20.35 12.9 20.34 12.96C20.34 13.04 20.33 13.12 20.32 13.19L20.3 13.29C19.27 20.07 10.45 23.87 10.4 23.9C10.92 23.97 11.46 24 12 24C18.63 24 24 18.63 24 12S18.63 0 12 0Z",source:"https://developer.amazon.com/docs/alexa-voice-service/logo-and-brand.html",hex:"00CAFF",guidelines:void 0,license:void 0},siAlltrails={title:"AllTrails",slug:"alltrails",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AllTrails</title><path d="'+this.path+'"/></svg>'},path:"M23.694 18.72c-3.845-4.058-12.083-5.754-17.345-3.216l5.504-7.623 2.63 4.163c.148.246.47.32.71.164l1.993-1.333c1.684 1.806 3.358 3.618 4.796 5.158a.19.19 0 00.322-.139.185.185 0 00-.023-.088h.001c-1.41-2.458-2.826-4.913-4.25-7.364-.254-.434-.552-.503-.986-.219l-1.34.921-3.382-5.226a.587.587 0 00-.494-.275.574.574 0 00-.487.265A5684.859 5684.859 0 01.08 18.973v.002c-.2.28-.001.67.343.671.175-.002.331-.124.488-.2 3.142-1.626 10.197-3.996 15.073-.26 2.141 1.817 9.61 1.408 7.71-.465",source:"https://www.alltrails.com/",hex:"428813",guidelines:void 0,license:void 0},siAlpinelinux={title:"Alpine Linux",slug:"alpinelinux",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Alpine Linux</title><path d="'+this.path+'"/></svg>'},path:"M5.998 1.607L0 12l5.998 10.393h12.004L24 12 18.002 1.607H5.998zM9.965 7.12L12.66 9.9l1.598 1.595.002-.002 2.41 2.363c-.2.14-.386.252-.563.344a3.756 3.756 0 01-.496.217 2.702 2.702 0 01-.425.111c-.131.023-.25.034-.358.034-.13 0-.242-.014-.338-.034a1.317 1.317 0 01-.24-.072.95.95 0 01-.2-.113l-1.062-1.092-3.039-3.041-1.1 1.053-3.07 3.072a.974.974 0 01-.2.111 1.274 1.274 0 01-.237.073c-.096.02-.209.033-.338.033-.108 0-.227-.009-.358-.031a2.7 2.7 0 01-.425-.114 3.748 3.748 0 01-.496-.217 5.228 5.228 0 01-.563-.343l6.803-6.727zm4.72.785l4.579 4.598 1.382 1.353a5.24 5.24 0 01-.564.344 3.73 3.73 0 01-.494.217 2.697 2.697 0 01-.426.111c-.13.023-.251.034-.36.034-.129 0-.241-.014-.337-.034a1.285 1.285 0 01-.385-.146c-.033-.02-.05-.036-.053-.04l-1.232-1.218-2.111-2.111-.334.334L12.79 9.8l1.896-1.897zm-5.966 4.12v2.529a2.128 2.128 0 01-.356-.035 2.765 2.765 0 01-.422-.116 3.708 3.708 0 01-.488-.214 5.217 5.217 0 01-.555-.34l1.82-1.825Z",source:"https://alpinelinux.org/",hex:"0D597F",guidelines:void 0,license:void 0},siAlpinedotjs={title:"Alpine.js",slug:"alpinedotjs",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Alpine.js</title><path d="'+this.path+'"/></svg>'},path:"m24 12-5.72 5.746-5.724-5.741 5.724-5.75L24 12zM5.72 6.254 0 12l5.72 5.746h11.44L5.72 6.254z",source:"https://github.com/simple-icons/simple-icons/issues/5583#issuecomment-832770167",hex:"8BC0D0",guidelines:void 0,license:void 0},siAmazon={title:"Amazon",slug:"amazon",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Amazon</title><path d="'+this.path+'"/></svg>'},path:"M.045 18.02c.072-.116.187-.124.348-.022 3.636 2.11 7.594 3.166 11.87 3.166 2.852 0 5.668-.533 8.447-1.595l.315-.14c.138-.06.234-.1.293-.13.226-.088.39-.046.525.13.12.174.09.336-.12.48-.256.19-.6.41-1.006.654-1.244.743-2.64 1.316-4.185 1.726a17.617 17.617 0 01-10.951-.577 17.88 17.88 0 01-5.43-3.35c-.1-.074-.151-.15-.151-.22 0-.047.021-.09.051-.13zm6.565-6.218c0-1.005.247-1.863.743-2.577.495-.71 1.17-1.25 2.04-1.615.796-.335 1.756-.575 2.912-.72.39-.046 1.033-.103 1.92-.174v-.37c0-.93-.105-1.558-.3-1.875-.302-.43-.78-.65-1.44-.65h-.182c-.48.046-.896.196-1.246.46-.35.27-.575.63-.675 1.096-.06.3-.206.465-.435.51l-2.52-.315c-.248-.06-.372-.18-.372-.39 0-.046.007-.09.022-.15.247-1.29.855-2.25 1.82-2.88.976-.616 2.1-.975 3.39-1.05h.54c1.65 0 2.957.434 3.888 1.29.135.15.27.3.405.48.12.165.224.314.283.45.075.134.15.33.195.57.06.254.105.42.135.51.03.104.062.3.076.615.01.313.02.493.02.553v5.28c0 .376.06.72.165 1.036.105.313.21.54.315.674l.51.674c.09.136.136.256.136.36 0 .12-.06.226-.18.314-1.2 1.05-1.86 1.62-1.963 1.71-.165.135-.375.15-.63.045a6.062 6.062 0 01-.526-.496l-.31-.347a9.391 9.391 0 01-.317-.42l-.3-.435c-.81.886-1.603 1.44-2.4 1.665-.494.15-1.093.227-1.83.227-1.11 0-2.04-.343-2.76-1.034-.72-.69-1.08-1.665-1.08-2.94l-.05-.076zm3.753-.438c0 .566.14 1.02.425 1.364.285.34.675.512 1.155.512.045 0 .106-.007.195-.02.09-.016.134-.023.166-.023.614-.16 1.08-.553 1.424-1.178.165-.28.285-.58.36-.91.09-.32.12-.59.135-.8.015-.195.015-.54.015-1.005v-.54c-.84 0-1.484.06-1.92.18-1.275.36-1.92 1.17-1.92 2.43l-.035-.02zm9.162 7.027c.03-.06.075-.11.132-.17.362-.243.714-.41 1.05-.5a8.094 8.094 0 011.612-.24c.14-.012.28 0 .41.03.65.06 1.05.168 1.172.33.063.09.099.228.099.39v.15c0 .51-.149 1.11-.424 1.8-.278.69-.664 1.248-1.156 1.68-.073.06-.14.09-.197.09-.03 0-.06 0-.09-.012-.09-.044-.107-.12-.064-.24.54-1.26.806-2.143.806-2.64 0-.15-.03-.27-.087-.344-.145-.166-.55-.257-1.224-.257-.243 0-.533.016-.87.046-.363.045-.7.09-1 .135-.09 0-.148-.014-.18-.044-.03-.03-.036-.047-.02-.077 0-.017.006-.03.02-.063v-.06z",source:"https://worldvectorlogo.com/logo/amazon-icon",hex:"FF9900",guidelines:void 0,license:void 0},siAlbertheijn={title:"Albert Heijn",slug:"albertheijn",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Albert Heijn</title><path d="'+this.path+'"/></svg>'},path:"M15.652 0c-.354.002-.714.09-1.047.276L4.475 5.924c-.456.26-.881.716-1.075 1.362l-2.718 9.44c-.326 1.13.311 2.314 1.423 2.646l15.968 4.542c1.111.33 2.277-.318 2.603-1.448l2.641-9.258c.172-.543.076-1.213-.192-1.737L17.59 1.162A2.19 2.19 0 0 0 15.652 0zM12.97 6.373s-.008 4.23 0 4.225c.899-1.295 1.712-2.577 3.234-2.577 1.684-.001 2.597 1.409 2.602 2.595l-.007 7.596h-1.891l-.009-7.19c0-.988-.793-.986-.804-.986-.64 0-1.816 1.605-3.125 3.386v4.793l-1.913.002-.002-2.219S9.79 18.217 7.897 18.22c-2.148 0-2.877-1.476-2.882-5.015-.004-3.37.474-5.175 2.777-5.177 1.751-.001 3.256 2.55 3.256 2.55V8.963zm-5.15 3.658c-.88 0-.957.93-.954 3.17.003 2.242.124 3.115.95 3.115 1.124-.001 2.895-2.86 2.895-2.86S8.955 10.03 7.82 10.03z",source:"https://www.ah.nl/",hex:"04ACE6",guidelines:void 0,license:void 0},siAirtable={title:"Airtable",slug:"airtable",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Airtable</title><path d="'+this.path+'"/></svg>'},path:"M11.992 1.966c-.434 0-.87.086-1.28.257L1.779 5.917c-.503.208-.49.908.012 1.116l8.982 3.558a3.266 3.266 0 0 0 2.454 0l8.982-3.558c.503-.196.503-.908.012-1.116l-8.957-3.694a3.255 3.255 0 0 0-1.272-.257zM23.4 8.056a.589.589 0 0 0-.222.045l-10.012 3.877a.612.612 0 0 0-.38.564v8.896a.6.6 0 0 0 .821.552L23.62 18.1a.583.583 0 0 0 .38-.551V8.653a.6.6 0 0 0-.6-.596zM.676 8.095a.644.644 0 0 0-.48.19C.086 8.396 0 8.53 0 8.69v8.355c0 .442.515.737.908.54l6.27-3.006.307-.147 2.969-1.436c.466-.22.43-.908-.061-1.092L.883 8.138a.57.57 0 0 0-.207-.044z",source:"https://airtable.com/press",hex:"18BFFF",guidelines:void 0,license:void 0},siApacheflink={title:"Apache Flink",slug:"apacheflink",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache Flink</title><path d="'+this.path+'"/></svg>'},path:"M3.192 13.236c.028.035.064.069.098.101l.024.022.008.004a.736.736 0 0 0 .179.065 8.117 8.117 0 0 1-.138-1.758c.027-.797.178-1.47.462-2.059a8.02 8.02 0 0 1 .315-.519s-.176 1.202-.202 1.673a7.104 7.104 0 0 0 .16 1.868l.072-.05c-.043-.389-.042-.8.004-1.22a6.987 6.987 0 0 1 .419-1.721 9.266 9.266 0 0 1 .973-1.892c-1.985.209-2.418 2.1-2.418 2.1s.017-.347.024-.434c.057-.649.123-.961.205-1.287-.13.238-.212.488-.271.688-.139.47-.216.949-.273 1.356a9.022 9.022 0 0 0-.096 1.289c.002.38.024.828.176 1.263.073.205.164.373.279.511zm1.44-.737c.179-.113.385-.2.626-.268.425-.119.889-.239 1.461-.379l.19-.046c.478-.116.974-.237 1.439-.415.283-.108.552-.25.824-.436.38-.26.721-.579 1.012-.951.154-.196.232-.349.309-.605l.114-.378s.464.519-.004 1.436c.297-.107.582-.413.798-.788.181-.315.491-1.451.491-1.451s.569.875-.105 2.011a1.59 1.59 0 0 0 .356-.227c2.507-2.49.349-3.899-.103-4.236a4.141 4.141 0 0 0-.982-.525L11 5.218c-.03-.013-.047-.033-.055-.042l-.321-.35.563.155c.079.021.154.042.228.064.614.182 1.082.4 1.472.686.445.325 2.142 1.751.348 3.837.556-.191 1.606-.772 1.962-1.272 1.713-2.405-.254-3.808-.17-3.808.019 0 .044.002.099.01a.44.44 0 0 0 .069.006c.036 0 .097-.006.109-.041.015-.042-.014-.122-.073-.168-.154-.117-.321-.202-.533-.169C12.926 4.4 12.3 3.85 12.3 3.85s2.482.129 2.562-.28a4.92 4.92 0 0 0-1.225-.912 6.697 6.697 0 0 0-2.228-.743c-1.207-.179-2.13.053-2.13.053.096-.121.574-.667 2.556-.511.802.063 1.564.316 2.27.669.182.091.29-.125.293-.223.004-.114.201.379.203.405.019-.049.096-.308.112-.308.047 0 .24.603.24.603.002-.024.257-.286.257-.286.076.343.066.514.047.562.002-.009.267-.172.267-.172s.152.638.412.891c.084.082.238.296.328.527.19-.133.421-.799.421-.799s.119.353.019.988c.007-.008.301-.219.301-.219s.042.449-.15 1.008a.572.572 0 0 0-.022.095c.162-.091.404-.388.404-.388l-.042.188c-.048.214-.137.629-.327.953a2.549 2.549 0 0 0-.29.686c.049-.045.099-.085.152-.12.1-.065.199-.117.293-.151l.232-.085c.392-.142.788-.309 1.173-.479.812-.359.631-.86.631-.86-.209.408-.966.816-.966.816s.98-.878.562-1.905c-.115.27-.224.538-.327.792-.144.353-.314.726-.59 1.055-.141.168-.286.29-.446.373a.686.686 0 0 1-.115.048l-.043.016s.172-.283.184-1.063c.004-.282.012-.571.012-.826v-.054c0-.132-.003-.263-.002-.395.005-.558.015-.982.132-1.373-.012-.022-.005-.045-.018-.068-.027-.046-.047-.099-.071-.157-.036-.089-.066-.178-.101-.275-.127-.36-.308-.538-.365-.588-.038.115-.271.591-.271.591s.001-.365-.001-.393c-.067-.511-1.33-.972-1.356-.988l.067.401s-.382-.028-.545-.284c-.034-.052-.084-.09-.13-.125l.09.306.093.214s-.296-.024-.435-.269c-.033-.057-.075-.121-.112-.189a.746.746 0 0 0-.574-.396 8.393 8.393 0 0 0-.601-.062 1.301 1.301 0 0 1-.479-.11L12.573 0l.046.087c.015.029.025.058.04.095l.008.022.032.078.048.172s-.353-.014-.765-.299c-.089-.062-.201-.062-.325-.072L11.622.08a4.192 4.192 0 0 0-.332-.014 3.097 3.097 0 0 0-.974.149c.035-.002.071-.003.106-.003l.067.001c.677.012.887.413.887.413s-.606 0-.785.023c-.209.027-.42.052-.616.106a5.102 5.102 0 0 0-1.622.796c-.124.088-.253.17-.389.256-.23.147-.424.341-.576.577a.357.357 0 0 0-.034.068c-.014.036-.008.039.015.051a.78.78 0 0 0 .168.061 2.353 2.353 0 0 1 1.786 2.005l.015.123c.035.307.072.623.056.944a3.413 3.413 0 0 1-.901 2.191c-.59.646-1.323.69-1.316.685.435-.406.722-.95.876-1.66a1.395 1.395 0 0 0-.084-.828.868.868 0 0 0-.016.047c-.097.276-.22.594-.447.857-.132.15-.312.322-.521.521-.911.867-2.435 2.317-2.409 4.623 0 .135.027.3.056.427zm13.967-5.836c-.113.098-.226.196-.341.292-.205.171-.351.28-.666.394-.276.099-.488-.124-.488-.124a1.3 1.3 0 0 0 .447-.389 7.968 7.968 0 0 0-1.154.71 2.41 2.41 0 0 0-.389.353c-.124.156-.205.318-.205.484v.002c0-.003.044-.005.053-.007a6.122 6.122 0 0 0 1.226-.49 16.006 16.006 0 0 0 1.757-1.074.334.334 0 0 1 .095-.048l.371-.106-.228.314a.288.288 0 0 1-.027.034c-.745.741-1.517 1.272-2.36 1.622a4.734 4.734 0 0 1-.492.174 9.201 9.201 0 0 0 1.513-.525c.537-.244.913-.483 1.22-.772.475-.45.814-.981 1.009-1.576a.732.732 0 0 0 .024-.1l-.111.033c-.127.037-.258.074-.373.13a2.367 2.367 0 0 0-.427.286c-.158.127-.321.269-.454.383zM1.578 14.987c.128.205.268.407.403.602l.021.031c-.351-1.236.223-1.982.223-1.982l.142.391c.036.101.091.199.167.302.147-.275.326-.538.534-.784a1.438 1.438 0 0 1-.472-.415c-.2-.264-.332-.581-.415-.996a5.507 5.507 0 0 1-.069-1.562c.015-.174.036-.348.059-.525a8.377 8.377 0 0 0-1.626 2.716.046.046 0 0 0 .003.021 9.438 9.438 0 0 0 1.03 2.201zM18.221 3.353a5.045 5.045 0 0 1 .366-1.933l.018-.041a.94.94 0 0 0-.246.252c-.168.242-.291.53-.397.932-.182.687-.29 1.427-.337 2.308.192-.205.507-.657.572-1.215.011-.094.024-.199.024-.303zm3.368 19.012c-.396-.065-1.234-.36-1.468-.945-.288.707.306 1.221.75 1.451.077.04.1.05.181.082.084.037-.165.494.045.704.21.21.409.148.487.148 0 0 .361.335.567.111.053-.058.098-.262.029-.385-.086-.152-.295-.124-.315-.124-.41.005-.373-.188-.311-.27.045-.059.132-.055.205-.055.017 0 .034.001.053.004.094.011.184.016.268.016.335 0 .726-.035.985-.179.186-.104.491-.456.475-.692-.017.006-.825.319-1.951.134zm2.324-7.785c-.038-.097-.085-.196-.126-.283l-.06-.126c-.021-.047-.044-.093-.066-.139-.055-.111-.112-.226-.151-.35-.034-.106-.043-.216-.052-.32a3.312 3.312 0 0 0-1.886-2.716 1.25 1.25 0 0 1-.215.417c-.09.12-.144.138-.262.138-.157 0-.18-.18-.133-.265a1.45 1.45 0 0 0 .196-.543c.033-.377-.177-.786-.435-1.068-.239-.261-.649-.564-.979-.663-.079.307.017.812.124 1.109.132.36.544 1.069.445 1.499 0 0-.029.275-.304.448-.153.096-.215.053-.215.053.294-.627.297-.891-.028-1.485-.245-.447-.358-.899-.27-1.398.003-.02.01-.04.014-.06a2.222 2.222 0 0 1-.088.199c-.25.439-.486.667-.628 1.121-.149.508.01 1.059.325 1.598a1.237 1.237 0 0 1-.553-.804 4.323 4.323 0 0 0-1.334 1.166c-.08.104-.175.191-.259.268a4.92 4.92 0 0 1-1.978 1.099c-.493.145-1.001.267-1.502.388l-.131.031c-.683.165-1.409.351-2.097.657-.792.352-1.42.757-1.918 1.239a4.412 4.412 0 0 0-1.326 2.593c-.114.781-.055 1.595.18 2.49.008.032-1.03-.941-.494-3.741a6.322 6.322 0 0 0-.236-.007l-.067.001c-1.933.058-2.737 1.123-2.737 1.123s.126-1.182 1.987-1.579c.14-.03 1.312-.293 1.352-.306.154-.314.341-.612.557-.889l-.166.026c-.319.05-.648.1-.975.143l-.252.03c-.577.074-1.174.149-1.74.316-.594.174-1.059.426-1.422.768-.389.366-.668.839-.852 1.442l-.023.086c-.013.05-.026.101-.045.151-.02.052-.024.11.018.22.348.923.945 1.723 1.774 2.376a7.587 7.587 0 0 0 2.146 1.18c.026.009.07.024.109.064l.348.337-.544-.13c-.064-.015-.127-.029-.191-.047-1.114-.306-2.085-.821-2.885-1.532-.273-.099-1.668-.794-2.26-1.936l-.099-.19s.757.746 1.288.855a5.59 5.59 0 0 1-.564-1.22.283.283 0 0 0-.049-.087C1.273 17.196.624 16.054.196 14.834a4.708 4.708 0 0 1-.085-.262c-.043.355-.064.71-.064 1.057 0 .11.955 2.647.955 2.647s-.42-.467-.768-1.059c0 0-.061-.199-.069-.212.149.897.439 1.74.863 2.521 1.167 2.147 2.956 3.554 5.47 4.212a7.73 7.73 0 0 0 1.955.255l7.855.007c.369 0 .652-.022.915-.07l.041-.007a1.47 1.47 0 0 1 .281-.034c.106.001.219.014.345.044l.062.015c.116.026.224.052.331.052 1.32.01 1.137-.785 1.137-.785-.055-.207-.295-.351-.557-.413a1.204 1.204 0 0 0-.28-.033c-.179 0-.367.041-.559.12l-.288.123-.172.075a1.317 1.317 0 0 1-.098.038.54.54 0 0 1-.17.036c-.199 0-.208-.195-.213-.312a.46.46 0 0 1 .169-.373c.093-.079.194-.156.302-.228.195-.132.396-.268.551-.446a1.49 1.49 0 0 0 .361-.699.825.825 0 0 0-.044-.469c-.014-.035-.027-.042-.04-.046a9.037 9.037 0 0 0-.368-.112c-.488-.137-.847-.342-1.127-.643a2.803 2.803 0 0 1-.439-.671 5.783 5.783 0 0 1-.416-1.096c-.159-.601-.536-1.083-1.15-1.472a3.536 3.536 0 0 0-1.557-.524c-.137-.015-.276-.021-.423-.028-.037-.002-.122-.013-.208-.024-.077-.01-.153-.021-.188-.022l-.21-.013s.054-.076.489-.242c.082-.031.167-.039.25-.054.201-.035.4-.053.59-.053.458 0 .891.106 1.288.314.494.26.888.656 1.206 1.211.173.302.309.626.416.992.021.07.038.14.058.216.035.134.071.271.122.396.307.756.876 1.198 1.69 1.315.216.031.426.046.626.046a3.48 3.48 0 0 0 1.077-.165c.455-.149.803-.382 1.062-.712a1.42 1.42 0 0 0 .255-.494l.035-.121.203.048c.043.011.086.021.13.03a.483.483 0 0 0 .094.009c.092 0 .186-.022.288-.044l.017-.004c.076-.017.15-.02.222-.023l.061-.003c.072 0 .132.048.159.093.031.053.081.083.175.104a.367.367 0 0 0 .075.007c.229 0 .47-.21.476-.416.003-.079-.018-.127-.07-.163-.041-.028-.083-.054-.131-.084l-.228-.143.152-.116a.245.245 0 0 1 .147-.051c.045 0 .085.013.12.028 0 0-.191-1.01-1.527-.716 0 0-.217.089-.328.131l-.052.02a.27.27 0 0 1-.101.019.358.358 0 0 1-.166-.047c-.468-.235-.926-.131-1.002-.131a2.28 2.28 0 0 1-.538-.059.222.222 0 0 1-.116-.067l-.086-.097a2.634 2.634 0 0 1-1.183-.197c-.436-.186-.784-.47-.995-.903a1.487 1.487 0 0 1-.15-.685l.026.067c.084.248.208.474.374.678.306.379.701.634 1.15.813.243.097.495.165.764.21 0 0 .955.036 1.38-.317.323-.18.614-.264.917-.264h.063c1.027-.001 1.118-.498 1.118-.498s.117.076.281.051a.666.666 0 0 0 .604-.63l-.34-.306-.072-.063-.134-.106.092-.105a.274.274 0 0 1 .207-.099c.046 0 .091.012.134.035.061.034.115.077.164.117l.051.04.064.05a.559.559 0 0 0-.036-.265zm-1.267-.273c-.038.106-.088.123-.199.099a.688.688 0 0 0-.181-.014c-.111.005-.221.024-.332.026-.277.005-.543-.045-.763-.225-.312-.256-.372-.559-.177-.943l.004.037a.745.745 0 0 0 .345.611c.18.121.385.17.595.196.17.021.338.05.487.142l.041.021a.043.043 0 0 1 .006-.007c-.029-.041-.039-.183-.024-.242a.565.565 0 0 0 .002-.297.622.622 0 0 1-.25.304.076.076 0 0 1-.053.02 2.53 2.53 0 0 1-.654-.233c-.186-.102-.283-.261-.234-.484a.198.198 0 0 0-.056-.189c-.023-.023-.043-.05-.067-.078.055-.051.102-.1.155-.143.05-.04.102-.078.158-.109.432-.245 1.016-.061 1.208.389.049.114.075.24.089.363.028.259-.013.511-.1.756zm-20.67 2.926c-.02-.237-.033-.474-.046-.756a.102.102 0 0 0-.021-.064c-.63-.909-1.089-1.696-1.446-2.476a7.292 7.292 0 0 1-.169-.394 7.748 7.748 0 0 0 1.682 3.694v-.004zm18.991 4.103c.176.117.395.203.732.287.34.085.653.125.966.125.185 0 .334-.019.47-.059a.81.81 0 0 0 .59-.639 6.03 6.03 0 0 0 .128-.713 1.798 1.798 0 0 0-.372-1.323c-.035.031-.07.061-.106.089a1.104 1.104 0 0 1-.198.121.658.658 0 0 1-.291.072.593.593 0 0 1-.281-.072.96.96 0 0 0-.461-.104c-.063 0-.131.005-.208.013-.027.003-.039.009-.054.04-.258.531-.683.908-1.298 1.154l-.017.007-.003.013a1.15 1.15 0 0 0-.001.454c.054.216.185.391.404.535zM14.99 9.512c-.516.525-1.141.958-1.964 1.364-.52.256-1.1.441-1.826.582-.415.081-.829.159-1.243.237l-.086.015-1.056.2c-.929.178-1.92.389-2.872.71-.691.234-1.224.481-1.677.779-.444.291-.75.591-.965.943a2.637 2.637 0 0 0-.146.291 5.696 5.696 0 0 1-.075.159.42.42 0 0 1-.076.114c-.484.473-.69 1.064-.613 1.756.046.416.176.821.395 1.236.127-.846.574-1.492 1.328-1.92.41-.233.863-.403 1.383-.517.526-.117 1.06-.214 1.561-.304l.307-.054c.516-.091 1.051-.184 1.558-.345.12-.038.238-.08.348-.121.147-.055.275-.12.391-.206.141-.105.289-.2.444-.291-.653-.015-1.76-.017-2.104-.019-.77-.004-1.3.06-1.964.312-.694.264-2.676 1.271-2.676 1.271s.985-1.054 2.837-1.844a7.858 7.858 0 0 1 2.928-.53c.275 0 .561.011.872.033.512.038 1.024.075 1.535.11l.014.001c.024 0 .05-.004.075-.011a10.63 10.63 0 0 1 1.572-.325c.175-.025.353-.061.528-.097-.034-.011-.069-.02-.103-.03a1.13 1.13 0 0 1-.118-.044l-.088-.035-.345-.233 1.296.028c.279 0 3.032-.443 4.21-3.723.078-.219.16-.437.223-.676a7.611 7.611 0 0 1-2.669 1.063 7.155 7.155 0 0 1-1.139.121zm4.784-1.871zm1.701 5.622a.27.27 0 1 0 .54 0 .27.27 0 0 0-.54 0z",source:"https://apache.org/logos/",hex:"E6526F",guidelines:void 0,license:void 0},siApachegroovy={title:"Apache Groovy",slug:"apachegroovy",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache Groovy</title><path d="'+this.path+'"/></svg>'},path:"M11.997 6.012S10.315 8.8 9.516 10.155c-.155.058-.172.041-.341.207-.41-.47-.897-.041-1.028.22-.057-.566-.151-.567-.279-.694.074-.496.316-1.305-.241-1.884-1.078-.727-2.326 1.05-3.021 1.982l-.375.622c-1.546-.032-2.763.008-4.231-.021 1.79.67 1.864.686 4.026 1.506 0 .066.161.372.34.552.147.15.308.234.389.284-.106.054-.32.138-.385.258-.292.546.139.672.418 1.107.315.568.382.944 1.126.625.254-.11.562-.148.758-.21-.693 1.094-.87 1.392-2.083 3.274l.012.004c4.85-1.893 4.974-1.942 7.373-2.89 3.448 1.338 3.646 1.448 7.432 2.891-.529-.826-.89-1.343-1.274-1.995.151-.013.483-.046.777-.233.213-.135.463-.288.688-.574.443-.565.551-1.277.39-2.166-.078-.423-.235-.834-.213-.85 2.061-.778 2.304-.862 4.226-1.587-2.31.034-2.422.01-4.591.016-.036-.414-.244-.627-.882-.606-.238.039-.389.12-.5.445-.357-.657-.85-.464-1.06-.14-.275-.282-.917-.377-1.24-.17-.238-.112-.514-.112-.757.177-.175-.146-.23-.188-.614-.342-.886-1.497-1.622-2.692-2.36-3.951zm.012.802c.35.535 1.552 2.61 1.849 3.074-.337.023-.668.202-.918.562-.217-.224-.47-.445-.917-.463-.544-.093-.834.148-1.2.568-.108-.365-.53-.45-.896-.28.327-.519 1.872-3.122 2.082-3.46zM7.45 9.128c-.05 1.434-1.068 2.712-1.798 2.245-.551-.449.149-1.584.59-1.985-.033.307.246.498.023.77-.446.543-.27.936-.078.996.513.162 1.004-1.227 1.004-2.201 0-.625-.366-.613-1.086.136-.983 1.022-1.513 2.012-1.16 2.69.197.38.485.651.959.594.925-.11 1.483-1.254 1.543-1.988.148-.003.109.01.148-.02 0 .129.177.755.317 1.166.183.702.964 2.11-1.369 2.658-.44.11-.614.148-1.05.32-.213-.443-.263-.585-.697-1.013.588-.205.593-.185.972-.317 1.467-.51 1.908-.947 1.857-1.57 0 0 .018-.32-.185-.588a2.613 2.613 0 0 1-.293.645c-.437.68-1.296 1.101-2.06.833-.417-.146-.596-.466-.596-1.015 0-.703 1.601-2.735 2.387-3.08.555-.165.579.293.571.724zm6.502 1.3c.26.006.543.133.735.34.594.64.529 1.417.163 1.905-.435.581-1.532.324-1.791-.488-.12-.378.095-1.312.475-1.624a.628.628 0 0 1 .418-.132zm-2.113.066a.502.502 0 0 1 .117.017c.503.03.61.313.701.56.231.626.173 1.212-.301 1.691-.711.719-1.54.401-1.536-.567.014-.69.443-1.715 1.02-1.7zm1.868.038c-.383.287-.432 1.023-.08 1.296.138.13.215.22.613.256.273.024.704-.253.725-.527.01-.125-.013-.333-.312-.67-.252-.283-.579-.349-.661-.3-.265.156.021.28.125.383.162.163.2.234.125.282a.447.447 0 0 1-.372.057c-.105-.049-.456-.246-.163-.777zm3.759.003c.167.26.215.316.402.965.24.838.546 1.163.816 1.01.74-.418.148-1.476-.113-1.974.167-.002.134.007.286.005.12.471.086.387.407 1.813.385 1.706.442 2.16-.528 2.926-.446.352-1.103.37-1.667.34l-.636-.095c.438-.287.545-.557.542-1.116 1.278.535 1.959.132 2.23-.526.132-.317.086-.735-.04-1.471.008.6-.005.71-.084 1.007-.158.595-.547.76-.812.34-.102-.163-.345-.702-.42-1.282-.075-.58-.132-1.395-.5-1.736.04-.08.082-.17.117-.206zm-1.247.01c.258.068.572.204.74.52.234.436.388.668.376 1.447-.014.832-.34 1.055-.557 1.086-.278.04-.762.034-1.049-1.598-.095-.541-.268-1.056-.45-1.224.09-.11.097-.096.165-.204.091.1.17.27.298.777.202.808.387.975.745 1.02.558.072.778-.78.318-1.391-.1-.134-.365-.307-.503-.236.008.236.113.162.114.318-.026.185-.053.219-.113.32-.142-.056-.21-.078-.334-.291-.157-.31-.055-.6.25-.544zm-4.597.076c-.263.185-.594.8-.304 1.35.143.205.297.372.638.3.245-.051.671-.34.73-.749.052-.35-.456-1.028-.738-.87-.327.183-.128.314.074.511.185.18.052.289-.077.342-.258.106-.403.003-.467-.203-.065-.205-.01-.38.144-.68zm-2.867.064c.056.172.1.402.218.624.028.023.132 0 .269-.157.086-.1.185-.238.357-.463.104.095.113.166.142.219.073.13.225.12.273.106.168-.167.195-.275.306-.29.01.216.021.35-.257.677a.535.535 0 0 1-.501.172c-.12-.034-.199-.108-.389-.205-.258.04-.19.315-.143.546.12.611.5.855.832.675.116-.062.09-.062.312-.153-.038.388-.06.463.01.896-.541.301-.982.25-1.102-.506-.091-.632-.261-1.4-.415-1.556-.145-.147-.205-.195-.205-.195l.293-.39zm-7.114.082c.753.01 1.602.01 2.506.017-.13.318-.175.54-.193.854-.422-.163-1.877-.684-2.313-.871zm20.723.01c-.997.359-1.715.637-2.677 1.004-.105-.45-.124-.588-.219-.994 1.601-.005 1.628-.002 2.896-.01zm-6.978 2.04c.105.43.253.641.253.641.202.348.454.545.84.645.085.136.115.163.148.236.037.457.01.514-.344.774-.209.204-.218.497-.003.769.231.22.474.298 1.375.064.174.3.418.653.776 1.217-1.206-.455-2.868-1.103-6.43-2.49 0 0-4.169 1.62-6.404 2.491.935-1.474 1.012-1.599 1.677-2.63.225-.089.149-.053.349-.155.459-.245.827-.61 1.028-1.145.368.83.779.925 1.636.655.177-.082.38-.2.424-.518.46.413 1.432.49 2.142-.382.612.717 2.001.785 2.533-.171zm2.157.865s.04.129.064.169c-.101.003-.213 0-.213 0a.905.905 0 0 0 .149-.17z",source:"https://groovy-lang.org/",hex:"4298B8",guidelines:void 0,license:void 0},siAirplayaudio={title:"AirPlay Audio",slug:"airplayaudio",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AirPlay Audio</title><path d="'+this.path+'"/></svg>'},path:"M11.908.183a12.012 12.012 0 00-8.044 3.172c-4.882 4.475-5.166 12.08-.692 16.962.204.244.448.447.692.692a.315.315 0 00.408-.04l.53-.61a.32.32 0 000-.448C.53 15.965.243 9.253 4.23 4.982 8.217.711 14.889.427 19.16 4.414c4.271 3.986 4.555 10.655.568 14.927-.203.203-.365.407-.568.57a.32.32 0 000 .447l.53.611a.37.37 0 00.446.04c4.882-4.516 5.166-12.081.692-16.962a11.98 11.98 0 00-8.92-3.864zm.387 3.518A8.607 8.607 0 006.143 6c-3.458 3.213-3.66 8.623-.447 12.08.122.123.243.285.406.407a.319.319 0 00.447 0l.53-.61a.32.32 0 000-.446A7.263 7.263 0 014.8 12.183c0-3.946 3.212-7.16 7.158-7.16s7.16 3.253 7.16 7.199a7.207 7.207 0 01-2.238 5.209.319.319 0 000 .447l.529.61c.122.121.325.162.447.04a8.599 8.599 0 00.408-12.122 8.494 8.494 0 00-5.97-2.705zm-.266 3.316A5.198 5.198 0 008.34 8.48c-2.075 1.993-2.115 5.247-.122 7.322l.121.123a.319.319 0 00.447 0l.53-.611a.32.32 0 000-.448 3.814 3.814 0 01-1.098-2.683 3.732 3.732 0 013.742-3.742 3.732 3.732 0 013.742 3.742c0 1.017-.406 1.951-1.139 2.683a.32.32 0 000 .448l.53.61a.32.32 0 00.447 0c2.034-1.992 2.116-5.246.123-7.321a5.128 5.128 0 00-3.633-1.586zm.006 7.744a.599.599 0 00-.402.146l-.04.041-7.159 8.055a.506.506 0 00.041.69.437.437 0 00.283.124h14.36a.495.495 0 00.489-.488.463.463 0 00-.121-.326l-7.08-8.055a.5.5 0 00-.37-.187z",source:"https://developer.apple.com/design/human-interface-guidelines/airplay/overview/icons/",hex:"000000",guidelines:void 0,license:void 0},siAmazondynamodb={title:"Amazon DynamoDB",slug:"amazondynamodb",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Amazon DynamoDB</title><path d="'+this.path+'"/></svg>'},path:"M16.606 20.705v-2.371c-1.263 1.082-3.884 1.795-7.066 1.795-3.184 0-5.805-.714-7.068-1.797v2.369c0 1.168 2.903 2.47 7.068 2.47 4.16 0 7.06-1.3 7.066-2.466zm.001-6.765l.817-.005v.005c0 .517-.258.998-.75 1.441.601.54.75 1.071.75 1.449a1661.7 1661.7 0 0 0 0 3.87c0 1.881-3.389 3.3-7.884 3.3-4.471 0-7.846-1.404-7.88-3.27a583.119 583.119 0 0 1-.003-3.909c.001-.375.15-.9.745-1.437-.592-.538-.743-1.062-.746-1.435v-3.892c.002-.377.153-.903.747-1.438-.593-.54-.744-1.062-.747-1.435 0-1.357-.002-2.735.002-3.897C1.674 1.412 5.056 0 9.54 0c2.159 0 4.233.356 5.689.974l-.315.766c-1.36-.58-3.319-.91-5.374-.91-4.165 0-7.067 1.3-7.067 2.47 0 1.168 2.902 2.47 7.067 2.47.115 0 .222 0 .334-.005l.033.828c-.122.006-.245.006-.367.006-3.184 0-5.805-.714-7.068-1.798v2.38c.005.45.45.843.821 1.093 1.116.736 3.114 1.239 5.34 1.342l-.037.829c-2.254-.105-4.23-.59-5.5-1.332-.318.245-.623.573-.623.952 0 1.168 2.902 2.47 7.067 2.47.411 0 .812-.014 1.203-.042l.06.826c-.41.03-.833.045-1.263.045-3.184 0-5.805-.713-7.068-1.797v2.368c.005.462.449.855.821 1.104 1.275.842 3.67 1.366 6.247 1.366h.182v.83H9.54c-2.62 0-4.99-.507-6.444-1.359-.317.245-.623.574-.623.954 0 1.168 2.902 2.47 7.067 2.47 4.159 0 7.058-1.298 7.066-2.465v-.007c0-.377-.303-.705-.62-.948a5.732 5.732 0 0 1-.662.336l-.316-.764c.3-.128.56-.266.776-.412.376-.254.823-.651.823-1.1zm4.377-6.915h-2.717a.406.406 0 0 1-.332-.173.42.42 0 0 1-.055-.375l1.204-3.597h-5.403l-2.583 4.974h2.623c.128 0 .248.06.325.164a.418.418 0 0 1 .069.36l-2.249 8.365zm1.249-.128l-10.89 11.608a.408.408 0 0 1-.498.075.418.418 0 0 1-.192-.471l2.534-9.426h-2.766a.407.407 0 0 1-.349-.2.418.418 0 0 1-.012-.407l3.014-5.804a.408.408 0 0 1 .36-.222h6.22c.132 0 .256.065.332.174a.422.422 0 0 1 .055.374l-1.204 3.598h3.1c.164 0 .31.099.375.251a.422.422 0 0 1-.08.45zM3.085 20.723a8.107 8.107 0 0 0 1.72.72l.233-.794a7.32 7.32 0 0 1-1.546-.645zm1.72-5.984l.233-.795a7.262 7.262 0 0 1-1.546-.646l-.407.72a8.051 8.051 0 0 0 1.72.72zm-1.72-7.427l.407-.719c.418.244.939.462 1.546.646l-.232.794a8.046 8.046 0 0 1-1.72-.72Z",source:"https://aws.amazon.com/architecture/icons/",hex:"4053D6",guidelines:void 0,license:void 0},siAnta={title:"Anta",slug:"anta",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Anta</title><path d="'+this.path+'"/></svg>'},path:"M24 15.2372a20.744 20.744 0 0 0-9.86-7.5087 31.2657 31.2657 0 0 1 6.9097 1.0135l-1.5536-1.3192A29.1614 29.1614 0 0 0 9.0497 5.509a29.0797 29.0797 0 0 0-6.4051.7036L0 8.032c.335 0 .8376-.021 1.1747-.021a25.1537 25.1537 0 0 1 20.4571 10.48ZM9.1963 12.9758h3.3334l-.3329 1.183h-1.0532L9.9333 18.491H8.7692l1.206-4.3322H8.8655zm-3.771 0H6.468l.4376 2.9544.8229-2.9544h1.1977l-1.537 5.5152H6.221l-.4041-2.743-.7643 2.743H3.8841ZM0 18.491l2.8225-5.5131h1.181L3.769 18.491H2.5838l.0545-.7391H1.5264l-.3601.7391zm2.0206-1.8844h.6889l.2094-1.9474zm8.2122 1.8844 2.8288-5.5131h1.1768l-.2346 5.5131h-1.181l.0524-.7391h-1.1076l-.3644.7391zm2.0247-1.8844h.689l.2093-1.9474z",source:"https://www.anta.com/",hex:"D70010",guidelines:void 0,license:void 0},siAlacritty={title:"Alacritty",slug:"alacritty",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Alacritty</title><path d="'+this.path+'"/></svg>'},path:"m10.065 0-8.57 21.269h3.595l6.91-16.244 6.91 16.244h3.594l-8.57-21.269zm1.935 9.935c-0.76666 1.8547-1.5334 3.7094-2.298 5.565 1.475 4.54 1.475 4.54 2.298 8.5 0.823-3.96 0.823-3.96 2.297-8.5-0.76637-1.8547-1.5315-3.7099-2.297-5.565z",source:"https://github.com/alacritty/alacritty/blob/6d8db6b9dfadd6164c4be7a053f25db8ef6b7998/extra/logo/alacritty-simple.svg",hex:"F46D01",guidelines:void 0,license:void 0},siApachejmeter={title:"Apache JMeter",slug:"apachejmeter",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache JMeter</title><path d="'+this.path+'"/></svg>'},path:"M4.35 7.79s-.247-.4-.537-.228c-.14.084-.374.318-.653.658l.257.484a6.28 6.28 0 0 1 .517-.653c-.079.09-.246.298-.484.662.334-.023.666-.064.996-.123.099-.549-.096-.8-.096-.8zm-.386.228.022-.024zM.91 14.02a45.295 45.295 0 0 0-.774 2.33.198.198 0 0 1-.136.132c.23-.76.458-1.476.687-2.124-.143-.033-.346.007-.594.11.17-.13.339-.242.5-.252-.051-.011-.183-.057-.36-.22.169.063.316.094.422.072-.022-.282-.174-.57-.374-.86-.001-.002.28.161.383.33l.002-.023c.017-.22.048-.438.093-.654v-.002c.034-.174.076-.348.127-.522l.066-.223c.028-.087.06-.176.093-.27.11-.301.235-.596.375-.884l.036-.072c.128-.257.264-.511.408-.76.076-.133.154-.262.231-.39.007-.007.011-.017.017-.026L2.11 9.71l.008-.013c.236-.38.488-.75.754-1.108a8.36 8.36 0 0 1 .229-.296l.058-.072.256.482a10.46 10.46 0 0 0-.268.404c-.172.276-.335.559-.487.846l-.217.414-.222-.439.22.44-.007.015c-.044.09-.09.18-.133.27a6.9 6.9 0 0 0-.077.16l-.206.444a42.824 42.824 0 0 0-.57 1.344l-.18.457a6.523 6.523 0 0 1-.04.103c-.044.121-.091.239-.134.357v.004l-.033.088-.141.381-.01.029zm3.235-4.623a4.98 4.98 0 0 1-.334.562c-.106.149-.216.25-.457.363l.022-.004c.002-.002.003-.002.006-.002.125-.023.28-.074.37-.127a.184.184 0 0 0 .036-.024.846.846 0 0 1-.02.089c-.006.025-.016.054-.026.085l-.012.033-.036.092a2.985 2.985 0 0 1-.102.226c-.008.019-.018.038-.028.057l-.024.039a.85.85 0 0 1-.084.116l-.04.044a1.2 1.2 0 0 1-.113.101 1.231 1.231 0 0 1-.27.151l.017-.002.064-.011c.129-.031.251-.085.361-.16-.138.275-.326.497-.628.612l.052-.007.05-.011a.998.998 0 0 0 .254-.087 6.74 6.74 0 0 1-.18.492c-.071.174-.145.33-.225.47a2.577 2.577 0 0 1-.35.487c-.276.298-.705.54-1.027.58l.016.003c.366.076.745-.047.996-.324a2.685 2.685 0 0 1-.106.187c-.148.24-.318.386-.654.537.23.013.35-.041.448-.165a1.414 1.414 0 0 1-.052.1c-.215.356-.634.478-1.117.456a.54.54 0 0 1 .174.37c-.074-.134-.152-.251-.251-.297l.116-.334a.523.523 0 0 1 .02-.054v-.006l.132-.37a.837.837 0 0 0 .026-.07l.003-.01.17-.454.007-.022.168-.435c.061-.159.124-.312.184-.46.123-.301.25-.6.382-.897.052-.116.101-.228.152-.336l.05-.108.097-.205c.028-.063.059-.122.088-.183l.027-.058c.002-.002.003-.006.002-.011l.006-.001c.074-.15.143-.291.213-.423.15-.29.309-.576.474-.857l.013-.023c.088-.148.171-.28.246-.396.333-.023.665-.064.995-.12-.011.052-.022.107-.038.165a2.966 2.966 0 0 1-.075.225 4.142 4.142 0 0 1-.187.413h-.001zm2.351.674v4.596c0 .28-.041.527-.125.732a1.337 1.337 0 0 1-.35.512 1.37 1.37 0 0 1-.531.3c-.203.063-.43.095-.674.095a2.728 2.728 0 0 1-.659-.074.063.063 0 0 1-.046-.06v-.842a.063.063 0 0 1 .076-.062c.077.018.162.033.25.045.162.024.376.03.54-.01a.48.48 0 0 0 .332-.29.826.826 0 0 0 .052-.313v-4.63c0-.035.027-.063.062-.063h1.01c.036 0 .063.028.063.063zm8.588 1.44a1.352 1.352 0 0 0-.518-.334 1.887 1.887 0 0 0-.675-.114c-.254 0-.49.041-.702.125-.208.082-.395.21-.545.377a1.75 1.75 0 0 0-.35.619 2.704 2.704 0 0 0-.123.859c0 .32.044.606.135.848.092.24.222.443.386.603.164.157.364.276.59.355a2.3 2.3 0 0 0 .742.118c.143 0 .267-.005.377-.015a2.33 2.33 0 0 0 .61-.13c.095-.033.187-.074.273-.12a.06.06 0 0 0 .033-.055v-.77a.063.063 0 0 0-.09-.055 2.505 2.505 0 0 1-.827.265c-.102.01-.204.015-.307.014a.907.907 0 0 1-.332-.055.703.703 0 0 1-.243-.162.797.797 0 0 1-.155-.263 1.168 1.168 0 0 1-.058-.295h2.157a.063.063 0 0 0 .063-.062v-.483a2.126 2.126 0 0 0-.114-.725 1.462 1.462 0 0 0-.327-.544zm-1.758 1.029c.022-.216.081-.377.176-.478a.518.518 0 0 1 .395-.167.55.55 0 0 1 .246.052c.07.033.13.083.176.144a.647.647 0 0 1 .105.22c.02.071.033.148.038.229h-1.136zm10.673-1.387v.934a.062.062 0 0 1-.077.06.727.727 0 0 0-.254-.027l-.08-.004c-.121 0-.233.016-.337.047a.636.636 0 0 0-.253.145.672.672 0 0 0-.163.264c-.039.11-.059.248-.059.411v1.856a.063.063 0 0 1-.063.063h-.994a.063.063 0 0 1-.063-.063v-3.645c0-.035.028-.063.063-.063h.753c.028 0 .053.02.06.046l.124.462c.04-.067.085-.13.133-.191a.932.932 0 0 1 .487-.338 1.14 1.14 0 0 1 .434-.044c.033 0 .065 0 .096.006a.76.76 0 0 1 .084.011.279.279 0 0 1 .066.011.061.061 0 0 1 .044.059h-.001zm-5.956 2.794a.06.06 0 0 1 .027.05v.741a.06.06 0 0 1-.033.055 1.524 1.524 0 0 1-.364.125c-.304.068-.62.066-.924-.008a.91.91 0 0 1-.381-.207 1.036 1.036 0 0 1-.256-.397 1.819 1.819 0 0 1-.088-.608V12h-.414a.063.063 0 0 1-.062-.062v-.42a.06.06 0 0 1 .03-.053l.529-.323.28-.75a.062.062 0 0 1 .058-.04h.636c.035 0 .062.028.062.063v.714h.825c.034 0 .063.028.063.062v.747a.063.063 0 0 1-.063.063h-.825v1.695c0 .124.029.214.085.268a.315.315 0 0 0 .231.084c.094 0 .181-.011.263-.03.089-.022.177-.05.264-.08a.062.062 0 0 1 .057.007v.001zm-6.105-3.876v4.77a.063.063 0 0 1-.062.061h-.943a.063.063 0 0 1-.063-.063v-2.45l.014-.473.01-.242.008-.187-1.018 3.37a.062.062 0 0 1-.06.044h-.93a.063.063 0 0 1-.06-.044l-.929-3.32a24.947 24.947 0 0 1 .033.88c.003.074.005.142.005.204v2.218a.063.063 0 0 1-.063.063h-.903a.063.063 0 0 1-.063-.063V10.07c0-.034.027-.063.062-.063h1.376c.03 0 .053.02.061.047l.981 3.473 1.046-3.474a.063.063 0 0 1 .06-.044h1.376c.034 0 .062.027.062.061zm9.135 1.44a1.351 1.351 0 0 0-.517-.334 1.886 1.886 0 0 0-.676-.114c-.253 0-.49.041-.701.125-.208.082-.395.21-.545.377a1.75 1.75 0 0 0-.35.619c-.087.278-.13.568-.124.859 0 .32.046.606.135.848.093.24.223.443.387.603.164.157.364.276.59.355a2.3 2.3 0 0 0 .742.118c.143 0 .266-.005.376-.015a2.306 2.306 0 0 0 .884-.25.06.06 0 0 0 .033-.055v-.77a.063.063 0 0 0-.09-.055 2.5 2.5 0 0 1-.828.265c-.101.01-.204.015-.306.014a.905.905 0 0 1-.332-.055.7.7 0 0 1-.242-.162.799.799 0 0 1-.157-.263 1.165 1.165 0 0 1-.057-.295h2.157a.063.063 0 0 0 .063-.062v-.483a2.126 2.126 0 0 0-.114-.725 1.464 1.464 0 0 0-.328-.544zm-.765.58a.65.65 0 0 1 .106.22c.02.071.033.148.038.229h-1.137c.022-.216.082-.377.177-.478a.518.518 0 0 1 .395-.167.55.55 0 0 1 .246.052.48.48 0 0 1 .175.144zM6.26 7.63h-.137L5.41 9.336h.179l.218-.534h.769l.22.534h.18l-.714-1.708H6.26zm-.419 1.04.352-.844.341.844h-.693zm1.483.035h.555c.292 0 .489-.262.489-.54 0-.265-.211-.536-.503-.536h-.708v1.708h.166v-.632zm0-.926h.532c.187 0 .346.172.346.386 0 .207-.13.392-.332.392h-.546v-.778zm1.129 1.558.218-.534h.767l.22.534h.184l-.714-1.708H8.99l-.715 1.708h.177zm.606-1.51.342.843H8.71l.352-.844H9.06zm.778.643c0-.41.297-.85.81-.85a.672.672 0 0 1 .631.372l-.135.081a.538.538 0 0 0-.504-.303c-.408 0-.632.365-.632.709 0 .376.276.718.639.718a.58.58 0 0 0 .526-.318l.14.073c-.111.256-.414.397-.676.397-.468 0-.799-.447-.799-.88zm1.875.867h-.165V7.629h.165v.76h1.011v-.76h.169v1.708h-.169v-.799h-1.01v.799zm2.71 0h-1.145V7.629h1.124v.15h-.959v.616h.836v.142h-.837v.65h.982v.15z",source:"https://apache.org/logos/",hex:"D22128",guidelines:void 0,license:void 0},siApachekafka={title:"Apache Kafka",slug:"apachekafka",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache Kafka</title><path d="'+this.path+'"/></svg>'},path:"M9.71 2.136a1.43 1.43 0 0 0-2.047 0h-.007a1.48 1.48 0 0 0-.421 1.042c0 .41.161.777.422 1.039l.007.007c.257.264.616.426 1.019.426.404 0 .766-.162 1.027-.426l.003-.007c.261-.262.421-.629.421-1.039 0-.408-.159-.777-.421-1.042H9.71zM8.683 22.295c.404 0 .766-.167 1.027-.429l.003-.008c.261-.261.421-.631.421-1.036 0-.41-.159-.778-.421-1.044H9.71a1.42 1.42 0 0 0-1.027-.432 1.4 1.4 0 0 0-1.02.432h-.007c-.26.266-.422.634-.422 1.044 0 .406.161.775.422 1.036l.007.008c.258.262.617.429 1.02.429zm7.89-4.462c.359-.096.683-.33.882-.684l.027-.052a1.47 1.47 0 0 0 .114-1.067 1.454 1.454 0 0 0-.675-.896l-.021-.014a1.425 1.425 0 0 0-1.078-.132c-.36.091-.684.335-.881.686-.2.349-.241.75-.146 1.119.099.363.33.691.675.896h.002c.346.203.737.239 1.101.144zm-6.405-7.342a2.083 2.083 0 0 0-1.485-.627c-.58 0-1.103.242-1.482.627-.378.385-.612.916-.612 1.507s.233 1.124.612 1.514a2.08 2.08 0 0 0 2.967 0c.379-.39.612-.923.612-1.514s-.233-1.122-.612-1.507zm-.835-2.51c.843.141 1.6.552 2.178 1.144h.004c.092.093.182.196.265.299l1.446-.851a3.176 3.176 0 0 1-.047-1.808 3.149 3.149 0 0 1 1.456-1.926l.025-.016a3.062 3.062 0 0 1 2.345-.306c.77.21 1.465.721 1.898 1.482v.002c.431.757.518 1.626.313 2.408a3.145 3.145 0 0 1-1.456 1.928l-.198.118h-.02a3.095 3.095 0 0 1-2.154.201 3.127 3.127 0 0 1-1.514-.944l-1.444.848a4.162 4.162 0 0 1 0 2.879l1.444.846c.413-.47.939-.789 1.514-.944a3.041 3.041 0 0 1 2.371.319l.048.023v.002a3.17 3.17 0 0 1 1.408 1.906 3.215 3.215 0 0 1-.313 2.405l-.026.053-.003-.005a3.147 3.147 0 0 1-1.867 1.436 3.096 3.096 0 0 1-2.371-.318v-.006a3.156 3.156 0 0 1-1.456-1.927 3.175 3.175 0 0 1 .047-1.805l-1.446-.848a3.905 3.905 0 0 1-.265.294l-.004.005a3.938 3.938 0 0 1-2.178 1.138v1.699a3.09 3.09 0 0 1 1.56.862l.002.004c.565.572.914 1.368.914 2.243 0 .873-.35 1.664-.914 2.239l-.002.009a3.1 3.1 0 0 1-2.21.931 3.1 3.1 0 0 1-2.206-.93h-.002v-.009a3.186 3.186 0 0 1-.916-2.239c0-.875.35-1.672.916-2.243v-.004h.002a3.1 3.1 0 0 1 1.558-.862v-1.699a3.926 3.926 0 0 1-2.176-1.138l-.006-.005a4.098 4.098 0 0 1-1.173-2.874c0-1.122.452-2.136 1.173-2.872h.006a3.947 3.947 0 0 1 2.176-1.144V6.289a3.137 3.137 0 0 1-1.558-.864h-.002v-.004a3.192 3.192 0 0 1-.916-2.243c0-.871.35-1.669.916-2.243l.002-.002A3.084 3.084 0 0 1 8.683 0c.861 0 1.641.355 2.21.932v.002h.002c.565.574.914 1.372.914 2.243 0 .876-.35 1.667-.914 2.243l-.002.005a3.142 3.142 0 0 1-1.56.864v1.692zm8.121-1.129l-.012-.019a1.452 1.452 0 0 0-.87-.668 1.43 1.43 0 0 0-1.103.146h.002c-.347.2-.58.529-.677.896-.095.365-.054.768.146 1.119l.007.009c.2.347.519.579.874.673.357.103.755.059 1.098-.144l.019-.009a1.47 1.47 0 0 0 .657-.885 1.493 1.493 0 0 0-.141-1.118",source:"https://apache.org/logos/",hex:"231F20",guidelines:void 0,license:void 0},siApachekylin={title:"Apache Kylin",slug:"apachekylin",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache Kylin</title><path d="'+this.path+'"/></svg>'},path:"M8.033 16.459l-.59 1.29h.142l.155-.344h.72l.154.345h.144l-.59-1.291h-.135zm-.243.835l.31-.694.31.694h-.62zm1.154-.515v1.328h.131v-.54a.424.424 0 0 0 .369.192c.277 0 .483-.2.483-.494a.47.47 0 0 0-.483-.493.42.42 0 0 0-.374.2v-.192h-.126zm.49.107c.205 0 .362.153.362.378 0 .227-.157.379-.361.379-.207 0-.362-.152-.362-.379 0-.224.155-.378.362-.378zm1.487.864v-.602c0-.25-.142-.376-.392-.376a.616.616 0 0 0-.395.13l.059.099a.494.494 0 0 1 .323-.115c.18 0 .274.09.274.257v.059h-.308c-.278 0-.374.125-.374.275 0 .167.135.282.354.282.16 0 .275-.061.334-.16v.15h.125zm-.13-.292c-.052.128-.161.198-.309.198-.154 0-.245-.07-.245-.183 0-.1.06-.173.25-.173h.303v.158zm.525-.193c0 .228.155.378.367.378a.328.328 0 0 0 .282-.142l.098.066c-.077.125-.216.192-.38.192-.29 0-.5-.205-.5-.494 0-.29.21-.493.5-.493.164 0 .303.065.38.192l-.098.066a.33.33 0 0 0-.282-.144c-.212 0-.367.152-.367.379zm1.12-.884v.568c.072-.112.199-.177.363-.177.236 0 .398.137.398.415v.563h-.13v-.55c0-.205-.108-.31-.292-.31-.208 0-.34.13-.34.35v.51h-.13v-1.37h.13zm1.968.884c0-.292-.198-.493-.47-.493-.274 0-.475.205-.475.493 0 .287.207.494.51.494a.477.477 0 0 0 .374-.159l-.074-.085a.382.382 0 0 1-.297.128c-.212 0-.367-.135-.382-.338h.812l.002-.04zm-.814-.058a.337.337 0 0 1 .343-.322c.19 0 .329.132.345.322h-.688zm1.728-.748v.78l.758-.78h.157l-.559.584.598.707h-.162l-.528-.607-.264.267v.34h-.136v-1.291h.136zm1.292 1.383l.042-.094-.433-.969h.136l.365.825.365-.825h.13l-.486 1.087c-.08.19-.184.25-.322.25a.332.332 0 0 1-.236-.088l.06-.098a.243.243 0 0 0 .178.074c.086 0 .145-.04.2-.162zm.92-1.461v1.369h-.131v-1.37h.13zm.365.398h.13v.97h-.13v-.97zm.066-.212a.095.095 0 0 1-.095-.094c0-.05.042-.092.095-.092a.093.093 0 1 1 0 .186zm.556.212v.18c.07-.119.2-.187.369-.187.236 0 .398.137.398.415v.562h-.131v-.55c0-.204-.107-.309-.291-.309-.209 0-.34.13-.34.35v.51h-.13v-.97h.125zM2.086 15.41C.264 15.4.124 15.395.063 15.356c-.084-.055-.084-.137-.002-.302.223-.448.78-.76 1.676-.943.575-.116.917-.252 1.23-.487.374-.281.418-.538.12-.69a2.52 2.52 0 0 1-.868-.786c-.294-.447-.492-1.162-.492-1.778 0-.321.168-.938.36-1.323.282-.565.68-.963 1.236-1.235a3.043 3.043 0 0 1 1.25-.298c.085 0 .142-.014.178-.044.05-.04.052-.051.026-.13-.04-.119-.206-.266-.373-.328-.156-.058-.332-.085-.807-.122-.18-.013-.38-.04-.444-.06a.788.788 0 0 1-.411-.28c-.057-.085-.067-.126-.067-.259 0-.14.011-.179.098-.338.092-.168.13-.267.2-.522.023-.086.037-.102.09-.102.033 0 .1.031.148.07.292.23 1.183.53 1.571.53.246 0 .361-.035.453-.14.064-.073.071-.095.058-.181a1.036 1.036 0 0 0-.268-.502c-.14-.14-.426-.285-.694-.355a1.921 1.921 0 0 0-.504-.054c-.345-.004-.373.004-.563.163-.158.132-.21.12-.386-.089-.441-.522-.646-1.065-.518-1.37.041-.1.095-.121.467-.184.163-.027.498-.091.744-.143.965-.202 1.498-.268 2.164-.267.56.001.585-.006.736-.231.199-.297.271-.585.272-1.088 0-.406.018-.455.162-.455.113 0 .276.08.357.176.16.189.221.439.249 1.012.017.351.035.509.08.686.094.364.146.445.543.837.493.488.64.722.731 1.16.073.352.032.768-.107 1.085-.171.393-.579.845-1.033 1.147-.351.234-.757.427-2.302 1.097-.297.128-.61.27-.696.312-.559.282-1.082.816-1.283 1.31-.058.14-.07.21-.08.443-.016.43.076.72.34 1.07.181.242.53.508.791.606.323.121.776.127 1.154.016.37-.108.797-.361.747-.442-.026-.042-.08-.031-.245.048-.627.299-1.316.344-1.71.112a2.043 2.043 0 0 1-.55-.551c-.228-.386-.3-.932-.173-1.303a1.14 1.14 0 0 1 .313-.468c.24-.233.993-.618 2.46-1.258.868-.38 1.04-.464 1.342-.666a3.719 3.719 0 0 0 1.67-3.135c0-.148.01-.27.021-.27.028 0 .19.216.313.416.627 1.026.843 2.398.54 3.443-.284.978-.948 1.741-1.77 2.034a2.307 2.307 0 0 1-.88.14 2.57 2.57 0 0 1-.852-.13c-.467-.135-.814-.148-1.19-.044-.346.096-.52.235-.588.47a.682.682 0 0 0 .08.518c.086.16.165.215.323.228.234.019.547-.145.547-.287 0-.031-.07-.178-.156-.326-.086-.148-.156-.295-.156-.328 0-.089.084-.133.251-.133.22 0 .36.076.528.284.158.196.301.3.47.34.206.05.235.158.13.476-.175.522-.62 1.133-1.429 1.96a8.642 8.642 0 0 0-.596.66c-.224.319-.44.787-.565 1.224-.087.306-.164.384-.41.412-.039.005-.952.003-2.028-.004zM9.741 2.668a10.68 10.68 0 0 1 5.137-.638c2.634.336 4.891 1.67 6.295 3.72.499.728.699 1.143.7 1.451 0 .346-.242.533-.618.477a.98.98 0 0 1-.508-.271 24.729 24.729 0 0 1-.672-.781c-1.308-1.565-1.733-2.01-2.404-2.516a8.626 8.626 0 0 0-1.856-1.044c-1.82-.713-3.944-.805-6.106-.266-.494.123-.48.067.032-.132zM23.807 12.89c-.359.932-1.224 1.631-2.401 1.942-.939.247-1.7.244-2.46-.01a4.319 4.319 0 0 1-1.42-.84c-.22-.205-.294-.23-.294-.097 0 .067.034.124.18.306.231.285.336.488.316.613-.02.123-.104.19-.261.21-.185.022-2.544.004-2.593-.02-.104-.051.012-.31.203-.45.143-.104.275-.158.492-.199.184-.035.247-.075.247-.157 0-.02-.054-.146-.12-.278a2.606 2.606 0 0 1-.23-.723c-.024-.13-.177-.073-.319.117-.247.331-.419.856-.53 1.623-.056.377-.085.46-.18.502-.048.022-.56.028-2.072.026a104.858 104.858 0 0 1-2.07-.014c-.213-.04-.178-.254.08-.48.21-.184.703-.417 1.303-.616.406-.135.454-.173.452-.36-.002-.29-.235-.573-.873-1.06-.671-.511-.864-1.516-.43-2.235.261-.431.73-.782 1.2-.897.803-.196 1.43.033 1.722.628.11.225.182.477.16.563-.022.089-.093.071-.272-.066-.258-.198-.434-.27-.682-.28-.255-.01-.416.036-.552.16-.158.141-.198.244-.199.508 0 .208.007.242.077.392.377.796 1.599.95 2.453.308.278-.21.623-.788.724-1.216.043-.181.05-.267.04-.528-.009-.267-.02-.342-.082-.519-.155-.445-.343-.685-.672-.855-.503-.26-1.133-.33-1.989-.22-.728.092-1.493.059-1.95-.086-.2-.063-.27-.114-.27-.194 0-.067.023-.074.3-.094.428-.031.896-.147 1.651-.408.248-.086.556-.183.684-.215.783-.198 1.609-.252 2.218-.146.26.045.572.2.811.402.695.588 1.368 1.78 1.913 3.39.168.497.323.839.506 1.117.41.627.958 1.01 1.65 1.155.08.017.28.03.444.029a2.19 2.19 0 0 0 1.002-.235c.608-.289.977-.74 1.163-1.423.068-.25.075-.85.013-1.086-.144-.54-.492-.896-1.038-1.059-.239-.071-.773-.091-.942-.035a.877.877 0 0 0-.537.514c-.044.11-.054.186-.055.4-.002.237.005.278.062.4.174.371.505.547 1.031.548.26 0 .3.02.274.14-.03.136-.178.225-.437.265a1.667 1.667 0 0 1-.986-.13c-.308-.143-.595-.477-.72-.835a1.452 1.452 0 0 1-.021-.76 2.4 2.4 0 0 1 .368-.732c.399-.492 1.06-.746 1.775-.68 1.002.092 1.779.639 2.121 1.494.278.693.288 1.796.022 2.486zm-12.888.57c-.265.18-1.02.268-1.913.22-.547-.028-.6-.019-.639.113-.041.145.034.318.234.535.27.295.291.447.077.562-.098.052-.107.052-1.539.058-1.2.004-1.453 0-1.517-.029-.139-.06-.129-.264.021-.434.133-.15.178-.163.652-.178.387-.012.431-.017.462-.06a.189.189 0 0 0 .033-.095c0-.081-.102-.304-.212-.466-.175-.258-.205-.345-.206-.608-.001-.257.024-.317.175-.42.253-.172.937-.1 1.626.173.67.265 1.328.371 2.309.371.509 0 .585.005.597.038.019.047-.055.15-.16.22zm10.194 5.002c.047.04.038.178-.02.29-.123.242-.518.705-1.008 1.183-.842.821-1.599 1.354-2.673 1.884-1.593.786-3.18 1.16-4.87 1.148a19.02 19.02 0 0 1-.675-.012 10.35 10.35 0 0 1-2.395-.479c-2.186-.718-4.043-2.16-5.4-4.19-.375-.563-.517-.895-.538-1.256-.015-.254.011-.37.12-.531a.539.539 0 0 1 .242-.2c.156-.08.178-.084.396-.083.503.004.899.247 1.353.83.086.11.326.449.535.752.43.628.756 1.068 1.046 1.416.255.306.72.77.976.975.419.334 1.405.863 2.117 1.134 2.32.883 4.7.8 7.069-.247 1.22-.54 2.408-1.364 3.27-2.27.295-.31.4-.39.455-.344z",source:"https://apache.org/logos/",hex:"F09D13",guidelines:void 0,license:void 0},siApachemaven={title:"Apache Maven",slug:"apachemaven",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache Maven</title><path d="'+this.path+'"/></svg>'},path:"M4.237.001c-.312-.013-.665.072-.828.457-.158.374-.283 1.188-.34 2.276l1.223.591c-.02-.737.007-1.43.076-2.066-.026.299-.056.96.006 2.039.019.342.049.725.088 1.15.002.024.002.047.007.069a45.485 45.485 0 0 0 .309 2.412c.057.368.126.752.195 1.16l-.01.01c.014.01.015.018.014.023l.03.16c.03.162.06.328.093.494l.108.553.056.289a61.72 61.72 0 0 0 .457 2.068c.09.382.186.78.287 1.186.098.386.199.783.309 1.193.096.362.199.735.303 1.117.003.018.012.036.015.055a145.826 145.826 0 0 0 .34 1.185l.049.174c.078.261.158.533.242.805a4.2 4.2 0 0 1-.293-.135l-.19-.654c-.02-.077-.042-.148-.062-.225l-.002-.004-.004-.002c-.087-.3-.17-.607-.257-.916-.023-.087-.044-.173-.069-.263l-.314-1.178c-.1-.381-.194-.765-.29-1.154-.094-.39-.185-.78-.277-1.172-.093-.401-.181-.8-.265-1.203-.085-.396-.161-.798-.24-1.193a50.315 50.315 0 0 1-.211-1.17c-.004-.013-.006-.03-.01-.041l.004-.002c-.057-.386-.116-.77-.174-1.15a60.905 60.905 0 0 1-.154-1.204 27.447 27.447 0 0 1-.172-2.41l-1.22-.59c-.004.074-.01.15-.013.23-.012.294-.02.605-.023.93a45.3 45.3 0 0 0 .006 1.157c.009.37.025.755.045 1.148.02.336.042.675.07 1.022l.002.039.006.004c.003.023.007.05.006.076.033.368.064.739.107 1.115a34.493 34.493 0 0 0 .303 2.125c.01.064.024.131.035.195a23.418 23.418 0 0 0 .547 2.32c.07.237.14.464.21.68.063.182.13.365.194.545.155.422.327.832.512 1.232l.006.004a.318.318 0 0 0 .02.05c.225.485.475.95.755 1.395.01.013.02.033.03.047-.455-.183-1.259-.098-1.253-.097.83.288 1.557.64 2.016 1.175-.183.2-.523.352-.953.477.594.064.924-.039 1.045-.092-.31.26-.483.732-.635 1.24.35-.57.696-.949 1.033-1.094.078.258.162.524.244.788A147.532 147.532 0 0 0 5.157 24a.56.56 0 0 0 .43-.312c.13-.282.83-1.775 1.908-3.875.413 1.303.88 2.679 1.386 4.109a.494.494 0 0 0 .076-.465 103.735 103.735 0 0 1-1.308-3.945c.154-.299.316-.612.484-.932.125.04.255.094.389.155.203.186.352.491.482.84a1.515 1.515 0 0 0-.334-1.098c1.335.258 2.547.09 3.287-.81a3.97 3.97 0 0 0 .192-.258c-.325.304-.682.404-1.313.273.996-.281 1.523-.617 2.035-1.22.12-.145.244-.303.371-.48-.943.722-1.927.822-2.9.493l-.045-.018c.914.02 2.203-.474 3.092-1.189.41-.33.796-.73 1.17-1.21.28-.359.55-.76.82-1.216.234-.393.468-.824.7-1.293a2.83 2.83 0 0 1-.74.137l-.144.008c-.048.002-.093 0-.146.002.885-.198 1.5-.74 1.994-1.447-.24.117-.628.262-1.07.297-.058.006-.12.006-.182.006-.013-.002-.028 0-.047-.002.306-.078.574-.178.81-.309a3.363 3.363 0 0 0 .358-.236c.044-.037.088-.07.13-.106.099-.086.193-.18.28-.287.028-.034.056-.063.08-.098.036-.05.073-.098.104-.146a8.388 8.388 0 0 0 .51-.828c.015-.031.032-.057.046-.088.04-.084.08-.16.11-.227.042-.099.074-.179.092-.238a.515.515 0 0 1-.108.051c-.273.112-.727.187-1.086.201-.004 0-.008 0-.013.004h-.067c.72-.214 1.067-.45 1.422-.818a13.883 13.883 0 0 0 1.154-1.428c.264-.37.505-.738.692-1.072a6.5 6.5 0 0 0 .298-.592c.066-.157.122-.305.172-.45-.466.01-.986.011-1.48 0 .495.01 1.015.007 1.484-.005.5-1.485.063-2.262.063-2.262s-.526-1.212-1.4-.851c-.426.175-1.172.73-2.083 1.56l.514 1.45a17.561 17.561 0 0 1 1.703-1.602c-.257.22-.807.726-1.615 1.644-.256.29-.537.624-.844.997-.017.02-.035.038-.047.06a51.435 51.435 0 0 0-1.666 2.187c-.248.34-.498.704-.765 1.088h-.016c.002.02-.004.028-.01.032l-.101.152c-.104.155-.213.31-.318.47l-.352.534c-.061.09-.124.181-.186.277-.184.282-.367.573-.558.873a97.351 97.351 0 0 0-1.428 2.338 96.866 96.866 0 0 0-1.341 2.343c-.012.017-.02.04-.034.057a197.256 197.256 0 0 0-.668 1.223l-.097.181c-.17.318-.346.642-.52.979 0 .004-.005.008-.006.013-.026.048-.05.093-.072.141-.117.222-.218.424-.45.87a1.352 1.352 0 0 0-.233-.182l.345-.65c.047-.089.096-.177.143-.27l.04-.077.546-1.001.13-.233v-.006l-.001-.006c.169-.31.345-.62.52-.94.051-.087.102-.173.153-.265.224-.395.454-.794.684-1.197a91.685 91.685 0 0 1 2.135-3.504c.247-.386.503-.77.754-1.152.092-.138.182-.272.279-.41a72.9 72.9 0 0 1 .48-.701c.007-.012.019-.024.026-.037h.006c.26-.356.517-.713.773-1.065.278-.373.554-.735.83-1.09a31.075 31.075 0 0 1 1.777-2.075l-.515-1.446c-.06.057-.126.116-.192.178a32.37 32.37 0 0 0-.758.729c-.295.294-.597.606-.912.935a46.032 46.032 0 0 0-1.632 1.838l-.03.033.002.008c-.017.02-.033.044-.054.064-.266.323-.538.649-.801.985a39.105 39.105 0 0 0-1.445 1.95c-.043.06-.085.126-.127.186a26.458 26.458 0 0 0-1.403 2.303c-.13.247-.256.485-.37.715-.096.195-.187.395-.278.591-.21.463-.398.93-.566 1.399l.002.006a.36.36 0 0 0-.026.058c-.108.303-.203.608-.29.914-.14.174-.302.325-.483.46a3.505 3.505 0 0 0-.131-.153 5.148 5.148 0 0 0 .824-2.211 6.4 6.4 0 0 0-.016-1.488c-.046-.4-.126-.82-.238-1.274-.097-.393-.217-.81-.363-1.248-.091.185-.22.367-.379.545l-.086.094c-.029.032-.06.06-.092.094.434-.674.486-1.397.358-2.148a2.722 2.722 0 0 1-.49.85c-.033.038-.072.077-.11.116-.01.007-.019.018-.033.028.144-.24.25-.467.318-.698a1.29 1.29 0 0 0 .04-.146 2.85 2.85 0 0 0 .038-.225l.018-.146a2.11 2.11 0 0 0-.002-.354c-.003-.04-.004-.076-.01-.113-.01-.055-.016-.105-.027-.154a7.416 7.416 0 0 0-.193-.84c-.01-.028-.015-.056-.026-.084-.027-.079-.048-.149-.072-.209a2.1 2.1 0 0 0-.09-.209.455.455 0 0 1-.035.1c-.102.24-.34.57-.557.8-.003.003-.007.005-.007.01l-.04.043c.318-.58.39-.946.385-1.398a12.274 12.274 0 0 0-.16-1.615 10.68 10.68 0 0 0-.232-1.104 5.853 5.853 0 0 0-.18-.558 6.337 6.337 0 0 0-.172-.391 26.18 26.18 0 0 0 .002-.004C5.576.341 4.82.124 4.82.124s-.27-.11-.582-.123zm3.38 15.783l.032.082v.002c-.06.033-.116.067-.178.097-.012.004-.024.012-.039.018a2.41 2.41 0 0 0 .186-.2zm-.603 1.626c.13.136.25.242.354.32l.07.227a1.866 1.866 0 0 0-.246.053l-.03-.098c-.024-.084-.048-.17-.076-.257l-.021-.073zm.26.875a2.34 2.34 0 0 1 .271.01l.07.229a.778.778 0 0 1 .247-.004l-.326.627a127.643 127.643 0 0 1-.262-.862z",source:"https://apache.org/logos/",hex:"C71A36",guidelines:void 0,license:void 0},siApachenetbeanside={title:"Apache NetBeans IDE",slug:"apachenetbeanside",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache NetBeans IDE</title><path d="'+this.path+'"/></svg>'},path:"M22.8575 6.1211c-.0092-.0866-.0486-.1598-.121-.2104C22.7381 5.9098 12.1194.032 12.1185.03a.2487.2487 0 00-.2372 0c-.003 0-10.6129 5.8784-10.6145 5.8797-.0744.0497-.1156.1241-.1243.2124v11.8365c.0149.0565.0178.1253.071.161.0183.0788 10.6175 5.7985 10.6694 5.8507a.2456.2456 0 00.2343 0c.0025-.0017 10.6135-5.7957 10.6147-5.7984.0748-.0489.115-.1262.1256-.2133V6.1211zm-17.633 9.3292L1.6323 17.534V6.5401l3.5922 2.011zm13.551-6.8993l3.5922-2.0109v10.9938l-3.5922-2.0836zm-.7407-.1455c-2.0115 1.1316-4.0232 2.263-6.0348 3.3943a125706.698 125706.698 0 01-6.0349-3.3943L12 4.9349zM5.7143 15.4473V8.8265l6.0408 3.398v6.5444l-6.0408-3.3216zm6.5305 3.3216v-6.5444l6.0409-3.398v6.6208c-2.0135 1.1074-4.0272 2.2145-6.0408 3.3216zM12 .5247l10.1094 5.5984-3.5771 2.003-6.4104-3.6858a.2418.2418 0 00-.2439 0L5.4676 8.126l-3.577-2.003L12 .5248zM5.4728 15.8731l6.2823 3.4547v4.014L1.8868 17.952zm6.772 7.4686v-4.014l6.2824-3.4546 3.586 2.0789z",source:"https://apache.org/logos/",hex:"1B6AC6",guidelines:void 0,license:void 0},siApacheopenoffice={title:"Apache OpenOffice",slug:"apacheopenoffice",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache OpenOffice</title><path d="'+this.path+'"/></svg>'},path:"M12 0C5.372 0 0 5.371 0 12c0 .843.088 1.667.254 2.462a12.594 12.594 0 013.309-.44c1.836 0 3.579.392 5.152 1.099a12.536 12.536 0 017.303-2.332c1.704 0 3.33.339 4.811.953l.023.01a.186.186 0 01-.083.353l-.267-.02a12.525 12.525 0 00-.895-.032c-4.208 0-7.988 1.546-10.281 4.681l-.11.151a.183.183 0 01-.28.008C6.76 16.847 3.894 16.037.677 15.981 2.32 20.65 6.768 24 11.998 24 18.628 24 24 18.627 24 12c0-6.628-5.373-12-12.001-12zm9.395 7.181c-.042-.004-.114-.016-.16-.022a6.703 6.703 0 00-.405-.051c-2.447-.23-4.725.449-6.21 2.171-.063.064-.118.067-.179.003-1.181-1.34-2.864-1.935-4.795-2.118a7.24 7.24 0 00-2.01.09l-.01.001-.02.002a.125.125 0 01-.075-.223l.035-.02a7.23 7.23 0 014.05-.795c1.054.1 2.035.42 2.9.91a7.279 7.279 0 016.797-.255c.045.025.093.047.14.073a.116.116 0 01.067.11c0 .069-.044.134-.125.124z",source:"https://apache.org/logos",hex:"0E85CD",guidelines:void 0,license:void 0},siAltiumdesigner={title:"Altium Designer",slug:"altiumdesigner",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Altium Designer</title><path d="'+this.path+'"/></svg>'},path:"M19.14 5.876a1.012 1.012 0 00-.442-.442L9.744.171c-.329-.226-.843-.226-1.203-.01L5.148 2.145c-.051.041-.102.082-.144.123a1.086 1.086 0 00-.288.72l.01 6.569-.02.215.062.123a.478.478 0 00.195.206.516.516 0 00.555.01L8.859 8.2a.573.573 0 00.175-.175l.082-.165V4.643l2.251 1.326 3.536 2.077a.413.413 0 01.164.185.442.442 0 01.062.226v7.052a.52.52 0 01-.072.257c-.041.072-.082.123-.154.154l-4.225 2.488-1.573.925v-3.228l1.953-1.172 1.049-.627.185-.175.021-.051a.542.542 0 00.062-.247V9.999a.51.51 0 00-.092-.288l-.062-.123-.144-.072c-.093-.041-.175-.041-.247-.041l-.175.01-6.363 3.865a1.129 1.129 0 00-.442.463 1.281 1.281 0 00-.144.607v6.559c0 .257.103.514.329.75.082.062.154.113.236.164l3.341 1.943c.186.113.381.164.597.164.216 0 .422-.051.596-.164l8.882-5.212c.195-.103.36-.267.442-.432.113-.185.164-.401.164-.617V6.483a1.236 1.236 0 00-.153-.607zM8.387 7.624L5.447 9.32V2.988c0-.072.031-.154.092-.216l.216-.123 2.632 1.563v3.412zm-2.951 6.795c0-.093.021-.185.062-.278a.409.409 0 01.175-.175l5.973-3.629v3.392l-.956.576-2.313 1.388-2.94 1.778v-3.052zm0 6.559v-2.663l2.94-1.768v3.218l-2.632 1.552-.103-.062c-.051-.031-.093-.051-.103-.062-.061-.071-.102-.143-.102-.215zm13.128-3.403a.518.518 0 01-.072.257.342.342 0 01-.165.154l-8.892 5.222a.405.405 0 01-.452 0l-2.508-1.47 4.575-2.693v-.01l4.215-2.478a.998.998 0 00.432-.442 1.13 1.13 0 00.175-.606V8.457c0-.216-.062-.421-.165-.596a1.189 1.189 0 00-.432-.442l-3.536-2.077-3.352-1.974-1.923-1.141L8.911.788a.446.446 0 01.452 0l8.985 5.294a.319.319 0 01.154.154.517.517 0 01.062.247v11.092z",source:"https://www.altium.com/altium-designer/",hex:"A5915F",guidelines:void 0,license:void 0},siAldinord={title:"Aldi Nord",slug:"aldinord",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Aldi Nord</title><path d="'+this.path+'"/></svg>'},path:"M13.812 2.057 6.086 13.73c-.349.523-.581.89-.592 1.461-.01.541.128 1.027.395 1.495h1.46a2.11 2.11 0 0 1-.546-1.531c.007-.125.03-.28.067-.405h9.833a1.933 1.933 0 0 0-.297-.583H7.145a11.3 11.3 0 0 1 .379-.604l.507-.76h7.47l-.408-.614H8.44l6.702-10.132zm-3.502 0L3.092 12.963c-.549.823-.806 1.304-.806 2.068 0 .871.232 1.255.409 1.655h1.153a4.007 4.007 0 0 1-.096-.232 3.327 3.327 0 0 1-.233-1.23c.02-.811.302-1.356.772-2.058l7.381-11.109zm6.34 14.629c.338-.352.58-.927.547-1.532-.028-.517-.343-1.026-.72-1.591l-4.234-6.35.648-.974 4.993 7.491c.348.523.58.89.592 1.461a2.833 2.833 0 0 1-.395 1.495h-1.43zm3.508 0c.041-.09.062-.144.094-.23.123-.324.27-.768.26-1.231-.02-.812-.302-1.357-.773-2.059l-5.745-8.58.665-.996 6.25 9.373c.548.824.805 1.303.805 2.068 0 .871-.232 1.255-.409 1.655zm-17.53.457v4.8h18.743v-4.8zm3.588.571h1.672l1.873 3.658H8.104l-.176-.385H6.177L6 21.372H4.343zm3.761 0h1.67v2.601h1.435v1.057H9.977zm3.422 0h2.43c1.002 0 1.814.82 1.814 1.83a1.822 1.822 0 0 1-1.815 1.828h-2.43zm4.614 0h1.644v3.658h-1.644zm-2.974 1.034v1.59h.352c.41 0 .743-.356.743-.795 0-.44-.332-.795-.743-.795zm-7.996.465-.374.811h.767zm.84-6.189h7.767l.614.922H7.276c.088-.145.607-.922.607-.922m4.035-10.967L4.488 13.24c-.465.695-.731 1.214-.75 1.99-.01.452.128 1.013.337 1.457h1.576a2.942 2.942 0 0 1-.376-1.497c.012-.615.266-1.01.614-1.531l7.678-11.6zm6.431 14.629a2.94 2.94 0 0 0 .376-1.497c-.012-.615-.266-1.01-.613-1.532l-5.079-7.625.827-1.247 5.652 8.454c.465.695.732 1.214.75 1.99.011.452-.128 1.013-.338 1.457H18.35zM23.429 0H.57v24h22.86zm-.915 23.086H1.486V.914h21.028z",source:"https://commons.wikimedia.org/wiki/File:Aldi_Nord_201x_logo.svg",hex:"2490D7",guidelines:void 0,license:void 0},siApachepulsar={title:"Apache Pulsar",slug:"apachepulsar",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache Pulsar</title><path d="'+this.path+'"/></svg>'},path:"M24 8.925h-5.866c-1.586-3.041-3.262-5.402-5.544-5.402-2.97 0-4.367 2.593-5.717 5.115l-.118.22H0v1.5h3.934c1.39 0 1.673.468 1.673.468-1.09 1.691-2.4 3.363-4.584 3.363H0v1.574h1.03c4.234 0 6.083-3.434 7.567-6.193 1.361-2.541 2.31-4.08 3.993-4.08 1.747 0 3.584 3.801 5.201 7.157.237.488.477.988.72 1.483-6.2.197-9.155 1.649-11.559 2.833-1.759.866-3.147 1.94-5.433 1.94H0v1.574h1.507c2.754 0 4.47-.85 6.295-1.751 2.53-1.243 5.398-2.652 12.157-2.652h3.907V14.5H21.66a1.18 1.18 0 01-.972-.393 70.83 70.83 0 01-1.133-2.321l-.511-1.047s.366-.393 1.38-.393H24Z",source:"https://apache.org/logos/",hex:"188FFF",guidelines:void 0,license:void 0},siApacherocketmq={title:"Apache RocketMQ",slug:"apacherocketmq",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache RocketMQ</title><path d="'+this.path+'"/></svg>'},path:"M11.438 23.467c-.517-.638-1.106-1.89-1.217-2.587l-.082-.511h1.835c1.435 0 1.835.036 1.835.165 0 .352-.412 1.553-.709 2.066-.333.577-1.021 1.41-1.155 1.4-.043-.004-.272-.244-.507-.533zm-4.532-4.193c-1.251-3.005-1.231-6.784.056-10.63.786-2.35 2.652-5.689 4.413-7.9L11.967 0l.422.493c.763.893 2.612 3.731 3.28 5.036 1.32 2.578 2.055 4.993 2.264 7.438.197 2.302-.176 4.837-.962 6.533l-.338.731-.727-.433-.727-.433H11.95c-2.466 0-3.287.039-3.476.166-.136.091-.453.29-.705.441l-.458.276-.405-.974zm9.338-1.79c.779-2.623.532-6.253-.635-9.344-.683-1.81-2.085-4.319-3.211-5.747-.357-.452-.387-.466-.609-.265-.441.398-1.854 2.622-2.544 4.002-1.927 3.856-2.484 7.995-1.521 11.308l.196.672h8.138l.186-.626zM3.311 19.835c.037-.155.108-.565.157-.909.079-.549.189-.729.885-1.443l.795-.815.002.507c.003.641.302 1.799.631 2.445l.254.498H4.64c-1.384-.001-1.396-.003-1.329-.283zm14.944-.376c.271-.613.529-1.616.606-2.352.031-.299.066-.282.762.379s.738.735.908 1.631c.098.516.179.952.179.97 0 .017-.618.031-1.373.031h-1.373l.291-.659zm-6.477-4.504a2.173 2.173 0 0 1-2.17-2.17c0-1.196.973-2.17 2.17-2.17s2.17.973 2.17 2.17-.973 2.17-2.17 2.17zm0-3.865c-.935 0-1.696.761-1.696 1.695s.761 1.696 1.696 1.696c.935 0 1.696-.761 1.696-1.696s-.761-1.695-1.696-1.695zM9.455 9.457a.657.657 0 1 1 0 1.314.657.657 0 0 1 0-1.314zm-.357 4.665a.8.8 0 1 1 0 1.6.8.8 0 0 1 0-1.6zm5.212-5.18a1.069 1.069 0 1 1 0 2.138 1.069 1.069 0 0 1 0-2.138zm0 5.75a1.418 1.418 0 1 1 0 2.836 1.418 1.418 0 0 1 0-2.836zM9.447 10.68l.491-.491.729.729-.491.491-.729-.729zm4.066-.336l.539.539-.729.729-.539-.539.729-.729zm-3.572 3.362l.491.491-.729.729-.491-.491.729-.729zm2.721 1.064l.61-.59.779.754-.61.59-.779-.754zm-1.717-2.167a.277.277 0 1 1 0 .554.277.277 0 0 1 0-.554zm.794 0a.277.277 0 1 1 0 .554.277.277 0 0 1 0-.554zm.794 0a.277.277 0 1 1 0 .554.277.277 0 0 1 0-.554z",source:"https://apache.org/logos/",hex:"D77310",guidelines:void 0,license:void 0},siApachesolr={title:"Apache Solr",slug:"apachesolr",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache Solr</title><path d="'+this.path+'"/></svg>'},path:"M20.741 3.8L8.926 16.573l14.849-6.851A11.979 11.979 0 0 0 20.741 3.8M11.975 0c-1.637 0-3.197.328-4.619.921l-1.585 13.36L13.693.124A12.168 12.168 0 0 0 11.975 0m11.918 10.459l-14.07 7.874 13.201-1.566a11.976 11.976 0 0 0 .869-6.308m-5.188 11.527a12.084 12.084 0 0 0 3.8-4.16l-12.374 2.457 8.574 1.703zM14.417.249L7.53 15.177 20.306 3.36A11.978 11.978 0 0 0 14.417.249M12.98 24a11.938 11.938 0 0 0 3.774-.945l-6.931-.822L12.98 24zM1.016 7.08a11.944 11.944 0 0 0-1.013 3.864l1.867 3.337-.854-7.201zm5.298-5.665a12.076 12.076 0 0 0-4.236 3.784l1.743 8.773L6.314 1.415z",source:"https://apache.org/logos/",hex:"D9411E",guidelines:void 0,license:void 0},siApachehadoop={title:"Apache Hadoop",slug:"apachehadoop",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache Hadoop</title><path d="'+this.path+'"/></svg>'},path:"M12.098 3.01c-1.133.277-1.466.474-1.842 1.787.478-.962.84-1.315 1.842-1.787zm3.228.076c-.834-.053-1.715.177-2.756.615a3.97 3.97 0 00-1.199.76c-.31.287-.576.62-.866 1.006a1.312 1.312 0 00-.468.095 1.868 1.868 0 00-.539.356c-.141.124-.28.252-.416.383v.002c-.123.12-.244.241-.363.365-.945.152-1.72.32-2.41.588a6.314 6.314 0 00-1.97 1.217c-.252.222-.482.469-.687.736a5.435 5.435 0 00-.503.803c-.13.142-.26.288-.399.414a1.45 1.45 0 01-.441.285c-.093.035-.133.058-.137.056-.004-.001-.008-.033-.012-.047.235-.21.267-.55.289-.86.03.034.053.068.082.113.031.047.062.095.1.142l.158.2.055-.249c.046-.208.081-.484.027-.724-.034-.153-.117-.315-.235-.393l.036-.09c.04-.1.08-.204.115-.303l.069-.193-.204.035c-.27.047-.852.366-1.261.791-.152.158-.284.33-.37.514a.984.984 0 00-.093.59.91.91 0 00.272.498c.03.12.058.223.087.316.033.104.068.198.112.29.119.247.31.398.529.468.182.059.369.066.566.02a3.83 3.83 0 00-.072.69 8.911 8.911 0 00.07 1.394c.013.093.028.184.045.275l-.107.291-.166.455-.37.365-.343.34a9.22 9.22 0 01-.082.08c-.232.224-.279.27-.213.662.04.241.119.484.242.72.114.216.267.427.463.624.245.245.647.55 1.066.71.245.092.488.138.723.097l-.039.11a4.046 4.046 0 01-.123.3c-.285.624.008.95.463 1.158.227.104.497.173.748.238l.168.045c.298.08.812.228 1.281.258.513.033.974-.073 1.098-.533.049-.182.078-.322.09-.459a2.33 2.33 0 00-.01-.406c.144-.32.21-.423.316-.578l.053-.08c.115-.17.168-.29.188-.426.018-.131.004-.262-.02-.461l-.011-.084a6.822 6.822 0 001.338.05l-.118.061-.055.03c-.395.203-.413.587-.289.984.112.357.343.723.487.945.303.467.592.861.943 1.076.368.226.786.253 1.328-.04.276-.15.363-.302.48-.507.038-.066.08-.133.126-.204.101-.05.382-.296.67-.534l.296-.242c.073.053.164.09.27.115.14.034.305.05.504.065.149.01.635.01.949.01h.227c.324.001.585-.016.783-.128.21-.119.334-.331.361-.71a1.28 1.28 0 00-.008-.378.946.946 0 00-.136-.312l-.014-.502-.016-.521a2.372 2.372 0 00-.068-.536 3.558 3.558 0 00-.18-.505c-.053-.127-.096-.245-.138-.36a5.756 5.756 0 00-.229-.547l.018-.123.181.174.266.258c.203.196.39.373.607.502.226.133.479.21.807.195a1.925 1.925 0 001.016-.385c.293-.216.528-.509.627-.832l.084-.279.07-.225c.482.082.998.11 1.498.057a3.7 3.7 0 001.351-.389 3.406 3.406 0 001.35-1.33h.002v-.002c.355-.616.555-1.34.63-2.088.062-.599.028-1.415-.097-2.2-.11-.701-.295-1.38-.55-1.87a.736.736 0 00-.137-.178 1.413 1.413 0 00-.51-.31c-.206-.07-.422-.084-.594.006a.485.485 0 00-.123.09 2.793 2.793 0 00-.3.388c-.106.153-.21.307-.337.414-.149.128-.327.202-.502.272a3.454 3.454 0 00-.261-.508 4.81 4.81 0 00-.399-.54 2.21 2.21 0 00-.365-.349 5.357 5.357 0 00-.41-.275c-.407-.255-.754-.559-1.108-.87-.16-.14-.323-.282-.482-.413-.842-.695-1.628-1.031-2.469-1.084zm-4.129.004c-.57.137-.68.245-.851.804.273-.41.43-.545.851-.804zm3.952.465c.829-.001 1.587.303 2.431 1.013.412.347.774.684 1.192.983-.152.013-.283.04-.455.107.21-.04.451 0 .67.04.06.039.124.078.189.116.295.174.463.27.662.547.21.294.386.589.541.912-.101-.036-.186-.067-.262-.09a.566.566 0 00-.533.034l-.012.006c-.163.079-.416.17-.586.197a.7.7 0 00.405-.006.565.565 0 00-.018.539.269.269 0 01-.02-.12.228.228 0 01.249-.208.233.233 0 01.187.33c-.117.02-.233.055-.353.1a4.41 4.41 0 00-.237.095 3.722 3.722 0 011.084-.02c.025.117.05.24.073.366l-.137.01-.012.002c-.174-.14-.367-.117-.633-.057-.806.184-.617.637-.988 1.318.385-.47.357-.962.984-1.11.147-.036.247-.078.346-.063-.178.09-.333.237-.394.41-.173.486-.065.895-.254 1.35.234-.407.249-.802.459-1.23.075-.153.354-.4.525-.403l.14-.002c.042.27.068.539.052.761a8.535 8.535 0 01-.198 1.24c.213-.272.31-.85.403-1.257.097-.424.07-.934-.014-1.389-.117-.625.527-.522.9-.816.275-.217.463-.564.715-.809.25-.243.644.114.742.352.426 1.03.62 2.65.508 3.69-.126 1.164-.69 2.437-1.719 3.01-1.31.732-2.854.285-4.156-.154-.278-.093-.47-.229-.715-.382.067.3.097.615.008.914-.14.474-.367 1.251.277 1.394.246.055.357.048.704-.13a1.3 1.3 0 01-.616.011.397.397 0 01-.314-.273c.06.044.16.066.33.107.478.115.932-.114 1.021-.445.052-.194.043-.295.153-.559.099.03.202.059.306.084l-.177.578c-.154.501-.752.904-1.28.895-.488-.009-.797-.314-1.134-.613l-.678-.6a5.228 5.228 0 01-1.658-.834c.4.472.673.732 1.232.967-.081.83-.37 1.436-.615 2.23-.111.36-.991 1.8-1.234 1.94-.174.1-1.26 1.016-1.465 1.136-.153.203-.287.483-.516.604-.698.37-1.148-.339-1.523-.936-.171-.272-.645-1.054-.23-1.273.39-.208.61-.357 1.009-.62.059.108.159.212.225.32l-.043-.352a2.752 2.752 0 01-.008-.596c.016-.206.03-.413.047-.62-.06.21-.179.42-.239.63-.024.084-.045.152-.056.214a7.05 7.05 0 01-2.682.034 16.76 16.76 0 00-.185-.926c-.018.278-.007 1.047-.008 1.476-.001.333-.016.448-.188.731-.16.265-.228.325-.453.773.019.283.019.47-.057.739-.125.446-1.386.098-1.718.007-.41-.112-1.256-.278-1.043-.824.187-.48.307-.986.398-1.658-.75-1.08-1.448-2.56-1.582-3.873-.104-1.019-.04-1.646.18-2.27.35-.987.837-1.843 1.62-2.53C5.778 7.89 6.767 7.516 8.316 7.28c-.373.417-.741.858-1.143 1.33-.406.479-.648.963-.906 1.487-.357.722-.348.996.125 1.63.407.547.627.794.804 1.328-.146.303-.2.56-.25.973.5.545.87.918 1.354 1.033.475.113.872.093 1.297-.125.944-.482 1.816-1.107 2.88-1.132.493-1.211.444-2.222.208-3.393-.162-.8-.227-1.557-.278-2.373-.2.84-.236 1.577-.088 2.414.18 1.008.318 2.124-.18 3.01-.962.073-1.788.658-2.655 1.107-.35.18-.712.198-1.098.092-.358-.098-.6-.334-.986-.78-.006-.446.095-.653.3-1.058.33-.65.695-1.255 1.094-1.894-.49.59-.953 1.084-1.338 1.677-.147-.419-.358-.633-.707-1.105-.34-.461-.375-.662-.12-1.196.255-.536.472-1.008.907-1.478.753-.813 1.443-1.717 2.266-2.518.447-.434.628-.42 1.22-.51a20.768 20.768 0 001.606-.31 22.5 22.5 0 01-1.553.08h-.015c.506-.646.799-1.006 1.62-1.363.95-.412 1.738-.652 2.47-.652zm.556 2.79c-1.101.276-1.307.739-1.166 1.45.121-.535.335-1.05 1.166-1.45zm-3.263.061c-.446.05-.89.096-1.336.139-.375.035-.436.03-.702.293-.403.399-.794 1.768-.92 2.316.198-.455.69-1.729 1.069-2.053.105-.09.18-.143.258-.183-.271.455-.252.566-.157 1.176.081-.62.295-.859.647-1.32a9.287 9.287 0 001.14-.368zm10.226.053c-.255.517-.65.95-1.185 1.215-.288.142-.47.093-.791.062.326.094.533.21.853.096.652-.233.967-.756 1.123-1.373zm-2.28.834c.023.047.046.096.067.144a.602.602 0 00-.05.041.572.572 0 00-.126-.181l.11-.004zm-3.26.4c-.36.166-.779.126-1.087.334-.271.184-.646.764-.922 1.01.2-.078.394-.212.57-.354.002.22.101.426.27.565a.31.31 0 01.092-.492.312.312 0 01.432.191c-.148.11-.284.238-.397.387a1.666 1.666 0 00-.24.44 4.222 4.222 0 012.002-1.294c-.2-.003-.437.034-.678.114a.732.732 0 00-.482-.614c.16-.085.316-.175.44-.287zm-1.042 1.64a.735.735 0 01-.125-.083.35.35 0 00.125.084zM1.32 8.34c-.953.672-1.19.978-1.062 2.338C.352 9.608.56 9.145 1.32 8.34zm-.808.404c-.482.336-.545.475-.5 1.059.105-.482.203-.664.5-1.059zm1.779.195c-.07.15-.118.264-.152.381-.147.508.066.962-.395 1.33.217.438.207.612.711.41.195-.078.355-.187.498-.316-.07.18-.133.361-.191.545l-.03.094c-.36.153-.834.25-1.015-.13a3.458 3.458 0 01-.203-.595c-.594-.615.294-1.427.777-1.719zm.123.276c.123.071.156.2.17.375-.073-.074-.132-.122-.227-.112.008-.06.019-.119.034-.177.007-.03.014-.058.023-.086zm14.87 3.267c-.131.022-.365.07-.495.092-.348.059-.387.142-.441.484l-.086.524a9.16 9.16 0 01.228-.568c.084-.184.132-.202.31-.3.127-.068.357-.163.483-.232zm-14.47 2.4c.274.946.738 1.876 1.255 2.657v.014a.993.993 0 01-.149.369c-.369.493-1.306-.23-1.578-.508-.297-.303-.496-.662-.543-.998-.034-.246-.001-.252.17-.426l.693-.701.153-.406zm12.405.62c.056.183.101.364.183.558.138.326.205.526.215.875l.032 1.106c.117.206.136.249.115.484-.043.481-.203.513-.625.506-.192-.003-.957-.007-1.15-.023-.274-.024-.429-.05-.512-.112.43-.316 1.162-1.619 1.304-2.068.151-.474.315-.888.438-1.326z",source:"https://apache.org/logos/#hadoop",hex:"66CCFF",guidelines:void 0,license:void 0},siAparat={title:"Aparat",slug:"aparat",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Aparat</title><path d="'+this.path+'"/></svg>'},path:"M12.0014 1.5938C2.7317 1.5906-1.9119 12.7965 4.641 19.3515c2.975 2.976 7.4496 3.8669 11.3374 2.257 3.8877-1.61 6.4228-5.4036 6.4228-9.6116 0-5.7441-4.6555-10.4012-10.3997-10.4031zM6.11 6.783c.5011-2.5982 3.8927-3.2936 5.376-1.1028 1.4834 2.1907-.4216 5.0816-3.02 4.5822-1.6118-.3098-2.6668-1.868-2.356-3.4794zm4.322 8.9882c-.5045 2.5971-3.8965 3.288-5.377 1.0959-1.4807-2.1922.427-5.0807 3.0247-4.5789 1.612.3114 2.6655 1.8714 2.3524 3.483zm1.2605-2.405c-1.1528-.2231-1.4625-1.7273-.4917-2.3877.9708-.6604 2.256.18 2.0401 1.3343-.1347.7198-.8294 1.1924-1.5484 1.0533zm6.197 3.8375c-.501 2.5981-3.8927 3.2935-5.376 1.1028-1.4834-2.1908.4217-5.0817 3.0201-4.5822 1.6117.3097 2.6667 1.8679 2.356 3.4794zm-1.9662-5.5018c-2.5981-.501-3.2935-3.8962-1.1027-5.3795 2.1907-1.4834 5.0816.4216 4.5822 3.02-.3082 1.6132-1.8668 2.6701-3.4795 2.3595zm-2.3348 11.5618l2.2646.611c1.9827.5263 4.0167-.6542 4.5433-2.6368l.639-2.4016a11.3828 11.3828 0 0 1-7.4469 4.4274zM21.232 3.5985l-2.363-.6284a11.3757 11.3757 0 0 1 4.3538 7.619l.6495-2.4578c.5194-1.9804-.6615-4.0076-2.6403-4.5328zM.6713 13.8086l-.5407 2.04c-.5263 1.9826.6542 4.0166 2.6368 4.5432l2.1066.5618a11.3792 11.3792 0 0 1-4.2027-7.145zM10.3583.702L8.1498.1261C6.166-.4024 4.1296.7785 3.603 2.763l-.5512 2.082A11.3757 11.3757 0 0 1 10.3583.702Z",source:"https://www.aparat.com/logo",hex:"ED145B",guidelines:void 0,license:void 0},siApachespark={title:"Apache Spark",slug:"apachespark",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache Spark</title><path d="'+this.path+'"/></svg>'},path:"M10.812 0c-.425.013-.845.215-1.196.605a3.593 3.593 0 00-.493.722c-.355.667-.425 1.415-.556 2.143a551.9 551.9 0 00-.726 4.087c-.027.16-.096.227-.244.273C5.83 8.386 4.06 8.94 2.3 9.514c-.387.125-.773.289-1.114.506-1.042.665-1.196 1.753-.415 2.71.346.422.79.715 1.284.936 1.1.49 2.202.976 3.3 1.47.019.01.036.013.053.019h-.004l1.306.535c0 .023.002.045 0 .073-.2 2.03-.39 4.063-.58 6.095-.04.419-.012.831.134 1.23.317.87 1.065 1.148 1.881.701.372-.204.666-.497.937-.818 1.372-1.623 2.746-3.244 4.113-4.872.111-.133.205-.15.363-.098.349.117.697.231 1.045.347h.001c.02.012.045.02.073.03l.142.042c1.248.416 2.68.775 3.929 1.19.4.132.622.164 1.045.098.311-.048.592-.062.828-.236.602-.33.995-.957.988-1.682-.005-.427-.154-.813-.35-1.186-.82-1.556-1.637-3.113-2.461-4.666-.078-.148-.076-.243.037-.375 1.381-1.615 2.756-3.236 4.133-4.855.272-.32.513-.658.653-1.058.308-.878-.09-1.57-1-1.741a2.783 2.783 0 00-1.235.069c-1.974.521-3.947 1.041-5.918 1.57-.175.047-.26.015-.355-.144a353.08 353.08 0 00-2.421-4.018 4.61 4.61 0 00-.652-.849c-.371-.37-.802-.549-1.227-.536zm.172 3.703a.592.592 0 01.189.211c.87 1.446 1.742 2.89 2.609 4.338.07.118.135.16.277.121 1.525-.41 3.052-.813 4.579-1.217.367-.098.735-.193 1.103-.289a.399.399 0 01-.1.2c-1.259 1.48-2.516 2.962-3.779 4.438-.11.13-.12.22-.04.37.937 1.803 1.768 3.309 2.498 4.76l-3.696-1.019c-.538-.18-1.077-.358-1.615-.539-.163-.055-.25-.03-.36.1-1.248 1.488-2.504 2.97-3.759 4.454a.398.398 0 01-.18.132c.035-.378.068-.757.104-1.136.149-1.572.297-3.144.451-4.716-.03-.318.117-.405-.322-.545-1.493-.593-3.346-1.321-4.816-1.905a.595.595 0 01.24-.134c1.797-.57 3.595-1.14 5.394-1.705.127-.04.199-.092.211-.233.013-.148.05-.294.076-.441.241-1.363.483-2.726.726-4.088.068-.386.14-.771.21-1.157z",source:"https://apache.org/logos/",hex:"E25A1C",guidelines:void 0,license:void 0},siApacheecharts={title:"Apache ECharts",slug:"apacheecharts",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache ECharts</title><path d="'+this.path+'"/></svg>'},path:"M12 0A12 12 0 0 0 0 12a12 12 0 0 0 12 12 12 12 0 0 0 12-12A12 12 0 0 0 12 0zm-.792 5.307c2.192-.025 4.366 1.134 5.43 3.304.909 1.852.878 3.61-.098 5.645-.477.995-.487 1.06-.241 1.578.214.452.727.779 1.221.779.454 0 1.15-.586 1.252-1.054.1-.454-.193-1.118-.607-1.377a10.11 10.11 0 0 1-.393-.255c-.129-.1.42-.38.741-.38.687 0 1.247.526 1.375 1.29.055.333.134.422.44.502.859.222 1.297 1.451.755 2.116-.22.27-.23.271-.305.042-.267-.801-.666-1.12-1.403-1.12-.319 0-.572.128-1.098.556-1.006.82-1.866 1.303-2.907 1.632-1.276.384-2.752.478-4.086.156-2.162-.431-4.232-2.11-5.252-4.257C4.758 11.782 5.135 9 7.033 7.077a5.924 5.924 0 0 1 4.175-1.77Z",source:"https://apache.org/logos/",hex:"AA344D",guidelines:void 0,license:void 0},siApachetomcat={title:"Apache Tomcat",slug:"apachetomcat",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache Tomcat</title><path d="'+this.path+'"/></svg>'},path:"M12.66 3.494c-.377.637-.544 2.114-.502 3.162l-.005.004c.036.946.165 1.816.372 2.615-3.096.767-6.466 2.795-8.352 4.754-.882-1.19-1.232-2.168-1.336-2.908-.131-.936.092-1.794.646-2.482.867-1.077 2.098-1.153 3.365-.94-.025.2.001.391.081.51.335.494 2.135.668 3.21.189-.793-1.112-2.4-1.654-2.844-1.437a.762.762 0 00-.335.359c-.438-.078-.873-.137-1.19-.134-1.117.008-1.971.398-2.61 1.193-.628.78-.882 1.747-.734 2.8.14.996.633 2.055 1.46 3.154-.138.147-.27.293-.398.436C1.473 17.023 0 19.44 0 19.842v.207h2.658l-.046-.246c-.15-.793.15-1.785.763-2.526.386-.465 1.024-.996 2.027-1.241.891.87 2.027 1.794 3.291 2.685h1.976v-.208a.678.678 0 00-.327-.577c-.312-.204-.794-.232-1.237-.081-.421-.47-.658-1.098-.709-1.877 4.287.38 8.388 2.11 13.015 4.528h2.546l.033-.167c.048-.237-.082-.556-.346-.851-.456-.51-1.349-.752-2.095-.734-.514-.612-3.342-3.591-3.507-3.765a9.626 9.626 0 002.673-2.847h1.388v-.298H20.89a9.81 9.81 0 00.223-.419h.989v-.299h-.845c.628-1.359.975-2.918.942-4.625l.003.002c-.002-.468-.147-2.445-.415-2.989-.726.276-2.047 1.17-2.346 2.084a14.557 14.557 0 00-4.463.056c-.237-.984-1.423-1.736-2.318-2.16zm.164.577c.211 1.148.593 1.869 1.42 2.223.734-.21 1.58-.34 2.448-.388l.717 1.571.46-1.585c.876.029 1.736.142 2.485.349.762-.554 1.057-1.4 1.218-2.138.202.86.178 2.717.18 2.717a9.883 9.883 0 01-.158 1.988l-.824.35.726.11a9.19 9.19 0 01-.198.714l-.703.205.56.201c-.094.253-.2.5-.314.738h-1.16v.299h1.008a8.788 8.788 0 01-.238.419h-.77v.298h.583a8.634 8.634 0 01-2.921 2.748c-1.334-.664-2.341-1.634-3.079-2.748h.446v-.298h-.636a9.195 9.195 0 01-.236-.419h.872v-.299h-1.026a10.12 10.12 0 01-.46-1.094l.522-.147-.659-.263c-.066-.215-.127-.43-.18-.646l1.015-.069-1.16-.615c-.282-1.563-.225-3.08.062-4.221zm2.946 2.97c-.89 0-1.24.909-1.255.948l.252.094c.012-.033.302-.773 1.003-.773.154 0 .262.062.34.195.182.314.152.933 0 1.58h-1.227v.269h1.159a5.679 5.679 0 01-.496 1.225l-.064.112 1.537.967-.865.57.148.224.967-.637 1.043.681.143-.228-.967-.598 1.518-.986v-.001c-.318-.47-.42-.872-.286-1.329h.108l1.167-.001.002-.268h-1.175c.216-.51.52-.968 1.602-.968v-.27c-.999 0-1.596.397-1.883 1.238h-2.154c.15-.672.177-1.333-.046-1.715a.63.63 0 00-.57-.33zm.55 2.313h2.126c-.095.304-.057.763.178 1.157h-2.737c.166-.334.32-.74.433-1.157zm-3.683.321c.155.515.344.997.562 1.451h-.91v.299h1.06c.075.142.153.282.233.419H12.29v.298h1.478c.91 1.416 2.14 2.499 3.534 3.318a9.45 9.45 0 00.456-.28l.362.39-.61.938 1.04-.474.606.652-1.019.776 1.403-.363 1.905 2.05.16-.014c1.007-.086 1.58.46 1.73.63.112.124.179.237.215.326h-2.036c-4.67-2.437-8.771-4.155-13.127-4.53.01-.607.117-1.293.324-2.058l-.4-.108c-.213.786-.325 1.497-.338 2.134-.454-.03-.91-.046-1.371-.046-.391 0-.747.036-1.072.1a14.771 14.771 0 01-1.09-1.21c.546-.57 1.19-1.123 1.893-1.643l.967.668-.316-1.128c.297-.2.603-.394.914-.58l1.434.73-.673-1.162c.198-.106.398-.21.598-.31l2.007 1.346-.66-1.952a15.32 15.32 0 012.034-.667zm3.492 1.105h2.22l-1.084.715zM4.153 14.675c.273.337.577.678.91 1.021a4.104 4.104 0 00-2.007 1.316c-.629.76-.962 1.762-.886 2.622H.495c.337-.728 1.677-2.833 3.658-4.959z",source:"https://apache.org/logos/",hex:"F8DC75",guidelines:void 0,license:void 0},siAirplayvideo={title:"AirPlay Video",slug:"airplayvideo",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AirPlay Video</title><path d="'+this.path+'"/></svg>'},path:"M3.412 1.32c-1.178 0-1.584.122-2.031.366A2.449 2.449 0 00.365 2.7C.122 3.148 0 3.553 0 4.771v9.137c0 1.178.122 1.585.365 2.031.244.447.57.772 1.016 1.016.406.244.813.365 2.031.365h2.72l1.138-1.34H3.006c-.325.041-.69-.001-1.016-.164-.203-.08-.366-.283-.488-.486-.122-.325-.203-.65-.162-1.016V4.406c-.04-.325 0-.69.162-1.015.081-.203.285-.365.488-.487.325-.122.65-.204 1.016-.164h17.867c.325-.04.69.002 1.016.164.203.082.364.284.486.487.122.324.203.65.162 1.015v9.95c.04.324 0 .69-.162 1.015-.081.203-.283.365-.486.486-.325.122-.65.203-1.016.163h-4.264l1.137 1.341 2.803-.04c1.218 0 1.623-.122 2.07-.366a2.449 2.449 0 001.016-1.016c.243-.406.365-.813.365-2.03V4.77c0-1.218-.122-1.623-.365-2.07a2.449 2.449 0 00-1.016-1.015c-.447-.244-.852-.366-2.07-.366H3.412zm8.451 12.198a.501.501 0 00-.37.187l-7.106 8.162a.465.465 0 00-.123.326.47.47 0 00.488.487h14.293c.122 0 .245-.04.326-.121.203-.163.204-.489.041-.692l-7.107-8.162-.041-.04a.594.594 0 00-.4-.147z",source:"https://developer.apple.com/design/human-interface-guidelines/airplay/overview/icons/",hex:"000000",guidelines:void 0,license:void 0},siAmazonprime={title:"Amazon Prime",slug:"amazonprime",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Amazon Prime</title><path d="'+this.path+'"/></svg>'},path:"M1.8054 12.403c-.0699-.096-.144-.1746-.144-.3538v-.5945c0-.2523.0179-.484-.168-.6576-.1466-.1408-.3892-.1903-.5752-.1903-.3635 0-.7688.136-.8542.5849-.0087.0476.0258.0728.0573.08l.3703.0398c.0345-.0014.0597-.0358.066-.0703.032-.1544.1616-.2292.3073-.2292.0786 0 .1679.0292.214.099.0538.0787.0466.1864.0466.2772v.0495c-.2214.0248-.511.0413-.7183.1325-.2393.1034-.4072.314-.4072.6242 0 .3965.2504.595.5717.595.2718 0 .4198-.064.6295-.2776.0694.1005.0922.1495.219.2548.0285.015.0649.0136.0902-.0092l.294-.2524c.0312-.0257.0253-.067.001-.102m-.68-.5765c0 .149.0035.2728-.0713.4053-.0606.1072-.1572.1732-.2645.1732-.1465 0-.232-.1116-.232-.2766 0-.3257.2917-.3844.5679-.3844zm5.6864.5766c-.0694-.0961-.1441-.1747-.1441-.3539v-.5945c0-.2523.018-.484-.168-.6576-.1465-.1408-.3892-.1903-.5751-.1903-.3636 0-.7688.136-.8537.5849-.0093.0476.0257.0728.0568.08l.3703.0398c.0344-.0014.0596-.0358.066-.0703.032-.1544.1616-.2292.3072-.2292.0786 0 .168.0292.214.099.0539.0787.0466.1864.0466.2772v.0495c-.2213.0248-.511.0413-.7178.1325-.2397.1034-.4076.314-.4076.6242 0 .3965.2504.595.5717.595.2717 0 .4202-.064.63-.2776.0689.1005.0916.1495.2188.2548a.0788.0788 0 0 0 .0898-.0092l.001.001c.0767-.068.215-.1883.293-.2534.0312-.0257.0259-.067.0011-.102m-.7513-.1712c-.0607.1072-.1572.1732-.2646.1732-.1465 0-.232-.1116-.232-.2766 0-.3257.2918-.3844.568-.3844v.0825c0 .149.0038.2728-.0714.4053m5.16.5307h-.3806a.0717.0717 0 0 1-.0684-.0704l-.0007-1.9608c.0032-.0359.0349-.064.0734-.064h.3542a.0725.0725 0 0 1 .0678.0547v.2999h.0073c.107-.2682.2566-.396.5204-.396.1711 0 .3387.0618.4457.231.0998.1567.0998.4206.0998.6104v1.2335c-.0043.0347-.0355.0617-.0732.0617h-.3829a.072.072 0 0 1-.068-.0617v-1.0643c0-.2145.025-.528-.2388-.528-.0927 0-.1782.0619-.221.1567-.0535.1197-.0607.2393-.0607.3713v1.0554a.073.073 0 0 1-.0743.0706M9.612 10.6259c.5668 0 .8733.4868.8733 1.1055 0 .598-.3385 1.0724-.8733 1.0724-.5561 0-.8592-.4868-.8592-1.0931 0-.6104.3066-1.0848.8592-1.0848m.0035.4002c-.2817 0-.2994.3835-.2994.6227 0 .2392-.0036.7507.296.7507.2958 0 .31-.4125.31-.664 0-.1649-.0071-.363-.057-.5197-.0428-.1362-.1285-.1897-.2496-.1897m-7.062 1.7364h-.3819a.0719.0719 0 0 1-.0683-.0646l.0003-1.96c0-.0393.033-.0706.0738-.0706h.3556c.0372.0017.067.03.0694.0657v.256h.0071c.0927-.2476.2674-.363.5027-.363.2388 0 .3886.1154.4954.363.0928-.2476.3031-.363.5277-.363.1605 0 .3351.066.4421.2144.1212.165.0963.4042.0963.6146l-.0004 1.237c0 .039-.033.0705-.0737.0705h-.3813a.0715.0715 0 0 1-.0686-.0704v-1.0392c0-.0824.007-.2886-.0109-.367-.0284-.132-.114-.1692-.2244-.1692-.0928 0-.189.062-.2283.1608-.0392.0991-.0356.264-.0356.3754v1.039c0 .0392-.033.0706-.0737.0706h-.3815a.0716.0716 0 0 1-.0685-.0704l-.0004-1.0392c0-.2185.0356-.5402-.2352-.5402-.2745 0-.2638.3134-.2638.5402l-.0002 1.039c0 .0392-.033.0706-.0737.0706m4.5791-1.7494v-.28a.0692.0692 0 0 1 .071-.071h1.2553c.0402 0 .0724.0291.0724.0706v.2402c-.0003.0403-.0343.0929-.0945.1763l-.6502.9284c.2413-.0056.4967.0306.716.1538.0494.0278.0627.069.0666.1093v.2989c0 .0411-.0451.0888-.0925.064-.3863-.2024-.8991-.2245-1.3263.0025-.0437.0232-.0894-.0238-.0894-.065v-.284c0-.0455.0009-.1233.0467-.1926l.7534-1.0808h-.656c-.04 0-.0722-.0286-.0725-.0706m.8171 2.1613c-.0917-.1174-.606-.0556-.8372-.028-.07.0084-.0809-.0527-.0179-.097.4105-.2882 1.0829-.205 1.1611-.1085.0787.0973-.0207.7715-.4052 1.0933-.0592.0494-.1155.023-.0892-.0423.0865-.2161.2802-.7.1884-.8175m-.2983.3406c-.717.529-1.7563.8105-2.6514.8105-1.2543 0-2.384-.4638-3.2388-1.2355-.067-.0607-.0072-.1434.0735-.0965.9222.5366 2.0628.8598 3.2406.8598.7947 0 1.6681-.1649 2.4719-.5058.1211-.0514.2228.0799.1042.1675m15.5297-.693c-.342 0-.6045-.0938-.7879-.2813-.1835-.1875-.275-.4563-.275-.8065 0-.3584.0935-.6397.2811-.8437.1875-.204.4481-.3061.7817-.3061.2565 0 .4571.062.6019.1861.1447.1241.2171.2895.2171.4963 0 .2068-.078.3634-.2337.4694-.1558.1063-.3853.1593-.6887.1593-.157 0-.2936-.0151-.4094-.0455.0165.1847.0724.3171.1675.397.0952.08.2392.12.4323.12.0771 0 .1522-.0048.2253-.0145.073-.0096.1744-.031.304-.064a.163.163 0 0 1 .0455-.0084c.0468 0 .0703.0318.0703.0952v.1902c0 .0441-.0062.0752-.0185.093-.0125.018-.0366.0339-.0725.0476-.2013.0772-.415.1158-.641.1158m-.1365-1.2986c.1406 0 .2426-.0214.306-.0641.0634-.0428.0952-.1083.0952-.1965 0-.1738-.1034-.2606-.3102-.2606-.2647 0-.4177.1628-.4591.488.1103.0221.233.0332.3681.0332M18.6275 12.76c-.0359 0-.0622-.0082-.0786-.0248-.0166-.0165-.0248-.0427-.0248-.0786V10.75c0-.0387.0082-.0655.0248-.0807.0164-.0151.0427-.0227.0786-.0227h.2977c.0634 0 .102.0303.1159.091l.033.1116c.1461-.0965.2778-.1647.395-.2047.1171-.04.2378-.06.362-.06.248 0 .4231.0882.5251.2647.1407-.0937.273-.1613.3972-.2026.124-.0414.2522-.062.3846-.062.193 0 .3425.0536.4487.1612.1061.1076.1593.258.1593.4508v1.46c0 .0359-.0077.062-.0228.0786-.0152.0166-.042.0248-.0807.0248h-.397c-.0359 0-.062-.0082-.0785-.0248-.0166-.0165-.025-.0427-.025-.0786V11.329c0-.1875-.084-.2813-.2522-.2813-.1489 0-.2992.0359-.4508.1075v1.5014c0 .0359-.0076.062-.0228.0786-.0152.0166-.042.0248-.0806.0248h-.397c-.036 0-.0621-.0082-.0787-.0248-.0165-.0165-.0248-.0427-.0248-.0786V11.329c0-.1875-.0842-.2813-.2523-.2813-.1544 0-.306.0373-.4549.1116v1.4973c0 .0359-.0077.062-.0227.0786-.0153.0166-.0422.0248-.0807.0248zm-.9174-2.4402c-.1048 0-.1888-.029-.2522-.0869-.0635-.0578-.0952-.1364-.0952-.2357s.0317-.1778.0952-.2357c.0634-.058.1474-.0869.2523-.0869.1046 0 .1888.029.2522.0869.0634.0579.0952.1364.0952.2357s-.0318.1779-.0952.2357c-.0634.058-.1476.087-.2523.087m-.1985 2.4401c-.0358 0-.062-.0083-.0786-.0249-.0166-.0164-.0248-.0426-.0248-.0785V10.75c0-.0386.0082-.0655.0248-.0807.0165-.0151.0428-.0227.0786-.0227h.397c.0386 0 .0655.0076.0807.0227.0151.0152.0228.042.0228.0807v1.9066c0 .036-.0077.062-.0228.0785-.0152.0166-.042.025-.0807.025zm-1.6527 0c-.0359 0-.0622-.0082-.0786-.0248-.0166-.0165-.0248-.0427-.0248-.0786V10.75c0-.0387.0082-.0655.0248-.0807.0164-.0151.0427-.0227.0786-.0227h.2977c.0634 0 .102.0303.1158.091l.0538.2233c.1103-.1214.2144-.2075.3123-.2585a.6664.6664 0 0 1 .3123-.0765h.0578c.0386 0 .0662.0076.0827.0227.0166.0152.0248.042.0248.0807v.3474c0 .0358-.0076.062-.0227.0785-.0151.0166-.042.025-.0807.025a.8293.8293 0 0 1-.0744-.0043 1.3657 1.3657 0 0 0-.1158-.0041c-.0634 0-.1406.009-.2316.0269-.091.018-.1682.0407-.2316.0683v1.3896c0 .0359-.0077.062-.0227.0786-.0153.0166-.0422.0248-.0807.0248zm-2.477.852c-.0358 0-.062-.0077-.0786-.0227-.0165-.0153-.0248-.042-.0248-.0807V10.75c0-.0386.0083-.0655.0248-.0807.0166-.0151.0428-.0227.0786-.0227h.2978c.0634 0 .102.0304.1157.091l.029.1075c.0828-.08.1827-.1433.2999-.1903a.9562.9562 0 0 1 .3578-.0703c.2673 0 .479.098.6348.2937.1558.1958.2337.4605.2337.794 0 .229-.0386.4288-.1157.5997-.0772.171-.1821.3027-.3144.395-.1324.0925-.284.1386-.4549.1386a.965.965 0 0 1-.3226-.0538c-.1021-.0358-.189-.0854-.2606-.1489v.9058c0 .0386-.0076.0654-.0227.0807-.0153.015-.0421.0227-.0807.0227zm.9057-1.2615c.1545 0 .2682-.0523.3413-.157.073-.1048.1097-.2703.1097-.4964 0-.2288-.036-.3956-.1076-.5005-.0718-.1048-.1862-.1571-.3434-.1571a.7883.7883 0 0 0-.4052.1116v1.0878c.1212.0744.2564.1116.4052.1116Z",source:"https://www.amazon.com/b?node=17277626011",hex:"00A8E1",guidelines:void 0,license:void 0},siAmd={title:"AMD",slug:"amd",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AMD</title><path d="'+this.path+'"/></svg>'},path:"M18.324 9.137l1.559 1.56h2.556v2.557L24 14.814V9.137zM2 9.52l-2 4.96h1.309l.37-.982H3.9l.408.982h1.338L3.432 9.52zm4.209 0v4.955h1.238v-3.092l1.338 1.562h.188l1.338-1.556v3.091h1.238V9.52H10.47l-1.592 1.845L7.287 9.52zm6.283 0v4.96h2.057c1.979 0 2.88-1.046 2.88-2.472 0-1.36-.937-2.488-2.747-2.488zm1.237.91h.792c1.17 0 1.63.711 1.63 1.57 0 .728-.372 1.572-1.616 1.572h-.806zm-10.985.273l.791 1.932H2.008zm17.137.307l-1.604 1.603v2.25h2.246l1.604-1.607h-2.246z",source:"https://www.amd.com/",hex:"ED1C24",guidelines:void 0,license:void 0},siAmazonlumberyard={title:"Amazon Lumberyard",slug:"amazonlumberyard",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Amazon Lumberyard</title><path d="'+this.path+'"/></svg>'},path:"M13.136 4.01a2.25 2.25 0 0 0-.441.042 2.133 2.133 0 0 0-1.74 2.195c-.07.056-.139.115-.2.178l-.21.219c-.137.14-.276.278-.417.416-.282.274-.574.541-.867.812-.584.54-1.186 1.088-1.725 1.715a7.3 7.3 0 0 0-.73 1.014 4.9 4.9 0 0 0-.65 1.791 3.73 3.73 0 0 0-.04.324l-.008.08-.004.074-.005.15-.002.038-.002.049v.078l.002.16.006.152c-.884-.293-2.123-.481-3.184-.468-1.235.013-2.132.273-2.588.75a1.14 1.14 0 0 0-.33.842c.034.95 1.117 1.511 2.912 1.511h.1c1.257-.015 2.762-.348 3.613-.767a2.055 2.055 0 0 1 .07 1.09 1.662 1.662 0 0 1-.175.465 1.436 1.436 0 0 1-.31.373 1.45 1.45 0 0 1-.419.24 1.82 1.82 0 0 1-.5.1l.047.634h.012c1.306.771 1.579 1.622 1.74 1.702.215.105 1.023-.188.877-.854-.086-.392-.545-.675-.975-.861.08-.008.16-.02.238-.032a.532.532 0 0 0 .051-.002l.05-.01.05-.011a5.4 5.4 0 0 0 .234-.043l.004-.002c1.225-.252 2.32-.713 3.202-1.317.906.575 1.89 1.398 2.22 2.15-.03.129-.138.261-.261.274l.334.618c1.054-.532 1.809-.238 2.326.002l.178.091c.027.015.003 0 .027.016l.088-.031c.15-.095.535-.454.44-.82-.12-.453-.415-.626-.7-.575-.286.052-1.01.506-.955.07l-.004-.003c.042-.33.088-.922.004-1.592-.16-1.247-.709-2.214-1.594-2.817a3.51 3.51 0 0 0 .139-.62c.614.216 1.207.389 1.973.458.276.025.902.03 1.373.025l.064.237a.01.01 0 0 0 .014.006l.256-.092a.514.514 0 0 1 .07-.024c.022-.006.034-.006.035.012-.004.05-.017.12-.023.147l-.057.287-.031.166c-.006.062.031.096.107.066.066-.03.153-.071.157-.074.438-.182.913-.443 1.351-.629.21-.088.31-.3.352-.504a1.25 1.25 0 0 0-.008-.404l.691.058.004-.006.207-.552.588.058.207-.552.586.058.207-.553.586.06.207-.552.588.059.205-.553.588.059.205-.553.346.035.086-.506.002-.02-.299-1.414-8.383 3.315a.03.03 0 0 0-.01.047l.381.383c.007.008.017.01.03.008l.17-.057a.104.104 0 0 1 .13.057l.096.234s.01.03-.041.03l-.051-.003a7.035 7.035 0 0 1-.205-.011 3.435 3.435 0 0 1-.375-.053c-.062-.01-.123-.03-.184-.043-.06-.015-.122-.034-.183-.051l-.18-.064-.176-.075a4.493 4.493 0 0 1-.346-.173c-.057-.032-.113-.063-.17-.1a11.316 11.316 0 0 1-.503-.332c-.111-.078-.224-.16-.336-.24l-.022-.018c.126-1.483.522-2.098.834-2.352a.812.812 0 0 1 .356-.175 1.832 1.832 0 0 0-.022.38l.434.034.031-.11c.008-.036.021-.07.031-.105.01-.036.025-.07.037-.104.011-.034.03-.066.041-.1.013-.033.032-.064.047-.099.015-.03.035-.065.051-.098.037-.065.075-.134.117-.2l.13-.216c.042-.075.086-.15.126-.232.02-.042.04-.083.059-.127.019-.044.037-.085.054-.135l.024-.07.014-.035.01-.031.015-.06.01-.03.002-.006.008-.026.005-.03.004-.028v-.04c0-.015 0-.02-.006-.05a.234.234 0 0 0-.007-.03l-.01-.027a1.465 1.465 0 0 0-.4-.607 2.21 2.21 0 0 0-.214-.174l.15.006c.146.005.267.008.352.008.085.002.133 0 .133 0l.053-.528s-.05-.01-.135-.023a7.918 7.918 0 0 0-.353-.053l-.06-.008.048-.01a2.26 2.26 0 0 0-2.174-1.753zm.102.643a1.62 1.62 0 0 1 1.394 1.059l-.385-.027a20.737 20.737 0 0 0-.578-.03 19.922 19.922 0 0 0-.508-.01l-.207.002c-.062 0-.108.003-.152.004l-.135.006v.002c-.026 0-.052 0-.078.002a3.112 3.112 0 0 0-.974.217 1.48 1.48 0 0 1 .607-.95c.014-.002.029-.003.047-.01.025-.003.054-.005.086-.01.03 0 .063-.007.1-.005h.113c.039.006.079.009.119.014.04.01.084.012.125.023.04.012.082.022.121.04a1 1 0 0 1 .115.046c.038.016.07.038.104.055.03.02.064.039.09.059a1.14 1.14 0 0 1 .15.125.034.034 0 0 1 .01.011l.256-.177-.01-.022a1.49 1.49 0 0 0-.164-.207c-.03-.033-.063-.063-.098-.098-.037-.03-.073-.066-.117-.097zm-.483 1.645h.067l.074.002c.176.008.365.03.545.064.363.07.721.186 1.037.354.156.084.303.182.42.293a.92.92 0 0 1 .209.28l-.002.013-.01.031-.008.022-.015.046c-.01.03-.027.066-.041.1-.012.033-.028.067-.043.102-.014.034-.034.068-.051.103l-.05.106a6.728 6.728 0 0 0-.114.224l-.026.051c-.103-.012-.506-.038-.94.297-.554.43-.91 1.25-1.06 2.447-.025-.017-.046-.036-.07-.05a10.35 10.35 0 0 0-.363-.231l-.186-.111-.191-.104a6.063 6.063 0 0 0-.795-.35 2.93 2.93 0 0 0-.207-.064 3.504 3.504 0 0 0-.211-.06c-.07-.018-.142-.04-.21-.051l-.206-.041-.086.318c.133.047.268.09.389.14.06.023.123.05.185.077a5.567 5.567 0 0 1 .541.268 6.7 6.7 0 0 1 .348.203l.17.111.166.113.164.12.164.122c.109.082.216.166.324.252l.324.26c.22.174.445.35.686.516.059.04.12.08.182.119a4.624 4.624 0 0 0 .586.326c.068.032.139.06.209.09.07.027.142.05.214.076.074.022.147.046.221.065.075.017.148.035.223.049.15.026.303.045.455.056.075.003.15.008.227.008l.093-.002a.573.573 0 0 0 .248-.063l.055-.027s.052-.03.1-.07a.931.931 0 0 1 .13-.112.499.499 0 0 1 .178-.08.29.29 0 0 1 .155.008c.013.006.025.007.039.014a.374.374 0 0 1 .039.021l.006.002a.9.9 0 0 1 .007.073.91.91 0 0 1-.005.181.72.72 0 0 1-.295.5l-.002.002a1.575 1.575 0 0 1-.075.051c-.026.018-.054.029-.082.045-.028.016-.06.028-.09.041l-.078.031a3.68 3.68 0 0 1-.037-.228 17.834 17.834 0 0 1-1.29-.024c-.887-.08-1.516-.31-2.31-.6a22.853 22.853 0 0 0-1.806-.595.897.897 0 0 0-1.116.588c-.085.276-.086.628-.005 1.049.248 1.282.255 2.291.017 2.771a8.57 8.57 0 0 1-2.398.86h-.004l-.092.02-.131.023a4.35 4.35 0 0 1-.438.052 2.11 2.11 0 0 0 .26-.35c.116-.202.2-.423.25-.648a2.697 2.697 0 0 0-.11-1.502c-.016-.053-.04-.105-.06-.156-.02-.052-.048-.102-.072-.152l-.062-.135a2.802 2.802 0 0 1-.172-.502 3.593 3.593 0 0 1-.088-.54 4.33 4.33 0 0 1-.018-.278l-.002-.14v-.097l.004-.037.01-.15.004-.075.006-.066c.009-.09.018-.18.035-.271a4.253 4.253 0 0 1 .562-1.563c.191-.323.417-.63.666-.922.501-.585 1.084-1.12 1.67-1.66.293-.272.586-.546.877-.828.144-.14.291-.283.432-.43l.031-.035.034.04c.052.059.106.131.19.2.073.073.168.144.274.211a2.118 2.118 0 0 0 .563.248 3.54 3.54 0 0 0 .65.117 4.714 4.714 0 0 0 .723 0l-.004-.277a4.425 4.425 0 0 1-.67-.09 3.146 3.146 0 0 1-.55-.18 1.47 1.47 0 0 1-.151-.076 1.583 1.583 0 0 1-.252-.17 1.201 1.201 0 0 1-.172-.174c-.049-.052-.077-.107-.107-.148-.026-.043-.04-.08-.055-.104 0-.003-.003-.004-.004-.007l.05-.032.058-.029a2.491 2.491 0 0 1 .748-.254 2.54 2.54 0 0 1 .394-.031zm.52.484c-.217.009-.388.13-.38.27.009.14.193.248.411.24.22-.008.389-.13.379-.27-.007-.139-.19-.246-.408-.24zM23.26 9.24l.052.286a.09.09 0 0 1-.105.113c-.032-.006-.063.005-.074.035l-.192.512-.588-.059-.205.553-.588-.06-.205.554-.588-.06-.205.554-.588-.06-.207.553-.586-.06-.183.49a.092.092 0 0 1-.096.058l-.047-.004c-.036-.004-.254-.024-.265-.059l-.542-1.265zm-6.018 2.495c.184-.013.305.077.388.24.013.01.487 1.213.479 1.195a.37.37 0 0 1-.05.436c-.083.095-.28.16-.401.21-.065.029-.066-.013-.09-.081l-.053-.153.024-.042a1.43 1.43 0 0 0 .138-.45 1.525 1.525 0 0 0-.007-.457l-.016-.076-.01-.039-.012-.049v-.002a.301.301 0 0 0-.101-.148 1.29 1.29 0 0 0-.276-.172.716.716 0 0 0-.109-.041c-.039-.011-.077-.024-.117-.03a.869.869 0 0 0-.117-.011l-.02-.002c-.016-.007-.046-.061-.033-.086a.45.45 0 0 1 .383-.242zm-6.544 1.097a.254.254 0 0 1 .002 0 .304.304 0 0 1 .108.01c.635.176 1.15.359 1.604.524-.075 1.032-.725 2.01-1.756 2.773.089-.747-.028-1.661-.17-2.392-.076-.397-.047-.624-.01-.745a.254.254 0 0 1 .222-.17zm-7.771.87c1.119-.014 2.494.224 3.283.556l.01.045a3.542 3.542 0 0 0 .138.446c-.679.348-2.09.697-3.353.71-1.147.012-2.31-.25-2.332-.86a.47.47 0 0 1 .146-.354c.318-.334 1.089-.532 2.108-.543zm9.75 1.123c1.514 1.142 1.263 3.371 1.188 3.855l-.215.045c-.43-.977-1.59-1.862-2.266-2.314.558-.474 1-1.01 1.293-1.586z",source:"https://aws.amazon.com/lumberyard/support",hex:"66459B",guidelines:void 0,license:void 0},siAmazons3={title:"Amazon S3",slug:"amazons3",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Amazon S3</title><path d="'+this.path+'"/></svg>'},path:"M20.913 13.147l.12-.895c.947.576 1.258.922 1.354 1.071-.16.031-.562.046-1.474-.176zm-2.174 7.988a.547.547 0 0 0-.005.073c0 .084-.207.405-1.124.768a10.28 10.28 0 0 1-1.438.432c-1.405.325-3.128.504-4.853.504-4.612 0-7.412-1.184-7.412-1.704a.547.547 0 0 0-.005-.073L1.81 5.602c.135.078.28.154.432.227.042.02.086.038.128.057.134.062.272.122.417.18l.179.069c.154.058.314.114.478.168.043.013.084.029.13.043.207.065.423.127.646.187l.176.044c.175.044.353.087.534.127a23.414 23.414 0 0 0 .843.17l.121.023c.252.045.508.085.768.122.071.011.144.02.216.03.2.027.4.053.604.077l.24.027c.245.026.49.05.74.07l.081.009c.275.022.552.04.83.056l.233.012c.21.01.422.018.633.025a33.088 33.088 0 0 0 2.795-.026l.232-.011c.278-.016.555-.034.83-.056l.08-.008c.25-.02.497-.045.742-.072l.238-.026c.205-.024.408-.05.609-.077.07-.01.141-.019.211-.03.261-.037.519-.078.772-.122l.111-.02c.215-.04.427-.082.634-.125l.212-.047c.186-.041.368-.085.546-.13l.166-.042c.225-.06.444-.122.654-.189.04-.012.077-.026.115-.038a10.6 10.6 0 0 0 .493-.173c.058-.021.114-.044.17-.066.15-.06.293-.12.43-.185.038-.017.079-.034.116-.052.153-.073.3-.15.436-.228l-.976 7.245c-2.488-.78-5.805-2.292-7.311-3a1.09 1.09 0 0 0-1.088-1.085c-.6 0-1.088.489-1.088 1.088 0 .6.488 1.089 1.088 1.089.196 0 .378-.056.537-.148 1.72.812 5.144 2.367 7.715 3.15zm-7.42-20.047c5.677 0 9.676 1.759 9.75 2.736l-.014.113c-.01.033-.031.067-.048.101-.015.028-.026.057-.047.087-.024.033-.058.068-.09.102-.028.03-.051.06-.084.09-.038.035-.087.07-.133.105-.04.03-.074.06-.119.091-.053.036-.116.071-.177.107-.05.03-.095.06-.15.09-.068.036-.147.073-.222.11-.059.028-.114.057-.177.085-.084.038-.177.074-.268.111-.068.027-.13.054-.203.082-.097.036-.205.072-.31.107-.075.026-.148.053-.228.079-.111.035-.233.069-.35.103-.085.024-.165.05-.253.073-.124.034-.258.065-.389.098-.093.022-.181.046-.278.068-.139.032-.287.061-.433.091-.098.02-.191.041-.293.06-.155.03-.32.057-.482.084-.1.018-.198.036-.302.052-.166.026-.342.048-.515.072-.11.014-.213.03-.325.044-.181.023-.372.041-.56.06-.11.012-.218.025-.332.036-.188.016-.386.029-.58.043-.122.009-.24.02-.364.028-.207.012-.422.02-.635.028-.12.005-.234.012-.354.016a35.605 35.605 0 0 1-2.069 0c-.12-.004-.234-.011-.352-.016-.214-.008-.43-.016-.637-.028-.122-.008-.238-.02-.36-.027-.195-.015-.394-.028-.584-.044-.11-.01-.215-.024-.324-.035-.19-.02-.384-.038-.568-.06l-.315-.044c-.176-.024-.355-.046-.525-.073-.1-.015-.192-.033-.29-.05-.167-.028-.335-.055-.494-.086-.096-.018-.183-.038-.276-.056-.151-.032-.305-.062-.45-.095-.09-.02-.173-.043-.26-.064-.138-.034-.277-.067-.407-.102-.082-.022-.157-.046-.235-.069a11.75 11.75 0 0 1-.368-.108c-.075-.024-.141-.049-.213-.073-.11-.037-.223-.075-.325-.113-.067-.025-.125-.051-.188-.077-.096-.038-.195-.076-.282-.115-.06-.027-.11-.054-.166-.08-.08-.039-.162-.077-.233-.116-.052-.028-.094-.055-.142-.084-.063-.038-.13-.075-.185-.113-.043-.029-.075-.058-.113-.086-.048-.037-.098-.073-.139-.11-.032-.029-.054-.057-.08-.087-.033-.035-.069-.07-.093-.104-.02-.03-.031-.058-.046-.086-.018-.035-.039-.068-.049-.102l-.015-.113c.076-.977 4.074-2.736 9.748-2.736zm12.182 12.124c-.118-.628-.84-1.291-2.31-2.128l.963-7.16a.531.531 0 0 0 .005-.073C22.16 1.581 16.447 0 11.32 0 6.194 0 .482 1.581.482 3.851a.58.58 0 0 0 .005.072L2.819 21.25c.071 2.002 5.236 2.75 8.5 2.75 1.805 0 3.615-.188 5.098-.531.598-.138 1.133-.3 1.592-.48 1.18-.467 1.789-1.053 1.813-1.739l.945-7.018c.557.131 1.016.197 1.389.197.54 0 .902-.137 1.134-.413a.956.956 0 0 0 .21-.804Z",source:"https://aws.amazon.com/architecture/icons/",hex:"569A31",guidelines:void 0,license:void 0},siApachehive={title:"Apache Hive",slug:"apachehive",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apache Hive</title><path d="'+this.path+'"/></svg>'},path:"M5.902.258c-.331.216-.65.525-.994.877-.569.589-.947 1.164-1.526 1.59-.116.1-.441.26-.85.284-.192.01-.318.042-.672-.003-.312-.169-.608-.059-.897.287-.317.456-.72 1.322-.886 1.868-.345 1.39.533 2.536 1.375 3.42.749.73 1.18 1.188 1.488 1.859.233.435.405 1.032.592 1.45.067.133.053.132.235.172.39.084.934.084 1.417.126.209.003.496-.005.768-.033.375-.071.815-.14 1.185-.268.36-.09.682-.212.971-.325-.037.126-.313.249-.416.41-.962 1.376-1.24 2.605-1.09 4.51l-.008-.007.011.05.006.077c.097.874.298 1.6.6 2.43a6.8 6.8 0 0 0 .717 1.38c.072.101.152.205.238.31h-.002l.005.004c.93 1.13 2.706 2.45 5.098 2.986.457.062.975.029 1.463-.1 1.292-.392 3.925-1.319 3.925-1.319s-2.337.194-3.408.088c-.248-.039-.52-.052-.693-.221-.03-.037-.135-.25-.067-.251.093-.003.36-.113.77-.15-.877-.094-.865-.093-.929-.253a9.968 9.968 0 0 0-.409-.884c.386.033 1.24.08 1.529-.218 0 0-.505.058-.951.006a2.76 2.76 0 0 1-.484-.137c-.2-.079-.365-.103-.404-.154-.07-.177-.116-.236-.2-.473-.114-.315-.123-.665-.145-.986.292.36.664.663 1.157.818.006-.013.638.275 1.098.127l.088-.029c-.045.009-.307.02-.409-.03-.934-.398-1.075-.745-1.226-.918l-.403-.604c.123-.245.192-.254.355-.256.491.054.705.096 1.004.024.203.416.257.835.718 1.137 1.533.456 1.866-.135 2.237-.656 1.104.81 2.9 1.059 4.147.014 1.586-1.835 2.088-4.728 1.947-4.893-.198-.336-.457-.683-.68-.635-.796.217-1.09.62-1.877.529.094-.006.252-.008.253-.017.06-.667-.005-.99-.034-1.046-.24-.527-.554-1.082-.772-1.498-.057-.086-.223-.742-.5-1-.12-.102-.41-.37-.41-.37l-.026.285s.114.017.158.193c.079.322.313.854.542 1.33h-.37l.424.11c.228.465.437.852.467.888.193.312.148.673.155.98l-.11.055c-.017-.361-.405-.335-.732-.338l-.268-.066c.082.076.334.07.232.233-.086.046-.125.242-.174.407l-.145.007c.256.1.494.188.776.306l.142.021-.142.357-.193-.078-.007-.135c-.34-.136-.995-.193-1.019-.165-.242.237-.418.524-.609.8.262-.204.46-.512.813-.597.028-.003.378.065.568.098-.122.025-.32.034-.35.077-.269.332-.466.736-.697 1.105.319-.329.416-.666.957-.985.045-.03.375-.023.536.058-.051.183-.167.401-.26.607-.133.313-.386.601-.58.902.608-.74.435-.469.841-.946.17-.404.34-.84.497-1.271l.03-.016c.054.033.47-.008.795.012.559-.12.535-.367 1.018-.404.325-.025.358.586.353.634a7.248 7.248 0 0 1-.58 2.174c-.652 1.258-1.383 2.388-2.42 2.545-1.265.221-1.922-.332-2.608-.684l-.262.224c-.891.887-1.949.808-2.382-.351l-.003-.006a2.839 2.839 0 0 0-.092-.175c-.127-.246-.25-.495-.402-.724-1.338-1.058-.72-2.022-.364-2.632-.744-.188-1.73-.588-1.866-1.113-.219-1.7-.108-2.24.11-3.113-.996.21-2.006.419-3.077.776l-.001-.008c-.286.064-1.246.416-1.518.563-.617.179-1.13.366-1.917.563a2.934 2.934 0 0 1-.753-.002c-.566-.077-1.531-.008-1.593-.065-.383-.535-.488-1.493-.838-2.006l-.004-.005-.005-.004c-.203-.275-.441-.498-.675-.73C1.49 8.213.773 7.407.572 6.554c-.05-.252-.18-.513-.112-1.258l.002-.004.001-.003c.202-.697.53-1.265 1.087-1.834.58.01 1.153.022 1.6.108.205.034.631.09 1.071.254 1.115.415 2.587 1.097 2.587 1.097-1.105-.607-2.34-1.395-3.121-1.554-.117-.017-.188-.07-.222-.162 1.173-.69 1.388-1.502 2.16-2.23.353-.154.49-.232.79-.265 2.774.439 4.52 1.543 5.9 2.282.56.304 1.07.535 1.557.812.426.14 1.713 1.113 2.09 1.637.383.807.662 1.68.917 2.522.183.857.343 1.204.343 1.204s-.155-.716-.13-.845c.162.06.542.18.7.16 0 0-.705-.364-.797-.686-.296-1.033-.594-2.641-.674-2.725-.226-.284-1.168-1.005-1.746-1.339-.218-.126-.336-.204-.345-.26.184-.186.412-.433.617-.59.195-.15.374-.32.647-.42 1.2-.541 1.886.207 2.05.056 0 0-.259-.296-.144-.247.117.063.5.138.542.177.437.342 1.581 1.593 2.27 2.913.166.323.233.536.156.925-.077.39-.136.604-.22.864-.076.174-.505 1.365-.503 1.525-.087.653.28 1.471.28 1.471.003-.222-.014-.34.006-.499l.025-.284s-.016-.075-.013-.105c.019-.196.067-.361.081-.474.138-.853.377-1.467.65-2.216.08-.189.185-.294.18-.438.005-.255-.224-.598-.389-.933a10.141 10.141 0 0 0-.627-1.112c-.596-.857-1.103-1.527-2.033-1.947-.26-.114-1.284-.226-1.638-.16-.429.09-.797.178-1.092.367-.462.296-.826.755-1.252 1.025-.944-.472-1.4-.825-1.484-.874-.561-.3-1.234-.649-1.958-.98-.348-.321-2.504-1.096-4.479-1.25zm9.705 19.318c.004 0 .007-.001.007-.002zm1.957-16.262c.05.26.091.517.287.844.42.463.571.79.63.935.205.526.369 1.052.519 1.578-.05-.548-.237-1.136-.313-1.66-.043-.24-.954-1.68-1.123-1.697zm-7.078 2.51c1.051.267 2.609.274 3.368.743.011.041-.02.068-.066.09-.187-.026-.372-.077-.57-.03-.29.093-.548.269-.822.406.754-.154.965.027 1.538.075.62.236.985 1.375 1.394 1.696-.378-.827-.617-2.06-1.355-2.714-.917-.294-2.267-.226-3.487-.267zm6.987 4.916a3.036 3.036 0 0 0-.668.066c-.16.215-.17.433-.24.635.476-.525.665-.557 1.427-.666a4.429 4.429 0 0 0-.52-.035zm-7.787.365c.496 1.86 1.516 3.733 2.53 5.44.39.496.497.718 1.087 1.018-.049.103-.103.23-.162.376-1.132-.559-2.067-1.232-3.008-1.91-1.512-1.104-1.89-2.418-2.155-4.136a.363.363 0 0 1 .12-.108 4.556 4.556 0 0 1 1.588-.68zm8.185 1.135c-.466-.002-.851.16-1.351.482 0 0 .554-.08.544-.03-.037.175.048.575.073.602l.006-.005c0 .006-.003.008-.006.005l-.306.25c.654-.329 1.341-.263 2.039-.313 0 0-.588-.162-.552-.167.131-.019-.035-.613-.08-.626a4.2 4.2 0 0 1 .334-.094 2.81 2.81 0 0 0-.701-.104zm-1.351.482zm.904.081c.094.001.189.028.22.09a.484.484 0 0 1 .018.265.538.538 0 0 0-.395.12c-.071.07-.123-.347-.068-.412.034-.04.13-.064.225-.063zm3.017.298c.084-.001.256.009.287.12.02.062-.042.27-.072.292-.046.023-.356.003-.369-.061-.026-.076.037-.306.108-.348l.046-.003zm2.897.384l-.553.27c-.9.284-.954.03-1.29-.066.222.253.487.442.958.33.645-.196.667-.36.885-.534zm-16.499.699c.5 1.36 2.887 3.894 6.09 4.278l-.008.018c-.11.266-.202.724-.196 1.104l-.006.01c-4.155-.885-4.67-1.994-5.951-2.987-.093-.768-.105-1.602.071-2.423zm9.442 1.904c-.021 0-.033 0-.033.003-.296.21-.34.412-.334.586.491-.483.473-.485 1.19-.48a7.261 7.261 0 0 0-.823-.109zm.296.363c-.105.567-.487.97-.783 1.368-.059.093-.101.22.189.624.078.108.36.126.55.116-.193-.146-.488-.301-.536-.436.341.233.657.3.943.262.065-.007.146-.077.209-.183.127-.274.227-.34.328-.413l.232.29.262-.223c-.581-.455-1.07-.923-1.394-1.405zm-9.281 2.42c1.46.878 3.814 1.839 5.812 1.791.2.347.439.711.633 1.001-2.544.387-4.308-.391-5.387-.92l-.117-.118c-.345-.391-.676-1.134-.941-1.755zm6.884 3.456c.1.207.262.379.273.402.856 1.116-1.079.859-1.478.791-.71-.113-1.405-.391-2.065-.767 1.074-.021 2.208.06 3.27-.426Z",source:"https://apache.org/logos/",hex:"FDEE21",guidelines:void 0,license:void 0},siAmazonaws={title:"Amazon AWS",slug:"amazonaws",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Amazon AWS</title><path d="'+this.path+'"/></svg>'},path:"M6.763 10.036c0 .296.032.535.088.71.064.176.144.368.256.576.04.063.056.127.056.183 0 .08-.048.16-.152.24l-.503.335a.383.383 0 0 1-.208.072c-.08 0-.16-.04-.239-.112a2.47 2.47 0 0 1-.287-.375 6.18 6.18 0 0 1-.248-.471c-.622.734-1.405 1.101-2.347 1.101-.67 0-1.205-.191-1.596-.574-.391-.384-.59-.894-.59-1.533 0-.678.239-1.23.726-1.644.487-.415 1.133-.623 1.955-.623.272 0 .551.024.846.064.296.04.6.104.918.176v-.583c0-.607-.127-1.03-.375-1.277-.255-.248-.686-.367-1.3-.367-.28 0-.568.031-.863.103-.295.072-.583.16-.862.272a2.287 2.287 0 0 1-.28.104.488.488 0 0 1-.127.023c-.112 0-.168-.08-.168-.247v-.391c0-.128.016-.224.056-.28a.597.597 0 0 1 .224-.167c.279-.144.614-.264 1.005-.36a4.84 4.84 0 0 1 1.246-.151c.95 0 1.644.216 2.091.647.439.43.662 1.085.662 1.963v2.586zm-3.24 1.214c.263 0 .534-.048.822-.144.287-.096.543-.271.758-.51.128-.152.224-.32.272-.512.047-.191.08-.423.08-.694v-.335a6.66 6.66 0 0 0-.735-.136 6.02 6.02 0 0 0-.75-.048c-.535 0-.926.104-1.19.32-.263.215-.39.518-.39.917 0 .375.095.655.295.846.191.2.47.296.838.296zm6.41.862c-.144 0-.24-.024-.304-.08-.064-.048-.12-.16-.168-.311L7.586 5.55a1.398 1.398 0 0 1-.072-.32c0-.128.064-.2.191-.2h.783c.151 0 .255.025.31.08.065.048.113.16.16.312l1.342 5.284 1.245-5.284c.04-.16.088-.264.151-.312a.549.549 0 0 1 .32-.08h.638c.152 0 .256.025.32.08.063.048.12.16.151.312l1.261 5.348 1.381-5.348c.048-.16.104-.264.16-.312a.52.52 0 0 1 .311-.08h.743c.127 0 .2.065.2.2 0 .04-.009.08-.017.128a1.137 1.137 0 0 1-.056.2l-1.923 6.17c-.048.16-.104.263-.168.311a.51.51 0 0 1-.303.08h-.687c-.151 0-.255-.024-.32-.08-.063-.056-.119-.16-.15-.32l-1.238-5.148-1.23 5.14c-.04.16-.087.264-.15.32-.065.056-.177.08-.32.08zm10.256.215c-.415 0-.83-.048-1.229-.143-.399-.096-.71-.2-.918-.32-.128-.071-.215-.151-.247-.223a.563.563 0 0 1-.048-.224v-.407c0-.167.064-.247.183-.247.048 0 .096.008.144.024.048.016.12.048.2.08.271.12.566.215.878.279.319.064.63.096.95.096.502 0 .894-.088 1.165-.264a.86.86 0 0 0 .415-.758.777.777 0 0 0-.215-.559c-.144-.151-.416-.287-.807-.415l-1.157-.36c-.583-.183-1.014-.454-1.277-.813a1.902 1.902 0 0 1-.4-1.158c0-.335.073-.63.216-.886.144-.255.335-.479.575-.654.24-.184.51-.32.83-.415.32-.096.655-.136 1.006-.136.175 0 .359.008.535.032.183.024.35.056.518.088.16.04.312.08.455.127.144.048.256.096.336.144a.69.69 0 0 1 .24.2.43.43 0 0 1 .071.263v.375c0 .168-.064.256-.184.256a.83.83 0 0 1-.303-.096 3.652 3.652 0 0 0-1.532-.311c-.455 0-.815.071-1.062.223-.248.152-.375.383-.375.71 0 .224.08.416.24.567.159.152.454.304.877.44l1.134.358c.574.184.99.44 1.237.767.247.327.367.702.367 1.117 0 .343-.072.655-.207.926-.144.272-.336.511-.583.703-.248.2-.543.343-.886.447-.36.111-.734.167-1.142.167zM21.698 16.207c-2.626 1.94-6.442 2.969-9.722 2.969-4.598 0-8.74-1.7-11.87-4.526-.247-.223-.024-.527.272-.351 3.384 1.963 7.559 3.153 11.877 3.153 2.914 0 6.114-.607 9.06-1.852.439-.2.814.287.383.607zM22.792 14.961c-.336-.43-2.22-.207-3.074-.103-.255.032-.295-.192-.063-.36 1.5-1.053 3.967-.75 4.254-.399.287.36-.08 2.826-1.485 4.007-.215.184-.423.088-.327-.151.32-.79 1.03-2.57.695-2.994z",source:"https://upload.wikimedia.org/wikipedia/commons/9/93/Amazon_Web_Services_Logo.svg",hex:"232F3E",guidelines:void 0,license:void 0},siAmazonpay={title:"Amazon Pay",slug:"amazonpay",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Amazon Pay</title><path d="'+this.path+'"/></svg>'},path:"M14.3781 4.9945c-.3732-.3227-.953-.4843-1.7401-.4843-.3895 0-.779.0355-1.1684.1054-.3901.0706-.7172.1636-.9824.2797-.0993.0418-.166.0849-.1991.1304-.0331.0456-.05.1267-.05.2422v.3352c0 .1491.0537.224.1617.224a.337.337 0 0 0 .1061-.0187c.0374-.0125.0687-.0225.093-.0312.6385-.1904 1.247-.2859 1.8275-.2859.4968 0 .8451.0912 1.0442.274.1991.1823.2984.4969.2984.9444v.8201c-.5799-.141-1.1023-.211-1.5667-.211-.729 0-1.3088.1804-1.74.5406-.4308.3601-.6467.8432-.6467 1.448 0 .5642.1741 1.013.5224 1.3488.3477.3358.8201.503 1.4168.503.3564 0 .7147-.0705 1.0754-.2109.3608-.1404.6897-.3402.988-.5967l.0625.41c.025.1574.116.236.274.236h.5343c.1654 0 .249-.083.249-.2484V6.4987c-.0006-.6797-.1872-1.1809-.5599-1.5042zm-.6091 4.6c-.2734.2072-.5593.3645-.8576.4725-.2984.108-.5842.1617-.8576.1617-.3233 0-.5717-.085-.7459-.2547-.1741-.1698-.2609-.412-.2609-.7271 0-.721.4682-1.0817 1.4044-1.0817.2153 0 .4369.015.6647.0437.2278.0293.4456.0687.6529.118zM8.7726 6.402c-.1204-.402-.292-.744-.5161-1.0255-.2235-.2815-.4969-.4975-.8202-.6466-.3227-.1492-.6834-.2235-1.0816-.2235-.3727 0-.7378.07-1.0936.211-.3563.141-.6921.3483-1.0073.6216l-.0618-.3982c-.025-.1654-.1205-.2484-.2865-.2484h-.5468c-.1654 0-.2484.083-.2484.2484v8.3662c0 .166.083.2484.2484.2484h.7334c.166 0 .2484-.083.2484-.2484v-2.9086c.5387.4887 1.181.7334 1.9268.7334.4057 0 .7746-.0811 1.106-.2422.3314-.1616.6129-.3876.845-.6778.2323-.2896.4126-.6416.5406-1.0567.1286-.4144.1929-.8788.1929-1.3925.0012-.505-.0593-.9587-.1792-1.3606zM5.982 10.1369c-.5642 0-1.111-.1985-1.6409-.5967V6.0724c.5218-.3813 1.0773-.5717 1.666-.5717 1.1271 0 1.6907.7752 1.6907 2.3243-.0006 1.5417-.5723 2.3119-1.7158 2.3119zm13.0005 1.963l2.735-6.9612c.0575-.141.0868-.2403.0868-.2984 0-.0992-.058-.1491-.1741-.1491h-.696c-.1329 0-.2234.0212-.274.0624-.0499.0418-.0992.133-.1491.274l-1.6784 4.8228-1.7401-4.8228c-.05-.141-.0993-.2322-.1492-.274-.05-.0412-.141-.0624-.274-.0624h-.7459c-.116 0-.1741.0499-.1741.1491 0 .058.0287.1573.0868.2984l2.3992 5.917-.236.6341c-.141.3982-.2983.6716-.4724.8208-.1741.1491-.4188.2234-.7334.2234-.141 0-.2528-.0087-.3352-.025-.083-.0162-.1454-.025-.1866-.025-.1242 0-.1866.0787-.1866.236v.3233c0 .1161.0206.201.0624.2547.0412.0536.1074.0936.1991.118.2066.0574.4432.0873.7084.0873.4725 0 .8557-.1242 1.1497-.3732.2952-.2478.5543-.6585.7777-1.2302m2.7113 4.4233c-2.6276 1.9393-6.4369 2.9704-9.7174 2.9704-4.5975 0-8.7375-1.6996-11.8701-4.5283-.246-.2221-.0269-.5255.269-.3532 3.3798 1.9667 7.5597 3.1513 11.877 3.1513 2.9123 0 6.1136-.6042 9.0596-1.8537.4437-.1891.8163.2921.382.6135m1.0928-1.2483c.3364.4307-.3738 2.204-.691 2.996-.096.2396.11.3364.3271.1548 1.4094-1.179 1.7739-3.65 1.4855-4.0071-.2865-.3539-2.7506-.6585-4.2548.3976-.2316.1623-.1916.387.0649.3557.847-.101 2.7325-.3276 3.0683.103Z",source:"https://pay.amazon.com/",hex:"FF9900",guidelines:void 0,license:void 0},siApollographql={title:"Apollo GraphQL",slug:"apollographql",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apollo GraphQL</title><path d="'+this.path+'"/></svg>'},path:"M12,0C5.372,0 0,5.373 0,12 0,18.628 5.372,24 12,24 18.627,24 24,18.628 24,12A12.014,12.014 0 0 0 23.527,8.657 0.6,0.6 0 0 0 22.4,9.066H22.398C22.663,10.009 22.8,10.994 22.8,12A10.73,10.73 0 0 1 19.637,19.637 10.729,10.729 0 0 1 12,22.8 10.73,10.73 0 0 1 4.363,19.637 10.728,10.728 0 0 1 1.2,12 10.73,10.73 0 0 1 4.363,4.363 10.728,10.728 0 0 1 12,1.2C14.576,1.2 17.013,2.096 18.958,3.74A1.466,1.466 0 1 0 19.82,2.9 11.953,11.953 0 0 0 12,0ZM10.56,5.88 6.36,16.782H8.99L9.677,14.934H13.646L12.927,12.892H10.314L12.014,8.201 15.038,16.781H17.669L13.47,5.88Z",source:"https://github.com/apollographql/space-kit/blob/9a42083746a49c9a734563f427c13233e42adcc9/logos/mark.svg",hex:"311C87",guidelines:void 0,license:void 0},siAskubuntu={title:"Ask Ubuntu",slug:"askubuntu",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Ask Ubuntu</title><path d="'+this.path+'"/></svg>'},path:"M6.511 13a3.95 3.95 0 0 0-.505.035c-.178.023-.341.07-.489.143a1.07 1.07 0 0 0-.37.299c-.098.126-.147.294-.147.5 0 .383.121.65.364.8.242.148.571.223.988.223.25 0 .472-.006.665-.017.193-.012.354-.032.483-.063v-1.782a1.33 1.33 0 0 0-.37-.098 4.04 4.04 0 0 0-.619-.04zm12.774 2.77c-.171-.284-.37-.574-.593-.87a13.212 13.212 0 0 0-.703-.854 10.048 10.048 0 0 0-.746-.75 6.636 6.636 0 0 0-.722-.573v3.048h-1.137V6.506l1.137-.195v5.778l.649-.646c.236-.236.468-.475.696-.719.229-.244.445-.478.648-.701.204-.223.38-.42.526-.591h1.334c-.188.203-.392.426-.612.67-.22.244-.448.49-.685.737-.237.249-.475.497-.715.744l-.679.701c.244.188.503.419.777.695.273.276.541.575.807.896.265.321.515.646.752.976.236.329.436.635.6.92zm-5.754-.304c-.436.3-1.057.451-1.864.451-.563 0-1.003-.046-1.321-.14a6.652 6.652 0 0 1-.648-.214l.208-.974c.13.049.338.121.623.22.286.096.665.145 1.138.145.464 0 .809-.06 1.033-.183.224-.122.336-.317.336-.585a.775.775 0 0 0-.33-.658c-.22-.163-.583-.345-1.088-.549a15.22 15.22 0 0 1-.704-.299 2.464 2.464 0 0 1-.58-.359 1.582 1.582 0 0 1-.392-.5 1.597 1.597 0 0 1-.147-.719c0-.56.208-1.006.624-1.335.416-.33.983-.494 1.7-.494.179 0 .359.01.538.031.18.02.347.044.502.073a4.802 4.802 0 0 1 .684.177l-.208.975a2.941 2.941 0 0 0-.574-.201 3.75 3.75 0 0 0-.942-.104c-.318 0-.595.063-.832.189a.626.626 0 0 0-.355.591c0 .139.027.26.08.366a.848.848 0 0 0 .245.287c.11.085.246.164.41.237.162.074.358.15.587.232.3.114.57.226.807.335.236.11.438.238.605.384.167.146.296.323.385.53.09.208.135.462.135.763 0 .585-.218 1.028-.655 1.328zm-4.97.195l-.41.068c-.175.028-.373.055-.594.079-.22.024-.458.046-.715.067-.256.02-.511.03-.764.03a4.19 4.19 0 0 1-.99-.11 2.221 2.221 0 0 1-.784-.347 1.595 1.595 0 0 1-.513-.628c-.122-.26-.184-.573-.184-.938 0-.35.071-.65.214-.903.143-.251.337-.455.582-.61a2.71 2.71 0 0 1 .856-.34 4.68 4.68 0 0 1 1.027-.11 4.132 4.132 0 0 1 .703.067 15.222 15.222 0 0 1 .458.091v-.317c0-.187-.02-.372-.06-.554a1.275 1.275 0 0 0-.22-.488 1.118 1.118 0 0 0-.435-.341c-.184-.086-.422-.129-.715-.129-.375 0-.704.027-.985.08a3.48 3.48 0 0 0-.63.164l-.134-.938c.147-.065.391-.128.734-.19.342-.06.713-.091 1.113-.091.456 0 .841.06 1.155.177.314.118.567.285.758.5.192.215.328.471.41.768.082.297.122.624.122.981zM24 11.961C24 5.356 18.627 0 12 0S0 5.356 0 11.961c0 6.607 5.373 11.963 12 11.963 2.177 0 4.217-.58 5.978-1.591L24 24l-1.512-6.226A11.878 11.878 0 0 0 24 11.961z",source:"https://askubuntu.com/",hex:"DC461D",guidelines:"https://stackoverflow.com/legal/trademark-guidance",license:void 0},siAskfm={title:"ASKfm",slug:"askfm",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>ASKfm</title><path d="'+this.path+'"/></svg>'},path:"M12 24c-2.172 0-4.195-.547-6.07-1.64a12.003 12.003 0 01-4.29-4.29A11.842 11.842 0 010 12c0-2.172.547-4.195 1.64-6.07a12.003 12.003 0 014.29-4.29A11.842 11.842 0 0112 0c2.172 0 4.195.547 6.07 1.64a12.003 12.003 0 014.29 4.29A11.842 11.842 0 0124 12c0 2.172-.547 4.195-1.64 6.07a12.003 12.003 0 01-4.29 4.29A11.842 11.842 0 0112 24zm2.133-14.227c-.39.282-.664.688-.82 1.22-.157.53-.188 1.109-.094 1.734s.312 1.222.656 1.793c.344.57.754 1.027 1.23 1.37.477.344.961.54 1.454.587.492.046.933-.07 1.324-.352.39-.281.664-.688.82-1.219.156-.531.188-1.11.094-1.734a4.839 4.839 0 00-.656-1.793 4.564 4.564 0 00-1.23-1.371c-.477-.344-.962-.54-1.454-.586a1.887 1.887 0 00-1.324.351zm2.484 5.18c-.469.188-.937.152-1.406-.105-.469-.258-.813-.66-1.031-1.207a3.082 3.082 0 01-.164-.797h.023c.063 0 .14-.016.234-.047h-.023c.188-.063.316-.211.387-.445a.92.92 0 00-.012-.633.842.842 0 00-.164-.305v.024c.187-.235.406-.399.656-.493.469-.203.938-.175 1.406.082.47.258.809.668 1.02 1.23.21.563.227 1.106.047 1.63-.18.523-.504.879-.973 1.066zm-3.586.235a.825.825 0 00-.515-.106.768.768 0 00-.47.27l-.187.234a.348.348 0 00-.093.258c0 .062.015.125.046.187.391.735.711 1.242.961 1.524a.124.124 0 00.13.058.18.18 0 00.128-.082c.094-.234.219-.734.375-1.5l.047-.258v-.07a.38.38 0 00-.164-.328zm-4.804-4.641c-.47.062-.891.289-1.266.68-.375.39-.664.882-.867 1.476a5.391 5.391 0 00-.282 1.887c.016.664.149 1.262.399 1.793.25.531.574.93.973 1.195.398.266.832.367 1.3.305.47-.063.891-.285 1.266-.668.375-.383.664-.871.867-1.465a5.391 5.391 0 00.281-1.887c-.015-.664-.148-1.261-.398-1.793-.25-.53-.574-.933-.973-1.207a1.806 1.806 0 00-1.3-.316zm1.828 3.633c.03.593-.102 1.113-.399 1.558-.297.446-.68.692-1.148.739-.469.046-.883-.118-1.242-.493-.36-.375-.563-.851-.61-1.43v-.187c0-.219.024-.43.07-.633v.024a.822.822 0 00.235.023.703.703 0 00.469-.316.81.81 0 00.14-.598.725.725 0 00-.07-.328c.203-.156.445-.258.727-.305.468-.047.882.121 1.242.504s.554.864.586 1.442zM5.602 7.547a1.17 1.17 0 00-.329-.305c-.156-.094-.304-.125-.445-.094a.489.489 0 00-.328.258.961.961 0 00-.117.375l-.281 2.766.304-.516c.25-.39.516-.726.797-1.008.406-.406.797-.671 1.172-.796a1.54 1.54 0 01-.445-.329c-.12-.104-.227-.243-.328-.351zM17.25 5.016a.55.55 0 00-.48-.141c-.18.031-.34.164-.48.398-.08.157-.142.32-.188.493-.027.058-.032.125-.047.187l-.024.07c-.11.25-.21.43-.304.54.453.015.89.101 1.312.257a4.83 4.83 0 011.594.961l.21.211-1.265-2.578a.925.925 0 00-.328-.398Z",source:"https://ask.fm/",hex:"DB3552",guidelines:void 0,license:void 0},siAssemblyscript={title:"AssemblyScript",slug:"assemblyscript",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AssemblyScript</title><path d="'+this.path+'"/></svg>'},path:"M0 0v24h24V0h-9.225c0 1.406-1.04 2.813-2.756 2.813A2.766 2.766 0 019.234 0zm18.204 10.947c.707 0 1.314.137 1.82.412.517.264.96.717 1.33 1.361l-1.726 1.108c-.19-.338-.395-.58-.617-.728a1.422 1.422 0 00-.807-.222c-.327 0-.586.09-.776.27a.896.896 0 00-.285.68c0 .337.106.596.317.775.222.17.57.36 1.045.57l.554.238c.474.2.891.411 1.25.633.37.21.675.453.918.728.253.264.443.57.57.918.137.337.206.738.206 1.203a3 3 0 01-.285 1.33c-.18.38-.433.701-.76.965a3.419 3.419 0 01-1.171.601c-.443.127-.929.19-1.456.19a5.31 5.31 0 01-1.41-.174 4.624 4.624 0 01-1.139-.475 3.922 3.922 0 01-.886-.712 4.48 4.48 0 01-.602-.902L16.1 18.67c.242.39.527.712.855.966.337.253.78.38 1.33.38.463 0 .827-.1 1.091-.301.275-.211.412-.475.412-.792 0-.38-.143-.664-.428-.854-.285-.19-.68-.396-1.187-.618l-.554-.237a8.12 8.12 0 01-1.092-.554 3.64 3.64 0 01-.839-.696 2.887 2.887 0 01-.538-.903 3.375 3.375 0 01-.19-1.187c0-.411.074-.796.222-1.155a2.91 2.91 0 01.649-.934c.285-.264.628-.47 1.029-.617.4-.148.849-.222 1.345-.222zm-8.796.032h.19l4.922 10.858h-2.327l-.506-1.219H7.318l-.506 1.219H4.675zm.063 3.988a22.21 22.21 0 01-.206.697l-.205.649a6.979 6.979 0 01-.222.585l-.776 1.868h2.834l-.776-1.868a15.492 15.492 0 01-.237-.633 23.741 23.741 0 01-.412-1.298z",source:"https://www.assemblyscript.org/",hex:"007AAC",guidelines:void 0,license:void 0},siAstonmartin={title:"Aston Martin",slug:"astonmartin",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Aston Martin</title><path d="'+this.path+'"/></svg>'},path:"M.3281 9.3008c-.0675 0-.2142.01-.293.1562-.0337.0675-.0665.181.0235.3496l.1797.291c.0674.1125.156.1587.336.17 0 0 .079.0101.1464.1113l.1797.3145c.0337.0674.1246.248.4394.293.0113 0 .0903.012.1465.1132l.2246.3926c.0675.1237.1575.1684.3262.2246l4.0586 1.1934c.135.045.2031.2011.2031.2011.1012.2474.2239.4612.8535.6524l3.3184.9004c.045.0112.426.1234.707-.1465l.7774-.7422s.0327-.0332.0664-.0332c.045 0 .0683.0332.0683.0332l.7754.7422c.2924.281.664.1577.709.1465l3.3164-.9004c.6296-.1912.7542-.3938.8555-.6524 0 0 .0549-.1562.2012-.2011l4.0605-1.1934c.1575-.0562.2456-.101.3242-.2246l.2266-.3926c.045-.09.1334-.1133.1445-.1133.3036-.045.3946-.2142.4395-.293l.1797-.3144c.0562-.1012.1351-.1113.1465-.1113.1685-.0113.259-.0575.3378-.17l.1797-.291c.0338-.1574.0006-.2821-.0332-.3496-.0788-.1461-.2479-.1562-.293-.1562h-9.705c-.2699 0-.4935.0774-.6621.246-.1125.1125-.2031.2694-.248.4493 0 0-.0117.045-.1016.045h-1.9102c-.0787 0-.0903-.0338-.1016-.045-.045-.18-.1243-.3368-.248-.4492-.1574-.1574-.3942-.2461-.664-.2461H.328zm13.6172.1797h4.4629c-.1574.1124-.2363.2583-.2363.2695-.0562.1012-.1108.203-.1895.3379H13.213c.0112-.0113.0117-.0352.0117-.0352.0337-.1574.1015-.2699.1914-.371.1237-.1237.3044-.2012.5293-.2012zM.3281 9.4902h4.834c.3261 0 .5293.338.5293.338.045.0786.0888.1683.1563.2695H.5645c-.1237-.0113-.1577-.0224-.1915-.0899 0 0-.1586-.2685-.1699-.291C.1806 9.6718.17 9.626.17 9.6035c0-.0675.0458-.1133.1582-.1133zm9.7032 0c.2248 0 .4056.0682.5292.2032.09.09.1577.2136.1915.371l.0214.045H6.006c-.0675-.1125-.1914-.338-.1914-.338-.0113-.0112-.0902-.157-.2364-.2694 2.2939-.0113 4.4531-.0118 4.4531-.0118zm8.793 0h4.8359c.0561 0 .1113.0122.1562.0684 0 .0112.0234.0229.0234.0566-.0335.0113-.034.0454-.0566.1016l-.168.291c-.0337.0562-.0564.0786-.1914.0899h-5.2851c.0675-.1012.1133-.1909.1582-.2696 0 0 .19-.3379.5273-.3379zm-11.6368.7422h9.6133v1.3496H7.1875v-1.3496zm10.8613 0h5.1055c0 .0113-.0121.0342-.0234.0567l-.1797.3261c-.0225.045-.0677.1133-.1914.1582-.1011.0225-.3023.0113-.3809 0l-4.4883-.293c.0564-.0899.1133-.1693.1582-.248zm-17.2383.0117h5.1172c.045.0788.1.1581.1563.248l-4.4961.2911c-.0562.0112-.2601.0112-.3613 0-.1237-.045-.1577-.1113-.1914-.1562-.0675-.1237-.1684-.3154-.2247-.3829zm5.2852 0h.9453v.1797l-.787.0567c-.0563-.0787-.1133-.1576-.1583-.2364zm10.8398 0h.9454c-.0451.0675-.102.1577-.1582.2364l-.7872-.0567v-.1797zm-9.1425.2032l-.416.9218h.1132v-.0117a3.7474 3.7474 0 0 1 .1133-.3262l.0098-.0214h.3144c.045.1012.0918.2015.1368.3476v.0117h.1562l-.3926-.9218H7.793zm2.205 0c-.2923 0-.4843.1915-.4843.4726s.2032.4707.4843.4707c.2924 0 .506-.2013.506-.4824 0-.3148-.2586-.461-.506-.461zm3.4415 0l-.418.9218h.1133v-.0117a3.7474 3.7474 0 0 1 .1132-.3262s.0098-.0102.0098-.0214h.3164c.045.1012.0898.2127.1348.3476v.0117h.1562l-.3925-.9218h-.0332zM8.58 10.457c-.18 0-.291.1019-.291.248 0 .1575.1121.2031.2246.2481.09.0338.1797.0673.1797.1797 0 .1012-.0668.1797-.168.1797-.09 0-.147-.033-.2031-.123h-.045l-.0234.123c.045.0562.1586.0781.2149.0781.1911 0 .3261-.1228.3261-.3027.0225-.1574-.102-.203-.2031-.248-.1012-.0338-.1914-.0673-.1914-.1797 0-.0788.0682-.1465.1582-.1465.0675 0 .1225.0345.1562.1133v.0117h.0235l.0332-.1133c-.0562-.045-.1352-.0684-.1914-.0684zm.2812 0v.0918h.0117c.0788-.0112.1571-.0234.2696-.0234v.8203h.125v-.8203c.09 0 .179.0122.2578.0234l.0234.0098v-.1016h-.6875zm3.1836 0v.0117c-.0112.135-.0912.675-.125.8887v.0117h.1133v-.0117c0-.1237.0224-.3152.045-.5176 0 0 .0102-.0893.0214-.123.0225.0225.1806.3475.248.4824l.0684.1582h.0215v-.0117c.0675-.1687.18-.3703.3262-.6289.0225.1574.0458.4607.0683.6406v.0117h.1348v-.0117c-.0225-.2136-.0683-.5063-.1133-.8887l-.0332-.0117-.2148.3946s-.1338.247-.1563.2695c-.135-.2249-.247-.4617-.3594-.664h-.0449zm-1.4062.0117v.9004h.0898v-.6972c.0113.0112.5625.6191.5625.6191l.0664.0781h.045l-.0098-.9003h-.0801v.664a471.423 471.423 0 0 1-.6172-.664h-.0566zm3.957 0v.0899h.0117c.0787-.0112.1571-.0215.2696-.0215v.8203h.125v-.8203c.09 0 .179.0103.2578.0215h.0117v-.0899h-.6758zm.7871 0v.9004h.125v-.9003h-.125zm.3164 0v.9004h.0899v-.6972c.011.0112.5625.6191.5625.6191l.0664.0781h.0566v-.9003h-.0898v.664c-.0112-.0112-.6192-.664-.6192-.664h-.0664zm-1.7441.0118v.9004h.125v-.4395h.0332c0 .0112.1015.1133.1015.1133l.1563.2012.08.1132h.1563c.0113 0-.336-.4282-.336-.4394.1575-.0337.2579-.1224.2579-.2461 0-.135-.1018-.2031-.293-.2031h-.2812zm-3.9356.0234c.1125 0 .2036.0443.2598.123.0675.0788.0781.1689.0781.2813v.0215c0 .09-.0346.203-.1133.293-.0674.0674-.1444.1015-.2343.1015-.2024 0-.3496-.1584-.3496-.3945 0-.2586.1344-.4258.3593-.4258zm4.0606.0215c.0562 0 .1347-.0113.1797 0 .09.0225.1347.0682.1347.1582 0 .09-.0682.1572-.1582.1797-.0562.0112-.1337.0117-.1562.0117v-.3496zm2.8554.0332l.6973.045a2.6065 2.6065 0 0 0-.1582.2148l-.539-.0684v-.1914zm-9.8945.0117v.1797l-.5293.0781a2.5667 2.5667 0 0 1-.1562-.2129l.6855-.0449zm-.8555.0567c.0563.0674.1133.157.1582.2246l-4.2851.5742c-.1574.0225-.2134-.0337-.2246-.045l-.213-.3828c-.0224-.0224-.034-.057-.0565-.0683.0224 0 4.621-.3027 4.621-.3027zm11.6055 0l4.5645.3027c.0111 0 .0229.0005.0566.0117-.0113.0113-.0336.0342-.045.0566 0 0-.181.3154-.2148.3829-.011.0112-.0671.0674-.2246.0449l-4.3066-.5742c.0675-.0787.1137-.1572.17-.2246zm-10.0312.0214c.0112.0225.1235.2822.1347.3047h-.2578c.0113-.0225.1118-.271.123-.3047zm5.6562 0c.0113.0225.1235.2822.1348.3047h-.2578a8.5805 8.5805 0 0 0 .123-.3047zm3.5195.2364l.4278.0566c-.0564.0675-.1122.1454-.1797.2129-.1124-.0112-.1917-.0224-.248-.045v-.2245zm-9.8828.0117v.2246l-.248.045c-.0675-.0675-.1235-.1455-.1797-.213l.4277-.0566zm-.5976.0781c.0675.0675.1127.1571.1914.2246l-2.957.6074c-.1237.0225-.4383.0802-.5957.0352-.4386-.135-.8094-.2363-.9668-.2813l4.328-.5859zm11.0879.0117l4.328.5742-.9765.2813c-.1574.045-.4847-.0122-.586-.0234 0 0-2.0236-.4163-2.957-.6075.0676-.0674.124-.1571.1915-.2246zm-10.502.2696v.1796c-.045-.045-.0898-.0995-.1348-.1445a1.1219 1.1219 0 0 0 .1348-.0351zm9.8945.0117l.1348.0234c-.0449.0562-.0897.1-.1348.1563v-.1797zm.3047.0566l3.0352.6172c.0113 0 .0683.0234.1582.0234l-1.0137.3028c-.2025.0562-.4824-.0332-.4824-.0332l-1.9785-.6192c.101-.1012.1913-.201.2812-.291zm-10.4804.0117c.09.1012.18.201.2812.291l-1.9805.6192c-.0224-.0112-.2917.0777-.494.0215-.3374-.1012-.674-.201-1-.291.0899-.0113.1562-.0235.1562-.0235s2.1375-.4373 3.037-.6172zm.5722.3809h1.1582l-.752.3496c-.0112-.0113-.2937-.2484-.4062-.3496zm1.4844 0h.877l-1.213.8672c-.2023-.1237-.4167-.2699-.619-.416.4497-.2137.8763-.4062.955-.4512zm2.3399 0h.3378l-.4843 1.7539c-.2699-.0337-.529-.0888-.7989-.1562.3486-.596.8217-1.384.9453-1.5977zm1.3378 0h.338l.9433 1.5977c-.2586.0674-.527.1112-.7969.1562l-.4844-1.7539zm.5059 0h.3945l1.2578 1.3047c-.236.1012-.483.1806-.7304.248L13 11.7168zm.584 0h.4726l1.3164.9453c-.1911.1125-.3933.203-.5957.293-.4272-.4385-.9572-.9797-1.1933-1.2383zm.709 0h.8652l.957.4512c-.2023.1574-.4055.2908-.6191.4258-.4498-.3374-.9445-.6858-1.2031-.877zm1.203 0h1.1583c-.1126.1124-.3932.3496-.4043.3496-.2811-.1237-.5514-.2484-.754-.3496zm-4.9023.0117h.3946l-.9238 1.5527c-.2474-.0674-.4832-.158-.7305-.248.506-.5285 1.1136-1.1585 1.2598-1.3047zm1.0235 0h.293l.0097 1.8106c-.2586 0-.5285-.0225-.787-.045l.4843-1.7656zm.4492 0h.293l.4824 1.7656c-.2586.0338-.5168.045-.7754.045v-1.8106zm4.7793 0l2.0469.629s.0453.0234.1015.0234l-1.1132.3378c-.1462.0338-.3486-.0463-.416-.08 0 0-.5292-.2473-1.0801-.5059.1574-.135.3148-.2694.4609-.4043zm-9.7148.0117c.1461.135.2922.2694.4609.4043l-1.08.5059c-.0563.0225-.2582.1133-.4044.0684-.045-.0113-.5178-.1576-1.125-.3262.0562-.0113.1016-.0235.1016-.0235s1.6645-.5164 2.0469-.6289zm2.789 0h.4707l-1.1914 1.2364c-.2024-.09-.3933-.1918-.5957-.293.5735-.416 1.1702-.8422 1.3164-.9434zm-2.2168.4942c.2024.1574.4173.3045.6309.4394l-1.002.707c.0113.0226-.1911.1696-.371.1133-.4161-.1574-.4829-.3152-.5391-.4726-.0113-.0225-.0327-.1005-.1114-.168.1462-.0225.2583-.0786.2696-.0898 0 0 .572-.2595 1.123-.5293zm8.5684.0117l1.1367.5273c.0113 0 .1228.0693.2578.0918-.0675.0787-.1015.1568-.1015.168-.0675.1574-.1232.304-.5391.4727-.1688.0562-.3828-.1016-.3828-.1016s-.4715-.3384-1-.7207c.2136-.135.4266-.28.6289-.4375zm-7.791.5059c.2024.1124.4035.2244.6172.3144l-.5723.6191c-.0562.0563-.2264.1788-.3613.1563l-.8868-.2461c.09-.0337.1563-.0786.1563-.0898 0 0 .4959-.3491 1.0469-.754zm7.0156.0117l1.0469.752s.0663.0467.1562.0917c-.225.0562-.7305.1895-.7305.1895l-.1582.0449c-.135.0337-.2914-.1-.3476-.1563 0 0-.2467-.2588-.584-.6074.2024-.1012.4148-.202.6172-.3144zm-6.2637.3808c.2474.1125.4953.204.754.2715l-.3145.5274c-.0338.0674-.1571.2475-.2696.2363l-.957-.2578c.1012-.0563.17-.1235.17-.1348 0 0 .2686-.294.6171-.6426zm5.5098 0l.6191.6426c.0113.0113.0668.0673.168.1348l-.9434.2578c-.1124.0225-.2475-.1576-.2812-.2363l-.3145-.5274c.2587-.0674.5159-.159.752-.2715zm-4.6211.293c.2699.0675.551.1245.832.1582l-.1562.5957s-.0345.1693-.1582.248c-.0562.0338-.1127.0328-.1914.0215l-.8438-.2246c.1012-.0787.1704-.2021.1817-.2246 0 0 .1447-.2481.3359-.5742zm3.7441.0117l.338.5742c.0112.0225.0784.1347.1796.2246l-.8437.213a.2228.2228 0 0 1-.1895-.0215c-.1124-.0675-.1582-.2369-.1582-.248l-.1582-.584c.2811-.0338.5622-.0908.832-.1583zm-2.7773.1797c.2024.0225.4172.0337.6309.045-.1462.1686-.709.6855-.709.6855-.0675.0675-.1357.102-.2032.1133.09-.1125.125-.2368.125-.248l.1563-.5958zm1.789 0l.1563.5957c.0113.0225.035.1581.125.248-.1124-.0224-.1473-.0671-.3047-.2246 0 0-.45-.4392-.6074-.5742.2136-.0112.4285-.0224.6309-.0449Z",source:"https://www.astonmartin.com/",hex:"000000",guidelines:void 0,license:void 0},siAstro={title:"Astro",slug:"astro",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Astro</title><path d="'+this.path+'"/></svg>'},path:"M16.074 16.86c-.72.616-2.157 1.035-3.812 1.035-2.032 0-3.735-.632-4.187-1.483-.161.488-.198 1.046-.198 1.402 0 0-.106 1.75 1.111 2.968 0-.632.513-1.145 1.145-1.145 1.083 0 1.082.945 1.081 1.712v.069c0 1.164.711 2.161 1.723 2.582a2.347 2.347 0 0 1-.236-1.029c0-1.11.652-1.523 1.41-2.003.602-.383 1.272-.807 1.733-1.66a3.129 3.129 0 0 0 .378-1.494 3.14 3.14 0 0 0-.148-.954zM15.551.6c.196.244.296.572.496 1.229l4.368 14.347a18.18 18.18 0 0 0-5.222-1.768L12.35 4.8a.37.37 0 0 0-.71.002l-2.81 9.603a18.175 18.175 0 0 0-5.245 1.771L7.974 1.827c.2-.656.3-.984.497-1.227a1.613 1.613 0 0 1 .654-.484C9.415 0 9.757 0 10.443 0h3.135c.686 0 1.03 0 1.32.117A1.614 1.614 0 0 1 15.55.6z",source:"https://github.com/withastro/astro/blob/09144e8e88fbb79a75a2283aca8bf6eba6dc45f0/assets/brand/logo-white.svg",hex:"FF5D01",guidelines:void 0,license:{type:"MIT",url:"https://spdx.org/licenses/MIT"}},siAsus={title:"ASUS",slug:"asus",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>ASUS</title><path d="'+this.path+'"/></svg>'},path:"M23.904 10.788V9.522h-4.656c-.972 0-1.41.6-1.482 1.182v.018-1.2h-1.368v1.266h1.362zm-6.144.456l-1.368-.078v1.458c0 .456-.228.594-1.02.594H14.28c-.654 0-.93-.186-.93-.594v-1.596l-1.386-.102v1.812h-.03c-.078-.528-.276-1.14-1.596-1.23L6 11.22c0 .666.474 1.062 1.218 1.14l3.024.306c.24.018.414.09.414.288 0 .216-.18.24-.456.24H5.946V11.22l-1.386-.09v3.348h5.646c1.26 0 1.662-.654 1.722-1.2h.03c.156.864.912 1.2 2.19 1.2h1.41c1.494 0 2.202-.456 2.202-1.524zm4.398.258l-4.338-.258c0 .666.438 1.11 1.182 1.17l3.09.24c.24.018.384.078.384.276 0 .186-.168.258-.516.258h-4.212v1.29h4.302c1.356 0 1.95-.474 1.95-1.554 0-.972-.534-1.338-1.842-1.422zm-10.194-1.98h1.386v1.266h-1.386zM3.798 11.07l-1.506-.15L0 14.478h1.686zm7.914-1.548h-4.23c-.984 0-1.416.612-1.518 1.2v-1.2H3.618c-.33 0-.486.102-.642.33l-.648.936h9.384Z",source:"https://www.asus.com/",hex:"000000",guidelines:void 0,license:void 0},siAtandt={title:"AT&T",slug:"atandt",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AT&amp;T</title><path d="'+this.path+'"/></svg>'},path:"M4.584 21.438a12.077 12.077 0 0 0 7.349 2.495 12 12 0 0 0 7.887-2.967c-.944.607-3.64 2.023-7.887 2.023-3.708 0-6.068-.81-7.349-1.55m8.158.606c2.966 0 6.202-.809 8.09-2.427.539-.405 1.01-1.011 1.483-1.753.27-.472.539-1.011.741-1.483-1.82 2.63-7.011 4.315-12.404 4.315-3.776 0-7.888-1.214-9.506-3.573 1.483 3.236 6 4.92 11.596 4.92m-3.236-5.257C3.37 16.787.472 13.955 0 12c0 .674.067 1.483.202 2.09.068.27.27.674.607 1.079 1.483 1.55 5.191 3.707 11.595 3.707 8.697 0 10.72-2.898 11.124-3.842.27-.674.472-1.888.472-2.967v-.674c-.607 2.292-8.022 5.394-14.494 5.394m-8.427-9.91C.742 7.55.337 8.763.202 9.37c-.067.27 0 .404.068.607.741 1.55 4.45 4.044 13.078 4.044 5.259 0 9.371-1.28 10.045-3.64.135-.404.135-.876 0-1.483-.202-.674-.472-1.483-.809-2.09.068 3.101-8.562 5.124-12.944 5.124-4.719 0-8.696-1.888-8.696-4.248.067-.337.135-.606.135-.809M19.82 3.034c.068.067.068.135.068.27 0 1.348-4.045 3.64-10.517 3.64-4.787 0-5.663-1.753-5.663-2.9 0-.404.135-.808.472-1.213-.607.607-1.146 1.147-1.686 1.82-.202.27-.337.54-.337.675 0 2.36 5.865 3.977 11.259 3.977 5.797 0 8.427-1.887 8.427-3.573 0-.606-.203-.943-.81-1.618a17.301 17.301 0 0 0-1.213-1.078m-1.753-1.281A11.794 11.794 0 0 0 11.933.067C9.64.067 7.55.674 5.73 1.82c-.539.27-.876.54-.876.877 0 1.01 2.36 2.09 6.54 2.09 4.112 0 7.348-1.214 7.348-2.36.067-.202-.203-.405-.675-.674",source:"https://www.att.com",hex:"009FDB",guidelines:void 0,license:void 0},siAtari={title:"Atari",slug:"atari",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Atari</title><path d="'+this.path+'"/></svg>'},path:"M0 21.653s3.154-.355 5.612-2.384c2.339-1.93 3.185-3.592 3.77-5.476.584-1.885.671-6.419.671-7.764V2.346H8.598v1.365c-.024 2.041-.2 5.918-1.135 8.444C5.203 18.242 0 18.775 0 18.775zm24 0s-3.154-.355-5.61-2.384c-2.342-1.93-3.187-3.592-3.772-5.476-.583-1.885-.671-6.419-.671-7.764V2.346H15.4l.001 1.365c.024 2.041.202 5.918 1.138 8.444 2.258 6.087 7.46 6.62 7.46 6.62zM10.659 2.348h2.685v19.306H10.66Z",source:"https://atarivcs.com/",hex:"E4202E",guidelines:void 0,license:void 0},siAtlassian={title:"Atlassian",slug:"atlassian",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Atlassian</title><path d="'+this.path+'"/></svg>'},path:"M7.12 11.084a.683.683 0 00-1.16.126L.075 22.974a.703.703 0 00.63 1.018h8.19a.678.678 0 00.63-.39c1.767-3.65.696-9.203-2.406-12.52zM11.434.386a15.515 15.515 0 00-.906 15.317l3.95 7.9a.703.703 0 00.628.388h8.19a.703.703 0 00.63-1.017L12.63.38a.664.664 0 00-1.196.006z",source:"https://www.atlassian.com/company/news/press-kit",hex:"0052CC",guidelines:void 0,license:void 0},siAuchan={title:"Auchan",slug:"auchan",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Auchan</title><path d="'+this.path+'"/></svg>'},path:"m14.467 18.7529 1.6518 4.6358h1.2185l-1.7447-4.8583a7.9586 7.9586 0 0 1-1.1256.2217M0 23.3888h5.5057l1.7822-5.6112H1.9158A107.284 107.284 0 0 0 0 23.3879m7.2547-12.6334L10.4337 8.1c.5205-1.4086 1.0642-2.8197 1.6295-4.0216.2822.6408.5495 1.2816.83 1.9639 1.2268-1.0077 2.0328-1.5555 2.0735-1.582l.0164-.0117a5.6618 5.6618 0 0 1 1.632-.7064 112.7775 112.7775 0 0 0-1.4817-3.131h-6.169c-.5146.9903-2.4329 4.9521-4.6765 10.399h2.2694c.3693 0 .5544-.1362.6972-.2557m12.9073 4.4076a7.4539 7.4539 0 0 1-3.473 2.9658l1.8702 5.2609H24c-1.0874-3.3012-2.2536-6.2786-3.3484-9.0684-.1527.303-.3155.5603-.4898.8409M18.549 6.2946c.157 0 .303.0365.4358.1005-.0264-.0042-.054-.0092-.0813-.0092a.5844.5844 0 0 0-.5844.581.581.581 0 0 0 .5844.5803.581.581 0 0 0 .5827-.5794c0-.02-.0025-.0374-.004-.0548a.9987.9987 0 0 1 .0772.3843c0 .5528-.4524 1.0027-1.0102 1.0027-.5556.0014-1.0074-.4471-1.0102-1.0027 0-.5561.4532-1.0027 1.0102-1.0027zm-5.6393 11.3178c1.3297 0 4.503-.3378 6.2204-3.096 1.7198-2.76 2.3191-7.1386 2.3191-7.1386l1.8826-.8923c.1179-.0589.0872-.2623-.0565-.2623H21.246c-.318-.4955-1.4194-1.5497-3.0422-1.5497-.9628 0-1.8062.2715-2.5615.7637 0 0-1.1015.7503-2.7035 2.1282l-4.904 4.0797c-.3776.3155-.84.5205-1.4791.5205H.3858c-.1743 0-.1162.146-.088.2307.435 1.3256 1.5962 2.5085 3.6232 2.5085l-1.4476 1.4916c-.0573.0564-.0573.2258.0863.2258h5.5049c3.9784 0 6.4246-1.7415 8.0324-4.1545.1378-.2067.2673-.4266.3901-.6391.0606.0282.0664.0863.0381.1428-.4059.9794-1.4194 2.965-3.2737 4.1452-.6392.3736-.8417.489-1.7398.8334-.0614.0266-.0863.1245-.0581.2092l2.2279 6.2295h1.216l-2.042-5.7771h.0557z",source:"https://www.auchan.fr/",hex:"D6180B",guidelines:void 0,license:void 0},siAtom={title:"Atom",slug:"atom",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Atom</title><path d="'+this.path+'"/></svg>'},path:"M20.489 9.025c-2.183-.93-5.116-1.53-8.25-1.695-.5-.03-.987-.04-1.45-.04 2.318-2.83 4.802-4.73 6.437-4.79.322-.013.595.055.813.196.706.458.905 1.768.545 3.59-.04.25.12.493.36.54.25.05.49-.11.54-.36.45-2.28.12-3.846-.94-4.538-.38-.248-.84-.365-1.35-.346-2.05.077-4.94 2.3-7.59 5.72-1.154.035-2.24.13-3.232.287-.646-2.897-.39-4.977.594-5.477.138-.073.285-.11.457-.124.697-.054 1.66.395 2.71 1.27.194.16.486.14.646-.06a.458.458 0 00-.06-.645C9.459 1.51 8.297 1 7.347 1.07a2.244 2.244 0 00-.803.22c-1.19.607-1.67 2.327-1.37 4.838.07.52.16 1.062.29 1.62-3.281.656-5.371 1.97-5.461 3.624-.06 1.17.865 2.284 2.68 3.222a.46.46 0 10.42-.816C1.653 13.031.873 12.19.92 11.42c.05-1.08 1.772-2.19 4.76-2.78.27.994.62 2.032 1.05 3.09-1.018 1.888-1.756 3.747-2.137 5.4-.56 2.465-.26 4.22.86 4.948.36.234.78.35 1.247.35.935 0 2.067-.46 3.347-1.372a.458.458 0 10-.53-.746c-1.544 1.103-2.844 1.472-3.562 1.003-.76-.495-.926-1.943-.46-3.976.32-1.386.907-2.93 1.708-4.52.2.438.41.876.63 1.313 1.425 2.796 3.17 5.227 4.91 6.845 1.386 1.29 2.674 1.963 3.735 1.963.35 0 .68-.075.976-.223 1.145-.585 1.64-2.21 1.398-4.575-.224-2.213-1.06-4.91-2.354-7.6a.46.46 0 00-.83.396c2.69 5.602 2.88 10.19 1.37 10.96-1.59.813-5.424-2.355-8.39-8.18-.34-.655-.637-1.3-.9-1.93.34-.608.7-1.22 1.095-1.83.395-.604.806-1.188 1.224-1.745h.394c.54 0 1.126.01 1.734.048 6.53.343 10.975 2.56 10.884 4.334-.04.765-.924 1.538-2.425 2.12a.464.464 0 00-.26.596.455.455 0 00.593.262c1.905-.74 2.95-1.756 3.01-2.93.07-1.33-1.17-2.61-3.5-3.6v-.01zM8.073 9.45c-.27.415-.52.827-.764 1.244a23.66 23.66 0 01-.723-2.215c.713-.11 1.485-.19 2.31-.24-.28.39-.554.794-.82 1.21v-.01zm3.925 1.175a1.375 1.375 0 100 2.75 1.375 1.375 0 100-2.75z",source:"https://commons.wikimedia.org/wiki/File:Atom_editor_logo.svg",hex:"66595C",guidelines:void 0,license:void 0},siAudacity={title:"Audacity",slug:"audacity",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Audacity</title><path d="'+this.path+'"/></svg>'},path:"M12 2.145c-2.487 0-4.755.776-6.428 2.08-1.673 1.303-2.76 3.169-2.76 5.244v.75C1.153 11.06 0 13.268 0 15.856c0 3.312 1.884 6 4.312 6V9.468c0-1.554.805-2.984 2.186-4.06C7.879 4.331 9.829 3.643 12 3.643c2.17 0 4.12.688 5.502 1.764 1.38 1.077 2.186 2.507 2.186 4.06v12.387c2.428 0 4.312-2.687 4.312-6 0-2.587-1.152-4.795-2.813-5.636v-.75c0-2.075-1.086-3.94-2.76-5.244-1.672-1.304-3.94-2.08-6.427-2.08zm0 6.153l-1.125 8.683L9.75 9.105l-.562 6.75-.376-.75-.375-4.5-.187 4.5-.563 1.313-.374-4.5-.376 3.562-.562-.937v2.625l-.563-2.11v-4.64a1.432 1.432 0 0 0-.937-.375v11.812c.375 0 .75-.187.937-.562v-3.375l.188.187.563 1.875.187-2.25.563 2.813v-3.562l.374.937.563 2.625v-3.562l.375.374.563 3.188.562-4.313 1.24 4.86.072-2.985.375-1.124.376 4.687 1.124-4.687.375 3.937.938-4.125.938 4.5.187-3.375.562-1.125.188 4.313.938-4.125.562 1.875.188-1.688.374.75v3.375c.188.375.563.562.938.562V10.043c-.375 0-.75.188-.938.375v4.813l-.374 1-.188-3.188-.375 2.437-.375-.75-.188-2.625-.937 3.563-.188-.75L15 9.293l-.562 4.875-.376 1.5-.75-5.062-.75 4.312-.375 1.125Z",source:"https://github.com/audacity/audacity/blob/c818449c69193f5311b430fbf600d8d6cbe49047/images/audacity.svg",hex:"0000CC",guidelines:void 0,license:void 0},siAudi={title:"Audi",slug:"audi",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Audi</title><path d="'+this.path+'"/></svg>'},path:"M19.848,7.848c-0.992,0-1.902,0.348-2.616,0.928c-0.714-0.58-1.624-0.928-2.616-0.928 c-0.992,0-1.902,0.348-2.616,0.928c-0.714-0.58-1.624-0.928-2.616-0.928c-0.992,0-1.902,0.348-2.616,0.928 c-0.714-0.58-1.624-0.928-2.616-0.928C1.859,7.848,0,9.707,0,12s1.859,4.152,4.152,4.152c0.992,0,1.902-0.348,2.616-0.928 c0.714,0.58,1.624,0.928,2.616,0.928c0.992,0,1.902-0.348,2.616-0.928c0.714,0.58,1.624,0.928,2.616,0.928 c0.992,0,1.902-0.348,2.616-0.928c0.714,0.58,1.624,0.928,2.616,0.928C22.141,16.152,24,14.293,24,12S22.141,7.848,19.848,7.848z M17.232,13.866c-0.376-0.526-0.598-1.17-0.598-1.866c0-0.696,0.222-1.34,0.598-1.866c0.376,0.526,0.598,1.17,0.598,1.866 C17.83,12.696,17.608,13.34,17.232,13.866z M12,13.866c-0.376-0.526-0.598-1.17-0.598-1.866c0-0.696,0.222-1.34,0.598-1.866 c0.376,0.526,0.598,1.17,0.598,1.866C12.598,12.696,12.376,13.34,12,13.866z M6.768,13.866C6.392,13.34,6.17,12.696,6.17,12 c0-0.696,0.222-1.34,0.598-1.866C7.144,10.66,7.366,11.304,7.366,12C7.366,12.696,7.144,13.34,6.768,13.866z M0.938,12 c0-1.775,1.439-3.214,3.214-3.214c0.736,0,1.414,0.248,1.956,0.665C5.56,10.154,5.232,11.039,5.232,12 c0,0.961,0.328,1.846,0.876,2.549c-0.542,0.416-1.22,0.665-1.956,0.665C2.377,15.214,0.938,13.775,0.938,12z M7.428,14.549 C7.976,13.846,8.304,12.961,8.304,12c0-0.961-0.328-1.846-0.876-2.549c0.542-0.416,1.22-0.665,1.956-0.665 c0.736,0,1.414,0.248,1.956,0.665c-0.549,0.704-0.876,1.588-0.876,2.549c0,0.961,0.328,1.846,0.876,2.549 c-0.542,0.416-1.22,0.665-1.956,0.665C8.648,15.214,7.97,14.966,7.428,14.549z M12.66,14.549c0.549-0.704,0.876-1.588,0.876-2.549 c0-0.961-0.328-1.846-0.876-2.55c0.542-0.416,1.22-0.665,1.956-0.665s1.414,0.248,1.956,0.665 c-0.549,0.704-0.876,1.588-0.876,2.549c0,0.961,0.328,1.846,0.876,2.549c-0.542,0.416-1.22,0.665-1.956,0.665 C13.88,15.214,13.202,14.966,12.66,14.549z M19.848,15.214c-0.736,0-1.414-0.248-1.956-0.665c0.548-0.704,0.876-1.588,0.876-2.549 c0-0.961-0.328-1.846-0.876-2.549c0.542-0.416,1.22-0.665,1.956-0.665c1.775,0,3.214,1.439,3.214,3.214 S21.623,15.214,19.848,15.214z",source:"https://www.audi.com/ci/en/intro/basics/rings.html",hex:"BB0A30",guidelines:void 0,license:void 0},siAudible={title:"Audible",slug:"audible",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Audible</title><path d="'+this.path+'"/></svg>'},path:"M12.008 17.362L24 9.885v2.028l-11.992 7.509L0 11.912V9.886l12.008 7.477zm0-9.378c-2.709 0-5.085 1.363-6.448 3.47.111-.111.175-.175.286-.254 3.374-2.804 8.237-2.17 10.883 1.362l1.758-1.124c-1.394-2.044-3.786-3.454-6.48-3.454m0 3.47a4.392 4.392 0 0 0-3.548 1.821 3.597 3.597 0 0 1 2.139-.697c1.299 0 2.455.666 3.232 1.79l1.679-1.045c-.729-1.157-2.028-1.87-3.501-1.87M3.897 8.412c4.943-3.897 11.929-2.836 15.652 2.344l.031.032 1.822-1.125a11.214 11.214 0 0 0-9.394-5.085c-3.897 0-7.366 1.996-9.394 5.085.364-.412.824-.903 1.283-1.251",source:"https://commons.wikimedia.org/wiki/File:Audible_logo.svg",hex:"F8991C",guidelines:void 0,license:void 0},siAudioboom={title:"Audioboom",slug:"audioboom",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Audioboom</title><path d="'+this.path+'"/></svg>'},path:"M12 24C5.373 24 0 18.627 0 12S5.373 0 12 0s12 5.373 12 12-5.373 12-12 12zM7.425 3.214c-.621 0-1.125.503-1.125 1.124v6a1.124 1.124 0 0 0 2.25 0v-6c0-.62-.504-1.124-1.125-1.124zm0 9.314c-.621 0-1.125.503-1.125 1.125v6a1.124 1.124 0 0 0 2.25 0v-6c0-.622-.504-1.125-1.125-1.125zm4.152-6.856c-.621 0-1.125.504-1.125 1.125v10.388a1.124 1.124 0 0 0 2.25 0V6.797c0-.621-.504-1.125-1.125-1.125zm4.151 6.856c-.62 0-1.124.503-1.124 1.125v1.056a1.124 1.124 0 1 0 2.249 0v-1.056c0-.622-.504-1.125-1.125-1.125zm0-4.37c-.62 0-1.124.503-1.124 1.124v1.056a1.124 1.124 0 0 0 2.249 0V9.282c0-.62-.504-1.124-1.125-1.124zm4.152 2.422c-.62 0-1.124.503-1.124 1.124v.574a1.124 1.124 0 1 0 2.249 0v-.574c0-.62-.504-1.124-1.125-1.124Z",source:"https://audioboom.com/about/brand-guidelines",hex:"007CE2",guidelines:void 0,license:void 0},siAudiomack={title:"Audiomack",slug:"audiomack",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Audiomack</title><path d="'+this.path+'"/></svg>'},path:"M.331 11.378s.5418-.089.765.1439c.2234.2332.077.7156-.2195.7237-.2965.01-.5705.063-.765-.1439-.1946-.2066-.1424-.6218.2195-.7237m5.881 3.2925c-.0522.01-.1075-.018-.164-.059-.3884-.5413-.5287-2.3923-.707-2.5025-.185-.1144-.8545 1.0255-2.1862.903-.5569-.051-1.1236-.4121-1.4573-.662.031-.4206.0364-1.4027.8659-1.0833.5038.1939 1.3667.7266 2.1245-.23.8378-1.0579 1.2999-.7506 1.577-.5206.2771.23.0925 1.4259.5058 1.0916.4133-.3343 2.082-2.4103 2.082-2.4103s1.292-1.303 1.4898.067c.1979 1.3698 1.0403 2.8877 1.2635 2.8445.2234-.043 2.8223-5.3253 3.1945-5.666.3722-.3409 1.6252-.2961 1.5657.5781-.0596.8742-.1871 6.308-.1871 6.308s-.147 1.5311.0924.7128c.0992-.3392.206-.6453.3392-1.0024.6414-2.0534 1.734-5.5613 2.2784-7.3688.1252-.4325.233-.8037.3166-1.0891l.0001-.0008a3.5925 3.5925 0 0 1 .0973-.3305c.0455-.1532.0763-.2546.0858-.2813.0243-.068.0925-.1192.1884-.157.0962-.061.1995-.064.3165-.067.3021-.027.6907.012 1.0401.1119.1018 0 .2125.037.3172.1118v.0001s.0063 0 .0151.01c.0023 0 .0048 0 .0073.01.0219.015.0573.045.0983.095.0012 0 .0025 0 .004.01.017.021.0341.045.0515.073.1952.2863.315.814.1948 1.7498-.2996 2.3354-.5316 7.1397-.5316 7.1397s-.0461.2298.4353-.782c.0167-.035.0383-.066.058-.098.026-.017.0552-.042.0913-.085.2974-.3546 1.0968-.5629 1.6512-.5586.2336.028.4293.087.5462.1609.2188.333.0897 1.562.0897 1.562-.4612.043-1.3403.2908-1.6519.3366-.3118.046-.7852 2.0699-1.4433 1.8629-.6581-.2069-2.1246-1.1268-2.1246-1.2533 0-.1102.1152-1.4546.1453-1.8016.0022-.024.004-.046.0058-.068a.152.152 0 0 1 .0014-.014l-.0002.0003c.0213-.2733.0023-.3927-.1239-.1199-.1086.2346-.581 1.7359-1.1078 3.3709-.0556.1429-1.0511 3.1558-1.1818 3.5231-.156.4261-.287.7523-.3776.921-.1378.1867-.3234.3036-.5826.2252-.6465-.1954-1.4654-1.0889-1.473-1.3106-.0155-1.2503.0608-7.973-.2423-7.4127-.311.5744-2.73 4.5608-2.73 4.5608-.0405.01-.0705.01-.1062.01-.1712-.019-.4366-.074-.51-.2384-.004-.01-.0094-.018-.0129-.028-.0035-.01-.0075-.022-.0135-.04-.0329-.1097-.0463-.2289-.0753-.3265-.1082-.3652-.2813-.8886-.463-1.421-.2784-.9079-.5654-1.8366-.6127-1.9391-.0923-.2007-.2268-.116-.3475-.0002-.54.458-1.6868 2.4793-2.7225 2.5898",source:"https://styleguide.audiomack.com/",hex:"FFA200",guidelines:void 0,license:void 0},siAurelia={title:"Aurelia",slug:"aurelia",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Aurelia</title><path d="'+this.path+'"/></svg>'},path:"M15.716 4.636L13.49 6.122l-2.295-3.439 2.228-1.486zM17.527 14.967l3.806 5.703-4.533 3.025-3.806-5.703-.664-.995 4.533-3.025zM11.817 18.777l.838 1.256-3.45 2.303-1.503-2.25.754-.504 2.697-1.8zM19.413 12.27l.968-.645 1.501 2.25-2.227 1.487-.838-1.256 1.26-.84zm-.596 1.836l-.664-.995 1.26-.84.664.994zM3.792 12.593l-.753.503L.744 9.657l3.45-2.302 1.61 2.41-2.698 1.8 2.697-1.8.686 1.029zM11.513 5.954l.687 1.029-4.534 3.025L6.98 8.98 3.21 3.33 7.742.305zM14.749 5.282l-1.26.84-.686-1.028-1.609-2.41 2.228-1.487 2.295 3.439zM9.12 20.577l-.664-.995 2.697-1.8.664.995zM18.817 14.106l-.664-.995 1.26-.84.664.994zM3.792 12.593l-.686-1.028 2.697-1.8.686 1.029zM13.489 6.122l-.686-1.028 1.26-.84.686 1.028zM17.527 14.967l-4.533 3.025-.664-.995 4.533-3.025zM11.513 5.954l.687 1.029-4.534 3.025L6.98 8.98zM2.507 5.132l.855 1.283-1.282.855-.856-1.282zM7.127 20.505l.856 1.283-1.282.855-.856-1.282zM3.754 21.797L0 16.125 20.063 2.706 24 8.287z",source:"https://aurelia.io/",hex:"ED2B88",guidelines:void 0,license:void 0},siAudiotechnica={title:"Audio-Technica",slug:"audiotechnica",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Audio-Technica</title><path d="'+this.path+'"/></svg>'},path:"M12 0A11.992 11.992 0 00.015 11.985 12.019 12.019 0 0012 24a12.019 12.019 0 0011.985-12.015A11.992 11.992 0 0012.004 0zm0 .903a11.078 11.078 0 0111.085 11.078c0 6.123-4.958 11.112-11.085 11.112A11.104 11.104 0 01.922 11.985 11.078 11.078 0 0111.996.907zm.087 1.16l-.43 1.252-5.674 16.063-.204.604h12.654l-.23-.604L12.524 3.31zm0 2.797l2.007 5.643-3.024 8.553H7.056zm2.502 7.038l2.532 7.155h-5.09z",source:"https://wikipedia.org/wiki/File:Audio-technica.svg",hex:"000000",guidelines:void 0,license:void 0},siAuth0={title:"Auth0",slug:"auth0",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Auth0</title><path d="'+this.path+'"/></svg>'},path:"M21.98 7.448L19.62 0H4.347L2.02 7.448c-1.352 4.312.03 9.206 3.815 12.015L12.007 24l6.157-4.552c3.755-2.81 5.182-7.688 3.815-12.015l-6.16 4.58 2.343 7.45-6.157-4.597-6.158 4.58 2.358-7.433-6.188-4.55 7.63-.045L12.008 0l2.356 7.404 7.615.044z",source:"https://styleguide.auth0.com",hex:"EB5424",guidelines:void 0,license:void 0},siAutomattic={title:"Automattic",slug:"automattic",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Automattic</title><path d="'+this.path+'"/></svg>'},path:"M14.521 8.11a1.497 1.497 0 01.433 2.102l-3.511 5.441a1.496 1.496 0 01-2.068.457 1.507 1.507 0 01-.44-2.08l3.513-5.44c.215-.335.554-.57.943-.655.39-.085.796-.04 1.13.175z M11.98 23.03C4.713 23.03 0 17.79 0 12.338v-.676C0 6.117 4.713.97 11.98.97 19.246.97 24 6.117 24 11.662v.676c0 5.453-4.713 10.692-12.02 10.692zm8.133-11.31c0-3.974-2.888-7.51-8.133-7.51-5.245 0-8.087 3.542-8.087 7.51v.497c0 3.974 2.888 7.578 8.087 7.578 5.198 0 8.133-3.604 8.133-7.578v-.497z",source:"https://automattic.com/press/brand-materials/",hex:"3499CD",guidelines:void 0,license:void 0},siAuthy={title:"Authy",slug:"authy",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Authy</title><path d="'+this.path+'"/></svg>'},path:"M12 0A12 12 0 0 0 0 12a12 12 0 0 0 12 12 12 12 0 0 0 12-12A12 12 0 0 0 12 0zm3.42 5.338c.274 0 .551.105.769.315l2.862 2.862c2.054 2.039 2.084 5.35.105 7.449a.21.21 0 0 1-.045.06l-.03.03-.03.03c-.015.015-.045.03-.06.045-2.098 1.978-5.41 1.948-7.463-.105l-2.863-2.863a1.05 1.05 0 0 1 0-1.499 1.05 1.05 0 0 1 1.5 0l2.861 2.863a3.23 3.23 0 0 0 4.542.03 3.244 3.244 0 0 0-.03-4.541l-2.863-2.862a1.05 1.05 0 0 1 0-1.5c.203-.209.472-.314.746-.314zM8.758 6.397a5.33 5.33 0 0 1 3.715 1.564l2.863 2.862c.42.42.42 1.08 0 1.5-.42.419-1.08.419-1.5 0L10.975 9.46a3.249 3.249 0 0 0-4.558-.015 3.243 3.243 0 0 0 .03 4.54l2.863 2.863c.42.42.42 1.08 0 1.499a1.05 1.05 0 0 1-1.499 0L4.95 15.484c-2.054-2.053-2.084-5.365-.105-7.463.015-.03.03-.045.045-.06l.03-.03.03-.03c.015-.015.045-.03.06-.045a5.355 5.355 0 0 1 3.748-1.46z",source:"https://authy.com/",hex:"EC1C24",guidelines:void 0,license:void 0},siAutodesk={title:"Autodesk",slug:"autodesk",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Autodesk</title><path d="'+this.path+'"/></svg>'},path:"M6.898.437S7.87.534 8.26 1.505c0 0 1.069 2.526 2.04 4.955 1.42 3.33 3.22 7.615 4.67 11.078H1.167c-.778 0-1.166-.486-1.166-.486.777 1.36 3.012 5.636 3.012 5.636.388.486.777.776 1.36.776 1.264 0 3.208-1.262 3.208-1.262l7.409-4.619c1.412 3.372 2.5 5.98 2.5 5.98H24c.097-.097-9.327-22.446-9.424-22.544-.097-.097-.292-.582-.972-.582zm-.29.875c-.583 0-.778.485-.875.582L.39 14.526c-.291.874-.097 1.943 1.458 1.943h4.177l3.693-8.841A453.32 453.32 0 0 0 7.58 2.38c-.097-.291-.389-1.068-.972-1.068z",source:"https://www.autodesk.com",hex:"0696D7",guidelines:void 0,license:void 0},siAutohotkey={title:"AutoHotkey",slug:"autohotkey",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AutoHotkey</title><path d="'+this.path+'"/></svg>'},path:"M20.514.508V.51H1.803C1.053.51.079 1.135 0 2.27v17.133h.002v2.325c.08 1.136 1.05 1.763 1.8 1.763h1.505l.002-.002h18.869c1.256-.053 1.766-1.066 1.822-1.699v-3.023h-.002V2.209c-.056-.633-.567-1.648-1.824-1.701h-1.66zM3.412 1.623h17.154c.898 0 1.618.72 1.618 1.617v16.64c0 .898-.72 1.62-1.618 1.62H3.412a1.616 1.616 0 01-1.619-1.62V3.24c0-.897.722-1.617 1.62-1.617zm3.315 12.412l-1.895 5.037h.703l.526-1.467h2.02l.497 1.467h.744l-1.824-5.037h-.771zm8.43.008v5.037h.679v-1.767l.793-.758 1.76 2.525h.884l-2.154-3.002 2.098-2.035h-.94l-2.441 2.441v-2.441h-.68zm-5.153.027v5.037h.682v-2.351h2.628v2.351h.682V14.07h-.682v2.084h-2.628V14.07h-.682zm-2.926.717h.014l.742 2.217H6.271l.807-2.217z",source:"https://www.autohotkey.com/",hex:"334455",guidelines:void 0,license:void 0},siAutoprefixer={title:"Autoprefixer",slug:"autoprefixer",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Autoprefixer</title><path d="'+this.path+'"/></svg>'},path:"M5.87 21.045h2.923l.959-3.068h4.503l.949 3.068h2.922L11.94 2.955l-6.07 18.09zm6.162-10.12 1.543 4.917h-3.153l1.553-4.916h.057zM24 17.617l-.378-1.182-6.266-.59.733 2.127 5.91-.354zM6.644 15.843l-6.266.591L0 17.616l5.911.355.733-2.128z",source:"https://github.com/postcss/autoprefixer/blob/1341747bc8142a147342f55eea5ed4286a3ca318/logo.svg",hex:"DD3735",guidelines:void 0,license:void 0},siAwsamplify={title:"AWS Amplify",slug:"awsamplify",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AWS Amplify</title><path d="'+this.path+'"/></svg>'},path:"M5.223 17.905h6.76l1.731 3.047H0l4.815-8.344 2.018-3.494 1.733 3.002zm2.52-10.371L9.408 4.65l9.415 16.301h-3.334zm2.59-4.486h3.33L24 20.952h-3.334z",source:"https://docs.amplify.aws/",hex:"FF9900",guidelines:void 0,license:void 0},siAzureartifacts={title:"Azure Artifacts",slug:"azureartifacts",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Azure Artifacts</title><path d="'+this.path+'"/></svg>'},path:"M5.2 0c-.552 0-1 .43-1 .958V11.5h15.6V.958c0-.529-.448-.958-1-.958H5.2zm3.2 2.3h2.4c.331 0 .6.257.6.575a.588.588 0 0 1-.6.575H8.4a.588.588 0 0 1-.6-.575c0-.318.269-.575.6-.575zM1.064 12C.476 12 0 12.448 0 13v10c0 .552.476 1 1.064 1H8.8a1 1 0 0 1-1-1v-8h-3a.6.6 0 1 1 0-1.201h3V12H1.064z M23 12H8.299v11c0 .552.477 1 1.064 1H23a1 1 0 0 0 1-1V13a1 1 0 0 0-1-1zm-9.8 10.2H9.6V21h3.6v1.2zm2.4-1.8h-6v-1.2h6v1.2zM15 15h-2.4a.6.6 0 0 1 0-1.201H15A.602.602 0 0 1 15 15z",source:"https://azure.microsoft.com/en-us/services/devops/artifacts/",hex:"CB2E6D",guidelines:void 0,license:void 0},siAvast={title:"Avast",slug:"avast",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Avast</title><path d="'+this.path+'"/></svg>'},path:"M10.2941 2.991a3.0286 3.0286 0 0 1 4.4499 1.2039l7.0018 14.8042a11.937 11.937 0 0 0 2.2539-6.9131C24.0464 5.4569 18.7112.047 12.0834.0004 5.4556-.0463.047 5.2889.0004 11.9167a11.9356 11.9356 0 0 0 2.2213 7.0344l.2813-.0613 4.5692-1.008c.1287-.0286.1967.1454.084.2127L3.3736 20.337a11.9563 11.9563 0 0 0 8.5431 3.6625c3.76.0267 7.1258-1.68 9.3444-4.3705L9.8095 7.5735a3.0272 3.0272 0 0 1 .4846-4.5826zm2.1493 13.6089-7.3731.64a1.302 1.302 0 1 1 .1866-2.5666l7.2031 1.6972c.1287.0314.114.2174-.0166.2294zM9.03 10.116l8.9404 7.2324c.102.0827.01.2447-.1133.198L7.1035 13.4713a1.9593 1.9593 0 1 1 1.9266-3.3552z",source:"https://www.avast.com/",hex:"FF7800",guidelines:"https://press.avast.com/media-materials",license:void 0},siAwesomelists={title:"Awesome Lists",slug:"awesomelists",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Awesome Lists</title><path d="'+this.path+'"/></svg>'},path:"M24 11.438l-6.154-5.645-.865.944 5.128 4.7H1.895l5.128-4.705-.865-.943-6.154 5.649H0v3.72c0 1.683 1.62 3.053 3.61 3.053h3.795c1.99 0 3.61-1.37 3.61-3.051v-2.446h1.97v2.446c0 1.68 1.62 3.051 3.61 3.051h3.794c1.99 0 3.61-1.37 3.61-3.051v-3.721z",source:"https://github.com/sindresorhus/awesome/tree/master/media",hex:"FC60A8",guidelines:void 0,license:void 0},siAwesomewm={title:"awesomeWM",slug:"awesomewm",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>awesomeWM</title><path d="'+this.path+'"/></svg>'},path:"M0 24V8.25h16.5V7.5H0V0h24v24h-7.5v-8.25h-9v.75h8.25V24z",source:"https://awesomewm.org/",hex:"535D6C",guidelines:void 0,license:void 0},siAzurepipelines={title:"Azure Pipelines",slug:"azurepipelines",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Azure Pipelines</title><path d="'+this.path+'"/></svg>'},path:"M1.7997 22.1998h4.2001V24H.0004v-6.0002h1.7993v4.2zM12.6229 9.8975l-7.6353 7.6353 1.4792 1.4792 7.6345-7.6362-1.4784-1.4783zM4.365 15.1793l-.391-.3908c-.5042-.5042-.5828-1.3004-.1869-1.8934l4.6036-6.8958H.9979c-.5513.0014-.9975.4487-.9975 1v5.5002l3.5021 3.6036.8625-.9238zM23.9996.9999v8.9306a2 2 0 0 1-.8893 1.6632l-12.2834 8.2005a.9999.9999 0 0 1-1.2622-.1246L8.04 18.1457c.3313-.3313 6.4656-6.4672 6.7684-6.7698l-2.1855-2.1855L5.8533 15.96l-1.5258-1.525a1.0001 1.0001 0 0 1-.1246-1.2623L12.4034.8893A2 2 0 0 1 14.0666 0h8.9331c.5522 0 .9999.4477.9999.9999zm-2.9997 5.0003c0-1.6567-1.343-2.9997-2.9997-2.9997s-2.9997 1.343-2.9997 2.9997 1.343 2.9997 2.9997 2.9997 2.9997-1.343 2.9997-2.9997zM10.272 20.4625c-.4008 0-.7776-.156-1.0609-.4392l-.368-.3679-.8435.8417 3.4996 3.4996h5.5003c.5522 0 .9999-.4477.9999-.9999v-7.3899L11.1045 20.21a1.4944 1.4944 0 0 1-.8325.2525z",source:"https://github.com/vscode-icons/vscode-icons/blob/dc7872262c9b059c574bd16fc4cfedbb6bdf156e/icons/file_type_azurepipelines.svg",hex:"2560E0",guidelines:void 0,license:void 0},siBandrautomation={title:"B&R Automation",slug:"bandrautomation",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>B&amp;R Automation</title><path d="'+this.path+'"/></svg>'},path:"M22.637 5.186H1.363C.613 5.186 0 5.799 0 6.548v10.903c0 .75.614 1.363 1.363 1.363h21.274c.75 0 1.363-.613 1.363-1.363V6.548c0-.75-.614-1.362-1.363-1.362zm1.039 12.265a1.04 1.04 0 0 1-1.039 1.04H1.363a1.04 1.04 0 0 1-1.039-1.04V6.548A1.04 1.04 0 0 1 1.363 5.51h21.274a1.04 1.04 0 0 1 1.039 1.038v10.903zm-.685-5.491c-.116-.267-.418-.332-.682-.307A1.51 1.51 0 0 0 23 10.644c.052-.285.044-.577.039-.865-.011-1.021.004-2.116.004-3.07a.576.576 0 0 0-.568-.568c-2.257-.017-4.51.04-6.767-.02-.351-.022-.747.153-.77.55-.008 3.418.009 7.184-.004 10.557-.099.744.966.797.917.055v-4.11a1.56 1.56 0 0 1 .693-1.005c.963-.638 2.305.011 2.305 1.188 0 1.273.006 3.934.006 4.028 0 .223.169.425.39.452.31.003 2.496 0 3.257 0 .309 0 .541-.273.541-.568v-2.062l-.001-2.635c0-.199.033-.424-.052-.611zm-.873-2.041c0 .845-.733 1.484-1.579 1.49-.843.006-1.577-.547-1.577-1.49V8.57c0-.939.678-1.577 1.577-1.577.901 0 1.579.71 1.579 1.577v1.35zM8.939 15.403V13.13c.003-.59-.334-1.172-.821-1.485.495-.31.85-.859.821-1.457-.006-1.166.011-2.33-.006-3.496a.566.566 0 0 0-.57-.55c-2.283.012-4.566 0-6.851 0a.556.556 0 0 0-.55.53C.943 10.206.95 13.75.958 17.286c.002.288.249.559.554.552 2.175 0 4.675-.014 6.84-.002a.573.573 0 0 0 .585-.581c.01-.616-.003-1.236.002-1.853zm-.893.124c0 .832-.66 1.463-1.48 1.468-.82.006-1.59-.52-1.59-1.45v-1.98c0-1.053.717-1.573 1.59-1.573.876 0 1.48.698 1.48 1.554v1.981zm.028-5.74c-.028.853-.728 1.428-1.511 1.473-.856.05-1.583-.586-1.583-1.478V8.511c0-.929.707-1.554 1.583-1.554s1.511.701 1.511 1.56v1.27zm6.154 4.312c-.103-.052-.228-.036-.342-.035.002-.174-.004-.345.001-.518.007-.158.027-.355-.127-.454a.315.315 0 0 0-.159-.048c-.133-.004-.266.082-.293.22v.828a81.76 81.76 0 0 0-1.043-.007c-.319-.004-.414-.256-.419-.533.013-.341-.049-.702.044-1.036.064-.198.237-.266.433-.266h1.073c.16 0 .29-.132.29-.292a.295.295 0 0 0-.303-.289h-3.137c-.157 0-.321-.02-.443.1-.078.08-.097.18-.103.286-.004.688 0 1.38.005 2.067.02.135.136.238.275.238a.284.284 0 0 0-.27.211c-.023.918.003 1.844-.006 2.763 0 .142-.009.296.099.404.104.102.246.101.38.101 1.062.002 2.12-.019 3.181.013.231 0 .522-.067.522-.354v-2.853h.204c.294.003.397-.411.138-.546zm-.896 2.722c0 .18-.147.326-.326.326h-.74c-.256 0-.42-.232-.42-.416v-1.407c0-.292.097-.668.464-.668h1.022v2.165z",source:"https://www.br-automation.com/",hex:"FF8800",guidelines:void 0,license:void 0},siBabel={title:"Babel",slug:"babel",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Babel</title><path d="'+this.path+'"/></svg>'},path:"M15.76 0c-1.603.147-3.719.713-6.317 1.719a22.366 22.366 0 01-2.44 1.539l.01.158c.064 0 .136-.043.24-.096.106-.01.169.032.169.137l.168-.094.084-.011.01.074c.01.073-.566.523-1.707 1.33l.093.146-.084.012-.177-.064c0 .052-.073.085-.24.095l.01.084.189.21a.673.673 0 01-.252-.053c-.367.031-.734.303-1.09.806l.094.147c.314-.283.492-.43.544-.43l.022.23c-.052 0-.136.042-.24.094l.199.295A5.86 5.86 0 016.29 5.291c.23.063.346.125.346.209l.168-.01c1.225-.911 2.44-1.562 3.644-1.97l.012.158c-.22.335-.377.501-.461.511.01.116.052.21.115.305.021.21-.524 1.583-1.635 4.139-2.535 5.93-4.651 10.307-6.359 13.156 0 .052.041.136.094.23.419-.104.691-.197.806-.302l.096-.012.01.158.158-.011.166-.094c0 .052.063.073.168.062l.012.159c.01.157-.075.397-.274.722-.178.2-.355.607-.554 1.225l.01.074.158-.01c.68-.764 1.204-1.52 1.56-2.254 2.001-.586 3.52-1.162 4.578-1.728 1.058-.094 1.876-.365 2.42-.826l-.011-.084-.399.115-.094.01-.01-.084c.776-.116 1.32-.293 1.614-.524 1.519-1.173 2.66-2 3.435-2.492 2.4-1.76 3.531-3.457 3.395-5.07-.01-.168-.545-.828-1.582-1.98-.021-.22.345-.535 1.078-.954l2.086-1.834c.46-.597.744-1.56.838-2.89l-.031-.315c-.084-.932-.756-1.687-2.034-2.264C19.06.303 17.708.031 15.76 0zm2.525 1.037c1.55.063 2.347.335 2.389.817l-.063.158-2.326-.975zm-1.482 1.317c1.063-.016 1.617.267 1.672.863l.156-.012-.031-.398.168-.01c.408.22.627.492.648.816.021.22-.094.494-.355.819-.105.01-.168-.064-.178-.221l-.168.012-.041.47c-.702 1.048-1.205 1.582-1.52 1.614-.283.387-.462.587-.535.597-.22.262-.816.712-1.8 1.34-.325.032-1.531.493-3.616 1.404a.595.595 0 00-.334-.052l-.012-.147c-.02-.304.107-.681.41-1.142.158-.86.335-1.352.534-1.467l1.738-3.906c-.02-.241.347-.43 1.111-.555l.252-.022.02.221a50.387 50.387 0 011.394-.2c.173-.014.335-.022.487-.024zm3.619.39h.027c.139.012.288.263.446.744l.01.147c-.085.01-.24-.242-.471-.744l-.012-.147zm-9.836 2.483h.072l.022.23c-.074.01-.177.116-.303.336l-.012-.156c.147-.178.22-.316.22-.41zM5.6 5.354l.01.072c-.053 0-.136.043-.24.095l-.085.01-.01-.146.325-.031zM9.885 6.86l.031.315-.084.01-.031-.313.084-.012zm-.2.567c-.02.262-.084.397-.22.408l-.084.01c.094-.178.147-.303.137-.397l.168-.021zm-.345.816l.01.074-.147.25-.158.012-.01-.074c.157-.01.231-.093.22-.25l.085-.012zm-.358.735l-.04.386-.085.01-.03-.387.155-.01zm8.497.28l.345.212c.01.104-.042.167-.146.177-.147-.094-.262-.136-.346-.136l-.021-.23.168-.022zm-6.653.891l.012.147-.326.033-.01-.148.324-.032zm5.363.545c.23.105.347.21.358.293l.01.075c-.22.02-.42-.095-.608-.346l.24-.022zm2.6.252c.178.074.261.148.272.221l.052.617c-.073.168-.146.252-.23.252l-.094-1.09zm-4.195.065c.84-.014 1.482.184 1.922.605l.03.315c-.376 1.09-.795 1.719-1.245 1.918l-2.096 1.666c-1.56 1.026-2.4 1.538-2.525 1.548-2.483 1.373-4.032 2.075-4.63 2.127l-.095.01c.084-.293 1.185-2.555 3.322-6.808.943-.084 2.43-.525 4.452-1.32l.492-.042c.128-.01.253-.017.373-.02zm-3.055.49l.01.074-.334.031-.012-.074.336-.031zm-5.226 5.07c-.105.535-.221.808-.336.819l-.01-.075c-.021-.272.094-.513.346-.744zm7.101.336l.01.147c.01.063-.23.261-.701.607-1.394.681-2.21 1.152-2.452 1.393-1.508.523-2.252.849-2.242.974-1.34.535-2.22.923-2.638 1.164-.095.01-.241-.031-.43-.115-.021-.272.093-.494.365-.672.23-.02.463.011.672.106.251-.126.68-.274 1.299-.42l-.012-.156-.492.04c.063-.083.535-.303 1.436-.67l.251-.02.01.073c-.419.032-.66.167-.713.387.01.094.064.147.168.137.304-.21.461-.324.461-.356.608-.115 2.274-.995 5.008-2.619zm-7.584.723l.01.072c.01.105-.042.17-.147.18l-.01-.074c-.01-.095.042-.157.147-.178zm3.77.937c.089-.002.139.049.148.131-.199.021-.566.178-1.121.492l-.084.01-.01-.156a1.586 1.586 0 001.026-.47c.014-.003.028-.006.04-.007zm-3.664 1.243l.01.082c-.064 0-.138.043-.243.095l-.156.01c-.01-.073.032-.136.137-.168l.252-.02zm-1.918.953l.177.072c-.063.471-.198.713-.44.734a1.076 1.076 0 00-.513-.105l-.021-.23c-.01-.095.043-.147.158-.178.105-.01.167.061.178.218.282-.345.44-.511.46-.511Z",source:"https://github.com/babel/website/blob/93330158b6ecca1ab88d3be8dbf661f5c2da6c76/website/static/img/babel-black.svg",hex:"F9DC3E",guidelines:void 0,license:void 0},siBackbonedotjs={title:"Backbone.js",slug:"backbonedotjs",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Backbone.js</title><path d="'+this.path+'"/></svg>'},path:"M2.34 0v10.45l3.2-1.83V5.27l2.93 1.67 3.01-1.72L2.34 0zm19.31 0L12.5 5.22l3.02 1.73 2.94-1.68v3.35l3.2 1.83V0h-.01zm-9.9 5.64-9.4 5.38V24l9.4-5.36v-3.76l-6.21 3.56v-5.5l6.21-3.54V5.64zm.5 0V9.4l6.22 3.54v5.5l-6.22-3.56v3.76L21.66 24V11.02l-9.41-5.38zM7.7 12.3l-1.65.94v1.86l2.17 1.24 3.28-1.87-3.8-2.17zm8.61 0-3.8 2.16 3.28 1.88 2.17-1.24v-1.86l-1.65-.94z",source:"https://upload.wikimedia.org/wikipedia/commons/2/20/Backbone.js_logo.svg",hex:"0071B5",guidelines:void 0,license:{type:"MIT",url:"https://github.com/jashkenas/backbone/blob/master/LICENSE"}},siBadgr={title:"Badgr",slug:"badgr",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Badgr</title><path d="'+this.path+'"/></svg>'},path:"M22.84 11.134c-1.75-1.71-3.617-2.982-5.552-3.784a.287.287 0 0 0-.041-.024c-.662-.369-1.282-.893-1.51-1.15-.396-.443-1.229-1.056-1.67-1.154a.69.69 0 0 0-.154-.017c-.406 0-.86.324-1.433.734l-.346.245c-.198.136-.33.22-.421.272a1.487 1.487 0 0 1-.112.059 13.948 13.948 0 0 0-1.443.122c-1.59.217-3.463 1.34-4.83 2.16-.607.364-1.18.708-1.412.769l-.704.184V6.324L13.025.648l9.815 5.676v4.81zM12.195 6.436l.035-.024.035-.025a16.252 16.252 0 0 0 .274-.194l.176-.123a15.142 15.142 0 0 1 .523-.364c.27-.176.502-.295.675-.295a.32.32 0 0 1 .067.006c.182.04.494.228.795.451l.128.097a.708.708 0 0 0-.013.064 2.124 2.124 0 0 0-.01.097l-.002.05a.409.409 0 0 1-.027.138c-.012.032-.03.047-.045.047a.074.074 0 0 1-.031-.01c-.065-.035-.094-.154-.1-.193l-.016-.112-.1.05a2.424 2.424 0 0 0-.132.075l-.08.046a.61.61 0 0 1-.076.037.357.357 0 0 0-.027-.148.484.484 0 0 0-.032-.065.724.724 0 0 0-.163-.188l-.071-.057-.014-.01-.042.099c-.137.332-1.093.553-1.667.553l-.06-.002zM8.15 10.594a.35.35 0 0 0-.075-.11.202.202 0 0 0-.048-.006c-.008 0-.015 0-.023.002l.039-.025a.348.348 0 0 0-.212-.073c-.012 0-.024.003-.037.004a.625.625 0 0 1 .164-.086.463.463 0 0 1 .324.009.946.946 0 0 1 .075.028l.066.029c.165.066.46.23.46.23a.417.417 0 0 0-.083.021.742.742 0 0 0-.157.083c-.105.067-.212.153-.345.216a.616.616 0 0 1-.237.068.34.34 0 0 0 .089-.39zm7.581-.536a.736.736 0 0 1-.3-.09 1.325 1.325 0 0 1-.158-.089.44.44 0 0 0 .074-.06.622.622 0 0 0 .06-.069l.026-.037a.778.778 0 0 0 .097-.25l.005-.03a.324.324 0 0 1-.338.124l-.005-.002a.333.333 0 0 0 .013-.195.337.337 0 0 0-.034-.088.382.382 0 0 1-.118.122.387.387 0 0 1-.212.058.495.495 0 0 1-.097-.01c-.024-.004-.038-.009-.038-.009a.956.956 0 0 0 .02-.403 1.557 1.557 0 0 0-.038-.175l-.002-.01a.207.207 0 0 1-.014.026c-.073.114-.383.34-.723.52a2.696 2.696 0 0 1-.6.245.96.96 0 0 1-.212.032c-.053 0-.082-.01-.097-.027a.043.043 0 0 1-.01-.028.091.091 0 0 1 .01-.048.234.234 0 0 1 .016-.03l.017-.025.013-.016s.02-.034.06-.089a1.406 1.406 0 0 1 .123-.15 1.788 1.788 0 0 1 .83-.511 3.81 3.81 0 0 1 .712-.132 2.552 2.552 0 0 1 .183-.006c.224 0 .436.032.612.115.044.02.086.044.126.07a.741.741 0 0 1 .27.338 7.546 7.546 0 0 1 .229.66 4.921 4.921 0 0 1 .102.408c.028.139.045.269.046.378a.572.572 0 0 1-.018.172c-.025.097-.079.155-.17.155a.315.315 0 0 1-.068-.009c-.324-.08-.688-.507-.688-.507a.654.654 0 0 0 .219-.144.98.98 0 0 0 .101-.113c.041-.05.064-.088.064-.088a.21.21 0 0 1-.088.017zm.871.277c-.058-.463-.26-1.01-.376-1.297-.125-.308-.44-.676-1.232-.676-.367 0-.726.081-.962.148a2.138 2.138 0 0 0-.182.063 6.337 6.337 0 0 0-.764-.154c-.687-.1-1.78-.263-4.109.447-2.327.71-4.897 2.027-5.302 2.453-.405.425.04 1.033.405 1.297.364.264.749.71.89.345.142-.365.08-.446.608-.406.526.041 3.46.366 4.837.041 1.376-.324 2.753-.71 3.016-.993 0 0-.02.344-.122.527 0 0 .587-.081.79-.223 0 0-.02.243-.162.344 0 0 .344.122.607-.04 0 0-.223.202-.162.385.06.182.627.243 1.822.385 1.082.129 3.662 1.907 5.687 5.243l-.314.18.29-.167-.583.338c-.893-.539-2.133-1.284-3.197-1.924-1.924-1.156-5.061-2.393-7.814-2.494a103.93 103.93 0 0 1-4.309-.246c-.12-.02-.241-.04-.366-.058a34.442 34.442 0 0 1-1.635-.275c.584.05 1.262.091 1.781.072.21-.008.41-.017.604-.027.832-.04 1.488-.072 1.94.101a.126.126 0 0 0 .043.008.121.121 0 0 0 .043-.236c-.5-.19-1.178-.157-2.037-.116-.193.01-.393.02-.602.027-.792.029-1.891-.058-2.524-.123a8.86 8.86 0 0 1-.474-.058l-.062-.011-.101-.018-.01-.005a2.898 2.898 0 0 1-.398-.195c.07-.203.273-.793.398-1.263.07-.268.117-.496.099-.594a.628.628 0 0 0-.099-.214c-.152-.235-.433-.514-.561-.637l.561-.149.647-.17.808-.212c.84-.22 3.904-2.607 6.194-2.92.298-.04.625-.075.975-.099a.786.786 0 0 0 .193-.006c.202.002.517.013.913.044.623.058 1.257.153 1.57.202.267.043.712.14 1.2.254 1.061.28 2.176.714 3.123 1.39 2.458 1.752 3.866 3.04 3.947 3.223.078.176-4.053-.214-5.532-1.512zM13.026 23.35l-9.814-5.676v-3.852c.586.151 1.336.284 2.327.43l.02.004.02.003c2.744.413 3.976 1.07 4.064 1.117a14.603 14.603 0 0 1 4.944 5.167c.271.479.513.971.719 1.465l.008.019-2.287 1.323zM23.164 5.762L13.35.087a.648.648 0 0 0-.648 0L2.888 5.763a.648.648 0 0 0-.324.561v3.397l-.953.252c-.553.145-.89.387-1.031.74-.207.523.097 1.129.424 1.653.378.606.778.976 1.56 1.262v4.048a.65.65 0 0 0 .324.562l9.814 5.675a.646.646 0 0 0 .648 0l9.814-5.675a.648.648 0 0 0 .324-.562V6.324a.648.648 0 0 0-.324-.562Z",source:"https://info.badgr.com/",hex:"282C4C",guidelines:void 0,license:void 0},siBaidu={title:"Baidu",slug:"baidu",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Baidu</title><path d="'+this.path+'"/></svg>'},path:"M9.154 0C7.71 0 6.54 1.658 6.54 3.707c0 2.051 1.171 3.71 2.615 3.71 1.446 0 2.614-1.659 2.614-3.71C11.768 1.658 10.6 0 9.154 0zm7.025.594C14.86.58 13.347 2.589 13.2 3.927c-.187 1.745.25 3.487 2.179 3.735 1.933.25 3.175-1.806 3.422-3.364.252-1.555-.995-3.364-2.362-3.674a1.218 1.218 0 0 0-.261-.03zM3.582 5.535a2.811 2.811 0 0 0-.156.008c-2.118.19-2.428 3.24-2.428 3.24-.287 1.41.686 4.425 3.297 3.864 2.617-.561 2.262-3.68 2.183-4.362-.125-1.018-1.292-2.773-2.896-2.75zm16.534 1.753c-2.308 0-2.617 2.119-2.617 3.616 0 1.43.121 3.425 2.988 3.362 2.867-.063 2.553-3.238 2.553-3.988 0-.745-.62-2.99-2.924-2.99zm-8.264 2.478c-1.424.014-2.708.925-3.323 1.947-1.118 1.868-2.863 3.05-3.112 3.363-.25.309-3.61 2.116-2.864 5.42.746 3.301 3.365 3.237 3.365 3.237s1.93.19 4.171-.31c2.24-.495 4.17.123 4.17.123s5.233 1.748 6.665-1.616c1.43-3.364-.808-5.109-.808-5.109s-2.99-2.306-4.736-4.798c-1.072-1.665-2.348-2.268-3.528-2.257zm-2.234 3.84l1.542.024v8.197H7.758c-1.47-.291-2.055-1.292-2.13-1.462-.072-.173-.488-.976-.268-2.343.635-2.049 2.447-2.196 2.447-2.196h1.81zm3.964 2.39v3.881c.096.413.612.488.612.488h1.614v-4.343h1.689v5.782h-3.915c-1.517-.39-1.59-1.465-1.59-1.465v-4.317zm-5.458 1.147c-.66.197-.978.708-1.05.928-.076.22-.247.78-.1 1.269.294 1.095 1.248 1.144 1.248 1.144h1.37v-3.34z",source:"https://www.baidu.com",hex:"2932E1",guidelines:void 0,license:void 0},siAngular={title:"Angular",slug:"angular",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Angular</title><path d="'+this.path+'"/></svg>'},path:"M9.931 12.645h4.138l-2.07-4.908m0-7.737L.68 3.982l1.726 14.771L12 24l9.596-5.242L23.32 3.984 11.999.001zm7.064 18.31h-2.638l-1.422-3.503H8.996l-1.422 3.504h-2.64L12 2.65z",source:"https://angular.io/assets/images/logos/angular/angular_solidBlack.svg",hex:"DD0031",guidelines:void 0,license:void 0},siBamboo={title:"Bamboo",slug:"bamboo",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bamboo</title><path d="'+this.path+'"/></svg>'},path:"M21.7142 13.6433h-4.9888a.651.651 0 00-.655.555 4.1139 4.1139 0 01-4.0619 3.5299l1.35 6.1728a10.3737 10.3737 0 009.0077-9.5447.651.651 0 00-.652-.713zm-8.6327-.158l7.1998-6.1718a.645.645 0 000-.984L13.0815.1597a.648.648 0 00-1.074.483v12.3426a.651.651 0 001.073.5zm-11.3547 1.505A10.3847 10.3847 0 0012.0115 24v-6.2698a4.0929 4.0929 0 01-4.0999-4.0869zm-.096-1.447v.1h6.2798a4.0929 4.0929 0 014.098-4.0879l-1.348-6.1698a10.3697 10.3697 0 00-9.0298 10.1577",source:"https://www.atlassian.design/guidelines/marketing/resources/logo-files",hex:"0052CC",guidelines:void 0,license:void 0},siAzuredataexplorer={title:"Azure Data Explorer",slug:"azuredataexplorer",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Azure Data Explorer</title><path d="'+this.path+'"/></svg>'},path:"M23.1765.0176a.8032.8032 0 00-.0235.002h-8.0679L7.5426 7.562l8.8666 8.8667 7.5895-7.5894V.8222a.8032.8032 0 00-.8222-.8046zm-21.245.002a.8032.8032 0 00-.5644 1.365l5.4685 5.4705L13.671.0195zm14.8937 2.326c.137 0 .2721.0533.377.1582l.9374.9355a.535.535 0 010 .7577l-.9374.9355a.5326.5326 0 01-.7558 0l-.9375-.9355a.535.535 0 010-.7577l.9375-.9355a.5353.5353 0 01.3788-.1582zM13.4426 5.734c.1369 0 .274.0513.3789.1562l.9355.9374a.5326.5326 0 010 .7559l-.9355.9374a.535.535 0 01-.7578 0l-.9355-.9374a.5326.5326 0 010-.7559l.9355-.9374a.5332.5332 0 01.379-.1562zm6.773.002a.5355.5355 0 01.3731.1581l.9296.9296a.5355.5355 0 010 .7617l-.9296.9297a.5355.5355 0 01-.7617 0l-.9296-.9297a.5355.5355 0 010-.7617l.9296-.9296a.5355.5355 0 01.3887-.1582zm-3.3845 3.3786c.1369 0 .272.0533.377.1582l.9374.9355a.535.535 0 010 .7578l-.9375.9374a.5326.5326 0 01-.7558 0l-.9374-.9374a.535.535 0 010-.7578l.9374-.9355a.5353.5353 0 01.3789-.1582zm-11.015.7226a.3799.3799 0 00-.2695.1114L.1172 15.378a.3808.3808 0 000 .539l1.1562 1.1562c.149.149.388.149.537 0l5.4314-5.4314a.3785.3785 0 000-.537L6.0856 9.9487a.3799.3799 0 00-.2695-.1114zm18.1826.416l-6.8825 6.8825 5.4724 5.4704a.8032.8032 0 001.41-.5625zM9.1792 13.265a.382.382 0 00-.2695.1133L.1113 22.1746a.3808.3808 0 000 .539l1.1562 1.1562c.149.149.39.149.539 0l8.7964-8.7984a.3808.3808 0 000-.539l-1.1542-1.1542a.382.382 0 00-.2695-.1133zm3.365 3.3475a.3799.3799 0 00-.2695.1113L6.8434 22.155a.3785.3785 0 000 .5371l1.1562 1.1562c.149.149.39.149.539 0l5.4294-5.4313a.3785.3785 0 000-.5371l-1.1562-1.1562a.3755.3755 0 00-.2676-.1113Z",source:"https://azure.microsoft.com/en-us/pricing/details/data-explorer/",hex:"0078D4",guidelines:void 0,license:void 0},siBadoo={title:"Badoo",slug:"badoo",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Badoo</title><path d="'+this.path+'"/></svg>'},path:"M17.68 2.809c3.392 0 6.32 2.788 6.32 6.228 0 6.71-6.6 12.158-12 12.158S0 15.748 0 9.037c0-3.44 2.928-6.228 6.32-6.228 4.128 0 5.578 3.179 5.68 3.411a6.079 6.079 0 0 1 5.67-3.411zm1.078 6.488V9.11h-2.38v.186c0 2.352-1.97 4.276-4.378 4.276-2.417 0-4.369-1.924-4.369-4.276V9.11H5.233v.186c0 1.766.697 3.42 1.98 4.666a6.795 6.795 0 0 0 4.778 1.933 6.797 6.797 0 0 0 4.777-1.933 6.488 6.488 0 0 0 1.98-4.666Z",source:"https://badoo.com/team/press/",hex:"783BF9",guidelines:void 0,license:void 0},siAzuredevops={title:"Azure DevOps",slug:"azuredevops",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Azure DevOps</title><path d="'+this.path+'"/></svg>'},path:"M0 8.877L2.247 5.91l8.405-3.416V.022l7.37 5.393L2.966 8.338v8.225L0 15.707zm24-4.45v14.651l-5.753 4.9-9.303-3.057v3.056l-5.978-7.416 15.057 1.798V5.415z",source:"http://azure.com/devops",hex:"0078D7",guidelines:void 0,license:void 0},siAzurefunctions={title:"Azure Functions",slug:"azurefunctions",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Azure Functions</title><path d="'+this.path+'"/></svg>'},path:"M10.537.904L6.602 12.04l4.798.037-3.748 11.018v.002L17.996 8.39h-5.022L17.847.903h-3.824zM6.903 4.91a.585.585 0 0 0-.412.17L.155 11.285a.682.682 0 0 0 0 .865l6.448 6.396a.625.625 0 0 0 .824 0 .638.638 0 0 0 0-.865l-5.436-5.53a.641.641 0 0 1 0-.865l5.324-5.344a.574.574 0 0 0 0-.865.586.586 0 0 0-.412-.169zm10.193 0a.585.585 0 0 0-.412.17.572.572 0 0 0 0 .864l5.435 5.343a.64.64 0 0 1 0 .866l-5.548 5.53a.64.64 0 0 0 0 .865.625.625 0 0 0 .824 0l6.45-6.396a.68.68 0 0 0 0-.865l-6.337-6.208a.585.585 0 0 0-.412-.169z",source:"https://azure.microsoft.com/en-us/services/functions",hex:"0062AD",guidelines:void 0,license:void 0},siBandcamp={title:"Bandcamp",slug:"bandcamp",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bandcamp</title><path d="'+this.path+'"/></svg>'},path:"M0 18.75l7.437-13.5H24l-7.438 13.5H0z",source:"https://bandcamp.com/buttons",hex:"408294",guidelines:void 0,license:void 0},siBankofamerica={title:"Bank of America",slug:"bankofamerica",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bank of America</title><path d="'+this.path+'"/></svg>'},path:"M15.194 7.57c.487-.163 1.047-.307 1.534-.451-1.408-.596-3.176-1.227-4.764-1.625-.253.073-1.01.271-1.534.434.541.162 2.328.577 4.764 1.642zm-8.896 6.785c.577.343 1.19.812 1.786 1.209 3.952-3.068 7.85-5.432 12.127-6.767-.596-.307-1.119-.578-1.787-.902-2.562.65-6.947 2.4-12.126 6.46zm-.758-6.46c-2.112.974-4.331 2.31-5.54 3.085.433.199.866.361 1.461.65 2.671-1.805 4.764-2.905 5.594-3.266-.595-.217-1.154-.361-1.515-.47zm8.066.234c-.686-.379-3.068-1.263-4.71-1.642-.487.18-1.173.451-1.642.65.595.162 2.815.758 4.71 1.714.487-.235 1.173-.523 1.642-.722zm-3.374 1.552c-.56-.27-1.173-.523-1.643-.74-1.425.704-3.284 1.769-5.63 3.447.505.27 1.047.595 1.624.92 1.805-1.335 3.627-2.598 5.649-3.627zm1.732 8.825c3.79-3.249 9.113-6.407 12.036-7.544a48.018 48.018 0 00-1.949-1.155c-3.771 1.246-8.174 4.007-12.108 7.129.667.505 1.371 1.028 2.02 1.57zm2.851-.235h-.108l-.18-.27h-.109v.27h-.072v-.596h.27c.055 0 .109 0 .145.036.054.019.072.073.072.127 0 .108-.09.162-.198.162zm-.289-.343c.09 0 .199.018.199-.09 0-.072-.072-.09-.144-.09h-.163v.18zm-.523.036c0-.289.235-.523.541-.523.307 0 .542.234.542.523a.543.543 0 01-.542.542.532.532 0 01-.54-.542m.107 0c0 .235.199.433.451.433a.424.424 0 100-.848c-.27 0-.45.199-.45.415",source:"https://www.bankofamerica.com/",hex:"012169",guidelines:void 0,license:void 0},siBarclays={title:"Barclays",slug:"barclays",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Barclays</title><path d="'+this.path+'"/></svg>'},path:"M21.043 3.629a3.235 3.235 0 0 0-1.048-.54 3.076 3.076 0 0 0-.937-.144h-.046c-.413.006-1.184.105-1.701.71a1.138 1.138 0 0 0-.226 1.023.9.9 0 0 0 .555.63s.088.032.228.058c-.04.078-.136.214-.136.214-.179.265-.576.612-1.668.612h-.063c-.578-.038-1.056-.189-1.616-.915-.347-.45-.523-1.207-.549-2.452-.022-.624-.107-1.165-.256-1.6-.1-.29-.333-.596-.557-.742a2.55 2.55 0 0 0-.694-.336c-.373-.12-.848-.14-1.204-.146-.462-.01-.717.096-.878.292-.027.033-.032.05-.068.046-.084-.006-.272-.006-.328-.006-.264 0-.498.043-.721.09-.47.1-.761.295-1.019.503-.12.095-.347.365-.399.653a.76.76 0 0 0 .097.578c.14-.148.374-.264.816-.266.493-.002 1.169.224 1.406.608.336.547.27.99.199 1.517-.183 1.347-.68 2.048-1.783 2.203-.191.026-.38.04-.56.04-.776 0-1.34-.248-1.63-.716a.71.71 0 0 1-.088-.168s.087-.021.163-.056c.294-.14.514-.344.594-.661.09-.353.004-.728-.23-1.007-.415-.47-.991-.708-1.713-.708-.4 0-.755.076-.982.14-.908.256-1.633.947-2.214 2.112-.412.824-.7 1.912-.81 3.067-.11 1.13-.056 2.085.019 2.949.124 1.437.363 2.298.708 3.22a15.68 15.68 0 0 0 1.609 3.19c.09-.094.15-.161.308-.318.188-.19.724-.893.876-1.11.19-.27.51-.779.664-1.147l.15.119c.16.127.252.348.249.592-.003.215-.053.464-.184.922a8.703 8.703 0 0 1-.784 1.818c-.189.341-.27.508-.199.584.015.015.038.03.06.026.116 0 .34-.117.585-.304.222-.17.813-.672 1.527-1.675a15.449 15.449 0 0 0 1.452-2.521c.12.046.255.101.317.226a.92.92 0 0 1 .08.563c-.065.539-.379 1.353-.63 1.94-.425.998-1.208 2.115-1.788 2.877-.022.03-.163.197-.186.227.9.792 1.944 1.555 3.007 2.136.725.408 2.203 1.162 3.183 1.424.98-.262 2.458-1.016 3.184-1.424a17.063 17.063 0 0 0 3.003-2.134c-.05-.076-.13-.158-.183-.23-.582-.763-1.365-1.881-1.79-2.875-.25-.59-.563-1.405-.628-1.94-.028-.221-.002-.417.08-.565.033-.098.274-.218.317-.226.405.884.887 1.73 1.452 2.522.715 1.003 1.306 1.506 1.527 1.674.248.191.467.304.586.304a.07.07 0 0 0 .044-.012c.094-.069.017-.234-.183-.594a9.003 9.003 0 0 1-.786-1.822c-.13-.456-.18-.706-.182-.92-.004-.246.088-.466.248-.594l.15-.118c.155.373.5.919.665 1.147.15.216.685.919.876 1.11.156.158.22.222.308.32a15.672 15.672 0 0 0 1.609-3.19c.343-.923.583-1.784.707-3.222.075-.86.128-1.81.02-2.948-.101-1.116-.404-2.264-.81-3.068-.249-.49-.605-1.112-1.171-1.566z",source:"https://home.barclays/",hex:"00AEEF",guidelines:void 0,license:void 0},siBasecamp={title:"Basecamp",slug:"basecamp",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Basecamp</title><path d="'+this.path+'"/></svg>'},path:"M12.6516 22.453c-4.0328 0-7.575-1.5542-10.244-4.4946a1.11 1.11 0 0 1-.219-1.1338c.7008-1.8884 2.5935-6.2808 5.0205-6.2948h.0125c1.219 0 2.1312.9655 2.8648 1.7412.2192.2324.555.5875.7818.7611.5656-.5587 1.6775-2.4158 2.5422-4.2779.259-.5567.9203-.7985 1.4765-.5402.557.2584.7988.919.5404 1.4762-2.6217 5.6503-4.019 5.6503-4.478 5.6503-1.022 0-1.7628-.7843-2.4791-1.5422-.3208-.339-.9878-1.045-1.2482-1.045h-.0004c-.5665.095-1.8085 2.0531-2.6966 4.2034 2.1925 2.1722 4.9232 3.2726 8.1266 3.2726 4.3955 0 7.683-1.1964 9.0996-3.2953-.4888-5.585-3.5642-13.1634-9.0996-13.1634-4.6855 0-8.2152 3.264-10.4915 9.7007-.205.579-.8416.8828-1.4187.6776-.5789-.2047-.882-.8398-.6776-1.4185 2.624-7.421 6.859-11.1833 12.5878-11.1833 7.4826 0 10.9304 9.5613 11.3458 15.588a1.1154 1.1154 0 0 1-.1456.6314c-1.7407 3.0221-5.7182 4.6864-11.2002 4.6864Z",source:"https://basecamp.com/about/press",hex:"1D2D35",guidelines:void 0,license:void 0},siBata={title:"Bata",slug:"bata",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bata</title><path d="'+this.path+'"/></svg>'},path:"M17.397 13.003c.244-1.308 1.795-1.974 2.936-1.91.436.025.82.154 1.039.41.09-.09.18-.192.269-.282.051-.051.205-.038.346-.013.154.026.32.09.423.09.103 0 .36-.077.603-.115.243-.039.461-.026.423.064l-.218.538-.705 1.73c-.141.347.41.257 1.166-.55.129.09.193.102.321.423-.654.564-1.27.961-2.128 1.256-.77.27-1.346-.115-1.526-.756-1.102 1.025-2.628 1.013-3.064-.141-.718.359-1.564.73-1.923.833-.282.077-.526.141-.77.141-.384 0-.794-.346-.666-.872-.628.282-1.128.462-1.846.705-.77.27-1.218-.025-1.398-.666-1.102 1.025-2.628 1.013-3.064-.141-.436.205-1.025.513-1.577.73-.884.398-1.923.321-2.692-.487l.257-.397c.359.384.807.372 1.153.051.372-.333.603-.974.436-1.513-.077-.23-.333-.41-.833-.384l.154-.41c.5-.013.897-.09 1.115-.398.308-.449.308-1.128-.346-1.115a1.34 1.34 0 0 0-.41.077c-.116.333-.308.73-.475 1.14-.371.95-.782 2-1.256 2.68-.564.808-1.18.962-1.667.936-.512-.039-.91-.192-1.474-.692 0-.218.013-.308.064-.577.218.269.898.564 1.115.243.488-.718 1.026-2.102 1.436-3-.359.116-.705.346-1.18.68 0-.051-.153-.18-.153-.334.77-.884 2.115-1.423 3.026-1.615 1.397-.295 2.884.128 3.115 1.013.154.59-.538 1.14-1.192 1.218.372.218.769.602.872 1.077.05.23.038.487-.039.73.218-.102.487-.23.654-.307.27-1.885 3.192-2.487 3.987-1.59l.27-.282c.05-.051.204-.038.346-.013.153.026.32.09.423.09.102 0 .359-.077.602-.115.244-.039.462-.026.423.064l-.91 2.269c-.205.513 1.308-.398 1.397-.449l.654-1.384-.666.012.115-.564h.744c.128-.166.153-.359.32-.474.218-.167.718-.077.949-.23.205-.129.359-.321.538-.629.154-.256.744-.192.628.051l-.512 1.295h.653c.308.013.039.539-.307.539l-.539.012-.628 1.629c-.205.5.59.025 1.192-.32zm-6.012-1.115c-.077-.244-.282-.308-.475-.295-.436.051-.859.538-1.077.872-.346.538-.269 1.346.295 1.192.577-.154 1.36-1.41 1.257-1.77zm9.666 0c-.077-.244-.282-.308-.474-.295-.436.051-.86.538-1.077.872-.346.538-.27 1.346.295 1.192.577-.154 1.359-1.41 1.256-1.77Z",source:"https://www.bata.com/",hex:"DD282E",guidelines:void 0,license:void 0},siBathasu={title:"Bath ASU",slug:"bathasu",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bath ASU</title><path d="'+this.path+'"/></svg>'},path:"M20.9734 22.2604c-.33 0-.653-.088-.942-.256a1.88 1.88 0 01-.69-2.5691c1.91-3.2981.77-7.5363-2.5391-9.4434a6.8883 6.8883 0 00-3.4481-.92c-.33 0-.66-.09-.941-.257a1.87 1.87 0 01-.6901-2.5651c.33-.575.946-.93 1.621-.935 1.8631 0 3.7112.49 5.3333 1.427a10.6074 10.6074 0 014.9551 6.4762 10.6204 10.6204 0 01-1.065 8.0964c-.33.57-.96.93-1.622.93l.04.006zm-11.4724 1.31a10.7094 10.7094 0 01-9.2513-5.3362 1.874 1.874 0 01.69-2.559c.872-.504 2.066-.176 2.563.686a6.9313 6.9313 0 005.9923 3.4551c1.201 0 2.3961-.32 3.4461-.925a7.1553 7.1553 0 002.5231-2.5401c.166-.284.392-.524.69-.689.8561-.51 2.0591-.18 2.5532.676.332.57.332 1.292-.015 1.877a10.7164 10.7164 0 01-3.9042 3.9052 10.7344 10.7344 0 01-5.3322 1.427l.05.023zm.746-16.6306a5.6412 5.6412 0 00-1.815 4.1532c0 1.03.277 1.992.76 2.826.271.466.421.9901.421 1.5621a3.1241 3.1241 0 01-1.79 2.8241c1.46.45 3.08.315 4.5091-.512a5.7152 5.7152 0 002.0721-2.07 3.0701 3.0701 0 011.159-1.1441 3.1371 3.1371 0 013.3482.136 5.5612 5.5612 0 00-2.6881-3.6491 5.6232 5.6232 0 00-2.8191-.751c-.54 0-1.08-.15-1.5601-.42a3.1221 3.1221 0 01-1.545-2.9732l-.043.01zM6.479 17.3642c-.664 0-1.286-.36-1.623-.94a10.6304 10.6304 0 01-1.4291-5.3302C3.4278 5.2117 8.206.4296 14.0932.4296a1.878 1.878 0 01-.008 3.7541c-3.8102 0-6.9073 3.1001-6.9073 6.9083a6.9003 6.9003 0 00.926 3.4541 1.878 1.878 0 01-1.63 2.8151v.002z",source:"https://bathasu.com/press/",hex:"00A3E0",guidelines:void 0,license:void 0},siBattledotnet={title:"Battle.net",slug:"battledotnet",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Battle.net</title><path d="'+this.path+'"/></svg>'},path:"M20.001 3.106c0-.059 0-.187.063-.187.09 0 .167.19.196.27.486 1.548.35 3.449-.345 5.588 2.756 1.473 4.338 3.382 4.052 5.168-.38 2.347-3.824 3.727-8.462 3.565a27.12 27.12 0 001.55-1.825c1.786-.347 3.066-1.053 3.4-2.184.246-.823-.32-1.736-1.396-2.594-1.768 3.723-4.722 7.058-7.451 8.985 1.323 1.687 2.556 2.858 3.964 3.516.052.025.164.09.126.148-.044.078-.252.05-.33.034-1.585-.352-3.158-1.42-4.673-3.093-2.652 1.65-5.099 2.066-6.502.925-1.842-1.5-1.316-5.178 1.137-9.106.193.631.505 1.526.806 2.253-.594 1.721-.622 3.183.19 4.041.59.623 1.664.59 2.945.088-2.325-3.395-3.738-7.62-4.04-10.954-2.124.303-3.754.785-5.027 1.675-.048.033-.16.098-.195.04-.044-.078.082-.24.137-.304 1.098-1.196 2.812-2.028 5.012-2.496-.102-3.124.758-5.45 2.45-6.093 2.22-.846 5.14 1.448 7.316 5.542a26.617 26.617 0 00-2.354-.429c-1.193-1.372-2.446-2.13-3.594-1.854-.834.2-1.341 1.146-1.547 2.502 4.108-.332 8.473.56 11.51 1.964.8-1.984 1.197-3.637 1.062-5.185zm-9.598 15.057c3.252-1.859 5.889-4.696 7.638-7.965-3.24-1.88-7.013-2.75-10.716-2.627-.008 3.745 1.124 7.451 3.082 10.594Z",source:"https://eu.shop.battle.net/en-gb",hex:"148EFF",guidelines:void 0,license:void 0},siBbc={title:"BBC",slug:"bbc",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>BBC</title><path d="'+this.path+'"/></svg>'},path:"M13.004 13c0 .744-.925.7-.925.7h-.925v-1.343h.925c.952-.007.925.644.925.644m-1.85-2.693h.704c.732.04.705.584.705.584 0 .677-.81.688-.81.688h-.6zm1.679 1.536s.633-.27.627-.985c0 0 .096-1.173-1.458-1.316h-1.724v4.917h1.977s1.65.004 1.65-1.388c0 0 .04-.947-1.072-1.228M8.37 8.58h7.258v6.84H8.371zM4.633 13c0 .744-.925.7-.925.7h-.925v-1.343h.925c.952-.007.925.644.925.644m-1.85-2.693h.705c.732.04.704.584.704.584 0 .677-.81.688-.81.688h-.599zm1.679 1.536s.633-.27.627-.985c0 0 .097-1.173-1.457-1.316H1.908v4.917h1.976s1.651.004 1.651-1.388c0 0 .04-.947-1.073-1.228M0 8.58h7.259v6.84H0zm22.52 1.316v.908s-.887-.545-1.867-.556c0 0-1.828-.036-1.91 1.752 0 0-.066 1.645 1.888 1.738 0 0 .82.099 1.932-.61v.94s-1.492.887-3.22.204c0 0-1.454-.53-1.509-2.272 0 0-.06-1.79 1.878-2.385 0 0 .517-.198 1.447-.11 0 0 .556.055 1.36.39m-5.778 5.525H24V8.58h-7.259Z",source:"https://commons.wikimedia.org/wiki/File:BBC.svg",hex:"000000",guidelines:"https://www.bbc.co.uk/branding/logo-use",license:void 0},siBbciplayer={title:"BBC iPlayer",slug:"bbciplayer",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>BBC iPlayer</title><path d="'+this.path+'"/></svg>'},path:"M8.315 0H2.382v6.022h5.933V3.506l9.618 8.45-9.618 8.538V8.99H2.382V24h5.933l13.303-12.045Z",source:"https://www.bbc.co.uk/iplayer",hex:"F54997",guidelines:void 0,license:void 0},siBeatport={title:"Beatport",slug:"beatport",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Beatport</title><path d="'+this.path+'"/></svg>'},path:"M14.668 24c-3.857 0-6.935-3.039-6.935-6.974a6.98 6.98 0 011.812-4.714l-4.714 4.714-2.474-2.474 5.319-5.26c.72-.72 1.09-1.656 1.09-2.688V0h3.487v6.604c0 2.026-.72 3.74-2.123 5.143l-.156.156a6.945 6.945 0 014.694-1.812c3.955 0 6.975 3.136 6.975 6.935A6.943 6.943 0 0114.668 24zm0-10.714c-2.123 0-3.779 1.753-3.779 3.74 0 2.045 1.675 3.78 3.78 3.78a3.804 3.804 0 003.818-3.78c0-2.065-1.715-3.74-3.819-3.74Z",source:"https://brand.beatport.com/",hex:"01FF95",guidelines:"https://support.beatport.com/hc/en-us/articles/200353255-Beatport-Logos-and-Images",license:void 0},siBandsintown={title:"Bandsintown",slug:"bandsintown",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bandsintown</title><path d="'+this.path+'"/></svg>'},path:"M18.783 0H24v12h-5.217V0zm-6.261 5h5.217v7h-5.217V5zM6.26 5h5.217v7H6.261V5zM24 24H0V0h5.217v19h13.566v-1H6.26v-5H24v11Z",source:"https://corp.bandsintown.com/media-library",hex:"00CEC8",guidelines:void 0,license:void 0},siBetfair={title:"Betfair",slug:"betfair",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Betfair</title><path d="'+this.path+'"/></svg>'},path:"M20.218 3.14h-7.083v3.6H9.352l7.359 8.582L24 6.67h-3.782zM0 17.26h3.782v3.6h7.083v-3.6h3.783l-7.29-8.583z",source:"https://partnerships.betfair.com/",hex:"FFB80B",guidelines:void 0,license:void 0},siBigcartel={title:"Big Cartel",slug:"bigcartel",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Big Cartel</title><path d="'+this.path+'"/></svg>'},path:"M12 13.068v-1.006c0-.63.252-1.256.88-1.508l7.79-4.9c.503-.252.755-.88.755-1.51V0L12 6.03 2.575 0v12.69c0 3.394 1.51 6.284 4.02 7.917L11.875 24l5.28-3.393c2.513-1.51 4.02-4.398 4.02-7.916V7.036L12 13.068z",source:"https://www.bigcartel.com",hex:"222222",guidelines:void 0,license:void 0},siBigbasket={title:"bigbasket",slug:"bigbasket",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>bigbasket</title><path d="'+this.path+'"/></svg>'},path:"M11.543 12.989a3.352 3.352 0 0 0-.871-1.375 2.251 2.251 0 0 0-1.474-.503 2.276 2.276 0 0 0-1.541.536 2.953 2.953 0 0 0-.973 1.375 5.609 5.609 0 0 0-.335 1.845 5.42 5.42 0 0 0 .335 1.809c.192.548.528 1.034.973 1.407.441.339.985.516 1.541.503a2.08 2.08 0 0 0 1.945-1.072h-.002a4.92 4.92 0 0 0 .67-2.649 6.477 6.477 0 0 0-.268-1.876zM20.381.033H3.587A3.584 3.584 0 0 0 0 3.585V20.38a3.59 3.59 0 0 0 3.587 3.586h16.794c1.986 0 3.601-1.6 3.619-3.586V3.585A3.614 3.614 0 0 0 20.381.033zM10.64 3.034h1.911v5.744a3.47 3.47 0 0 0-1.911-.584v-5.16zm-.438 17.93a5.586 5.586 0 0 1-2.278-.369 3.522 3.522 0 0 1-1.174-.804 4.18 4.18 0 0 1-.335-.536l-.033-.134v.302C6.281 21.266 3.4 20.931 3.4 20.931V3.034h3.15v7.442h.034a3.675 3.675 0 0 1 1.541-1.309 4.825 4.825 0 0 1 2.079-.435 4.197 4.197 0 0 1 2.649.871 5.263 5.263 0 0 1 1.675 2.278v-.001c.372.951.565 1.963.569 2.984a8.418 8.418 0 0 1-.571 2.984 5.47 5.47 0 0 1-1.675 2.278 4.161 4.161 0 0 1-2.649.838zm9.828-3.111a5.47 5.47 0 0 1-1.675 2.278 4.173 4.173 0 0 1-2.649.838 5.587 5.587 0 0 1-2.278-.37 4.85 4.85 0 0 1-.362-.186c.444-.36.837-.778 1.168-1.245.353.127.726.189 1.101.185 2.38 0 3.15-2.502 3.15-4.484 0-1.96-.721-4.523-3.15-4.523a3.058 3.058 0 0 0-1.021.163 6.349 6.349 0 0 0-1.017-1.166c.107-.063.218-.121.331-.176a4.72 4.72 0 0 1 6.403 2.715l-.001.004c.373.951.566 1.963.571 2.984a8.409 8.409 0 0 1-.571 2.983z",source:"https://www.bigbasket.com/",hex:"A5CD39",guidelines:void 0,license:void 0},siBeats={title:"Beats",slug:"beats",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Beats</title><path d="'+this.path+'"/></svg>'},path:"M2.625 0v15h8.25a7.5 7.5 0 0 0 0-15zm17.016 11.705c-1.571 3.261-4.91 5.517-8.766 5.517h-8.25V24h11.25a7.5 7.5 0 0 0 5.766-12.295z",source:"https://www.elastic.co/brand",hex:"005571",guidelines:void 0,license:void 0},siBem={title:"BEM",slug:"bem",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>BEM</title><path d="'+this.path+'"/></svg>'},path:"M0 5.163h5.61v1.65H0Zm0-3.065h5.61v1.65H0Zm10.067 6.106H0v1.65h9.69c1.06 0 3.536.024 4.455 1.51v-.92c-.448-1.462-1.768-2.24-4.078-2.24Zm.023 3.065H0v1.65h9.69c2.357 0 3.842.095 4.455.425v-.731c-.471-1.155-2.451-1.344-4.055-1.344Zm-.023 7.78H0V17.4h9.69c1.06 0 3.536-.024 4.455-1.509v.92c-.448 1.461-1.768 2.24-4.078 2.24zm.023-3.065H0v-1.65h9.69c2.357 0 3.842-.094 4.455-.424v.73c-.471 1.156-2.451 1.344-4.055 1.344zm6.507 5.918H24v-1.014h-7.19c-.637 0-2.146-.023-2.688-.896v.566c.26.872 1.06 1.344 2.475 1.344zm-.023-1.863h7.403v-1.013H16.81c-1.439 0-2.334-.047-2.688-.26v.448c.283.708 1.485.825 2.452.825z",source:"https://en.bem.info/",hex:"000000",guidelines:void 0,license:void 0},siBeijingsubway={title:"Beijing Subway",slug:"beijingsubway",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Beijing Subway</title><path d="'+this.path+'"/></svg>'},path:"M7.8857.7537C11.2092-.5 15.09-.1816 18.1547 1.6493c2.826 1.6916 5.055 4.7166 5.5526 7.5028-1.2538 0-1.5523.0398-2.7862.0398-.796-2.5872-3.7216-5.4729-6.1097-6.07-3.1246-.6567-5.6321-.199-7.8014 1.3335C5.418 5.55 3.9253 7.4604 3.368 9.3312c-.8159 2.408-.1592 5.8112 1.234 7.9208 1.0945 1.5722 3.005 3.0648 4.836 3.642 1.7911.5572 4.7166.0397 6.4878-.5971 2.4877-.9155 4.3186-3.1842 5.1147-5.6918l-3.4628.0398c-.1593 1.1543-.3384 1.5523-1.035 2.8857l-9.4929-.0199V6.4257h9.473c1.1345 1.4328 1.3136 3.6817 1.3335 5.5723 0 0 3.8011.02 6.1296 0-.0398 3.6022-1.5523 7.1645-4.4181 9.3935-2.0897 1.6518-4.7166 2.607-7.3834 2.607-3.7216.0598-7.4232-1.7314-9.6522-4.7166C1.0992 17.451.343 15.2021.0445 12.9334c-.0796-1.3931.02-2.0897.0398-2.1693C.343 9.1521.761 7.56 1.577 6.167 2.9501 3.6792 5.219 1.7289 7.8857.7537m1.811 8.1795v6.2291l4.5972.02c1.0349-1.1942.995-1.9703-.0398-3.0649 1.0349-1.0946 1.0946-2.2488.02-3.1842H9.6966Z",source:"https://zh.wikipedia.org/wiki/File:Beijing_Subway_Logo.svg",hex:"004A9D",guidelines:void 0,license:void 0},siBehance={title:"Behance",slug:"behance",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Behance</title><path d="'+this.path+'"/></svg>'},path:"M0 4.4804V19.243h7.1554c.6613 0 1.3078-.0832 1.9297-.248.6288-.1654 1.1905-.4203 1.6792-.7661.485-.3431.8784-.788 1.1677-1.3369.2862-.542.4294-1.187.4294-1.9354 0-.9232-.219-1.7109-.6675-2.369-.446-.6542-1.1187-1.1139-2.0274-1.3746.6674-.3161 1.1658-.7227 1.506-1.2177.3371-.4967.5058-1.1174.5058-1.8607 0-.6873-.1127-1.2677-.3375-1.7318-.2306-.4709-.552-.8452-.9632-1.1266-.4176-.2808-.912-.4857-1.4912-.6085-.5827-.1261-1.22-.1872-1.9264-.1872zm15.6674.9903v1.4567h5.9844V5.4707zM3.2509 6.9947h3.0407c.2873 0 .5683.0204.8359.0731.2728.0466.508.134.716.2595.2096.1205.3754.293.501.5132.1208.2203.1806.5038.1806.8474 0 .6189-.1811 1.0702-.5551 1.3426-.3778.2775-.8543.4147-1.4304.4147H3.2509zm15.545 1.2564c-.819 0-1.5587.1462-2.2294.436-.6705.2904-1.2463.6875-1.7318 1.1915-.4846.5011-.8535 1.0986-1.12 1.7909-.2612.69-.3942 1.4366-.3942 2.236 0 .8268.1284 1.5891.3835 2.2786.258.6923.6198 1.2822 1.0856 1.781.478.4967 1.046.8784 1.726 1.1497.6806.269 1.4382.4048 2.2803.4048 1.208 0 2.2446-.2771 3.0949-.8326.8599-.5528 1.4902-1.471 1.9058-2.7574h-2.585c-.1.3307-.359.649-.784.9467-.4295.2988-.9417.4492-1.534.4492-.8233 0-1.4588-.2168-1.8985-.6462-.4412-.4294-.7267-1.2289-.7267-2.0742h7.713c.0552-.8291-.0122-1.6218-.2045-2.3797-.1938-.7601-.5033-1.4365-.9393-2.029-.4355-.5931-.9904-1.0667-1.667-1.4165-.6788-.3543-1.4703-.5288-2.3747-.5288zm-.0887 2.217c.7209 0 1.3126.2092 1.6612.5954.3503.389.6065.9432.6766 1.6915h-4.7766c.0136-.2085.058-.4444.1339-.7045.0749-.2668.2039-.5164.3933-.753.1905-.2326.4402-.431.744-.5896.3109-.1608.6986-.2397 1.1676-.2397zM3.251 12.664h3.5334c.6996 0 1.2682.1602 1.6948.4836.4259.328.6405.8685.6405 1.6292 0 .3885-.0632.7094-.1946.9566-.131.2495-.3106.4466-.528.5896-.2172.1491-.4753.2498-.7661.3137-.2862.0639-.5905.092-.9115.092H3.2509z",source:"https://www.behance.net/dev/api/brand",hex:"1769FF",guidelines:void 0,license:void 0},siBeatsbydre={title:"Beats by Dre",slug:"beatsbydre",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Beats by Dre</title><path d="'+this.path+'"/></svg>'},path:"M12.0099 15.5996A3.5995 3.5995 0 1 0 8.4103 12a3.5995 3.5995 0 0 0 3.5996 3.5996zm0-15.5981a11.9985 11.9985 0 0 0-3.5996.552v6.6471A5.9992 5.9992 0 1 1 6.0106 12V1.6033A11.9985 11.9985 0 1 0 12.01.0015z",source:"https://www.beatsbydre.com/",hex:"E01F3D",guidelines:void 0,license:void 0},siAral={title:"ARAL",slug:"aral",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>ARAL</title><path d="'+this.path+'"/></svg>'},path:"M5.393 10.02l-.48 1.959.99.001-.51-1.96zm3.892.082v1.187c.549-.002.958.03 1.229-.033.27-.062.404-.217.404-.592 0-.334-.12-.469-.385-.523-.264-.055-.672-.028-1.248-.04zm5.326-.079l-.48 1.96h.99l-.51-1.96zM11.996 0L0 11.998 12.004 24 24 12.004 11.996 0zM5.393 8.896c.366 0 .606.117.775.295.169.18.267.421.35.67l1.07 3.211s.134.276.144.567c.01.29-.104.599-.6.666-.355-.054-.536-.156-.657-.35-.122-.194-.184-.482-.305-.91H4.645c-.147.468-.195.757-.295.941-.1.184-.254.263-.616.317-.508-.054-.636-.369-.636-.67 0-.301.129-.588.129-.588l1.015-3.152c.08-.246.176-.495.348-.682.172-.187.42-.315.803-.315zm9.191.002c.366 0 .607.117.775.295.17.18.267.421.35.67l1.072 3.211s.135.276.145.567c.01.29-.104.599-.6.666-.356-.054-.536-.156-.658-.35-.122-.194-.186-.482-.307-.91h-1.525c-.147.468-.193.757-.293.941-.1.184-.256.263-.617.317-.509-.054-.635-.367-.635-.668 0-.301.127-.59.127-.59l1.016-3.152c.075-.233.17-.484.343-.674.174-.19.424-.323.807-.323zm3.346.002c.308 0 .483.114.58.291.097.178.117.418.117.672v3.207c.215.005 1.23 0 1.23 0 .29 0 .53.02.694.106.164.086.252.239.244.504-.01.361-.18.517-.406.582-.226.065-.509.039-.744.039h-1.766c-.375 0-.536-.165-.604-.436-.067-.27-.04-.645-.04-1.062v-2.94c-.014-.254.02-.496.126-.674.107-.177.288-.289.569-.289zm-8.645.104h1.098c.254 0 .51-.002.767.084.259.086.52.26.786.613.28.378.35.933.222 1.414-.128.481-.456.889-.972.969.187.348.804 1.283.804 1.283s.066.11.078.266c.012.155-.03.357-.25.539-.388.147-.633.106-.78.03-.149-.078-.2-.192-.2-.192s-.562-.964-.91-1.633h-.643v1.338s.01.154-.064.305c-.075.15-.236.298-.578.285-.327 0-.488-.155-.567-.309C7.997 13.842 8 13.69 8 13.69V9.861c0-.334.006-.549.17-.68.164-.13.486-.177 1.115-.177z",source:"https://upload.wikimedia.org/wikipedia/commons/6/60/Aral_Logo.svg",hex:"0063CB",guidelines:void 0,license:void 0},siCitroen={title:"Citro\xEBn",slug:"citroen",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Citro&#235;n</title><path d="'+this.path+'"/></svg>'},path:"M18.591 15.407c-1.225-1.044-4.864-4.014-6.59-4.014-1.73 0-5.366 2.968-6.591 4.013-.007-.247-.014-.397-.014-.617 0 0-.03-.363.293-.725 2.657-2.393 5.442-3.563 5.528-3.6.83-.348.784-.283.783-1.683 0 0 .037-.002.06 0 1.17.106 4.316 3.14 6.177 5.19.003.003.367.422.367.864 0 .206-.006.41-.013.572m-.05-1.712c-.198-.218-4.855-5.328-6.541-5.328s-6.343 5.11-6.54 5.327h-.001c-.02.022-.474.539-.474 1.14 0 .47.031.941.031.946.002.022.012.22.124.275a.128.128 0 0 0 .058.013.242.242 0 0 0 .137-.055c.05-.044 4.795-4.209 6.665-4.209s6.615 4.165 6.663 4.207a.247.247 0 0 0 .14.057.13.13 0 0 0 .058-.013c.11-.054.122-.253.123-.276 0-.004.031-.476.031-.944 0-.602-.454-1.119-.474-1.14m-3.35 6.45h-.001a6.569 6.569 0 0 1-.376 0c-.415 0-.863-.312-.863-.818 0-.501.438-.8.86-.8a4.14 4.14 0 0 1 .38 0c.425 0 .863.299.863.8 0 .506-.447.819-.862.819m.404-1.936c-.59-.013-1.19 0-1.194 0-.72 0-1.307.5-1.307 1.114 0 .623.586 1.13 1.307 1.13.005 0 .604.012 1.195 0 .722 0 1.309-.507 1.309-1.13 0-.608-.575-1.097-1.31-1.114m7.67 2.216H24v-1.07c0-.624-.56-1.114-1.274-1.114h-1.858c-.03 0-.102.007-.102.081v2.02c0 .054.04.082.079.082h.777v-1.689c0-.074.055-.113.11-.113h.857c.236 0 .587.215.587.678v1.04s.002.085.09.085m-15.507-1.75h1.146v-.348c0-.05-.035-.086-.082-.086H5.627a.083.083 0 0 0-.083.084v.349h.764c.286 0 .479.246.479.475v1.193c0 .039.035.083.084.083h.775v-1.639c0-.062.05-.112.112-.112m-3.532 1.668c0 .049.044.083.084.083h.044l-.006.005c.022-.005.097-.005.357-.005h.38v-2.101a.084.084 0 0 0-.083-.084H4.31a.085.085 0 0 0-.084.084v2.018zm5.994-1.079v-.436c0-.119.085-.202.206-.202h1.14c.173 0 .32.145.32.317a.322.322 0 0 1-.323.321H10.22zm1.668 1.162h.852c-.013-.525-.56-.742-.623-.765l-.01-.004v-.03l.011-.003c.366-.081.62-.36.62-.68 0-.337-.33-.703-.866-.703H9.811a.441.441 0 0 0-.446.446v1.655a.08.08 0 0 0 .082.083h.774l-.001-.774h.73c.65 0 .918.47.938.775m-8.965-1.451h.835c-.181-.457-.682-.77-1.257-.781l-.256-.006a11.048 11.048 0 0 0-.938.006c-.41.02-.67.114-.923.335a1.06 1.06 0 0 0-.384.802c0 .625.556 1.115 1.292 1.14.505.018.56.019 1.222 0 .613-.02 1.053-.297 1.243-.781h-.834a.078.078 0 0 0-.072.041.869.869 0 0 1-.754.422c-.171.007-.378 0-.378 0-.424 0-.863-.306-.863-.818v-.005c.003-.509.44-.813.865-.813.048-.002.219-.008.376 0 .309 0 .606.164.756.418a.08.08 0 0 0 .07.04m17.384 1.058h-2.02c-.069 0-.116-.045-.116-.11v-.416h1.75v-.383h-1.75l-.001-.38c0-.001-.001-.042.03-.074.022-.024.056-.036.1-.036h2.006v-.307c0-.026-.007-.046-.022-.06-.028-.027-.074-.025-.076-.025h-2.81c-.009 0-.086.002-.086.085v1.654c0 .219.169.445.45.445h2.46c.021 0 .042-.01.058-.025a.08.08 0 0 0 .027-.057v-.31m-.628-2.582a.553.553 0 0 0-.298-.076.56.56 0 0 0-.297.076c-.079.049-.141.114-.234.114-.093 0-.149-.065-.232-.114a.572.572 0 0 0-.297-.076.555.555 0 0 0-.298.076c-.082.05-.123.11-.123.181s.041.132.123.182c.083.05.181.075.298.075a.566.566 0 0 0 .29-.07c.075-.044.155-.118.239-.118.084 0 .16.066.234.113a.572.572 0 0 0 .297.075c.12 0 .22-.025.3-.075.08-.05.12-.11.12-.182 0-.07-.04-.131-.122-.181m-1.094-6.905c-1.224-1.042-4.86-4.01-6.585-4.01-1.726 0-5.36 2.966-6.583 4.01-.008-.247-.014-.397-.014-.616 0 0-.03-.363.292-.725 2.654-2.39 5.437-3.56 5.523-3.596.83-.348.783-.283.782-1.682 0 0 .037-.002.06 0 1.17.106 4.311 3.136 6.17 5.185.004.004.368.422.368.863 0 .206-.006.41-.013.571m-.05-1.71c-.198-.218-4.85-5.322-6.535-5.322-1.684 0-6.337 5.104-6.534 5.322-.02.021-.474.537-.474 1.139 0 .468.031.94.031.944.002.022.012.22.124.275a.13.13 0 0 0 .057.013.242.242 0 0 0 .138-.055c.05-.044 4.79-4.205 6.658-4.205 1.868 0 6.608 4.161 6.656 4.203a.245.245 0 0 0 .14.057.13.13 0 0 0 .058-.013c.11-.054.122-.253.123-.276 0-.004.031-.475.031-.943 0-.602-.454-1.118-.473-1.14",source:"https://citroen.pcaci.co.uk/logo.php",hex:"6E6E6E",guidelines:void 0,license:void 0},siCisco={title:"Cisco",slug:"cisco",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Cisco</title><path d="'+this.path+'"/></svg>'},path:"M16.331 18.171V17.06l-.022.01c-.25.121-.522.19-.801.203a1.186 1.186 0 01-.806-.237 1.038 1.038 0 01-.352-.498 1.21 1.21 0 01-.023-.667c.052-.225.178-.426.357-.569.16-.134.355-.218.562-.242a1.85 1.85 0 011.061.198l.024.013v-1.117l-.051-.014a2.862 2.862 0 00-1.011-.132 2.34 2.34 0 00-.903.206c-.287.132-.54.327-.739.571a2.221 2.221 0 00-.04 2.705c.295.378.709.645 1.175.756.491.12 1.006.102 1.487-.052l.082-.023M5.336 18.171V17.06l-.022.01c-.25.121-.522.19-.801.203a1.183 1.183 0 01-.806-.237 1.03 1.03 0 01-.351-.498 1.202 1.202 0 01-.024-.667c.052-.225.177-.426.357-.569.16-.134.355-.218.562-.242a1.85 1.85 0 011.061.198l.024.013v-1.117l-.051-.014a2.862 2.862 0 00-1.011-.132 2.344 2.344 0 00-.903.206 2.08 2.08 0 00-.74.571 2.224 2.224 0 00-.041 2.705 2.11 2.11 0 001.176.756c.491.12 1.005.102 1.487-.052l.083-.023M9.26 17.249l-.004.957.07.012c.22.041.441.069.664.085.195.019.391.022.587.012.187-.014.372-.049.551-.104.21-.06.405-.163.571-.305a1.16 1.16 0 00.333-.478 1.31 1.31 0 00-.007-.96 1.068 1.068 0 00-.298-.414 1.261 1.261 0 00-.438-.255l-.722-.268a.388.388 0 01-.197-.188.245.245 0 01.008-.219.382.382 0 01.154-.142.798.798 0 01.257-.074c.153-.022.308-.021.46.005.18.02.358.051.533.096l.038.008v-.883l-.069-.015a4.749 4.749 0 00-.543-.097 2.844 2.844 0 00-.714-.003c-.3.027-.585.143-.821.33-.16.126-.281.293-.351.484-.104.29-.105.608 0 .899.054.145.14.274.252.381.097.093.207.173.327.236.157.084.324.149.497.195.057.017.114.035.17.054l.085.031.024.01c.084.03.162.078.226.14.045.042.08.094.101.151a.325.325 0 01.001.161.339.339 0 01-.166.198.856.856 0 01-.275.086 2.032 2.032 0 01-.427.021 5.208 5.208 0 01-.557-.074 9.195 9.195 0 01-.287-.067l-.033-.006zm-2.475.995h1.05v-4.167h-1.05v4.167zm12.162-2.936a1.095 1.095 0 011.541.158 1.094 1.094 0 01-.157 1.541l-.017.014a1.096 1.096 0 01-1.367-1.713m-1.525.854a2.193 2.193 0 002.666 2.107 2.139 2.139 0 00.701-3.937 2.207 2.207 0 00-3.367 1.83M22.961 10.728a.52.52 0 001.039 0V9.573a.52.52 0 00-1.039 0v1.155M20.117 10.728a.522.522 0 001.041 0V8.139a.521.521 0 00-1.04 0v2.589M17.231 11.771a.521.521 0 001.039 0V6.17a.52.52 0 00-1.039 0v5.601M14.393 10.728a.521.521 0 001.04 0V8.139a.52.52 0 00-1.039 0v2.589M11.494 10.728a.522.522 0 001.039 0V9.573a.52.52 0 00-1.039 0v1.155M8.624 10.728a.52.52 0 001.039 0V8.139a.52.52 0 00-1.039 0v2.589M5.737 11.771a.52.52 0 001.039 0V6.17a.52.52 0 00-1.039 0v5.601M2.876 10.728a.522.522 0 001.04 0V8.139a.52.52 0 00-1.039 0v2.589M0 10.728a.521.521 0 001.039 0V9.573a.52.52 0 00-1.039 0v1.155",source:"https://www.cisco.com/",hex:"1BA0D7",guidelines:void 0,license:void 0},siArchiveofourown={title:"Archive of Our Own",slug:"archiveofourown",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Archive of Our Own</title><path d="'+this.path+'"/></svg>'},path:"M18.417 9.883c-.687 1.116-1.823 1.722-2.99 1.855-4.227.484-6.047-4.149-3.469-6.728 2.31-2.31 7.082-.9 7.005 2.899-.011.611-.166 1.357-.546 1.974zm-6.459-2.029c.142 3.596 4.764 3.682 5.687 1.054.815-2.324-1.12-4.199-3.19-3.897-1.523.221-2.553 1.411-2.497 2.843zM23.123 6.003c.284-.131.697-.412.837-.246.211.251-.459.475-.748.664-.918.6-1.731 1.227-2.477 2.049-.959 1.059-1.944 2.376-2.55 3.818.618.032 3.021.157 3.6 1.481.464 1.062-.387 2.156-1.32 2.627.663.414 1.81.945 1.745 1.898-.158 2.343-3.696 2.241-5.178.695-.244-.289-.358-.482-.25-.578.151-.134.326.186.676.476.225.187.377.251.572.354 1.301.683 3.339.403 3.478-.792.064-.554-.664-.955-1.217-1.204-.498-.224-1.514-.386-1.494-.952.02-.554.524-.45 1.03-.65.55-.217 1.004-.901 1.003-1.116-.005-.905-2.062-.888-3.221-.92-.275.606-.471 1.226-.692 2.158-.139.583-.151 1.897-.748 2.029-.737.164-1.014-.477-1.455-.991-.594-.69-1.436-1.637-1.942-2.223-3.033 1.002-5.392 2.091-8.256 3.712-1.311.742-2.063 1.59-2.545 1.354-.396-.194-.339-.633-.147-.887.393-.521.927-1.225 1.396-1.888.6-.849 1.054-1.667 1.373-2.445.692-1.688 1.23-4.72 1.475-5.859.088-.412.309-.348.322-.148.027.419-.237 2.047-.29 2.383-.436 2.781-.772 4.41-2.009 6.349 2.196-1.358 4.805-3.019 7.592-3.955C8.846 9.936 5.847 6.85 1.676 4.905 1.037 4.542 0 4.464 0 4.22c0-.271.781-.06 1.043.007 2.383.596 4.817 2.141 6.601 3.444 2.145 1.567 4.714 3.967 5.679 5.081.657-.226 2.286-.457 3.696-.496.752-1.58 2.55-4.018 4.788-5.442.413-.263.842-.594 1.316-.811zm-8.594 8.071c.423.428.742.934 1.11 1.398.174-.59.405-1.216.643-1.758-.619.082-1.281.203-1.753.36z",source:"https://archiveofourown.org/",hex:"990000",guidelines:void 0,license:void 0},siBigcommerce={title:"BigCommerce",slug:"bigcommerce",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>BigCommerce</title><path d="'+this.path+'"/></svg>'},path:"M12.645 13.663h3.027c.861 0 1.406-.474 1.406-1.235 0-.717-.545-1.234-1.406-1.234h-3.027c-.1 0-.187.086-.187.172v2.125c.015.1.086.172.187.172zm0 4.896h3.128c.961 0 1.535-.488 1.535-1.35 0-.746-.545-1.35-1.535-1.35h-3.128c-.1 0-.187.087-.187.173v2.34c.015.115.086.187.187.187zM23.72.053l-8.953 8.93h1.464c2.281 0 3.63 1.435 3.63 3 0 1.235-.832 2.14-1.722 2.541-.143.058-.143.259.014.316 1.033.402 1.765 1.48 1.765 2.742 0 1.78-1.19 3.202-3.5 3.202h-6.342c-.1 0-.187-.086-.187-.172V13.85L.062 23.64c-.13.13-.043.359.143.359h23.631a.16.16 0 0 0 .158-.158V.182c.043-.158-.158-.244-.273-.13z",source:"https://www.bigcommerce.co.uk/press/media-kit/",hex:"121118",guidelines:void 0,license:void 0},siAppsignal={title:"AppSignal",slug:"appsignal",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AppSignal</title><path d="'+this.path+'"/></svg>'},path:"M21.003 7.328c-1.781 0-3.055 1.57-4.368 3.318-.815-3.714-1.72-7.424-4.601-7.424-2.881 0-3.789 3.71-4.617 7.427-1.31-1.752-2.584-3.32-4.365-3.32C1.918 7.329 0 8.098 0 10.986v5.24c0 2.832 1.512 3.527 2.42 3.766 1.565.406 5.334.786 9.578.786s8.013-.38 9.579-.786c.907-.24 2.423-.934 2.423-3.766v-5.24c0-2.888-1.92-3.658-3.052-3.658m-8.914-2.469c1.726 0 2.384 3.406 3.3 7.493-1.004 1.238-2.072 2.236-3.3 2.236-1.228 0-2.292-.998-3.3-2.236.857-3.822 1.519-7.493 3.3-7.493M1.664 16.242v-5.24c0-1.823.981-2.02 1.414-2.02 1.257 0 2.62 2.096 3.893 3.78-.91 3.818-1.873 6.143-4.145 5.664-.593-.16-1.15-.537-1.15-2.167m4.46 2.655c1.006-1.093 1.638-2.8 2.139-4.607 1.05 1.103 2.266 1.935 3.772 1.935 1.506 0 2.718-.832 3.773-1.935.488 1.807 1.13 3.514 2.135 4.607a67.507 67.507 0 0 1-11.806 0m16.282-2.655c0 1.637-.556 2.007-1.15 2.167-2.275.482-3.235-1.846-4.145-5.665 1.287-1.683 2.62-3.779 3.894-3.779.425 0 1.414.197 1.414 2.02z",source:"https://appsignal.com/",hex:"21375A",guidelines:void 0,license:void 0},siAppletv={title:"Apple TV",slug:"appletv",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apple TV</title><path d="'+this.path+'"/></svg>'},path:"M20.57 17.735h-1.815l-3.34-9.203h1.633l2.02 5.987c.075.231.273.9.586 2.012l.297-.997.33-1.006 2.094-6.004H24zm-5.344-.066a5.76 5.76 0 0 1-1.55.207c-1.23 0-1.84-.693-1.84-2.087V9.646h-1.063V8.532h1.121V7.081l1.476-.602v2.062h1.707v1.113H13.38v5.805c0 .446.074.75.214.932.14.182.396.264.75.264.207 0 .495-.041.883-.115zm-7.29-5.343c.017 1.764 1.55 2.358 1.567 2.366-.017.042-.248.842-.808 1.658-.487.71-.99 1.418-1.79 1.435-.783.016-1.03-.462-1.93-.462-.89 0-1.17.445-1.913.478-.758.025-1.344-.775-1.838-1.484-.998-1.451-1.765-4.098-.734-5.88.51-.89 1.426-1.451 2.416-1.46.75-.016 1.468.512 1.93.512.461 0 1.327-.627 2.234-.536.38.016 1.452.157 2.136 1.154-.058.033-1.278.743-1.27 2.219M6.468 7.988c.404-.495.685-1.18.61-1.864-.585.025-1.294.388-1.723.883-.38.437-.71 1.138-.619 1.806.652.05 1.328-.338 1.732-.825Z",source:"https://commons.wikimedia.org/wiki/File:AppleTV.svg",hex:"000000",guidelines:void 0,license:void 0},siAppveyor={title:"AppVeyor",slug:"appveyor",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AppVeyor</title><path d="'+this.path+'"/></svg>'},path:"M 12,0 C 18.6,0 24,5.4 24,12 24,18.6 18.6,24 12,24 5.4,24 0,18.6 0,12 0,5.4 5.4,0 12,0 Z m 2.94,14.34 C 16.26,12.66 16.08,10.26 14.4,9 12.78,7.74 10.38,8.04 9,9.72 7.68,11.4 7.86,13.8 9.54,15.06 c 1.68,1.26 4.08,0.96 5.4,-0.72 z m -6.42,7.8 c 0.72,0.3 2.28,0.6 3.06,0.6 l 5.22,-7.56 c 1.68,-2.52 1.26,-5.94 -1.08,-7.8 -2.1,-1.68 -5.04,-1.62 -7.14,0 l -7.26,5.58 c 0.18,1.92 0.72,2.88 0.72,2.94 l 4.14,-4.5 c -0.3,1.98 0.42,4.02 2.1,5.28 1.44,1.14 3.18,1.44 4.86,1.08 z",source:"https://commons.wikimedia.org/wiki/File:Appveyor_logo.svg",hex:"00B3E0",guidelines:void 0,license:void 0},siAqua={title:"Aqua",slug:"aqua",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Aqua</title><path d="'+this.path+'"/></svg>'},path:"M17.7875 18.6811c.7687 0 .7695.7105.7695.7517.0003.2888-.1047.4303-.2229.5535l-3.6066 3.6127c-.2547.2557-.5963.4006-.9567.401H.879c-.1444.0002-.2889-.0409-.4238-.1226-.2628-.1525-.46-.4826-.4551-.8042v-4.3921h17.7874zM23.0632.0001c.3202-.0053.6491.1893.8014.4518.0814.1348.1354.279.1354.4234V13.757c0 .3601-.1402.7054-.3946.9602l-3.5466 3.5524c-.137.1371-.274.2744-.6027.2744-.0411 0-.8225 0-.8225-.7681V.0001h4.4296zM4.5539 5.482s.824 0 .824.7699v12.0934H.0001v-8.0648c0-.361.1397-.7072.3945-.9625L3.95 5.757c.1372-.1376.2744-.275.6039-.275zM18.2983.0002v5.377H6.255c-.7669 0-.7669-.8233-.7669-.8233 0-.3292.137-.4663.2739-.6035L9.3087.398a1.3545 1.3545 0 01.9585-.3977h8.0311z",source:"https://www.aquasec.com/brand/",hex:"1904DA",guidelines:"https://www.aquasec.com/brand/",license:void 0},siArdour={title:"Ardour",slug:"ardour",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Ardour</title><path d="'+this.path+'"/></svg>'},path:"M12 1.606L0 22.394c1.45 0 .832-.885 1.565-.93.703 0 .559.44 1.044.44.846 0 .273-2.82 1.043-2.82.665 0 .48 2.038 1.044 2.038.288 0 .521-.811.521-1.81v-.945c0-1.304.234-2.364.522-2.364.288 0 .522 1.066.522 2.005 0 1.178.233 2.43.522 2.43.288 0 .521-1.263.521-2.805v-.44c0-1.69.234-3.065.522-3.065.288 0 .522 1.369.522 2.967 0 1.661.233 3.098.522 3.098.288 0 .521-1.437.521-3.18 0-1.737.234-3.146.522-3.146.288 0 .522 1.424.522 3.277 0 1.786.233 3.147.522 3.147.288 0 .521-1.367.521-2.87 0-1.386.234-2.657.522-2.657.288 0 .522 1.271.522 2.837v.472c0 1.415.233 2.56.521 2.56.289 0 .522-1.152.522-2.299 0-.973.234-1.989.522-1.989.288 0 .522 1.01.522 2.25v.57c0 1.058.233 1.908.521 1.908.289 0 .522-.84.522-1.614 0-.589.234-1.304.522-1.304.288 0 .522.709.522 1.581v.538c0 .696.233 1.272.521 1.272.595 0 .45-1.728 1.044-1.728.288 0 .522.43.522.962v.456c0 .385.233.685.521.685.59 0 .462-.782 1.044-.782.76 0 .197 1.076 1.043 1.076.512 0 .426-.18 1.044-.18.563 0 .493.359 1.565.359z",source:"https://github.com/Ardour/ardour/tree/master/tools/misc_resources/",hex:"C61C3E",guidelines:void 0,license:void 0},siBitcoin={title:"Bitcoin",slug:"bitcoin",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bitcoin</title><path d="'+this.path+'"/></svg>'},path:"M23.638 14.904c-1.602 6.43-8.113 10.34-14.542 8.736C2.67 22.05-1.244 15.525.362 9.105 1.962 2.67 8.475-1.243 14.9.358c6.43 1.605 10.342 8.115 8.738 14.548v-.002zm-6.35-4.613c.24-1.59-.974-2.45-2.64-3.03l.54-2.153-1.315-.33-.525 2.107c-.345-.087-.705-.167-1.064-.25l.526-2.127-1.32-.33-.54 2.165c-.285-.067-.565-.132-.84-.2l-1.815-.45-.35 1.407s.975.225.955.236c.535.136.63.486.615.766l-1.477 5.92c-.075.166-.24.406-.614.314.015.02-.96-.24-.96-.24l-.66 1.51 1.71.426.93.242-.54 2.19 1.32.327.54-2.17c.36.1.705.19 1.05.273l-.51 2.154 1.32.33.545-2.19c2.24.427 3.93.257 4.64-1.774.57-1.637-.03-2.58-1.217-3.196.854-.193 1.5-.76 1.68-1.93h.01zm-3.01 4.22c-.404 1.64-3.157.75-4.05.53l.72-2.9c.896.23 3.757.67 3.33 2.37zm.41-4.24c-.37 1.49-2.662.735-3.405.55l.654-2.64c.744.18 3.137.524 2.75 2.084v.006z",source:"https://bitcoin.org/en",hex:"F7931A",guidelines:void 0,license:void 0},siArduino={title:"Arduino",slug:"arduino",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Arduino</title><path d="'+this.path+'"/></svg>'},path:"M23.82 12a5.78 5.78 0 0 0-5.88-5.67c-.29 0-.6.02-.9.05-2.52.37-4.2 2.18-5.13 3.57-.95-1.39-2.64-3.2-5.14-3.57-.3-.03-.6-.05-.9-.05A5.78 5.78 0 0 0 0 12a5.78 5.78 0 0 0 5.87 5.67c.3 0 .6-.02.92-.06 2.52-.36 4.2-2.17 5.14-3.56.95 1.39 2.63 3.2 5.14 3.57.31.03.6.05.91.05A5.78 5.78 0 0 0 23.82 12zM6.48 15.6c-.2.04-.43.04-.63.04A3.77 3.77 0 0 1 2 11.98a3.78 3.78 0 0 1 3.86-3.66c.2 0 .42.02.63.04 2.37.35 3.82 2.67 4.31 3.62-.5.95-1.95 3.3-4.31 3.62zM13 12c.49-.93 1.94-3.27 4.31-3.62.2-.04.42-.04.62-.04A3.76 3.76 0 0 1 21.8 12a3.78 3.78 0 0 1-3.86 3.66c-.2 0-.42-.02-.62-.04-2.36-.35-3.82-2.69-4.31-3.62zm-8.79.59h3.54v-1.16H4.22v1.16zm14.13 0h1.19v-1.16h-1.2v-1.19H17.2v1.2H16v1.15h1.2v1.18h1.15V12.6zM24 7.06c0 .3-.22.51-.53.51a.51.51 0 0 1-.53-.5c0-.28.24-.52.53-.52.31 0 .53.22.53.51zm-.91 0c0 .22.16.4.4.4.22 0 .38-.18.38-.4s-.16-.4-.38-.4c-.24-.02-.4.16-.4.4zm.3.26h-.1V6.8l.2-.01c.09 0 .14.01.18.03.04.02.06.06.06.11 0 .06-.04.1-.11.11.05.02.07.06.09.13l.03.13h-.12c-.02-.02-.02-.07-.04-.13-.02-.05-.04-.07-.11-.07h-.05l-.02.22zm.02-.3h.06c.07 0 .1-.01.1-.07 0-.05-.03-.07-.1-.07h-.07v.14h.01z",source:"https://cdn.arduino.cc/projecthub/img/Arduino-logo.svg",hex:"00979D",guidelines:void 0,license:void 0},siArkecosystem={title:"ARK Ecosystem",slug:"arkecosystem",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>ARK Ecosystem</title><path d="'+this.path+'"/></svg>'},path:"M1.8 0C.806 0 0 .805 0 1.8v20.4c0 .995.805 1.8 1.8 1.8h20.4c.995 0 1.8-.805 1.8-1.8V1.8c0-.995-.805-1.8-1.8-1.8H1.8zm10.223 4.39l9.29 15.098-9.29-9.82-9.351 9.82 9.351-15.097zm0 7.583l1.633 1.691h-3.285l1.652-1.691zM9.31 14.762h5.41l1.496 1.574H7.813l1.496-1.574z",source:"https://ark.io/press-kit",hex:"C9292C",guidelines:void 0,license:void 0},siArlo={title:"Arlo",slug:"arlo",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Arlo</title><path d="'+this.path+'"/></svg>'},path:"m16.21 11.172 4.963-5.792c.943-1.293 1.494-1.828 1.07-3.94l-7.367 8.6a7.907 7.907 0 0 0-1.896 5.487L9.763 11.87a5.775 5.775 0 0 0-.947-.829A9.979 9.979 0 0 0 7 10.051c.213-.076.43-.14.649-.194.385-.094.78-.144 1.176-.147.444 0 .881.07 1.3.237.416.168.82.432 1.212.858l.216.252 1.336-1.129c-.01-.011-.241-.283-.251-.292a5.09 5.09 0 0 0-1.86-1.308 5.233 5.233 0 0 0-1.953-.364c-.151 0-.299.007-.446.017-1.461.24-2.364 1.104-3.714 1.244.001.006-4.58 0-4.581.002-.101 0-.115.144-.017.163 1.202.24 3.341.699 4.844 1.214 1.142.529 2.24 1.205 3.106 2.022.17.135.317.271.439.405l4.283 4.87c.61.501 1.395.755 3.066.767a6.197 6.197 0 0 1-.695-1.337 6.173 6.173 0 0 1-.014-4.256 6.139 6.139 0 0 1 1.114-1.903zM24 22.56c-1.734-.022-2.489-.317-3.11-.888l-.962-1.093c-.065-.079-.13-.157-.197-.234l.011.023-1.704-1.937a4.794 4.794 0 0 1-.905-4.806 4.755 4.755 0 0 1 .871-1.482l4.208-4.892c.43 2.179-.192 2.666-1.21 4.09l-1.668 1.937a3.038 3.038 0 0 0-.739 1.989c.001.741.272 1.458.761 2.014L24 22.56z",source:"https://www.arlo.com/",hex:"49B48A",guidelines:void 0,license:void 0},siArm={title:"Arm",slug:"arm",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Arm</title><path d="'+this.path+'"/></svg>'},path:"M5.419 8.534h1.614v6.911H5.419v-.72c-.71.822-1.573.933-2.07.933C1.218 15.658 0 13.882 0 11.985c0-2.253 1.542-3.633 3.37-3.633.507 0 1.4.132 2.049.984zm-3.765 3.491c0 1.198.751 2.202 1.918 2.202 1.015 0 1.959-.74 1.959-2.181 0-1.512-.934-2.233-1.959-2.233-1.167-.01-1.918.974-1.918 2.212zm7.297-3.49h1.613v.618a3 3 0 0 1 .67-.578c.314-.183.619-.233.984-.233.396 0 .822.06 1.269.324l-.66 1.462a1.432 1.432 0 0 0-.822-.244c-.345 0-.69.05-1.005.376-.446.477-.446 1.136-.446 1.593v3.582H8.94zm5.56 0h1.614v.639c.538-.66 1.177-.822 1.705-.822.72 0 1.4.345 1.786 1.015.579-.822 1.441-1.015 2.05-1.015.842 0 1.573.396 1.969 1.086.132.233.365.74.365 1.745v4.272h-1.614V11.65c0-.771-.08-1.086-.152-1.228-.101-.264-.345-.609-.923-.609-.396 0-.741.213-.954.508-.284.395-.315.984-.315 1.572v3.562H18.43V11.65c0-.771-.081-1.086-.152-1.228-.102-.264-.345-.609-.924-.609-.396 0-.74.213-.954.508-.284.395-.314.984-.314 1.572v3.562h-1.573z",source:"https://www.arm.com/",hex:"0091BD",guidelines:"https://www.arm.com/company/policies/trademarks/guidelines-corporate-logo",license:void 0},siArtifacthub={title:"Artifact Hub",slug:"artifacthub",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Artifact Hub</title><path d="'+this.path+'"/></svg>'},path:"M11.9999 24.00044c-.617.0012-1.24209-.17217-1.78008-.50002l-7.50975-4.29263c-1.01763-.61684-1.64001-1.71772-1.64066-2.9077V7.72971c0-1.25305.63694-2.36948 1.76008-3.01013L10.25041.47895c1.08003-.63867 2.41512-.63767 3.49515.001l7.41975 4.23763c1.08007.59613 1.7714 1.7341 1.76266 3.01013v8.58195c0 .96773-.44338 2.16388-1.63666 2.89856l-7.51074 4.2922c-.56347.34395-1.19861.50002-1.78167.50002zm-.50002-21.34695L3.95513 6.96224c-.2006.1567-.37906.36914-.37902.76747l.001 8.67039c.03753.22045.11891.42808.37302.63459l7.55975 4.31663c.26601.172.66403.21.98504 0l7.51792-4.29663c.23173-.14844.37102-.38858.41002-.65359V7.72971c.0095-.29884-.13595-.5886-.37702-.76547L12.49993 2.6525c-.39058-.23932-.7592-.15575-1.00004.001z",source:"https://raw.githubusercontent.com/artifacthub/hub/87a1fed/web/public/static/media/logo/artifacthub-brand-white.svg",hex:"417598",guidelines:void 0,license:void 0},siArtixlinux={title:"Artix Linux",slug:"artixlinux",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Artix Linux</title><path d="'+this.path+'"/></svg>'},path:"M12 0L7.873 8.462l11.358 6.363zM6.626 11.018L.295 24l18.788-7.762zm13.846 6.352l-5.926 3.402L23.706 24Z",source:"https://gitea.artixlinux.org/artix/artwork/src/commit/256432e3d06b3e9024bfd6912768e80281ea3746/icons/logo-gray.svg",hex:"10A0CC",guidelines:void 0,license:void 0},siArtstation={title:"ArtStation",slug:"artstation",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>ArtStation</title><path d="'+this.path+'"/></svg>'},path:"M0 17.723l2.027 3.505h.001a2.424 2.424 0 0 0 2.164 1.333h13.457l-2.792-4.838H0zm24 .025c0-.484-.143-.935-.388-1.314L15.728 2.728a2.424 2.424 0 0 0-2.142-1.289H9.419L21.598 22.54l1.92-3.325c.378-.637.482-.919.482-1.467zm-11.129-3.462L7.428 4.858l-5.444 9.428h10.887z",source:"https://www.artstation.com/about/logo",hex:"13AFF0",guidelines:void 0,license:void 0},siArxiv={title:"arXiv",slug:"arxiv",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>arXiv</title><path d="'+this.path+'"/></svg>'},path:"M16.318 8.465V9.59h1.344V8.465zm-6.9.228l2.059 3.412-2.155 3.311h1.14l1.563-2.41 1.46 2.41h1.628l-2.136-3.553 2.056-3.17h-1.125l-1.484 2.264-1.371-2.264zm-.096 6.723H9.32v.004zM2.25 10.314a5.039 5.039 0 00-1.814.348v.926a3.32 3.32 0 011.593-.445c.59 0 .883.258.883.775v.455h-.355c-.822.001-1.453.152-1.893.451a1.456 1.456 0 00-.663 1.278 1.382 1.382 0 00.408 1.033 1.48 1.48 0 001.065.398c.517 0 .998-.217 1.443-.652l.004.002h.053c.159.435.512.652 1.066.652a2.757 2.757 0 00.754-.129l-.031-.756a.803.803 0 01-.176.022c-.254 0-.377-.192-.377-.584v-2.215c.001-1.038-.653-1.559-1.961-1.559zm6.646 0c-.713 0-1.246.353-1.591 1.057v-.941H5.959v4.99h1.346v-3.178c.336-.535.768-.805 1.306-.805a1.607 1.607 0 01.534.104v-1.2a1.408 1.408 0 00-.249-.027zm7.422.116v4.994l1.344-.004v-4.99zm2.52 0l1.902 4.99h1.332L24 10.43h-.965l-1.385 3.6-1.396-3.6zM2.596 13.145h.322v1.013c-.331.305-.651.46-.982.455a.643.643 0 01-.643-.65c0-.543.433-.818 1.303-.818z",source:"https://static.arxiv.org/static/base/0.15.2/images/arxiv-logo-web.svg",hex:"B31B1B",guidelines:void 0,license:void 0},siAsana={title:"Asana",slug:"asana",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Asana</title><path d="'+this.path+'"/></svg>'},path:"M18.78 12.653c-2.882 0-5.22 2.336-5.22 5.22s2.338 5.22 5.22 5.22 5.22-2.34 5.22-5.22-2.336-5.22-5.22-5.22zm-13.56 0c-2.88 0-5.22 2.337-5.22 5.22s2.338 5.22 5.22 5.22 5.22-2.338 5.22-5.22-2.336-5.22-5.22-5.22zm12-6.525c0 2.883-2.337 5.22-5.22 5.22-2.882 0-5.22-2.337-5.22-5.22 0-2.88 2.338-5.22 5.22-5.22 2.883 0 5.22 2.34 5.22 5.22z",source:"https://asana.com/styles",hex:"273347",guidelines:void 0,license:void 0},siAsciidoctor={title:"Asciidoctor",slug:"asciidoctor",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Asciidoctor</title><path d="'+this.path+'"/></svg>'},path:"M18.0685 0H5.9318C2.6579 0 0 2.6578 0 5.9316v12.1367C0 21.3421 2.658 24 5.9318 24h12.1367C21.3423 24 24 21.3421 24 18.0683V5.9316C24 2.6578 21.3423 0 18.0685 0zM10.708 15.4038H8.8102c-.0018.0045-.0031.009-.005.0135L7.1986 19.282a.5058.5058 0 11-.934-.3883l1.4507-3.49H4.8677a.5058.5058 0 110-1.0113h5.8403a.5058.5058 0 110 1.0113zm7.9189 4.1647a.5058.5058 0 01-.6545-.2886L12.6206 6.2306l-2.395 5.761h1.551a.5058.5058 0 110 1.0113H5.9369a.5058.5058 0 110-1.0113h3.194c.0015-.0038.0026-.0075.0042-.0112l3.0223-7.2693a.5058.5058 0 01.457-.3112.5058.5058 0 01.4774.3137L18.908 18.896a.5058.5058 0 01-.2812.6725z",source:"https://github.com/asciidoctor/brand/blob/b9cf5e276616f4770c4f1227e646e7daee0cbf24/logo/logo-fill-bw.svg",hex:"E40046",guidelines:void 0,license:void 0},siAsciinema={title:"asciinema",slug:"asciinema",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>asciinema</title><path d="'+this.path+'"/></svg>'},path:"M1.61 0V24L22.39 12L1.61 0M5.76 7.2L10.06 9.68L5.76 12.16V7.2M12.55 11.12L14.08 12L5.76 16.8V15.04L12.55 11.12Z",source:"https://github.com/asciinema/asciinema-logo",hex:"D40000",guidelines:void 0,license:void 0},siAsda={title:"ASDA",slug:"asda",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>ASDA</title><path d="'+this.path+'"/></svg>'},path:"M21.7596 8.673h-2.475l-1.4114 4.0851c.0632-.3392.0743-.6104.0743-.7283 0-1.7114-.9805-3.3568-3.2843-3.3568h-2.6458l.0078 4.0635c-.2287-1.1546-1.2835-1.4639-2.5952-1.8626-.4902-.151-.7594-.3908-.6612-.6143.0839-.1952.3845-.2564.7494-.206.5564.0796 1.0008.2657 1.4287.4986l.5847-1.449c-.1318-.065-1.0792-.6337-2.2665-.6337-1.6557 0-2.7131.8078-2.7131 1.9999 0 1.0622.6542 1.6798 1.8572 2.026 1.2938.3753 1.6218.5263 1.5828.8984-.0335.3207-.8354.7113-2.7974-.4958l-.5829 1.2062-1.7994-5.431H2.3382L0 15.4244h1.9502l.3777-1.09h2.2875l.3886 1.0902h2.0473l-.2322-.6603c.6921.4 1.5504.7662 2.5772.7662 1.5728 0 2.4231-.859 2.626-1.6823v1.5764h2.638c1.5727 0 2.3953-.7498 2.8251-1.5524l-.5396 1.5524h1.9487l.39-1.0901h2.323l.3425 1.09H24L21.7594 8.673Zm-18.996 4.1365.7272-2.3196.6889 2.3196Zm11.2193.874v-3.2703h.465c.663 0 1.3867.2684 1.3867 1.6352 0 1.2105-.6392 1.6351-1.381 1.6351zm5.773-.874.6936-2.292.7224 2.292z",source:"https://www.asda.com/",hex:"68A51C",guidelines:void 0,license:void 0},siCakephp={title:"CakePHP",slug:"cakephp",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>CakePHP</title><path d="'+this.path+'"/></svg>'},path:"M0 13.875v3.745c0 2.067 5.37 3.743 12 3.743V17.62c-6.63 0-12-1.68-12-3.743v-.002zm21.384 2.333L12 13.875v3.745l9.384 2.333C23.02 19.313 24 18.503 24 17.62v-3.745c0 .882-.98 1.692-2.616 2.333zM12 10.133v3.742c-6.627 0-12-1.677-12-3.744V6.38c0-2.064 5.37-3.743 12-3.743 6.625 0 12 1.68 12 3.744v3.75c0 .883-.98 1.69-2.616 2.334L12 10.13v.003z",source:"https://cakephp.org/logos",hex:"D33C43",guidelines:void 0,license:void 0},siBlazor={title:"Blazor",slug:"blazor",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Blazor</title><path d="'+this.path+'"/></svg>'},path:"M23.8337 8.1013a13.9123 13.9123 0 0 1-13.6424 11.72 10.1053 10.1053 0 0 1-1.994-.121 6.111 6.111 0 0 1-5.0824-5.7607 5.9344 5.9344 0 0 1 11.867-.0838c.025.9835-.4011 1.8464-1.277 1.8713-.9356 0-1.3742-.6677-1.3742-1.5674v-2.5001a1.5313 1.5313 0 0 0-1.5196-1.5328H8.7152a3.6481 3.6481 0 1 0 2.6948 6.0794l.0733-.1093.0734.1213a2.5807 2.5807 0 0 0 2.2007 1.0479 2.9088 2.9088 0 0 0 2.6947-3.0406 7.912 7.912 0 0 0-.217-1.9324 7.4043 7.4043 0 0 0-14.6395 1.6033 7.4971 7.4971 0 0 0 7.307 7.4043s.549.05 1.1677.0357a15.8029 15.8029 0 0 0 8.4747-2.5283c.036-.025.0719.025.048.0614a12.4392 12.4392 0 0 1-9.6901 3.9625A8.7442 8.7442 0 0 1 .003 13.8603a9.049 9.049 0 0 1 3.6349-7.2471 8.8634 8.8634 0 0 1 5.229-1.7262h2.813a7.9145 7.9145 0 0 0 5.8386-2.5777.1093.1093 0 0 1 .0594-.034.1115.1115 0 0 1 .1195.0522.113.113 0 0 1 .0155.0672 7.9345 7.9345 0 0 1-1.2274 3.5493.1075.1075 0 0 0-.0132.0609.1098.1098 0 0 0 .0724.0945.109.109 0 0 0 .0619.0033 8.5054 8.5054 0 0 0 5.9134-4.876.1554.1554 0 0 1 .0546-.0527.1497.1497 0 0 1 .147 0 .1535.1535 0 0 1 .0546.0527 10.779 10.779 0 0 1 1.0575 6.8746zm-14.9383 3.527a2.188 2.188 0 1 0 2.1877 2.1878v-2.0425a.1577.1577 0 0 0-.1497-.1497Z",source:"https://dotnet.microsoft.com/apps/aspnet/web-apps/blazor",hex:"512BD4",guidelines:void 0,license:void 0},siBlazemeter={title:"Blazemeter",slug:"blazemeter",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Blazemeter</title><path d="'+this.path+'"/></svg>'},path:"M15.04 17.135c-.256 0-.352-.128-.32-.352l1.696-9.566c.032-.224.16-.352.416-.352h3.584c2.4 0 3.584.736 3.584 2.24 0 .607-.16 1.151-.48 1.6-.32.48-.768.8-1.344.991.384.096.736.32.96.672.256.32.384.768.384 1.28 0 1.215-.416 2.08-1.248 2.655-.832.544-1.952.832-3.328.832H15.04zm3.968-1.664c1.664 0 2.496-.608 2.496-1.823 0-.384-.16-.64-.448-.832-.288-.192-.8-.256-1.472-.256h-2.08l-.512 2.88h2.016v.031zm.768-4.383c1.472 0 2.176-.544 2.176-1.663 0-.352-.128-.576-.416-.736-.288-.16-.736-.224-1.344-.224h-1.984l-.48 2.623h2.048zm-6.88-.256a.608.608 0 0 0-.608-.608H.608a.608.608 0 1 0 0 1.216h11.648c.352 0 .64-.256.64-.608zm1.344-2.175a.608.608 0 0 0-.608-.608H6.464a.608.608 0 1 0 0 1.216h7.168c.32 0 .608-.256.608-.608zm-2.464 6.654a.608.608 0 0 0-.608-.608H8.256a.608.608 0 1 0 0 1.216h2.912c.32 0 .608-.256.608-.608zm-.864-2.271a.608.608 0 0 0-.608-.608H3.2a.608.608 0 1 0 0 1.216h7.104a.63.63 0 0 0 .608-.608z",source:"https://www.blazemeter.com/",hex:"CA2133",guidelines:void 0,license:void 0},siBlender={title:"Blender",slug:"blender",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Blender</title><path d="'+this.path+'"/></svg>'},path:"M12.51 13.214c.046-.8.438-1.506 1.03-2.006a3.424 3.424 0 0 1 2.212-.79c.85 0 1.631.3 2.211.79.592.5.983 1.206 1.028 2.005.045.823-.285 1.586-.865 2.153a3.389 3.389 0 0 1-2.374.938 3.393 3.393 0 0 1-2.376-.938c-.58-.567-.91-1.33-.865-2.152M7.35 14.831c.006.314.106.922.256 1.398a7.372 7.372 0 0 0 1.593 2.757 8.227 8.227 0 0 0 2.787 2.001 8.947 8.947 0 0 0 3.66.76 8.964 8.964 0 0 0 3.657-.772 8.285 8.285 0 0 0 2.785-2.01 7.428 7.428 0 0 0 1.592-2.762 6.964 6.964 0 0 0 .25-3.074 7.123 7.123 0 0 0-1.016-2.779 7.764 7.764 0 0 0-1.852-2.043h.002L13.566 2.55l-.02-.015c-.492-.378-1.319-.376-1.86.002-.547.382-.609 1.015-.123 1.415l-.001.001 3.126 2.543-9.53.01h-.013c-.788.001-1.545.518-1.695 1.172-.154.665.38 1.217 1.2 1.22V8.9l4.83-.01-8.62 6.617-.034.025c-.813.622-1.075 1.658-.563 2.313.52.667 1.625.668 2.447.004L7.414 14s-.069.52-.063.831zm12.09 1.741c-.97.988-2.326 1.548-3.795 1.55-1.47.004-2.827-.552-3.797-1.538a4.51 4.51 0 0 1-1.036-1.622 4.282 4.282 0 0 1 .282-3.519 4.702 4.702 0 0 1 1.153-1.371c.942-.768 2.141-1.183 3.396-1.185 1.256-.002 2.455.41 3.398 1.175.48.391.87.854 1.152 1.367a4.28 4.28 0 0 1 .522 1.706 4.236 4.236 0 0 1-.239 1.811 4.54 4.54 0 0 1-1.035 1.626",source:"https://www.blender.org/about/logo/",hex:"F5792A",guidelines:void 0,license:void 0},siBlogger={title:"Blogger",slug:"blogger",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Blogger</title><path d="'+this.path+'"/></svg>'},path:"M21.976 24H2.026C.9 24 0 23.1 0 21.976V2.026C0 .9.9 0 2.025 0H22.05C23.1 0 24 .9 24 2.025v19.95C24 23.1 23.1 24 21.976 24zM12 3.975H9c-2.775 0-5.025 2.25-5.025 5.025v6c0 2.774 2.25 5.024 5.025 5.024h6c2.774 0 5.024-2.25 5.024-5.024v-3.975c0-.6-.45-1.05-1.05-1.05H18c-.524 0-.976-.45-.976-.976 0-2.776-2.25-5.026-5.024-5.026zm3.074 12H9c-.525 0-.975-.45-.975-.975s.45-.976.975-.976h6.074c.526 0 .977.45.977.976s-.45.976-.975.976zm-2.55-7.95c.527 0 .976.45.976.975s-.45.975-.975.975h-3.6c-.525 0-.976-.45-.976-.975s.45-.975.975-.975h3.6z",source:"https://www.blogger.com",hex:"FF5722",guidelines:void 0,license:void 0},siBlockchaindotcom={title:"Blockchain.com",slug:"blockchaindotcom",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Blockchain.com</title><path d="'+this.path+'"/></svg>'},path:"M19.8285 6.6117l-5.52-5.535a3.1352 3.1352 0 00-4.5 0l-5.535 5.535 7.755 3.87zm2.118 2.235l1.095 1.095a3.12 3.12 0 010 4.5L14.22 23.3502a2.6846 2.6846 0 01-.72.525V13.0767zm-19.893 0l-1.095 1.095a3.1198 3.1198 0 000 4.5L9.78 23.3502c.2091.214.4525.3914.72.525V13.0767z",source:"https://www.blockchain.com/",hex:"121D33",guidelines:"https://www.blockchain.com/en/press",license:void 0},siBloglovin={title:"Bloglovin",slug:"bloglovin",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bloglovin</title><path d="'+this.path+'"/></svg>'},path:"M12.526 11.695c1.84-.382 3.367-2.044 3.367-4.478 0-2.604-1.9-4.97-5.615-4.97H0v19.506h10.6c3.75 0 5.683-2.341 5.683-5.292-.009-2.426-1.646-4.444-3.757-4.766zm-8.37-5.793h5.207c1.407 0 2.28.849 2.28 2.044 0 1.255-.881 2.044-2.28 2.044H4.155zM9.54 18.098H4.155v-4.444h5.386c1.61 0 2.484.992 2.484 2.222.009 1.399-.932 2.222-2.484 2.222zM21.396 2.28c-1.255 0-2.315 1.052-2.315 2.307s.882 2.103 1.993 2.103c.238 0 .467-.025.56-.085-.238 1.052-1.315 2.282-2.256 2.782l1.611 1.314C22.796 9.422 24 7.462 24 5.266c0-1.9-1.23-2.985-2.604-2.985Z",source:"https://www.bloglovin.com/widgets",hex:"000000",guidelines:void 0,license:void 0},siBuymeacoffee={title:"Buy Me A Coffee",slug:"buymeacoffee",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Buy Me A Coffee</title><path d="'+this.path+'"/></svg>'},path:"M20.216 6.415l-.132-.666c-.119-.598-.388-1.163-1.001-1.379-.197-.069-.42-.098-.57-.241-.152-.143-.196-.366-.231-.572-.065-.378-.125-.756-.192-1.133-.057-.325-.102-.69-.25-.987-.195-.4-.597-.634-.996-.788a5.723 5.723 0 00-.626-.194c-1-.263-2.05-.36-3.077-.416a25.834 25.834 0 00-3.7.062c-.915.083-1.88.184-2.75.5-.318.116-.646.256-.888.501-.297.302-.393.77-.177 1.146.154.267.415.456.692.58.36.162.737.284 1.123.366 1.075.238 2.189.331 3.287.37 1.218.05 2.437.01 3.65-.118.299-.033.598-.073.896-.119.352-.054.578-.513.474-.834-.124-.383-.457-.531-.834-.473-.466.074-.96.108-1.382.146-1.177.08-2.358.082-3.536.006a22.228 22.228 0 01-1.157-.107c-.086-.01-.18-.025-.258-.036-.243-.036-.484-.08-.724-.13-.111-.027-.111-.185 0-.212h.005c.277-.06.557-.108.838-.147h.002c.131-.009.263-.032.394-.048a25.076 25.076 0 013.426-.12c.674.019 1.347.067 2.017.144l.228.031c.267.04.533.088.798.145.392.085.895.113 1.07.542.055.137.08.288.111.431l.319 1.484a.237.237 0 01-.199.284h-.003c-.037.006-.075.01-.112.015a36.704 36.704 0 01-4.743.295 37.059 37.059 0 01-4.699-.304c-.14-.017-.293-.042-.417-.06-.326-.048-.649-.108-.973-.161-.393-.065-.768-.032-1.123.161-.29.16-.527.404-.675.701-.154.316-.199.66-.267 1-.069.34-.176.707-.135 1.056.087.753.613 1.365 1.37 1.502a39.69 39.69 0 0011.343.376.483.483 0 01.535.53l-.071.697-1.018 9.907c-.041.41-.047.832-.125 1.237-.122.637-.553 1.028-1.182 1.171-.577.131-1.165.2-1.756.205-.656.004-1.31-.025-1.966-.022-.699.004-1.556-.06-2.095-.58-.475-.458-.54-1.174-.605-1.793l-.731-7.013-.322-3.094c-.037-.351-.286-.695-.678-.678-.336.015-.718.3-.678.679l.228 2.185.949 9.112c.147 1.344 1.174 2.068 2.446 2.272.742.12 1.503.144 2.257.156.966.016 1.942.053 2.892-.122 1.408-.258 2.465-1.198 2.616-2.657.34-3.332.683-6.663 1.024-9.995l.215-2.087a.484.484 0 01.39-.426c.402-.078.787-.212 1.074-.518.455-.488.546-1.124.385-1.766zm-1.478.772c-.145.137-.363.201-.578.233-2.416.359-4.866.54-7.308.46-1.748-.06-3.477-.254-5.207-.498-.17-.024-.353-.055-.47-.18-.22-.236-.111-.71-.054-.995.052-.26.152-.609.463-.646.484-.057 1.046.148 1.526.22.577.088 1.156.159 1.737.212 2.48.226 5.002.19 7.472-.14.45-.06.899-.13 1.345-.21.399-.072.84-.206 1.08.206.166.281.188.657.162.974a.544.544 0 01-.169.364zm-6.159 3.9c-.862.37-1.84.788-3.109.788a5.884 5.884 0 01-1.569-.217l.877 9.004c.065.78.717 1.38 1.5 1.38 0 0 1.243.065 1.658.065.447 0 1.786-.065 1.786-.065.783 0 1.434-.6 1.499-1.38l.94-9.95a3.996 3.996 0 00-1.322-.238c-.826 0-1.491.284-2.26.613z",source:"https://www.buymeacoffee.com/brand",hex:"FFDD00",guidelines:void 0,license:void 0},siBlueprint={title:"Blueprint",slug:"blueprint",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Blueprint</title><path d="'+this.path+'"/></svg>'},path:"M21.809 5.524L12.806.179l-.013-.007.078-.045h-.166a1.282 1.282 0 0 0-1.196.043l-.699.403-8.604 4.954a1.285 1.285 0 0 0-.644 1.113v10.718c0 .46.245.884.644 1.113l9.304 5.357c.402.232.898.228 1.297-.009l9.002-5.345c.39-.231.629-.651.629-1.105V6.628c0-.453-.239-.873-.629-1.104zm-19.282.559L11.843.719a.642.642 0 0 1 .636.012l9.002 5.345a.638.638 0 0 1 .207.203l-4.543 2.555-4.498-2.7a.963.963 0 0 0-.968-.014L6.83 8.848 2.287 6.329a.644.644 0 0 1 .24-.246zm14.13 8.293l-4.496-2.492V6.641a.32.32 0 0 1 .155.045l4.341 2.605v5.085zm-4.763-1.906l4.692 2.601-4.431 2.659-4.648-2.615a.317.317 0 0 1-.115-.112l4.502-2.533zm-.064 10.802l-9.304-5.357a.643.643 0 0 1-.322-.557V7.018L6.7 9.51v5.324c0 .348.188.669.491.84l4.811 2.706.157.088v4.887a.637.637 0 0 1-.329-.083z",source:"https://blueprintjs.com",hex:"137CBD",guidelines:void 0,license:void 0},siBmcsoftware={title:"BMC Software",slug:"bmcsoftware",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>BMC Software</title><path d="'+this.path+'"/></svg>'},path:"M6.375 23.999c-.95 0-1.95-.749-1.95-2.2v-3.4c0-1.349.85-2.899 2.05-3.548l4.75-2.8-4.75-2.8C5.325 8.5 4.425 7 4.425 5.65V2.2c0-1.45 1-2.2 2.002-2.2.4 0 .849.1 1.249.35l10.7 6.35c.75.45 1.15 1.149 1.15 1.849 0 .75-.452 1.45-1.15 1.85l-2.55 1.5 2.55 1.501c.75.45 1.2 1.15 1.2 1.85 0 .75-.452 1.45-1.2 1.85L7.674 23.65c-.45.25-.85.35-1.3.35zm7.15-10.599l-5.85 3.45c-.45.25-.9 1.05-.9 1.55v3.05l10.15-6zM6.775 2.6v3.05c0 .5.45 1.3.9 1.55l5.85 3.45 3.45-2.05z",source:"https://www.bmc.com/",hex:"FE5000",guidelines:void 0,license:void 0},siBoehringeringelheim={title:"Boehringer Ingelheim",slug:"boehringeringelheim",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Boehringer Ingelheim</title><path d="'+this.path+'"/></svg>'},path:"M12.53029 7.32626v16.64847C12.32849 24 12.22723 24 12.00009 24c-.22738 0-.3539 0-.55609-.02527V7.32626h1.08629zm-2.39964.00006v16.57275c-.42958-.076-.85921-.2022-1.08628-.27786V7.32632h1.08628zm4.79978-.00006v16.26937c-.55577.17692-.78316.25265-1.08628.30344V7.32626h1.08628zm-7.1998 7.73063v8.15995c-.22739-.07574-.32864-.1262-.55577-.2274-.17693-.07572-.30312-.12619-.53051-.25264v-7.67991h1.08628zm9.62502 0v7.67984c-.42932.20219-.73237.3539-1.11155.48004V15.0569h1.11155zM12.00015 0c6.64404 0 11.99985 5.38108 11.99985 12.05063 0 2.65267-.8589 5.22935-2.42528 7.225-.7075.93488-1.3894 1.54112-2.9306 2.70314v-6.92188h1.08629v4.90097c2.27388-2.6022 3.25891-4.9767 3.25891-7.9325C22.98932 5.86112 18.08835.8841 12.0001.8841 5.91152.8841.98529 5.88632.98529 12.07583c0 2.82934.90936 5.02717 3.25891 7.88203v-4.90097h1.11155v6.92188c-1.23794-.73238-2.39996-1.91998-3.41057-3.41032C.6567 16.62328 0 14.45066 0 12.1263 0 5.38108 5.33061 0 12.00016 0zm.00001 2.65267l3.63777 2.85454-.63151.73276-3.00626-2.34955-3.00658 2.34955-.63144-.7075 3.63802-2.8798z",source:"https://cd.boehringer-ingelheim.com",hex:"003366",guidelines:void 0,license:void 0},siBmw={title:"BMW",slug:"bmw",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>BMW</title><path d="'+this.path+'"/></svg>'},path:"M12 0C5.373 0 0 5.373 0 12s5.373 12 12 12 12-5.373 12-12S18.627 0 12 0zm0 .78C18.196.78 23.219 5.803 23.219 12c0 6.196-5.022 11.219-11.219 11.219C5.803 23.219.781 18.196.781 12S5.804.78 12 .78zm-.678.63c-.33.014-.66.042-.992.078l-.107 2.944a9.95 9.95 0 0 1 .71-.094l.07-1.988-.013-.137.043.13.664 1.489h.606l.664-1.488.04-.131-.01.137.07 1.988c.232.022.473.054.71.094l-.109-2.944a14.746 14.746 0 0 0-.992-.078l-.653 1.625-.023.12-.023-.12-.655-1.625zm6.696 1.824l-1.543 2.428c.195.15.452.371.617.522l1.453-.754.092-.069-.069.094-.752 1.453c.163.175.398.458.53.63l2.43-1.544a16.135 16.135 0 0 0-.46-.568L18.777 6.44l-.105.092.078-.115.68-1.356-.48-.48-1.356.68-.115.078.091-.106 1.018-1.539c-.18-.152-.351-.291-.57-.46zM5.5 3.785c-.36.037-.638.283-1.393 1.125a18.97 18.97 0 0 0-.757.914l2.074 1.967c.687-.76.966-1.042 1.508-1.613.383-.405.6-.87.216-1.317-.208-.242-.558-.295-.85-.175l-.028.01.01-.026a.7.7 0 0 0-.243-.734.724.724 0 0 0-.537-.15zm.006.615c.136-.037.277.06.308.2.032.14-.056.272-.154.382-.22.25-1.031 1.098-1.031 1.098l-.402-.383c.417-.51.861-.974 1.062-1.158a.55.55 0 0 1 .217-.139zM12 4.883a7.114 7.114 0 0 0-7.08 6.388v.002a7.122 7.122 0 0 0 8.516 7.697 7.112 7.112 0 0 0 5.68-6.97A7.122 7.122 0 0 0 12 4.885v-.002zm-5.537.242c.047 0 .096.013.14.043.088.059.128.16.106.26-.026.119-.125.231-.205.318l-1.045 1.12-.42-.4s.787-.832 1.045-1.099c.102-.106.168-.17.238-.205a.331.331 0 0 1 .14-.037zM12 5.818A6.175 6.175 0 0 1 18.182 12H12v6.182A6.175 6.175 0 0 1 5.818 12H12V5.818Z",source:"https://www.bmw.de/",hex:"0066B1",guidelines:void 0,license:void 0},siBoeing={title:"Boeing",slug:"boeing",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Boeing</title><path d="'+this.path+'"/></svg>'},path:"M6.9044 17.2866a6.0512 6.0512 0 01-3.7595-1.3008c1.2048-2.7146 3.6545-6.3581 6.998-9.9166a6.0702 6.0702 0 012.2617 7.729c-1.0599-.49-2.0497-1.106-2.8876-1.8798l1.8307 3.4375a6.0582 6.0582 0 01-4.4433 1.9307M.8292 11.2115a6.0752 6.0752 0 016.0762-6.0772c.8998 0 1.7527.196 2.5226.546-3.2935 2.9095-5.8432 6.293-7.353 9.2177a6.0512 6.0512 0 01-1.2458-3.6875m12.3403 2.9126a6.862 6.862 0 00.6419-2.9126c0-2.3997-1.2248-4.5144-3.0846-5.7532a49.6072 49.6072 0 013.5825-3.3416A31.1727 31.1727 0 0010.11 5.0903a6.907 6.907 0 00-8.4368 10.6265C.3493 18.5795.1193 20.8781 1.285 21.654c1.2489.832 3.9625-.6769 5.5903-3.1345 0 0-2.5177 2.2736-3.9015 1.7517-.8519-.322-.8549-1.6248-.152-3.4925a6.871 6.871 0 004.0835 1.3378c1.8937 0 3.6065-.7599 4.8533-1.9917l.245.462c3.0095-.245 11.9963-.483 11.9963-.483 0-.431-5.9502-.04-10.8325-1.9797",source:"https://commons.wikimedia.org/wiki/File:Boeing_full_logo.svg",hex:"1D439C",guidelines:void 0,license:void 0},siBookmeter={title:"Bookmeter",slug:"bookmeter",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bookmeter</title><path d="'+this.path+'"/></svg>'},path:"M.678 14.262h6.089V24H.678v-9.738zm8.215 9.717h6.089V7.11H8.893v16.869zM17.234 0v24h6.089V0h-6.089z",source:"https://bookmeter.com/",hex:"64BC4B",guidelines:void 0,license:void 0},siBookbub={title:"BookBub",slug:"bookbub",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>BookBub</title><path d="'+this.path+'"/></svg>'},path:"M0 20V4h5.4c1.6 0 2.8.3 3.8 1 .9.7 1.4 1.6 1.4 2.7 0 .8-.3 1.6-.8 2.3-.6.7-1.3 1.2-2.2 1.4 1.1.1 2 .6 2.7 1.3.7.7 1 1.6 1 2.6 0 1.4-.5 2.6-1.5 3.4-1 .9-2.4 1.3-4.1 1.3H0zM3 6.4v4.2h1.7c.8 0 1.5-.2 1.9-.6.4-.4.7-1 .7-1.7 0-1.3-.9-1.9-2.7-1.9H3zM3 13v4.7h2.1c.9 0 1.6-.2 2.1-.6.5-.5.8-1.1.8-1.9C8 13.7 7 13 5 13H3zm9.7 7V4h5.4c1.6 0 2.8.3 3.8 1 .9.7 1.4 1.6 1.4 2.7 0 .8-.3 1.6-.8 2.3-.6.7-1.3 1.2-2.2 1.4 1.1.1 2 .6 2.7 1.3.7.7 1 1.6 1 2.6 0 1.4-.5 2.6-1.5 3.4-1 .9-2.4 1.3-4.1 1.3h-5.7zm3-13.6v4.2h1.7c.8 0 1.5-.2 1.9-.6s.7-1 .7-1.7c0-1.3-.9-1.9-2.7-1.9h-1.6zm0 6.6v4.7h2.1c.9 0 1.6-.2 2.1-.6.5-.4.7-1 .7-1.8 0-1.5-1-2.3-3-2.3h-1.9z",source:"https://insights.bookbub.com/bookbub-follow-bookmark-buttons-for-authors-websites/",hex:"F44336",guidelines:void 0,license:void 0},siBookstack={title:"BookStack",slug:"bookstack",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>BookStack</title><path d="'+this.path+'"/></svg>'},path:"M.3013 17.6146c-.1299-.3387-.5228-1.5119-.1337-2.4314l9.8273 5.6738a.329.329 0 0 0 .3299 0L24 12.9616v2.3542l-13.8401 7.9906-9.8586-5.6918zM.1911 8.9628c-.2882.8769.0149 2.0581.1236 2.4261l9.8452 5.6841L24 9.0823V6.7275L10.3248 14.623a.329.329 0 0 1-.3299 0L.1911 8.9628zm13.1698-1.9361c-.1819.1113-.4394.0015-.4852-.2064l-.2805-1.1336-2.1254-.1752a.33.33 0 0 1-.1378-.6145l5.5782-3.2207-1.7021-.9826L.6979 8.4935l9.462 5.463 13.5104-7.8004-4.401-2.5407-5.9084 3.4113zm-.1821-1.7286.2321.938 5.1984-3.0014-2.0395-1.1775-4.994 2.8834 1.3099.108a.3302.3302 0 0 1 .2931.2495zM24 9.845l-13.6752 7.8954a.329.329 0 0 1-.3299 0L.1678 12.0667c-.3891.919.003 2.0914.1332 2.4311l9.8589 5.692L24 12.1993V9.845z",source:"https://www.bookstackapp.com/",hex:"0288D1",guidelines:void 0,license:void 0},siBoots={title:"Boots",slug:"boots",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Boots</title><path d="'+this.path+'"/></svg>'},path:"M22.979 8.337c.201-.23.326-.516.326-.73 0-.143-.083-.234-.218-.234-.224 0-.493.276-.493.691a.848.848 0 0 0 .018.175c-.257.4-.524.807-.793 1.198a1.491 1.491 0 0 0-.292-.029c-.649 0-1.319.487-1.319 1.367a1.697 1.697 0 0 0 .114.632c-.555.633-1.044 1.044-1.375 1.044-.13 0-.208-.071-.208-.219 0-.158.076-.409.229-.758l1.91-4.228 2.062-.242.234-.489-1.993.067.346-.763-.776.092-.35.695-2.79.09-.501.995 2.917-.344-.587 1.165a2.636 2.636 0 0 0-1.086-.212 3.927 3.927 0 0 0-1.766.425 1.81 1.81 0 0 0-.792-.175c-.673 0-1.436.324-2.056.893-.126-.388-.39-.62-.778-.62-.454 0-.935.238-1.396.623-.276-.225-.673-.29-1.095-.132a2.802 2.802 0 0 0 .35-1.317c0-.781-.365-1.354-1.032-1.7a5.165 5.165 0 0 1 .723-.493 1.72 1.72 0 0 0-.233-.164 6.642 6.642 0 0 0-.942.473c-.42-.134-.922-.202-1.496-.202C5.18 5.911 2.66 7.45 2.66 9.35c0 .837.473 1.137.942 1.137.438 0 .866-.246 1.002-.544-.381-.078-.607-.408-.607-.827 0-1.481 1.792-2.774 3.63-2.774.412 0 .769.077 1.062.218-1.117.86-1.975 2.03-2.682 3.282a1.937 1.937 0 0 0-.298-.024c-.528 0-.91.224-.91.666 0 .298.194.554.494.739-.44.911-.822 1.822-1.19 2.652-.128-.252-.419-.416-.755-.416-.807 0-1.418.712-1.418 1.594 0 .575.233 1.125.636 1.566-.38.425-.796.676-1.28.69a.858.858 0 0 1-.452-.114c.38-.042.692-.325.683-.692-.008-.367-.314-.628-.734-.617a.793.793 0 0 0-.783.817c.017.695.608 1.062 1.38 1.044.667-.015 1.24-.253 1.75-.654a3.266 3.266 0 0 0 1.769.5c2.049 0 3.787-1.745 3.787-4.087 0-.93-.24-1.668-.599-2.231a4.598 4.598 0 0 0 1.705-1.06c.637-.63 1.11-.572 1.381-.403-1.057 1.097-1.916 2.867-1.916 4.056 0 .737.295 1.217.862 1.217 1.7 0 3.73-3.278 3.705-5.08.546-.605 1.276-.965 1.869-.965a1.186 1.186 0 0 1 .307.037c-1.329.94-2.157 2.547-2.157 3.782 0 .655.322 1.152.95 1.152 1.17 0 2.692-1.823 2.692-3.64 0-.559-.159-.978-.41-1.273a2.599 2.599 0 0 1 1.34-.392 2.11 2.11 0 0 1 .834.18l-1.172 2.323c-.272.568-.378.988-.378 1.293 0 .469.275.71.711.71.636 0 1.385-.59 2.132-1.436.323.4.826.579 1.242.579a2.215 2.215 0 0 0 .404-.039c-.314.397-.838.696-1.607.889l-10.17 2.548c-1.545.386-2.49 1.148-2.034 2.608.353-.29.987-.573 2.63-1.073l9.232-2.816c1.35-.411 2.207-1.38 2.572-2.356.628-.306 1.189-.89 1.189-1.7.001-.894-.749-1.429-1.021-2.078zm-16.16 2.322a2.241 2.241 0 0 1 .321.33 3.023 3.023 0 0 1-.503.062q.09-.197.182-.392zm-1.592-.214c0-.231.279-.27.577-.236q-.162.3-.314.604c-.167-.105-.263-.235-.263-.368zm-2.271 5.663c-.34-.317-.507-.727-.502-1.068a1 1 0 0 1 .12-.462.756.756 0 0 0 .693.418.903.903 0 0 0 .35-.071 10.415 10.415 0 0 1-.661 1.183zm1.403.511a2.317 2.317 0 0 1-.641-.086c1.053-1.185 1.84-3.085 2.697-4.993a4.882 4.882 0 0 0 1.013-.087c.172.363.277.805.277 1.331 0 1.723-1.266 3.835-3.346 3.835zm3.366-5.816a3.254 3.254 0 0 0-.7-.577c.608-1.251 1.284-2.432 2.13-3.335.287.297.443.702.443 1.186-.001 1.204-.796 2.262-1.872 2.726zm2.597 3.579c-.164 0-.246-.142-.246-.382 0-1.047 1.778-4.474 2.673-4.474.17 0 .246.142.246.388-.002 1.058-1.77 4.468-2.673 4.468zm4.588-.996c-.17 0-.245-.135-.245-.388 0-.81.72-2.513 1.877-3.511.128.213.186.482.187.763.005 1.34-1.224 3.136-1.82 3.136zm5.744-2.368a1.326 1.326 0 0 1-.032-.295c0-.523.373-.946.865-.946q.05 0 .096.004c-.317.446-.63.866-.931 1.237zm1.867.593a1.275 1.275 0 0 1-.763.252c-.385 0-.713-.159-.917-.432.387-.47.77-.997 1.13-1.533.42.236.592.782.592 1.276a2.15 2.15 0 0 1-.044.437zm.494-.6c-.015-.6-.315-1.175-.825-1.444.202-.308.396-.617.579-.917.191.39.477.813.477 1.368a2.214 2.214 0 0 1-.232.994z",source:"https://www.boots-uk.com/css/images/Boots_logo.svg",hex:"05054B",guidelines:void 0,license:void 0},siBoost={title:"Boost",slug:"boost",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Boost</title><path d="'+this.path+'"/></svg>'},path:"M4.428 2.727l3.335 3.335c-.486.07-.903.276-1.32.624L.886 12.383c-1.181 1.18-1.181 3.194 0 4.375a2.41 2.41 0 0 0 1.598.834l17.088 3.681-3.335-3.333c.486-.07.903-.278 1.32-.626l5.557-5.695c1.181-1.181 1.181-3.196 0-4.377a2.411 2.411 0 0 0-1.598-.833zM11.653 6.2c.694 0 1.25.486 1.25 1.18 0 .695-.486 1.251-1.181 1.251-.695 0-1.25-.485-1.25-1.18s.555-1.251 1.18-1.251zm1.51 3.792c.049-.006.088.046.088.098-.139.694-.695 1.181-1.39 1.181-.694 0-1.32-.487-1.46-1.112 0 0 .002-.07.071 0 .487.278.972.348 1.32.278.346 0 .833-.07 1.32-.416a.092.092 0 0 1 .05-.029zm.723 2.511c.058.013.06.106.06.158-.209.903-.973 1.666-1.946 1.666a2.167 2.167 0 0 1-2.084-1.528c-.07-.07 0-.138.138-.138.695.347 1.39.416 1.877.416.486 0 1.18-.14 1.875-.556.035-.017.06-.022.08-.018zm.597 3.018c.049-.013.087.09.087.195-.278 1.181-1.25 2.085-2.5 2.155-1.251 0-2.293-.835-2.57-1.946 0-.139.068-.278.207-.209.834.486 1.737.556 2.362.556s1.529-.208 2.362-.694c.018-.035.036-.053.052-.057z",source:"https://www.boostmobile.com/",hex:"F7901E",guidelines:void 0,license:void 0},siBosch={title:"Bosch",slug:"bosch",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bosch</title><path d="'+this.path+'"/></svg>'},path:"M12 0C5.373 0 0 5.373 0 12s5.373 12 12 12 12-5.373 12-12C23.996 5.374 18.626.004 12 0zm0 22.88C5.991 22.88 1.12 18.009 1.12 12S5.991 1.12 12 1.12 22.88 5.991 22.88 12c-.006 6.006-4.874 10.874-10.88 10.88zm4.954-18.374h-.821v4.108h-8.24V4.506h-.847a8.978 8.978 0 0 0 0 14.988h.846v-4.108h8.24v4.108h.822a8.978 8.978 0 0 0 0-14.988zM6.747 17.876a7.86 7.86 0 0 1 0-11.752v11.752zm9.386-3.635h-8.24V9.734h8.24v4.507zm1.12 3.61V6.124a7.882 7.882 0 0 1 0 11.727z",source:"https://www.bosch.de/",hex:"EA0016",guidelines:void 0,license:void 0},siBose={title:"Bose",slug:"bose",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bose</title><path d="'+this.path+'"/></svg>'},path:"M14.051 10.555a.686.686 0 00-.588.34c-.11.194-.426.742-.54.936a.27.27 0 00.236.409h1.873l-.336.582a.271.271 0 01-.24.142h-.29c-.097 0-.137-.105-.103-.168.035-.063.112-.194.112-.194h-1.698l-.246.426c-.115.2.038.416.233.416h3.173a.69.69 0 00.598-.349c.121-.21.405-.706.528-.916a.27.27 0 00-.228-.42h-1.873l.346-.6a.274.274 0 01.231-.125h.292c.096 0 .136.104.106.159a14.05 14.05 0 01-.118.204h1.696l.255-.44a.273.273 0 00-.24-.402h-3.179m-2.94.65a1307.162 1307.217 0 00-.936 1.622.275.275 0 01-.236.137h-.295c-.095 0-.138-.104-.102-.168l.94-1.629a.275.275 0 01.236-.133h.295a.113.113 0 01.098.171m1.597-.65h-3.17a.695.695 0 00-.593.337l-1.238 2.145c-.11.19.04.407.236.407h3.176c.256 0 .48-.145.593-.338l1.236-2.143a.272.272 0 00-.24-.408m-5.723.65l-.243.42a.266.266 0 01-.233.134h-.9l.419-.725h.858c.089 0 .14.096.099.17M6.29 12.41l-.243.42a.266.266 0 01-.233.134h-.9l.42-.724h.857c.089 0 .14.095.099.17m1.902-1.855H4.61l-1.392 2.41H0v.48l6.599-.001c.24 0 .468-.125.595-.344l.41-.713c.086-.148-.005-.338-.163-.387a.698.698 0 00.583-.337l.402-.698a.272.272 0 00-.234-.41m9.986 0l-1.667 2.889h4.042l.277-.48h-2.346l.418-.724h2.346l.277-.48H19.18l.418-.726H24v-.479h-5.82z",source:"https://developer.bose.com/sites/default/files/Bose%20AR%20Design%20Guidelines%20v1.0.pdf",hex:"000000",guidelines:void 0,license:void 0},siBoulanger={title:"boulanger",slug:"boulanger",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>boulanger</title><path d="'+this.path+'"/></svg>'},path:"M8.405 3.612v3.5777h5.6616c2.987.0347 5.3836 2.4311 5.3836 5.4181-.0347 2.987-2.4313 5.3834-5.3836 5.4181h-3.1259c-2.987 0-5.4181-2.431-5.4181-5.418V8.4052c0-2.084 1.1458-3.8903 2.8824-4.7933zC3.7856 3.612 0 7.3975 0 12.017c0 4.6194 3.7162 8.371 8.3704 8.371h7.2592C20.249 20.388 24 16.6711 24 12.017c0-4.6542-3.6815-8.405-8.3704-8.405zm.0353 6.4255v2.5357c0 1.3893 1.1457 2.535 2.535 2.535h3.0222c1.3893 0 2.535-1.1457 2.535-2.535 0-1.3893-1.111-2.5357-2.535-2.5357z",source:"https://www.boulanger.com/",hex:"FD5300",guidelines:void 0,license:void 0},siBower={title:"Bower",slug:"bower",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bower</title><path d="'+this.path+'"/></svg>'},path:"M23.542 11.756c-1.235-1.187-7.408-1.927-9.355-2.142.094-.223.175-.454.242-.691.266-.117.552-.225.848-.315.036.107.207.515.303.709 3.917.108 4.118-2.91 4.277-3.738.156-.808.149-1.59 1.492-3.018-2.001-.584-4.88.904-5.844 3.118a5.981 5.981 0 00-1.085-.298c-.257-1.038-1.597-3.93-5.114-3.93-2.278 0-4.574.94-6.301 2.58a9.421 9.421 0 00-2.173 3.12C.28 8.43 0 9.84 0 11.342c0 5.227 3.568 9.807 5.584 9.807.88 0 1.638-.659 1.816-1.25.15.406.606 1.665.757 1.985.222.475 1.249.885 1.698.392.577.321 1.638.514 2.215-.342 1.113.235 2.097-.428 2.118-1.22.546-.029.814-.796.695-1.406-.088-.45-1.026-2.063-1.393-2.62.725.59 2.562.757 2.784 0 1.169.918 2.991.437 3.135-.31 1.42.369 3.05-.441 2.782-1.423 2.282-.157 1.99-2.585 1.35-3.2zm-5.943-4.024c-.6-.236-1.363-.386-1.897-.386-.757 0-1.22.43-1.932.43-.15 0-.507 0-.794-.102.189.198.423.305.877.305.272 0 .81-.139 1.245-.27.007.093.016.183.029.274-.816.195-1.672.714-1.92.849-.55-1.218-.077-2.368.36-2.899 1.962.004 3.548 1.352 4.032 1.8zm.85-.091l-.3-.28c-.309-.29-.63-.55-.96-.783.491-.974 1.109-2.04 1.889-2.698-.859.346-1.707 1.38-2.208 2.485a7.635 7.635 0 00-.777-.433c.7-1.493 2.323-2.739 4.114-2.836-1.2 1.088-.75 3.258-1.76 4.544l.001.001zm-2.464 1.017c-.133-.288-.266-.763-.25-1.042.222-.006.65.078.718.094-.026.131-.04.42-.04.456.042-.073.16-.324.208-.423.428.081.99.218 1.32.372-.388.25-1.045.523-1.957.543zM8.912 6.706c-.484-.174-.484-.611 0-.785.485-.174 1.095.045 1.095.392 0 .348-.61.567-1.095.393zm1.617.162A1.252 1.252 0 108.65 7.951c.832.48 1.879-.123 1.879-1.083zm2.783-1.575c-1.565 1.586-.947 3.593-.377 4.499-.81 1.348-2.404 2.27-4.255 2.69 2.078 0 3.3-.535 4.011-1.059.454-.335.7-.664.825-.847 3.081.199 7.96 1.192 8.435 1.513.19.129.388.414.417.687-2.315-.324-6.488-.665-7.58-.722.775.11 6.433 1.18 7.414 1.432-.299.486-.98.83-2.004.591.555.754-.52 1.66-2.019 1.161.33.74-1.003 1.407-2.52.636.02.74-1.88.826-2.63.007.015.098.104.284.142.367-.241 2.163-2.014 3.506-3.829 3.506-4.443 0-8.314-3.61-8.314-8.411 0-5.076 3.751-8.865 8.278-8.865 2.594 0 3.766 2.042 4.006 2.815z",source:"https://bower.io/docs/about/#brand",hex:"EF5734",guidelines:void 0,license:void 0},siBrandfolder={title:"Brandfolder",slug:"brandfolder",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Brandfolder</title><path d="'+this.path+'"/></svg>'},path:"M0,23.291h19.601v-2.978H2.98V3.689h16.626v10.911h-1.422l2.908,2.909L24,14.599 h-1.417V0.709H0V23.291z M16.148,13.356c-0.191-0.406-0.432-0.739-0.72-0.997c-0.287-0.258-0.599-0.454-0.933-0.583 c-0.337-0.132-0.641-0.217-0.916-0.254c0.251-0.034,0.496-0.134,0.735-0.296c0.241-0.161,0.455-0.364,0.647-0.609 c0.192-0.247,0.345-0.535,0.458-0.863c0.115-0.33,0.171-0.686,0.171-1.069c0-0.648-0.126-1.186-0.377-1.617 c-0.252-0.432-0.597-0.775-1.033-1.033c-0.436-0.258-0.948-0.44-1.536-0.547c-0.586-0.108-1.21-0.162-1.868-0.162 c-0.754,0-1.382,0.018-1.887,0.054C8.387,5.417,7.944,5.463,7.56,5.525v12.933c0.684,0.083,1.293,0.141,1.834,0.171 c0.539,0.03,1.082,0.044,1.634,0.044c0.718,0,1.404-0.054,2.057-0.162c0.652-0.107,1.227-0.304,1.723-0.592 c0.499-0.288,0.893-0.68,1.187-1.177c0.294-0.498,0.441-1.135,0.441-1.914C16.436,14.253,16.34,13.763,16.148,13.356z M10.165,7.321c0.91-0.111,1.873-0.054,2.301,0.304c0.38,0.317,0.607,0.599,0.607,1.42c0,0.751-0.357,1.195-0.608,1.356 c-0.251,0.161-0.59,0.368-1.403,0.368s-0.897,0-0.897,0V7.321z M13.194,16.001c-0.449,0.39-1.114,0.552-1.816,0.552 c-0.79,0-1.213-0.072-1.213-0.072v-3.737h1.132c0.711,0,1.438,0.126,1.832,0.464c0.509,0.437,0.611,0.895,0.611,1.505 C13.741,15.322,13.528,15.711,13.194,16.001z",source:"https://brandfolder.com/brandfolder",hex:"40D1F5",guidelines:void 0,license:void 0},siBox={title:"Box",slug:"box",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Box</title><path d="'+this.path+'"/></svg>'},path:"M.959 5.523c-.54 0-.959.42-.959.899v7.549a4.59 4.59 0 004.613 4.494 4.717 4.717 0 004.135-2.457c.779 1.438 2.337 2.457 4.074 2.457 2.577 0 4.674-2.037 4.674-4.613.06-2.457-2.037-4.495-4.613-4.495-1.738 0-3.295.959-4.074 2.397-.78-1.438-2.338-2.397-4.135-2.397-1.079 0-2.038.36-2.817.899V6.422a.92.92 0 00-.898-.899zM17.602 9.26a.95.95 0 00-.704.158c-.36.3-.479.899-.18 1.318l2.397 3.116-2.396 3.115c-.3.42-.24.96.18 1.26.419.3 1.016.298 1.316-.122l2.039-2.636 2.096 2.697c.3.36.899.419 1.318.12.36-.3.42-.84.121-1.259l-2.338-3.115 2.338-3.057c.3-.419.298-1.018-.121-1.318-.48-.3-1.019-.24-1.318.18l-2.096 2.576-2.04-2.695c-.149-.18-.373-.3-.612-.338zM4.613 11.154c1.558 0 2.817 1.26 2.817 2.758 0 1.558-1.259 2.756-2.817 2.756-1.558 0-2.816-1.198-2.816-2.756 0-1.498 1.258-2.758 2.816-2.758zm8.27 0c1.558 0 2.816 1.26 2.816 2.758-.06 1.558-1.318 2.756-2.816 2.756-1.558 0-2.817-1.198-2.817-2.756 0-1.498 1.259-2.758 2.817-2.758Z",source:"https://www.box.com/en-gb/about-us/press",hex:"0061D5",guidelines:void 0,license:void 0},siBreaker={title:"Breaker",slug:"breaker",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Breaker</title><path d="'+this.path+'"/></svg>'},path:"M13.556,12.924c0.21,0,0.386,0.017,0.585,0.056c1.043,0.206,1.898,0.964,2.246,1.956 c0.101,0.319,0.234,0.797,0.319,1.125l0.111,0.433l0.446-0.009c3.552-0.075,6.456-2.965,6.456-6.546C23.72,4.513,19.195,0,12.281,0 C9.429,0.009,6.725,1.046,4.678,2.715c-2.683,2.2-4.397,5.543-4.397,9.286c0.002,0.96,0.118,1.926,0.334,2.818 c0.788,3.268,2.91,6.015,5.759,7.628c1.723,0.971,3.784,1.547,5.909,1.553c0.521,0,1.052-0.036,1.554-0.099 c3.126-0.405,5.873-2.012,7.765-4.339l0.124-0.152l-0.24-0.868l-0.463,0.122c-1.436,0.381-2.908,0.578-4.463,0.576 c-1.243,0-2.428-0.128-3.598-0.375c-1.054-0.212-1.911-0.979-2.248-1.98c-0.109-0.315-0.158-0.608-0.156-0.958 c-0.011-0.782,0.257-1.425,0.741-1.975C11.848,13.321,12.656,12.924,13.556,12.924z M12.281,1.125 c6.398,0,10.313,4.11,10.313,8.813c0,2.811-2.168,5.119-4.919,5.397c-0.073-0.261-0.152-0.536-0.219-0.746 C15.715,9.132,11.567,4.907,6.23,2.957C7.965,1.78,10.01,1.118,12.281,1.125z M1.405,12.001c0-3.283,1.455-6.227,3.756-8.223 c4.377,1.403,7.964,4.397,10.058,8.371c-0.272-0.12-0.559-0.212-0.859-0.272c-1.219-0.253-2.511-0.394-3.807-0.394 c-3.24,0.006-6.345,0.859-9.001,2.325C1.454,13.222,1.405,12.625,1.405,12.001z M12.729,19.967 c1.224,0.257,2.526,0.398,3.829,0.398c0.996,0,1.986-0.083,2.948-0.234c-1.519,1.352-3.418,2.282-5.519,2.614 c-0.799-0.938-1.493-1.95-2.072-3.032C12.174,19.822,12.446,19.908,12.729,19.967z M12.645,22.871 c-0.12,0.004-0.242,0.006-0.364,0.006c-1.825,0.006-3.486-0.424-4.994-1.209c0.433-1.907,1.172-3.675,2.171-5.277 c0.034,0.294,0.099,0.587,0.186,0.848C10.314,19.28,11.347,21.202,12.645,22.871z M10.453,13.207 c-1.954,2.19-3.43,4.913-4.176,7.864c-2.143-1.421-3.752-3.582-4.467-6.117c2.586-1.508,5.532-2.351,8.744-2.346 c0.18,0,0.358,0.002,0.536,0.008C10.858,12.79,10.644,12.987,10.453,13.207z",source:"https://www.breaker.audio/i/brand",hex:"003DAD",guidelines:void 0,license:void 0},siBrave={title:"Brave",slug:"brave",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Brave</title><path d="'+this.path+'"/></svg>'},path:"M15.68 0l2.096 2.38s1.84-.512 2.709.358c.868.87 1.584 1.638 1.584 1.638l-.562 1.381.715 2.047s-2.104 7.98-2.35 8.955c-.486 1.919-.818 2.66-2.198 3.633-1.38.972-3.884 2.66-4.293 2.916-.409.256-.92.692-1.38.692-.46 0-.97-.436-1.38-.692a185.796 185.796 0 01-4.293-2.916c-1.38-.973-1.712-1.714-2.197-3.633-.247-.975-2.351-8.955-2.351-8.955l.715-2.047-.562-1.381s.716-.768 1.585-1.638c.868-.87 2.708-.358 2.708-.358L8.321 0h7.36zm-3.679 14.936c-.14 0-1.038.317-1.758.69-.72.373-1.242.637-1.409.742-.167.104-.065.301.087.409.152.107 2.194 1.69 2.393 1.866.198.175.489.464.687.464.198 0 .49-.29.688-.464.198-.175 2.24-1.759 2.392-1.866.152-.108.254-.305.087-.41-.167-.104-.689-.368-1.41-.741-.72-.373-1.617-.69-1.757-.69zm0-11.278s-.409.001-1.022.206-1.278.46-1.584.46c-.307 0-2.581-.434-2.581-.434S4.119 7.152 4.119 7.849c0 .697.339.881.68 1.243l2.02 2.149c.192.203.59.511.356 1.066-.235.555-.58 1.26-.196 1.977.384.716 1.042 1.194 1.464 1.115.421-.08 1.412-.598 1.776-.834.364-.237 1.518-1.19 1.518-1.554 0-.365-1.193-1.02-1.413-1.168-.22-.15-1.226-.725-1.247-.95-.02-.227-.012-.293.284-.851.297-.559.831-1.304.742-1.8-.089-.495-.95-.753-1.565-.986-.615-.232-1.799-.671-1.947-.74-.148-.068-.11-.133.339-.175.448-.043 1.719-.212 2.292-.052.573.16 1.552.403 1.632.532.079.13.149.134.067.579-.081.445-.5 2.581-.541 2.96-.04.38-.12.63.288.724.409.094 1.097.256 1.333.256s.924-.162 1.333-.256c.408-.093.329-.344.288-.723-.04-.38-.46-2.516-.541-2.961-.082-.445-.012-.45.067-.579.08-.129 1.059-.372 1.632-.532.573-.16 1.845.009 2.292.052.449.042.487.107.339.175-.148.069-1.332.508-1.947.74-.615.233-1.476.49-1.565.986-.09.496.445 1.241.742 1.8.297.558.304.624.284.85-.02.226-1.026.802-1.247.95-.22.15-1.413.804-1.413 1.169 0 .364 1.154 1.317 1.518 1.554.364.236 1.355.755 1.776.834.422.079 1.08-.4 1.464-1.115.384-.716.039-1.422-.195-1.977-.235-.555.163-.863.355-1.066l2.02-2.149c.341-.362.68-.546.68-1.243 0-.697-2.695-3.96-2.695-3.96s-2.274.436-2.58.436c-.307 0-.972-.256-1.585-.461-.613-.205-1.022-.206-1.022-.206z",source:"https://brave.com/brave-branding-assets/",hex:"FB542B",guidelines:void 0,license:void 0},siBritishairways={title:"British Airways",slug:"britishairways",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>British Airways</title><path d="'+this.path+'"/></svg>'},path:"M23.489 13.252c-.25.212-.605.444-1.241.767-1.347.72-2.198.983-2.198.983s-1.617-.234-4.207-1.007c0 0 1.306-.378 1.93-.581a40.11 40.11 0 0 0 1.958-.681c1.055-.396 1.73-.761 2.18-1.088.03-.022.058-.046.085-.068 0 0 .32.036.593.113.294.083.604.245.786.386.191.147.28.308.308.358a.681.681 0 0 1 .071.226s.014.085-.003.177a.579.579 0 0 1-.147.313zM24 12.196a.662.662 0 0 0-.08-.157 1.348 1.348 0 0 0-.197-.23 1.685 1.685 0 0 0-.227-.178c-.354-.232-.81-.362-1.215-.416-.627-.083-1.342-.07-1.411-.07-.23-.005-1.722.007-2.105.015-1.702.034-3.787.039-4.333.038-5.636.027-8.089-.094-10.82-.642C1.289 10.094 0 9.658 0 9.658c2.05-.073 14.004-.568 16.186-.627 1.427-.04 2.44-.048 3.253 0 .413.023.802.058 1.287.14a6.2 6.2 0 0 1 1.064.286c.486.18.893.442 1.096.707 0 0 .06.06.14.17.093.126.197.282.234.34.294.447.434.73.484.828.052.102.1.209.145.315.044.104.063.166.076.21.02.064.03.125.035.17Z",source:"https://www.britishairways.com/travel/home/public/en_ie/",hex:"2E5C99",guidelines:void 0,license:void 0},siBroadcom={title:"Broadcom",slug:"broadcom",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Broadcom</title><path d="'+this.path+'"/></svg>'},path:"M12 0C5.37 0 0 5.37 0 12A12 12 0 0 0 .574 15.62C.848 15.5 1.14 15.36 1.43 15.24C2.8 14.7 4.06 14.88 5.31 15.64C5.31 15.64 5.77 15.92 5.91 16C6.5 16.38 7.05 16.73 7.58 16.73C8.09 16.73 8.59 16.59 8.8 15.61C9.13 14.08 9.94 10.31 10.29 8.45C10.5 7.35 10.61 6.76 10.73 6.36C10.93 5.65 11.31 5.27 11.84 5.21C11.84 5.21 11.93 5.2 12 5.2C12.07 5.2 12.15 5.21 12.15 5.21C12.69 5.27 13.07 5.65 13.28 6.36C13.39 6.76 13.5 7.35 13.71 8.45C14.06 10.31 14.87 14.08 15.2 15.61C15.41 16.59 15.91 16.73 16.42 16.73C16.95 16.73 17.5 16.38 18.09 16C18.23 15.92 18.69 15.64 18.69 15.64C19.95 14.88 21.2 14.7 22.57 15.24C22.87 15.36 23.16 15.5 23.44 15.63A12 12 0 0 0 24 12C24 5.37 18.63 0 12 0M12 9.79C11.6 11.8 11 14.71 10.7 16C10.34 17.7 9.2 18.66 7.58 18.66C6.5 18.66 5.64 18.12 4.88 17.65C4.5 17.4 4.08 17.13 3.63 17A2.32 2.32 0 0 0 2.21 16.97A6.11 6.11 0 0 0 1.27 17.36A12 12 0 0 0 12 24A12 12 0 0 0 22.73 17.35A6.08 6.08 0 0 0 21.79 16.96A2.32 2.32 0 0 0 20.38 16.97C19.92 17.13 19.5 17.4 19.12 17.65C18.36 18.12 17.5 18.66 16.42 18.66C14.8 18.66 13.67 17.7 13.3 16C13 14.71 12 9.79 12 9.79Z",source:"https://en.wikipedia.org/wiki/Broadcom_Inc",hex:"CC092F",guidelines:void 0,license:void 0},siBt={title:"BT",slug:"bt",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>BT</title><path d="'+this.path+'"/></svg>'},path:"M12.589 7.91h5.977v1.753H16.56v6.41h-1.97v-6.41h-2zM12 22.523C6.193 22.523 1.477 17.807 1.477 12 1.477 6.193 6.193 1.477 12 1.477c5.807 0 10.523 4.716 10.523 10.523 0 5.807-4.716 10.523-10.523 10.523M12 24c6.626 0 12-5.374 12-12S18.626 0 12 0C5.379 0 0 5.374 0 12s5.379 12 12 12M9.97 13.574c0-.516-.321-.865-.873-.865h-1.32v1.702h1.32c.552 0 .874-.345.874-.837m-.24-3.276c0-.433-.275-.732-.745-.732h-1.21v1.486h1.21c.47 0 .746-.299.746-.754m2.231 3.372c0 1.546-1.09 2.402-2.65 2.402H5.834V7.91h3.249c1.573 0 2.64.805 2.64 2.277 0 .672-.298 1.27-.781 1.634.552.326 1.021.947 1.021 1.85Z",source:"https://www.bt.com/",hex:"6400AA",guidelines:void 0,license:void 0},siBuddy={title:"Buddy",slug:"buddy",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Buddy</title><path d="'+this.path+'"/></svg>'},path:"M21.7 5.307L12.945.253a1.892 1.892 0 00-1.891 0L2.299 5.306a1.892 1.892 0 00-.945 1.638v10.11c0 .675.36 1.3.945 1.637l8.756 5.056a1.892 1.892 0 001.89 0l8.756-5.055c.585-.338.945-.962.945-1.638V6.945c0-.675-.36-1.3-.945-1.638zm-7.45 7.753l-3.805 3.804-1.351-1.351 3.804-3.805-3.804-3.806 1.35-1.35 3.805 3.805 1.351 1.35-1.35 1.353z",source:"https://buddy.works/about",hex:"1A86FD",guidelines:void 0,license:void 0},siBuefy={title:"Buefy",slug:"buefy",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Buefy</title><path d="'+this.path+'"/></svg>'},path:"M13.358.004c-.008 0-.175.02-.375.031-.64.05-1.275.142-1.902.278-.402.09-1.496.402-1.54.433-.738.259-1.472.606-2.17.957-.606.332-1.544.938-1.689 1.094a6.04 6.04 0 01-.304.242c-.387.309-1.172 1.102-1.528 1.543-1.203 1.512-1.87 3.145-2.074 5.063-.066.66 0 2.507.086 2.507.02 0 .32-.132.684-.304.191-.086.418-.192.511-.235.094-.043.602-.273 1.122-.515.527-.243 1.046-.48 1.16-.532l.488-.226c.156-.07.297-.13.316-.13.02 0-.007-.081-.058-.183a4.262 4.262 0 01-.48-1.996c0-1.152.402-2.246 1.23-3.344.388-.49.831-.932 1.32-1.32.07-.054.172-.129.227-.176.34-.261 1.437-.851 1.59-.851.035 0 .046.023.035.066-.012.04-.09.422-.18.844-.082.434-.16.816-.172.86-.008.038-.043.21-.074.378-.035.168-.066.34-.074.38-.012.042-.094.464-.192.948-.093.48-.19.95-.21 1.047-.02.094-.044.203-.047.246l-.157.801c-.01.043-.113.555-.23 1.14-.117.587-.219 1.098-.23 1.141l-.153.766a8.49 8.49 0 01-.074.375c-.043.198-.081.398-.114.598a1.384 1.384 0 00-.035.148c-.01.05-.062.3-.113.563-.055.261-.105.539-.117.609-.012.07-.047.234-.074.363-.027.113-.05.226-.07.34-.178.9-.36 1.8-.544 2.7l-.07.378c-.012.043-.094.469-.195.95l-.207 1.046a3.51 3.51 0 00-.047.25l-.156.797c-.012.043-.118.559-.235 1.14-.113.587-.215 1.099-.222 1.134-.05.23-.286 1.437-.3 1.53l-.02.122 3.546-.012c3.137 0 4.184-.02 4.723-.07l.457-.043c.168-.012.328-.031.363-.035.035-.008.152-.024.266-.035.113-.012.351-.051.527-.086.18-.032.367-.063.414-.07.047-.012.203-.044.344-.079.137-.03.273-.062.308-.07.094-.02.73-.207.817-.242.043-.02.238-.098.433-.18 1.258-.5 2.297-1.312 3.032-2.371.136-.195.511-.824.511-.855 0-.012.07-.16.15-.332a7.814 7.814 0 00.64-2.258c.05-.383.02-1.817-.05-1.926a1.215 1.215 0 01-.036-.191 6.046 6.046 0 00-3.172-4.23 6.71 6.71 0 00-1.23-.497l-.188-.043.308-.203c.133-.088.263-.18.39-.274.252-.2.497-.408.734-.625.525-.535.845-.949 1.17-1.503.265-.45.546-1.157.624-1.56a.641.641 0 01.032-.14c.093-.265.093-1.61 0-1.761-.008-.012-.02-.075-.032-.137a4.155 4.155 0 00-.1-.344c-.415-1.27-1.368-2.328-2.68-2.976C17.55.632 16.78.344 16.525.3a2.157 2.157 0 01-.265-.059 8.852 8.852 0 00-.93-.168 10.58 10.58 0 00-1.3-.073c-.368.004-.669-.001-.673.003zm1.645 1.812c.972.254 1.742.891 2.082 1.723.207.504.254.79.254 1.543 0 .613-.02.89-.114 1.277a4.284 4.284 0 01-2.28 2.918c-.22.114-.41.2-.512.235-.012 0-.047.02-.079.031-.273.113-1.418.371-1.46.328-.012-.012.042-.297.11-.644.07-.344.14-.688.147-.762a1.93 1.93 0 01.04-.192 1.05 1.05 0 00.034-.191c.012-.078.032-.16.04-.191.011-.032.027-.114.035-.188.011-.07.074-.39.136-.703.067-.316.13-.613.137-.664.008-.055.09-.48.192-.95.093-.472.18-.91.19-.972.013-.062.044-.234.075-.379.031-.148.06-.308.07-.36.172-.91.375-1.894.383-1.933.024-.054.055-.047.52.074zM13.84 11.824c.191.028.508.086.82.16.172.036.664.235.926.371 1.465.758 2.273 2.356 2.098 4.133a7.38 7.38 0 01-.11.664c-.012.024-.023.09-.039.153a8.4 8.4 0 01-.352.949c-1.082 2.172-3.394 3.5-6.199 3.55l-.476.012.023-.105.043-.203c.012-.055.031-.184.055-.285l.058-.305c.012-.066.024-.148.036-.191.007-.043.085-.446.168-.895.09-.445.183-.926.214-1.062l.08-.399c.01-.086.022-.18.034-.21.011-.032.023-.099.035-.15.012-.054.04-.198.058-.323.024-.125.106-.528.176-.895.05-.26.102-.518.153-.777.007-.067.043-.235.07-.38.055-.261.078-.386.113-.609l.094-.472.285-1.465c.117-.61.223-1.14.23-1.188.012-.054.055-.086.126-.093.187-.024 1.05-.008 1.28.015z",source:"https://github.com/buefy/buefy/blob/a9a724efca0b531e6a64ab734889b00bf4507a9d/static/img/icons/safari-pinned-tab.svg",hex:"7957D5",guidelines:void 0,license:void 0},siBuffer={title:"Buffer",slug:"buffer",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Buffer</title><path d="'+this.path+'"/></svg>'},path:"M1.371 5.476L11.943 0l10.686 5.476-10.686 5.495zm3.36 4.81l7.212 3.547 7.288-3.547 3.398 1.655-10.686 5.202L1.371 11.94zm0 6.171l7.212 3.911 7.288-3.91 3.398 1.815L11.943 24 1.371 18.273z",source:"https://buffer.com/press",hex:"231F20",guidelines:void 0,license:void 0},siBugatti={title:"Bugatti",slug:"bugatti",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bugatti</title><path d="'+this.path+'"/></svg>'},path:"M0 5.168v2.194h2.92l.004-.73.006-.73 3.498-.005 3.496-.004v4.103H7.157V8.851l-1.464.004-1.466.006v5.744l1.466.006 1.464.004V13.47h2.767v4.618H2.92v-1.45H0v4.39h9.31c6.06 0 9.405-.008 9.584-.02a5.482 5.482 0 0 0 3.73-1.842 5.567 5.567 0 0 0 1.341-2.904c.048-.325.046-1.184-.002-1.504a5.537 5.537 0 0 0-1.36-2.922 1.478 1.478 0 0 1-.14-.17c0-.008.054-.08.12-.16a5.255 5.255 0 0 0 1.13-2.693 6.9 6.9 0 0 0 .01-1.122 5.297 5.297 0 0 0-1.172-2.81 5.328 5.328 0 0 0-1.884-1.443 5.297 5.297 0 0 0-1.2-.38c-.515-.09-.038-.085-10.052-.085H0zm18.656.744c.557.044.958.214 1.305.555.536.529.73 1.414.475 2.193a1.933 1.933 0 0 1-.494.794 1.884 1.884 0 0 1-1.055.513c-.147.025-.561.03-2.63.03h-2.458v-2.04c0-1.121.005-2.045.013-2.05.02-.022 4.569-.016 4.844.005zm.267 7.586c1.078.174 1.807.977 1.876 2.065.057.888-.246 1.613-.87 2.088-.159.12-.5.288-.691.342-.35.095-.342.095-2.977.095h-2.462V13.47h2.477c2.082 0 2.502.003 2.647.028Z",source:"https://www.bugatti.com/",hex:"BE0030",guidelines:void 0,license:void 0},siBugcrowd={title:"Bugcrowd",slug:"bugcrowd",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bugcrowd</title><path d="'+this.path+'"/></svg>'},path:"M24 12L18 1.387H6L0 12l6 10.613h12zm-5.782 1.658c-.003.825-.122 1.569-.354 2.231a5.05 5.05 0 0 1-.99 1.708 4.316 4.316 0 0 1-1.503 1.093 4.69 4.69 0 0 1-1.896.385 4.158 4.158 0 0 1-1.145-.152 3.754 3.754 0 0 1-.868-.36 3.792 3.792 0 0 1-.601-.435 3.023 3.023 0 0 1-.466-.514h-.04l.02.193c.011.166.018.331.02.497v.528H7.961V7.062c0-.151-.04-.263-.114-.337-.077-.074-.19-.109-.33-.109h-.811V4.425h2.452c.473-.003.824.108 1.048.331.222.223.333.576.33 1.049v3.003c-.003.258-.01.467-.02.626l-.02.247h.04a2.898 2.898 0 0 1 .463-.507c.156-.143.354-.284.6-.426.245-.142.538-.261.876-.36.38-.1.77-.15 1.162-.148.702.003 1.334.135 1.894.395a4.118 4.118 0 0 1 1.446 1.11c.4.48.707 1.052.92 1.715.212.658.317 1.392.32 2.198m-2.803 1.406c.138-.399.206-.852.209-1.366-.003-.659-.112-1.231-.328-1.718-.216-.484-.517-.859-.902-1.125a2.347 2.347 0 0 0-1.344-.404 2.57 2.57 0 0 0-.969.186 2.372 2.372 0 0 0-.83.589 2.839 2.839 0 0 0-.579 1.015c-.141.413-.212.906-.216 1.477 0 .397.053.792.159 1.174.101.366.265.712.483 1.02.211.3.486.548.805.722.32.176.698.267 1.127.27.343.002.683-.07.997-.213a2.43 2.43 0 0 0 .824-.623c.24-.273.428-.607.564-1.004Z",source:"https://www.bugcrowd.com/about/press-kit/",hex:"F26822",guidelines:void 0,license:void 0},siBugsnag={title:"Bugsnag",slug:"bugsnag",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bugsnag</title><path d="'+this.path+'"/></svg>'},path:"M12 24c-4.596 0-8.336-3.74-8.336-8.336v-4.135a.62.62 0 01.62-.62h2.957L7.23 1.337 4.903 2.77v5.45a.62.62 0 01-1.24 0V2.7c0-.384.204-.749.53-.95L6.773.166a1.114 1.114 0 011.699.949l.01 9.796h3.52a4.759 4.759 0 014.753 4.754 4.759 4.759 0 01-4.753 4.753 4.759 4.759 0 01-4.754-4.753l-.003-3.515H4.903v3.515c0 3.912 3.183 7.097 7.097 7.097a7.104 7.104 0 007.097-7.097c0-3.915-3.184-7.098-7.097-7.098h-1.076a.62.62 0 010-1.24H12c4.596 0 8.336 3.74 8.336 8.336S16.596 24 12 24zM8.482 12.15l.004 3.514A3.518 3.518 0 0012 19.178a3.518 3.518 0 003.514-3.514A3.518 3.518 0 0012 12.149zm4.513 3.514a.995.995 0 01-.995.994.995.995 0 01-.995-.994.995.995 0 01.995-.995.995.995 0 01.995.995Z",source:"https://www.bugsnag.com/newsroom",hex:"4949E4",guidelines:void 0,license:void 0},siBootstrap={title:"Bootstrap",slug:"bootstrap",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bootstrap</title><path d="'+this.path+'"/></svg>'},path:"M11.77 11.24H9.956V8.202h2.152c1.17 0 1.834.522 1.834 1.466 0 1.008-.773 1.572-2.174 1.572zm.324 1.206H9.957v3.348h2.231c1.459 0 2.232-.585 2.232-1.685s-.795-1.663-2.326-1.663zM24 11.39v1.218c-1.128.108-1.817.944-2.226 2.268-.407 1.319-.463 2.937-.42 4.186.045 1.3-.968 2.5-2.337 2.5H4.985c-1.37 0-2.383-1.2-2.337-2.5.043-1.249-.013-2.867-.42-4.186-.41-1.324-1.1-2.16-2.228-2.268V11.39c1.128-.108 1.819-.944 2.227-2.268.408-1.319.464-2.937.42-4.186-.045-1.3.968-2.5 2.338-2.5h14.032c1.37 0 2.382 1.2 2.337 2.5-.043 1.249.013 2.867.42 4.186.409 1.324 1.098 2.16 2.226 2.268zm-7.927 2.817c0-1.354-.953-2.333-2.368-2.488v-.057c1.04-.169 1.856-1.135 1.856-2.213 0-1.537-1.213-2.538-3.062-2.538h-4.16v10.172h4.181c2.218 0 3.553-1.086 3.553-2.876z",source:"http://getbootstrap.com/about",hex:"7952B3",guidelines:void 0,license:void 0},siBunq={title:"bunq",slug:"bunq",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>bunq</title><path d="'+this.path+'"/></svg>'},path:"M16.414 14.62h1.103v-2.896a2.484 2.484 0 0 0-2.483-2.483 2.484 2.484 0 0 0-2.482 2.483v2.897h1.103v-2.897c0-.837.618-1.517 1.38-1.517.76 0 1.379.68 1.379 1.517zm-6.07-5.24h1.104v2.896a2.484 2.484 0 0 1-2.482 2.483 2.484 2.484 0 0 1-2.483-2.483V9.379h1.103v2.897c0 .837.618 1.517 1.38 1.517.76 0 1.379-.68 1.379-1.517zM0 7.034V12c0 .046.001.093.004.139H0v2.482h.965l.055-.48A2.76 2.76 0 0 0 5.518 12a2.76 2.76 0 0 0-4.414-2.208V7.035zm2.69 3.172c.951 0 1.724.803 1.724 1.793 0 .99-.773 1.793-1.725 1.793-.951 0-1.724-.803-1.724-1.793 0-.99.773-1.793 1.724-1.793zm18.552-.965A2.76 2.76 0 0 0 18.482 12a2.76 2.76 0 0 0 4.414 2.207v2.758H24V12a2.15 2.15 0 0 0-.004-.139H24V9.38h-.965l-.055.48a2.741 2.741 0 0 0-1.738-.617zm.069.965c.951 0 1.724.803 1.724 1.793 0 .99-.773 1.793-1.724 1.793-.952 0-1.725-.803-1.725-1.793 0-.99.773-1.793 1.725-1.793Z",source:"https://www.bunq.com/press/",hex:"3394D7",guidelines:void 0,license:void 0},siBurgerking={title:"Burger King",slug:"burgerking",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Burger King</title><path d="'+this.path+'"/></svg>'},path:"M15.39 12.614c-.72 0-1.11.538-1.11 1.215v1.508c0 .125-.043.182-.12.182-.056 0-.098-.035-.147-.133l-.971-1.885c-.37-.72-.755-.887-1.196-.887-.734 0-1.14.552-1.14 1.243v4.314c0 .678.392 1.215 1.112 1.215.72 0 1.112-.537 1.112-1.215v-1.507c0-.126.042-.182.119-.182.055 0 .097.035.146.133l.972 1.885c.37.719.769.886 1.195.886.735 0 1.14-.551 1.14-1.242v-4.315c0-.677-.391-1.215-1.111-1.215zm-4.02-.405c.364 0 .68-.286.68-.642 0-.238-.099-.412-.224-.572-.203-.266-.385-.496-.476-.74-.02-.056-.007-.105.056-.154.217-.167.469-.537.469-1.124 0-.886-.734-1.389-1.622-1.389h-.79c-.553 0-.819.321-.819.754v3.114c0 .419.245.754.692.754.448 0 .693-.335.693-.754v-.74c0-.09.042-.133.111-.133.084 0 .112.049.126.133.063.356.23.837.42 1.082.237.314.46.411.685.411zm-1.146-2.666h-.098c-.119 0-.175-.07-.175-.161v-.474c0-.09.056-.16.175-.16h.098c.294 0 .385.208.385.39 0 .174-.091.405-.385.405zm-3.761 2.666c1.132 0 1.734-.677 1.734-1.528V8.328c0-.419-.245-.754-.692-.754-.448 0-.693.335-.693.754v2.276c0 .167-.097.363-.35.363-.251 0-.335-.196-.335-.363V8.328c0-.419-.252-.754-.7-.754-.447 0-.691.335-.691.754v2.353c0 .852.594 1.528 1.727 1.528zm12.011-.034c.392 0 .7-.23.7-.65 0-.412-.308-.642-.7-.642h-.63c-.118 0-.174-.07-.174-.16v-.133c0-.091.056-.161.175-.161h.482c.336 0 .602-.202.602-.559 0-.355-.266-.558-.602-.558h-.482c-.12 0-.175-.07-.175-.16V9.04c0-.091.056-.161.175-.161h.629c.392 0 .7-.23.7-.65 0-.411-.308-.642-.7-.642h-1.321c-.553 0-.818.321-.818.754v3.079c0 .432.265.754.818.754h1.321zm2.642 3.127h-.342c-.615 0-1.09.286-1.09.914 0 .573.517.845.901.845.189 0 .322.056.322.202 0 .182-.224.3-.462.3-.79 0-1.328-.537-1.328-1.535 0-1.11.734-1.515 1.3-1.515.692 0 .804.349 1.287.349a.927.927 0 0 0 .936-.915.95.95 0 0 0-.398-.788c-.427-.315-1.07-.545-1.979-.545-1.629 0-3.216 1.026-3.216 3.414 0 2.282 1.587 3.35 3.153 3.35 1.643 0 2.685-1.012 2.685-2.492 0-.935-.587-1.584-1.769-1.584zm-12.43-2.688c-.783 0-1.21.587-1.21 1.32v4.132c0 .734.427 1.32 1.21 1.32.783 0 1.21-.586 1.21-1.32v-4.132c0-.733-.427-1.32-1.21-1.32zm11.494-.405c.447 0 .692-.335.692-.754v-.74c0-.09.042-.132.112-.132.084 0 .111.049.125.133.063.355.231.837.42 1.082.238.314.461.412.685.412.363 0 .678-.286.678-.643 0-.237-.098-.412-.224-.572-.237-.3-.384-.496-.475-.74-.02-.056-.007-.105.056-.153.217-.168.469-.538.469-1.124 0-.887-.735-1.39-1.623-1.39h-.79c-.552 0-.817.321-.817.754v3.114c0 .419.244.753.692.753zm.615-3.301c0-.09.056-.161.175-.161h.098c.293 0 .384.21.384.391 0 .175-.09.405-.384.405h-.098c-.12 0-.175-.07-.175-.16zm-18.87 3.267h.986c.93 0 1.496-.622 1.496-1.397 0-.621-.37-.907-.454-.977-.035-.028-.07-.056-.07-.084 0-.035.021-.048.056-.09.133-.154.266-.398.266-.754 0-.838-.567-1.285-1.448-1.285h-.832c-.552 0-.817.321-.817.754v3.079c0 .433.265.754.817.754zm.413-3.386c0-.09.056-.16.175-.16h.09c.301 0 .392.209.392.39 0 .168-.09.405-.391.405h-.091c-.12 0-.175-.07-.175-.16zm0 1.634c0-.091.056-.161.175-.161h.126c.335 0 .433.223.433.426 0 .181-.098.44-.433.44h-.126c-.12 0-.175-.07-.175-.161zm11.878 1.794c1.098 0 1.79-.699 1.79-1.718 0-.649-.391-1.096-1.174-1.096h-.224c-.413 0-.734.196-.734.636 0 .39.342.58.601.58.133 0 .217.041.217.139 0 .125-.147.21-.315.21-.524 0-.88-.37-.88-1.062 0-.768.489-1.047.866-1.047.462 0 .539.238.86.238.37 0 .623-.308.623-.629a.669.669 0 0 0-.266-.544c-.294-.217-.706-.377-1.321-.377-1.084 0-2.14.712-2.14 2.36 0 1.576 1.056 2.31 2.097 2.31zm-8.718 3.762a.354.354 0 0 1-.07-.188c0-.077.042-.133.126-.21.196-.181.678-.635.944-1.047.202-.314.286-.6.286-.837 0-.607-.552-1.082-1.153-1.082-.385 0-.748.216-.993.614-.329.53-.72 1.145-.972 1.39-.063.062-.098.076-.146.076-.084 0-.12-.056-.12-.146v-.699c0-.684-.405-1.235-1.139-1.235-.74 0-1.14.551-1.14 1.235v4.3c0 .685.399 1.237 1.14 1.237.734 0 1.14-.552 1.14-1.236v-.991c0-.084.035-.147.119-.147.111 0 .14.112.167.168.161.384.63 1.2 1.063 1.682.294.32.657.524 1.042.524.65 0 1.196-.566 1.196-1.173 0-.377-.161-.657-.469-.991-.392-.427-.853-.986-1.021-1.244zm15.751 6.702C19.432 23.707 16.313 24 12 24c-4.313 0-7.432-.293-9.25-1.32-1.09-.614-1.642-1.451-1.642-2.052 0-.342.181-.537.587-.537h20.61c.406 0 .587.195.587.537 0 .6-.552 1.438-1.643 2.053zm1.056-15.917H1.695c-.406 0-.587-.209-.587-.586C1.108 3.944 4.47 0 12 0c7.46 0 10.892 3.944 10.892 6.178 0 .377-.181.586-.587.586Z",source:"https://www.bk.com/",hex:"D62300",guidelines:"https://www.bk.com/trademarks",license:void 0},siCachet={title:"Cachet",slug:"cachet",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Cachet</title><path d="'+this.path+'"/></svg>'},path:"M11.746.254C5.265.254 0 5.519 0 12c0 6.481 5.265 11.746 11.746 11.746 6.482 0 11.746-5.265 11.746-11.746 0-1.44-.26-2.82-.734-4.097l-.264-.709-1.118 1.118.1.288c.373 1.064.575 2.207.575 3.4a10.297 10.297 0 01-10.305 10.305A10.297 10.297 0 011.441 12 10.297 10.297 0 0111.746 1.695c1.817 0 3.52.47 5.002 1.293l.32.178 1.054-1.053-.553-.316A11.699 11.699 0 0011.746.254zM22.97.841l-13.92 13.92-3.722-3.721-1.031 1.03 4.752 4.753L24 1.872z",source:"https://cachethq.io/press",hex:"7ED321",guidelines:void 0,license:void 0},siBuzzfeed={title:"BuzzFeed",slug:"buzzfeed",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>BuzzFeed</title><path d="'+this.path+'"/></svg>'},path:"M24 12c0 6.627-5.373 12-12 12S0 18.627 0 12 5.373 0 12 0s12 5.373 12 12zm-4.148-.273l-.977-6.94-6.5 2.624 2.575 1.487-2.435 4.215L8.3 10.68l-4.153 7.19 2.327 1.346 2.812-4.868L13.5 16.78l3.777-6.54 2.575 1.487z",source:"https://www.buzzfeed.com/press/assets",hex:"EE3322",guidelines:void 0,license:void 0},siByjus={title:"Byju's",slug:"byjus",get svg(){return`<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Byju's</title><path d="`+this.path+'"/></svg>'},path:"M2.327.016A2.325 2.325 0 0 0 0 2.34v19.32a2.325 2.325 0 0 0 2.327 2.323h19.346A2.325 2.325 0 0 0 24 21.66V2.34A2.325 2.325 0 0 0 21.673.016zm10.054 3.496a3.443 3.443 0 0 1 .07 0 4.317 4.317 0 0 1 3.267 1.462 4.447 4.447 0 0 1 .961 2.365 4.157 4.157 0 0 1-.456 2.27 5.024 5.024 0 0 1 2.424 2.008 5.237 5.237 0 0 1 .73 3.374 4.68 4.68 0 0 1-1.15 2.466 4.84 4.84 0 0 1-2.26 1.535l-4.987 1.439a1.494 1.494 0 0 1-.41.058 1.497 1.497 0 0 1-1.432-1.075L5.524 6.909a1.487 1.487 0 0 1 1.018-1.841l4.956-1.429a3.443 3.443 0 0 1 .883-.127zm.248.861a3.091 3.091 0 0 0-.855.122L6.94 5.888a.744.744 0 0 0-.51.922l3.53 12.206a.745.745 0 0 0 .921.509l4.664-1.345a4.085 4.085 0 0 0-.896-8.003 3.297 3.297 0 0 0 1.138-2.272 3.479 3.479 0 0 0-.928-2.549 2.989 2.989 0 0 0-2.23-.983Z",source:"https://byjus.com/byjus-the-learning-app/",hex:"813588",guidelines:void 0,license:void 0},siByte={title:"byte",slug:"byte",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>byte</title><path d="'+this.path+'"/></svg>'},path:"M0 0v16.114h16.14V9.838c-.025-.633-.579-1.082-1.317-1.082-.739 0-1.294.449-1.32 1.108v3.614c-1.712-.002-3.435.003-5.142-.002a6.536 6.536 0 0 1 6.435-5.248c3.64.027 6.567 2.955 6.567 6.568a6.552 6.552 0 0 1-12.369 3.032l-.053-.104c-.396-.818-.739-1.188-1.583-1.24-.844-.027-1.503.447-1.292 1.133A9.175 9.175 0 0 0 14.796 24 9.195 9.195 0 0 0 24 14.796c0-4.537-3.428-8.466-7.886-9.1V0zm2.638 2.638h10.84v3.059a9.175 9.175 0 0 0-7.781 7.78c-1.013.002-2.04 0-3.06 0Z",source:"https://byte.co/byte",hex:"551DEF",guidelines:void 0,license:void 0},siC={title:"C",slug:"c",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>C</title><path d="'+this.path+'"/></svg>'},path:"M16.5921 9.1962s-.354-3.298-3.627-3.39c-3.2741-.09-4.9552 2.474-4.9552 6.14 0 3.6651 1.858 6.5972 5.0451 6.5972 3.184 0 3.5381-3.665 3.5381-3.665l6.1041.365s.36 3.31-2.196 5.836c-2.552 2.5241-5.6901 2.9371-7.8762 2.9201-2.19-.017-5.2261.034-8.1602-2.97-2.938-3.0101-3.436-5.9302-3.436-8.8002 0-2.8701.556-6.6702 4.047-9.5502C7.444.72 9.849 0 12.254 0c10.0422 0 10.7172 9.2602 10.7172 9.2602z",source:"https://commons.wikimedia.org/wiki/File:The_C_Programming_Language_logo.svg",hex:"A8B9CC",guidelines:void 0,license:void 0},siBytedance={title:"ByteDance",slug:"bytedance",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>ByteDance</title><path d="'+this.path+'"/></svg>'},path:"M19.8772 1.4685L24 2.5326v18.9426l-4.1228 1.0563V1.4685zm-13.3481 9.428l4.115 1.0641v8.9786l-4.115 1.0642v-11.107zM0 2.572l4.115 1.0642v16.7354L0 21.428V2.572zm17.4553 5.6205v11.107l-4.1228-1.0642V9.2568l4.1228-1.0642z",source:"https://www.bytedance.com/",hex:"3C8CFF",guidelines:void 0,license:void 0},siBuildkite={title:"Buildkite",slug:"buildkite",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Buildkite</title><path d="'+this.path+'"/></svg>'},path:"M23.613 8.143l-7.668-3.856v7.712l7.668-3.855zM8.166 15.857V8.143L.387 4.287V12l7.78 3.857zM.183 3.958a.382.382 0 01.377-.017l7.606 3.771 7.607-3.771a.386.386 0 01.346 0l7.668 3.857a.386.386 0 01.213.345v7.71a.388.388 0 01-.213.346l-7.668 3.86a.389.389 0 01-.562-.345v-7.09l-7.219 3.58a.392.392 0 01-.344 0L.215 12.346A.387.387 0 010 12V4.287a.385.385 0 01.183-.329z",source:"https://buildkite.com/brand-assets",hex:"14CC80",guidelines:void 0,license:void 0},siCaffeine={title:"Caffeine",slug:"caffeine",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Caffeine</title><path d="'+this.path+'"/></svg>'},path:"M6.162 1.557c-.18.006-.263.137-.293.18L.05 11.82c-.07.142-.06.27-.004.356 1.942 3.36 3.882 6.723 5.822 10.085a.337.337 0 00.305.182h11.65c.138.003.26-.09.31-.182 1.94-3.36 3.878-6.721 5.82-10.08a.361.361 0 000-.358l-5.82-10.085c-.112-.193-.308-.181-.308-.181zm.804.719h9.513L10.136 5.94zm-.427.603l2.964 3.426L6.54 8.018zm10.3.018l-3.86 6.685L7.19 8.469zm1.341.357l4.756 8.246-4.756-.916zm-12.36.002v5.176l-4.48 2.587zm11.64 0v11.142l-3.857-4.457zM7.127 9.186l5.847 1.126 3.898 4.502-5.842-1.125zM5.82 9.26v3.425l-4.45-.855zm.72.341l3.856 4.457-3.857 6.685zm11.64 1.713l4.447.856-4.447 2.57zM1.062 12.5l4.76.916v7.33zm21.597.48l-4.479 7.763v-5.175zm-11.64 1.437l5.79 1.114-9.649 5.572zm6.44 1.565v5.138l-2.964-3.425zm-3.597 2.078l3.172 3.664H7.52z",source:"https://www.caffeine.tv/",hex:"0000FF",guidelines:"https://www.caffeine.tv/newsroom.html",license:void 0},siCplusplus={title:"C++",slug:"cplusplus",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>C++</title><path d="'+this.path+'"/></svg>'},path:"M22.394 6c-.167-.29-.398-.543-.652-.69L12.926.22c-.509-.294-1.34-.294-1.848 0L2.26 5.31c-.508.293-.923 1.013-.923 1.6v10.18c0 .294.104.62.271.91.167.29.398.543.652.69l8.816 5.09c.508.293 1.34.293 1.848 0l8.816-5.09c.254-.147.485-.4.652-.69.167-.29.27-.616.27-.91V6.91c.003-.294-.1-.62-.268-.91zM12 19.11c-3.92 0-7.109-3.19-7.109-7.11 0-3.92 3.19-7.11 7.11-7.11a7.133 7.133 0 016.156 3.553l-3.076 1.78a3.567 3.567 0 00-3.08-1.78A3.56 3.56 0 008.444 12 3.56 3.56 0 0012 15.555a3.57 3.57 0 003.08-1.778l3.078 1.78A7.135 7.135 0 0112 19.11zm7.11-6.715h-.79v.79h-.79v-.79h-.79v-.79h.79v-.79h.79v.79h.79zm2.962 0h-.79v.79h-.79v-.79h-.79v-.79h.79v-.79h.79v.79h.79z",source:"https://github.com/isocpp/logos",hex:"00599C",guidelines:void 0,license:void 0},siBitcoincash={title:"Bitcoin Cash",slug:"bitcoincash",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bitcoin Cash</title><path d="'+this.path+'"/></svg>'},path:"m10.84 11.22-.688-2.568c.728-.18 2.839-1.051 3.39.506.27 1.682-1.978 1.877-2.702 2.062zm.289 1.313.755 2.829c.868-.228 3.496-.46 3.241-2.351-.433-1.666-3.125-.706-3.996-.478zM24 12c0 6.627-5.373 12-12 12S0 18.627 0 12 5.373 0 12 0s12 5.373 12 12zm-6.341.661c-.183-1.151-1.441-2.095-2.485-2.202.643-.57.969-1.401.57-2.488-.603-1.368-1.989-1.66-3.685-1.377l-.546-2.114-1.285.332.536 2.108c-.338.085-.685.158-1.029.256L9.198 5.08l-1.285.332.545 2.114c-.277.079-2.595.673-2.595.673l.353 1.377s.944-.265.935-.244c.524-.137.771.125.886.372l1.498 5.793c.018.168-.012.454-.372.551.021.012-.935.241-.935.241l.14 1.605s2.296-.588 2.598-.664l.551 2.138 1.285-.332-.551-2.153c.353-.082.697-.168 1.032-.256l.548 2.141 1.285-.332-.551-2.135c1.982-.482 3.38-1.73 3.094-3.64z",source:"https://www.bitcoincash.org/graphics/",hex:"0AC18E",guidelines:void 0,license:void 0},siCitrix={title:"Citrix",slug:"citrix",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Citrix</title><path d="'+this.path+'"/></svg>'},path:"M11.983 0a1.78 1.78 0 0 0-1.78 1.78 1.78 1.78 0 0 0 1.78 1.78 1.78 1.78 0 0 0 1.78-1.78A1.78 1.78 0 0 0 11.983 0zM5.17 5.991a1.026 1.026 0 0 0-1.095 1.027c0 .308.136.616.376.822l6.162 7.086-6.401 7.258a1.084 1.084 0 0 0-.309.787c0 .582.48 1.027 1.062 1.027.342 0 .684-.17.89-.444l6.128-7.19 6.162 7.19c.205.274.547.444.89.444.582.035 1.062-.445 1.062-1.027a1.14 1.14 0 0 0-.309-.787l-6.402-7.258 6.162-7.086c.24-.206.377-.514.377-.822v-.034c0-.582-.513-1.027-1.095-.993-.343 0-.65.171-.856.445l-5.957 7.018L6.06 6.436a1.07 1.07 0 0 0-.855-.445z",source:"https://brand.citrix.com/",hex:"452170",guidelines:void 0,license:void 0},siBitdefender={title:"Bitdefender",slug:"bitdefender",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bitdefender</title><path d="'+this.path+'"/></svg>'},path:"M1.685 0v.357l1.232 1.046c1.477 1.204 1.67 1.439 1.67 2.526V24h8.646c4.537 0 9.083-1.629 9.083-6.849 0-3.082-2.174-5.458-5.186-5.797v-.067c2.475-.745 4.169-2.54 4.169-5.253 0-4.372-3.73-6.032-7.349-6.032L1.686 0zm7.176 3.664h3.524c2.383 0 3.121.327 3.844 1.013.548.521.799 1.237.801 2.07 0 .775-.267 1.466-.831 2.004-.705.676-1.674 1.011-3.443 1.011H8.862V3.664zm0 9.758h4.099c3.456 0 5.085.881 5.085 3.39 0 3.153-3.055 3.526-5.256 3.526H8.86v-6.916z",source:"https://www.bitdefender.com/funzone/logos.html",hex:"ED1C24",guidelines:void 0,license:void 0},siBitwig={title:"Bitwig",slug:"bitwig",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bitwig</title><path d="'+this.path+'"/></svg>'},path:"M4.15 7.782a1.59 1.59 0 1 1 3.181 0 1.59 1.59 0 0 1-3.181 0zm5.741 1.591a1.59 1.59 0 1 0 0-3.181 1.59 1.59 0 0 0 0 3.181zm4.218 0a1.59 1.59 0 1 0 0-3.181 1.59 1.59 0 0 0 0 3.181zm4.15 0a1.59 1.59 0 1 0 0-3.181 1.59 1.59 0 0 0 0 3.181zM5.741 10.409a1.59 1.59 0 1 0 0 3.181 1.59 1.59 0 0 0 0-3.181zm8.368 0a1.59 1.59 0 1 0 0 3.181 1.59 1.59 0 0 0 0-3.181zm4.15 0a1.59 1.59 0 1 0 0 3.181 1.59 1.59 0 0 0 0-3.181zm4.15 3.182a1.59 1.59 0 1 0 0-3.181 1.59 1.59 0 0 0 0 3.181zM1.591 10.409a1.591 1.591 0 1 0 0 3.182 1.591 1.591 0 0 0 0-3.182zm4.15 4.218a1.59 1.59 0 1 0 0 3.181 1.59 1.59 0 0 0 0-3.181zm12.518 0a1.59 1.59 0 1 0 0 3.181 1.59 1.59 0 0 0 0-3.181zm4.15 0a1.59 1.59 0 1 0 0 3.181 1.59 1.59 0 0 0 0-3.181zm-20.818 0a1.59 1.59 0 1 0 0 3.181 1.59 1.59 0 0 0 0-3.181m8.3-4.218a1.591 1.591 0 1 0 0 3.182 1.591 1.591 0 0 0 0-3.182Z",source:"https://www.bitwig.com/",hex:"FF5A00",guidelines:void 0,license:void 0},siAppwrite={title:"Appwrite",slug:"appwrite",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Appwrite</title><path d="'+this.path+'"/></svg>'},path:"M7.834 4C4.094 4.09.584 6.816.06 11.014a7.993 7.994 0 0 0 3.122 7.368c2.757 2.08 6.198 2.047 8.82.538a7.993 7.994 0 1 0-.005-13.834A7.84 7.84 0 0 0 7.831 4zm.122 1.485a6.525 6.526 0 0 1 6.484 5.537c0 .007.002.013.003.02.02.143.037.287.048.433l.006.054c.01.15.016.303.017.456 0 .084-.005.168-.008.252-.002.058-.003.117-.007.175a6.68 6.68 0 0 1-.03.335l-.01.08c-.015.12-.033.24-.055.358l-.01.048c-.022.124-.05.248-.08.37l-.006.025a6.578 6.58 0 0 1-.41 1.15c-.007.016-.017.033-.024.05a6.538 6.54 0 0 1-1.62 2.115l-.054.046c-.08.067-.162.13-.245.194-.055.042-.11.084-.168.125-.04.03-.08.056-.122.084a6.68 6.68 0 0 1-1.123.612 6.517 6.518 0 0 1-6.468-.8C.069 14.184.838 7.96 5.457 6.004a6.512 6.513 0 0 1 2.499-.518zm.61 3.72c-.183 0-.343.013-.352.032-.01.024-.132.504-.264 1.074-.136.57-.353 1.468-.475 2-.235.974-.377 1.613-.377 1.698 0 .023.146.042.325.042h.325l.146-.65.423-1.796c.15-.635.334-1.408.405-1.72.07-.31.14-.591.155-.624.014-.043-.066-.057-.31-.057zm-2.441 1.6-.438.47-.433.47.127.15c.07.086.264.298.428.472l.302.32h.856l-.405-.438c-.221-.235-.405-.46-.405-.49 0-.032.17-.243.377-.47.207-.23.376-.428.376-.45 0-.02-.178-.034-.395-.034zm3.27 0c-.231 0-.415.014-.415.028s.08.103.18.202c.366.367.624.678.61.74-.009.032-.188.253-.405.484l-.39.428h.437l.438-.005.4-.438c.22-.244.4-.46.4-.49 0-.023-.188-.244-.424-.493l-.423-.457z",source:"https://github.com/appwrite/appwrite/blob/c961382fb7a59ce908b4982a572e02e6e0feacd5/public/images/appwrite.svg",hex:"F02E65",guidelines:void 0,license:void 0},siBulma={title:"Bulma",slug:"bulma",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bulma</title><path d="'+this.path+'"/></svg>'},path:"M11.25 0l-6 6 -1.5 10.5 7.5 7.5 9 -6 -6 -6 4.5 -4.5 -7.5 -7.5Z",source:"https://github.com/jgthms/bulma/",hex:"00D1B2",guidelines:void 0,license:void 0},siBukalapak={title:"Bukalapak",slug:"bukalapak",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bukalapak</title><path d="'+this.path+'"/></svg>'},path:"M10.976 23.845a3.158 3.158 0 1 1-1.95-6.008 3.158 3.158 0 0 1 1.95 6.008Zm6.554-2.883c4.047-1.315 7.315-5.981 5.689-10.984-1.626-5.003-7.012-6.856-11.058-5.541a1.89 1.89 0 0 0-1.252 2.249l.414 1.682a1.892 1.892 0 0 0 2.42 1.348l.162-.053c1.861-.606 3.592.504 4.071 2.019.505 1.507-.244 3.422-2.106 4.027l-.162.054a1.891 1.891 0 0 0-1.166 2.512l.653 1.604a1.89 1.89 0 0 0 2.335 1.083Zm-6.962-7.982L7.841 1.752A2.3 2.3 0 0 0 4.897.113l-2.952.959A2.3 2.3 0 0 0 .526 4.128L4.92 14.815a2.3 2.3 0 0 0 2.841 1.318l1.285-.417a2.298 2.298 0 0 0 1.522-2.736Z",source:"https://assets.bukalapak.com/sigil/bukalapak-logo-icon.svg",hex:"E31E52",guidelines:"https://brand.bukalapak.design/brand-elements#logo-overview",license:void 0},siChartmogul={title:"ChartMogul",slug:"chartmogul",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>ChartMogul</title><path d="'+this.path+'"/></svg>'},path:"M10.621 19.89V8.75L2.867 19.89H0V4.11h2.758v11.112l7.754-11.113h2.867v11.14L21.16 4.11H24v15.782h-2.73V8.75l-7.755 11.14Z",source:"https://chartmogul.com/company/",hex:"13324B",guidelines:void 0,license:void 0},siChase={title:"Chase",slug:"chase",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Chase</title><path d="'+this.path+'"/></svg>'},path:"M0 15.415c0 .468.38.85.848.85h5.937V.575L0 7.72v7.695m15.416 8.582c.467 0 .846-.38.846-.849v-5.937H.573l7.146 6.785h7.697M24 8.587a.844.844 0 0 0-.847-.846h-5.938V23.43l6.782-7.148L24 8.586M8.585.003a.847.847 0 0 0-.847.847v5.94h15.688L16.282.003H8.585Z",source:"https://commons.wikimedia.org/wiki/File:Chase_logo_2007.svg",hex:"117ACA",guidelines:void 0,license:void 0},siCoda={title:"Coda",slug:"coda",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Coda</title><path d="'+this.path+'"/></svg>'},path:"M21.194 0H2.806A2.01 2.01 0 0 0 .8 2v20c0 1.1.903 2 2.006 2h18.388a2.01 2.01 0 0 0 2.006-2v-.933c-.033-1.2-.067-3.7-.067-4.834 0-.633-.468-1.166-1.07-1.166-.668 0-1.103.4-1.437.733-1.003.9-2.508 1.067-3.812.833-.601-.133-1.17-.3-1.638-.6-1.438-.833-2.374-2.4-2.374-4.066 0-1.667.936-3.2 2.374-4.067.502-.3 1.07-.467 1.638-.6 1.27-.233 2.809-.067 3.812.833.367.334.802.734 1.437.734.602 0 1.07-.534 1.07-1.167 0-1.1.034-3.633.067-4.833V2c0-1.1-.903-2-2.006-2Z",source:"https://coda.io/",hex:"F46A54",guidelines:void 0,license:void 0},siCodefactor={title:"CodeFactor",slug:"codefactor",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>CodeFactor</title><path d="'+this.path+'"/></svg>'},path:"M5.375 2.65a2.64 2.64 0 01-2.62 2.65 2.64 2.64 0 01-2.63-2.65A2.64 2.64 0 012.755 0a2.64 2.64 0 012.62 2.65zm0 9.35a2.64 2.64 0 01-2.62 2.65A2.64 2.64 0 01.125 12a2.64 2.64 0 012.63-2.65A2.64 2.64 0 015.375 12zm0 9.35A2.64 2.64 0 012.755 24a2.64 2.64 0 01-2.63-2.65 2.64 2.64 0 012.63-2.65 2.64 2.64 0 012.62 2.65zM11.315 0a2.64 2.64 0 00-2.61 2.65 2.64 2.64 0 002.6 2.65h9.94a2.64 2.64 0 002.63-2.65A2.64 2.64 0 0021.255 0zm-2.61 12a2.64 2.64 0 012.62-2.65h5.68a2.64 2.64 0 012.6 2.65 2.64 2.64 0 01-2.6 2.65h-5.7a2.64 2.64 0 01-2.6-2.65z",source:"https://www.codefactor.io/",hex:"F44A6A",guidelines:void 0,license:void 0},siCodecov={title:"Codecov",slug:"codecov",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Codecov</title><path d="'+this.path+'"/></svg>'},path:"M12.006.481C5.391.486.005 5.831 0 12.399v.03l2.042 1.19.028-.018a5.82 5.82 0 013.308-1.02c.37 0 .733.034 1.085.1l-.036-.006a5.69 5.69 0 012.874 1.43l-.004-.002.35.326.198-.434c.192-.42.414-.814.66-1.173.1-.144.208-.29.332-.446l.205-.257-.252-.211a8.33 8.33 0 00-3.836-1.807l-.052-.008a8.565 8.565 0 00-4.08.251l.06-.016c.972-4.256 4.714-7.223 9.133-7.226a9.31 9.31 0 016.6 2.713 9.196 9.196 0 012.508 4.498 8.385 8.385 0 00-2.498-.379h-.154c-.356.006-.7.033-1.036.078l.045-.005-.042.006a8.103 8.103 0 00-.39.06c-.057.01-.114.022-.17.033a8.102 8.102 0 00-.392.09l-.138.034a9.21 9.21 0 00-.483.144l-.03.01c-.354.12-.708.268-1.05.44l-.027.013c-.152.076-.305.16-.47.256l-.035.022a8.216 8.216 0 00-2.108 1.8l-.011.014-.075.092a8.345 8.345 0 00-.378.503c-.088.13-.177.269-.288.452l-.06.104a8.985 8.985 0 00-.234.432l-.016.029c-.17.34-.317.698-.44 1.063l-.017.053a8.052 8.052 0 00-.41 2.716v-.007.112a12 12 0 00.023.431l-.002-.037a11.676 11.676 0 00.042.412l.005.042.013.103c.018.127.038.252.062.378.241 1.266.845 2.532 1.745 3.66l.041.051.042-.05c.359-.424 1.249-1.77 1.325-2.577v-.015l-.006-.013a5.56 5.56 0 01-.64-2.595c0-3.016 2.37-5.521 5.396-5.702l.2-.007a5.93 5.93 0 013.47 1.025l.027.019L24 12.416v-.03a11.77 11.77 0 00-3.51-8.423A11.962 11.962 0 0012.007.48z",source:"https://codecov.io/",hex:"F01F7A",guidelines:void 0,license:void 0},siCodeforces={title:"Codeforces",slug:"codeforces",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Codeforces</title><path d="'+this.path+'"/></svg>'},path:"M4.5 7.5C5.328 7.5 6 8.172 6 9v10.5c0 .828-.672 1.5-1.5 1.5h-3C.673 21 0 20.328 0 19.5V9c0-.828.673-1.5 1.5-1.5h3zm9-4.5c.828 0 1.5.672 1.5 1.5v15c0 .828-.672 1.5-1.5 1.5h-3c-.827 0-1.5-.672-1.5-1.5v-15c0-.828.673-1.5 1.5-1.5h3zm9 7.5c.828 0 1.5.672 1.5 1.5v7.5c0 .828-.672 1.5-1.5 1.5h-3c-.828 0-1.5-.672-1.5-1.5V12c0-.828.672-1.5 1.5-1.5h3z",source:"http://codeforces.com/",hex:"1F8ACB",guidelines:void 0,license:void 0},siCodacy={title:"Codacy",slug:"codacy",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Codacy</title><path d="'+this.path+'"/></svg>'},path:"M3.883 9.825a8.46 8.46 0 0 1 3.875-5.07l.04-.021-1.803-3.113C3.276 3.212 1.268 5.769.427 8.81l-.02.084zM9.824 3.894a8.246 8.246 0 0 1 2.164-.283h.005V.016h-.019a12.05 12.05 0 0 0-3.165.421l.084-.02zM14.178 3.897a8.449 8.449 0 0 1 5.063 3.875l.021.04 3.117-1.799c-1.591-2.718-4.146-4.726-7.186-5.568l-.084-.02zM0 12v.006c0 1.1.148 2.165.425 3.177l-.02-.084 3.476-.929a8.14 8.14 0 0 1-.284-2.161v-.008zM1.605 17.995c.55.941 1.18 1.754 1.901 2.475l2.553-2.54a8.56 8.56 0 0 1-1.313-1.695l-.022-.04zM5.995 22.38a11.77 11.77 0 0 0 5.967 1.604h.021-.001v-3.595h-.004a8.308 8.308 0 0 1-4.223-1.145l.039.021zM19.259 16.205a8.44 8.44 0 0 1-5.034 3.884l-.059.014.931 3.476c3.124-.86 5.681-2.863 7.246-5.52l.031-.056zM23.577 15.221c.268-.947.423-2.035.423-3.159 0-1.087-.144-2.14-.415-3.142l.019.084-3.486.931c.175.64.275 1.374.275 2.132 0 .79-.109 1.555-.313 2.28l.014-.059z",source:"https://www.codacy.com/blog/",hex:"222F29",guidelines:void 0,license:void 0},siCodemagic={title:"Codemagic",slug:"codemagic",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Codemagic</title><path d="'+this.path+'"/></svg>'},path:"M22.833 10.117L16.937 7.24c-.07-.035-.106-.106-.142-.177l-2.912-5.896c-.498-1.03-1.776-1.457-2.807-.96a2.09 2.09 0 0 0-.959.96L7.205 7.063a.81.81 0 0 1-.142.177l-5.896 2.913c-1.03.497-1.457 1.776-.96 2.806a2.1 2.1 0 0 0 .96.96l5.896 2.876c.07.036.106.107.142.142l2.948 5.896c.497 1.03 1.776 1.457 2.806.96a2.09 2.09 0 0 0 .959-.96l2.877-5.896c.036-.07.107-.142.142-.142l5.896-2.912c1.03-.498 1.457-1.776.96-2.806-.178-.427-.533-.746-.96-.96zm-4.368.427l-2.735 2.38c-.533.497-.924 1.136-1.066 1.847l-.71 3.551c-.036.143-.178.25-.32.214-.071 0-.107-.036-.142-.107l-2.38-2.735c-.497-.533-1.137-.923-1.847-1.066l-3.552-.71c-.142-.035-.249-.178-.213-.32 0-.07.035-.106.106-.142l2.735-2.38c.533-.497.924-1.136 1.066-1.847l.71-3.551c.036-.143.178-.25.32-.214a.27.27 0 0 1 .142.071l2.38 2.735c.497.533 1.137.924 1.847 1.066l3.552.71c.142.036.249.178.213.32a.38.38 0 0 1-.106.178z",source:"https://codemagic.io/",hex:"F45E3F",guidelines:void 0,license:void 0},siCodeclimate={title:"Code Climate",slug:"codeclimate",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Code Climate</title><path d="'+this.path+'"/></svg>'},path:"M16.125 5.272l-4.511 4.475 2.684 2.659 1.827-1.813 5.19 5.145L24 13.079zM8.13 8.265L0 16.066l2.772 2.662 5.357-5.145 5.357 5.145 2.772-2.662z",source:"https://codeclimate.com/github/codeclimate/python-test-reporter/badges/",hex:"000000",guidelines:void 0,license:void 0},siCodemirror={title:"CodeMirror",slug:"codemirror",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>CodeMirror</title><path d="'+this.path+'"/></svg>'},path:"M12.313.858c1.044-.002 2.016.364 2.966 1.178.799.685 1.167 1.52 1.453 2.159.455 1.018.321 1.112-.18 1.398a1.27 1.27 0 0 1-.26.108c.12 1.502.962 1.637 1.232 2.165.176.34.262.752-.553.881-.819.13-.552.76-1.763.815-.864.041-1.372-.257-1.665-.568a4.639 4.639 0 0 1-.623 2.478c.21.104.67.306 1.305.422.881.16 2.155-.522 2.644-.522.153 0 .313-.022.49-.025.374-.007.827.072 1.47.622l.034-.075c-.376-.515-.212-1.885.49-3.535.811-1.904 1.803-3.534 2.606-3.099v-.004c.725.392.36 1.916-.45 3.82-.697 1.636-1.377 2.939-2.083 3.043l-.079.241c.834.662.667.978.441 1.52-.262.619.114 1.175-1.222 1.403a.969.969 0 0 1-.434-.025c-.098.232-.177.412-.177.412s-.13.357-.478.232c-.357-.13-.263-.388-.263-.388l.344-.625c-.214-.231-.327-.492-.297-.586.133-.294.455-.031.423-.356-.619.066-1.206-.294-1.336-.326-.13-.031-.066-.325-1.109.326-.414.258-.794.517-1.18.762.153.784 1.057 2.016 1.74 2.106 2.152-.098 2.152 1.34 1.991 1.37-.325-.618-.846-.489-1.532-.097s.13.325.423.552c-1.437.608-2.848-.537-3.247-.901-.568.903-1.673 1.543-2.438 1.885-.944.423-1.65.983-.944 1.336.588.294.913-.455 1.763-.588.846-.13 1.599.196 1.665.686-.356-.196-.619-.196-.619-.196s.294.196.325.52c.032.326-.03.162-.227.162-.49 0-.552-.424-.98-.357-1.077.098-1.14.552-1.727.62-.588.062-1.567-.26-1.434-1.012.13-.748 1.14-1.273 2.088-1.665.944-.392 2.382-1.63 2.186-2.743-.096-.546-.351-.768-.585-.852-.683.27-1.4.45-2.13.531-2.1.257-2.804-.742-2.983-1.09-1.302.933-3.153 1.275-3.842 2.422.294-1.63 1.175-2.155 3.232-3.099 2.052-.942 2.478-2.891 2.48-2.901v-.006.006c-.002.03-.101 1.773-1.247 3.03.39.746.984 1.125 2.36.984 1.567-.16 3.828-1.52 5.419-2.316 1.109-.556 1.598.49 2.382.553 1.09.09.196 1.238.196 1.238s.819-.13.98-.423c.16-.294-.099-.49.16-.749.262-.262.227-.556-.145-.83-.33-.243-.537-.568-1.614-1.058-1.078-.49-1.994.454-3.233.748-.932.22-1.77-.183-2.129-.399-.956 1.024-2.141 1.222-2.141 1.222v-.004c1.175-.686 1.908-1.931 2.225-3.009.234-.795.07-1.655-.033-2.052-1.51-.03-2.627-1.478-2.627-1.478h.004s1.924 1.238 3.49.717c1.564-.521 1.305-3.554 1.337-3.393.015.078.262.692.3 1.436.367-.044 1.705-.25 1.424-.887-.884-1.99-2.486-3.235-5.312-3.374.518 2.805-1.864 2.038-5.616 3.961C1.687 7.243.653 10.448 1.107 14.17c.277 2.245 1.718 4.716 4.387 6.323a2.58 2.58 0 0 0 1.647-.834c.815-.913.356-2.35 1.696-2.872a4.109 4.109 0 0 1 1.472-.296c.491-.003.781.1.781.1s-2.382.325-2.578 1.697c-.196 1.371-.52 1.99-1.042 2.413-.238.186-.51.324-.802.405 1.564.7 3.462 1.127 5.703 1.127 7.15 0 10-5.673 10.305-7.193.34-1.681 1.324-2.08 1.324-.286 0 3.428-5.136 8.388-11.601 8.388-6.465 0-10.054-3.495-11.523-6.3C-.594 14.032-.2 9.758 1.954 7.18c2.154-2.582 5.081-3.166 7.2-3.851 2.017-.653 1.91-1.86 1.895-1.975-.33-.015-.662-.017-.993-.004.796-.318 1.543-.491 2.257-.492zm9.299 4.492c-.358.006-1.19 1.31-1.863 2.994-.705 1.77-.909 3.314-.69 3.436.122.067 1.168-1.203 1.873-2.97.706-1.77 1.054-3.326.729-3.452a.126.126 0 0 0-.05-.008zm-6.66.502c-.01.779-.283 1.647-1.284 2.178-.08.043-.158.08-.236.112a3.9 3.9 0 0 1 .076.42c.27.151.672.34 1.112.413.784.129 1.34-.396 1.568-.588.227-.192.572-.047.732-.016.16.036.486-.062.259-.16-.231-.098-.49-.44-.686-.862-.208-.833-.5-1.19-.653-1.33-.248.122-.579.029-.8-.12-.03-.015-.06-.03-.088-.047zm6.396.166h.014l-.036.014c-.006.004-.01.01-.015.016.016.07.007.146.007.225a.806.806 0 0 1-.03.24c.006.015 0 .04 0 .059-.019.024-.004.044-.009.064.03.029.074.063.054.102-.01.025-.04.035-.069.044-.014.07-.034.147-.049.226 0 .02 0 .049-.004.068-.015.05-.03.093-.045.147-.01.044 0 .128-.048.137-.02.05-.03.089-.054.138-.01.004-.02-.005-.03 0v.001a1.04 1.04 0 0 1-.03.18c0 .02-.004.054-.004.078-.025.034-.01.059-.02.088.035.04.079.079.054.137-.014.04-.054.05-.088.069-.03.093-.059.206-.088.308-.005.03-.01.064-.02.094-.024.063-.054.127-.073.2-.02.06-.015.167-.078.177-.03.063-.045.112-.079.176-.015.01-.024-.005-.039 0-.015.02-.02.049-.034.069-.01.01-.025.01-.035.024-.02.03-.014.073-.034.118a.318.318 0 0 0-.054.063l-.005.01c-.023.062-.034.136-.062.196.023-.197.045-.426.063-.662.009-.17.022-.382.037-.599a6.43 6.43 0 0 0-.01-.89l.031-.063.064-.123c.014-.151.026-.256.03-.24a.95.95 0 0 1 .023.14c.035-.061.071-.124.113-.193.04-.069.074-.142.118-.196.03-.04.078-.117.113-.19.01-.025.01-.05.048-.055.035-.044.064-.098.103-.137.01-.01.025-.015.035-.02.01-.01.014-.024.029-.034.024-.02.069-.039.098-.078.005-.01.01-.02.02-.03.012-.015.03-.045.05-.068l-.001-.01.017-.006a.062.062 0 0 1 .022-.014zm-.993 1.453c-.057.724-.1 1.45-.128 2.175a1.87 1.87 0 0 0-.045.095c-.049.117-.122.254-.171.391l-.015.079c-.02.054-.049.107-.064.161-.03.084-.068.23-.147.309-.004.01-.024.02-.034.03-.01.014-.005.034-.02.053l-.017.011.117-1.412c.006-.26.033-.515.07-.746l-.003-.032c.015-.083.025-.147.049-.24l.01-.03c.078-.384.164-.645.164-.645l-.032.308c.012-.028.025-.056.04-.084.014-.03.038-.054.053-.088.005-.015.01-.04.015-.059.046-.095.102-.184.158-.276zm-.599 1.579c-.073.505-.127 1.15-.06 1.744-.006.011-.01.023-.018.034-.025.024-.06.039-.084.068-.014.02-.024.05-.044.074a.98.98 0 0 1-.068.078l-.088.128a.212.212 0 0 1-.098.088c-.02.01-.05.005-.074.01-.014-.02 0-.05 0-.074 0-.01-.01-.024-.01-.034 0-.03-.004-.084 0-.113 0-.03.025-.054.035-.098.005-.034 0-.073 0-.112 0-.015.005-.035.005-.06 0-.029 0-.043.004-.083a.598.598 0 0 0-.004-.132c.02-.103.029-.186.058-.308.01-.054.035-.152.06-.216.019-.063.043-.127.063-.196.02-.068.044-.137.068-.205.015-.044.04-.084.06-.133.009-.024.009-.053.019-.083.02-.059.044-.122.073-.176l.083-.162zm-6.268 6.006c-.13.074-.263.146-.4.215.283.203.905.778.65 1.775a2.183 2.183 0 0 1-.038.132c.525.729 1.273 1.112 1.657 1.168.42.063.239-.164.176-.391-.066-.228.392-.294.65-.455.26-.164.13-.423-.716-.294-.762.12-1.833-1.545-1.979-2.15Z",source:"https://github.com/codemirror/CodeMirror/blob/6e7aa65a8bfb64837ae9d082b674b2f5ee056d2c/doc/logo.svg",hex:"D30707",guidelines:void 0,license:void 0},siCodereview={title:"Code Review",slug:"codereview",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Code Review</title><path d="'+this.path+'"/></svg>'},path:"M11.986 23.972C5.411 23.972 0 18.561 0 11.986 0 5.411 5.411 0 11.986 0c6.575 0 11.986 5.411 11.986 11.986a11.9 11.9 0 0 1-2.492 7.281l2.062 2.062c.293.293.458.691.458 1.106 0 .859-.706 1.565-1.565 1.565-.415 0-.813-.165-1.106-.458l-2.062-2.062a11.9 11.9 0 0 1-7.281 2.492Zm6.664-6.001a8.936 8.936 0 0 0 2.31-5.985c0-4.923-4.051-8.974-8.974-8.974-2.702 0-5.141 1.22-6.792 3.135h5.255v2.458H3.681a8.851 8.851 0 0 0-.536 1.844H9.22v2.459H3.06c.087.845.297 1.673.621 2.459h4.31v2.458H5.194c1.651 1.915 4.09 3.135 6.792 3.135 2.29 0 4.392-.877 5.985-2.31a1.59 1.59 0 0 1 .679-.679Zm-9.43-.146h7.376v-2.458H9.22v2.458Zm6.147-4.917h4.917v-2.459h-4.917v2.459Zm-4.918 0h3.074v-2.459h-3.074v2.459Zm1.844-4.303h4.918V6.147h-4.918v2.458Z",source:"https://codereview.stackexchange.com/",hex:"485A62",guidelines:"https://stackoverflow.com/legal/trademark-guidance",license:void 0},siCodeberg={title:"Codeberg",slug:"codeberg",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Codeberg</title><path d="'+this.path+'"/></svg>'},path:"M11.955.49A12 12 0 0 0 0 12.49a12 12 0 0 0 1.832 6.373L11.838 5.928a.187.14 0 0 1 .324 0l10.006 12.935A12 12 0 0 0 24 12.49a12 12 0 0 0-12-12 12 12 0 0 0-.045 0zm.375 6.467l4.416 16.553a12 12 0 0 0 5.137-4.213z",source:"https://codeberg.org",hex:"2185D0",guidelines:void 0,license:void 0},siChatbot={title:"ChatBot",slug:"chatbot",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>ChatBot</title><path d="'+this.path+'"/></svg>'},path:"M11.999 0c-2.25 0-4.5.06-6.6.21a5.57 5.57 0 00-5.19 5.1c-.24 3.21-.27 6.39-.06 9.6a5.644 5.644 0 005.7 5.19h3.15v-3.9h-3.15c-.93.03-1.74-.63-1.83-1.56-.18-3-.15-6 .06-9 .06-.84.72-1.47 1.56-1.53 2.04-.15 4.2-.21 6.36-.21s4.32.09 6.36.18c.81.06 1.5.69 1.56 1.53.24 3 .24 6 .06 9-.12.93-.9 1.62-1.83 1.59h-3.15l-6 3.9V24l6-3.9h3.15c2.97.03 5.46-2.25 5.7-5.19.21-3.18.18-6.39-.03-9.57a5.57 5.57 0 00-5.19-5.1c-2.13-.18-4.38-.24-6.63-.24zm-5.04 8.76c-.36 0-.66.3-.66.66v2.34c0 .33.18.63.48.78 1.62.78 3.42 1.2 5.22 1.26 1.8-.06 3.6-.48 5.22-1.26.3-.15.48-.45.48-.78V9.42c0-.09-.03-.15-.09-.21a.648.648 0 00-.87-.36c-1.5.66-3.12 1.02-4.77 1.05-1.65-.03-3.27-.42-4.77-1.08a.566.566 0 00-.24-.06z",source:"https://chatbot.design/",hex:"FFD000",guidelines:void 0,license:void 0},siCodecademy={title:"Codecademy",slug:"codecademy",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Codecademy</title><path d="'+this.path+'"/></svg>'},path:"M23.827 19.729h-5.595c-.094 0-.17.058-.17.172v1.515c0 .094.058.17.172.17h5.594c.096 0 .172-.044.172-.164v-1.515c0-.105-.057-.166-.173-.166v-.014zM16.463 2.463c.016.034.03.067.047.12v18.79c0 .06-.02.096-.037.114a.168.168 0 01-.135.06H.153c-.038 0-.075 0-.097-.02A.181.181 0 010 21.393V2.564c0-.076.04-.134.096-.15h16.242c.04 0 .096.017.115.034v.016zM1.818 19.573c0 .072.038.135.096.152h12.643c.058-.019.096-.076.096-.154V4.402c0-.073-.039-.134-.098-.15H1.915c-.056.02-.096.073-.096.15l-.003 15.17zm5.174-8.375c.65 0 1.014.177 1.396.62.058.074.153.093.23.034l1.034-.92c.075-.044.058-.164.02-.224-.635-.764-1.554-1.244-2.74-1.244-1.59 0-2.79.795-3.255 2.206-.165.495-.24 1.126-.24 1.98 0 .854.075 1.483.255 1.98.465 1.425 1.665 2.204 3.255 2.204 1.2 0 2.115-.48 2.745-1.216.045-.074.06-.165-.015-.226l-1.037-.915c-.073-.047-.163-.047-.224.027-.39.45-.795.69-1.454.69-.706 0-1.245-.345-1.47-1.035-.136-.39-.166-.87-.166-1.483 0-.615.045-1.068.18-1.47.24-.66.766-1.008 1.486-1.008z",source:"https://www.codecademy.com/",hex:"1F4056",guidelines:void 0,license:void 0},siCirrusci={title:"Cirrus CI",slug:"cirrusci",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Cirrus CI</title><path d="'+this.path+'"/></svg>'},path:"M19.422.453a1.113 1.113 0 0 0-1.113 1.115 1.113 1.113 0 0 0 1.112 1.114c1.31 0 2.35 1.042 2.35 2.363 0 1.32-1.04 2.363-2.35 2.363H1.112A1.113 1.113 0 0 0 0 8.52a1.113 1.113 0 0 0 1.113 1.117h18.31c1.308 0 2.35 1.042 2.35 2.363 0 1.32-1.042 2.363-2.35 2.363H1.112A1.113 1.113 0 0 0 0 15.48a1.113 1.113 0 0 0 1.113 1.112h18.31c1.308 0 2.35 1.042 2.35 2.363 0 1.32-1.042 2.363-2.35 2.363H1.112A1.113 1.113 0 0 0 0 22.432a1.113 1.113 0 0 0 1.113 1.115h18.31a1.113 1.113 0 0 0 .206-.022c2.42-.112 4.37-2.12 4.37-4.57 0-1.393-.642-2.634-1.63-3.478C23.356 14.632 24 13.393 24 12c0-1.393-.643-2.632-1.63-3.477C23.357 7.68 24 6.438 24 5.045c0-2.52-2.06-4.592-4.578-4.592z",source:"https://cirrus-ci.org",hex:"4051B5",guidelines:void 0,license:void 0},siCodeceptjs={title:"CodeceptJS",slug:"codeceptjs",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>CodeceptJS</title><path d="'+this.path+'"/></svg>'},path:"M15.3986.597c-1.424 0-1.5473.0048-1.59.0807-.0238.0475-1.0206 2.6485-2.212 5.7811-1.196 3.1326-2.1737 5.7005-2.1832 5.71-.0048.0047-1.0348-1.1534-2.2831-2.5726C5.1937 7.394 4.852 7.0236 4.8283 7.1138c-.0424.1883-.0657.3492-.095.5412l2.7815 3.6262c1.5283 1.9935 2.7956 3.631 2.8146 3.6358.0285.0095 6.474-13.9308 6.588-14.2393.0285-.076-.0664-.0807-1.5188-.0807zM7.6828 2.1692a8.7326 8.7326 0 0 0-.88.0463c-1.2483.1282-2.4871.5696-3.5218 1.2579-.5554.3654-1.5142 1.329-1.9034 1.9033-2.1311 3.161-1.7561 7.3758.8924 9.9816.6028.5933 1.2008 1.0158 2.041 1.4382 1.03.5221 2.0694.8259 3.4174 1.0157 1.0062.1377 2.9238.1092 4.1199-.0616l.1993-.0285v-.6692l-.1756.0284c-1.0727.1709-3.0994.1614-4.0962-.0143-2.601-.4604-4.5091-1.7609-5.577-3.8066-.9256-1.7704-1.049-4.0486-.3228-5.9947.375-1.0157.8781-1.7989 1.647-2.563.7974-.7974 1.5664-1.2769 2.5631-1.6091 1.3148-.4367 2.9475-.4699 4.4901-.095.2658.0618.489.114.4937.114.0284 0 .185-.3797.166-.3987-.0427-.038-1.0015-.2658-1.4903-.356a11.0808 11.0808 0 0 0-2.0628-.1887zm10.6834.792c-.0283-.0042.0274.0476.184.1846 2.1074 1.8321 3.3605 4.0108 3.8019 6.6118.1424.8449.1566 2.3922.0284 3.2275-.3654 2.3495-1.3859 4.3857-3.0471 6.0565-1.8559 1.87-4.101 2.9665-6.8112 3.3225-.8306.1091-2.5345.0712-3.37-.0712-.9777-.1662-1.9697-.4747-3.0139-.9256-.5743-.2515.432.3892 1.2863.8164 2.5298 1.2673 5.4679 1.5568 8.2588.8211.731-.1946 1.3527-.432 2.1311-.8116 3.4602-1.6993 5.7574-4.979 6.1513-8.7762.0665-.655.0333-1.9175-.0759-2.5915-.4746-3.0282-2.2213-5.7337-4.8176-7.4471-.2468-.1661-.5268-.337-.617-.3797-.046-.0223-.0762-.0357-.089-.0376zM16.271 8.1145c-.2641-.0026-.5068.0126-.6967.0482-.8544.1661-1.4382.674-1.609 1.4002-.1804.75.0427 1.4192.5837 1.7657.318.1993.6028.2942 1.462.4888.9018.2041 1.2103.3418 1.3907.6123.1044.1567.128.2421.1233.4794 0 .1709-.0332.3512-.0806.4367-.1092.2135-.413.4556-.6883.5553-.5363.1946-1.5473.185-2.3162-.019-.6598-.1756-.5886-.1993-.5886.1899 0 .2943.0143.3417.1092.4034.3845.2563 1.8986.3893 2.7387.2469.522-.0902 1.03-.3134 1.3242-.5744.1044-.0997.2611-.318.3465-.4889.1472-.2942.1567-.3464.1567-.8163 0-.451-.0143-.5221-.133-.769-.2658-.5458-.7309-.7879-2.0029-1.0584-.8686-.1804-1.234-.375-1.405-.7547-.223-.4936.0048-1.03.5364-1.2625.4841-.2089 1.533-.171 2.4017.0901l.2942.0902V8.438l-.2278-.076c-.4535-.15-1.1382-.2418-1.7192-.2475z",source:"https://github.com/codeceptjs/codeceptjs.github.io/blob/c7917445b9a70a9daacf20986c403c3299f5c960/favicon/safari-pinned-tab.svg",hex:"F6E05E",guidelines:void 0,license:void 0},siCheckmarx={title:"Checkmarx",slug:"checkmarx",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Checkmarx</title><path d="'+this.path+'"/></svg>'},path:"M6.544.12A6.553 6.553 0 0 0 0 6.664v10.674a6.551 6.551 0 0 0 6.544 6.542h10.912A6.551 6.551 0 0 0 24 17.338v-.831a2.193 2.193 0 0 0-4.388 0v.83c0 1.19-.967 2.157-2.156 2.157H6.544a2.16 2.16 0 0 1-2.158-2.156V6.748c0-1.19.969-2.16 2.158-2.16 3.843.004 7.814-.009 11.612.001.556.138.892.445 1.058.848.193.47.343 1.118-.404 1.748l-6.26 4.596-1.892-2.441a2.191 2.191 0 0 0-3.075-.391 2.191 2.191 0 0 0-.391 3.076l3.198 4.133a2.197 2.197 0 0 0 3.035.424l7.252-5.301a56.68 56.68 0 0 0 1.22-.977c2.106-1.926 2.517-4.393 1.627-6.553C22.603 1.51 20.268.12 17.435.12Z",source:"https://www.checkmarx.com/resources/datasheets/",hex:"54B848",guidelines:void 0,license:void 0},siCodechef={title:"CodeChef",slug:"codechef",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>CodeChef</title><path d="'+this.path+'"/></svg>'},path:"M11.2574.0039c-.37.0101-.7353.041-1.1003.095C9.6164.153 9.0766.4236 8.482.694c-.757.3244-1.5147.6486-2.2176.7027-1.1896.3785-1.568.919-1.8925 1.3516 0 .054-.054.1079-.054.1079-.4325.865-.4873 1.73-.325 2.5952.1621.5407.3786 1.0282.5408 1.5148.3785 1.0274.7578 2.0007.92 3.1362.1622.3244.3235.7571.4316 1.1897.2704.8651.542 1.8383 1.353 2.5952l.0057-.0028c.0175.0183.0301.0387.0482.0568.0072-.0036.0141-.0063.0213-.0099l-.0213-.5849c.6489-.9733 1.5673-1.6221 2.865-1.8925.5195-.1093 1.081-.1497 1.6625-.1278a8.7733 8.7733 0 0 1 1.7988.2357c1.4599.3785 2.595 1.1358 2.6492 1.7846.0273.3549.0398.6952.0326 1.0364-.001.064-.0046.1285-.007.193l.1362.0682c.075-.0375.1424-.107.2059-.1902.0008-.001.002-.002.0028-.0028.0018-.0023.0039-.0061.0057-.0085.0396-.0536.0747-.1236.1107-.1931.0188-.0377.0372-.0866.0554-.1292.2048-.4622.362-1.1536.538-1.9635.0541-.2703.1092-.4864.1633-.7027.4326-.9733 1.0266-1.8382 1.6213-2.6492.9733-1.3518 1.8928-2.5962 1.7846-4.0561-1.784-3.4608-4.2718-4.0017-5.5695-4.272-.2163-.0541-.3233-.0539-.4856-.108-1.3382-.2433-2.4945-.3953-3.6046-.3648zm5.0428 14.3788a9.8602 9.8602 0 0 0-.0326-.9824c-.0541-.703-1.1892-1.46-2.7032-1.8386-.588-.1336-1.1764-.2142-1.7448-.2356-.539-.0137-1.0657.0248-1.5546.1277-1.2436.2704-2.2162.9193-2.811 1.8925l.0511 1.431c.6672-.3558 1.7326-.8747 3.139-.9994.0662-.0059.1368-.0059.2044-.0099.1177-.013.2667-.044.4444-.044 1.6075 0 3.2682.5336 4.8767 1.6483.039-.2744.0611-.549.071-.8234l.044.0227c.0028-.0622.0143-.1268.0156-.1888zM11.256.0578c.1239-.0034.2538.01.379.0114-.23-.0022-.4588.0026-.6871.0156.103-.0061.2046-.0242.308-.027zm.4983.0156c.6552.014 1.3255.0711 2.0387.1803-.6834-.0987-1.3646-.1671-2.0387-.1803zm-1.3147.0554c-.076.0087-.1527.0133-.2285.0241-.8168.1167-1.7742.7015-2.75 1.045.3545-.1323.7143-.2957 1.0747-.4501C9.0765.4774 9.6705.207 10.1571.1529c.0939-.0139.1886-.0133.2825-.0241zm-.2285.24c.1622 0 .3787-.0002.5409.0539-.1425-.0357-.2595-.026-.3706-.0142a1.174 1.174 0 0 1 .3166.0681c.5796 1.0012-.4264 5.2791-.6786 8.1492.1559 1.0276.3138 1.9963.4628 2.7201-.7029-1.7843-1.4067-4.921-1.5148-7.354-.054-.9733.001-1.8386.2172-2.4874C9.401.8557 9.7244.4228 10.2111.3687zm3.1361.271c-.811 2.1088-.9184 6.1092-.9725 7.3528-.054.5407-.0001 1.73.054 2.5952 0 .2163.054.4325.054.6488 0-.2163-.054-.3786-.054-.5948-.4326-3.2442-.974-7.1362.9185-10.002zm3.352.3777c-.2704 2.1628-1.4047 3.191-1.7832 5.2998-.1081 1.6762-.325 3.6222-.379 5.2984-.0541-1.6762-.0007-3.4601.2697-5.2444.2703-1.8384.8651-3.6776 1.8925-5.3538zm-10.381.433c-.3581.1194-.632.248-.8575.3805.2317-.1358.4996-.2666.8575-.3805zm.2101.1974c.2155.0025.4384.0734.6006.2357-.0067-.004-.0078-.0033-.0142-.0071.1331.0929.2666.2093.3932.3847-.2036.9673.2553 3.0317.0398 4.6694.0763 1.5485.0717 3.1804.849 4.4594-.9796-1.5107-1.176-3.4375-1.3218-5.236-.1128-1.0907-.2035-2.0969-.4642-2.9033-.144-.3047-.2684-.5745-.3833-.822-.0247-.0369-.0447-.0784-.071-.1135-.1082-.1082-.1619-.2696-.1619-.3777 0-.054.0539-.1618.108-.1618.054-.0541.1616-.0553.2157-.1094a1.013 1.013 0 0 1 .2101-.0184zm-1.3459.6133c-.0604.0201-.0923.041-.1405.061.1768-.034.3617.0339.5196.318-.1877.8916.4364 3.3685.4288 5.104.3124 1.8478.5496 3.8498 1.5716 5.1152C6.3723 11.5076 5.886 9.1286 5.5076 7.128 5.183 5.56 4.9125 4.2086 4.3718 3.776c-.054-.1081-.1079-.163-.1079-.2711 0-.1622-.0002-.3786.1079-.5949-.2772.6337-.4047 1.2673-.3706 1.901-.0445-.6487.0857-1.2905.3706-1.901 0-.054.054-.0538.054-.1079.012-.016.0314-.0349.044-.0511.0618-.0983.1308-.189.2257-.257.0557-.0615.0965-.1191.159-.1817-.0526.0555-.0872.1092-.1335.1647.0273-.018.0523-.0368.0838-.0525.1081-.1082.2154-.1633.3776-.1633zm-.3776.1633c-.0038.0075-.0076.0111-.0114.0184.0125-.0099.0242-.0208.037-.0298-.0074.0037-.0182.0077-.0256.0114zm14.7608 1.1343c-.0017.0052-.004.0104-.0057.0156.0378-.005.0751-.0173.1135-.0156-.0378-.0022-.0763.0103-.115.0199-.8634 2.6418-1.8874 5.2844-2.9118 7.9262a.0184.0184 0 0 1-.0015.0028c-.0874.4652-.234.8842-.5395 1.1898.4326-.4867.4854-1.1907.5395-2.0558.054-.811.0544-1.6761.487-2.5413 0-.0531.0012-.1058.0525-.159.0003-.0009.0012-.0019.0015-.0028.0973-.3524.202-.6885.3166-1.018.4183-1.2896 1.1396-3.1653 2.0131-3.3405.0163-.0052.034-.018.0497-.0213zM8.3726 16.2113l-.3238.1079c.1623.2163.2696.379.3777.433.1081.054.2168.108.379.108.0541 0 .1618 0 .2159-.054l.812-.2698c.0541 0 .1078-.054.1619-.054.1081 0 .1616 0 .2697.054l.2712.2698.2697-.054c-.1081-.1622-.2695-.3236-.3776-.3776-.1082-.0541-.2169-.1094-.379-.1094h-.108l-.866.3252h-.1618c-.1082 0-.2157 0-.2698-.054-.054-.054-.163-.1629-.2712-.3251zm-2.5953.541c-.2703.1621-.649.4324-1.1897.6487-.5407.2163-.9734.4325-1.1897.6488-.2163.2163-.3237.4326-.3237.6488 0 .1082.0537.1632.1618.2172.054.0541.1632.0539.2172.108.757.3244 1.5133.7019 2.2162 1.0803.1082.0541.2171.1632.2712.2173.054.054.1078.054.1618.054.1082 0 .2695-.0538.3777-.162.1081-.108.1632-.217.1632-.325 0-.1082-.055-.1618-.1632-.2158 0 0-.4328-.2165-1.1898-.541-.4866-.2162-.9179-.4326-1.1883-.5948.1623-.2704.486-.4865.9726-.7028.5407-.2163.9196-.4326 1.0818-.5948.054-.0541.054-.1078.054-.1619 0-.054-.0539-.1631-.108-.2172-.054-.054-.163-.1079-.2711-.1079zm11.247 0c-.054 0-.1618.0537-.2158.1078-.0541.1081-.1093.1632-.1093.2172v.054c.1622.1622.3797.2695.7041.3776.2704.054.5403.1632.8107.2172.3244.1082.5407.2693.6488.4856v.0553c0 .0541-.1088.1616-.3251.2698-.1082.054-.3245.2167-.5949.433-.2703.1622-.4326.3236-.5948.3776-.2163.1082-.3776.217-.4316.3252-.0541.054-.054.1077-.054.1618 0 .1081.0539.1077.108.2158.054.1081.1616.1093.2157.1093.054 0 .1078-.0554.1619-.0554.2703-.1622.6492-.3782 1.0818-.7567.4866-.3784.8655-.6484 1.0818-.8106.2163-.1082.3237-.2169.3237-.379 0-.0541.0002-.1618-.1079-.2159-.3785-.4325-.9185-.7022-1.5674-.9185-.1081-.0541-.2704-.1092-.5948-.1633-.1622-.054-.3249-.1079-.433-.1079zm-2.9743.8106c-.2704 0-.4866.055-.6488.2172-.2163.1622-.2699.4323-.2158.7567 0 .2703.1075.4865.2697.7027.1622.2163.3786.3252.5949.3252.1622 0 .2708-.0553.433-.1094.2703-.1622.379-.4319.379-.9185 0-.3785-.109-.6485-.2711-.8107-.1622-.1081-.3246-.1632-.541-.1632zm-4.4877.054c-.2704 0-.4866.055-.6488.2171-.2163.1622-.27.4323-.2158.7567 0 .2704.1075.4865.2697.7028s.3786.3251.5949.3251c.1622 0 .2708-.0552.433-.1093.2703-.1622.3776-.432.3776-.9186 0-.4325-.1075-.7025-.2697-.8106-.1622-.1082-.3247-.1633-.541-.1633zm0 .6501c.1622 0 .2711.1076.2711.2698 0 .1622-.163.2697-.2711.2697-.1622 0-.2698-.1075-.2698-.2697s.1076-.2698.2698-.2698zm4.3798.054c.1622 0 .2711.1075.2711.2697 0 .1082-.109.2698-.2711.2698-.1622 0-.2698-.1076-.2698-.2698 0-.1622.1076-.2697.2698-.2697zm-2.7032 2.1083l.1619.3237c.054.1081.1076.163.2158.2711.054.054.163.1619.2712.1619h.1078c.1082 0 .1618 0 .2158-.054.0541-.054.1632-.0538.2173-.1079l.1618-.1618c.054-.054.108-.1092.108-.1633.054-.054.0537-.1078.1078-.1618 0-.0541.054-.108.054-.108-.0541.1082-.1618.2156-.2158.3238-.1082.054-.1616.1632-.2698.1632-.1081.0541-.217.054-.3251.054s-.2157.0001-.2697-.054c-.1082 0-.1632-.0538-.2173-.1079l-.1618-.1632c-.054-.0541-.1078-.1618-.1619-.2158zm-.866 1.0278c-1.1355 0-1.8377 1.5136-3.4598.1619-.4326 2.6494 2.7583 2.866 4.11 1.7306.9192-.811.6475-1.9465-.6502-1.8925zm2.8664 0c-1.2977-.054-1.568 1.0815-.6488 1.8925 1.3518 1.1355 4.5412.9188 4.1087-1.7306-1.6221 1.3517-2.2703-.1619-3.4599-.1619z",source:"https://www.codechef.com/",hex:"5B4638",guidelines:void 0,license:void 0},siChef={title:"Chef",slug:"chef",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Chef</title><path d="'+this.path+'"/></svg>'},path:"M12.03 0C6.94 0 2.57 3.17.82 7.65l1.91.77a10 10 0 0 1 9.3-6.4c2.24 0 4.32.77 5.96 1.97l1.2-1.64A11.96 11.96 0 0 0 12.03 0zm0 2.3a9.76 9.76 0 0 0-9.08 6.23l1.91.7a7.62 7.62 0 0 1 7.17-4.91zm3.55.7l-.76 1.92a7.47 7.47 0 0 1 4.75 5.63h2.08a9.7 9.7 0 0 0-6.07-7.54zm-3.55 1.6a7.44 7.44 0 1 0 7.32 8.9h-2.08a5.5 5.5 0 0 1-5.24 3.94 5.39 5.39 0 0 1-5.42-5.41 5.39 5.39 0 0 1 5.42-5.41 5.4 5.4 0 0 1 5.2 3.93h2.07a7.35 7.35 0 0 0-7.27-5.96zm10.22 1.09L20.5 6.78a9.5 9.5 0 0 1 1.42 3.77H24a11.56 11.56 0 0 0-1.75-4.86zM11.97 6.83a5.22 5.22 0 0 0-4.7 7.27l1.97-.87a2.97 2.97 0 0 1-.27-1.2c0-1.64 1.36-3.01 3-3.01zm1.92.39l-.77 2.02c.66.27 1.15.7 1.53 1.31h2.3a5.04 5.04 0 0 0-3.06-3.33zM0 12.02c0 1.65.33 3.29 1.04 4.87l1.8-.82a10.49 10.49 0 0 1-.82-4.04zm2.3 0c0 4.1 2.51 7.6 6.12 9.03l.76-1.92a7.63 7.63 0 0 1-4.86-7.1zm12.3 1.48c-.33.6-.82 1.1-1.48 1.31l.77 2.03a5.04 5.04 0 0 0 3.06-3.34zm4.97 0a7.73 7.73 0 0 1-7.54 6.24v2.02a9.71 9.71 0 0 0 9.62-8.26zm2.35 0a10.1 10.1 0 0 1-9.9 8.53c-2.73 0-5.24-1.15-7.04-2.95L3.55 20.5c2.19 2.19 5.2 3.5 8.53 3.5A12 12 0 0 0 24 13.5zm-12.02.66l-1.53 1.53a5.21 5.21 0 0 0 3.66 1.53v-2.19a3.02 3.02 0 0 1-2.13-.87z",source:"https://www.chef.io/",hex:"F09820",guidelines:void 0,license:void 0},siCodeigniter={title:"CodeIgniter",slug:"codeigniter",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>CodeIgniter</title><path d="'+this.path+'"/></svg>'},path:"M11.466 0c.88 1.423-.28 3.306-1.207 4.358-.899 1.02-1.992 1.873-2.985 2.8-1.066.996-2.091 2.044-2.967 3.213-1.753 2.339-2.827 5.28-2.038 8.199.788 2.916 3.314 4.772 6.167 5.429-1.44-.622-2.786-2.203-2.79-3.82-.003-1.765 1.115-3.262 2.505-4.246-.167.632-.258 1.21.155 1.774a1.68 1.68 0 0 0 1.696.642c1.487-.326 1.556-1.96.674-2.914-.872-.943-1.715-2.009-1.384-3.377.167-.685.588-1.328 1.121-1.787-.41 1.078.755 2.14 1.523 2.67 1.332.918 2.793 1.612 4.017 2.688 1.288 1.132 2.24 2.661 2.047 4.435-.208 1.923-1.736 3.26-3.45 3.936 3.622-.8 7.365-3.61 7.44-7.627.093-3.032-1.903-5.717-5.158-7.384.19.48.074.697-.058.924-.55.944-2.082 1.152-2.835.184-1.205-1.548.025-3.216.197-4.855.215-2.055-1.073-4.049-2.67-5.242z",source:"https://www.codeigniter.com/help/legal",hex:"EF4223",guidelines:void 0,license:void 0},siChevrolet={title:"Chevrolet",slug:"chevrolet",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Chevrolet</title><path d="'+this.path+'"/></svg>'},path:"M23.905 9.784H15.92V8.246a.157.157 0 00-.157-.158H8.238a.157.157 0 00-.157.158v1.538H2.358c-.087 0-.193.07-.237.158L.02 14.058c-.045.088-.011.157.077.157H8.08v1.54c0 .086.07.157.157.157h7.525c.087 0 .157-.07.157-.157v-1.54h5.723c.087 0 .193-.07.238-.157l2.1-4.116c.045-.087.011-.158-.076-.158m-2.494.996l-1.244 2.437h-5.232v1.708H9.07v-1.708H2.595L3.84 10.78h5.232V9.073h5.864v1.707z",source:"https://www.chevrolet.com/content/dam/chevrolet/na/us/english/index/shopping-tools/download-catalog/02-pdf/2019-chevrolet-corvette-catalog.pdf",hex:"CD9834",guidelines:void 0,license:void 0},siChinaeasternairlines={title:"China Eastern Airlines",slug:"chinaeasternairlines",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>China Eastern Airlines</title><path d="'+this.path+'"/></svg>'},path:"M11.572 2.383c-1.846 0-2.245.238-2.962 1.205-.38.516-3.568 4.915-5.009 6.898-.18.236-.446.486-1.03.486H0v.004c3.05 8.61 6.324 10.64 9.602 10.64h5.178c.07 0 .146-.08-.041-.124-3.805-.953-7.57-3.984-7.589-6.962.066 2.464 5.255 3.315 10.876 4.016.098.011.093-.065.063-.12l-.17-.293c-.02-.039-.043-.068-.124-.088-3.094-.787-6.242-1.938-6.242-3.01 0-2.032 5.272-4.042 11.27-4.96.195-.04.29-.076.42-.18.17-.136.536-.433.695-.554.096-.085.061-.11.025-.11-.16 0-.326.004-.485.01-7.898.219-15.544 2.008-16.253 4.55-.002.014-.01.027-.014.04.937-4.652 7.198-9.162 15.008-11.28.18-.052.239-.168.014-.168Z",source:"https://uk.ceair.com/newCMS/uk/en/content/en_Footer/Support/201904/t20190404_5763.html",hex:"1A2477",guidelines:void 0,license:void 0},siChinasouthernairlines={title:"China Southern Airlines",slug:"chinasouthernairlines",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>China Southern Airlines</title><path d="'+this.path+'"/></svg>'},path:"M16.4269 9.8628v.6196c.3071-.003.5555.1004.5555.1004-.7588.2595-1.1804 1.0664-1.1804 1.8426v2.6228c-.0417.0354-.0665.0665-.0941.0985-.1116-.344-.4517-.7569-.8049-.9524v-2.029c0-.7272.5308-1.5219 1.2808-1.6708v-.6351c-.2426-.0558-.426-.275-.426-.5342a.549.549 0 0 1 .5493-.5516.5506.5506 0 0 1 .5526.5516c0 .2591-.1868.4847-.4328.5376m-3.0299-.0035v.6355c.7491.149 1.2828.9432 1.2828 1.6704v2.0295c-.3556.195-.6943.6079-.8049.9519-.03-.0316-.0548-.0631-.0946-.0985v-2.6228c0-.7913-.4216-1.583-1.1794-1.8422 0 0 .247-.1038.5516-.1004v-.6234a.55.55 0 0 1-.425-.5342c0-.3057.243-.5511.5497-.5511a.5506.5506 0 0 1 .5516.5511c0 .2596-.1848.4789-.4318.5342m1.5162-.4217l-.003.5948c.293.0393.555.244.6448.4861-.3478.2261-.6297.5691-.7656.9946-.1334-.4255-.4157-.7685-.7636-.9946.1096-.242.3532-.4468.6433-.486v-.5968a.5497.5497 0 0 1-.4264-.5357.5496.5496 0 0 1 .5497-.5516c.3046 0 .553.246.553.5516 0 .262-.1848.4828-.4322.5376m-.1209 7.5837c1.7156 0 2.1013-1.4385 2.1542-1.8053v-.4846c-.5313.132-1.0053.4133-1.327.8354-.114-.493-.426-.914-.8272-1.1867-.4036.2727-.716.6938-.832 1.1867-.3188-.422-.7952-.7035-1.3245-.8354v.4846c.0514.3668.439 1.8053 2.1565 1.8053m-4.2333-5.006c-.0068-.7307.4949-1.326 1.5195-1.326.6783 0 1.488.5682 1.488 2.0266v2.1628c-.294-.193-.7034-.3702-.9266-.3736v-2.0163c0-.7724-.5546-.998-.815-.998.1474.1349.2362.3018.2362.5245 0 .41-.3416.7496-.753.7496-.411 0-.7306-.3028-.749-.7496m8.4666 0c.0043-.7307-.4978-1.326-1.52-1.326-.6793 0-1.4905.5682-1.4905 2.0266v2.1628c.295-.193.704-.3702.9252-.3736v-2.0163c0-.7724.5575-.998.8151-.998-.146.1349-.2343.3018-.2343.5245 0 .41.3406.7496.7525.7496.4128 0 .7326-.3028.752-.7496M15.9702 10.03c-.263-.1286-.4473-.3973-.4473-.705 0-.4332.3517-.7864.784-.7864.4347 0 .7855.3532.7855.7865a.7812.7812 0 0 1-.4469.7068v.2203c.2431.0252.5357.1266.7147.2183a4.0304 4.0304 0 0 1 .292-.0126c.9898 0 1.685.654 1.685 1.5574 0 .5565-.4987 1.065-1.0581 1.065-.5628 0-1.0722-.5517-.9708-1.1067 0 0-.0568.1916-.0568.4255V15.23c-.0247.323-.458 2.1056-2.4593 2.1056-2.0023 0-2.4374-1.7825-2.4617-2.1056v-2.831c0-.2338-.0572-.4254-.0572-.4254.1077.5336-.4086 1.1066-.9675 1.1066-.5637 0-1.0605-.5084-1.0605-1.065 0-.9033.6933-1.5573 1.6874-1.5573.1043 0 .2086.0068.2867.0126.182-.0917.489-.2003.7166-.2183v-.2232c-.2605-.1276-.4454-.3963-.4454-.704 0-.4332.3537-.7864.7865-.7864.4347 0 .7864.3532.7864.7865a.784.784 0 0 1-.4497.7093v.295c.066.0213.1353.0465.2003.0766.1218-.262.3668-.4667.6438-.5584V9.609c-.2663-.1271-.4487-.3954-.4487-.7093 0-.4352.3503-.785.783-.785a.7836.7836 0 0 1 .7855.785c0 .3139-.1815.5822-.4478.7093v.2387c.275.0902.5167.2964.638.5584.062-.03.1363-.0553.2023-.0767zM24 3.434h-6.8636L0 20.566h17.1364Z",source:"https://www.csair.com/en/about/investor/yejibaogao/2020/",hex:"008BCB",guidelines:void 0,license:void 0},siChocolatey={title:"Chocolatey",slug:"chocolatey",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Chocolatey</title><path d="'+this.path+'"/></svg>'},path:"M0 1.249l1.439 3.18L0 6.926l1.439 2.5L0 11.923l1.439 2.424L0 16.845l1.439 2.5L0 22.75l2.8-.91c6.3.01 12.696.006 18.096 0l3.104.91-2.044-3.635 1.136-1.892-2.196-2.272-.004-.017V2.005c-6.551-.001-12.243 0-18.091 0zm19.688 1.968v7.03l-.23-.898-1.438-4.39-3.56.605-1.89-2.343zm-11.695.004h4.563L9.539 4.428zm2.86 3.68a3.903 3.903 0 0 1 1.64.254c1.968.757 1.286 2.8.15 4.012-.378.378-1.21.227-.605-.908.228-.454.454-1.363-.227-1.59-1.515-.53-3.255.682-3.634 2.271-.378 1.363.606 2.801 2.347 2.423 1.439-.303 2.802-1.288 3.332-1.742.53-.455.907.38.301 1.288-.68.908-1.74 1.968-2.65 2.574-3.558 2.423-6.662-.758-5.375-4.392.677-1.845 2.454-4.041 4.72-4.19zm6.527 2.031a.66.66 0 0 1 .454.182c.324.326.204.972-.268 1.445-.473.474-1.121.593-1.446.268-.325-.326-.205-.972.267-1.445.292-.292.666-.461.993-.45zm-.42 3.233a.66.66 0 0 1 .454.182c.325.325.206.973-.268 1.446-.473.473-1.12.592-1.445.268-.324-.326-.205-.972.268-1.445.291-.292.664-.462.99-.451Z",source:"https://chocolatey.org/media-kit",hex:"80B5E3",guidelines:void 0,license:void 0},siChromecast={title:"Chromecast",slug:"chromecast",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Chromecast</title><path d="'+this.path+'"/></svg>'},path:"M0 18.5455v3.2727h3.2727c0-1.811-1.4618-3.2727-3.2727-3.2727zm0-4.3637v2.1818c3.011 0 5.4545 2.4437 5.4545 5.4546h2.1819c0-4.2218-3.4146-7.6364-7.6364-7.6364zm0-4.3636V12c5.4218 0 9.8182 4.3964 9.8182 9.8182H12c0-6.6327-5.3782-12-12-12zm21.8182-7.6364H2.1818C.9818 2.1818 0 3.1636 0 4.3636v3.2728h2.1818V4.3636h19.6364v15.2728h-7.6364v2.1818h7.6364c1.2 0 2.1818-.9818 2.1818-2.1818V4.3636c0-1.2-.9818-2.1818-2.1818-2.1818Z",source:"https://www.google.com/intl/en_us/chromecast/built-in/",hex:"999999",guidelines:void 0,license:void 0},siChrysler={title:"Chrysler",slug:"chrysler",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Chrysler</title><path d="'+this.path+'"/></svg>'},path:"M23.9996 12.1455c0-.0003.0004-.0007.0004-.001l-.0007.0003c-.0039-.0173-.0638-.0248-.172-.0258l-1.595-.0216c-2.4391-.0216-6.9786-.0638-7.1847-.0638h-.0501a1.8954 1.8954 0 0 0-.7028.0982l-.0913.0275a3.2546 3.2546 0 0 1-.795.1718c-.2837.0108-1.3633.0088-1.4085.0088s-1.1258 0-1.4085-.0078a3.2434 3.2434 0 0 1-.795-.1718l-.0913-.0275a1.9045 1.9045 0 0 0-.7037-.0982h-.0441c-.2071 0-4.7466.0206-7.1847.0432l-1.6008.0196c-.1089 0-.1727.0088-.1718.0265l.0913.0226c.336.069.6771.1107 1.0198.1247.6527.0128 5.4346.1325 5.5495.1345.2584-.0067.5155.039.7557.1343h1.4968s-.6046.0353-.6134.0726h-.0373c-.1512 0-.6066 0-.8647-.0118 0 0-.0186.0726.2444.0726.0923.0618.1884.1207.2758.1698h1.2868s-.5055.0304-.5153.0677c-.0599 0-.2797-.0059-.4908-.0118l-.2945-.0088s-.0147.0638.2267.0648l.0412.0255c.4833.217.9953.3632 1.5204.4338.1992.0382.4004.0648.6027.0795 0 0 .2444.0216.2022.0206a9.6487 9.6487 0 0 1-1.701-.2218 4.3198 4.3198 0 0 1-1.276-.5398 1.3917 1.3917 0 0 0-.7381-.2316c-.1698-.0118-5.6486-.2277-5.6604-.2277a5.3434 5.3434 0 0 1-1.0434-.1404L0 12.1258c0 .0147.0383.055.0707.0844.1688.1502.8097.4613 1.1837.5526.6488.157 4.6445.6655 5.3542.745l.3926.0442c1.0728.1158 2.4214.264 3.1085.3337a.8442.8442 0 0 0 .3926-.0216A4.1449 4.1449 0 0 1 12 13.606a4.3124 4.3124 0 0 1 1.5027.2581.8354.8354 0 0 0 .3877.0216c.6871-.0687 2.0396-.2189 3.1035-.3367l.3975-.0442c.7096-.0785 4.7044-.5673 5.3532-.7244.3749-.0903 1.0149-.4024 1.1847-.5526.0303-.0274.067-.0653.0697-.0812l.001-.0001c0-.0004-.0004-.0007-.0004-.001zm-12.2646.9952c-.795 0-1.5812-.0108-1.8099-.0677-.5447-.1354-.7989-.3838-.8421-.4593-.0432-.0756-.0324-.0746.0353-.0746h5.7595c.0677 0 .0726.0069.0344.0746-.0383.0677-.2945.3239-.8412.4593-.2287.0569-1.0149.0658-1.8099.0677h-.5261zm12.1884-.9707a5.345 5.345 0 0 1-1.0443.1413c-.0118 0-5.4965.1963-5.6614.21a1.3917 1.3917 0 0 0-.7381.2316 4.3198 4.3198 0 0 1-1.276.5398 9.6487 9.6487 0 0 1-1.701.2218c-.0422 0 .2022-.0206.2022-.0206a5.1874 5.1874 0 0 0 .6017-.0795 5.5189 5.5189 0 0 0 1.5213-.4338l.0471-.0255c.2415 0 .2277-.0648.2277-.0648l-.2945.0088c-.2179.0059-.4417.0118-.4976.0118-.0098-.0373-.5114-.0677-.5114-.0677h1.2858a5.3585 5.3585 0 0 0 .2709-.1678c.263 0 .2454-.0726.2454-.0726-.2827.0069-.8088.0137-.902.0108-.0088-.0373-.5693-.0726-.5693-.0726h1.4458a1.9327 1.9327 0 0 1 .7597-.1335l5.5534-.1139a6.3607 6.3607 0 0 0 1.0198-.1247l.0684-.0169-.0536.018zm-11.9627.532h.0903l-.1747.1247v.0991h-.1325v-.0972l-.1884-.1266h.1541l.1286.0805.1226-.0805zm.8088.1826h.3023v.0412h-.4338v-.2248h.1315v.1836zm.5408 0h.3131v.0412h-.4427v-.2248h.4378v.0412h-.3082v.051h.3023v.0412h-.3023v.0502zm-2.5225-.1826h.1325v.2238h-.1354v-.0913h-.2778v.0913h-.1325v-.2238h.1325v.0903h.2778l.0029-.0903zm.5978.1256l.1698.0982h-.1492s-.1364-.0972-.1678-.1217c.1345.0049.157-.0098.157-.0324s-.106-.0353-.2267-.0285v.1826h-.1404v-.2228h.3053c.1502 0 .1963.0314.1963.0628 0 .0285-.055.054-.1443.0618zm2.7148-.0559c0-.0226-.106-.0353-.2267-.0285v.1845h-.1394v-.2228h.3013c.1502 0 .1963.0344.1963.0628 0 .0285-.055.054-.1443.0599l.1698.0982h-.1492s-.1364-.0972-.1678-.1217c.1335.0049.16-.0098.16-.0324zm-1.5576.0873c0 .0569-.1227.0756-.2513.0756a1.6114 1.6114 0 0 1-.2071-.0137l.0137-.0481a.9392.9392 0 0 0 .1894.0137c.108 0 .1148-.0128.1148-.0265 0-.0137-.0304-.0226-.0785-.0226l-.0982-.0118c-.0952-.0118-.1345-.0157-.1345-.0726s.1237-.0667.2032-.0667a1.814 1.814 0 0 1 .2081.0177l-.0108.0432a1.1384 1.1384 0 0 0-.1639-.0137c-.0844 0-.1031.0049-.1031.0196s.0275.0236.0697.0236l.1139.0079c.0894.0136.1326.0352.1346.0744zM9.875 12.81c0 .052.1266.0736.211.0736s.1639-.0088.1826-.0088l-.0137.0461c-.0236.002-.106.0108-.1963.0108-.1678 0-.318-.0402-.318-.1217s.1502-.1217.318-.1217c.0982 0 .1757.0098.1963.0098l.0137.0471a1.9641 1.9641 0 0 0-.1826-.0098c-.0883 0-.211.0225-.211.0746zm.9972-2.1996l-.5497-.4976h.3651l.2091.1767.2287.1963.0412.0373.0412-.0363.422-.371h.1423c-.1777.1698-.5094.4908-.5094.4908l-.0196.0186v.4319h-.3494v-.4281l-.0215-.0186zm5.3768.4466h-1.4732v-.9452h.3259v.8284h1.1474v.1168zm2.1858-.0059H16.938v-.9374h1.4782v.1168h-1.1631v.2915h1.1435v.1207h-1.1435v.2925h1.1817v.1159zm-12.4142.002h-.3327v-.9432h.3327v.4172h.9148V10.11h.3308v.9432h-.3308V10.64h-.9148v.4131zm2.5441-.003H8.229v-.9452h.8834c.168-.0107.3362.0186.4908.0854a.1964.1964 0 0 1 .1188.1678c-.001.108-.0805.214-.3612.2444l-.0805.0088.0618.0491c.0893.0726.3121.2945.4162.3926l.0097.003h-.3847c-.0569-.0628-.373-.3494-.5104-.4908a2.1988 2.1988 0 0 0 .3926-.0481.1433.1433 0 0 0 .0982-.1315.1152.1152 0 0 0-.052-.0913c-.0805-.0677-.265-.0677-.4809-.0677h-.266v.8235zm4.9056-.2424c0-.0569-.0491-.0834-.0982-.0982a1.2952 1.2952 0 0 0-.2032-.0363c-.1845-.0236-.2787-.0373-.3435-.0481a.9384.9384 0 0 1-.3406-.0982.1872.1872 0 0 1-.0932-.1727c-.001-.0991.0844-.162.2228-.2032.146-.0362.2962-.053.4466-.0501.2342.0027.468.0208.6998.054l-.0226.1139a3.124 3.124 0 0 0-.5408-.0501 1.2286 1.2286 0 0 0-.2945.0236c-.0609.0167-.0982.054-.0982.0982a.1091.1091 0 0 0 .0883.0982c.06.017.1214.0282.1835.0334.1031.0098.2483.0304.3867.0491a.8507.8507 0 0 1 .3308.0982.1906.1906 0 0 1 .0982.1698c.001.0962-.0864.1698-.2444.2208a2.0935 2.0935 0 0 1-.5889.0707l.001-.0069a4.8331 4.8331 0 0 1-.6743-.053l.0294-.1345c.2054.0451.415.0678.6252.0677a.8745.8745 0 0 0 .3514-.0481.112.112 0 0 0 .0787-.0982zm-10.2872-.2209c0-.158.1031-.2709.2778-.3543a1.622 1.622 0 0 1 .6782-.1276c.1911.0011.3819.0146.5712.0402l.0265.1286a5.1308 5.1308 0 0 0-.5212-.0353 1.2396 1.2396 0 0 0-.4397.0766c-.1325.052-.2434.1374-.2434.2689.001.1315.1109.2169.2434.2689.1407.0519.2897.0778.4397.0766a5.1308 5.1308 0 0 0 .5212-.0353l-.0344.1315a4.4382 4.4382 0 0 1-.5712.0402 1.6324 1.6324 0 0 1-.6704-.1247c-.1796-.0834-.2777-.2002-.2777-.3543zm16.4207.4731h-.3318v-.9462h.8834a1.0791 1.0791 0 0 1 .4908.0864.1964.1964 0 0 1 .1188.1669c-.001.1089-.0805.215-.3612.2454l-.0805.0079.0618.0491c.0893.0726.3121.2895.4162.3926v.001h-.3789c-.0569-.0628-.374-.3494-.5104-.4908a2.1177 2.1177 0 0 0 .3926-.0491.1424.1424 0 0 0 .0982-.1305.1152.1152 0 0 0-.052-.0913c-.0815-.0687-.265-.0687-.4809-.0687h-.266v.8273z",source:"https://www.stellantis.com/en/brands/chrysler",hex:"000000",guidelines:void 0,license:void 0},siBinance={title:"Binance",slug:"binance",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Binance</title><path d="'+this.path+'"/></svg>'},path:"M16.624 13.9202l2.7175 2.7154-7.353 7.353-7.353-7.352 2.7175-2.7164 4.6355 4.6595 4.6356-4.6595zm4.6366-4.6366L24 12l-2.7154 2.7164L18.5682 12l2.6924-2.7164zm-9.272.001l2.7163 2.6914-2.7164 2.7174v-.001L9.2721 12l2.7164-2.7154zm-9.2722-.001L5.4088 12l-2.6914 2.6924L0 12l2.7164-2.7164zM11.9885.0115l7.353 7.329-2.7174 2.7154-4.6356-4.6356-4.6355 4.6595-2.7174-2.7154 7.353-7.353z",source:"https://binance.com/",hex:"F0B90B",guidelines:void 0,license:void 0},siCircle={title:"Circle",slug:"circle",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Circle</title><path d="'+this.path+'"/></svg>'},path:"M20.788 3.832c-.101-.105-.197-.213-.301-.317-.103-.103-.211-.202-.32-.302A11.903 11.903 0 0 0 12 0a11.926 11.926 0 0 0-8.486 3.514C-1.062 8.09-1.16 15.47 3.213 20.168c.099.108.197.214.3.32.104.103.21.2.317.3A11.92 11.92 0 0 0 12 24c3.206 0 6.22-1.247 8.487-3.512 4.576-4.576 4.673-11.956.301-16.656zm-16.655.301A11.057 11.057 0 0 1 12 .874c2.825 0 5.49 1.048 7.55 2.958l-1.001 1.002A9.646 9.646 0 0 0 12 2.292a9.644 9.644 0 0 0-6.865 2.844A9.644 9.644 0 0 0 2.292 12c0 2.448.9 4.753 2.542 6.549L3.831 19.55C-.201 15.191-.101 8.367 4.133 4.133zm13.798 1.318v.002l-1.015 1.014A7.346 7.346 0 0 0 12 4.589 7.357 7.357 0 0 0 6.761 6.76 7.362 7.362 0 0 0 4.589 12a7.34 7.34 0 0 0 1.877 4.913l-1.014 1.016A8.77 8.77 0 0 1 3.167 12a8.77 8.77 0 0 1 2.588-6.245A8.771 8.771 0 0 1 12 3.167c2.213 0 4.301.809 5.931 2.284zM18.537 12c0 1.745-.681 3.387-1.916 4.622S13.746 18.538 12 18.538a6.491 6.491 0 0 1-4.296-1.621l-.001-.004c-.11-.094-.22-.188-.324-.291a6.027 6.027 0 0 1-.293-.326A6.47 6.47 0 0 1 5.466 12c0-1.746.679-3.387 1.914-4.621A6.488 6.488 0 0 1 12 5.465c1.599 0 3.105.576 4.295 1.62.111.096.224.19.326.295.104.104.2.214.295.324A6.482 6.482 0 0 1 18.537 12zM7.084 17.534h.001A7.349 7.349 0 0 0 12 19.413a7.35 7.35 0 0 0 5.239-2.174A7.354 7.354 0 0 0 19.412 12a7.364 7.364 0 0 0-1.876-4.916l1.013-1.012A8.777 8.777 0 0 1 20.834 12a8.765 8.765 0 0 1-2.589 6.246A8.764 8.764 0 0 1 12 20.834a8.782 8.782 0 0 1-5.93-2.285l1.014-1.015zm12.783 2.333A11.046 11.046 0 0 1 12 23.125a11.042 11.042 0 0 1-7.551-2.957l1.004-1.001a9.64 9.64 0 0 0 6.549 2.542 9.639 9.639 0 0 0 6.865-2.846A9.642 9.642 0 0 0 21.71 12a9.64 9.64 0 0 0-2.543-6.548l1.001-1.002c4.031 4.359 3.935 11.182-.301 15.417z",source:"https://www.circle.com/",hex:"8669AE",guidelines:void 0,license:void 0},siBitcoinsv={title:"Bitcoin SV",slug:"bitcoinsv",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bitcoin SV</title><path d="'+this.path+'"/></svg>'},path:"M14.648 14.423l.003-.004a1.34 1.34 0 0 1-.498.659c-.269.189-.647.338-1.188.364l-1.99.004v-2.93c.288.008 1.565-.013 2.119.015.722.035 1.171.321 1.41.668.262.351.293.82.144 1.224zm-2.129-3.261c.503-.024.852-.162 1.101-.336.214-.146.375-.367.46-.611.134-.375.107-.81-.136-1.135-.223-.319-.638-.584-1.306-.616-.495-.026-1.413-.003-1.664-.01v2.709c.025.004 1.539-.001 1.545-.001zM24 12c0 6.627-5.373 12-12 12S0 18.627 0 12 5.373 0 12 0s12 5.373 12 12zm-6.65 2.142c.022-1.477-1.24-2.332-1.908-2.572.715-.491 1.206-1.043 1.206-2.085 0-1.655-1.646-2.43-2.647-2.529-.082-.009-.31-.013-.31-.013V5.361h-1.633l.004 1.583H10.97V5.367H9.31v1.569c-.292.007-2.049.006-2.049.006v1.401h.571c.601.016.822.362.798.677v6.041a.408.408 0 0 1-.371.391c-.249.011-.621 0-.621 0l-.32 1.588h1.996v1.6h1.661v-1.591h1.091v1.594h1.624v-1.588c1.899.05 3.643-1.071 3.66-2.913z",source:"https://bitcoinsv.com/",hex:"EAB300",guidelines:void 0,license:void 0},siCircleci={title:"CircleCI",slug:"circleci",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>CircleCI</title><path d="'+this.path+'"/></svg>'},path:"M8.963 12c0-1.584 1.284-2.855 2.855-2.855 1.572 0 2.856 1.284 2.856 2.855 0 1.572-1.284 2.856-2.856 2.856-1.57 0-2.855-1.284-2.855-2.856zm2.855-12C6.215 0 1.522 3.84.19 9.025c-.01.036-.01.07-.01.12 0 .313.252.576.575.576H5.59c.23 0 .433-.13.517-.333.997-2.16 3.18-3.672 5.712-3.672 3.466 0 6.286 2.82 6.286 6.287 0 3.47-2.82 6.29-6.29 6.29-2.53 0-4.714-1.5-5.71-3.673-.097-.19-.29-.336-.517-.336H.755c-.312 0-.575.253-.575.576 0 .037.014.072.014.12C1.514 20.16 6.214 24 11.818 24c6.624 0 12-5.375 12-12 0-6.623-5.376-12-12-12z",source:"https://circleci.com/press",hex:"343434",guidelines:void 0,license:void 0},siArangodb={title:"ArangoDB",slug:"arangodb",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>ArangoDB</title><path d="'+this.path+'"/></svg>'},path:"M13.885 3.75c-.32.007-.536.032-.61.041-.878.106-2.81.49-4.466 2.088-.921.89-1.501 2.153-1.783 2.826.251-.072.502-.13.75-.164.94-.131 1.8-.013 2.431.219.89-.158 1.474-.228 1.782-.227.953.004 2.003-.008 2.775.65.208.178.82.542.725 1.515-.084.867-.474 1.933-1.428 2.982-.574.632-1.686 1.444-3.059 2.15-.995.511-2.412 1.313-4.469 1.426-.331.019-.708.041-1.105.04-1.012-.004-2.48-.138-3.545-1.249-.221-.231-1.31-1.458-1.002-2.93.248-1.185 1.229-1.798 2.016-2.292.447-.281 1.05-.512 1.861-.754.585-.63 1.274-1.017 1.975-1.262-1.394.312-2.784.652-3.788 1.15-1.15.557-2.236 1.082-2.707 2.237-.287.707-.263 1.42-.191 1.892 0 0 .31 3.096 2.441 4.674 1.784 1.323 4.413 1.812 6.374 1.276 1.543-.294 3.015-1.738 4.24-3.004l.006.004c.392.186 1.295.584 2.027.963 1.692.873 2.864 1.054 3.47 1.16 1.317.23 3.368-.292 4.341-1.383.932-1.045 1.203-2.454.98-3.711-.067-.386-.066-1.073-.349-2.016-.222-.737-.333-1.104-.494-1.496-.31-.758-.705-1.373-1.295-2.137-1.382-1.784-2.072-2.679-3.2-3.39-1.834-1.16-3.74-1.297-4.703-1.278zm.713 1.135c.814.033 2.014.046 3.051.725.603.397 1.182.68 2.338 2.21 1.56 2.069 1.711 2.301 2.293 3.405.443.84.822 2.55.65 3.885-.05.387-.09 1.209-.95 2.021-1.157 1.093-3.13.97-3.337.946-.629-.077-1.113-.371-2.582-.934l-1.816-.744c-.121-.048-.245-.115-.37-.18.417-.499 1.182-1.488 1.497-2.111.231-.466.385-.985.488-1.37.078-.308.195-.765.244-1.204.025-.229.045-.463.049-.663.004-.207-.001-.244-.01-.402a4.156 4.156 0 0 0-.201-.926 2.408 2.408 0 0 0-.457-.748 2.623 2.623 0 0 0-.51-.367c-.208-.113-.474-.216-.646-.283-.32-.125-.585-.196-1.067-.256a5.006 5.006 0 0 0-.451-.016c-.547.005-1.274.08-2.338.237-.68.095-1.357.208-2.024.334l.002-.006c.69-1.402 1.67-2.392 3.35-2.983 1.075-.377 2.198-.595 2.797-.57zm.272 2.566a2.08 2.08 0 0 0-.721.112c.378.093.743.284 1.064.426.255.138.49.313.633.462.249.261.46.616.569.93.099.29.206.71.226 1.06.009.15.016.22.012.438a8.02 8.02 0 0 1-.053.711c-.054.488-.178.965-.256 1.272a7.829 7.829 0 0 1-.383 1.144c.239.004.47-.002.602-.025.937-.164 1.561-1.126 1.752-1.904.268-1.102-.285-2.02-.654-2.633-.349-.577-.963-1.384-2.073-1.834a2.09 2.09 0 0 0-.718-.159zM7.844 9.035a4.64 4.64 0 0 0-1.511.457c-.53.254-.99.648-1.573 1.335-.65.815-1.112 2.387-.76 2.81.18.218.275.24.34.283.901.436 1.724 1.035 3.068 1.114h1.118c.234.002.545-.05.632-.059 1.547-.254 3.605-1.349 3.526-2.88-.03-.573-.683-1.512-1.127-1.935-.431-.41-1.147-.788-1.454-.917-.266-.131-.576-.167-.888-.213-.47-.078-.972-.048-1.371.005z",source:"https://www.arangodb.com",hex:"DDE072",guidelines:"https://www.arangodb.com/resources/logos",license:void 0},siArchlinux={title:"Arch Linux",slug:"archlinux",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Arch Linux</title><path d="'+this.path+'"/></svg>'},path:"M11.39.605C10.376 3.092 9.764 4.72 8.635 7.132c.693.734 1.543 1.589 2.923 2.554-1.484-.61-2.496-1.224-3.252-1.86C6.86 10.842 4.596 15.138 0 23.395c3.612-2.085 6.412-3.37 9.021-3.862a6.61 6.61 0 01-.171-1.547l.003-.115c.058-2.315 1.261-4.095 2.687-3.973 1.426.12 2.534 2.096 2.478 4.409a6.52 6.52 0 01-.146 1.243c2.58.505 5.352 1.787 8.914 3.844-.702-1.293-1.33-2.459-1.929-3.57-.943-.73-1.926-1.682-3.933-2.713 1.38.359 2.367.772 3.137 1.234-6.09-11.334-6.582-12.84-8.67-17.74zM22.898 21.36v-.623h-.234v-.084h.562v.084h-.234v.623h.331v-.707h.142l.167.5.034.107a2.26 2.26 0 01.038-.114l.17-.493H24v.707h-.091v-.593l-.206.593h-.084l-.205-.602v.602h-.091",source:"https://www.archlinux.org/art/",hex:"1793D1",guidelines:"https://wiki.archlinux.org/index.php/DeveloperWiki:TrademarkPolicy#Logo_Usage_Guidelines",license:void 0},siArchicad={title:"Archicad",slug:"archicad",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Archicad</title><path d="'+this.path+'"/></svg>'},path:"M22.5896 16.3222c-.779 0-1.4104-.6315-1.4104-1.4105 0-.779.6314-1.4104 1.4104-1.4104S24 14.1328 24 14.9117c0 .779-.6315 1.4105-1.4104 1.4105zM.1507 19.8272c-.35.6959-.0696 1.5438.6263 1.8938.6959.35 1.5438.0695 1.8938-.6263 0 0 7.8494-16.0114 14.2545-16.1487 4.2299-.0907 4.2313 5.642 4.2313 5.642 0 .779.6314 1.4104 1.4104 1.4104s1.4104-.6314 1.4104-1.4104c0 0 .0566-8.3813-7.0196-8.4569C8.7634 1.8711.1507 19.8272.1507 19.8272z",source:"https://graphisoft.com/contact-us/press-relations#/documents/archicad-logo-98604",hex:"2D50A5",guidelines:void 0,license:void 0},siBitrise={title:"Bitrise",slug:"bitrise",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bitrise</title><path d="'+this.path+'"/></svg>'},path:"M23.5154 13.4558c-.2744-1.8854-.692-3.7828-.9904-5.0477-.358-1.5035-1.6349-2.5775-3.1742-2.673-1.5155-.0955-4.0215-.2028-7.3627-.2028-3.3413 0-5.8472.1074-7.3627.2028-1.5394.0955-2.8163 1.1695-3.1743 2.673-.2983 1.265-.716 3.1623-.9904 5.0477-.191 1.2769-.3341 2.7685-.4535 4.463-.0596.9427.2506 1.8496.8831 2.5537.6324.704 1.4916 1.1217 2.4463 1.1575 2.0763.0955 5.2625.2148 8.6634.2148 3.401 0 6.587-.1193 8.6634-.2148.9427-.0477 1.8139-.4535 2.4463-1.1575.6325-.704.9427-1.611.883-2.5537-.1312-1.6945-.2863-3.198-.4773-4.463zm-1.6467 5.9188c-.3342.37-.7876.5848-1.2888.6086-2.0644.0955-5.2148.2148-8.5918.2148-3.3771 0-6.5274-.1193-8.5919-.2148-.5011-.0239-.9546-.2386-1.2887-.6086-.3342-.3699-.5012-.8472-.4654-1.3484.1074-1.6468.2506-3.1026.4415-4.3317.2625-1.8258.6683-3.6754.9666-4.9045.191-.7995.8592-1.3604 1.6826-1.42C6.2244 7.2745 8.6945 7.167 12 7.167c3.2935 0 5.7756.1074 7.2673.2029.8114.0477 1.4916.6205 1.6825 1.42.2864 1.2291.6921 3.0787.9666 4.9045.179 1.2291.3222 2.685.4415 4.3317 0 .5012-.167.9785-.4892 1.3484zM11.988 4.1958c.5608 0 1.0262-.4535 1.0262-1.0143 0-.561-.4534-1.0263-1.0262-1.0263-.5609 0-1.0263.4535-1.0263 1.0263 0 .5489.4654 1.0143 1.0263 1.0143zm5.9665 7.84c-.9069 0-1.6468.7399-1.6468 1.6468h3.2936c0-.907-.728-1.6468-1.6468-1.6468zm-11.933 0c-.907 0-1.6468.7399-1.6468 1.6468h3.2935c0-.907-.728-1.6468-1.6468-1.6468zm5.9665 5.9665c1.4677 0 2.661-1.1933 2.661-2.661h-5.334c0 1.4558 1.1933 2.661 2.673 2.661z",source:"https://www.bitrise.io/presskit",hex:"683D87",guidelines:void 0,license:void 0},siCinema4d={title:"Cinema 4D",slug:"cinema4d",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Cinema 4D</title><path d="'+this.path+'"/></svg>'},path:"M12.052 0C5.394-.007-.003 5.412 0 11.976.003 18.654 5.475 23.981 11.978 24c6.535.02 12.057-5.306 12.022-11.998-.009-1.665-.53-5.371-1.84-5.276-1.98.145-2.159 4.12-2.377 5.407-.417 2.46-1.346 5.08-2.953 6.99-1.88 2.359-4.697 3.634-7.662 3.158-3.55-.564-5.893-3.278-6.68-5.201-.753-1.723-1.035-4.162-.07-6.324 1.16-2.766 3.734-4.632 6.28-5.584 2.006-.827 4.103-1.151 5.357-1.375 2.516-.5 2.855-1.463 2.814-2.149-.015-.252-.256-.724-.785-.943C15.03.269 13.268.001 12.052 0zm5.098 1.342c.139.398.088.85-.148 1.256-.325.56-.972 1.05-1.897 1.29-1.636.428-2.976.554-4.34.96-1.312.39-3.397 1.018-5.316 2.552-.268.842-.341 1.892-.369 2.662.15 5.014 4.557 8.884 9.17 8.682.853-.037 1.921-.261 2.912-.68a13.56 13.56 0 0 0 1.387-2.683l.002-.002v-.002c.424-1.03.606-1.836.8-2.793.32-1.565.202-2.88 1.012-4.758.251-.582.71-1.113 1.258-1.346.25-.105.522-.133.79-.072-.89-2.471-3.115-4.326-5.26-5.066z",source:"https://www.maxon.net/en/about-maxon/branding",hex:"011A6A",guidelines:void 0,license:void 0},siChupachups={title:"Chupa Chups",slug:"chupachups",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Chupa Chups</title><path d="'+this.path+'"/></svg>'},path:"M15.2056.0007c-1.1953-.0181-2.3567.4498-3.206 1.2882C10.7647.0694 8.8692-.366 7.1692.338c-1.7001.7042-2.7325 2.3525-2.7435 4.088-1.7358.0114-3.3842 1.0438-4.0883 2.7435-.7042 1.6998-.2684 3.5954.9512 4.831C.069 13.2354-.3665 15.131.3373 16.831c.7041 1.6998 2.3525 2.7319 4.0886 2.743.0107 1.736 1.043 3.3846 2.7432 4.0886 1.7.7042 3.5958.2684 4.8309-.9513 1.2349 1.2197 3.1304 1.6551 4.8306.951 1.6997-.704 2.7318-2.3523 2.7428-4.0882 1.736-.011 3.3848-1.0433 4.0888-2.7431.7041-1.7002.2683-3.5955-.9513-4.8314 1.2196-1.2352 1.6554-3.1306.9513-4.8304-.704-1.6997-2.3528-2.7322-4.0888-2.7432-.0107-1.7356-1.0431-3.384-2.7428-4.0884a4.416 4.416 0 0 0-1.625-.3369zM8.8546.623C10.09.6207 11.2772 1.222 12 2.2524 13.0059.8188 14.9096.2157 16.5923.913c1.683.6967 2.6026 2.4695 2.3 4.1948 1.725-.3027 3.498.6174 4.1947 2.2998.6968 1.6826.0938 3.5866-1.3395 4.5924 1.4333 1.0063 2.0363 2.91 1.3395 4.5928-.697 1.6822-2.4694 2.6023-4.1943 2.2998.3022 1.725-.6177 3.4982-2.3001 4.1949-1.683.6967-3.587.0937-4.593-1.3396-1.0057 1.4333-2.9097 2.0363-4.5922 1.3396-1.6826-.6967-2.6023-2.4695-2.3-4.1944-1.7254.3024-3.498-.6178-4.1949-2.3-.697-1.683-.0944-3.587 1.3396-4.5931C.8184 10.9942.2155 9.0905.9125 7.4078c.6968-1.6826 2.4698-2.6027 4.1948-2.3-.3028-1.7253.6175-3.498 2.3-4.1948a3.7897 3.7897 0 0 1 1.4475-.29zm.2617.4925a3.793 3.793 0 0 0-1.5049.29c-1.5743.6522-2.4823 2.246-2.3451 3.8613-1.6153-.1372-3.209.771-3.8614 2.3448C.753 9.1861 1.2377 10.9553 2.4772 12 1.238 13.0453.753 14.8143 1.405 16.3889c.6525 1.5738 2.2464 2.4821 3.8614 2.345-.1372 1.6154.7708 3.209 2.3451 3.8612 1.5743.652 3.3433.1672 4.3883-1.0722 1.045 1.2391 2.814 1.7242 4.3885 1.0722 1.574-.6524 2.4824-2.2462 2.345-3.8612 1.6154.1369 3.209-.7715 3.861-2.3455.6522-1.5742.1677-3.3431-1.0718-4.3884 1.2392-1.0453 1.724-2.8142 1.0719-4.3885-.6521-1.5742-2.246-2.4824-3.8613-2.3452.1374-1.6151-.7708-3.2087-2.345-3.8608-1.5743-.652-3.3433-.1671-4.3883 1.072-.7186-.852-1.7792-1.3476-2.8834-1.362zm.1288.575a3.8514 3.8514 0 0 1 2.7546 1.1035C13.062 1.7483 14.69 1.3756 16.15 1.9804c1.4597.6047 2.3476 2.0192 2.3592 3.5096 1.491.0116 2.9055.8994 3.5102 2.3593.6049 1.46.232 3.0882-.8135 4.1507 1.0456 1.0624 1.4184 2.6906.8135 4.1505-.605 1.46-2.0192 2.3475-3.51 2.3593-.0115 1.4908-.8993 2.9055-2.3594 3.5104-1.46.6045-3.0879.2318-4.15-.8138-1.0624 1.0458-2.6905 1.4183-4.1503.8138-1.46-.6049-2.348-2.0196-2.3596-3.51-1.4906-.0119-2.9053-.8998-3.5103-2.3597-.6045-1.4596-.2319-3.0878.8137-4.1502-1.0458-1.0624-1.4182-2.6906-.8134-4.151.6046-1.4599 2.0191-2.3474 3.5098-2.359.0113-1.4906.8989-2.905 2.3595-3.5099a3.7971 3.7971 0 0 1 1.3957-.29zM6.821 5.9463c-.4963.0028-1.0034.2088-1.3915.4873-.9826.7051-1.552 1.765-1.5075 2.9352.0236.6227.3794 1.2746.9944 1.5076.7724.2935 1.396-.0028 2.0429-.4427l-.1765.43 1.0606.0006 1.0627-2.3575c.1-.2227.5938-.1762.481.0881l-.6535 1.532c-.1047.245-.0169.5406.2162.6934.4885.32 1.0588.004 1.48-.2484.052.1283.1102.2726.2443.3409.3872.1963.9427.0092 1.2606-.2028.023-.0153.1375.128.2673.2028.4295.2472.9943.0295 1.351-.219-.2173.4977-.4285 1.2961-.9464 1.5181-.0888.0381-.2882-.0427-.2645.096.1926.225.5255.2585.826.2048.9148-.1628 1.0627-1.179 1.4556-1.8244.1085.116.2114.2512.381.2806.9732.1672 1.5356-.83 2.2055-1.3632-.1075.3432-.2886.8839.1043 1.2508.3803.3553 1.0707.1246 1.4394-.1523l.1442.2286c.115.182.3993.1592.6054.1123.2356-.0535.6068-.2073.6056-.4052-.287.0463-.4815-.1071-.3609-.3968.3755-.9027 1.1694-2.7194 1.1694-2.7194h-1.044l-.1254.3013c-.068-.1485-.2174-.2837-.369-.3127-1.2422-.2401-1.6844 1.1902-2.3773 1.6315.1205-.437.3887-1.1607-.0443-1.5154-.3217-.263-.7507-.0466-1.0827.0845l.0673-.1892h-.9904l-1.0941 2.479c-.0798.1809-.2666.2795-.4449.3046-.0793.011-.1597-.0274-.2085-.0965-.0595-.0833-.058-.1944-.0198-.2805l1.0612-2.4066h-1.0673l-.9406 2.15c-.006.0144-.1833.5038-.3687.5694-.0925.0327-.213.0081-.2644-.0883-.0405-.076-.0235-.1815.0078-.2526l1.0517-2.3785H11.62l-1.086 2.4626c-.0859.1942-.526.4166-.6536.1204-.0454-.1052-.022-.2245.0202-.3206l.4811-1.099c.1483-.338.5155-.8832.068-1.1466-.463-.2726-.921.068-1.2174.2594l.7523-1.7509H8.9478L7.3899 9.48c-.204.449-.7536.6712-1.2146.751-.3688.064-.7448-.0152-.9382-.3209-.4688-.7416-.0705-1.658.2965-2.3135.2716-.4855.7437-1.1352 1.3715-1.0868.1079.0083.234.0567.2766.1805.143.4128-.3268.6998-.6254.8702.0564.3558.6835.3803.9384.2443.3277-.1743.539-.5163.5653-.87.0217-.2922-.1296-.5774-.385-.7458-.262-.173-.556-.2444-.8538-.2427zm12.4299 2.294c.1901.0033.2381.185.1688.3427l-.702 1.5919c-.0606.1378-.248.2035-.409.1324-.0478-.021-.104-.076-.1043-.1324-.0033-.4853.2456-.923.4573-1.3431.1142-.2276.2587-.5599.5493-.5897a.3343.3343 0 0 1 .0399-.0017zm-3.335.0072c.0899.003.1665.0445.1795.127.0711.4493-.5303 1.6964-.9302 1.9126-.1004.0543-.2483.0044-.2728-.1041-.022-.0974.0306-.2071.0722-.3008l.6457-1.4596c.0525-.1189.19-.1789.3056-.175zm-6.303 3.1817l-1.124.0045-1.7048 3.8193c-.5372.5693-1.2974 1.1229-2.0564.8124-.3688-.1509-.5473-.5486-.5574-.9263-.0177-.6733.1488-1.289.5014-1.8086.342-.504.7937-1.1283 1.4474-1.1951.1721-.0175.3326.075.3969.2289.0803.192-.0153.3892-.1402.5211-.144.153-.337.246-.5133.2806.0906.4412.734.4207 1.0544.2772.2442-.11.4806-.35.5495-.6057.0836-.3098.0383-.6695-.1642-.9186-.3791-.465-1.0279-.5176-1.588-.3887-1.2165.28-2.3287 1.3853-2.6427 2.5743-.2395.9087-.1822 2.0852.682 2.6142.9996.6125 1.9043-.0058 2.6045-.5139l-.2575.5786 1.1494.003 1.239-2.802c.1231-.2785.6937-.234.5376.1201l-.6818 1.5438c-.087.1972-.1522.3845-.1522.5976 0 .229.0833.471.3123.5694.5578.2385 1.11-.1131 1.527-.47.0537.273.205.4565.494.5179.4516.0959.8182-.1604 1.1711-.3686.068.128.109.2812.2566.3567.4342.2218.9632-.0281 1.3402-.2363l-.3943.863c-.9815-.2082-2.0948-.2582-3.0592.0747-.532.184-1.0934.691-1.1347 1.3075-.031.4587.1895.8673.5693 1.099.7596.462 1.8348.4653 2.6425.0958.4793-.2194.8899-.577 1.2388-1.0065 1.5761.333 3.4885.589 4.6032-.8216.0211-.0271.173-.2487.2006-.4454-.2086.1366-.44.2202-.6818.2646-.5984.111-1.2287.0944-1.847.0425-.4098-.034-1.1304-.1828-1.4892-.3505l.5978-1.3038c.0921.2085.2696.3657.4853.409.6628.133 1.1861-.2979 1.6075-.758l1.9608-2.1407c.0653-.0715.1707-.203.2925-.1808.0367.0068.0548.05.0407.0883-.1106.295-.2242.5895-.3133.8984-.1354.4696-.0843 1.0261-.3685 1.431-.0669.0952-.1804.1427-.2927.1486-.1164.006-.2264-.0519-.277-.1606-.0903-.1956.0397-.4238.1805-.557-.0705-.0591-.17-.0683-.2351-.0637-.1672.0122-.3155.1068-.4185.244-.0992.1324-.1362.3117-.1121.4928.0362.272.2962.4922.5496.5577.5403.1392 1.0957-.0172 1.5154-.377.7315-.6272.5-1.6633.425-2.494-.037-.4122.1765-.802.5495-.9744-.1026-.1256-.2454-.168-.3344-.1795-1.1026-.139-1.8218 1.2796-2.489 1.6753.0314-.1304.3402-1.281-.2078-1.6083-.387-.2303-.8384-.004-1.1552.2165.011-.0568.036-.2084.036-.2084h-1.0338l-1.332 3.0032c-.072.163-.2684.2052-.4286.2088-.0804.002-.1598-.0265-.1966-.1042-.0352-.0748-.0461-.1518-.0122-.2287l1.2861-2.8884h-1.137l-1.2755 2.8884c-.0517.1164-.1728.1762-.2928.1885-.0763.0076-.1602-.0484-.2086-.12-.0435-.0647-.0383-.1777-.008-.2488l1.1626-2.708h-1.1167l-1.2489 2.8523c-.0704.161-.241.2864-.4092.3288-.1044.0263-.2131.0007-.2725-.0845-.0609-.0873-.0417-.1994 0-.3044.29-.7285.682-1.4192.9264-2.1652.0646-.1982.035-.4453-.1405-.5693-.4426-.314-.966-.0667-1.3553.1882zm6.3363 2.3177c.0784.0056.1475.0595.1823.1211.0481.086.037.2212.0079.3127-.1865.5829-.4699 1.1878-.7859 1.6762-.1007.155-.529.2388-.529 0v-.1322l.8056-1.8085c.0496-.1115.1692-.155.285-.1685a.1868.1868 0 0 1 .034-.0008zm-5.3643 4.849c.1608.002.3222.0152.4782.0275.346.0275.6818.1045 1.0064.2007-.4502.7776-1.4392 1.2001-2.2655.7178-.3268-.1911-.3654-.6248.0082-.8061.238-.1154.5046-.1432.7727-.1399zm3.1186.7396a.8233.8233 0 0 0-.3883.0973c-.1232.0648-.2269.1618-.3094.2916-.0822.1294-.1239.2739-.1239.4323 0 .2272.0803.421.2409.5813.1603.1597.3539.24.5807.24.2253 0 .4186-.0806.5797-.2413.1606-.1608.241-.354.241-.58 0-.159-.0416-.3043-.1247-.4347-.0836-.1301-.1868-.2272-.311-.2906-.1238-.064-.2525-.096-.385-.096zm.0008.1611c.177 0 .3314.063.4632.1893.1314.1258.1972.2833.1972.4708 0 .1815-.0648.3374-.1945.4665-.129.1303-.2846.195-.4659.195-.1816 0-.337-.0644-.4658-.1936-.1292-.1287-.1935-.2852-.1935-.468 0-.1874.0658-.3449.1972-.4707.1315-.1263.2853-.1893.4621-.1893zm-.372.2284v.871h.177v-.3577h.0461c.0555 0 .0993.0152.1313.0445.0317.0296.0697.0867.1132.1721l.0727.1412h.219l-.1033-.1759c-.05-.0848-.0859-.1378-.1067-.1585a.2044.2044 0 0 0-.0777-.0467c.0702-.0104.1267-.0372.1703-.0805.043-.0429.0645-.097.0645-.1622 0-.0671-.0199-.1224-.0596-.1655-.04-.0431-.0837-.0674-.1315-.0736-.0473-.0057-.1607-.0082-.3383-.0082zm.177.1383h.0718c.0785 0 .1328.0015.1623.0052a.1292.1292 0 0 1 .076.0357.1032.1032 0 0 1 .0316.077.1088.1088 0 0 1-.0294.0771.1197.1197 0 0 1-.072.0367c-.0281.004-.0848.0062-.1685.0062h-.0718Z",source:"https://www.chupachups.co.uk/",hex:"CF103E",guidelines:void 0,license:void 0},siBitly={title:"Bitly",slug:"bitly",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bitly</title><path d="'+this.path+'"/></svg>'},path:"M13.055 21.26c-1.345.022-2.325-.41-2.386-1.585-.025-.44-.018-.91.002-1.192.137-1.716 1.333-2.95 2.53-3.19 1.482-.294 2.455.38 2.455 2.31 0 1.303-.36 3.618-2.59 3.657h-.016zM11.923 0C5.32 0 0 5.297 0 12.224c0 3.594 1.92 7.062 4.623 9.147.52.4 1.138.367 1.497.02.297-.285.272-.984-.285-1.475-2.16-1.886-3.652-4.76-3.652-7.635 0-5.15 4.58-9.49 9.74-9.49 6.28 0 9.636 5.102 9.636 9.43 0 2.65-1.29 5.84-3.626 7.874.015 0 .493-.942.493-2.784 0-3.13-1.976-4.836-4.28-4.836-1.663 0-2.667.598-3.34 1.152 0-1.272.045-3.652.045-3.652 0-1.572-.54-2.83-2.47-2.86-1.11-.015-1.932.493-2.44 1.647-.18.436-.12.916.254 1.125.3.18.81.046 1.046-.284.165-.21.254-.254.404-.24.24.03.257.405.257.66.014.193.193 2.903.088 9.865C7.98 21.798 9.493 24 13.1 24c1.56 0 2.756-.435 4.493-1.422C20.243 21.08 24 17.758 24 12.128 23.953 5.045 18.265 0 11.933 0",source:"https://bitly.com/pages/press",hex:"EE6123",guidelines:void 0,license:void 0},siBlackberry={title:"Blackberry",slug:"blackberry",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Blackberry</title><path d="'+this.path+'"/></svg>'},path:"M2.05 3.54L1.17 7.7H4.45C6.97 7.7 7.73 6.47 7.73 5.36C7.73 4.54 7.26 3.54 5.21 3.54H2.05M10.54 3.54L9.66 7.7H12.94C15.5 7.7 16.22 6.47 16.22 5.36C16.22 4.54 15.75 3.54 13.7 3.54H10.54M18.32 7.23L17.39 11.39H20.67C23.24 11.39 24 10.22 24 9.05C24 8.23 23.53 7.23 21.5 7.23H18.32M.88 9.8L0 13.96H3.28C5.85 13.96 6.56 12.73 6.56 11.62C6.56 10.8 6.09 9.8 4.04 9.8H.88M9.43 9.8L8.5 13.96H11.77C14.34 13.96 15.11 12.73 15.11 11.62C15.11 10.8 14.64 9.8 12.59 9.8H9.42M17.09 13.73L16.22 17.88H19.5C22 17.88 22.77 16.71 22.77 15.54C22.77 14.72 22.3 13.73 20.26 13.73H17.09M8.2 16.3L7.32 20.46H10.6C13.11 20.46 13.87 19.23 13.87 18.12C13.87 17.3 13.41 16.3 11.36 16.3H8.2Z",source:"https://www.blackberry.com/",hex:"000000",guidelines:void 0,license:void 0},siAseprite={title:"Aseprite",slug:"aseprite",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Aseprite</title><path d="'+this.path+'"/></svg>'},path:"M4.006 0v1.6h15.988V0zm15.988 1.6v1.6h1.6V1.6zm1.6 1.6v14.4h-1.6v1.6H4.006v-1.6h-1.6V3.2H.809v17.6h1.599v1.6h1.599V24h15.988v-1.6h1.6v-1.6h1.598V3.2zm-19.187 0h1.599V1.6h-1.6zm4.796 3.2v6.4h1.6V6.4zm7.995 0v6.4h1.599V6.4z",source:"https://www.aseprite.org/",hex:"7D929E",guidelines:void 0,license:void 0},siBandlab={title:"BandLab",slug:"bandlab",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>BandLab</title><path d="'+this.path+'"/></svg>'},path:"M10.87714 17.58857C12.84 17.58857 15.3 15.78 15.3 13.32c0-.72-.15429-1.43143-.45429-2.09143l-3.41142-8.34H17.16L15.65143 0H7.48286l4.68 11.56286C10.1657 12 8.34 13.56 8.34 15.36c0 1.30286.94286 2.22857 2.53714 2.22857.02737 0 0 0 5.1-11.50286H19.32L22.88571 12.24A8.82857 8.82857 0 0 1 24 16.26c0 4.5-3.54857 7.74-8.57143 7.74H8.57143C3.54 24 0 20.76 0 16.26c.04286-1.41429.42857-2.78571 1.11429-4.02857L4.67143 6.0857h3.34286l-4.17429 7.26a6.05143 6.05143 0 0 0-.82286 2.86286c0 2.86286 1.95429 4.90286 5.65715 4.90286h6.65142c3.68572 0 5.65715-2.04 5.65715-4.90286a6.05143 6.05143 0 0 0-.83143-2.86286l-4.17429-7.26H19.32h-3.34286",source:"https://blog.bandlab.com/press/",hex:"F12C18",guidelines:void 0,license:void 0},siBigbluebutton={title:"BigBlueButton",slug:"bigbluebutton",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>BigBlueButton</title><path d="'+this.path+'"/></svg>'},path:"M12 0A12 12 0 0 0 0 12a12 12 0 0 0 12 12 12 12 0 0 0 12-12A12 12 0 0 0 12 0zM6.838 4.516c.743 0 1.378.364 1.904 1.091.526.728.787 1.602.787 2.625v6.76c0 .539.27.809.809.809h4.174c.538 0 .808-.27.808-.809v-3.205c0-.52-.27-.788-.808-.807h-.807c-1.041-.036-1.923-.308-2.64-.816-.719-.507-1.077-1.133-1.077-1.877h4.524c.97 0 1.796.342 2.478 1.024a3.374 3.374 0 0 1 1.024 2.476v3.205c0 .97-.342 1.797-1.024 2.479-.682.682-1.509 1.021-2.478 1.021h-4.174c-.97 0-1.795-.339-2.477-1.021a3.376 3.376 0 0 1-1.023-2.479V4.516Z",source:"https://github.com/bigbluebutton/bbb-app-rooms/blob/0fcf9636a3ba683296326f46354265917c4f0ea4/app/assets/images/icon.svg",hex:"283274",guidelines:"https://bigbluebutton.org/trademark/",license:void 0},siBilibili={title:"Bilibili",slug:"bilibili",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bilibili</title><path d="'+this.path+'"/></svg>'},path:"M17.813 4.653h.854c1.51.054 2.769.578 3.773 1.574 1.004.995 1.524 2.249 1.56 3.76v7.36c-.036 1.51-.556 2.769-1.56 3.773s-2.262 1.524-3.773 1.56H5.333c-1.51-.036-2.769-.556-3.773-1.56S.036 18.858 0 17.347v-7.36c.036-1.511.556-2.765 1.56-3.76 1.004-.996 2.262-1.52 3.773-1.574h.774l-1.174-1.12a1.234 1.234 0 0 1-.373-.906c0-.356.124-.658.373-.907l.027-.027c.267-.249.573-.373.92-.373.347 0 .653.124.92.373L9.653 4.44c.071.071.134.142.187.213h4.267a.836.836 0 0 1 .16-.213l2.853-2.747c.267-.249.573-.373.92-.373.347 0 .662.151.929.4.267.249.391.551.391.907 0 .355-.124.657-.373.906zM5.333 7.24c-.746.018-1.373.276-1.88.773-.506.498-.769 1.13-.786 1.894v7.52c.017.764.28 1.395.786 1.893.507.498 1.134.756 1.88.773h13.334c.746-.017 1.373-.275 1.88-.773.506-.498.769-1.129.786-1.893v-7.52c-.017-.765-.28-1.396-.786-1.894-.507-.497-1.134-.755-1.88-.773zM8 11.107c.373 0 .684.124.933.373.25.249.383.569.4.96v1.173c-.017.391-.15.711-.4.96-.249.25-.56.374-.933.374s-.684-.125-.933-.374c-.25-.249-.383-.569-.4-.96V12.44c0-.373.129-.689.386-.947.258-.257.574-.386.947-.386zm8 0c.373 0 .684.124.933.373.25.249.383.569.4.96v1.173c-.017.391-.15.711-.4.96-.249.25-.56.374-.933.374s-.684-.125-.933-.374c-.25-.249-.383-.569-.4-.96V12.44c.017-.391.15-.711.4-.96.249-.249.56-.373.933-.373Z",source:"https://www.bilibili.com/",hex:"00A1D6",guidelines:void 0,license:void 0},siBaremetrics={title:"Baremetrics",slug:"baremetrics",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Baremetrics</title><path d="'+this.path+'"/></svg>'},path:"M22.109 7.951l1.485 2.464a3.507 3.507 0 010 3.275l-4.505 7.717a3.333 3.333 0 01-2.94 1.793H7.83a3.335 3.335 0 01-2.94-1.793l-1.555-2.632 6.139-5.695 4.447 2.578a1.093 1.093 0 001.456-.198zm-13.39.628L1.99 16.15.406 13.725a3.495 3.495 0 010-3.27L5.158 2.59A3.338 3.338 0 018.1.8h8.008c1.228 0 2.357.687 2.942 1.79l1.616 2.722-6.017 5.592-4.432-2.574a1.098 1.098 0 00-1.499.248z",source:"https://baremetrics.com/",hex:"6078FF",guidelines:void 0,license:void 0},siCanva={title:"Canva",slug:"canva",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Canva</title><path d="'+this.path+'"/></svg>'},path:"M12 0C5.373 0 0 5.373 0 12s5.373 12 12 12 12-5.373 12-12S18.627 0 12 0zM6.962 7.68c.754 0 1.337.549 1.405 1.2.069.583-.171 1.097-.822 1.406-.343.171-.48.172-.549.069-.034-.069 0-.137.069-.206.617-.514.617-.926.548-1.508-.034-.378-.308-.618-.583-.618-1.2 0-2.914 2.674-2.674 4.629.103.754.549 1.646 1.509 1.646.308 0 .65-.103.96-.24.5-.264.799-.47 1.097-.8-.073-.885.704-2.046 1.851-2.046.515 0 .926.205.96.583.068.514-.377.582-.514.582s-.378-.034-.378-.17c-.034-.138.309-.07.275-.378-.035-.206-.24-.274-.446-.274-.72 0-1.131.994-1.029 1.611.035.275.172.549.447.549.205 0 .514-.31.617-.755.068-.308.343-.514.583-.514.102 0 .17.034.205.171v.138c-.034.137-.137.548-.102.651 0 .069.034.171.17.171.092 0 .436-.18.777-.459.117-.59.253-1.298.253-1.357.034-.24.137-.48.617-.48.103 0 .171.034.205.171v.138l-.136.617c.445-.583 1.097-.994 1.508-.994.172 0 .309.102.309.274 0 .103 0 .274-.069.446-.137.377-.309.96-.412 1.474 0 .137.035.274.207.274.171 0 .685-.206 1.096-.754l.007-.004c-.002-.068-.007-.134-.007-.202 0-.411.035-.754.104-.994.068-.274.411-.514.617-.514.103 0 .205.069.205.171 0 .035 0 .103-.034.137-.137.446-.24.857-.24 1.269 0 .24.034.582.102.788 0 .034.035.069.07.069.068 0 .548-.445.89-1.028-.308-.206-.48-.549-.48-.96 0-.72.446-1.097.858-1.097.343 0 .617.24.617.72 0 .308-.103.65-.274.96h.102a.77.77 0 0 0 .584-.24.293.293 0 0 1 .134-.117c.335-.425.83-.74 1.41-.74.48 0 .924.205.959.582.068.515-.378.618-.515.618l-.002-.002c-.138 0-.377-.035-.377-.172 0-.137.309-.068.274-.376-.034-.206-.24-.275-.446-.275-.686 0-1.13.891-1.028 1.611.034.275.171.583.445.583.206 0 .515-.308.652-.754.068-.274.343-.514.583-.514.103 0 .17.034.205.171 0 .069 0 .206-.137.652-.17.308-.171.48-.137.617.034.274.171.48.309.583.034.034.068.102.068.102 0 .069-.034.138-.137.138-.034 0-.068 0-.103-.035-.514-.205-.72-.548-.789-.891-.205.24-.445.377-.72.377-.445 0-.89-.411-.96-.926a1.609 1.609 0 0 1 .075-.649c-.203.13-.422.203-.623.203h-.17c-.447.652-.927 1.098-1.27 1.303a.896.896 0 0 1-.377.104c-.068 0-.171-.035-.205-.104-.095-.152-.156-.392-.193-.667-.481.527-1.145.805-1.453.805-.343 0-.548-.206-.582-.55v-.376c.102-.754.377-1.2.377-1.337a.074.074 0 0 0-.069-.07c-.24 0-1.028.824-1.166 1.373l-.103.445c-.068.309-.377.515-.582.515-.103 0-.172-.035-.206-.172v-.137l.046-.233c-.435.31-.87.508-1.075.508-.308 0-.48-.172-.514-.412-.206.274-.445.412-.754.412-.352 0-.696-.24-.862-.593-.244.275-.523.553-.852.764-.48.309-1.028.549-1.68.549-.582 0-1.097-.309-1.371-.583-.412-.377-.651-.96-.686-1.509-.205-1.68.823-3.84 2.4-4.8.378-.205.755-.343 1.132-.343zm9.77 3.291c-.104 0-.172.172-.172.343 0 .274.137.583.309.755a1.74 1.74 0 0 0 .102-.583c0-.343-.137-.515-.24-.515z",source:"https://www.canva.com/",hex:"00C4CC",guidelines:void 0,license:void 0},siBluetooth={title:"Bluetooth",slug:"bluetooth",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bluetooth</title><path d="'+this.path+'"/></svg>'},path:"M12 0C6.76 0 3.1484 2.4895 3.1484 12S6.76 24 12 24c5.24 0 8.8516-2.4895 8.8516-12S17.24 0 12 0zm-.7773 1.6816l6.2148 6.2149L13.334 12l4.1035 4.1035-6.2148 6.2149V14.125l-3.418 3.42-1.2422-1.2442L10.8515 12l-4.289-4.3008 1.2422-1.2441 3.418 3.4199V1.6816zm1.748 4.2442v3.9687l1.9844-1.9843-1.9844-1.9844zm0 8.1816v3.9668l1.9844-1.9844-1.9844-1.9824Z",source:"https://www.bluetooth.com/develop-with-bluetooth/marketing-branding/",hex:"0082FC",guidelines:void 0,license:void 0},siCsharp={title:"C Sharp",slug:"csharp",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>C Sharp</title><path d="'+this.path+'"/></svg>'},path:"M12 0A12 12 0 000 12a12 12 0 0012 12 12 12 0 0012-12A12 12 0 0012 0zM9.426 7.12a5.55 5.55 0 011.985.38v1.181a4.5 4.5 0 00-2.25-.566 3.439 3.439 0 00-2.625 1.087 4.099 4.099 0 00-1.012 2.906 3.9 3.9 0 00.945 2.754 3.217 3.217 0 002.482 1.023 4.657 4.657 0 002.464-.634l-.004 1.08a5.543 5.543 0 01-2.625.555 4.211 4.211 0 01-3.228-1.297 4.793 4.793 0 01-1.212-3.409 5.021 5.021 0 011.365-3.663 4.631 4.631 0 013.473-1.392 5.55 5.55 0 01.12-.004 5.55 5.55 0 01.122 0zm5.863.155h.836l-.555 2.652h1.661l.567-2.652h.81l-.555 2.652 1.732-.004-.15.697H17.91l-.412 1.98h1.852l-.176.698h-1.816l-.58 2.625h-.83l.567-2.625h-1.65l-.555 2.625h-.81l.555-2.625h-1.74l.131-.698h1.748l.401-1.976h-1.826l.138-.697h1.826zm.142 3.345L15 12.6h1.673l.423-1.98z",source:"https://upload.wikimedia.org/wikipedia/commons/0/0d/C_Sharp_wordmark.svg",hex:"239120",guidelines:void 0,license:void 0},siBitbucket={title:"Bitbucket",slug:"bitbucket",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bitbucket</title><path d="'+this.path+'"/></svg>'},path:"M.778 1.213a.768.768 0 00-.768.892l3.263 19.81c.084.5.515.868 1.022.873H19.95a.772.772 0 00.77-.646l3.27-20.03a.768.768 0 00-.768-.891zM14.52 15.53H9.522L8.17 8.466h7.561z",source:"https://www.atlassian.com/company/news/press-kit",hex:"0052CC",guidelines:void 0,license:void 0},siBit={title:"Bit",slug:"bit",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bit</title><path d="'+this.path+'"/></svg>'},path:"M12 24C5.373 24 0 18.627 0 12S5.373 0 12 0s12 5.373 12 12-5.373 12-12 12zm-1.144-10.93c0-1.292-.763-2.019-1.858-2.019-.341 0-.637.072-.862.224V9.552c0-.323-.197-.485-.601-.485s-.601.162-.601.485v4.533c0 .305 0 .601.413.835.359.206.826.305 1.328.305 1.4 0 2.181-.844 2.181-2.154zm-2.72 1.05v-1.921a.923.923 0 0 1 .565-.18c.556 0 .924.413.924 1.131 0 .709-.359 1.104-.942 1.104-.206 0-.395-.045-.548-.135zm4.968-4.254c0-.413-.296-.691-.709-.691s-.709.278-.709.691c0 .413.296.7.709.7s.709-.287.709-.7zm-.108 1.669c0-.323-.197-.485-.601-.485s-.601.162-.601.485v3.186c0 .323.197.485.601.485s.601-.162.601-.485v-3.186zm3.64 2.594c-.072 0-.135.018-.206.036-.081.018-.18.045-.278.045-.153 0-.269-.054-.332-.18-.081-.153-.081-.386-.081-.548v-1.346h.754c.323 0 .485-.162.485-.503s-.162-.503-.485-.503h-.754v-.79c0-.323-.197-.485-.601-.485s-.601.162-.601.485v.79h-.314c-.323 0-.485.162-.485.503s.162.503.485.503h.314v1.346c0 .413.018.799.197 1.122.197.359.583.619 1.23.619.35 0 .691-.081.889-.197.171-.099.215-.224.215-.35 0-.197-.099-.548-.431-.548z",source:"https://bit.dev",hex:"73398D",guidelines:void 0,license:void 0},siApplearcade={title:"Apple Arcade",slug:"applearcade",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apple Arcade</title><path d="'+this.path+'"/></svg>'},path:"M.198 18.24a.966.966 0 0 1-.194-.571v-.955s0-.571.563-.313c0 0 6.919 3.135 8.033 3.626a7.832 7.832 0 0 0 3.408.729 8.216 8.216 0 0 0 3.396-.729l8.037-3.626c.559-.258.559.313.559.313v.955a1.038 1.038 0 0 1-.198.575c-.19.258-.515.539-1.411.959-.713.337-6.23 2.818-6.995 3.17a8.008 8.008 0 0 1-3.4.729 8.336 8.336 0 0 1-3.82-.927c-1.435-.65-5.849-2.631-6.567-2.972-.9-.428-1.153-.654-1.411-.963zm1.411-5.973l6.987-3.17a7.975 7.975 0 0 1 2.164-.634v5.707c0 .396.571.697 1.236.697s1.141-.313 1.141-.697V8.479c.778.105 1.54.313 2.263.618l6.987 3.17c.579.273 1.609.761 1.609 1.538s-1.011 1.236-1.609 1.53l-6.987 3.17a8.2 8.2 0 0 1-3.396.729 7.832 7.832 0 0 1-3.408-.729l-6.987-3.17C1.011 15.042 0 14.574 0 13.801s1.03-1.264 1.609-1.534zm1.807 2.247c.77.396 1.683.396 2.453 0 .682-.396.686-1.026 0-1.419a2.705 2.705 0 0 0-2.453 0c-.68.392-.666 1.02 0 1.419zM12 7.595a3.35 3.35 0 1 1 3.349-3.351v.003c0 1.849-1.5 3.348-3.349 3.348z",source:"https://www.apple.com/apple-arcade/",hex:"000000",guidelines:void 0,license:void 0},siApostrophe={title:"Apostrophe",slug:"apostrophe",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apostrophe</title><path d="'+this.path+'"/></svg>'},path:"M15.674 0c-.795.001-1.794.095-3.167.313l-4.6.729c-3.138.497-4.224 1.003-5.274 1.798a6.485 6.485 0 00-2.24 3.082c-.43 1.245-.577 2.434-.08 5.571l.729 4.6c.497 3.138 1.003 4.22 1.798 5.273a6.485 6.485 0 003.082 2.24c1.245.431 2.434.578 5.571.081l4.6-.729c3.138-.497 4.22-1.003 5.273-1.799a6.477 6.477 0 002.24-3.081c.431-1.245.578-2.434.082-5.571l-.73-4.6c-.497-3.138-1.003-4.224-1.799-5.274a6.477 6.477 0 00-3.081-2.24C17.378.152 16.695 0 15.674 0zm-5.319 4.566a.52.52 0 01.003 0 .52.52 0 01.52.444l.77 4.865a.52.52 0 01-.435.6l-4.859.77a.52.52 0 01-.602-.436l-.77-4.866a.52.52 0 01.435-.6l4.86-.77a.52.52 0 01.078-.007zM9.92 5.692l-3.823.605.612 3.83 3.813-.605zm6.504 2.91a3.274 3.274 0 01.497 6.513 3.258 3.258 0 01-3.713-2.726 3.274 3.274 0 013.216-3.787zm-.054 1.058a2.226 2.226 0 10.388 4.42 2.208 2.208 0 001.818-2.541 2.226 2.226 0 00-2.206-1.879zm-6.45 3a.52.52 0 01.424.208l3.824 4.964a.52.52 0 01-.333.839l-5.932.937a.52.52 0 01-.576-.695l2.108-5.901a.52.52 0 01.486-.352zm.18 1.611L8.61 18.438l4.186-.664z",source:"https://github.com/apostrophecms/apostrophe/blob/a7fcc6b13831302e27f79a6fcaaf58e3a40517df/logo.svg",hex:"6236FF",guidelines:void 0,license:void 0},siAppstore={title:"App Store",slug:"appstore",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>App Store</title><path d="'+this.path+'"/></svg>'},path:"M8.8086 14.9194l6.1107-11.0368c.0837-.1513.1682-.302.2437-.4584.0685-.142.1267-.2854.1646-.4403.0803-.3259.0588-.6656-.066-.9767-.1238-.3095-.3417-.5678-.6201-.7355a1.4175 1.4175 0 0 0-.921-.1924c-.3207.043-.6135.1935-.8443.4288-.1094.1118-.1996.2361-.2832.369-.092.1463-.175.2979-.259.4492l-.3864.6979-.3865-.6979c-.0837-.1515-.1667-.303-.2587-.4492-.0837-.1329-.1739-.2572-.2835-.369-.2305-.2353-.5233-.3857-.844-.429a1.4181 1.4181 0 0 0-.921.1926c-.2784.1677-.4964.426-.6203.7355-.1246.311-.1461.6508-.066.9767.038.155.0962.2984.1648.4403.0753.1564.1598.307.2437.4584l1.248 2.2543-4.8625 8.7825H2.0295c-.1676 0-.3351-.0007-.5026.0092-.1522.009-.3004.0284-.448.0714-.3108.0906-.5822.2798-.7783.548-.195.2665-.3006.5929-.3006.9279 0 .3352.1057.6612.3006.9277.196.2683.4675.4575.7782.548.1477.043.296.0623.4481.0715.1675.01.335.009.5026.009h13.0974c.0171-.0357.059-.1294.1-.2697.415-1.4151-.6156-2.843-2.0347-2.843zM3.113 18.5418l-.7922 1.5008c-.0818.1553-.1644.31-.2384.4705-.067.1458-.124.293-.1611.452-.0785.3346-.0576.6834.0645 1.0029.1212.3175.3346.583.607.7549.2727.172.5891.2416.9013.1975.3139-.044.6005-.1986.8263-.4402.1072-.1148.1954-.2424.2772-.3787.0902-.1503.1714-.3059.2535-.4612L6 19.4636c-.0896-.149-.9473-1.4704-2.887-.9218m20.5861-3.0056a1.4707 1.4707 0 0 0-.779-.5407c-.1476-.0425-.2961-.0616-.4483-.0705-.1678-.0099-.3352-.0091-.503-.0091H18.648l-4.3891-7.817c-.6655.7005-.9632 1.485-1.0773 2.1976-.1655 1.0333.0367 2.0934.546 3.0004l5.2741 9.3933c.084.1494.167.299.2591.4435.0837.131.1739.2537.2836.364.231.2323.5238.3809.8449.4232.3192.0424.643-.0244.9217-.1899.2784-.1653.4968-.4204.621-.7257.1246-.3072.146-.6425.0658-.9641-.0381-.1529-.0962-.2945-.165-.4346-.0753-.1543-.1598-.303-.2438-.4524l-1.216-2.1662h1.596c.1677 0 .3351.0009.5029-.009.1522-.009.3007-.028.4483-.0705a1.4707 1.4707 0 0 0 .779-.5407A1.5386 1.5386 0 0 0 24 16.452a1.539 1.539 0 0 0-.3009-.9158Z",source:"https://developer.apple.com/app-store/",hex:"0D96F6",guidelines:void 0,license:void 0},siAppannie={title:"App Annie",slug:"appannie",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>App Annie</title><path d="'+this.path+'"/></svg>'},path:"M7.834 10.525l2.958 8.975-8.873-8.975zm8.325 0h5.862l-8.793 8.974zm-1.02-.401l-3.169 9.691-3.17-9.691 3.17-3.231zM9.328 2.796h5.326L11.99 5.43zm6.7 6.712L12.75 6.213l3.027-3.043 6.305 6.338zM11.25 6.232L7.999 9.508h-6.08L8.211 3.17zm4.634-4.447l-.006-.006H8.121C5.414 4.529 2.706 7.279 0 10.03l12 12.192c4-4.064 8.001-8.127 12-12.192l-8.115-8.244",source:"https://www.appannie.com/en/about/press/",hex:"0F2346",guidelines:void 0,license:void 0},siAppian={title:"Appian",slug:"appian",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Appian</title><path d="'+this.path+'"/></svg>'},path:"M19.646 6.117C19.538 1.763 17.883 0 13.636 0H7.34v4.066h4.57c1.799 0 2.807 0 2.807 1.655v2.375c-.828 0-2.88-.036-4.426-.036-4.246 0-5.83 1.727-5.937 6.117v3.742c.108 4.102 1.51 5.865 5.253 6.081l3.85-4.066c-.397.036-.864.036-1.44.036-1.798 0-2.806 0-2.806-1.655v-4.57c0-1.655 1.007-1.655 2.806-1.655 1.908 0 2.807 0 2.807 1.655v10.22h4.821z",source:"https://appian.com",hex:"2322F0",guidelines:"https://assets.appian.com/uploads/assets/Appian_BrandGuidelines_Newsroom.pdf",license:void 0},siApple={title:"Apple",slug:"apple",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apple</title><path d="'+this.path+'"/></svg>'},path:"M12.152 6.896c-.948 0-2.415-1.078-3.96-1.04-2.04.027-3.91 1.183-4.961 3.014-2.117 3.675-.546 9.103 1.519 12.09 1.013 1.454 2.208 3.09 3.792 3.039 1.52-.065 2.09-.987 3.935-.987 1.831 0 2.35.987 3.96.948 1.637-.026 2.676-1.48 3.676-2.948 1.156-1.688 1.636-3.325 1.662-3.415-.039-.013-3.182-1.221-3.22-4.857-.026-3.04 2.48-4.494 2.597-4.559-1.429-2.09-3.623-2.324-4.39-2.376-2-.156-3.675 1.09-4.61 1.09zM15.53 3.83c.843-1.012 1.4-2.427 1.245-3.83-1.207.052-2.662.805-3.532 1.818-.78.896-1.454 2.338-1.273 3.714 1.338.104 2.715-.688 3.559-1.701",source:"https://www.apple.com",hex:"000000",guidelines:void 0,license:void 0},siApplepodcasts={title:"Apple Podcasts",slug:"applepodcasts",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apple Podcasts</title><path d="'+this.path+'"/></svg>'},path:"M5.34 0A5.328 5.328 0 000 5.34v13.32A5.328 5.328 0 005.34 24h13.32A5.328 5.328 0 0024 18.66V5.34A5.328 5.328 0 0018.66 0zm6.525 2.568c2.336 0 4.448.902 6.056 2.587 1.224 1.272 1.912 2.619 2.264 4.392.12.59.12 2.2.007 2.864a8.506 8.506 0 01-3.24 5.296c-.608.46-2.096 1.261-2.336 1.261-.088 0-.096-.091-.056-.46.072-.592.144-.715.48-.856.536-.224 1.448-.874 2.008-1.435a7.644 7.644 0 002.008-3.536c.208-.824.184-2.656-.048-3.504-.728-2.696-2.928-4.792-5.624-5.352-.784-.16-2.208-.16-3 0-2.728.56-4.984 2.76-5.672 5.528-.184.752-.184 2.584 0 3.336.456 1.832 1.64 3.512 3.192 4.512.304.2.672.408.824.472.336.144.408.264.472.856.04.36.03.464-.056.464-.056 0-.464-.176-.896-.384l-.04-.03c-2.472-1.216-4.056-3.274-4.632-6.012-.144-.706-.168-2.392-.03-3.04.36-1.74 1.048-3.1 2.192-4.304 1.648-1.737 3.768-2.656 6.128-2.656zm.134 2.81c.409.004.803.04 1.106.106 2.784.62 4.76 3.408 4.376 6.174-.152 1.114-.536 2.03-1.216 2.88-.336.43-1.152 1.15-1.296 1.15-.023 0-.048-.272-.048-.603v-.605l.416-.496c1.568-1.878 1.456-4.502-.256-6.224-.664-.67-1.432-1.064-2.424-1.246-.64-.118-.776-.118-1.448-.008-1.02.167-1.81.562-2.512 1.256-1.72 1.704-1.832 4.342-.264 6.222l.413.496v.608c0 .336-.027.608-.06.608-.03 0-.264-.16-.512-.36l-.034-.011c-.832-.664-1.568-1.842-1.872-2.997-.184-.698-.184-2.024.008-2.72.504-1.878 1.888-3.335 3.808-4.019.41-.145 1.133-.22 1.814-.211zm-.13 2.99c.31 0 .62.06.844.178.488.253.888.745 1.04 1.259.464 1.578-1.208 2.96-2.72 2.254h-.015c-.712-.331-1.096-.956-1.104-1.77 0-.733.408-1.371 1.112-1.745.224-.117.534-.176.844-.176zm-.011 4.728c.988-.004 1.706.349 1.97.97.198.464.124 1.932-.218 4.302-.232 1.656-.36 2.074-.68 2.356-.44.39-1.064.498-1.656.288h-.003c-.716-.257-.87-.605-1.164-2.644-.341-2.37-.416-3.838-.218-4.302.262-.616.974-.966 1.97-.97z",source:"https://www.apple.com/itunes/marketing-on-podcasts/identity-guidelines.html#apple-podcasts-icon",hex:"9933CC",guidelines:void 0,license:void 0},siApplemusic={title:"Apple Music",slug:"applemusic",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apple Music</title><path d="'+this.path+'"/></svg>'},path:"M23.994 6.124a9.23 9.23 0 00-.24-2.19c-.317-1.31-1.062-2.31-2.18-3.043a5.022 5.022 0 00-1.877-.726 10.496 10.496 0 00-1.564-.15c-.04-.003-.083-.01-.124-.013H5.986c-.152.01-.303.017-.455.026-.747.043-1.49.123-2.193.4-1.336.53-2.3 1.452-2.865 2.78-.192.448-.292.925-.363 1.408-.056.392-.088.785-.1 1.18 0 .032-.007.062-.01.093v12.223c.01.14.017.283.027.424.05.815.154 1.624.497 2.373.65 1.42 1.738 2.353 3.234 2.801.42.127.856.187 1.293.228.555.053 1.11.06 1.667.06h11.03a12.5 12.5 0 001.57-.1c.822-.106 1.596-.35 2.295-.81a5.046 5.046 0 001.88-2.207c.186-.42.293-.87.37-1.324.113-.675.138-1.358.137-2.04-.002-3.8 0-7.595-.003-11.393zm-6.423 3.99v5.712c0 .417-.058.827-.244 1.206-.29.59-.76.962-1.388 1.14-.35.1-.706.157-1.07.173-.95.045-1.773-.6-1.943-1.536a1.88 1.88 0 011.038-2.022c.323-.16.67-.25 1.018-.324.378-.082.758-.153 1.134-.24.274-.063.457-.23.51-.516a.904.904 0 00.02-.193c0-1.815 0-3.63-.002-5.443a.725.725 0 00-.026-.185c-.04-.15-.15-.243-.304-.234-.16.01-.318.035-.475.066-.76.15-1.52.303-2.28.456l-2.325.47-1.374.278c-.016.003-.032.01-.048.013-.277.077-.377.203-.39.49-.002.042 0 .086 0 .13-.002 2.602 0 5.204-.003 7.805 0 .42-.047.836-.215 1.227-.278.64-.77 1.04-1.434 1.233-.35.1-.71.16-1.075.172-.96.036-1.755-.6-1.92-1.544-.14-.812.23-1.685 1.154-2.075.357-.15.73-.232 1.108-.31.287-.06.575-.116.86-.177.383-.083.583-.323.6-.714v-.15c0-2.96 0-5.922.002-8.882 0-.123.013-.25.042-.37.07-.285.273-.448.546-.518.255-.066.515-.112.774-.165.733-.15 1.466-.296 2.2-.444l2.27-.46c.67-.134 1.34-.27 2.01-.403.22-.043.442-.088.663-.106.31-.025.523.17.554.482.008.073.012.148.012.223.002 1.91.002 3.822 0 5.732z",source:"https://www.apple.com/itunes/marketing-on-music/identity-guidelines.html#apple-music-icon",hex:"FA243C",guidelines:void 0,license:void 0},siApplepay={title:"Apple Pay",slug:"applepay",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Apple Pay</title><path d="'+this.path+'"/></svg>'},path:"M2.15 4.318a42.16 42.16 0 0 0-.454.003c-.15.005-.303.013-.452.04a1.44 1.44 0 0 0-1.06.772c-.07.138-.114.278-.14.43-.028.148-.037.3-.04.45A10.2 10.2 0 0 0 0 6.222v11.557c0 .07.002.138.003.207.004.15.013.303.04.452.027.15.072.291.142.429a1.436 1.436 0 0 0 .63.63c.138.07.278.115.43.142.148.027.3.036.45.04l.208.003h20.194l.207-.003c.15-.004.303-.013.452-.04.15-.027.291-.071.428-.141a1.432 1.432 0 0 0 .631-.631c.07-.138.115-.278.141-.43.027-.148.036-.3.04-.45.002-.07.003-.138.003-.208l.001-.246V6.221c0-.07-.002-.138-.004-.207a2.995 2.995 0 0 0-.04-.452 1.446 1.446 0 0 0-1.2-1.201 3.022 3.022 0 0 0-.452-.04 10.448 10.448 0 0 0-.453-.003zm0 .512h19.942c.066 0 .131.002.197.003.115.004.25.01.375.032.109.02.2.05.287.094a.927.927 0 0 1 .407.407.997.997 0 0 1 .094.288c.022.123.028.258.031.374.002.065.003.13.003.197v11.552c0 .065 0 .13-.003.196-.003.115-.009.25-.032.375a.927.927 0 0 1-.5.693 1.002 1.002 0 0 1-.286.094 2.598 2.598 0 0 1-.373.032l-.2.003H1.906c-.066 0-.133-.002-.196-.003a2.61 2.61 0 0 1-.375-.032c-.109-.02-.2-.05-.288-.094a.918.918 0 0 1-.406-.407 1.006 1.006 0 0 1-.094-.288 2.531 2.531 0 0 1-.032-.373 9.588 9.588 0 0 1-.002-.197V6.224c0-.065 0-.131.002-.197.004-.114.01-.248.032-.375.02-.108.05-.199.094-.287a.925.925 0 0 1 .407-.406 1.03 1.03 0 0 1 .287-.094c.125-.022.26-.029.375-.032.065-.002.131-.002.196-.003zm4.71 3.7c-.3.016-.668.199-.88.456-.191.22-.36.58-.316.918.338.03.675-.169.888-.418.205-.258.345-.603.308-.955zm2.207.42v5.493h.852v-1.877h1.18c1.078 0 1.835-.739 1.835-1.812 0-1.07-.742-1.805-1.808-1.805zm.852.719h.982c.739 0 1.161.396 1.161 1.089 0 .692-.422 1.092-1.164 1.092h-.979zm-3.154.3c-.45.01-.83.28-1.05.28-.235 0-.593-.264-.981-.257a1.446 1.446 0 0 0-1.23.747c-.527.908-.139 2.255.374 2.995.249.366.549.769.944.754.373-.014.52-.242.973-.242.454 0 .586.242.98.235.41-.007.667-.366.915-.733.286-.417.403-.82.41-.841-.007-.008-.79-.308-.797-1.209-.008-.754.615-1.113.644-1.135-.352-.52-.9-.578-1.09-.593a1.123 1.123 0 0 0-.092-.002zm8.204.397c-.99 0-1.606.533-1.652 1.256h.777c.072-.358.369-.586.845-.586.502 0 .803.266.803.711v.309l-1.097.064c-.951.054-1.488.484-1.488 1.184 0 .72.548 1.207 1.332 1.207.526 0 1.032-.281 1.264-.727h.019v.659h.788v-2.76c0-.803-.62-1.317-1.591-1.317zm1.94.072l1.446 4.009c0 .003-.073.24-.073.247-.125.41-.33.571-.711.571-.069 0-.206 0-.267-.015v.666c.06.011.267.019.335.019.83 0 1.226-.312 1.568-1.283l1.5-4.214h-.868l-1.012 3.259h-.015l-1.013-3.26zm-1.167 2.189v.316c0 .521-.45.917-1.024.917-.442 0-.731-.228-.731-.579 0-.342.278-.56.769-.593z",source:"https://developer.apple.com/apple-pay/marketing/",hex:"000000",guidelines:void 0,license:void 0},siCairometro={title:"Cairo Metro",slug:"cairometro",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Cairo Metro</title><path d="'+this.path+'"/></svg>'},path:"M12.397 4.14h.882v.881h-.882zm-1.628 0h.883v.881h-.883zm4.915 1.055v3.402h-1.386V5.195h-.84v1.763h-2.983V5.196h-.84v3.402H8.543v.84h1.911V7.82h2.983v1.617h5.44V5.195zm2.352 3.395h-1.512V6.028h1.512zM5.173 5.195v2.604h2.353v.805H5.173v.833h3.193V5.195zm2.339 1.757H5.999v-.924h1.513zm-2.64 12.177V9.726h4.175L12 12.68l2.954-2.953h4.176v9.403h-4.176v-3.442L12 18.754l-2.952-3.048v3.424zM12 0L8.485 3.515h-4.97v4.97L0 12l3.515 3.515v4.97h4.97L12 24l3.515-3.515h4.97v-4.97L24 12l-3.515-3.515v-4.97h-4.97zm0 1.708l3.014 3.015h4.263v4.263L22.292 12l-3.015 3.014v4.263h-4.263L12 22.292l-3.014-3.015H4.723v-4.263L1.708 12l3.015-3.014V4.723h4.263Z",source:"https://en.wikipedia.org/wiki/File:Cairo_metro_logo2012.svg",hex:"C10C0C",guidelines:void 0,license:void 0},siCheckio={title:"CheckiO",slug:"checkio",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>CheckiO</title><path d="'+this.path+'"/></svg>'},path:"M10.846 8.886L24 2.932v13.82L9.621 21.068 0 14.09l3.35-9.956 7.496 4.751v.001zm-4.582 2.067l3.923-1.768-6.065-3.85 2.142 5.618zm-5.393 2.44l4.842-2.187-2.179-5.717-2.662 7.904H.871zm22.526 2.54V4.256l-5.96 7.37 5.96 4.307zm-12.865 4.233l12.497-3.758-5.973-4.316-6.524 8.074zM.94 14.029l8.092 5.867-3.106-8.124L.94 14.029zm21.722-9.826c-5.085 2.296-10.163 4.6-15.25 6.895l9.445.284 5.805-7.178v-.001zM9.775 20.143l6.608-8.173-9.844-.29 3.236 8.462v.001z",source:"https://py.checkio.org/blog/",hex:"008DB6",guidelines:void 0,license:void 0},siCampaignmonitor={title:"Campaign Monitor",slug:"campaignmonitor",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Campaign Monitor</title><path d="'+this.path+'"/></svg>'},path:"M23.836 4.27c-.29-.413-.86-.515-1.273-.226L.163 19.73c.167.235.437.39.747.39h22.18c.503 0 .91-.41.91-.914V4.78c-.004-.176-.058-.352-.164-.51zm-22.4-.226c-.413-.29-.982-.19-1.272.226-.107.154-.162.332-.164.51v14.45l10.664-8.736-9.227-6.45v-.002z",source:"https://www.campaignmonitor.com/company/brand/",hex:"111324",guidelines:void 0,license:void 0},siCanonical={title:"Canonical",slug:"canonical",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Canonical</title><path d="'+this.path+'"/></svg>'},path:"M24 12c0 6.627-5.373 12-12 12-6.628 0-12-5.373-12-12C0 5.372 5.372 0 12 0c6.627 0 12 5.372 12 12zM12 2.92A9.08 9.08 0 002.92 12 9.08 9.08 0 0012 21.08 9.08 9.08 0 0021.081 12 9.08 9.08 0 0012 2.92zm0 16.722A7.64 7.64 0 014.36 12 7.64 7.64 0 0112 4.36 7.64 7.64 0 0119.641 12a7.64 7.64 0 01-7.64 7.641z",source:"https://design.ubuntu.com/downloads/",hex:"77216F",guidelines:"https://design.ubuntu.com/brand/canonical-logo/",license:{type:"CC-BY-SA-3.0",url:"https://spdx.org/licenses/CC-BY-SA-3.0"}},siCastro={title:"Castro",slug:"castro",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Castro</title><path d="'+this.path+'"/></svg>'},path:"M12 0C5.372 0 0 5.373 0 12s5.372 12 12 12c6.627 0 12-5.373 12-12S18.627 0 12 0zm-.002 13.991a2.052 2.052 0 1 1 0-4.105 2.052 2.052 0 0 1 0 4.105zm4.995 4.853l-2.012-2.791a5.084 5.084 0 1 0-5.982.012l-2.014 2.793A8.526 8.526 0 0 1 11.979 3.42a8.526 8.526 0 0 1 8.526 8.526 8.511 8.511 0 0 1-3.512 6.898z",source:"http://supertop.co/castro/press/",hex:"00B265",guidelines:void 0,license:void 0},siCapacitor={title:"Capacitor",slug:"capacitor",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Capacitor</title><path d="'+this.path+'"/></svg>'},path:"M24 3.7l-5.766 5.766 5.725 5.736-3.713 3.712L5.073 3.742 8.786.03l5.736 5.726L20.284 0 24 3.7zM.029 8.785l3.713-3.713 15.173 15.173-3.713 3.714-5.732-5.726L3.7 24 0 20.285l5.754-5.764L.029 8.785z",source:"https://github.com/ionic-team/ionicons-site/blob/b0c97018d737b763301154231b34e1b882c0c84d/docs/ionicons/svg/logo-capacitor.svg",hex:"119EFF",guidelines:void 0,license:void 0},siCarthrottle={title:"Car Throttle",slug:"carthrottle",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Car Throttle</title><path d="'+this.path+'"/></svg>'},path:"M0 19.99h5.31l1-5.76h2.673L7.97 19.99h5.272l1.037-5.76h2.824l-1 5.76h7.584L21.9 17.029 24 4.01h-5.16l-.987 5.647h-2.86l.936-5.647H8.483l1.724 2.749-.487 2.898H6.996l.9-5.647H.35l1.76 2.774Z",source:"https://www.carthrottle.com/",hex:"FF9C42",guidelines:void 0,license:void 0},siCarrefour={title:"Carrefour",slug:"carrefour",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Carrefour</title><path d="'+this.path+'"/></svg>'},path:"M12.14 4.045c-2.569 0-3.572 3.64-3.572 7.979 0 4.34 1.003 7.931 3.572 7.931 1.541 0 2.855-.903 2.86-1.645a.625.625 0 0 0-.199-.453c-.73-.706-1.016-1.412-1.018-2.034-.005-1.189 1.026-2.074 1.977-2.074 1.306 0 2.077 1.027 2.077 2.357 0 1.26-.537 2.31-1.121 3.15a.193.193 0 0 0-.034.107c0 .065.04.12.098.12.035 0 .076-.02.122-.065l6.561-6.344c.328-.28.537-.608.537-1.073 0-.468-.21-.794-.537-1.073l-6.561-6.346c-.045-.045-.087-.064-.122-.064-.059 0-.097.055-.098.12 0 .035.01.073.034.107.584.84 1.12 1.89 1.12 3.15 0 1.329-.77 2.356-2.076 2.356-.95 0-1.982-.884-1.977-2.073.002-.622.288-1.328 1.018-2.033A.624.624 0 0 0 15 5.69c-.004-.743-1.319-1.646-2.86-1.646m-5.043.537L.537 10.93C.209 11.207 0 11.534 0 12c0 .465.21.793.537 1.073l6.56 6.345c.042.043.083.06.117.06.062 0 .105-.057.103-.123a.188.188 0 0 0-.057-.123C5.72 17.32 4.6 15.126 4.6 12.024c0-3.104 1.12-5.341 2.66-7.255a.185.185 0 0 0 .057-.123c.002-.068-.04-.123-.103-.123-.034 0-.075.017-.117.06",source:"https://upload.wikimedia.org/wikipedia/commons/5/5b/Carrefour_logo.svg",hex:"004E9F",guidelines:void 0,license:void 0},siCarto={title:"Carto",slug:"carto",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Carto</title><path d="'+this.path+'"/></svg>'},path:"M19.138 7.138C21.823 7.138 24 9.3147 24 12s-2.1769 4.862-4.862 4.862c-1.9046 0-3.5532-1.0949-4.351-2.6896h.4683c.7615 1.358 2.215 2.2759 3.8826 2.2759 2.4567 0 4.4483-1.9916 4.4483-4.4483 0-2.4567-1.9916-4.4483-4.4483-4.4483-1.6677 0-3.1211.9178-3.8826 2.2759h-.4683c.7978-1.5947 2.4464-2.6897 4.351-2.6897zm0 3.3103c.8569 0 1.5517.6947 1.5517 1.5517 0 .857-.6948 1.5517-1.5518 1.5517-.857 0-1.5517-.6947-1.5517-1.5517 0-.857.6948-1.5517 1.5517-1.5517zm-17.5772.0109c.6066 0 .9968.2545 1.2597.615l-.6192.4793c-.1697-.2079-.3648-.3478-.649-.3478-.4156 0-.7083.3562-.7083.7889v.008c0 .4453.2927.793.7083.793.3096 0 .492-.144.6702-.3604l.6192.4411c-.2799.386-.6574.6701-1.3105.6701C.6829 13.547 0 12.898 0 12.0116v-.008c0-.8652.6617-1.5439 1.5608-1.5439zm4.7346.0382l1.264 2.9902h-.8822l-.212-.5344H5.3156l-.212.5344h-.861l1.2596-2.9902zm4.27.0212c.454 0 .7678.1187.9671.318.174.174.263.3988.263.6914v.008c0 .458-.2418.7592-.6108.9162l.7083 1.0349h-.9458l-.598-.8992h-.3648v.8992h-.8228v-2.969zm5.3983 0v.721h-.8907v2.248h-.8228v-2.248h-.8864v-.721zm-10.0712.9543l-.335.8398h.6658zm4.6348-.246h-.5429v.7168h.5472c.2756 0 .441-.1357.441-.352v-.008c0-.2375-.1738-.3563-.4453-.3563z",source:"https://carto.com/brand/",hex:"EB1510",guidelines:void 0,license:void 0},siCashapp={title:"Cash App",slug:"cashapp",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Cash App</title><path d="'+this.path+'"/></svg>'},path:"M23.59 3.475a5.1 5.1 0 00-3.05-3.05c-1.31-.42-2.5-.42-4.92-.42H8.36c-2.4 0-3.61 0-4.9.4a5.1 5.1 0 00-3.05 3.06C0 4.765 0 5.965 0 8.365v7.27c0 2.41 0 3.6.4 4.9a5.1 5.1 0 003.05 3.05c1.3.41 2.5.41 4.9.41h7.28c2.41 0 3.61 0 4.9-.4a5.1 5.1 0 003.06-3.06c.41-1.3.41-2.5.41-4.9v-7.25c0-2.41 0-3.61-.41-4.91zm-6.17 4.63l-.93.93a.5.5 0 01-.67.01 5 5 0 00-3.22-1.18c-.97 0-1.94.32-1.94 1.21 0 .9 1.04 1.2 2.24 1.65 2.1.7 3.84 1.58 3.84 3.64 0 2.24-1.74 3.78-4.58 3.95l-.26 1.2a.49.49 0 01-.48.39H9.63l-.09-.01a.5.5 0 01-.38-.59l.28-1.27a6.54 6.54 0 01-2.88-1.57v-.01a.48.48 0 010-.68l1-.97a.49.49 0 01.67 0c.91.86 2.13 1.34 3.39 1.32 1.3 0 2.17-.55 2.17-1.42 0-.87-.88-1.1-2.54-1.72-1.76-.63-3.43-1.52-3.43-3.6 0-2.42 2.01-3.6 4.39-3.71l.25-1.23a.48.48 0 01.48-.38h1.78l.1.01c.26.06.43.31.37.57l-.27 1.37c.9.3 1.75.77 2.48 1.39l.02.02c.19.2.19.5 0 .68z",source:"https://cash.app/press",hex:"00C244",guidelines:void 0,license:void 0},siCastbox={title:"Castbox",slug:"castbox",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Castbox</title><path d="'+this.path+'"/></svg>'},path:"M12 0c-.29 0-.58.068-.812.206L2.417 5.392c-.46.272-.804.875-.804 1.408v10.4c0 .533.344 1.135.804 1.407l8.77 5.187c.465.275 1.162.275 1.626 0l8.77-5.187c.46-.272.804-.874.804-1.407V6.8c0-.533-.344-1.136-.804-1.408L12.813.206A1.618 1.618 0 0012 0zm-.85 8.304c.394 0 .714.303.714.676v2.224c0 .207.191.375.427.375s.428-.168.428-.375V9.57c0-.373.32-.675.713-.675.394 0 .712.302.712.675v4.713c0 .374-.318.676-.712.676-.394 0-.713-.302-.713-.676v-1.31c0-.206-.192-.374-.428-.374s-.427.168-.427.374v1.226c0 .374-.32.676-.713.676-.394 0-.713-.302-.713-.676v-1.667c0-.207-.192-.375-.428-.375-.235 0-.427.168-.427.375v3.31c0 .373-.319.676-.712.676-.394 0-.713-.303-.713-.676v-2.427c0-.206-.191-.374-.428-.374-.235 0-.427.168-.427.374v.178a.71.71 0 01-.712.708.71.71 0 01-.713-.708v-2.123a.71.71 0 01.713-.708.71.71 0 01.712.708v.178c0 .206.192.373.427.373.237 0 .428-.167.428-.373v-1.53c0-.374.32-.676.713-.676.393 0 .712.303.712.676v.646c0 .206.192.374.427.374.236 0 .428-.168.428-.374V8.98c0-.373.319-.676.713-.676zm4.562 2.416c.393 0 .713.302.713.676v2.691c0 .374-.32.676-.713.676-.394 0-.712-.303-.712-.676v-2.691c0-.374.319-.676.712-.676zm2.28 1.368c.395 0 .713.303.713.676v.67c0 .374-.318.676-.712.676-.394 0-.713-.302-.713-.675v-.67c0-.374.32-.677.713-.677Z",source:"https://castbox.fm/newsroom/",hex:"F55B23",guidelines:void 0,license:void 0},siCastorama={title:"Castorama",slug:"castorama",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Castorama</title><path d="'+this.path+'"/></svg>'},path:"M8.91 16.106c-2.129 0-3.659-1.794-3.659-4.266 0-2.148 1.468-4.095 3.488-4.095 2.275 0 3.545 1.857 3.545 1.857l2.939-3.298c-.91-1.062-2.598-2.882-6.503-2.882-4.388 0-8.209 3.489-8.209 8.456 0 4.766 3.475 8.532 8.266 8.532 3.855 0 5.572-2.017 6.54-3.129l-2.831-2.969c0 .001-1.415 1.794-3.576 1.794zM18.283 0v9.988h-2.064a1.92 1.92 0 1 0 0 3.84h2.064V24h5.205V0h-5.205z",source:"https://www.castorama.fr/",hex:"0078D7",guidelines:void 0,license:void 0},siCelery={title:"Celery",slug:"celery",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Celery</title><path d="'+this.path+'"/></svg>'},path:"M2.303 0A2.298 2.298 0 0 0 0 2.303v19.394A2.298 2.298 0 0 0 2.303 24h19.394A2.298 2.298 0 0 0 24 21.697V2.303A2.298 2.298 0 0 0 21.697 0zm8.177 3.072c4.098 0 7.028 1.438 7.68 1.764l-1.194 2.55c-2.442-1.057-4.993-1.41-5.672-1.41-1.574 0-2.17.922-2.17 1.763v8.494c0 .869.596 1.791 2.17 1.791.679 0 3.23-.38 5.672-1.41l1.194 2.496c-.435.271-3.637 1.818-7.68 1.818-1.112 0-4.64-.244-4.64-4.64V7.713c0-4.397 3.528-4.64 4.64-4.64z",source:"https://github.com/celery/celery/blob/4d77ddddb10797011dc10dd2e4e1e7a7467b8431/docs/images/favicon.ico",hex:"37814A",guidelines:void 0,license:void 0},siCaterpillar={title:"Caterpillar",slug:"caterpillar",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Caterpillar</title><path d="'+this.path+'"/></svg>'},path:"M11.901 11.554l.802-4.1.798 4.1zm2.869-6.52h-4.15L8.2 15.884l4.503-3.635 4.695 3.934zm-2.067 8.156l-7.509 6.072H19.95zM24 5.02v2.77h-2.066v11.45h-.882l-2.436-2.04V7.79h-2.057V5.02zM6.872 16.864c.548-.458.642-1.024.642-1.532V13.2h-2.98v2.894a.75.75 0 0 1-.748.751c-.414 0-.722-.336-.722-.75V7.893c0-.414.308-.75.722-.75a.75.75 0 0 1 .749.75v2.913H7.51V7.785c0-1.67-1.092-3.044-3.75-3.047-2.728 0-3.76 1.38-3.76 3.05v8.563c0 1.655 1.314 2.907 2.995 2.907h.922Z",source:"https://commons.wikimedia.org/wiki/File:Caterpillar_logo.svg",hex:"FFCD11",guidelines:void 0,license:void 0},siCbs={title:"CBS",slug:"cbs",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>CBS</title><path d="'+this.path+'"/></svg>'},path:"M12 24C5.314 24 .068 18.587.068 11.949.068 5.413 5.314 0 12 0s11.932 5.413 11.932 11.949C23.932 18.587 18.686 24 12 24zm0-5.106c5.452 0 9.36-3.473 11.109-6.945C21.875 9.294 18.172 5.106 12 5.106c-5.452 0-9.36 3.37-11.109 6.843C2.537 15.42 6.548 18.894 12 18.894zm0-.613c-3.497 0-6.377-2.86-6.377-6.332S8.503 5.617 12 5.617s6.377 2.86 6.377 6.332c0 3.574-2.88 6.332-6.377 6.332Z",source:"https://www.cbs.com/",hex:"033963",guidelines:void 0,license:void 0},siCdprojekt={title:"CD Projekt",slug:"cdprojekt",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>CD Projekt</title><path d="'+this.path+'"/></svg>'},path:"M18.942,20.154c-0.687,0.323-1.719,0.302-2.986-0.072l0.213,0.547l-0.389-0.226l-1.537-0.907h0.001 l-0.033-0.158C14.783,19.509,17.746,20.507,18.942,20.154z M7.929,22.045c-0.127,0.229,0.179,0.645,0.179,0.645 c-0.687-0.534-1.276,0.346-1.276,0.346c-0.039-0.385,0.397-0.669,0.397-0.669c-0.715,0.113-1.549,0.78-1.549,0.78 c-0.097-0.333,0.319-0.556,0.319-0.556c0-0.263,0.361-0.236,0.763-0.347c0.272-0.074,0.679-0.186,0.919-0.252 c0.005-0.004,0.007-0.01,0.011-0.013c0-0.002,0.303-0.348,0.671-0.745c0.291-0.31,0.614-0.648,0.868-0.88 c0.118,0.018,0.226,0.031,0.294,0.037c-0.243,0.199-0.651,0.62-0.999,0.994C8.266,21.665,8.039,21.921,7.929,22.045z M10.168,14.083 l8.822,6.05c-0.013,0.007-0.029,0.011-0.042,0.018c-0.008-0.004-0.163-0.064-0.328-0.129c-0.081-0.033-0.178-0.072-0.29-0.118 h-0.001c-0.005-0.002-0.012-0.005-0.019-0.009c-0.772-0.317-2.27-0.951-4.634-2.041c-2.4-1.112-3.815-1.798-5.028-2.388l0.001,0.002 c0,0-0.001-0.002-0.002-0.002l4.363,3.974l0.006,0.004l0.011,0.011h0.002l0.256,0.211l-1.153,0.348 c-0.001-0.006-0.005-0.013-0.006-0.018c-0.006-0.016-0.011-0.033-0.017-0.051c-0.003-0.008-0.006-0.017-0.009-0.025 c-0.006-0.017-0.012-0.033-0.018-0.05c-0.003-0.007-0.006-0.015-0.009-0.023c-0.011-0.023-0.021-0.047-0.032-0.073l-0.202,0.094 c0.09,0.197,0.121,0.356,0.121,0.482c-0.001,0.16-0.064,0.282-0.109,0.353c-0.025,0.037-0.07,0.086-0.071,0.086l0.064,0.088 c-0.004,0.011-0.008,0.023-0.014,0.035c-0.341,0.545-0.652,1.308-0.786,1.653c-0.044,0.114-0.069,0.183-0.069,0.183 c0,0,0,0.002-0.001,0.005c0.227,0.009,0.767,0.073,0.627,0.504l-0.122,0.444c-0.268-0.478-0.154-0.606-0.154-0.606 C10.544,22.894,8.968,24,8.968,24c0.052-0.411,0.506-0.697,0.768-0.847c-0.221-0.026-0.494,0.165-0.64,0.283 c0.137-0.27,0.335-0.433,0.539-0.522c-0.002-0.002-0.002-0.002-0.003-0.004c0.359-0.135,0.712-0.069,0.753-0.029l-0.002,0.001 c0.122-0.038,0.131-0.043,0.241-0.068c0.036-0.026,0.071-0.112,0.088-0.158c0.001-0.005,0.363-1.014,0.81-1.774 c-0.217-0.021-0.388-0.274-0.388-0.581c0-0.018,0.001-0.037,0.002-0.055c-0.475,0.069-0.973,0.088-1.484,0.043 c-0.016,0-0.032-0.003-0.049-0.005c0,0.001,0,0.001,0,0.001c-0.024-0.002-0.131-0.012-0.262-0.029 c-0.945-0.128-1.803-0.45-2.507-0.911l0.002,0.01c0,0-1.279-0.682-1.551-2.233l-0.309,0.195c0-1.39,0.238-2.365,0.563-3.111 l-0.38,0.037l0.38-0.534c-0.05,0.103-0.096,0.212-0.143,0.332l0.233-0.039l0-.002c0.047-0.096,0.092-0.184,0.138-0.27 c0.092-0.169,0.188-0.328,0.295-0.484c0.024-0.035,0.069-0.098,0.111-0.152c0.062-0.08,0.147-0.179,0.204-0.245 c0.051-0.06,0.166-0.172,0.22-0.221c0.041-0.037,0.114-0.096,0.147-0.12l-0.229,1.072c0.669-0.832,1.912-2.075,2.535-2.665 c-0.118-0.222-0.248-0.418-0.386-0.581L8.08,10.763l-0.025,0.019c0,0-0.416,0.314-0.565,0.412c-0.409,0.267-0.706-0.07-0.722-0.09 c0.088,0.074,0.201,0.12,0.328,0.12c0.14,0,0.267-0.055,0.357-0.144c0.092-0.088,0.147-0.209,0.147-0.343 c0-0.068-0.014-0.132-0.038-0.191c-0.044-0.097-0.12-0.178-0.214-0.23H7.35c0,0-0.104-0.06-0.082-0.158 c0.022-0.099,0.206-0.291,0.206-0.291l0.225-0.229l0.36-0.367l0.777-0.79c0.047-0.052,0.077-0.087,0.077-0.087L8.231,8.686 L8.229,8.68c0-0.009,0.006-0.037,0.053-0.123c0.065-0.119,0.22-0.335,0.224-0.343l0.001-0.001L7.242,9.117c0-0.001,0-0.001,0-0.002 c0.074-0.35,0.824-1.365,0.858-1.412L7.27,8.464c0-0.002-0.001-0.004-0.003-0.006C7.224,8.2,7.638,7.317,7.695,7.197 C7.697,7.193,7.698,7.19,7.7,7.187C7.398,7.488,7.18,7.815,7.173,7.823c0-0.291,0.223-0.709,0.223-0.709 C7.332,7.176,7.272,7.242,7.214,7.307C6.346,8.285,6.095,9.429,6.027,9.873c0,0,0,0.001-0.001,0.001 C5.881,9.963,5.97,9.854,5.9,10.022c-0.256,0.073-0.47,0.202-0.642,0.346c-0.287,0.237-0.459,0.511-0.513,0.605 c0.034-0.043,0.07-0.083,0.105-0.119C5.38,10.3,5.992,10.36,5.992,10.36s0.682,1.26,0.542,1.405 c-0.015,0.015-0.039,0.017-0.072,0.006c-0.09-0.031-0.149-0.017-0.182,0.024c-0.105,0.117-0.009,0.454-0.008,0.462l-1.809-0.778 c0.858-0.318,1.47-0.1,1.47-0.1c0,0.212,0.48,0.184,0.48,0.184l0-.001h0.001c0-0.196-0.365-0.43-0.365-0.43 s-0.327,0.136-0.716,0c-0.077-0.027-0.161-0.038-0.242-0.034C5.02,11.1,4.946,11.115,4.874,11.136 c-0.206,0.059-0.357,0.174-0.357,0.174v-0.001L4.515,11.31l1.131-4.139l0.119,1.591L8.06,3.367l0.039,4.037L14.354,0l-3.847,8.316 l0.023,0.041l2.713-1.954l-0.573,1.149l3.793-1.481l-3.539,2.585l6.612-0.81l-8.021,3.471l4.105-1.001L10.168,14.083z M11.512,11.319l0.001,0l-0.001-0.004C11.512,11.316,11.512,11.317,11.512,11.319z M9.515,12.181 c-0.095-0.395-0.223-0.757-0.371-1.076L8.2,13.182L9.515,12.181z M7.215,11.087c0.208-0.071,0.314-0.308,0.239-0.529l-0.208,0.071 c0.013,0.031,0.022,0.064,0.022,0.099c0,0.031-0.005,0.06-0.017,0.086l0.095,0.057c-0.032,0.051-0.081,0.095-0.141,0.12 c-0.036,0.016-0.074,0.022-0.112,0.022c-0.122,0-0.236-0.074-0.286-0.195c-0.004-0.01-0.01-0.022-0.012-0.034l-0.092,0.03 C6.778,11.038,7.008,11.158,7.215,11.087z",source:"https://www.cdprojekt.com/en/media/logotypes/",hex:"DC0D15",guidelines:void 0,license:void 0},siCeph={title:"Ceph",slug:"ceph",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Ceph</title><path d="'+this.path+'"/></svg>'},path:"M11.959.257A11.912 11.912 0 003.503 3.76 11.92 11.92 0 000 12.217a11.934 11.934 0 001.207 5.243c.72 1.474 1.888 2.944 3.208 4.044.86-.47 1.35-.99 1.453-1.545.1-.533-.134-1.107-.737-1.805a9.031 9.031 0 01-2.219-5.937c0-4.988 4.058-9.047 9.047-9.047h.08c4.99 0 9.048 4.059 9.048 9.047a9.03 9.03 0 01-2.218 5.936c-.599.693-.84 1.292-.735 1.83.108.556.595 1.068 1.449 1.522 1.322-1.1 2.489-2.57 3.209-4.046A11.898 11.898 0 0024 12.217a11.929 11.929 0 00-3.503-8.457A11.923 11.923 0 0012.04.257h-.041zm-.005 4.837a7.072 7.072 0 00-3.76 1.075A7.202 7.202 0 006.15 8.093a7.164 7.164 0 00-1.161 2.65 7.188 7.188 0 00.04 3.125 7.14 7.14 0 001.22 2.607c.154.207.326.396.509.597l.185.202.005.006c.007.007.017.016.026.027.635.738.957 1.533.957 2.36a3.4 3.4 0 01-1.788 2.989 11.924 11.924 0 002.685 1.087c.14-.088.614-.441 1.077-1.083a4.899 4.899 0 00.94-2.99 6.595 6.595 0 00-.49-2.37 6.717 6.717 0 00-1.302-2.033l-.002-.004-.124-.142c-.21-.245-.428-.497-.602-.792a4.104 4.104 0 01-.462-1.135 4.258 4.258 0 01-.024-1.85 4.25 4.25 0 01.686-1.564 4.216 4.216 0 013.432-1.773H12.042a4.202 4.202 0 013.432 1.773c.33.466.568 1.007.686 1.565a4.27 4.27 0 01-.023 1.849c-.093.39-.249.772-.463 1.135-.173.295-.391.547-.602.792l-.123.142-.004.004a6.736 6.736 0 00-1.301 2.033 6.607 6.607 0 00-.49 2.37 4.897 4.897 0 00.94 2.99c.463.642.937.995 1.076 1.083a11.776 11.776 0 002.687-1.087 3.399 3.399 0 01-1.789-2.988c0-.817.313-1.59.956-2.359.009-.012.02-.022.027-.03l.006-.004.184-.204c.183-.2.355-.39.51-.596a7.14 7.14 0 001.22-2.608 7.21 7.21 0 00.04-3.124 7.185 7.185 0 00-1.16-2.65 7.203 7.203 0 00-2.044-1.924 7.074 7.074 0 00-3.762-1.075h-.09zM12 9.97a2.365 2.365 0 00-2.362 2.361A2.364 2.364 0 0012 14.691c1.301 0 2.36-1.059 2.36-2.36A2.364 2.364 0 0012 9.968z",source:"https://github.com/ceph/ceph/blob/b106a03dcddaee80493825e85bc5e399ab4d8746/src/pybind/mgr/dashboard/frontend/src/assets/Ceph_Logo.svg",hex:"EF5C55",guidelines:void 0,license:void 0},siCentos={title:"CentOS",slug:"centos",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>CentOS</title><path d="'+this.path+'"/></svg>'},path:"M12.076.066L8.883 3.28H3.348v5.434L0 12.01l3.349 3.298v5.39h5.374l3.285 3.236 3.285-3.236h5.43v-5.374L24 12.026l-3.232-3.252V3.321H15.31zm0 .749l2.49 2.506h-1.69v6.441l-.8.805-.81-.815V3.28H9.627zm-8.2 2.991h4.483L6.485 5.692l4.253 4.279v.654H9.94L5.674 6.423l-1.798 1.77zm5.227 0h1.635v5.415l-3.509-3.53zm4.302.043h1.687l1.83 1.842-3.517 3.539zm2.431 0h4.404v4.394l-1.83-1.842-4.241 4.267h-.764v-.69l4.261-4.287zm2.574 3.3l1.83 1.843v1.676h-5.327zm-12.735.013l3.515 3.462H3.876v-1.69zM3.348 9.454v1.697h6.377l.871.858-.782.77H3.35v1.786L.753 12.01zm17.42.068l2.488 2.503-2.533 2.55v-1.796h-6.41l-.75-.754.825-.83h6.38zm-9.502.978l.81.815.186-.188.614-.618v.686h.768l-.825.83.75.754h-.719v.808l-.842-.83-.741.73v-.707h-.7l.781-.77-.188-.186-.682-.672h.788zm-7.39 2.807h5.402l-3.603 3.55-1.798-1.772zm6.154 0h.708v.7l-4.404 4.338 1.852 1.824h-4.31v-4.342l1.798 1.77zm3.348 0h.715l4.317 4.343.186-.187 1.599-1.61v4.316h-4.366l1.853-1.825-.188-.185-4.116-4.054zm1.46 0h5.357v1.798l-1.785 1.796zm-2.83.191l.842.829v6.37h1.691l-2.532 2.495-2.533-2.495h1.79V14.23zm-1.27 1.251v5.42H8.939l-1.852-1.823zm2.64.097l3.552 3.499-1.853 1.825h-1.7z",source:"https://wiki.centos.org/ArtWork/Brand/Logo",hex:"262577",guidelines:void 0,license:void 0},siCesium={title:"Cesium",slug:"cesium",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Cesium</title><path d="'+this.path+'"/></svg>'},path:"M23.0283 10.216c-.3959 0-.7785.22-1.0792.6168l-3.7755 4.994c-.625.8275-1.5128 1.3012-2.4355 1.3012h-.0143c-.9236 0-1.8115-.4737-2.4355-1.3012l-3.7754-4.994c-.2998-.3969-.6823-.6168-1.0802-.6168-.3949 0-.7795.22-1.0781.6168l-3.7765 4.994c-.621.8204-1.4996 1.294-2.414 1.3012C3.088 21.186 7.2113 24 12.0004 24 18.6268 24 24 18.6276 24 12.001c0-.4705-.0338-.9308-.086-1.382-.2638-.2598-.5697-.403-.8857-.403m-7.019-2.5972c-.6936 0-1.2542-.5616-1.2542-1.2541s.5606-1.2541 1.2541-1.2541c.6925 0 1.254.5616 1.254 1.254s-.5615 1.2542-1.254 1.2542M12.0005 0C5.3732 0 0 5.3714 0 12.001c0 1.0536.1504 2.0704.406 3.0463.2272.175.4788.2762.7366.2762.3979 0 .7804-.2189 1.0812-.6138l3.7754-4.996c.623-.8285 1.5129-1.3021 2.4335-1.3021.9226 0 1.8095.4736 2.4355 1.3021l3.6323 4.8037.1565.1923c.2997.3939.6812.6107 1.074.6138.3918-.003.7743-.22 1.072-.6138l.1595-.1923 3.6323-4.8037c.624-.8285 1.5118-1.3021 2.4335-1.3021.1462 0 .2935.0163.4367.0388C21.9522 3.5557 17.3922 0 12.0005 0",source:"https://cesium.com/press/",hex:"6CADDF",guidelines:void 0,license:void 0},siChai={title:"Chai",slug:"chai",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Chai</title><path d="'+this.path+'"/></svg>'},path:"M22.2235 5.8311 12.2307.0619a.4617.4617 0 0 0-.4615 0L1.7765 5.8311a.4615.4615 0 0 0-.2308.3997v11.5385c0 .1649.088.3173.2308.3997l9.9928 5.7692a.4617.4617 0 0 0 .4615 0l9.9928-5.7692a.4615.4615 0 0 0 .2308-.3997V6.2308a.4618.4618 0 0 0-.2309-.3997zm-.6304 11.7074L12 23.0769l-9.5931-5.5385V6.4615L12 .9231l9.5931 5.5385v11.0769zM11.2957 8.1858c.3873-.2769.7918-.4965 1.2137-.6588s.8427-.2434 1.2624-.2434c.2596 0 .5019.0379.7269.1136.225.0757.4197.185.5841.3278s.2942.3202.3894.5322c.0952.212.1428.4543.1428.7269 0 .3288-.0649.6555-.1947.98-.1298.3245-.304.6252-.5225.9022s-.4706.5192-.7561.7269-.582.357-.8892.4478l-.1363-.2272a2.0872 2.0872 0 0 0 .4998-.3505 2.2747 2.2747 0 0 0 .3894-.4835c.1082-.1796.1915-.37.2499-.5712a2.1893 2.1893 0 0 0 .0876-.6133c0-.238-.0346-.463-.1038-.675-.0692-.212-.1709-.397-.305-.5549-.1341-.1579-.2996-.2823-.4965-.3732-.1969-.0909-.423-.1363-.6782-.1363-.3115 0-.5971.0606-.8567.1817-.2596.1212-.4933.2845-.701.49s-.3883.4413-.5419.7075a4.874 4.874 0 0 0-.3829.8373 5.6168 5.6168 0 0 0-.2304.8859c-.0519.2986-.0779.5798-.0779.8438 0 .2683.0281.5452.0844.8308s.1385.5668.2466.8438c.1082.2769.2423.5387.4024.7853.1601.2466.3451.463.5549.649a2.583 2.583 0 0 0 .701.4446c.2575.1103.5376.1655.8405.1655.2077 0 .41-.0281.6069-.0844a2.9874 2.9874 0 0 0 .5679-.2272 3.2094 3.2094 0 0 0 .516-.3375 3.9668 3.9668 0 0 0 .4511-.4219l.2142.2077c-.1904.251-.4165.4922-.6782.7237a5.5434 5.5434 0 0 1-.847.6166 4.6241 4.6241 0 0 1-.9508.4284c-.331.106-.6588.159-.9833.159-.3159 0-.6133-.0552-.8924-.1655-.2791-.1103-.5355-.2596-.7691-.4478s-.4424-.4089-.6263-.662c-.1839-.2531-.3397-.5225-.4673-.8081s-.225-.5798-.2921-.8827-.101-.5992-.101-.8891c0-.4197.0703-.8513.2109-1.2948s.3343-.874.5809-1.2916.5376-.8124.873-1.1845c.3353-.3721.6966-.6967 1.0839-.9736z",source:"https://github.com/simple-icons/simple-icons/issues/4983#issuecomment-796736373",hex:"A30701",guidelines:void 0,license:void 0},siCivicrm={title:"CiviCRM",slug:"civicrm",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>CiviCRM</title><path d="'+this.path+'"/></svg>'},path:"M22.565 9.054c.248-.477.45-1.125.235-1.786-.25-.766-.939-1.275-2.051-1.511l-7.052-1.5L6.496.405C6.418.363 5.717 0 4.951 0 4.38 0 3.888.198 3.527.571c-.337.349-.539.834-.603 1.444a3.184 3.184 0 0 0-.199-.006c-1.089 0-1.648.456-1.926.839C.369 3.44.315 4.241.638 5.23l2.649 8.118.251 7.033c.044 1.222.719 2.536 2.098 2.537.264 0 .537-.051.82-.15.328.556.92 1.232 1.864 1.232.666 0 1.324-.357 1.956-1.063l5.11-5.697 6.783-4.283c.147-.094 1.444-.95 1.398-2.229-.022-.642-.362-1.202-1.002-1.674zM7.396 20.166l-2.328-7.134-.316-8.847 8.326 1.771 6.771 3.622-5.63 6.279-6.823 4.309zM20.377 7.51c.545.116.709.279.72.313.021.063-.017.196-.087.344l-1.623-.868.99.211zM4.951 1.792c.269 0 .607.145.7.193l1.738.929-2.693-.573c.013-.323.08-.484.12-.526.012-.011.062-.023.135-.023zm-2.61 2.882c-.195-.595-.093-.773-.092-.774.019-.026.167-.099.476-.099.083 0 .159.005.221.011l.109 3.05-.714-2.188zm2.988 15.642l-.029-.798.514 1.574a.68.68 0 0 1-.178.034c-.146 0-.293-.5-.307-.81zm3.614 1.424c-.414.463-.62.468-.622.468-.058 0-.185-.132-.301-.317l1.818-1.148-.895.997zm12.27-10.299l-1.445.913 1.695-1.89c.249.174.313.298.314.329.006.133-.287.468-.564.648z",source:"https://civicrm.org/trademark",hex:"81C459",guidelines:void 0,license:void 0},siCivo={title:"Civo",slug:"civo",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Civo</title><path d="'+this.path+'"/></svg>'},path:"M9.229 7.985h-.993c-.183 0-.303.14-.303.318v7.393c0 .177.12.318.303.318h.993a.318.318 0 0 0 .323-.318V8.303a.317.317 0 0 0-.323-.318m-3.1 5.838a.32.32 0 0 0-.507-.104 2.34 2.34 0 0 1-1.604.635c-1.627 0-2.868-1.65-2.141-3.368a2.128 2.128 0 0 1 1.13-1.128c.992-.42 1.958-.18 2.599.408a.32.32 0 0 0 .507-.103l.43-.943a.353.353 0 0 0-.111-.428C5.425 8.03 4.05 7.732 2.617 8.22a3.838 3.838 0 0 0-2.412 2.478c-.874 2.772 1.172 5.32 3.813 5.32.92 0 1.764-.31 2.44-.831a.348.348 0 0 0 .101-.42zm17.666-3.125a3.838 3.838 0 0 0-2.412-2.478 4.176 4.176 0 0 0-2.329-.13c-1.2.269-2.07.838-2.834 2.479l-1.534 3.326-2.603-5.722a.32.32 0 0 0-.29-.187l-1.138-.002a.32.32 0 0 0-.292.453l3.376 7.382a.324.324 0 0 0 .291.19l.056.005h1.276a.236.236 0 0 0 .076-.013.335.335 0 0 0 .2-.18l1.71-3.893c.515-1.213.827-1.718 1.643-2.065a2.527 2.527 0 0 1 2.054.026c.492.222.878.629 1.084 1.128a2.701 2.701 0 0 1 .206.95 2.354 2.354 0 0 1-2.353 2.387 2.34 2.34 0 0 1-1.604-.635.32.32 0 0 0-.507.104l-.43.944a.348.348 0 0 0 .1.42c.677.52 1.522.831 2.44.831 2.642 0 4.688-2.548 3.814-5.32",source:"https://www.civo.com/brand-assets",hex:"239DFF",guidelines:"https://www.civo.com/brand-assets",license:void 0},siCkeditor4={title:"CKEditor 4",slug:"ckeditor4",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>CKEditor 4</title><path d="'+this.path+'"/></svg>'},path:"M16.1237 3.7468a4.5092 4.5092 0 0 0-.469 2.009c0 2.5006 2.0271 4.5278 4.5278 4.5278a4.447 4.447 0 0 0 .0967-.001v6.3413a2.1307 2.1307 0 0 1-1.0654 1.8453l-8.0089 4.6239a2.1307 2.1307 0 0 1-2.1307 0l-8.0088-4.624A2.1307 2.1307 0 0 1 0 16.624V7.3761c0-.7613.4061-1.4647 1.0654-1.8453L9.0742.907a2.1307 2.1307 0 0 1 2.1307 0zM5.733 7.9753a.5327.5327 0 0 0-.5327.5327v.2542c0 .2942.2385.5327.5327.5327h8.9963a.5327.5327 0 0 0 .5327-.5327V8.508a.5327.5327 0 0 0-.5327-.5327zm0 3.281a.5327.5327 0 0 0-.5327.5326v.2542c0 .2942.2385.5327.5327.5327h6.5221a.5327.5327 0 0 0 .5327-.5327v-.2542a.5327.5327 0 0 0-.5327-.5327zm0 3.2809a.5327.5327 0 0 0-.5327.5327v.2542c0 .2942.2385.5326.5327.5326h8.9963a.5327.5327 0 0 0 .5327-.5326v-.2542a.5327.5327 0 0 0-.5327-.5327zm14.5383-5.1414c-2.0593 0-3.7287-1.6694-3.7287-3.7288 0-2.0593 1.6694-3.7287 3.7287-3.7287S24 3.6077 24 5.667c0 2.0594-1.6694 3.7288-3.7288 3.7288zm.6347-2.7825h.393v-.5904h-.397V4.139h-.8144l-1.1668 1.8623v.612H20.27v.5991h.636zm-.632-1.7277v1.1373h-.6928l.6807-1.1373Z",source:"https://github.com/ckeditor/ckeditor4/blob/7d8305ce4d12683853a563b9d6ea54e0d4686a2f/samples/img/logo.svg",hex:"0287D0",guidelines:void 0,license:void 0},siClaris={title:"Claris",slug:"claris",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Claris</title><path d="'+this.path+'"/></svg>'},path:"M11.56 0a3.34 3.34 0 00-.57.043L22.947 12 10.99 23.957c.132.022.307.043.57.043 6.626 0 12-5.375 12-12s-5.374-12-12-12zm-1.535 2.414C4.738 2.414.44 6.713.44 12s4.3 9.588 9.586 9.588c.264 0 .44-.023.57-.045L1.054 12l9.543-9.543a3.337 3.337 0 00-.57-.043zm.746 2.457c-.263 0-.438.021-.57.043L17.287 12l-7.086 7.086c.132.022.307.045.57.045 3.927 0 7.13-3.204 7.13-7.131s-3.203-7.129-7.13-7.129zm-.416 2.434A4.701 4.701 0 005.66 12a4.701 4.701 0 004.695 4.695c.264 0 .44-.023.57-.045L6.274 12l4.653-4.65a3.296 3.296 0 00-.57-.045Z",source:"https://www.claris.com/",hex:"000000",guidelines:void 0,license:void 0},siChainlink={title:"Chainlink",slug:"chainlink",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Chainlink</title><path d="'+this.path+'"/></svg>'},path:"M12 0L9.798 1.266l-6 3.468L1.596 6v12l2.202 1.266 6.055 3.468L12.055 24l2.202-1.266 5.945-3.468L22.404 18V6l-2.202-1.266-6-3.468zM6 15.468V8.532l6-3.468 6 3.468v6.936l-6 3.468z",source:"https://chain.link/brand-assets",hex:"375BD2",guidelines:void 0,license:void 0},siClickup={title:"ClickUp",slug:"clickup",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>ClickUp</title><path d="'+this.path+'"/></svg>'},path:"M2 18.439l3.69-2.828c1.961 2.56 4.044 3.739 6.363 3.739 2.307 0 4.33-1.166 6.203-3.704L22 18.405C19.298 22.065 15.941 24 12.053 24 8.178 24 4.788 22.078 2 18.439zM12.04 6.15l-6.568 5.66-3.036-3.52L12.055 0l9.543 8.296-3.05 3.509z",source:"https://clickup.com/brand",hex:"7B68EE",guidelines:void 0,license:void 0},siClion={title:"CLion",slug:"clion",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>CLion</title><path d="'+this.path+'"/></svg>'},path:"M0 0v24h24V0H0zm7.041 3a5.049 5.049 0 0 1 .219 0c1.86 0 3 .6 3.9 1.56L9.78 6.18C9 5.46 8.22 5.04 7.26 5.04c-1.68 0-2.88 1.38-2.88 3.12 0 1.68 1.2 3.12 2.88 3.12 1.14 0 1.86-.48 2.64-1.14l1.38 1.38c-1.02 1.08-2.16 1.8-4.08 1.8a5.1 5.1 0 0 1-5.1-5.16A5.049 5.049 0 0 1 7.04 3zm5.738.12H15v8.1h4.32v1.86h-6.54V3.12zM2.28 19.5h9V21h-9v-1.5Z",source:"https://www.jetbrains.com/company/brand/logos/",hex:"000000",guidelines:"https://www.jetbrains.com/company/brand/",license:void 0},siClockify={title:"Clockify",slug:"clockify",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Clockify</title><path d="'+this.path+'"/></svg>'},path:"M13.3512 20.4035c1.1108 0 2.169-.2217 3.139-.6157l2.6913 2.6944C17.4555 23.4458 15.4688 24 13.3512 24 6.729 24 1.3594 18.627 1.3594 12.0006 1.3594 5.3729 6.7289 0 13.3512 0c2.0964 0 4.0652.5406 5.7789 1.4865L16.4834 4.136c-.9687-.3918-2.0236-.6134-3.1322-.6134-4.6379 0-8.3976 3.779-8.3976 8.441 0 4.6609 3.7597 8.4399 8.3976 8.4399zm2.176-12.1544l5.5104-5.5139 1.5773 1.5772-5.5104 5.514zm-2.2328 5.6348c-1.0784 0-1.952-.8775-1.952-1.961 0-1.0825.8736-1.9611 1.952-1.9611 1.0784 0 1.952.8786 1.952 1.961 0 1.0836-.8736 1.9611-1.952 1.9611zm9.3462 5.6953l-1.5772 1.5783-5.5105-5.514 1.5774-1.5783z",source:"https://clockify.me/brand-assets",hex:"03A9F4",guidelines:void 0,license:void 0},siCliqz={title:"Cliqz",slug:"cliqz",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Cliqz</title><path d="'+this.path+'"/></svg>'},path:"M19.387 18.146l4.19-1.402L12 12.027l4.716 11.578 1.403-4.19 3.917 3.917 1.268-1.268zm-7.387 1c.035 0 .07-.004.105-.004l1.908 4.686c-.654.11-1.326.172-2.013.172-6.617 0-12-5.383-12-12S5.383 0 12 0s12 5.383 12 12c0 .695-.063 1.376-.177 2.04l-4.683-1.908c0-.044.006-.087.006-.133A7.153 7.153 0 0 0 12 4.854a7.155 7.154 0 0 0-7.147 7.145A7.155 7.154 0 0 0 12 19.146z",source:"https://cliqz.com/design",hex:"00AEF0",guidelines:void 0,license:void 0},siCloud66={title:"Cloud 66",slug:"cloud66",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Cloud 66</title><path d="'+this.path+'"/></svg>'},path:"M11.985.317C7.0865 2.716 2.9666.4233 2.9666.4233 1.1064 3.486.216 6.1747 0 8.5272h23.9992c-.2165-2.3514-1.1074-5.0365-2.9665-8.0966 0 0-4.119 2.2905-9.0185-.1073zM5.2196 3.5273c.424 0 .7456.0853.8906.1594l-.1666.6417a1.7877 1.7877 0 0 0-.6865-.1334c-.6485 0-1.152.3871-1.152 1.1823 0 .7157.4282 1.1666 1.1572 1.1666.2464 0 .5202-.0537.6813-.1166l.124.6312c-.1505.0747-.4882.1594-.9282.1594-1.248 0-1.8916-.7751-1.8916-1.7927 0-1.2197.879-1.8979 1.9718-1.8979zm6.3144 0c1.1093 0 1.7145.8217 1.7145 1.8083 0 1.1717-.7179 1.8823-1.7739 1.8823-1.072 0-1.6989-.8006-1.6989-1.8187 0-1.071.6917-1.8719 1.7583-1.8719zm7.8091.0323c.6859 0 1.131.1226 1.4792.3823.3754.2757.6114.7149.6114 1.3458 0 .6837-.2517 1.1562-.6 1.4479-.3808.3125-.9594.4604-1.6666.4604-.424 0-.7244-.026-.928-.0521V3.6336c.2996-.048.6913-.074 1.104-.074zM7.003 3.5867h.8198v2.8947H9.258v.6781H7.003zm7.1779 0h.8208V5.643c0 .615.235.9281.6531.9281.4293 0 .6646-.2972.6646-.928V3.5866h.8156v2.003c0 1.103-.5638 1.6282-1.5073 1.6282-.9109 0-1.4468-.4988-1.4468-1.6385zm-2.6718.5823c-.5504 0-.8708.5212-.8708 1.2166 0 .7013.332 1.1958.877 1.1958.55 0 .8646-.5212.8646-1.2166 0-.6432-.3097-1.1958-.8708-1.1958zm7.9206.0104c-.1824 0-.301.0163-.3708.0323v2.3437c.0698.016.1825.0156.2843.0156.7398.0053 1.2219-.3987 1.2219-1.2541.0053-.744-.4336-1.1375-1.1354-1.1375zM.0052 9.7886c-.281 10.276 11.9798 13.8881 11.9798 13.8881l.0292.0063S24.281 20.0688 23.9951 9.7886h-.001zm10.7684 1.2802a5.5849 5.5849 0 0 1 .326.0083v1.4125c-.2117 0-.4367 0-.7364.024-1.6853.1333-2.434.967-2.6457 1.8842h.0375c.3989-.3983.9613-.628 1.7228-.628 1.36 0 2.5083.93 2.5083 2.5603 0 1.5583-1.2358 2.8384-2.9958 2.8384-2.1588 0-3.2196-1.557-3.2196-3.429 0-1.4736.5618-2.706 1.4353-3.4916.8112-.7125 1.8592-1.099 3.1322-1.1593a5.5849 5.5849 0 0 1 .4354-.0198zm6.9269 0a5.5849 5.5849 0 0 1 .327.0083v1.4125c-.2117 0-.4367 0-.7364.024-1.6853.1333-2.434.967-2.6457 1.8842h.0375c.3989-.3983.9613-.628 1.7228-.628 1.36 0 2.5072.93 2.5072 2.5603 0 1.5583-1.2352 2.8384-2.9947 2.8384-2.1593 0-3.2196-1.557-3.2196-3.429 0-1.4736.5618-2.706 1.4353-3.4916.8112-.7125 1.8592-1.099 3.1322-1.1593a5.5849 5.5849 0 0 1 .4344-.0198zm-8.8477 4.0061c-.512 0-.9356.301-1.1228.7-.0496.096-.075.2423-.075.4593.0373.8336.449 1.5823 1.3103 1.5823h.0125c.6614 0 1.0854-.5928 1.0854-1.3896 0-.7253-.3992-1.352-1.2104-1.352zm6.928 0c-.512 0-.9357.301-1.123.7-.0495.096-.075.2423-.075.4593.0374.8336.4491 1.5823 1.3105 1.5823h.0125c.6613 0 1.0853-.5928 1.0853-1.3896 0-.7253-.3992-1.352-1.2103-1.352Z",source:"https://www.cloud66.com/",hex:"3C72B9",guidelines:void 0,license:void 0},siClojure={title:"Clojure",slug:"clojure",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Clojure</title><path d="'+this.path+'"/></svg>'},path:"M11.503 12.216c-.119.259-.251.549-.387.858-.482 1.092-1.016 2.42-1.21 3.271a4.91 4.91 0 0 0-.112 1.096c0 .164.009.337.022.514.682.25 1.417.388 2.186.39a6.39 6.39 0 0 0 2.001-.326 3.808 3.808 0 0 1-.418-.441c-.854-1.089-1.329-2.682-2.082-5.362M8.355 6.813A6.347 6.347 0 0 0 5.657 12a6.347 6.347 0 0 0 2.625 5.134c.39-1.622 1.366-3.107 2.83-6.084-.087-.239-.186-.5-.297-.775-.406-1.018-.991-2.198-1.513-2.733a4.272 4.272 0 0 0-.947-.729M17.527 19.277c-.84-.105-1.533-.232-2.141-.446A7.625 7.625 0 0 1 4.376 12a7.6 7.6 0 0 1 2.6-5.73 5.582 5.582 0 0 0-1.324-.162c-2.236.02-4.597 1.258-5.58 4.602-.092.486-.07.854-.07 1.29 0 6.627 5.373 12 12 12 4.059 0 7.643-2.017 9.815-5.101-1.174.293-2.305.433-3.271.436-.362 0-.702-.02-1.019-.058M15.273 16.952c.074.036.242.097.475.163a6.354 6.354 0 0 0 2.6-5.115h-.002a6.354 6.354 0 0 0-6.345-6.345 6.338 6.338 0 0 0-1.992.324c1.289 1.468 1.908 3.566 2.507 5.862l.001.003c.001.002.192.637.518 1.48.326.842.789 1.885 1.293 2.645.332.51.697.876.945.983M12.001 0a11.98 11.98 0 0 0-9.752 5.013c1.134-.71 2.291-.967 3.301-.957 1.394.004 2.491.436 3.017.732.127.073.248.152.366.233A7.625 7.625 0 0 1 19.625 12a7.605 7.605 0 0 1-2.268 5.425c.344.038.709.063 1.084.061 1.328 0 2.766-.293 3.842-1.198.703-.592 1.291-1.458 1.617-2.757.065-.502.1-1.012.1-1.531 0-6.627-5.371-12-11.999-12",source:"https://commons.wikimedia.org/wiki/File:Clojure_logo.svg",hex:"5881D8",guidelines:void 0,license:void 0},siCloudfoundry={title:"Cloud Foundry",slug:"cloudfoundry",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Cloud Foundry</title><path d="'+this.path+'"/></svg>'},path:"M12.854 13.537c-.048 1.79.074 3.862.149 4.917.96.136 1.633.456 1.633.83 0 .497-1.193 1.07-2.665 1.07s-2.665-.573-2.665-1.07c0-.374.673-.694 1.633-.83.075-1.055.197-3.127.15-4.917-.044-1.613-.779-3.091-1.676-3.821-.725-.59-1.174-1.427-1.166-2.354.016-1.765 1.683-3.186 3.724-3.186s3.708 1.42 3.723 3.186c.008.927-.44 1.763-1.165 2.354-.897.73-1.632 2.208-1.675 3.821zm6.214 6.596c.287-.115.612-.177.951-.19-.007-.24-.166-.672-.303-.877-.56-.1-1.276-.313-1.658-.682a.48.48 0 0 1-.186-.41c.026-.146.133-.253.278-.329a8.115 8.115 0 0 0-1.08-.515 4.6 4.6 0 0 1-1.697-.124c-.303-.09-.764-.24-.82-.549-.16-.03-.54-.083-.766-.112a4.048 4.048 0 0 0-.07.31.815.815 0 0 0 .56.956c1 .291 1.756.77 1.974 1.359.44 1.19-1.413 2.353-4.231 2.353-2.82 0-4.673-1.163-4.233-2.353.213-.574.94-1.044 1.903-1.337a.863.863 0 0 0 .589-1.005l-.06-.283c-.291.03-.779.101-1.031.148-.019.313-.476.466-.76.564a4.65 4.65 0 0 1-1.708.147 7.82 7.82 0 0 0-1.052.535c.544.23.316.736-.09.97-.407.253-.842.409-1.38.51-.051.088-.111.298-.163.438-.016.136-.063.367-.053.459.645.02 1.268.152 1.62.605.281.508-.024.976-.51 1.364.392.316.986.673 1.45.868a4.82 4.82 0 0 1 2.715-.269c.718.16 1.506.581 1.742 1.289.635.042 1.895.04 2.528-.041.182-.731.907-1.147 1.606-1.326a4.803 4.803 0 0 1 2.712.193c.356-.18 1.03-.602 1.306-.9-.474-.358-.873-.794-.63-1.325.085-.19.301-.33.547-.44zm-9.54-5.848s.418-1.586-1.4-3.632A4.99 4.99 0 0 1 6.88 7.346a5.05 5.05 0 0 1 5.047-5.04c2.822-.065 5.168 2.218 5.164 5.04a4.984 4.984 0 0 1-1.248 3.306c-1.614 1.616-1.4 3.633-1.4 3.633a7.352 7.352 0 0 0 4.956-6.898c.035-4.021-3.39-7.47-7.414-7.385-4.027-.083-7.447 3.364-7.413 7.385a7.352 7.352 0 0 0 4.956 6.898z",source:"https://www.cloudfoundry.org/",hex:"0C9ED5",guidelines:"https://www.cloudfoundry.org/logo/",license:void 0},siCloudcannon={title:"CloudCannon",slug:"cloudcannon",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>CloudCannon</title><path d="'+this.path+'"/></svg>'},path:"M20.686 7.602c.321-1.964-1.203-3.778-3.21-3.778-.91 0-1.733.376-2.325.977a1.132 1.132 0 0 0-1.061-.744c-.63 0-1.141.51-1.141 1.14s.429.909 1.34 1.335a5.884 5.884 0 0 1 .813.46c.275.184.534.388.776.612A6.02 6.02 0 0 1 17.796 12a6.02 6.02 0 0 1-2.694 5.008 6.16 6.16 0 0 1-.813.46c-.911.427-1.34.704-1.34 1.335 0 .63.51 1.141 1.14 1.141.492 0 .9-.312 1.062-.744.592.6 1.414.976 2.325.976 2.025 0 3.527-1.81 3.21-3.778C22.61 15.842 24 14.026 24 12.001c0-2.038-1.382-3.837-3.314-4.399zM9.711 17.468a6.193 6.193 0 0 1-1.589-1.073A6.02 6.02 0 0 1 6.204 12a6.02 6.02 0 0 1 1.918-4.395 6.22 6.22 0 0 1 1.589-1.072c.91-.427 1.34-.704 1.34-1.335s-.51-1.141-1.14-1.141c-.492 0-.9.312-1.062.744a3.257 3.257 0 0 0-2.325-.976c-2.003 0-3.536 1.807-3.21 3.778C1.381 8.164 0 9.962 0 12c0 2.028 1.38 3.836 3.314 4.397-.323 1.954 1.198 3.778 3.21 3.778.91 0 1.733-.375 2.325-.976.162.432.57.744 1.061.744.63 0 1.141-.51 1.141-1.14 0-.631-.429-.909-1.34-1.335zM12 8.443a3.557 3.557 0 1 1 0 7.114 3.557 3.557 0 0 1 0-7.114z",source:"https://cloudcannon.com/",hex:"407AFC",guidelines:void 0,license:void 0},siCloudbees={title:"CloudBees",slug:"cloudbees",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>CloudBees</title><path d="'+this.path+'"/></svg>'},path:"M6.87.283C3.081.283 0 3.32 0 7.05c0 3.732 3.082 6.767 6.87 6.767h2.429v-3.495h-2.43c-1.83 0-3.319-1.468-3.319-3.272 0-1.804 1.488-3.27 3.32-3.27.734 0 1.377.19 1.928.567l2.51-2.473C10.06.814 8.58.284 6.87.284zm5.152 2.231c-.066-.005-.141.08-.35.252a.457.457 0 0 0-.028.026L9.722 4.674c-.323.315-.29.203-.066.556a3.204 3.204 0 0 1 .532 1.749v9.991c0 3.73 3.096 6.747 6.908 6.747C20.907 23.717 24 20.7 24 16.97c0-3.728-3.093-6.75-6.904-6.75H13.76V6.979c0-1.495-.512-3.002-1.436-4.158-.175-.203-.234-.3-.3-.307zm5.246 11.209c1.762.088 3.168 1.502 3.168 3.247 0 1.802-1.5 3.264-3.342 3.264s-3.335-1.477-3.335-3.28v-3.219h3.509z",source:"https://www.cloudbees.com/",hex:"1997B5",guidelines:void 0,license:void 0},siCloudera={title:"Cloudera",slug:"cloudera",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Cloudera</title><path d="'+this.path+'"/></svg>'},path:"M12 0C5.373 0 0 5.373 0 12s5.373 12 12 12 12-5.373 12-12S18.627 0 12 0zm.344 20.251a8.25 8.25 0 1 1 0-16.502 8.21 8.21 0 0 1 5.633 2.234L15.519 8.53a4.686 4.686 0 0 0-3.175-1.239 4.709 4.709 0 1 0 3.284 8.081l2.657 2.346a8.224 8.224 0 0 1-5.941 2.533z",source:"https://www.cloudera.com/",hex:"F96702",guidelines:void 0,license:void 0},siCloudflare={title:"Cloudflare",slug:"cloudflare",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Cloudflare</title><path d="'+this.path+'"/></svg>'},path:"M16.5088 16.8447c.1475-.5068.0908-.9707-.1553-1.3154-.2246-.3164-.6045-.499-1.0615-.5205l-8.6592-.1123a.1559.1559 0 0 1-.1333-.0713c-.0283-.042-.0351-.0986-.021-.1553.0278-.084.1123-.1484.2036-.1562l8.7359-.1123c1.0351-.0489 2.1601-.8868 2.5537-1.9136l.499-1.3013c.0215-.0561.0293-.1128.0147-.168-.5625-2.5463-2.835-4.4453-5.5499-4.4453-2.5039 0-4.6284 1.6177-5.3876 3.8614-.4927-.3658-1.1187-.5625-1.794-.499-1.2026.119-2.1665 1.083-2.2861 2.2856-.0283.31-.0069.6128.0635.894C1.5683 13.171 0 14.7754 0 16.752c0 .1748.0142.3515.0352.5273.0141.083.0844.1475.1689.1475h15.9814c.0909 0 .1758-.0645.2032-.1553l.12-.4268zm2.7568-5.5634c-.0771 0-.1611 0-.2383.0112-.0566 0-.1054.0415-.127.0976l-.3378 1.1744c-.1475.5068-.0918.9707.1543 1.3164.2256.3164.6055.498 1.0625.5195l1.8437.1133c.0557 0 .1055.0263.1329.0703.0283.043.0351.1074.0214.1562-.0283.084-.1132.1485-.204.1553l-1.921.1123c-1.041.0488-2.1582.8867-2.5527 1.914l-.1406.3585c-.0283.0713.0215.1416.0986.1416h6.5977c.0771 0 .1474-.0489.169-.126.1122-.4082.1757-.837.1757-1.2803 0-2.6025-2.125-4.727-4.7344-4.727",source:"https://www.cloudflare.com/logo/",hex:"F38020",guidelines:void 0,license:void 0},siCloudsmith={title:"Cloudsmith",slug:"cloudsmith",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Cloudsmith</title><path d="'+this.path+'"/></svg>'},path:"M16.15 0a4.146 4.146 0 0 0-2.94 1.225c-.981.98-1.34 2.288-1.177 3.53-.458 2.548-2.843 2.908-3.889 2.94-1.176-.098-2.352.327-3.235 1.21a4.142 4.142 0 0 0 0 5.88 4.142 4.142 0 0 0 5.882 0A4.136 4.136 0 0 0 12 12.108v-.23c.097-3.104 2.777-3.529 3.92-3.561h.523c.98-.066 1.928-.458 2.647-1.21a4.142 4.142 0 0 0 0-5.88A4.146 4.146 0 0 0 16.15 0zm-.327 15.7a4.15 4.15 0 0 0-4.15 4.15 4.15 4.15 0 0 0 4.15 4.15 4.15 4.15 0 0 0 4.15-4.15 4.15 4.15 0 0 0-4.15-4.15z",source:"https://cloudsmith.io/branding/",hex:"187EB6",guidelines:void 0,license:void 0},siCloudways={title:"Cloudways",slug:"cloudways",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Cloudways</title><path d="'+this.path+'"/></svg>'},path:"M15.795 5.522a4.938 4.938 0 0 0-2.485.717.434.434 0 0 1-.236.066c-2.717-.002-5.434-.002-8.151-.002a.594.594 0 0 0-.594.45.573.573 0 0 0 .284.66c.112.056.25.082.377.082 2.25.005 4.499.003 6.749.004.044 0 .09.003.152.006l-.09.13a4.942 4.942 0 0 0-.674 1.302c-.03.09-.075.113-.166.113-2.545-.003-4.844-.003-7.193-.002a.602.602 0 0 0-.581.456.584.584 0 0 0 .312.668.875.875 0 0 0 .35.069c1.924.004 3.848.003 5.771.003h.123a.22.22 0 0 1-.074.085c-.5.367-.908.819-1.218 1.356-.046.08-.095.109-.188.109a5042.02 5042.02 0 0 0-7.687-.002.598.598 0 0 0-.566.706c.06.3.3.49.624.49h7.304a5.091 5.091 0 0 0-.074 1.567H7.27c-.233 0-.357.117-.364.349a7.604 7.604 0 0 0 0 .474c.006.236.132.354.37.355.269.001.538.003.807-.001.075-.002.112.023.142.092.186.428.439.816.75 1.165.082.092.168.18.274.292h-5.01a.602.602 0 0 0-.574.48.585.585 0 0 0 .35.664.841.841 0 0 0 .305.051c5.458.004 10.345.01 15.371-.018a4.032 4.032 0 0 0 1.121-.172c2.333-.688 3.704-3.159 3.006-5.566-.434-1.496-1.413-2.504-2.888-3.02-.067-.024-.095-.054-.108-.124a4.072 4.072 0 0 0-.098-.39c-.645-2.184-2.653-3.712-4.929-3.664zM.758 14.556a.31.31 0 0 0-.323.315c-.004.158-.002.316-.002.474.001.274.119.388.396.388h4.163c.203 0 .351-.125.357-.306a9.126 9.126 0 0 0 0-.544c-.006-.192-.14-.327-.327-.327H.758z",source:"https://www.cloudways.com/en/media-kit.php",hex:"2C39BD",guidelines:void 0,license:void 0},siClyp={title:"Clyp",slug:"clyp",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Clyp</title><path d="'+this.path+'"/></svg>'},path:"M11.9995 17.9583a1.137 1.137 0 01-1.137-1.136V7.2347a1.138 1.138 0 012.275 0v9.5896c0 .626-.51 1.134-1.138 1.134m7.4397 2.4398a1.137 1.137 0 01-1.14-1.1379V4.7958a1.138 1.138 0 012.276 0v14.4654c0 .627-.51 1.136-1.138 1.136M15.7193 24a1.137 1.137 0 01-1.138-1.136V1.138a1.138 1.138 0 012.276 0v21.726c0 .627-.509 1.136-1.138 1.136m-7.4366-3.1599a1.137 1.137 0 01-1.138-1.136V4.2979a1.138 1.138 0 012.276 0v15.4064c0 .628-.51 1.137-1.138 1.137m-3.7199-4.9889a1.137 1.137 0 01-1.138-1.135V9.2857a1.138 1.138 0 012.276 0v5.4318c0 .626-.51 1.135-1.138 1.135z",source:"https://clyp.it/",hex:"3CBDB1",guidelines:void 0,license:void 0},siCmake={title:"CMake",slug:"cmake",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>CMake</title><path d="'+this.path+'"/></svg>'},path:"M11.769.066L.067 23.206l12.76-10.843zM23.207 23.934L7.471 17.587 0 23.934zM24 23.736L12.298.463l1.719 19.24zM12.893 12.959l-5.025 4.298 5.62 2.248z",source:"https://www.kitware.com/platforms/",hex:"064F8C",guidelines:void 0,license:void 0},siClubhouse={title:"Clubhouse",slug:"clubhouse",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Clubhouse</title><path d="'+this.path+'"/></svg>'},path:"M23.184 2.654l-10.967 3.5V2.696L.39 6.47v10.025l10.2-3.258v3.441l13.41-4.275-3.634-3.55zM10.592 4.929v6.592l-8.567 2.733V7.662zm9.683.367l-1.85 3.9 2.542 2.467-8.75 2.791V7.871zM1.741 17.863c-.958 0-1.741.783-1.741 1.741 0 .959.783 1.742 1.741 1.742a1.74 1.74 0 100-3.483z",source:"https://brand.clubhouse.io/",hex:"6515DD",guidelines:"https://brand.clubhouse.io/",license:void 0},siBiolink={title:"Bio Link",slug:"biolink",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bio Link</title><path d="'+this.path+'"/></svg>'},path:"M3.95192 4.6371V2.75605c0-.26354-.14223-.39521-.42679-.39521H2.2289V5.0323h1.29624c.28456 0 .4268-.13168.4268-.3952zm0 4.2839V6.96087c0-.13696-.03158-.23187-.09482-.28456-.06324-.06324-.1739-.09482-.33197-.09482H2.2289V9.3162h1.29624c.28456 0 .4268-.13168.4268-.39521zM0 .81166h4.17323c1.33842 0 2.00763.57962 2.00763 1.73882v1.77049c0 .77986-.23714 1.2699-.71143 1.4701.47429.17917.71143.63235.71143 1.35953v1.96013c0 1.1698-.6692 1.75466-2.00763 1.75466H0Zm7.56538 0h2.24468v10.05373H7.56538zm5.66357 0h2.11829c1.32777 0 1.9917.57962 1.9917 1.73882v6.56025c0 1.1698-.66393 1.75466-1.9917 1.75466h-2.1183c-1.33832 0-2.00753-.58486-2.00753-1.75466V2.55048c0-1.1592.6692-1.73882 2.00754-1.73882zm1.84948 7.99868V2.8667c0-.26353-.13696-.3952-.41096-.3952h-.75876c-.28455 0-.42678.13167-.42678.3952v5.94364c0 .26354.14223.39521.42678.39521h.75876c.274 0 .41096-.13167.41096-.3952zm5.03262 2.02892c-.75304 0-1.3634-.61045-1.3634-1.3634V9.3879c0-.75304.61036-1.3634 1.3634-1.3634.75295 0 1.3634.61036 1.3634 1.3634v.08796c0 .75295-.61045 1.3634-1.3634 1.3634zM2.25329 21.52851h2.8928v1.65983H.00859V13.13461h2.2447zm3.66888-8.3939h2.24469v10.05373h-2.2447zm7.9241 0h2.07078v10.05373h-2.02338l-2.19727-6.02272v6.02272H9.64144V13.13461h2.03921l2.16561 6.00698zm10.15373 0-2.02338 4.96367L24 23.18834h-2.43433l-1.94439-5.09006 1.94439-4.96367zm-6.67082 10.05373V13.13461h2.24469v10.05373Z",source:"https://bio.link/",hex:"000000",guidelines:void 0,license:void 0},siBitwarden={title:"Bitwarden",slug:"bitwarden",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bitwarden</title><path d="'+this.path+'"/></svg>'},path:"M3.75 0A3.75 3.75 0 000 3.75v16.5A3.75 3.75 0 003.75 24h16.5A3.75 3.75 0 0024 20.25V3.75A3.75 3.75 0 0020.25 0zm1.36 2.92h13.8c.208 0 .388.076.54.228a.737.737 0 01.227.539v9.2c0 .687-.134 1.367-.401 2.042a7.618 7.618 0 01-.995 1.797 11.097 11.097 0 01-1.413 1.528c-.547.495-1.052.906-1.515 1.234-.464.327-.947.636-1.45.928-.503.291-.86.489-1.072.593-.212.104-.381.184-.51.24a.687.687 0 01-.31.071.688.688 0 01-.312-.072 13.784 13.784 0 01-.51-.24 20.61 20.61 0 01-1.071-.592 19.133 19.133 0 01-1.45-.928 16.457 16.457 0 01-1.515-1.234 11.11 11.11 0 01-1.414-1.528 7.617 7.617 0 01-.994-1.797 5.502 5.502 0 01-.401-2.042v-9.2c0-.208.076-.387.227-.54a.737.737 0 01.54-.227zm6.9 2.3v13.62c.95-.502 1.801-1.05 2.552-1.64 1.877-1.47 2.815-2.907 2.815-4.313V5.22Z",source:"https://github.com/bitwarden/brand/blob/6182cd64321d810c6f6255db08c2a17804d2b724/icons/icon.svg",hex:"175DDC",guidelines:void 0,license:void 0},siDatagrip={title:"DataGrip",slug:"datagrip",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>DataGrip</title><path d="'+this.path+'"/></svg>'},path:"M0 0v24h24V0Zm17.1797 2.9477a5.452 5.452 0 0 1 3.9047 1.364L19.7078 5.972a3.672 3.672 0 0 0-2.596-1.0086c-1.6 0-2.8555 1.408-2.8555 3.096v.0282c0 1.816 1.2517 3.1523 3.0117 3.1523a3.492 3.492 0 0 0 2.064-.5921V9.2234h-2.2V7.336h4.3157v4.3157a6.436 6.436 0 0 1-4.2438 1.5757c-3.096 0-5.2242-2.1797-5.2242-5.1117v-.0281a5.1 5.1 0 0 1 5.2-5.1398zm-14.7438.1718h3.8758c3.12 0 5.2805 2.1439 5.2805 4.9399v.028c0 2.8-2.1605 4.968-5.2805 4.968H2.436Zm4.075 1.9688a2.852 2.852 0 0 0-.1992.003H4.6203v6h1.6914A2.832 2.832 0 0 0 9.304 8.1235v-.036a2.852 2.852 0 0 0-2.793-2.9991Zm-4.303 14.407h9v1.5h-9z",source:"https://www.jetbrains.com/company/brand/logos/",hex:"000000",guidelines:"https://www.jetbrains.com/company/brand/",license:void 0},siConan={title:"Conan",slug:"conan",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Conan</title><path d="'+this.path+'"/></svg>'},path:"M11.709 0 0 5.534V16.76L11.984 24l4.857-2.706V9.998c.13-.084.275-.196.399-.27l.032-.017c.197-.11.329-.102.23.33v10.884l6.466-3.603V6.11L24 6.093Zm.915 2.83c.932.02 1.855.191 2.706.552 1.32.533 2.522 1.364 3.45 2.429a62.814 62.814 0 0 1-3.044 1.616c.56-.853.14-2.009-.76-2.455-.93-.648-2.093-.73-3.205-.674-1.064.175-2.258.51-2.893 1.474-.722.862-.084 2.11.914 2.408 1.2.509 2.543.38 3.806.413-.975.457-1.931.97-2.927 1.358-1.701-.176-3.585-.917-4.374-2.51-.574-1.178.215-2.572 1.319-3.14a11.426 11.426 0 0 1 3.336-1.348 9.212 9.212 0 0 1 1.672-.123Z",source:"https://conan.io/",hex:"6699CB",guidelines:void 0,license:void 0},siChartdotjs={title:"Chart.js",slug:"chartdotjs",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Chart.js</title><path d="'+this.path+'"/></svg>'},path:"M12 0L1.605 6v12L12 24l10.395-6V6zm0 1.41l9.172 5.295v10.59L12 22.59l-9.172-5.295V6.705zM5.902 8.334c-1.306 0-1.983.956-2.574 2.41v6.262L12 22.014l8.672-5.008v-5.971c-.447-.264-.894-.412-1.336-.412-4.275 0-3.97 4.885-6.717 5.8-2.748.917-3.511-8.089-6.717-8.089zm12.364.457c-2.9 0-2.137 4.732-5.342 4.732-1.63 0-2.52-1.317-3.477-1.981.148.326.3.655.442.98.467 1.068.922 2.09 1.379 2.734.228.322.455.541.644.644a.595.595 0 0 0 .549.05c.558-.187.968-.571 1.36-1.112.39-.541.74-1.228 1.154-1.916.413-.688.894-1.385 1.59-1.918.695-.534 1.607-.881 2.77-.881.465 0 .908.136 1.337.352v-.121c-.633-.849-1.348-1.563-2.406-1.563zm-6.68.152c-.868 0-1.491.82-2.076 2.06.094.055.192.106.277.167 1.06.761 1.798 1.853 3.137 1.853.678 0 1.067-.218 1.418-.585-.722-1.546-1.432-3.492-2.756-3.495Z",source:"https://www.chartjs.org/",hex:"FF6384",guidelines:void 0,license:void 0},siAngellist={title:"AngelList",slug:"angellist",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>AngelList</title><path d="'+this.path+'"/></svg>'},path:"M16.467 9.956c.736-2 1.31-3.651 1.723-4.953.412-1.302.618-2.102.618-2.399 0-.318-.069-.565-.206-.741a.683.683 0 0 0-.569-.264c-.308 0-.62.255-.94.766-.318.511-.67 1.333-1.055 2.465L14.39 9.593zm-2.192 4.434c-.473-.022-.92-.071-1.344-.148a7.126 7.126 0 0 1-1.211-.33c.175.352.332.703.47 1.055.137.352.25.698.337 1.039.264-.33.542-.63.833-.899a6.93 6.93 0 0 1 .915-.717zm-1.863-4.994l-1.78-5.143C10.17 2.945 9.813 2.09 9.56 1.69c-.253-.402-.527-.602-.824-.602a.688.688 0 0 0-.56.264c-.143.175-.215.412-.215.708 0 .506.193 1.385.577 2.638.385 1.253.962 2.895 1.731 4.928a.55.55 0 0 1 .28-.255 1.33 1.33 0 0 1 .495-.074c.066 0 .198.005.396.016.197.011.521.039.972.083zm-1.615 7.961c.186 0 .357-.085.51-.255a.81.81 0 0 0 .231-.552c0-.209-.15-.695-.453-1.46a14.623 14.623 0 0 0-1.129-2.25c-.33-.549-.654-.963-.973-1.244-.318-.28-.62-.42-.906-.42-.23 0-.486.146-.767.437-.28.291-.42.563-.42.816 0 .263.137.66.412 1.187.275.527.643 1.087 1.105 1.68.483.65.94 1.155 1.368 1.517.428.363.769.544 1.022.544zm-4.945-.395c.153.187.368.461.642.824.726 1 1.396 1.5 2.011 1.5a.874.874 0 0 0 .56-.198c.166-.132.248-.27.248-.412 0-.165-.11-.44-.33-.824-.22-.385-.522-.819-.906-1.302-.44-.56-.805-.97-1.096-1.228-.291-.258-.525-.388-.7-.388-.386 0-.74.206-1.064.618-.324.412-.486.899-.486 1.46 0 .45.112.953.338 1.507.225.555.552 1.113.98 1.673a6.543 6.543 0 0 0 2.415 2.003c.962.467 2.025.7 3.19.7 2.143 0 3.937-.799 5.382-2.398 1.445-1.599 2.167-3.601 2.167-6.008 0-.736-.055-1.321-.165-1.755-.11-.434-.29-.75-.544-.948-.45-.374-1.326-.709-2.629-1.006a18.315 18.315 0 0 0-4.08-.445c-.395 0-.675.066-.84.198-.165.132-.247.357-.247.676 0 .747.417 1.288 1.253 1.623.834.336 2.186.503 4.055.503h.675c.154 0 .278.058.371.173.093.116.157.289.19.52-.187.175-.572.376-1.154.601-.583.225-1.028.448-1.335.668a5.92 5.92 0 0 0-1.59 1.722c-.402.665-.603 1.294-.603 1.888 0 .362.085.8.256 1.31.17.511.255.827.255.948v.115l-.033.149c-.483-.033-.865-.316-1.145-.85-.28-.532-.42-1.244-.42-2.134v-.148a.912.912 0 0 1-.256.165.726.726 0 0 1-.272.05c-.099 0-.192-.009-.28-.026a2.869 2.869 0 0 1-.297-.074 2.917 2.917 0 0 1 .099.627c0 .406-.16.755-.478 1.046a1.63 1.63 0 0 1-1.137.437c-.693 0-1.396-.338-2.11-1.014-.715-.675-1.072-1.337-1.072-1.986 0-.12.014-.228.041-.321a.552.552 0 0 1 .14-.24zm11.802-6.726c.989.187 1.687.605 2.093 1.253.407.649.61 1.67.61 3.066 0 2.77-.832 5.036-2.497 6.8C16.195 23.118 14.066 24 11.473 24a8.254 8.254 0 0 1-2.976-.552 7.368 7.368 0 0 1-2.48-1.541c-.792-.726-1.385-1.492-1.78-2.3a5.58 5.58 0 0 1-.594-2.48c0-.946.203-1.676.61-2.193.406-.516 1.049-.868 1.928-1.055a8.824 8.824 0 0 1-.362-.972c-.077-.264-.116-.467-.116-.61 0-.495.261-1 .783-1.517.522-.516 1.014-.774 1.475-.774.198 0 .407.035.627.107.22.071.472.19.758.354C8.5 8.071 7.885 6.223 7.5 4.92c-.385-1.302-.577-2.2-.577-2.695 0-.681.176-1.222.528-1.623C7.802.2 8.28 0 8.885 0c1.032 0 2.34 2.308 3.923 6.923.274.791.483 1.401.626 1.83l.511-1.45C15.527 2.73 16.89.444 18.033.444c.56 0 1.008.19 1.343.569.336.379.503.887.503 1.524 0 .484-.184 1.369-.552 2.654-.368 1.286-.926 2.967-1.673 5.044",source:"https://angel.co/logo",hex:"000000",guidelines:void 0,license:void 0},siVerizon={title:"Verizon",slug:"verizon",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Verizon</title><path d="'+this.path+'"/></svg>'},path:"M18.302 0H22v.003L10.674 24H7.662L2 12h3.727l3.449 7.337z",source:"https://www.verizondigitalmedia.com/about/logo-usage/",hex:"CD040B",guidelines:void 0,license:void 0},siVfairs={title:"vFairs",slug:"vfairs",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>vFairs</title><path d="'+this.path+'"/></svg>'},path:"M22.316 5.923c-.01-.014-.027-.024-.04-.035a.412.412 0 0 0-.06-.047L12.223.061a.427.427 0 0 0-.08-.033C12.128.02 12.113.02 12.1.015a.41.41 0 0 0-.325.046l-9.992 5.78a.418.418 0 0 0-.143.141c-.015.014-.02.034-.028.05a.423.423 0 0 0-.048.191v11.56a.418.418 0 0 0 .007.05c.007.14.088.266.212.331l9.992 5.78a.555.555 0 0 0 .487 0l9.888-5.756a.437.437 0 0 0 .284-.406V6.223a.408.408 0 0 0-.119-.3zM2.45 17.015V6.99l8.665 5.012-8.665 5.012zm10.452-5.023l8.648-5.001v10.024c-2.905-1.676-5.634-3.268-8.648-5.023zm-.46-.757V1.211l8.666 5.012zm-.885 0L2.891 6.223l8.666-5.012zm0 1.535v10.024l-8.665-5.012zm.925.023l5.477 3.168 3.129 1.821-8.606 5.01Z",source:"https://www.vfairs.com/",hex:"EF4678",guidelines:void 0,license:void 0},siViadeo={title:"Viadeo",slug:"viadeo",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Viadeo</title><path d="'+this.path+'"/></svg>'},path:"M16.2888 13.8979c.361.884.5428 1.8423.5428 2.875 0 1.9315-.6593 3.6185-1.977 5.0626C13.537 23.2796 11.8417 24 9.7697 24c-2.0819 0-3.778-.7204-5.0973-2.1645-1.3177-1.4441-1.9786-3.1311-1.9786-5.0626 0-1.9142.6213-3.5747 1.8687-4.9791C5.9381 10.2439 7.6688 9.469 9.7673 9.469c.884 0 1.7018.1388 2.4536.4131-.2453.4808-.4659 1.0698-.5262 1.7035-.599-.2503-1.2425-.3759-1.9332-.3759-1.454 0-2.7015.5453-3.7416 1.6382-1.0409 1.0921-1.5614 2.4132-1.5614 3.963 0 .9996.2396 1.9315.7105 2.7948.4792.8642 1.1153 1.53 1.9249 2.0009.8096.4701 1.6936.7047 2.6602.7047.9666 0 1.8588-.2338 2.6602-.7047.8096-.47 1.454-1.1367 1.9249-2.0009.8345-1.4971.9618-3.465.2974-5.0386.4708-.0991 1.0491-.2949 1.6522-.6692zM20.3873.4285l-.0126-.0148c-.7574 1.6151-2.1586 1.9175-2.1586 1.9175-1.4013.3613-1.8924.8997-1.8924.8997-1.4013 1.416-.295 3.1344-.295 3.1344 3.0311-.6933 4.1374-3.186 4.1374-3.186-.1327 1.6815-3.7317 3.658-3.7317 3.658 1.1947 1.1726 2.3305 1.0325 3.0828.5826.9956-.59 1.475-1.8953 1.475-1.8953.966-2.8984-.6049-5.0961-.6049-5.0961zM7.0301 20.4729s.4278.0738.9123.0516c0 0 10.3286-7.021 7.6094-14.3148l-.0405-.118v.0074c.0339.4867-4.483 13.0613-8.4812 14.3738zm8.3828-15.1895C15.0486 1.4101 12.9327 0 12.9327 0c1.4897 2.5134 2.2995 4.7694 2.4816 5.3055 0-.0132-.0014-.0221-.0014-.0221z",source:"https://viadeo.journaldunet.com/",hex:"F07355",guidelines:void 0,license:void 0},siViber={title:"Viber",slug:"viber",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Viber</title><path d="'+this.path+'"/></svg>'},path:"M11.4 0C9.473.028 5.333.344 3.02 2.467 1.302 4.187.696 6.7.633 9.817.57 12.933.488 18.776 6.12 20.36h.003l-.004 2.416s-.037.977.61 1.177c.777.242 1.234-.5 1.98-1.302.407-.44.972-1.084 1.397-1.58 3.85.326 6.812-.416 7.15-.525.776-.252 5.176-.816 5.892-6.657.74-6.02-.36-9.83-2.34-11.546-.596-.55-3.006-2.3-8.375-2.323 0 0-.395-.025-1.037-.017zm.058 1.693c.545-.004.88.017.88.017 4.542.02 6.717 1.388 7.222 1.846 1.675 1.435 2.53 4.868 1.906 9.897v.002c-.604 4.878-4.174 5.184-4.832 5.395-.28.09-2.882.737-6.153.524 0 0-2.436 2.94-3.197 3.704-.12.12-.26.167-.352.144-.13-.033-.166-.188-.165-.414l.02-4.018c-4.762-1.32-4.485-6.292-4.43-8.895.054-2.604.543-4.738 1.996-6.173 1.96-1.773 5.474-2.018 7.11-2.03zm.38 2.602c-.167 0-.303.135-.304.302 0 .167.133.303.3.305 1.624.01 2.946.537 4.028 1.592 1.073 1.046 1.62 2.468 1.633 4.334.002.167.14.3.307.3.166-.002.3-.138.3-.304-.014-1.984-.618-3.596-1.816-4.764-1.19-1.16-2.692-1.753-4.447-1.765zm-3.96.695c-.19-.032-.4.005-.616.117l-.01.002c-.43.247-.816.562-1.146.932-.002.004-.006.004-.008.008-.267.323-.42.638-.46.948-.008.046-.01.093-.007.14 0 .136.022.27.065.4l.013.01c.135.48.473 1.276 1.205 2.604.42.768.903 1.5 1.446 2.186.27.344.56.673.87.984l.132.132c.31.308.64.6.984.87.686.543 1.418 1.027 2.186 1.447 1.328.733 2.126 1.07 2.604 1.206l.01.014c.13.042.265.064.402.063.046.002.092 0 .138-.008.31-.036.627-.19.948-.46.004 0 .003-.002.008-.005.37-.33.683-.72.93-1.148l.003-.01c.225-.432.15-.842-.18-1.12-.004 0-.698-.58-1.037-.83-.36-.255-.73-.492-1.113-.71-.51-.285-1.032-.106-1.248.174l-.447.564c-.23.283-.657.246-.657.246-3.12-.796-3.955-3.955-3.955-3.955s-.037-.426.248-.656l.563-.448c.277-.215.456-.737.17-1.248-.217-.383-.454-.756-.71-1.115-.25-.34-.826-1.033-.83-1.035-.137-.165-.31-.265-.502-.297zm4.49.88c-.158.002-.29.124-.3.282-.01.167.115.312.282.324 1.16.085 2.017.466 2.645 1.15.63.688.93 1.524.906 2.57-.002.168.13.306.3.31.166.003.305-.13.31-.297.025-1.175-.334-2.193-1.067-2.994-.74-.81-1.777-1.253-3.05-1.346h-.024zm.463 1.63c-.16.002-.29.127-.3.287-.008.167.12.31.288.32.523.028.875.175 1.113.422.24.245.388.62.416 1.164.01.167.15.295.318.287.167-.008.295-.15.287-.317-.03-.644-.215-1.178-.58-1.557-.367-.378-.893-.574-1.52-.607h-.018z",source:"https://www.viber.com/brand-center/",hex:"7360F2",guidelines:void 0,license:void 0},siDigitalocean={title:"DigitalOcean",slug:"digitalocean",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>DigitalOcean</title><path d="'+this.path+'"/></svg>'},path:"M12.04 0C5.408-.02.005 5.37.005 11.992h4.638c0-4.923 4.882-8.731 10.064-6.855a6.95 6.95 0 014.147 4.148c1.889 5.177-1.924 10.055-6.84 10.064v-4.61H7.391v4.623h4.61V24c7.86 0 13.967-7.588 11.397-15.83-1.115-3.59-3.985-6.446-7.575-7.575A12.8 12.8 0 0012.039 0zM7.39 19.362H3.828v3.564H7.39zm-3.563 0v-2.978H.85v2.978z",source:"https://www.digitalocean.com/press/",hex:"0080FF",guidelines:"https://www.digitalocean.com/press/",license:void 0},siVim={title:"Vim",slug:"vim",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Vim</title><path d="'+this.path+'"/></svg>'},path:"M24 11.986h-.027l-4.318-4.318 4.303-4.414V1.461l-.649-.648h-8.198l-.66.605v1.045L12.015.027V0L12 .014 11.986 0v.027l-1.29 1.291-.538-.539H2.035l-.638.692v1.885l.616.616h.72v5.31L.027 11.987H0L.014 12 0 12.014h.027l2.706 2.706v6.467l.907.523h2.322l1.857-1.904 4.166 4.166V24l.015-.014.014.014v-.028l2.51-2.509h.485c.111 0 .211-.07.25-.179l.146-.426c.028-.084.012-.172-.037-.239l1.462-1.462-.612 1.962c-.043.141.036.289.177.332.025.008.052.012.078.012h1.824c.106-.001.201-.064.243-.163l.165-.394c.025-.065.024-.138-.004-.203-.027-.065-.08-.116-.146-.142-.029-.012-.062-.019-.097-.02h-.075l.84-2.644h1.232l-1.016 3.221c-.043.141.036.289.176.332.025.008.052.012.079.012h2.002c.11 0 .207-.066.248-.17l.164-.428c.051-.138-.021-.29-.158-.341-.029-.011-.06-.017-.091-.017h-.145l1.131-3.673c.027-.082.012-.173-.039-.24l-.375-.504-.003-.005c-.051-.064-.127-.102-.209-.102h-1.436c-.071 0-.141.03-.19.081l-.4.439h-.624l-.042-.046 4.445-4.445H24L23.986 12l.014-.014zM9.838 21.139l1.579-4.509h-.501l.297-.304h1.659l-1.563 4.555h.623l-.079.258H9.838zm3.695-7.516l.15.151-.269.922-.225.226h-.969l-.181-.181.311-.871.288-.247h.895zM5.59 20.829H3.877l-.262-.15V3.091H2.379l-.1-.1V1.815l.143-.154h7.371l.213.214v1.108l-.142.173H8.785v8.688l8.807-8.688h-2.086l-.175-.188V1.805l.121-.111h7.49l.132.133v1.07L12.979 13.25h-.373c-.015-.001-.028 0-.042.001l-.02.003c-.045.01-.086.03-.119.06l-.343.295-.004.003c-.033.031-.059.069-.073.111l-.296.83-6.119 6.276zm14.768-3.952l.474-.519h1.334l.309.415-1.265 4.107h.493l-.08.209H19.84l1.124-3.564h-2.015l-1.077 3.391h.424l-.073.174h-1.605l1.107-3.548h-2.096l-1.062 3.339h.436l-.072.209H13.27l1.514-4.46H14.198l.091-.271h1.65l.519.537h.906l.491-.554h1.061l.489.535h.953z",source:"https://commons.wikimedia.org/wiki/File:Vimlogo.svg",hex:"019733",guidelines:void 0,license:void 0},siVimeo={title:"Vimeo",slug:"vimeo",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Vimeo</title><path d="'+this.path+'"/></svg>'},path:"M23.9765 6.4168c-.105 2.338-1.739 5.5429-4.894 9.6088-3.2679 4.247-6.0258 6.3699-8.2898 6.3699-1.409 0-2.578-1.294-3.553-3.881l-1.9179-7.1138c-.719-2.584-1.488-3.878-2.312-3.878-.179 0-.806.378-1.8809 1.132l-1.129-1.457a315.06 315.06 0 003.501-3.1279c1.579-1.368 2.765-2.085 3.5539-2.159 1.867-.18 3.016 1.1 3.447 3.838.465 2.953.789 4.789.971 5.5069.5389 2.45 1.1309 3.674 1.7759 3.674.502 0 1.256-.796 2.265-2.385 1.004-1.589 1.54-2.797 1.612-3.628.144-1.371-.395-2.061-1.614-2.061-.574 0-1.167.121-1.777.391 1.186-3.8679 3.434-5.7568 6.7619-5.6368 2.4729.06 3.6279 1.664 3.4929 4.7969z",source:"https://vimeo.com/about/brand_guidelines",hex:"1AB7EA",guidelines:void 0,license:void 0},siVimeolivestream={title:"Vimeo Livestream",slug:"vimeolivestream",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Vimeo Livestream</title><path d="'+this.path+'"/></svg>'},path:"M2.672 10.63c-.11 0-.21.04-.3.116-.09.077-.137.157-.14.24-.007.16.078.24.252.24a.4.4 0 0 0 .293-.125.345.345 0 0 0 .115-.23.233.233 0 0 0-.06-.16.199.199 0 0 0-.16-.08zm9.127.636v1.737c0 .327.22.365.344.365a.494.494 0 0 0 .074-.006v-.181s-.023.003-.05.003c-.077 0-.166-.03-.166-.226v-1.692zm.63 0v.253h.21v-.253zm4.693.182v.431h-.199v.17h.196v.764c0 .5.347.555.519.555a.515.515 0 0 0 .085-.006v-.181s-.026.006-.068.006c-.112 0-.335-.045-.335-.395v-.744h.374v-.17h-.373v-.43zM1.745 11.5c-.283-.01-.475.158-.575.503a.367.367 0 0 1 .15-.035c.105 0 .15.062.138.184-.006.074-.052.182-.137.324-.086.142-.15.213-.193.213-.055 0-.105-.11-.151-.328a8.209 8.209 0 0 1-.083-.492c-.036-.245-.134-.359-.293-.343-.067.007-.168.071-.303.193L0 12l.096.13a.622.622 0 0 1 .16-.101c.07 0 .136.115.197.346l.165.636c.082.23.183.346.302.346.192 0 .427-.19.705-.569.195-.264.321-.487.38-.67.077-.059.124-.09.142-.09.055 0 .082.042.082.126 0 .016-.03.135-.09.356-.059.222-.09.386-.093.492a.374.374 0 0 0 .07.25.26.26 0 0 0 .218.096c.205 0 .41-.093.615-.279l.053-.051a.395.395 0 0 0 .085.177c.088.1.237.146.447.14-.028-.071-.04-.196-.033-.376.01-.2.06-.395.147-.574.088-.183.171-.274.248-.274.089 0 .13.059.124.178-.003.08-.018.172-.045.275a1.36 1.36 0 0 0-.045.308c-.006.164.029.281.105.352.085.08.235.117.448.11a.747.747 0 0 1-.039-.317 1.38 1.38 0 0 1 .19-.608c.11-.199.205-.298.285-.298.073 0 .109.06.105.183a1.83 1.83 0 0 1-.057.337 1.848 1.848 0 0 0-.057.37c-.006.232.09.347.289.347.205 0 .41-.093.614-.279l.01-.01a.568.568 0 0 0 .022.038c.107.174.285.26.533.26.333 0 .662-.097.986-.293l.104-.065a.7.7 0 0 0 .072.122c.125.164.309.246.55.246a.95.95 0 0 0 .73-.323c.195-.215.3-.47.311-.765.01-.218-.038-.396-.142-.534-.11-.151-.272-.226-.486-.226-.333 0-.61.128-.83.384-.205.232-.3.485-.284.76 0 .021.002.04.004.06l-.034.016c-.26.118-.5.177-.72.177-.11 0-.193-.04-.248-.12a1.37 1.37 0 0 0 .739-.361c.183-.173.269-.341.257-.505-.019-.256-.178-.385-.477-.385-.325 0-.606.13-.844.386-.217.235-.328.482-.33.742a.65.65 0 0 0 .006.126c-.052.036-.09.054-.117.054-.058 0-.095-.013-.11-.039-.015-.025-.021-.072-.018-.14 0-.025.019-.123.057-.294a2.25 2.25 0 0 0 .062-.392c.006-.13-.018-.232-.073-.302-.064-.087-.17-.123-.317-.11a.663.663 0 0 0-.353.144c-.067.052-.136.12-.206.207l-.069.063a.488.488 0 0 0-.073-.304c-.065-.086-.172-.123-.321-.11a.797.797 0 0 0-.473.216.875.875 0 0 0-.16.193.472.472 0 0 0-.064-.354c-.05-.075-.114-.11-.193-.103-.046.003-.133.067-.262.192-.177.174-.273.267-.289.28l.11.13c.086-.065.138-.098.156-.098.034 0 .048.029.042.087-.003.083-.017.2-.043.348a3.95 3.95 0 0 0-.033.24l-.005.003c-.11.095-.186.143-.229.143-.098 0-.145-.069-.142-.207.046-.3.089-.549.128-.744a.42.42 0 0 0-.052-.28c-.048-.073-.122-.104-.223-.095-.064.007-.162.071-.293.193l-.137.13c-.01-.227-.108-.344-.297-.35zm13.221.301c-.403 0-.735.294-.735.785 0 .461.335.782.78.782.334 0 .551-.208.551-.208l-.092-.155s-.18.182-.453.182c-.309 0-.57-.208-.578-.592h1.144s.006-.068.006-.104c0-.372-.21-.69-.623-.69zm1.334 0c-.27 0-.51.146-.51.413 0 .488.804.408.804.735 0 .157-.14.238-.3.238a.637.637 0 0 1-.444-.182l-.11.146s.19.217.552.217c.299 0 .51-.175.51-.42 0-.493-.804-.403-.804-.734 0-.166.145-.232.297-.232.246 0 .373.137.373.137l.092-.154s-.146-.164-.46-.164zm3.2 0c-.403 0-.735.294-.735.785 0 .461.335.782.78.782.334 0 .55-.208.55-.208l-.091-.155s-.181.182-.454.182c-.308 0-.569-.208-.578-.592h1.144s.006-.068.006-.104c0-.372-.21-.69-.622-.69zm1.414 0c-.335 0-.53.17-.53.17l.094.154s.175-.143.421-.143c.214 0 .37.099.37.387v.039h-.082c-.258 0-.913.012-.913.517 0 .297.258.443.507.443.373 0 .498-.324.498-.324h.006s-.006.05-.006.125v.164h.192v-.958c0-.375-.198-.574-.557-.574zm1.575.023a.61.61 0 0 0-.54.378h-.006s.006-.053.006-.119v-.223h-.199v1.495h.202v-.707c0-.067.006-.134.02-.2.063-.228.247-.44.49-.44.281 0 .314.22.314.447v.9h.201v-.707c0-.08.006-.152.027-.217.057-.22.243-.422.471-.422.273 0 .323.202.323.446v.9H24v-.95c0-.37-.133-.58-.495-.58a.606.606 0 0 0-.548.374h-.006c-.045-.247-.187-.375-.462-.375zm-3.876.021c-.234 0-.4.172-.471.398h-.006s.006-.053.006-.118v-.265h-.199v1.495h.202v-.63a.99.99 0 0 1 .041-.291c.066-.22.223-.387.433-.387.039 0 .074.006.074.006v-.199s-.038-.009-.08-.009zm-6.179.015v1.495h.202V11.86zm.371 0l.572 1.495h.22l.569-1.495h-.211l-.412 1.097c-.03.077-.053.179-.053.179h-.006s-.024-.104-.05-.179l-.416-1.097zm-4.338.052c.048 0 .086.036.112.108a.638.638 0 0 1 .034.24.947.947 0 0 1-.133.444c-.098.17-.215.256-.353.256-.061 0-.109-.036-.142-.106a.432.432 0 0 1-.041-.213.967.967 0 0 1 .137-.464c.101-.177.23-.265.386-.265zm-1.722.056c.07 0 .103.043.1.13-.003.064-.049.147-.137.249-.108.117-.24.207-.39.264a.693.693 0 0 1 .146-.444c.096-.133.189-.199.28-.199zm8.215.003c.223 0 .412.145.424.457h-.936c.047-.3.263-.457.512-.457zm4.534 0c.222 0 .412.145.424.457h-.937c.048-.3.264-.457.513-.457zm-9.031.26c-.149 0-.223.111-.223.223 0 .111.074.222.223.222.148 0 .222-.111.222-.222 0-.112-.074-.223-.222-.223zm10.72.343h.087v.066c0 .258-.172.555-.457.555-.222 0-.332-.142-.332-.282 0-.33.469-.339.703-.339z",source:"https://livestream.com",hex:"0A0A20",guidelines:void 0,license:void 0},siVirgin={title:"Virgin",slug:"virgin",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Virgin</title><path d="'+this.path+'"/></svg>'},path:"m7.951 9.821.008-.004c.044-.06.105-.114.13-.18.04-.11.066-.228-.005-.34-.016-.026-.024-.056-.036-.084-.035-.09-.08-.118-.204-.116a.56.56 0 0 0-.281.086 3.11 3.11 0 0 0-.298.211c-.05.04-.09.092-.135.137-.06.06-.074.14-.11.21a.46.46 0 0 0-.053.222c.002.094.041.18.113.23.08.054.184.092.29.042a1.84 1.84 0 0 0 .216-.116c.133-.086.282-.156.365-.298M24 9.423c-.008-.01-.02-.02-.023-.033a.635.635 0 0 0-.173-.28.3.3 0 0 0-.123-.06c-.039-.01-.082.002-.122-.007a.986.986 0 0 0-.688.098c-.217.113-.43.233-.65.341a5.64 5.64 0 0 1-.448.192c-.106.042-.167.02-.234-.06-.009-.012-.02-.025-.032-.028-.05-.012-.05-.055-.063-.09-.005-.015-.01-.04-.017-.042-.068-.011-.046-.038-.016-.07.01-.01.015-.023.025-.038-.034-.032-.09-.05-.064-.11.002-.004-.008-.016-.015-.019-.044-.019-.024-.052-.021-.082.005-.057.006-.064.032-.088l-.052-.05.053-.094c-.046-.01-.063-.038-.036-.066.032-.031.027-.06.022-.096-.002-.016-.005-.037.003-.05.02-.03.016-.058.006-.09-.006-.02.006-.044.01-.07-.047-.019-.061-.054-.042-.104.005-.012.009-.03.004-.04-.025-.047.002-.081.019-.1-.013-.05-.03-.084-.03-.119a9.858 9.858 0 0 1 .002-.412c0-.022.02-.043.031-.066-.03-.053-.03-.053.014-.096-.014-.03-.032-.057-.037-.085-.008-.053.051-.034.07-.054-.008-.05-.02-.095-.022-.14 0-.041-.007-.082.01-.125.014-.038.002-.085.002-.131l-.046.004-.007-.149c-.002-.054.008-.1.066-.102v-.127c-.021-.032-.045-.061-.062-.094-.022-.043.013-.073.041-.107-.057-.027-.067-.073-.08-.123-.016-.063-.03-.142-.075-.18-.042-.036-.077-.085-.131-.109l-.033-.013c-.22-.099-.437-.061-.647.024-.114.046-.218.117-.326.178a.343.343 0 0 0-.07.052c-.078.075-.154.152-.23.228a1.096 1.096 0 0 0-.08.095.747.747 0 0 1-.338.244.362.362 0 0 1-.275-.01c-.066-.029-.117-.039-.179 0a.165.165 0 0 1-.093.018c-.273-.036-.497.075-.682.252a.927.927 0 0 0-.263.547c-.015.107-.015.217-.02.325-.01.179-.017.357-.026.536l-.036.682c-.007.138-.009.276-.016.413-.016.32-.035.64-.05.961a.932.932 0 0 0 .007.182c.023.16.08.25.22.279a.52.52 0 0 0 .331-.028c.088-.041.18-.077.26-.13.099-.066.219-.12.235-.26 0-.003.003-.005.004-.008.04-.07.08-.14.115-.213a.12.12 0 0 0 .013-.072c-.007-.032-.048-.055-.007-.099.019-.02 0-.07.007-.106.007-.039.022-.076.034-.118l-.061-.049.032-.03c-.068-.063-.013-.116.022-.17-.019-.021-.062-.004-.057-.05.012-.12-.027-.244.034-.36.002-.004.005-.013.003-.015-.047-.054-.004-.1.008-.153.03.038.048.006.067-.002l-.011-.068c-.01-.052.002-.11-.054-.148-.013-.008-.016-.051-.006-.07a.36.36 0 0 1 .074-.096c.03-.029.035-.057.02-.094a.758.758 0 0 1-.036-.106c-.005-.024-.011-.057 0-.075.012-.018.044-.022.066-.032v-.115l-.04-.026.026-.057c.055.009.055.009.044-.042-.001-.008-.004-.02 0-.024.045-.053.025-.117.033-.176.002-.017 0-.038.01-.049.049-.058.05-.128.056-.188.038-.034.09-.058.1-.093.022-.077.078-.12.134-.164a.213.213 0 0 0 .066-.078.387.387 0 0 1 .102-.137c.068-.054.148-.093.22-.143.11-.076.227-.039.342-.026.023.003.047.025.064.045.066.075.106.164.03.304a.358.358 0 0 0-.01.344c.102.188.009.359.026.538-.04.054-.02.109-.002.164a.066.066 0 0 1 0 .041.495.495 0 0 0-.015.327c.006.018.002.04 0 .061-.01.156-.039.31-.035.467.002.13 0 .258.005.387a.448.448 0 0 0 .118.286c.04.045.095.077.145.111.044.03.049.047.01.08a.368.368 0 0 1-.051.035c-.066.04-.132.079-.199.116l-.696.39-.996.558c-.196.11-.392.219-.586.33-.224.13-.446.264-.671.393-.031.018-.071.022-.106.034-.016.005-.034.01-.046.021a.766.766 0 0 1-.221.14c-.07.033-.14.064-.206.103-.12.073-.238.152-.357.227l-.557.343c-.236.145-.474.288-.709.435-.13.081-.255.169-.384.253-.023.015-.05.024-.082.04-.005-.033-.011-.053-.011-.072a5.868 5.868 0 0 1 0-.227 2.493 2.493 0 0 1 .01-.19c.007-.078.028-.152.013-.233-.013-.07.006-.144.01-.216.005-.051.024-.107.01-.154a.52.52 0 0 1-.013-.208 4.242 4.242 0 0 0 .024-.39c0-.046.014-.091.018-.137.008-.088.013-.176.02-.263.02-.201.042-.402.057-.603.016-.201.023-.403.037-.604.008-.115 0-.239.041-.342.044-.11-.008-.218.033-.32-.049-.108.04-.214.004-.321-.002-.005.013-.013.014-.02a.134.134 0 0 0 0-.045c-.003-.02-.014-.039-.014-.058 0-.059-.002-.119.005-.177a.354.354 0 0 0-.09-.284.361.361 0 0 0-.232-.114.701.701 0 0 0-.39.052c-.174.08-.304.197-.34.387a3.91 3.91 0 0 0-.05.427c-.017.22-.027.439-.042.658-.01.143-.025.286-.038.429-.007.08.005.163-.047.234a.025.025 0 0 0-.003.022c.034.078.01.158.005.235-.007.152-.036.303-.049.454-.022.254-.062.505-.103.756-.028.176-.08.34-.213.474a.785.785 0 0 1-.503.25.244.244 0 0 1-.252-.131.654.654 0 0 1-.082-.239c-.015-.156-.04-.314.003-.471.005-.02 0-.04 0-.061.002-.047.001-.094.005-.14a3.877 3.877 0 0 1 .026-.21c.005-.033.008-.07.024-.1.028-.056.024-.104-.002-.16a.218.218 0 0 1-.019-.126c.014-.085.019-.171.051-.254.032-.084.046-.175.072-.262a.248.248 0 0 1 .048-.103c.04-.042.047-.092.061-.142a.498.498 0 0 1 .044-.113c.03-.051.063-.104.086-.155.024-.052.04-.1.089-.134a.12.12 0 0 0 .036-.058.27.27 0 0 1 .102-.13c.029-.02.067-.038.081-.066.05-.095.123-.177.146-.286.012-.054.01-.111.027-.16a.246.246 0 0 0-.009-.182.186.186 0 0 0-.084-.086.344.344 0 0 0-.237-.023c-.164.047-.337.073-.468.198-.014.013-.037.018-.053.03-.104.083-.216.157-.308.25-.086.088-.15.195-.224.294-.166.224-.29.47-.376.733-.095.288-.133.587-.175.884-.026.188.001.382-.061.566-.01.027-.006.058-.004.088.006.063.018.126.02.19.003.114 0 .228-.001.343-.001.24-.018.48.036.718.026.115.056.23.13.323a.796.796 0 0 0 .602.307c.146.009.29-.011.431-.044.05-.011.099-.036.154-.013.012.005.033-.005.049-.012.02-.009.04-.022.06-.031.076-.031.149-.07.232-.077a.099.099 0 0 0 .039-.014c.109-.072.217-.146.326-.219.02-.013.05-.03.068-.024.016.006.028.04.03.064.003.06-.005.122.002.182a1.65 1.65 0 0 1-.003.344.099.099 0 0 1-.044.071c-.149.1-.298.2-.443.307-.217.16-.43.324-.644.485a23.486 23.486 0 0 1-.384.281c-.134.096-.27.189-.404.285-.15.11-.297.224-.448.332-.193.14-.39.274-.584.413-.047.035-.086.08-.131.118-.057.046-.117.09-.175.135a41.919 41.919 0 0 0-.255.203l-.353.282c-.142.114-.284.23-.426.343-.076.06-.155.116-.229.178-.114.098-.221.202-.336.298-.142.12-.29.232-.433.35a45.057 45.057 0 0 0-.515.432c-.15.128-.3.256-.447.388-.138.124-.271.253-.407.38-.164.152-.33.302-.494.455-.229.217-.467.425-.661.675l-.214.28a.328.328 0 0 0-.057.217.78.78 0 0 0 .079.322.493.493 0 0 0 .188.202c.154.093.32.111.495.105a.378.378 0 0 0 .257-.113c.076-.073.155-.143.23-.216.08-.075.156-.152.234-.228.019-.019.04-.036.058-.055a11.42 11.42 0 0 0 .123-.124 2.737 2.737 0 0 0 .073-.077l.204-.228c.025-.029.047-.06.074-.086l.596-.589c.045-.045.09-.092.133-.139a2.143 2.143 0 0 0 .087-.097c.028-.034.05-.072.08-.103.056-.056.116-.107.172-.163.096-.094.188-.193.288-.284.092-.085.194-.16.288-.243.042-.037.074-.083.112-.123l.246-.252c.006-.006.014-.01.021-.016.15-.12.3-.238.447-.36.21-.171.417-.346.627-.517.14-.114.285-.221.424-.335.203-.166.401-.337.605-.502.116-.095.24-.182.358-.274.116-.09.23-.184.347-.274a64.393 64.393 0 0 1 .489-.377c.157-.12.313-.24.473-.355.085-.06.176-.116.28-.155.004.027.01.047.009.066-.003.07-.01.139-.011.208-.002.208-.002.416-.002.625l-.001.79c0 .316 0 .632-.002.948 0 .056.022.117-.027.167-.007.007.002.027.003.041.003.037.009.075.008.112-.004.093-.014.186-.015.279 0 .082.012.163.014.245a7.293 7.293 0 0 1-.004.314l-.014.358c-.003.137-.003.275-.009.412-.006.152-.018.304-.023.456-.007.202-.004.404-.016.605-.016.277-.007.55.083.816.031.09.055.184.126.259a.7.7 0 0 0 .34.195c.023.005.044.015.066.023.07.021.132.02.203.015a.384.384 0 0 0 .16-.05c.077-.043.154-.085.226-.134a.523.523 0 0 0 .118-.13c.022-.03.025-.073.047-.103.023-.031.057-.054.087-.08l-.078-.045c.012-.026.022-.048.034-.07.006-.012.024-.023.022-.032-.01-.053.024-.085.06-.121-.03-.017-.074-.028-.077-.046-.01-.053-.051-.082-.077-.12l.042-.075-.05-.018c.094-.003.05-.098.1-.124-.02-.027-.06-.031-.036-.081.014-.03-.033-.06-.076-.06-.047 0-.072-.02-.073-.067l-.008-.129.058-.026-.002-.014-.065-.01c.077-.022.1-.084.127-.146a.394.394 0 0 1-.077-.256c.002-.026-.003-.06-.054-.053-.043.005-.079-.056-.064-.1.015-.043.031-.082-.01-.124l.057-.025c.025-.063-.03-.12-.011-.18-.044-.029-.047-.067-.02-.11l-.056-.006.048-.124-.1-.105c.03-.066.03-.066.006-.166l.051-.029c-.024-.026-.022-.073-.071-.07-.006 0-.014-.012-.017-.02-.026-.06-.001-.111.064-.135l-.023-.036c-.043-.069-.064-.136.015-.198.01-.008.012-.038.006-.054-.02-.064-.045-.127-.064-.18.02-.054.035-.102.056-.147.018-.04.028-.074-.003-.113-.007-.01.003-.032.005-.053l-.056-.074.08-.02c-.002-.014 0-.03-.007-.035-.022-.018-.046-.031-.069-.046 0-.037-.007-.076.003-.11.01-.032.037-.059.058-.09-.005-.054-.016-.116-.014-.178.001-.067.015-.133.022-.2 0-.009 0-.02-.005-.025-.025-.024-.023-.048-.017-.08.01-.044.008-.09.01-.136l.016-.473a.361.361 0 0 0-.016-.108c-.013-.039-.02-.075.023-.109.008-.006.009-.032.003-.042-.029-.043-.02-.093-.02-.138a2.898 2.898 0 0 1 .004-.356c.005-.052.03-.1-.005-.15-.006-.008-.003-.03.003-.04.029-.05.024-.094-.006-.14-.01-.016-.01-.039-.01-.041.021-.028.049-.058.046-.06-.06-.068-.013-.136.003-.199.015-.059.018-.108-.028-.148.007-.061.058-.117.004-.176-.005-.006.007-.033.017-.046.022-.029.045-.055.014-.092-.006-.007-.002-.023-.001-.034.006-.097.022-.194.016-.29-.005-.086.04-.123.103-.161.053-.033.119-.054.139-.125.002-.009.016-.016.026-.023.091-.064.182-.13.274-.191.202-.136.4-.276.618-.388.088-.045.162-.114.245-.168.19-.123.38-.248.575-.366.219-.133.442-.26.664-.39.26-.152.517-.307.78-.455a94.35 94.35 0 0 1 1.162-.639c.26-.14.522-.276.783-.414.208-.11.417-.22.627-.329.178-.092.355-.188.538-.27.27-.12.54-.237.817-.341.262-.1.53-.184.798-.27.226-.073.455-.134.66-.257.215-.128.399-.285.498-.522a.672.672 0 0 1 .073-.124c.005-.008.026-.006.039-.009v-.035c-.04-.05-.04-.05 0-.106zm-7.653-2.757a.408.408 0 0 0 .122.071c.098.039.208.054.3.013.154-.068.3-.16.39-.32a.385.385 0 0 1 .043-.06c.086-.1.17-.199.202-.34a.527.527 0 0 0 .014-.157c-.007-.091-.063-.15-.1-.218-.035-.005-.07-.003-.098-.014a.468.468 0 0 0-.297-.008.906.906 0 0 0-.464.294c-.158.18-.254.387-.17.64a.238.238 0 0 0 .058.1m-.54 5.139a.592.592 0 0 0 .281-.06 9.347 9.347 0 0 0 .335-.164.699.699 0 0 0 .255-.219c.05-.07.123-.136.12-.231-.002-.033.014-.067.017-.1.002-.025-.004-.05-.008-.076-.006-.033-.022-.067-.02-.1a18.424 18.424 0 0 1 .024-.497c.003-.054.015-.108.023-.161l.074.004c-.017-.023-.031-.038-.041-.054a.802.802 0 0 1-.031-.065l.105.018c-.021-.03-.027-.054-.043-.061-.054-.023-.055-.064-.054-.105.002-.042-.009-.097.017-.123.064-.063.068-.128.056-.203a.798.798 0 0 1-.01-.143c.003-.098.01-.196.014-.293 0-.005-.007-.01-.008-.016-.002-.028-.012-.058-.003-.083a.17.17 0 0 0 .003-.11.537.537 0 0 1-.005-.278c.014-.056.031-.112.043-.17.002-.008-.018-.02-.029-.033.053-.074.058-.151.064-.227.003-.04-.019-.078.011-.122a.242.242 0 0 0 .033-.13c0-.053.013-.106-.021-.161-.026-.041-.061-.084-.06-.14.003-.091-.051-.144-.156-.15-.139-.01-.278-.007-.403.058a.983.983 0 0 0-.552.773c-.005.06-.014.121-.022.181-.04.284-.082.567-.117.85-.039.319-.07.638-.107.957-.026.231-.055.463-.079.695-.015.148-.033.297-.028.444.005.179.108.284.322.295m-10.31 1.223a.328.328 0 0 1 .073-.282c.018-.02.034-.062.024-.08-.024-.04.014-.058.018-.087.006-.03-.028-.06 0-.093.01-.012.01-.033.012-.05.003-.038 0-.077.007-.113l.122-.521c.052-.223.098-.447.156-.669.047-.183.08-.372.166-.544.019-.037.025-.08.046-.116.032-.056.023-.13.081-.173.009-.007.013-.02.016-.032l.054-.206c.016-.061.028-.124.098-.152.012-.005.022-.02.027-.034.034-.076.07-.151.07-.237 0-.032-.007-.064-.002-.095.02-.126.051-.25.06-.377a.417.417 0 0 1 .06-.19c.066-.111.089-.235.114-.355.02-.094.068-.168.113-.247.018-.032.03-.054.009-.088a.087.087 0 0 1-.003-.093c.065-.126.095-.262.125-.399a2.69 2.69 0 0 1 .06-.23c.027-.088.062-.173.091-.26.03-.086.054-.173.083-.26.02-.062.037-.128.071-.183a.635.635 0 0 0 .08-.203 1.05 1.05 0 0 1 .064-.194c.055-.124.116-.247.175-.37.02-.04.045-.077.062-.117a.224.224 0 0 0 .022-.094.351.351 0 0 1 .034-.164c.084-.188.161-.379.249-.565.15-.32.256-.662.468-.953.049-.066.077-.146.12-.216a4.29 4.29 0 0 1 .439-.566c.053-.06.116-.113.176-.17.027.015.047.012.05-.015.01-.072.063-.094.121-.115.013-.005.03-.012.035-.023.019-.046.063-.082.053-.139-.002-.013.005-.03.013-.04.044-.064.092-.124.135-.188a.742.742 0 0 0 .133-.393 1.137 1.137 0 0 0-.043-.352.789.789 0 0 0-.568-.571 1.305 1.305 0 0 0-.246-.056 1.059 1.059 0 0 0-.19 0 .954.954 0 0 0-.492.27c-.13.123-.244.258-.335.416a3.677 3.677 0 0 0-.248.526 24.106 24.106 0 0 1-.146.375c-.037.094-.08.186-.116.281-.1.26-.195.52-.293.78-.093.248-.19.496-.281.745-.06.16-.112.322-.17.482L6.175 6.26c-.02.053-.033.111-.064.157-.048.073-.064.153-.085.234-.026.1-.052.203-.098.296-.077.157-.123.322-.172.488-.033.113-.037.237-.107.34-.011.015-.012.04-.012.06-.002.073.008.149-.049.21-.003.004-.003.012-.004.017l-.076.294-.132.465c-.04.146-.082.293-.119.44-.018.072-.021.147-.04.219-.027.094-.067.185-.092.28-.09.333-.175.668-.262 1.003-.012.045-.026.09-.037.137a88.407 88.407 0 0 0-.106.434c-.015.064-.031.128-.044.192-.06.298-.112.597-.177.894-.055.25-.107.501-.143.755-.035.236-.084.47-.126.705-.016.085-.03.17-.042.255l-.054.354c-.043.277-.089.553-.13.83-.026.171-.044.343-.07.513-.007.051-.03.1-.048.152-.032-.026-.058-.04-.074-.061a.137.137 0 0 1-.025-.07c-.003-.062 0-.124-.003-.185 0-.013-.01-.03-.021-.035-.038-.016-.033-.046-.034-.076-.003-.106 0-.213-.036-.318-.01-.031 0-.07.003-.106.003-.058.011-.117.01-.176 0-.028-.006-.066-.025-.082-.071-.06-.074-.15-.092-.226a.44.44 0 0 1 .028-.241c.027-.07.034-.129 0-.194a.399.399 0 0 1-.02-.049c-.032-.093-.077-.183-.072-.284a.563.563 0 0 0-.04-.217c-.027-.077-.063-.16-.008-.237-.02-.043-.06-.085-.054-.122.017-.137-.057-.246-.1-.364-.016-.044-.032-.081-.016-.112-.02-.039-.045-.067-.051-.097-.015-.08-.014-.16-.034-.24-.03-.116-.034-.238-.055-.357-.022-.125-.075-.246-.038-.377a.039.039 0 0 0-.003-.027c-.025-.049.016-.12-.053-.157-.006-.002.001-.027 0-.04 0-.023.004-.047-.005-.066-.036-.085-.022-.182-.066-.265-.006-.012 0-.03 0-.044-.001-.018 0-.035-.004-.052-.01-.04-.024-.08-.03-.12-.023-.14-.04-.283-.064-.424a104.342 104.342 0 0 0-.16-.923.85.85 0 0 0-.144-.345c-.17-.24-.53-.289-.772-.142a.656.656 0 0 0-.279.342c-.036.095-.06.194-.099.288-.117.287-.174.595-.31.876-.008.109-.057.205-.092.306-.029.081-.041.167-.067.25-.027.088-.063.173-.09.262-.039.13-.096.254-.127.389a.693.693 0 0 1-.116.288c-.025.033-.026.084-.037.126-.015.058-.014.128-.049.17-.053.063-.065.137-.089.208-.012.037-.01.077-.023.113-.058.168-.14.326-.187.5-.054.204-.138.4-.208.6a1.24 1.24 0 0 0-.047.163.43.43 0 0 0 .287.49c.182.063.35.022.507-.076.052-.032.093-.081.14-.122-.018-.066.042-.106.058-.163.02-.073.059-.14.084-.213.03-.083.092-.15.104-.242.005-.04.042-.075.065-.113-.022-.016-.006-.036.004-.058.03-.067.068-.133.087-.203.015-.055.02-.11.044-.166.038-.085.035-.187.088-.27-.013-.084.048-.145.08-.21a.325.325 0 0 0 .037-.201c.032-.016.077-.023.066-.077 0-.004.018-.012.025-.02.02-.02.044-.038.055-.063.024-.05.04-.105.062-.156.007-.017.033-.04.042-.037a.44.44 0 0 1 .11.053c.034.024.047.058.027.101-.005.01.001.026.003.045.031-.008.054-.049.083-.012-.006.028-.014.055-.017.083a.972.972 0 0 0-.004.127c.002.037.016.073.014.109a.119.119 0 0 0 .034.096.242.242 0 0 1 .057.098c.018.078.026.158.039.237l.11.706c.007.05.013.1.014.15.002.091-.018.185.046.267.01.012.006.034.009.052.027.186.053.372.081.557.027.177.056.353.082.53.037.24.072.482.108.722.026.18.052.359.08.538l.12.748c.017.108.052.214.016.324-.007.022-.008.046-.012.065.096.077.102.107.041.21.048 0 .063.03.07.069.025.154.041.31.08.463.005.02.008.045 0 .062a.072.072 0 0 0 .01.082.118.118 0 0 1 .02.05c.03.166.06.332.087.498.03.182.054.366.09.546.044.213.103.423.144.636.036.19.25.391.486.36.2-.025.428-.14.491-.384a6.125 6.125 0 0 0 .104-.47c.037-.204.065-.411.094-.617.039-.271.078-.542.113-.814.036-.277.066-.556.101-.833a85.361 85.361 0 0 1 .098-.754c.013-.097.02-.197.049-.29.026-.085.07-.163.057-.253.098-.037.12-.08.064-.131-.04-.037-.045-.073-.04-.118l.01-.088c.014-.103.034-.206.037-.31.002-.067.019-.134.061-.172.078-.07.07-.165.1-.248.023-.065.01-.144.014-.22-.049-.014-.084-.034-.077-.086.009-.065.012-.131.025-.195.028-.139.062-.276.092-.414a.167.167 0 0 0 0-.079c-.013-.044.003-.073.032-.103a.107.107 0 0 0 .03-.06 2.729 2.729 0 0 0 .008-.245c0-.043.011-.079.025-.119.027-.082.074-.161.048-.257-.008-.027.012-.07.033-.096.081-.098.083-.207.056-.32m2.18-.666c-.015-.065-.001-.08.065-.115-.021-.038-.06-.075-.053-.102.017-.067-.016-.12-.034-.176a.228.228 0 0 0-.2-.16.476.476 0 0 0-.195.014 1.239 1.239 0 0 0-.333.157c-.172.11-.3.248-.386.425a1.766 1.766 0 0 0-.16.569c-.019.152-.03.306-.043.459-.002.014 0 .029-.001.044-.004.109-.007.218-.013.327a52.91 52.91 0 0 1-.028.504c-.002.039.011.081-.03.113-.008.006-.004.027-.003.041 0 .072.015.146 0 .214-.035.149-.03.299-.037.448-.008.171-.021.342-.026.513-.004.183-.01.366 0 .548.008.162.114.249.288.263a.455.455 0 0 0 .241-.05 2.2 2.2 0 0 0 .391-.253c.031-.024.045-.075.104-.054.006.002.027-.012.028-.02.005-.06.06-.032.097-.044l.02-.083-.084-.005c.006-.033.011-.063.019-.093.007-.03.021-.06.026-.09.015-.086.014-.176.044-.256.046-.118.012-.235.021-.352.006-.083-.004-.166.005-.249.014-.138.036-.275.056-.413.01-.068.026-.136.037-.204a2.184 2.184 0 0 0 .024-.18c.004-.054 0-.106.025-.16a.495.495 0 0 0 .04-.184c.008-.127.005-.254.007-.381 0-.015-.002-.032.005-.043.055-.088.055-.188.07-.283a.793.793 0 0 0 .019-.18.253.253 0 0 1 .03-.143c.015-.025.031-.06.022-.08a.125.125 0 0 1 .008-.12c-.025-.063-.052-.113-.065-.166m1.132-.94a1.285 1.285 0 0 0-.12.473c-.01.155-.014.31-.021.465-.008.15-.015.298-.025.447-.007.093-.018.186-.026.278-.004.048.005.1-.012.142a.604.604 0 0 0-.04.268l-.002.008c.004.071-.021.141-.006.214.006.03.001.065-.002.097-.007.064-.037.134-.02.19.032.11.006.217.007.325 0 .094-.035.184-.024.282.012.1.004.203.005.304 0 .082.027.156.066.225.06.107.166.164.269.145.193-.036.402-.137.57-.304a.708.708 0 0 0 .206-.398 3.67 3.67 0 0 0 .042-.492c.005-.24.017-.48.028-.719.003-.06.026-.124.016-.183-.018-.102.009-.201.008-.302 0-.049.01-.106.053-.134.003-.055-.006-.102.01-.136.028-.06.027-.123.044-.184.009-.033.034-.064.034-.097a.24.24 0 0 1 .046-.133c.103-.16.21-.318.366-.433a6.662 6.662 0 0 0 .29-.228c.136-.112.273-.226.26-.431 0-.014.009-.028.008-.042-.003-.036-.001-.075-.014-.107-.028-.067-.064-.13-.097-.195-.048-.095-.13-.124-.229-.124-.096 0-.18.041-.265.081-.056.027-.11.056-.168.082-.054.024-.112.039-.163.068a.77.77 0 0 1-.3.096 1.25 1.25 0 0 0-.455.125.74.74 0 0 0-.34.327",source:"https://www.virgin.com/img/virgin-logo-square.svg",hex:"E10A0A",guidelines:void 0,license:void 0},siVirtualbox={title:"VirtualBox",slug:"virtualbox",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>VirtualBox</title><path d="'+this.path+'"/></svg>'},path:"M12 0a.477.477 0 0 0-.188.047L2.17 4.274c-.265.169-.378.363-.372.692l.832 10.278c.009.107.047.165.128.25l3.564 2.713s.015 2.015.455 2.806C7.109 21.61 8.652 24.033 12 24c3.348-.033 4.988-2.03 5.484-3.028.47-.946.46-2.912.46-2.912l3.255-2.548a.31.31 0 0 0 .14-.258l.86-10.31c.026-.312-.103-.57-.368-.685L12.181.047A.435.435 0 0 0 12 0zm-.051 1.078c.054.002.108.02.188.056l7.417 3.429L12.132 8.9c-.115.058-.166.049-.264 0l-7.35-4.264c-.113-.074-.12-.125 0-.197l7.234-3.314a.534.534 0 0 1 .197-.047zm.01.688L5.905 4.591l6.042 3.49 6.067-3.48zm0 .375l5.232 2.46-3.262 1.82-1.04-.557 1.764-2.208-2.138.838L13.639 3.1l-3.252 1.346 1.1-1.15-.978-.45zm-1.837.849l.784.388-2.115 2.098 3.615-1.492-1.246 1.502 2.237-.932-1.136 1.419 1.232.666-1.56.885-5.148-2.946zm-6.93 3.902c.029 0 .072.02.135.054l7.28 4.577.017 7.818-6.853-5.057c-.077-.073-.104-.098-.103-.193l-.52-7.137c0-.043.015-.062.044-.062zm17.592.086c.03 0 .042.02.043.062l-.495 7.027c0 .096-.026.12-.103.193l-6.843 5.081.043-7.805 7.219-4.504a.348.348 0 0 1 .136-.054zm-.805 3.206l-.177.126-.133.442-.049-.315-.226.15.145.598-.224.915.233-.195.085-.527.064.413.278-.184-.195-.682zm-15.71.249c-.12-.011-.19.127-.169.37.028.327.21.72.408.877l.419.33c.2.158.338.018.307-.313-.03-.33-.216-.724-.414-.879l-.417-.323a.265.265 0 0 0-.134-.062zm.075.235a.173.173 0 0 1 .087.041l.397.31c.129.101.25.358.27.57.02.215-.07.304-.199.202l-.4-.315c-.128-.101-.246-.354-.264-.566-.014-.158.03-.249.109-.242zm14.823.103c0-.035-.074.01-.115.04-.16.123-.358.559-.372 1.068-.015.556.11.619.263.514.162-.11.382-.492.39-1.026.007-.409-.166-.491-.166-.596zm-.713.067s-.439.19-.44.295c-.01.65-.07 1.968-.07 1.968l.332-.251s.329-.218.334-.82c.003-.386-.126-.31-.126-.31s.104-.218.106-.514c.005-.445-.136-.368-.136-.368zm.602.214c.115 0 .094.268.092.446-.002.175-.088.576-.18.643-.093.068-.1-.243-.098-.423.003-.173.074-.666.186-.666zm-.72.075s.08-.05.073.214a.829.829 0 0 1-.088.328l-.134.09.006-.538zm-.512.021l-.229.14-.06 1.843s-.014.184.036.222c.072.056.267-.173.267-.173l-.004-.21s-.075.018-.072-.058zM5.25 11.16l.112 1.196.14.111-.091-.988.461.363a.47.47 0 0 1 .137.287c.01.108-.033.154-.098.103l-.396-.313.477.936.205.163-.32-.617.063.05c.137.107.23.013.208-.213-.022-.225-.15-.496-.287-.602zm13.049.78s.1-.024.09.279c-.008.257-.09.338-.09.338l-.152.11.013-.62zm-.95.174c-.042-.012-.102.006-.189.077-.107.07-.305.38-.305.38l.008.19s.114-.141.171-.187c.221-.22.165.09.165.09l-.005.099-.156.146s-.231.227-.243.658c-.006.206.068.35.18.265.11-.082.247-.33.247-.33l.004.144.19-.17.013-1.02s.043-.307-.08-.342zm-10.704.126c-.035-.028-.066-.027-.08.004l-.334.8.167.133.273-.671.254.69-.38-.3.105.28.386.307.103.28.17.134-.572-1.518a.338.338 0 0 0-.092-.139zm10.054.35l-.18.132-.01 1.078s-.098.19-.14.217c-.072.047-.07-.107-.07-.107l.015-1.02-.192.145-.015 1.02s-.011.457.182.313a.779.779 0 0 0 .222-.323l.017.128.154-.11zm-.806.11l-.164.108-.066.489-.077.049v.023l-.152.095c-.06.093-.098.38-.098.38l.002-.288-.175.124-.04 1.483.198-.143.043-.877s.032-.211.098-.321l.107-.086.017-.309.002.155.066-.056-.008.945s-.015.314.15.204c.057-.039.213-.23.213-.23L16 14.252s-.076.071-.1.086c-.037.023-.036-.058-.036-.058l.021-.915.11-.077-.003-.24-.096.06zm-8.551.14c-.124-.012-.197.13-.171.384.035.339.232.748.44.913l.449.353.062-.15-.524-.415c-.134-.107-.263-.37-.286-.59-.023-.219.07-.31.203-.206l.423.333.062-.15-.517-.408a.28.28 0 0 0-.141-.064zm9.85.172v.357s-.107.126-.156.155c-.048.029-.06-.055-.06-.129a.457.457 0 0 1 .118-.293zm-2.226.171c-.067.048-.123.188-.124.313 0 .125.053.187.12.14.068-.048.125-.188.126-.314 0-.125-.054-.188-.122-.139zm-6.887.189l.12 1.12a.296.296 0 0 0 .087.178l.673.532.062-.152-.686-.543-.11-1.022zm6.684.109l-.213.156s-.022.371-.182 1.69c-.132-.98-.132-1.45-.132-1.45l-.246.163.152 1.803.365-.208zm.259.298l-.197.141-.062 1.505.197-.142zm-5.911.446c-.127-.013-.198.133-.169.392.039.346.244.765.457.934l.46.364.064-.154-.541-.426c-.114-.09-.225-.29-.273-.485l.636.5.062-.153-.724-.57c.01-.146.094-.196.207-.107l.436.343.062-.152-.534-.418a.292.292 0 0 0-.143-.068zm.769.587c-.013.013-.02.042-.015.081a.351.351 0 0 0 .105.21c.048.038.08.006.07-.073a.36.36 0 0 0-.105-.212c-.024-.018-.042-.02-.055-.006zm.015.032c.01-.01.026-.01.045.004.038.03.074.104.08.165.008.063-.016.088-.055.058-.012-.01-.015-.035-.025-.051l.006.004-.006-.06.015.01.025.078.022.017-.03-.084h.004c.008-.002.009-.013.008-.019v-.013a.122.122 0 0 0-.025-.058.12.12 0 0 0-.026-.025l-.023-.02.015.137c-.015-.03-.037-.05-.04-.08-.005-.032 0-.053.01-.063zm.036.047l.006.004c.01.008.013.011.018.017a.07.07 0 0 1 .01.026c0 .006.002.01 0 .013-.002.006-.009.002-.015-.002l-.013-.01z",source:"https://commons.wikimedia.org/wiki/File:Virtualbox_logo.png",hex:"183A61",guidelines:void 0,license:void 0},siVirustotal={title:"VirusTotal",slug:"virustotal",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>VirusTotal</title><path d="'+this.path+'"/></svg>'},path:"M10.87 12L0 22.68h24V1.32H0zm10.73 8.52H5.28l8.637-8.448L5.28 3.48H21.6z",source:"https://www.virustotal.com/",hex:"394EFF",guidelines:void 0,license:void 0},siVisa={title:"Visa",slug:"visa",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Visa</title><path d="'+this.path+'"/></svg>'},path:"M9.112 8.262L5.97 15.758H3.92L2.374 9.775c-.094-.368-.175-.503-.461-.658C1.447 8.864.677 8.627 0 8.479l.046-.217h3.3a.904.904 0 01.894.764l.817 4.338 2.018-5.102zm8.033 5.049c.008-1.979-2.736-2.088-2.717-2.972.006-.269.262-.555.822-.628a3.66 3.66 0 011.913.336l.34-1.59a5.207 5.207 0 00-1.814-.333c-1.917 0-3.266 1.02-3.278 2.479-.012 1.079.963 1.68 1.698 2.04.756.367 1.01.603 1.006.931-.005.504-.602.725-1.16.734-.975.015-1.54-.263-1.992-.473l-.351 1.642c.453.208 1.289.39 2.156.398 2.037 0 3.37-1.006 3.377-2.564m5.061 2.447H24l-1.565-7.496h-1.656a.883.883 0 00-.826.55l-2.909 6.946h2.036l.405-1.12h2.488zm-2.163-2.656l1.02-2.815.588 2.815zm-8.16-4.84l-1.603 7.496H8.34l1.605-7.496z",source:"https://merchantsignageeu.visa.com/product.asp?dptID=696",hex:"1A1F71",guidelines:void 0,license:void 0},siVisualstudio={title:"Visual Studio",slug:"visualstudio",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Visual Studio</title><path d="'+this.path+'"/></svg>'},path:"M17.583.063a1.5 1.5 0 00-1.032.392 1.5 1.5 0 00-.001 0A.88.88 0 0016.5.5L8.528 9.316 3.875 5.5l-.407-.35a1 1 0 00-1.024-.154 1 1 0 00-.012.005l-1.817.75a1 1 0 00-.077.036 1 1 0 00-.047.028 1 1 0 00-.038.022 1 1 0 00-.048.034 1 1 0 00-.03.024 1 1 0 00-.044.036 1 1 0 00-.036.033 1 1 0 00-.032.035 1 1 0 00-.033.038 1 1 0 00-.035.044 1 1 0 00-.024.034 1 1 0 00-.032.05 1 1 0 00-.02.035 1 1 0 00-.024.05 1 1 0 00-.02.045 1 1 0 00-.016.044 1 1 0 00-.016.047 1 1 0 00-.015.055 1 1 0 00-.01.04 1 1 0 00-.008.054 1 1 0 00-.006.05A1 1 0 000 6.668v10.666a1 1 0 00.615.917l1.817.764a1 1 0 001.035-.164l.408-.35 4.653-3.815 7.973 8.815a1.5 1.5 0 00.072.065 1.5 1.5 0 00.057.05 1.5 1.5 0 00.058.042 1.5 1.5 0 00.063.044 1.5 1.5 0 00.065.038 1.5 1.5 0 00.065.036 1.5 1.5 0 00.068.031 1.5 1.5 0 00.07.03 1.5 1.5 0 00.073.025 1.5 1.5 0 00.066.02 1.5 1.5 0 00.08.02 1.5 1.5 0 00.068.014 1.5 1.5 0 00.075.01 1.5 1.5 0 00.075.008 1.5 1.5 0 00.073.003 1.5 1.5 0 00.077 0 1.5 1.5 0 00.078-.005 1.5 1.5 0 00.067-.007 1.5 1.5 0 00.087-.015 1.5 1.5 0 00.06-.012 1.5 1.5 0 00.08-.022 1.5 1.5 0 00.068-.02 1.5 1.5 0 00.07-.028 1.5 1.5 0 00.09-.037l4.944-2.377a1.5 1.5 0 00.476-.362 1.5 1.5 0 00.09-.112 1.5 1.5 0 00.004-.007 1.5 1.5 0 00.08-.125 1.5 1.5 0 00.062-.12 1.5 1.5 0 00.009-.017 1.5 1.5 0 00.04-.108 1.5 1.5 0 00.015-.037 1.5 1.5 0 00.03-.107 1.5 1.5 0 00.009-.037 1.5 1.5 0 00.017-.1 1.5 1.5 0 00.008-.05 1.5 1.5 0 00.006-.09 1.5 1.5 0 00.004-.08V3.942a1.5 1.5 0 000-.003 1.5 1.5 0 000-.032 1.5 1.5 0 00-.01-.15 1.5 1.5 0 00-.84-1.17L18.206.21a1.5 1.5 0 00-.622-.146zM18 6.92v10.163l-6.198-5.08zM3 8.574l3.099 3.427-3.1 3.426z",source:"https://visualstudio.microsoft.com/",hex:"5C2D91",guidelines:void 0,license:void 0},siVisualstudiocode={title:"Visual Studio Code",slug:"visualstudiocode",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Visual Studio Code</title><path d="'+this.path+'"/></svg>'},path:"M23.15 2.587L18.21.21a1.494 1.494 0 0 0-1.705.29l-9.46 8.63-4.12-3.128a.999.999 0 0 0-1.276.057L.327 7.261A1 1 0 0 0 .326 8.74L3.899 12 .326 15.26a1 1 0 0 0 .001 1.479L1.65 17.94a.999.999 0 0 0 1.276.057l4.12-3.128 9.46 8.63a1.492 1.492 0 0 0 1.704.29l4.942-2.377A1.5 1.5 0 0 0 24 20.06V3.939a1.5 1.5 0 0 0-.85-1.352zm-5.146 14.861L10.826 12l7.178-5.448v10.896z",source:"https://commons.wikimedia.org/wiki/File:Visual_Studio_Code_1.35_icon.svg",hex:"007ACC",guidelines:void 0,license:void 0},siVite={title:"Vite",slug:"vite",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Vite</title><path d="'+this.path+'"/></svg>'},path:"m8.286 10.578.512-8.657a.306.306 0 0 1 .247-.282L17.377.006a.306.306 0 0 1 .353.385l-1.558 5.403a.306.306 0 0 0 .352.385l2.388-.46a.306.306 0 0 1 .332.438l-6.79 13.55-.123.19a.294.294 0 0 1-.252.14c-.177 0-.35-.152-.305-.369l1.095-5.301a.306.306 0 0 0-.388-.355l-1.433.435a.306.306 0 0 1-.389-.354l.69-3.375a.306.306 0 0 0-.37-.36l-2.32.536a.306.306 0 0 1-.374-.316zm14.976-7.926L17.284 3.74l-.544 1.887 2.077-.4a.8.8 0 0 1 .84.369.8.8 0 0 1 .034.783L12.9 19.93l-.013.025-.015.023-.122.19a.801.801 0 0 1-.672.37.826.826 0 0 1-.634-.302.8.8 0 0 1-.16-.67l1.029-4.981-1.12.34a.81.81 0 0 1-.86-.262.802.802 0 0 1-.165-.67l.63-3.08-2.027.468a.808.808 0 0 1-.768-.233.81.81 0 0 1-.217-.6l.389-6.57-7.44-1.33a.612.612 0 0 0-.64.906L11.58 23.691a.612.612 0 0 0 1.066-.004l11.26-20.135a.612.612 0 0 0-.644-.9z",source:"https://vitejs.dev/",hex:"646CFF",guidelines:void 0,license:void 0},siChakraui={title:"Chakra UI",slug:"chakraui",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Chakra UI</title><path d="'+this.path+'"/></svg>'},path:"M12 0C5.352 0 0 5.352 0 12s5.352 12 12 12 12-5.352 12-12S18.648 0 12 0zm2.8 4.333c.13-.004.248.136.171.278l-3.044 5.58a.187.187 0 00.164.276h5.26c.17 0 .252.207.128.323l-9.22 8.605c-.165.154-.41-.063-.278-.246l4.364-6.021a.187.187 0 00-.151-.296H6.627a.187.187 0 01-.131-.32l8.18-8.123a.182.182 0 01.125-.056z",source:"https://github.com/chakra-ui/chakra-ui/blob/327e1624d22936abb43068e1f57054e43c9c6819/logo/logomark-colored.svg",hex:"319795",guidelines:void 0,license:void 0},siVivino={title:"Vivino",slug:"vivino",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Vivino</title><path d="'+this.path+'"/></svg>'},path:"M12.476 18.034c0-1.087.889-1.989 1.988-1.989 1.1 0 1.989.902 1.989 1.989 0 1.1-.89 1.989-1.989 1.989-1.1 0-1.988-.89-1.988-1.99M12.043 24c-1.1 0-1.988-.902-1.988-1.989 0-1.099.889-1.988 1.988-1.988 1.087 0 1.989.889 1.989 1.988A2.003 2.003 0 0112.043 24M5.2 14.007c0-1.087.89-1.988 1.989-1.988 1.087 0 1.989.901 1.989 1.988 0 1.1-.902 1.989-1.99 1.989-1.098 0-1.988-.89-1.988-1.989m4.385-5.892c1.1 0 1.989.902 1.989 1.989 0 1.1-.89 1.976-1.989 1.976-1.1 0-1.988-.877-1.988-1.976 0-1.087.889-1.989 1.988-1.989m2.384-4.187c1.1 0 1.989.89 1.989 1.989 0 1.087-.89 1.988-1.989 1.988A2.003 2.003 0 019.98 5.917c0-1.1.902-1.99 1.99-1.99M14.401 0c1.1 0 1.99.89 1.99 1.989 0 1.087-.89 1.988-1.99 1.988a2.003 2.003 0 01-1.988-1.988c0-1.1.901-1.989 1.988-1.989M11.6 18.034c0 1.1-.89 1.989-1.99 1.989a1.995 1.995 0 01-1.988-1.99c0-1.086.902-1.988 1.989-1.988 1.1 0 1.989.902 1.989 1.989m-1.544-4.027c0-1.087.889-1.988 1.988-1.988 1.087 0 1.989.901 1.989 1.988 0 1.1-.902 1.989-1.989 1.989-1.1 0-1.988-.89-1.988-1.989m4.385-1.927c-1.1 0-1.99-.877-1.99-1.976 0-1.087.89-1.989 1.99-1.989 1.099 0 1.988.902 1.988 1.989 0 1.1-.89 1.976-1.988 1.976m4.36 1.927c0 1.1-.89 1.989-1.989 1.989-1.1 0-1.989-.89-1.989-1.989 0-1.087.89-1.988 1.99-1.988 1.098 0 1.988.901 1.988 1.988Z",source:"https://www.vivino.com/press",hex:"AA1329",guidelines:void 0,license:void 0},siVk={title:"VK",slug:"vk",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>VK</title><path d="'+this.path+'"/></svg>'},path:"m9.489.004.729-.003h3.564l.73.003.914.01.433.007.418.011.403.014.388.016.374.021.36.025.345.03.333.033c1.74.196 2.933.616 3.833 1.516.9.9 1.32 2.092 1.516 3.833l.034.333.029.346.025.36.02.373.025.588.012.41.013.644.009.915.004.98-.001 3.313-.003.73-.01.914-.007.433-.011.418-.014.403-.016.388-.021.374-.025.36-.03.345-.033.333c-.196 1.74-.616 2.933-1.516 3.833-.9.9-2.092 1.32-3.833 1.516l-.333.034-.346.029-.36.025-.373.02-.588.025-.41.012-.644.013-.915.009-.98.004-3.313-.001-.73-.003-.914-.01-.433-.007-.418-.011-.403-.014-.388-.016-.374-.021-.36-.025-.345-.03-.333-.033c-1.74-.196-2.933-.616-3.833-1.516-.9-.9-1.32-2.092-1.516-3.833l-.034-.333-.029-.346-.025-.36-.02-.373-.025-.588-.012-.41-.013-.644-.009-.915-.004-.98.001-3.313.003-.73.01-.914.007-.433.011-.418.014-.403.016-.388.021-.374.025-.36.03-.345.033-.333c.196-1.74.616-2.933 1.516-3.833.9-.9 2.092-1.32 3.833-1.516l.333-.034.346-.029.36-.025.373-.02.588-.025.41-.012.644-.013.915-.009ZM6.79 7.3H4.05c.13 6.24 3.25 9.99 8.72 9.99h.31v-3.57c2.01.2 3.53 1.67 4.14 3.57h2.84c-.78-2.84-2.83-4.41-4.11-5.01 1.28-.74 3.08-2.54 3.51-4.98h-2.58c-.56 1.98-2.22 3.78-3.8 3.95V7.3H10.5v6.92c-1.6-.4-3.62-2.34-3.71-6.92Z",source:"https://vk.com/brand",hex:"0077FF",guidelines:"https://vk.com/brand",license:void 0},siVlcmediaplayer={title:"VLC media player",slug:"vlcmediaplayer",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>VLC media player</title><path d="'+this.path+'"/></svg>'},path:"M12.0319 0c-.8823 0-1.0545.136-1.0545.136-.1738.056-.3556.255-.4105.43L9.683 3.3808c.4729.1729 1.3222.4266 2.2337.4266 1.0987 0 2.017-.3494 2.3763-.5075L13.4352.566c-.055-.1755-.237-.3707-.4067-.4374 0 0-.1142-.1286-.9966-.1286zm3.5645 7.455c-.3601.34-1.3276.9373-3.6797.9373-2.2929 0-3.189-.5678-3.5213-.9113l-1.3887 4.4227c.2272.3614 1.2539 1.5594 4.8847 1.5594 3.7569 0 4.8539-1.3467 5.0649-1.6737zm-8.5897 4.4487l-1.0025 3.1922H4.3428c-.2486 0-.5097.1932-.5826.4315l-2.334 7.6317a.3962.3962 0 0 0-.0169.1537c-.0008.0053-.002.0099-.002.016 0 .0839.0233.226.0233.226.0322.2456.2612.4452.5098.4452h20.1192c.2487 0 .4768-.1994.5098-.4453 0 0 .0234-.142.0234-.226a.0245.0245 0 0 0-.0025-.01.3201.3201 0 0 0 .0024-.0313.4096.4096 0 0 0-.019-.1282l-2.3339-7.6318c-.0729-.2383-.334-.4314-.5826-.4314h-1.6636l.2005.6391c-.2407.4854-1.4886 2.38-6.3027 2.38-4.6003 0-5.8288-1.73-6.1107-2.3072z",source:"http://git.videolan.org/?p=vlc.git;a=tree;f=extras/package/macosx/asset_sources",hex:"FF8800",guidelines:void 0,license:void 0},siVmware={title:"VMware",slug:"vmware",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>VMware</title><path d="'+this.path+'"/></svg>'},path:"M.5 10.1a.505.505 0 00-.197.048.497.497 0 00-.25.68l1.138 2.475c.179.38.38.592.721.592.342 0 .542-.22.72-.592l1.003-2.186a.144.144 0 01.144-.092.16.16 0 01.157.16v2.118a.535.535 0 101.066 0v-1.73a.531.531 0 01.566-.552.52.52 0 01.541.551v1.73a.531.531 0 00.53.593.539.539 0 00.535-.592v-1.73a.531.531 0 01.564-.552.52.52 0 01.543.551v1.73a.531.531 0 00.528.593.535.535 0 00.535-.592v-1.969a1.234 1.234 0 00-1.283-1.23 1.647 1.647 0 00-1.14.486 1.26 1.26 0 00-1.095-.483 1.807 1.807 0 00-1.074.483 1.287 1.287 0 00-.961-.483 1.177 1.177 0 00-1.158.786l-.729 1.716-.933-2.203.011-.004A.505.505 0 00.5 10.1zm18.43.06a.27.27 0 00-.266.274h.002v3.142a.27.27 0 10.535 0v-1.222c0-1.037.571-1.56 1.27-1.643a.266.266 0 00.238-.274.258.258 0 00-.266-.269 1.465 1.465 0 00-1.242.88v-.614a.266.266 0 00-.271-.274zm-6.735.008a.273.273 0 00-.25.217l-.912 2.627-.902-2.62a.28.28 0 00-.274-.22.266.266 0 00-.27.258.493.493 0 00.034.144l1.09 3.037.02-.007a.319.319 0 00.298.242.3.3 0 00.293-.242l.903-2.583.896 2.583a.3.3 0 00.293.242h.018a.319.319 0 00.293-.242l1.097-3.038a.512.512 0 00.033-.144.258.258 0 00-.265-.25.262.262 0 00-.258.209l-.918 2.63-.904-2.626a.285.285 0 00-.278-.217h-.025a.273.273 0 00-.012 0zm10.168.008a1.75 1.75 0 00-1.691 1.851 1.765 1.765 0 001.76 1.858l-.008.013a1.784 1.784 0 001.33-.539.228.228 0 00.082-.17.228.228 0 00-.379-.168 1.435 1.435 0 01-1.018.415 1.237 1.237 0 01-1.24-1.207h2.555a.247.247 0 00.246-.247c0-.945-.593-1.806-1.637-1.806zm-5.744.002a1.571 1.571 0 00-.158.006 2.384 2.384 0 00-1.078.205.22.22 0 00-.143.222.24.24 0 00.235.229.266.266 0 00.095-.024 1.822 1.822 0 01.834-.162c.691 0 1.07.334 1.07.979v.125a3.796 3.796 0 00-1.103-.15c-.892 0-1.52.4-1.52 1.16l-.003-.004c0 .736.671 1.117 1.34 1.117a1.575 1.575 0 001.298-.62v.343a.247.247 0 00.254.25.254.254 0 00.258-.262v-1.983a1.416 1.416 0 00-.379-1.046 1.571 1.571 0 00-1-.385zm5.719.43c.714 0 1.085.565 1.139 1.214h-2.278a1.222 1.222 0 011.139-1.215zm-5.885 1.382a3.75 3.75 0 011.057.153V12.49c0 .57-.539.973-1.2.973-.485 0-.904-.261-.904-.713 0-.467.375-.76 1.047-.76Z",source:"https://myvmware.workspaceair.com/",hex:"607078",guidelines:void 0,license:void 0},siVodafone={title:"Vodafone",slug:"vodafone",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Vodafone</title><path d="'+this.path+'"/></svg>'},path:"M12 0A12 12 0 0 0 0 12A12 12 0 0 0 12 24A12 12 0 0 0 24 12A12 12 0 0 0 12 0M16.25 1.12C16.57 1.12 16.9 1.15 17.11 1.22C14.94 1.67 13.21 3.69 13.22 6C13.22 6.05 13.22 6.11 13.23 6.17C16.87 7.06 18.5 9.25 18.5 12.28C18.54 15.31 16.14 18.64 12.09 18.65C8.82 18.66 5.41 15.86 5.39 11.37C5.38 8.4 7 5.54 9.04 3.85C11.04 2.19 13.77 1.13 16.25 1.12Z",source:"https://web.vodafone.com.eg/",hex:"E60000",guidelines:void 0,license:void 0},siVolkswagen={title:"Volkswagen",slug:"volkswagen",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Volkswagen</title><path d="'+this.path+'"/></svg>'},path:"M12 0C5.36 0 0 5.36 0 12S5.36 24 12 24 24 18.64 24 12 18.64 0 12 0M12 1.41C13.2 1.41 14.36 1.63 15.43 2L12.13 9.13C12.09 9.17 12.09 9.26 12 9.26S11.91 9.17 11.87 9.13L8.57 2C9.64 1.63 10.8 1.42 12 1.42M6.9 2.74L10.72 10.97C10.8 11.14 10.89 11.19 11 11.19H13C13.12 11.19 13.2 11.14 13.29 10.97L17.06 2.74C18.64 3.64 20 4.93 20.96 6.47L15.6 16.84C15.56 16.93 15.5 16.97 15.47 16.97C15.39 16.97 15.39 16.89 15.34 16.84L13.29 12.3C13.2 12.13 13.12 12.09 13 12.09H11C10.89 12.09 10.8 12.13 10.71 12.3L8.66 16.84C8.61 16.89 8.62 16.97 8.53 16.97C8.44 16.97 8.44 16.89 8.4 16.84L3 6.47C3.94 4.93 5.32 3.64 6.9 2.74M2.06 8.53L8.23 20.53C8.31 20.7 8.4 20.83 8.62 20.83C8.83 20.83 8.91 20.7 9 20.53L11.87 14.14C11.91 14.06 11.96 14 12 14C12.09 14 12.09 14.1 12.13 14.14L15.04 20.53C15.13 20.7 15.21 20.83 15.43 20.83C15.64 20.83 15.73 20.7 15.81 20.53L22 8.53C22.37 9.6 22.59 10.76 22.59 12C22.54 17.79 17.79 22.59 12 22.59C6.21 22.59 1.46 17.79 1.46 12C1.46 10.8 1.67 9.65 2.06 8.53Z",source:"https://www.volkswagen.ie/",hex:"151F5D",guidelines:void 0,license:void 0},siVolvo={title:"Volvo",slug:"volvo",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Volvo</title><path d="'+this.path+'"/></svg>'},path:"M11.269 11.225h-.522v-.343h2.072v.343h-.516v1.55h.479c.443 0 .734-.292.734-.69h.342v1.038h-3.11v-.347h.522zm2.533.001h-.515v-.344h2.248v.344h-.544l.758 1.383.749-1.383h-.448v-.344h1.55v.344h-.516l-1.027 1.9-1.21-.001zm5.181-.392c1.041 0 1.6.52 1.6 1.171 0 .66-.527 1.187-1.594 1.187-1.067 0-1.599-.526-1.599-1.187 0-.651.553-1.17 1.593-1.17zM5.781 12.61l.748-1.383h-.447v-.344H7.63v.344h-.515l-1.028 1.9-1.21-.001-1.045-1.899h-.514v-.344h2.247v.344h-.543zm3.237-1.775c1.041 0 1.6.52 1.6 1.171 0 .66-.527 1.187-1.594 1.187-1.067 0-1.599-.526-1.599-1.187 0-.651.552-1.17 1.593-1.17zm-.551 1.157c.007-.432.214-.809.57-.803.356.007.544.39.537.823-.008.407-.176.831-.567.824-.38-.007-.547-.427-.54-.844zm9.965 0c.007-.432.214-.809.57-.803.356.007.544.39.537.823-.008.407-.176.831-.567.824-.38-.007-.547-.427-.54-.844zM3.226 9.83C4.198 5.887 7.757 2.963 12 2.963c4.243 0 7.802 2.924 8.774 6.866zm17.548 4.342c-.972 3.942-4.531 6.866-8.774 6.866-4.243 0-7.802-2.924-8.774-6.866zm.849-9.341l.568-.569c.404.532.769 1.096 1.087 1.688h.449V.283H18.06v.444c.589.317 1.15.68 1.678 1.082l-.569.568A11.947 11.947 0 0 0 12 0C5.373 0 0 5.373 0 12s5.373 12 12 12 12-5.373 12-12c0-2.688-.884-5.17-2.377-7.17Z",source:"https://www.media.volvocars.com/global/en-gb/logos",hex:"003057",guidelines:void 0,license:void 0},siVonage={title:"Vonage",slug:"vonage",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Vonage</title><path d="'+this.path+'"/></svg>'},path:"M9.279 11.617l-4.54-10.07H0l6.797 15.296a.084.084 0 0 0 .153 0zm9.898-10.07s-6.148 13.868-6.917 15.565c-1.838 4.056-3.2 5.07-4.588 5.289a.026.026 0 0 0 .004.052h4.34c1.911 0 3.219-1.285 5.06-5.341C17.72 15.694 24 1.547 24 1.547z",source:"https://www.vonage.com",hex:"FFFFFF",guidelines:void 0,license:void 0},siVox={title:"VOX",slug:"vox",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>VOX</title><path d="'+this.path+'"/></svg>'},path:"M0 8.198l4.182 7.604h2.442L8.15 13.07a4.276 4.276 0 0 1 2.054-4.872H7.112l-1.677 3.216-1.706-3.216zm14.342 0a4.24 4.24 0 0 1 1.923 2.206c.784 2.081-.098 4.415-2.145 5.398h2.767l1.564-1.754 1.42 1.754H24l-3.505-4.032 3.088-3.572H19.41l-.952 1.249-.931-1.249zm-2.09 1.596c-.949 0-1.913.69-2.074 1.775a2.132 2.132 0 0 0 2.064 2.483c1.268.01 2.192-1.126 2.156-2.18-.013-1.015-.877-2.08-2.146-2.078z",source:"https://commons.wikimedia.org/wiki/File:VOX_Logo_2013.svg",hex:"DA074A",guidelines:void 0,license:void 0},siVsco={title:"VSCO",slug:"vsco",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>VSCO</title><path d="'+this.path+'"/></svg>'},path:"M12 0C5.376 0 0 5.376 0 12s5.376 12 12 12 12-5.376 12-12S18.624 0 12 0zm11.52 12c0 .408-.023.792-.072 1.176l-2.04-.24c.024-.312.05-.624.05-.936 0-.288-.025-.6-.05-.888l2.04-.24c.072.384.072.744.072 1.128zM.479 12c0-.384.024-.769.049-1.152l2.04.24c-.024.312-.047.6-.047.912s.023.6.047.912l-2.04.24C.479 12.769.479 12.384.479 12zm20.472-3.096l1.921-.72c.264.72.433 1.464.552 2.232l-2.04.24c-.097-.6-.24-1.2-.433-1.752zM21 12c0 .6-.072 1.176-.167 1.752l-2.017-.455c.071-.409.119-.841.119-1.297s-.048-.912-.119-1.344l2.017-.457c.118.577.167 1.177.167 1.801zm-9 6.456C8.435 18.455 5.545 15.565 5.544 12 5.545 8.435 8.435 5.545 12 5.544c3.565.001 6.455 2.891 6.456 6.456.008 3.559-2.871 6.448-6.429 6.456H12zM12.216 21v-2.064c.885-.029 1.756-.224 2.568-.575l.888 1.872c-1.09.482-2.264.742-3.456.767zm-3.936-.791l.912-1.873c.792.359 1.656.575 2.568.6V21c-1.202-.023-2.386-.293-3.48-.791zM3 12c0-.624.072-1.224.192-1.824l2.016.456c-.098.45-.146.908-.144 1.368 0 .432.048.864.12 1.272l-2.016.455C3.051 13.159 2.994 12.58 3 12zm8.76-9v2.064c-.877.029-1.74.224-2.544.576l-.888-1.871C9.411 3.291 10.577 3.03 11.76 3zm3.935.792l-.911 1.872c-.809-.363-1.682-.559-2.568-.576V3.024c1.248 0 2.424.288 3.479.768zm5.088 4.656c-.231-.56-.513-1.098-.84-1.608l1.681-1.152c.407.648.768 1.32 1.056 2.04l-1.897.72zm-.07 1.296l-2.018.456c-.23-.85-.621-1.648-1.151-2.352l1.632-1.295c.72.959 1.248 2.015 1.537 3.191zm-3.457-2.256c-.572-.667-1.264-1.22-2.04-1.633l.912-1.871c1.056.549 1.993 1.299 2.76 2.208l-1.632 1.296zm-.6-3.744l.96-1.824c.672.384 1.295.816 1.896 1.32L18.145 4.8c-.461-.401-.959-.754-1.489-1.056zm-.408-.216c-.54-.266-1.102-.483-1.68-.648l.504-1.992c.744.216 1.464.48 2.159.84l-.983 1.8zm-2.16-.768c-.6-.144-1.2-.216-1.824-.239V.479c.793.024 1.584.12 2.328.289l-.504 1.992zm-2.28-.239c-.605.021-1.207.094-1.8.216L9.528.744c.72-.168 1.487-.265 2.28-.265v2.042zm-2.28.334c-.586.167-1.156.384-1.704.649l-.96-1.824c.691-.343 1.415-.616 2.16-.816l.504 1.991zm-2.112.865c-.529.294-1.027.64-1.488 1.032L4.56 3.216c.6-.504 1.224-.936 1.896-1.319l.96 1.823zm.48.264l.888 1.871c-.792.408-1.464.96-2.04 1.608L5.136 6.168c.775-.895 1.711-1.636 2.76-2.184zM4.848 6.552l1.608 1.295c-.53.705-.921 1.503-1.152 2.353l-2.016-.456c.312-1.2.84-2.28 1.56-3.192zM3.24 8.4l-1.92-.72c.287-.72.648-1.416 1.08-2.04l1.68 1.176c-.341.494-.623 1.025-.84 1.584zm-.168.455c-.192.577-.36 1.152-.432 1.776L.6 10.393c.12-.769.288-1.537.553-2.257l1.919.719zm-.456 4.513c.096.6.239 1.2.432 1.776l-1.92.72c-.271-.728-.456-1.485-.552-2.257l2.04-.239zm.624 2.208c.239.576.528 1.104.84 1.607L2.4 18.336c-.435-.629-.797-1.306-1.08-2.016l1.92-.744zm.024-1.392l2.017-.456c.216.864.624 1.681 1.128 2.376L4.8 17.4c-.725-.957-1.247-2.051-1.536-3.216zm3.432 2.28c.577.672 1.272 1.248 2.064 1.656l-.912 1.872c-1.063-.557-2.009-1.315-2.784-2.232l1.632-1.296zm.72 3.815l-.96 1.825c-.674-.376-1.31-.819-1.896-1.321l1.368-1.535c.456.407.936.744 1.488 1.031zm.408.217c.528.264 1.104.48 1.705.647l-.504 1.992c-.747-.196-1.471-.469-2.16-.815l.959-1.824zm2.16.768c.576.12 1.176.193 1.8.217v2.039c-.774-.026-1.544-.114-2.305-.264l.505-1.992zm2.28.216c.605-.021 1.207-.094 1.801-.217l.479 1.992c-.749.168-1.513.264-2.28.287V21.48zm2.257-.336c.586-.165 1.155-.382 1.703-.647l.96 1.824c-.688.35-1.412.623-2.159.815l-.504-1.992zm2.086-.865c.528-.287 1.032-.647 1.488-1.031l1.369 1.535c-.588.502-1.223.945-1.896 1.321l-.961-1.825zm-.479-.263l-.888-1.871c.788-.414 1.489-.977 2.064-1.656l1.606 1.296c-.778.91-1.722 1.668-2.782 2.231zm3.071-2.592l-1.607-1.296c.532-.708.916-1.517 1.128-2.376l2.017.456c-.311 1.157-.831 2.248-1.538 3.216zM20.76 15.6l1.92.721c-.288.72-.648 1.392-1.079 2.04l-1.682-1.177c.337-.504.624-1.032.841-1.584zm.168-.455c.192-.553.336-1.152.433-1.752l2.039.239c-.11.761-.294 1.508-.551 2.232l-1.921-.719zm.456-9.841l-1.681 1.152c-.358-.49-.76-.947-1.199-1.368l1.368-1.536c.552.552 1.056 1.128 1.512 1.752zM4.2 3.528l1.368 1.536c-.456.408-.84.864-1.2 1.368l-1.68-1.176c.431-.636.94-1.216 1.512-1.728zM2.664 18.744l1.68-1.152c.36.48.769.937 1.2 1.369l-1.368 1.535c-.548-.545-1.054-1.131-1.512-1.752zm17.16 1.729l-1.368-1.537c.432-.407.841-.863 1.199-1.344l1.682 1.176c-.457.6-.961 1.175-1.513 1.705z",source:"https://vscopress.co/media-kit",hex:"000000",guidelines:void 0,license:void 0},siVtex={title:"VTEX",slug:"vtex",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>VTEX</title><path d="'+this.path+'"/></svg>'},path:"M22.2027 1.7925H4.2812c-1.3897 0-2.2795 1.4698-1.6293 2.6917l1.7927 3.3773H1.1947a1.2 1.2 0 0 0-.5873.1537 1.1924 1.1924 0 0 0-.4356.421 1.1847 1.1847 0 0 0-.0342 1.1683l5.766 10.858c.1017.191.2537.3507.4399.4622a1.1996 1.1996 0 0 0 1.2326 0 1.1913 1.1913 0 0 0 .4398-.4623l1.566-2.933 1.9647 3.7006c.6914 1.3016 2.5645 1.304 3.2584.0038L23.7878 4.416c.635-1.1895-.2314-2.6235-1.5851-2.6235ZM14.1524 8.978l-3.8733 7.2533a.7932.7932 0 0 1-.2927.3074.7986.7986 0 0 1-.82 0 .7933.7933 0 0 1-.2927-.3074L5.0378 9.0086a.7883.7883 0 0 1 .0208-.7776.7933.7933 0 0 1 .2891-.281.7985.7985 0 0 1 .3906-.1033h7.7307a.7769.7769 0 0 1 .381.0998.7717.7717 0 0 1 .2823.2736.7672.7672 0 0 1 .02.758z",source:"https://vtex.com",hex:"ED125F",guidelines:void 0,license:void 0},siVuetify={title:"Vuetify",slug:"vuetify",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Vuetify</title><path d="'+this.path+'"/></svg>'},path:"M7.094 0L12 11.596 16.906 0H7.094zM1.5 3.5L12 24 22.5 3.5H17L12 15 7 3.5z",source:"https://vuetifyjs.com/",hex:"1867C0",guidelines:void 0,license:void 0},siVulkan={title:"Vulkan",slug:"vulkan",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Vulkan</title><path d="'+this.path+'"/></svg>'},path:"M14.3417 15.336h-.936v-2.991c.299.167.694.474.936.769zm-7.8972 0h-1.167L3.7543 10.63h1.061l1.048 3.309h.013l1.061-3.309h1.0681zm4.7001 0h-.89v-.474h-.02a1.051 1.051 0 01-.462.429 1.36 1.36 0 01-.58.132 1.63 1.63 0 01-.616-.099.89.89 0 01-.379-.28 1.11 1.11 0 01-.195-.442 2.768 2.768 0 01-.0561-.577v-2.096h.936v1.925c0 .281.044.491.132.629.088.139.244.208.468.208.255 0 .439-.076.554-.227.114-.152.171-.401.171-.748V11.93h.9361zm3.3521-2.05l-.002-.132 1.18-1.226h1.108l-1.285 1.252 1.43 2.155h-1.134zm2.602-.31c.013-.22.068-.402.165-.547a1.13 1.13 0 01.3691-.349 1.6 1.6 0 01.504-.188 2.9 2.9 0 01.564-.056c.171 0 .345.012.521.036.176.024.336.072.481.142.145.07.264.168.356.293.092.125.138.291.138.498v1.773c0 .154.009.301.026.442a.799.799 0 00.092.316h-.949a1.32 1.32 0 01-.066-.329 1.208 1.208 0 01-.528.323 2.135 2.135 0 01-.62.092c-.163 0-.314-.02-.455-.059a1.018 1.018 0 01-.369-.185.856.856 0 01-.247-.316 1.073 1.073 0 01-.089-.455c0-.193.034-.353.102-.478a.856.856 0 01.264-.3c.108-.075.231-.131.369-.168.138-.037.278-.067.418-.089a7.9902 7.9902 0 01.415-.053c.136-.013.257-.033.362-.059a.637.637 0 00.251-.116c.062-.051.09-.124.086-.221a.5.5 0 00-.05-.241.365.365 0 00-.132-.138.521.521 0 00-.191-.066 1.56 1.56 0 00-.234-.017c-.185 0-.33.039-.435.119-.105.079-.167.211-.185.396zm2.1622.693a.415.415 0 01-.148.082c-.059.02-.123.036-.191.05a3.2101 3.2101 0 01-.214.033c-.075.009-.149.02-.224.033-.07.013-.14.031-.208.053a.618.618 0 00-.178.089.42.42 0 00-.122.142.455.455 0 00-.046.218c0 .084.015.154.046.211a.362.362 0 00.125.135.523.523 0 00.185.069c.07.013.143.02.218.02.185 0 .328-.031.429-.092a.616.616 0 00.224-.221.712.712 0 00.089-.26c.011-.088.016-.158.017-.211zm1.542-1.741h.89v.474h.02c.119-.198.272-.342.461-.432.189-.09.382-.135.58-.135.251 0 .456.034.617.102.16.068.286.163.379.283.092.121.1571.268.1941.441.037.176.056.368.056.579v2.096h-.936v-1.925c0-.281-.044-.491-.132-.629-.088-.138-.244-.208-.468-.208-.255 0-.439.076-.554.227-.114.151-.171.401-.171.748v1.786h-.9361zm-9.0383-.587v3.996h.936v-3.48a11.5774 11.5774 0 00-.936-.516zm-9.5483.17c.542-1.5901 3.7861-2.1722 7.2463-1.3021 2.075.522 3.771 1.534 4.8791 2.535-.503-1.327-2.94-3.22-6.2952-3.868-3.7941-.734-7.5362-.089-7.9992 1.595-.334 1.216 1.134 2.641 3.406 3.6151-1.021-.827-1.518-1.755-1.237-2.575zm12.1264.655v-1.5361h-.936v.466c.399.357.716.72.936 1.07z",source:"https://www.khronos.org/legal/trademarks/",hex:"AC162C",guidelines:void 0,license:void 0},siVultr={title:"Vultr",slug:"vultr",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Vultr</title><path d="'+this.path+'"/></svg>'},path:"M8.36 2.172A1.194 1.194 0 007.348 1.6H1.2A1.2 1.2 0 000 2.8a1.211 1.211 0 00.182.64l11.6 18.4a1.206 1.206 0 002.035 0l3.075-4.874a1.229 1.229 0 00.182-.64 1.211 1.211 0 00-.182-.642zm10.349 8.68a1.206 1.206 0 002.035 0L21.8 9.178l2.017-3.2a1.211 1.211 0 00.183-.64 1.229 1.229 0 00-.183-.64l-1.6-2.526a1.206 1.206 0 00-1.016-.571h-6.148a1.2 1.2 0 00-1.201 1.2 1.143 1.143 0 00.188.64z",source:"https://www.vultr.com/company/brand-assets/",hex:"007BFC",guidelines:void 0,license:void 0},siW3c={title:"W3C",slug:"w3c",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>W3C</title><path d="'+this.path+'"/></svg>'},path:"M23.642 5.602l-.931 1.858s-.4-.738-.795-1.076c-.377-.322-.864-.62-1.48-.556-.597.062-1.27.587-1.722 1.46-.513.994-.688 2.001-.692 3.112-.005 1.556.57 2.618.57 2.618s-.132-.494-.11-1.33c.014-.52.017-1.089.41-2.261.33-.98 1.084-1.775 1.75-1.912.517-.107.847-.03 1.356.329.603.425.966 1.193.966 1.193l.946-1.81zM0 5.674l3.77 12.723h.156l2.356-7.886 2.357 7.886h.157l3.228-10.895.152-.258h2.655l-2.2 3.802v.754h.629c.806 0 1.398.246 1.775.738.324.42.487 1.011.487 1.776 0 .691-.152 1.283-.455 1.775-.304.492-.676.738-1.116.738-.419 0-.783-.138-1.092-.416-.308-.277-.557-.657-.746-1.139l-1.288.534c.261.796.665 1.427 1.21 1.893.544.466 1.183.699 1.916.699.974 0 1.767-.393 2.38-1.178.613-.785.919-1.754.919-2.906 0-.932-.21-1.743-.628-2.435-.42-.69-1.037-1.167-1.854-1.43l2.326-4.006v-.77h-6.177L8.64 13.419 6.362 5.674h-1.65l.754 2.529-1.54 5.215L1.65 5.674zm17.44 8.88s.233.755.379 1.076c.084.185.342.75.708 1.24.341.46 1.004 1.248 2.011 1.426 1.008.178 1.7-.274 1.871-.384.172-.11.533-.412.761-.657.239-.255.465-.58.59-.775.091-.143.24-.432.24-.432l-.241-1.255s-.418.748-.678 1.036c-.261.288-.727.794-1.302 1.048-.576.253-.877.302-1.446.247-.569-.054-1.097-.383-1.282-.52-.185-.138-.658-.542-.925-.92-.268-.376-.686-1.13-.686-1.13z",source:"https://www.w3.org/Consortium/Legal/logo-usage-20000308",hex:"005A9C",guidelines:void 0,license:{type:"custom",url:"https://www.w3.org/Consortium/Legal/2002/trademark-license-20021231"}},siWagtail={title:"Wagtail",slug:"wagtail",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Wagtail</title><path d="'+this.path+'"/></svg>'},path:"M16.1812 0c-2.641 0-4.11 1.969-4.732 3.313L4.0175 16.9734l2.0979-.3927L2.2627 24l2.688-.4822 2.0433-5.8379c5.8146 0 13.279-2.0877 12.2382-9.9063 0 0-.634-3.151-4.7436-2.3013-.4163-1.4205-.3419-2.4749.5662-3.4343 1.2487-1.3192 3.1822-.5958 3.1822-.5958l.002-1.0877C17.5596.0565 16.9059 0 16.1813 0zm2.417 2.5229a.4955.4955 0 1 0 0 .991.4955.4955 0 0 0 0-.991zm1.502 1.029l-1.2918 1.5742h2.9289zM16.374 8.3422l.3033.0105-.0407.5502-.0374.2886c-.0144.1048-.0252.2188-.051.3388l-.0737.383-.1068.4193c-.0422.1448-.0937.2935-.1428.4484a14.128 14.128 0 0 1-.1863.4678l-.1128.2374-.0574.1207-.066.1184-.1343.2399c-.0502.0778-.1008.1563-.152.2354l-.0772.119-.0853.1146c-.0578.0762-.1137.1546-.1741.2303-.1258.1472-.2494.2993-.3902.438-.1335.1453-.2843.2754-.4312.4097l-.231.19c-.0764.0644-.1598.12-.2393.1803-.3235.2336-.6618.4464-1.01.626-.3473.1805-.697.3432-1.0442.4767-.3467.1351-.686.2538-1.0122.3513-.3253.1004-.6363.1829-.9243.2547-.5762.1422-1.061.2393-1.4002.3065l-.5337.1026.531-.1155c.3374-.0754.8196-.184 1.391-.3397.2855-.0785.5935-.1682.9148-.276.3223-.1047.6567-.2308.9972-.373.3413-.1407.6833-.31 1.0217-.4962.3392-.1853.6668-.4028.9782-.6391.0764-.0611.1567-.1172.2298-.182l.2212-.191c.1401-.1346.2841-.2646.4104-.4091.1337-.138.2499-.2887.3685-.4341.0567-.0747.109-.1521.1632-.2271l.08-.1128.0719-.1168.1413-.231.1241-.2348.0609-.1155.0526-.118.1033-.2314c.061-.1552.1165-.3078.1688-.4556.0438-.1509.09-.2953.1274-.436l.0934-.4074.0623-.3721c.0223-.1163.03-.2273.0415-.3291.0108-.102.0208-.1956.0296-.2803l.0267-.5345Z",source:"https://github.com/wagtail/wagtail/blob/e3e46e23b780aa2b1b521de081cb81872f77466d/wagtail/admin/static_src/wagtailadmin/images/wagtail-logo.svg",hex:"43B1B0",guidelines:void 0,license:void 0},siWakatime={title:"WakaTime",slug:"wakatime",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>WakaTime</title><path d="'+this.path+'"/></svg>'},path:"M12 0C5.373 0 0 5.373 0 12s5.373 12 12 12 12-5.373 12-12S18.627 0 12 0zm0 2.824a9.176 9.176 0 1 1 0 18.352 9.176 9.176 0 0 1 0-18.352zm5.097 5.058c-.327 0-.61.19-.764.45-1.025 1.463-2.21 3.162-3.288 4.706l-.387-.636a.897.897 0 0 0-.759-.439.901.901 0 0 0-.788.492l-.357.581-1.992-2.943a.897.897 0 0 0-.761-.446c-.514 0-.903.452-.903.96a1 1 0 0 0 .207.61l2.719 3.96c.152.272.44.47.776.47a.91.91 0 0 0 .787-.483c.046-.071.23-.368.314-.504l.324.52c-.035-.047.076.113.087.13.024.031.054.059.078.085.019.019.04.036.058.052.036.033.08.056.115.08.025.016.052.028.076.04.029.015.06.024.088.035.058.025.122.027.18.04.031.004.064.003.092.005.29 0 .546-.149.707-.36 1.4-2 2.842-4.055 4.099-5.849A.995.995 0 0 0 18 8.842c0-.508-.389-.96-.903-.96",source:"https://wakatime.com/legal/logos-and-trademark-usage",hex:"000000",guidelines:"https://wakatime.com/legal/logos-and-trademark-usage",license:void 0},siWalkman={title:"WALKMAN",slug:"walkman",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>WALKMAN</title><path d="'+this.path+'"/></svg>'},path:"M16.838 6.377a3.624 3.624 0 0 0-.833.086c-1.696.375-2.56 1.674-2.535 3.027.022 1.328-.592 2.51-1.911 2.663-1.28.154-1.861-.835-1.946-2.009-.083-1.159-.875-2.076-2.099-1.802-1.044.227-1.785 1.163-1.846 2.339-.065 1.22-.547 2.24-1.425 2.343-.841.097-1.261-.933-1.317-1.75-.054-.803-.453-1.822-1.497-1.59C.446 9.9.017 11.128.001 11.94c-.017.82.333 1.914 1.27 1.853.726-.048 1.275.636 1.291 1.67.014 1.008.568 2.16 1.665 2.162 1.16 0 1.799-.982 1.828-2.366.027-1.2.757-2.06 1.555-2.147.827-.087 1.588.635 1.674 1.957.091 1.344.77 2.517 2.568 2.517 1.947 0 2.457-1.477 2.421-2.889-.036-1.397 1.03-2.367 2.318-2.544 1.404-.192 2.862-1.246 2.687-3.382-.138-1.701-1.242-2.374-2.44-2.393zm3.999 5.638a3.909 3.909 0 0 0-.318.02c-1.6.16-2.762 1.27-2.644 2.893.12 1.65 1.47 2.679 3.133 2.679 1.769 0 3.165-1.154 2.975-2.992-.178-1.69-1.571-2.632-3.146-2.6Z",source:"https://en.wikipedia.org/wiki/File:Walkman_logo.svg",hex:"000000",guidelines:void 0,license:void 0},siWalmart={title:"Walmart",slug:"walmart",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Walmart</title><path d="'+this.path+'"/></svg>'},path:"M21.41818 9.10219c-.22048 0-.39583.12308-.39583.27297l.13393 1.51627c.01478.09132.12669.16185.26197.16185.13555-.00017.24705-.07065.26214-.16185l.13424-1.51627c0-.1499-.17555-.27297-.39645-.27297zM-.00002 10.3184s.59713 2.44699.69242 2.84417c.11123.46362.3117.63419.88954.51913l.37291-1.51718c.0945-.37683.1579-.64553.21866-1.02883h.01065c.04269.3871.10354.65314.18131 1.03017 0 0 .15176.68869.22949 1.05042.07795.36163.29482.5895.86083.46542l.88851-3.3633h-.71735l-.30339 1.45411c-.08155.42325-.15544.75396-.21251 1.14117h-.01022c-.05189-.38347-.11777-.70096-.20072-1.11331l-.31586-1.48197h-.7474l-.3378 1.44462c-.09569.43899-.18528.79337-.2422 1.16745h-.01023c-.05832-.35224-.13599-.7977-.22006-1.22261 0 0-.20074-1.03328-.27115-1.38946zm6.83845 0v3.3633h.68299v-3.3633zm9.6188 0v2.48118c0 .34202.0644.5817.20213.72811.12033.12806.31854.21094.55604.21094.20193 0 .40062-.0383.49426-.07317l-.0088-.53367c-.06968.01711-.1498.03078-.25942.03078-.23265 0-.31068-.149-.31068-.45611v-.94921h.59479v-.64351h-.59481v-.79533zm2.77885 0c-.11446.0027-.24452.08936-.32723.23277-.11062.19096-.09105.40434.03838.47923l1.3799.64254c.0862.03205.20323-.02912.27103-.14597.06814-.11745.0629-.2496-.0088-.3082l-1.24635-.8741c-.03237-.01874-.06877-.02717-.10693-.02627zm4.36427 0c-.03815-.0009-.0745.0075-.1068.02628l-1.2464.8741c-.07112.05846-.07653.1901-.0092.30734.00006.00013.00015.00023.00025.00036.00009.00016.00015.00033.00024.00049.06804.11686.18472.17803.27091.14598l1.38004-.64254c.12997-.0749.14861-.28827.03874-.47923-.08309-.1434-.21333-.23006-.32777-.23277zM5.312 11.0981c-.42444 0-.76136.11916-.94501.22529l.13442.46019c.16808-.10595.43566-.19366.68907-.19366.41954-.0011.48817.23728.48817.39012v.03613c-.9142-.0014-1.49164.31493-1.49164.9598 0 .3937.29399.76266.80512.76266.31466 0 .57778-.12554.73548-.32662h.01545s.10445.4367.67982.26969c-.03022-.18174-.04002-.37546-.04002-.60884v-.89849c0-.57263-.24452-1.07627-1.07086-1.07627zm4.08552 0c-.42739 0-.61944.2166-.7359.40034h-.01016v-.34335h-.65173v2.5266h.68658V12.2c0-.06945.00799-.1429.03223-.2068.05689-.1492.19565-.3237.41725-.3237.27704 0 .40667.2342.40667.57222v1.44h.68585v-1.4996c0-.06636.0091-.14622.02859-.20486.05639-.16969.20602-.30776.41201-.30776.28086 0 .41567.23012.41567.62788v1.38434h.68633v-1.48805c0-.78478-.39845-1.09555-.8483-1.09555-.19922 0-.35646.04996-.49863.13722-.1195.07334-.22655.17753-.32006.3147h-.0101c-.10853-.27228-.36375-.45192-.6963-.45192zm3.7702 0c-.42435 0-.76113.11916-.94495.22529l.13454.46019c.16792-.10595.43572-.19366.689-.19366.41926-.0011.48806.23728.48806.39012v.03613c-.91407-.0014-1.49164.31494-1.49164.9598 0 .3937.29418.76266.8056.76266.31441 0 .57759-.12554.735-.32662h.01557s.10437.4367.67982.26969c-.03027-.18174-.03996-.37546-.03996-.60884v-.89849c0-.57263-.24458-1.07627-1.07104-1.07627zm2.85129 0c-.26292 0-.56205.1697-.68761.53354h-.0191v-.47655h-.6181v2.5266h.70453V12.388c0-.06985.0042-.1307.01527-.1865.0521-.27102.25945-.44425.55696-.44425.08167 0 .1401.0088.20333.018v-.66151c-.05302-.0107-.0893-.01563-.15528-.01563zm4.35946 1.22067c-.01785-.00025-.03513.0026-.05134.0087l-1.3799.6418c-.12943.07519-.149.28868-.03838.47984.11028.1906.30469.28118.43415.20644l1.24634-.87349c.0717-.05929.07696-.19127.0088-.30862l.0006.00025c-.05507-.09558-.14292-.15388-.22027-.15492zm2.07955 0c-.07727.001-.1649.05934-.22012.15491l.00049-.00025c-.06781.11735-.06254.24934.0088.30862l1.2464.87349c.12921.07474.3238-.01584.43458-.20644.10986-.19116.09122-.40466-.03875-.47983l-1.38012-.64181c-.0162-.0061-.03344-.0089-.05128-.0087zm-16.75741.14518v.31519c0 .0466-.00406.09467-.01697.13673-.05286.17506-.23415.32303-.46086.32303-.18901 0-.33916-.1073-.33916-.33422 0-.34707.38204-.443.81699-.44073zm7.85577 0v.31519c0 .0466-.0041.09467-.0169.13673-.05287.17506-.23421.32303-.46093.32303-.18905 0-.3392-.1073-.3392-.33422 0-.34707.38209-.443.81703-.44073zm7.86138.48324c-.13506.00016-.24672.07024-.26148.16137l-.13393 1.5162c0 .15015.17535.27304.39583.27304.2209 0 .39645-.12289.39645-.27303l-.13424-1.51621c-.01509-.09113-.12659-.1612-.26214-.16137z",source:"https://corporate.walmart.com",hex:"0071CE",guidelines:"https://one.walmart.com/content/people-experience/associate-brand-center.html",license:void 0},siDaserste={title:"Das Erste",slug:"daserste",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Das Erste</title><path d="'+this.path+'"/></svg>'},path:"M11.646.005C5.158.2-.001 5.57 0 12.127.135 18.724 5.468 24 12 24s11.865-5.276 12-11.873C24.001 5.291 18.41-.195 11.645.005zm5.138 4.93V16.96L8.78 19.92v-9.08l-3.9 1.386V9.263l11.903-4.328z",source:"https://en.wikipedia.org/wiki/Das_Erste",hex:"001A4B",guidelines:void 0,license:void 0},siWappalyzer={title:"Wappalyzer",slug:"wappalyzer",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Wappalyzer</title><path d="'+this.path+'"/></svg>'},path:"M24 11.014v-.604L12 1.805 0 10.41v.603l12 8.606 12-8.605zM8.634 10.82l2.75 1.07.016-.01-1.526-1.967.984-.72 2.695 1.116.016-.011-1.463-2.018 1.247-.913 2.6 3.85-1.046.766-2.797-1.157-.012.008 1.593 2.038-1.048.767-5.26-1.903 1.251-.916zm14.418 1.488l.947.679v.603l-12 8.605L0 13.59v-.603l.947-.678 10.761 7.717.292.21.291-.21 10.762-7.717z",source:"https://www.wappalyzer.com/",hex:"32067C",guidelines:void 0,license:void 0},siWarnerbros={title:"Warner Bros.",slug:"warnerbros",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Warner Bros.</title><path d="'+this.path+'"/></svg>'},path:"M16.5798 10.2379c-.5236 0-.9992.201-2.4648 1.2525v5.6593c2.5407-2.8547 3.2641-4.808 3.2641-5.81-.0026-.7013-.3264-1.1018-.7993-1.1018zm.1998-3.7564c0-1.0047-1.1458-1.8286-2.6646-1.9284v5.234c1.9165-1.1267 2.664-2.2566 2.664-3.3056zm4.5098-2.2211c-.0246-.0998-.05-.1373-.0999-.15l-1.796-.4763-.249-1.0268c-.0127-.0503-.0254-.0878-.0747-.0998l-1.8439-.501-.2238-.9773a.1372.1372 0 00-.1-.1253L12.1154.0111a.6414.6414 0 00-.2372 0l-4.789.8928a.1372.1372 0 00-.0998.1253l-.2245.9773-1.8432.5003c-.05.012-.062.0496-.0747.0998l-.249 1.0268-1.7914.477c-.0493.0127-.0746.0502-.0992.15a12.9347 12.9347 0 00-.2245 2.4301c0 7.214 3.737 13.4768 9.3174 17.209A.2493.2493 0 0012 24a.2493.2493 0 00.1999-.1005c5.5803-3.7322 9.3173-9.995 9.3173-17.209a12.9906 12.9906 0 00-.2284-2.4301zm-9.9922 16.3208c0 .0503-.05.075-.0992.0248-1.3703-1.5774-2.2916-3.5058-2.9144-5.6097l-.9466.6028c-.2491.1755-.4483.1005-.5995-.1748-1.2704-2.254-2.0924-5.9614-2.167-8.565a.4522.4522 0 01.1246-.3255 11.8352 11.8352 0 011.0958-1.1521c.0746-.075.1499-.0255.1499.0998 0 3.2057.5475 6.1858 1.4195 8.1396.0746.15.1492.15.2492.075l.2737-.1754c-.5229-2.329-.822-5.4343-.7474-9.0158 0-.1253.0253-.1755.1-.225a8.7268 8.7268 0 011.195-.6264c.1246-.0502.1499-.0247.1499.075-.0706 5.2086.3544 8.8136 1.2743 11.6938.0247.075.0993.0495.0993-.0255-.05-1.0516-.05-1.978-.05-3.1053l-.0493-8.991c0-.0998.0247-.15.1246-.1748a9.9022 9.9022 0 011.245-.2257.0664.0664 0 01.0557.019.0672.0672 0 01.019.056zm1.4949.0248c-.05.0503-.1.0255-.1-.0248V2.9757a.0672.0672 0 01.019-.056.0664.0664 0 01.0557-.019c3.3373.2257 5.4797 1.6283 5.4797 3.6565a3.4113 3.4113 0 01-.872 2.2774c1.0958.3007 1.5195 1.1273 1.5195 2.2292.002 1.9538-1.4176 5.185-6.1 9.5422Z",source:"https://www.warnerbros.com/",hex:"004DB4",guidelines:void 0,license:void 0},siWaze={title:"Waze",slug:"waze",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Waze</title><path d="'+this.path+'"/></svg>'},path:"M13.218 0C9.915 0 6.835 1.49 4.723 4.148c-1.515 1.913-2.31 4.272-2.31 6.706v1.739c0 .894-.62 1.738-1.862 1.813-.298.025-.547.224-.547.522-.05.82.82 2.31 2.012 3.502.82.844 1.788 1.515 2.832 2.036a3 3 0 0 0 2.955 3.528 2.966 2.966 0 0 0 2.931-2.385h2.509c.323 1.689 2.086 2.856 3.974 2.21 1.64-.546 2.36-2.409 1.763-3.924a12.84 12.84 0 0 0 1.838-1.465 10.73 10.73 0 0 0 3.18-7.65c0-2.882-1.118-5.589-3.155-7.625A10.899 10.899 0 0 0 13.218 0zm0 1.217c2.558 0 4.967.994 6.78 2.807a9.525 9.525 0 0 1 2.807 6.78A9.526 9.526 0 0 1 20 17.585a9.647 9.647 0 0 1-6.78 2.807h-2.46a3.008 3.008 0 0 0-2.93-2.41 3.03 3.03 0 0 0-2.534 1.367v.024a8.945 8.945 0 0 1-2.41-1.788c-.844-.844-1.316-1.614-1.515-2.11a2.858 2.858 0 0 0 1.441-.846 2.959 2.959 0 0 0 .795-2.036v-1.789c0-2.11.696-4.197 2.012-5.861 1.863-2.385 4.62-3.726 7.6-3.726zm-2.41 5.986a1.192 1.192 0 0 0-1.191 1.192 1.192 1.192 0 0 0 1.192 1.193A1.192 1.192 0 0 0 12 8.395a1.192 1.192 0 0 0-1.192-1.192zm7.204 0a1.192 1.192 0 0 0-1.192 1.192 1.192 1.192 0 0 0 1.192 1.193 1.192 1.192 0 0 0 1.192-1.193 1.192 1.192 0 0 0-1.192-1.192zm-7.377 4.769a.596.596 0 0 0-.546.845 4.813 4.813 0 0 0 4.346 2.757 4.77 4.77 0 0 0 4.347-2.757.596.596 0 0 0-.547-.845h-.025a.561.561 0 0 0-.521.348 3.59 3.59 0 0 1-3.254 2.061 3.591 3.591 0 0 1-3.254-2.061.64.64 0 0 0-.546-.348z",source:"https://www.waze.com/",hex:"33CCFF",guidelines:void 0,license:void 0},siWearos={title:"Wear OS",slug:"wearos",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Wear OS</title><path d="'+this.path+'"/></svg>'},path:"M8.416 21.1346c-.9687 0-1.8938-.56-2.3135-1.5015L.2193 6.4198C-.3488 5.1432.2248 3.6472 1.5014 3.079c1.2767-.5681 2.7727.0055 3.3408 1.2821l5.8832 13.2133c.5681 1.2767-.0055 2.7727-1.2821 3.3408a2.5254 2.5254 0 01-1.0273.2194zm7.1952.0368c-.891 0-1.7412-.515-2.1268-1.3816L7.39 6.1024C6.867 4.9279 7.3955 3.5532 8.5686 3.03c1.173-.5218 2.5492.0054 3.0724 1.1785l6.0943 13.6888c.5232 1.1745-.0054 2.5492-1.1785 3.0724a2.3111 2.3111 0 01-.9456.2017zM24 5.195a2.3271 2.3271 0 01-2.3271 2.327 2.3271 2.3271 0 01-2.3271-2.327 2.3271 2.3271 0 012.327-2.3271A2.3271 2.3271 0 0124 5.1949zm-2.6119 5.116a2.4892 2.4892 0 01-2.4892 2.4893 2.4892 2.4892 0 01-2.4893-2.4892 2.4892 2.4892 0 012.4893-2.4893 2.4892 2.4892 0 012.4892 2.4893Z",source:"https://partnermarketinghub.withgoogle.com/#/brands/",hex:"4285F4",guidelines:void 0,license:void 0},siWeb3dotjs={title:"Web3.js",slug:"web3dotjs",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Web3.js</title><path d="'+this.path+'"/></svg>'},path:"M.889.775S0 1.29 0 2.315V7.44s0 3.079 2.666 4.618c.817.472 1.384.508 1.777.334.394.628.96 1.246 1.778 1.718 2.666 1.54 2.668-1.539 2.668-1.539V7.447c0-1.027.888-1.539.888-1.539l3.557-2.054s.89-.514 1.777 0c.89.513 0 1.027 0 1.027L11.56 6.934l1.775 1.025 3.559-2.055c.052-.03.912-.495 1.773.002.89.514 0 1.026 0 1.026l-3.555 2.054s-.888.514-.888 1.54v5.124s0 1.028-.889.514c-.89-.513-.89-1.539-.89-1.539l-1.778-1.027s.001 3.08 2.668 4.619c2.667 1.539 2.666-1.54 2.666-1.54v-5.126c0-1.026.889-1.537.889-1.537l4.445-2.569s1.776-1.025-.889-2.564c-.819-.474-1.552-.704-2.177-.797-.164-.357-.565-.776-1.377-1.24-2.667-1.523-5.332-.016-5.332-.016L8.004 4.881s-.89.514-.89 1.539v5.125s0 1.027-.89.514c-.889-.514-.89-1.54-.89-1.54V5.396c0-.064.003-.127.01-.188.097-.902.879-1.353.879-1.353L4.445 2.828l-.004.002c-.052.03-.884.544-.884 1.537v5.125s-.002 1.027-.891.514c-.89-.514-.889-1.54-.889-1.54V3.343c0-1.026.889-1.54.889-1.54L.889.776zm9.78 8.735v2.053l1.778 1.025v-2.053L10.67 9.51zm8.442 2.183c-.666.005-1.332.389-1.332 1.909 0 3.039 2.666 4.619 2.666 4.619l.889.513s.89.514.89 1.54-.89.513-.89.513l-3.555-2.053v2.053l3.555 2.053S24 24.379 24 21.3c0-3.077-1.777-4.105-1.777-4.105l-1.778-1.025s-.888-.514-.888-1.54c0-1.028.888-.515.888-.515L24 16.168v-2.053l-3.555-2.05s-.667-.376-1.334-.372Z",source:"https://github.com/ChainSafe/web3.js/blob/fdbda4958cbdbaebe8ed5ea59183582b07fac254/assets/logo/web3js.svg",hex:"F16822",guidelines:void 0,license:void 0},siWebassembly={title:"WebAssembly",slug:"webassembly",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>WebAssembly</title><path d="'+this.path+'"/></svg>'},path:"M14.745,0c0,0.042,0,0.085,0,0.129c0,1.52-1.232,2.752-2.752,2.752c-1.52,0-2.752-1.232-2.752-2.752 c0-0.045,0-0.087,0-0.129H0v24h24V0H14.745z M11.454,21.431l-1.169-5.783h-0.02l-1.264,5.783H7.39l-1.824-8.497h1.59l1.088,5.783 h0.02l1.311-5.783h1.487l1.177,5.854h0.02l1.242-5.854h1.561l-2.027,8.497H11.454z M20.209,21.431l-0.542-1.891h-2.861l-0.417,1.891 h-1.59l2.056-8.497h2.509l2.5,8.497H20.209z M17.812,15.028l-0.694,3.118h2.159l-0.796-3.118H17.812z",source:"https://webassembly.org/",hex:"654FF0",guidelines:void 0,license:void 0},siWebcomponentsdotorg={title:"webcomponents.org",slug:"webcomponentsdotorg",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>webcomponents.org</title><path d="'+this.path+'"/></svg>'},path:"M11.731 2.225l-.01.016H5.618L0 11.979l5.618 9.736h12.8l.04.06 2.134-3.735.518-.893h-.008l.008-.014-.626-.75h.895l.006-.01.008.01L24 11.994l-2.607-4.39-.003.005-.011-.02h-.945l.63-.763-2.606-4.57-.006.01-.024-.04H11.73zM9.107 6.824h6.19l-.53.764h-.023l2.398 4.015h.875l-.277.328.357.435h-.956l-2.398 4.015h.027l.523.764H9.074l-2.99-5.168 3.022-5.155z",source:"https://www.webcomponents.org/",hex:"29ABE2",guidelines:void 0,license:void 0},siWebdriverio={title:"WebdriverIO",slug:"webdriverio",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>WebdriverIO</title><path d="'+this.path+'"/></svg>'},path:"M1.875 0C0.836 0 0 0.836 0 1.875v20.25C0 23.164 0.836 24 1.875 24h20.25C23.164 24 24 23.164 24 22.125V1.875C24 0.836 23.164 0 22.125 0ZM2.25 6H3V18H2.25ZM9.335 6H10.125L5.29 18H4.499ZM16.125 6c3.314 0 6 2.686 6 6 0 3.314-2.686 6-6 6-3.314 0-6-2.686-6-6 0-3.314 2.686-6 6-6zm0 0.75c-2.899 0-5.25 2.351-5.25 5.25 0 2.899 2.351 5.25 5.25 5.25 2.899 0 5.25-2.351 5.25-5.25 0-2.899-2.351-5.25-5.25-5.25z",source:"https://webdriver.io/docs/api/",hex:"EA5906",guidelines:void 0,license:void 0},siWebflow={title:"Webflow",slug:"webflow",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Webflow</title><path d="'+this.path+'"/></svg>'},path:"M17.802 8.56s-1.946 6.103-2.105 6.607a4778.8 4778.8 0 0 0-1.484-11.473c-3.316 0-5.089 2.36-6.026 4.851l-2.565 6.637c-.015-.476-.36-6.565-.36-6.565-.204-3.052-3-4.91-5.262-4.91l2.739 16.6c3.474-.015 5.347-2.361 6.328-4.852 0 0 2.09-5.398 2.176-5.643.015.23 1.5 10.494 1.5 10.494 3.488 0 5.362-2.202 6.37-4.606L24 3.708c-3.445 0-5.261 2.346-6.198 4.851Z",source:"https://webflow.com/",hex:"4353FF",guidelines:void 0,license:void 0},siWebgl={title:"WebGL",slug:"webgl",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>WebGL</title><path d="'+this.path+'"/></svg>'},path:"M18.928 14.179c-.214.09-.427.135-.643.135-.342 0-.65-.059-.923-.178a1.963 1.963 0 0 1-.69-.491c-.187-.209-.332-.453-.432-.735s-.149-.586-.149-.911c0-.335.05-.643.149-.93.1-.287.242-.536.429-.747a1.96 1.96 0 0 1 .69-.501 2.25 2.25 0 0 1 .923-.183c.23 0 .451.036.664.104.214.069.408.171.581.304s.316.299.427.496a1.7 1.7 0 0 1 .206.676h-.935c-.059-.249-.171-.437-.337-.562a.973.973 0 0 0-.607-.187c-.221 0-.408.043-.562.128s-.28.199-.375.344c-.095.145-.166.308-.209.491s-.066.372-.066.569c0 .187.021.37.066.548.043.178.114.337.209.479.095.142.221.256.375.342s.342.128.562.128c.325 0 .577-.083.754-.247.178-.164.28-.401.311-.714h-.987V11.8h1.872v2.413h-.624l-.1-.505a1.444 1.444 0 0 1-.579.471zm2.896-4.429v3.632H24v.828h-3.155V9.75h.979zM2.785 11.999c0-.709.343-1.376.948-1.962l1.109 4.221h.764l1.075-3.815 1.06 3.815h.766l1.321-4.856h-.86l-.861 3.725-1.039-3.726H6.28l-1.039 3.725-.84-3.632c1.489-1.025 3.868-1.69 6.548-1.69 2.512 0 4.764.529 6.261 1.445-1.632-1.535-4.565-2.612-7.915-2.614C4.161 6.635 0 9.036 0 11.999s4.161 5.367 9.293 5.367c3.338 0 6.261-1.075 7.9-2.6-1.497.911-3.741 1.428-6.244 1.428-4.51-.001-8.164-1.877-8.164-4.195zm9.194-.553a1.184 1.184 0 0 0-.444-.384 1.378 1.378 0 0 0-.622-.135c-.261 0-.496.047-.7.14a1.313 1.313 0 0 0-.489.387c-.244.311-.372.75-.372 1.269 0 .23.033.448.097.643a1.5 1.5 0 0 0 .285.515c.261.304.633.465 1.077.465.233 0 .422-.024.581-.074.138-.043.23-.1.306-.149a1.357 1.357 0 0 0 .444-.489c.09-.166.135-.323.145-.403l.007-.055h-.633l-.002.045c-.017.206-.287.574-.769.574-.688 0-.852-.498-.864-.937h2.306v-.05a3.15 3.15 0 0 0-.085-.766 1.84 1.84 0 0 0-.268-.596zm-1.139.05c.51 0 .783.275.833.84h-1.651c.025-.458.388-.84.818-.84zm4.678.415a1.575 1.575 0 0 0-.268-.515 1.25 1.25 0 0 0-.437-.346 1.36 1.36 0 0 0-.586-.126 1.141 1.141 0 0 0-.531.128 1.1 1.1 0 0 0-.346.28v-1.49h-.631v4.413h.6v-.301a.964.964 0 0 0 .211.206c.171.123.382.185.626.185.263 0 .501-.059.7-.176.178-.104.33-.254.448-.444a1.93 1.93 0 0 0 .235-.584 2.66 2.66 0 0 0 .069-.603 1.986 1.986 0 0 0-.09-.627zm-.567.717c0 .346-.069.636-.202.84a.682.682 0 0 1-.605.325c-.377 0-.819-.263-.819-1.008 0-.356.045-.631.135-.84.13-.301.351-.446.671-.446.342 0 .572.133.7.41.106.227.12.505.12.719z",source:"https://www.khronos.org/legal/trademarks/",hex:"990000",guidelines:"https://www.khronos.org/legal/trademarks/",license:void 0},siWebhint={title:"webhint",slug:"webhint",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>webhint</title><path d="'+this.path+'"/></svg>'},path:"M12 0C5.335 0 0 5.334 0 12c0 6.667 5.334 12 12 12 6.667 0 12-5.333 12-12-.06-6.666-5.393-12-12-12zm0 1.333c5.846.06 10.552 4.82 10.546 10.667 0 5.818-4.727 10.606-10.606 10.606S1.394 17.817 1.394 11.939C1.394 6.062 6.174 1.333 12 1.333zm7.334 5.273l-2.667 1.576c-.06.06-.122.06-.182.12a.843.843 0 000 1.152c.12.122.243.183.364.183.303.06.605 0 .787-.183.06-.06.122-.121.183-.242l.363-.727zM13.516 8c-4.121 0-4.788 1.94-4.788 4.364.06.606 0 1.212-.303 1.758-.303.545-.91.908-1.516.847-.242 0-1.151-.181-1.212-.423h.121c.97 0 1.758-.788 1.758-1.819v-.485h-.849c-.606 0-1.151.304-1.515.788a2.152 2.152 0 00-1.576-.726h-.848v.363c0 1.03.849 1.879 1.94 1.879h.303c0 .606.848 3.03 7.09 3.03 2.425 0 6.061-.425 6.061-5.03-.06-.789-.303-1.637-.727-2.303-.182.06-.303.06-.485.06a1.344 1.344 0 01-1.333-1.333c0-.121 0-.303.06-.425A3.565 3.565 0 0013.516 8z",source:"https://github.com/webhintio/webhint.io/blob/5c9f10a33a6d68e1f0d2b1eff0829685b9123433/src/webhint-theme/source/images/webhint-logo.svg",hex:"4700A3",guidelines:void 0,license:void 0},siWeblate={title:"Weblate",slug:"weblate",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Weblate</title><path d="'+this.path+'"/></svg>'},path:"M9.662 3.809c-1.875 1.19-2.81 3.515-2.83 5.795-.014 2.628.666 5.258 1.988 7.305.936 1.46 2.238 2.715 3.836 3.412a6.942 6.942 0 005.647-.07c1.997-.927 3.523-2.73 4.463-4.785 1.606-3.518 1.643-7.724.12-11.295-1.146.458-2.166-.271-2.166-.271s.003 1.122-1.083 1.685c1.115 2.612 1.088 5.717-.03 8.263-.538 1.225-1.358 2.365-2.498 3.01-.917.52-2.04.625-3.052.184-1.342-.585-2.293-1.864-2.89-3.254-.466-1.067-.782-2.447-.802-3.878-.037-1.724.728-3.193 1.635-3.218.622-.024 1.427.918 1.598 2.435.158 1.543-.177 3.72-1.174 5.49.677 1.085 1.77 1.98 2.951 1.974 1.386-2.338 1.827-4.911 1.793-6.987-.02-2.28-.955-4.603-2.83-5.795-1.437-.907-3.173-.948-4.676 0zM3.278 3.9s-1.018.73-2.163.27c-1.524 3.573-1.488 7.778.12 11.296.94 2.056 2.465 3.858 4.462 4.785a6.95 6.95 0 005.523.124 9.12 9.12 0 01-1.75-1.455 11.18 11.18 0 01-1.267-1.628c-.768-.08-1.498-.482-2.003-.913-1.447-1.213-2.453-3.478-2.632-5.9-.12-1.635.14-3.354.795-4.894C3.276 5.022 3.278 3.9 3.278 3.9z",source:"https://github.com/WeblateOrg/graphics/blob/669e4f910abd9ec36fda172d2ea6f2f424a32ace/logo/weblate-black.svg",hex:"2ECCAA",guidelines:void 0,license:{type:"GPL-3.0-only",url:"https://spdx.org/licenses/GPL-3.0-only"}},siWebmoney={title:"WebMoney",slug:"webmoney",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>WebMoney</title><path d="'+this.path+'"/></svg>'},path:"M11.943.1825c1.8723 0 3.6538.429 5.2524 1.1964.2507.1131.503.2485.7529.384l-1.0961.971-1.6433-1.6933-2.8315 2.483L10.71 1.74 5.5032 6.368l3.3336 3.6347-1.3014 1.1285 3.2889 3.6346-1.3015 1.128 4.7045 5.1698 2.7844-2.5285 2.4217 2.7097c-.48.3613-1.0052.7232-1.5754 1.0387a12.0418 12.0418 0 0 1-5.892 1.534C5.3657 23.8175 0 18.5135 0 11.9899-.0231 5.5104 5.3435.1825 11.943.1825zM9.7502 11.267l2.8546-2.5285 2.5582 2.8218-2.8552 2.5283zm2.033 4.8764l2.8314-2.551 2.5807 2.8216-2.8548 2.5286zM7.719 6.4587l2.8537-2.5285 2.5577 2.8217-2.8548 2.5285zm5.2284-1.355l2.124-1.8961L16.99 5.307l-2.124 1.9186zm3.7912 8.6914l2.1232-1.8963 1.9186 2.1215-2.124 1.8975zm1.8723 4.267l2.124-1.8966 1.9171 2.0995-2.1232 1.9183zm.868-9.7527l1.4156-1.2643 1.2784 1.4002-1.4155 1.2638zM17.652 4.133l1.4158-1.2864 1.2793 1.422-1.4168 1.2641zm3.6308 8.3531l1.4156-1.2642L24 12.6216l-1.4381 1.2639zm-6.3711-3.138l2.124-1.8963 1.9178 2.099-2.1231 1.8967Z",source:"https://www.webmoney.ru/rus/developers/logos.shtml",hex:"036CB5",guidelines:void 0,license:void 0},siWebpack={title:"Webpack",slug:"webpack",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Webpack</title><path d="'+this.path+'"/></svg>'},path:"M22.1987 18.498l-9.7699 5.5022v-4.2855l6.0872-3.3338 3.6826 2.117zm.6683-.6026V6.3884l-3.5752 2.0544v7.396zm-21.0657.6026l9.7699 5.5022v-4.2855L5.484 16.3809l-3.6826 2.117zm-.6683-.6026V6.3884l3.5751 2.0544v7.396zm.4183-12.2515l10.0199-5.644v4.1434L5.152 7.6586l-.0489.028zm20.8975 0l-10.02-5.644v4.1434l6.4192 3.5154.0489.028 3.5518-2.0427zm-10.8775 13.096l-6.0056-3.2873V8.9384l6.0054 3.4525v6.349zm.8575 0l6.0053-3.2873V8.9384l-6.0053 3.4525zM5.9724 8.1845l6.0287-3.3015L18.03 8.1845l-6.0288 3.4665z",source:"https://webpack.js.org/branding/",hex:"8DD6F9",guidelines:void 0,license:void 0},siWebrtc={title:"WebRTC",slug:"webrtc",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>WebRTC</title><path d="'+this.path+'"/></svg>'},path:"M11.9998.3598c-2.8272 0-5.1456 2.1733-5.3793 4.94a5.4117 5.4117 0 00-1.2207-.1401C2.418 5.1597 0 7.5779 0 10.5603c0 2.2203 1.341 4.1274 3.2568 4.957a5.3734 5.3734 0 00-.7372 2.7227c0 2.9823 2.4175 5.4002 5.4002 5.4002 1.6627 0 3.1492-.7522 4.1397-1.934.9906 1.1818 2.4773 1.934 4.1398 1.934 2.983 0 5.4004-2.418 5.4004-5.4002 0-.9719-.258-1.883-.7073-2.6708C22.7283 14.7068 24 12.8418 24 10.6795c0-2.9823-2.4175-5.4006-5.3998-5.4006-.417 0-.8223.049-1.2121.1384C17.2112 2.5949 14.867.3598 11.9998.3598zm-5.717 6.8683h10.5924c.7458 0 1.352.605 1.352 1.3487v7.6463c0 .7438-.6062 1.3482-1.352 1.3482h-3.6085l-7.24 3.5491 1.1008-3.5491h-.8447c-.7458 0-1.3522-.6044-1.3522-1.3482V8.5768c0-.7438.6064-1.3487 1.3522-1.3487Z",source:"https://webrtc.org/",hex:"333333",guidelines:void 0,license:void 0},siWebstorm={title:"WebStorm",slug:"webstorm",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>WebStorm</title><path d="'+this.path+'"/></svg>'},path:"M0 0v24h24V0H0zm17.889 2.889c1.444 0 2.667.444 3.667 1.278l-1.111 1.667c-.889-.611-1.722-1-2.556-1s-1.278.389-1.278.889v.056c0 .667.444.889 2.111 1.333 2 .556 3.111 1.278 3.111 3v.056c0 2-1.5 3.111-3.611 3.111-1.5-.056-3-.611-4.167-1.667l1.278-1.556c.889.722 1.833 1.222 2.944 1.222.889 0 1.389-.333 1.389-.944v-.056c0-.556-.333-.833-2-1.278-2-.5-3.222-1.056-3.222-3.056v-.056c0-1.833 1.444-3 3.444-3zm-16.111.222h2.278l1.5 5.778 1.722-5.778h1.667l1.667 5.778 1.5-5.778h2.333l-2.833 9.944H9.723L8.112 7.277l-1.667 5.778H4.612L1.779 3.111zm.5 16.389h9V21h-9v-1.5z",source:"https://www.jetbrains.com/company/brand/logos/",hex:"000000",guidelines:"https://www.jetbrains.com/company/brand/",license:void 0},siWebtoon={title:"WEBTOON",slug:"webtoon",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>WEBTOON</title><path d="'+this.path+'"/></svg>'},path:"M15.023 15.26c.695 0 1.014-.404 1.014-1.051 0-.551-.308-1.01-.984-1.01-.58 0-.912.404-.912 1.016 0 .543.32 1.045.882 1.045zM10.135 15.447c.764 0 1.113-.443 1.113-1.154 0-.604-.338-1.109-1.082-1.109-.637 0-1.002.445-1.002 1.115 0 .597.352 1.148.971 1.148zM24 10.201l-3.15.029.83-9.686L1.958 3.605l1.686 6.248H0l3.734 11.488 8.713-1.283v3.396l10.113-4.641L24 10.201zm-9.104-3.594c0-.049.039-.092.088-.094l1.879-.125.446-.029c.524-.035 1.634.063 1.634 1.236 0 .83-.619 1.184-.619 1.184s.75.189.707 1.092c0 1.602-1.943 1.389-1.943 1.389l-.225-.006-1.908-.053a.089.089 0 0 1-.086-.09l.027-4.504zm-3.675.243c0-.047.039-.09.088-.092l3.064-.203a.08.08 0 0 1 .087.08v.943c0 .049-.039.09-.087.092l-1.9.08a.094.094 0 0 0-.088.09l-.005.394a.083.083 0 0 0 .086.084l1.646-.066a.082.082 0 0 1 .086.084l-.02 1.012a.089.089 0 0 1-.089.086h-1.63a.089.089 0 0 0-.088.088v.416c0 .047.039.088.088.088l1.87.033a.09.09 0 0 1 .087.09v.951a.084.084 0 0 1-.087.084l-3.063-.123a.09.09 0 0 1-.087-.09l.042-4.121zm-6.01.312l.975-.064a.101.101 0 0 1 .105.08l.458 2.205c.01.047.027.047.039 0l.576-2.281a.132.132 0 0 1 .108-.09l.921-.061a.108.108 0 0 1 .109.078l.564 2.342c.012.047.029.047.041 0l.6-2.424a.131.131 0 0 1 .108-.092l.996-.064c.048-.004.077.031.065.078l-1.09 4.104a.113.113 0 0 1-.109.082l-1.121-.031a.12.12 0 0 1-.109-.086l-.535-1.965c-.012-.047-.033-.047-.045 0l-.522 1.934a.12.12 0 0 1-.11.082l-1.109-.031a.123.123 0 0 1-.108-.088l-.873-3.618c-.011-.047.019-.088.066-.09zm-.288 9.623v-3.561a.089.089 0 0 0-.087-.088l-1.252-.029a.095.095 0 0 1-.091-.09l-.046-1.125a.082.082 0 0 1 .083-.086l4.047.096c.048 0 .087.041.085.088l-.022 1.088a.093.093 0 0 1-.089.088l-1.139.004a.09.09 0 0 0-.087.088v3.447c0 .049-.039.09-.087.092l-1.227.07a.08.08 0 0 1-.088-.082zm2.834-2.379c0-1.918 1.321-2.482 2.416-2.482s2.339.73 2.339 2.316c0 1.9-1.383 2.482-2.416 2.482-1.033.001-2.339-.724-2.339-2.316zm5.139-.115c0-1.746 1.166-2.238 2.162-2.238s2.129.664 2.129 2.107c0 1.729-1.259 2.26-2.198 2.26s-2.093-.68-2.093-2.129zm7.259 1.711a.175.175 0 0 1-.139-.064l-1.187-1.631c-.029-.039-.053-.031-.053.018v1.67c0 .047-.039.09-.086.092l-1.052.061a.082.082 0 0 1-.087-.082l.039-3.842c0-.047.039-.086.088-.084l.881.02a.2.2 0 0 1 .137.074l1.293 1.902c.027.041.051.033.051-.014l.032-1.846a.087.087 0 0 1 .089-.086l.963.029c.047 0 .085.041.083.09l-.138 3.555a.097.097 0 0 1-.091.092l-.823.046zM16.258 8.23l.724-.014s.47.018.47-.434c0-.357-.411-.33-.411-.33l-.782.008a.09.09 0 0 0-.088.088v.598a.083.083 0 0 0 .087.084zM16.229 10.191h.99c.024 0 .35-.051.35-.404 0-.293-.229-.402-.441-.398l-.898.029a.089.089 0 0 0-.087.09v.596a.086.086 0 0 0 .086.087z",source:"http://webtoons.com/",hex:"00D564",guidelines:void 0,license:void 0},siWechat={title:"WeChat",slug:"wechat",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>WeChat</title><path d="'+this.path+'"/></svg>'},path:"M8.691 2.188C3.891 2.188 0 5.476 0 9.53c0 2.212 1.17 4.203 3.002 5.55a.59.59 0 0 1 .213.665l-.39 1.48c-.019.07-.048.141-.048.213 0 .163.13.295.29.295a.326.326 0 0 0 .167-.054l1.903-1.114a.864.864 0 0 1 .717-.098 10.16 10.16 0 0 0 2.837.403c.276 0 .543-.027.811-.05-.857-2.578.157-4.972 1.932-6.446 1.703-1.415 3.882-1.98 5.853-1.838-.576-3.583-4.196-6.348-8.596-6.348zM5.785 5.991c.642 0 1.162.529 1.162 1.18a1.17 1.17 0 0 1-1.162 1.178A1.17 1.17 0 0 1 4.623 7.17c0-.651.52-1.18 1.162-1.18zm5.813 0c.642 0 1.162.529 1.162 1.18a1.17 1.17 0 0 1-1.162 1.178 1.17 1.17 0 0 1-1.162-1.178c0-.651.52-1.18 1.162-1.18zm5.34 2.867c-1.797-.052-3.746.512-5.28 1.786-1.72 1.428-2.687 3.72-1.78 6.22.942 2.453 3.666 4.229 6.884 4.229.826 0 1.622-.12 2.361-.336a.722.722 0 0 1 .598.082l1.584.926a.272.272 0 0 0 .14.047c.134 0 .24-.111.24-.247 0-.06-.023-.12-.038-.177l-.327-1.233a.582.582 0 0 1-.023-.156.49.49 0 0 1 .201-.398C23.024 18.48 24 16.82 24 14.98c0-3.21-2.931-5.837-6.656-6.088V8.89c-.135-.01-.27-.027-.407-.03zm-2.53 3.274c.535 0 .969.44.969.982a.976.976 0 0 1-.969.983.976.976 0 0 1-.969-.983c0-.542.434-.982.97-.982zm4.844 0c.535 0 .969.44.969.982a.976.976 0 0 1-.969.983.976.976 0 0 1-.969-.983c0-.542.434-.982.969-.982z",source:"https://wechat.design/standard/download/brand",hex:"07C160",guidelines:"https://wechat.design/standard/download/brand",license:void 0},siWegame={title:"WeGame",slug:"wegame",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>WeGame</title><path d="'+this.path+'"/></svg>'},path:"M21.458 11.005c-.024-.179-.078-.632-.165-1.08a8.082 8.082 0 0 0-.255-1.006l-.005-.015a1.87 1.87 0 0 0-.151-.315 1.224 1.224 0 0 0-.317-.354 1.57 1.57 0 0 0-1.412-.138 2.029 2.029 0 0 0-.861 1.064c-.238.465-.475.93-.742 1.378a2.617 2.617 0 0 1-.572.7 1.33 1.33 0 0 1-.367.215c-.534.2-.91-.08-1.321-.403-.438-.342-.824-.744-1.274-1.073a1.851 1.851 0 0 0-.983-.43c-.637-.003-1.195.619-1.544 1.078-.195.258-.577.779-.775 1.033a3.403 3.403 0 0 1-.454.458 1.169 1.169 0 0 1-.196.138 1.101 1.101 0 0 1-.48.136 1.566 1.566 0 0 1-.869-.263 2.678 2.678 0 0 1-.288-.183l-.035-.027a.469.469 0 0 0-.734.428.392.392 0 0 0 .024.136c0 .003.003.005.004.008a.395.395 0 0 0 .093.14c.608.897 1.47 1.55 2.303 1.564a1.507 1.507 0 0 0 .635-.124c.646-.285 1.13-.903 1.67-1.334a1.314 1.314 0 0 1 .776-.33 1.038 1.038 0 0 1 .63.215 2.122 2.122 0 0 1 .189.144 8.916 8.916 0 0 1 .742.753 9.93 9.93 0 0 0 .9.85 2.53 2.53 0 0 0 1.146.56c.046.007.091.011.136.014a1.522 1.522 0 0 0 1.002-.314 4.176 4.176 0 0 0 .745-.689 6.13 6.13 0 0 0 .463-.664c.07-.112.143-.19.2-.308a5.769 5.769 0 0 1-.065.953 10.09 10.09 0 0 1-.212 1.288q-.062.253-.135.503-.116.397-.262.786a1.906 1.906 0 0 1-.072.188l-.003.007q-.088.23-.192.453a7.005 7.005 0 0 1-12.74-.01q-.106-.225-.195-.459l-.004-.009a10.91 10.91 0 0 1 .426-9.024 13.024 13.024 0 0 1 1.635-2.396 8.352 8.352 0 0 1 2.132-1.946c.03-.017.057-.037.086-.055a4.168 4.168 0 0 1 4.57 0l.086.055a11.285 11.285 0 0 1 1.795 1.588l.002.002.052.053a1.183 1.183 0 0 0 .296.212 1.36 1.36 0 0 0 1.493-.211 1.291 1.291 0 0 0 .137-1.672c-.041-.05-.083-.1-.121-.15a8.076 8.076 0 0 0-.722-.763A14.069 14.069 0 0 0 15.375.9a6.85 6.85 0 0 0-.118-.071A6.126 6.126 0 0 0 12.118 0a5.748 5.748 0 0 0-3.033.841 3.166 3.166 0 0 0-.117.071A12.178 12.178 0 0 0 6.003 3.39a.455.455 0 0 1-.024.025 15.477 15.477 0 0 0-3.578 9.8 16.626 16.626 0 0 0 .359 3.444 9.487 9.487 0 0 0 18.478.017l.028-.13a.097.097 0 0 0 .002-.012l.02-.103a15.856 15.856 0 0 0 .286-2.235q.026-.454.026-.91a18.254 18.254 0 0 0-.142-2.28z",source:"https://www.wegame.com.cn",hex:"FAAB00",guidelines:void 0,license:void 0},siDataiku={title:"Dataiku",slug:"dataiku",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Dataiku</title><path d="'+this.path+'"/></svg>'},path:"M12 0a12 12 0 1 0 12 12A12 12 0 0 0 12 0zm6.527 15.34H12.5v-.934h6.026zm-.739-8.73s-.412.543-.193 1.995c.41 2.724-1.02 5.15-3.56 5.15h-1.87s-1.835-.092-2.933 1.01c-3.263 3.269-4.04 4.116-4.274 4.233-.15.08-.188-.093-.188-.093l9.644-11.891c-.203-2.145 2.34-2.715 3.278-1.13l.884-.248zm-1.599-.614a.476.476 0 1 0 .47.474.476.476 0 0 0-.47-.474z",source:"https://www.dataiku.com/company/media-kit/",hex:"2AB1AC",guidelines:void 0,license:void 0},siWeightsandbiases={title:"Weights & Biases",slug:"weightsandbiases",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Weights &amp; Biases</title><path d="'+this.path+'"/></svg>'},path:"M2.48 0a1.55 1.55 0 1 0 0 3.1 1.55 1.55 0 0 0 0-3.1zm19.04 0a1.55 1.55 0 1 0 0 3.101 1.55 1.55 0 0 0 0-3.101zM12 2.295a1.55 1.55 0 1 0 0 3.1 1.55 1.55 0 0 0 0-3.1zM2.48 5.272a2.48 2.48 0 1 0 0 4.96 2.48 2.48 0 0 0 0-4.96zm19.04 0a2.48 2.48 0 1 0 0 4.96 2.48 2.48 0 0 0 0-4.96zM12 8.496a1.55 1.55 0 1 0 0 3.1 1.55 1.55 0 0 0 0-3.1zm-9.52 3.907a1.55 1.55 0 1 0 0 3.1 1.55 1.55 0 0 0 0-3.1zm19.04 0a1.55 1.55 0 1 0 0 3.102 1.55 1.55 0 0 0 0-3.102zM12 13.767a2.48 2.48 0 1 0 0 4.962 2.48 2.48 0 0 0 0-4.962zm-9.52 3.907a2.48 2.48 0 1 0 .001 4.962 2.48 2.48 0 0 0 0-4.962zm19.04.93a1.55 1.55 0 1 0 0 3.102 1.55 1.55 0 0 0 0-3.101zM12 20.9a1.55 1.55 0 1 0 0 3.1 1.55 1.55 0 0 0 0-3.1Z",source:"https://wandb.ai/",hex:"FFBE00",guidelines:void 0,license:void 0},siWelcometothejungle={title:"Welcome to the Jungle",slug:"welcometothejungle",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Welcome to the Jungle</title><path d="'+this.path+'"/></svg>'},path:"M22.62 3.783c-1.115-1.811-4.355-2.604-6.713-.265-.132.135-.306.548.218 1.104 1.097 1.149 6.819 7.046 4.702 12.196-1.028 2.504-3.953 2.073-5.052-2.076a23.184 23.184 0 0 1-.473-9.367s.105-.394-.065-.52c-.117-.087-.305-.05-.547.33-.06.096-.048.076-.106.178l-.003.002c-1.622 2.688-3.272 5.874-4.049 7.07.38-1.803-.101-4.283-.85-6.359l-.142-.375c-.692-1.776-1.524-2.974-1.776-3.245-.03-.033-.105-.094-.353-.094H.398c-.49 0-.448.412-.293.561 1.862 2.178 7.289 10.343 4.773 18.355-.194.619.11.944.612.305 2.206-2.81 4.942-7.598 6.925-11.187-.437 1.245-.822 2.63-1.028 4.083-.435 3.064.487 5.37 1.162 6.58.345.619.803.998 1.988.824 6.045-.885 8.06-6.117 8.805-8.77 1.357-4.839.363-7.568-.722-9.33",source:"https://www.welcometothejungle.com/",hex:"FFCD00",guidelines:void 0,license:void 0},siWemo={title:"WEMO",slug:"wemo",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>WEMO</title><path d="'+this.path+'"/></svg>'},path:"M4.3014 0C1.925 0 0 1.9254 0 4.302v15.3965C0 22.0728 1.925 24 4.3014 24H19.697c2.3757 0 4.3026-1.9272 4.3026-4.3015H24V4.3019C24 1.9258 22.0731 0 19.6974 0zm12.912 4.1665c2.0881 0 3.7885 1.621 3.7885 3.6134 0 .0947-.004.1877-.011.2799l-.0157.1756H14.651l.1142.3244c.3537.9944 1.337 1.6628 2.4478 1.6628.8293 0 1.6137-.383 2.0992-1.0237l.109-.1462.9896.6745-.12.1603c-.7109.9427-1.8618 1.5054-3.0775 1.5054-2.0907 0-3.7912-1.6207-3.7912-3.613 0-1.9924 1.7005-3.6134 3.7912-3.6134zm-13.9374.132h1.2095V8.729c0 .7302.5934 1.3236 1.324 1.3236.7298 0 1.3243-.5934 1.3243-1.3236V4.2986h1.2069v4.4303c0 .7302.5941 1.3236 1.3247 1.3236.7298 0 1.3236-.5934 1.3236-1.3236V4.2986h1.2095v4.4303c0 1.3964-1.136 2.5319-2.5331 2.5319-.648 0-1.2892-.26-1.7604-.7137l-.1683-.1624-.168.1624c-.4712.4537-1.112.7137-1.7592.7137-1.3971 0-2.5335-1.1355-2.5335-2.532zm13.9373 1.0248c-.987 0-1.8822.5172-2.3362 1.3484l-.1946.3586h5.0588l-.1946-.3586c-.4536-.8315-1.3478-1.3484-2.3334-1.3484zm-.0015 7.2326c2.0893 0 3.7895 1.6217 3.7895 3.6137 0 1.993-1.7002 3.6138-3.7895 3.6138-2.0903 0-3.789-1.621-3.789-3.6138 0-1.992 1.699-3.6137 3.789-3.6137zm-11.403.1328c.6482 0 1.2906.2597 1.7618.7134l.1668.1624.1687-.1624c.4719-.4537 1.1125-.7134 1.7593-.7134 1.396 0 2.5323 1.1363 2.5323 2.532v4.4303h-1.208v-4.4303c0-.7302-.5945-1.3247-1.324-1.3247-.7309 0-1.3243.5945-1.3243 1.3247v4.4303H7.1338v-4.4303c0-.7302-.5934-1.3247-1.325-1.3247-.7295 0-1.323.5945-1.323 1.3247v4.4303h-1.209v-4.4303c0-1.3953 1.1367-2.532 2.532-2.532zm11.403 1.0383c-1.422 0-2.579 1.096-2.579 2.443 0 1.3466 1.157 2.4423 2.579 2.4423 1.4224 0 2.5782-1.0957 2.5782-2.4423 0-1.347-1.1561-2.443-2.5782-2.443Z",source:"https://commons.wikimedia.org/wiki/File:WeMoApp.svg",hex:"72D44C",guidelines:void 0,license:void 0},siWetransfer={title:"WeTransfer",slug:"wetransfer",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>WeTransfer</title><path d="'+this.path+'"/></svg>'},path:"M13.855 11.891c0-3.382 2.4-5.4 5.51-5.4C22.145 6.491 24 7.91 24 9.873c0 1.855-1.582 3.055-3.328 3.055-.982 0-1.69-.164-2.182-.546-.163-.164-.272-.109-.272.055 0 .709.272 1.254.709 1.745.382.382 1.09.655 1.745.655.71 0 1.31-.164 1.855-.437.545-.272.982-.163 1.254.273.328.49-.109 1.145-.49 1.582-.71.763-2.073 1.309-3.819 1.309-3.545-.11-5.618-2.51-5.618-5.673zm-7.254 2.237c.327 0 .545.163.763.545l.982 1.582c.382.6.709 1.036 1.418 1.036.71 0 1.091-.273 1.418-1.09a21.11 21.11 0 001.31-3.873c.49-1.855.709-2.946.709-3.873s-.273-1.473-1.31-1.637c-1.363-.272-3.272-.381-5.29-.381-2.019 0-3.928.109-5.291.327C.273 6.982 0 7.528 0 8.454c0 .928.219 2.019.655 3.874a28.714 28.714 0 001.31 3.872c.381.818.708 1.091 1.417 1.091.71 0 1.037-.436 1.419-1.036l.981-1.582c.273-.327.491-.545.819-.545z",source:"https://wetransfer.com/",hex:"409FFF",guidelines:void 0,license:void 0},siWhatsapp={title:"WhatsApp",slug:"whatsapp",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>WhatsApp</title><path d="'+this.path+'"/></svg>'},path:"M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413Z",source:"https://www.facebook.com/brand/resources/whatsapp/whatsapp-brand",hex:"25D366",guidelines:"https://www.facebook.com/brand/resources/whatsapp/whatsapp-brand",license:void 0},siWheniwork={title:"When I Work",slug:"wheniwork",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>When I Work</title><path d="'+this.path+'"/></svg>'},path:"M12 24C5.342 24 0 18.582 0 12 0 5.342 5.342 0 12 0s12 5.342 12 12c0 6.582-5.342 12-12 12zm0-21.986c-5.497 0-9.987 4.489-9.987 9.986 0 5.498 4.49 9.988 9.987 9.988 5.498 0 9.987-4.49 9.987-9.988 0-5.497-4.489-9.986-9.987-9.986zm5.885 11.148H9.213c-.384 0-.695-.309-.698-.691v-1.012c0-.387.311-.697.698-.697h8.748c.387 0 .697.311.697.697v1.006c-.077.387-.387.697-.773.697zm-2.246-3.871H6.891c-.383.002-.697-.307-.698-.691V7.59c0-.311.31-.621.697-.621h8.748c.31 0 .62.311.62.619v1.006c.001.386-.31.697-.619.697zm-8.748 5.418h8.748c.388 0 .696.311.696.697v1.006c.002.383-.309.695-.691.697H6.891c-.388-.076-.697-.387-.697-.773V15.33c-.001-.31.309-.621.697-.621z",source:"https://wheniwork.com/",hex:"51A33D",guidelines:void 0,license:void 0},siWhitesource={title:"WhiteSource",slug:"whitesource",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>WhiteSource</title><path d="'+this.path+'"/></svg>'},path:"M12 0C5.373 0 0 5.372 0 12c0 6.627 5.373 12 12 12 6.628 0 12-5.373 12-12 0-6.628-5.372-12-12-12zm-1.58 4.916h3.167v5.268h.657V5.818c2.971 1.432 2.554 5.28 2.586 5.136h.718v1.014H6.452v-1.014h.718s-.687-3.559 2.587-5.136v4.366h.662zm-3.968 8.002h3.18V13.464A2.376 2.376 0 0012 15.833a2.376 2.376 0 002.369-2.369V12.918h3.18v2.066h-1.292l-.416.928.872.768-1.596 1.697-.911-.919-.988.424v1.202h-2.436v-1.202l-.987-.424-.912.919-1.595-1.697.871-.768-.415-.928H6.452z",source:"https://www.whitesourcesoftware.com/whitesource-media-kit/",hex:"161D4E",guidelines:void 0,license:void 0},siWiiu={title:"Wii U",slug:"wiiu",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Wii U</title><path d="'+this.path+'"/></svg>'},path:"M11.133 8.432c-.465 0-.835.359-.835.814.007.454.381.817.835.812.488 0 .873-.358.873-.81 0-.455-.385-.816-.873-.816zm2.93 0c-.465 0-.848.359-.848.814 0 .442.383.812.848.812.477 0 .861-.358.861-.81 0-.455-.385-.816-.861-.816zm3.655.011c-.53 0-.99.335-.99.858v3.315c0 .809.56 1.289 1.377 1.289h4.647c.689 0 1.248-.477 1.248-1.162V9.345c0-.412-.308-.86-.688-.86h-1.075v2.799c0 2.122-3.701 2.104-3.701.04v-2.88h-.818zm1.679 0v2.453c0 1.636 1.934 1.402 1.934.256V8.445h-1.934v-.002zM4.833 8.77c-.465 0-.776.232-.938.756-.152.533-1.116 4.242-1.116 4.242l-1.267-4.94H0s1.451 5.264 1.65 5.881c.15.476.521.86 1.058.86.627 0 .917-.454 1.045-.86.14-.421 1.08-3.895 1.08-3.895s.942 3.476 1.069 3.895c.14.406.431.86 1.047.86.547 0 .906-.385 1.07-.86.196-.617 1.65-5.881 1.65-5.881H8.148l-1.258 4.94s-.963-3.709-1.125-4.242c-.15-.526-.479-.756-.93-.756h-.002zm5.605 2.09v4.662h1.441V10.86h-1.441zm2.916 0v4.662h1.442V10.86h-1.442z",source:"https://commons.wikipedia.org/wiki/File:WiiU.svg",hex:"8B8B8B",guidelines:void 0,license:void 0},siWikidotjs={title:"Wiki.js",slug:"wikidotjs",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Wiki.js</title><path d="'+this.path+'"/></svg>'},path:"M17.801 13.557c.148.098.288.202.417.313 1.854 1.6 3.127 4.656 2.582 7.311-1.091-.255-5.747-1.055-7.638-3.383-.91-1.12-1.366-2.081-1.569-2.885a5.65 5.65 0 0 0 .034-.219c.089.198.197.35.313.466.24.24.521.335.766.372.304.046.594-.006.806-.068l.001.001c.05-.015.433-.116.86-.342.325-.173 2.008-.931 3.428-1.566Zm-7.384 1.435C9.156 16.597 6.6 18.939.614 18.417c.219-1.492 1.31-3.019 2.51-4.11.379-.345.906-.692 1.506-1.009.286.168.598.332.939.486 2.689 1.221 3.903 1.001 4.89.573a1.3 1.3 0 0 0 .054-.025 6.156 6.156 0 0 0-.096.66Zm4.152-.462c.38-.341.877-.916 1.383-1.559-.389-.15-.866-.371-1.319-.591-.598-.29-1.305-.283-2.073-.315a4.685 4.685 0 0 1-.804-.103c.014-.123.027-.246.038-.369.062.104.673.057.871.057.354 0 1.621.034 3.074-.574 1.452-.608 2.55-1.706 3.022-3.225.474-1.52.22-3.091-.168-3.952-.169.709-1.453 2.381-1.926 2.871-.473.489-2.381 2.296-2.972 2.921-.7.74-.688.793-1.332 1.302-.202.19-.499.402-.563.53.027-.338.039-.675.027-.997a7.653 7.653 0 0 0-.032-.523c.322-.059.567-.522.567-.861 0-.224-.106-.247-.271-.229.075-.894.382-3.923 1.254-4.281.218.109.831.068.649-.295-.182-.364-.825-.074-1.081.266-.28.374-.956 2.046-.92 4.324-.113.014-.174.033-.322.033-.171 0-.321-.04-.433-.05.034-2.275-.714-3.772-.84-4.169-.12-.375-.491-.596-.781-.596-.146 0-.272.056-.333.179-.182.363.459.417.677.308.706.321 1.156 3.519 1.254 4.277-.125-.006-.199.035-.199.233 0 .311.17.756.452.843a.442.442 0 0 0-.007.03s-.287.99-.413 2.189a4.665 4.665 0 0 1-.718-.225c-.714-.286-1.355-.583-2.019-.566-.664.018-1.366.023-1.804-.036-.438-.058-.649-.15-.649-.15s-.234.365.257 1.075c.42.607 1.055 1.047 1.644 1.18.589.134 1.972.18 2.785-.377.16-.109.317-.228.459-.34a8.717 8.717 0 0 0-.013.626c-.289.753-.571 1.993-.268 3.338 0-.001.701-.842.787-2.958.006-.144.009-.271.01-.383.052-.248.103-.518.148-.799.072.135.151.277.234.413.511.842 1.791 1.37 2.383 1.49.091.019.187.032.285.038Zm-1.12.745c-.188.055-.445.1-.713.059-.21-.031-.45-.11-.655-.316-.169-.168-.312-.419-.401-.789a9.837 9.837 0 0 0 .039-.82l.049-.243c.563.855 1.865 1.398 2.476 1.522.036.008.072.014.109.02l-.013.009c-.579.415-.76.503-.891.558Zm6.333-2.818c-.257.114-4.111 1.822-5.246 2.363.98-.775 3.017-3.59 3.699-4.774 1.062.661 1.468 1.109 1.623 1.441.101.217.09.38.096.515a.57.57 0 0 1-.172.455Zm-9.213 1.62a1.606 1.606 0 0 1-.19.096c-.954.414-2.126.61-4.728-.571-2.023-.918-3.024-2.157-3.371-2.666.476.161 1.471.473 2.157.524.282.021.703.068 1.167.125.021.209.109.486.345.829l.001.001c.451.651 1.134 1.119 1.765 1.262.622.141 2.083.182 2.942-.407a3.12 3.12 0 0 0 .132-.093l.001.179a6.052 6.052 0 0 0-.221.721Zm5.512-1.271a17.49 17.49 0 0 1-1.326-.589c.437.042 1.054.083 1.692.108-.121.162-.244.323-.366.481Zm.932-1.26c-.12.17-.245.343-.373.517-.241.018-.478.03-.709.038a29.05 29.05 0 0 1-.741-.048c.608-.065 1.228-.252 1.823-.507Zm.22-.315c-.809.382-1.679.648-2.507.648-.472 0-.833.018-1.139.039v.001c-.324-.031-.665-.039-1.019-.054a3.555 3.555 0 0 1-.152-.009c.102-.002.192-.006.249-.006.363 0 1.662.034 3.151-.589 1.508-.632 2.645-1.773 3.136-3.351.37-1.186.31-2.402.086-3.312.458-.336.86-.651 1.147-.91.501-.451.743-.733.848-.869.199.206.714.864.685 2.138-.036 1.611-.606 3.187-1.501 4.154a9.099 9.099 0 0 1-1.321 1.132 11.978 11.978 0 0 0-.644-.422l-.089-.055-.051.091c-.184.332-.5.825-.879 1.374ZM4.763 5.817c-.157 1.144.113 2.323.652 3.099.539.776 2.088 2.29 3.614 2.505.991.14 2.055.134 2.055.134s-.593-.576-1.114-1.66c-.521-1.085-.948-2.104-1.734-2.786-.785-.681-1.601-1.416-2.045-1.945-.444-.53-.59-.86-.59-.86s-.656.175-.838 1.513Zm14.301 4.549a9.162 9.162 0 0 0 1.3-1.12c.326-.352.611-.782.845-1.265 1.315.145 2.399.371 2.791.434 0 0-.679 1.971-3.945 3.022l-.016-.035c-.121-.26-.385-.594-.975-1.036Zm-11.634.859a8.537 8.537 0 0 1-.598-.224c-1.657-.693-2.91-1.944-3.449-3.678-.498-1.601-.292-3.251.091-4.269.225.544.758 1.34 1.262 2.01a3.58 3.58 0 0 0-.172.726c-.163 1.197.123 2.428.687 3.24.416.599 1.417 1.62 2.555 2.193-.128.002-.253.003-.376.002Zm-1.758-.077c-.958-.341-1.901-.787-2.697-1.368C-.07 7.559 0 6.827 0 6.827s1.558-.005 3.088.179c.03.126.065.251.104.377.557 1.791 1.851 3.086 3.562 3.803l.047.019a4.254 4.254 0 0 1-.267-.026h-.001c-.401-.053-.595-.135-.595-.135l-.157-.069-.092.144-.017.029Zm6.807-1.59c.086.017.136.058.136.145 0 .197-.242.5-.597.597l-.01-.161a.887.887 0 0 0 .283-.243c.078-.099.142-.217.188-.338Zm-1.591.006c.033.1.076.197.129.282.061.097.134.18.217.24l-.021.083c-.276-.093-.424-.293-.424-.466 0-.078.035-.119.099-.139Zm-.025-.664c-.275-.816-.795-2.022-1.505-2.179-.296.072-.938.096-.691-.145.246-.24 1.085-.048 1.283.217.145.194.744.806 1.011 1.737l.032.227a.324.324 0 0 0-.13.143Zm1.454-.266c.251-.99.889-1.639 1.039-1.841.197-.265 1.036-.457 1.283-.217.247.241-.395.217-.691.145-.69.152-1.2 1.296-1.481 2.109a.364.364 0 0 0-.067-.059.37.37 0 0 0-.092-.043l.009-.094Zm4.802-2.708a9.875 9.875 0 0 1-.596.705c-.304.315-1.203 1.176-1.963 1.916.647-.955 1.303-1.806 2.184-2.376.123-.08.249-.161.375-.245Z",source:"https://cdn.js.wiki/images/wikijs-butterfly-mono.svg",hex:"1976D2",guidelines:void 0,license:void 0},siWikidata={title:"Wikidata",slug:"wikidata",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Wikidata</title><path d="'+this.path+'"/></svg>'},path:"M0 4.583v14.833h.865V4.583zm1.788 0v14.833h2.653V4.583zm3.518 0v14.832H7.96V4.583zm3.547 0v14.834h.866V4.583zm1.789 0v14.833h.865V4.583zm1.759 0v14.834h2.653V4.583zm3.518 0v14.834h.923V4.583zm1.788 0v14.833h2.653V4.583zm3.64 0v14.834h.865V4.583zm1.788 0v14.834H24V4.583Z",source:"https://commons.wikimedia.org/wiki/File:Wikidata-logo-en.svg",hex:"006699",guidelines:void 0,license:void 0},siWikimediacommons={title:"Wikimedia Commons",slug:"wikimediacommons",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Wikimedia Commons</title><path d="'+this.path+'"/></svg>'},path:"M9.048 15.203a2.952 2.952 0 1 1 5.904 0 2.952 2.952 0 0 1-5.904 0zm11.749.064v-.388h-.006a8.726 8.726 0 0 0-.639-2.985 8.745 8.745 0 0 0-1.706-2.677l.004-.004-.186-.185-.044-.045-.026-.026-.204-.204-.006.007c-.848-.756-1.775-1.129-2.603-1.461-1.294-.519-2.138-.857-2.534-2.467.443.033.839.174 1.13.481C15.571 6.996 11.321 0 11.321 0s-1.063 3.985-2.362 5.461c-.654.744.22.273 1.453-.161.279 1.19.77 2.119 1.49 2.821.791.771 1.729 1.148 2.556 1.48.672.27 1.265.508 1.767.916l-.593.594-.668-.668-.668 2.463 2.463-.668-.668-.668.6-.599a6.285 6.285 0 0 1 1.614 3.906h-.844v-.944l-2.214 1.27 2.214 1.269v-.944h.844a6.283 6.283 0 0 1-1.614 3.906l-.6-.599.668-.668-2.463-.668.668 2.463.668-.668.6.6a6.263 6.263 0 0 1-3.907 1.618v-.848h.945L12 18.45l-1.27 2.214h.944v.848a6.266 6.266 0 0 1-3.906-1.618l.599-.6.668.668.668-2.463-2.463.668.668.668-.6.599a6.29 6.29 0 0 1-1.615-3.906h.844v.944l2.214-1.269-2.214-1.27v.944h-.843a6.292 6.292 0 0 1 1.615-3.906l.6.599-.668.668 2.463.668-.668-2.463-.668.668-2.359-2.358-.23.229-.044.045-.185.185.004.004a8.749 8.749 0 0 0-2.345 5.662h-.006v.649h.006a8.749 8.749 0 0 0 2.345 5.662l-.004.004.185.185.045.045.045.045.185.185.004-.004a8.73 8.73 0 0 0 2.677 1.707 8.75 8.75 0 0 0 2.985.639V24h.649v-.006a8.75 8.75 0 0 0 2.985-.639 8.717 8.717 0 0 0 2.677-1.707l.004.004.187-.187.044-.043.043-.044.187-.186-.004-.004a8.733 8.733 0 0 0 1.706-2.677 8.726 8.726 0 0 0 .639-2.985h.006v-.259z",source:"https://commons.wikimedia.org/wiki/File:Commons-logo.svg",hex:"006699",guidelines:void 0,license:void 0},siWikipedia={title:"Wikipedia",slug:"wikipedia",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Wikipedia</title><path d="'+this.path+'"/></svg>'},path:"M12.09 13.119c-.936 1.932-2.217 4.548-2.853 5.728-.616 1.074-1.127.931-1.532.029-1.406-3.321-4.293-9.144-5.651-12.409-.251-.601-.441-.987-.619-1.139-.181-.15-.554-.24-1.122-.271C.103 5.033 0 4.982 0 4.898v-.455l.052-.045c.924-.005 5.401 0 5.401 0l.051.045v.434c0 .119-.075.176-.225.176l-.564.031c-.485.029-.727.164-.727.436 0 .135.053.33.166.601 1.082 2.646 4.818 10.521 4.818 10.521l.136.046 2.411-4.81-.482-1.067-1.658-3.264s-.318-.654-.428-.872c-.728-1.443-.712-1.518-1.447-1.617-.207-.023-.313-.05-.313-.149v-.468l.06-.045h4.292l.113.037v.451c0 .105-.076.15-.227.15l-.308.047c-.792.061-.661.381-.136 1.422l1.582 3.252 1.758-3.504c.293-.64.233-.801.111-.947-.07-.084-.305-.22-.812-.24l-.201-.021c-.052 0-.098-.015-.145-.051-.045-.031-.067-.076-.067-.129v-.427l.061-.045c1.247-.008 4.043 0 4.043 0l.059.045v.436c0 .121-.059.178-.193.178-.646.03-.782.095-1.023.439-.12.186-.375.589-.646 1.039l-2.301 4.273-.065.135 2.792 5.712.17.048 4.396-10.438c.154-.422.129-.722-.064-.895-.197-.172-.346-.273-.857-.295l-.42-.016c-.061 0-.105-.014-.152-.045-.043-.029-.072-.075-.072-.119v-.436l.059-.045h4.961l.041.045v.437c0 .119-.074.18-.209.18-.648.03-1.127.18-1.443.421-.314.255-.557.616-.736 1.067 0 0-4.043 9.258-5.426 12.339-.525 1.007-1.053.917-1.503-.031-.571-1.171-1.773-3.786-2.646-5.71l.053-.036z",source:"https://commons.wikimedia.org/wiki/File:Wikipedia-logo-v2.svg",hex:"000000",guidelines:void 0,license:void 0},siWinamp={title:"Winamp",slug:"winamp",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Winamp</title><path d="'+this.path+'"/></svg>'},path:"M11.902 0a.987.987 0 0 0-.91.604l-6.139 14.57c-.176.42.131.883.586.883H8.66a.987.987 0 0 0 .91-.604L15.707.883A.636.636 0 0 0 15.12 0h-3.219Zm3.438 7.943a.987.987 0 0 0-.91.604l-6.137 14.57c-.177.42.13.883.586.883h3.219a.987.987 0 0 0 .91-.604l6.138-14.57a.636.636 0 0 0-.586-.883h-3.22Z",source:"https://www.winamp.com",hex:"F93821",guidelines:void 0,license:void 0},siWindicss={title:"Windi CSS",slug:"windicss",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Windi CSS</title><path d="'+this.path+'"/></svg>'},path:"M4.12 15.561H.96v2.431h3.16zm13.728 4.22A4.224 4.224 0 0113.628 24c-2.452 0-3.918-1.838-3.918-3.617h2.412c0 .5.467 1.206 1.506 1.206a1.81 1.81 0 001.809-1.809c0-.997-.917-1.808-2.563-1.808H5.589v-2.411h7.285c3.097 0 4.974 1.893 4.974 4.22zA4.224 4.224 0 0113.628 24c-2.452 0-3.918-1.838-3.918-3.617h2.412c0 .5.467 1.206 1.506 1.206a1.81 1.81 0 001.809-1.809c0-.997-.917-1.808-2.563-1.808H5.589v-2.411h7.285c3.097 0 4.974 1.893 4.974 4.22zM18.48 3.72c-2.66 0-4.536 2.022-4.536 4.682h2.136c0-1.322.96-2.282 2.4-2.282s2.16.96 2.16 2.282-.935 2.411-3.48 2.411H.96v2.411h16.56c3.769 0 5.52-2.422 5.52-4.822 0-2.66-1.8-4.682-4.56-4.682zm-5.981.5A4.224 4.224 0 008.279 0C5.827 0 4.361 1.838 4.361 3.617h2.411c0-.5.468-1.206 1.507-1.206a1.81 1.81 0 011.809 1.809c0 .997-.728 1.808-2.563 1.808H.96v2.411h6.565c3.097 0 4.974-1.893 4.974-4.22zA4.224 4.224 0 008.279 0C5.827 0 4.361 1.838 4.361 3.617h2.411c0-.5.468-1.206 1.507-1.206a1.81 1.81 0 011.809 1.809c0 .997-.728 1.808-2.563 1.808H.96v2.411h6.565c3.097 0 4.974-1.893 4.974-4.22z",source:"https://github.com/windicss/docs/blob/d7a01df515c4fa30dbb33ede7c46392e21fbf2cb/public/assets/logo.svg",hex:"48B0F1",guidelines:void 0,license:void 0},siWindows={title:"Windows",slug:"windows",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Windows</title><path d="'+this.path+'"/></svg>'},path:"M0 3.449L9.75 2.1v9.451H0m10.949-9.602L24 0v11.4H10.949M0 12.6h9.75v9.451L0 20.699M10.949 12.6H24V24l-12.9-1.801",source:"https://commons.wikimedia.org/wiki/File:Windows_10_Logo.svg",hex:"0078D6",guidelines:void 0,license:void 0},siWindows95={title:"Windows 95",slug:"windows95",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Windows 95</title><path d="'+this.path+'"/></svg>'},path:"M5.712 1.596l-.756.068-.238.55.734-.017zm1.39.927l-.978.137-.326.807.96-.12.345-.824zM4.89 3.535l-.72.05-.24.567.721-.017zm3.724.309l-1.287.068-.394.96 1.27-.052zm1.87.566l-1.579.069-.566 1.357 1.596-.088.548-1.338zm-4.188.037l-.977.153-.343.806.976-.12zm6.144.668l-1.87.135-.637 1.527 1.87-.154zm2.925.219c-.11 0-.222 0-.334.002l-.767 1.85c1.394-.03 2.52.089 3.373.38l-1.748 4.201c-.955-.304-2.082-.444-3.36-.394l-.54 1.305a8.762 8.762 0 0 1 3.365.396l-1.663 4.014c-1.257-.27-2.382-.395-3.387-.344l-.782 1.887c3.363-.446 6.348.822 9.009 3.773L24 9.23c-2.325-2.575-5.2-3.88-8.637-3.896zm-.644.002l-2.024.12-.687 1.68 2.025-.19zm-10.603.05l-.719.036-.224.566h.703l.24-.601zm3.69.397l-1.287.069-.395.959 1.27-.05zM5.54 6.3l-.994.154-.344.807.98-.121zm4.137.066l-1.58.069L7.53 7.77l1.596-.085.55-1.32zm1.955.688l-1.87.135-.636 1.527 1.887-.154zm2.282.19l-2.01.136-.7 1.682 2.04-.19.67-1.63zm-10.57.066l-.739.035-.238.564h.72l.257-.6zm3.705.293l-1.303.085-.394.96 1.287-.034zm11.839.255a6.718 6.718 0 0 1 2.777 1.717l-1.75 4.237c-.617-.584-1.15-.961-1.611-1.149l-1.201-.498zM4.733 8.22l-.976.154-.344.807.961-.12.36-.841zm4.186 0l-1.594.052-.549 1.354L8.37 9.54zm1.957.668L8.99 9.04l-.619 1.508 1.87-.135.636-1.527zm2.247.275l-2.007.12-.703 1.665 2.042-.156zM2.52 9.267l-.718.033-.24.549.718-.016zm3.725.273l-1.289.07-.41.96 1.287-.03.412-1zm1.87.6l-1.596.05-.55 1.356 1.598-.084.547-1.322zm-4.186.037l-.979.136-.324.805.96-.119zm6.14.633l-1.87.154-.653 1.527 1.906-.154zm2.267.275l-2.026.12-.686 1.663 2.025-.172zm-10.569.031l-.739.037-.238.565.72-.016zm3.673.362l-1.289.068-.41.978 1.305-.05zm-2.285.533l-.976.154-.326.805.96-.12.342-.84zm4.153.07l-1.596.066-.565 1.356 1.612-.084zm1.957.666l-1.889.154-.617 1.526 1.886-.15zm2.28.223l-2.025.12-.685 1.665 2.041-.172.67-1.613zm-10.584.05l-.738.053L0 13.64l.72-.02.24-.6zm3.705.31l-1.285.07-.395.976 1.287-.05.393-.997zm11.923.07c1.08.29 2.024.821 2.814 1.613l-1.715 4.183c-.892-.754-1.82-1.32-2.814-1.664l1.715-4.133zm-10.036.515L4.956 14l-.549 1.32 1.578-.066.567-1.338zm-4.184.014l-.996.156-.309.79.961-.106zm6.14.67l-1.904.154-.617 1.527 1.89-.154.632-1.527zm2.231.324l-2.025.123-.686 1.682 2.026-.174zm-6.863.328l-1.3.068-.397.98 1.285-.054zm1.871.584l-1.578.068-.566 1.334 1.595-.064zm1.953.701l-1.867.137-.635 1.51 1.87-.137zm2.23.31l-2.005.122-.703 1.68 2.04-.19.67-1.61z",source:"https://en.wikipedia.org/wiki/Windows_95",hex:"008080",guidelines:void 0,license:void 0},siWindowsterminal={title:"Windows Terminal",slug:"windowsterminal",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Windows Terminal</title><path d="'+this.path+'"/></svg>'},path:"M8.165 6V3h7.665v3H8.165zm-.5-3H1c-.55 0-1 .45-1 1v2h7.665V3zM23 3h-6.67v3H24V4c0-.55-.45-1-1-1zM0 6.5h24V20c0 .55-.45 1-1 1H1c-.55 0-1-.45-1-1V6.5zM11.5 18c0 .3.2.5.5.5h8c.3 0 .5-.2.5-.5v-1.5c0-.3-.2-.5-.5-.5h-8c-.3 0-.5.2-.5.5V18zm-5.2-4.55l-3.1 3.1c-.25.25-.25.6 0 .8l.9.9c.25.25.6.25.8 0l4.4-4.4a.52.52 0 0 0 0-.8l-4.4-4.4c-.2-.2-.6-.2-.8 0l-.9.9c-.25.2-.25.55 0 .8l3.1 3.1z",source:"https://github.com/microsoft/terminal/blob/a90289548f8548bf5c370a4b141b4b815c22616b/res/terminal/Terminal_HC.svg",hex:"4D4D4D",guidelines:void 0,license:void 0},siWindowsxp={title:"Windows XP",slug:"windowsxp",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Windows XP</title><path d="'+this.path+'"/></svg>'},path:"M9.302 1.415c-1.184.02-2.592.32-4.341 1.044l-2.283 7.949c1.846-.761 3.311-1.114 4.537-1.1a7.596 7.596 0 014.37 1.593l2.296-7.92c-1.26-.855-2.607-1.599-4.58-1.566zm5.75 2.411l-2.256 7.949c2.016 1.367 4.44 2.494 8.907.493L24 4.333h-.042c-4.651 1.931-6.906.846-8.907-.507zM6.617 10.77c-1.184.018-2.591.315-4.335 1.034L0 19.779c4.65-1.93 6.863-.803 8.878.55l2.326-7.99c-1.26-.855-2.613-1.6-4.586-1.57zm5.784 2.344l.011.008.003-.008zm.011.008l-2.294 7.898c2.015 1.367 4.256 2.453 8.906.522l2.297-7.92c-4.641 1.927-6.882.85-8.909-.5Z",source:"https://commons.wikimedia.org/wiki/File:Windows_logo_-_2002%E2%80%932012_(Multicolored).svg",hex:"003399",guidelines:void 0,license:void 0},siWinmate={title:"Winmate",slug:"winmate",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Winmate</title><path d="'+this.path+'"/></svg>'},path:"M5.785 4.058l-4.473.004L1.311.01 19.469 0c3.514.42 3.199 4.047 3.199 4.047l-2.156-.002-2.769 15.888L14.79 4.049l-4.731.005.856 7.376-2.137 8.507L5.785 4.058zM4.491 21.373L1.317 8.52l.009 12.338C1.756 23.983 4.629 24 4.629 24l1.687-.001c-1.393-.69-1.825-2.626-1.825-2.626zm9.237.659l-1.724-6.724-1.673 6.678c-.517 1.652-1.702 2.009-1.702 2.009l6.602-.002c-1.206-.499-1.503-1.961-1.503-1.961zm8.949-17.643l-2.844 15.865c-.711 3.767-2.285 3.738-2.285 3.738l5.141-.008-.012-19.595z",source:"https://www.winmate.com/NewsAndEvents/Publications",hex:"C11920",guidelines:void 0,license:void 0},siCodersrank={title:"CodersRank",slug:"codersrank",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>CodersRank</title><path d="'+this.path+'"/></svg>'},path:"M23.134 8.64l-5.973-3.62a.286.286 0 0 0-.412.125l-1.4 3.286 2.842 1.696a.53.53 0 0 1 0 .921l-5.335 3.14-2.267 5.274a.127.127 0 0 0 .052.203.122.122 0 0 0 .134-.035l3.914-2.365 1.545 2.219a.373.373 0 0 0 .309.167h3.708a.367.367 0 0 0 .327-.2.382.382 0 0 0-.018-.386l-2.513-3.852 5.088-3.077c.577-.349.865-.74.865-1.172V9.813c0-.433-.288-.823-.866-1.172zM13.082 4.35L.845 12.052c-.577.348-.858.739-.845 1.171v1.173c.014.432.303.816.866 1.15l6.056 3.496a.286.286 0 0 0 .412-.146l1.36-3.286-2.884-1.633a.518.518 0 0 1-.275-.384.529.529 0 0 1 .254-.537l5.295-3.245 2.183-5.316a.128.128 0 0 0-.04-.142.122.122 0 0 0-.146-.005z",source:"https://codersrank.io",hex:"67A4AC",guidelines:void 0,license:void 0},siWipro={title:"Wipro",slug:"wipro",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Wipro</title><path d="'+this.path+'"/></svg>'},path:"M15.5415 12.0352c0-.8754-.69-1.5851-1.541-1.5851-.8513 0-1.5415.7097-1.5415 1.585 0 .8757.6902 1.5854 1.5416 1.5854.851 0 1.541-.7097 1.541-1.5853zm-1.541.837c-.4373 0-.7927-.3755-.7927-.837 0-.4611.3554-.8366.7928-.8366.437 0 .7923.3755.7923.8366 0 .4615-.3554.837-.7923.837zm-9.5842-2.2084l-.9272 2.8733c-.0148.046-.0665.0835-.1152.0835h-.084c-.0484 0-.1064-.0352-.1287-.078l-.95-1.8242-.9496 1.8243c-.0225.0427-.0803.0779-.1289.0779h-.0842c-.0483 0-.1002-.0374-.115-.0835L.006 10.6638c-.0222-.0693.019-.126.0915-.126h.5677c.0483 0 .1002.0379.115.084l.4688 1.452.8047-1.5458c.0223-.0428.0804-.0779.1289-.0779H2.24c.0485 0 .1063.0351.1289.0779l.805 1.5458.4685-1.452c.0148-.0461.0667-.084.1152-.084h.5672c.0727 0 .1138.0567.0915.126zm1.368 2.7367a.1323.1323 0 01-.1321.1322h-.5726a.1321.1321 0 01-.132-.1322v-2.7304c0-.0729.059-.1322.132-.1322h.5726a.1323.1323 0 01.1322.1322v2.7304zm.7409-2.7305v4.3155c0 .0733.059.1322.1321.1322h.5725a.1318.1318 0 00.132-.1322v-1.497c.2426.085.5106.132.7927.132.8024 0 1.4531-.7097 1.4531-1.5853 0-.8754-.6507-1.5851-1.4531-1.5851-.394 0-.751.171-1.0127.4487l-.0002-.0004-.1018-.2777c-.0167-.0453-.07-.0829-.1183-.0829h-.2642a.1321.1321 0 00-.1321.1322zm.8365.9c.1376-.2239.3713-.3714.6373-.3714.4235 0 .7667.3746.7667.8366 0 .4622-.3432.837-.7667.837-.2396 0-.4599-.063-.6373-.1694V11.57zm3.5755 1.9627h-.5723a.1321.1321 0 01-.1321-.1321V10.67c0-.0729.059-.1322.1321-.1322h.2642c.0483 0 .1016.0376.1183.0829l.1018.2777s.3195-.4483.87-.4483c.5507 0 .6172.1897.5712.2947-.0463.1047-.1714.3878-.197.4454-.0254.058-.0903.099-.1772.0657-.087-.0335-.5128-.1723-.8469.2329v1.9118a.1323.1323 0 01-.1321.1321zm4.6893-10.3422a.704.704 0 01.8628-.4977.7043.7043 0 11-.3647 1.3607.7046.7046 0 01-.498-.863zm1.8466 2.7892a.5286.5286 0 01.1935.722.528.528 0 01-.7218.193.5281.5281 0 01-.1935-.7215.5281.5281 0 01.7218-.1935zm.664 10.9686a.5727.5727 0 010-.8099.5722.5722 0 01.8096 0 .5727.5727 0 010 .81.573.573 0 01-.8095 0zm-2.4577-7.377a.2423.2423 0 01-.4196-.2423.2422.2422 0 11.4196.2422zm-.4196 5.1001a.2423.2423 0 01.4196-.2422.2425.2425 0 01-.0888.331.2426.2426 0 01-.3308-.0888zm3.7296-2.6713a.517.517 0 11-.5169-.5169.517.517 0 01.517.5169zM17.816 3.8893a.7485.7485 0 111.2962.749.7485.7485 0 01-1.2962-.749zm-5.43 10.5742a.154.154 0 11.2666.154.154.154 0 01-.2666-.154zm2.8037-8.7912a.4842.4842 0 11.9354.2502.4843.4843 0 01-.593.3428.4844.4844 0 01-.3424-.593zM13.993 7.8486a.308.308 0 110-.6162.308.308 0 110 .6162zm0 1.0129a.1982.1982 0 11.0002.3962.1982.1982 0 01-.0002-.3962zm0-2.84a.4404.4404 0 110-.881.4404.4404 0 010 .881zm-1.6072 3.5154a.154.154 0 11.2102.0564.1537.1537 0 01-.2102-.0564zm1.6072 5.602a.1982.1982 0 11-.0001-.3963.1982.1982 0 010 .3964zm0 1.0127a.3081.3081 0 010 .6165.3081.3081 0 110-.6165zm3.4944-2.1381a.4399.4399 0 01.6014-.161.44.44 0 01.161.6013.4402.4402 0 01-.7624-.4403zm-3.4944 3.9655a.4404.4404 0 11-.0002.8808.4404.4404 0 01.0002-.8808zm9.5772-8.5426c.1383.5164-.168 1.0476-.6848 1.186-.5165.1383-1.0478-.1684-1.1861-.6849-.1386-.5164.1682-1.0475.6847-1.186.5165-.1384 1.0476.168 1.1862.6849zm-6.694 6.0018a.3963.3963 0 01.5602-.5607.396.396 0 010 .5602.3958.3958 0 01-.5602.0005zm.9736-4.4694a.484.484 0 01.3424-.5928.4841.4841 0 11.2507.9353.484.484 0 01-.593-.3425zm1.4076-2.7157a.6165.6165 0 01.6166 1.0676.6165.6165 0 01-.6166-1.0676zm-.3108-.3913a.5722.5722 0 01-.8095 0 .5725.5725 0 010-.8097.5722.5722 0 01.8095 0 .5725.5725 0 010 .8097zm-1.0968 5.1692a.4842.4842 0 01.9355.2509.4842.4842 0 11-.9355-.251zm-3.0186-5.4263a.3303.3303 0 01.4041-.2336.3303.3303 0 01-.1706.6381.3303.3303 0 01-.2335-.4045zm6.4676-.835c.4213-.2434.96-.0992 1.2031.3218a.8806.8806 0 11-1.5254.8808c-.2429-.421-.0987-.9596.3223-1.2027zm-3.049 2.777a.4401.4401 0 11-.7624.4402.4401.4401 0 11.7624-.4402zm1.3227.9608a.6606.6606 0 01.4667-.8089.6605.6605 0 01.342 1.2758.6605.6605 0 01-.8087-.467zm0 2.9854a.6603.6603 0 111.2756.3416.6602.6602 0 11-1.2756-.3416zm.8594-.7354a.7574.7574 0 11-.0002-1.5146.7574.7574 0 01.0002 1.5146zm-.6756-6.5149a.7921.7921 0 010-1.1207c.3095-.3095.8115-.31 1.1209 0a.7926.7926 0 01-1.1209 1.1207zm-3.2223 2.068a.3522.3522 0 11-.61-.3523.3522.3522 0 01.61.3522zm-.6387 5.5862a.2642.2642 0 01.3738-.0004.2646.2646 0 010 .3738.2638.2638 0 01-.3738 0 .2637.2637 0 010-.3734zm0-4.1666a.2642.2642 0 01.3738-.0004.2642.2642 0 11-.3738.0004zm.5146 3.9917a.2868.2868 0 01-.105-.391.2862.2862 0 01.3912-.1046.2863.2863 0 01-.2862.4956zm-.486 2.3203a.352.352 0 01.129-.4811.352.352 0 01.4811.1288.352.352 0 01-.1289.4811.3521.3521 0 01-.4811-.1288zm.877-5.659a.286.286 0 01-.1048.3909.2867.2867 0 01-.3911-.1049.2862.2862 0 01.4958-.286zm-.2485.9334a.3082.3082 0 11.5955-.1596.3082.3082 0 01-.5955.1596zm0 1.3668a.3083.3083 0 11.5953.1602.3083.3083 0 01-.5953-.1602zm.4008-.3467a.3366.3366 0 11.0001-.6731.3366.3366 0 01-.0001.6731zm.4832-3.7744a.3963.3963 0 11-.5602.5608.3963.3963 0 01.5602-.5608zm-7.416 11.4507a.573.573 0 01-.782.2096.5726.5726 0 01.5725-.9916.5725.5725 0 01.2096.782zM14.814 8.945a.2202.2202 0 11-.114.4253.2202.2202 0 01.114-.4254zm-2.5387 11.8366a.6164.6164 0 11-1.1908-.3189.6164.6164 0 011.1908.319zm2.5387-5.726a.2203.2203 0 01-.1138-.4255.22.22 0 11.1138.4254zm-.1604 5.8739a.6603.6603 0 01-.6604.6602.6603.6603 0 01-.6606-.6602c0-.3649.2959-.6608.6606-.6608.3647 0 .6604.296.6604.6608zm-1.4693-5.9217a.1767.1767 0 01-.1247-.2158.1766.1766 0 01.216-.1245.1761.1761 0 01-.0913.3403zm-.0712 1.3712a.2863.2863 0 11-.5526-.1478.2863.2863 0 01.5526.1478zm-2.795-2.2726a.2202.2202 0 01-.3812.2202.2195.2195 0 01.0805-.3005.2198.2198 0 01.3007.0803zm1.6704 1.8817a.2642.2642 0 11-.4578-.2638.2642.2642 0 01.4578.2638zm.0148-1.8253a.1321.1321 0 11-.1869-.1869.1328.1328 0 01.187 0 .1325.1325 0 010 .187zm-.9966.81a.242.242 0 11-.3423.342.2418.2418 0 010-.342.2417.2417 0 01.3423 0zm.0783 2.7563a.3518.3518 0 01-.4811.1289.3522.3522 0 11.4811-.1289zm9.7924.0285a.7926.7926 0 010 1.121c-.3094.3097-.8114.3093-1.121 0-.3097-.3094-.3095-.8114 0-1.121a.793.793 0 011.121 0zm-1.6198-2.0103a.6169.6169 0 01-.2255-.8423.6168.6168 0 01.842-.2255.6165.6165 0 01-.6166 1.0678zm3.2445 1.1612c-.243.4214-.7818.5656-1.203.3223-.4211-.243-.5653-.7816-.3224-1.2026.2437-.4211.782-.5655 1.203-.3224.4213.2433.5657.7816.3224 1.2027zm-7.2666-.2796a.33.33 0 11-.1706-.638.3301.3301 0 01.1706.638zM24 12c0 .584-.4735 1.058-1.058 1.058-.5843 0-1.0578-.474-1.0578-1.058 0-.5842.4735-1.0579 1.0579-1.0579S24 11.4159 24 12.0001zm-.4297 2.564c-.1386.5164-.6697.8233-1.1862.685-.5165-.1387-.8233-.6698-.6847-1.1862.1383-.5169.6696-.8234 1.1861-.685.5169.1386.8231.6697.6848 1.1861zm-6.583 5.881a.7044.7044 0 11-1.3608.3643.7042.7042 0 01.4981-.8625.7043.7043 0 01.8628.4981zm2.1248-1.0825a.748.748 0 01-.274 1.0221.7482.7482 0 01-1.0222-.2738.748.748 0 01.2738-1.0224.7484.7484 0 011.0224.274zm-3.9225-1.0344a.4843.4843 0 11.9355-.2507.4843.4843 0 01-.9355.2507zm2.2835-.3077a.5284.5284 0 11-.5284-.9153.5284.5284 0 01.5284.9153zm-4.761.2798a.3963.3963 0 01-.7655-.205.396.396 0 01.4853-.2803.3964.3964 0 01.2802.4853zm-.8958-8.2762a.132.132 0 11.1868-.1869.132.132 0 01-.1868.1869zm.0754-1.651a.2643.2643 0 01-.2643-.4576.2642.2642 0 01.2643.4576zm-.8072-4.8355a.6164.6164 0 111.1905-.3188.6164.6164 0 01-1.1905.3188zm-.847 6.0555a.22.22 0 11-.2201.3812.2195.2195 0 01-.0806-.3004.22.22 0 01.3006-.0808zm.7691-.908a.2423.2423 0 01-.3423.3426.2423.2423 0 01.3423-.3426zm-.5319-2.0617a.3524.3524 0 01.6102-.352.3522.3522 0 01-.6102.352zm2.8578-3.5523c0-.3648.2959-.6608.6606-.6608.3647 0 .6604.296.6604.6608a.6606.6606 0 01-.6604.6607.6608.6608 0 01-.6606-.6607zm-.1483 5.9215a.1761.1761 0 11.091.3404.1761.1761 0 01-.091-.3404zm-.9575-3.5729a.3964.3964 0 01.2053.7657.3962.3962 0 01-.4854-.2802.3966.3966 0 01.28-.4855zm.5358 1.9992a.2863.2863 0 11.148.553.2863.2863 0 01-.148-.553zM9.0292 4.5596a.5724.5724 0 01.2094-.7818.5725.5725 0 01.5724.9914.572.572 0 01-.7818-.2096zm-.37 10.5048a.2643.2643 0 11-.458.264.2643.2643 0 01.458-.264zM4.9193 9.4585a.462.462 0 01.566-.3267.462.462 0 01.327.5658.4621.4621 0 01-.5661.3271.4624.4624 0 01-.327-.5662zm.9001-2.1691a.4843.4843 0 11.1772.6616.4845.4845 0 01-.1772-.6616zm2.2292 10.6412a.528.528 0 010 .7472.5286.5286 0 01-.7473 0 .5285.5285 0 010-.7472.5282.5282 0 01.7473 0zM6.676 16.2091a.4842.4842 0 11-.8386.4845.4842.4842 0 01.8386-.4845zm.6255-10.1393a.5285.5285 0 010-.7472.5286.5286 0 01.7473 0 .528.528 0 010 .7472.5282.5282 0 01-.7473 0zM9.6679 7.689a.3086.3086 0 01-.436 0 .3085.3085 0 010-.4362.3086.3086 0 01.436 0 .3085.3085 0 010 .4362zm0 8.6225a.3082.3082 0 11-.4359.4359.3082.3082 0 01.4359-.436zM8.2015 8.6719a.2642.2642 0 11.4574.2642.2642.2642 0 01-.4574-.2642z",source:"https://www.wipro.com/content/dam/nexus/en/service-lines/applications/latest-thinking/state-of-cybersecurity-report-2019.pdf",hex:"341C53",guidelines:void 0,license:void 0},siHive={title:"Hive",slug:"hive",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Hive</title><path d="'+this.path+'"/></svg>'},path:"M19.442 21.355c.55-.19.74-.256.99-.373.342-.152.605-.39.605-.818a.846.846 0 00-.605-.813c-.318-.092-.703.042-.99.122l-5.42 1.46a7.808 7.808 0 01-4.057 0l-5.407-1.46c-.287-.08-.672-.214-.99-.122a.847.847 0 00-.605.813c0 .427.263.666.605.818.25.117.44.184.99.373l5.138 1.79c1.491.52 3.104.52 4.601 0zm-9.263-3.224a7.622 7.622 0 003.636 0l8.01-1.967c.507-.122.709-.165.99-.257.354-.116.605-.415.605-.806a.847.847 0 00-.605-.813c-.281-.08-.697.024-.99.08l-8.664 1.545a6.813 6.813 0 01-2.334 0l-8.652-1.545c-.293-.056-.708-.16-.99-.08a.847.847 0 00-.604.813c0 .39.25.69.604.806.282.092.483.135.99.257zM14.75.621a24.43 24.43 0 00-5.511 0L6.495.933c-.294.03-.715.055-.99.14-.28.092-.605.355-.605.807 0 .39.257.702.605.806.281.08.696.074.99.074h11.01c.293 0 .709.006.99-.074a.835.835 0 00.605-.806c0-.452-.324-.715-.605-.807-.275-.085-.697-.11-.99-.14zm6.037 6.767c.3-.019.709-.037.99-.116a.84.84 0 000-1.614c-.281-.085-.69-.073-.99-.073H3.214c-.3 0-.709-.012-.99.073a.84.84 0 000 1.614c.281.079.69.097.99.116l7.808.556c.642.042 1.308.042 1.943 0zm1.62 4.242c.513-.08.708-.104.989-.202.354-.121.605-.409.605-.806a.84.84 0 00-.605-.806c-.28-.086-.69-.019-.99.012l-9.232.929c-.776.079-1.582.079-2.358 0l-9.22-.93c-.3-.03-.715-.097-.99-.011a.84.84 0 00-.605.806c0 .397.25.685.605.806.275.092.476.123.99.202l8.823 1.418c1.038.165 2.12.165 3.158 0Z",source:"https://www.hivehome.com/",hex:"FF7A00",guidelines:void 0,license:void 0},siWire={title:"Wire",slug:"wire",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Wire</title><path d="'+this.path+'"/></svg>'},path:"M24 14.475c.009 4.084-3.296 7.401-7.38 7.41h-.016c-1.637-.015-3.222-.58-4.5-1.605-3.269 2.544-7.981 1.957-10.524-1.313-1-1.286-1.555-2.862-1.58-4.492V2.82h1.41v11.655c-.002 3.314 2.683 6.002 5.996 6.004 1.293.001 2.552-.416 3.589-1.189-1.163-1.335-1.806-3.043-1.815-4.814v-9.54c0-1.557 1.263-2.82 2.82-2.82s2.82 1.263 2.82 2.82v9.54c.006 1.766-.623 3.474-1.77 4.814 2.674 1.957 6.429 1.371 8.383-1.304.745-1.019 1.149-2.248 1.157-3.511V2.82H24v11.655zm-10.59-9.54c0-.778-.632-1.41-1.41-1.41-.779 0-1.41.631-1.41 1.41v9.54c.002 1.41.501 2.776 1.41 3.855.908-1.079 1.408-2.445 1.41-3.855v-9.54z",source:"http://brand.wire.com",hex:"000000",guidelines:"https://brand.wire.com/",license:void 0},siHive_blockchain={title:"Hive",slug:"hive_blockchain",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Hive</title><path d="'+this.path+'"/></svg>'},path:"M6.076 1.637a.103.103 0 00-.09.05L.014 11.95a.102.102 0 000 .104l6.039 10.26c.04.068.14.068.18 0l5.972-10.262a.102.102 0 00-.002-.104L6.166 1.687a.103.103 0 00-.09-.05zm2.863 0c-.079 0-.13.085-.09.154l5.186 8.967a.105.105 0 00.09.053h3.117c.08 0 .13-.088.09-.157l-5.186-8.966a.104.104 0 00-.09-.051H8.94zm5.891 0a.102.102 0 00-.088.154L20.656 12l-5.914 10.209a.102.102 0 00.088.154h3.123a.1.1 0 00.088-.05l5.945-10.262a.1.1 0 000-.102L18.041 1.688a.1.1 0 00-.088-.051H14.83zm-.79 11.7a.1.1 0 00-.089.052l-5.101 8.82c-.04.069.01.154.09.154h3.117a.104.104 0 00.09-.05l5.1-8.82a.103.103 0 00-.09-.155h-3.118z",source:"https://hive.io/brand/",hex:"E31337",guidelines:void 0,license:void 0},siWireguard={title:"WireGuard",slug:"wireguard",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>WireGuard</title><path d="'+this.path+'"/></svg>'},path:"M23.98 11.645S24.533 0 11.735 0C.418 0 .064 11.17.064 11.17S-1.6 24 11.997 24C25.04 24 23.98 11.645 23.98 11.645zM8.155 7.576c2.4-1.47 5.469-.571 6.618 1.638.218.419.246 1.063.108 1.503-.477 1.516-1.601 2.366-3.145 2.728.455-.39.817-.832.933-1.442a2.112 2.112 0 0 0-.364-1.677 2.14 2.14 0 0 0-2.465-.75c-.95.36-1.47 1.228-1.377 2.294.087.99.839 1.632 2.245 1.876-.21.111-.372.193-.53.281a5.113 5.113 0 0 0-1.644 1.43c-.143.192-.24.208-.458.075-2.827-1.729-3.009-6.067.078-7.956zM6.04 18.258c-.455.116-.895.286-1.359.438.227-1.532 2.021-2.943 3.539-2.782a3.91 3.91 0 0 0-.74 2.072c-.504.093-.98.155-1.44.272zM15.703 3.3c.448.017.898.01 1.347.02a2.324 2.324 0 0 1 .334.047 3.249 3.249 0 0 1-.34.434c-.16.15-.341.296-.573.069-.055-.055-.187-.042-.283-.044-.447-.005-.894-.02-1.34-.003a8.323 8.323 0 0 0-1.154.118c-.072.013-.178.25-.146.338.078.207.191.435.359.567.619.49 1.277.928 1.9 1.413.604.472 1.167.99 1.51 1.7.446.928.46 1.9.267 2.877-.322 1.63-1.147 2.98-2.483 3.962-.538.395-1.205.62-1.821.903-.543.25-1.1.465-1.644.712-.98.446-1.53 1.51-1.369 2.615.149 1.015 1.04 1.862 2.059 2.037 1.223.21 2.486-.586 2.785-1.83.336-1.397-.423-2.646-1.845-3.024l-.256-.066c.38-.17.708-.291 1.012-.458q.793-.437 1.558-.925c.15-.096.231-.096.36.014.977.846 1.56 1.898 1.724 3.187.27 2.135-.74 4.096-2.646 5.101-2.948 1.555-6.557-.215-7.208-3.484-.558-2.8 1.418-5.34 3.797-5.83 1.023-.211 1.958-.637 2.685-1.425.47-.508.697-.944.775-1.141a3.165 3.165 0 0 0 .217-1.158 2.71 2.71 0 0 0-.237-.992c-.248-.566-1.2-1.466-1.435-1.656l-2.24-1.754c-.079-.065-.168-.06-.36-.047-.23.016-.815.048-1.067-.018.204-.155.76-.38 1-.56-.726-.49-1.554-.314-2.315-.46.176-.328 1.046-.831 1.541-.888a7.323 7.323 0 0 0-.135-.822c-.03-.111-.154-.22-.263-.283-.262-.154-.541-.281-.843-.434a1.755 1.755 0 0 1 .906-.28 3.385 3.385 0 0 1 .908.088c.54.123.97.042 1.399-.324-.338-.136-.676-.26-1.003-.407a9.843 9.843 0 0 1-.942-.493c.85.118 1.671.437 2.54.32l.022-.118-2.018-.47c1.203-.11 2.323-.128 3.384.388.299.146.61.266.897.432.14.08.233.24.348.365.09.098.164.23.276.29.424.225.89.234 1.366.223l.01-.16c.479.15 1.017.702 1.017 1.105-.776 0-1.55-.003-2.325.004-.083 0-.165.061-.247.094.078.046.155.128.235.131z M14.703 2.153a.118.118 0 0 0-.016.19.179.179 0 0 0 .246.065c.075-.038.148-.078.238-.125-.072-.062-.13-.114-.19-.163-.106-.087-.193-.032-.278.033z",source:"https://www.wireguard.com/",hex:"88171A",guidelines:void 0,license:void 0},siHomeassistant={title:"Home Assistant",slug:"homeassistant",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Home Assistant</title><path d="'+this.path+'"/></svg>'},path:"M11.9922 1.3945a.7041.7041 0 00-.498.211L.1621 13.0977A.5634.5634 0 000 13.494a.567.567 0 00.5664.5664H2.67v8.0743c0 .2603.2104.4707.4707.4707h7.9473v-3.6836L8.037 15.8672a2.42 2.42 0 01-.9473.1933c-1.3379 0-2.4218-1.0868-2.4218-2.4257 0-1.339 1.084-2.4239 2.4218-2.4239 1.338 0 2.422 1.085 2.422 2.4239 0 .3359-.068.6563-.1915.9472l1.7676 1.7676v-5.375C10.2 10.615 9.5723 9.744 9.5723 8.7266c0-1.339 1.0859-2.4258 2.4238-2.4258 1.338 0 2.4219 1.0868 2.4219 2.4258 0 1.0174-.6259 1.8884-1.5137 2.248v5.375l1.7656-1.7676a2.4205 2.4205 0 01-.1914-.9472c0-1.339 1.086-2.4239 2.4238-2.4239 1.338 0 2.422 1.085 2.422 2.4239 0 1.3389-1.084 2.4257-2.422 2.4257a2.42 2.42 0 01-.9472-.1933l-3.0508 3.0547v3.6836h7.9473a.4702.4702 0 00.4707-.4707v-8.0743h2.1113a.5686.5686 0 00.3965-.162c.2233-.2185.2262-.5775.0078-.8008l-2.5156-2.5723V6.4707c0-.2603-.2104-.4727-.4707-.4727h-1.9649c-.2603 0-.4707.2124-.4707.4727v1.1035L12.5 1.6035a.7056.7056 0 00-.5078-.209zm.0039 6.3614c-.5352 0-.9688.4351-.9688.9707 0 .5355.4336.9687.9688.9687a.9683.9683 0 00.9687-.9687c0-.5356-.4335-.9707-.9687-.9707zM7.0898 12.666a.9683.9683 0 00-.9687.9688c0 .5355.4336.9707.9687.9707.5352 0 .9688-.4352.9688-.9707a.9683.9683 0 00-.9688-.9688zm9.8125 0c-.5351 0-.9707.4332-.9707.9688 0 .5355.4356.9707.9707.9707.5352 0 .9688-.4352.9688-.9707a.9683.9683 0 00-.9688-.9688Z",source:"https://github.com/home-assistant/assets/blob/1e19f0dca208f0876b274c68345fcf989de7377a/logo/logo-small.png",hex:"41BDF5",guidelines:void 0,license:{type:"CC-BY-NC-SA-4.0",url:"https://spdx.org/licenses/CC-BY-NC-SA-4.0"}},siHomeassistantcommunitystore={title:"Home Assistant Community Store",slug:"homeassistantcommunitystore",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Home Assistant Community Store</title><path d="'+this.path+'"/></svg>'},path:"M1.63.47a.393.393 0 0 0-.39.39v2.417c0 .212.177.39.39.39h20.74c.213 0 .39-.178.39-.39V.859a.393.393 0 0 0-.39-.39zm-.045 4.126a.41.41 0 0 0-.407.337l-1.17 6.314C0 11.274 0 11.3 0 11.327v2.117c0 .23.186.416.416.416h23.168c.23 0 .416-.186.416-.416v-2.126c0-.027 0-.053-.009-.08l-1.169-6.305a.41.41 0 0 0-.407-.337zM1.7 14.781a.457.457 0 0 0-.46.46v7.829c0 .257.203.46.46.46h14.108c.257 0 .46-.203.46-.46v-6.589c0-.257.204-.46.461-.46h4.02c.258 0 .461.203.461.46v6.589c0 .257.204.46.46.46h.62a.456.456 0 0 0 .461-.46v-7.829a.458.458 0 0 0-.46-.46zm1.842 1.55h7.847c.212 0 .39.177.39.39V21.6c0 .212-.178.39-.39.39H3.542a.393.393 0 0 1-.39-.39v-4.88c0-.221.178-.39.39-.39Z",source:"https://hacs.xyz/",hex:"41BDF5",guidelines:void 0,license:void 0},siWireshark={title:"Wireshark",slug:"wireshark",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Wireshark</title><path d="'+this.path+'"/></svg>'},path:"m2.95 0c-1.62 0-2.95 1.32-2.95 2.95v18.1c0 1.63 1.32 2.95 2.95 2.95h18.1c1.62 0 2.95-1.32 2.95-2.95v-18.1c-.00024-1.63-1.32-2.95-2.95-2.95zm0 1.09h18.1c1.04 0 1.85.818 1.85 1.86v14h-5.27c-.335-.796-2.57-6.47.283-10.9a.516.517 0 0 0-.443-.794c-5.24.0827-8.2 3.19-9.74 6.21-1.35 2.64-1.63 4.91-1.69 5.53h-4.95v-14c0-1.04.817-1.86 1.85-1.86zm13.6 5.24c-2.62 5.24.248 11.4.248 11.4a.516.517 0 0 0 .469.301h5.62v3.05c0 1.04-.817 1.86-1.85 1.86h-18.1c-1.04 0-1.85-.818-1.85-1.86v-3.05h5.39a.516.517 0 0 0 .514-.477s.226-2.8 1.66-5.62c1.34-2.62 3.67-5.17 7.91-5.57z",source:"https://gitlab.com/wanduow/wireshark/-/blob/cd5539b0f76975474869984a9d2f0fce29d5c21e/image/wsicon.svg",hex:"1679A7",guidelines:void 0,license:void 0},siHomeadvisor={title:"HomeAdvisor",slug:"homeadvisor",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>HomeAdvisor</title><path d="'+this.path+'"/></svg>'},path:"M15.98 2.442H8.02L0 10.46h2.275l6.882-6.88 6.881 6.881H24l-8.02-8.018m-.492 9.348L9.157 5.459 4.01 10.605v4.987a1.33 1.33 0 0 0 1.329 1.329h6.077l4.637 4.637v-4.637h2.598a1.33 1.33 0 0 0 1.33-1.33V11.79h-4.494Z",source:"https://www.homeadvisor.com/",hex:"F68315",guidelines:void 0,license:void 0},siWizzair={title:"Wizz Air",slug:"wizzair",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Wizz Air</title><path d="'+this.path+'"/></svg>'},path:"M17.6366 10.393h2.3183l-2.7457 3.5919h-2.3195zm-.1745-.351l-2.9186 3.8194c-.0699.0911-.0812.2063-.0302.308a.2977.2977 0 0 0 .2643.1658h2.6055l2.9424-3.8484a.2817.2817 0 0 0 .0277-.2926c-.0472-.0942-.1429-.1521-.2508-.1521zM9.127 8.1753a.0859.0859 0 0 1 .074-.0421h1.5203l.2184-1.2553a.0823.0823 0 0 1 .0823-.0664l1.423-.001c.0262 0 .0472.0078.0623.0248a.0904.0904 0 0 1 .0197.0682l-.1416.8122 6.69.0049c.0361 0 .062.0218.0747.0429.0078.0156.0183.0472-.0035.0768l-.6041.7888 4.9581-.0013a.0661.0661 0 0 1 .0577.0342.0535.0535 0 0 1-.0005.0583l-4.1208 5.3952c-.047.0588-.0448.2082-.0121.2718.034.0642.1515.156.2251.156l2.8984.0031a.0795.0795 0 0 1 .0623.0278.0813.0813 0 0 1 .0189.0658l-.2203 1.2607a.0823.0823 0 0 1-.0823.066H11.2994l-.1812-.001a.915.915 0 0 1 .0188.1934c0 .567-.4595 1.0269-1.0274 1.0269-.5677 0-1.0274-.4598-1.0274-1.027 0-.5673.4597-1.0266 1.0274-1.0266a1.03 1.03 0 0 1 .9012.5318l4.4943-5.8922c.0723-.1521.0362-.2066-.0027-.2964-.0288-.0677-.1372-.1373-.2556-.136h-3.146L11.297 13.93c-.0078.0361-.0423.0612-.0809.0612H9.7922a.0828.0828 0 0 1-.0628-.0283.0787.0787 0 0 1-.0184-.0658l.8732-4.9824-3.5515 6.9628a.1814.1814 0 0 1-.1578.092l-1.2097.006c-.0432 0-.0788-.0308-.0825-.0678l-.3336-5.0579-2.6239 5.0288a.182.182 0 0 1-.157.0914l-1.227-.0008c-.042 0-.0779-.031-.0814-.071L.36 8.2208a.0874.0874 0 0 1 .0208-.0639c.0148-.0148.0364-.0232.062-.0232H2.092c.045 0 .0828.0367.0828.0847l.2473 5.0088 2.4254-5.0503a.0824.0824 0 0 1 .0733-.0432l1.5034-.0064c.0415 0 .0788.0315.0812.0682l.2443 5.0474zm1.8249-1.7154a.3501.3501 0 0 0-.3447.2896l-.1812 1.0323H9.1472c-.1306 0-.2473.0704-.3137.1923l-1.8003 3.84-.1785-3.7122a.351.351 0 0 0-.3492-.3198h-1.637a.3528.3528 0 0 0-.3135.193l-1.851 3.8544-.1826-3.6977a.3504.3504 0 0 0-.35-.3497H.3506a.3533.3533 0 0 0-.2586.1092c-.0648.0712-.0977.1702-.0912.2732l.8163 7.8411a.35.35 0 0 0 .3487.3115l1.3534.0005a.4463.4463 0 0 0 .3956-.2378l2.067-3.9601.2549 3.8862a.3508.3508 0 0 0 .3479.3115l1.3434.0005a.448.448 0 0 0 .3962-.2397l2.512-4.925-.4865 2.7779a.3553.3553 0 0 0 .076.2872.3507.3507 0 0 0 .268.1245h1.5922c.1653 0 .306-.1151.343-.2812l.7659-4.3713H15.13l-4.1332 5.4092a1.3776 1.3776 0 0 0-.8842-.3198c-.7602 0-1.3807.6194-1.3807 1.3802 0 .7612.6205 1.3804 1.3807 1.3804.6984 0 1.2928-.5337 1.3731-1.2227l10.9119-.0005a.3472.3472 0 0 0 .3444-.2902l.2497-1.4206a.3526.3526 0 0 0-.0777-.2853.348.348 0 0 0-.2678-.1235l-2.8299-.0027 4.126-5.3993c.07-.1046.0765-.2308.0183-.3395a.3309.3309 0 0 0-.2942-.1788h-4.4148l.28-.3657c.0733-.1097.0806-.2432.0188-.3597-.0617-.1144-.1798-.1872-.3085-.1872h-6.44l.0883-.495a.3605.3605 0 0 0-.0815-.2884c-.0658-.0784-.1596-.1213-.265-.1213h-1.592Z",source:"https://wizzair.com/en-gb/information-and-services/about-us/press-office/logos",hex:"C6007E",guidelines:void 0,license:void 0},siHomebridge={title:"Homebridge",slug:"homebridge",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Homebridge</title><path d="'+this.path+'"/></svg>'},path:"M12 0C5.373 0 0 5.373 0 12s5.373 12 12 12 12-5.373 12-12S18.627 0 12 0zm8.116 12.262a.74.74 0 0 1-.741-.74c0-.008.005-.016.005-.025l-1.46-1.46a1.31 1.31 0 0 1-.38-.917V5.731a.285.285 0 0 0-.284-.283h-.915a.284.284 0 0 0-.284.283v2.413L12.17 4.383a.284.284 0 0 0-.4.003L4.438 11.72a.283.283 0 0 0 0 .4l.696.697a.286.286 0 0 0 .4 0l5.635-5.552a1.302 1.302 0 0 1 1.83.008l5.525 5.525a1.3 1.3 0 0 1 0 1.836l-.679.68a1.305 1.305 0 0 1-1.824.012l-3.876-3.766a.283.283 0 0 0-.4.004l-3.723 3.74a.285.285 0 0 0 0 .4l.687.69a.283.283 0 0 0 .4 0l2.013-1.986a1.302 1.302 0 0 1 1.824 0l1.994 1.96.007.007a1.299 1.299 0 0 1 0 1.837l-1.985 1.984v.013a.74.74 0 1 1-.74-.741c.009 0 .016.005.025.005l1.975-1.98a.284.284 0 0 0 .084-.201.28.28 0 0 0-.085-.2l-1.995-1.96a.285.285 0 0 0-.4 0l-2.006 1.98a1.3 1.3 0 0 1-1.83-.004l-.69-.689a1.301 1.301 0 0 1 0-1.834l3.72-3.74a1.303 1.303 0 0 1 1.826-.016l3.879 3.758a.285.285 0 0 0 .4 0l.679-.679a.285.285 0 0 0 0-.4L12.28 7.986a.284.284 0 0 0-.4 0l-5.637 5.555a1.301 1.301 0 0 1-1.829-.008l-.698-.694-.002-.003a1.296 1.296 0 0 1 .002-1.834l7.334-7.334a1.305 1.305 0 0 1 1.821-.015l2.166 2.097v-.019a1.3 1.3 0 0 1 1.299-1.298h.916a1.3 1.3 0 0 1 1.298 1.298v3.384a.282.282 0 0 0 .083.2l1.467 1.467h.014a.74.74 0 0 1 .001 1.48z",source:"https://github.com/homebridge/branding/blob/6ef3a1685e79f79a2ecdcc83824e53775ec0475d/logos/homebridge-silhouette-round-black.svg",hex:"491F59",guidelines:void 0,license:void 0},siWolfram={title:"Wolfram",slug:"wolfram",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Wolfram</title><path d="'+this.path+'"/></svg>'},path:"M20.105 12.001l3.307-3.708-4.854-1.059.495-4.944-4.55 1.996L12 0 9.495 4.287 4.947 2.291l.494 4.944L.587 8.289l3.305 3.707-3.305 3.713 4.854 1.053-.5 4.945 4.553-1.994L12 24l2.504-4.287 4.55 1.994-.495-4.938 4.854-1.06-3.308-3.708zm1.605 2.792l-2.861-.982-1.899-2.471 2.526.942 2.234 2.511zm.459-6.096l-2.602 2.918-3.066-1.141 1.844-2.612 3.824.835zm-4.288-1.324l-1.533 2.179.088-3.162 1.788-2.415-.343 3.398zm-3.304-2.399l3.091-1.354L15.9 5.998l-2.943 1.049 1.62-2.073zm1.187 1.772l-.096 3.652-3.341 1.12V7.969l3.437-1.223zM12 1.308l1.969 3.371L12 7.199l-1.971-2.521L12 1.308zM9.423 4.974l1.619 2.072-2.948-1.048L6.332 3.62l3.091 1.354zm2.245 2.995v3.549l-3.335-1.12-.102-3.652 3.437 1.223zM7.564 6.39l.086 3.162-1.532-2.179-.341-3.397L7.564 6.39zM1.83 8.692l3.824-.83 1.839 2.612-3.065 1.136L1.83 8.692zm2.694 3.585l2.526-.937-1.9 2.471-2.861.977 2.235-2.511zm-2.093 3.159l2.929-1 3.045.896-2.622.837-3.352-.733zm3.28 5.212l.392-3.896 3.111-.982.082 3.31-3.585 1.568zm3.691-5.708l-3.498-1.03 2.226-2.892 3.335 1.126-2.063 2.796zm2.266 7.191l-1.711-2.934-.066-2.771 1.777 2.597v3.108zm-1.73-6.8L12 12.532l2.063 2.799L12 18.336l-2.062-3.005zm4.104 3.866l-1.715 2.934v-3.107l1.782-2.597-.067 2.77zm-1.514-7.052l3.341-1.126 2.221 2.892-3.499 1.03-2.063-2.796zm2.175 6.935l.077-3.31 3.116.982.386 3.901-3.579-1.573zm3.514-2.912l-2.625-.837 3.049-.896 2.928 1.003-3.352.73z",source:"http://company.wolfram.com/press-center/wolfram-corporate/",hex:"DD1100",guidelines:void 0,license:void 0},siHomify={title:"homify",slug:"homify",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>homify</title><path d="'+this.path+'"/></svg>'},path:"M20.383 10.561a1.727 1.727 0 0 1 0 .055l-.004.048c-.088 2.33-.057 11.357-.057 11.823.002 1.078-.826 1.943-1.596 1.283l-6.98-5.53a373.72 373.72 0 0 1-4.742 4.925c-.977.946-1.786-1.327-1.045-1.808.066-.042 2.223-1.95 4.61-4.05L5.4 13.214c-.446-.356-.618-.946-.363-1.261a.46.46 0 0 1 .328-.127.47.47 0 0 1 .164.037c1.596.722 3.962 2.492 6.314 4.329 2.45-2.15 4.805-4.191 5.116-4.364.38-.214.48.354.354.516-.131.166-2.169 2.326-4.408 4.678 2.204 1.732 4.294 3.389 5.614 4.137l.217-10.62c-.17-.206-5.332-7.163-5.892-7.746-.892.78-5.566 6.112-5.802 6.342 1.067.11 5.597.382 8.452.684.721.07 1.2.606-.346.59l-11.105-.015a.44.44 0 0 1-.394-.267.415.415 0 0 1 .094-.457C3.8 9.613 11.782.748 12.454.184A.702.702 0 0 1 12.935 0a.732.732 0 0 1 .483.227c.083.077 4.292 5.94 6.344 8.802.492.678.617 1.137.621 1.5z",source:"https://www.homify.com",hex:"7DCDA3",guidelines:void 0,license:void 0},siWolframlanguage={title:"Wolfram Language",slug:"wolframlanguage",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Wolfram Language</title><path d="'+this.path+'"/></svg>'},path:"M14.335 12.431c-.552.15-.615.18-1.164.337-.589-.337-1.107-.526-1.595-.463.057-.306.151-.525.245-.8 1.036-.15 1.805.4 2.514.926zm5.308 7.201a10.795 10.795 0 0 1-1.907 1.52h-.006l-3.702-4.613 3.07.336s1.47.151 1.807 0c.308-.117 1.963-2.449 1.963-2.449s-4.76-3.009-6.384-4.666c.188-2.793-.213-6.508-.213-6.478-1.193 1.195-1.35 1.383-2.544 2.489-.52-1.688-.769-2.27-1.289-3.958-1.568 1.289-2.763 3.464-3.62 6.016a12.29 12.29 0 0 0-.55.656c-.113.157-.23.313-.345.475a16.126 16.126 0 0 0-1.101 1.819c-.063.112-.125.231-.188.35-.913 1.788-1.676 3.79-2.338 5.604A10.824 10.824 0 0 1 1.205 12c0-2.862 1.138-5.613 3.163-7.64A10.785 10.785 0 0 1 12 1.202a10.8 10.8 0 0 1 7.642 3.158A10.83 10.83 0 0 1 22.797 12a10.813 10.813 0 0 1-3.154 7.633M12 6.691c.832-.801.951-.92 1.75-1.69.064 1.533.032 2.334-.062 4.204-.463-.458-1.381-1.044-1.381-1.044S12.126 7.09 12 6.69m3.834 15.463C9.218 24.547 4.436 20.14 3.417 18.602c.006-.014.006-.027.006-.039.92-3.889 2.058-8.535 3.884-9.91.955-1.655 1.231-4.113 2.943-5.401.432 1.288 1.107 3.958 1.57 5.246 2.025 2.025 5.087 4.545 7.146 5.59.212.12.489.98.489.98l-.825 1.038-8.835-.887c-.2-.02-.394-.028-.594-.028-.569 0-1.15.073-1.833.18.432-1.07 1.35-1.936 1.35-1.936s-.855-.519-1.505-.605c.187-.432.681-.989.8-1.138-.244.087-2.026.888-2.208 1.563.857.214 1.47.487 1.47.487s-.95.957-1.132 2.612c0 0 2.82-.43 4.939-.153.063.03.094.03.125.03l1.102.031 3.509 5.84.027.046a.012.012 0 0 1-.011.006m4.652-18.64A12.02 12.02 0 0 0 12 0C8.818 0 5.768 1.27 3.516 3.515a12.025 12.025 0 0 0-3.513 8.484c0 3.183 1.27 6.235 3.512 8.478a11.98 11.98 0 0 0 16.97 0 11.966 11.966 0 0 0 3.512-8.478c0-3.181-1.26-6.233-3.511-8.484z",source:"http://company.wolfram.com/press-center/language/",hex:"DD1100",guidelines:void 0,license:void 0},siWolframmathematica={title:"Wolfram Mathematica",slug:"wolframmathematica",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Wolfram Mathematica</title><path d="'+this.path+'"/></svg>'},path:"M15.74 10.7c-.53-1.53.14-4 .14-4S13.6 8.01 11.93 8 8.13 6.7 8.13 6.7s.56 2.46.07 4.04c-.48 1.58-2.47 3.34-2.47 3.34s2.58.23 3.85 1.1S12 18.64 12 18.64s.78-2.35 2.32-3.41c1.54-1.07 3.96-1.15 3.96-1.15s-2-1.84-2.54-3.37zm-2 3.69c-1.09.81-1.75 2.19-1.75 2.19s-.76-1.43-1.8-2.22c-1.05-.79-2.57-.97-2.57-.97a5.06 5.06 0 0 0 1.53-2.37c.46-1.54.18-2.73.18-2.73s.92.7 2.62.7c1.7 0 2.79-.7 2.79-.7s-.38 1.58.07 2.7c.44 1.14 1.57 2.41 1.57 2.41s-1.56.17-2.64.99zM13.73 9.6s-.95.38-1.77.37c-.82 0-1.7-.37-1.7-.37.05.58 0 1.15-.17 1.7-.27.86-.91 1.64-.91 1.64A4.23 4.23 0 0 1 12 14.95s.45-.85 1.18-1.33c.5-.31 1.05-.55 1.63-.7 0 0-.74-.78-1.02-1.57-.28-.78-.06-1.75-.06-1.75zM20.1 12l3.31-3.7-4.85-1.07.5-4.94-4.56 2L12 0 9.5 4.29l-4.55-2 .49 4.95L.59 8.29 3.89 12 .6 15.7l4.85 1.07-.5 4.94 4.55-2L12 24l2.5-4.29 4.56 2-.5-4.94 4.85-1.06-3.3-3.71zm-5.27 3.95C14 16.56 12 20.81 12 20.81S10.5 16.95 9 15.95c-1.48-1-5.38-1.22-5.38-1.22s2.99-2.37 3.57-4.47c.59-2.1-.37-5.37-.37-5.37s2.9 2.1 5.08 2.1c2.17 0 5.26-2.1 5.26-2.1s-.82 4.5-.53 5.46c.3.96 3.73 4.38 3.73 4.38s-4.7.62-5.54 1.22z",source:"http://company.wolfram.com/press-center/mathematica/",hex:"DD1100",guidelines:void 0,license:void 0},siWoo={title:"Woo",slug:"woo",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Woo</title><path d="'+this.path+'"/></svg>'},path:"M2.227 4.857A2.228 2.228 0 000 7.094v7.457c0 1.236 1.001 2.237 2.237 2.237h9.253l4.229 2.355-.962-2.355h7.006c1.236 0 2.237-1 2.237-2.237V7.094c0-1.236-1-2.237-2.237-2.237zm8.08 1.311c.194.002.372.071.535.2a.769.769 0 01.304.56.851.851 0 01-.098.47c-.382.707-.696 1.894-.951 3.542-.246 1.6-.334 2.846-.275 3.739.02.245-.02.46-.118.647a.632.632 0 01-.52.353c-.255.02-.52-.098-.775-.362-.913-.933-1.639-2.326-2.169-4.18a184.085 184.085 0 00-1.413 2.825c-.578 1.11-1.069 1.678-1.481 1.708-.265.02-.49-.206-.687-.677-.5-1.286-1.04-3.768-1.619-7.448-.03-.255.02-.48.157-.657.137-.186.344-.284.618-.304.5-.04.785.196.854.706.304 2.051.638 3.788.991 5.21L5.809 8.41c.196-.373.441-.57.736-.589.431-.03.696.245.804.824.246 1.305.56 2.414.932 3.356.255-2.492.687-4.288 1.295-5.397.148-.274.363-.412.648-.431a.866.866 0 01.084-.004zm3.734 1.063c.167 0 .343.02.53.06.687.146 1.216.52 1.57 1.137.314.53.47 1.168.47 1.933 0 1.011-.254 1.933-.765 2.777-.588.981-1.354 1.472-2.305 1.472-.167 0-.344-.02-.53-.059-.697-.147-1.217-.52-1.57-1.138-.314-.54-.471-1.187-.471-1.943 0-1.01.255-1.933.765-2.767.599-.981 1.364-1.472 2.306-1.472zm6.152 0c.167 0 .343.02.53.06.696.146 1.216.52 1.57 1.137.314.53.47 1.168.47 1.933 0 1.011-.254 1.933-.765 2.777-.588.981-1.354 1.472-2.305 1.472-.167 0-.344-.02-.53-.059-.697-.147-1.217-.52-1.57-1.138-.314-.54-.471-1.187-.471-1.943 0-1.01.255-1.933.765-2.767.599-.981 1.364-1.472 2.306-1.472zm-6.107 1.645c-.307-.002-.606.201-.889.622a3.173 3.173 0 00-.52 1.168c-.05.225-.069.47-.069.716 0 .284.06.589.177.893.147.382.343.589.579.638.245.049.51-.06.795-.315.363-.323.608-.804.745-1.452.05-.225.069-.47.069-.726a2.49 2.49 0 00-.176-.893c-.148-.382-.344-.588-.58-.637a.714.714 0 00-.131-.014zm6.152 0c-.307-.002-.606.201-.889.622a3.173 3.173 0 00-.52 1.168c-.049.225-.069.47-.069.716 0 .284.06.589.177.893.147.382.344.589.579.638.245.049.51-.06.795-.315.363-.323.608-.804.745-1.452.04-.225.07-.47.07-.726a2.49 2.49 0 00-.177-.893c-.148-.382-.344-.588-.58-.637a.714.714 0 00-.131-.014Z",source:"https://woocommerce.com/style-guide/",hex:"96588A",guidelines:"https://woocommerce.com/trademark-guidelines/",license:void 0},siWoocommerce={title:"WooCommerce",slug:"woocommerce",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>WooCommerce</title><path d="'+this.path+'"/></svg>'},path:"M.754 9.58a.754.754 0 00-.754.758v2.525c0 .42.339.758.758.758h3.135l1.431.799-.326-.799h2.373a.757.757 0 00.758-.758v-2.525a.757.757 0 00-.758-.758H.754zm2.709.445h.03c.065.001.124.023.179.067a.26.26 0 01.103.19.29.29 0 01-.033.16c-.13.239-.236.64-.322 1.199-.083.541-.114.965-.094 1.267a.392.392 0 01-.039.219.213.213 0 01-.176.12c-.086.006-.177-.034-.263-.124-.31-.316-.555-.788-.735-1.416-.216.425-.375.744-.478.957-.196.376-.363.568-.502.578-.09.007-.166-.069-.233-.228-.17-.436-.352-1.277-.548-2.524a.297.297 0 01.054-.222c.047-.064.116-.095.21-.102.169-.013.265.065.288.238.103.695.217 1.284.336 1.766l.727-1.387c.066-.126.15-.192.25-.199.146-.01.237.083.273.28.083.441.188.817.315 1.136.086-.844.233-1.453.44-1.828a.255.255 0 01.218-.147zm1.293.36c.056 0 .116.006.18.02.232.05.411.177.53.386.107.18.161.395.161.654 0 .343-.087.654-.26.94-.2.332-.459.5-.781.5a.88.88 0 01-.18-.022.763.763 0 01-.531-.384 1.287 1.287 0 01-.158-.659c0-.342.085-.655.258-.937.202-.333.462-.498.78-.498zm2.084 0c.056 0 .116.006.18.02.236.05.411.177.53.386.107.18.16.395.16.654 0 .343-.086.654-.259.94-.2.332-.459.5-.781.5a.88.88 0 01-.18-.022.763.763 0 01-.531-.384 1.287 1.287 0 01-.16-.659c0-.342.087-.655.26-.937.202-.333.462-.498.78-.498zm4.437.047c-.305 0-.546.102-.718.304-.173.203-.256.49-.256.856 0 .395.086.697.256.906.17.21.418.316.744.316.315 0 .559-.107.728-.316.17-.21.256-.504.256-.883s-.087-.673-.26-.879c-.176-.202-.424-.304-.75-.304zm-1.466.002a1.13 1.13 0 00-.84.326c-.223.22-.332.499-.332.838 0 .362.108.658.328.88.22.223.505.336.861.336.103 0 .22-.016.346-.052v-.54c-.117.034-.216.051-.303.051a.545.545 0 01-.422-.177c-.106-.12-.16-.278-.16-.48 0-.19.053-.348.156-.468a.498.498 0 01.397-.181c.103 0 .212.015.332.049v-.537a1.394 1.394 0 00-.363-.045zm12.414 0a1.135 1.135 0 00-.84.326c-.223.22-.332.499-.332.838 0 .362.108.658.328.88.22.223.506.336.861.336.103 0 .22-.016.346-.052v-.54c-.116.034-.216.051-.303.051a.545.545 0 01-.422-.177c-.106-.12-.16-.278-.16-.48 0-.19.053-.348.156-.468a.498.498 0 01.397-.181c.103 0 .212.015.332.049v-.537a1.394 1.394 0 00-.363-.045zm-9.598.06l-.29 2.264h.579l.156-1.559.395 1.559h.412l.379-1.555.164 1.555h.603l-.304-2.264h-.791l-.12.508c-.03.13-.06.264-.087.4l-.067.352a29.97 29.97 0 00-.258-1.26h-.771zm2.768 0l-.29 2.264h.579l.156-1.559.396 1.559h.412l.375-1.555.165 1.555h.603l-.305-2.264h-.789l-.119.508c-.03.13-.06.264-.086.4l-.066.352c-.063-.352-.15-.771-.26-1.26h-.771zm3.988 0v2.264h.611v-1.031h.012l.494 1.03h.645l-.489-1.019a.61.61 0 00.37-.552.598.598 0 00-.25-.506c-.167-.123-.394-.186-.68-.186h-.713zm3.377 0v2.264H24v-.483h-.63v-.414h.54v-.468h-.54v-.416h.626v-.483H22.76zm-4.793.004v2.264h1.24v-.483h-.627v-.416h.541v-.468h-.54v-.415h.622v-.482h-1.236zm2.025.432c.146.003.25.025.313.072.063.046.091.12.091.227 0 .156-.135.236-.404.24v-.54zm-15.22.011c-.104 0-.205.069-.301.211a1.078 1.078 0 00-.2.639c0 .096.02.2.06.303.049.13.117.198.196.215.083.016.173-.02.27-.106.123-.11.205-.273.252-.492.016-.077.023-.16.023-.246 0-.097-.02-.2-.06-.303-.05-.13-.116-.198-.196-.215a.246.246 0 00-.045-.006zm2.083 0c-.103 0-.204.069-.3.211a1.078 1.078 0 00-.2.639c0 .096.02.2.06.303.049.13.117.198.196.215.083.016.173-.02.27-.106.123-.11.205-.273.252-.492.013-.077.023-.16.023-.246 0-.097-.02-.2-.06-.303-.05-.13-.116-.198-.196-.215a.246.246 0 00-.045-.006zm4.428.006c.233 0 .354.218.354.66-.004.273-.038.46-.098.553a.293.293 0 01-.262.139.266.266 0 01-.242-.139c-.056-.093-.084-.28-.084-.562 0-.436.11-.65.332-.65Z",source:"https://woocommerce.com/style-guide/",hex:"96588A",guidelines:"https://woocommerce.com/trademark-guidelines/",license:void 0},siWordpress={title:"WordPress",slug:"wordpress",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>WordPress</title><path d="'+this.path+'"/></svg>'},path:"M21.469 6.825c.84 1.537 1.318 3.3 1.318 5.175 0 3.979-2.156 7.456-5.363 9.325l3.295-9.527c.615-1.54.82-2.771.82-3.864 0-.405-.026-.78-.07-1.11m-7.981.105c.647-.03 1.232-.105 1.232-.105.582-.075.514-.93-.067-.899 0 0-1.755.135-2.88.135-1.064 0-2.85-.15-2.85-.15-.585-.03-.661.855-.075.885 0 0 .54.061 1.125.09l1.68 4.605-2.37 7.08L5.354 6.9c.649-.03 1.234-.1 1.234-.1.585-.075.516-.93-.065-.896 0 0-1.746.138-2.874.138-.2 0-.438-.008-.69-.015C4.911 3.15 8.235 1.215 12 1.215c2.809 0 5.365 1.072 7.286 2.833-.046-.003-.091-.009-.141-.009-1.06 0-1.812.923-1.812 1.914 0 .89.513 1.643 1.06 2.531.411.72.89 1.643.89 2.977 0 .915-.354 1.994-.821 3.479l-1.075 3.585-3.9-11.61.001.014zM12 22.784c-1.059 0-2.081-.153-3.048-.437l3.237-9.406 3.315 9.087c.024.053.05.101.078.149-1.12.393-2.325.609-3.582.609M1.211 12c0-1.564.336-3.05.935-4.39L7.29 21.709C3.694 19.96 1.212 16.271 1.211 12M12 0C5.385 0 0 5.385 0 12s5.385 12 12 12 12-5.385 12-12S18.615 0 12 0",source:"https://wordpress.org/about/logos",hex:"21759B",guidelines:void 0,license:void 0},siWorkplace={title:"Workplace",slug:"workplace",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Workplace</title><path d="'+this.path+'"/></svg>'},path:"M23.268 10.541C23.268 4.715 18.544 0 12.728 0c-1.614 0-3.191.317-4.663.952a11.952 11.952 0 00-3.817 2.574 11.915 11.915 0 00-3.516 8.478 11.924 11.924 0 003.516 8.48 12.05 12.05 0 003.817 2.573c1.472.626 3.05.943 4.671.943 1.56 0 3.05-.3 4.416-.837l-.908-2.292a9.448 9.448 0 01-3.508.67 9.481 9.481 0 01-6.743-2.794A9.481 9.481 0 013.2 12.004c0-2.547.996-4.944 2.794-6.742a9.496 9.496 0 016.743-2.794 8.072 8.072 0 016.734 12.524l-2.098-5.165c-.308-.758-.679-1.895-2.071-1.895-1.393 0-1.763 1.146-2.063 1.895l-1.93 4.769-2.591-6.54H5.993l3.226 7.95c.326.802.688 1.895 2.09 1.895 1.4 0 1.753-1.093 2.08-1.895l1.912-4.724 1.921 4.724c.388.978.802 1.895 2.08 1.895.908 0 1.481-.582 1.798-.96a10.493 10.493 0 002.168-6.4Z",source:"https://en.facebookbrand.com/",hex:"4326C4",guidelines:"https://en.facebookbrand.com/",license:void 0},siWpengine={title:"WP Engine",slug:"wpengine",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>WP Engine</title><path d="'+this.path+'"/></svg>'},path:"M8.145 0v5.867L9.99 7.71h4.022l1.845-1.844V0zm8.145 0v5.867l1.845 1.844h5.864V.001zM1.845 0L0 1.845v5.866h7.712V0zM0 8.146v7.71h5.866l1.845-1.844V8.145zm18.133 0L16.29 9.989v4.022l1.845 1.845H24V8.145zm-6.147 2.75a1.105 1.105 0 00.014 2.21A1.105 1.105 0 0013.105 12a1.105 1.105 0 00-1.118-1.104zM0 16.29v7.71h5.866l1.845-1.842v-4.023l-1.845-1.845zm9.988 0l-1.843 1.845V24h7.71v-5.866L14.01 16.29zm6.3 0V24H24v-5.865l-1.842-1.845z",source:"https://wpengine.com/brand-assets/",hex:"0ECAD4",guidelines:void 0,license:void 0},siWprocket={title:"WP Rocket",slug:"wprocket",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>WP Rocket</title><path d="'+this.path+'"/></svg>'},path:"M3.723.666c-.08-.276.08-.47.356-.47h2.283c.16 0 .31.137.356.274L8.393 7.07h.08L11.491.218A.374.374 0 0111.824 0h.356c.172 0 .287.092.333.218l3.018 6.85h.08L17.286.47a.397.397 0 01.356-.275h2.284c.275 0 .424.195.355.47l-3.683 13.082a.369.369 0 01-.356.275h-.31a.38.38 0 01-.333-.218l-3.568-7.963h-.058l-3.545 7.963a.403.403 0 01-.333.218h-.31a.379.379 0 01-.356-.275L3.723.666m8.308 7.917l-2.594 5.818a1.663 1.663 0 01-.344.448v.004a1.466 1.466 0 01-.688.34l1.4 8.687c.091.16.263.16.367 0l1.79-2.72 1.64 2.708c.104.16.265.16.368 0l1.584-8.698a1.5 1.5 0 01-.832-.618l-.02-.03a1.405 1.405 0 01-.066-.12l-.609-1.366h-.003Z",source:"https://wp-rocket.me/",hex:"F56640",guidelines:void 0,license:void 0},siWwe={title:"WWE",slug:"wwe",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>WWE</title><path d="'+this.path+'"/></svg>'},path:"M24 1.047L15.67 18.08l-3.474-8.53-3.474 8.53L.393 1.048l3.228 8.977 3.286 8.5C3.874 19.334 1.332 20.46 0 21.75c.443-.168 3.47-1.24 7.409-1.927l1.21 3.129 1.552-3.518a36.769 36.769 0 0 1 3.96-.204l1.644 3.722 1.4-3.62c2.132.145 3.861.426 4.675.692 0 0 .92-1.962 1.338-2.866a54.838 54.838 0 0 0-5.138-.092l2.722-7.042zm-21.84.026L8.64 13.86l3.568-9.155 3.567 9.155 6.481-12.788-6.433 8.452-3.615-8.22-3.615 8.22zm10.036 13.776l1.115 2.523a42.482 42.482 0 0 0-2.363.306Z",source:"https://commons.wikimedia.org/wiki/File:WWE_Network_logo.svg",hex:"000000",guidelines:void 0,license:void 0},siWwise={title:"Wwise",slug:"wwise",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Wwise</title><path d="'+this.path+'"/></svg>'},path:"M6 12c0 .7644-.6193 1.3846-1.3846 1.3846-.7645 0-1.3847-.6202-1.3847-1.3846 0-.765.6202-1.3846 1.3847-1.3846C5.3807 10.6154 6 11.2351 6 12m7.8462-5.5384c0 1.0191-.826 1.8461-1.8463 1.8461-1.0188 0-1.8461-.827-1.8461-1.8461 0-1.0197.8273-1.8462 1.8461-1.8462 1.0203 0 1.8463.8265 1.8463 1.8462M1.8462 12a.923.923 0 0 1-.9231.923C.4143 12.923 0 12.5096 0 12c0-.5102.4142-.923.923-.923.51 0 .923.4128.923.923M24 12c0 .5095-.4133.923-.923.923-.5089 0-.9231-.4135-.9231-.923 0-.5102.4142-.923.923-.923.5098 0 .923.4128.923.923m-3.2306 0c0 .7644-.6195 1.3846-1.3847 1.3846C18.6203 13.3846 18 12.7644 18 12c0-.765.6203-1.3846 1.3846-1.3846.7652 0 1.3847.6197 1.3847 1.3846m-8.2252 2.8356c.0034.535.2557 1.0139.6581 1.3139.4006.3332.6584.8409.6584 1.4048 0 1.0139-.8192 1.8303-1.8295 1.8303H12c-1.0116 0-1.8317-.8164-1.8317-1.8303 0-.564.2596-1.0716.6606-1.4048.3999-.3.6615-.7788.6577-1.314v-.1283c-.004-.5395-.2578-1.0183-.6577-1.3154-.401-.336-.6606-.8423-.6606-1.4077 0-1.0125.8201-1.8302 1.8317-1.8302h.0312c1.0103 0 1.8295.8177 1.8295 1.8302 0 .5654-.2578 1.0717-.6584 1.4077a1.6166 1.6166 0 0 0-.658 1.3154v.1284m3.6922-2.7692c.0033.535.2557 1.0139.658 1.3139.4007.3332.6585.8409.6585 1.4048 0 1.0139-.8192 1.8302-1.8295 1.8302h-.031c-1.0118 0-1.8318-.8163-1.8318-1.8302 0-.564.2597-1.0716.6606-1.4048.3999-.3.6614-.7788.6577-1.314v-.1283c-.004-.5395-.2578-1.0183-.6577-1.3154-.401-.336-.6606-.8423-.6606-1.4077 0-1.0125.82-1.8302 1.8318-1.8302h.031c1.0103 0 1.8295.8177 1.8295 1.8302 0 .5654-.2578 1.0717-.6584 1.4077a1.6166 1.6166 0 0 0-.658 1.3154v.1284m-7.3848 0c.0035.535.2559 1.0139.6582 1.3139a1.828 1.828 0 0 1 .6583 1.4048c0 1.0139-.8193 1.8302-1.8294 1.8302h-.0312c-1.0116 0-1.8317-.8163-1.8317-1.8302 0-.564.2596-1.0716.6606-1.4048.3999-.3.6615-.7788.6577-1.314v-.1283c-.004-.5395-.2578-1.0183-.6577-1.3154-.401-.336-.6606-.8423-.6606-1.4077 0-1.0125.8201-1.8302 1.8317-1.8302h.0312c1.0101 0 1.8294.8177 1.8294 1.8302 0 .5654-.2578 1.0717-.6583 1.4077a1.617 1.617 0 0 0-.6582 1.3154v.1284",source:"https://www.audiokinetic.com/resources/credits/",hex:"00549F",guidelines:"https://www.audiokinetic.com/resources/credits/",license:void 0},siHonda={title:"Honda",slug:"honda",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Honda</title><path d="'+this.path+'"/></svg>'},path:"M23.902 6.87c-.33-3.218-2.47-3.895-4.354-4.204-.946-.16-2.63-.3-3.716-.34-.946-.06-3.168-.09-3.835-.09-.657 0-2.89.03-3.835.09-1.076.04-2.77.18-3.716.34C2.563 2.985.42 3.66.092 6.87c-.08.877-.1 2.023-.09 3.248.03 2.031.2 3.406.3 4.363.07.657.338 2.62.687 3.636.478 1.395.916 1.803 1.424 2.222.937.757 2.471.996 2.79 1.056 1.733.31 5.24.368 6.784.368 1.544 0 5.05-.05 6.784-.368.329-.06 1.863-.29 2.79-1.056.508-.419.946-.827 1.424-2.222.35-1.016.628-2.979.698-3.636.1-.957.279-2.332.299-4.363.04-1.225.01-2.371-.08-3.248m-1.176 5.4c-.19 2.57-.418 4.104-.747 5.22-.29.976-.637 1.623-1.165 2.092-.867.787-2.063.956-2.76 1.056-1.514.23-4.055.3-6.057.3-2.002 0-4.543-.08-6.057-.3-.697-.1-1.893-.269-2.76-1.056-.518-.469-.876-1.126-1.155-2.093-.329-1.105-.558-2.65-.747-5.22-.11-1.543-.09-4.054.08-5.4.258-2.011 1.255-3.018 3.387-3.396.996-.18 2.34-.31 3.606-.37 1.016-.07 2.7-.1 3.636-.09.936-.01 2.62.03 3.636.09 1.275.06 2.61.19 3.606.37 2.142.378 3.139 1.395 3.388 3.397.199 1.345.229 3.856.11 5.4m-5.202-8.39c-.548 2.462-.767 3.588-1.216 5.37-.428 1.715-.767 3.298-1.335 4.065-.587.777-1.365.947-1.893 1.006-.279.03-.478.04-1.066.05-.596 0-.796-.02-1.075-.05-.528-.06-1.315-.229-1.892-1.006-.578-.767-.907-2.35-1.335-4.064-.47-1.773-.678-2.91-1.236-5.37 0 0-.548.02-.797.04-.329.02-.588.05-.867.09.343 5.372.692 11.079 1.126 16.13a21.983 21.983 0 002.39.169c.33-1.266.748-3.02 1.207-3.767.378-.608.966-.677 1.295-.717.518-.07.956-.08 1.165-.08.2-.01.637 0 1.165.08.33.05.917.11 1.295.717.47.747.877 2.5 1.206 3.766 0 0 .358-.01 1.165-.05.41-.018.82-.058 1.226-.12.458-5.39.785-10.728 1.126-16.128-.28-.04-.538-.07-.867-.09-.23-.02-.787-.04-.787-.04z",source:"https://www.honda.ie/",hex:"E40521",guidelines:void 0,license:void 0},siHootsuite={title:"Hootsuite",slug:"hootsuite",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Hootsuite</title><path d="'+this.path+'"/></svg>'},path:"M12.002 0h.023c1.311.004 2.603.322 3.766.928C16.948.332 18.23.022 19.532.022h.676V24l-.656-.002C15.369 24 11.356 22.336 8.4 19.373 5.43 16.43 3.77 12.414 3.791 8.23V.021h.677c1.301 0 2.586.311 3.741.906C9.381.318 10.682 0 12.002 0zm0 .654c-1.381 0-2.676.373-3.791 1.021-1.138-.655-2.428-1.001-3.742-1h-.022V8.23c-.025 8.35 6.764 15.09 15.107 15.113V.675h-.022c-1.313-.001-2.604.343-3.743.999-1.144-.666-2.443-1.018-3.766-1.02h-.021zm3.252 2.754c1.79.002 3.238 1.453 3.237 3.242-.003 1.791-1.454 3.238-3.244 3.236-.616 0-1.22-.176-1.739-.508l-1.516 1.508-1.507-1.516c-1.514.952-3.515.495-4.465-1.02-.952-1.516-.495-3.516 1.021-4.467s3.516-.494 4.467 1.022c.273.437.44.933.483 1.446l.016-.02.015.018c.154-1.667 1.556-2.945 3.232-2.941zM8.76 8.789c1.192.006 2.163-.959 2.168-2.15.001-.219-.031-.436-.096-.644-.243.544-.882.788-1.426.546-.545-.244-.79-.883-.546-1.428.109-.243.304-.437.548-.547-1.137-.355-2.347.276-2.705 1.414-.066.207-.099.424-.1.642-.003 1.192.96 2.163 2.153 2.167h.004zm6.478.019c1.193.003 2.163-.962 2.166-2.155s-.963-2.162-2.155-2.164c-.216-.002-.431.03-.638.094.545.244.789.883.547 1.428-.244.543-.883.787-1.428.545-.245-.109-.439-.307-.549-.553-.355 1.139.279 2.352 1.417 2.707.209.063.423.097.64.098z",source:"https://hootsuite.widencollective.com/portals/bafpk5oo/MediaKitAssets/c/b9e3a7bb-aca7-48d7-90ed-cff5898aafd0",hex:"143059",guidelines:"https://hootsuite.widencollective.com/portals/bafpk5oo/MediaKitAssets",license:void 0},siHoppscotch={title:"Hoppscotch",slug:"hoppscotch",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Hoppscotch</title><path d="'+this.path+'"/></svg>'},path:"M17.119 5.505a4.786 4.786 0 0 0-4.016-4.254c-2.188-.342-4.256.854-5.128 2.786-4.494-.278-7.784.257-7.966 1.47-.17 1.041 1.992 2.32 5.383 3.362l.001.006C5.308 8.841.333 22.807.333 22.807h18.803s-1.145-11.966-1.316-11.966c3.539.051 6-.496 6.172-1.539.178-1.188-2.662-2.682-6.873-3.797zm-.375 1.353c-.035.274-.309.479-.582.427s-.479-.308-.428-.581c.053-.273.309-.479.582-.427s.479.307.428.581zm-5.162-1.163a.67.67 0 0 1 .786-.564.67.67 0 0 1 .564.787.715.715 0 0 1-.786.564.67.67 0 0 1-.564-.787zm-3.949-.273c.051-.274.307-.479.581-.427s.479.308.427.581c-.034.273-.308.461-.581.427-.273-.051-.478-.308-.427-.581zm9.521 5.419c-.119.684-2.701.871-5.778.376-3.077-.495-5.47-1.453-5.368-2.153.068-.377.854-.599 2.051-.65-.358.067-.58.204-.614.376-.085.512 1.744 1.247 4.068 1.623 2.342.359 4.29.24 4.375-.291.018-.17-.154-.375-.479-.563 1.13.426 1.814.872 1.745 1.282z",source:"https://github.com/hoppscotch/hoppscotch/blob/77862cdf9bd902a4ea64bd8b2301ed2206820649/static/images/ufo_logo.svg",hex:"31C48D",guidelines:void 0,license:void 0},siHotelsdotcom={title:"Hotels.com",slug:"hotelsdotcom",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Hotels.com</title><path d="'+this.path+'"/></svg>'},path:"M20.6672 1.3329c-1.4725 0-2.6661 1.1936-2.6661 2.6662v4.334L11.334 8V3.3326C11.3342 1.4927 9.8415 0 8 0 6.1584 0 4.6672 1.4928 4.6672 3.3327v17.3346C4.6672 22.5088 6.1584 24 8 24s3.3343-1.4912 3.3343-3.3327v-5.3338h6.6669v5.3338c0 1.4726 1.1936 2.6661 2.6661 2.6661 1.4726 0 2.6662-1.1935 2.6662-2.666V3.9991c0-1.4725-1.1936-2.6661-2.6662-2.6661M4 3.333c0-.5379.1085-1.051.3023-1.5206-.975.5812-1.6354 1.6353-1.6354 2.8537v15.335c0 1.4323.9084 2.6429 2.1779 3.114C4.3178 22.4379 4 21.59 4 20.6677zm-1.698-.1874C1.327 3.7269.6666 4.7825.6666 5.9993v12.6673c0 1.2184.6604 2.2724 1.6354 2.8537a3.9658 3.9658 0 0 1-.3023-1.5206V4.6662c0-.5379.1085-1.051.3023-1.5206m15.0318.854c0-.6976.217-1.344.5844-1.8803-1.1052.3256-1.9175 1.3362-1.9175 2.5468v2.9002l1.3331.0668zm0 12.0004h-1.333v4.0008c0 1.2106.8122 2.2212 1.9174 2.5467-.3674-.5363-.5844-1.1827-.5844-1.8802zm-3.3334 3.3335c0 1.2106.8122 2.2212 1.919 2.5467-.369-.5363-.586-1.1827-.586-1.8802v-4.0008h-1.333zm1.3333-14.6671c0-.6976.217-1.344.5844-1.8803-1.1052.3256-1.9174 1.3362-1.9174 2.5468v2.133l1.333.0667Z",source:"https://en.wikipedia.org/wiki/File:Hotels.com_logo.svg",hex:"D32F2F",guidelines:void 0,license:void 0},siHotjar={title:"Hotjar",slug:"hotjar",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Hotjar</title><path d="'+this.path+'"/></svg>'},path:"M21.055 7.814C17.512 1.404 7.118 0 7.118 0s4.798 5.34-1.334 9.567c-3.876 2.666-5.41 6.13-3.75 9.914 1.27 2.9 3.96 4.076 6.86 4.519-.745-1.434-.932-3.505-.381-5.628.055-.212.116-.434.186-.636.813 1.258 2.148 1.946 3.45 1.629 1.783-.424 2.829-2.582 2.342-4.799a5.104 5.104 0 00-.536-1.372c.07.017.14.024.212.047 2.225.635 3.301 3.962 2.403 7.434a9.266 9.266 0 01-1.325 2.946c3.82-1.23 6.36-4.311 7.06-7.056.736-2.856.177-6.185-1.25-8.751z",source:"https://www.hotjar.com/",hex:"FD3A5C",guidelines:void 0,license:void 0},siHoudini={title:"Houdini",slug:"houdini",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Houdini</title><path d="'+this.path+'"/></svg>'},path:"M0 19.635V24h3.824A8.662 8.662 0 0 1 0 19.635zm16.042-4.555c0-4.037-3.253-7.92-8.111-8.089C4.483 6.873 1.801 8.136 0 10.005v4.209c1.224-3.549 4.595-5.158 7.419-5.128 3.531.041 6.251 2.703 6.275 5.72 0 2.878-1.183 4.992-4.436 5.516-1.774.296-4.548-.754-4.436-3.434.065-1.381 1.138-2.162 2.366-2.106-1.207 1.618.39 2.801 1.52 2.561a2.51 2.51 0 0 0 1.966-2.502c0-1.017-.958-2.662-3.333-2.6-2.936.068-4.785 2.183-4.85 4.797-.071 3.28 3.007 5.457 6.174 5.483 4.633.059 7.395-2.984 7.377-7.441zM0 0v6.906a12.855 12.855 0 0 1 7.931-2.609c6.801 0 11.134 4.762 11.131 10.765 0 4.17-1.946 7.308-4.995 8.938H24V0H0z",source:"https://www.sidefx.com/products/houdini/",hex:"FF4713",guidelines:void 0,license:void 0},siHouzz={title:"Houzz",slug:"houzz",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Houzz</title><path d="'+this.path+'"/></svg>'},path:"M1.27 0V24H9.32V16.44H14.68V24H22.73V10.37L6.61 5.75V0H1.27Z",source:"https://www.houzz.com/logoGuidelines",hex:"4DBC15",guidelines:"https://www.houzz.com/logoGuidelines",license:void 0},siXdotorg={title:"X.Org",slug:"xdotorg",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>X.Org</title><path d="'+this.path+'"/></svg>'},path:"M19.94 1.9l-9.092 11.874 4.598 6.392a14.29 14.29 0 0 1-2.56.228c-2.387 0-4.582-.577-6.316-1.542l6.556-8.627-6.031-8.311L2.23 1.91 9.8 12.48l-4.332 5.66c-1.692-1.266-2.729-2.965-2.729-4.832 0-2.13 1.348-4.042 3.48-5.342l-.655-.999C2.22 8.386 0 10.876 0 13.71c0 2.432 1.635 4.61 4.212 6.075l-1.765 2.307h1.661l1.299-1.709c1.892.83 4.158 1.314 6.592 1.314a17.43 17.43 0 0 0 4.188-.501l.65.903h4.865l-1.729-2.422C22.443 18.214 24 16.082 24 13.71c0-2.94-2.39-5.512-5.948-6.9l-.217.311c3.099 1.214 5.195 3.531 5.195 6.188 0 2.202-1.44 4.17-3.698 5.47l-5.153-7.22 7.382-9.658zM12 5.755c-.586 0-1.212.046-1.775.1 1.004 1.309 1.836 2.417 2.795 3.676-.538-1.157-1.644-2.268-1.261-2.839.378-.565 1.075-.47 1.128-.47 1.118 0 2.194.127 3.2.36l.235-.324C14.98 5.91 13.523 5.754 12 5.754z",source:"https://upload.wikimedia.org/wikipedia/commons/9/90/X.Org_Logo.svg",hex:"F28834",guidelines:void 0,license:void 0},siHp={title:"HP",slug:"hp",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>HP</title><path d="'+this.path+'"/></svg>'},path:"M12 24h-.354l2.46-6.745h3.372c.597 0 1.249-.448 1.454-1.007l2.664-7.304c.429-1.192-.242-2.18-1.528-2.18h-4.695l-6.15 16.92C3.933 22.415 0 17.663 0 12 0 6.503 3.708 1.863 8.758.447L2.646 17.255H5.18l3.242-8.926h1.92l-3.243 8.926h2.535l3.037-8.33c.428-1.192-.242-2.18-1.528-2.18H9L11.46.02c.186 0 .354-.019.54-.019 6.634 0 12 5.366 12 12s-5.366 12-12 12zm7.267-15.67h-1.92l-2.682 7.34h1.919z",source:"https://brandcentral.ext.hp.com/login",hex:"0096D6",guidelines:void 0,license:void 0},siXamarin={title:"Xamarin",slug:"xamarin",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Xamarin</title><path d="'+this.path+'"/></svg>'},path:"M6.925 1.323a1.904 1.904 0 00-1.609.93L.241 11.07a1.918 1.918 0 000 1.862l5.075 8.816c.326.56.96.929 1.609.93h10.15a1.904 1.904 0 001.609-.93l5.075-8.816a1.918 1.918 0 000-1.862l-5.075-8.816a1.904 1.904 0 00-1.609-.93zm.092 5.157a.22.22 0 01.043 0h1.75a.23.23 0 01.192.114l2.97 5.292a.228.228 0 01.028.086.228.228 0 01.028-.086l2.963-5.292a.231.231 0 01.198-.114h1.751c.155.002.271.197.199.334L14.239 12l2.9 5.179c.08.138-.04.342-.199.34h-1.75a.232.232 0 01-.2-.12l-2.962-5.292A.228.228 0 0112 12.02a.228.228 0 01-.028.086l-2.97 5.292a.231.231 0 01-.192.12H7.06c-.16.002-.278-.202-.199-.34L9.761 12l-2.9-5.186c-.07-.125.015-.307.156-.334Z",source:"https://github.com/dotnet/swag/tree/master/xamarin",hex:"3498DB",guidelines:void 0,license:void 0},siHtmlacademy={title:"HTML Academy",slug:"htmlacademy",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>HTML Academy</title><path d="'+this.path+'"/></svg>'},path:"M12 0L2.524.994v17.368L12 24l9.476-5.638V.994L12.099.01 12 0zm8.236 17.657L12 22.557l-8.236-4.9v-7.119l8.2 4.881.014.885-5.626-3.349-.008.86 5.648 3.394.015.908-5.647-3.36-.008.86L12 19.01l5.703-3.412v-.862l-.008.004v-2.805l2.54-1.517v7.238zm-.006-8.162l-2.254 1.328-1.04.613-4.96-2.951-.009.858 4.24 2.521-.037.023-.092.054-.602.355-3.5-2.083-.009.859 2.763 1.643-.652.436-.015.01-2.088-1.23-.008.858 1.37.807-1.395.837-8.16-4.85 8.172-4.912v.001l8.276 4.823zm.006-.864l-8.28-4.882h-.002l-8.19 4.877V2.11L12 1.246l8.237.864v6.52z",source:"https://htmlacademy.ru/",hex:"302683",guidelines:void 0,license:void 0},siXaml={title:"XAML",slug:"xaml",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>XAML</title><path d="'+this.path+'"/></svg>'},path:"M6.3912 1.5373a.7847.7847 0 0 0-.679.3914l-5.6065 9.678a.7847.7847 0 0 0 0 .7867l5.6065 9.6779a.7847.7847 0 0 0 .679.3914h11.2176c.28 0 .5387-.1492.679-.3914l5.6065-9.678a.7847.7847 0 0 0 0-.7867l-5.6065-9.6779a.7848.7848 0 0 0-.679-.3914zm.0302.837h10.542l-5.2093 9.2112H5.9679l4.7196-8.1747a.1308.1308 0 0 0-.1132-.1962L7.5062 3.213a.2615.2615 0 0 0-.2266.1307l-4.7633 8.2419h-1.431zm11.3325.3025L23.1549 12l-5.3722 9.2735-5.2987-9.2784zm.1712 2.8248a.1295.1295 0 0 0-.1132.0665l-1.5186 2.689a.2616.2616 0 0 0 .0013.2595l1.943 3.3611a.2615.2615 0 0 1 0 .2617l-1.9268 3.3375a.2616.2616 0 0 0-.0006.2605l1.5272 2.6742c.05.0877.1763.088.2268.0006l3.5503-6.1431a.5231.5231 0 0 0-.0001-.5238L18.039 5.567a.1295.1295 0 0 0-.1139-.0653zM1.09 12.4225h1.4363l4.7634 8.2314a.2616.2616 0 0 0 .2262.1305l3.0718.0018a.1308.1308 0 0 0 .1133-.1962l-4.7215-8.1675h5.7848l5.2557 9.2032H6.4214z",source:"https://github.com/microsoft/microsoft-ui-xaml/issues/1185#issuecomment-529731046",hex:"0C54C2",guidelines:void 0,license:void 0},siHtml5={title:"HTML5",slug:"html5",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>HTML5</title><path d="'+this.path+'"/></svg>'},path:"M1.5 0h21l-1.91 21.563L11.977 24l-8.564-2.438L1.5 0zm7.031 9.75l-.232-2.718 10.059.003.23-2.622L5.412 4.41l.698 8.01h9.126l-.326 3.426-2.91.804-2.955-.81-.188-2.11H6.248l.33 4.171L12 19.351l5.379-1.443.744-8.157H8.531z",source:"http://www.w3.org/html/logo/",hex:"E34F26",guidelines:void 0,license:void 0},siXampp={title:"XAMPP",slug:"xampp",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>XAMPP</title><path d="'+this.path+'"/></svg>'},path:"M16.792,11.923c0.113,0.043,0.226,0.079,0.334,0.128c0.45,0.203,0.715,0.553,0.748,1.044 c0.041,0.634,0.044,1.271,0.002,1.905c-0.049,0.732-0.725,1.292-1.483,1.271c-0.735-0.021-1.369-0.62-1.397-1.341 c-0.017-0.441-0.003-0.884-0.006-1.326c-0.001-0.239-0.003-0.242-0.245-0.243c-1.363-0.001-2.726,0.008-4.089-0.003 c-0.888-0.007-1.421,0.482-1.471,1.46c-0.019,0.38-0.1,0.727-0.357,1.018c-0.397,0.451-0.898,0.601-1.472,0.466 c-0.554-0.131-0.867-0.522-1.035-1.048c-0.117-0.367-0.056-0.737,0.012-1.094c0.341-1.797,1.366-3.006,3.125-3.555 c0.357-0.112,0.731-0.166,1.105-0.166c0.94,0.001,1.881,0.001,2.821-0.001c0.128,0,0.257-0.012,0.385-0.021 c0.702-0.051,1.166-0.511,1.22-1.352c0.004-0.064,0-0.129,0.001-0.193c0.011-0.788,0.605-1.396,1.393-1.425 c0.787-0.029,1.438,0.527,1.493,1.318c0.076,1.083-0.265,2.046-0.913,2.907C16.903,11.751,16.819,11.816,16.792,11.923z M8.249,10.436c-0.258-0.008-0.571,0.018-0.882-0.035c-0.536-0.09-0.876-0.39-1.02-0.916C6.19,8.912,6.25,8.388,6.698,7.96 C7.154,7.526,7.694,7.4,8.285,7.645c0.52,0.216,0.859,0.731,0.89,1.293C9.2,9.382,9.178,9.828,9.182,10.272 c0.001,0.116-0.043,0.167-0.161,0.165C8.781,10.434,8.542,10.436,8.249,10.436z M21.682,0H2.318C1.102,0,0.116,0.986,0.116,2.202 v19.317c0,1.37,1.111,2.481,2.481,2.481h18.807c1.37,0,2.481-1.111,2.481-2.481V2.202C23.884,0.986,22.898,0,21.682,0z M20.125,12.473c0.519,0.804,0.733,1.69,0.677,2.657c-0.108,1.886-1.413,3.474-3.25,3.916c-2.585,0.623-4.566-0.923-5.233-2.794 c-0.109-0.304-0.16-0.622-0.224-0.985c-0.068,0.414-0.115,0.789-0.264,1.134c-0.697,1.617-1.884,2.603-3.665,2.799 c-2.104,0.232-4.048-1.067-4.632-3.084c-0.25-0.863-0.175-1.747-0.068-2.625c0.08-0.653,0.321-1.268,0.632-1.848 c0.057-0.106,0.057-0.184-0.01-0.285c-0.561-0.845-0.779-1.777-0.7-2.784C3.43,8.035,3.56,7.52,3.805,7.038 C4.52,5.626,6.09,4.427,8.193,4.626c1.849,0.175,3.562,1.77,3.83,3.564c0.013,0.09,0.039,0.178,0.068,0.311 c0.044-0.241,0.076-0.439,0.118-0.636c0.344-1.63,1.94-3.335,4.201-3.357c2.292-0.021,3.99,1.776,4.31,3.446 c0.17,0.888,0.089,1.776-0.103,2.663c-0.112,0.517-0.31,1.008-0.524,1.492C20.034,12.245,20.043,12.345,20.125,12.473z",source:"https://www.apachefriends.org/en/",hex:"FB7A24",guidelines:void 0,license:void 0},siHuawei={title:"Huawei",slug:"huawei",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Huawei</title><path d="'+this.path+'"/></svg>'},path:"M3.67 6.14S1.82 7.91 1.72 9.78v.35c.08 1.51 1.22 2.4 1.22 2.4 1.83 1.79 6.26 4.04 7.3 4.55 0 0 .06.03.1-.01l.02-.04v-.04C7.52 10.8 3.67 6.14 3.67 6.14zM9.65 18.6c-.02-.08-.1-.08-.1-.08l-7.38.26c.8 1.43 2.15 2.53 3.56 2.2.96-.25 3.16-1.78 3.88-2.3.06-.05.04-.09.04-.09zm.08-.78C6.49 15.63.21 12.28.21 12.28c-.15.46-.2.9-.21 1.3v.07c0 1.07.4 1.82.4 1.82.8 1.69 2.34 2.2 2.34 2.2.7.3 1.4.31 1.4.31.12.02 4.4 0 5.54 0 .05 0 .08-.05.08-.05v-.06c0-.03-.03-.05-.03-.05zM9.06 3.19a3.42 3.42 0 00-2.57 3.15v.41c.03.6.16 1.05.16 1.05.66 2.9 3.86 7.65 4.55 8.65.05.05.1.03.1.03a.1.1 0 00.06-.1c1.06-10.6-1.11-13.42-1.11-13.42-.32.02-1.19.23-1.19.23zm8.299 2.27s-.49-1.8-2.44-2.28c0 0-.57-.14-1.17-.22 0 0-2.18 2.81-1.12 13.43.01.07.06.08.06.08.07.03.1-.03.1-.03.72-1.03 3.9-5.76 4.55-8.64 0 0 .36-1.4.02-2.34zm-2.92 13.07s-.07 0-.09.05c0 0-.01.07.03.1.7.51 2.85 2 3.88 2.3 0 0 .16.05.43.06h.14c.69-.02 1.9-.37 3-2.26l-7.4-.25zm7.83-8.41c.14-2.06-1.94-3.97-1.94-3.98 0 0-3.85 4.66-6.67 10.8 0 0-.03.08.02.13l.04.01h.06c1.06-.53 5.46-2.77 7.28-4.54 0 0 1.15-.93 1.21-2.42zm1.52 2.14s-6.28 3.37-9.52 5.55c0 0-.05.04-.03.11 0 0 .03.06.07.06 1.16 0 5.56 0 5.67-.02 0 0 .57-.02 1.27-.29 0 0 1.56-.5 2.37-2.27 0 0 .73-1.45.17-3.14z",source:"https://e.huawei.com/ph/material/partner/0a72728b864949c48b22106454352483",hex:"FF0000",guidelines:"https://e.huawei.com/ph/material/partner/0a72728b864949c48b22106454352483",license:void 0},siXbox={title:"Xbox",slug:"xbox",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Xbox</title><path d="'+this.path+'"/></svg>'},path:"M4.102 21.033C6.211 22.881 8.977 24 12 24c3.026 0 5.789-1.119 7.902-2.967 1.877-1.912-4.316-8.709-7.902-11.417-3.582 2.708-9.779 9.505-7.898 11.417zm11.16-14.406c2.5 2.961 7.484 10.313 6.076 12.912C23.002 17.48 24 14.861 24 12.004c0-3.34-1.365-6.362-3.57-8.536 0 0-.027-.022-.082-.042-.063-.022-.152-.045-.281-.045-.592 0-1.985.434-4.805 3.246zM3.654 3.426c-.057.02-.082.041-.086.042C1.365 5.642 0 8.664 0 12.004c0 2.854.998 5.473 2.661 7.533-1.401-2.605 3.579-9.951 6.08-12.91-2.82-2.813-4.216-3.245-4.806-3.245-.131 0-.223.021-.281.046v-.002zM12 3.551S9.055 1.828 6.755 1.746c-.903-.033-1.454.295-1.521.339C7.379.646 9.659 0 11.984 0H12c2.334 0 4.605.646 6.766 2.085-.068-.046-.615-.372-1.52-.339C14.946 1.828 12 3.545 12 3.545v.006z",source:"https://www.xbox.com/en-US/consoles",hex:"107C10",guidelines:void 0,license:void 0},siHubspot={title:"HubSpot",slug:"hubspot",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>HubSpot</title><path d="'+this.path+'"/></svg>'},path:"M18.164 7.93V5.084a2.198 2.198 0 001.267-1.978v-.067A2.2 2.2 0 0017.238.845h-.067a2.2 2.2 0 00-2.193 2.193v.067a2.196 2.196 0 001.252 1.973l.013.006v2.852a6.22 6.22 0 00-2.969 1.31l.012-.01-7.828-6.095A2.497 2.497 0 104.3 4.656l-.012.006 7.697 5.991a6.176 6.176 0 00-1.038 3.446c0 1.343.425 2.588 1.147 3.607l-.013-.02-2.342 2.343a1.968 1.968 0 00-.58-.095h-.002a2.033 2.033 0 102.033 2.033 1.978 1.978 0 00-.1-.595l.005.014 2.317-2.317a6.247 6.247 0 104.782-11.134l-.036-.005zm-.964 9.378a3.206 3.206 0 113.215-3.207v.002a3.206 3.206 0 01-3.207 3.207z",source:"https://www.hubspot.com/style-guide",hex:"FF7A59",guidelines:"https://www.hubspot.com/style-guide",license:void 0},siXcode={title:"Xcode",slug:"xcode",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Xcode</title><path d="'+this.path+'"/></svg>'},path:"M19.06 5.3327c.4517-.1936.7744-.2581 1.097-.1936.5163.1291.7744.5163.968.7098.1936.3872.9034.7744 1.2261.8389.2581.0645.7098-.6453 1.0325-1.2906.3227-.5808.5163-1.3552.4517-1.5488-.0645-.1936-.968-.5808-1.1616-.5808-.1291 0-.3872.1291-.8389.0645-.4517-.0645-.9034-.5808-1.1616-.968-.4517-.6453-1.097-1.0325-1.6778-1.3552-.6453-.3227-1.3552-.5163-2.065-.6453-1.0325-.2581-2.065-.4517-3.0975-.3227-.5808.0645-1.2906.1291-1.8069.3227-.0645 0-.1936.1936-.0645.1936s.5808.0645.5808.0645-.5807.1292-.5807.2583c0 .1291.0645.1291.1291.1291.0645 0 1.4842-.0645 2.065 0 .6453.1291 1.3552.4517 1.8069 1.2261.7744 1.4197.4517 2.7749.2581 3.2266-.968 2.1295-8.6472 15.2294-9.0344 16.1328-.3873.9034-.5163 1.4842.5807 2.065s1.6778.3227 2.0005-.0645c.3872-.5163 7.0339-17.1654 9.2925-18.2624zm-3.6138 8.7117h1.5488c1.0325 0 1.2261.5163 1.2261.7098.0645.5163-.1936 1.1616-1.2261 1.1616h-.968l.7744 1.2906c.4517.7744.2581 1.1616 0 1.4197-.3872.3872-1.2261.3872-1.6778-.4517l-.9034-1.5488c-.6453 1.4197-1.2906 2.9684-2.065 4.7753h4.0009c1.9359 0 3.5492-1.6133 3.5492-3.5492V6.5588c-.0645-.1291-.1936-.0645-.2581 0-.3872.4517-1.4842 2.0004-4.001 7.4856zm-9.8087 8.0019h-.3227c-2.3231 0-4.1945-1.8714-4.1945-4.1945V7.0105c0-2.3231 1.8714-4.1945 4.1945-4.1945h9.3571c-.1936-.1936-.968-.5163-1.7423-.4517-.3227 0-.968.1291-1.3552-.1291-.3872-.3227-.3227-.5163-.9034-.5163H4.9277c-2.6458 0-4.7753 2.1295-4.7753 4.7753v11.7447c0 2.6458 2.1295 4.7753 4.4527 4.7108.6452 0 .8388-.5162 1.0324-.9034zM20.4152 6.9459v10.9058c0 2.3231-1.8714 4.1945-4.1945 4.1945H11.897s-.3872 1.0325.8389 1.0325h3.8719c2.6458 0 4.7753-2.1295 4.7753-4.7753V8.8173c.0646-.9034-.7098-1.4842-.9679-1.8714zm-18.5851.0646v10.8413c0 1.9359 1.6133 3.5492 3.5492 3.5492h.5808c0-.0645.7744-1.4197 2.4522-4.2591.1936-.3872.4517-.7744.7098-1.2261H4.4114c-.5808 0-.9034-.3872-.968-.7098-.1291-.5163.1936-1.1616.9034-1.1616h2.3877l3.033-5.2916s-.7098-1.2906-.9034-1.6133c-.2582-.4517-.1291-.9034.129-1.1615.3872-.3872 1.0325-.5808 1.6778.4517l.2581.3872.2581-.3872c.5808-.8389.968-.7744 1.2906-.7098.5163.1291.8389.7098.3872 1.6133L8.864 14.0444h1.3552c.4517-.7744.9034-1.5488 1.3552-2.3877-.0645-.3227-.1291-.7098-.0645-1.0325.0645-.5163.3227-.968.6453-1.3552l.3872.6453c1.2261-2.1295 2.1295-3.9364 2.3877-4.6463.1291-.3872.3227-1.1616.1291-1.8069H5.3794c-2.0005.0001-3.5493 1.6134-3.5493 3.5494zM4.605 17.7872c0-.0645.7744-1.4197.7744-1.4197 1.2261-.3227 1.8069.4517 1.8714.5163 0 0-.8389 1.4842-1.097 1.7423s-.5808.3227-.9034.2581c-.5164-.129-.839-.6453-.6454-1.097z",source:"https://developer.apple.com/develop/",hex:"147EFB",guidelines:void 0,license:void 0},siHungryjacks={title:"Hungry Jack's",slug:"hungryjacks",get svg(){return`<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Hungry Jack's</title><path d="`+this.path+'"/></svg>'},path:"M2.868.215C1.284.215 0 1.476 0 3.032v17.936c0 1.555 1.284 2.817 2.868 2.817h18.264c1.584 0 2.868-1.262 2.868-2.817V3.032C24 1.476 22.716.215 21.132.215zm9.033 1.82c6.143 0 9.46 2.233 9.743 4.487.043.333.016 1.012.016 1.012v10.585s-.03.612-.325 1.112c-1.067 1.808-4.108 2.674-9.434 2.674s-8.367-.866-9.434-2.674c-.295-.5-.324-1.112-.324-1.112s0-10.679-.003-10.813v-.532c.003-.093.009-.18.018-.252.283-2.254 3.6-4.488 9.743-4.488zm-.13.537c-5.685 0-8.714 1.97-9.08 3.953-.086.455.197.611.48.611H20.37c.283 0 .566-.156.48-.611-.366-1.983-3.395-3.953-9.08-3.953zM6.692 8.21c-.19 0-.47.098-.47.325v1.917c0 .525.658.895 1.232.895s1.233-.37 1.233-.895V8.536c0-.227-.28-.325-.47-.325-.192 0-.471.098-.471.325v1.73c0 .127-.154.2-.292.2-.138 0-.29-.073-.29-.2v-1.73c0-.227-.28-.325-.471-.325zm2.75 0c-.195 0-.482.134-.482.38v2.531c0 .246.287.362.483.362s.481-.147.481-.362v-.943c0-.069.09-.055.132 0 0 0 .611.786.814 1.044.203.257.316.26.484.26.196 0 .482-.116.482-.36V8.59c0-.245-.286-.38-.482-.38s-.483.135-.483.38v.935c0 .07-.087.058-.148-.02l-.766-.996c-.117-.156-.265-.298-.514-.298zm4.325 0c-.978 0-1.658.666-1.658 1.628 0 1.133.725 1.645 1.649 1.645.715 0 1.364-.278 1.364-.789v-.89c0-.234-.152-.329-.396-.329h-.69c-.346 0-.422.228-.422.405 0 .177.06.419.413.419.097 0 .126.007.126.07.012.167-.1.266-.42.266-.392 0-.615-.354-.615-.784 0-.43.18-.815.699-.815.185 0 .275.003.58.141.307.138.475-.022.55-.126.077-.104.158-.332-.036-.504-.264-.23-.644-.337-1.144-.337zm-10.08.136c-.194 0-.477.11-.477.346v2.445c0 .234.283.346.476.346.194 0 .476-.112.476-.346v-.713c0-.076.054-.097.114-.097h.474c.06 0 .11.021.11.097v.713c0 .234.282.346.475.346.194 0 .476-.112.476-.346V8.693c0-.235-.282-.346-.476-.346-.193 0-.476.11-.476.346v.653c0 .073-.041.1-.105.1h-.486c-.056 0-.106-.027-.106-.1v-.653c0-.235-.282-.346-.476-.346zm12.185 0c-.23 0-.477.12-.477.345v2.465c0 .225.283.322.477.322.193 0 .475-.097.475-.322v-.638c0-.06.055-.079.093-.033l.677.862c.138.177.486.163.648.062.18-.111.313-.358.174-.534l-.53-.678c-.022-.03-.027-.056.018-.09.333-.222.417-.55.417-.836 0-.319-.274-.925-1.074-.925zm4.293 0c-.174-.008-.384.052-.463.2l-.36.566c-.029.05-.062.049-.09.004l-.358-.57c-.105-.197-.441-.233-.619-.168-.232.084-.343.337-.239.535l.706 1.154c.053.092.077.144.076.236v.834c0 .235.285.346.48.346s.48-.111.48-.346v-.834c0-.092.006-.133.074-.233l.707-1.157c.105-.198-.012-.445-.239-.535a.49.49 0 0 0-.155-.031zm-3.636.545c.305 0 .372.133.372.344 0 .21-.161.338-.354.338-.124 0-.193.003-.193-.056V8.96c.035-.046.063-.068.175-.068zM5.163 12.166c-.264 0-.649.164-.649.51v2.599c.028.413-.244.52-.349.214-.15-.367-.526-.287-.67-.214-.144.072-.351.26-.264.615.153.543.543.907 1.291.913 1 0 1.284-.625 1.284-1.297l.005-.07v-2.76c0-.346-.384-.51-.648-.51zm2.634 0c-.246.008-.654.115-.75.458L5.97 16.122c-.108.336.188.629.447.675.232.042.633-.132.702-.435l.062-.206c.017-.065.046-.08.1-.08h1.034c.074 0 .08.03.095.08l.062.206c.07.303.47.477.702.435.259-.046.556-.339.447-.675l-1.075-3.498c-.1-.349-.504-.45-.75-.458zm3.833 0c-1.252 0-2.122.949-2.122 2.318 0 1.37.87 2.32 2.122 2.32.542 0 .898-.152 1.148-.41.248-.244.143-.544.046-.692-.097-.149-.308-.366-.704-.18-.225.104-.248.128-.427.128-.663 0-.895-.548-.895-1.16h-.001c0-.613.233-1.175.896-1.175.187 0 .225.034.427.128.396.186.607-.031.704-.18.097-.148.202-.444-.046-.688-.279-.287-.618-.41-1.148-.41zm2.347 0c-.258 0-.635.164-.635.512v3.613c0 .348.377.512.635.512s.635-.164.635-.512V15.3l-.001.014c0-.213.12-.096.12-.096l1.173 1.428s.28.375.774-.06c.494-.437.014-.897.014-.897s-.721-.849-.883-1.064c-.145-.194.04-.387.04-.387l.908-1.115c.22-.275.167-.545-.087-.763-.286-.246-.639-.238-.875.067l-1.057 1.277c-.05.068-.12.062-.126-.047v.003l-.001-.013.001.01v-.978c0-.348-.377-.512-.635-.512zm3.254 0c-.182 0-.33.138-.33.31.007.21.132.273.173.288.041.016.03.047.026.066a.342.342 0 0 1-.116.17c-.14.086-.002.266.113.257.128-.01.644-.452.443-.892a.34.34 0 0 0-.31-.2zm1.979 0c-.996 0-1.608.678-1.61 1.684-.001.61.525 1.019 1.052 1.126l.27.055c.123.029.29.097.29.289 0 .191-.103.372-.334.372-.155 0-.197.04-.526-.13-.37-.19-.573.032-.665.175-.092.145-.19.433.045.67.3.282.66.396 1.266.396 1.102 0 1.609-.668 1.6-1.594-.006-.72-.502-1.133-1.073-1.28l-.305-.079c-.104-.028-.276-.105-.276-.263 0-.174.103-.317.301-.317.126 0 .178-.02.449.128.366.199.574-.031.666-.175.091-.143.19-.424-.045-.66-.308-.31-.565-.397-1.105-.397zM7.725 14.212c.027-.002.054.022.068.075l.202.668c.02.062-.001.075-.071.075H7.51c-.038 0-.07-.026-.05-.075l.202-.666c.01-.048.036-.076.062-.077zm-4.554 3.665c-.283 0-.566.11-.48.473.516 1.98 3.395 3.018 9.08 3.018 5.684 0 8.563-1.037 9.08-3.018.085-.363-.198-.473-.48-.473h-8.6zm17.161 2.685c.288 0 .534.228.534.536a.531.531 0 0 1-.534.538.532.532 0 0 1-.536-.538c0-.308.246-.536.536-.536zm0 .09a.431.431 0 0 0-.43.446c0 .259.189.45.43.45.239 0 .428-.191.428-.45a.43.43 0 0 0-.428-.446zm-.21.128h.232c.144 0 .216.055.216.177 0 .11-.07.159-.159.17l.174.273h-.104l-.16-.269h-.107v.269h-.092zm.092.08v.192h.11c.079 0 .149-.006.149-.101 0-.077-.069-.09-.133-.09Z",source:"https://www.hungryjacks.com.au/",hex:"D0021B",guidelines:void 0,license:void 0},siXdadevelopers={title:"XDA Developers",slug:"xdadevelopers",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>XDA Developers</title><path d="'+this.path+'"/></svg>'},path:"M13.84 3.052V0h7.843v17.583H13.84v-3.024h4.591V3.052zM5.569 14.53V3.024h4.592V0H2.318v17.583H6.98L10.16 24v-9.483z",source:"https://www.xda-developers.com/",hex:"EA7100",guidelines:void 0,license:void 0},siHurriyetemlak={title:"Hurriyetemlak",slug:"hurriyetemlak",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Hurriyetemlak</title><path d="'+this.path+'"/></svg>'},path:"M24 16.085L11.994 4.091 0 16.097l3.817 3.812 8.182-8.189 8.189 8.182z",source:"https://ilan.hurriyetemlak.com/emlak-ilani-yayinlama-kurallari",hex:"E02826",guidelines:void 0,license:void 0},siXero={title:"Xero",slug:"xero",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Xero</title><path d="'+this.path+'"/></svg>'},path:"M12 0C5.373 0 0 5.373 0 12s5.373 12 12 12 12-5.373 12-12S18.627 0 12 0zm6.585 14.655c-1.485 0-2.69-1.206-2.69-2.689 0-1.485 1.207-2.691 2.69-2.691 1.485 0 2.69 1.207 2.69 2.691s-1.207 2.689-2.69 2.689zM7.53 14.644c-.099 0-.192-.041-.267-.116l-2.043-2.04-2.052 2.047c-.069.068-.16.108-.258.108-.202 0-.368-.166-.368-.368 0-.099.04-.191.111-.263l2.04-2.05-2.038-2.047c-.075-.069-.113-.162-.113-.261 0-.203.166-.366.368-.366.098 0 .188.037.258.105l2.055 2.048 2.048-2.045c.069-.071.162-.108.26-.108.211 0 .375.165.375.366 0 .098-.029.188-.104.258l-2.056 2.055 2.055 2.051c.068.069.104.16.104.258 0 .202-.165.368-.365.368h-.01zm8.017-4.591c-.796.101-.882.476-.882 1.404v2.787c0 .202-.165.366-.366.366-.203 0-.367-.165-.368-.366v-4.53c0-.204.16-.366.362-.366.166 0 .316.125.346.289.27-.209.6-.317.93-.317h.105c.195 0 .359.165.359.368 0 .201-.164.352-.375.359 0 0-.09 0-.164.008l.053-.002zm-3.091 2.205H8.625c0 .019.003.037.006.057.02.105.045.211.083.31.194.531.765 1.275 1.829 1.29.33-.003.631-.086.9-.229.21-.12.391-.271.525-.428.045-.058.09-.112.12-.168.18-.229.405-.186.54-.083.164.135.18.391.045.57l-.016.016c-.21.27-.435.495-.689.66-.255.164-.525.284-.811.345-.33.09-.645.104-.975.06-1.095-.135-2.01-.93-2.28-2.01-.06-.21-.09-.42-.09-.645 0-.855.421-1.695 1.125-2.205.885-.615 2.085-.66 3-.075.63.405 1.035 1.021 1.185 1.771.075.419-.21.794-.734.81l.068-.046zm6.129-2.223c-1.064 0-1.931.865-1.931 1.931 0 1.064.866 1.931 1.931 1.931s1.931-.867 1.931-1.931c0-1.065-.866-1.933-1.931-1.933v.002zm0 2.595c-.367 0-.666-.297-.666-.666 0-.367.3-.665.666-.665.367 0 .667.299.667.665 0 .369-.3.667-.667.666zm-8.04-2.603c-.91 0-1.672.623-1.886 1.466v.03h3.776c-.203-.855-.973-1.494-1.891-1.494v-.002z",source:"https://www.xero.com/uk/about/media/downloads",hex:"13B5EA",guidelines:void 0,license:void 0},siHusqvarna={title:"Husqvarna",slug:"husqvarna",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Husqvarna</title><path d="'+this.path+'"/></svg>'},path:"M12.001 14.457c2.04 0 1.997 0 1.997.645v4.054h2.775V7.927h-2.775v3.371c0 .664.042.662-1.997.662h.001c-2.04 0-1.996.002-1.996-.662v-3.37H7.23v11.228h2.775v-4.054c0-.644-.043-.645 1.996-.645M12 0c1.04 0 1.72.18 2.004.241-.143 1.307-.1 2.355 0 2.657.347 1.006 2.32 1.475 3.115 1.012.878-.523.676-2.109.676-3.155 0 0 1.294.301 2.086.594.644.238 1.593.703 1.593.703.188 1.323.01 3.281-1.316 3.945 1 .985 1.335 2.152 1.764 4.304.346 1.932.265 3.28.243 4.405-.101 1.53-.101 2.354-.468 3.743-.53 1.588-.844 2.335-1.918 3.438C17.599 24.131 14.045 24 12 23.998c-2.045.001-5.598.133-7.779-2.11-1.074-1.104-1.388-1.85-1.918-3.439-.367-1.389-.367-2.213-.469-3.743-.02-1.126-.102-2.473.245-4.405.428-2.152.763-3.319 1.763-4.304-1.326-.664-1.504-2.622-1.316-3.945 0 0 .95-.465 1.593-.703.792-.293 2.085-.594 2.085-.594 0 1.046-.201 2.632.676 3.155.797.463 2.768-.006 3.116-1.012.102-.302.142-1.35 0-2.657C10.28.181 10.959 0 12 0m-.004 21.125c2.387 0 3.149 0 4.331-.322.408-.14 1.143-.341 1.674-1.166.979-1.65.979-4.747.979-6.236 0-1.49 0-4.125-.979-5.754-.53-.846-1.255-1.078-1.674-1.188-1.208-.316-1.983-.297-4.331-.302h.002c-2.348.005-3.123-.014-4.331.302-.418.11-1.143.342-1.674 1.188-.979 1.63-.979 4.264-.979 5.754 0 1.489 0 4.586.98 6.236.53.825 1.264 1.025 1.673 1.166 1.182.323 1.944.322 4.33.322Z",source:"https://www.husqvarna.com/uk/catalogues/",hex:"273A60",guidelines:void 0,license:void 0},siHyper={title:"Hyper",slug:"hyper",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Hyper</title><path d="'+this.path+'"/></svg>'},path:"M13.565 17.91H24v1.964H13.565zm-3.201-5.09l-9.187 8.003 2.86-7.004L0 11.179l9.187-8.002-3.11 7.451z",source:"https://hyper.is/",hex:"000000",guidelines:void 0,license:void 0},siHyperledger={title:"Hyperledger",slug:"hyperledger",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Hyperledger</title><path d="'+this.path+'"/></svg>'},path:"M16.593 1.008L5.725 2.067a.671.671 0 0 0-.688-.585.72.72 0 0 0-.71.71c0 .256.14.455.326.58L.106 12.636l-.047.044c-.06.06-.059.06-.059.12 0 0 0 .058.059.058l6.338 8.974a.716.716 0 0 0-.175.449c0 .415.355.71.71.71a.68.68 0 0 0 .705-.666l10.66-1.04.132.048a.226.226 0 0 0 .052-.065c.037-.004.068-.014.068-.054l4.55-9.876c.062.018.125.039.19.039.356 0 .711-.355.711-.71a.72.72 0 0 0-.71-.713.693.693 0 0 0-.263.054L16.71 1.067c-.06-.06-.06-.06-.118-.06zm-.522.28l-4.952 2.711-5.434-1.598a.962.962 0 0 0 .045-.15zm.404.016l1.36 5.907-3.115-1.933a.944.944 0 0 0 .154-.36.72.72 0 0 0-.71-.71.71.71 0 0 0-.667.49l-2.07-.608zm.272.244l6.062 8.607c-.03.028-.052.06-.076.093l-4.676-2.9zm-11.094.944l5.339 1.577-3.644 1.995-1.876-3.339a.802.802 0 0 0 .18-.233zm-.38.363L7.118 6.14l.012.059-2.093 1.917V2.903a.625.625 0 0 0 .236-.048zm-.43.01c.044.014.09.023.135.027v5.28L.561 12.22zm6.456 1.295l2.176.643c-.008.039-.024.076-.024.115 0 .166.067.304.158.42l-2.53 2.188-3.564-1.278zm2.339 1.22a.72.72 0 0 0 .525.25c.022 0 .043-.005.065-.008l.625 3.257-3.723-1.334zm.999.018l3.245 2.017.64 2.779-3.598-1.29-.62-3.295a.71.71 0 0 0 .333-.211zM7.407 6.4l3.527 1.251-2.803 2.424zm-.22.088l.748 3.756-2.38 2.056a.705.705 0 0 0-.518-.211V8.457zm10.916 1.065l4.545 2.826c-.015.033-.022.066-.032.1l-3.917-.285zm-7.118.117l3.902 1.384.707 3.69-3.077 2.64-3.584-1.238-.793-4.023zm-6.007.84v3.585a.72.72 0 0 0-.652.705.72.72 0 0 0 .711.711c.03 0 .056-.013.085-.017l.407 2.147-5.174-2.9zm9.98.568l3.471 1.233-2.79 2.394zm-7.014 1.214l.752 3.772-3.015-1.041a.955.955 0 0 0 .067-.223.708.708 0 0 0-.17-.466zm10.78.14l3.858.283a.67.67 0 0 0 .117.321l-4.068 3.644zm-.181.138l-.095 4.273-1.566 1.403a.72.72 0 0 0-.468-.186c-.05 0-.093.017-.14.025l-.576-3.068zm4.273.618c.026.024.059.037.088.057l-4.407 9.576.13-5.94zm-7.162 1.866l.582 3.038a.654.654 0 0 0-.483.412l-2.932-1.014zm-10.008.055l3.07 1.062.73 3.664-3.838-2.15-.427-2.204a.713.713 0 0 0 .465-.372zm-5.123.012l5.07 2.85 1.075 5.653c-.03.013-.054.034-.081.05zm8.43 1.132l3.482 1.202-2.775 2.382zm9.491.788l-.133 5.997-5.669-2.02 3.198-1.855a.72.72 0 0 0 .574.32.722.722 0 0 0 .712-.713.676.676 0 0 0-.162-.426zm-5.704.519l2.996 1.035c-.013.058-.032.112-.032.175 0 .11.028.21.071.301L12.5 18.967l-2.633-.937zm-7.069.456l3.786 2.13-2.213 3.493a.687.687 0 0 0-.492-.043zm3.984 2.217l2.553.903-4.706 2.723c-.025-.035-.047-.073-.08-.103zm2.697.954l5.533 1.955-10.274.957c-.011-.047-.022-.094-.042-.137Z",source:"https://www.hyperledger.org/",hex:"2F3134",guidelines:void 0,license:void 0},siXfce={title:"XFCE",slug:"xfce",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>XFCE</title><path d="'+this.path+'"/></svg>'},path:"M.121 5.7271a.104.104 0 0 0-.0344.0017v-.0003l-.0154.0024-.0138.0076a.1156.1156 0 0 0-.0486.053.1147.1147 0 0 0-.0065.067c.0073.0362.0229.0552.0392.0754.0326.0403.0783.0798.1424.1286.1282.0976.3274.2256.5973.379.5396.3065 1.3597.7126 2.4276 1.1523 1.0533.4336 2.3185 1.2056 3.2863 1.9117.4838.353.8938.6902 1.165.9572.1356.1336.2365.2504.2924.337.028.0433.0443.0791.0498.1003.0027.0106.0029.0158.003.0176-.6994.9875-1.1131 2.187-.8297 4.1959l.0003.0003v.0002c.0055.0378-.0317.1266-.1203.2349-.0886.1082-.2168.2333-.3462.3656-.1294.1324-.2604.2723-.3573.4192-.0968.1469-.1629.3058-.138.4716v.0005l.0002.0005c.0122.074.062.1403.1251.1684.0632.0281.1297.0276.1987.0184.1379-.0185.295-.0788.4534-.1449.1584-.066.3168-.1387.4379-.1832a.7913.7913 0 0 1 .1308-.0376c-.0002.021.0023.0308-.0032.0646-.0102.0611-.0291.1386-.0536.2251-.0488.173-.1194.3824-.1843.5878-.0648.2054-.1239.4059-.15.57-.013.082-.0188.155-.008.2219.0107.0669.0489.1414.1224.1683l.0027.0011.0027.0009c.0509.015.0835.0012.1164-.0117a.6625.6625 0 0 0 .1038-.054c.0748-.046.1643-.1118.2657-.1916.2027-.1596.4515-.3752.697-.5916.2455-.2164.4874-.4336.6734-.5937.093-.08.1723-.146.2292-.1892a.8072.8072 0 0 1 .0624-.044c1.4976.4462 3.2026.5014 4.5489.4407a20.9787 20.9787 0 0 0 1.6869-.144c.2111-.027.3812-.0525.5013-.0722.06-.0099.1076-.0183.1419-.0249a1.1699 1.1699 0 0 0 .033-.0068l.0002.0003c.0194.0085.049.022.087.0392l.3181.1443c.265.12.6217.28.9867.4357.365.1556.7378.3069 1.0378.4102.15.0517.2812.0913.3875.1138.0531.0112.1.0184.1427.0197.0426.0012.0828.001.1273-.0281l.0095-.0062.0078-.0084c.1755-.19.183-.4255.0992-.6327-.0839-.2072-.2455-.4023-.4127-.5864-.1672-.1841-.3415-.3571-.45-.4989-.0542-.0709-.0909-.1342-.1043-.1783-.0118-.039-.0065-.053.0057-.0711a.2403.2403 0 0 1 .0505 0c.0583.0053.1458.0236.2484.0508.2052.0544.4736.1441.7421.2324.2685.0883.5367.1751.7497.2251.1065.025.1982.0413.2764.0422.0392.0004.0754-.0023.112-.0152.0365-.0128.0778-.0424.0956-.0875l.0008-.0022.0008-.0024c.0502-.1516-.0056-.3138-.0951-.4762-.0895-.1624-.2203-.3305-.3594-.4927-.1393-.1621-.287-.3178-.4093-.449-.1217-.1307-.2194-.2425-.2494-.2922-.062-.1099-.1004-.2568-.083-.3986.0174-.142.0849-.2801.2475-.3935.032-.0223.1324-.0749.2681-.14.1358-.0651.311-.1464.5108-.24.3995-.1873.8972-.425 1.3802-.6902.4829-.2653.9507-.5574 1.2937-.8589.3427-.3013.5755-.6187.5291-.948-.0722-.5354-.425-.9433-.8964-1.2494-.4714-.3061-1.0654-.5177-1.6504-.6716-.585-.1538-1.1615-.2492-1.5953-.3167-.217-.0337-.3984-.0603-.5251-.0835a1.5818 1.5818 0 0 1-.144-.0316h-.0003a4.2196 4.2196 0 0 1-.0003-.0878c.0006-.0827.0018-.1971 0-.3308-.0035-.2674-.0186-.612-.0746-.9416-.056-.3297-.1499-.6458-.3319-.8597-.1817-.2136-.4698-.3041-.8207-.1656-.2319.0867-.3625.2882-.4175.5189-.0551.231-.0452.4976-.0095.7594.0357.2618.0984.5187.155.7248.0568.206.1093.3695.1187.4113v.0003c.006.026.0051.0173-.0049.0254-.01.008-.0423.021-.0832.0246a.4074.4074 0 0 1-.126-.0098c-.0373-.0092-.0626-.0292-.0575-.023-.0078-.0095-.0375-.0606-.0695-.1286-.0319-.068-.0701-.1557-.1137-.2548-.087-.1982-.195-.4413-.3197-.67-.1247-.2286-.2647-.4431-.4283-.587-.0818-.0719-.171-.1269-.2695-.151a.4444.4444 0 0 0-.3064.0362l-.0016.0008-.0016.0014c-.2555.1408-.3929.3651-.449.607-.056.2417-.0374.502.0033.7437.0407.2416.1046.4659.1454.6286.0204.0813.0347.1484.0381.1867.0011.0127.0005.0142.0003.0181-.1823.114-.275.2937-.346.4789-.0744.194-.1365.397-.2634.5732l-.0006.0005-.0003.0006c-.0384.055-.1194.1045-.2464.1375-.127.033-.2952.049-.4908.0495-.3912.0008-.891-.059-1.412-.1419-1.042-.1656-2.1617-.4221-2.7331-.4567-.4299-.0254-.8375.1359-1.1459.2875-.1542.0759-.2843.15-.3764.1979a.8919.8919 0 0 1-.0957.0443c-.9968-.9934-3.013-2.6882-5.2499-3.2603-.6133-.1664-1.3873-.4945-2.015-.7794-.3138-.1425-.5914-.2741-.7958-.3697a11.373 11.373 0 0 0-.2481-.1138 1.4159 1.4159 0 0 0-.0776-.0316.3291.3291 0 0 0-.0305-.01C.132 5.7309.128 5.7286.121 5.7274zm22.6994 1.8353a.0621.0621 0 0 0-.0182.0046c-.0199.0086-.0256.0186-.0313.0268a.2303.2303 0 0 0-.026.0537c-.0158.0423-.033.1017-.0516.1754-.0371.1474-.0786.3496-.1137.5565-.0352.2068-.0639.4179-.0744.5845-.0052.0834-.0062.1552-.0002.2125a.3184.3184 0 0 0 .016.0764.106.106 0 0 0 .0475.0587.0745.0745 0 0 0 .0435.013.0789.0789 0 0 0 .043-.0176c.0206-.0163.031-.0348.0418-.0565.0218-.0434.0407-.1023.0598-.1757.0382-.1468.0746-.3488.1035-.5567.0289-.2078.0501-.421.0567-.5897.0033-.0843.0031-.157-.0022-.2145a.4137.4137 0 0 0-.0127-.0757.1082.1082 0 0 0-.036-.0587c-.0063-.006-.013-.0127-.0242-.0156a.061.061 0 0 0-.0214-.0014zm1.111.2114a.104.104 0 0 0-.0428.0075c-.0233.0095-.0431.024-.0645.0422-.0429.0365-.0908.0899-.1444.157-.107.1342-.2336.3218-.35.5178-.1162.196-.222.3999-.2864.5686-.0322.0844-.0545.1597-.0616.2246-.0071.0647-.0006.1294.051.1678.0286.0211.0674.015.0898.0035.0225-.0115.0403-.0275.0597-.0475.0388-.04.0812-.0975.1284-.1687.0944-.1424.2056-.3388.311-.5402a9.6877 9.6877 0 0 0 .2754-.5673 2.732 2.732 0 0 0 .0806-.2002.522.522 0 0 0 .0191-.0673A.1276.1276 0 0 0 24 7.8419c-.0002-.0112.0007-.0282-.0191-.0479l-.002-.0019-.0015-.0016a.0757.0757 0 0 0-.046-.0167zM19.5691 9.629c.1818 0 .3346.1698.3346.3876 0 .2177-.1528.3872-.3346.3872-.1817 0-.3345-.1695-.3345-.3872 0-.2178.1528-.3876.3345-.3876zm-.8823.3395c.0791.2909.1785.5128.35.6475.1629.128.3965.1727.6894.1813-.1803.129-.3447.1912-.4803.1751-.168-.0198-.3091-.1247-.414-.2686s-.1708-.3257-.1867-.483c-.011-.1075.0095-.1888.0416-.2523zm2.0906 1.7806c.0534-.0043.083.0061.0911.0138l.0084.0081.011.0041c.0068.0024.0032.0004.0055.002-.0108.016-.0496.0531-.1124.0929-.1312.083-.3492.1845-.5792.2778-.23.0933-.473.1791-.6578.2349-.059.0178-.098.0261-.1424.037.029-.0212.0513-.0392.0894-.0646a6.3595 6.3595 0 0 1 .5192-.306c.1948-.103.3971-.1968.5602-.2513.0816-.0272.1536-.0443.207-.0486zm.2406.4714a.0686.0686 0 0 1 .0248.0022c.0265.0305.0393.0587.0349.0964-.005.0422-.0289.0957-.0708.1538-.084.1161-.2354.2477-.3984.3667-.163.1191-.3378.2268-.4702.3027-.0483.0277-.0822.0454-.1165.0635.0153-.0296.029-.0579.0562-.0983.0782-.1163.1994-.266.3319-.409.1325-.1428.2771-.2796.4005-.3702.0617-.0453.1184-.0788.1624-.0962a.1569.1569 0 0 1 .0451-.0116z",source:"https://www.xfce.org/download#artwork",hex:"2284F2",guidelines:void 0,license:void 0},siHyundai={title:"Hyundai",slug:"hyundai",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Hyundai</title><path d="'+this.path+'"/></svg>'},path:"M11.999 18.145c6.627 0 12.001-2.751 12.001-6.144 0-3.395-5.374-6.146-12.001-6.146C5.374 5.855 0 8.606 0 12.001c0 3.393 5.374 6.144 11.999 6.144m2.26-3.015c-.2.464-.545 1.454-1.336 1.85-.24.119-.537.174-.8.185H12c-2.214 0-4.276-.31-6.002-.834l-.066-.025c-.16-.053-.24-.127-.24-.218 0-.079.043-.14.099-.195l.109-.097c.4-.332 1.598-1.2 3.858-2.067.793-.301 1.786-.679 2.825-.9.608-.126 2.868-.473 1.675 2.301m6.062-6.194c.043-.074.1-.137.203-.142.056-.006.132.007.248.08 1.409.867 2.245 1.952 2.245 3.125 0 2.118-2.724 3.94-6.62 4.735-.248.05-.416.048-.471-.015-.04-.038-.05-.106 0-.19a.815.815 0 01.104-.145c2.12-2.5 3.736-6.189 4.195-7.253.035-.074.068-.147.096-.195M9.777 8.857c.2-.463.545-1.454 1.335-1.846.24-.12.537-.178.8-.185.061-.002.104 0 .12 0 2.217 0 4.276.306 6.004.833.013.006.053.02.066.025.16.054.24.127.24.218 0 .079-.042.137-.098.193a1.89 1.89 0 01-.11.096c-.397.335-1.598 1.201-3.858 2.068-.795.304-1.786.679-2.822.899-.61.13-2.87.474-1.677-2.3M7.6 7.264c.25-.048.415-.048.476.015.035.04.045.106-.002.19a.89.89 0 01-.104.142c-2.12 2.503-3.737 6.189-4.198 7.256a2.313 2.313 0 01-.096.195c-.04.073-.099.136-.2.142-.056.005-.135-.011-.251-.081C1.817 14.256.98 13.172.98 11.999c0-2.118 2.724-3.94 6.62-4.735Z",source:"https://en.wikipedia.org/wiki/File:Hyundai_Motor_Company_logo.svg",hex:"002C5F",guidelines:"https://www.hyundai.pl/fileadmin/user_upload/media/logo/201607_HYU_Guideline_ENG_small.pdf",license:void 0},siXiaomi={title:"Xiaomi",slug:"xiaomi",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Xiaomi</title><path d="'+this.path+'"/></svg>'},path:"M12 0C8.016 0 4.756.255 2.493 2.516.23 4.776 0 8.033 0 12.012c0 3.98.23 7.235 2.494 9.497C4.757 23.77 8.017 24 12 24c3.983 0 7.243-.23 9.506-2.491C23.77 19.247 24 15.99 24 12.012c0-3.984-.233-7.243-2.502-9.504C19.234.252 15.978 0 12 0zM4.906 7.405h5.624c1.47 0 3.007.068 3.764.827.746.746.827 2.233.83 3.676v4.54a.15.15 0 0 1-.152.147h-1.947a.15.15 0 0 1-.152-.148V11.83c-.002-.806-.048-1.634-.464-2.051-.358-.36-1.026-.441-1.72-.458H7.158a.15.15 0 0 0-.151.147v6.98a.15.15 0 0 1-.152.148H4.906a.15.15 0 0 1-.15-.148V7.554a.15.15 0 0 1 .15-.149zm12.131 0h1.949a.15.15 0 0 1 .15.15v8.892a.15.15 0 0 1-.15.148h-1.949a.15.15 0 0 1-.151-.148V7.554a.15.15 0 0 1 .151-.149zM8.92 10.948h2.046c.083 0 .15.066.15.147v5.352a.15.15 0 0 1-.15.148H8.92a.15.15 0 0 1-.152-.148v-5.352a.15.15 0 0 1 .152-.147Z",source:"https://www.mi.com/global",hex:"FF6900",guidelines:void 0,license:void 0},siI18next={title:"i18next",slug:"i18next",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>i18next</title><path d="'+this.path+'"/></svg>'},path:"M14.93646 2.48699v4.51684l5.0758 13.03647s1.5495 3.1839-2.8824 3.9597H7.01922s-4.13084-.4311-3.14053-3.7019L9.21276 7.00401V2.48699h5.7237Zm2.0894 13.10781c-4.4301-1.3742-8.15457-.6365-9.97498-.0788l-1.83572 4.4186c-.78296 2.499 2.27302 2.9417 2.59687 2.9813l.02755.0032h8.44448c3.5407-.5982 2.511-2.972 2.4147-3.1773l-.0068-.0142-1.6661-4.1328Zm-7.81345.7772c.78905.0004 1.42905.3862 1.42905.8646 0 .4764-.6404.864-1.42905.864-.7887 0-1.42711-.3878-1.42711-.864 0-.4784.6384-.8646 1.4271-.8646Zm5.08375 0c.7871.0004 1.4271.3862 1.4271.8646 0 .4764-.6403.864-1.4271.864-.791 0-1.429-.3878-1.429-.864 0-.4784.638-.8646 1.429-.8646Zm-4.5001-5.2131c-.55227 0-.99993.5395-.99993 1.2051 0 .6656.44766 1.2051.99993 1.2051.5522 0 .9998-.5395.9998-1.2051 0-.6656-.4476-1.2051-.9998-1.2051Zm3.6413-1.29686c-.6549 0-1.1862.63806-1.1862 1.42906 0 .7871.5313 1.4271 1.1862 1.4271.653 0 1.1862-.64 1.1862-1.4271 0-.7907-.5328-1.42906-1.1862-1.42906Zm6.0363-2.73783s-2.1219 1.54591-4.0858-.41975V4.55615s2.7243-.60065 4.0858 2.56806Zm-14.84367 0C5.9908 3.9555 8.71543 4.55615 8.71543 4.55615v2.14831c-1.96566 1.96566-4.08544.41975-4.08544.41975ZM15.04366 0c.4954 0 .8958.4387.8958.98109 0 .54203-.4006.98074-.8958.98074H8.95478c-.49315 0-.89428-.43871-.89428-.98074C8.0605.43871 8.46146 0 8.95478 0h6.08888Z",source:"https://github.com/i18next/i18next-gitbook/blob/32efcfd9c59ae55cc63a60e633dbc1651c7950ad/assets/img/logo.svg",hex:"26A69A",guidelines:void 0,license:void 0},siXilinx={title:"Xilinx",slug:"xilinx",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Xilinx</title><path d="'+this.path+'"/></svg>'},path:"M8 18l5.241 6H5.586L.345 18l5.241-6L.345 6l5.241-6h7.655L8 6l5.241 6L8 18zM23.655 0H13.241l5.241 6 5.173-6zM13.241 24h10.414l-5.172-6-5.242 6z",source:"https://www.xilinx.com",hex:"E01F27",guidelines:void 0,license:void 0},siIata={title:"Iata",slug:"iata",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Iata</title><path d="'+this.path+'"/></svg>'},path:"M3.417 19.695l.98-4.885H5.99l-.973 4.884zm4.808-1.6h1.012l-.26-1.792zm-2.235 1.6l2.412-4.885h1.57l.99 4.884H9.487l-.088-.58H7.827l-.25.58zm6.439 0l.547-3.674h-1.394l.238-1.233h4.28l-.237 1.233h-1.327L14 19.695zm5.354-1.6h1.012l-.26-1.792zm-2.23 1.6l2.407-4.885h1.57l.99 4.884h-1.487l-.073-.58h-1.57l-.25.58zM24 9.289h-7.495c-.276 1.372-1.228 2.517-3.125 3.308.215.652.95 1.255 1.714 1.255h4.066c.62 0 1.112-.52 1.31-.94h-4.13c-.254-.044-.265-.25-.01-.271h4.06c.524 0 1-.448 1.276-.935h-4.73c-.237-.04-.237-.238 0-.277h4.77c.48 0 .918-.558 1.1-.934h-5.232c-.26-.033-.26-.277 0-.282H22.9c.415 0 .819-.454 1.1-.924zm-24 0h7.495c.27 1.372 1.228 2.517 3.12 3.308-.216.652-.952 1.255-1.715 1.255H4.84c-.62 0-1.112-.52-1.311-.94h4.13c.25-.044.266-.25.01-.271H3.608c-.525 0-1-.448-1.272-.935H7.07c.238-.04.238-.238 0-.277H2.3c-.481 0-.918-.558-1.1-.934h5.232c.26-.033.26-.277 0-.282H1.106c-.42 0-.824-.454-1.106-.924zm9.569-4.114c.277.238.586.448.918.58.282-.553.675-1.028 1.129-1.45a4.05 4.05 0 0 0-2.047.87zM8.242 7.902h1.67a5.358 5.358 0 0 1 .454-1.91 4.021 4.021 0 0 1-1.002-.63 3.83 3.83 0 0 0-1.122 2.54zm3.628-1.567V7.9H10.2a4.62 4.62 0 0 1 .414-1.815c.399.143.83.237 1.256.25zm2.56-1.161a3.346 3.346 0 0 1-.917.58 5.243 5.243 0 0 0-1.134-1.443 3.993 3.993 0 0 1 2.052.863zM15.754 7.9h-1.665a5.096 5.096 0 0 0-.442-1.91c.354-.165.69-.375.984-.63a3.723 3.723 0 0 1 1.123 2.54zM12.14 6.335V7.9h1.66c0-.631-.155-1.234-.415-1.815a4.017 4.017 0 0 1-1.245.25zm-2.571 4.57c.277-.216.597-.454.918-.57.299.559.67 1.018 1.129 1.433a4.05 4.05 0 0 1-2.047-.863zM8.242 8.173h1.67c.039.69.182 1.3.454 1.924a4.202 4.202 0 0 0-1.002.625 3.864 3.864 0 0 1-1.122-2.55zm3.628 1.57v-1.57H10.2c.01.63.154 1.255.414 1.814.399-.144.83-.232 1.256-.244zm2.56 1.162a3.41 3.41 0 0 0-.917-.57 5.113 5.113 0 0 1-1.134 1.433 4.088 4.088 0 0 0 2.052-.863zm1.323-2.732h-1.665a5.075 5.075 0 0 1-.442 1.924c.354.166.674.366.984.625a3.806 3.806 0 0 0 1.123-2.55zm-3.612 1.57v-1.57h1.66c0 .63-.155 1.244-.415 1.814a4.01 4.01 0 0 0-1.245-.244zm-.271-5.276a4.387 4.387 0 0 0-1.123 1.382c.36.122.74.222 1.123.222zm.27 0c.444.365.847.846 1.113 1.382a3.26 3.26 0 0 1-1.112.222zm-.27 7.146a4.23 4.23 0 0 1-1.123-1.388c.36-.128.74-.2 1.123-.2zm.27.01c.444-.37.847-.867 1.113-1.4a3.715 3.715 0 0 0-1.112-.197z",source:"https://upload.wikimedia.org/wikipedia/commons/f/f7/IATAlogo.svg",hex:"004E81",guidelines:void 0,license:void 0},siXing={title:"Xing",slug:"xing",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Xing</title><path d="'+this.path+'"/></svg>'},path:"M18.188 0c-.517 0-.741.325-.927.66 0 0-7.455 13.224-7.702 13.657.015.024 4.919 9.023 4.919 9.023.17.308.436.66.967.66h3.454c.211 0 .375-.078.463-.22.089-.151.089-.346-.009-.536l-4.879-8.916c-.004-.006-.004-.016 0-.022L22.139.756c.095-.191.097-.387.006-.535C22.056.078 21.894 0 21.686 0h-3.498zM3.648 4.74c-.211 0-.385.074-.473.216-.09.149-.078.339.02.531l2.34 4.05c.004.01.004.016 0 .021L1.86 16.051c-.099.188-.093.381 0 .529.085.142.239.234.45.234h3.461c.518 0 .766-.348.945-.667l3.734-6.609-2.378-4.155c-.172-.315-.434-.659-.962-.659H3.648v.016z",source:"https://dev.xing.com/logo_rules",hex:"006567",guidelines:void 0,license:void 0},siIbeacon={title:"iBeacon",slug:"ibeacon",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>iBeacon</title><path d="'+this.path+'"/></svg>'},path:"M12 .053c-6.617 0-12 5.383-12 12 0 6.077 4.541 11.113 10.408 11.894v-.364C4.741 22.804.36 17.931.36 12.053.36 5.635 5.582.413 12 .413s11.64 5.222 11.64 11.64c0 5.878-4.38 10.751-10.048 11.53v.364C19.459 23.166 24 18.13 24 12.053c0-6.617-5.383-12-12-12zm0 1.696c-5.653 0-10.251 4.598-10.251 10.25 0 5.112 3.76 9.362 8.66 10.129v-.366c-4.7-.763-8.3-4.85-8.3-9.762 0-5.454 4.437-9.89 9.891-9.89s9.891 4.436 9.891 9.89c0 4.912-3.6 8.999-8.3 9.762v.366c4.9-.767 8.66-5.017 8.66-10.128 0-5.653-4.598-10.25-10.251-10.25zm0 1.736c-4.695 0-8.515 3.82-8.515 8.515 0 4.151 2.986 7.618 6.923 8.365v-.367C6.671 19.256 3.845 15.952 3.845 12c0-4.496 3.659-8.155 8.155-8.155 4.496 0 8.154 3.659 8.154 8.155 0 3.952-2.825 7.256-6.562 7.998v.367c3.937-.747 6.923-4.214 6.923-8.365 0-4.695-3.82-8.515-8.515-8.515zm0 1.725A6.798 6.798 0 0 0 5.21 12c0 3.196 2.22 5.883 5.198 6.602v-.372C7.63 17.52 5.57 14.996 5.57 12A6.437 6.437 0 0 1 12 5.57 6.437 6.437 0 0 1 18.43 12c0 2.996-2.06 5.52-4.838 6.23v.372c2.979-.719 5.198-3.406 5.198-6.602A6.798 6.798 0 0 0 12 5.21zm0 1.749A5.047 5.047 0 0 0 6.959 12a5.05 5.05 0 0 0 3.45 4.782v-.38A4.689 4.689 0 0 1 7.318 12c0-2.58 2.1-4.68 4.681-4.68s4.68 2.1 4.68 4.68a4.689 4.689 0 0 1-3.088 4.402v.38A5.05 5.05 0 0 0 17.042 12 5.047 5.047 0 0 0 12 6.96zm0 1.737A3.308 3.308 0 0 0 8.696 12c0 1.245.692 2.33 1.712 2.894v-.42a2.943 2.943 0 1 1 3.184 0v.42A3.306 3.306 0 0 0 15.304 12 3.308 3.308 0 0 0 12 8.696zm0 1.712A1.592 1.592 0 0 0 10.408 12 1.592 1.592 0 0 0 12 13.592 1.592 1.592 0 0 0 13.592 12 1.592 1.592 0 0 0 12 10.408Z",source:"https://developer.apple.com/ibeacon/",hex:"3D7EBB",guidelines:void 0,license:void 0},siXmpp={title:"XMPP",slug:"xmpp",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>XMPP</title><path d="'+this.path+'"/></svg>'},path:"M24 3.186l-3.217 1.248-.976.325-3.122.925c.014.18.014.361.014.555 0 3.422-1.744 7.59-4.63 10.573-2.805-2.972-4.49-7.066-4.49-10.434 0-.194 0-.375.014-.555l-3.11-.921v-.009l-.861-.306L0 3.172c.146 5.747 4.867 11.701 10.542 15.02-1.3 1.014-2.766 1.788-4.365 2.192v.319c.434-.054.852-.14 1.271-.225.15-.027.3-.048.451-.08l.047-.012c1.36-.29 2.722-.776 4.052-1.408.397.195.797.38 1.2.548.109.05.22.095.33.142.201.086.407.159.612.236 1.25.474 2.568.809 3.96.924v-.305c-1.68-.425-3.211-1.264-4.56-2.355C19.194 14.904 23.853 8.975 24 3.186z",source:"https://github.com/xsf/xmpp.org/tree/00c49187e353c1a156c95562dafaf129e688fbad/content/icons",hex:"002B5C",guidelines:void 0,license:void 0},siIbm={title:"IBM",slug:"ibm",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>IBM</title><path d="'+this.path+'"/></svg>'},path:"M23.544 15.993c.038 0 .06-.017.06-.053v-.036c0-.035-.022-.052-.06-.052h-.09v.14zm-.09.262h-.121v-.498h.225c.112 0 .169.066.169.157 0 .079-.036.129-.09.15l.111.19h-.133l-.092-.17h-.07zm.434-.222v-.062c0-.2-.157-.357-.363-.357a.355.355 0 00-.363.357v.062c0 .2.156.358.363.358a.355.355 0 00.363-.358zm-.838-.03c0-.28.212-.492.475-.492.264 0 .475.213.475.491 0 .279-.211.491-.475.491a.477.477 0 01-.475-.49zM16.21 8.13l-.216-.624h-3.56v.624zm.413 1.19l-.216-.623h-3.973v.624zm2.65 7.147h3.107v-.624h-3.108zm0-1.192h3.107v-.623h-3.108zm0-1.19h1.864v-.624h-1.865zm0-1.191h1.864v-.624h-1.865zm0-1.191h1.864v-.624h-3.555l-.175.504-.175-.504h-3.555v.624h1.865v-.574l.2.574h3.33l.2-.574zm1.864-1.815h-3.142l-.217.624h3.359zm-7.46 3.006h1.865v-.624h-1.865zm0 1.19h1.865v-.623h-1.865zm-1.243 1.191h3.108v-.623h-3.108zm0 1.192h3.108v-.624h-3.108zm6.386-8.961l-.216.624h3.776v-.624zm-.629 1.815h4.19v-.624h-3.974zm-4.514 1.19h3.359l-.216-.623h-3.143zm2.482 2.383h2.496l.218-.624h-2.932zm.417 1.19h1.662l.218-.623h-2.098zm.416 1.191h.83l.218-.623h-1.266zm.414 1.192l.217-.624h-.432zm-12.433-.006l4.578.006c.622 0 1.18-.237 1.602-.624h-6.18zm4.86-3v.624h2.092c0-.216-.03-.425-.083-.624zm-3.616.624h1.865v-.624H6.217zm3.617-3.573h2.008c.053-.199.083-.408.083-.624H9.834zm-3.617 0h1.865v-.624H6.217zM9.55 7.507H4.973v.624h6.18a2.36 2.36 0 00-1.602-.624zm2.056 1.191H4.973v.624h6.884a2.382 2.382 0 00-.25-.624zm-5.39 2.382v.624h4.87c.207-.176.382-.387.519-.624zm4.87 1.191h-4.87v.624h5.389a2.39 2.39 0 00-.519-.624zm-6.114 3.006h6.634c.11-.193.196-.402.25-.624H4.973zM0 8.13h4.352v-.624H0zm0 1.191h4.352v-.624H0zm1.243 1.191h1.865v-.624H1.243zm0 1.191h1.865v-.624H1.243zm0 1.19h1.865v-.623H1.243zm0 1.192h1.865v-.624H1.243zM0 15.276h4.352v-.623H0zm0 1.192h4.352v-.624H0Z",source:"https://www.ibm.com/design/language/ibm-logos/8-bar/",hex:"052FAD",guidelines:"https://www.ibm.com/design/language/ibm-logos/8-bar/",license:void 0},siXrp={title:"XRP",slug:"xrp",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>XRP</title><path d="'+this.path+'"/></svg>'},path:"M5.52 2.955A3.521 3.521 0 001.996 6.48v2.558A2.12 2.12 0 010 11.157l.03.562-.03.561a2.12 2.12 0 011.996 2.121v2.948a3.69 3.69 0 003.68 3.696v-1.123a2.56 2.56 0 01-2.557-2.558v-2.963a3.239 3.239 0 00-1.42-2.682 3.26 3.26 0 001.42-2.682V6.48A2.412 2.412 0 015.52 4.078h.437V2.955zm12.538 0v1.123h.437a2.39 2.39 0 012.386 2.401v2.558a3.26 3.26 0 001.42 2.682 3.239 3.239 0 00-1.42 2.682v2.963a2.56 2.56 0 01-2.557 2.558v1.123a3.69 3.69 0 003.68-3.696V14.4A2.12 2.12 0 0124 12.281l-.03-.562.03-.561a2.12 2.12 0 01-1.996-2.12V6.478a3.518 3.518 0 00-3.509-3.524zM6.253 7.478l3.478 3.259a3.393 3.393 0 004.553 0l3.478-3.26h-1.669l-2.65 2.464a2.133 2.133 0 01-2.886 0L7.922 7.478zm5.606 4.884a3.36 3.36 0 00-2.128.886l-3.493 3.274h1.668l2.667-2.495a2.133 2.133 0 012.885 0l2.65 2.495h1.67l-3.494-3.274a3.36 3.36 0 00-2.425-.886z",source:"https://xrpl.org/",hex:"25A768",guidelines:void 0,license:void 0},siXsplit={title:"XSplit",slug:"xsplit",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>XSplit</title><path d="'+this.path+'"/></svg>'},path:"M24 19.5c-.7-.1-2.5-.3-2.7-.3-.1 0-2.8 2.3-4 3.399l-.1.101c.1-1.3.3-2.601.399-3.9C11.7 18.1 5.9 17.4 0 16.7V1.5v-.2H.3C.9 1.4 22.9 3.9 24 4v15.5zm-2.6-2.6V6.2C15.1 5.5 8.7 4.7 2.4 4v10.6c6.3.8 12.7 1.5 19 2.3z",source:"https://www.xsplit.com/presskit",hex:"0095DE",guidelines:void 0,license:void 0},siIcinga={title:"Icinga",slug:"icinga",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Icinga</title><path d="'+this.path+'"/></svg>'},path:"M13.8285.0086a2.122 2.122 0 00-1.1546.4705c-.9134.7446-1.052 2.0897-.3057 3.0038.1738.2135.382.3803.6085.5076l-1.9992 4.1526c-1.3307-.5156-2.8925-.3242-4.0768.6411a4.1264 4.1264 0 00-.2805.2538L4.3895 7.2125c.124-.31.1253-.6679-.0326-.9913-.2979-.6072-1.0314-.859-1.6385-.561-.6079.2963-.8581 1.0298-.561 1.637.2979.6063 1.029.8595 1.637.5624.0991-.0483.1849-.1119.2642-.181l2.1846 1.7868c-1.1343 1.4732-1.1567 3.5843.0712 5.0876.2648.3253.5696.5978.9009.8193l-2.5067 3.5945c-.5002-.3428-1.1085-.5336-1.7602-.4838-1.522.114-2.663 1.4395-2.5482 2.9608.114 1.522 1.4403 2.663 2.9623 2.5483 1.522-.114 2.6622-1.4396 2.5482-2.9609-.0494-.6638-.3388-1.2483-.7658-1.6948l2.569-3.6836c1.1473.5518 2.5128.5527 3.6718-.0505l1.444 2.4117c-.1372.1332-.2392.3041-.2627.509-.0547.472.2836.899.7555.9529.471.054.8965-.2836.9528-.7555.054-.471-.2836-.898-.7554-.9528-.057-.007-.1097.0104-.1648.0148l-1.4856-2.4829c.072-.0512.1443-.1008.2137-.1573 1.0746-.8777 1.584-2.1864 1.493-3.4729l6.968-1.7186c.3257.484.888.7887 1.5108.742.9248-.0698 1.6171-.8747 1.548-1.7987-.07-.924-.8755-1.6156-1.7988-1.5464-.9247.0706-1.6163.874-1.5464 1.7972.007.0956.0267.1876.049.2776l-6.8092 1.68c-.1312-.6151-.4011-1.2094-.8252-1.7305-.3373-.4132-.7407-.7403-1.1799-.9854l2.017-4.1882c.6295.1558 1.3211.0324 1.8625-.4081.9134-.7447 1.0504-2.092.3058-3.0054-.466-.5709-1.1665-.8375-1.8492-.7762z",source:"https://github.com/Icinga/icingaweb2/blob/293021b2000e9d459387153ca5690f97e0184aaa/public/img/icinga-logo-compact.svg",hex:"06062C",guidelines:void 0,license:void 0},siXstate={title:"XState",slug:"xstate",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>XState</title><path d="'+this.path+'"/></svg>'},path:"M15.891 0h6.023l-6.085 10.563c-1.853-3.305-1.822-7.32.062-10.563zm6.055 23.999L8.078.001H2.055l6.919 12.015L2.055 24h6.023L12 17.236 15.892 24z",source:"https://github.com/davidkpiano/xstate/blob/544df7f00e2ef49603b5e5ff2f0d183ff6bd5e7c/docs/.vuepress/public/logo.svg",hex:"2C3E50",guidelines:void 0,license:void 0},siIcloud={title:"iCloud",slug:"icloud",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>iCloud</title><path d="'+this.path+'"/></svg>'},path:"M13.762 4.29a6.51 6.51 0 0 0-5.669 3.332 3.571 3.571 0 0 0-1.558-.36 3.571 3.571 0 0 0-3.516 3A4.918 4.918 0 0 0 0 14.796a4.918 4.918 0 0 0 4.92 4.914 4.93 4.93 0 0 0 .617-.045h14.42c2.305-.272 4.041-2.258 4.043-4.589v-.009a4.594 4.594 0 0 0-3.727-4.508 6.51 6.51 0 0 0-6.511-6.27z",source:"https://commons.wikimedia.org/wiki/File:ICloud_logo.svg",hex:"3693F3",guidelines:void 0,license:void 0},siYcombinator={title:"Y Combinator",slug:"ycombinator",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Y Combinator</title><path d="'+this.path+'"/></svg>'},path:"M0 24V0h24v24H0zM6.951 5.896l4.112 7.708v5.064h1.583v-4.972l4.148-7.799h-1.749l-2.457 4.875c-.372.745-.688 1.434-.688 1.434s-.297-.708-.651-1.434L8.831 5.896h-1.88z",source:"https://www.ycombinator.com/press/",hex:"F0652F",guidelines:void 0,license:void 0},siIcomoon={title:"IcoMoon",slug:"icomoon",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>IcoMoon</title><path d="'+this.path+'"/></svg>'},path:"M12 0C10.34 0 8.79 .313 7.34 .938A12 12 0 0 0 3.5 3.5A12 12 0 0 0 .937 7.34C.313 8.79 0 10.34 0 12C0 13.66 .313 15.21 .938 16.66A12 12 0 0 0 3.5 20.5A12 12 0 0 0 7.34 23.06C8.79 23.69 10.34 24 12 24C13.66 24 15.21 23.69 16.66 23.06A12 12 0 0 0 20.5 20.5A12 12 0 0 0 23.06 16.66C23.69 15.21 24 13.66 24 12C24 10.34 23.69 8.79 23.06 7.34A12 12 0 0 0 20.5 3.5A12 12 0 0 0 16.66 .937C15.21 .313 13.66 0 12 0M8.88 1.5A11.65 11.65 0 0 1 11.37 3.42A12.31 12.31 0 0 1 13.27 5.87C13.8 6.77 14.2 7.73 14.5 8.77C14.78 9.8 14.93 10.88 14.93 12S14.78 14.2 14.5 15.23A11.71 11.71 0 0 1 13.27 18.13A12.31 12.31 0 0 1 11.37 20.58C10.62 21.33 9.79 21.96 8.88 22.5A11.91 11.91 0 0 1 6.42 20.58A12.31 12.31 0 0 1 4.5 18.13A11.71 11.71 0 0 1 3.31 15.23A11.63 11.63 0 0 1 2.86 12C2.86 10.88 3 9.8 3.31 8.77A11.71 11.71 0 0 1 4.5 5.87A12.31 12.31 0 0 1 6.42 3.42C7.17 2.67 8 2.04 8.88 1.5M8.86 9.23C8.09 9.23 7.44 9.5 6.9 10.04A2.67 2.67 0 0 0 6.09 12C6.09 12.77 6.36 13.42 6.9 13.96C7.44 14.5 8.09 14.77 8.86 14.77C9.63 14.77 10.28 14.5 10.82 13.96C11.36 13.42 11.63 12.77 11.63 12S11.36 10.58 10.82 10.04A2.67 2.67 0 0 0 8.86 9.23Z",source:"https://icomoon.io/",hex:"825794",guidelines:void 0,license:void 0},siYahoo={title:"Yahoo!",slug:"yahoo",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Yahoo!</title><path d="'+this.path+'"/></svg>'},path:"M18.86 1.56L14.27 11.87H19.4L24 1.56H18.86M0 6.71L5.15 18.27L3.3 22.44H7.83L14.69 6.71H10.19L7.39 13.44L4.62 6.71H0M15.62 12.87C13.95 12.87 12.71 14.12 12.71 15.58C12.71 17 13.91 18.19 15.5 18.19C17.18 18.19 18.43 16.96 18.43 15.5C18.43 14.03 17.23 12.87 15.62 12.87Z",source:"https://yahoo.com/",hex:"6001D2",guidelines:void 0,license:void 0},siIcon={title:"ICON",slug:"icon",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>ICON</title><path d="'+this.path+'"/></svg>'},path:"M1.92669 23.93457c-.93754-.17758-1.70436-.94464-1.88217-1.88241-.31993-1.6878 1.13237-3.1401 2.82018-2.82018.93754.17781 1.7046.94463 1.8824 1.88217.31993 1.68804-1.13237 3.14034-2.82041 2.82042zM21.13507 4.76808c-.93754-.1778-1.7046-.94463-1.8824-1.8824-.31993-1.68805 1.13284-3.14034 2.82065-2.82019.93777.17805 1.70436.94487 1.88217 1.88241.31992 1.6878-1.13261 3.1401-2.82042 2.82018zm-9.11415 1.24226c1.1475 0 2.21912.32347 3.13017.88292l2.58538-2.58562c-1.59582-1.1877-3.57352-1.89092-5.71555-1.89092-5.29278 0-9.58347 4.29045-9.58347 9.58323 0 2.14227.70321 4.11997 1.89116 5.7158l2.58538-2.5854c-.55945-.91105-.88268-1.9829-.88268-3.1304 0-3.30799 2.68162-5.98961 5.9896-5.98961zm5.10664 2.85936c.55969.91106.88292 1.98267.88292 3.13018 0 3.30798-2.68162 5.9896-5.98961 5.9896-1.1475 0-2.21935-.323-3.13041-.88268L6.30508 19.6922c1.59582 1.18794 3.57352 1.89115 5.71579 1.89115 5.29278 0 9.58323-4.29045 9.58323-9.58346 0-2.14227-.70345-4.11974-1.89092-5.7158Z",source:"https://icon.foundation/contents/resrce/media",hex:"31B8BB",guidelines:void 0,license:void 0},siYale={title:"Yale",slug:"yale",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Yale</title><path d="'+this.path+'"/></svg>'},path:"M15.8 15.72v-1.24c-.64.04-.8-.24-.8-.76V7.6h-1.36v6.24c0 1.2.44 1.96 2.16 1.88zm4.96-5.24c-.44-.52-1.12-.88-2.08-.88-1 0-1.68.36-2.12.88-.52.64-.64 1.56-.64 2.24 0 .64.12 1.4.56 2.04.44.6 1.16 1 2.28 1 .76 0 1.36-.16 1.8-.48.44-.32.76-.84.8-1.36h-1.4c-.04.2-.16.36-.32.52-.2.16-.48.2-.88.2-.56 0-.92-.16-1.12-.48-.16-.24-.24-.64-.24-1h4.04c0-1.08-.16-2.04-.68-2.68zm-3.4 1.64c0-.32.12-.76.36-1s.56-.36.96-.36c.4 0 .72.12.96.36s.32.68.32 1zM10.4 9.64c-1.6 0-2.36.84-2.44 2h1.4c.04-.52.32-.84 1.04-.84.84 0 1.08.4 1.08 1v.36h-1.24c-.8 0-1.32.08-1.72.36-.48.32-.76.76-.76 1.44 0 .84.52 1.8 2.12 1.8.8 0 1.32-.24 1.68-.68v.6h1.32v-3.84c-.04-1.28-.72-2.2-2.48-2.2zm1.04 4.16c0 .64-.56.92-1.32.92-.84 0-1.04-.36-1.04-.8 0-.24.08-.44.28-.56.16-.08.4-.12.88-.12h1.2zM9.12 7.6H7.56l-1.92 3.6-1.92-3.6H2.16l2.76 4.96v3.08h1.44v-3.08zM24 12c0 6.64-5.36 12-12 12S0 18.64 0 12 5.36 0 12 0s12 5.36 12 12",source:"https://yalehome.com",hex:"FFD900",guidelines:void 0,license:void 0},siIconfinder={title:"Iconfinder",slug:"iconfinder",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Iconfinder</title><path d="'+this.path+'"/></svg>'},path:"M12 0C4.492 2.746-.885 11.312.502 19.963.502 19.963 4.989 24 12 24c7.01 0 11.496-4.037 11.496-4.037C24.882 11.312 19.508 2.746 12 0zm0 1.846s2.032.726 3.945 2.488c.073.067.13.163.129.277-.001.168-.128.287-.301.287a.496.496 0 01-.137-.027 6.537 6.537 0 00-2.316-.4 6.625 6.625 0 00-3.914 1.273l-.002.002a7.978 7.978 0 016.808.768C20.48 9.11 22.597 14.179 21.902 19c0 0-1.646 1.396-4.129 2.172a.369.369 0 01-.303-.026c-.144-.084-.185-.255-.1-.404a.492.492 0 01.094-.103 6.562 6.562 0 001.504-1.809 6.632 6.632 0 00.856-4.027l-.002-.002a7.949 7.949 0 01-3.838 5.383c-4.42 2.552-9.99 1.882-13.885-1.184 0 0-.388-2.124.182-4.662a.373.373 0 01.176-.25c.145-.084.31-.033.396.117a.448.448 0 01.045.13c.126.762.405 1.5.814 2.208a6.637 6.637 0 003.059 2.756 7.96 7.96 0 01-1.672-2.033 7.928 7.928 0 01-1.066-4.205C4.128 8.047 7.464 3.659 12 1.846zm0 7.623c-2.726 0-5.117.93-6.483 2.332-.064.32-.1.65-.1.984 0 3.146 2.947 5.695 6.583 5.695 3.635 0 6.584-2.549 6.584-5.695 0-.334-.038-.664-.102-.984C17.116 10.4 14.724 9.469 12 9.469zm0 .693a3.12 3.12 0 010 6.238 3.118 3.118 0 01-2.872-4.336 1.3 1.3 0 101.657-1.656A3.108 3.108 0 0112 10.162z",source:"https://www.iconfinder.com/p/about",hex:"1A1B1F",guidelines:void 0,license:void 0},siYamahacorporation={title:"Yamaha Corporation",slug:"yamahacorporation",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Yamaha Corporation</title><path d="'+this.path+'"/></svg>'},path:"M12 0a12 12 0 1012 12A12 12 0 0012 0zm-.412 1.377A10.648 10.648 0 0122.664 12 10.648 10.648 0 0112 22.664a10.648 10.648 0 01-.412-21.287zM12 1.9a.184.184 0 00-.172.131l-.883 2.526a.39.39 0 000 .097.3.3 0 00.133.25.926.926 0 01.074 1.465 2.345 2.345 0 00-.82 1.79v.903L5.865 6.498l-.547.953 4.987 2.877v.692l-.602.347-4.978-2.88-.551.954L8.602 12l-.782.45a2.345 2.345 0 00-1.127 1.616.93.93 0 01-1.312.668.293.293 0 00-.277 0 .324.324 0 00-.079.063l-1.742 2.037a.188.188 0 00.176.305l2.633-.493a.36.36 0 00.09-.035.3.3 0 00.152-.238.926.926 0 011.232-.781 2.345 2.345 0 001.954-.184l.78-.451v5.104h1.098v-5.756l.598-.344.598.344v5.756h1.1v-5.123l.78.45a2.345 2.345 0 001.954.184.926.926 0 011.234.782.285.285 0 00.149.238.36.36 0 00.09.035l2.634.492a.184.184 0 00.176-.305l.004.02-1.744-2.037a.39.39 0 00-.075-.063.3.3 0 00-.28 0 .938.938 0 01-.864-.035.93.93 0 01-.434-.633 2.368 2.368 0 00-1.14-1.609l-.782-.45 4.436-2.558-.549-.955-4.98 2.873-.602-.347v-.692l4.985-2.877-.547-.953L13.7 9.062v-.904a2.345 2.345 0 00-.803-1.789.922.922 0 01.079-1.465.309.309 0 00.128-.25.27.27 0 000-.097L12.18 2.03a.184.184 0 00-.18-.13zm.021 5.512a.598.598 0 01.58.598V9.7l-.597.347-.598-.348V8.01a.598.598 0 01.615-.597zm-.017 3.818l.687.391v.781l-.687.391-.688-.39v-.782zm2.299 1.403l1.46.847a.598.598 0 01.223.817v.004a.602.602 0 01-.82.219l-1.465-.844v-.696zm-4.596.004l.602.347v.692l-1.465.844a.598.598 0 11-.598-1.036z",source:"https://www.yamaha.com/en/",hex:"4B1E78",guidelines:void 0,license:void 0},siIconify={title:"Iconify",slug:"iconify",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Iconify</title><path d="'+this.path+'"/></svg>'},path:"M12 19.5c3.75 0 7.159-3.379 6.768-4.125-.393-.75-2.268 1.875-6.768 1.875s-6-2.625-6.375-1.875S8.25 19.5 12 19.5zm4.125-12c.623 0 1.125.502 1.125 1.125v1.5c0 .623-.502 1.125-1.125 1.125A1.123 1.123 0 0115 10.125v-1.5c0-.623.502-1.125 1.125-1.125zm-8.25 0C8.498 7.5 9 8.002 9 8.625v1.5c0 .623-.502 1.125-1.125 1.125a1.123 1.123 0 01-1.125-1.125v-1.5c0-.623.502-1.125 1.125-1.125zM12 0C5.381 0 0 5.381 0 12s5.381 12 12 12 12-5.381 12-12S18.619 0 12 0zm0 1.5c5.808 0 10.5 4.692 10.5 10.5S17.808 22.5 12 22.5 1.5 17.808 1.5 12 6.192 1.5 12 1.5Z",source:"https://iconify.design/",hex:"1769AA",guidelines:void 0,license:void 0},siYamahamotorcorporation={title:"Yamaha Motor Corporation",slug:"yamahamotorcorporation",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Yamaha Motor Corporation</title><path d="'+this.path+'"/></svg>'},path:"M12 0A12 12 0 000 12a12 12 0 0012 12 12 12 0 0012-12A12 12 0 0012 0zm0 .57C18.315.57 23.43 5.685 23.43 12c0 6.31-5.115 11.43-11.43 11.43C5.69 23.43.57 18.314.57 12 .57 5.69 5.69.57 12 .57zm0 .234c-.1 0-.183.06-.218.147l-.492 1.551A9.523 9.523 0 002.475 12c0 1.48.337 2.885.94 4.136l-1.1 1.206a.241.241 0 00-.015.262.246.246 0 00.238.115l1.592-.353a9.52 9.52 0 007.87 4.16c3.27 0 6.16-1.652 7.874-4.16l1.592.353a.236.236 0 00.23-.123.234.234 0 00-.016-.262l-1.1-1.198A9.431 9.431 0 0021.526 12a9.523 9.523 0 00-8.815-9.498L12.218.947A.237.237 0 0012 .804zm-.003.25c.024 0 .048.02.056.043l1.02 3.354a1.2 1.2 0 00-.48.957c0 .389.19.734.48.952h-.004c.436.326.718.846.718 1.429v1.12l4.326-2.497.476.825-4.802 2.77v.965l.834.48 4.802-2.774.476.825-4.326 2.5.972.56c.508.294.818.798.882 1.338v-.004a1.193 1.193 0 001.655.953l2.393 2.56c.02.02.02.047.008.07-.016.025-.04.033-.068.029l-3.413-.794a1.193 1.193 0 00-1.65-.957l.003-.004c-.5.215-1.091.199-1.6-.095l-.968-.56v4.994h-.952v-5.545l-.834-.48-.833.48v5.545h-.953V15.1l-.972.555c-.508.294-1.1.31-1.6.096l.004.004a1.193 1.193 0 00-1.651.957l-3.413.793a.054.054 0 01-.063-.028c-.016-.02-.012-.047.008-.067l2.397-2.56c.333.143.73.135 1.067-.064.338-.194.544-.528.588-.889v.004c.063-.54.373-1.044.88-1.337l.97-.56-4.327-2.496.477-.826 4.802 2.774.833-.484v-.964l-4.802-2.77.476-.826 4.326 2.496V7.79c0-.583.282-1.103.719-1.429h-.004c.29-.214.476-.56.476-.952 0-.393-.19-.738-.48-.957l1.02-3.353c.008-.028.031-.044.051-.044zm.004 5.902a.833.833 0 00-.833.833v1.67L12 9.94l.833-.48V7.789a.833.833 0 00-.833-.833zm0 4.084l-.833.48v.964l.833.476.833-.48v-.96zm-2.62 1.516l-1.444.833a.833.833 0 00-.306 1.14.822.822 0 00.723.412.83.83 0 00.416-.111l1.445-.834v-.96zm5.243 0l-.833.48V14l1.445.834a.834.834 0 00.833-1.445z",source:"https://en.wikipedia.org/wiki/Yamaha_Motor_Company",hex:"E60012",guidelines:void 0,license:void 0},siIconjar={title:"IconJar",slug:"iconjar",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>IconJar</title><path d="'+this.path+'"/></svg>'},path:"M5.15 5.875c-.492 0-.936-.453-.936-.954 0-1.155 2.858-2.01 6.11-2.01.295 0 .492 0 .492-.25 0-.452-.985-.602-.985-1.355C9.831.502 10.767 0 11.95 0c1.183 0 2.12.502 2.12 1.306 0 .753-.986.853-.986 1.355 0 .151.148.251.492.251 3.252 0 6.16.803 6.16 2.009a.944.944 0 01-.937.953H5.151zm14.732 4.568c1.183.753 1.626 2.109 1.43 3.365l-1.38 7.58C19.636 22.897 18.354 24 16.826 24H7.17c-1.526 0-2.808-1.104-3.104-2.611l-1.38-7.581a3.307 3.307 0 011.48-3.315c.69-.501.836-1.355 0-1.656-1.184-.452-.938-1.908.245-1.908h7.193c1.133 0 2.514.853 2.514 3.615 0 2.762-1.282 2.51-1.282 4.468 0 .854.69 1.758 1.527 1.859 1.43.15 2.267-.402 2.267-2.41 0-2.06-1.182-3.013-1.182-4.72 0-2.059 1.28-2.863 2.118-2.863h2.07c1.182 0 1.43 1.457.246 1.909-.837.35-.69 1.205 0 1.656z",source:"https://geticonjar.com/",hex:"16A5F3",guidelines:void 0,license:void 0},siYammer={title:"Yammer",slug:"yammer",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Yammer</title><path d="'+this.path+'"/></svg>'},path:"M23.5094 7.391a.696.696 0 00-.859-.527l-2.31.626A17.4135 17.4135 0 0016.3897.226a.69.69 0 00-.509-.225.677.677 0 00-.482.2L9.7667 5.8379H1.023C.458 5.838 0 6.296 0 6.862v10.2368c0 .566.458 1.025 1.023 1.025h8.7037l5.6719 5.6768a.687.687 0 00.99-.025 17.4305 17.4305 0 003.9509-7.2638l2.3109.626a.696.696 0 00.859-.527 21.9024 21.9024 0 000-9.2198zm-7.6738-5.45a15.8536 15.8536 0 013.0229 5.9499l-6.5958 1.786v-2.815a1.02 1.02 0 00-.48-.865zM9.2738 9.226l-2.205 3.8809v2.0219a.938.938 0 11-1.876 0v-2.193L3.085 9.226a.8637.8637 0 111.501-.855l1.594 2.9779 1.5939-2.978a.861.861 0 011.176-.324.866.866 0 01.324 1.179zm9.5847 6.8848a15.8536 15.8536 0 01-3.023 5.9498l-4.0788-4.0819c.301-.178.506-.504.506-.88v-2.7739zm3.316-.698l-9.9118-2.684v-1.4559l9.9117-2.684a20.4075 20.4075 0 010 6.8239Z",source:"https://developer.microsoft.com/en-us/fluentui#/styles/web/colors/products",hex:"106EBE",guidelines:void 0,license:void 0},siIcons8={title:"Icons8",slug:"icons8",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Icons8</title><path d="'+this.path+'"/></svg>'},path:"M12 0H0v24h12zM18 12c3.3137 0 6-2.6863 6-6s-2.6863-6-6-6-6 2.6863-6 6 2.6863 6 6 6zM18 24c3.3137 0 6-2.6863 6-6s-2.6863-6-6-6-6 2.6863-6 6 2.6863 6 6 6z",source:"https://icons8.com/",hex:"1FB141",guidelines:void 0,license:void 0},siYarn={title:"Yarn",slug:"yarn",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Yarn</title><path d="'+this.path+'"/></svg>'},path:"M12 0C5.375 0 0 5.375 0 12s5.375 12 12 12 12-5.375 12-12S18.625 0 12 0zm.768 4.105c.183 0 .363.053.525.157.125.083.287.185.755 1.154.31-.088.468-.042.551-.019.204.056.366.19.463.375.477.917.542 2.553.334 3.605-.241 1.232-.755 2.029-1.131 2.576.324.329.778.899 1.117 1.825.278.774.31 1.478.273 2.015a5.51 5.51 0 0 0 .602-.329c.593-.366 1.487-.917 2.553-.931.714-.009 1.269.445 1.353 1.103a1.23 1.23 0 0 1-.945 1.362c-.649.158-.95.278-1.821.843-1.232.797-2.539 1.242-3.012 1.39a1.686 1.686 0 0 1-.704.343c-.737.181-3.266.315-3.466.315h-.046c-.783 0-1.214-.241-1.45-.491-.658.329-1.51.19-2.122-.134a1.078 1.078 0 0 1-.58-1.153 1.243 1.243 0 0 1-.153-.195c-.162-.25-.528-.936-.454-1.946.056-.723.556-1.367.88-1.71a5.522 5.522 0 0 1 .408-2.256c.306-.727.885-1.348 1.32-1.737-.32-.537-.644-1.367-.329-2.21.227-.602.412-.936.82-1.08h-.005c.199-.074.389-.153.486-.259a3.418 3.418 0 0 1 2.298-1.103c.037-.093.079-.185.125-.283.31-.658.639-1.029 1.024-1.168a.94.94 0 0 1 .328-.06zm.006.7c-.507.016-1.001 1.519-1.001 1.519s-1.27-.204-2.266.871c-.199.218-.468.334-.746.44-.079.028-.176.023-.417.672-.371.991.625 2.094.625 2.094s-1.186.839-1.626 1.881c-.486 1.144-.338 2.261-.338 2.261s-.843.732-.899 1.487c-.051.663.139 1.2.343 1.515.227.343.51.176.51.176s-.561.653-.037.931c.477.25 1.283.394 1.71-.037.31-.31.371-1.001.486-1.283.028-.065.12.111.209.199.097.093.264.195.264.195s-.755.324-.445 1.066c.102.246.468.403 1.066.398.222-.005 2.664-.139 3.313-.296.375-.088.505-.283.505-.283s1.566-.431 2.998-1.357c.917-.598 1.293-.76 2.034-.936.612-.148.57-1.098-.241-1.084-.839.009-1.575.44-2.196.825-1.163.718-1.742.672-1.742.672l-.018-.032c-.079-.13.371-1.293-.134-2.678-.547-1.515-1.413-1.881-1.344-1.997.297-.5 1.038-1.297 1.334-2.78.176-.899.13-2.377-.269-3.151-.074-.144-.732.241-.732.241s-.616-1.371-.788-1.483a.271.271 0 0 0-.157-.046z",source:"https://github.com/yarnpkg/assets",hex:"2C8EBB",guidelines:void 0,license:void 0},siIcq={title:"ICQ",slug:"icq",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>ICQ</title><path d="'+this.path+'"/></svg>'},path:"M10.189 0a3.784 3.784 0 0 0-3.055 5.93l1.741 2.562a1.855 1.855 0 0 0 3.334-.13l1.454-2.929h-.006A3.784 3.784 0 0 0 10.189 0zm9.173 4.496a4.235 4.235 0 0 0-1.662.306 4.23 4.23 0 0 0-1.817 1.396l-2.214 2.837c-.025.032-.05.063-.074.096l-.01.012a2.088 2.088 0 0 0 1.509 3.306l3.614.536-.003-.007a4.259 4.259 0 0 0 4.532-5.807 4.264 4.264 0 0 0-3.875-2.675zM3.586 7.242A3.154 3.154 0 0 0 .55 9.628a3.151 3.151 0 0 0 3.903 3.804l2.539-.737a1.545 1.545 0 0 0 .742-2.673L5.79 8.118v.005a3.13 3.13 0 0 0-2.204-.881zM13.9 13.959a1.886 1.886 0 0 0-1.858 2.233l.387 3.263.005-.003a3.846 3.846 0 0 0 6.134 2.574 3.846 3.846 0 0 0-.9-6.645l-2.877-1.197a1.89 1.89 0 0 0-.89-.225zm-5.55.08c-.377 0-.75.104-1.076.3L4.06 16.018l.006.003a4.21 4.21 0 0 0-1.593 1.485 4.24 4.24 0 0 0 1.342 5.843 4.239 4.239 0 0 0 5.845-1.332 4.21 4.21 0 0 0 .647-2.172l.108-3.45a2.079 2.079 0 0 0-2.062-2.356z",source:"https://commons.wikimedia.org/wiki/File:ICQNewlogo.svg",hex:"24FF00",guidelines:void 0,license:void 0},siZalando={title:"Zalando",slug:"zalando",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Zalando</title><path d="'+this.path+'"/></svg>'},path:"M5.27 24c-.88 0-1.36-.2-1.62-.36-.36-.21-1.02-.75-1.62-2.33A27.06 27.06 0 01.49 12c.02-3.66.59-6.76 1.54-9.3C2.63 1.1 3.29.56 3.65.35 3.91.21 4.39 0 5.27 0c.33 0 .72.03 1.18.1a26.1 26.1 0 018.7 3.3h.01a26.4 26.4 0 017.16 6.01c1.06 1.32 1.19 2.17 1.19 2.59 0 .42-.13 1.27-1.19 2.59a26.4 26.4 0 01-7.16 6h-.01a26.03 26.03 0 01-8.7 3.3c-.46.08-.85.11-1.18.11z",source:"https://www.zalando.co.uk/",hex:"FF6900",guidelines:void 0,license:void 0},siIeee={title:"IEEE",slug:"ieee",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>IEEE</title><path d="'+this.path+'"/></svg>'},path:"M4.74 14.973h-.05v-.064h.04c.022 0 .051.002.051.03 0 .028-.015.034-.04.034zm.101-.03c0-.06-.04-.079-.109-.079h-.099v.265h.057v-.111h.027l.061.111h.068l-.069-.116c.036-.003.064-.02.064-.07zm-.11.243c-.098 0-.176-.076-.176-.19 0-.113.078-.188.176-.188.095 0 .177.075.177.188 0 .114-.082.19-.177.19zm-.247-.19c0 .156.116.247.247.247.13 0 .247-.09.247-.247a.238.238 0 0 0-.247-.246.239.239 0 0 0-.247.246zM3.35 12.61c-.02.374-.025.72-.052 1.096.148.013.315.026.473.003l-.047-1.046-.009-.05c-.12.005-.234.01-.365-.003zm-.926-1.051c-.182.091-.45.23-.421.48.04.136.187.224.304.28.647.286 1.506.295 2.19.083.168-.065.395-.16.426-.366-.002-.171-.183-.279-.313-.344v-.008a.575.575 0 0 1 .144-.039v-.004c-.228-.041-.45-.101-.671-.16.043.097.073.2.109.301.067-.021.135-.038.207-.047.117.045.284.11.3.256.014.137-.136.204-.23.26-.501.181-1.065.2-1.588.06-.144-.045-.353-.103-.37-.287.102-.242.367-.292.588-.351-.114-.073-.23-.138-.34-.22-.119.007-.227.059-.335.106zm1.107-1.46l-.064.208-.326.932c.082.008.183 0 .263.008v.008l-.048 1.054.008.01c.104.01.234.016.34-.002V12.3l-.042-1.022.006-.035.286-.004a46.727 46.727 0 0 1-.414-1.14zm-.15-.469c.239-.163.453.065.639.195.717.578 1.393 1.238 1.909 1.984.065.096.094.246.036.355-.134.223-.314.426-.485.633v.011c-.426.454-.876.92-1.363 1.305-.237.144-.455.46-.761.264a11.007 11.007 0 0 1-1.927-1.82c-.096-.149-.246-.271-.312-.44-.093-.23.112-.394.229-.566.576-.71 1.291-1.407 2.034-1.92zm.6-.678l-.266-.376c-.032-.02-.073-.052-.108-.062-.079-.034-.163.007-.227.056l-.48.624c-.769.953-1.68 1.843-2.673 2.525-.079.061-.195.121-.22.222-.026.091.022.166.078.223a13.061 13.061 0 0 1 2.234 1.94c.12.127.217.252.335.37.198.265.43.53.613.813.057.06.066.158.156.187.07.024.156.04.223 0l.066-.067a13.269 13.269 0 0 1 3.034-3.06c.117-.103.34-.142.343-.336a.308.308 0 0 0-.137-.226l-.02-.003c-.6-.408-1.159-.87-1.686-1.394l-.582-.609a16.595 16.595 0 0 1-.684-.827zm.039.672c.206.157.42.336.61.518l.034.02a10.122 10.122 0 0 1 1.405 1.592c.065.1.122.212.086.343-.133.332-.403.597-.639.887-.51.55-1.05 1.081-1.652 1.506-.122.086-.287.166-.433.097-.444-.232-.818-.613-1.207-.96-.45-.417-.902-.904-1.244-1.413a.417.417 0 0 1-.064-.253c.044-.176.165-.32.279-.469.403-.514.897-1.002 1.397-1.447.011-.012.032-.036.05-.047.215-.186.428-.35.652-.511.234-.182.529-.031.726.137zm15.942-.197H24v1.028h-2.569v1.094h2.364v1.028H21.43V13.7H24v1.028h-4.038zm-4.859 0h4.037v1.028h-2.57v1.094h2.363v1.028H16.57V13.7h2.569v1.028h-4.037zm-4.86 0h4.037v1.028h-2.57v1.094h2.365v1.028H11.71V13.7h2.57v1.028h-4.038zm-2.24 0h1.469v5.301H8.004Z",source:"https://brand-experience.ieee.org/templates-tools-resources/resources/master-brand-and-logos/",hex:"00629B",guidelines:"https://brand-experience.ieee.org/guidelines/brand-identity/",license:void 0},siZalo={title:"Zalo",slug:"zalo",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Zalo</title><path d="'+this.path+'"/></svg>'},path:"M12.49 10.2722v-.4496h1.3467v6.3218h-.7704a.576.576 0 01-.5763-.5729l-.0006.0005a3.273 3.273 0 01-1.9372.6321c-1.8138 0-3.2844-1.4697-3.2844-3.2823 0-1.8125 1.4706-3.2822 3.2844-3.2822a3.273 3.273 0 011.9372.6321l.0006.0005zM6.9188 7.7896v.205c0 .3823-.051.6944-.2995 1.0605l-.03.0343c-.0542.0615-.1815.206-.2421.2843L2.024 14.8h4.8948v.7682a.5764.5764 0 01-.5767.5761H0v-.3622c0-.4436.1102-.6414.2495-.8476L4.8582 9.23H.1922V7.7896h6.7266zm8.5513 8.3548a.4805.4805 0 01-.4803-.4798v-7.875h1.4416v8.3548H15.47zM20.6934 9.6C22.52 9.6 24 11.0807 24 12.9044c0 1.8252-1.4801 3.306-3.3066 3.306-1.8264 0-3.3066-1.4808-3.3066-3.306 0-1.8237 1.4802-3.3044 3.3066-3.3044zm-10.1412 5.253c1.0675 0 1.9324-.8645 1.9324-1.9312 0-1.065-.865-1.9295-1.9324-1.9295s-1.9324.8644-1.9324 1.9295c0 1.0667.865 1.9312 1.9324 1.9312zm10.1412-.0033c1.0737 0 1.945-.8707 1.945-1.9453 0-1.073-.8713-1.9436-1.945-1.9436-1.0753 0-1.945.8706-1.945 1.9436 0 1.0746.8697 1.9453 1.945 1.9453z",source:"https://zalo.me/",hex:"0068FF",guidelines:void 0,license:void 0},siZapier={title:"Zapier",slug:"zapier",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Zapier</title><path d="'+this.path+'"/></svg>'},path:"M15 12.004c0 .893-.165 1.746-.461 2.535-.787.297-1.643.461-2.535.461h-.009c-.893 0-1.745-.165-2.534-.461C9.164 13.75 9 12.896 9 12.004v-.009c0-.893.164-1.745.461-2.534C10.25 9.164 11.103 9 11.995 9h.009c.893 0 1.748.164 2.535.462.297.788.461 1.641.461 2.535v.007zM23.835 10H16.83l4.948-4.952c-.39-.548-.82-1.06-1.295-1.533-.473-.474-.985-.907-1.53-1.296l-4.954 4.949V.165C13.35.061 12.686 0 12.004 0h-.01c-.68 0-1.346.061-1.995.165V7.17l-4.95-4.949c-.549.386-1.06.821-1.534 1.294-.474.474-.908.987-1.296 1.533L7.168 10H.165S0 11.316 0 11.995v.009c0 .68.061 1.348.165 1.995H7.17l-4.949 4.952c.777 1.096 1.733 2.051 2.827 2.83L10 16.831v7.004c.648.105 1.313.165 1.991.165h.017c.679 0 1.344-.06 1.991-.165v-7.004l4.952 4.95c.548-.375 1.06-.812 1.529-1.29h.005c.473-.465.906-.976 1.296-1.531l-4.95-4.949h7.004c.105-.645.165-1.304.165-1.98V12c0-.678-.06-1.343-.165-1.99",source:"https://zapier.com/about/brand",hex:"FF4A00",guidelines:void 0,license:void 0},siZcash={title:"Zcash",slug:"zcash",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Zcash</title><path d="'+this.path+'"/></svg>'},path:"M12 0C5.382 0 0 5.382 0 12s5.382 12 12 12 12-5.382 12-12S18.618 0 12 0zm0 22.02C6.474 22.02 1.98 17.526 1.98 12S6.474 1.98 12 1.98 22.02 6.474 22.02 12 17.526 22.02 12 22.02zm4.28-13.763V6.431h-3.274V4.42h-2.012V6.43H7.72v2.423h5.079l-5.08 6.889v1.826h3.275v2.002h2.012v-2.002h3.275v-2.422H11.2z",source:"https://z.cash/press/",hex:"F4B728",guidelines:"https://www.zfnd.org/about/trademark-policy/",license:void 0},siZdf={title:"ZDF",slug:"zdf",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>ZDF</title><path d="'+this.path+'"/></svg>'},path:"M7.014 4.987A7.02 7.02 0 000 12.005a7.017 7.017 0 0013.271 3.174h2.915c.696 0 1.324-.044 1.962-.553.461-.365.749-.884.883-1.56v2.103h1.336v-2.473h3.153v-1.1h-3.16l.02-.445c.005-.724.226-1.162 1.277-1.162H24V8.876h-2.818c-1.517 0-2.141.85-2.141 2.18v.129c-.254-1.565-1.185-2.31-2.889-2.31h-2.855a7.018 7.018 0 00-6.283-3.888zM8.02 8.876h3.436c1.742 0 1.992 1.219 1.992 1.9 0 .725-.298 1.873-1.992 1.873h-.844c-1.056 0-1.281.38-1.281 1.104v.336h3.945v1.074H7.982v-1.558c0-1.335.625-2.123 2.137-2.123h.873c.691 0 1.1-.14 1.1-.725 0-.605-.409-.772-1.12-.772h-2.95v-1.11zm6.63 1.113h1.472c1.157 0 1.574.496 1.574 2.04 0 1.542-.412 2.036-1.574 2.036H14.65z",source:"https://www.zdf.de/",hex:"FA7D19",guidelines:void 0,license:void 0},siZelle={title:"Zelle",slug:"zelle",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Zelle</title><path d="'+this.path+'"/></svg>'},path:"M13.559 24h-2.841a.483.483 0 0 1-.483-.483v-2.765H5.638a.667.667 0 0 1-.666-.666v-2.234a.67.67 0 0 1 .142-.412l8.139-10.382h-7.25a.667.667 0 0 1-.667-.667V3.914c0-.367.299-.666.666-.666h4.23V.483c0-.266.217-.483.483-.483h2.841c.266 0 .483.217.483.483v2.765h4.323c.367 0 .666.299.666.666v2.137a.67.67 0 0 1-.141.41l-8.19 10.481h7.665c.367 0 .666.299.666.666v2.477a.667.667 0 0 1-.666.667h-4.32v2.765a.483.483 0 0 1-.483.483Z",source:"https://www.zellepay.com/",hex:"6D1ED4",guidelines:void 0,license:void 0},siZend={title:"Zend",slug:"zend",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Zend</title><path d="'+this.path+'"/></svg>'},path:"M24 .467L9.01 20.217H20.54A3.46 3.46 0 0024 16.757V.468zM3.459 3.783C1.585 3.783 0 5.153 0 7.1v16.433l15.063-19.75H3.459Z",source:"https://www.zend.com/",hex:"0679EA",guidelines:void 0,license:void 0},siZendesk={title:"Zendesk",slug:"zendesk",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Zendesk</title><path d="'+this.path+'"/></svg>'},path:"M12.914 2.904V16.29L24 2.905H12.914zM0 2.906C0 5.966 2.483 8.45 5.543 8.45s5.542-2.484 5.543-5.544H0zm11.086 4.807L0 21.096h11.086V7.713zm7.37 7.84c-3.063 0-5.542 2.48-5.542 5.543H24c0-3.06-2.48-5.543-5.543-5.543z",source:"https://brandland.zendesk.com/",hex:"03363D",guidelines:void 0,license:void 0},siZenn={title:"Zenn",slug:"zenn",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Zenn</title><path d="'+this.path+'"/></svg>'},path:"M.264 23.771h4.984c.264 0 .498-.147.645-.352L19.614.874c.176-.293-.029-.645-.381-.645h-4.72c-.235 0-.44.117-.557.323L.03 23.361c-.088.176.029.41.234.41zM17.445 23.419l6.479-10.408c.205-.323-.029-.733-.41-.733h-4.691c-.176 0-.352.088-.44.235l-6.655 10.643c-.176.264.029.616.352.616h4.779c.234-.001.468-.118.586-.353z",source:"https://zenn.dev/mediakit",hex:"3EA8FF",guidelines:void 0,license:void 0},siZenodo={title:"Zenodo",slug:"zenodo",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Zenodo</title><path d="'+this.path+'"/></svg>'},path:"M23.82698 11.163a2.2419 2.2419 0 00-.46698-.68697 2.1499 2.1499 0 00-1.52393-.62697 2.10991 2.10991 0 00-1.20695.36499 2.2469 2.2469 0 00-.49498.45398c-.06.075-.125.17499-.163.23599a2.68689 2.68689 0 00-.20498.46398c.006-.27.046-.67197.20499-.89797V8.52212a.42698.42698 0 00-.137-.32199.44298.44298 0 00-.31698-.132.43998.43998 0 00-.32299.132.43998.43998 0 00-.13.32199v1.73292a2.3699 2.3699 0 00-.59197-.29898 2.1239 2.1239 0 00-1.49994.06 2.1599 2.1599 0 00-1.15295 1.14695l-.024.06a2.2419 2.2419 0 00-.48997-.74697 2.1529 2.1529 0 00-1.52394-.62698 2.10991 2.10991 0 00-.84296.167 2.2299 2.2299 0 00-.68697.45998 2.10591 2.10591 0 00-.46598.68697l-.023.056-.023-.056a2.1549 2.1549 0 00-1.98992-1.31395c-.30098 0-.58197.056-.84196.167a2.2299 2.2299 0 00-.68597.45998c-.2.19599-.35499.42398-.46698.68697l-.02.053-.022-.053a2.2429 2.2429 0 00-.46698-.68698 2.1479 2.1479 0 00-1.52293-.62697 2.10991 2.10991 0 00-.84197.167 2.2289 2.2289 0 00-.64197.41798v-.072a.46298.46298 0 00-.46198-.46298H.53398a.46298.46298 0 000 .92596h2.54889L.091 14.84985a.46198.46198 0 00-.091.27499v.30198c0 .256.207.46298.46298.46298h3.44985a.46198.46198 0 00.46198-.42998 2.1689 2.1689 0 001.34695.47198c.44598 0 .84396-.12 1.19494-.35998.283-.192.50698-.43098.66998-.71997v.62597c0 .127.043.235.13.32199a.43598.43598 0 00.32398.132c.12 0 .22399-.044.31598-.132a.42698.42698 0 00.138-.32199V13.8579h-.002l.002-.003H7.36069a.43998.43998 0 00-.41799.28699l-.074.152a1.23395 1.23395 0 01-.45997.53197 1.23395 1.23395 0 01-.68697.197c-.168 0-.32999-.031-.48498-.095a1.17495 1.17495 0 01-.39999-.27 1.38194 1.38194 0 01-.26998-.39998 1.16495 1.16495 0 01-.1-.47698v-.40598h4.02783v-1.37494a1.23695 1.23695 0 01.36498-.87796 1.23995 1.23995 0 01.88996-.36499c.167 0 .32899.032.48398.095.155.065.289.154.39999.27.112.11499.19999.24898.26898.39997.067.151.102.311.102.47798v3.47686c0 .12799.043.23599.13.32298a.43798.43798 0 00.32398.132c.12 0 .224-.044.31599-.132a.43098.43098 0 00.137-.32299v-.62297a2.1439 2.1439 0 001.86791 1.07795c.29399 0 .57398-.056.83697-.168.26199-.11099.49298-.26398.69297-.45997a2.11191 2.11191 0 00.48398-.73297l.018.047c.111.26199.26699.48998.46598.68697.19999.195.42798.34799.68697.45998.25799.11.53997.167.84296.167a2.1469 2.1469 0 001.52294-.62698c.19499-.196.35098-.42498.46698-.68697l.024-.06.024.06c.115.26199.26998.48998.46598.68697a2.1439 2.1439 0 001.52393.62697c.29398 0 .57397-.056.83696-.168a2.2199 2.2199 0 00.69297-.45997 2.11691 2.11691 0 00.63498-1.52194v-1.78192a2.07991 2.07991 0 00-.173-.83696zM1.15995 14.96485l2.4199-3.25886c-.012.096-.02.194-.02.29399v1.77992c0 .296.058.57398.174.83797.05399.123.11799.23899.18998.34698zm5.81775-2.49989H4.4678v-.46498a1.24195 1.24195 0 01.76498-1.14695c.15199-.064.31498-.096.48998-.096.16799 0 .32998.032.48398.095.15599.065.28998.154.39998.26999.112.115.19999.24899.26999.39998.068.151.1.31099.1.47798zm8.05766 1.31594a1.24895 1.24895 0 01-1.25395 1.24295c-.168 0-.32898-.032-.48498-.096a1.16795 1.16795 0 01-.39998-.26999 1.37594 1.37594 0 01-.26899-.39998 1.15895 1.15895 0 01-.1-.47698v-1.78092a1.23995 1.23995 0 011.25495-1.24295c.16599 0 .32798.032.48198.095.15599.065.28998.154.39998.26999.112.115.201.24899.26999.39998.067.152.101.31099.101.47798zm4.02783 0c0 .167-.033.32599-.1.47798a1.37994 1.37994 0 01-.27.39999 1.15995 1.15995 0 01-.39998.26998 1.25995 1.25995 0 01-.48397.094 1.23195 1.23195 0 01-.88997-.36398 1.24195 1.24195 0 01-.36598-.87796v-1.78093c0-.16699.035-.32598.102-.47798a1.39994 1.39994 0 01.26998-.39998 1.15995 1.15995 0 01.39999-.26999 1.26995 1.26995 0 01.48398-.095 1.24995 1.24995 0 01.88996.36499 1.24995 1.24995 0 01.36398.87796zm4.02782 0a1.22395 1.22395 0 01-.36398.87797c-.116.116-.24999.20499-.39998.26998a1.24995 1.24995 0 01-.48998.094 1.26995 1.26995 0 01-.48498-.095 1.16895 1.16895 0 01-.39999-.26998 1.37994 1.37994 0 01-.26998-.39999 1.15695 1.15695 0 01-.1-.47698v-1.78092a1.23995 1.23995 0 011.25494-1.24295c.167 0 .32799.032.48298.095.156.065.29.154.39999.27.112.11499.20099.24898.26998.39997.067.152.1.311.1.47798v1.77993z",source:"https://about.zenodo.org",hex:"1682D4",guidelines:"https://about.zenodo.org",license:void 0},siZerodha={title:"Zerodha",slug:"zerodha",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Zerodha</title><path d="'+this.path+'"/></svg>'},path:"M20.378 5.835A27.267 27.267 0 0124 12.169V0H13.666c2.486 1.343 4.763 3.308 6.712 5.835zM5.48 1.297c-1.914 0-3.755.409-5.48 1.166V24h22.944C22.766 11.44 15 1.297 5.48 1.297z",source:"https://zerodha.com",hex:"387ED1",guidelines:void 0,license:void 0},siZeromq={title:"ZeroMQ",slug:"zeromq",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>ZeroMQ</title><path d="'+this.path+'"/></svg>'},path:"M22.088,5.499l1.894-1.894l-3.587-3.587l-1.894,1.894C16.627,0.702,14.396,0,12,0C5.373,0,0,5.373,0,12c0,2.396,0.702,4.627,1.912,6.501l-1.894,1.894l3.587,3.587l1.894-1.894C7.373,23.298,9.604,24,12,24c6.627,0,12-5.373,12-12C24,9.604,23.298,7.373,22.088,5.499z M4.569,12c0-4.104,3.327-7.431,7.431-7.431c1.125,0,2.191,0.25,3.146,0.698l-9.88,9.88C4.819,14.191,4.569,13.125,4.569,12z M12,19.431c-1.125,0-2.191-0.25-3.146-0.698l9.88-9.88c0.447,0.956,0.698,2.022,0.698,3.146C19.431,16.104,16.104,19.431,12,19.431z",source:"https://github.com/zeromq/zeromq.org/blob/master/static/safari-pinned-tab.svg",hex:"DF0000",guidelines:void 0,license:void 0},siZerply={title:"Zerply",slug:"zerply",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Zerply</title><path d="'+this.path+'"/></svg>'},path:"M20.779 18.746c-.747.714-1.562 1.017-2.543 1.017-1.32 0-3.322-.61-4.846-1.66-1.629-1.119-3.765-2.237-5.562-2.271 1.323-1.798 3.39-3.628 5.322-5.798.713-.78 4.983-5.7 5.73-6.586.54-.645.813-1.424.813-2.205 0-.3-.033-.585-.101-.855-2.035.405-3.561.601-6.001.601-2.677.015-4.607-.314-5.73-.989-.78 1.018-1.56 2.373-1.56 3.12 0 .948.918 1.728 3.189 1.728.746 0 1.965-.034 3.66-.169-3.492 4.5-6.949 8.16-9.016 10.47-.713.781-1.121 1.83-1.121 2.881 0 .405.075.81.18 1.185.645-.104 1.291-.179 1.965-.179 1.395 0 2.79.299 4.081.839C11.805 21.014 14.205 24 16.921 24c2.204 0 4.065-1.741 4.065-4.036 0-.404-.061-.825-.195-1.229l-.012.011z",source:"https://zerply.com/about/resources",hex:"7BBB6E",guidelines:void 0,license:void 0},siZhihu={title:"Zhihu",slug:"zhihu",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Zhihu</title><path d="'+this.path+'"/></svg>'},path:"M5.721 0C2.251 0 0 2.25 0 5.719V18.28C0 21.751 2.252 24 5.721 24h12.56C21.751 24 24 21.75 24 18.281V5.72C24 2.249 21.75 0 18.281 0zm1.964 4.078c-.271.73-.5 1.434-.68 2.11h4.587c.545-.006.445 1.168.445 1.171H9.384a58.104 58.104 0 01-.112 3.797h2.712c.388.023.393 1.251.393 1.266H9.183a9.223 9.223 0 01-.408 2.102l.757-.604c.452.456 1.512 1.712 1.906 2.177.473.681.063 2.081.063 2.081l-2.794-3.382c-.653 2.518-1.845 3.607-1.845 3.607-.523.468-1.58.82-2.64.516 2.218-1.73 3.44-3.917 3.667-6.497H4.491c0-.015.197-1.243.806-1.266h2.71c.024-.32.086-3.254.086-3.797H6.598c-.136.406-.158.447-.268.753-.594 1.095-1.603 1.122-1.907 1.155.906-1.821 1.416-3.6 1.591-4.064.425-1.124 1.671-1.125 1.671-1.125zM13.078 6h6.377v11.33h-2.573l-2.184 1.373-.401-1.373h-1.219zm1.313 1.219v8.86h.623l.263.937 1.455-.938h1.456v-8.86z",source:"https://www.zhihu.com/",hex:"0084FF",guidelines:void 0,license:void 0},siZig={title:"Zig",slug:"zig",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Zig</title><path d="'+this.path+'"/></svg>'},path:"m23.53 1.02-7.686 3.45h-7.06l-2.98 3.452h7.173L.47 22.98l7.681-3.607h7.065v-.002l2.978-3.45-7.148-.001 12.482-14.9zM0 4.47v14.901h1.883l2.98-3.45H3.451v-8h.942l2.824-3.45H0zm22.117 0-2.98 3.608h1.412v7.844h-.942l-2.98 3.45H24V4.47h-1.883z",source:"https://github.com/ziglang/logo",hex:"F7A41D",guidelines:void 0,license:{type:"CC-BY-SA-4.0",url:"https://spdx.org/licenses/CC-BY-SA-4.0"}},siZigbee={title:"Zigbee",slug:"zigbee",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Zigbee</title><path d="'+this.path+'"/></svg>'},path:"M11.988 0a11.85 11.85 0 00-8.617 3.696c7.02-.875 11.401-.583 13.289-.34 3.752.583 3.558 3.404 3.558 3.404L8.237 19.112c2.299.22 6.897.366 13.796-.631a11.86 11.86 0 001.912-6.469C23.945 5.374 18.595 0 11.988 0zm.232 4.31c-2.451-.014-5.772.146-9.963.723C.854 7.003.055 9.41.055 12.012.055 18.626 5.38 24 11.988 24c3.63 0 6.85-1.63 9.053-4.182-7.286.948-11.813.631-13.75.388-3.775-.56-3.557-3.404-3.557-3.404L15.691 4.474a38.635 38.635 0 00-3.471-.163Z",source:"https://zigbeealliance.org/solution/zigbee/",hex:"EB0443",guidelines:void 0,license:void 0},siZillow={title:"Zillow",slug:"zillow",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Zillow</title><path d="'+this.path+'"/></svg>'},path:"M12.006 0L1.086 8.627v3.868c3.386-2.013 11.219-5.13 14.763-6.015.11-.024.16.005.227.078.372.427 1.586 1.899 1.916 2.301a.128.128 0 0 1-.03.195 43.607 43.607 0 0 0-6.67 6.527c-.03.037-.006.043.012.03 2.642-1.134 8.828-2.94 11.622-3.452V8.627zm-.48 11.177c-2.136.708-8.195 3.307-10.452 4.576V24h21.852v-7.936c-2.99.506-11.902 3.16-15.959 5.246a.183.183 0 0 1-.23-.036l-2.044-2.429c-.055-.061-.062-.098.011-.208 1.574-2.3 4.789-5.899 6.833-7.418.042-.03.031-.06-.012-.042Z",source:"https://www.zillow.com/",hex:"006AFF",guidelines:void 0,license:void 0},siZingat={title:"Zingat",slug:"zingat",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Zingat</title><path d="'+this.path+'"/></svg>'},path:"M12.271.006A8.584 8.584 0 009.906.25a8.705 8.705 0 00-4.83 3.059 8.377 8.377 0 00-1.85 4.556 6.2 6.2 0 00.159 2.168 15.04 15.04 0 001.053 2.748 38.762 38.762 0 002.498 4.336A82.576 82.576 0 0011.994 24l.067-.074c.456-.574.923-1.14 1.363-1.725.789-1.048 1.562-2.11 2.34-3.168a1 1 0 00.21-.756.973.973 0 00-1.195-.802c-.307.077-.5.286-.675.527-.547.753-1.095 1.505-1.647 2.256-.147.2-.301.393-.488.553a64.17 64.17 0 01-4.38-6.356c-.763-1.28-1.47-2.589-2.007-3.98a8.079 8.079 0 01-.334-1.006c-.105-.44-.096-.892-.068-1.344a5.144 5.144 0 01.328-1.643c.244-.604.507-1.195.9-1.712a6.947 6.947 0 012.65-2.165c.788-.36 1.596-.62 2.47-.62a17.886 17.886 0 011.349.03 4.389 4.389 0 01.943.167c1.486.448 2.742 1.256 3.696 2.494a6.771 6.771 0 01.925 1.709 6.83 6.83 0 01.276.885 4.903 4.903 0 01.086.677c.044.494.063.99-.047 1.477-.079.324-.18.641-.305.951-.133.359-.281.71-.437 1.059V9.793a.835.835 0 00-.184-.56 2.57 2.57 0 00-.394-.354c-1.62-1.23-3.238-2.46-4.858-3.688a.964.964 0 00-1.168.006c-.212.161-.422.325-.633.487l-1.273.972V5.74c-.001-.088-.013-.175-.035-.261a.982.982 0 10-1.932.26V8.06a.169.169 0 01-.074.152c-.194.14-.379.284-.563.428l-.025.02a.98.98 0 00-.148 1.376c.339.422.956.49 1.378.152l3.825-2.92.006-.005a.102.102 0 01.144.006l2.268 1.734c.52.397 1.039.8 1.564 1.19a.293.293 0 01.135.275v4.83c0 .02.003.039.004.058a.97.97 0 00.01.123.97.97 0 000 .002c0 .007 0 .013.002.02a.981.981 0 00.015.072.981.981 0 00.028.094.981.981 0 00.037.09.981.981 0 001.8-.045l.03-.043c.314-.54.635-1.076.937-1.627.597-1.084 1.132-2.196 1.518-3.375a6.706 6.706 0 00.375-1.855 8 8 0 00-.338-2.561 8.497 8.497 0 00-2.943-4.338C15.986.7 14.227.076 12.272.006zM11.178 10.21a1.022 1.022 0 00-.996 1.047v1.615a1.024 1.024 0 001.039 1.002h1.61a1.02 1.02 0 001.019-1.023v-1.618a1.024 1.024 0 00-1.018-1.021h-.81v-.002zm.072.957h1.54c.074 0 .1.03.1.103v.778l.003.006c0 .248-.009.497 0 .74 0 .084-.026.115-.112.115h-1.529c-.08 0-.107-.027-.107-.107v-1.526c0-.077.023-.109.105-.109z",source:"https://www.zingat.com/kurumsal-logolar",hex:"009CFB",guidelines:void 0,license:void 0},siZoho={title:"Zoho",slug:"zoho",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Zoho</title><path d="'+this.path+'"/></svg>'},path:"M19.838 14.351c-.203-.244-.306-.579-.306-1.009 0-.438.103-.779.305-1.024.202-.246.477-.368.833-.368.353 0 .625.122.828.368.202.245.305.586.305 1.024 0 .428-.103.763-.305 1.008-.203.244-.475.366-.828.366-.354 0-.628-.121-.832-.365zm-1.556-3.727h4.932v5.307h-4.932v-1.163l.148-.414a.17.17 0 0 0 .01-.084l-.158-1.214v-2.432zm.318 2.717c0 .307.051.593.155.857.104.265.257.503.46.713.19.196.408.345.652.445.245.1.513.15.804.15.28 0 .544-.05.788-.15.244-.1.465-.249.661-.445.205-.21.36-.447.465-.711.105-.264.157-.55.157-.859 0-.308-.052-.594-.157-.857a2.11 2.11 0 0 0-.465-.707c-.196-.2-.416-.35-.66-.452a2.037 2.037 0 0 0-.79-.152 1.953 1.953 0 0 0-1.456.604 2.044 2.044 0 0 0-.46.704 2.34 2.34 0 0 0-.154.86zm4.97-2.828v5.166l.43-.43v-5.233l-.43.497zm-4.56-.791l-.502.547h4.802l.478-.552-4.777.005zm-1.992.432l.303-.87-4.8.669-.063.21.15.593 4.41-.602zm.314.18l.239 1.682.374 2.637.136-.38-.576-4.436-.173.497zm-5.068 1.149l.097.043-1.935 4.391-4.28-1.93L8.08 9.596l4.184 1.886zm-.923 1.104c0-.262-.046-.518-.139-.77-.098-.266-.237-.495-.418-.685s-.4-.341-.658-.45a1.969 1.969 0 0 0-.776-.163h-.012a1.93 1.93 0 0 0-.784.176c-.27.117-.505.282-.704.493-.2.21-.362.464-.488.76a2.516 2.516 0 0 0-.207.976c0 .258.044.51.132.758a1.89 1.89 0 0 0 1.087 1.13c.253.108.511.162.772.162h.007c.263-.002.524-.058.782-.169a2.23 2.23 0 0 0 .711-.499c.202-.21.365-.464.49-.758a2.48 2.48 0 0 0 .205-.961zm5.993.29l.335 2.36-4.777.671-.505-3.56.37-.84c.002-.002 0-.005 0-.007a.175.175 0 0 0 .01-.108l-.072-.29 4.303-.587.336 2.36zm-.543 1.97a.874.874 0 0 0-.01-.127l-.504-3.432c-.023-.158-.077-.278-.164-.357a.37.37 0 0 0-.256-.094.537.537 0 0 0-.079.006.398.398 0 0 0-.297.182.494.494 0 0 0-.068.265c0 .039.003.08.01.123l.187 1.32-1.475.217-.187-1.32a.586.586 0 0 0-.162-.353.359.359 0 0 0-.253-.1.496.496 0 0 0-.071.006.418.418 0 0 0-.309.18.48.48 0 0 0-.069.266.8.8 0 0 0 .01.126l.505 3.433c.023.158.078.278.169.355.07.061.16.092.26.091a.59.59 0 0 0 .087-.006.375.375 0 0 0 .284-.182.504.504 0 0 0 .063-.258.851.851 0 0 0-.01-.125l-.206-1.357 1.475-.216.206 1.356a.56.56 0 0 0 .167.353.38.38 0 0 0 .259.094.525.525 0 0 0 .079-.006.392.392 0 0 0 .294-.18.492.492 0 0 0 .065-.26zm-4.458-3.724l-.277-1.103-4.262-1.95.343 1.161 4.196 1.893zM7.8 9.348l-.319-1.076-1.509 3.582.184 1.226L7.8 9.348zm2.01 2.072a1.12 1.12 0 0 0-.438-.096.957.957 0 0 0-.469.125c-.283.157-.515.442-.693.86a1.942 1.942 0 0 0-.173.752c0 .116.015.226.044.33.087.312.288.532.61.67.149.063.293.094.433.094a.962.962 0 0 0 .469-.124c.283-.156.512-.436.686-.845a2 2 0 0 0 .178-.772c0-.113-.014-.221-.042-.323-.085-.313-.284-.534-.604-.67zm-4.83.322l.518 3.41-4.739.742L0 11.245l3.912-.599.882-.135.187 1.231zm-.5 3.024a.485.485 0 0 0-.007-.084.365.365 0 0 0-.078-.177.357.357 0 0 0-.16-.106.75.75 0 0 0-.246-.035c-.09 0-.194.01-.311.03l-1.343.23c.014-.104.065-.24.156-.406a5.35 5.35 0 0 1 .448-.668l.155-.208c.025-.031.061-.078.107-.14.308-.403.498-.731.57-.989a2.07 2.07 0 0 0 .08-.562c0-.106-.008-.21-.026-.314a.855.855 0 0 0-.07-.234.331.331 0 0 0-.118-.14.451.451 0 0 0-.233-.048c-.083 0-.182.01-.299.03l-1.552.266c-.188.032-.327.088-.416.17a.33.33 0 0 0-.106.25.44.44 0 0 0 .007.08c.022.132.09.229.201.278a.57.57 0 0 0 .237.044c.063 0 .132-.007.207-.02l1.3-.219a.695.695 0 0 1-.038.307c-.04.108-.136.261-.29.457l-.2.249c-.35.424-.6.786-.753 1.087a2.35 2.35 0 0 0-.223.613 1.69 1.69 0 0 0-.036.337c0 .078.006.152.018.225a.92.92 0 0 0 .078.257.337.337 0 0 0 .133.148c.05.028.125.039.228.04.13 0 .305-.02.526-.058l1.409-.24c.25-.044.423-.103.523-.186a.327.327 0 0 0 .122-.264zm.663-4.563l-.02.109.599 3.944.14-.73L5.27 9.55l-.125.654zM5.07 8.706L.303 9.47.02 10.883l4.772-.73.277-1.446z",source:"https://www.zoho.com/branding/",hex:"C8202B",guidelines:void 0,license:void 0},siZoiper={title:"Zoiper",slug:"zoiper",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Zoiper</title><path d="'+this.path+'"/></svg>'},path:"M3.3751 13.0786c-.8624-.8624-.8624-2.9256-.0748-3.7131s3.2625-3.225 5.0621-5.0247c1.8004-1.7996 3.3755-2.0624 3.8629-2.0624H15.9c.2223 0 .5527.0322.9236.0884l-1.087 2.1664c-.8738-.0629-1.6811-.0422-2.274-.0422-2.4374 0-2.6254.5622-3.0378.9747-.4125.4125-5.0621 4.8375-5.3997 5.1752-1.0504 1.0503.5621 1.5376 2.3252 1.5376.7875 0 .8998.825.7119 1.5751-.1018.4079-.3684 1.43-.5919 2.5285h-2.139c.0834-.4237.1648-.7712.2184-.954.188-.637.2253-1.2-.1497-1.2s-1.1626-.1871-2.0249-1.0495zm18.0425-9.9195c-.1965-.1965-2.184-1.3497-2.7726-1.6201-.1614-.0739-.2993-.1047-.4172-.1047-.3126 0-.4853.2162-.5872.4193l-3.1179 6.2136c-1.564.4473-2.7104 1.8872-2.7104 3.595 0 1.4355.8088 2.6815 1.996 3.3091-.4575.5435-1.1337 1.1005-1.2919 1.2851-.2254.2628-.7875.5256-1.763.5256H4.3672c-.0298-1.1804-.9951-2.1287-2.1832-2.1287-1.206 0-2.184.978-2.184 2.184 0 1.2068.978 2.1849 2.184 2.1849.9185 0 1.7036-.5664 2.0267-1.3693h7.0394c.9747 0 1.5377-.262 1.7622-.5248.2134-.2491 1.3658-1.1728 1.6584-1.8311.2824.0689.5784.1063.8828.1063 2.0659 0 3.7404-1.6746 3.7404-3.7412a3.7288 3.7288 0 0 0-.5316-1.9221 7006.5352 7006.5352 0 0 1 2.753-5.5502c.2705-.5399.0988-.8342-.0977-1.0307zm.2867 1.7742c-.2377.4786-.6018 1.2128-.993 2.0014.697 1.0061 1.1516 2.4119 1.1516 4.4188 0 5.0995-2.7003 5.6625-3.2625 5.6625h-2.1381c-.4499 0-.7875.0748-1.6125.8998-.825.825-1.9875 1.837-2.3252 2.1746-.3368.3376-.825.563-1.6873.563h-2.662c-.3751 0-1.0503-.188-1.0503-1.7631 0-.221.0212-.4749.0488-.7374H5.0591c-.0581.6409-.0749 1.2776.0034 1.7872.2253 1.4628 1.4254 2.6254 2.4374 2.6254h3.9752c1.8378 0 5.2126-3.4121 5.2126-3.4121s1.1073.0681 1.763.0502C20.4875 19.1485 24 17.4662 24 11.8412c0-3.3144-.9952-5.4775-2.2957-6.9079z",source:"https://www.zoiper.com/en/products",hex:"F47920",guidelines:void 0,license:void 0},siZoom={title:"Zoom",slug:"zoom",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Zoom</title><path d="'+this.path+'"/></svg>'},path:"M4.585 13.607l-.27-.012H1.886l3.236-3.237-.013-.27a.815.815 0 00-.796-.796l-.27-.013H0l.014.27c.034.438.353.77.794.796l.27.013h2.43L.268 13.595l.014.269c.015.433.362.78.795.796l.27.013h4.046l-.014-.27c-.036-.443-.35-.767-.795-.795zm3.238-4.328h-.004a2.696 2.697 0 10.003 0zm1.141 3.841a1.619 1.619 0 11-2.289-2.288 1.619 1.619 0 012.289 2.288zM21.84 9.28a2.158 2.158 0 00-1.615.73 2.153 2.153 0 00-1.619-.732 2.148 2.148 0 00-1.208.37c-.21-.233-.68-.37-.949-.37v5.395l.27-.013c.45-.03.778-.349.796-.796l.013-.27v-1.889l.014-.27c.01-.202.04-.382.132-.54a1.078 1.079 0 011.473-.393 1.078 1.079 0 01.393.392c.093.16.12.34.132.54l.014.271v1.889l.013.269a.83.83 0 00.795.796l.27.013v-2.967l.012-.27c.01-.2.04-.384.134-.543.3-.514.96-.69 1.473-.39a1.078 1.079 0 01.393.393c.092.16.12.343.13.54l.015.27v1.889l.013.269c.028.443.35.77.796.796l.27.013v-3.237a2.158 2.158 0 00-2.16-2.156zm-10.263.788a2.697 2.698 0 103.811 3.816 2.697 2.698 0 00-3.811-3.816zm3.05 3.052a1.619 1.619 0 11-2.289-2.29 1.619 1.619 0 012.289 2.29z",source:"https://zoom.us/brandguidelines",hex:"2D8CFF",guidelines:void 0,license:void 0},siZorin={title:"Zorin",slug:"zorin",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Zorin</title><path d="'+this.path+'"/></svg>'},path:"M4 18.944L5.995 22.4h12.01L20 18.944H4zM24 12l-2.013 3.488H9.216l12.771-6.976L24 12zM0 12l2.013-3.488h12.771L2.013 15.488 0 12zm4-6.944L5.995 1.6h12.01L20 5.056H4z",source:"https://zorinos.com/press/",hex:"0CC1F3",guidelines:void 0,license:void 0},siIfixit={title:"iFixit",slug:"ifixit",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>iFixit</title><path d="'+this.path+'"/></svg>'},path:"M15.345 12.506l2.37 3.131c.198.261.211.69.025.961l-.119.177c-.181.27-.55.645-.814.831l-.285.201c-.266.195-.697.195-.956-.016l-3.135-2.369c-.255-.195-.681-.195-.94 0l-3.136 2.369c-.258.211-.689.211-.956.03l-.207-.135c-.27-.181-.641-.556-.825-.81l-.181-.256c-.186-.27-.18-.689.018-.96l2.377-3.149c.195-.256.195-.675 0-.945L6.197 8.43c-.194-.263-.203-.69-.013-.957l.2-.285c.187-.264.56-.629.828-.814l.175-.119c.27-.196.703-.182.961.014l3.135 2.37c.26.195.684.195.942 0l3.135-2.385c.258-.195.698-.226.979-.061l.33.195c.28.165.639.524.795.81l.12.21c.154.285.123.721-.075.99l-2.37 3.135c-.194.255-.194.676 0 .945l.006.028zM12 0C5.37 0 0 5.373 0 12s5.37 12 12 12c6.627 0 12-5.373 12-12S18.627 0 12 0z",source:"https://www.ifixit.com/",hex:"0071CE",guidelines:"https://www.ifixit.com/Info/Media",license:void 0},siIfood={title:"iFood",slug:"ifood",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>iFood</title><path d="'+this.path+'"/></svg>'},path:"M8.428 1.67c-4.65 0-7.184 4.149-7.184 6.998 0 2.294 2.2 3.299 4.25 3.299l-.006-.006c4.244 0 7.184-3.854 7.184-6.998 0-2.29-2.175-3.293-4.244-3.293zm11.328 0c-4.65 0-7.184 4.149-7.184 6.998 0 2.294 2.2 3.299 4.25 3.299l-.006-.006C21.061 11.96 24 8.107 24 4.963c0-2.29-2.18-3.293-4.244-3.293zM14.172 14.52l2.435 1.834c-2.17 2.07-6.124 3.525-9.353 3.17A8.913 8.913 0 01.23 14.541H0a9.598 9.598 0 008.828 7.758c3.814.24 7.323-.905 9.947-3.13l-.004.007 1.08 2.988 1.555-7.623-7.234-.02Z",source:"https://ifood.com.br/",hex:"EA1D2C",guidelines:void 0,license:void 0},siIfttt={title:"IFTTT",slug:"ifttt",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>IFTTT</title><path d="'+this.path+'"/></svg>'},path:"M0 8.82h2.024v6.36H0zm11.566 0h-3.47v2.024h1.446v4.337h2.024v-4.337h1.446V8.82zm5.494 0h-3.47v2.024h1.446v4.337h2.024v-4.337h1.446V8.82zm5.494 0h-3.47v2.024h1.446v4.337h2.024v-4.337H24V8.82zM7.518 10.843V8.82H2.892v6.36h2.024v-1.734H6.65v-2.024H4.916v-.578z",source:"https://ifttt.com/discover/brand-guidelines",hex:"000000",guidelines:"https://ifttt.com/discover/brand-guidelines",license:void 0},siIheartradio={title:"iHeartRadio",slug:"iheartradio",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>iHeartRadio</title><path d="'+this.path+'"/></svg>'},path:"M4.403 21.983c.597 0 1.023-.306 1.023-.817v-.012c0-.489-.375-.784-1.017-.784H3.182v1.613zm-1.67-1.8c0-.125.102-.228.221-.228h1.489c.488 0 .88.148 1.13.398.193.193.307.472.307.784v.011c0 .654-.443 1.034-1.062 1.154l.988 1.272c.046.051.074.102.074.164 0 .12-.114.222-.227.222-.091 0-.16-.05-.21-.12l-1.12-1.453H3.183v1.346a.228.228 0 01-.228.227.227.227 0 01-.221-.227v-3.55m6.674 2.29l-.914-2.035-.915 2.034zm-2.812 1.164l1.614-3.528c.056-.125.142-.2.284-.2h.022c.137 0 .228.075.279.2l1.613 3.522a.31.31 0 01.029.113c0 .12-.097.216-.216.216-.108 0-.182-.074-.222-.165l-.415-.914H7.402l-.415.926c-.04.097-.113.153-.216.153a.204.204 0 01-.204-.204.26.26 0 01.028-.12m6.078-.118c1.005 0 1.647-.682 1.647-1.563v-.011c0-.88-.642-1.574-1.647-1.574h-.932v3.148zm-1.38-3.335c0-.125.102-.228.221-.228h1.16c1.249 0 2.112.858 2.112 1.977v.012c0 1.119-.863 1.988-2.113 1.988h-1.159a.226.226 0 01-.221-.227v-3.522m4.481-.029c0-.124.103-.227.222-.227.125 0 .227.103.227.227v3.579a.228.228 0 01-.227.227.227.227 0 01-.222-.227v-3.579m5.027 1.801v-.011c0-.904-.659-1.642-1.568-1.642s-1.556.727-1.556 1.63v.012c0 .903.659 1.642 1.567 1.642.91 0 1.557-.728 1.557-1.631zm-3.59 0v-.011c0-1.097.824-2.057 2.033-2.057 1.21 0 2.023.949 2.023 2.045v.012c0 1.096-.824 2.056-2.034 2.056s-2.022-.949-2.022-2.045m2.03-17.192c0 1.397-.754 2.773-2.242 4.092a.345.345 0 01-.458-.517c1.333-1.182 2.01-2.385 2.01-3.575v-.016c0-.966-.606-2.103-1.38-2.588a.345.345 0 11.367-.586c.97.61 1.703 1.974 1.703 3.174zM14.76 7.677a.345.345 0 11-.337-.602c.799-.448 1.336-1.318 1.339-2.167a2.096 2.096 0 00-1.124-1.855.345.345 0 11.321-.611 2.785 2.785 0 011.493 2.46v.011c-.004 1.09-.683 2.199-1.692 2.764zm-2.772-1.015a1.498 1.498 0 11.001-2.997 1.498 1.498 0 01-.001 2.997zm-2.303.882a.345.345 0 01-.47.133c-1.009-.565-1.688-1.674-1.692-2.764v-.01a2.785 2.785 0 011.493-2.461.346.346 0 01.321.611 2.096 2.096 0 00-1.124 1.855c.003.849.54 1.719 1.34 2.166a.345.345 0 01.132.47zM7.464 8.825a.344.344 0 01-.488.03C5.49 7.536 4.734 6.16 4.734 4.763v-.016c0-1.2.732-2.564 1.703-3.174a.346.346 0 01.367.586c-.774.485-1.38 1.622-1.38 2.588v.016c0 1.19.677 2.393 2.01 3.575a.345.345 0 01.03.487zM16.152 0c-1.727 0-3.27.915-4.164 2.252C11.094.915 9.55 0 7.823 0A4.982 4.982 0 002.84 4.983c0 1.746 1.106 3.005 2.261 4.17l4.518 4.272a.371.371 0 00.626-.27V9.827c0-.963.78-1.743 1.743-1.745a1.745 1.745 0 011.742 1.745v3.328c0 .326.39.493.626.27l4.518-4.272c1.155-1.165 2.261-2.424 2.261-4.17A4.982 4.982 0 0016.152 0M4.582 14.766h1.194v1.612h1.532v-1.612H8.5v4.307H7.308v-1.637H5.776v1.637H4.582v-4.307m6.527 2.353a.563.563 0 00-.578-.587c-.308 0-.55.238-.578.587zm-2.264.305v-.012c0-.972.696-1.741 1.68-1.741 1.15 0 1.68.842 1.68 1.82 0 .075 0 .16-.007.24H9.971c.093.364.357.549.72.549.277 0 .498-.105.738-.34l.647.536c-.32.406-.782.677-1.447.677-1.045 0-1.784-.695-1.784-1.729m7.29-1.68h1.17v.67c.19-.454.498-.75 1.051-.725v1.23h-.098c-.609 0-.954.351-.954 1.12v1.034h-1.168v-3.329m2.95 2.295v-1.353h-.393v-.942h.393v-.842h1.17v.842h.775v.942h-.775v1.126c0 .234.105.332.32.332.153 0 .301-.043.442-.11v.916c-.209.117-.485.19-.812.19-.7 0-1.12-.307-1.12-1.1m-15.65-3.584a.62.62 0 100 1.24.62.62 0 000-1.24m10.502 3.952c-.303.013-.483-.161-.483-.371 0-.203.16-.307.454-.307h.667v.036c-.004.137-.06.617-.638.642zm1.746-1.008c0-1.033-.739-1.729-1.784-1.729-.665 0-1.126.271-1.447.677l.647.536c.24-.234.461-.34.738-.34.359 0 .621.182.716.537l.001.025-.77.003c-.956.013-1.458.37-1.458 1.045 0 .65.464.999 1.262.999.432 0 .764-.17.987-.401v.32h1.106v-1.628l.002-.032V17.4M3.458 15.99h-.043a.61.61 0 00-.61.61v2.474h1.263v-2.474a.61.61 0 00-.61-.61",source:"https://brand.iheart.com/logo",hex:"C6002B",guidelines:"https://brand.iheart.com/logo",license:void 0},siIkea={title:"IKEA",slug:"ikea",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>IKEA</title><path d="'+this.path+'"/></svg>'},path:"M0 7.2v9.6h24V7.2H0zm12.002 9.12C5.308 16.32.48 14.36.48 12s4.831-4.32 11.522-4.32c6.69 0 11.518 1.96 11.518 4.32s-4.824 4.32-11.518 4.32zm-.225-6.062h4.176v.964c-.103-.047-.203-.047-.306-.047h-1.758v.46h1.689v.732h-1.689v.457h1.758c.103 0 .203 0 .306-.05v.967h-4.176c.052-.101.052-.198.052-.299V10.56c0-.101 0-.198-.052-.302zm-7.076.302v2.881c0 .101 0 .198.052.299H2.4c.052-.101.052-.198.052-.299V10.56c0-.101 0-.198-.052-.299h2.353c-.052.101-.052.198-.052.299zm6.447 2.881c.076.107.158.208.255.299H8.805c0-.101-.1-.306-.21-.467-.11-.161-.705-1.044-.705-1.044v1.212c0 .101 0 .198.052.299H5.778c.052-.101.052-.198.052-.299V10.56c0-.101 0-.198-.052-.299h2.164c-.052.101-.052.198-.052.299v1.259s.691-.88.85-1.085c.12-.154.268-.373.268-.473h2.257c-.155.101-.327.282-.468.45l-.826.984s1.039 1.548 1.177 1.746zm10.546-3.005a.178.178 0 0 0-.175-.178h-.21v.551h.083v-.195h.12l.11.195h.093l-.12-.212a.184.184 0 0 0 .099-.161zm-.189.101h-.114v-.191h.124c.055 0 .093.047.093.101 0 .053-.048.093-.103.09zm-.021-.457h-.031a.444.444 0 0 0-.437.457c0 .007 0 .017-.003.023a.466.466 0 0 0 .482.447.464.464 0 0 0 .458-.47v-.017a.454.454 0 0 0-.469-.44zm0 .823a.372.372 0 0 1-.375-.366v-.027a.357.357 0 0 1 .375-.339c.206 0 .375.165.375.366s-.168.366-.375.366zm-.877-.339c-.038-.101-.093-.198-.065-.299h-3.017c.014.101-.024.198-.062.299l-1.07 2.881a.852.852 0 0 1-.162.299h1.785c-.014-.101.024-.198.058-.299.034-.101.072-.198.072-.198l.021-.054h1.304l.021.05c.048.118.083.198.083.198.041.101.079.198.069.299h2.263a.837.837 0 0 1-.169-.299 690.277 690.277 0 0 0-1.131-2.877zm-2.167 1.893c.155-.42.289-.772.299-.806.028-.074.048-.151.062-.228.017.077.041.154.069.228l.316.806h-.746z",source:"https://www.ikea.com/",hex:"0058A3",guidelines:void 0,license:void 0},siImagej={title:"ImageJ",slug:"imagej",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>ImageJ</title><path d="'+this.path+'"/></svg>'},path:"M13.1286 17.5084h-8.072a.187.187 0 0 1-.187-.187v-.4442a.187.187 0 0 1 .187-.187h8.0721a.187.187 0 0 1 .187.187v.4442a.1872.1872 0 0 1-.1871.187zm5.6234-12.195c-1.4233.0033-4.2184-.0098-5.6414-.0065a.4035.4035 0 0 0-.4035.4035v3.6061c0 .2229.1807.4035.4035.4035h1.7475v8.19a1.8275 1.8275 0 0 1-.9112 1.5761 1.8277 1.8277 0 0 1-1.8224 0 1.8276 1.8276 0 0 1-.9113-1.5784H6.941c0 2.1705 1.1677 4.193 3.0473 5.2782.9398.5428 1.9936.8141 3.0474.8141s2.1076-.2713 3.0474-.8139c1.8795-1.0837 3.0444-3.1089 3.0473-5.274V5.692a.3785.3785 0 0 0-.3784-.3786zM7.4546 15.2306h3.276a.6403.6403 0 0 0 .6403-.6403V.6403A.6403.6403 0 0 0 10.7306 0h-3.276a.6403.6403 0 0 0-.6403.6403v13.95c0 .3536.2867.6403.6403.6403z",source:"https://github.com/imagej/imagej/blob/0667395bcac20e5d7a371ac9f468522c74367d59/logo/inkscape_image_logo_src.svg",hex:"00D8E0",guidelines:void 0,license:void 0},siImgur={title:"Imgur",slug:"imgur",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Imgur</title><path d="'+this.path+'"/></svg>'},path:"M21.147 3.043c-.002-.113-.069-.182-.189-.191a14.117 14.117 0 00-.51-.045l-.162-.01a21.998 21.998 0 00-1.085-.046l-.217-.005c-.172-.003-.35-.004-.532-.004l-.189-.001c-.295 0-.601.003-.919.01l-.106.003a55.86 55.86 0 00-.87.026l-.237.009c-.335.013-.676.029-1.027.049l-.012.001c-.357.021-.724.045-1.095.071l-.275.021c-.304.023-.609.048-.92.076l-.25.021c-.38.035-.766.074-1.156.115-.08.009-.161.019-.242.027-.319.035-.641.073-.965.113l-.33.042c-.403.051-.806.105-1.212.164a.547.547 0 00-.154.045.303.303 0 00-.097.074l-.003.002c-.045.055-.047.12.004.179.003.004.002.008.005.012l3.488 3.456-6.629 6.596c-.069.067-.068.165 0 .251.856 1.093 1.44 1.793 2.143 2.492.699.703 1.398 1.286 2.493 2.143a.216.216 0 00.132.051.167.167 0 00.119-.051l6.597-6.629 3.455 3.488a.143.143 0 00.101.047c.096 0 .187-.118.212-.292.746-5.141.882-10.051.634-12.31z M15.87 24l6.356-6.357.026-.026.156-.155-.006-.006a3.144 3.144 0 00.822-1.711c.804-5.53.903-10.591.654-12.952a2.904 2.904 0 00-.834-1.812 2.96 2.96 0 00-1.816-.855C20.458.042 19.476 0 18.318 0c-2.999 0-6.667.284-10.063.777a3.143 3.143 0 00-1.887.991L0 8.137V24H15.87zm1.528-6.707c-.151 0-.563.405-.563.613a.1.1 0 01-.099.1.1.1 0 01-.099-.1c0-.208-.411-.613-.563-.613a.1.1 0 01-.099-.1c0-.054.044-.098.099-.098.152 0 .563-.404.563-.614 0-.055.044-.098.099-.098.054 0 .099.043.099.098 0 .21.412.614.563.614a.1.1 0 010 .198zM5.4 7.045c.197 0 .735-.528.735-.801a.13.13 0 01.128-.129c.071 0 .128.058.128.129 0 .272.538.801.735.801.071 0 .128.057.128.128a.128.128 0 01-.128.128c-.197 0-.735.528-.735.801a.128.128 0 01-.128.128.128.128 0 01-.128-.128c0-.273-.538-.801-.735-.801a.128.128 0 010-.256zm-3.99 3.26c0-.065.057-.098.119-.118.69-.228 1.269-.8 1.403-1.554.011-.064.053-.118.118-.118.066 0 .107.054.119.118.133.754.711 1.326 1.401 1.554.062.02.118.053.118.118s-.056.098-.118.119c-.69.227-1.269.799-1.403 1.553-.011.064-.053.119-.119.119-.065 0-.106-.054-.118-.119-.134-.754-.713-1.326-1.403-1.553-.061-.022-.117-.054-.117-.119zm1.565 9.307c-.113 0-.42.302-.42.459 0 .04-.034.073-.074.073a.074.074 0 01-.074-.073c0-.157-.307-.459-.42-.459a.074.074 0 01-.074-.073c0-.039.034-.073.074-.073.113 0 .42-.302.42-.457 0-.042.033-.073.074-.073.04 0 .074.031.074.073 0 .155.307.457.42.457.04 0 .073.034.073.073a.073.073 0 01-.073.073zm.568-3.047c-.14 0-.521.375-.521.568a.092.092 0 11-.183 0c0-.193-.381-.568-.521-.568a.09.09 0 01-.091-.09c0-.051.041-.092.091-.092.14 0 .521-.375.521-.568a.09.09 0 01.092-.09.09.09 0 01.091.09c0 .193.381.568.521.568a.091.091 0 010 .182zm3.334 4.382c-.203 0-.758.546-.758.827 0 .073-.06.133-.132.133a.133.133 0 01-.133-.133c0-.281-.555-.827-.758-.827a.134.134 0 01-.133-.133c0-.073.059-.132.133-.132.204 0 .758-.545.758-.828 0-.071.06-.132.133-.132.073 0 .132.061.132.132 0 .283.555.828.758.828.074 0 .133.059.133.132a.133.133 0 01-.133.133zm1.922-.806c-1.086-.851-1.869-1.498-2.653-2.287-.789-.784-1.436-1.566-2.287-2.654-.626-.8-.566-1.897.144-2.607l.001-.001.002-.001L9.364 7.26 7.149 5.066l-.003-.003-.002-.003c-.52-.52-.7-1.27-.472-1.958.148-.447.464-.802.867-1.049a1.983 1.983 0 01.371-.19 2.1 2.1 0 01.468-.131c.005 0 .009-.003.014-.004C11.746 1.24 15.363.96 18.317.96h.002c1.125 0 2.072.041 2.818.121.469.046.903.249 1.228.576.328.331.525.767.562 1.237.243 2.311.144 7.253-.651 12.714-.001.01-.006.016-.007.025a2.258 2.258 0 01-.18.586c-.006.014-.01.028-.018.042-.333.699-1.001 1.163-1.771 1.163-.51 0-.992-.2-1.358-.567l-.003-.002-.004-.004-2.192-2.215-5.333 5.359-.001.002h-.001a1.94 1.94 0 01-1.378.573c-.44 0-.877-.151-1.231-.429zm2.576 2.09c-.139 0-.518.373-.518.566a.09.09 0 01-.091.09.09.09 0 01-.09-.09c0-.193-.379-.566-.519-.566a.09.09 0 110-.18c.139 0 .519-.373.519-.566a.09.09 0 01.09-.09c.05 0 .091.041.091.09 0 .193.379.566.518.566.05 0 .091.039.091.09s-.04.09-.091.09zm2.115-2.437c.248 0 .922-.662.922-1.003 0-.088.072-.161.161-.161.088 0 .161.073.161.161 0 .341.674 1.003.921 1.003.089 0 .161.073.161.161a.16.16 0 01-.161.161c-.247 0-.921.662-.921 1.005a.162.162 0 01-.161.162.162.162 0 01-.161-.162c0-.343-.674-1.005-.922-1.005a.161.161 0 010-.322z",source:"https://imgurinc.com/press",hex:"1BB76E",guidelines:"https://help.imgur.com/hc/en-us/articles/202062878-Trademark-Use-Policy",license:void 0},siImou={title:"Imou",slug:"imou",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Imou</title><path d="'+this.path+'"/></svg>'},path:"M14.6426 9.1484c-1.5747 0-2.8555 1.279-2.8555 2.8516 0 1.5724 1.2808 2.8516 2.8555 2.8516 1.5748 0 2.8554-1.2792 2.8554-2.8516 0-1.5725-1.2806-2.8516-2.8554-2.8516zm-9.8184.0059c-1.3802 0-2.502 1.12-2.502 2.498v2.9532c0 .0886.0714.1601.1602.1601h.9727a.1598.1598 0 0 0 .1601-.1601v-2.9532c0-.6656.5425-1.207 1.209-1.207.6667 0 1.209.5414 1.209 1.207v2.9532c0 .0886.0733.1601.1621.1601h.9707a.1615.1615 0 0 0 .1621-.1601v-2.9532c0-.6656.5423-1.207 1.209-1.207.6665 0 1.209.5414 1.209 1.207v2.9532c0 .0886.0714.1601.1601.1601h.9727a.1598.1598 0 0 0 .1602-.1601v-2.9532c0-1.378-1.122-2.498-2.502-2.498-.7367 0-1.397.3209-1.8555.8281-.4582-.5072-1.1209-.8281-1.8574-.8281zm-4.664.1309A.1596.1596 0 0 0 0 9.4453v5.1602c0 .0888.0714.1601.1602.1601h.9628a.1614.1614 0 0 0 .1622-.1601V9.4453a.1615.1615 0 0 0-.1622-.1601H.1602zm18.289 0a.1612.1612 0 0 0-.162.1601v1.4492c0 .089.073.1602.162.1602h.963a.1596.1596 0 0 0 .16-.1602V9.4453a.1596.1596 0 0 0-.16-.1601h-.963zm4.4278 0a.1612.1612 0 0 0-.1622.1601v1.4492c0 .089.0732.1602.1622.1602h.9628A.1596.1596 0 0 0 24 10.8945V9.4453a.1596.1596 0 0 0-.1602-.1601h-.9628zm-8.2344 1.1464c.8663 0 1.5703.7035 1.5703 1.5684 0 .865-.704 1.5684-1.5703 1.5684-.8664 0-1.5723-.7035-1.5723-1.5684 0-.865.706-1.5684 1.5723-1.5684zm3.8066 1.2579a.1615.1615 0 0 0-.162.1601v.08c0 1.5443 1.2004 2.8615 2.746 2.92C22.6579 14.9108 24 13.6088 24 12v-.1504a.1598.1598 0 0 0-.1602-.1601h-.9628a.1615.1615 0 0 0-.1622.1601V12c0 .8651-.704 1.5684-1.5703 1.5684-.8663 0-1.5722-.7033-1.5722-1.5684v-.1504a.1597.1597 0 0 0-.1602-.1601h-.9629Z",source:"https://www.imoulife.com/support/download/userManual",hex:"E89313",guidelines:void 0,license:void 0},siIndeed={title:"Indeed",slug:"indeed",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Indeed</title><path d="'+this.path+'"/></svg>'},path:"M11.566 21.5633v-8.762c.2553.0231.5009.0346.758.0346 1.2225 0 2.3739-.3206 3.3506-.8928v9.6182c0 .8219-.1957 1.4287-.5757 1.8338-.378.4033-.8808.6049-1.491.6049-.6007 0-1.0766-.2016-1.468-.6183-.3781-.4032-.5739-1.01-.5739-1.8184zM11.589.5659c2.5447-.8929 5.4424-.8449 7.6186.987.405.3687.8673.8334 1.0515 1.3806.2207.6913-.7695-.073-.9057-.167-.71-.4532-1.4182-.8334-2.2127-1.0946C12.8614.3873 8.8122 2.709 6.2945 6.315c-1.0516 1.5939-1.7367 3.2721-2.299 5.1174-.0614.2017-.1094.4647-.2207.6413-.1113.2036-.048-.5453-.048-.5702.0845-.7623.2438-1.4997.4414-2.237C5.3292 5.3375 7.897 2.0655 11.5891.5658zm4.9281 7.0587c0 1.6686-1.353 3.0224-3.0205 3.0224-1.6677 0-3.0186-1.3538-3.0186-3.0224 0-1.6687 1.351-3.0224 3.0186-3.0224 1.6676 0 3.0205 1.3518 3.0205 3.0224Z",source:"https://indeed.design/resources",hex:"003A9B",guidelines:void 0,license:void 0},siInfluxdb={title:"InfluxDB",slug:"influxdb",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>InfluxDB</title><path d="'+this.path+'"/></svg>'},path:"M23.778 14.482l-2.287-9.959c-.13-.545-.624-1.09-1.169-1.248L9.87.051C9.74 0 9.584 0 9.426 0c-.443 0-.909.18-1.222.443L.716 7.412C.3 7.776.092 8.504.222 9.024l2.445 10.662c.13.545.624 1.092 1.169 1.248l9.775 3.015c.13.051.285.051.443.051.443 0 .91-.18 1.223-.443l8.007-7.435c.418-.39.624-1.092.494-1.64zM10.962 2.417l7.175 2.21c.285.08.285.21 0 .286l-3.77.858c-.285.08-.674-.05-.883-.26l-2.626-2.834c-.235-.232-.184-.336.104-.26zm4.47 12.872c.079.286-.105.444-.39.365l-7.748-2.392c-.285-.079-.338-.313-.13-.52l5.93-5.514c.209-.209.443-.13.52.156zM2.667 8.267l6.293-5.85c.21-.209.545-.18.754.025L12.86 5.85c.209.21.18.545-.026.754l-6.293 5.85c-.21.21-.545.181-.754-.025L2.64 9.024a.536.536 0 01.026-.757zm1.536 9.284L2.54 10.244c-.08-.285.05-.34.234-.13L5.4 12.949c.209.209.285.624.209.909L4.462 17.55c-.079.285-.208.285-.26 0zm9.202 4.264l-8.217-2.522a.547.547 0 01-.364-.675l1.378-4.421a.547.547 0 01.675-.365l8.216 2.522c.285.079.443.39.364.675L14.08 21.45a.553.553 0 01-.674.365zm7.279-5.98L15.2 20.93c-.209.209-.31.13-.234-.155l1.144-3.694c.079-.285.39-.573.674-.624l3.77-.858c.288-.076.339.054.13.234zm.598-1.09l-4.523 1.039a.534.534 0 01-.65-.39l-1.922-8.372a.534.534 0 01.39-.65L19.1 5.335a.534.534 0 01.649.39l1.923 8.371c.079.31-.102.596-.39.65Z",source:"https://influxdata.github.io/branding/logo/downloads/",hex:"22ADF6",guidelines:"https://influxdata.github.io/branding/logo/usage/",license:void 0},siInformatica={title:"Informatica",slug:"informatica",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Informatica</title><path d="'+this.path+'"/></svg>'},path:"M12 0l3.547 10.788-4.5-1.255-.25 4.43 7.121 4.035V18h.001l5.919-6zm-.64.65L.162 12l6.32 6.407L12 24l5.184-5.255-9.736-3.856z",source:"https://www.informatica.com/",hex:"FF4D00",guidelines:void 0,license:void 0},siIngress={title:"Ingress",slug:"ingress",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Ingress</title><path d="'+this.path+'"/></svg>'},path:"M22.55 6.55v10.9c0 .434-.184.749-.55.95l-9.45 5.45c-.367.2-.733.2-1.1 0L2 18.4c-.366-.201-.55-.516-.55-.95V6.55c0-.434.184-.749.55-.95L11.45.15c.367-.2.733-.2 1.1 0L22 5.6c.366.201.55.516.55.95zM21 17.8l-3.9-2.25.5-.9 3.9 2.249V6.549l-.05-.048-8.95-5.2v4.5h-1v-4.5l-9 5.2v10.398l3.9-2.248.5.899L3 17.8l8.95 5.15h.1L21 17.8zM4.55 7.675c0-.016.016-.025.05-.025h14.8c.033 0 .05.009.05.025v.075l-7.4 12.799c0 .034-.017.05-.05.05-.034 0-.05-.016-.05-.05L4.55 7.75v-.075zm6.95 5.076c0-.301-.15-.533-.45-.7L6.9 9.65h-.05v.05l4.6 7.9c.033 0 .05-.019.05-.051v-4.8zm.9-1.601l4.2-2.45H7.4l.05.051 4.15 2.399a.701.701 0 00.8 0zM17.15 9.7v-.05h-.05l-4.15 2.4c-.3.167-.45.417-.45.749v4.8h.1l4.55-7.899z",source:"https://ingress.com/assets/fonts/ingress_icons.woff",hex:"783CBD",guidelines:void 0,license:void 0},siInkscape={title:"Inkscape",slug:"inkscape",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Inkscape</title><path d="'+this.path+'"/></svg>'},path:"M7.666 14.871c.237.147 3.818.875 4.693 1.02.303.064.088.376-.33.587-.943.251-5.517-1.607-4.363-1.607zm5.647-13.264l3.505 3.56c.333.34.328.998.142 1.187l-1.74-1.392-.342 2.061-1.455-.767-2.328 1.47-.771-3.1L9.073 6.79H7.16c-.78 0-.871-.99-.163-1.698 1.237-1.335 2.657-2.696 3.429-3.485.776-.793 2.127-.77 2.887 0zM9.786.97l-8.86 9.066c-2.993 3.707 2.038 3.276 4.194 4.343.774.791-2.965 1.375-2.191 2.166.773.791 4.678 1.524 5.453 2.314.773.791-1.584 1.63-.81 2.42.773.792 2.563.042 2.898 1.868.238 1.304 3.224.56 4.684-.508.774-.791-1.48-.717-.706-1.508 1.923-1.967 3.715-.714 4.373-2.686.325-.974-2.832-1.501-2.057-2.292 2.226-1.3 9.919-2.146 6.268-5.796L13.85.97c-1.123-1.078-2.998-1.09-4.063 0zm10.177 17.475c0 .45 3.314.745 3.314-.106-.472-1.366-2.922-1.274-3.314.106zm-14.928 2.39c.784.679 1.997-.169 2.36-1.116-.76-1.01-3.607.037-2.36 1.116zm14.512-1.466c-1.011.908.114 1.828 1.111 1.242.222-.225-.006-1.016-1.11-1.242Z",source:"https://inkscape.org/gallery/=inkscape-branding/inkscape-brand-assets/",hex:"000000",guidelines:void 0,license:{type:"CC-BY-SA-3.0",url:"https://spdx.org/licenses/CC-BY-SA-3.0"}},siInstacart={title:"Instacart",slug:"instacart",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Instacart</title><path d="'+this.path+'"/></svg>'},path:"M15.629 9.619c1.421 1.429 2.58 3.766 1.917 5.152-1.778 3.715-15.04 10.226-16.169 9.1C.252 22.746 6.768 9.476 10.481 7.697c1.388-.66 3.724.51 5.152 1.92l-.005.014v-.012zm7.028-1.566c-.231-.855-.821-1.717-1.7-1.82-1.61-.186-4.151 2.663-3.971 3.339.181.69 3.766 1.875 5.1.915.691-.494.781-1.56.556-2.414l.015-.02zM17.666.158c1.198.324 2.407 1.148 2.551 2.382.261 2.259-3.732 5.819-4.68 5.564-.948-.251-2.618-5.284-1.269-7.162.695-.972 2.201-1.106 3.399-.788v.004h-.001z",source:"https://www.instacart.com/press",hex:"43B02A",guidelines:void 0,license:void 0},siInstagram={title:"Instagram",slug:"instagram",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Instagram</title><path d="'+this.path+'"/></svg>'},path:"M12 0C8.74 0 8.333.015 7.053.072 5.775.132 4.905.333 4.14.63c-.789.306-1.459.717-2.126 1.384S.935 3.35.63 4.14C.333 4.905.131 5.775.072 7.053.012 8.333 0 8.74 0 12s.015 3.667.072 4.947c.06 1.277.261 2.148.558 2.913.306.788.717 1.459 1.384 2.126.667.666 1.336 1.079 2.126 1.384.766.296 1.636.499 2.913.558C8.333 23.988 8.74 24 12 24s3.667-.015 4.947-.072c1.277-.06 2.148-.262 2.913-.558.788-.306 1.459-.718 2.126-1.384.666-.667 1.079-1.335 1.384-2.126.296-.765.499-1.636.558-2.913.06-1.28.072-1.687.072-4.947s-.015-3.667-.072-4.947c-.06-1.277-.262-2.149-.558-2.913-.306-.789-.718-1.459-1.384-2.126C21.319 1.347 20.651.935 19.86.63c-.765-.297-1.636-.499-2.913-.558C15.667.012 15.26 0 12 0zm0 2.16c3.203 0 3.585.016 4.85.071 1.17.055 1.805.249 2.227.415.562.217.96.477 1.382.896.419.42.679.819.896 1.381.164.422.36 1.057.413 2.227.057 1.266.07 1.646.07 4.85s-.015 3.585-.074 4.85c-.061 1.17-.256 1.805-.421 2.227-.224.562-.479.96-.899 1.382-.419.419-.824.679-1.38.896-.42.164-1.065.36-2.235.413-1.274.057-1.649.07-4.859.07-3.211 0-3.586-.015-4.859-.074-1.171-.061-1.816-.256-2.236-.421-.569-.224-.96-.479-1.379-.899-.421-.419-.69-.824-.9-1.38-.165-.42-.359-1.065-.42-2.235-.045-1.26-.061-1.649-.061-4.844 0-3.196.016-3.586.061-4.861.061-1.17.255-1.814.42-2.234.21-.57.479-.96.9-1.381.419-.419.81-.689 1.379-.898.42-.166 1.051-.361 2.221-.421 1.275-.045 1.65-.06 4.859-.06l.045.03zm0 3.678c-3.405 0-6.162 2.76-6.162 6.162 0 3.405 2.76 6.162 6.162 6.162 3.405 0 6.162-2.76 6.162-6.162 0-3.405-2.76-6.162-6.162-6.162zM12 16c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4-1.79 4-4 4zm7.846-10.405c0 .795-.646 1.44-1.44 1.44-.795 0-1.44-.646-1.44-1.44 0-.794.646-1.439 1.44-1.439.793-.001 1.44.645 1.44 1.439z",source:"https://en.facebookbrand.com/instagram/",hex:"E4405F",guidelines:"https://en.facebookbrand.com/instagram/",license:void 0},siInstapaper={title:"Instapaper",slug:"instapaper",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Instapaper</title><path d="'+this.path+'"/></svg>'},path:"M14.766 20.259c0 1.819.271 2.089 2.934 2.292V24H6.301v-1.449c2.666-.203 2.934-.473 2.934-2.292V3.708c0-1.784-.27-2.089-2.934-2.292V0h11.398v1.416c-2.662.203-2.934.506-2.934 2.292v16.551z",source:"https://www.instapaper.com/",hex:"1F1F1F",guidelines:void 0,license:void 0},siInstatus={title:"Instatus",slug:"instatus",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Instatus</title><path d="'+this.path+'"/></svg>'},path:"m16.994 21.028c3.5843-1.91 5.471-5.759 5.0561-9.5637-1.3206 1.0851-2.6237 2.3203-3.8709 3.6906-2.0656 2.2694-3.7476 4.6559-4.9953 6.9817 1.2946-0.09715 2.5907-0.45868 3.8101-1.1086zm-13.394-2.5626c-1.3408 1.8191-2.3771 4.4991-1.3032 5.3066 1.5151 1.1394 8.404-2.0133 13.908-8.8051 5.504-6.7918 7.3265-13.796 4.879-14.873-1.1283-0.49644-3.486 1.083-4.8394 2.3943l0.58412 0.31415c1.332-0.85276 3.5528-1.7338 1.4995 1.9758-0.0097 0.01768-0.01962 0.03541-0.02949 0.05317-2.9067-2.2075-6.9471-2.662-10.379-0.8328-4.7026 2.506-6.4831 8.3499-3.9771 13.052 0.58979 1.1067 1.3644 2.0516 2.2655 2.8168-3.5586 2.7493-2.6905 0.35965-2.1925-0.8162z",source:"https://www.instatus.com/",hex:"4EE3C2",guidelines:void 0,license:void 0},siInstructables={title:"Instructables",slug:"instructables",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Instructables</title><path d="'+this.path+'"/></svg>'},path:"M9.4174.0004c-.1655-.0025-.319.0073-.4493.0363-.902.201-1.2372 1.1122-1.6211 1.9531-.1036.2255-.192.107-.5576.9754-1.1487-.137-2.5594-.1066-3.4065-.2041.1402.4845.8319.198 1.295.2041.7587.0061 1.5447.2011 2.1115.2042.0335.2102.2134.4414.25.6486.1188.6917.0764 1.3407-.1126 2.005-.1828.649-1.2492 1.1886-1.499 2.0448-.1037.3535.0118.6551-.1375 1.0909-.1097.137-.3256.1702-.475.2707-1.0572 1.1914-1.6729 3.178-1.9745 4.9026.7252.3382 1.3467.0185 1.7032.2714.2163.061.0916-.2255.2714-.2041.137.0213.1306.1828.2707.204-.1127 1.027.0673 1.7308.0673 2.7912 1.1152.4814 2.3768.399 3.9551.4112-.0182.2042.3868.9602.0578 1.4569.4875.4966-.2407 2.1783.7587 2.221-.332.4874-.5579 1.0785-.5457 1.9073-.2407.1066-.0396-.2316-.2041-.2041-1.691-.0427-2.6844-.3078-4.4943-.2042.5058.2072 1.4444.119 2.1787.2714.0792.0122.055.125.0672.2041.2956-.1401 1.1029-.0304 1.633 0-.2376.125.3325.2468.3416 0 .457.0701.8287.5852 1.2248.6797 1.3072.3138 2.0447-.6313 2.8613-1.2224.128.2681.7553.0152 1.1575 0-.3352-.198-1.1365-.134-1.499 0 .1218-.9629-.3534-1.3285-.8166-1.7032.189-.1067.3958-.1948.5451-.341.0183-1.3407-.0546-1.7948-.1368-2.9953.7252-.1493 1.7613-.2437 2.6572-.4082-.317.969-.1404 1.444-.2714 2.7238.1676.0823.399.101.6124.1375-.6704.3595-1.0573 1.8947-.2042 2.3823-.0761.1736-.3655.1344-.6123.1374.0091.3565.8498-.1221.7492.341.457-.3687 3.1811-.0394 4.2902.0673-.1188-.6094-1.453-.1192-2.0442-.5457.7648-.4876.7768-1.9618-.0673-2.3823.646-.4296.2683-2.1969.4755-3.1993.6186-.2682 1.5905-.1801 2.1115-.5458-.0152-.8714-.1825-1.5873-.341-2.3156.2164-.1493.7495-.3351 1.0206-.2041.1493-.0122.146-.174.137-.3416.0609-.1645.201.1526.4082.0673.0091-.8136-.3684-1.2249-.7493-1.9074-.5728-1.0238-1.3196-2.0295-2.453-2.453-.9538-1.6363-1.9711-3.2054-4.1528-3.6106-.1219-.3078-.049-.8135-.0672-1.2248.3016-.265.564-.573.5457-1.158.8288-.3535 2.1297.0852 2.928 0-.128-.4206-.8656-.1555-1.3623-.2042-.527-.0518-1.0481-.2803-1.499 0-.131-.387-.3533-1.1057-.591-.929-.1402-.3382-.1313-.8657-.0917-1.3836-.847-.1737-1.7762-.4385-2.7238-.5452-.4228-.048-1.0288-.1665-1.5253-.1737zm-.382.2374c1.5448.134 3.1656.1919 4.427.6124.2164 1.551-.085 2.9803.1375 4.6318-1.6484-.2803-3.5102-.6189-5.177-.3416.0793-1.6302.1463-3.434.6124-4.9026zM8.627.5092c-.0945 1.5387-.396 2.8426-.4083 4.6312-.323.2437-.6734.46-1.0908.6124-.0366-.5698.021-1.3403.1369-1.77.0975.1067.2652.143.4755.137.5545-.64.28-1.7428-.0673-2.5198.2803-.3991.4908-.8714.954-1.0908zm2.2626.7903c-.2944-.0043-.5763.0233-.8308.0964.3322.0061.7194-.037.954.0667-.4753.2072-.7955.5667-.7498 1.295.7282 1.0115 1.9712-.2254 1.2247-1.2248.4754-.0335 1.3378.3292 1.9746.2714-.6947-.1943-1.6894-.4917-2.5727-.5047zm.356.3535c.297.041.3246.751.2421 1.0284-.32.387-.9866.1405-1.0902-.2708.1615-.0853-.0248-.5212.2707-.4755-.0822.515.1649.701.5458.7498.0944-.131.1797-.2713.204-.4755-.0578-.2346-.2832-.3048-.4082-.4755.0644-.0464.1218-.0716.1726-.0797a.2142.2142 0 0 1 .0631-.0012zm-3.5726.4225c.1189.4175.2135 1.1727.0673 1.77-1.039-.0245-.7224-1.581-.0673-1.77zm3.1327 0c.2255.003.481-.0274.475.2042-.0366.0975-.1067.1645-.2042.204-.0853-.14-.3287-.1248-.2708-.4082zm1.6925.0238c-.2755.0209-.5396.2472-.535.7957.2407.1188.4021.3232.8165.2714.6685-.5656.1777-1.1018-.2815-1.067zm.0107.0429c.2986.0213.5146.119.475.4755-.2194-.0945-.2739-.3567-.475-.4755zm1.3617.1375c.393.4326.4144 1.7184-.2042 1.9073-.0243-.5667-.061-1.4412.2042-1.9073zm-1.4938.069c.0266.002.0497.0214.0649.0678-.189.1036-.009.4084.0702.4785-.2681.0396-.302-.1527-.3416-.3416.016-.0594.1267-.2109.2065-.2047zm.1321.135c.2133-.0304.3043.0606.2708.2709-.2133.0335-.3012-.0575-.2708-.2708zm-3.4064.8166c-.0792.0122-.0581.1249-.0673.2041 1.5266.1828 2.7729.6487 4.0861.5451-.2133-.3504-.7098-.1736-1.0206-.204-.9446-.0946-1.8924-.4537-2.8613-.475-.0793.0091-.1217-.0154-.137-.0702zm2.093 1.9014c.9318.0446 2.0293.469 2.5412.6183.1401.0396.3231-.0427.4755 0 .4844.134 1.1974.4724 1.499.6826.844.5911 1.4262 1.807 1.9747 2.7911.195.3535.5148.6095.6123.8867.3017.8593.3501 1.7671.7493 2.5198l.0732.341c.2163.7587.4269 1.8193.5457 2.453-3.0287.4297-5.872.7495-8.3096 1.0207-2.0232-.3291-4.1683-.1735-5.9934-.341-.3017-2.3036.3993-4.5952.2713-6.9474.0122-.192.2227-.1856.2714-.341-.1737-.0092-.3507-.0122-.3416-.2042.198-2.1054 2.4071-3.9675 4.6985-3.3368.2376-.0366.305-.1155.5457-.1369a2.8444 2.8444 0 0 1 .3868-.006zM9.894 8.9997a1.6087 1.6087 0 0 0-.3136.0226c-.2255.3474-.1552.6615-.137 1.1581 1.1142 1.1912 1.8694-1.134.4506-1.1807zm5.0633.0173c-1.3532.0321-.3819 2.6965.6837 1.3003.253-.8074-.1368-1.2554-.545-1.295a1.1653 1.1653 0 0 0-.1387-.0053zm-2.3609.0297c-.2254-.0106-.472.067-.7034.247-.0853.4174.0887.9444.3416 1.2248.518.0426.9107-.0429 1.1575-.2714.0943-.727-.2996-1.177-.7957-1.2004zm-7.3062.1095c.3595 1.0939-.0454 2.523-.0667 3.6779-.5667-.0915-1.0694-.2464-1.7032-.2708.329-1.3955.6638-2.7885 1.7699-3.407zm4.8847.0673a.264.264 0 0 1 .1523.0702c.1615.1615-.0121.3349 0 .5451-.2772.067-.2741-.006-.6123 0 .0487-.2529-.116-.2922-.0673-.5451.1943.0229.3695-.088.5273-.0702zm2.2995.003c.5982-.0527.9245.8043-.103.7498-.0761-.2194-.2739-.3172-.341-.5457.1538-.1314.306-.192.444-.2041zm2.5793.013c.2693-.001.52.1634.52.5327-.2345.2742-.4719.5575-.9533.4082-.0305-.1645.1215-.1496.0667-.3416-.1341.003-.085.1863-.2708.1375-.0857-.461.291-.7355.6374-.7368zm3.107.2583c1.0421.5028 1.6454 1.4442 2.1115 2.5198-.4966.0426-.7891-.1185-1.295-.0667-.1035-.5759-.4474-.9112-.4748-1.5663.1797-.003.4021.0362.4082-.1375-.0487-.262-.3507-.4692-.5457-.2041-.0091-.2408-.195-.3045-.2041-.5452zM4.879 9.702c-.0883.2894-.0607.5207.2714.545.1067-.1919-.0181-.28.0702-.545zm5.7227.204c.003.2073-.1432.2651-.2041.4083-.384.0214-.7133-.015-.7499-.341.3626.0762.6737.0912.954-.0672zm2.5864 0v.341c-.2712.125-1.2094.2804-.9534-.204.2468.3077.7675.0337.9534-.137zm2.3162.2042c-.0275.387-.762.582-.954.2041.4113.1097.7072.0122.954-.204zm-6.332 1.3652c.1279.5028-.1341.6338-.2042 1.0909.9263.067 1.9806-.0213 2.791-.003.0428-.061.0824-.1223 0-.1375H9.5109c2.5534-.5271 4.2109-.3652 7.014-.2708.0763.2133-.0186.1795.0667.341-1.6149.326-3.251-.402-4.8323.0673 1.5631-.0518 3.1962.1641 4.9026.2708.0365-.3474.0883-.8317 0-1.2248-.2468-.064-.07.2929-.2042.3416-1.8647-.1402-4.6772-.125-7.0813.2041-.0944-.0883-.0666-.2957-.0666-.4755 1.4595-.2468 4.305.253 5.4477-.2041-1.7002.1036-3.7235-.0122-5.5852 0zm6.5432.0637c-.3249-.0107-.6745.0136-.8909.003.3108.3016 1.2095.0152 1.633.204-.1173-.1507-.4172-.1964-.742-.207zm3.8957.6153c.3183.0018.6615.0695.7986.2048-.46-.1585-.911.1672-1.295-.1375.1234-.0457.3054-.0683.4964-.0673zm.1505.325c.2297-.0027.459.023.5779.0839-.2072.1432-1.0789.3626-1.1581 0 .1204-.0503.3506-.0813.5802-.084zm.9641.244c.2443-.0384.3716.3498.3636.6564-.2529.134-.4389-.3077-.4755-.6124.0397-.0244.077-.0386.112-.044zm-17.2756.044c.4083 0 1.3406.0668 1.7032.341-.588-.0945-1.3833.0216-1.7032-.341zm16.8894.1369c.2133.2681.25.4813.2714.8165-.262-.0549-.2836-.7099-.2714-.8165zm-.9504.0672h.2708c.006.3139.171.463.1374.8165-.387-.0213-.332-.4843-.4082-.8165zm.6094 0c.0396.2133.3197.542.1369.7493-.1067-.1463-.3106-.5482-.137-.7493zm-16.039.1298c.4297.0108.9446.1147 1.057.3451-.5455-.0883-1.134-.1336-1.6337-.2707.0914-.0538.3189-.081.5767-.0744zm-.25.3433c.1167.0012.2099.028.219.1423-.1493.1706-.0765.5575-.3416.6124 0-.1128-.1888-.0394-.204-.137.0944-.1766.2498-.2954.204-.6123a1.524 1.524 0 0 1 .1226-.0054zm-.3933.0054c-.0183.2529-.1069.4354-.2714.5451-.0213-.2925-.006-.5512.2714-.5451zm1.2247.1339c.1158.1371.0973.5514-.0672.6124-.1432-.0762-.274-.649.0672-.6124zm.4083.0702c.0152.125.1767.4507 0 .5452-.0214-.1189-.3139-.5238 0-.5452zm14.5738 2.0413c.2255.0244.1064.393.1369.6124-2.3797.582-4.5644.7128-7.1635 1.0997l-1.2158-.0089c-1.7916.131-4.171.1646-5.856-.2041-.0334-.2407-.1007-.4446-.0672-.7493 2.2822-.1676 4.6439.3136 6.9474.1369 2.526-.195 4.9512-.7831 7.2182-.8867zm-.4083.1369c-.0548.0365-.1096.0703-.204.0672.006.198.0239.3837.2707.341.0091-.1676.0126-.329-.0667-.4082zm-2.6572.3416c-.0152.2437.0979.3562.3416.341.0518-.061.0728-.152.0667-.2708-.0792-.0823-.2407-.0794-.4083-.0702zM5.97 16.582c-.0457.2285.116.25.2714.2714.0548-.061.0763-.1526.0702-.2714zm6.9474.0673c-.1006.2132-.0033.2772.1369.4082.1736-.006.1339-.2285.1339-.4082zm-4.1129.0743c-.057-.0037-.1187.0145-.1773.0625-.0152.2438.0972.3563.341.341.1348-.185.0074-.3923-.1637-.4035zm8.8113.1964c.0092.521-.0824.5822-.0702 1.1581-1.0207.0701-1.4718-.0978-2.3828-.1374.3108-.9111 1.5511-.8714 2.453-1.0207zm-5.5822.6826c.0457.2468.0947.4935.0673.8165-.8684.0275-1.7373-.222-2.5203-.0666-.0762-.2133-.0061-.1554 0-.4083.6033-.4022 1.9137-.2288 2.453-.3416zm3.9064.6636c.1382-.0064.3265.0284.451.153h-.204c-.5694-.0172-.4774-.1424-.247-.153zm1.3824.0036c.1326-.008.2384.0107.2262.1493-.0762.0914-.5362-.0058-.6124-.1368.0945.0304.2537-.0045.3862-.0125zm-6.395.2154c.1815.0066.3368.0398.4236.138-.2468-.003-.5362.0369-.6123-.1368a2.6671 2.6671 0 0 1 .1886-.0012zm5.2935.063c.4243-.0022.8604.043 1.261.2792-.9171-.2042-2.0204.11-2.453-.2708.355.0442.7677-.006 1.192-.0083zm-6.0756.1756c.6793-.0043 1.6155.0968 2.0222.378-.972-.125-1.743.0215-2.587-.341.1402-.0222.3384-.0355.5648-.037zm5.5144.1714c.6914.0055 1.3525.0443 1.8919.2065-.1158.1798-.009.5853-.137.7499-.6367-.067-1.828.128-2.5196 0-.0366-.3779.0361-.6432.0666-.954.2339-.0023.4676-.0042.698-.0024zm-6.0119.1363c.5729.1036 1.9195.189 2.5197.2744-.0883.4936.1676.9445 0 1.295-.5972.3534-1.5266.378-2.3828.4754-.1463-.5362-.3167-1.411-.1369-2.0448zm6.9474 1.0909c.9537-.0427 1.4072.7652 1.2914 1.4294-.2072 1.2036-2.5014 1.4865-3.132.475.009-.7161.0033-1.4503.5456-1.633.064.4905-.2193.591-.204.8867.0578 1.2096 2.2818 1.3774 2.4524.2713.131-.8562-.6213-.8993-.9534-1.4294zm-.7558.2404c.0436-.0153.0947.015.1036.0607.0036.0042.0088.0046.0119.0101.0365.07.043.1458.0583.222.0091.0457-.0217.0765-.0613.0887a.9213.9213 0 0 1-.2041.0333c-.061.003-.1189-.0612-.0762-.119.0548-.0762.0884-.161.125-.2524a.0721.0721 0 0 1 .0428-.0434zm1.0296.3053c.265.006.5516.4539.4755 1.0206-.2773.4875-1.5542.5269-1.5664.341.7953.0914 1.0362-.3714 1.3622-.7492.0214-.2743-.442-.4174-.2713-.6124zm-.3636.1654c.1848-.0061.3668.2504.4308.447-.3108.2102-.5.5453-.954.6123-.1706-.1676-.4478-.2345-.4082-.6123.4692-.0397.4177-.1583.7498.0672.1493-.1432-.0335-.195 0-.4082.058-.0724.12-.104.1816-.106zm-5.2912.31c.8866.0245 1.1762.6398 1.292 1.429.0304.1889-.2531.064-.2714.204.0792.0336.1554.073.2041.137-.46.8927-3.1687 1.4504-2.7238-.4083.07 1.1761 1.779.9509 2.2483.2714.2255-.9568-.4384-1.0389-.7492-1.633zm-.4755.5452c.088.0907.2554.1019.2755.2625a.313.313 0 0 1-.0012.0785c-.131.128-.171.0061-.3416 0 .0366-.1005-.079-.3532.0673-.341zm.545 0c1.4017.5515-.1582 2.0504-1.2247 1.2277-.0944-.265-.3105-.9659.0673-1.0908.1188.198.1612.4758.1369.817.2986.4724 1.3837.3046 1.4294-.2713-.2803-.0762-.1315-.4784-.4088-.6826zm.0673.4755c.0945.0884.0672.2957.0703.4785-.3322.0426-.71.2373-.8868-.1375.4175.0305.4905-.28.8165-.341zm8.503.532c-.0694-.005-.1785.0148-.3308.0834.393.1713.5394-.0684.3309-.0834Z",source:"https://www.instructables.com/community/Official-Instructables-Logos-1/",hex:"FABF15",guidelines:void 0,license:void 0},siIntegromat={title:"Integromat",slug:"integromat",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Integromat</title><path d="'+this.path+'"/></svg>'},path:"M12 0c-.681 0-1.349.057-2 .166v4.09a8.002 8.002 0 012-.253c.69 0 1.36.088 2 .253V.166C13.35.056 12.68 0 12 0zM8.002.683C3.342 2.332 0 6.78 0 12c0 6.623 5.377 12 12 12s12-5.377 12-12C24 6.78 20.658 2.332 15.999.683v4.392a7.997 7.997 0 11-7.997 0zM12 6.003c-.7 0-1.374.12-2 .342v9.32a5.98 5.98 0 002 .343c.7 0 1.374-.121 2-.342V6.345a5.977 5.977 0 00-2-.342z",source:"https://www.integromat.com",hex:"2F8CBB",guidelines:void 0,license:void 0},siIntel={title:"Intel",slug:"intel",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Intel</title><path d="'+this.path+'"/></svg>'},path:"M20.42 7.345v9.18h1.651v-9.18zM0 7.475v1.737h1.737V7.474zm9.78.352v6.053c0 .513.044.945.13 1.292.087.34.235.618.44.828.203.21.475.359.803.451.334.093.754.136 1.255.136h.216v-1.533c-.24 0-.445-.012-.593-.037a.672.672 0 0 1-.39-.173.693.693 0 0 1-.173-.377 4.002 4.002 0 0 1-.037-.606v-2.182h1.193v-1.416h-1.193V7.827zm-3.505 2.312c-.396 0-.76.08-1.082.241-.327.161-.6.384-.822.668l-.087.117v-.902H2.658v6.256h1.639v-3.214c.018-.588.16-1.02.433-1.299.29-.297.642-.445 1.044-.445.476 0 .841.149 1.082.433.235.284.359.686.359 1.2v3.324h1.663V12.97c.006-.89-.229-1.595-.686-2.09-.458-.495-1.1-.742-1.917-.742zm10.065.006a3.252 3.252 0 0 0-2.306.946c-.29.29-.525.637-.692 1.033a3.145 3.145 0 0 0-.254 1.273c0 .452.08.878.241 1.274.161.395.39.742.674 1.032.284.29.637.526 1.045.693.408.173.86.26 1.342.26 1.397 0 2.262-.637 2.782-1.23l-1.187-.904c-.248.297-.841.699-1.583.699-.464 0-.847-.105-1.138-.321a1.588 1.588 0 0 1-.593-.872l-.019-.056h4.915v-.587c0-.451-.08-.872-.235-1.267a3.393 3.393 0 0 0-.661-1.033 3.013 3.013 0 0 0-1.02-.692 3.345 3.345 0 0 0-1.311-.248zm-16.297.118v6.256h1.651v-6.256zm16.278 1.286c1.132 0 1.664.797 1.664 1.255l-3.32.006c0-.458.525-1.255 1.656-1.261zm7.073 3.814a.606.606 0 0 0-.606.606.606.606 0 0 0 .606.606.606.606 0 0 0 .606-.606.606.606 0 0 0-.606-.606zm-.008.105a.5.5 0 0 1 .002 0 .5.5 0 0 1 .5.501.5.5 0 0 1-.5.5.5.5 0 0 1-.5-.5.5.5 0 0 1 .498-.5zm-.233.155v.699h.13v-.285h.093l.173.285h.136l-.18-.297a.191.191 0 0 0 .118-.056c.03-.03.05-.074.05-.136 0-.068-.02-.117-.063-.154-.037-.038-.105-.056-.185-.056zm.13.099h.154c.019 0 .037.006.056.012a.064.064 0 0 1 .037.031c.013.013.012.031.012.056a.124.124 0 0 1-.012.055.164.164 0 0 1-.037.031c-.019.006-.037.013-.056.013h-.154Z",source:"https://www.intel.com/content/www/us/en/newsroom/resources/press-kits-intel-overview.html",hex:"0071C5",guidelines:void 0,license:void 0},siIntellijidea={title:"IntelliJ IDEA",slug:"intellijidea",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>IntelliJ IDEA</title><path d="'+this.path+'"/></svg>'},path:"M0 0v24h24V0zm3.723 3.111h5v1.834h-1.39v6.277h1.39v1.834h-5v-1.834h1.444V4.945H3.723zm11.055 0H17v6.5c0 .612-.055 1.111-.222 1.556-.167.444-.39.777-.723 1.11-.277.279-.666.557-1.11.668a3.933 3.933 0 0 1-1.445.278c-.778 0-1.444-.167-1.944-.445a4.81 4.81 0 0 1-1.279-1.056l1.39-1.555c.277.334.555.555.833.722.277.167.611.278.945.278.389 0 .721-.111 1-.389.221-.278.333-.667.333-1.278zM2.222 19.5h9V21h-9z",source:"https://www.jetbrains.com/idea/",hex:"000000",guidelines:"https://www.jetbrains.com/company/brand/",license:void 0},siZotero={title:"Zotero",slug:"zotero",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Zotero</title><path d="'+this.path+'"/></svg>'},path:"M21.231 2.462 7.18 20.923h14.564V24H2.256v-2.462L16.308 3.076H2.975V0h18.256v2.462z",source:"https://www.zotero.org/support/brand",hex:"CC2936",guidelines:void 0,license:void 0},siZulip={title:"Zulip",slug:"zulip",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Zulip</title><path d="'+this.path+'"/></svg>'},path:"M22.767 3.589c0 1.209-.543 2.283-1.37 2.934l-8.034 7.174c-.149.128-.343-.078-.235-.25l2.946-5.9c.083-.165-.024-.368-.194-.368H4.452c-1.77 0-3.219-1.615-3.219-3.59C1.233 1.616 2.682 0 4.452 0h15.096c1.77-.001 3.219 1.614 3.219 3.589zM4.452 24h15.096c1.77 0 3.219-1.616 3.219-3.59 0-1.974-1.449-3.59-3.219-3.59H8.12c-.17 0-.277-.202-.194-.367l2.946-5.9c.108-.172-.086-.378-.235-.25l-8.033 7.173c-.828.65-1.37 1.725-1.37 2.934 0 1.974 1.448 3.59 3.218 3.59z",source:"https://github.com/zulip/zulip/blob/df9e40491dc77b658d943cff36a816d46e32ce1b/static/images/logo/zulip-org-logo.svg",hex:"FFFFFF",guidelines:void 0,license:void 0},siInteractjs={title:"InteractJS",slug:"interactjs",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>InteractJS</title><path d="'+this.path+'"/></svg>'},path:"M12.382.01C12.255.006 12.128 0 12 0A11.999 11.999 0 0 0 1.804 18.327l9.911-17.17zm7.097 19.686L11.201 5.121 2.788 19.689l.007.007h16.684zm.184 1.538H4.337a11.998 11.998 0 0 0 15.326 0zm2.917-3.568A11.999 11.999 0 0 0 12.382.01l.667 1.148zM12.383.009l-.001.001h.001V.009z",source:"https://github.com/taye/interact.js/blob/603c34d4b34dece8a260381e2e5991b810d6d739/img/ijs-icon.svg",hex:"2599ED",guidelines:void 0,license:void 0},siBentley={title:"Bentley",slug:"bentley",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Bentley</title><path d="'+this.path+'"/></svg>'},path:"M11.535 8.114a5.407 5.407 0 0 0-1.49.34c-.131.05-.269.135-.414.079-.654-.153-1.331-.096-1.992-.025-.859.09-1.72-.003-2.579-.045a21.543 21.543 0 0 0-2.349.05c-.713.044-1.429-.01-2.138-.086-.088-.002-.178-.02-.265-.002-.135.088-.22.232-.308.363v.068c.185.158.404.262.625.358-.062.151-.101.31-.13.47.264.124.54.227.796.368-.029.095-.072.186-.083.285-.006.059.024.121.083.142.21.11.448.142.665.23.021.01.05.02.05.048.017.128.02.258.047.385a.173.173 0 0 0 .057.035c.287.095.588.131.881.196.034.11.022.249.106.336.375.196.82.1 1.213.228.098.096.075.29.223.344.296.09.614.01.918.05.069.079.077.193.144.273a.249.249 0 0 0 .169.076c.287.008.562-.087.846-.12.059.099.087.247.213.277.229.045.452-.042.665-.116.08.26.166.521.303.758.473.858 1.288 1.499 2.198 1.841.128.036.172.175.238.276.127-.048.252-.102.384-.134l.2.297c.119-.06.237-.122.356-.184.08.094.16.187.242.28l.31-.22c.09.078.173.164.254.251h.035c.096-.085.187-.177.282-.263.106.077.21.156.316.235.081-.095.163-.19.246-.284.12.06.238.123.357.184.063-.098.124-.196.185-.295.14.031.27.089.404.136.033-.068.065-.138.102-.204.053-.142.22-.164.336-.232.972-.447 1.78-1.286 2.099-2.318.162.06.345.134.517.064.09-.046.125-.144.168-.228.24.053.48.154.73.102.13-.039.194-.161.253-.271.23.03.456.095.69.075.104-.013.247 0 .318-.096.059-.096.067-.215.124-.312.315-.042.648.042.954-.072.096-.108.097-.27.184-.383.247-.018.495 0 .742-.018a.286.286 0 0 0 .215-.123c.056-.107.064-.23.1-.344.007-.024.02-.05.044-.061.241-.1.534-.022.755-.177.108-.12.021-.31.088-.443.207-.118.477-.088.669-.241.129-.11.032-.282.014-.42.225-.077.472-.119.657-.279-.052-.14-.113-.275-.17-.412A4.67 4.67 0 0 0 24 8.871v-.087a1.176 1.176 0 0 0-.272-.34c-.071-.053-.17-.01-.25-.018-.696.062-1.396.13-2.095.092-.417-.022-.833-.062-1.25-.062-.522 0-1.044-.015-1.564.027-.77.046-1.544.103-2.313.017-.657-.077-1.335-.115-1.981.053-.103.043-.211.009-.305-.037-.516-.234-1.077-.348-1.638-.402zm.521.155c.327.014.654.049.974.122.31.072.622.149.91.287-.103.065-.227.164-.354.11a5.088 5.088 0 0 0-1.716-.29c-.326.02-.652.046-.97.125-.204.04-.4.116-.606.149-.096-.026-.184-.073-.272-.119a5.653 5.653 0 0 1 2.034-.384zm11.467.278c.17-.01.308.126.395.26a2.31 2.31 0 0 1-1.093.252c-1.65.027-3.298.095-4.947.137 0 .027.002.054.004.081a2.744 2.744 0 0 1-.048-.154c.361-.05.72-.12 1.085-.142.668-.05 1.34-.068 2.01-.075a.394.394 0 0 0 .245-.072c-.533-.057-1.07-.026-1.604-.013-.371.027-.744.033-1.114.08-.495.06-.989.154-1.489.16-.312.005-.625.032-.937.01-.39-.007-.786-.042-1.17.045-.108.035-.239.073-.282.192-.093.188.01.398.095.569.103.217.279.425.247.682-.015.091-.092.151-.162.203a2.4 2.4 0 0 1-.198-.251c.04-.08.106-.155.088-.252-.033-.2-.178-.358-.314-.498-.196-.19-.414-.367-.547-.61-.039-.07-.066-.17.009-.227.22-.156.491-.209.752-.252.715-.1 1.436-.015 2.153.015.353.035.709.03 1.063 0 .838-.054 1.68-.138 2.52-.082.378.021.757.038 1.135.047.692.028 1.38-.062 2.07-.101a.308.308 0 0 1 .034-.004zM.55 8.55c.196-.002.392.027.587.04.542.048 1.086.079 1.63.056.674-.008 1.345-.088 2.019-.052.687.022 1.37.098 2.058.119.525-.018 1.049-.06 1.574-.084.533-.017 1.087-.011 1.59.187.097.04.217.093.24.207-.02.158-.14.28-.238.399-.175.216-.429.36-.57.605-.11.14-.126.35-.005.488a1.808 1.808 0 0 1-.219.243c-.083-.076-.16-.17-.15-.292.038-.346.347-.593.383-.94.031-.121-.031-.239-.108-.327a1.155 1.155 0 0 0-.468-.124c-.562-.048-1.126.027-1.689-.007-.557.004-1.107-.093-1.657-.167a26.874 26.874 0 0 0-2.115-.106c-.195-.003-.39.015-.585.032.063.052.14.087.225.078.733.01 1.466.022 2.197.085.307.029.61.084.916.131l-.023.084c-.536-.033-1.074-.028-1.611-.05-.965-.035-1.93-.065-2.895-.081-.411-.027-.841.017-1.234-.134-.11-.037-.213-.088-.317-.136.076-.093.153-.199.27-.24.065-.01.13-.014.195-.014zm11.455.114a4.324 4.324 0 0 1 1.597.296c.004.104-.029.218.024.313a1.245 1.245 0 0 0 .16.229c.18.212.41.383.588.597a.716.716 0 0 1 .157.272 3.76 3.76 0 0 0-1.267-.755 3.848 3.848 0 0 0-3.158.28c-.174.098-.332.22-.486.348l-.152.128a.502.502 0 0 1 .06-.147c.223-.315.556-.533.781-.846.11-.133.1-.31.083-.47a5.558 5.558 0 0 1 1.613-.245zm5.762.455c.016.044.03.088.044.132-.313.18-.688.135-1.032.09-.078-.007-.124-.074-.155-.139.38-.041.763-.038 1.143-.083zm-11.55.016c.386.006.771.025 1.154.064-.03.051-.054.124-.122.132-.203.035-.41.041-.614.049-.158.01-.303-.062-.44-.129l.023-.116zm1.207.055c.154.003.309.005.463.014.41.017.831-.016 1.23.105.099.034.208.08.259.178.039.172-.06.325-.144.464-.083.151-.197.293-.235.464-.048.16.05.294.124.423-.112.004-.25.051-.338-.04-.041-.082.007-.179.024-.263l-.16.143-.195-.012c-.015-.203.141-.35.221-.521-.138.123-.278.297-.483.281-.081.003-.143-.104-.093-.169.111-.141.255-.254.359-.402-.124.096-.25.195-.397.251a.464.464 0 0 1-.326-.038c.018-.204.234-.276.35-.417-.127.053-.24.154-.387.145-.058.002-.115-.016-.17-.029-.01-.173.171-.234.273-.337-.09.02-.177.062-.27.06-.062-.022-.11-.072-.164-.108.015-.066.035-.13.06-.192zm9.156 0c.018.078.087.178-.005.237-.1.125-.268.022-.39-.002.112.096.285.167.284.343-.096.017-.2.05-.295.01-.088-.036-.173-.081-.259-.122.027.027.055.053.084.078l.087.076c.057.051.113.104.16.164.016.068-.033.14-.106.139-.233.059-.415-.127-.584-.254.089.121.195.226.297.335.051.054.046.135.064.203-.084.011-.174.044-.256.008-.128-.052-.225-.155-.33-.243.091.16.23.305.216.502l-.208.008a10.001 10.001 0 0 1-.137-.132c.008.082.06.176.007.25-.062.07-.158.065-.246.063-.03 0-.059 0-.086.003.047-.119.14-.222.137-.356-.036-.35-.358-.587-.406-.932-.01-.149.154-.218.273-.261.554-.145 1.133-.073 1.7-.117zM.698 9.192c.77 0 1.54.04 2.31.047.963.021 1.926.028 2.888.053.2-.014.365.116.53.207l-.018.19a5.46 5.46 0 0 1-.089.043l.026-.073c-.899.024-1.796.085-2.695.112-.566.012-1.13.06-1.697.05A3.707 3.707 0 0 1 .89 9.705c-.115-.034-.247-.052-.338-.137-.001-.135.073-.264.145-.376zm22.62.022c.064.111.132.222.179.342-.43.14-.89.133-1.336.116-.828-.002-1.656-.055-2.484-.083-.699-.032-1.398-.06-2.097-.1.143-.102.305-.202.486-.196 1.751-.007 3.501-.078 5.252-.08zm-16.073.214c.077.005.136.074.194.12a.138.138 0 0 1 .05.116c-.078.06-.181.068-.273.092-.186.034-.37.09-.56.097-.067-.026-.14-.055-.185-.116-.016-.084.01-.2.104-.222.21-.042.425-.054.636-.085a.139.139 0 0 1 .034-.002zm9.465.008c.235 0 .47.03.7.073.109.021.106.15.134.234-.09.05-.177.13-.29.107-.163-.025-.323-.066-.485-.096-.087-.022-.187-.029-.258-.09.005-.108.116-.177.2-.228zm-4.785.138c.908-.02 1.842.29 2.495.935.358.365.62.856.612 1.377.01.47-.199.926-.507 1.274-.566.642-1.415.983-2.256 1.046a3.577 3.577 0 0 1-2.17-.514c-.345-.22-.66-.5-.867-.858a1.853 1.853 0 0 1-.227-1.365c.099-.415.356-.774.668-1.057.565-.51 1.318-.775 2.07-.83.06-.004.121-.006.182-.008zm5.64.023c.218-.005.435.025.653.035 1.44.088 2.882.14 4.322.224.093.014.198-.004.283.043.057.083.072.185.087.283-.302.185-.678.14-1.015.149-.425-.028-.85-.08-1.274-.121a15.638 15.638 0 0 0-.425-.036c-.872-.087-1.747-.139-2.615-.258a1.474 1.474 0 0 0-.016-.32zm-5.553.01c-.116 0-.23.005-.345.016-.805.077-1.627.39-2.161 1.02-.308.348-.518.809-.484 1.282.018.674.448 1.273.985 1.65.884.618 2.057.75 3.079.44.46-.149.903-.38 1.245-.727.428-.414.714-1.017.635-1.622-.065-.495-.35-.941-.723-1.265-.61-.536-1.425-.795-2.231-.794zm-5.915.175c.059 0 .118 0 .178.002.148.042.249.167.359.266-.027.077-.05.155-.072.234.072.057.149.108.23.15-.517.084-1.03.193-1.544.292l-.464.102-.465.098c-.31.063-.621.123-.934.174-.405.072-.828.05-1.222-.069-.113-.032-.141-.162-.095-.262.017-.1.141-.09.215-.105 1.276-.13 2.548-.295 3.82-.447.178-.019.38-.023.51-.163-.701.064-1.402.142-2.102.22l-1.051.113c-.35.036-.701.07-1.052.1-.394.04-.802.002-1.17-.153a1.65 1.65 0 0 1 .144-.328c1.393-.063 2.789-.092 4.18-.195.178-.008.356-.025.535-.029zm1.256.064a.56.56 0 0 1 .122.008c.084.025.162.067.24.105-.009.132-.138.166-.238.212-.125.051-.247.11-.375.153-.162.052-.325-.028-.474-.087.02-.068.028-.144.07-.203a.916.916 0 0 1 .297-.12c.117-.03.237-.064.358-.068zm9.248 0c.177-.004.35.054.517.106.064.026.144.036.192.092.032.06.04.13.064.192-.146.053-.302.145-.462.093a6.866 6.866 0 0 1-.632-.271c.018-.123.137-.18.245-.206a.718.718 0 0 1 .076-.006zm.887.172c.239-.004.474.041.711.066.758.085 1.517.168 2.276.246.543.068 1.09.108 1.632.19.013.107.126.312-.033.35a4.135 4.135 0 0 1-1.12.025c-1.182-.184-2.36-.394-3.544-.566a4.356 4.356 0 0 0-.024-.307c.034-.002.068-.004.102-.004zm-5.377.111c.253.001.504.032.748.103.282.084.568.226.73.482.111.16.124.368.087.554-.056.226-.263.365-.442.492l.004.042c.265.181.554.434.545.785.025.254-.11.492-.293.657-.129.098-.27.183-.422.241-.43.149-.892.168-1.342.138-.552-.069-1.13-.224-1.537-.627.07-.094.16-.17.224-.268a23.17 23.17 0 0 0 .006-1.615c-.066-.099-.157-.177-.231-.27.274-.375.732-.545 1.17-.64.247-.047.5-.075.753-.074zm4.163.063c.029 0 .058.001.086.008.169.065.332.144.494.225.036.024.09.036.106.082.004.08-.034.168-.113.197-.115.048-.253.078-.37.024-.191-.084-.365-.202-.544-.307.017-.042.025-.095.054-.13a.1.1 0 0 1 .038-.027.606.606 0 0 1 .249-.072zm-8.563 0a.555.555 0 0 1 .276.078c.065.031.079.14.017.18-.162.11-.332.21-.514.281-.143.047-.287-.007-.42-.053l-.04-.194c.168-.088.34-.173.514-.25a.36.36 0 0 1 .167-.042zm4.37.172a2.535 2.535 0 0 0-.282.015.623.623 0 0 0-.361.168c-.163.169-.176.422-.145.641a.563.563 0 0 0 .367.487c.233.079.49.075.725.01.254-.085.382-.362.376-.614.013-.213-.04-.462-.231-.586a.807.807 0 0 0-.449-.12zm5.287.085c.27.006.54.052.806.099.833.15 1.666.301 2.498.458.21.043.423.079.63.138-.028.125-.043.32-.202.344-.513.065-1.028-.05-1.52-.187-.814-.22-1.637-.414-2.45-.64a.435.435 0 0 0-.149-.007c.013-.052.017-.107.042-.154.064-.048.153-.045.229-.05h.116zm-10.387.055c.028.114.052.229.097.337-.634.195-1.267.39-1.904.572-.338.097-.67.223-1.02.27-.316.028-.64.013-.948-.066-.126-.034-.16-.17-.163-.284.89-.193 1.777-.399 2.67-.577.422-.085.839-.203 1.268-.252zm8.897.051a.266.266 0 0 1 .177.063c.15.099.297.2.448.296a.196.196 0 0 0-.014.043l-.01.047c-.009.032-.021.061-.05.077-.13.014-.269.043-.396-.006a2.215 2.215 0 0 1-.396-.324c-.046-.039-.041-.116-.002-.158a.093.093 0 0 1 .05-.027c.061-.003.128-.013.193-.01zm-7.713 0c.051 0 .102.004.152.01.069.017.116.122.047.169-.156.156-.318.354-.557.365-.08-.001-.16.002-.238-.015-.057-.038-.052-.12-.071-.176.173-.11.338-.231.516-.333a.63.63 0 0 1 .15-.02zm8.857.204c.162.017.316.07.473.108.766.225 1.533.447 2.298.674.143.043.289.079.426.138-.038.095-.074.203-.163.262a2.07 2.07 0 0 1-1.1-.072c-.27-.103-.527-.233-.792-.346-.48-.205-.958-.419-1.445-.61.103-.047.195-.121.303-.154zm-1.563.04c.105 0 .19.084.266.148.072.072.167.131.212.225.015.085-.055.159-.079.235-.104-.02-.234.02-.318-.066a1.57 1.57 0 0 1-.322-.397c-.016-.086.083-.138.163-.141l.032.001a.202.202 0 0 1 .046-.005zm-6.891.004a.423.423 0 0 1 .23.082 1.5 1.5 0 0 1-.34.455c-.074.09-.2.075-.3.045-.063-.047-.086-.13-.124-.196.123-.127.24-.262.389-.359a.32.32 0 0 1 .145-.027zm-1.326.12a.848.848 0 0 1 .108.002c.102.015.115.135.153.212-.178.06-.341.153-.508.236-.434.208-.857.435-1.29.645-.295.156-.643.13-.966.133-.09-.009-.191 0-.27-.052-.052-.067-.074-.152-.1-.232.245-.124.516-.18.77-.283.456-.172.924-.31 1.384-.47.238-.067.471-.179.72-.19zm7.692.011c.093.022.207.015.277.091.098.133.197.272.253.428-.018.12-.154.2-.272.195-.04-.253-.148-.485-.258-.714zm-5.888.003a2.99 2.99 0 0 0-.242.718c-.095-.022-.214-.046-.256-.147-.03-.05-.001-.105.022-.15a2.1 2.1 0 0 1 .225-.346c.071-.054.167-.054.251-.075zm7.515.028c.182.033.342.134.508.212.661.309 1.32.623 1.977.942-.013.07-.011.154-.059.214-.163.063-.344.037-.513.02-.206-.023-.42-.047-.601-.16-.507-.315-.98-.687-1.509-.966.115-.042.154-.159.197-.262zm-8.832.254c.09 0 .18.014.267.042-.194.232-.456.392-.695.571-.28.19-.538.417-.85.553a2.027 2.027 0 0 1-.761.104c-.112-.014-.161-.118-.166-.22.587-.32 1.187-.615 1.774-.933a.83.83 0 0 1 .43-.117zm8.426.018a.6.6 0 0 1 .321.134c.449.335.896.674 1.346 1.007.06.031.091.091.116.152-.126.054-.263.12-.403.078-.041-.01-.084-.018-.126-.027a.946.946 0 0 1-.364-.13c-.427-.27-.773-.65-1.206-.912.092-.082.12-.21.206-.293a.399.399 0 0 1 .11-.009zm-8.156.176c.114.178.334.117.508.165-.38.273-.666.652-1.042.93-.228.169-.583.234-.814.037.113-.175.29-.29.447-.423.3-.236.593-.483.901-.709zm7.554.125c.11.023.233.032.319.116.284.24.551.498.836.738.097.09.227.167.238.315-.095.035-.202.075-.302.033a.672.672 0 0 1-.071-.023c-.162-.063-.295-.183-.424-.297a9.813 9.813 0 0 0-.769-.679c.056-.069.114-.137.173-.203zm-7.068.176c.102.027.201.065.303.091.013.1.02.2.026.3-.174.175-.307.406-.541.51-.156.06-.327.081-.493.06-.057-.012-.097-.057-.138-.095.278-.292.54-.6.843-.866zm6.729.073c.151-.002.25.118.344.218.196.228.42.428.622.649-.043.057-.09.136-.18.106a.738.738 0 0 1-.311-.05c-.208-.1-.345-.293-.522-.433l.047-.49zm-3.103.132a1.564 1.564 0 0 0-.255.014c-.274.032-.537.235-.584.515-.03.271-.019.602.204.796.147.12.34.16.525.176.258.008.56-.033.72-.264.175-.264.176-.623.054-.908-.132-.24-.401-.322-.664-.33zm-3.303.33c.066.17.114.346.16.522-.12-.023-.302-.01-.37-.138-.033-.161.117-.274.21-.383zm6.349.15c.087.077.204.181.17.31-.067.117-.218.118-.335.13a33.1 33.1 0 0 0 .165-.44zm-6.69.321c.093.077.195.157.319.176.08.024.173.018.245.063.156.191.294.399.488.555.299.277.658.469.995.692-.058.24-.213.437-.339.644-.92-.353-1.719-1.07-2.085-1.995.126-.042.252-.087.376-.135zm6.993.063c.093.037.186.075.28.11-.185.51-.532.95-.94 1.301a3.133 3.133 0 0 1-1.012.6c-.08-.14-.166-.278-.236-.424-.02-.05-.052-.118-.01-.165.098-.098.227-.156.346-.224.248-.148.476-.327.686-.526.14-.134.228-.312.357-.456.11-.043.238-.024.347-.074.07-.036.124-.092.182-.142zm-7.67.07l.204.003c.174.43.422.837.76 1.157.207.187.408.384.649.527.23.152.482.262.73.38a1.417 1.417 0 0 1-.089.2 4.51 4.51 0 0 1-.699-.352c-.3-.177-.55-.421-.8-.66-.26-.253-.43-.58-.604-.894-.065-.114-.106-.239-.15-.361zm8.027.058l.22.02a3.174 3.174 0 0 1-.847 1.33c-.372.34-.785.665-1.272.82-.034-.07-.068-.14-.1-.212.305-.137.61-.289.87-.504.48-.388.91-.868 1.129-1.454zm-1.348.433c-.19.266-.485.42-.746.605-.12.093-.29.15-.339.31.011.094.087.164.13.245.108.186.215.374.302.57.048.124-.001.252-.048.367-.158-.043-.334-.115-.403-.275-.133-.241-.13-.544-.315-.76-.017.322.216.582.255.893-.016.109-.084.202-.136.297-.139-.078-.31-.156-.343-.329-.095-.256-.037-.563-.192-.797-.063.223.046.44.088.656.023.134.082.303-.023.417a2.76 2.76 0 0 1-.106.133c-.105-.075-.24-.145-.275-.28-.059-.26-.016-.53-.064-.79-.014-.033-.037-.059-.058-.086-.07.31.085.616.047.928-.042.112-.135.229-.26.25-.115-.08-.222-.2-.221-.35-.015-.271.087-.535.073-.807l-.073-.002c-.037.23-.018.465-.033.697a.487.487 0 0 1-.104.294c-.06.054-.127.1-.197.142-.063-.066-.135-.13-.173-.216-.034-.13.013-.26.04-.388.047-.192.115-.384.106-.584h-.066c-.083.259-.081.533-.154.794a.468.468 0 0 1-.273.295c-.054.024-.119-.014-.14-.066-.097-.123-.048-.289-.005-.423.086-.222.192-.439.24-.674l-.066-.027c-.14.26-.174.564-.32.821a.478.478 0 0 1-.311.24c-.045.015-.08-.022-.1-.057a.386.386 0 0 1-.005-.334c.112-.241.27-.46.38-.702.02-.066.056-.155.001-.213-.22-.226-.546-.3-.77-.522.233.138.459.296.716.386.923.372 1.99.383 2.915.011.39-.136.729-.387 1.026-.669Z",source:"https://en.wikipedia.org/wiki/File:Bentley_logo_2.svg",hex:"333333",guidelines:void 0,license:void 0},siIntercom={title:"Intercom",slug:"intercom",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Intercom</title><path d="'+this.path+'"/></svg>'},path:"M21 0H3C1.343 0 0 1.343 0 3v18c0 1.658 1.343 3 3 3h18c1.658 0 3-1.342 3-3V3c0-1.657-1.342-3-3-3zm-5.801 4.399c0-.44.36-.8.802-.8.44 0 .8.36.8.8v10.688c0 .442-.36.801-.8.801-.443 0-.802-.359-.802-.801V4.399zM11.2 3.994c0-.44.357-.799.8-.799s.8.359.8.799v11.602c0 .44-.357.8-.8.8s-.8-.36-.8-.8V3.994zm-4 .405c0-.44.359-.8.799-.8.443 0 .802.36.802.8v10.688c0 .442-.36.801-.802.801-.44 0-.799-.359-.799-.801V4.399zM3.199 6c0-.442.36-.8.802-.8.44 0 .799.358.799.8v7.195c0 .441-.359.8-.799.8-.443 0-.802-.36-.802-.8V6zM20.52 18.202c-.123.105-3.086 2.593-8.52 2.593-5.433 0-8.397-2.486-8.521-2.593-.335-.288-.375-.792-.086-1.128.285-.334.79-.375 1.125-.09.047.041 2.693 2.211 7.481 2.211 4.848 0 7.456-2.186 7.479-2.207.334-.289.839-.25 1.128.086.289.336.25.84-.086 1.128zm.281-5.007c0 .441-.36.8-.801.8-.441 0-.801-.36-.801-.8V6c0-.442.361-.8.801-.8.441 0 .801.357.801.8v7.195z",source:"https://www.intercom.com/press",hex:"6AFDEF",guidelines:"https://www.intercom.com/press",license:void 0},siAndroidstudio={title:"Android Studio",slug:"androidstudio",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Android Studio</title><path d="'+this.path+'"/></svg>'},path:"M19.2693 10.3368c-.3321 0-.6026.2705-.6026.6031v9.8324h-1.7379l-3.3355-6.9396c.476-.5387.6797-1.286.5243-2.0009a2.2862 2.2862 0 0 0-1.2893-1.6248v-.8124c.0121-.2871-.1426-.5787-.4043-.7407-.1391-.0825-.2884-.1234-.4402-.1234a.8478.8478 0 0 0-.4318.1182c-.2701.1671-.4248.4587-.4123.7662l-.0003.721c-1.0149.3668-1.6619 1.4153-1.4867 2.5197a2.282 2.282 0 0 0 .5916 1.2103l-3.2096 6.9064H4.0928c-1.0949-.007-1.9797-.8948-1.9832-1.9896V5.016c-.0055 1.1024.8836 2.0006 1.9859 2.0062a2.024 2.024 0 0 0 .1326-.0037h14.7453s2.5343-.2189 2.8619 1.5392c-.2491.0287-.4449.2321-.4449.4889 0 .7115-.5791 1.2901-1.3028 1.2901h-.8183zM17.222 22.5366c.2347.4837.0329 1.066-.4507 1.3007-.1296.0629-.2666.0895-.4018.0927a.9738.9738 0 0 1-.3194-.0455c-.024-.0078-.046-.0209-.0694-.0305a.9701.9701 0 0 1-.2277-.1321c-.0247-.0192-.0495-.038-.0724-.0598-.0825-.0783-.1574-.1672-.21-.2757l-1.2554-2.6143-1.5585-3.2452a.7725.7725 0 0 0-.6995-.4443h-.0024a.792.792 0 0 0-.7083.4443l-1.5109 3.2452-1.2321 2.6464a.9722.9722 0 0 1-.7985.5795c-.0626.0053-.1238-.0024-.185-.0087-.0344-.0036-.069-.0053-.1025-.0124-.0489-.0103-.0954-.0278-.142-.0452-.0301-.0113-.0613-.0197-.0901-.0339-.0496-.0244-.0948-.0565-.1397-.0889-.0217-.0156-.0457-.0275-.0662-.045a.9862.9862 0 0 1-.1695-.1844.9788.9788 0 0 1-.0708-.9852l.8469-1.8223 3.2676-7.0314a1.7964 1.7964 0 0 1-.7072-1.1637c-.1555-.9799.5129-1.9003 1.4928-2.0559V9.3946a.3542.3542 0 0 1 .1674-.3155.3468.3468 0 0 1 .3541 0 .354.354 0 0 1 .1674.3155v1.159l.0129.0064a1.8028 1.8028 0 0 1 1.2878 1.378 1.7835 1.7835 0 0 1-.6439 1.7836l3.3889 7.0507.8481 1.7643zM12.9841 12.306c.0042-.6081-.4854-1.1044-1.0935-1.1085a1.1204 1.1204 0 0 0-.7856.3219 1.101 1.101 0 0 0-.323.7716c-.0042.6081.4854 1.1044 1.0935 1.1085h.0077c.6046 0 1.0967-.488 1.1009-1.0935zm-1.027 5.2768c-.1119.0005-.2121.0632-.2571.1553l-1.4127 3.0342h3.3733l-1.4564-3.0328a.274.274 0 0 0-.2471-.1567zm8.1432-6.7459l-.0129-.0001h-.8177a.103.103 0 0 0-.103.103v12.9103a.103.103 0 0 0 .0966.103h.8435c.9861-.0035 1.7836-.804 1.7836-1.79V9.0468c0 .9887-.8014 1.7901-1.7901 1.7901zM2.6098 5.0161v.019c.0039.816.6719 1.483 1.4874 1.4869a12.061 12.061 0 0 1 .1309-.0034h1.1286c.1972-1.315.7607-2.525 1.638-3.4859H4.0993c-.9266.0031-1.6971.6401-1.9191 1.4975.2417.0355.4296.235.4296.4859zm6.3381-2.8977L7.9112.3284a.219.219 0 0 1 0-.2189A.2384.2384 0 0 1 8.098 0a.219.219 0 0 1 .1867.1094l1.0496 1.8158a6.4907 6.4907 0 0 1 5.3186 0L15.696.1094a.2189.2189 0 0 1 .3734.2189l-1.0302 1.79c1.6671.9125 2.7974 2.5439 3.0975 4.4018l-12.286-.0014c.3004-1.8572 1.4305-3.488 3.0972-4.4003zm5.3774 2.6202a.515.515 0 0 0 .5271.5028.515.515 0 0 0 .5151-.5151.5213.5213 0 0 0-.8885-.367.5151.5151 0 0 0-.1537.3793zm-5.7178-.0067a.5151.5151 0 0 0 .5207.5095.5086.5086 0 0 0 .367-.1481.5215.5215 0 1 0-.734-.7341.515.515 0 0 0-.1537.3727z",source:"https://developer.android.com/studio/",hex:"3DDC84",guidelines:void 0,license:void 0},siIntermarche={title:"Intermarche",slug:"intermarche",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Intermarche</title><path d="'+this.path+'"/></svg>'},path:"m9.948 13.05.677 1.18h12.782l.15-1.18zm1.961-2.556a3.209 3.209 0 0 0-.694.071 1.72 1.72 0 0 0-.537-.07 2.699 2.699 0 0 0-1.007.168l-.215 1.53.317.552h.384l.254-1.834a.648.648 0 0 1 .2-.03c.17 0 .229.086.23.192l-.234 1.672h.782l.215-1.525a1 1 0 0 0 .008-.093l.03-.214a.646.646 0 0 1 .201-.029c.197 0 .246.115.227.25l-.22 1.608h.778l.215-1.524c.062-.442-.185-.72-.93-.72M8.88 11.88a.725.725 0 0 0 .438-.593l.012-.078h-.004c.062-.442-.185-.72-.93-.72a2.699 2.699 0 0 0-1.007.17v.003L7.1 12.741h.778l.104-.74h.2l1.466 2c.097.13.219.23.375.23h.208l-1.355-2.352zm-.32-.755-.01.084-.025.165a.27.27 0 0 1-.3.247h-.19l.01-.078.09-.638a.64.64 0 0 1 .202-.03c.197 0 .247.114.227.25zm-3.84 1.503c.014-.102-.023-.174-.145-.174h-.09c-.197 0-.247-.114-.228-.25l.165-1.178v-.015l.01-.078h.21a.058.058 0 0 1 .02 0c.113 0 .207-.115.231-.289H4.47l.122-.871c-.558.061-.815.32-.871.705l-.066.434-.006.042-.004.03-.14 1.04c-.061.432.17.707.876.72h.322l.016-.114m1.416-2.14a2.699 2.699 0 0 0-1.007.17l-.119.846-.068.509c-.06.43.175.705.877.718h.853l.015-.102c.015-.103-.021-.186-.143-.186H5.92c-.197 0-.246-.114-.227-.25l.025-.186h.244c.714-.01 1.03-.283 1.092-.713l.012-.079h-.004c.06-.44-.187-.719-.931-.719zm.166.642-.011.085-.027.155a.27.27 0 0 1-.3.247h-.191l.01-.078.09-.638a.642.642 0 0 1 .202-.029c.196 0 .245.115.226.25zm16.764-.642a2.696 2.696 0 0 0-1.005.17l-.12.846-.068.509c-.06.43.175.705.876.718h.854l.015-.103c.015-.103-.022-.185-.144-.185h-.625c-.196 0-.246-.114-.226-.25l.025-.186h.244c.713-.01 1.03-.283 1.092-.713l.012-.079h-.004c.061-.44-.186-.719-.93-.719zm.163.642-.01.085-.025.164a.271.271 0 0 1-.3.247h-.191l.01-.077.09-.639a.643.643 0 0 1 .202-.028c.196-.01.246.105.226.24zm-9.025-.632h-.665c-.116 0-.208.115-.233.29h.794c.197 0 .246.121.227.253l-.034.247h-.258c-.703.013-1.017.284-1.078.713l-.012.078h.007c-.06.44.187.719.933.719.342.008.684-.05 1.005-.17l.12-.847.075-.564c.06-.43-.175-.713-.876-.726zm.024 1.245-.09.645a.642.642 0 0 1-.201.03c-.196 0-.245-.115-.227-.25l.01-.085.026-.165a.27.27 0 0 1 .298-.248h.192l-.01.077zm3.16-.456.012-.079h.005c.06-.44-.187-.718-.93-.718a2.698 2.698 0 0 0-1.007.17v.003l-.293 2.08h.778l.104-.74h.198l.437.739h.778l-.513-.862a.725.725 0 0 0 .438-.593zm-.747-.165-.01.085-.039.163a.27.27 0 0 1-.3.247h-.19l.01-.078.09-.638a.64.64 0 0 1 .201-.029c.201.001.25.115.232.25zm2.604 1.33.018-.132a3.28 3.28 0 0 1-.647.073h-.06c-.196 0-.245-.115-.227-.254l.065-.479.018-.136.07-.477a.27.27 0 0 1 .296-.254h.06c.21-.002.42.02.624.067l.018-.137c.016-.114.027-.207-.127-.236a3.265 3.265 0 0 0-.537-.037c-.744 0-1.07.277-1.13.718l-.117.835c-.06.44.188.719.932.719.194 0 .388-.015.58-.048.085-.02.14-.058.165-.236m1.486-1.946c-.072 0-.143.002-.21.006l.1-.73c-.558.061-.815.32-.87.706l-.071.507-.247 1.76h.778l.254-1.834a.646.646 0 0 1 .2-.029c.197 0 .246.114.227.25l-.227 1.613h.778l.216-1.524c.062-.442-.186-.72-.932-.72M.865 11.51l.007-.055.243-1.684h-.78l-.27 1.843v.007l-.056.424c-.054.385.128.646.67.706l.18-1.239m22.771-1.53h-1.07l-.042.29h.878c.115 0 .208-.116.233-.29M2.274 12.741l.227-1.613c.019-.135-.03-.25-.227-.25a.64.64 0 0 0-.2.03l-.254 1.833h-.78l.293-2.079a2.69 2.69 0 0 1 1.006-.17c.745 0 .992.28.93.72l-.214 1.525h-.778",source:"https://www.intermarche.com/",hex:"E2001A",guidelines:void 0,license:void 0},siInternetarchive={title:"Internet Archive",slug:"internetarchive",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Internet Archive</title><path d="'+this.path+'"/></svg>'},path:"M22.667 22.884V24H1.333v-1.116zm-.842-1.675v1.396H2.175v-1.396zM4.233 6.14l.234.118.118 1.882.117 3.058v2.941l-.117 3.666-.02 2.47-.332.098H3.062l-.352-.098-.136-2.47-.118-3.646v-2.941l.118-3.078.107-1.892.244-.107zm16.842 0l.235.118.117 1.882.117 3.058v2.941l-.117 3.666-.02 2.47-.332.098h-1.171l-.352-.098-.137-2.47-.117-3.646v-2.941l.117-3.078.108-1.892.244-.107zm-11.79 0l.235.118.117 1.882.117 3.058v2.941l-.117 3.666-.02 2.47-.331.098H8.114l-.352-.098-.136-2.47-.117-3.646v-2.941l.117-3.078.107-1.892.244-.107zm6.457 0l.234.118.117 1.882.118 3.058v2.941l-.118 3.666-.019 2.47-.332.098H14.57l-.351-.098-.137-2.47-.117-3.646v-2.941l.117-3.078.108-1.892.244-.107zm6.083-2.511V5.58H2.175V3.628zM11.798 0l10.307 2.347-.413.723H1.951l-.618-.587Z",source:"https://archive.org/",hex:"666666",guidelines:void 0,license:void 0},siVivaldi={title:"Vivaldi",slug:"vivaldi",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Vivaldi</title><path d="'+this.path+'"/></svg>'},path:"M12 0C6.75 0 3.817 0 1.912 1.904.007 3.81 0 6.75 0 12s0 8.175 1.912 10.08C3.825 23.985 6.75 24 12 24c5.25 0 8.183 0 10.088-1.904C23.993 20.19 24 17.25 24 12s0-8.175-1.912-10.08C20.175.015 17.25 0 12 0zm-.168 3a9 9 0 016.49 2.648 9 9 0 010 12.704A9 9 0 1111.832 3zM7.568 7.496a1.433 1.433 0 00-.142.004A1.5 1.5 0 006.21 9.75l1.701 3c.93 1.582 1.839 3.202 2.791 4.822a1.417 1.417 0 001.41.75 1.5 1.5 0 001.223-.81l4.447-7.762A1.56 1.56 0 0018 8.768a1.5 1.5 0 10-2.828.914 2.513 2.513 0 01.256 1.119v.246a2.393 2.393 0 01-2.52 2.13 2.348 2.348 0 01-1.965-1.214c-.307-.51-.6-1.035-.9-1.553-.42-.72-.826-1.41-1.246-2.16a1.433 1.433 0 00-1.229-.754Z",source:"https://vivaldi.com/press/",hex:"EF3939",guidelines:void 0,license:void 0},siInvoiceninja={title:"Invoice Ninja",slug:"invoiceninja",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Invoice Ninja</title><path d="'+this.path+'"/></svg>'},path:"M16.247 10.326a1.164 1.164 0 11-2.328 0 1.164 1.164 0 012.328 0zm-6.288 0a1.164 1.164 0 11-2.329 0 1.164 1.164 0 012.329 0zm-.14 13.52c-4.712-.98-8.227-4.257-9.482-8.842-.421-1.537-.421-4.49 0-6.027C1.506 4.709 4.73 1.485 8.997.316c1.538-.421 4.49-.421 6.028 0 4.267 1.169 7.492 4.393 8.66 8.66.24.874.294 1.43.294 3.014 0 1.584-.054 2.14-.293 3.014-1.17 4.271-4.439 7.536-8.661 8.65-1.391.367-3.916.46-5.206.192zm6.64-9.315c-3.047-1.348-4.054-1.737-4.5-1.737-.446 0-1.433.38-4.38 1.684-2.091.926-3.828 1.76-3.86 1.79h16.663zm-9.873-.361c1.621-.729 3.06-1.387 3.196-1.464.258-.145.337-.09-5.285-3.682-.56-.358-1.023-.698-1.025-.65V15.564a790.1 790.1 0 003.114-1.394zm14.078-2.194V8.417c0-.11-1.676.993-3.496 2.12-3 1.854-3.281 2.06-3.004 2.185 1.345.611 6.42 2.862 6.5 2.872zm-8.169.11c.545.125.643.104 1.226-.263.349-.22.655-.419.681-.442.026-.024-.05-.181-.167-.35-.118-.168-.215-.5-.215-.739V9.86l-.569.21c-.726.267-2.28.27-3 .005l-.556-.205.013.452c.007.26-.088.563-.225.715-.232.256-.22.276.45.726.64.432.725.455 1.23.327a2.349 2.349 0 011.132-.002zm-4.23-2.65c-.105-.113-2.97-.954-3.033-.891-.03.03.504.414 1.186.854l1.24.8.34-.344c.186-.188.307-.377.268-.42zm9.76-.373c.473-.306.8-.555.728-.555-.155 0-2.877.804-3.027.894-.057.034.033.229.2.433l.304.37.47-.293c.257-.162.854-.544 1.326-.85zm-1.636-.555c2.11-.59 3.867-1.102 3.904-1.139H3.59c.187.187 7.779 2.195 8.323 2.202.41.005 2.014-.376 4.476-1.063z",source:"https://github.com/invoiceninja/invoiceninja/blob/2bdb26dd06123a0426cc7a8da77fc8fce7e5a222/public/images/round_logo.png",hex:"000000",guidelines:void 0,license:void 0},siCoderwall={title:"Coderwall",slug:"coderwall",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Coderwall</title><path d="'+this.path+'"/></svg>'},path:"M21.354 18.708c1.46 0 2.646 1.185 2.646 2.646C24 22.814 22.814 24 21.354 24s-2.646-1.186-2.646-2.646c0-1.458 1.185-2.646 2.646-2.646zM12 9.354c1.46 0 2.646 1.186 2.646 2.646S13.46 14.646 12 14.646 9.354 13.46 9.354 12 10.54 9.354 12 9.354zm9.354 0C22.814 9.354 24 10.54 24 12s-1.186 2.646-2.646 2.646S18.708 13.46 18.708 12s1.185-2.646 2.646-2.646zM12 0c1.46 0 2.646 1.185 2.646 2.646 0 1.46-1.186 2.646-2.646 2.646S9.354 4.106 9.354 2.646 10.54 0 12 0zM2.646 0c1.46 0 2.646 1.185 2.646 2.646 0 1.46-1.186 2.646-2.646 2.646S0 4.106 0 2.646 1.186 0 2.646 0zm18.708 0C22.814 0 24 1.185 24 2.646c0 1.46-1.186 2.646-2.646 2.646s-2.646-1.186-2.646-2.646S19.893 0 21.354 0z",source:"https://github.com/twolfson/coderwall-svg",hex:"3E8DCC",guidelines:void 0,license:void 0},siIobroker={title:"ioBroker",slug:"iobroker",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>ioBroker</title><path d="'+this.path+'"/></svg>'},path:"M12 0c-.61 0-1.201.044-1.787.133v3.285a8.943 8.943 0 013.574.004V.139A11.83 11.83 0 0012 0zM9.38.295C4.084 1.5.13 6.283.13 12 .129 18.628 5.44 24 12 24s11.871-5.372 11.871-12c0-5.717-3.953-10.499-9.246-11.705v3.34c3.575 1.113 6.18 4.44 6.18 8.365 0 4.83-3.949 8.76-8.8 8.76-4.85 0-8.804-3.93-8.804-8.76 0-3.924 2.605-7.247 6.18-8.365V.295zM12 4.137c-.616 0-1.212.068-1.783.2V19.53A7.887 7.887 0 0012 19.73c.616 0 1.211-.068 1.787-.2V4.343A7.65 7.65 0 0012 4.137Z",source:"https://github.com/ioBroker/awesome-iobroker/blob/6ba42e9fcda7c88356e2f8c98f435ce7b02d4e37/images/awesome-iobroker.svg",hex:"3399CC",guidelines:void 0,license:void 0},siImmer={title:"Immer",slug:"immer",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Immer</title><path d="'+this.path+'"/></svg>'},path:"M2.2706 14.3327C1.0174 14.3327 0 13.3149 0 12.0612s1.0174-2.2714 2.2706-2.2714 2.2706 1.0178 2.2706 2.2714-1.0175 2.2715-2.2706 2.2715zm19.4594.8587a3.1215 3.1215 0 0 1-1.8217-.5845c-.7428.8369-1.0466 1.047-2.0669 1.047-1.5417 0-3.1201-2.3208-4.5579-4.3146 1.4966-2.3358 2.8703-3.8786 4.3307-3.8786 1.1153 0 2.1849.4937 2.7865 1.7668a3.1155 3.1155 0 0 1 1.3291-.2958 3.1051 3.1051 0 0 1 1.1697.2262c-.88-2.5989-2.9964-3.9134-5.1127-3.9134-2.3344 0-4.0593 2.16-5.5753 4.6292-1.7833-2.4318-3.4838-4.6292-5.9239-4.6292-2.0769 0-4.154 1.2863-5.0431 3.8295a3.1179 3.1179 0 0 1 .9355-.1423 3.113 3.113 0 0 1 1.7177.5139c.546-.7723 1.2454-1.2347 2.0074-1.2095 1.5368.0516 2.9282 1.8499 4.6866 4.3248-1.2802 1.9587-2.9227 3.8683-4.3102 3.8683-1.0566 0-2.0739-.4443-2.6895-1.5742a3.1139 3.1139 0 0 1-1.412.3362c-.371.0066-.7336-.0773-1.085-.1857.9316 2.417 2.9722 3.6396 5.0129 3.6396 2.326 0 3.9314-2.0555 5.5251-4.6143 1.7485 2.4637 3.4992 4.7244 5.9921 4.7244 2.0245 0 4.2973-1.3328 5.2229-3.7499-.3583.0875-.7236.1989-1.118.1861zm-.0006-5.4016c-1.2531 0-2.2705 1.0178-2.2705 2.2714s1.0174 2.2715 2.2705 2.2715c1.2532 0 2.2706-1.0178 2.2706-2.2715s-1.0174-2.2714-2.2706-2.2714z",source:"https://github.com/immerjs/immer/blob/7a5382899bc8b0bf5e21972a1c7db63f53e1d697/website/static/img/immer-logo.svg",hex:"00E7C3",guidelines:void 0,license:void 0},siIonic={title:"Ionic",slug:"ionic",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Ionic</title><path d="'+this.path+'"/></svg>'},path:"M22.922 7.027l-.103-.23-.169.188c-.408.464-.928.82-1.505 1.036l-.159.061.066.155a9.745 9.745 0 0 1 .75 3.759c0 5.405-4.397 9.806-9.806 9.806-5.409 0-9.802-4.397-9.802-9.802 0-5.405 4.402-9.806 9.806-9.806 1.467 0 2.883.319 4.2.947l.155.075.066-.155a3.767 3.767 0 0 1 1.106-1.453l.197-.159-.225-.117A11.905 11.905 0 0 0 12.001.001c-6.619 0-12 5.381-12 12s5.381 12 12 12 12-5.381 12-12c0-1.73-.361-3.403-1.078-4.973zM12 6.53A5.476 5.476 0 0 0 6.53 12 5.476 5.476 0 0 0 12 17.47 5.476 5.476 0 0 0 17.47 12 5.479 5.479 0 0 0 12 6.53zm10.345-2.007a2.494 2.494 0 1 1-4.988 0 2.494 2.494 0 0 1 4.988 0z",source:"https://ionicframework.com/press",hex:"3880FF",guidelines:void 0,license:void 0},siInfiniti={title:"Infiniti",slug:"infiniti",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Infiniti</title><path d="'+this.path+'"/></svg>'},path:"M6.893 14.606C5.17 14.46 2.18 13.33 2.18 11.359c0-2.5 4.343-4.818 9.819-4.818 5.75 0 9.82 2.318 9.82 4.818 0 1.97-2.978 3.087-4.702 3.233-.475-.609-5.118-6.791-5.118-6.791s-4.662 6.232-5.106 6.805zm13.744 2.115C22.921 15.6 24 13.734 24 12.088c0-3.533-4.928-6.264-12.001-6.264C4.927 5.824 0 8.555 0 12.088c0 1.646 1.079 3.511 3.363 4.633 2.118 1.041 5.116 1.403 5.55 1.455l3.086-8.982 3.118 8.982c.432-.052 3.401-.414 5.52-1.455z",source:"https://www.infinitiusa.com",hex:"000000",guidelines:void 0,license:void 0},siIos={title:"iOS",slug:"ios",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>iOS</title><path d="'+this.path+'"/></svg>'},path:"M1.1 6.05C.486 6.05 0 6.53 0 7.13A1.08 1.08 0 0 0 1.1 8.21C1.72 8.21 2.21 7.73 2.21 7.13C2.21 6.53 1.72 6.05 1.1 6.05M8.71 6.07C5.35 6.07 3.25 8.36 3.25 12C3.25 15.67 5.35 17.95 8.71 17.95C12.05 17.95 14.16 15.67 14.16 12C14.16 8.36 12.05 6.07 8.71 6.07M19.55 6.07C17.05 6.07 15.27 7.45 15.27 9.5C15.27 11.13 16.28 12.15 18.4 12.64L19.89 13C21.34 13.33 21.93 13.81 21.93 14.64C21.93 15.6 20.96 16.28 19.58 16.28C18.17 16.28 17.11 15.59 17 14.53H15C15.08 16.65 16.82 17.95 19.46 17.95C22.25 17.95 24 16.58 24 14.4C24 12.69 23 11.72 20.68 11.19L19.35 10.89C17.94 10.55 17.36 10.1 17.36 9.34C17.36 8.38 18.24 7.74 19.54 7.74C20.85 7.74 21.75 8.39 21.85 9.46H23.81C23.76 7.44 22.09 6.07 19.55 6.07M8.71 7.82C10.75 7.82 12.06 9.45 12.06 12C12.06 14.57 10.75 16.2 8.71 16.2C6.65 16.2 5.35 14.57 5.35 12C5.35 9.45 6.65 7.82 8.71 7.82M.111 9.31V17.76H2.1V9.31H.11Z",source:"https://en.wikipedia.org/wiki/IOS",hex:"000000",guidelines:void 0,license:void 0},siInfosys={title:"Infosys",slug:"infosys",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Infosys</title><path d="'+this.path+'"/></svg>'},path:"M23.2734 7.5703c-.3984 0-.7246.3282-.7246.7266 0 .4013.3262.7246.7246.7246.3982 0 .7266-.3233.7266-.7246 0-.3984-.3284-.7266-.7266-.7266zm0 .1074c.3395 0 .6192.2795.6192.6192 0 .3396-.2797.6172-.6192.6172-.3397 0-.6171-.2776-.6171-.6172 0-.3397.2774-.6192.6171-.6192zm-15.1367.0547c-.9001 0-1.549.5917-1.6387 1.6406h-.6953v.5215h.6856c.0028 1.6664-.002 3.334-.002 4.998h.7774c-.0022-1.6659-.002-3.3319-.002-4.998h1.748c-.646.5242-1.0663 1.3739-1.0663 2.334 0 1.593 1.1564 2.8848 2.582 2.8848 1.4258 0 2.582-1.2918 2.582-2.8848 0-.1896-.0174-.3753-.0488-.5547.2565.4131.7488.6133 1.4082.8985.7784.329 1.2129.6165 1.2129 1.1074 0 .5885-.556.8955-1.1817.8906-.611 0-1.0883-.249-1.6191-.7305v.9239c.3239.2088.8256.3281 1.3691.3281.6844-.0023 2.0918-.249 2.0918-1.6758-.0044-.8557-.715-1.2239-1.4863-1.5586-.9383-.4653-1.2965-.5629-1.2871-1.0957 0-.7088.6178-.9219 1.0996-.9219.2099 0 .3891.0293.5586.086.3163.1194.4209.3553.5332.6113.5283 1.2356 1.0344 2.4811 1.5488 3.7227-.2464.5637-.526 1.1519-.7168 1.5273l-.0039.0098-.1601.2969-.1797.336h.7617c.3322-.7342 1.7436-4.1688 2.0469-4.9083.1995.533.6857.7467 1.4297 1.0684.7783.329 1.2148.6166 1.2148 1.1074 0 .5886-.5562.8936-1.1816.8887-.6348 0-1.1257-.2685-1.6817-.7871l-.0507-.041v.9413c.3115.259.8713.4102 1.4824.4102.6844-.0022 2.0918-.249 2.0918-1.6758-.0042-.8557-.7151-1.2258-1.4863-1.5605-.9384-.4654-1.2593-.563-1.25-1.0957 0-.709.5787-.9219 1.0605-.9219.5483 0 .8958.2037 1.379.5547V9.584c-.3923-.1381-.7212-.1915-1.1642-.1895-.8912-.0018-1.6966.3234-1.9004 1.0762l-1.1054 2.7344-.1153.3437-.1015-.3437c-.5022-1.2089-.9934-2.4236-1.4863-3.6309-.3154-.0828-.8307-.201-1.1934-.1953-.0377-.0007-.0758-.0002-.1152 0-1.0302-.002-2.0235.4332-2.0235 1.457 0 .0596.0022.1155.006.17-.412-.9813-1.3036-1.6602-2.338-1.6602-.1245 0-.2472.0085-.3672.0273H7.254c-.1194-.733.2228-1.1503.7383-1.1503.6472-.0006.9242.192 1.205.4511 0 0 .0195-.0007.0274 0 .0038-.2457.002-.5318.002-.7949-.185-.0857-.5061-.1465-1.0899-.1465zM0 7.756v7.1367h.8594V7.7559zm23 .1386v.7657h.1387v-.3086h.164l.1192.3086h.1543l-.1407-.3301c.0494-.0248.1329-.0518.1329-.1875 0-.2224-.1673-.248-.3125-.248zm.1387.1328h.1543c.0834 0 .1289.0337.1289.1016 0 .068-.0524.0996-.1172.0996h-.166zM4.1719 9.3555c-.945 0-1.3429.3359-1.6582.6738a.2474.2474 0 00-.0352.0644h-.0078v-.043l-.0098-.623H1.707v5.4649h.7754v-3.9961c.0226-.4905.7134-.9746 1.252-.9746.6477 0 1.1777.4364 1.1777 1.039v3.9317h.7754c-.0019-1.429-.002-2.858-.002-4.2871-.0234-.4835-.6094-1.25-1.5136-1.25zm6.2832.5566c.9741-.0175 1.7825 1.0214 1.8047 2.3184.022 1.297-.7504 2.3614-1.7246 2.3789-.9742.0171-1.7825-1.0195-1.8047-2.3164-.0221-1.2971.7503-2.3634 1.7246-2.3809Z",source:"https://www.infosys.com/newsroom/journalist-resources/infosyslogo.html",hex:"007CC3",guidelines:void 0,license:void 0},siIpfs={title:"IPFS",slug:"ipfs",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>IPFS</title><path d="'+this.path+'"/></svg>'},path:"M12 0L1.608 6v12L12 24l10.392-6V6zm-1.073 1.445h.001a1.8 1.8 0 002.138 0l7.534 4.35a1.794 1.794 0 000 .403l-7.535 4.35a1.8 1.8 0 00-2.137 0l-7.536-4.35a1.795 1.795 0 000-.402zM21.324 7.4c.109.08.226.147.349.201v8.7a1.8 1.8 0 00-1.069 1.852l-7.535 4.35a1.8 1.8 0 00-.349-.2l-.009-8.653a1.8 1.8 0 001.07-1.851zm-18.648.048l7.535 4.35a1.8 1.8 0 001.069 1.852v8.7c-.124.054-.24.122-.349.202l-7.535-4.35a1.8 1.8 0 00-1.069-1.852v-8.7c.124-.054.24-.122.35-.202z",source:"https://github.com/ipfs/logo",hex:"65C2CB",guidelines:void 0,license:void 0},siIssuu={title:"Issuu",slug:"issuu",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Issuu</title><path d="'+this.path+'"/></svg>'},path:"M.996 0A.998.998 0 0 0 0 .996V12c0 6.628 5.372 12 12 12s12-5.372 12-12S18.628 0 12 0H.996zm11.17 3.582a8.333 8.333 0 0 1 8.254 8.41 8.333 8.333 0 0 1-8.41 8.252c-4.597-.045-8.296-3.81-8.254-8.41.045-4.6 3.81-8.296 8.41-8.252zm-.031 2.27a6.107 6.107 0 0 0-6.155 6.046 6.109 6.109 0 0 0 6.05 6.163 6.099 6.099 0 0 0 6.154-6.047 6.107 6.107 0 0 0-6.041-6.162h-.008zm-.02 3.013a3.098 3.098 0 0 1 3.063 3.123 3.088 3.088 0 0 1-3.121 3.06l.002-.001a3.091 3.091 0 0 1 .056-6.182z",source:"https://issuu.com/press",hex:"F36D5D",guidelines:"https://issuu.com/press",license:void 0},siWallabag={title:"Wallabag",slug:"wallabag",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Wallabag</title><path d="'+this.path+'"/></svg>'},path:"M20.376.0007c-.0433-.0046-.0911.014-.1388.0528-.1028.0835-.9982.2919-1.529.7058-.857.6687-1.3854 1.9404-1.6248 2.6435a5.6065 5.6065 0 00-.047.1408c-.1116.2692-.3343.2698-.3343.2698a3.0022 3.0022 0 00-.3246-.0176c-.097 0-.1948.0043-.2913.0137-.0022.0004-.0037-.0002-.006 0-.284.0419-.4404-.3045-.473-.3871-.332-.9534-1.2247-2.8338-3.232-3.3397 0 0-.3653-.2788-.2543.1935.1057.4514.3243.9065.2757 1.5701-.0223.3063-.2117 1.877 1.2318 2.6944.1372.0777.26.1445.3696.1995-.7266.5814-1.3884 1.39-1.9533 2.3092.287-.1764 1.836-.9975 4.3328.0332 2.5684 1.06 4.1607.139 4.3582.0137-.6209-1.0206-1.358-1.9094-2.1743-2.5066.0544-.015.1094-.0297.1681-.047 1.0826-.313 1.3577-1.2306 1.4156-2.0158.0655-.8905.1097-.9039.303-1.705.1392-.5772.0578-.8074-.0723-.8212zM13.2022 9.03c-.2261 0-.4135.0631-.5553.1877-.1458.1276-.219.2755-.219.44v2.841c0 .3573.0352.696.1037 1.005.0706.316.1934.592.3656.8231.174.2335.41.4188.702.5494.2888.1287.6495.1936 1.0733.1936.4417 0 .8113-.0828 1.099-.2444.2413-.1355.4447-.313.6062-.5299.1556.217.3546.3945.5924.53.284.1615.6595.2443 1.1165.2443.4237 0 .7841-.0666 1.0695-.1955.2878-.1305.5217-.3144.696-.5475.1726-.2319.2958-.508.3657-.8232.0685-.309.1017-.6476.1017-1.005v-2.841c0-.1637-.0699-.312-.2112-.44-.1378-.1252-.3271-.1876-.5611-.1876-.2123 0-.389.0635-.524.1896-.1366.1277-.2053.275-.2053.438v2.886c0 .3872-.068.6726-.2034.8486-.1308.17-.3403.2522-.6394.2522-.306 0-.516-.0814-.6393-.2502-.1287-.176-.1936-.4623-.1936-.8506V9.646c0-.1973-.0896-.3575-.26-.4653-.2317-.146-.4609-.1987-.741-.1056a1.1842 1.1842 0 00-.2406.1095.6958.6958 0 00-.1955.178c-.0579.0776-.088.1612-.088.2502v2.931c0 .3878-.0649.6743-.1936.8504-.1236.1688-.332.2503-.6374.2503-.3064 0-.5181-.0829-.6452-.2522-.132-.176-.1994-.461-.1994-.8486v-2.886c0-.1632-.0686-.3104-.2053-.438-.135-.1262-.3142-.1896-.5338-.1896zm-3.0521 5.774a5.613 5.613 0 00.3363 1.0324c.1197.6731.2803 2.2572-.481 3.6446-.6706 1.2223-3.981 2.8883-8.8945 1.9318 0 0-.1964-.1367-.2561-.0235-.0883.1675.272.303.6433.4008 3.4209.906 8.583.5362 10.204-.7997.7398-.609 1.0264-1.4282 1.099-2.311 0 0 .0197-.2306.309-.0568.0828.0498.3824.2452.43.4654.0417.3133.0445.6964-.1172.9659-.2314.3854-.2341.4414.0703.6589.187.1334.9515.6952 2.014 1.3335.0026.0018.0031.0025.0058.0039.2247.1353.5377.4673.5377.4673.4785.5534 1.518 1.6664 1.971 1.4566.2138-.099-.0079-.5436-.0079-.5436s.3545.4607.5456.3031c.1454-.12-.0841-.5807-.0841-.5807s.3099.2699.4947.1701c.226-.122-.0326-.8295-1.8105-1.9103-1.7787-1.0817-2.261-1.2476-2.3033-1.7304 0 0-.0014-.023 0-.0645.0138-.1066.0739-.3332.3324-.309a7.454 7.454 0 001.1889.0958 7.391 7.391 0 001.355-.1231s.0226-.0048.0293-.006c.051-.0064.1502-.0025.1506.1213-.0162.1569-.0602.3136-.1526.4516-.26.3897-.174.4438.0978.6942.1677.1544.9373.8313 1.9905 1.486.0022.0016.0014.0026.0039.0039.2245.1351.614.5064.614.5064.4364.4432 1.2384 1.1847 1.6757 1.14.2958-.0302.0547-.5397.0547-.5397s.3737.3603.5573.2542c.2052-.1184-.0841-.4947-.0841-.4947s.2407.1283.4106.086c.1704-.0424.2125-.4768-1.5564-1.572-1.769-1.0961-2.364-1.4811-2.3267-1.9005 0 0 .0002-.0682.0176-.172.043-.2223.1784-.601.612-.8174a.2517.2517 0 00.0372-.0235c1.3783-.7998 2.386-2.0874 2.7413-3.6954-.3577.8882-3.0083 1.578-6.2275 1.578-3.218 0-5.87-.6898-6.2275-1.578z",source:"https://github.com/wallabag/logo/blob/f670395da2d85c3bbcb8dcfa8d2a339d8af5abb0/_default/icon/svg/logo-icon-black-no-bg.svg",hex:"3F6184",guidelines:void 0,license:void 0},siIstio={title:"Istio",slug:"istio",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Istio</title><path d="'+this.path+'"/></svg>'},path:"M4 21 20 21 10 24zM4 20 10 19 10 8zM11 19 20 20 11 0z",source:"https://github.com/istio/istio/blob/5a047251817eb2523af297607b7614120812e47a/logo/istio-bluelogo-whitebackground-unframed.svg",hex:"466BB0",guidelines:void 0,license:void 0},siIterm2={title:"iTerm2",slug:"iterm2",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>iTerm2</title><path d="'+this.path+'"/></svg>'},path:"m7.806 3.845h2.563v5.126h-2.563zm-1.531 1.65c-.14-.104-.272-.183-.397-.239-.126-.056-.28-.084-.463-.084-.167 0-.298.034-.391.102-.094.067-.141.161-.141.28 0 .092.045.168.135.227.089.06.202.117.337.17.135.054.282.11.439.168.157.057.304.128.439.212.135.083.248.186.337.307.09.121.135.274.135.457 0 .255-.091.471-.272.648s-.435.289-.761.337v.878h-.478v-.866c-.207-.02-.412-.073-.615-.158-.203-.086-.378-.19-.526-.314l.311-.471c.171.115.344.209.519.28.176.072.367.108.574.108.191 0 .335-.036.433-.108.097-.071.146-.167.146-.286 0-.104-.045-.189-.135-.257-.089-.068-.202-.13-.337-.188s-.281-.116-.436-.173c-.155-.058-.3-.129-.436-.212-.135-.084-.247-.184-.337-.302-.09-.117-.134-.266-.134-.445 0-.258.087-.469.262-.633.176-.163.412-.264.711-.304v-.782h.478v.776c.211.024.391.078.54.161.149.084.286.187.409.311zm-2.165-2.442c-.456.244-.813.601-1.057 1.057s-.373.908-.373 2.154v11.472c0 1.246.129 1.698.373 2.154s.601.813 1.057 1.057.908.373 2.154.373h11.472c1.246 0 1.698-.129 2.154-.373s.813-.601 1.057-1.057.373-.908.373-2.154v-11.472c0-1.246-.129-1.698-.373-2.154s-.601-.813-1.057-1.057-.908-.373-2.154-.373h-11.472c-1.246 0-1.698.129-2.154.373zm2.199-2.121h11.382c1.87 0 2.548.195 3.231.56.684.366 1.22.902 1.586 1.586.365.683.56 1.361.56 3.231v11.382c0 1.87-.195 2.548-.56 3.231-.366.684-.902 1.22-1.586 1.586-.683.365-1.361.56-3.231.56h-11.382c-1.87 0-2.548-.195-3.231-.56-.684-.366-1.22-.902-1.586-1.586-.365-.683-.56-1.361-.56-3.231v-11.382c0-1.87.195-2.548.56-3.231.366-.684.902-1.22 1.586-1.586.683-.365 1.361-.56 3.231-.56zm-3.567-.216c-.874.467-1.559 1.152-2.026 2.026-.467.873-.716 1.739-.716 4.128v10.26c0 2.389.249 3.255.716 4.128.467.874 1.152 1.559 2.026 2.026.873.467 1.739.716 4.128.716h10.26c2.389 0 3.255-.249 4.128-.716.874-.467 1.559-1.152 2.026-2.026.467-.873.716-1.739.716-4.128v-10.26c0-2.389-.249-3.255-.716-4.128-.467-.874-1.152-1.559-2.026-2.026-.873-.467-1.739-.716-4.128-.716h-10.26c-2.389 0-3.255.249-4.128.716z",source:"https://github.com/gnachman/iTerm2/blob/6a857f3f5872eb1465ddc0dd83412015991e79ae/images/AppIcon/iTermIcon.sketch",hex:"000000",guidelines:void 0,license:void 0},siItunes={title:"iTunes",slug:"itunes",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>iTunes</title><path d="'+this.path+'"/></svg>'},path:"M11.977 23.999c-2.483 0-4.898-.777-6.954-2.262a11.928 11.928 0 01-4.814-7.806A11.954 11.954 0 012.3 4.994 11.85 11.85 0 0110.08.159a11.831 11.831 0 018.896 2.104 11.933 11.933 0 014.815 7.807 11.958 11.958 0 01-2.091 8.937 11.855 11.855 0 01-7.78 4.835 12.17 12.17 0 01-1.943.157zm-6.474-2.926a11.022 11.022 0 008.284 1.96 11.044 11.044 0 007.246-4.504c3.583-5.003 2.445-12.003-2.538-15.603a11.022 11.022 0 00-8.284-1.96A11.046 11.046 0 002.966 5.47C-.618 10.474.521 17.473 5.503 21.073zm10.606-3.552a2.08 2.08 0 001.458-1.468l.062-.216.008-5.786c.006-4.334 0-5.814-.024-5.895a.535.535 0 00-.118-.214.514.514 0 00-.276-.073c-.073 0-.325.035-.56.078-1.041.19-7.176 1.411-7.281 1.45a.786.786 0 00-.399.354l-.065.128s-.031 9.07-.078 9.172a.7.7 0 01-.376.35 9.425 9.425 0 01-.609.137c-1.231.245-1.688.421-2.075.801-.22.216-.382.51-.453.82-.067.294-.045.736.051 1.005.1.281.262.521.473.71.192.148.419.258.674.324.563.144 1.618-.016 2.158-.328a2.36 2.36 0 00.667-.629c.06-.089.15-.268.2-.399.176-.456.181-8.581.204-8.683a.44.44 0 01.32-.344c.147-.04 6.055-1.207 6.222-1.23.146-.02.284.027.36.12a.29.29 0 01.109.096c.048.07.051.213.058 2.785.008 2.96.012 2.892-.149 3.079-.117.136-.263.189-.864.31-.914.188-1.226.276-1.576.447-.437.213-.679.446-.867.835a1.58 1.58 0 00-.182.754c.001.49.169.871.55 1.245.035.034.069.066.104.097.192.148.387.238.633.294.37.082 1.124.025 1.641-.126z",source:"https://upload.wikimedia.org/wikipedia/commons/d/df/ITunes_logo.svg",hex:"FB5BC5",guidelines:void 0,license:void 0},siIveco={title:"IVECO",slug:"iveco",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>IVECO</title><path d="'+this.path+'"/></svg>'},path:"M.24 14.402h1.433c.12 0 .239-.1.239-.243V9.87a.243.243 0 0 0-.244-.242H.24a.237.237 0 0 0-.24.24v4.294c0 .169.148.239.24.239m2.566-4.424l1.01 3.737c.064.25.244.435.391.53.17.11.338.156.61.156h1.119c.474 0 .833-.294.963-.794l.91-3.62a.431.431 0 0 0 .014-.108.238.238 0 0 0-.24-.25h-.827a.24.24 0 0 0-.235.182l-.718 3.135c-.022.108-.076.131-.134.131a.117.117 0 0 1-.112-.1l-.762-3.11c-.02-.157-.122-.239-.242-.239H3.03c-.188 0-.254.17-.243.273.001.022.013.043.019.077m7.728 1.49l-.002-.413c0-.15.116-.25.24-.25h1.7a.24.24 0 0 0 .238-.24l.001-.695a.243.243 0 0 0-.244-.242H9.57c-.468 0-.948.364-.948 1.024v2.79c0 .602.508.959.945.959h2.93c.124 0 .249-.093.243-.265v-.69a.24.24 0 0 0-.24-.24h-1.7c-.159 0-.266-.093-.266-.243v-.397h1.494a.242.242 0 0 0 .238-.251v-.61a.24.24 0 0 0-.244-.238h-1.488zm5.511-.664a11.9 11.9 0 0 1 1.283 0 .238.238 0 0 0 .239-.239v-.005l.005-.762a.239.239 0 0 0-.217-.238 12.611 12.611 0 0 0-.893-.024c-.42 0-.833.022-1.237.069l.025-.002c-.879.07-1.595.72-1.756 1.57a5.162 5.162 0 0 0-.074.82c0 .27.02.527.058.776a1.943 1.943 0 0 0 1.63 1.622l-.026-.004a9.788 9.788 0 0 0 2.303.053.239.239 0 0 0 .216-.236l-.001.017.002-.766a.239.239 0 0 0-.239-.239h-.007c-.239.012-.479.012-.722.007a12.965 12.965 0 0 1-.61-.021.675.675 0 0 1-.588-.594 6.287 6.287 0 0 1-.022-1.131.678.678 0 0 1 .631-.673M24 12.05c.003-.434-.06-.83-.178-1.195a1.916 1.916 0 0 0-1.59-1.285 9.213 9.213 0 0 0-1.085-.062c-.406 0-.76.01-1.156.06a1.932 1.932 0 0 0-1.6 1.392 3.792 3.792 0 0 0 .029 2.172 1.906 1.906 0 0 0 1.596 1.306c.342.037.684.054 1.037.054.443 0 .805 0 1.232-.058.85-.153 1.452-.752 1.613-1.511.065-.282.1-.57.102-.873m-1.91-.02c0 .222-.01.434-.037.65a.677.677 0 0 1-.62.565 8.625 8.625 0 0 1-.541.007.674.674 0 0 1-.664-.576 5.302 5.302 0 0 1-.014-1.337.677.677 0 0 1 .625-.601 8.615 8.615 0 0 1 .532-.004c.353 0 .643.268.675.612.03.223.044.452.044.684",source:"https://www.iveco.com/germany/Pages/Home-page.aspx",hex:"004994",guidelines:void 0,license:void 0},siJabber={title:"Jabber",slug:"jabber",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Jabber</title><path d="'+this.path+'"/></svg>'},path:"M9.597 11.737c0-.35-.065-.732-.268-1.025-.408-.588-1.283-.775-1.892-.405-.308.188-.48.515-.576.851-.191.668-.104 1.43.03 2.1.043.214.088.428.148.639.021.076.031.186.08.25.087.11.297.141.426.12.387-.065.291-.703.278-.974-.03-.634-.218-1.25-.036-1.881.076-.268.225-.568.494-.684.244-.105.49.023.586.261.156.385.117.83.215 1.23.033.137.07.272.131.399.018.037.043.113.094.108.126-.011.304-.22.398-.298.304-.25.616-.52.965-.705.165-.088.435-.23.603-.08a.612.612 0 0 1 .108.13c.198.31.002.55-.127.845-.166.38-.336.758-.577 1.098-.207.293-.49.549-.655.869-.107.205-.167.43-.123.663.036.188.181.301.373.257.143-.033.24-.156.322-.269.146-.202.281-.412.426-.615.28-.393.61-.76.846-1.183a3.41 3.41 0 0 0 .42-1.664c0-.474-.171-1.198-.723-1.298a.974.974 0 0 0-.326.01 1.432 1.432 0 0 0-.374.12 2.715 2.715 0 0 0-.818.637c-.146.16-.276.363-.449.495M9.078.016c-.435.058-.878.052-1.315.12-.838.129-1.64.389-2.425.703-.286.114-.568.241-.845.376-.103.05-.26.09-.343.17-.043.041-.039.139-.044.195-.014.156-.034.313-.05.47-.058.605-.1 1.229-.013 1.834.028.195.09.55.33.587.369.058.656-.397.837-.648.424-.586.905-1.132 1.6-1.394.817-.308 1.753-.381 2.618-.44 2.426-.167 5.078.277 6.865 2.064.254.254.495.524.7.82.8 1.159 1.223 2.477 1.427 3.86.096.65.161 1.308.013 1.955-.257 1.122-.932 2.1-1.706 2.931-.53.57-1.128 1.084-1.749 1.552-.347.261-.736.483-1.062.768-.375.329-.688.74-.925 1.179-.639 1.181-.81 2.602-.622 3.92.038.27.073.542.134.809.018.08.022.217.073.282.097.122.36.189.508.196.154.007.256-.11.294-.249.064-.236.026-.498-.012-.736-.076-.487-.147-.977-.125-1.471a3.71 3.71 0 0 1 1.026-2.425c.643-.673 1.512-1.061 2.243-1.625 1.474-1.136 2.794-2.668 3.301-4.492a5.194 5.194 0 0 0 .159-2.015c-.105-.849-.415-1.697-.708-2.497-.892-2.437-2.422-4.755-4.851-5.87-.964-.443-1.973-.645-3.016-.79-.49-.068-.98-.11-1.472-.132-.274-.012-.572-.042-.845-.006M5.277 15.796c-.473.068-.61.447-.523.876.112.548.543.965.97 1.295a6.03 6.03 0 0 0 3.884 1.238c.538-.023 1.124-.112 1.617-.34.265-.122.542-.563.181-.751a.59.59 0 0 0-.169-.051c-.157-.026-.333.041-.482.084-.263.075-.526.153-.797.196-.808.13-1.683-.055-2.352-.534-.542-.387-.98-.898-1.393-1.415-.253-.316-.482-.663-.936-.598M4.662 18.474c-.12.016-.259.011-.362.087-.215.158.022.476.135.62.328.417.76.763 1.192 1.068a7.832 7.832 0 0 0 4.03 1.442c.421.03.85 0 1.267-.07.152-.026.342-.037.482-.103.399-.186.284-.939-.072-1.106-.155-.073-.404.023-.567.046-.385.054-.771.06-1.158.05-1.015-.025-2.096-.338-2.98-.831a5.589 5.589 0 0 1-.966-.693c-.181-.16-.368-.42-.603-.502-.11-.037-.284-.023-.398-.008M4.903 20.73a.638.638 0 0 0-.413.236c-.078.088-.152.167-.197.278-.246.609.41 1.183.864 1.47.504.32 1.055.558 1.616.758 1.266.45 2.752.739 4.066.336.391-.12.778-.338 1.062-.634.16-.167.27-.419-.024-.526-.174-.063-.385.098-.543.162a4.57 4.57 0 0 1-1.158.312c-.527.064-1.001-.052-1.508-.179-.434-.108-.872-.217-1.291-.373a4.457 4.457 0 0 1-1.026-.513c-.094-.066-.206-.125-.282-.211-.25-.282-.439-.612-.707-.88-.116-.116-.281-.256-.459-.236",source:"https://commons.wikimedia.org/wiki/File:Jabber-bulb.svg",hex:"CC0000",guidelines:"http://www.jabber.org/faq.html#logo",license:{type:"CC-BY-2.5",url:"https://spdx.org/licenses/CC-BY-2.5"}},siDirectus={title:"Directus",slug:"directus",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Directus</title><path d="'+this.path+'"/></svg>'},path:"M19.187 13.909a1.74 1.74 0 0 1-.286-.092.657.657 0 0 1-.203-.139c.056-.488 0-.912.047-1.392.184-1.862 1.355-1.272 2.406-1.577.655-.184 1.31-.562 1.475-1.336a13.528 13.528 0 0 0-2.397-2.204c-2.85-2.028-6.574-2.84-9.958-2.277a5.113 5.113 0 0 0 2.238 2.074s-.917 0-1.703-.587c-.23.092-.692.274-.913.384a5.094 5.094 0 0 0 6.63.37c-.01.017-.185.285-.397 1.4-.47 2.38-1.826 2.195-3.504 1.596-3.485-1.264-5.403-.093-7.145-2.49-.507.286-.82.82-.82 1.402 0 .599.331 1.106.81 1.383.262-.348.38-.446.836-.446-.706.4-.79.75-1.094 1.718-.368 1.171-.212 2.37-1.936 2.683-.913.046-.894.664-1.226 1.586-.415 1.199-.968 1.678-2.047 2.812.443.535.904.6 1.374.406.968-.406 1.715-1.66 2.415-2.471.784-.904 2.665-.517 4.085-1.402.977-.599 1.457-1.41.811-2.784a2.72 2.72 0 0 1 .701 1.66c1.641-.213 3.836 1.788 5.836 2.12a3.574 3.574 0 0 1-.488-.82c-.23-.554-.304-1.06-.258-1.503.184 1.097 1.29 2.507 3.07 2.637.452.036.95-.019 1.466-.176.618-.184 1.19-.424 1.872-.295.507.093.977.35 1.272.784.443.645 1.41.784 1.844-.009-.977-2.554-3.67-2.72-4.813-3.015z",source:"https://directus.io/",hex:"263238",guidelines:void 0,license:void 0},siWattpad={title:"Wattpad",slug:"wattpad",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Wattpad</title><path d="'+this.path+'"/></svg>'},path:"M13.034 3.09c-1.695.113-3.9 2.027-6.9 6.947.245-2.758.345-4.716-.857-5.743-.823-.702-2.764-.974-3.926.536C.18 6.349-.09 9.312.024 12.432c.238 6.518 2.544 8.487 4.59 8.487h.001c3.623 0 4.13-4.439 6.604-8.4-.09 1.416-.008 2.668.266 3.532 1.078 3.398 4.784 3.663 6.467.21 2.374-4.87 3.058-6.016 5.453-9.521 1.58-2.314-.252-3.812-2.374-2.735-1.09.554-2.86 1.935-5.065 4.867.387-2.23.28-5.996-2.932-5.782z",source:"https://company.wattpad.com/brandguideline",hex:"FF500A",guidelines:"https://company.wattpad.com/brandguideline",license:void 0},siJaguar={title:"Jaguar",slug:"jaguar",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Jaguar</title><path d="'+this.path+'"/></svg>'},path:"M5.241 6.609a6.93 6.93 0 0 0-.293.01s-1.6.072-2.1.798c0 0-.085.098-.037.203 0 0 .01.03-.01.05 0 0-.27.24-.406.455-.048.078-.102.209 0 .3 0 0 .045.035.063.065.039.064.075.159.123.215.07.084.211.228.41.193.073-.013.09-.04.09-.04.1.099.26.096.26.096-.02-.064-.09-.188-.1-.263a.421.421 0 0 1 .015-.162.701.701 0 0 1 .145-.271c.054-.054.192-.115.303-.038.088.063.194.268.106.56 0 .022-.1.23-.205.26 0 0-.01.004-.03.004-.07 0-.2-.073-.2-.073s0 .018.015.094c.012.043.027.09.04.127 0 0-.025.046-.042.072-.025.045-.046.131.01.17 0 0 .23.157.455.171.154.01.212-.095.212-.095.114-.156.2-.29.32-.399.327-.3.786-.38.786-.38.03-.004.533-.144 1.386.539-.244.02-.534.078-.756.117-.632.113-1.037.71-1.155.952-.307.633.32.851.32.851.01-.006.6-.052.886-.683 0 0 .104-.279.383-.188.182.059 1.79.62 2.152.716 0 0 1.077.28 1.482-.215.649.213 1.257.316 2.85.11.277-.036.495-.027.495-.027.372.027.712.278.815.442.42.671.95 2.003 2.796 1.841l.835-.076c.51-.03.924-.05 1.345.172.183.096.285.131.596.428.425.404.816.842 1.336.603.185-.085.393-.415.393-.415a.598.598 0 0 0-.253-.419c.473.113 1.54.185 1.952-.536.107-.168.118-.318.078-.408-.113-.253-.426-.17-.426-.17-.148.03-.317.2-.568.274-.538.16-.968-.026-.968-.026-.829-.359-3.493-1.884-4.848-2.55 0 0-1.555-.78-3.839-1.684 0 0-4.148-1.823-7.212-1.77zm0 .136c3-.051 7.113 1.739 7.154 1.758v.001c.368.146.716.289 1.043.425l-.475-.188a43.23 43.23 0 0 0-1.828-.645c-1.544-.533-2.22-.627-2.267-.633a5.54 5.54 0 0 0-.256-.038l-.278-.032.154.249c-1.09-.771-2.395-.81-2.459-.812-.263 0-.492.075-.67.16l.089-.165-.216-.01a6.333 6.333 0 0 0-.901.018 5.1 5.1 0 0 1 .908-.088zm-.319.198c.095 0 .197.003.307.008l-.036.067c-.077.146-.385.448-.892.336 0 0 0 .226.555.307 0 0 .497.088 1.341.767 0 0-.403-.802-1.088-1.01 0 0-.086-.018-.044-.072 0 0 .404-.38.967-.38 0 0 1.754.038 2.869 1.204 0 0-.05-.203-.225-.49l-.073-.12s.067.008.25.038c0 0 .67.083 2.243.626 0 0 1.179.388 1.824.643.97.387 3.398 1.327 4.947 2.172.276.15 3.077 1.61 3.077 1.61.775.349 1.312.137 1.312.137.175-.066.492-.31.63-.172.071.071.081.167.047.26-.04.14-.24.328-.483.435-.255.114-.787.144-1.094.094 0 0-.596-.06-1.117-.605-.165-.172-.367-.367-.554-.559a1.038 1.038 0 0 0-.62-.333c-.35-.047-1.205-.07-1.526-.177-.215-.072-.474-.217-.819-.728-.166-.244-.283-.311-.509-.455 0 0 .173.138.271.312.142.252.213.435.29.57.077.135.164.254.295.36.164.131.266.156.443.185.17.028.742.023 1.232.016.483-.008.699.148.857.282.147.124.4.477.554.632.184.184.32.372.684.556.127.064.334.222.323.374-.164.164-.367.207-.855.076.035.034.29.303.727.176a.558.558 0 0 1-.396.15c-.458-.026-.906-.59-1.158-.798-.19-.158-.213-.197-.537-.422-.493-.341-1.598-.245-1.598-.245l-.812.042c-1.58.12-2.244-1.28-2.419-1.572a2.422 2.422 0 0 0-.168-.25c-.08-.108-.512-.668-.949-.852 0 0 .43.37.404.614 0 0-.178-.083-.662-.014-2.081.297-2.79-.224-2.79-.224.097-.417-.194-.845-.194-.845.16.05 1.184.396 2.155.2 0 0-1.581.008-2.69-.877 0 0 .69.865.526 1.431 0 0-.113.603-1.316.36-.129-.025-.28-.068-2.08-.568-.424-.127-.57.075-.647.197 0 .178-.213.386-.318.45-.558-.1-.336-.617-.336-.617-.35.502.017.724.133.74-.07.033-.135.058-.19.078 0 0-.457-.271-.202-.715.355-.62.717-.819 1.38-.88.29-.027.531-.048.715-.022.48.066.782.338 1.502.407-1.528-.45-1.532-1.335-1.537-1.352V8.5c-.085.292-.038.538.037.746-.02-.008-.355-.228-.483-.305-.548-.335-.982-.394-.982-.394-.182-.023-.266-.244-.266-.244-.01-.011-.013-.022-.02-.032-.252-.432-.502-.44-.502-.44a.836.836 0 0 1 .136.372c.01.055.014.157.014.187 0 .462-.54.607-.54.607-.372.473-.353.483-.436.495-.083.012-.265-.08-.265-.08-.014-.008-.018-.029-.016-.042 0-.029.028-.047.028-.047.07-.055.127-.11.127-.11.394-.403.441-.6.393-.861-.1-.524-.474-.463-.474-.463-.182.018-.256.168-.256.168a4.576 4.576 0 0 0-.195.392c-.08.176-.164.215-.207.223a.396.396 0 0 1-.065.003c-.127-.005-.223-.121-.223-.121-.01-.006-.01-.013-.016-.018-.116-.124-.032-.287-.032-.287.156-.363.46-.416.5-.421l.182-.026c.385-.065.567-.466.567-.466a2.99 2.99 0 0 0-.386.014c-.256.045-.343.346-.343.345-.216.05-.21-.136-.172-.193.034-.052.16-.275.991-.467 0 0 .314-.095.978-.092zm-.159.12c-.2 0-.305.112-.305.123 0 .006.027.009.07.01l.07.003a.79.79 0 0 0 .32-.083.422.422 0 0 0 .092-.052l-.245-.002zm.164.363v.004c.03.081.108.11.143.12v-.001c.163.05.309.138.437.241-.39-.218-.613-.261-.628-.264a1.609 1.609 0 0 1-.157-.032.987.987 0 0 0 .208-.068zm-1.364.05s-.05.16-.247.194c0 0-.077.018-.108.019l.021-.06c0-.012.051-.138.165-.15 0 0 .066-.004.169-.004zm-.683.233a.213.213 0 0 0 .056.047c-.135.057-.485.432-.485.432.177-.262.408-.458.41-.46 0-.003.01-.006.01-.009 0-.003.01-.007.01-.01zm.737.315c.038-.005.217-.012.3.27a.433.433 0 0 0-.14-.185.339.339 0 0 0-.254-.055.2.2 0 0 1 .094-.03zm-1.282 7.398v.873c0 .255-.056.426-.18.55-.165.162-.437.228-.84.228H0v.256h1.428c.677 0 1.156-.092 1.405-.347.143-.146.212-.329.212-.63v-.93zm2.688 0L3.37 17.33h.412l.348-.406h2.104l.35.406h.796l-1.656-1.907zm4.086 0c-.483 0-.772.056-1.03.2a.831.831 0 0 0-.432.75c0 .385.175.666.557.82.229.093.532.137.917.137h2.055v-.875h-.707v.62H9.336c-.366 0-.58-.053-.737-.173-.15-.115-.229-.289-.229-.525 0-.229.075-.4.215-.513.158-.128.365-.186.745-.186h1.774v-.255zm5.656 0v.924c0 .24-.03.393-.122.52-.154.217-.397.295-.896.295h-.06c-.476 0-.741-.078-.895-.294-.091-.128-.122-.273-.122-.521v-.923h-.71v.95c0 .246.027.44.15.603.202.264.574.416 1.6.416h.011c1.032 0 1.402-.152 1.604-.416.124-.163.15-.357.15-.603v-.95zm2.677 0l-1.654 1.907h.412l.349-.406h2.103l.35.406h.796l-1.656-1.907zm2.986 0v1.908h.71v-.661h.933l1.064.66H24l-1.117-.673c.266-.009.493-.05.667-.143a.52.52 0 0 0 .267-.472c0-.255-.114-.418-.321-.51-.185-.08-.413-.108-.866-.108zm.71.24h1.399c.266 0 .384.026.465.086.077.058.105.146.105.283v.036c0 .123-.03.223-.12.286-.09.062-.214.075-.441.075h-1.408zM5.18 15.7l.84.977H4.342zm12.419 0l.84.977h-1.68z",source:"https://media.jaguar.com/en/press-kit",hex:"FFFFFF",guidelines:void 0,license:void 0},siJameson={title:"Jameson",slug:"jameson",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Jameson</title><path d="'+this.path+'"/></svg>'},path:"M18.81 17.564c-.405 1.031-1.007 2.505-1.683 3.574 0 .012 0 .024.013.012.737-.59 1.486-1.732 1.891-2.763.258-.651.823-2.002 1.044-2.223.013-.013 0-.025-.012-.037-.43-.123-1.339-.234-1.867-2.236 0 0-2.678-9.985-3.046-11.385-.295-1.094-.037-1.757.356-2.199.012-.012 0-.025-.012-.012-.712.22-1.191 1.29-.86 2.505.369 1.388 3.01 11.226 3.01 11.226.171.651.405 1.167.663 1.536.258.368.614.638.97.712.037.012.086.012.123.012.012 0 .024.025.012.037-.025.013-.037.037-.061.062-.172.208-.357.65-.553 1.154zM14.352.024l.012.05v.012c-.59.405-1.167 1.486-.835 2.727.368 1.388 1.94 7.246 2.493 9.285l.602 2.223c.368 1.4.897 2.174 1.621 2.272 0 0 .012 0 .012.013l.025.049v.012c-.368.369-.676 1.265-1.069 2.1-.393.848-1.215 3.415-4.36 4.619-3.427 1.302-6.902.479-8.364-1.941-.958-1.572-.725-3.734.835-4.606 1.351-.761 2.813-.258 3.366.86.528 1.08.16 2.235-.27 2.616-.087.074 0 .233.208.368.909.627 1.953.59 2.948.062 1.277-.676 1.744-1.842 1.068-4.323-.54-2.04-2.972-11.08-3.34-12.48-.332-1.24-1.376-1.89-2.088-1.94 0 0-.013 0-.013-.012l-.012-.05s0-.012.012-.012L14.39 0s.012 0 .012.012zM9.795 20.083c.16.086.356.11.54.073.013 0 .013-.012.013-.012a3.249 3.249 0 0 0-.172-2.493c-.369-.75-.91-1.192-1.523-1.4-.013 0-.013.012-.013.012.393.27.725.639.958 1.105.443.91.43 1.88.16 2.629a.06.06 0 0 0 .025.073Z",source:"https://www.jamesonwhiskey.com/",hex:"004027",guidelines:void 0,license:void 0},siJasmine={title:"Jasmine",slug:"jasmine",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Jasmine</title><path d="'+this.path+'"/></svg>'},path:"M11.591 19.649h.771v-3.786h-.77zm-6.874-5.03l-.238-.733 3.6-1.17.238.735-3.6 1.17m4.645-5.762L7.138 5.796l.624-.453 2.224 3.062-.624.454m5.315.028l-.624-.454 2.225-3.062.624.453-2.225 3.063m4.592 5.78l-3.6-1.17.238-.734 3.6 1.17-.238.733M12 .001C5.383.001 0 5.384 0 11.998 0 18.617 5.383 24 12 24s12-5.382 12-12c0-6.617-5.383-12-12-12zm0 2.43c5.284 0 9.569 4.283 9.569 9.567 0 5.287-4.285 9.573-9.569 9.573-5.286 0-9.57-4.286-9.57-9.573 0-5.284 4.285-9.567 9.57-9.567m1.552 7.96l.575 1.768.747.242 4.736-1.538-.86-2.645-4.736 1.539-.462.635m.337 2.5l-1.504 1.093v.785l2.927 4.03 2.25-1.636-2.927-4.029-.746-.243m-2.275 1.093l-1.504-1.093-.747.243-2.927 4.029 2.25 1.635 2.928-4.029v-.785M9.873 12.16l.574-1.767-.462-.635-4.736-1.54-.86 2.646 4.737 1.54.747-.244m1.198-2.22h1.859l.462-.636v-4.98H10.61v4.98l.461.636",source:"https://github.com/jasmine/jasmine/blob/8991b1bba39b5b7e89fc5eeb07ae271a684cb1a4/images/jasmine-horizontal.svg",hex:"8A4182",guidelines:void 0,license:void 0},siJava={title:"Java",slug:"java",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Java</title><path d="'+this.path+'"/></svg>'},path:"M8.851 18.56s-.917.534.653.714c1.902.218 2.874.187 4.969-.211 0 0 .552.346 1.321.646-4.699 2.013-10.633-.118-6.943-1.149M8.276 15.933s-1.028.761.542.924c2.032.209 3.636.227 6.413-.308 0 0 .384.389.987.602-5.679 1.661-12.007.13-7.942-1.218M13.116 11.475c1.158 1.333-.304 2.533-.304 2.533s2.939-1.518 1.589-3.418c-1.261-1.772-2.228-2.652 3.007-5.688 0-.001-8.216 2.051-4.292 6.573M19.33 20.504s.679.559-.747.991c-2.712.822-11.288 1.069-13.669.033-.856-.373.75-.89 1.254-.998.527-.114.828-.093.828-.093-.953-.671-6.156 1.317-2.643 1.887 9.58 1.553 17.462-.7 14.977-1.82M9.292 13.21s-4.362 1.036-1.544 1.412c1.189.159 3.561.123 5.77-.062 1.806-.152 3.618-.477 3.618-.477s-.637.272-1.098.587c-4.429 1.165-12.986.623-10.522-.568 2.082-1.006 3.776-.892 3.776-.892M17.116 17.584c4.503-2.34 2.421-4.589.968-4.285-.355.074-.515.138-.515.138s.132-.207.385-.297c2.875-1.011 5.086 2.981-.928 4.562 0-.001.07-.062.09-.118M14.401 0s2.494 2.494-2.365 6.33c-3.896 3.077-.888 4.832-.001 6.836-2.274-2.053-3.943-3.858-2.824-5.539 1.644-2.469 6.197-3.665 5.19-7.627M9.734 23.924c4.322.277 10.959-.153 11.116-2.198 0 0-.302.775-3.572 1.391-3.688.694-8.239.613-10.937.168 0-.001.553.457 3.393.639",source:"https://www.oracle.com/legal/logos.html",hex:"007396",guidelines:"https://www.oracle.com/legal/logos.html",license:void 0},siJamstack={title:"Jamstack",slug:"jamstack",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Jamstack</title><path d="'+this.path+'"/></svg>'},path:"M12 0C5.365 0 0 5.364 0 12s5.365 12 12 12 12-5.364 12-12V0zm.496 3.318h8.17v8.17h-8.17zm-9.168 9.178h8.16v8.149c-4.382-.257-7.904-3.767-8.16-8.149zm9.168.016h8.152a8.684 8.684 0 01-8.152 8.148z",source:"https://github.com/jamstack/jamstack.org/tree/main/src/site/img/logo",hex:"F0047F",guidelines:void 0,license:void 0},siJamboard={title:"Jamboard",slug:"jamboard",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Jamboard</title><path d="'+this.path+'"/></svg>'},path:"M12.143 0v7.877h7.783V0zm0 8.155v7.784h7.783V8.155zm-.28.005a7.926 7.923 0 0 0-7.789 7.917A7.926 7.923 0 0 0 12 24a7.926 7.923 0 0 0 7.918-7.78h-8.056Z",source:"https://cdn2.hubspot.net/hubfs/159104/ECS/Jamboard/Approved%20Jamboard%20Brand%20Book.pdf",hex:"F37C20",guidelines:"https://cdn2.hubspot.net/hubfs/159104/ECS/Jamboard/Approved%20Jamboard%20Brand%20Book.pdf",license:void 0},siWikiquote={title:"Wikiquote",slug:"wikiquote",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Wikiquote</title><path d="'+this.path+'"/></svg>'},path:"M10.152 12a4.037 4.037 0 1 1-8.075 0 4.037 4.037 0 0 1 8.075 0zM17.292.822c-.286-.287-.581-.56-.885-.822l-1.528 1.527C17.872 4.036 19.778 7.8 19.778 12s-1.906 7.964-4.899 10.473L16.407 24c.304-.262.6-.535.886-.822A15.705 15.705 0 0 0 21.923 12c0-4.223-1.644-8.192-4.63-11.178zM13.508 2.9L12.03 4.377a9.642 9.642 0 0 1 0 15.246l1.477 1.477a11.712 11.712 0 0 0 0-18.2zm-2.735 2.735L9.349 7.057c1.61 1.057 2.675 2.878 2.675 4.943s-1.065 3.886-2.675 4.943l1.423 1.422A7.884 7.884 0 0 0 14.005 12a7.884 7.884 0 0 0-3.233-6.365z",source:"https://commons.wikimedia.org/wiki/File:Wikiquote-logo.svg",hex:"006699",guidelines:void 0,license:void 0},siCommerzbank={title:"Commerzbank",slug:"commerzbank",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Commerzbank</title><path d="'+this.path+'"/></svg>'},path:"M6.277 1.538a.018.018 0 0 0-.012.007l-4.74 8.21-1.398 2.418c.446.774.794 1.353 1.22 2.09.671 1.164 1.548 1.597 3.13 1.889a12.9 12.9 0 0 1 .697-1.392l2.783-4.824 2.786-4.826c.404-.702 1.296-2.143 2.57-2.965-.04.025-.07.059-.109.085.07-.047.137-.094.209-.136.46-.278.98-.467 1.413-.515.339-.038 1.465-.041 2.74-.041zm11.59.505c-1.048-.008-1.462.007-2.545.008-1.39 0-2.381.887-3.083 1.773.372.493.68.971.863 1.288a13357.605 13357.605 0 0 0 5.571 9.648c.404.7 1.209 2.196 1.284 3.71.029.574-.079 1.165-.265 1.592-.131.3-.652 1.207-1.256 2.253L24 12.678v-.008a.013.013 0 0 0-.002-.005zM.001 8.163l.095 4.946L0 8.163zm.093 4.946 1.132 1.964 4.264 7.384a.015.015 0 0 0 .012.005h12.265c.446-.779.664-1.147 1.311-2.282.709-1.242.278-2.681-.037-3.472-.618.076-1.18.093-1.547.093H6.35c-.809 0-2.505-.05-3.853-.741-.513-.263-.972-.65-1.248-1.027-.176-.238-.625-1.003-1.156-1.924z",source:"https://commons.wikimedia.org/wiki/Category:Commerzbank_logos",hex:"FFCC33",guidelines:void 0,license:void 0},siJavascript={title:"JavaScript",slug:"javascript",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>JavaScript</title><path d="'+this.path+'"/></svg>'},path:"M0 0h24v24H0V0zm22.034 18.276c-.175-1.095-.888-2.015-3.003-2.873-.736-.345-1.554-.585-1.797-1.14-.091-.33-.105-.51-.046-.705.15-.646.915-.84 1.515-.66.39.12.75.42.976.9 1.034-.676 1.034-.676 1.755-1.125-.27-.42-.404-.601-.586-.78-.63-.705-1.469-1.065-2.834-1.034l-.705.089c-.676.165-1.32.525-1.71 1.005-1.14 1.291-.811 3.541.569 4.471 1.365 1.02 3.361 1.244 3.616 2.205.24 1.17-.87 1.545-1.966 1.41-.811-.18-1.26-.586-1.755-1.336l-1.83 1.051c.21.48.45.689.81 1.109 1.74 1.756 6.09 1.666 6.871-1.004.029-.09.24-.705.074-1.65l.046.067zm-8.983-7.245h-2.248c0 1.938-.009 3.864-.009 5.805 0 1.232.063 2.363-.138 2.711-.33.689-1.18.601-1.566.48-.396-.196-.597-.466-.83-.855-.063-.105-.11-.196-.127-.196l-1.825 1.125c.305.63.75 1.172 1.324 1.517.855.51 2.004.675 3.207.405.783-.226 1.458-.691 1.811-1.411.51-.93.402-2.07.397-3.346.012-2.054 0-4.109 0-6.179l.004-.056z",source:"https://github.com/voodootikigod/logo.js",hex:"F7DF1E",guidelines:void 0,license:{type:"MIT",url:"https://spdx.org/licenses/MIT"}},siJirasoftware={title:"Jira Software",slug:"jirasoftware",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Jira Software</title><path d="'+this.path+'"/></svg>'},path:"M12.004 0c-2.35 2.395-2.365 6.185.133 8.585l3.412 3.413-3.197 3.198a6.501 6.501 0 0 1 1.412 7.04l9.566-9.566a.95.95 0 0 0 0-1.344L12.004 0zm-1.748 1.74L.67 11.327a.95.95 0 0 0 0 1.344C4.45 16.44 8.22 20.244 12 24c2.295-2.298 2.395-6.096-.08-8.533l-3.47-3.469 3.2-3.2c-1.918-1.955-2.363-4.725-1.394-7.057z",source:"https://www.atlassian.com/company/news/press-kit",hex:"0052CC",guidelines:"https://atlassian.design/foundations/logos/",license:void 0},siJbl={title:"JBL",slug:"jbl",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>JBL</title><path d="'+this.path+'"/></svg>'},path:"M0 5.2645l2.0221 4.5892 2.0217-4.5892zm2.0221 7.601c.6982 0 1.2656-.5655 1.2656-1.2606 0-.6985-.5674-1.2618-1.2656-1.2618-.7003 0-1.2661.5633-1.2661 1.2618 0 .6951.5658 1.2607 1.2661 1.2607zm-1.0937 3.361c0 .9572.862 2.509 3.3142 2.509 2.4529 0 3.3154-1.1872 3.3154-2.509V5.2645H5.3693l.0011 11.3428c0 .6196-.5037 1.1392-1.1261 1.1392-.6231 0-1.1279-.5045-1.1279-1.124l-.0016-2.3108H.9284zm8.2885 2.3119V5.2645h4.3745c.8441 0 2.187.693 2.187 2.1628v2.2611c0 .6612-.5798 1.8328-1.4412 1.8328.8614 0 1.4412.7422 1.4412 1.3045v3.9788c0 .6767-.5463 1.7339-2.187 1.7339zm3.3802-7.559c.7955 0 .9944-.134.9944-2.2147 0-2.0801-.199-2.246-.9944-2.246h-1.1948v4.4575zm.9944 3.8108c0-2.0812 0-2.6906-.8636-2.6906h-1.3256v5.3482l1.3255.0027c.8636 0 .8636-.5807.8636-2.6603zm3.779 3.7482H24v-4.2267h-2.1886l.0016 2.3107c0 .6196-.5047 1.1241-1.1273 1.1241-.622 0-1.1273-.5045-1.1273-1.124V5.2644h-2.188Z",source:"https://www.jbl.com/",hex:"FF3300",guidelines:void 0,license:void 0},siWorldhealthorganization={title:"World Health Organization",slug:"worldhealthorganization",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>World Health Organization</title><path d="'+this.path+'"/></svg>'},path:"M12.0214 1.4122c-1.064 0-.6118 1.5783-.5273 2.0925 0 .025.0857 3.5707.1024 4.3789.1619-.0429.3226-.0822.4761-.119l.3214-.081c.0154-.782.094-4.1658.0964-4.1837.0702-.551.6272-2.0877-.469-2.0877zm-.3118 12.0405c.119-.0405.238-.0762.3452-.1107l.2297-.0714c0-.2274.069-3.372.0809-3.9433a7.2271 7.2271 0 0 0-.732.2107c.0083.4285.0702 3.5719.0762 3.9147zm.3928 1.1926c-.0405.0143-.144.0583-.2095.081-.0655.0226-.1571.0606-.1571.0845 0 .0238.0666 3.6195.0666 3.6992 0 .744.3785.7487.3785 0 0-.0535.0762-3.9159.0762-3.9159s-.0905.0298-.1547.0512zm-.8558-10.1468a5.4953 5.4953 0 0 0-.8332.3392c-.2975.0988-.7141.119-1.151.588a5.8905 5.8905 0 0 0-.3963.5094c-.131.188-.1369.4904-.238.6535-.1381.238-.1048.3701-.1048.3701v.0072a.632.632 0 0 1-.1595.2952.6046.6046 0 0 1-.5546.2213c.1975.0988.476-.0392.476-.0392a3.6433 3.6433 0 0 0-.1047.3927c.2214-.501.425-.6843.488-.7355.0952.0214.2928.013.6594-.1976.4142-.238 1.0367-.6249 1.2129-.87a1.6175 1.6175 0 0 1 .7332-.5535c-.0131-.3773-.0203-.7035-.0274-.9808zM9.4993 6.0637L9.284 6.11l.257-.413.3.0095zm1.2795 8.64c0 .4665.3452.714.6892.9128 0-.0785-.0143-.801-.0143-.8129.0071-.144.1464-.2309.2595-.2845a5.6 5.6 0 0 1 .5463-.2082c.1023-.0358.1892-.0703.2868-.0988.6904-.2083 1.489-.4761 1.489-1.3093 0-.8332-.6844-1.1902-1.4283-1.4438 0 .2678-.013.6594-.019.9296.3166.119.526.275.526.5142 0 .3011-.3213.476-.5486.5618a5.9252 5.9252 0 0 1-.2797.0976c-.1833.0571-.381.119-.5654.1904a2.7126 2.7126 0 0 0-.2797.119c-.3285.1643-.663.406-.6618.832zm4.5753-8.1496c0-.8534-.619-1.8009-2.1365-2.1353a3.6528 3.6528 0 0 0-.463-.0536c0 .1286-.0095.4237-.0095.4237 0 .0929-.0095.4345-.012.5083a2.1424 2.1424 0 0 1 .2917.0404c.882.2107 1.1974.7142 1.1974 1.2165 0 .8105-.6927 1.1164-1.5473 1.3473l-.2821.0738c-.2583.0643-.5237.1262-.7868.1964a10.782 10.782 0 0 0-.2797.0797c-.9438.288-1.7556.7427-1.7556 1.9044 0 1.1617.926 1.5878 1.8294 1.8663q-.0083-.4987-.019-1.0022c-.3988-.1868-.6797-.4332-.6797-.8474 0-.4142.256-.6499.6475-.8332a3.0192 3.0192 0 0 1 .2786-.1083c.225-.0762.476-.1416.7439-.2059l.282-.0678c1.2724-.2976 2.7007-.6963 2.7007-2.4031zm-2.8482 9.5362c.4284.2166.8236.5165.989 1.0843.0726-.9403-.4546-1.3474-.9771-1.6223l-.012.538zM19.5199 5.29c.4595.5475 1.2629.87 1.733 1.4188-.3368-1.6223-1.589-2.947-3.0696-3.2637.7225.544.8784 1.2998 1.3366 1.845zM1.7235 9.4023c1.02-2.2198 2.5423-1.7497 3.1862-3.8647-.357.6487-2.0234.9224-2.7982 2.5852.394-.988.1964-2.4995.863-3.3148-1.9926 1.47-1.144 3.848-1.251 4.5943zm1.8472 5.324c.1833.864-.357 2.1114.5 3.304-.8856-.9926-2.7614-1.245-3.5256-2.7542.9522 3.6898 3.4517 2.928 4.5694 3.729-.9237-1.327-.1679-2.209-1.5438-4.2789zm-.2868 2.315c-.5463-2.0603.4273-2.7745-.3166-4.7503-.0774 1.114-.8201 1.6568-.319 3.6898C1.7639 14.2597.3963 13.6169 0 12.4338c.0274 3.2351 2.6269 3.7148 3.2839 4.6075zm3.992 3.4517c-.7653-1.0594-.238-1.658-2.3923-3.5815.4546.7023-.0143 1.5854 1.4354 2.959-1.4188-.8332-3.3755-.4761-4.3194-1.5962 1.6211 3.103 4.4694 1.8366 5.2763 2.2222zm10.4051-.6225c1.4497-1.3736.9808-2.2615 1.4354-2.959-2.1495 1.9235-1.627 2.5221-2.3923 3.5815.807-.3857 3.6552.8807 5.2751-2.2187-.9427 1.1213-2.8994.763-4.3182 1.5997zm2.2484-1.8437c.8534-1.1903.3166-2.44.4999-3.3041-1.376 2.0698-.6201 2.9518-1.5473 4.2848 1.1236-.801 3.6135-.0416 4.5693-3.729-.763 1.5069-2.6364 1.7592-3.522 2.7519zm-3.435 2.6126a10.617 10.617 0 0 0-2.3508-.3571 5.6834 5.6834 0 0 0-2.1424.3642 5.687 5.687 0 0 0-2.1424-.3642 10.617 10.617 0 0 0-2.3508.357c-1.2938.344-2.4114.6106-3.3862.119.9343.8332 2.0234 1.1249 3.5981.9523 1.3093-.1405 2.3698-.7963 3.6052-.7868h.0488a6.6023 6.6023 0 0 0-2.0377 1.5842l.5952.0798s.6272-1.2605 2.0698-1.589c1.4426.3285 2.0698 1.589 2.0698 1.589l.5951-.0798a6.6213 6.6213 0 0 0-2.0377-1.5758h.0488c1.2355-.0096 2.2936.6463 3.604.7867 1.5748.1702 2.665-.1262 3.5994-.9522-.9748.4868-2.0925.2202-3.3863-.1238zM3.0553 10.0569c-.5333 1.0236-1.3617 1.2581-1.27 3.3767-.45-1.883-1.5188-2.5804-1.5057-3.7813-.7427 3.1303 1.2426 3.5016 1.752 4.8133-.075-1.8794 1.1248-2.259 1.0236-4.4087zm.745-2.4162c-.1856.2595-.3154.3702-.8105.7785a4.0194 4.0194 0 0 0-1.4426 2.353c.0512-1.1473-.6582-2.7958-.1869-3.998-1.8246 2.577.1048 4.1207.1726 5.0538.4737-1.796 1.5616-1.8103 2.2674-4.1873zm18.6511 3.1316A4.0254 4.0254 0 0 0 21.01 8.4192c-.4951-.4083-.6249-.519-.8105-.7785.7058 2.3805 1.7937 2.3912 2.2614 4.1873.0679-.9331 1.9972-2.4769.1714-5.0537.4761 1.202-.232 2.8506-.1809 3.998zm1.5473 1.6663c-.3963 1.1831-1.764 1.8258-2.6483 3.5517.5011-2.0377-.238-2.5805-.319-3.6898-.7439 1.9782.238 2.6888-.3166 4.7503.6582-.9022 3.2577-1.3819 3.2851-4.617zm-3.0506-2.3817c-.1011 2.1496 1.0998 2.5293 1.0236 4.404.5106-1.3093 2.4995-1.683 1.752-4.8134.0143 1.201-1.0545 1.9044-1.5008 3.7754.0833-2.1079-.7451-2.3424-1.2748-3.366zM4.4824 5.296c.4607-.5474.6166-1.3009 1.3379-1.8448-1.4807.3166-2.7376 1.6413-3.0697 3.2636.463-.5546 1.2677-.8772 1.727-1.4247zm14.6126.2476c.644 2.1151 2.1663 1.645 3.1851 3.8648-.106-.7463.7427-3.1244-1.2497-4.5944.6665.8165.469 2.327.8629 3.3148-.7773-1.6687-2.44-1.9424-2.803-2.5911zm-5.1692 1.195a4.9895 4.9895 0 0 0-1.2176-.3273v.2714a4.761 4.761 0 0 1 1.1188.307.7141.7141 0 0 0 .0988-.251zM13.6175 4.12l.081-.0726-.1548-.0655-.407-.0083-.106.0738-.238-.0202v.0583a4.136 4.136 0 0 1 .419.044l.1987-.0178zm-.789 8.778c0-.069-.0917-.1368-.2274-.2011h-.025c0 .056 0 .332-.0084.4666.1679-.075.2607-.156.2607-.2655zM8.1126 7.7205a1.2997 1.2997 0 0 1 .0345-.1488.6891.6891 0 0 1-.1666.0167zm3.8956 11.9738a8.3031 8.3031 0 0 0 .8463-16.5598c0 .0155 0 .0321-.0095.0476-.0167.081-.0322.1535-.044.2178a8.0163 8.0163 0 0 1 4.8359 2.2615l-.9165.9165.0345-.162-.119-.0523-.1643-.0095.0345-.106-.1106-.3749-.2286-.2511-.7141-.3773-.062.0655-.1296.038a2.1424 2.1424 0 0 1 .3785 1.2034v.163l.357.4464-.1666.038.1107.1667-.313.3118-.1262-.238a2.133 2.133 0 0 1-.238.4678l.0702.0642-.9653.9653a3.2917 3.2917 0 0 0-.181-.1607 4.5833 4.5833 0 0 1-.2832.119l.0821.0643-.0488.0488-.119.0631-.0417.119-.0702-.0702-.2035.0679.056.0892.1404-.0369.0916.0072.0072-.05.0702-.0357.0214-.0417.1262-.0357h.0988c.019.0167.0392.0345.057.0524l-.388.369-.0285-.0405-.4.0654-.0892.0893-.0869.0107.2476-.238-.088-.044-.2322.3094.0679-.0071v.119l.0845.0333.0166.119-.1392-.0273-.1452.0261-.3571-.1797-.0286 1.4164c.8332.2785 1.708.6808 1.708 1.7378a1.3093 1.3093 0 0 1-.595 1.1164l-.018.0119-.0261.0179c-.3357.2213-.7665.3404-1.1403.457l-.0107.7403c.5951.2952 1.3152.7249 1.2486 1.9544-.0084.3023-.1262.3856-.2274.413a6.2511 6.2511 0 0 1-1.0712.1702v.2702a6.6499 6.6499 0 0 0 4.1397-1.8282l.964.9641a8.0186 8.0186 0 0 1-11.1049.0226l.9641-.964a6.6451 6.6451 0 0 0 4.0814 1.8031v-.2702a6.3785 6.3785 0 0 1-3.8945-1.7222l.257-.2583.3572.0405.188-.2024.4928.0167.0726-.1702-.0179-.0726a4.999 4.999 0 0 0 2.5102 1.0033v-.2713a4.7526 4.7526 0 0 1-2.7042-1.2403l.9653-.9652a3.4338 3.4338 0 0 0 .782.5249.913.913 0 0 1 .0976-.2536 3.1208 3.1208 0 0 1-.6892-.463l.9677-.9664a1.7687 1.7687 0 0 0 .5166.2868v-.2904a1.4842 1.4842 0 0 1-.319-.1893l.2725-.2725a6.7378 6.7378 0 0 1-.288-.0929l-.1833.1833a1.4759 1.4759 0 0 1-.2309-.344 3.2815 3.2815 0 0 1-.476-.2547 1.8675 1.8675 0 0 1-.9035-1.6401 1.9687 1.9687 0 0 1 .3904-1.2498l-.9617-.9617a4.7502 4.7502 0 0 1 2.5757-1.2664c0-.0928 0-.1845-.006-.2714a5.0204 5.0204 0 0 0-2.76 1.3498l-.1631-.1595a4.504 4.504 0 0 0-.1297.2511l.1023.1036a5.0145 5.0145 0 0 0-1.364 3.3552H5.6096a6.382 6.382 0 0 1 1.7699-4.3253l.4332.4345a.5487.5487 0 0 0 .062 0 .6546.6546 0 0 0 .2463-.0715l-.551-.551a6.488 6.488 0 0 1 .9521-.7594 1.7925 1.7925 0 0 1 .0679-.2 3.2053 3.2053 0 0 1 .2083-.2797 6.6653 6.6653 0 0 0-1.4188 1.0462l-.9641-.964a7.9984 7.9984 0 0 1 4.7729-2.2377 2.1298 2.1298 0 0 1-.012-.0595c-.0118-.0631-.0261-.1333-.0392-.2071a8.3043 8.3043 0 0 0 .8665 16.5622zm1.7985-5.731v-.0071zm4.0206-8.108a8.0056 8.0056 0 0 1 2.2198 5.4561h-1.37a6.626 6.626 0 0 0-.7141-2.9137l.0119-.0238.094.05.0226-.0726-.238-.4273-.2892-.3999-.3428-.2797c-.119-.1452-.238-.2857-.3654-.4213zm-1.7437 1.7462l.3273.0143.0786.094-.0393.1392.4511.2857.0893-.0107.5832.6665.238-.0833a6.3559 6.3559 0 0 1 .5952 2.6042h-1.364a4.9728 4.9728 0 0 0-.1274-1.0378l.063-.0846.0846-.4272-.0643-.4595-.1642-.5284-.381-.557.093.0487.0463-.0464-.3059-.2071-.0202.0678.3059.4369.1726.357.119.3571.0393.238.063.4024-.119.0083s-.132-.2464-.1725-.3476l.0607-.0916-.119-.1666V9.107l-.0834-.1047-.1035.013a2.924 2.924 0 0 0-.119-.2035l.0737.037.019-.0191-.0392-.0857.0893-.05-.0405-.05-.1321.05.0488-.207-.0786-.0453-.0702.1654a5.0752 5.0752 0 0 0-.4963-.6308zm-.2737 3.1981l.2451-.1333.25-.038.0547-.119.1393-.0834.0536-.119.0428-.2012a4.071 4.071 0 0 1 .0548.2155l-.1321.394v.1332l.1916-.2559a4.611 4.611 0 0 1 .0678.7142h-1.1902l-.0274-.1036.1393-.1107.0273-.0666.0607-.0452.162-.0167.0166-.0714zm-1.6378-.9367l.119-.0285v-.0286l-.119-.0821.0416-.2571.1464-.1464a3.2327 3.2327 0 0 1 .2536.3297l-.0512.1583-.1333-.0952-.1012.0273.05.094h.05l-.056.1393-.038-.056zm.5225 4.5313l-.2952-.0833-.088.032-.1667-.1273-.1571-.056c.0774-.0559.1524-.119.225-.176l.238.1713.1857.0976.0916.0917zm-.15-5.2633l.9653-.9653a4.8121 4.8121 0 0 1 .5951.8023l-.119.0333.006.2154.357.2286a4.6657 4.6657 0 0 1 .2262.6094l-.0631.0928-.131.0833-.032.2-.0893.05-.075.088-.075-.0273h-.1333l.0774-.1048.0559-.2725.088-.0548-.2487-.2559-.194.0655-.044.182-.119.1322-.1274-.1048-.0452-.1118.0726-.0453.0404.0738.0595-.0226-.0261-.119h-.0845l-.006.05-.056.0107-.3035-.3559-.1023-.0774.0393-.0428.0904-.031-.0833-.0333s-.106.0238-.119.0238l.0607.0762h-.1524a3.2982 3.2982 0 0 0-.3047-.3928zm.4916 5.136l-.131-.131.1-.1298.1262-.257-.0488-.0715.0833-.1904-.0095-.1714-.05-.1773-.119-.0417-.044.1-.0715-.019a3.235 3.235 0 0 0 .2857-.4988l.119-.0523.069-.0929.0334.0381.0833-.1-.0666-.0833.0607-.0167.1118.0453h.2107l.1274-.0667.3332-.088-.063-.1107-.0215-.1345.1786.0785.0666-.0393-.0333-.138-.2154.0869-.238-.05-.1834-.375h1.0439a4.7514 4.7514 0 0 1-1.3176 3.1042l-.1429-.144.062-.1917-.112-.4225zm.1845 2.6625l.1285-.2762-.05-.119.1893-.1666v-.1l-.1619-.1012.1333-.2654.2-.2618-.2-.2155h-.15l-.0928-.1511a7.5411 7.5411 0 0 0 .238-.206l.9654.9653a6.4725 6.4725 0 0 1-1.1998.8987zm1.2045-1.2736l.1071-.119-.1011-.5285-.069-.0273.0428-.0893-.2285-.0714-.044.188-.0227.238-.0476.0441-.4166-.4166a5.0192 5.0192 0 0 0 1.3973-3.2934h1.3653a6.3737 6.3737 0 0 1-1.7973 4.2587zm.3761.375a6.6463 6.6463 0 0 0 1.877-4.4492h1.364a8.008 8.008 0 0 1-2.2757 5.4144zm-8.2126-1.3224a5.1601 5.1601 0 0 1-.2833-.319l.0417-.3452-.144-.3308-.0358-.5178-.1618-.3142.0333-.1952-.1952-.375-.1702-.0856.069-.1988-.0702-.1571.0702-.1798h.1869l.0654-.1083h.319l.0488.094-.0595.3298-.038.0559.119.2607-.0786.0428-.0548-.069-.0238.0262.0548.1547.094.181h.044l.031-.1762-.0452-.0596v-.1095l-.0143-.2261.0595-.3975-.0643-.1072h.2286a3.3898 3.3898 0 0 0 .939 2.1627zm-.9046-2.6673l-.1286.2023h-.2213l-.0179-.013a4.849 4.849 0 0 1-.069-.6488h.4106l-.0988.3285zm.4487-.9368l.025-.2713.1619-.094.2892.0511.044.0524a3.2136 3.2136 0 0 0-.044.469h-.3273zm1.389 1.02l.0679-.0344.1702.1345-.0774.063.2012.1334-.0048-.1429.1071-.1773.1119.119.119.1643-.219.0452.094.188.144-.0761-.0142-.0595.1071-.0727.063-.2975a1.7746 1.7746 0 0 0 .3131.476l-.964.9642a3.1196 3.1196 0 0 1-.8451-1.8116l.1975.2107h.1857zm-.9926-3.9825l.964.9653a3.441 3.441 0 0 0-.5117.7368h-.0667l-.1357.0416h-.0476l-.144.1345.182-.038.1643-.0417-.0285.063-.144.0882h-.0726l-.212.1618-.2046-.0166-.2964.5522.0583.1107-.1607.1786-.025.238h-.6046a4.7514 4.7514 0 0 1 1.2855-3.1744zM7.283 15.4202l.3059.1797.063.0428-.2213.2214q-.1548-.1607-.3-.332zm-.306-3.8386c0 .1321.0168.2643.031.394l-.1666.038-.0345.1691-.3476.4428.0084.6082-.3571.119h-.1952a6.3654 6.3654 0 0 1-.3047-1.7723zm-1.3473 1.764l-.0797-.0155-.075-.0845-.3833-.0333.119.1606-.357-.0666.0928-.0857-.0869-.0857-.2559.1119-.0916.169.0357.3892.2952.6999.1416.2213.081.0298-.2226-.4225-.0488-.2155.05-.0523-.031-.119.1345.0178.206.3118.0511.0203v-.2274l.0833.0488.0179.119.2166.0572.0905-.0643.031.0214v.1655l.0951.119.119.0262.2524.4273.1535.0428.0476-.2a6.7034 6.7034 0 0 0 .9403 1.2141l-.964.9641a8.0127 8.0127 0 0 1-2.3115-5.4287h1.3652a6.6451 6.6451 0 0 0 .288 1.764zm.5952-7.514l.964.964a6.6546 6.6546 0 0 0-1.8496 4.5158h-1.364A8.008 8.008 0 0 1 6.219 5.8316zm9.879-.4975l-.0822-.1333-.1785-.0893-.1393.106.1786.0951.1916.1464zm-.8344 3.8504v.1047l.238-.0702.0726-.144-.163-.2143.0869-.1309.2202.1571.0404-.0321-.044-.031-.05-.0952.0905-.0523-.0881-.119-.2071.1047-.069.1297-.0417.113.0916.1536-.0333.0714zm-9.8671 6.1202l.0179-.0619-.119-.2666-.1453-.0536zm5.5798-5.1276c0 .2286.1393.3904.3928.5297v-.1024l-.1595-.1594.0845-.1536.069-.019c0-.2666-.0106-.5654-.0118-.6082h-.012c-.2356.1309-.363.288-.363.513Z",source:"https://www.who.int/",hex:"0093D5",guidelines:void 0,license:void 0},siDiscogs={title:"Discogs",slug:"discogs",get svg(){return'<svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><title>Discogs</title><path d="'+this.path+'"/></svg>'},path:"M1.7422 11.982c0-5.6682 4.61-10.2782 10.2758-10.2782 1.8238 0 3.5372.48 5.0251 1.3175l.8135-1.4879C16.1768.588 14.2474.036 12.1908.0024h-.1944C5.4091.0144.072 5.3107 0 11.886v.1152c.0072 3.4389 1.4567 6.5345 3.7748 8.7207l1.1855-1.2814c-1.9798-1.8743-3.218-4.526-3.218-7.4585zM20.362 3.4053l-1.1543 1.2406c1.903 1.867 3.0885 4.4636 3.0885 7.3361 0 5.6658-4.61 10.2758-10.2758 10.2758-1.783 0-3.4605-.456-4.922-1.2575l-.8542 1.5214c1.7086.9384 3.6692 1.4735 5.7546 1.4759C18.6245 23.9976 24 18.6246 24 11.9988c-.0048-3.3717-1.399-6.4146-3.638-8.5935zM1.963 11.982c0 2.8701 1.2119 5.4619 3.146 7.2953l1.1808-1.2767c-1.591-1.5166-2.587-3.6524-2.587-6.0186 0-4.586 3.7293-8.3152 8.3152-8.3152 1.483 0 2.875.3912 4.082 1.0751l.8351-1.5262C15.481 2.395 13.8034 1.927 12.018 1.927 6.4746 1.9246 1.963 6.4362 1.963 1