/// <reference types="node" />
/// <reference lib="esnext" />
/// <reference lib="dom" />
export declare type Class<T = unknown> = new (...args: any[]) => T;
export declare const enum TypeName {
    null = "null",
    boolean = "boolean",
    undefined = "undefined",
    string = "string",
    number = "number",
    bigint = "bigint",
    symbol = "symbol",
    Function = "Function",
    Generator = "Generator",
    GeneratorFunction = "GeneratorFunction",
    AsyncFunction = "AsyncFunction",
    Observable = "Observable",
    Array = "Array",
    Buffer = "Buffer",
    Object = "Object",
    RegExp = "RegExp",
    Date = "Date",
    Error = "Error",
    Map = "Map",
    Set = "Set",
    WeakMap = "WeakMap",
    WeakSet = "WeakSet",
    Int8Array = "Int8Array",
    Uint8Array = "Uint8Array",
    Uint8ClampedArray = "Uint8ClampedArray",
    Int16Array = "Int16Array",
    Uint16Array = "Uint16Array",
    Int32Array = "Int32Array",
    Uint32Array = "Uint32Array",
    Float32Array = "Float32Array",
    Float64Array = "Float64Array",
    BigInt64Array = "BigInt64Array",
    BigUint64Array = "BigUint64Array",
    ArrayBuffer = "ArrayBuffer",
    SharedArrayBuffer = "SharedArrayBuffer",
    DataView = "DataView",
    Promise = "Promise",
    URL = "URL"
}
declare function is(value: unknown): TypeName;
declare namespace is {
    var undefined: (value: unknown) => value is undefined;
    var string: (value: unknown) => value is string;
    var number: (value: unknown) => value is number;
    var bigint: (value: unknown) => value is bigint;
    var function_: (value: unknown) => value is Function;
    var null_: (value: unknown) => value is null;
    var class_: (value: unknown) => value is Class<unknown>;
    var boolean: (value: unknown) => value is boolean;
    var symbol: (value: unknown) => value is symbol;
    var numericString: (value: unknown) => value is string;
    var array: (arg: any) => arg is any[];
    var buffer: (value: unknown) => value is Buffer;
    var nullOrUndefined: (value: unknown) => value is null | undefined;
    var object: (value: unknown) => value is object;
    var iterable: (value: unknown) => value is IterableIterator<unknown>;
    var asyncIterable: (value: unknown) => value is AsyncIterableIterator<unknown>;
    var generator: (value: unknown) => value is Generator<unknown, any, unknown>;
    var nativePromise: (value: unknown) => value is Promise<unknown>;
    var promise: (value: unknown) => value is Promise<unknown>;
    var generatorFunction: (value: unknown) => value is GeneratorFunction;
    var asyncFunction: (value: unknown) => value is Function;
    var boundFunction: (value: unknown) => value is Function;
    var regExp: (value: unknown) => value is RegExp;
    var date: (value: unknown) => value is Date;
    var error: (value: unknown) => value is Error;
    var map: (value: unknown) => value is Map<unknown, unknown>;
    var set: (value: unknown) => value is Set<unknown>;
    var weakMap: (value: unknown) => value is WeakMap<object, unknown>;
    var weakSet: (value: unknown) => value is WeakSet<object>;
    var int8Array: (value: unknown) => value is Int8Array;
    var uint8Array: (value: unknown) => value is Uint8Array;
    var uint8ClampedArray: (value: unknown) => value is Uint8ClampedArray;
    var int16Array: (value: unknown) => value is Int16Array;
    var uint16Array: (value: unknown) => value is Uint16Array;
    var int32Array: (value: unknown) => value is Int32Array;
    var uint32Array: (value: unknown) => value is Uint32Array;
    var float32Array: (value: unknown) => value is Float32Array;
    var float64Array: (value: unknown) => value is Float64Array;
    var bigInt64Array: (value: unknown) => value is BigInt64Array;
    var bigUint64Array: (value: unknown) => value is BigUint64Array;
    var arrayBuffer: (value: unknown) => value is ArrayBuffer;
    var sharedArrayBuffer: (value: unknown) => value is SharedArrayBuffer;
    var dataView: (value: unknown) => value is DataView;
    var directInstanceOf: <T>(instance: unknown, class_: Class<T>) => instance is T;
    var urlInstance: (value: unknown) => value is URL;
    var urlString: (value: unknown) => value is string;
    var truthy: (value: unknown) => boolean;
    var falsy: (value: unknown) => boolean;
    var nan: (value: unknown) => boolean;
    var primitive: (value: unknown) => value is Primitive;
    var integer: (value: unknown) => value is number;
    var safeInteger: (value: unknown) => value is number;
    var plainObject: (value: unknown) => value is {
        [key: string]: unknown;
    };
    var typedArray: (value: unknown) => value is TypedArray;
    var arrayLike: (value: unknown) => value is ArrayLike<unknown>;
    var inRange: (value: number, range: number | number[]) => value is number;
    var domElement: (value: unknown) => value is Element;
    var observable: (value: unknown) => value is ObservableLike;
    var nodeStream: (value: unknown) => value is NodeStream;
    var infinite: (value: unknown) => value is number;
    var evenInteger: (value: number) => value is number;
    var oddInteger: (value: number) => value is number;
    var emptyArray: (value: unknown) => value is never[];
    var nonEmptyArray: (value: unknown) => value is unknown[];
    var emptyString: (value: unknown) => value is "";
    var nonEmptyString: (value: unknown) => value is string;
    var emptyStringOrWhitespace: (value: unknown) => value is string;
    var emptyObject: (value: unknown) => value is {
        [key: string]: never;
    };
    var nonEmptyObject: (value: unknown) => value is {
        [key: string]: unknown;
    };
    var emptySet: (value: unknown) => value is Set<never>;
    var nonEmptySet: (value: unknown) => value is Set<unknown>;
    var emptyMap: (value: unknown) => value is Map<never, never>;
    var nonEmptyMap: (value: unknown) => value is Map<unknown, unknown>;
    var any: (predicate: Predicate, ...values: unknown[]) => boolean;
    var all: (predicate: Predicate, ...values: unknown[]) => boolean;
}
export declare type Primitive = null | undefined | string | number | bigint | boolean | symbol;
export declare type TypedArray = Int8Array | Uint8Array | Uint8ClampedArray | Int16Array | Uint16Array | Int32Array | Uint32Array | Float32Array | Float64Array | BigInt64Array | BigUint64Array;
export interface ArrayLike<T> {
    readonly length: number;
    readonly [index: number]: T;
}
export interface ObservableLike {
    subscribe(observer: (value: unknown) => void): void;
    [Symbol.observable](): ObservableLike;
}
export declare type NodeStream = object & {
    readonly pipe: Function;
};
export declare type Predicate = (value: unknown) => boolean;
export default is;
