export function multiplySvgPointsService(points, iconSize, width, height) {
    const iconMaxSize = Math.min(width, height) * 0.5;
    const scale = iconMaxSize / iconSize;
    return points.replace(/([0-9,\.]{1,})/g, (coords) => {
        const [_x, _y] = coords.split(',').map((p) => parseFloat(p));
        const x = _x * scale + width / 2 - (iconSize * scale) / 2;
        const y = _y * scale + height / 2 - (iconSize * scale) / 2;
        if (iconMaxSize >= 100) {
            return `${Math.round(x)},${Math.round(y)}`;
        }
        return `${x},${y}`;
    });
}
//# sourceMappingURL=data:application/json;base64,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