function multiplySvgPoints(pointsString, iconSize, width, height) {
  const iconMaxSize = Math.min(width, height) * 0.5;
  const scale = iconMaxSize / iconSize;
  // eslint-disable-next-line
  return pointsString.replace(/([0-9,\.]{1,})/g, (coords) => {
    // eslint-disable-next-line
    coords = coords.split(',').map((p) => parseFloat(p));
    const x = coords[0] * scale + width / 2 - (iconSize * scale) / 2;
    const y = coords[1] * scale + height / 2 - (iconSize * scale) / 2;
    if (iconMaxSize >= 100) {
      return `${Math.round(x)},${Math.round(y)}`;
    }
    return `${x},${y}`;
  });
}

export default multiplySvgPoints;
