---
layout: changelog
---
  * In the past, you had to contort your callbacks to any Web API endpoint, because not all errors were propogated through the error parameter. Well, good news: We are no longer forcing you to sit uncomfortably. Server errors that result in a `200 OK` + `{ok: false, error:"mumble_mumble"}` result are now passed through the error parameter so you can simplify your callback logic. If you want.
  * Did you know that Slack will pass information on the scopes required to call a particular Web API endpoint? [We do](https://api.slack.com/docs/oauth-scopes#working_with_scopes)! And now you can get your hands on that very same information in your Web API callbacks too. Will help you debug and identify failed calls due to scoping issues.
  * The Web API functionality has been expanded to include `users.profile.[get|set]`. Mind that you can only update your own profile :wink:
  * Did you notice that there were errors in the documentation? There were (and almost certainly still are). Several concerned readers wrote in with comments and fixes, all of which have been addressed.
  * Last but not least, we have added functionality to track basic usage of this SDK. All calls to the Web API and the RTM API are made with a user agent string that identifies the version of this SDK in use, as well as system information on node version and operating system. More better, you can add to this treasure trove of analytics—we've added a function in `helpers.js` that you can call from your code to let us know more about your framework or bot. In the future, we will be adding this same information to a wide range of SDKs that access the Slack Platform, and releasing usage data publicly so we can all see who is winning this popularity contest. 