# Changelog

All notable changes to this project will be documented in this file. See [standard-version](https://github.com/conventional-changelog/standard-version) for commit guidelines.

## [1.14.0](https://github.com/Cubelrti/sm-crypto-v2/compare/v1.13.0...v1.14.0) (2025-09-05)


### Features

* **sm2:** expose ecdh interface and test cases ([68af176](https://github.com/Cubelrti/sm-crypto-v2/commit/68af176fd4013ea0e3165ad31c21f9cae590fcf7))

## [1.13.0](https://github.com/Cubelrti/sm-crypto-v2/compare/v1.12.0...v1.13.0) (2025-07-15)


### Features

* downgrade to es2020 target ([3058285](https://github.com/Cubelrti/sm-crypto-v2/commit/305828570dc15fd686d04f3d85c37b978e8893c8))

## [1.12.0](https://github.com/Cubelrti/sm-crypto-v2/compare/v1.11.0...v1.12.0) (2025-06-05)


### Features

* **utils:** ensure sm2 runs in environment don't have TextEncoder ([6b74b8d](https://github.com/Cubelrti/sm-crypto-v2/commit/6b74b8d4df3ead8e2c01587e3c13cdbbf9a27701))

## [1.11.0](https://github.com/Cubelrti/sm-crypto-v2/compare/v1.10.1...v1.11.0) (2025-04-28)


### Features

* **sm3, kx:** expose kdf in sm3, added test case for parity ([f0091ca](https://github.com/Cubelrti/sm-crypto-v2/commit/f0091ca4a58a3369a83f274023268dfe2bda2794))

### [1.10.1](https://github.com/Cubelrti/sm-crypto-v2/compare/v1.10.0...v1.10.1) (2025-04-27)


### Bug Fixes

* miniprogram build issue ([5e8ece4](https://github.com/Cubelrti/sm-crypto-v2/commit/5e8ece41dab69fc449675f9d46dfd25163538a78))
* **sm2:** typing issue ([f368a72](https://github.com/Cubelrti/sm-crypto-v2/commit/f368a72cc354d0ec9601dda8cbd2590eb9e6c144))

## [1.10.0](https://github.com/Cubelrti/sm-crypto-v2/compare/v1.9.3...v1.10.0) (2025-04-14)


### Features

* **sm4:** support gcm mode for `sm4` ([2c6a0df](https://github.com/Cubelrti/sm-crypto-v2/commit/2c6a0df8d591d802fd4816c6b1824e20e0b23e31))

### [1.9.3](https://github.com/Cubelrti/sm-crypto-v2/compare/v1.9.2...v1.9.3) (2024-10-10)


### Bug Fixes

* **sm2:** utf8 to hex [#15](https://github.com/Cubelrti/sm-crypto-v2/issues/15) ([16a714a](https://github.com/Cubelrti/sm-crypto-v2/commit/16a714ad8775381c21b814fab6b1d57c263b3c65))

### [1.9.2](https://github.com/Cubelrti/sm-crypto-v2/compare/v1.9.1...v1.9.2) (2024-08-16)


### Bug Fixes

* **sm4:** string type return ([406fa5a](https://github.com/Cubelrti/sm-crypto-v2/commit/406fa5a848015e3a02339f109f60ec1e8ec3fe8b))

### [1.9.1](https://github.com/Cubelrti/sm-crypto-v2/compare/v1.9.0...v1.9.1) (2024-07-09)


### Bug Fixes

* **asn1:** correct the implementation of the long version of L encoding in asn.1 ([55569c5](https://github.com/Cubelrti/sm-crypto-v2/commit/55569c55235c0a82525b142ea9a4f8a2669654ce))

## [1.9.0](https://github.com/Cubelrti/sm-crypto-v2/compare/v1.7.0...v1.9.0) (2023-12-27)


### Features

* **sm2:** support asn1 der encoded encryption/decryption ([f08b9fd](https://github.com/Cubelrti/sm-crypto-v2/commit/f08b9fd5b64a2a257d41694c1858d7a6b07326ae))
* support miniprogram build ([bb4dddc](https://github.com/Cubelrti/sm-crypto-v2/commit/bb4dddcb4935299fe6db82912f393aa427961e40))

## [1.8.0](https://github.com/Cubelrti/sm-crypto-v2/compare/v1.7.0...v1.8.0) (2023-12-15)


### Features

* **sm2:** support asn1 der encoded encryption/decryption ([f08b9fd](https://github.com/Cubelrti/sm-crypto-v2/commit/f08b9fd5b64a2a257d41694c1858d7a6b07326ae))

## [1.7.0](https://github.com/Cubelrti/sm-crypto-v2/compare/v1.6.0...v1.7.0) (2023-07-17)


### Features

* **sm2:** support precompute sm2 point ([ae347bf](https://github.com/Cubelrti/sm-crypto-v2/commit/ae347bfff6c306318276a31f5958290ac7f07b9c))

## [1.6.0](https://github.com/Cubelrti/sm-crypto-v2/compare/v1.5.1...v1.6.0) (2023-07-11)


### Features

* **sm4:** optimize sm4 ([031159c](https://github.com/Cubelrti/sm-crypto-v2/commit/031159c7e2889f01b499b9286ce1d93a5e55b151))

### [1.5.1](https://github.com/Cubelrti/sm-crypto-v2/compare/v1.5.0...v1.5.1) (2023-06-28)


### Bug Fixes

* **sm2/kx:** align key exchange with standard ([b4fae83](https://github.com/Cubelrti/sm-crypto-v2/commit/b4fae831ae587821a9c1fe72617420134ae7f326))

## [1.5.0](https://github.com/Cubelrti/sm-crypto-v2/compare/v1.4.0...v1.5.0) (2023-06-11)


### Features

* add benchmark ([81736dd](https://github.com/Cubelrti/sm-crypto-v2/commit/81736dd3acc05131a81fcbee61ffc247c4e2f21c))
* add benchmark result ([a8a45b2](https://github.com/Cubelrti/sm-crypto-v2/commit/a8a45b2ce234ebcd8ebc4c245325a0866f3399e5))
* **sm3:** optimize sm3 ([096bd95](https://github.com/Cubelrti/sm-crypto-v2/commit/096bd9568b451ac52a9a01bc1bdd711cfeb595c6))

## [1.4.0](https://github.com/Cubelrti/sm-crypto-v2/compare/v1.3.0...v1.4.0) (2023-06-09)


### Features

* **sm2:** add experimental key agreement ([cdd00b4](https://github.com/Cubelrti/sm-crypto-v2/commit/cdd00b4e42bb5072e1dcb6e0301b6a2f18f53614))

## [1.3.0](https://github.com/Cubelrti/sm-crypto-v2/compare/v1.2.2...v1.3.0) (2023-06-07)


### Features

* **sm2:** add benchmark and optimize rng pooling ([b162377](https://github.com/Cubelrti/sm-crypto-v2/commit/b1623774cc4374deea61499f13790c5e8b17041a))

### [1.2.2](https://github.com/Cubelrti/sm-crypto-v2/compare/v1.2.1...v1.2.2) (2023-06-07)


### Bug Fixes

* **sm2:** add test for prng ([6502a34](https://github.com/Cubelrti/sm-crypto-v2/commit/6502a3440dae2ecfe62603239448076a11c760cf))

### [1.2.1](https://github.com/Cubelrti/sm-crypto-v2/compare/v1.2.0...v1.2.1) (2023-06-07)

## [1.2.0](https://github.com/Cubelrti/sm-crypto-v2/compare/v1.1.0...v1.2.0) (2023-06-07)


### Features

* **sm2:** use secure prng ([b8ba3bf](https://github.com/Cubelrti/sm-crypto-v2/commit/b8ba3bfc0f6948c60db65fd2efe284d0c46855e0))

## [1.1.0](https://github.com/Cubelrti/sm-crypto-v2/compare/v0.3.15...v1.1.0) (2023-06-07)

### [0.3.15](https://github.com/Cubelrti/sm-crypto-v2/compare/v0.3.13...v0.3.15) (2023-06-07)


### Features

* **ec:** add unit tests ([e513d51](https://github.com/Cubelrti/sm-crypto-v2/commit/e513d519fa82491bbb6c823cf862a7840bbc379e))

### [0.3.14](https://github.com/Cubelrti/sm-crypto-v2/compare/v0.3.13...v0.3.14) (2023-06-07)


### Features

* **ec:** add unit tests ([e513d51](https://github.com/Cubelrti/sm-crypto-v2/commit/e513d519fa82491bbb6c823cf862a7840bbc379e))

### 0.3.13 (2023-06-06)


### Features

* add asn1 test and coverage ([da9a6f7](https://github.com/Cubelrti/sm-crypto-v2/commit/da9a6f7e06f5e93b0849f80d0efc9131d151fdab))
* add dev deps ([5e2b3f3](https://github.com/Cubelrti/sm-crypto-v2/commit/5e2b3f33811d8d927da7954a3f4c0ecb87dec354))
* add test ([e97ce86](https://github.com/Cubelrti/sm-crypto-v2/commit/e97ce869f5f186cef3b02beeeb0607786823f612))
* sm2 support binary array ([db4c6c7](https://github.com/Cubelrti/sm-crypto-v2/commit/db4c6c7f5b2abd7926f9fc4118190cea3d527331))
* **sm2:** add shortcut for sm2 verify, better typing ([84f7f87](https://github.com/Cubelrti/sm-crypto-v2/commit/84f7f87672cb26fd5a5ec1b98be2765e07e2825b))


### Bug Fixes

* invalid padding check ([89189e3](https://github.com/Cubelrti/sm-crypto-v2/commit/89189e30f4f1083d973e7f57ae3e0e0f220f0efe))
* remove debug log ([b0f5f2a](https://github.com/Cubelrti/sm-crypto-v2/commit/b0f5f2a9808ff707d874e96c47556e55e26b4929))
* **sm2:** correct entl impl ([3d7d40d](https://github.com/Cubelrti/sm-crypto-v2/commit/3d7d40db162e76bc052771e7b9c26debdaa832a8))
* **test:** output reporter ([252ffdd](https://github.com/Cubelrti/sm-crypto-v2/commit/252ffdd289f6325d5e780e01de8137d8e3fe3453))
* **test:** summary ([73b83fa](https://github.com/Cubelrti/sm-crypto-v2/commit/73b83fa2b30db8311365841c603589f525c2d116))
* use pkcs[#7](https://github.com/Cubelrti/sm-crypto-v2/issues/7) instead of pkcs[#5](https://github.com/Cubelrti/sm-crypto-v2/issues/5) ([3f24a2a](https://github.com/Cubelrti/sm-crypto-v2/commit/3f24a2a45f09eaffc14271126b848115edf75fb7))
* use Uint8Array whenever possible ([d98cfcc](https://github.com/Cubelrti/sm-crypto-v2/commit/d98cfcc2d9b14040873b1efeda4e817ab12128d1))

## 0.3.12

* 优化 sm3 运行性能

## 0.3.11

* sm2 支持压缩公钥

## 0.3.10

* 支持 sm3 hmac 模式


## 0.3.9

* 补充 sm4 解密时的 padding 判断

## 0.3.8

* sm2 解密时兼容密文可能是大写的情况

## 0.3.7

* 默认填充改为 pkcs#7，如传入 pkcs#5 也转到 pkcs#7 逻辑

## 0.3.6

* sm2 加解密支持二进制数据

## 0.3.5

* sm2.generateKeyPairHex 支持完整的 BigInteger 入参

## 0.3.4

* sm2 支持验证公钥接口
* sm2 生成密钥时支持自定义随机数

## 0.3.3

* dist 输出改成 umd 模式

## 0.3.2

* 修复 sm2 在 userId 长度大于 31 时新旧版本验签不通过的问题
## 0.3.0

* sm2、sm3 重构
* sm4 支持 cbc 模式

## 0.2.7

* 优化 sm3 性能

## 0.2.5

* sm3 支持字节数组输入

## 0.2.4

* 修复 sm4 四字节字符输出编码

## 0.2.3

* sm3/sm4 支持输入四字节字符

## 0.2.2

* sm3 支持中文输入

## 0.2.1

* 修复 sm2 点 16 进制串可能不满 64 位的问题

## 0.2.0

* sm4 默认支持 pkcs#5 填充方式
* sm4 支持输入输出为字符串
