/*! For license information please see smart.ui.editor.js.LICENSE.txt */
(()=>{var e={928:(e,t,r)=>{"use strict";r.d(t,{Z:()=>s});var n=r(8081),o=r.n(n),a=r(3645),i=r.n(a)()(o());i.push([e.id,"/* smart-button, smart-repeat-button, smart-toggle-button */\r\nsmart-button,\r\nsmart-toggle-button,\r\nsmart-repeat-button {\r\n  --smart-button-flat-color: var(--smart-background-color);\r\n  text-align: center;\r\n  display: inline-flex;\r\n  vertical-align: middle;\r\n  cursor: pointer;\r\n  text-transform: var(--smart-button-text-transform);\r\n  letter-spacing: .08929em;\r\n  overflow: hidden;\r\n  border-color: var(--smart-border);\r\n  border-top-left-radius: var(--smart-border-top-left-radius);\r\n  border-top-right-radius: var(--smart-border-top-right-radius);\r\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\r\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\r\n  border-width: var(--smart-border-width);\r\n  border-style: solid;\r\n  visibility: hidden;\r\n  font-weight: 500;\r\n}\r\nsmart-button.smart-element,\r\nsmart-toggle-button.smart-element,\r\nsmart-repeat-button.smart-element {\r\n  display: inline-flex;\r\n  visibility: inherit;\r\n}\r\nsmart-button button::-moz-focus-inner,\r\nsmart-toggle-button button::-moz-focus-inner,\r\nsmart-repeat-button button::-moz-focus-inner {\r\n  border: 0;\r\n}\r\nsmart-button.primary,\r\nsmart-toggle-button.primary,\r\nsmart-repeat-button.primary {\r\n  --smart-button-opacity-hover: 0.75;\r\n  --smart-button-opacity-focus: 0.7;\r\n  --smart-button-opacity-active: 0.65;\r\n  --smart-background: var(--smart-primary);\r\n  --smart-border: var(--smart-primary);\r\n  --smart-border-rgb: var(--smart-primary-rgb);\r\n  --smart-background-color: var(--smart-primary-color);\r\n  --smart-ui-state-hover: var(--smart-primary);\r\n  --smart-ui-state-border-hover: var(--smart-primary);\r\n  --smart-ui-state-color-hover: var(--smart-primary-color);\r\n  --smart-ui-state-active: var(--smart-primary);\r\n  --smart-ui-state-border-active: var(--smart-primary);\r\n  --smart-ui-state-color-active: var(--smart-primary-color);\r\n  --smart-ui-state-focus: var(--smart-primary);\r\n  --smart-ui-state-border-focus: var(--smart-primary);\r\n  --smart-ui-state-color-focus: var(--smart-primary-color);\r\n  --smart-button-flat-color: var(--smart-primary);\r\n  --smart-button-outlined-color: var(--smart-primary);\r\n  --smart-button-outlined-border: var(--smart-primary);\r\n}\r\nsmart-button.secondary,\r\nsmart-toggle-button.secondary,\r\nsmart-repeat-button.secondary {\r\n  --smart-button-opacity-hover: 0.75;\r\n  --smart-button-opacity-focus: 0.7;\r\n  --smart-button-opacity-active: 0.65;\r\n  --smart-background: var(--smart-secondary);\r\n  --smart-border: var(--smart-secondary);\r\n  --smart-border-rgb: var(--smart-secondary-rgb);\r\n  --smart-background-color: var(--smart-secondary-color);\r\n  --smart-ui-state-hover: var(--smart-secondary);\r\n  --smart-ui-state-border-hover: var(--smart-secondary);\r\n  --smart-ui-state-color-hover: var(--smart-secondary-color);\r\n  --smart-ui-state-active: var(--smart-secondary);\r\n  --smart-ui-state-border-active: var(--smart-secondary);\r\n  --smart-ui-state-color-active: var(--smart-secondary-color);\r\n  --smart-ui-state-focus: var(--smart-secondary);\r\n  --smart-ui-state-border-focus: var(--smart-secondary);\r\n  --smart-ui-state-color-focus: var(--smart-secondary-color);\r\n  --smart-button-flat-color: var(--smart-secondary);\r\n  --smart-button-outlined-color: var(--smart-secondary);\r\n  --smart-button-outlined-border: var(--smart-secondary);\r\n}\r\nsmart-button.success,\r\nsmart-toggle-button.success,\r\nsmart-repeat-button.success {\r\n  --smart-button-opacity-hover: 0.75;\r\n  --smart-button-opacity-focus: 0.7;\r\n  --smart-button-opacity-active: 0.65;\r\n  --smart-background: var(--smart-success);\r\n  --smart-border: var(--smart-success);\r\n  --smart-border-rgb: var(--smart-success-rgb);\r\n  --smart-background-color: var(--smart-success-color);\r\n  --smart-ui-state-hover: var(--smart-success);\r\n  --smart-ui-state-border-hover: var(--smart-success);\r\n  --smart-ui-state-color-hover: var(--smart-success-color);\r\n  --smart-ui-state-active: var(--smart-success);\r\n  --smart-ui-state-border-active: var(--smart-success);\r\n  --smart-ui-state-color-active: var(--smart-success-color);\r\n  --smart-ui-state-focus: var(--smart-success);\r\n  --smart-ui-state-border-focus: var(--smart-success);\r\n  --smart-ui-state-color-focus: var(--smart-success-color);\r\n  --smart-button-flat-color: var(--smart-success);\r\n  --smart-button-outlined-color: var(--smart-success);\r\n  --smart-button-outlined-border: var(--smart-success);\r\n}\r\nsmart-button.error,\r\nsmart-toggle-button.error,\r\nsmart-repeat-button.error {\r\n  --smart-button-opacity-hover: 0.75;\r\n  --smart-button-opacity-focus: 0.7;\r\n  --smart-button-opacity-active: 0.65;\r\n  --smart-background: var(--smart-error);\r\n  --smart-border: var(--smart-error);\r\n  --smart-border-rgb: var(--smart-error-rgb);\r\n  --smart-background-color: var(--smart-error-color);\r\n  --smart-ui-state-hover: var(--smart-error);\r\n  --smart-ui-state-border-hover: var(--smart-error);\r\n  --smart-ui-state-color-hover: var(--smart-error-color);\r\n  --smart-ui-state-active: var(--smart-error);\r\n  --smart-ui-state-border-active: var(--smart-error);\r\n  --smart-ui-state-color-active: var(--smart-error-color);\r\n  --smart-ui-state-focus: var(--smart-error);\r\n  --smart-ui-state-border-focus: var(--smart-error);\r\n  --smart-ui-state-color-focus: var(--smart-error-color);\r\n  --smart-button-flat-color: var(--smart-error);\r\n  --smart-button-outlined-color: var(--smart-error);\r\n  --smart-button-outlined-border: var(--smart-error);\r\n}\r\nsmart-button.info,\r\nsmart-toggle-button.info,\r\nsmart-repeat-button.info {\r\n  --smart-button-opacity-hover: 0.75;\r\n  --smart-button-opacity-focus: 0.7;\r\n  --smart-button-opacity-active: 0.65;\r\n  --smart-background: var(--smart-info);\r\n  --smart-border: var(--smart-info);\r\n  --smart-border-rgb: var(--smart-info-rgb);\r\n  --smart-background-color: var(--smart-info-color);\r\n  --smart-ui-state-hover: var(--smart-info);\r\n  --smart-ui-state-border-hover: var(--smart-info);\r\n  --smart-ui-state-color-hover: var(--smart-info-color);\r\n  --smart-ui-state-active: var(--smart-info);\r\n  --smart-ui-state-border-active: var(--smart-info);\r\n  --smart-ui-state-color-active: var(--smart-info-color);\r\n  --smart-ui-state-focus: var(--smart-info);\r\n  --smart-ui-state-border-focus: var(--smart-info);\r\n  --smart-ui-state-color-focus: var(--smart-info-color);\r\n  --smart-button-flat-color: var(--smart-info);\r\n  --smart-button-outlined-color: var(--smart-info);\r\n  --smart-button-outlined-border: var(--smart-info);\r\n}\r\nsmart-button.warning,\r\nsmart-toggle-button.warning,\r\nsmart-repeat-button.warning {\r\n  --smart-button-opacity-hover: 0.75;\r\n  --smart-button-opacity-focus: 0.7;\r\n  --smart-button-opacity-active: 0.65;\r\n  --smart-background: var(--smart-warning);\r\n  --smart-border: var(--smart-warning);\r\n  --smart-border-rgb: var(--smart-warning-rgb);\r\n  --smart-background-color: var(--smart-warning-color);\r\n  --smart-ui-state-hover: var(--smart-warning);\r\n  --smart-ui-state-border-hover: var(--smart-warning);\r\n  --smart-ui-state-color-hover: var(--smart-warning-color);\r\n  --smart-ui-state-active: var(--smart-warning);\r\n  --smart-ui-state-border-active: var(--smart-warning);\r\n  --smart-ui-state-color-active: var(--smart-warning-color);\r\n  --smart-ui-state-focus: var(--smart-warning);\r\n  --smart-ui-state-border-focus: var(--smart-warning);\r\n  --smart-ui-state-color-focus: var(--smart-warning-color);\r\n  --smart-button-flat-color: var(--smart-warning);\r\n  --smart-button-outlined-color: var(--smart-warning);\r\n  --smart-button-outlined-border: var(--smart-warning);\r\n}\r\nsmart-button.light,\r\nsmart-toggle-button.light,\r\nsmart-repeat-button.light {\r\n  --smart-button-opacity-hover: 0.75;\r\n  --smart-button-opacity-focus: 0.7;\r\n  --smart-button-opacity-active: 0.65;\r\n  --smart-background: var(--smart-light);\r\n  --smart-border: var(--smart-light);\r\n  --smart-border-rgb: var(--smart-light-rgb);\r\n  --smart-background-color: var(--smart-light-color);\r\n  --smart-ui-state-hover: var(--smart-light);\r\n  --smart-ui-state-border-hover: var(--smart-light);\r\n  --smart-ui-state-color-hover: var(--smart-light-color);\r\n  --smart-ui-state-active: var(--smart-light);\r\n  --smart-ui-state-border-active: var(--smart-light);\r\n  --smart-ui-state-color-active: var(--smart-light-color);\r\n  --smart-ui-state-focus: var(--smart-light);\r\n  --smart-ui-state-border-focus: var(--smart-light);\r\n  --smart-ui-state-color-focus: var(--smart-light-color);\r\n  --smart-button-flat-color: var(--smart-light);\r\n  --smart-button-outlined-color: var(--smart-light);\r\n  --smart-button-outlined-border: var(--smart-light);\r\n}\r\nsmart-button.dark,\r\nsmart-toggle-button.dark,\r\nsmart-repeat-button.dark {\r\n  --smart-button-opacity-hover: 0.75;\r\n  --smart-button-opacity-focus: 0.7;\r\n  --smart-button-opacity-active: 0.65;\r\n  --smart-background: var(--smart-dark);\r\n  --smart-border: var(--smart-dark);\r\n  --smart-border-rgb: var(--smart-dark-rgb);\r\n  --smart-background-color: var(--smart-dark-color);\r\n  --smart-ui-state-hover: var(--smart-dark);\r\n  --smart-ui-state-border-hover: var(--smart-dark);\r\n  --smart-ui-state-color-hover: var(--smart-dark-color);\r\n  --smart-ui-state-active: var(--smart-dark);\r\n  --smart-ui-state-border-active: var(--smart-dark);\r\n  --smart-ui-state-color-active: var(--smart-dark-color);\r\n  --smart-ui-state-focus: var(--smart-dark);\r\n  --smart-ui-state-border-focus: var(--smart-dark);\r\n  --smart-ui-state-color-focus: var(--smart-dark-color);\r\n  --smart-button-flat-color: var(--smart-dark);\r\n  --smart-button-outlined-color: var(--smart-dark);\r\n  --smart-button-outlined-border: var(--smart-dark);\r\n}\r\nsmart-button[hover],\r\nsmart-toggle-button[hover],\r\nsmart-repeat-button[hover] {\r\n  color: var(--smart-ui-state-color-hover);\r\n  border-color: var(--smart-ui-state-border-hover);\r\n  background-color: var(--smart-ui-state-hover);\r\n  transition: background-color 100ms linear, box-shadow 280ms ease-in-out;\r\n  opacity: var(--smart-button-opacity-hover);\r\n}\r\nsmart-button[focus],\r\nsmart-toggle-button[focus],\r\nsmart-repeat-button[focus] {\r\n  color: var(--smart-ui-state-color-focus);\r\n  border-color: var(--smart-ui-state-border-focus);\r\n  background-color: var(--smart-ui-state-focus);\r\n  opacity: var(--smart-button-opacity-focus);\r\n}\r\nsmart-button[active],\r\nsmart-toggle-button[active],\r\nsmart-repeat-button[active] {\r\n  color: var(--smart-ui-state-color-active);\r\n  border-color: var(--smart-ui-state-border-active);\r\n  background-color: var(--smart-ui-state-active);\r\n  transition: background-color 100ms linear, box-shadow 280ms ease-in-out;\r\n  opacity: var(--smart-button-opacity-active);\r\n}\r\nsmart-button[disabled],\r\nsmart-toggle-button[disabled],\r\nsmart-repeat-button[disabled] {\r\n  color: var(--smart-disabled-color);\r\n  border-color: var(--smart-disabled);\r\n  background-color: var(--smart-disabled);\r\n  cursor: default;\r\n  --smart-background: var(--smart-disabled);\r\n  --smart-border: var(--smart-disabled);\r\n  --smart-background-color: var(--smart-disabled-color);\r\n}\r\nsmart-button.large button,\r\nsmart-toggle-button.large button,\r\nsmart-repeat-button.large button {\r\n  padding: var(--smart-button-large-padding);\r\n  font-size: var(--smart-button-large-font-size);\r\n}\r\nsmart-button.small button,\r\nsmart-toggle-button.small button,\r\nsmart-repeat-button.small button {\r\n  padding: var(--smart-button-small-padding);\r\n  font-size: var(--smart-button-small-font-size);\r\n}\r\nsmart-button.very-small button,\r\nsmart-toggle-button.very-small button,\r\nsmart-repeat-button.very-small button {\r\n  padding: var(--smart-button-very-small-padding);\r\n  font-size: var(--smart-button-very-small-font-size);\r\n}\r\nsmart-button.rounded,\r\nsmart-toggle-button.rounded,\r\nsmart-repeat-button.rounded {\r\n  --smart-border-top-left-radius: 50px;\r\n  --smart-border-top-right-radius: 50px;\r\n  --smart-border-bottom-left-radius: 50px;\r\n  --smart-border-bottom-right-radius: 50px;\r\n  border-radius: var(--smart-border-bottom-left-radius) !important;\r\n}\r\nsmart-button.squared,\r\nsmart-toggle-button.squared,\r\nsmart-repeat-button.squared {\r\n  --smart-border-top-left-radius: 0;\r\n  --smart-border-top-right-radius: 0;\r\n  --smart-border-bottom-left-radius: 0;\r\n  --smart-border-bottom-right-radius: 0;\r\n}\r\nsmart-button.flat,\r\nsmart-toggle-button.flat,\r\nsmart-repeat-button.flat {\r\n  color: var(--smart-button-flat-color);\r\n  background: transparent;\r\n  border-color: transparent;\r\n}\r\nsmart-button.flat[hover],\r\nsmart-toggle-button.flat[hover],\r\nsmart-repeat-button.flat[hover] {\r\n  color: var(--smart-button-flat-color);\r\n  background: transparent;\r\n  border-color: transparent;\r\n}\r\nsmart-button.flat[active],\r\nsmart-toggle-button.flat[active],\r\nsmart-repeat-button.flat[active] {\r\n  color: var(--smart-button-flat-color);\r\n  background: transparent;\r\n  border-color: transparent;\r\n}\r\nsmart-button.flat[focus],\r\nsmart-toggle-button.flat[focus],\r\nsmart-repeat-button.flat[focus] {\r\n  border-color: var(--smart-ui-state-focus);\r\n}\r\nsmart-button.flat[checked],\r\nsmart-toggle-button.flat[checked],\r\nsmart-repeat-button.flat[checked] {\r\n  text-decoration: underline;\r\n  background: var(--smart-ui-state-active);\r\n}\r\nsmart-button.flat .smart-ripple,\r\nsmart-toggle-button.flat .smart-ripple,\r\nsmart-repeat-button.flat .smart-ripple {\r\n  background-color: var(--smart-button-flat-color);\r\n}\r\nsmart-button.outlined,\r\nsmart-toggle-button.outlined,\r\nsmart-repeat-button.outlined {\r\n  color: var(--smart-button-outlined-color);\r\n  border-color: var(--smart-button-outlined-border);\r\n  background: transparent;\r\n  border-width: calc(2 * var(--smart-border-width));\r\n}\r\nsmart-button.outlined[hover],\r\nsmart-toggle-button.outlined[hover],\r\nsmart-repeat-button.outlined[hover] {\r\n  color: var(--smart-button-outlined-color);\r\n  border-color: var(--smart-button-outlined-border);\r\n  background: transparent;\r\n}\r\nsmart-button.outlined[active],\r\nsmart-toggle-button.outlined[active],\r\nsmart-repeat-button.outlined[active] {\r\n  color: var(--smart-button-outlined-color);\r\n  border-color: var(--smart-button-outlined-border);\r\n  background: transparent;\r\n}\r\nsmart-button.outlined[focus],\r\nsmart-toggle-button.outlined[focus],\r\nsmart-repeat-button.outlined[focus] {\r\n  color: var(--smart-button-outlined-color);\r\n  border-color: var(--smart-ui-state-focus);\r\n  background: transparent;\r\n}\r\nsmart-button.outlined[checked],\r\nsmart-toggle-button.outlined[checked],\r\nsmart-repeat-button.outlined[checked] {\r\n  color: var(--smart-ui-state-color-active);\r\n  border-color: var(--smart-ui-state-active);\r\n  background: var(--smart-ui-state-active);\r\n}\r\nsmart-button.outlined .smart-ripple,\r\nsmart-toggle-button.outlined .smart-ripple,\r\nsmart-repeat-button.outlined .smart-ripple {\r\n  background-color: var(--smart-button-outlined-color);\r\n}\r\nsmart-button.outlined button.smart-button,\r\nsmart-toggle-button.outlined button.smart-button,\r\nsmart-repeat-button.outlined button.smart-button {\r\n  border-radius: initial;\r\n}\r\nsmart-button.raised,\r\nsmart-toggle-button.raised,\r\nsmart-repeat-button.raised {\r\n  box-shadow: var(--smart-elevation-2);\r\n  transition: background-color 100ms linear, box-shadow 280ms ease-in-out;\r\n}\r\nsmart-button.raised[hover],\r\nsmart-toggle-button.raised[hover],\r\nsmart-repeat-button.raised[hover] {\r\n  box-shadow: var(--smart-elevation-4);\r\n}\r\nsmart-button.raised[active], smart-button.raised[checked], smart-button.raised[active],\r\nsmart-button.raised button[active],\r\nsmart-toggle-button.raised[active],\r\nsmart-toggle-button.raised[checked],\r\nsmart-toggle-button.raised[active],\r\nsmart-toggle-button.raised button[active],\r\nsmart-repeat-button.raised[active],\r\nsmart-repeat-button.raised[checked],\r\nsmart-repeat-button.raised[active],\r\nsmart-repeat-button.raised button[active] {\r\n  box-shadow: var(--smart-elevation-8);\r\n}\r\nsmart-button.raised[focus], smart-button.raised[focus]:not([checked]),\r\nsmart-toggle-button.raised[focus],\r\nsmart-toggle-button.raised[focus]:not([checked]),\r\nsmart-repeat-button.raised[focus],\r\nsmart-repeat-button.raised[focus]:not([checked]) {\r\n  box-shadow: var(--smart-elevation-6);\r\n}\r\nsmart-button.floating,\r\nsmart-toggle-button.floating,\r\nsmart-repeat-button.floating {\r\n  border-radius: 50%;\r\n  width: 48px;\r\n  height: 48px;\r\n  box-shadow: var(--smart-elevation-4);\r\n  transition: background-color 100ms linear, box-shadow 280ms ease-in-out;\r\n}\r\nsmart-button.floating[hover],\r\nsmart-toggle-button.floating[hover],\r\nsmart-repeat-button.floating[hover] {\r\n  box-shadow: var(--smart-elevation-6);\r\n}\r\nsmart-button.floating[active], smart-button.floating[checked],\r\nsmart-toggle-button.floating[active],\r\nsmart-toggle-button.floating[checked],\r\nsmart-repeat-button.floating[active],\r\nsmart-repeat-button.floating[checked] {\r\n  box-shadow: var(--smart-elevation-12);\r\n}\r\nsmart-button.floating[focus], smart-button.floating[focus]:not([checked]),\r\nsmart-toggle-button.floating[focus],\r\nsmart-toggle-button.floating[focus]:not([checked]),\r\nsmart-repeat-button.floating[focus],\r\nsmart-repeat-button.floating[focus]:not([checked]) {\r\n  box-shadow: var(--smart-elevation-6);\r\n}\r\n\r\nbutton.smart-button {\r\n  position: relative;\r\n  padding: var(--smart-button-padding);\r\n  text-align: inherit;\r\n  vertical-align: inherit;\r\n  cursor: inherit;\r\n  text-transform: inherit;\r\n  font-weight: inherit;\r\n  letter-spacing: inherit;\r\n  background: inherit;\r\n  color: inherit;\r\n  border: none;\r\n  -webkit-font-smoothing: antialiased;\r\n  opacity: var(--smart-button-opacity);\r\n  white-space: nowrap;\r\n  border-radius: inherit;\r\n}\r\n\r\n.smart-button .smart-ripple {\r\n  background: var(--smart-background-color);\r\n}\r\n\r\nsmart-toggle-button .smart-container,\r\n[smart-toggle-button] .smart-container {\r\n  font-weight: inherit;\r\n  font-style: inherit;\r\n}\r\nsmart-toggle-button[checked],\r\n[smart-toggle-button][checked] {\r\n  color: var(--smart-ui-state-color-selected);\r\n  border-color: var(--smart-ui-state-border-selected);\r\n  background-color: var(--smart-ui-state-selected);\r\n}\r\n\r\n.smart-scroll-button .smart-button {\r\n  padding: 0px;\r\n}\r\n\r\n:host(.smart-button.flat) .smart-ripple {\r\n  background-color: var(--smart-button-flat-color);\r\n}\r\n\r\n:host(.smart-button.outlined) .smart-ripple {\r\n  background-color: var(--smart-button-outlined-color);\r\n}\r\n\r\nbutton.smart-button[type]:not(.smart-container) {\r\n  border-color: var(--smart-border);\r\n  border-top-left-radius: var(--smart-border-top-left-radius);\r\n  border-top-right-radius: var(--smart-border-top-right-radius);\r\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\r\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\r\n  border-width: var(--smart-border-width);\r\n  border-style: solid;\r\n  text-align: center;\r\n  vertical-align: middle;\r\n  cursor: pointer;\r\n  text-transform: var(--smart-button-text-transform);\r\n  font-weight: 500;\r\n  letter-spacing: .08929em;\r\n  overflow: hidden;\r\n  font-style: var(--smart-font-style);\r\n  font-size: var(--smart-font-size);\r\n  background: var(--smart-background);\r\n  outline: none;\r\n}\r\n\r\nbutton.smart-button[type]:hover {\r\n  color: var(--smart-ui-state-color-hover);\r\n  border-color: var(--smart-ui-state-border-hover);\r\n  background-color: var(--smart-ui-state-hover);\r\n}\r\n\r\nbutton.smart-button[type]:not([disabled]):active {\r\n  color: var(--smart-ui-state-color-active);\r\n  border-color: var(--smart-ui-state-border-active);\r\n  background-color: var(--smart-ui-state-active);\r\n}\r\n\r\n/* smart-button, smart-repeat-button, smart-toggle-button */\r\nsmart-button[right-to-left],\r\nsmart-toggle-button[right-to-left],\r\nsmart-repeat-button[right-to-left] {\r\n  direction: rtl;\r\n}\r\n",""]);const s=i},621:(e,t,r)=>{"use strict";r.d(t,{Z:()=>s});var n=r(8081),o=r.n(n),a=r(3645),i=r.n(a)()(o());i.push([e.id,"/* smart-check-box */\r\nsmart-check-box {\r\n  display: inline-block;\r\n  outline: none;\r\n  height: var(--smart-editor-height);\r\n  font-family: var(--smart-check-box-font-family);\r\n  font-size: var(--smart-check-box-font-size);\r\n  cursor: pointer;\r\n  line-height: 1; }\r\n  smart-check-box .smart-container {\r\n    position: relative;\r\n    display: flex;\r\n    /*justify-content: center;*/\r\n    align-items: center; }\r\n  smart-check-box .smart-overlay {\r\n    top: 0;\r\n    height: 100%;\r\n    background: var(--smart-check-box-background-active);\r\n    width: var(--smart-editor-height);\r\n    position: absolute;\r\n    left: 2px;\r\n    border-radius: 100%;\r\n    padding: 0px;\r\n    opacity: 0;\r\n    box-sizing: content-box;\r\n    transition: opacity 280ms ease-in-out; }\r\n  smart-check-box .smart-input {\r\n    width: var(--smart-check-box-default-size);\r\n    min-width: var(--smart-check-box-default-size);\r\n    height: var(--smart-check-box-default-size);\r\n    min-height: var(--smart-check-box-default-size);\r\n    background-color: var(--smart-check-box-background);\r\n    box-sizing: initial;\r\n    border-style: solid;\r\n    border-width: var(--smart-check-box-border-width);\r\n    border-color: var(--smart-check-box-border);\r\n    display: inline-block;\r\n    color: var(--smart-check-box-color);\r\n    border-top-left-radius: var(--smart-check-box-border-top-left-radius);\r\n    border-top-right-radius: var(--smart-check-box-border-top-right-radius);\r\n    border-bottom-left-radius: var(--smart-check-box-border-bottom-left-radius);\r\n    border-bottom-right-radius: var(--smart-check-box-border-bottom-right-radius);\r\n    margin: 0 0 0 8px;\r\n    transition: background linear 0.2s;\r\n    position: relative; }\r\n    smart-check-box .smart-input:after {\r\n      content: '';\r\n      position: absolute;\r\n      top: 50%;\r\n      left: 50%;\r\n      transform: translate(-50%, -50%);\r\n      width: 100%;\r\n      height: 100%;\r\n      font-style: normal;\r\n      font-variant: normal;\r\n      font-family: 'Material icons';\r\n      font-size: 15px;\r\n      font-weight: 100;\r\n      text-decoration: inherit;\r\n      text-transform: none;\r\n      color: inherit;\r\n      line-height: 100%; }\r\n  smart-check-box .smart-label {\r\n    color: var(--smart-check-box-color);\r\n    font-size: var(--smart-check-box-font-size);\r\n    font-family: var(--smart-check-box-font-family);\r\n    margin: 0 8px 0 8px;\r\n    white-space: nowrap;\r\n    overflow: hidden;\r\n    text-overflow: ellipsis;\r\n    width: auto; }\r\n  smart-check-box .smart-ripple {\r\n    background: var(--smart-check-box-background-active); }\r\n  smart-check-box:focus .smart-input, smart-check-box[focus] .smart-input {\r\n    outline: none;\r\n    overflow: visible;\r\n    border-color: var(--smart-check-box-border-focus);\r\n    background-color: var(--smart-check-box-background-focus);\r\n    color: var(--smart-check-box-color-focus); }\r\n  smart-check-box:focus .smart-overlay, smart-check-box[focus] .smart-overlay {\r\n    opacity: 0.3; }\r\n  smart-check-box:focus[active] .smart-overlay, smart-check-box[focus][active] .smart-overlay {\r\n    opacity: 0.4; }\r\n  smart-check-box[hover] .smart-input {\r\n    border-color: var(--smart-check-box-border-hover);\r\n    background-color: var(--smart-check-box-background-hover);\r\n    color: var(--smart-check-box-color-hover); }\r\n  smart-check-box[active] .smart-input {\r\n    border-color: var(--smart-check-box-border-active);\r\n    background-color: var(--smart-check-box-background-active);\r\n    color: var(--smart-check-box-color-active); }\r\n  smart-check-box[checked] .smart-input {\r\n    border-color: var(--smart-check-box-border-active);\r\n    background-color: var(--smart-check-box-background-active);\r\n    color: var(--smart-check-box-color-active); }\r\n    smart-check-box[checked] .smart-input:after {\r\n      content: '\\e876';\r\n      font-family: 'Material icons';\r\n      font-size: 15px;\r\n      font-weight: 100; }\r\n  smart-check-box[checked=\"null\"] .smart-input:after {\r\n    content: '-'; }\r\n  smart-check-box[check-mode=\"label\"] {\r\n    cursor: default; }\r\n    smart-check-box[check-mode=\"label\"] .smart-label {\r\n      cursor: pointer; }\r\n  smart-check-box[check-mode=\"input\"] {\r\n    cursor: default; }\r\n    smart-check-box[check-mode=\"input\"] .smart-input {\r\n      cursor: pointer; }\r\n  smart-check-box[readonly] {\r\n    cursor: initial; }\r\n    smart-check-box[readonly] .smart-input,\r\n    smart-check-box[readonly] .smart-label {\r\n      cursor: initial; }\r\n\r\n/* smart-check-box */\r\nsmart-check-box[right-to-left] .smart-container,\r\nsmart-check-box[right-to-left] .smart-hidden-input {\r\n  direction: rtl; }\r\nsmart-check-box[right-to-left] .smart-overlay {\r\n  left: initial;\r\n  right: 2px; }\r\nsmart-check-box[right-to-left] .smart-input {\r\n  margin: 0 8px 0 0; }\r\n",""]);const s=i},6900:(e,t,r)=>{"use strict";r.d(t,{Z:()=>s});var n=r(8081),o=r.n(n),a=r(3645),i=r.n(a)()(o());i.push([e.id,'/* smart-color-panel */\r\nsmart-color-panel {\r\n  width: var(--smart-color-panel-default-width);\r\n  height: var(--smart-color-panel-default-height);\r\n  user-select: none;\r\n}\r\nsmart-color-panel .no-touch {\r\n  touch-action: none;\r\n}\r\nsmart-color-panel.smart-element {\r\n  display: inline-block;\r\n  overflow: initial;\r\n  border: none;\r\n  background: var(--smart-background);\r\n  color: var(--smart-background-color);\r\n}\r\nsmart-color-panel[disabled] {\r\n  opacity: 0.55;\r\n  pointer-events: none;\r\n  user-select: none;\r\n}\r\n\r\n.smart-color-panel .smart-content {\r\n  position: relative;\r\n  cursor: pointer;\r\n  display: flex;\r\n  width: 100%;\r\n  height: 100%;\r\n}\r\n.smart-color-panel label {\r\n  /*min-width: 16px;*/\r\n  display: inline-block;\r\n  user-select: none;\r\n}\r\n.smart-color-panel smart-tooltip .smart-tooltip-content {\r\n  box-shadow: 0px 0px 20px 0px #8b8b8b;\r\n}\r\n.smart-color-panel input[type=number]::-webkit-inner-spin-button,\r\n.smart-color-panel input[type=number]::-webkit-outer-spin-button {\r\n  -webkit-appearance: none;\r\n  margin: 0;\r\n}\r\n.smart-color-panel input[type=number] {\r\n  -moz-appearance: textfield;\r\n  -webkit-appearance: textfied;\r\n}\r\n.smart-color-panel .color-input {\r\n  width: 70px;\r\n  height: var(--smart-editor-height);\r\n  margin: 5px;\r\n  padding: 5px;\r\n  border: var(--smart-border-width) solid var(--smart-border);\r\n  border-radius: var(--smart-border-radius);\r\n  background: var(--smart-background);\r\n  color: var(--smart-color);\r\n  outline: none;\r\n}\r\n.smart-color-panel .color-input:focus {\r\n  border-color: var(--smart-outline);\r\n}\r\n.smart-color-panel .color-input::selection {\r\n  background: var(--smart-editor-selection);\r\n  color: var(--smart-editor-selection-color);\r\n}\r\n.smart-color-panel .grid-mode-container,\r\n.smart-color-panel .palette-mode-container {\r\n  width: 100%;\r\n  max-height: 100%;\r\n  position: relative;\r\n}\r\n.smart-color-panel .custom-color-selection .buttons-container {\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: flex-end;\r\n}\r\n.smart-color-panel .gray-shades-box,\r\n.smart-color-panel .spectrum-box,\r\n.smart-color-panel .custom-colors-box,\r\n.smart-color-panel .grid-samples-container {\r\n  display: grid;\r\n  grid-template-columns: repeat(var(--smart-color-panel-grid-mode-column-count), auto);\r\n}\r\n.smart-color-panel .hue-scale {\r\n  display: block;\r\n  max-width: 100px;\r\n  height: var(--smart-color-panel-palette-size);\r\n  background-image: linear-gradient(#ff0000, #ff00ff, #0000ff, #00ffff, #00ff00, #ffff00, #ff0000);\r\n  /* reversed (#ff0000, #ffff00, #00ff00, #00ffff, #0000ff, #ff00ff, #ff0000) */\r\n  width: 20px;\r\n  margin-left: 15px;\r\n  margin-right: 15px;\r\n  position: relative;\r\n  padding: 1px;\r\n  border: var(--smart-border-width) solid var(--smart-border);\r\n  background-clip: content-box;\r\n  -webkit-background-clip: content-box;\r\n}\r\n.smart-color-panel .hue-scale-thumb {\r\n  width: 100%;\r\n  height: 10px;\r\n  box-sizing: content-box;\r\n  border: 3px solid white;\r\n  border-left-width: 10px;\r\n  border-right-width: 10px;\r\n  position: absolute;\r\n  left: -10px;\r\n  top: -3px;\r\n  box-shadow: 0px 0px 5px #666, inset 0px 0px 2px 0px #999, inset 0px 0px 2px 0px #999;\r\n  opacity: 0.8;\r\n  cursor: pointer;\r\n}\r\n.smart-color-panel .color-palette-thumb {\r\n  width: 0px;\r\n  height: 0px;\r\n  top: 0px;\r\n  position: absolute;\r\n  z-index: 10;\r\n  pointer-events: none;\r\n}\r\n.smart-color-panel .color-palette-thumb:after {\r\n  content: " ";\r\n  position: absolute;\r\n  left: -14px;\r\n  top: -14px;\r\n  width: 16px;\r\n  height: 16px;\r\n  border: 5px solid white;\r\n  border-radius: 50%;\r\n  box-shadow: var(--smart-elevation-2);\r\n}\r\n.smart-color-panel .color-palette {\r\n  width: var(--smart-color-panel-palette-size);\r\n  height: var(--smart-color-panel-palette-size);\r\n  background-color: red;\r\n  display: block;\r\n  position: relative;\r\n  overflow: hidden;\r\n  cursor: crosshair;\r\n  padding: 1px;\r\n  border: 1px solid lightgray;\r\n  background-clip: content-box;\r\n  -webkit-background-clip: content-box;\r\n}\r\n.smart-color-panel .color-palette:before, .smart-color-panel .color-palette:after {\r\n  width: 100%;\r\n  height: 100%;\r\n  content: " ";\r\n  display: block;\r\n  position: absolute;\r\n  left: 0;\r\n  top: 0;\r\n  z-index: 0;\r\n}\r\n.smart-color-panel .color-palette:before {\r\n  background-image: linear-gradient(90deg, white, transparent);\r\n}\r\n.smart-color-panel .color-palette:after {\r\n  background-image: linear-gradient(transparent, black);\r\n}\r\n.smart-color-panel .color-controls-container {\r\n  display: block;\r\n  max-width: 100px;\r\n  overflow: hidden;\r\n}\r\n.smart-color-panel .color-palette-container {\r\n  width: 100%;\r\n  height: var(--smart-color-panel-palette-size);\r\n  display: flex;\r\n  flex-direction: row;\r\n}\r\n.smart-color-panel .preview-container {\r\n  width: 100%;\r\n  min-width: 100px;\r\n  /* or use variable thet defines the default width of the column*/\r\n  height: 100px;\r\n  background-color: white;\r\n  margin-bottom: 20px;\r\n  position: relative;\r\n  padding: 1px;\r\n  border: var(--smart-border-width) solid var(--smart-border);\r\n  background-clip: content-box;\r\n  -webkit-background-clip: content-box;\r\n}\r\n.smart-color-panel .preview-container-top,\r\n.smart-color-panel .preview-container-bottom {\r\n  width: 100%;\r\n  height: 50%;\r\n  display: block;\r\n  background-color: white;\r\n}\r\n.smart-color-panel .alpha-channel-container {\r\n  flex-direction: row;\r\n  width: 100%;\r\n  align-items: center;\r\n  align-content: space-around;\r\n  margin-top: 5px;\r\n  display: none;\r\n}\r\n.smart-color-panel .alpha-channel-container label {\r\n  width: 48px;\r\n}\r\n.smart-color-panel .alpha-channel-scale {\r\n  width: var(--smart-color-panel-palette-size);\r\n  height: 20px;\r\n  margin-top: 15px;\r\n  margin-bottom: 15px;\r\n  position: relative;\r\n  border: var(--smart-border-width) solid var(--smart-border);\r\n  margin-right: 20px;\r\n}\r\n.smart-color-panel .alpha-channel-scale:before, .smart-color-panel .alpha-channel-scale:after {\r\n  position: absolute;\r\n  left: 0;\r\n  top: 0;\r\n  display: block;\r\n  width: 100%;\r\n  height: 100%;\r\n  content: " ";\r\n}\r\n.smart-color-panel .alpha-channel-scale:before {\r\n  background-image: linear-gradient(45deg, #cccccc 25%, transparent 25%, transparent 74%, #cccccc 75%, #cccccc), linear-gradient(45deg, #cccccc 25%, transparent 25%, transparent 74%, #cccccc 75%, #cccccc);\r\n  background-position: 0px 6px, 8px 14px;\r\n  background-size: 16px 16px;\r\n}\r\n.smart-color-panel .alpha-channel-scale:after {\r\n  background-image: linear-gradient(90deg, var(--smart-color-panel-alpha-channel-color), transparent);\r\n  box-shadow: inset 1px -1px 0px 0px #ffffff, inset -1px 1px 0px 0px #ffffff;\r\n}\r\n.smart-color-panel .alpha-channel-thumb {\r\n  width: 10px;\r\n  height: 100%;\r\n  box-sizing: content-box;\r\n  border: 3px solid white;\r\n  border-top-width: 10px;\r\n  border-bottom-width: 10px;\r\n  position: absolute;\r\n  left: -3px;\r\n  top: -10px;\r\n  opacity: 0.8;\r\n  box-shadow: 0px 0px 5px #666, inset 0px 0px 2px 0px #999, inset 0px 0px 2px 0px #999;\r\n  cursor: pointer;\r\n  z-index: 1;\r\n}\r\n.smart-color-panel .buttons-container {\r\n  display: none;\r\n  flex-direction: row;\r\n  justify-content: flex-end;\r\n  padding: 10px 0 0 0;\r\n}\r\n.smart-color-panel .buttons-container smart-button {\r\n  width: 100px;\r\n}\r\n.smart-color-panel .buttons-container smart-button:last-of-type {\r\n  margin-left: 20px;\r\n}\r\n.smart-color-panel .gradient-background {\r\n  background-image: linear-gradient(45deg, #cccccc 25%, transparent 25%, transparent 74%, #cccccc 75%, #cccccc), linear-gradient(45deg, #cccccc 25%, transparent 25%, transparent 74%, #cccccc 75%, #cccccc);\r\n  background-position: 0px 6px, 8px 14px;\r\n  background-size: 16px 16px;\r\n}\r\n.smart-color-panel .user-color-container {\r\n  width: var(--smart-color-panel-grid-mode-item-size);\r\n  height: var(--smart-color-panel-grid-mode-item-size);\r\n  background-image: linear-gradient(45deg, #cccccc 25%, transparent 25%, transparent 74%, #cccccc 75%, #cccccc), linear-gradient(45deg, #cccccc 25%, transparent 25%, transparent 74%, #cccccc 75%, #cccccc);\r\n  background-position: 0px 5px, 5px 10px;\r\n  background-size: 10px 10px;\r\n}\r\n.smart-color-panel .material-grid-samples-container {\r\n  display: grid;\r\n  grid-template-columns: 80px repeat(14, auto);\r\n}\r\n.smart-color-panel .button-custom-color {\r\n  margin: 5px 0px 5px 0px;\r\n}\r\n.smart-color-panel .color-sample {\r\n  width: var(--smart-color-panel-grid-mode-item-size);\r\n  height: var(--smart-color-panel-grid-mode-item-size);\r\n  margin: var(--smart-color-panel-grid-mode-columns-gap);\r\n  box-sizing: border-box;\r\n  cursor: pointer;\r\n  border: var(--smart-border-width) solid rgba(0, 0, 0, 0.1);\r\n  background-clip: content-box;\r\n  -webkit-background-clip: content-box;\r\n  text-overflow: ellipsis;\r\n}\r\n.smart-color-panel .color-sample.user-color {\r\n  position: relative;\r\n  background-clip: padding-box;\r\n  -webkit-background-clip: padding-box;\r\n}\r\n.smart-color-panel .color-sample.user-color:before {\r\n  position: absolute;\r\n  content: \'\';\r\n  width: 100%;\r\n  height: 100%;\r\n  background-image: linear-gradient(45deg, #cccccc 25%, transparent 25%, transparent 74%, #cccccc 75%, #cccccc), linear-gradient(45deg, #cccccc 25%, transparent 25%, transparent 74%, #cccccc 75%, #cccccc);\r\n  background-position: 0px 5px, 5px 10px;\r\n  background-size: 10px 10px;\r\n  top: 50%;\r\n  left: 50%;\r\n  transform: translate(-50%, -50%);\r\n  z-index: -1;\r\n}\r\n.smart-color-panel .color-sample.selected {\r\n  border: 2px solid var(--smart-ui-state-color-selected);\r\n  padding: 1px;\r\n}\r\n.smart-color-panel .color-sample.empty {\r\n  visibility: hidden;\r\n}\r\n.smart-color-panel .color-sample.header, .smart-color-panel .color-sample.label-column {\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  font-size: 11px;\r\n  border-width: 0px;\r\n  pointer-events: none;\r\n  user-select: none;\r\n}\r\n.smart-color-panel .color-sample.label-column {\r\n  width: 100%;\r\n  justify-content: flex-start;\r\n}\r\n.smart-color-panel .color-sample.color-sample-column, .smart-color-panel .color-sample.color-sample-row {\r\n  width: 16px;\r\n  /*to be calculated dinamically*/\r\n  height: 16px;\r\n  /*to be calculated dinamically*/\r\n  border: 2px solid rgba(0, 0, 0, 0.2);\r\n  padding: 1px;\r\n  background: repeating-linear-gradient(-55deg, #fff, #fff 10px, #eee 10px, #eee 20px);\r\n}\r\n.smart-color-panel .color-sample[transparent] {\r\n  position: relative;\r\n}\r\n.smart-color-panel .color-sample[transparent]:after {\r\n  content: \'\';\r\n  border: 1px solid red;\r\n  top: 50%;\r\n  left: 50%;\r\n  transform: translate(-50%, -50%) rotate(-45deg);\r\n  position: absolute;\r\n  width: 150%;\r\n  border-radius: 5px;\r\n}\r\n.smart-color-panel .user-color.empty {\r\n  background: repeating-linear-gradient(-55deg, #fff, #fff 10px, #eee 10px, #eee 20px);\r\n  background-origin: content-box;\r\n  border-color: lightgray;\r\n}\r\n.smart-color-panel .default-samples-container div {\r\n  display: grid;\r\n  grid-template-columns: repeat(10, auto);\r\n  justify-items: center;\r\n}\r\n.smart-color-panel .default-samples-container .theme-shades-box {\r\n  margin-top: var(--smart-color-panel-default-mode-sections-gap);\r\n  margin-bottom: var(--smart-color-panel-default-mode-sections-gap);\r\n}\r\n.smart-color-panel .default-samples-container .theme-colors-label,\r\n.smart-color-panel .default-samples-container .standard-colors-label {\r\n  display: block;\r\n  font-weight: 600;\r\n  margin-left: 2px;\r\n  margin-top: var(--smart-color-panel-default-mode-sections-gap);\r\n  margin-bottom: var(--smart-color-panel-default-mode-sections-gap);\r\n  margin-bottom: calc(var(--smart-color-panel-default-mode-sections-gap) / 2);\r\n}\r\n.smart-color-panel .hex-mode-resize-trigger {\r\n  visibility: hidden;\r\n  position: absolute;\r\n  left: 0;\r\n  top: 0;\r\n}\r\n.smart-color-panel[edit-alpha-channel] .alpha-channel-container {\r\n  display: flex;\r\n}\r\n.smart-color-panel[enable-custom-colors] .button-custom-color,\r\n.smart-color-panel[enable-custom-colors] .user-samples-container {\r\n  width: 100%;\r\n  display: flex;\r\n  align-items: center;\r\n}\r\n.smart-color-panel[enable-custom-colors]:not([display-mode="palette"]):not([display-mdoe="radial"]) .custom-color-selection .palette-mode-container {\r\n  display: block;\r\n}\r\n.smart-color-panel:not([display-mode="radial"]) .canvas-radial {\r\n  display: none;\r\n}\r\n.smart-color-panel[display-mode="hexagonal"] .brightness-scale, .smart-color-panel[display-mode="radial"] .brightness-scale {\r\n  display: block;\r\n  max-width: 100px;\r\n  height: var(--smart-color-panel-palette-size);\r\n  background-image: linear-gradient(#ff0000, #ff00ff, #0000ff, #00ffff, #00ff00, #ffff00, #ff0000);\r\n  /* reversed (#ff0000, #ffff00, #00ff00, #00ffff, #0000ff, #ff00ff, #ff0000) */\r\n  width: 20px;\r\n  margin-left: 15px;\r\n  margin-right: 15px;\r\n  position: relative;\r\n  padding: 1px;\r\n  border: var(--smart-border-width) solid var(--smart-border);\r\n  background-clip: content-box;\r\n  -webkit-background-clip: content-box;\r\n}\r\n.smart-color-panel[display-mode="hexagonal"] .brightness-scale-thumb, .smart-color-panel[display-mode="radial"] .brightness-scale-thumb {\r\n  width: 100%;\r\n  height: 10px;\r\n  box-sizing: content-box;\r\n  border: 3px solid white;\r\n  border-left-width: 10px;\r\n  border-right-width: 10px;\r\n  position: absolute;\r\n  left: -10px;\r\n  top: -3px;\r\n  box-shadow: 0px 0px 5px #666, inset 0px 0px 2px 0px #999, inset 0px 0px 2px 0px #999;\r\n  opacity: 0.8;\r\n  cursor: pointer;\r\n}\r\n.smart-color-panel[display-mode="hexagonal"] .alpha-channel-scale {\r\n  width: var(--smart-color-panel-palette-width);\r\n}\r\n.smart-color-panel[display-mode="hexagonal"] .brightness-scale {\r\n  display: block;\r\n  height: var(--smart-color-panel-palette-height);\r\n  background-image: linear-gradient(white, black);\r\n}\r\n.smart-color-panel[display-mode="hexagonal"] .selected {\r\n  stroke: white;\r\n  stroke-width: 4px;\r\n}\r\n.smart-color-panel[display-mode="hexagonal"] .color-palette-container {\r\n  height: var(--smart-color-panel-palette-height);\r\n}\r\n.smart-color-panel[display-mode="hexagonal"] .palette-mode-container {\r\n  display: block;\r\n}\r\n.smart-color-panel[display-mode="hexagonal"] .color-palette-hexagonal {\r\n  display: block;\r\n}\r\n.smart-color-panel[display-mode="radial"] .hue-scale {\r\n  display: none;\r\n}\r\n.smart-color-panel[display-mode="radial"] .brightness-scale {\r\n  background-image: linear-gradient(white, black);\r\n}\r\n.smart-color-panel[display-mode="radial"] .color-palette-radial {\r\n  width: var(--smart-color-panel-palette-size);\r\n  height: var(--smart-color-panel-palette-size);\r\n  display: block;\r\n  position: relative;\r\n  overflow: hidden;\r\n  cursor: crosshair;\r\n  padding: 1px;\r\n  border: 1px solid lightgray;\r\n  background-clip: content-box;\r\n  -webkit-background-clip: content-box;\r\n  background: conic-gradient(from 90deg, red, yellow, lime, aqua, blue, magenta, red) #ff005a;\r\n  border-radius: 50%;\r\n}\r\n.smart-color-panel[display-mode="radial"] .color-palette-radial:after {\r\n  width: 100%;\r\n  height: 100%;\r\n  content: " ";\r\n  display: block;\r\n  position: absolute;\r\n  left: 0px;\r\n  top: 0px;\r\n  z-index: 0;\r\n  background: black;\r\n  opacity: var(--smart-color-panel-brightness);\r\n  border-radius: 50%;\r\n}\r\n.smart-color-panel[display-mode="radial"] .color-palette-radial-thumb {\r\n  width: 0px;\r\n  height: 0px;\r\n  position: absolute;\r\n  z-index: 10;\r\n  pointer-events: none;\r\n  left: 50%;\r\n  top: 50%;\r\n}\r\n.smart-color-panel[display-mode="radial"] .color-palette-radial-thumb:after {\r\n  content: " ";\r\n  position: absolute;\r\n  left: -14px;\r\n  top: -14px;\r\n  width: 16px;\r\n  height: 16px;\r\n  border: 5px solid white;\r\n  border-radius: 50%;\r\n  box-shadow: var(--smart-elevation-2);\r\n}\r\n.smart-color-panel[display-mode="radial"] .white-radial-gradient {\r\n  z-index: 2;\r\n  width: var(--smart-color-panel-palette-size);\r\n  height: var(--smart-color-panel-palette-size);\r\n  position: absolute;\r\n  top: 50%;\r\n  left: 50%;\r\n  transform: translate(-50%, -50%);\r\n  border-radius: 50%;\r\n  background-image: radial-gradient(circle, white, transparent);\r\n}\r\n.smart-color-panel[display-mode="radial"] .palette-mode-container {\r\n  display: block;\r\n}\r\n.smart-color-panel[display-mode="radial"] canvas {\r\n  transform: rotate(-180deg);\r\n  transform-origin: center;\r\n}\r\n.smart-color-panel[display-mode="radial"][inverted] .color-palette-radial:after {\r\n  background: white;\r\n}\r\n.smart-color-panel[display-mode="radial"][inverted] .white-radial-gradient {\r\n  background: radial-gradient(black, transparent);\r\n}\r\n.smart-color-panel[display-mode="spectrumGrid"] .spectrum-grid-samples-container {\r\n  display: block;\r\n}\r\n.smart-color-panel[display-mode="default"] .default-samples-container {\r\n  display: block;\r\n}\r\n.smart-color-panel[display-mode="palette"] .palette-mode-container {\r\n  display: block;\r\n}\r\n.smart-color-panel[display-mode="palette"] .color-palette {\r\n  display: block;\r\n}\r\n.smart-color-panel[display-mode="materialGrid"] .color-palette {\r\n  display: block;\r\n}\r\n.smart-color-panel[apply-value-mode="useButtons"] .buttons-container {\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: flex-end;\r\n}\r\n\r\n.smart-color-panel .palette-mode-container,\r\n.smart-color-panel .spectrum-grid-samples-container,\r\n.smart-color-panel .color-palette-hexagonal,\r\n.smart-color-panel .custom-color-selection .grid-mode-container,\r\n.smart-color-panel .button-custom-color,\r\n.smart-color-panel .user-samples-container {\r\n  display: none;\r\n}\r\n.smart-color-panel[display-mode="default"] .grid-samples-container,\r\n.smart-color-panel[display-mode="default"] .palette-mode-container,\r\n.smart-color-panel[display-mode="default"] .material-grid-samples-container {\r\n  display: none;\r\n}\r\n.smart-color-panel[display-mode="grid"] .palette-mode-container,\r\n.smart-color-panel[display-mode="grid"] .material-grid-samples-container,\r\n.smart-color-panel[display-mode="grid"] .default-samples-container {\r\n  display: none;\r\n}\r\n.smart-color-panel[display-mode="spectrumGrid"] .palette-mode-container,\r\n.smart-color-panel[display-mode="spectrumGrid"] .grid-samples-container,\r\n.smart-color-panel[display-mode="spectrumGrid"] .material-grid-samples-container,\r\n.smart-color-panel[display-mode="spectrumGrid"] .default-samples-container {\r\n  display: none;\r\n}\r\n.smart-color-panel[display-mode="materialGrid"] .palette-mode-container,\r\n.smart-color-panel[display-mode="materialGrid"] .grid-samples-container,\r\n.smart-color-panel[display-mode="materialGrid"] .default-samples-container {\r\n  display: none;\r\n}\r\n.smart-color-panel[display-mode="hexagonal"] .grid-samples-container,\r\n.smart-color-panel[display-mode="hexagonal"] .spectrum-grid-samples-container,\r\n.smart-color-panel[display-mode="hexagonal"] .color-palette,\r\n.smart-color-panel[display-mode="hexagonal"] .hue-scale,\r\n.smart-color-panel[display-mode="hexagonal"] .default-samples-container {\r\n  display: none;\r\n}\r\n.smart-color-panel[display-mode="palette"] .color-palette-radial,\r\n.smart-color-panel[display-mode="palette"] .grid-mode-container {\r\n  display: none;\r\n}\r\n.smart-color-panel[display-mode="radial"] .color-palette,\r\n.smart-color-panel[display-mode="radial"] .grid-mode-container {\r\n  display: none;\r\n}\r\n.smart-color-panel[enable-custom-colors][display-mode="hexagonal"] .button-custom-color,\r\n.smart-color-panel[enable-custom-colors][display-mode="hexagonal"] .user-samples-container {\r\n  display: none;\r\n}\r\n.smart-color-panel[hide-preview-container] .preview-container {\r\n  display: none;\r\n}\r\n.smart-color-panel[hide-alpha-editor] .a-channel {\r\n  display: none;\r\n}\r\n.smart-color-panel[hide-r-g-b-editor] .r-channel,\r\n.smart-color-panel[hide-r-g-b-editor] .g-channel,\r\n.smart-color-panel[hide-r-g-b-editor] .b-channel {\r\n  display: none;\r\n}\r\n.smart-color-panel[hide-h-e-x-editor] .hex {\r\n  display: none;\r\n}\r\n\r\n/* smart-color-panel */\r\nsmart-color-panel[right-to-left] .grid-mode-container,\r\nsmart-color-panel[right-to-left] .color-palette-container,\r\nsmart-color-panel[right-to-left] .alpha-channel-container {\r\n  direction: rtl;\r\n}\r\nsmart-color-panel[right-to-left] .alpha-channel-scale {\r\n  margin: 0 0 0 20px;\r\n}\r\nsmart-color-panel[right-to-left] .alpha-channel-scale:after {\r\n  background-image: linear-gradient(90deg, transparent, var(--smart-color-panel-alpha-channel-color));\r\n}\r\nsmart-color-panel[right-to-left] .buttons-container {\r\n  flex-direction: row-reverse;\r\n}\r\nsmart-color-panel[right-to-left] .buttons-container smart-button:last-of-type {\r\n  margin: 0 0 0 20px;\r\n}\r\n',""]);const s=i},1094:(e,t,r)=>{"use strict";r.d(t,{Z:()=>s});var n=r(8081),o=r.n(n),a=r(3645),i=r.n(a)()(o());i.push([e.id,'/* all elements */\r\nsmart-accordion,\r\nsmart-button,\r\nsmart-toggle-button,\r\nsmart-repeat-button,\r\nsmart-switch-button,\r\nsmart-slider,\r\nsmart-led,\r\nsmart-tank,\r\nsmart-check-box,\r\nsmart-calendar,\r\nsmart-carousel,\r\nsmart-card,\r\nsmart-radio-button,\r\nsmart-progress-bar,\r\nsmart-circular-progress-bar,\r\nsmart-scroll-bar,\r\nsmart-gauge,\r\nsmart-grid,\r\nsmart-numeric-text-box,\r\nsmart-list-box,\r\nsmart-combo-box,\r\nsmart-docking-layout,\r\nsmart-drop-down-list,\r\nsmart-drop-down-button,\r\nsmart-multi-split-button,\r\nsmart-power-button,\r\nsmart-text-box,\r\nsmart-multiline-text-box,\r\nsmart-password-text-box,\r\nsmart-masked-text-box,\r\nsmart-tabs,\r\nsmart-date-time-picker,\r\nsmart-array,\r\nsmart-time-picker,\r\nsmart-menu,\r\nsmart-list-menu,\r\nsmart-window,\r\nsmart-alert-window,\r\nsmart-prompt-window,\r\nsmart-multiline-prompt-window,\r\nsmart-progress-window,\r\nsmart-tabs-window,\r\nsmart-dialog-window,\r\nsmart-pager,\r\nsmart-progress-window,\r\nsmart-wait-window,\r\nsmart-splitter,\r\nsmart-tree,\r\nsmart-filter-panel,\r\nsmart-breadcrumb,\r\nsmart-color-panel,\r\nsmart-color-picker,\r\nsmart-sort-panel,\r\nsmart-group-panel,\r\nsmart-column-panel,\r\nsmart-multi-column-filter-panel,\r\nsmart-query-builder,\r\nsmart-card-view,\r\nsmart-tooltip,\r\nsmart-layout,\r\nsmart-path,\r\nsmart-kanban,\r\nsmart-gantt-chart,\r\nsmart-sheduler,\r\nsmart-pivot-panel {\r\n    padding: 0px;\r\n    margin: 0px;\r\n    overflow: hidden;\r\n    display: block;\r\n}\r\n\r\n.smart-element {\r\n    outline: none;\r\n    box-sizing: border-box;\r\n    font-family: var(--smart-font-family);\r\n    font-size: var(--smart-font-size);\r\n    font-weight: var(--smart-font-weight);\r\n    /* Apple iOS specific browser CSS variable used for area highlighting on click. Reference link for details:\r\n        https://developer.apple.com/library/content/documentation/AppleApplications/Reference/SafariWebContent/AdjustingtheTextSize/AdjustingtheTextSize.html#//apple_ref/doc/uid/TP40006510-SW5 */\r\n    -webkit-tap-highlight-color: transparent;\r\n    background: var(--smart-background);\r\n    color: var(--smart-background-color);\r\n}\r\n\r\n.smart-root {\r\n    width: 100%;\r\n    height: 100%;\r\n    padding: 0;\r\n    margin: 0;\r\n    box-sizing: border-box;\r\n}\r\n\r\nsmart-button[disabled],\r\nsmart-calendar[disabled],\r\nsmart-combo-box[disabled],\r\nsmart-chip[disabled],\r\nsmart-toggle-button[disabled],\r\nsmart-repeat-button[disabled],\r\nsmart-switch-button[disabled],\r\nsmart-slider[disabled],\r\nsmart-led[disabled],\r\nsmart-tank[disabled],\r\nsmart-check-box[disabled],\r\nsmart-radio-button[disabled],\r\nsmart-progress-bar[disabled],\r\nsmart-circular-progress-bar[disabled],\r\nsmart-gauge[disabled],\r\nsmart-grid[disabled],\r\nsmart-numeric-text-box[disabled],\r\nsmart-list-item[disabled],\r\nsmart-list-box[disabled],\r\nsmart-drop-down-list[disabled],\r\nsmart-drop-down-button[disabled],\r\nsmart-multi-split-button[disabled],\r\nsmart-scroll-bar[disabled],\r\nsmart-power-button[disabled],\r\nsmart-text-box[disabled],\r\nsmart-multiline-text-box[disabled],\r\nsmart-password-text-box[disabled],\r\nsmart-tab[disabled],\r\nsmart-tabs[disabled],\r\nsmart-time-picker[disabled],\r\nsmart-menu-item[disabled],\r\nsmart-menu-items-group[disabled],\r\nsmart-menu[disabled],\r\nsmart-list-menu[disabled],\r\nsmart-window[disabled],\r\nsmart-dialog-window[disabled],\r\nsmart-progress-window[disabled],\r\nsmart-wait-window[disabled],\r\nsmart-alert-window[disabled],\r\nsmart-prompt-window[disabled],\r\nsmart-card[disabled],\r\nsmart-multiline-prompt-window[disabled],\r\nsmart-splitter[disabled],\r\nsmart-tree-item[disabled]>.smart-tree-item-label-container,\r\nsmart-tree-items-group[disabled]>.smart-tree-item-label-container,\r\nsmart-tree[disabled],\r\nsmart-docking-layout[disabled],\r\nsmart-filter-panel[disabled],\r\nsmart-breadcrumb[disabled],\r\nsmart-pager[disabled],\r\nsmart-pager .smart-pager-button[disabled],\r\nsmart-color-panel[disabled],\r\nsmart-color-picker[disabled],\r\nsmart-input[disabled],\r\nsmart-check-input[disabled],\r\nsmart-number-input[disabled],\r\nsmart-multi-input[disabled],\r\nsmart-multi-combo-input[disabled],\r\nsmart-date-input[disabled],\r\nsmart-time-input[disabled],\r\nsmart-date-range-input[disabled],\r\nsmart-password-input[disabled],\r\nsmart-text-area[disabled],\r\nsmart-sort-panel[disabled],\r\nsmart-group-panel[disabled],\r\nsmart-column-panel[disabled],\r\nsmart-multi-column-filter-panel[disabled],\r\nsmart-card-view[disabled],\r\nsmart-query-builder[disabled],\r\nsmart-date-time-picker[disabled],\r\nsmart-layout[disabled],\r\nsmart-path[disabled],\r\nsmart-kanban[disabled],\r\nsmart-gantt[disabled],\r\nsmart-gantt-chart[disabled],\r\nsmart-scheduler[disabled],\r\nsmart-button-group[disabled],\r\nsmart-table[disabled],\r\nsmart-pivot-table[disabled],\r\nsmart-notification-panel[disabled],\r\nsmart-formatting-panel[disabled],\r\nsmart-color-input[disabled],\r\nsmart-editor[disabled] {\r\n    opacity: 0.55;\r\n    cursor: default;\r\n    pointer-events: none;\r\n    user-select: none;\r\n    -webkit-user-select: none;\r\n    -moz-user-select: none;\r\n    -ms-user-select: none;\r\n}\r\n\r\nsmart-accordion,\r\nsmart-calendar,\r\nsmart-card-view,\r\nsmart-button,\r\nsmart-color-panel,\r\nsmart-docking-layout,\r\nsmart-date-time-picker,\r\nsmart-gantt-chart,\r\nsmart-scheduler,\r\nsmart-grid,\r\nsmart-menu,\r\nsmart-list-menu,\r\nsmart-list-box,\r\nsmart-scroll-viewer,\r\nsmart-progress-bar,\r\nsmart-pager,\r\nsmart-splitter,\r\nsmart-tank,\r\nsmart-time-picker,\r\nsmart-tree,\r\nsmart-text-box,\r\nsmart-multiline-text-box,\r\nsmart-layout,\r\n.smart-window,\r\nsmart-kanban,\r\nsmart-sort-panel,\r\nsmart-button-group,\r\nsmart-group-panel,\r\nsmart-column-panel,\r\nsmart-multi-column-filter-panel,\r\nsmart-formatting-panel {\r\n    border-color: var(--smart-border);\r\n    border-top-left-radius: var(--smart-border-top-left-radius);\r\n    border-top-right-radius: var(--smart-border-top-right-radius);\r\n    border-bottom-left-radius: var(--smart-border-bottom-left-radius);\r\n    border-bottom-right-radius: var(--smart-border-bottom-right-radius);\r\n    border-width: var(--smart-border-width);\r\n    border-style: solid;\r\n}\r\n\r\nsmart-numeric-text-box.smart-element,\r\nsmart-masked-text-box.smart-element,\r\nsmart-multiline-text-box.smart-element,\r\nsmart-text-box.smart-element,\r\nsmart-drop-down-button.smart-element,\r\nsmart-drop-down-list.smart-element,\r\nsmart-combo-box.smart-element,\r\nsmart-password-text-box.smart-element,\r\nsmart-multi-split-button.smart-element,\r\nsmart-switch-button.smart-element,\r\nsmart-multiline-text-box.smart-element,\r\nsmart-date-time-picker.smart-element,\r\nsmart-pager.smart-element,\r\nsmart-menu.smart-element,\r\nsmart-menu.smart-element,\r\nsmart-numeric-text-box.smart-element,\r\nsmart-tabs.smart-element,\r\nsmart-tank.smart-element,\r\nsmart-slider.smart-element,\r\nsmart-filter-panel.smart-element,\r\nsmart-color-panel.smart-element,\r\nsmart-color-picker.smart-element,\r\nsmart-query-builder.smart-element,\r\nsmart-card-view.smart-element,\r\nsmart-path.smart-element,\r\nsmart-kanban.smart-element {\r\n    overflow: visible;\r\n}\r\n\r\n.smart-disabled {\r\n    opacity: 0.55;\r\n    cursor: default;\r\n    pointer-events: none;\r\n    user-select: none;\r\n    -webkit-user-select: none;\r\n    -moz-user-select: none;\r\n    -ms-user-select: none;\r\n}\r\n\r\n/*\r\n    Common code for Box Components with Content and Action buttons.\r\n*/\r\n.smart-element input::selection,\r\n.smart-input::selection {\r\n    background: var(--smart-editor-selection);\r\n    color: var(--smart-editor-selection-color);\r\n}\r\n\r\n/* Style for standard HTML scrollbars when dark theme is applied (limited browser support) */\r\n@media (hover: hover) {\r\n\r\n    body[theme="dark"],\r\n    .smart-element[theme="dark"] {\r\n        scrollbar-color: var(--smart-scroll-bar-thumb-background) var(--smart-scroll-bar-track-background);\r\n    }\r\n\r\n    body[theme="dark"]::-webkit-scrollbar,\r\n    body[theme="dark"] ::-webkit-scrollbar {\r\n        background-color: var(--smart-background);\r\n    }\r\n\r\n    body[theme="dark"]::-webkit-scrollbar-track,\r\n    body[theme="dark"] ::-webkit-scrollbar-track,\r\n    body[theme="dark"]::-webkit-scrollbar-track-piece,\r\n    body[theme="dark"] ::-webkit-scrollbar-track-piece {\r\n        background-color: var(--smart-scroll-bar-track-background);\r\n    }\r\n\r\n    body[theme="dark"]::-webkit-scrollbar-thumb,\r\n    body[theme="dark"] ::-webkit-scrollbar-thumb {\r\n        border: 1px solid var(--smart-scroll-bar-thumb-border);\r\n        background-color: var(--smart-scroll-bar-thumb-background);\r\n    }\r\n\r\n    body[theme="dark"]::-webkit-scrollbar-thumb:hover,\r\n    body[theme="dark"] ::-webkit-scrollbar-thumb:hover {\r\n        border-color: var(--smart-scroll-bar-thumb-border-hover);\r\n        background-color: var(--smart-scroll-bar-thumb-background-hover);\r\n    }\r\n\r\n    body[theme="dark"]::-webkit-scrollbar-button,\r\n    body[theme="dark"] ::-webkit-scrollbar-button {\r\n        background-color: var(--smart-scroll-bar-button-background);\r\n    }\r\n}',""]);const s=i},1338:(e,t,r)=>{"use strict";r.d(t,{Z:()=>s});var n=r(8081),o=r.n(n),a=r(3645),i=r.n(a)()(o());i.push([e.id,".smart-drop-down-box {\r\n  background: var(--smart-surface);\r\n  border-color: var(--smart-border);\r\n  border-top-left-radius: var(--smart-border-top-left-radius);\r\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\r\n  border-top-right-radius: var(--smart-border-top-right-radius);\r\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\r\n  overflow: initial;\r\n  font-family: var(--smart-font-family);\r\n  font-size: var(--smart-font-size);\r\n  outline: none;\r\n  height: var(--smart-editor-height); }\r\n  .smart-drop-down-box > .smart-container, .smart-drop-down-box.smart-container {\r\n    display: flex;\r\n    position: relative;\r\n    align-items: center; }\r\n    .smart-drop-down-box > .smart-container > .smart-content, .smart-drop-down-box.smart-container > .smart-content {\r\n      position: relative;\r\n      display: flex;\r\n      width: 100%;\r\n      height: 100%; }\r\n  .smart-drop-down-box .smart-buttons-container {\r\n    width: inherit;\r\n    height: inherit;\r\n    display: inherit;\r\n    flex-direction: inherit;\r\n    cursor: inherit;\r\n    position: inherit;\r\n    overflow: hidden;\r\n    min-height: inherit; }\r\n  .smart-drop-down-box .smart-action-button {\r\n    display: flex;\r\n    padding-left: var(--smart-editor-label-padding);\r\n    align-content: center;\r\n    outline: 1px solid transparent;\r\n    height: 100%;\r\n    width: calc(100% - var(--smart-editor-addon-width));\r\n    flex-wrap: wrap;\r\n    overflow: hidden;\r\n    position: relative;\r\n    border-style: solid;\r\n    border-color: var(--smart-border);\r\n    border-width: var(--smart-border-width);\r\n    align-items: center;\r\n    border-right: none;\r\n    border-top-left-radius: var(--smart-border-top-left-radius);\r\n    border-bottom-left-radius: var(--smart-border-bottom-left-radius);\r\n    user-select: none;\r\n    white-space: nowrap; }\r\n    .smart-drop-down-box .smart-action-button .smart-input {\r\n      color: inherit;\r\n      background: inherit;\r\n      border: none;\r\n      width: calc(100% - var(--smart-editor-addon-width));\r\n      height: 100%;\r\n      outline: none;\r\n      text-overflow: ellipsis; }\r\n      .smart-drop-down-box .smart-action-button .smart-input::placeholder {\r\n        color: inherit; }\r\n  .smart-drop-down-box .smart-drop-down-button {\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    width: var(--smart-editor-addon-width);\r\n    min-width: var(--smart-editor-addon-width);\r\n    color: inherit;\r\n    outline: 1px solid transparent;\r\n    overflow: hidden;\r\n    position: relative;\r\n    background-color: var(--smart-surface);\r\n    border-width: var(--smart-border-width);\r\n    border-style: solid;\r\n    border-color: var(--smart-border);\r\n    border-left: none;\r\n    color: var(--smart-surface-color);\r\n    border-top-right-radius: var(--smart-border-top-right-radius);\r\n    border-bottom-right-radius: var(--smart-border-bottom-right-radius);\r\n    cursor: pointer; }\r\n    .smart-drop-down-box .smart-drop-down-button .smart-drop-down-button-icon {\r\n      pointer-events: none;\r\n      width: 100%;\r\n      height: 100%;\r\n      display: flex;\r\n      justify-content: center;\r\n      align-items: center;\r\n      transform-origin: center;\r\n      font-family: var(--smart-font-family-icon); }\r\n      .smart-drop-down-box .smart-drop-down-button .smart-drop-down-button-icon:after {\r\n        content: var(--smart-icon-arrow-down);\r\n        font-size: var(--smart-arrow-size); }\r\n    .smart-drop-down-box .smart-drop-down-button[active] {\r\n      border-color: var(--smart-ui-state-border-active);\r\n      background-color: var(--smart-ui-state-active);\r\n      color: var(--smart-ui-state-color-active); }\r\n    .smart-drop-down-box .smart-drop-down-button[top] .smart-drop-down-button-icon:after, .smart-drop-down-box .smart-drop-down-button[center-top] .smart-drop-down-button-icon:after {\r\n      transform: rotate(180deg); }\r\n  .smart-drop-down-box .smart-drop-down {\r\n    font-family: var(--smart-font-family);\r\n    font-size: var(--smart-font-size); }\r\n    .smart-drop-down-box .smart-drop-down.smart-visibility-hidden {\r\n      transform: scale(0);\r\n      transition: transform 0.2s ease-in;\r\n      transform-origin: left top 0px; }\r\n  .smart-drop-down-box[drop-down-button-position=\"top\"] .smart-action-button, .smart-drop-down-box[drop-down-button-position=\"bottom\"] .smart-action-button {\r\n    min-height: var(--smart-editor-height);\r\n    padding-left: initial; }\r\n  .smart-drop-down-box[drop-down-button-position=\"top\"] .smart-drop-down-button,\r\n  .smart-drop-down-box[drop-down-button-position=\"top\"] .smart-action-button, .smart-drop-down-box[drop-down-button-position=\"bottom\"] .smart-drop-down-button,\r\n  .smart-drop-down-box[drop-down-button-position=\"bottom\"] .smart-action-button {\r\n    width: 100%;\r\n    border: var(--smart-border-width) solid var(--smart-border);\r\n    height: 50%;\r\n    justify-content: center; }\r\n  .smart-drop-down-box[drop-down-button-position=\"top\"] {\r\n    min-height: calc(2 * var(--smart-editor-height)); }\r\n    .smart-drop-down-box[drop-down-button-position=\"top\"] .smart-content {\r\n      flex-direction: column-reverse; }\r\n    .smart-drop-down-box[drop-down-button-position=\"top\"] .smart-drop-down-button {\r\n      border-bottom: initial;\r\n      border-top-left-radius: var(--smart-border-top-left-radius);\r\n      border-bottom-left-radius: 0;\r\n      border-top-right-radius: var(--smart-border-top-right-radius);\r\n      border-bottom-right-radius: 0; }\r\n    .smart-drop-down-box[drop-down-button-position=\"top\"] .smart-action-button {\r\n      border-top-left-radius: 0;\r\n      border-bottom-left-radius: var(--smart-border-bottom-left-radius);\r\n      border-top-right-radius: 0;\r\n      border-bottom-right-radius: var(--smart-border-bottom-right-radius); }\r\n    .smart-drop-down-box[drop-down-button-position=\"top\"]:not([drop-down-open-mode=\"dropDownButton\"]) .smart-action-button {\r\n      border-top: initial; }\r\n  .smart-drop-down-box[drop-down-button-position=\"bottom\"] {\r\n    min-height: calc(2 * var(--smart-editor-height)); }\r\n    .smart-drop-down-box[drop-down-button-position=\"bottom\"] .smart-content {\r\n      flex-direction: column; }\r\n    .smart-drop-down-box[drop-down-button-position=\"bottom\"] .smart-action-button {\r\n      border-bottom: initial;\r\n      border-top-left-radius: var(--smart-border-top-left-radius);\r\n      border-bottom-left-radius: 0;\r\n      border-top-right-radius: var(--smart-border-top-right-radius);\r\n      border-bottom-right-radius: 0; }\r\n    .smart-drop-down-box[drop-down-button-position=\"bottom\"] .smart-drop-down-button {\r\n      border-top-left-radius: 0;\r\n      border-bottom-left-radius: var(--smart-border-bottom-left-radius);\r\n      border-top-right-radius: 0;\r\n      border-bottom-right-radius: var(--smart-border-bottom-right-radius); }\r\n    .smart-drop-down-box[drop-down-button-position=\"bottom\"]:not([drop-down-open-mode=\"dropDownButton\"]) .smart-drop-down-button {\r\n      border-top: initial; }\r\n  .smart-drop-down-box[drop-down-button-position=\"left\"] > .smart-container > .smart-content, .smart-drop-down-box[drop-down-button-position=\"left\"].smart-container > .smart-content {\r\n    flex-direction: row-reverse; }\r\n  .smart-drop-down-box[drop-down-button-position=\"left\"] .smart-action-button {\r\n    padding-right: var(--smart-editor-label-padding);\r\n    border-right: var(--smart-border-width) solid var(--smart-border);\r\n    border-color: var(--smart-border);\r\n    border-top-left-radius: 0px;\r\n    border-bottom-left-radius: 0px;\r\n    border-top-right-radius: var(--smart-border-top-right-radius);\r\n    border-bottom-right-radius: var(--smart-border-bottom-right-radius);\r\n    padding-left: initial;\r\n    flex-direction: row-reverse; }\r\n  .smart-drop-down-box[drop-down-button-position=\"left\"] .smart-drop-down-button {\r\n    border-left: var(--smart-border-width) solid var(--smart-border);\r\n    border-color: var(--smart-border);\r\n    border-top-left-radius: var(--smart-border-top-left-radius);\r\n    border-bottom-left-radius: var(--smart-border-bottom-left-radius);\r\n    border-top-right-radius: 0px;\r\n    border-bottom-right-radius: 0px;\r\n    border-right: initial; }\r\n    .smart-drop-down-box[drop-down-button-position=\"left\"] .smart-drop-down-button[selected] {\r\n      border-right: initial; }\r\n  .smart-drop-down-box[drop-down-button-position=\"left\"]:not([drop-down-open-mode=\"dropDownButton\"]) .smart-action-button {\r\n    border-left: initial; }\r\n  .smart-drop-down-box[drop-down-button-position=\"right\"] .smart-action-button {\r\n    padding-left: var(--smart-editor-label-padding); }\r\n  .smart-drop-down-box[drop-down-button-position=\"none\"] .smart-action-button {\r\n    border-right: var(--smart-border-width) solid var(--smart-border);\r\n    border-top-right-radius: var(--smart-border-top-right-radius);\r\n    border-bottom-right-radius: var(--smart-border-bottom-right-radius);\r\n    width: 100%;\r\n    padding-right: var(--smart-editor-label-padding); }\r\n  .smart-drop-down-box[drop-down-button-position=\"none\"] .smart-drop-down-button {\r\n    display: none; }\r\n  .smart-drop-down-box:not([drop-down-open-mode=\"dropDownButton\"]) .smart-action-button {\r\n    border-color: var(--smart-border);\r\n    background-color: var(--smart-surface);\r\n    color: var(--smart-surface-color); }\r\n  .smart-drop-down-box[drop-down-open-mode=\"dropDownButton\"] .smart-action-button {\r\n    border-color: var(--smart-border);\r\n    background-color: var(--smart-background);\r\n    color: var(--smart-background-color); }\r\n    .smart-drop-down-box[drop-down-open-mode=\"dropDownButton\"] .smart-action-button[active] {\r\n      border-color: var(--smart-ui-state-border-active);\r\n      background-color: var(--smart-ui-state-active);\r\n      color: var(--smart-ui-state-color-active); }\r\n  .smart-drop-down-box[drop-down-open-mode=\"dropDownButton\"] .smart-drop-down-button {\r\n    border-color: var(--smart-border);\r\n    background-color: var(--smart-surface);\r\n    color: var(--smart-surface-color);\r\n    border-left-style: solid;\r\n    border-left-width: var(--smart-border-width); }\r\n  .smart-drop-down-box[drop-down-open-mode=\"dropDownButton\"][drop-down-button-position=\"left\"]:not([hover]) .smart-drop-down-button:focus {\r\n    border-color: var(--smart-outline);\r\n    box-shadow: var(--smart-border-width) 0 0 0 var(--smart-outline); }\r\n  .smart-drop-down-box[drop-down-open-mode=\"dropDownButton\"][drop-down-button-position=\"left\"]:not([hover]) .smart-action-button:focus {\r\n    border-color: var(--smart-outline);\r\n    box-shadow: calc(-1 * var(--smart-border-width)) 0 0 0 var(--smart-outline); }\r\n  .smart-drop-down-box[drop-down-open-mode=\"dropDownButton\"][drop-down-button-position=\"right\"]:not([hover]) .smart-action-button:focus {\r\n    box-shadow: var(--smart-border-width) 0 0 0 var(--smart-outline);\r\n    border-color: var(--smart-outline);\r\n    z-index: 1; }\r\n  .smart-drop-down-box[drop-down-open-mode=\"dropDownButton\"]:not([drop-down-button-position]):not([hover]) .smart-drop-down-button:focus {\r\n    border-color: var(--smart-outline); }\r\n  .smart-drop-down-box[drop-down-open-mode=\"dropDownButton\"]:not([drop-down-button-position]):not([hover]) .smart-action-button:focus {\r\n    box-shadow: var(--smart-border-width) 0 0 0 var(--smart-outline);\r\n    border-color: var(--smart-outline);\r\n    z-index: 1; }\r\n  .smart-drop-down-box[resizing] {\r\n    user-select: none;\r\n    touch-action: none; }\r\n  .smart-drop-down-box[readonly] input {\r\n    user-select: none;\r\n    -moz-user-select: none;\r\n    -webkit-user-select: none; }\r\n  .smart-drop-down-box[hover] .smart-drop-down-button {\r\n    border-color: var(--smart-ui-state-border-hover);\r\n    background-color: var(--smart-ui-state-hover);\r\n    color: var(--smart-ui-state-color-hover); }\r\n  .smart-drop-down-box[hover]:not([drop-down-open-mode=\"dropDownButton\"]) .smart-action-button {\r\n    border-color: var(--smart-ui-state-border-hover);\r\n    background-color: var(--smart-ui-state-hover);\r\n    color: var(--smart-ui-state-color-hover); }\r\n  .smart-drop-down-box[focus]:not([opened]) .smart-action-button[focus],\r\n  .smart-drop-down-box[focus]:not([opened]) .smart-drop-down-button[focus],\r\n  .smart-drop-down-box[focus]:not([opened]) .smart-action-button,\r\n  .smart-drop-down-box[focus]:not([opened]) .smart-drop-down-button {\r\n    outline: initial;\r\n    border-color: var(--smart-outline); }\r\n  .smart-drop-down-box[active] .smart-action-button, .smart-drop-down-box[active][focus][drop-down-open-mode=\"dropDownButton\"] .smart-action-button, .smart-drop-down-box[active][focus][drop-down-open-mode=\"dropDownButton\"] .smart-drop-down-button, .smart-drop-down-box[active][drop-down-open-mode=\"dropDownButton\"] .smart-drop-down-button:focus {\r\n    border-color: var(--smart-ui-state-border-active);\r\n    background-color: var(--smart-ui-state-active);\r\n    color: var(--smart-ui-state-color-active); }\r\n  .smart-drop-down-box[opened] .smart-drop-down-button .smart-drop-down-button-icon:after {\r\n    transform: rotate(180deg); }\r\n  .smart-drop-down-box[opened] .smart-drop-down-button[bottom] .smart-drop-down-button-icon:after, .smart-drop-down-box[opened] .smart-drop-down-button[center-bottom] .smart-drop-down-button-icon:after {\r\n    transform: rotate(180deg); }\r\n  .smart-drop-down-box[opened] .smart-drop-down-button[top] .smart-drop-down-button-icon:after, .smart-drop-down-box[opened] .smart-drop-down-button[center-top] .smart-drop-down-button-icon:after {\r\n    transform: rotate(0deg); }\r\n  .smart-drop-down-box[opened]:not([drop-down-open-mode=\"dropDownButton\"]):not(.outlined):not(.underlined) .smart-action-button, .smart-drop-down-box[opened]:not(.outlined):not(.underlined) .smart-drop-down-button {\r\n    border-color: var(--smart-ui-state-active);\r\n    background-color: var(--smart-ui-state-active);\r\n    color: var(--smart-ui-state-color-active); }\r\n  .smart-drop-down-box.auto-height {\r\n    height: auto;\r\n    min-height: var(--smart-editor-height); }\r\n    .smart-drop-down-box.auto-height > .smart-container, .smart-drop-down-box.auto-height.smart-container {\r\n      min-height: inherit; }\r\n    .smart-drop-down-box.auto-height .smart-action-button,\r\n    .smart-drop-down-box.auto-height .smart-content {\r\n      min-height: inherit; }\r\n    .smart-drop-down-box.auto-height .smart-action-button {\r\n      padding: 3px; }\r\n    .smart-drop-down-box.auto-height[label], .smart-drop-down-box.auto-height[hint] {\r\n      height: auto; }\r\n  .smart-drop-down-box[label][hint] > .smart-container {\r\n    display: flex;\r\n    position: relative;\r\n    align-items: center; }\r\n  .smart-drop-down-box[label] > .smart-container {\r\n    align-items: flex-end; }\r\n  .smart-drop-down-box[hint] > .smart-container {\r\n    align-items: flex-start; }\r\n  .smart-drop-down-box[hint] .smart-hint {\r\n    opacity: 0;\r\n    transition: opacity 0.2s cubic-bezier(0.4, 0, 0.6, 1);\r\n    top: 100%;\r\n    bottom: initial; }\r\n  .smart-drop-down-box[hint][focus] .smart-hint {\r\n    opacity: 1;\r\n    transition: opacity 0.2s cubic-bezier(0.4, 0, 0.2, 1); }\r\n  .smart-drop-down-box[label] .smart-label, .smart-drop-down-box[hint] .smart-hint {\r\n    position: absolute;\r\n    left: 0;\r\n    bottom: 100%;\r\n    font-size: 12px;\r\n    width: 100%;\r\n    display: block;\r\n    padding: var(--smart-editor-label-padding);\r\n    pointer-events: none;\r\n    user-select: none;\r\n    -webkit-user-select: none;\r\n    -ms-user-select: none;\r\n    -moz-user-select: none;\r\n    text-align: initial;\r\n    line-height: initial;\r\n    vertical-align: initial; }\r\n  .smart-drop-down-box[disabled] > .smart-container {\r\n    cursor: default;\r\n    background-color: initial; }\r\n  .smart-drop-down-box[disabled] .smart-drop-down-button {\r\n    cursor: default;\r\n    background-color: initial; }\r\n  .smart-drop-down-box[disabled][selection-display-mode=\"tokens\"] .smart-action-button > span {\r\n    cursor: default; }\r\n  .smart-drop-down-box.underlined {\r\n    background-color: transparent;\r\n    border-width: 0px;\r\n    border-bottom-width: 1px;\r\n    background: var(--smart-background);\r\n    border-bottom-color: var(--smart-border); }\r\n    .smart-drop-down-box.underlined .smart-action-button {\r\n      border-top-color: transparent;\r\n      border-left-color: transparent;\r\n      border-right-color: transparent;\r\n      border-bottom-left-radius: 0;\r\n      background-color: transparent;\r\n      color: var(--smart-background-color); }\r\n      .smart-drop-down-box.underlined .smart-action-button input {\r\n        border-color: transparent !important; }\r\n      .smart-drop-down-box.underlined .smart-action-button[active] {\r\n        background-color: var(--smart-ui-state-active);\r\n        color: var(--smart-ui-state-color-active); }\r\n    .smart-drop-down-box.underlined .smart-spin-button {\r\n      background: var(--smart-background);\r\n      border-width: 0px; }\r\n      .smart-drop-down-box.underlined .smart-spin-button[hover] {\r\n        background: var(--smart-background);\r\n        color: var(--smart-ui-state-active); }\r\n      .smart-drop-down-box.underlined .smart-spin-button[active] {\r\n        background: var(--smart-background);\r\n        color: var(--smart-ui-state-active); }\r\n    .smart-drop-down-box.underlined .smart-drop-down-button {\r\n      background: var(--smart-background);\r\n      border-width: 0px;\r\n      border-bottom: 1px solid var(--smart-border) !important;\r\n      border-top-color: transparent;\r\n      border-left-color: transparent;\r\n      border-right-color: transparent; }\r\n      .smart-drop-down-box.underlined .smart-drop-down-button[hover] {\r\n        background: var(--smart-background);\r\n        color: var(--smart-ui-state-active); }\r\n      .smart-drop-down-box.underlined .smart-drop-down-button[active] {\r\n        background-color: var(--smart-ui-state-active);\r\n        color: var(--smart-ui-state-color-active); }\r\n    .smart-drop-down-box.underlined .smart-hint {\r\n      position: absolute;\r\n      top: 0;\r\n      left: 0;\r\n      right: 0;\r\n      bottom: 0;\r\n      display: block !important;\r\n      box-sizing: border-box;\r\n      padding: var(--smart-editor-label-padding);\r\n      color: var(--smart-background-color);\r\n      pointer-events: none;\r\n      font-size: 75%;\r\n      opacity: 0;\r\n      transition: color 0.2s, opacity 0.1s, font-size 0.2s, line-height 0.2s, margin-top 0.2s, top 0.2s;\r\n      margin-top: calc(0px - var(--smart-font-size)); }\r\n      .smart-drop-down-box.underlined .smart-hint:after {\r\n        content: \"\";\r\n        position: absolute;\r\n        left: 0;\r\n        bottom: -2px;\r\n        display: block;\r\n        width: 100%;\r\n        height: 2px;\r\n        background-color: var(--smart-primary);\r\n        transform-origin: bottom center;\r\n        transform: scaleX(0);\r\n        transition: transform 0.2s; }\r\n    .smart-drop-down-box.underlined:not([focus]) .smart-hint {\r\n      margin-top: 0px; }\r\n    .smart-drop-down-box.underlined[focus] input {\r\n      border-color: transparent !important; }\r\n    .smart-drop-down-box.underlined[focus] .smart-action-button {\r\n      border-color: transparent !important; }\r\n    .smart-drop-down-box.underlined[focus] .smart-drop-down-button,\r\n    .smart-drop-down-box.underlined[focus] .smart-hint {\r\n      color: var(--smart-primary) !important;\r\n      opacity: 1;\r\n      border-color: transparent !important; }\r\n    .smart-drop-down-box.underlined[focus] .smart-hint:after {\r\n      transform: scale(1); }\r\n    .smart-drop-down-box.underlined[opened] .smart-action-button {\r\n      border-top-color: transparent;\r\n      border-left-color: transparent;\r\n      border-right-color: transparent;\r\n      border-bottom-left-radius: 0;\r\n      background-color: transparent;\r\n      color: var(--smart-background-color); }\r\n    .smart-drop-down-box.underlined:not([opened]):not([hover]) .smart-drop-down-button {\r\n      background-color: transparent;\r\n      color: var(--smart-background-color); }\r\n      .smart-drop-down-box.underlined:not([opened]):not([hover]) .smart-drop-down-button:not([hover]) {\r\n        border-bottom-left-radius: 0; }\r\n      .smart-drop-down-box.underlined:not([opened]):not([hover]) .smart-drop-down-button:not([active]):not([hover]) {\r\n        border-radius: initial; }\r\n    .smart-drop-down-box.underlined:not([opened]) .smart-action-button:not([active]):not([hover]) {\r\n      border-radius: initial; }\r\n    .smart-drop-down-box.underlined[hover]:not([drop-down-open-mode=\"dropDownButton\"]):not([opened]) .smart-action-button {\r\n      border-bottom-left-radius: 0; }\r\n      .smart-drop-down-box.underlined[hover]:not([drop-down-open-mode=\"dropDownButton\"]):not([opened]) .smart-action-button:not([active]) {\r\n        background-color: transparent; }\r\n    .smart-drop-down-box.underlined[hover]:not([opened]) .smart-action-button, .smart-drop-down-box.underlined[hover]:not([opened]):not([drop-down-open-mode=\"dropDownButton\"]) .smart-action-button:not([active]) {\r\n      border-top-color: transparent;\r\n      border-left-color: transparent;\r\n      border-right-color: transparent; }\r\n    .smart-drop-down-box.underlined[drop-down-open-mode=\"dropDownButton\"]:not([drop-down-button-position=\"left\"]):not([drop-down-button-position=\"top\"]):not([drop-down-button-position=\"bottom\"]):not([hover]) .smart-action-button:focus {\r\n      box-shadow: none;\r\n      z-index: initial; }\r\n    .smart-drop-down-box.underlined[drop-down-open-mode=\"dropDownButton\"][drop-down-button-position=\"left\"]:not([hover]) .smart-drop-down-button:focus {\r\n      box-shadow: none; }\r\n    .smart-drop-down-box.underlined[drop-down-open-mode=\"dropDownButton\"][hover]:not([opened]) .smart-action-button[hover] {\r\n      border-top-color: transparent;\r\n      border-left-color: transparent;\r\n      border-right-color: transparent; }\r\n    .smart-drop-down-box.underlined.smart-invalid .smart-drop-down-button {\r\n      border-bottom-color: rgba(var(--smart-error-rgb), 0.5) !important; }\r\n  .smart-drop-down-box.outlined {\r\n    background-color: transparent;\r\n    padding-top: 6px;\r\n    height: auto;\r\n    min-height: 0;\r\n    border: none;\r\n    background: transparent; }\r\n    .smart-drop-down-box.outlined > .smart-container > .smart-content {\r\n      padding: 4px 3px 4px;\r\n      border: 1px solid var(--smart-border);\r\n      height: auto;\r\n      background: var(--smart-background);\r\n      border-radius: var(--smart-border-radius);\r\n      z-index: 5; }\r\n    .smart-drop-down-box.outlined .smart-action-button {\r\n      border: none;\r\n      background: var(--smart-background) !important;\r\n      border-color: var(--smart-border) !important;\r\n      color: var(--smart-background-color) !important; }\r\n      .smart-drop-down-box.outlined .smart-action-button input {\r\n        padding: 0;\r\n        border: none !important;\r\n        z-index: initial; }\r\n    .smart-drop-down-box.outlined .smart-spin-button {\r\n      background: var(--smart-background);\r\n      border-width: 0px; }\r\n      .smart-drop-down-box.outlined .smart-spin-button[hover] {\r\n        background: var(--smart-background);\r\n        color: var(--smart-ui-state-active); }\r\n      .smart-drop-down-box.outlined .smart-spin-button[active] {\r\n        background: var(--smart-background);\r\n        color: var(--smart-ui-state-active); }\r\n    .smart-drop-down-box.outlined .smart-drop-down-button {\r\n      background: var(--smart-background);\r\n      border-width: 0px;\r\n      padding: 8px 0px;\r\n      background: var(--smart-background) !important;\r\n      border-color: var(--smart-border) !important;\r\n      color: var(--smart-background-color) !important; }\r\n      .smart-drop-down-box.outlined .smart-drop-down-button.smart-calendar-button[hover] {\r\n        background: var(--smart-background);\r\n        color: var(--smart-ui-state-active); }\r\n      .smart-drop-down-box.outlined .smart-drop-down-button.smart-calendar-button[active] {\r\n        background: var(--smart-background);\r\n        color: var(--smart-ui-state-active); }\r\n    .smart-drop-down-box.outlined.smart-element-init .smart-hint {\r\n      visibility: hidden;\r\n      display: none !important; }\r\n    .smart-drop-down-box.outlined:not([focus])[hint] .smart-hint {\r\n      font-size: var(--smart-font-size);\r\n      line-height: 48px;\r\n      opacity: 0; }\r\n    .smart-drop-down-box.outlined[hint] .smart-hint {\r\n      position: absolute;\r\n      top: 0;\r\n      left: 0;\r\n      display: flex !important;\r\n      border-color: var(--smart-border) !important;\r\n      width: 100%;\r\n      max-height: 100%;\r\n      color: var(--smart-background-color);\r\n      font-size: 75%;\r\n      line-height: 15px;\r\n      cursor: text;\r\n      margin-top: -6px;\r\n      z-index: 10;\r\n      padding: 0;\r\n      transition: color 0.2s, font-size 0.2s, opacity 0.1s, font-size 0.2s, line-height 0.2s; }\r\n      .smart-drop-down-box.outlined[hint] .smart-hint:before, .smart-drop-down-box.outlined[hint] .smart-hint:after {\r\n        content: \"\";\r\n        display: block;\r\n        box-sizing: border-box;\r\n        margin-top: 6px;\r\n        border-top: solid 1px;\r\n        border-top-color: var(--smart-border) !important;\r\n        min-width: 10px;\r\n        height: 8px;\r\n        pointer-events: none;\r\n        box-shadow: inset 0 1px transparent;\r\n        transition: border-color 0.2s, box-shadow 0.2s; }\r\n      .smart-drop-down-box.outlined[hint] .smart-hint:before {\r\n        margin-right: 4px;\r\n        border-left: solid 1px transparent;\r\n        border-radius: 4px 0; }\r\n      .smart-drop-down-box.outlined[hint] .smart-hint:after {\r\n        flex-grow: 1;\r\n        margin-left: 4px;\r\n        border-right: solid 1px transparent;\r\n        border-radius: 0 4px; }\r\n    .smart-drop-down-box.outlined[focus] {\r\n      background-color: transparent; }\r\n      .smart-drop-down-box.outlined[focus] > .smart-container > .smart-content {\r\n        border-color: var(--smart-primary); }\r\n      .smart-drop-down-box.outlined[focus] .smart-drop-down-button {\r\n        color: var(--smart-ui-state-active) !important; }\r\n    .smart-drop-down-box.outlined[focus][hint] > .smart-container > .smart-content {\r\n      border-top-color: transparent !important; }\r\n    .smart-drop-down-box.outlined[focus][hint] .smart-hint {\r\n      color: var(--smart-primary);\r\n      opacity: 1; }\r\n      .smart-drop-down-box.outlined[focus][hint] .smart-hint:before, .smart-drop-down-box.outlined[focus][hint] .smart-hint:after {\r\n        border-top-color: var(--smart-primary) !important; }\r\n    .smart-drop-down-box.outlined[hover]:not([opened]):not([drop-down-open-mode=\"dropDownButton\"]) .smart-action-button:not([active]) {\r\n      background-color: transparent; }\r\n    .smart-drop-down-box.outlined:not([opened]) .smart-action-button:not([active]),\r\n    .smart-drop-down-box.outlined:not([opened]) .smart-drop-down-button {\r\n      background-color: transparent; }\r\n    .smart-drop-down-box.outlined[drop-down-open-mode=\"dropDownButton\"]:not([hover]) .smart-action-button:not([active]) {\r\n      background-color: transparent; }\r\n    .smart-drop-down-box.outlined.smart-invalid > .smart-container > .smart-content {\r\n      border-color: rgba(var(--smart-error-rgb), 0.5); }\r\n  .smart-drop-down-box[placeholder=\"\"][dropDownButtonPosition=\"none\"] .smart-drop-down-button, .smart-drop-down-box:not([placeholder])[dropDownButtonPosition=\"none\"] .smart-drop-down-button {\r\n    border-left-width: var(--smart-border-width);\r\n    border-left-style: solid;\r\n    border-top-left-radius: 0px;\r\n    border-bottom-left-radius: 0px;\r\n    border-top-right-radius: var(--smart-border-top-right-radius);\r\n    border-bottom-right-radius: var(--smart-border-bottom-right-radius); }\r\n  .smart-drop-down-box[placeholder=\"\"]:not([opened])[dropDownButtonPosition=\"none\"] .smart-drop-down-button:not([focus]), .smart-drop-down-box:not([placeholder]):not([opened])[dropDownButtonPosition=\"none\"] .smart-drop-down-button:not([focus]) {\r\n    border-color: var(--smart-border); }\r\n  .smart-drop-down-box:not([animation='none']) .smart-drop-down-button .smart-drop-down-button-icon:after {\r\n    transition: transform 0.2s; }\r\n  .smart-drop-down-box[drop-down-position=\"overlay-center\"] .smart-drop-down-button .smart-drop-down-button-icon:after {\r\n    content: var(--smart-icon-minus); }\r\n  .smart-drop-down-box.smart-invalid:not([drop-down-open-mode=\"dropDownButton\"]) .smart-action-button {\r\n    border-bottom-color: rgba(var(--smart-error-rgb), 0.5) !important; }\r\n  .smart-drop-down-box[right-to-left] {\r\n    direction: rtl; }\r\n    .smart-drop-down-box[right-to-left] .smart-label,\r\n    .smart-drop-down-box[right-to-left] .smart-hint {\r\n      direction: rtl; }\r\n    .smart-drop-down-box[right-to-left] .smart-drop-down-button:focus {\r\n      border-color: var(--smart-outline); }\r\n    .smart-drop-down-box[right-to-left]:not([hover]) .smart-action-button[focus],\r\n    .smart-drop-down-box[right-to-left]:not([hover]) .smart-drop-down-button[focus] {\r\n      border-color: var(--smart-outline); }\r\n    .smart-drop-down-box[right-to-left][drop-down-button-position=\"left\"] .smart-action-button {\r\n      flex-direction: row; }\r\n    .smart-drop-down-box[right-to-left][drop-down-button-position=\"right\"] > .smart-container > .smart-content {\r\n      flex-direction: row-reverse; }\r\n    .smart-drop-down-box[right-to-left][drop-down-button-position=\"left\"] .smart-action-button, .smart-drop-down-box[right-to-left]:not([drop-down-button-position]) .smart-action-button {\r\n      padding: 0 var(--smart-editor-label-padding) 0 0;\r\n      border-right: var(--smart-border-width) solid var(--smart-border);\r\n      border-top-left-radius: initial;\r\n      border-top-right-radius: var(--smart-border-top-right-radius);\r\n      border-bottom-left-radius: initial;\r\n      border-bottom-right-radius: var(--smart-border-bottom-right-radius); }\r\n    .smart-drop-down-box[right-to-left][drop-down-button-position=\"left\"] .smart-drop-down-button, .smart-drop-down-box[right-to-left]:not([drop-down-button-position]) .smart-drop-down-button {\r\n      border-left: var(--smart-border-width) solid var(--smart-border);\r\n      border-top-right-radius: initial;\r\n      border-bottom-right-radius: initial;\r\n      border-top-left-radius: var(--smart-border-top-left-radius);\r\n      border-bottom-left-radius: var(--smart-border-bottom-left-radius); }\r\n    .smart-drop-down-box[right-to-left][drop-down-button-position=\"left\"] > .smart-container > .smart-content, .smart-drop-down-box[right-to-left]:not([drop-down-button-position]) > .smart-container > .smart-content {\r\n      flex-direction: row; }\r\n    .smart-drop-down-box[right-to-left]:not([drop-down-open-mode=\"dropDownButton\"])[drop-down-button-position=\"left\"] .smart-action-button, .smart-drop-down-box[right-to-left]:not([drop-down-button-position]) .smart-action-button {\r\n      border-left: initial; }\r\n    .smart-drop-down-box[right-to-left]:not([drop-down-open-mode=\"dropDownButton\"]):not([drop-down-button-position]) .smart-drop-down-button, .smart-drop-down-box[right-to-left][drop-down-button-position=\"left\"] .smart-drop-down-button {\r\n      border-right: initial; }\r\n    .smart-drop-down-box[right-to-left][opened] .smart-drop-down-button,\r\n    .smart-drop-down-box[right-to-left][opened] .smart-action-button {\r\n      border-color: var(--smart-border-active); }\r\n    .smart-drop-down-box[right-to-left][drop-down-open-mode=\"dropDownButton\"][drop-down-button-position=\"right\"]:not([hover]) .smart-action-button:focus, .smart-drop-down-box[right-to-left][drop-down-open-mode=\"dropDownButton\"]:not([drop-down-button-position]):not([hover]) .smart-action-button:focus {\r\n      box-shadow: calc(-1 * var(--smart-border-width)) 0 0 0 var(--smart-outline); }\r\n\r\n.smart-drop-down.smart-drop-down-container {\r\n  box-shadow: var(--smart-elevation-8);\r\n  border-color: var(--smart-border);\r\n  font-size: var(--smart-font-size);\r\n  font-family: var(--smart-font-family);\r\n  background-color: var(--smart-background);\r\n  box-sizing: border-box;\r\n  outline: none;\r\n  border-width: var(--smart-border-width);\r\n  border-style: solid;\r\n  border-color: var(--smart-border);\r\n  display: flex;\r\n  flex-direction: column;\r\n  height: var(--smart-editor-drop-down-height);\r\n  max-height: var(--smart-editor-drop-down-max-height);\r\n  min-height: var(--smart-editor-drop-down-min-height);\r\n  width: var(--smart-editor-drop-down-width);\r\n  max-width: var(--smart-editor-drop-down-max-width);\r\n  min-width: var(--smart-editor-drop-down-min-width);\r\n  font-size: var(--smart-font-size);\r\n  font-family: var(--smart-font-family);\r\n  margin: calc(var(--smart-editor-drop-down-vertical-offset) + var(--smart-editor-drop-down-padding-size)) 0px;\r\n  padding: var(--smart-editor-drop-down-padding-size) 0 var(--smart-editor-drop-down-padding-size) 0 !important; }\r\n  .smart-drop-down.smart-drop-down-container smart-list-box:focus {\r\n    border-color: var(--smart-outline); }\r\n  .smart-drop-down.smart-drop-down-container .smart-drop-down-resize-bar {\r\n    position: relative;\r\n    width: 100%;\r\n    margin-top: 2.5px;\r\n    height: calc(var(--smart-editor-drop-down-resize-bar-height) - 2.5px);\r\n    touch-action: none; }\r\n  .smart-drop-down.smart-drop-down-container.smart-visibility-hidden {\r\n    transform: scale(0); }\r\n  .smart-drop-down.smart-drop-down-container.smart-drop-down-repositioned.smart-visibility-hidden {\r\n    top: 0;\r\n    left: 0; }\r\n  .smart-drop-down.smart-drop-down-container.smart-visibility-hidden.not-in-view {\r\n    left: -9999px;\r\n    top: -9999px;\r\n    transition: none; }\r\n  .smart-drop-down.smart-drop-down-container.smart-drop-down-repositioned {\r\n    background-color: var(--smart-background);\r\n    box-sizing: border-box;\r\n    outline: none;\r\n    border-width: var(--smart-border-width);\r\n    border-style: solid;\r\n    border-color: var(--smart-border);\r\n    display: flex;\r\n    flex-direction: column;\r\n    height: var(--smart-editor-drop-down-height);\r\n    max-height: var(--smart-editor-drop-down-max-height);\r\n    min-height: var(--smart-editor-drop-down-min-height);\r\n    width: var(--smart-editor-drop-down-width);\r\n    max-width: var(--smart-editor-drop-down-max-width);\r\n    min-width: var(--smart-editor-drop-down-min-width);\r\n    font-size: var(--smart-font-size);\r\n    font-family: var(--smart-font-family);\r\n    margin: calc(var(--smart-editor-drop-down-vertical-offset) + var(--smart-editor-drop-down-padding-size)) 0px;\r\n    padding: var(--smart-editor-drop-down-padding-size) 0 var(--smart-editor-drop-down-padding-size) 0 !important; }\r\n    .smart-drop-down.smart-drop-down-container.smart-drop-down-repositioned.smart-visibility-hidden.not-in-view {\r\n      left: -9999px;\r\n      top: -9999px;\r\n      transition: none; }\r\n    .smart-drop-down.smart-drop-down-container.smart-drop-down-repositioned[top], .smart-drop-down.smart-drop-down-container.smart-drop-down-repositioned[center-top] {\r\n      margin: calc(-1 * (var(--smart-editor-drop-down-vertical-offset) + 3px)) 0px; }\r\n.smart-drop-down.smart-date-time-drop-down {\r\n  width: var(--smart-editor-drop-down-width);\r\n  height: var(--smart-editor-drop-down-height); }\r\n  .smart-drop-down.smart-date-time-drop-down.smart-drop-down-repositioned {\r\n    width: var(--smart-editor-drop-down-width);\r\n    height: var(--smart-editor-drop-down-height);\r\n    padding: initial !important;\r\n    background-color: var(--smart-background);\r\n    box-sizing: border-box;\r\n    outline: none;\r\n    border-width: var(--smart-border-width);\r\n    border-style: solid;\r\n    border-color: var(--smart-border);\r\n    display: flex;\r\n    flex-direction: column;\r\n    height: var(--smart-editor-drop-down-height);\r\n    max-height: var(--smart-editor-drop-down-max-height);\r\n    min-height: var(--smart-editor-drop-down-min-height);\r\n    width: var(--smart-editor-drop-down-width);\r\n    max-width: var(--smart-editor-drop-down-max-width);\r\n    min-width: var(--smart-editor-drop-down-min-width);\r\n    font-size: var(--smart-font-size);\r\n    font-family: var(--smart-font-family);\r\n    margin: calc(var(--smart-editor-drop-down-vertical-offset) + var(--smart-editor-drop-down-padding-size)) 0px;\r\n    padding: var(--smart-editor-drop-down-padding-size) 0 var(--smart-editor-drop-down-padding-size) 0 !important; }\r\n  .smart-drop-down.smart-date-time-drop-down[drop-down-display-mode=\"calendar\"] {\r\n    height: calc(var(--smart-editor-drop-down-height) - var(--smart-calendar-title-height)) !important; }\r\n.smart-drop-down.smart-drop-down-color-picker.smart-drop-down-repositioned {\r\n  max-height: calc(var(--smart-editor-drop-down-max-height) + 50px); }\r\n.smart-drop-down[top] .smart-drop-down-resize-bar {\r\n  margin-top: 0;\r\n  margin-bottom: 2.5px; }\r\n.smart-drop-down[top].smart-drop-down-container.smart-drop-down-repositioned, .smart-drop-down[top].smart-drop-down-container.smart-drop-down-repositioned.smart-visibility-hidden {\r\n  top: initial;\r\n  bottom: calc(100% - var(--smart-border-width));\r\n  flex-direction: column-reverse; }\r\n.smart-drop-down[overlay-bottom], .smart-drop-down[overlay-center], .smart-drop-down[overlay-top] {\r\n  margin: unset; }\r\n.smart-drop-down:not([resize-mode='none']) smart-list-box {\r\n  position: relative;\r\n  width: 100%;\r\n  height: calc(100% - var(--smart-editor-drop-down-resize-bar-height));\r\n  border: none; }\r\n.smart-drop-down:not([resize-mode='none']) .smart-drop-down-resize-bar {\r\n  border-top: 1px solid var(--smart-border); }\r\n.smart-drop-down:not([resize-mode='none'])[top] .smart-drop-down-resize-bar {\r\n  border-top: initial;\r\n  border-bottom: 1px solid var(--smart-border); }\r\n.smart-drop-down[resize-mode][top] .smart-drop-down-resize-bar > div {\r\n  top: calc(50% - 1px);\r\n  /* Including the BorderBottom */ }\r\n.smart-drop-down[resize-mode='none'] smart-list-box {\r\n  width: 100%;\r\n  height: 100%;\r\n  position: relative;\r\n  border: none; }\r\n.smart-drop-down[resize-mode='none'] .smart-drop-down-resize-bar {\r\n  display: none;\r\n  cursor: default; }\r\n  .smart-drop-down[resize-mode='none'] .smart-drop-down-resize-bar > div {\r\n    display: none; }\r\n.smart-drop-down[resize-mode=\"vertical\"] .smart-drop-down-resize-bar > div, .smart-drop-down[resize-mode=\"both\"] .smart-drop-down-resize-bar > div {\r\n  display: initial;\r\n  position: absolute;\r\n  width: 5px;\r\n  height: 5px;\r\n  left: 50%;\r\n  /*top: 50%;*/\r\n  top: calc(50% + 1px);\r\n  /* Including the BorderTop */\r\n  transform: translate(-50%, -50%);\r\n  border: 1px solid var(--smart-border);\r\n  border-radius: 50%;\r\n  pointer-events: none; }\r\n  .smart-drop-down[resize-mode=\"vertical\"] .smart-drop-down-resize-bar > div:after, .smart-drop-down[resize-mode=\"vertical\"] .smart-drop-down-resize-bar > div:before, .smart-drop-down[resize-mode=\"both\"] .smart-drop-down-resize-bar > div:after, .smart-drop-down[resize-mode=\"both\"] .smart-drop-down-resize-bar > div:before {\r\n    position: absolute;\r\n    top: 50%;\r\n    transform: translate(-50%, -50%);\r\n    content: '';\r\n    width: 100%;\r\n    height: 100%;\r\n    border: 1px solid var(--smart-border);\r\n    border-radius: 50%;\r\n    pointer-events: none; }\r\n  .smart-drop-down[resize-mode=\"vertical\"] .smart-drop-down-resize-bar > div:after, .smart-drop-down[resize-mode=\"both\"] .smart-drop-down-resize-bar > div:after {\r\n    left: 500%; }\r\n  .smart-drop-down[resize-mode=\"vertical\"] .smart-drop-down-resize-bar > div:before, .smart-drop-down[resize-mode=\"both\"] .smart-drop-down-resize-bar > div:before {\r\n    left: -400%; }\r\n.smart-drop-down[resize-mode=\"vertical\"].smart-drop-down-container.smart-drop-down-repositioned .smart-drop-down-resize-bar > div, .smart-drop-down[resize-mode=\"both\"].smart-drop-down-container.smart-drop-down-repositioned .smart-drop-down-resize-bar > div {\r\n  width: 3px;\r\n  height: 3px; }\r\n.smart-drop-down[resize-mode=\"horizontal\"][resize-indicator] .smart-drop-down-resize-bar:before, .smart-drop-down[resize-mode=\"both\"][resize-indicator] .smart-drop-down-resize-bar:before {\r\n  width: 8px;\r\n  height: 5px;\r\n  font-family: var(--smart-font-family-icon);\r\n  content: var(--smart-icon-resize-horizontal);\r\n  position: absolute;\r\n  top: calc(100% - 8px);\r\n  left: calc(100% - 8px);\r\n  transform: rotate(-45deg);\r\n  font-size: 10px;\r\n  cursor: se-resize; }\r\n.smart-drop-down[resize-mode=\"horizontal\"][resize-indicator] .smart-drop-down-resize-bar:after, .smart-drop-down[resize-mode=\"both\"][resize-indicator] .smart-drop-down-resize-bar:after {\r\n  width: 8px;\r\n  height: 12px;\r\n  font-family: var(--smart-font-family-icon);\r\n  content: var(--smart-icon-resize-full);\r\n  position: absolute;\r\n  top: calc(100% - 12px);\r\n  left: calc(100% - 7px);\r\n  transform: rotate(-45deg) scaleX(2.25);\r\n  font-size: 10px;\r\n  cursor: e-resize; }\r\n.smart-drop-down[resize-mode=\"horizontal\"][top] .smart-drop-down-resize-bar:before, .smart-drop-down[resize-mode=\"both\"][top] .smart-drop-down-resize-bar:before {\r\n  transform: rotate(45deg);\r\n  top: calc(100% - 13px);\r\n  left: calc(100% - 4px); }\r\n.smart-drop-down[resize-mode=\"vertical\"] .smart-drop-down-resize-bar {\r\n  cursor: n-resize; }\r\n.smart-drop-down[resize-mode=\"horizontal\"] .smart-drop-down-resize-bar {\r\n  cursor: e-resize; }\r\n  .smart-drop-down[resize-mode=\"horizontal\"] .smart-drop-down-resize-bar > div {\r\n    display: none; }\r\n.smart-drop-down[resize-mode=\"both\"] .smart-drop-down-resize-bar {\r\n  cursor: nwse-resize; }\r\n.smart-drop-down[resize-mode=\"both\"][top] .smart-drop-down-resize-bar {\r\n  cursor: sw-resize; }\r\n\r\n.smart-drop-down-container.smart-drop-down-repositioned {\r\n  background-color: var(--smart-background);\r\n  box-sizing: border-box;\r\n  outline: none;\r\n  border-width: var(--smart-border-width);\r\n  border-style: solid;\r\n  border-color: var(--smart-border);\r\n  display: flex;\r\n  flex-direction: column;\r\n  height: var(--smart-editor-drop-down-height);\r\n  max-height: var(--smart-editor-drop-down-max-height);\r\n  min-height: var(--smart-editor-drop-down-min-height);\r\n  width: var(--smart-editor-drop-down-width);\r\n  max-width: var(--smart-editor-drop-down-max-width);\r\n  min-width: var(--smart-editor-drop-down-min-width);\r\n  font-size: var(--smart-font-size);\r\n  font-family: var(--smart-font-family);\r\n  margin: calc(var(--smart-editor-drop-down-vertical-offset) + var(--smart-editor-drop-down-padding-size)) 0px;\r\n  padding: var(--smart-editor-drop-down-padding-size) 0 var(--smart-editor-drop-down-padding-size) 0 !important; }\r\n  .smart-drop-down-container.smart-drop-down-repositioned.smart-visibility-hidden.not-in-view {\r\n    left: -9999px;\r\n    top: -9999px;\r\n    transition: none; }\r\n  .smart-drop-down-container.smart-drop-down-repositioned:focus {\r\n    border-color: var(--smart-border); }\r\n  .smart-drop-down-container.smart-drop-down-repositioned[overlay-bottom], .smart-drop-down-container.smart-drop-down-repositioned[overlay-center], .smart-drop-down-container.smart-drop-down-repositioned[overlay-top] {\r\n    margin: unset; }\r\n    .smart-drop-down-container.smart-drop-down-repositioned[overlay-bottom]:not([animation='none']), .smart-drop-down-container.smart-drop-down-repositioned[overlay-center]:not([animation='none']), .smart-drop-down-container.smart-drop-down-repositioned[overlay-top]:not([animation='none']) {\r\n      animation: smart-drop-down-list-smart-animate-opening 0.2s ease-out;\r\n      -webkit-transform-origin: center;\r\n      transform-origin: center; }\r\n      .smart-drop-down-container.smart-drop-down-repositioned[overlay-bottom]:not([animation='none']).smart-visibility-hidden, .smart-drop-down-container.smart-drop-down-repositioned[overlay-center]:not([animation='none']).smart-visibility-hidden, .smart-drop-down-container.smart-drop-down-repositioned[overlay-top]:not([animation='none']).smart-visibility-hidden {\r\n        animation: smart-drop-down-list-smart-animate-closing 0.2s ease-in;\r\n        -webkit-transform-origin: center;\r\n        transform-origin: center; }\r\n  .smart-drop-down-container.smart-drop-down-repositioned[top], .smart-drop-down-container.smart-drop-down-repositioned[center-top] {\r\n    margin: calc(-1 * (var(--smart-editor-drop-down-vertical-offset) + 3px)) 0px; }\r\n    .smart-drop-down-container.smart-drop-down-repositioned[top]:not([animation='none']), .smart-drop-down-container.smart-drop-down-repositioned[center-top]:not([animation='none']) {\r\n      animation: smart-drop-down-list-smart-animate-opening 0.2s ease-out;\r\n      -webkit-transform-origin: bottom;\r\n      transform-origin: bottom; }\r\n      .smart-drop-down-container.smart-drop-down-repositioned[top]:not([animation='none']).smart-visibility-hidden, .smart-drop-down-container.smart-drop-down-repositioned[center-top]:not([animation='none']).smart-visibility-hidden {\r\n        animation: smart-drop-down-list-smart-animate-closing 0.2s ease-in;\r\n        -webkit-transform-origin: bottom;\r\n        transform-origin: bottom; }\r\n  .smart-drop-down-container.smart-drop-down-repositioned[bottom]:not([animation='none']), .smart-drop-down-container.smart-drop-down-repositioned[center-bottom]:not([animation='none']) {\r\n    animation: smart-drop-down-list-smart-animate-opening 0.2s ease-out;\r\n    -webkit-transform-origin: top;\r\n    transform-origin: top; }\r\n    .smart-drop-down-container.smart-drop-down-repositioned[bottom]:not([animation='none']).smart-visibility-hidden, .smart-drop-down-container.smart-drop-down-repositioned[center-bottom]:not([animation='none']).smart-visibility-hidden {\r\n      animation: smart-drop-down-list-smart-animate-closing 0.2s ease-in;\r\n      -webkit-transform-origin: top;\r\n      transform-origin: top; }\r\n  .smart-drop-down-container.smart-drop-down-repositioned:not([animation='none']).smart-visibility-hidden {\r\n    transition: animation, visibility 0.2s ease-in; }\r\n.smart-drop-down-container[top].smart-drop-down-container.smart-drop-down-repositioned {\r\n  bottom: initial; }\r\n  .smart-drop-down-container[top].smart-drop-down-container.smart-drop-down-repositioned.smart-visibility-hidden {\r\n    bottom: calc(100% - var(--smart-border-width)); }\r\n\r\n.smart-path .smart-drop-down,\r\n.smart-color-picker .smart-drop-down,\r\n.smart-multi-split-button .smart-drop-down,\r\n.smart-drop-down-list .smart-drop-down,\r\n.smart-combo-box .smart-drop-down,\r\n.smart-text-box .smart-drop-down,\r\n.smart-drop-down-button .smart-drop-down,\r\n.smart-date-time-picker .smart-drop-down {\r\n  background-color: var(--smart-background);\r\n  box-sizing: border-box;\r\n  outline: none;\r\n  border-width: var(--smart-border-width);\r\n  border-style: solid;\r\n  border-color: var(--smart-border);\r\n  display: flex;\r\n  flex-direction: column;\r\n  height: var(--smart-editor-drop-down-height);\r\n  max-height: var(--smart-editor-drop-down-max-height);\r\n  min-height: var(--smart-editor-drop-down-min-height);\r\n  width: var(--smart-editor-drop-down-width);\r\n  max-width: var(--smart-editor-drop-down-max-width);\r\n  min-width: var(--smart-editor-drop-down-min-width);\r\n  font-size: var(--smart-font-size);\r\n  font-family: var(--smart-font-family);\r\n  margin: calc(var(--smart-editor-drop-down-vertical-offset) + var(--smart-editor-drop-down-padding-size)) 0px;\r\n  padding: var(--smart-editor-drop-down-padding-size) 0 var(--smart-editor-drop-down-padding-size) 0 !important;\r\n  top: calc(100% - var(--smart-border-width)); }\r\n  .smart-path .smart-drop-down.smart-visibility-hidden,\r\n  .smart-color-picker .smart-drop-down.smart-visibility-hidden,\r\n  .smart-multi-split-button .smart-drop-down.smart-visibility-hidden,\r\n  .smart-drop-down-list .smart-drop-down.smart-visibility-hidden,\r\n  .smart-combo-box .smart-drop-down.smart-visibility-hidden,\r\n  .smart-text-box .smart-drop-down.smart-visibility-hidden,\r\n  .smart-drop-down-button .smart-drop-down.smart-visibility-hidden,\r\n  .smart-date-time-picker .smart-drop-down.smart-visibility-hidden {\r\n    top: calc(100% - var(--smart-border-width)); }\r\n    .smart-path .smart-drop-down.smart-visibility-hidden.not-in-view,\r\n    .smart-color-picker .smart-drop-down.smart-visibility-hidden.not-in-view,\r\n    .smart-multi-split-button .smart-drop-down.smart-visibility-hidden.not-in-view,\r\n    .smart-drop-down-list .smart-drop-down.smart-visibility-hidden.not-in-view,\r\n    .smart-combo-box .smart-drop-down.smart-visibility-hidden.not-in-view,\r\n    .smart-text-box .smart-drop-down.smart-visibility-hidden.not-in-view,\r\n    .smart-drop-down-button .smart-drop-down.smart-visibility-hidden.not-in-view,\r\n    .smart-date-time-picker .smart-drop-down.smart-visibility-hidden.not-in-view {\r\n      left: -9999px;\r\n      top: -9999px;\r\n      transition: none; }\r\n  .smart-path .smart-drop-down[overlay-bottom], .smart-path .smart-drop-down[overlay-bottom].smart-visibility-hidden,\r\n  .smart-color-picker .smart-drop-down[overlay-bottom],\r\n  .smart-color-picker .smart-drop-down[overlay-bottom].smart-visibility-hidden,\r\n  .smart-multi-split-button .smart-drop-down[overlay-bottom],\r\n  .smart-multi-split-button .smart-drop-down[overlay-bottom].smart-visibility-hidden,\r\n  .smart-drop-down-list .smart-drop-down[overlay-bottom],\r\n  .smart-drop-down-list .smart-drop-down[overlay-bottom].smart-visibility-hidden,\r\n  .smart-combo-box .smart-drop-down[overlay-bottom],\r\n  .smart-combo-box .smart-drop-down[overlay-bottom].smart-visibility-hidden,\r\n  .smart-text-box .smart-drop-down[overlay-bottom],\r\n  .smart-text-box .smart-drop-down[overlay-bottom].smart-visibility-hidden,\r\n  .smart-drop-down-button .smart-drop-down[overlay-bottom],\r\n  .smart-drop-down-button .smart-drop-down[overlay-bottom].smart-visibility-hidden,\r\n  .smart-date-time-picker .smart-drop-down[overlay-bottom],\r\n  .smart-date-time-picker .smart-drop-down[overlay-bottom].smart-visibility-hidden {\r\n    border-color: var(--smart-border);\r\n    border-width: var(--smart-border-width);\r\n    border-style: solid;\r\n    top: 0; }\r\n  .smart-path .smart-drop-down[overlay-center], .smart-path .smart-drop-down[overlay-center].smart-visibility-hidden,\r\n  .smart-color-picker .smart-drop-down[overlay-center],\r\n  .smart-color-picker .smart-drop-down[overlay-center].smart-visibility-hidden,\r\n  .smart-multi-split-button .smart-drop-down[overlay-center],\r\n  .smart-multi-split-button .smart-drop-down[overlay-center].smart-visibility-hidden,\r\n  .smart-drop-down-list .smart-drop-down[overlay-center],\r\n  .smart-drop-down-list .smart-drop-down[overlay-center].smart-visibility-hidden,\r\n  .smart-combo-box .smart-drop-down[overlay-center],\r\n  .smart-combo-box .smart-drop-down[overlay-center].smart-visibility-hidden,\r\n  .smart-text-box .smart-drop-down[overlay-center],\r\n  .smart-text-box .smart-drop-down[overlay-center].smart-visibility-hidden,\r\n  .smart-drop-down-button .smart-drop-down[overlay-center],\r\n  .smart-drop-down-button .smart-drop-down[overlay-center].smart-visibility-hidden,\r\n  .smart-date-time-picker .smart-drop-down[overlay-center],\r\n  .smart-date-time-picker .smart-drop-down[overlay-center].smart-visibility-hidden {\r\n    border-color: var(--smart-border);\r\n    border-width: var(--smart-border-width);\r\n    border-style: solid;\r\n    top: 50%;\r\n    transform: translateY(-50%); }\r\n  .smart-path .smart-drop-down[overlay-top], .smart-path .smart-drop-down[overlay-top].smart-visibility-hidden,\r\n  .smart-color-picker .smart-drop-down[overlay-top],\r\n  .smart-color-picker .smart-drop-down[overlay-top].smart-visibility-hidden,\r\n  .smart-multi-split-button .smart-drop-down[overlay-top],\r\n  .smart-multi-split-button .smart-drop-down[overlay-top].smart-visibility-hidden,\r\n  .smart-drop-down-list .smart-drop-down[overlay-top],\r\n  .smart-drop-down-list .smart-drop-down[overlay-top].smart-visibility-hidden,\r\n  .smart-combo-box .smart-drop-down[overlay-top],\r\n  .smart-combo-box .smart-drop-down[overlay-top].smart-visibility-hidden,\r\n  .smart-text-box .smart-drop-down[overlay-top],\r\n  .smart-text-box .smart-drop-down[overlay-top].smart-visibility-hidden,\r\n  .smart-drop-down-button .smart-drop-down[overlay-top],\r\n  .smart-drop-down-button .smart-drop-down[overlay-top].smart-visibility-hidden,\r\n  .smart-date-time-picker .smart-drop-down[overlay-top],\r\n  .smart-date-time-picker .smart-drop-down[overlay-top].smart-visibility-hidden {\r\n    border-color: var(--smart-border);\r\n    border-width: var(--smart-border-width);\r\n    border-style: solid;\r\n    top: initial;\r\n    bottom: 0; }\r\n  .smart-path .smart-drop-down[top],\r\n  .smart-color-picker .smart-drop-down[top],\r\n  .smart-multi-split-button .smart-drop-down[top],\r\n  .smart-drop-down-list .smart-drop-down[top],\r\n  .smart-combo-box .smart-drop-down[top],\r\n  .smart-text-box .smart-drop-down[top],\r\n  .smart-drop-down-button .smart-drop-down[top],\r\n  .smart-date-time-picker .smart-drop-down[top] {\r\n    top: initial;\r\n    bottom: calc(100% - var(--smart-border-width));\r\n    flex-direction: column-reverse; }\r\n    .smart-path .smart-drop-down[top].smart-visibility-hidden,\r\n    .smart-color-picker .smart-drop-down[top].smart-visibility-hidden,\r\n    .smart-multi-split-button .smart-drop-down[top].smart-visibility-hidden,\r\n    .smart-drop-down-list .smart-drop-down[top].smart-visibility-hidden,\r\n    .smart-combo-box .smart-drop-down[top].smart-visibility-hidden,\r\n    .smart-text-box .smart-drop-down[top].smart-visibility-hidden,\r\n    .smart-drop-down-button .smart-drop-down[top].smart-visibility-hidden,\r\n    .smart-date-time-picker .smart-drop-down[top].smart-visibility-hidden {\r\n      top: initial;\r\n      bottom: calc(100% - var(--smart-border-width));\r\n      flex-direction: column-reverse; }\r\n  .smart-path .smart-drop-down[bottom],\r\n  .smart-color-picker .smart-drop-down[bottom],\r\n  .smart-multi-split-button .smart-drop-down[bottom],\r\n  .smart-drop-down-list .smart-drop-down[bottom],\r\n  .smart-combo-box .smart-drop-down[bottom],\r\n  .smart-text-box .smart-drop-down[bottom],\r\n  .smart-drop-down-button .smart-drop-down[bottom],\r\n  .smart-date-time-picker .smart-drop-down[bottom] {\r\n    cursor: default;\r\n    left: 0;\r\n    box-sizing: border-box;\r\n    font-size: inherit;\r\n    padding: var(--smart-editor-drop-down-padding-size);\r\n    margin: calc(var(--smart-editor-drop-down-vertical-offset) + var(--smart-editor-drop-down-padding-size)) 0px;\r\n    background-color: var(--smart-background);\r\n    border-width: var(--smart-border-width);\r\n    border-style: solid;\r\n    border-color: var(--smart-border);\r\n    box-shadow: var(--smart-elevation-8);\r\n    /*border-top: initial;*/\r\n    display: flex;\r\n    flex-direction: column;\r\n    padding-left: 0px;\r\n    top: calc(100% - var(--smart-border-width)); }\r\n    .smart-path .smart-drop-down[bottom].smart-visibility-hidden,\r\n    .smart-color-picker .smart-drop-down[bottom].smart-visibility-hidden,\r\n    .smart-multi-split-button .smart-drop-down[bottom].smart-visibility-hidden,\r\n    .smart-drop-down-list .smart-drop-down[bottom].smart-visibility-hidden,\r\n    .smart-combo-box .smart-drop-down[bottom].smart-visibility-hidden,\r\n    .smart-text-box .smart-drop-down[bottom].smart-visibility-hidden,\r\n    .smart-drop-down-button .smart-drop-down[bottom].smart-visibility-hidden,\r\n    .smart-date-time-picker .smart-drop-down[bottom].smart-visibility-hidden {\r\n      top: calc(100% - var(--smart-border-width)); }\r\n  .smart-path .smart-drop-down[center-bottom], .smart-path .smart-drop-down[center-bottom].smart-visibility-hidden,\r\n  .smart-color-picker .smart-drop-down[center-bottom],\r\n  .smart-color-picker .smart-drop-down[center-bottom].smart-visibility-hidden,\r\n  .smart-multi-split-button .smart-drop-down[center-bottom],\r\n  .smart-multi-split-button .smart-drop-down[center-bottom].smart-visibility-hidden,\r\n  .smart-drop-down-list .smart-drop-down[center-bottom],\r\n  .smart-drop-down-list .smart-drop-down[center-bottom].smart-visibility-hidden,\r\n  .smart-combo-box .smart-drop-down[center-bottom],\r\n  .smart-combo-box .smart-drop-down[center-bottom].smart-visibility-hidden,\r\n  .smart-text-box .smart-drop-down[center-bottom],\r\n  .smart-text-box .smart-drop-down[center-bottom].smart-visibility-hidden,\r\n  .smart-drop-down-button .smart-drop-down[center-bottom],\r\n  .smart-drop-down-button .smart-drop-down[center-bottom].smart-visibility-hidden,\r\n  .smart-date-time-picker .smart-drop-down[center-bottom],\r\n  .smart-date-time-picker .smart-drop-down[center-bottom].smart-visibility-hidden {\r\n    left: 50%;\r\n    border: var(--smart-border-width) solid var(--smart-border);\r\n    top: calc(100% - var(--smart-border-width)); }\r\n  .smart-path .smart-drop-down[center-top], .smart-path .smart-drop-down[center-top].smart-visibility-hidden,\r\n  .smart-color-picker .smart-drop-down[center-top],\r\n  .smart-color-picker .smart-drop-down[center-top].smart-visibility-hidden,\r\n  .smart-multi-split-button .smart-drop-down[center-top],\r\n  .smart-multi-split-button .smart-drop-down[center-top].smart-visibility-hidden,\r\n  .smart-drop-down-list .smart-drop-down[center-top],\r\n  .smart-drop-down-list .smart-drop-down[center-top].smart-visibility-hidden,\r\n  .smart-combo-box .smart-drop-down[center-top],\r\n  .smart-combo-box .smart-drop-down[center-top].smart-visibility-hidden,\r\n  .smart-text-box .smart-drop-down[center-top],\r\n  .smart-text-box .smart-drop-down[center-top].smart-visibility-hidden,\r\n  .smart-drop-down-button .smart-drop-down[center-top],\r\n  .smart-drop-down-button .smart-drop-down[center-top].smart-visibility-hidden,\r\n  .smart-date-time-picker .smart-drop-down[center-top],\r\n  .smart-date-time-picker .smart-drop-down[center-top].smart-visibility-hidden {\r\n    left: 50%;\r\n    border: var(--smart-border-width) solid var(--smart-border);\r\n    top: initial;\r\n    bottom: calc(100% - var(--smart-border-width)); }\r\n.smart-path:not([animation='none']) .smart-drop-down,\r\n.smart-color-picker:not([animation='none']) .smart-drop-down,\r\n.smart-multi-split-button:not([animation='none']) .smart-drop-down,\r\n.smart-drop-down-list:not([animation='none']) .smart-drop-down,\r\n.smart-combo-box:not([animation='none']) .smart-drop-down,\r\n.smart-text-box:not([animation='none']) .smart-drop-down,\r\n.smart-drop-down-button:not([animation='none']) .smart-drop-down,\r\n.smart-date-time-picker:not([animation='none']) .smart-drop-down {\r\n  animation: smart-drop-down-list-smart-animate-opening 0.2s ease-out;\r\n  -webkit-transform-origin: top;\r\n  transform-origin: top; }\r\n  .smart-path:not([animation='none']) .smart-drop-down.smart-visibility-hidden,\r\n  .smart-color-picker:not([animation='none']) .smart-drop-down.smart-visibility-hidden,\r\n  .smart-multi-split-button:not([animation='none']) .smart-drop-down.smart-visibility-hidden,\r\n  .smart-drop-down-list:not([animation='none']) .smart-drop-down.smart-visibility-hidden,\r\n  .smart-combo-box:not([animation='none']) .smart-drop-down.smart-visibility-hidden,\r\n  .smart-text-box:not([animation='none']) .smart-drop-down.smart-visibility-hidden,\r\n  .smart-drop-down-button:not([animation='none']) .smart-drop-down.smart-visibility-hidden,\r\n  .smart-date-time-picker:not([animation='none']) .smart-drop-down.smart-visibility-hidden {\r\n    transition: animation, visibility 0.2s ease-in;\r\n    animation: smart-drop-down-list-smart-animate-closing 0.2s ease-in;\r\n    -webkit-transform-origin: top;\r\n    transform-origin: top; }\r\n  .smart-path:not([animation='none']) .smart-drop-down[bottom], .smart-path:not([animation='none']) .smart-drop-down[center-bottom],\r\n  .smart-color-picker:not([animation='none']) .smart-drop-down[bottom],\r\n  .smart-color-picker:not([animation='none']) .smart-drop-down[center-bottom],\r\n  .smart-multi-split-button:not([animation='none']) .smart-drop-down[bottom],\r\n  .smart-multi-split-button:not([animation='none']) .smart-drop-down[center-bottom],\r\n  .smart-drop-down-list:not([animation='none']) .smart-drop-down[bottom],\r\n  .smart-drop-down-list:not([animation='none']) .smart-drop-down[center-bottom],\r\n  .smart-combo-box:not([animation='none']) .smart-drop-down[bottom],\r\n  .smart-combo-box:not([animation='none']) .smart-drop-down[center-bottom],\r\n  .smart-text-box:not([animation='none']) .smart-drop-down[bottom],\r\n  .smart-text-box:not([animation='none']) .smart-drop-down[center-bottom],\r\n  .smart-drop-down-button:not([animation='none']) .smart-drop-down[bottom],\r\n  .smart-drop-down-button:not([animation='none']) .smart-drop-down[center-bottom],\r\n  .smart-date-time-picker:not([animation='none']) .smart-drop-down[bottom],\r\n  .smart-date-time-picker:not([animation='none']) .smart-drop-down[center-bottom] {\r\n    animation: smart-drop-down-list-smart-animate-opening 0.2s ease-out;\r\n    -webkit-transform-origin: top;\r\n    transform-origin: top; }\r\n    .smart-path:not([animation='none']) .smart-drop-down[bottom].smart-visibility-hidden, .smart-path:not([animation='none']) .smart-drop-down[center-bottom].smart-visibility-hidden,\r\n    .smart-color-picker:not([animation='none']) .smart-drop-down[bottom].smart-visibility-hidden,\r\n    .smart-color-picker:not([animation='none']) .smart-drop-down[center-bottom].smart-visibility-hidden,\r\n    .smart-multi-split-button:not([animation='none']) .smart-drop-down[bottom].smart-visibility-hidden,\r\n    .smart-multi-split-button:not([animation='none']) .smart-drop-down[center-bottom].smart-visibility-hidden,\r\n    .smart-drop-down-list:not([animation='none']) .smart-drop-down[bottom].smart-visibility-hidden,\r\n    .smart-drop-down-list:not([animation='none']) .smart-drop-down[center-bottom].smart-visibility-hidden,\r\n    .smart-combo-box:not([animation='none']) .smart-drop-down[bottom].smart-visibility-hidden,\r\n    .smart-combo-box:not([animation='none']) .smart-drop-down[center-bottom].smart-visibility-hidden,\r\n    .smart-text-box:not([animation='none']) .smart-drop-down[bottom].smart-visibility-hidden,\r\n    .smart-text-box:not([animation='none']) .smart-drop-down[center-bottom].smart-visibility-hidden,\r\n    .smart-drop-down-button:not([animation='none']) .smart-drop-down[bottom].smart-visibility-hidden,\r\n    .smart-drop-down-button:not([animation='none']) .smart-drop-down[center-bottom].smart-visibility-hidden,\r\n    .smart-date-time-picker:not([animation='none']) .smart-drop-down[bottom].smart-visibility-hidden,\r\n    .smart-date-time-picker:not([animation='none']) .smart-drop-down[center-bottom].smart-visibility-hidden {\r\n      animation: smart-drop-down-list-smart-animate-closing 0.2s ease-in;\r\n      -webkit-transform-origin: top;\r\n      transform-origin: top; }\r\n  .smart-path:not([animation='none']) .smart-drop-down[top], .smart-path:not([animation='none']) .smart-drop-down[center-top],\r\n  .smart-color-picker:not([animation='none']) .smart-drop-down[top],\r\n  .smart-color-picker:not([animation='none']) .smart-drop-down[center-top],\r\n  .smart-multi-split-button:not([animation='none']) .smart-drop-down[top],\r\n  .smart-multi-split-button:not([animation='none']) .smart-drop-down[center-top],\r\n  .smart-drop-down-list:not([animation='none']) .smart-drop-down[top],\r\n  .smart-drop-down-list:not([animation='none']) .smart-drop-down[center-top],\r\n  .smart-combo-box:not([animation='none']) .smart-drop-down[top],\r\n  .smart-combo-box:not([animation='none']) .smart-drop-down[center-top],\r\n  .smart-text-box:not([animation='none']) .smart-drop-down[top],\r\n  .smart-text-box:not([animation='none']) .smart-drop-down[center-top],\r\n  .smart-drop-down-button:not([animation='none']) .smart-drop-down[top],\r\n  .smart-drop-down-button:not([animation='none']) .smart-drop-down[center-top],\r\n  .smart-date-time-picker:not([animation='none']) .smart-drop-down[top],\r\n  .smart-date-time-picker:not([animation='none']) .smart-drop-down[center-top] {\r\n    animation: smart-drop-down-list-smart-animate-opening 0.2s ease-out;\r\n    -webkit-transform-origin: bottom;\r\n    transform-origin: bottom; }\r\n    .smart-path:not([animation='none']) .smart-drop-down[top].smart-visibility-hidden, .smart-path:not([animation='none']) .smart-drop-down[center-top].smart-visibility-hidden,\r\n    .smart-color-picker:not([animation='none']) .smart-drop-down[top].smart-visibility-hidden,\r\n    .smart-color-picker:not([animation='none']) .smart-drop-down[center-top].smart-visibility-hidden,\r\n    .smart-multi-split-button:not([animation='none']) .smart-drop-down[top].smart-visibility-hidden,\r\n    .smart-multi-split-button:not([animation='none']) .smart-drop-down[center-top].smart-visibility-hidden,\r\n    .smart-drop-down-list:not([animation='none']) .smart-drop-down[top].smart-visibility-hidden,\r\n    .smart-drop-down-list:not([animation='none']) .smart-drop-down[center-top].smart-visibility-hidden,\r\n    .smart-combo-box:not([animation='none']) .smart-drop-down[top].smart-visibility-hidden,\r\n    .smart-combo-box:not([animation='none']) .smart-drop-down[center-top].smart-visibility-hidden,\r\n    .smart-text-box:not([animation='none']) .smart-drop-down[top].smart-visibility-hidden,\r\n    .smart-text-box:not([animation='none']) .smart-drop-down[center-top].smart-visibility-hidden,\r\n    .smart-drop-down-button:not([animation='none']) .smart-drop-down[top].smart-visibility-hidden,\r\n    .smart-drop-down-button:not([animation='none']) .smart-drop-down[center-top].smart-visibility-hidden,\r\n    .smart-date-time-picker:not([animation='none']) .smart-drop-down[top].smart-visibility-hidden,\r\n    .smart-date-time-picker:not([animation='none']) .smart-drop-down[center-top].smart-visibility-hidden {\r\n      animation: smart-drop-down-list-smart-animate-closing 0.2s ease-in;\r\n      -webkit-transform-origin: bottom;\r\n      transform-origin: bottom; }\r\n  .smart-path:not([animation='none']) .smart-drop-down[overlay-bottom], .smart-path:not([animation='none']) .smart-drop-down[overlay-top],\r\n  .smart-color-picker:not([animation='none']) .smart-drop-down[overlay-bottom],\r\n  .smart-color-picker:not([animation='none']) .smart-drop-down[overlay-top],\r\n  .smart-multi-split-button:not([animation='none']) .smart-drop-down[overlay-bottom],\r\n  .smart-multi-split-button:not([animation='none']) .smart-drop-down[overlay-top],\r\n  .smart-drop-down-list:not([animation='none']) .smart-drop-down[overlay-bottom],\r\n  .smart-drop-down-list:not([animation='none']) .smart-drop-down[overlay-top],\r\n  .smart-combo-box:not([animation='none']) .smart-drop-down[overlay-bottom],\r\n  .smart-combo-box:not([animation='none']) .smart-drop-down[overlay-top],\r\n  .smart-text-box:not([animation='none']) .smart-drop-down[overlay-bottom],\r\n  .smart-text-box:not([animation='none']) .smart-drop-down[overlay-top],\r\n  .smart-drop-down-button:not([animation='none']) .smart-drop-down[overlay-bottom],\r\n  .smart-drop-down-button:not([animation='none']) .smart-drop-down[overlay-top],\r\n  .smart-date-time-picker:not([animation='none']) .smart-drop-down[overlay-bottom],\r\n  .smart-date-time-picker:not([animation='none']) .smart-drop-down[overlay-top] {\r\n    animation: smart-drop-down-list-smart-animate-opening 0.2s ease-out;\r\n    -webkit-transform-origin: center;\r\n    transform-origin: center; }\r\n    .smart-path:not([animation='none']) .smart-drop-down[overlay-bottom].smart-visibility-hidden, .smart-path:not([animation='none']) .smart-drop-down[overlay-top].smart-visibility-hidden,\r\n    .smart-color-picker:not([animation='none']) .smart-drop-down[overlay-bottom].smart-visibility-hidden,\r\n    .smart-color-picker:not([animation='none']) .smart-drop-down[overlay-top].smart-visibility-hidden,\r\n    .smart-multi-split-button:not([animation='none']) .smart-drop-down[overlay-bottom].smart-visibility-hidden,\r\n    .smart-multi-split-button:not([animation='none']) .smart-drop-down[overlay-top].smart-visibility-hidden,\r\n    .smart-drop-down-list:not([animation='none']) .smart-drop-down[overlay-bottom].smart-visibility-hidden,\r\n    .smart-drop-down-list:not([animation='none']) .smart-drop-down[overlay-top].smart-visibility-hidden,\r\n    .smart-combo-box:not([animation='none']) .smart-drop-down[overlay-bottom].smart-visibility-hidden,\r\n    .smart-combo-box:not([animation='none']) .smart-drop-down[overlay-top].smart-visibility-hidden,\r\n    .smart-text-box:not([animation='none']) .smart-drop-down[overlay-bottom].smart-visibility-hidden,\r\n    .smart-text-box:not([animation='none']) .smart-drop-down[overlay-top].smart-visibility-hidden,\r\n    .smart-drop-down-button:not([animation='none']) .smart-drop-down[overlay-bottom].smart-visibility-hidden,\r\n    .smart-drop-down-button:not([animation='none']) .smart-drop-down[overlay-top].smart-visibility-hidden,\r\n    .smart-date-time-picker:not([animation='none']) .smart-drop-down[overlay-bottom].smart-visibility-hidden,\r\n    .smart-date-time-picker:not([animation='none']) .smart-drop-down[overlay-top].smart-visibility-hidden {\r\n      animation: smart-drop-down-list-smart-animate-closing 0.2s ease-in;\r\n      -webkit-transform-origin: center;\r\n      transform-origin: center; }\r\n  .smart-path:not([animation='none']) .smart-drop-down[overlay-center],\r\n  .smart-color-picker:not([animation='none']) .smart-drop-down[overlay-center],\r\n  .smart-multi-split-button:not([animation='none']) .smart-drop-down[overlay-center],\r\n  .smart-drop-down-list:not([animation='none']) .smart-drop-down[overlay-center],\r\n  .smart-combo-box:not([animation='none']) .smart-drop-down[overlay-center],\r\n  .smart-text-box:not([animation='none']) .smart-drop-down[overlay-center],\r\n  .smart-drop-down-button:not([animation='none']) .smart-drop-down[overlay-center],\r\n  .smart-date-time-picker:not([animation='none']) .smart-drop-down[overlay-center] {\r\n    animation: smart-drop-down-list-smart-animate-overlay-center-opening 0.2s ease-out;\r\n    -webkit-transform-origin: top;\r\n    transform-origin: top; }\r\n    .smart-path:not([animation='none']) .smart-drop-down[overlay-center].smart-visibility-hidden,\r\n    .smart-color-picker:not([animation='none']) .smart-drop-down[overlay-center].smart-visibility-hidden,\r\n    .smart-multi-split-button:not([animation='none']) .smart-drop-down[overlay-center].smart-visibility-hidden,\r\n    .smart-drop-down-list:not([animation='none']) .smart-drop-down[overlay-center].smart-visibility-hidden,\r\n    .smart-combo-box:not([animation='none']) .smart-drop-down[overlay-center].smart-visibility-hidden,\r\n    .smart-text-box:not([animation='none']) .smart-drop-down[overlay-center].smart-visibility-hidden,\r\n    .smart-drop-down-button:not([animation='none']) .smart-drop-down[overlay-center].smart-visibility-hidden,\r\n    .smart-date-time-picker:not([animation='none']) .smart-drop-down[overlay-center].smart-visibility-hidden {\r\n      animation: smart-drop-down-list-smart-animate-overlay-center-closing 0.2s ease-in;\r\n      -webkit-transform-origin: top;\r\n      transform-origin: top; }\r\n\r\n.smart-multi-split-button .smart-drop-down,\r\n.smart-drop-down-list .smart-drop-down,\r\n.smart-text-box .smart-drop-down,\r\n.smart-drop-down-button .smart-drop-down {\r\n  height: calc(var(--smart-scroll-bar-size)); }\r\n  .smart-multi-split-button .smart-drop-down smart-scroll-bar:before,\r\n  .smart-drop-down-list .smart-drop-down smart-scroll-bar:before,\r\n  .smart-text-box .smart-drop-down smart-scroll-bar:before,\r\n  .smart-drop-down-button .smart-drop-down smart-scroll-bar:before {\r\n    display: none;\r\n    background-color: var(--smart-border); }\r\n  .smart-multi-split-button .smart-drop-down smart-scroll-bar[orientation=\"vertical\"].bottom-corner,\r\n  .smart-drop-down-list .smart-drop-down smart-scroll-bar[orientation=\"vertical\"].bottom-corner,\r\n  .smart-text-box .smart-drop-down smart-scroll-bar[orientation=\"vertical\"].bottom-corner,\r\n  .smart-drop-down-button .smart-drop-down smart-scroll-bar[orientation=\"vertical\"].bottom-corner {\r\n    width: calc(var(--smart-scroll-bar-size));\r\n    height: calc(100% - var(--smart-scroll-bar-size)); }\r\n  .smart-multi-split-button .smart-drop-down smart-scroll-bar.bottom-corner,\r\n  .smart-drop-down-list .smart-drop-down smart-scroll-bar.bottom-corner,\r\n  .smart-text-box .smart-drop-down smart-scroll-bar.bottom-corner,\r\n  .smart-drop-down-button .smart-drop-down smart-scroll-bar.bottom-corner {\r\n    width: calc(100% - var(--smart-scroll-bar-size)); }\r\n  .smart-multi-split-button .smart-drop-down .smart-list-items-container.vscroll,\r\n  .smart-drop-down-list .smart-drop-down .smart-list-items-container.vscroll,\r\n  .smart-text-box .smart-drop-down .smart-list-items-container.vscroll,\r\n  .smart-drop-down-button .smart-drop-down .smart-list-items-container.vscroll {\r\n    width: calc(100% - var(--smart-scroll-bar-size)); }\r\n    .smart-multi-split-button .smart-drop-down .smart-list-items-container.vscroll[orientation=\"vertical\"],\r\n    .smart-drop-down-list .smart-drop-down .smart-list-items-container.vscroll[orientation=\"vertical\"],\r\n    .smart-text-box .smart-drop-down .smart-list-items-container.vscroll[orientation=\"vertical\"],\r\n    .smart-drop-down-button .smart-drop-down .smart-list-items-container.vscroll[orientation=\"vertical\"] {\r\n      padding-top: initial; }\r\n  .smart-multi-split-button .smart-drop-down input:focus,\r\n  .smart-drop-down-list .smart-drop-down input:focus,\r\n  .smart-text-box .smart-drop-down input:focus,\r\n  .smart-drop-down-button .smart-drop-down input:focus {\r\n    outline: none; }\r\n\r\n.smart-multi-split-button.auto-height .smart-action-button,\r\n.smart-drop-down-list.auto-height .smart-action-button,\r\n.smart-drop-down-button.auto-height .smart-action-button {\r\n  white-space: initial;\r\n  text-overflow: initial;\r\n  line-height: 1rem;\r\n  flex-wrap: wrap; }\r\n.smart-multi-split-button.auto-height[selection-display-mode=\"tokens\"] smart-action-button > span,\r\n.smart-multi-split-button.auto-height[selection-display-mode=\"tokens\"] .smart-action-button > span:first-of-type,\r\n.smart-drop-down-list.auto-height[selection-display-mode=\"tokens\"] smart-action-button > span,\r\n.smart-drop-down-list.auto-height[selection-display-mode=\"tokens\"] .smart-action-button > span:first-of-type,\r\n.smart-drop-down-button.auto-height[selection-display-mode=\"tokens\"] smart-action-button > span,\r\n.smart-drop-down-button.auto-height[selection-display-mode=\"tokens\"] .smart-action-button > span:first-of-type {\r\n  display: inline-block;\r\n  margin: 0.2em; }\r\n\r\n.smart-color-picker .smart-drop-down {\r\n  width: var(--smart-drop-down-button-drop-down-width);\r\n  height: var(--smart-drop-down-button-drop-down-height); }\r\n  .smart-color-picker .smart-drop-down.smart-drop-down-color-picker {\r\n    max-height: calc(var(--smart-editor-drop-down-max-height) + 50px); }\r\n  .smart-color-picker .smart-drop-down smart-scroll-bar:before {\r\n    display: none;\r\n    background-color: var(--smart-border); }\r\n  .smart-color-picker .smart-drop-down smart-scroll-bar[orientation=\"vertical\"].bottom-corner {\r\n    width: calc(var(--smart-scroll-bar-size));\r\n    height: calc(100% - var(--smart-scroll-bar-size)); }\r\n  .smart-color-picker .smart-drop-down .smart-list-items-container.vscroll {\r\n    width: calc(100% - var(--smart-scroll-bar-size)); }\r\n    .smart-color-picker .smart-drop-down .smart-list-items-container.vscroll[orientation=\"vertical\"] {\r\n      padding-top: initial; }\r\n\r\n.smart-drop-down-list .smart-drop-down {\r\n  width: var(--smart-drop-down-list-drop-down-width);\r\n  height: var(--smart-drop-down-list-drop-down-height); }\r\n\r\n.smart-combo-box .smart-drop-down {\r\n  width: var(--smart-combo-box-drop-down-width);\r\n  height: var(--smart-combo-box-drop-down-height); }\r\n  .smart-combo-box .smart-drop-down smart-scroll-bar:before {\r\n    display: none;\r\n    background-color: var(--smart-border); }\r\n  .smart-combo-box .smart-drop-down smart-scroll-bar[orientation=\"vertical\"].bottom-corner {\r\n    width: calc(var(--smart-scroll-bar-size));\r\n    height: calc(100% - var(--smart-scroll-bar-size)); }\r\n  .smart-combo-box .smart-drop-down smart-scroll-bar.bottom-corner {\r\n    width: calc(100% - var(--smart-scroll-bar-size)); }\r\n  .smart-combo-box .smart-drop-down .smart-list-items-container.vscroll {\r\n    width: calc(100% - var(--smart-scroll-bar-size)); }\r\n    .smart-combo-box .smart-drop-down .smart-list-items-container.vscroll[orientation=\"vertical\"] {\r\n      padding-top: initial; }\r\n.smart-combo-box .smart-selection-field input {\r\n  outline: none; }\r\n\r\n.smart-drop-down-button .smart-drop-down {\r\n  width: var(--smart-drop-down-button-drop-down-width);\r\n  height: var(--smart-drop-down-button-drop-down-height); }\r\n\r\n.smart-date-time-picker .smart-drop-down {\r\n  border: none; }\r\n\r\n.smart-drop-down-overlay {\r\n  position: absolute;\r\n  top: 0;\r\n  left: 0;\r\n  z-index: 9000; }\r\n\r\n.smart-list-box input.vscroll {\r\n  outline: none; }\r\n.smart-list-box smart-scroll-bar:before {\r\n  display: none;\r\n  background-color: var(--smart-border); }\r\n.smart-list-box smart-scroll-bar[orientation=\"vertical\"].bottom-corner {\r\n  width: calc(var(--smart-scroll-bar-size));\r\n  height: calc(100% - var(--smart-scroll-bar-size)); }\r\n.smart-list-box smart-scroll-bar.bottom-corner {\r\n  width: calc(100% - var(--smart-scroll-bar-size)); }\r\n.smart-list-box .smart-list-items-container.vscroll {\r\n  width: calc(100% - var(--smart-scroll-bar-size)); }\r\n\r\n.smart-scroll-viewer {\r\n  max-width: 100%;\r\n  border: 0; }\r\n  .smart-scroll-viewer smart-scroll-bar:before {\r\n    display: none;\r\n    background-color: var(--smart-border); }\r\n  .smart-scroll-viewer smart-scroll-bar[orientation=\"vertical\"].bottom-corner {\r\n    width: calc(var(--smart-scroll-bar-size));\r\n    height: calc(100% - var(--smart-scroll-bar-size)); }\r\n  .smart-scroll-viewer smart-scroll-bar.bottom-corner {\r\n    width: calc(100% - var(--smart-scroll-bar-size)); }\r\n  .smart-scroll-viewer .smart-list-items-container.vscroll {\r\n    width: calc(100% - var(--smart-scroll-bar-size)); }\r\n\r\n@keyframes smart-drop-down-list-smart-animate-overlay-center-opening {\r\n  0% {\r\n    opacity: 0.2;\r\n    transform: scaleY(0) translateY(-50%); }\r\n  50% {\r\n    opacity: 0.4; }\r\n  100% {\r\n    opacity: 1;\r\n    transform: scaleY(1) translateY(-50%); } }\r\n@keyframes smart-drop-down-list-smart-animate-overlay-center-closing {\r\n  0% {\r\n    opacity: 1;\r\n    transform: scaleY(1) translateY(-50%); }\r\n  50% {\r\n    opacity: 0.4; }\r\n  100% {\r\n    opacity: 0.2;\r\n    transform: scaleY(0) translateY(-50%); } }\r\n@keyframes smart-drop-down-list-smart-animate-opening {\r\n  0% {\r\n    opacity: 0.2;\r\n    transform: scaleY(0); }\r\n  50% {\r\n    opacity: 0.4; }\r\n  100% {\r\n    opacity: 1;\r\n    transform: scaleY(1); } }\r\n@keyframes smart-drop-down-list-smart-animate-closing {\r\n  0% {\r\n    opacity: 1;\r\n    transform: scaleY(1);\r\n    pointer-events: none; }\r\n  50% {\r\n    opacity: 0.4;\r\n    pointer-events: none; }\r\n  100% {\r\n    opacity: 0.2;\r\n    transform: scaleY(0);\r\n    pointer-events: none; } }\r\n.smart-drop-down-box[right-to-left]:not([hover]) .smart-action-button[focus] {\r\n  border-top-color: transparent;\r\n  border-left-color: transparent;\r\n  border-right-color: transparent;\r\n  border-bottom-left-radius: 0; }\r\n.smart-drop-down-box[right-to-left]:not([drop-down-button-position]) .smart-drop-down-button,\r\n.smart-drop-down-box[right-to-left]:not([drop-down-button-position]) .smart-drop-down-button[focus] {\r\n  border-top-color: transparent;\r\n  border-left-color: transparent;\r\n  border-right-color: transparent; }\r\n.smart-drop-down-box[right-to-left]:not([drop-down-button-position]) .smart-action-button {\r\n  border-top-color: transparent;\r\n  border-left-color: transparent;\r\n  border-right-color: transparent;\r\n  border-bottom-left-radius: 0;\r\n  border-bottom-right-radius: 0; }\r\n.smart-drop-down-box[right-to-left]:not([drop-down-button-position]):not([opened]):not([hover]) .smart-drop-down-button:not([hover]),\r\n.smart-drop-down-box[right-to-left]:not([drop-down-button-position]):not([opened]):not([hover]) .smart-drop-down-button[focus]:not([hover]) {\r\n  border-bottom-left-radius: 0; }\r\n",""]);const s=i},6707:(e,t,r)=>{"use strict";r.d(t,{Z:()=>s});var n=r(8081),o=r.n(n),a=r(3645),i=r.n(a)()(o());i.push([e.id,'/* .smart-editor */\r\n/* --- Scheduler Style Color Input --- */\r\n.smart-editor .smart-editor-content-container textarea, .smart-editor .smart-editor-content-container .smart-editor-editable {\r\n  width: 100%;\r\n  height: 100%;\r\n  outline: none;\r\n  padding: var(--smart-editor-padding);\r\n  background: transparent;\r\n}\r\n\r\n.smart-editor-toolbar-item[item-type="button"], .smart-editor-toolbar-item[item-type="toggle"], .smart-editor-toolbar-item[item-type="drop-down"], .smart-editor-toolbar-item[item-type="color-input"], .smart-editor-toolbar-item[item-type="delimiter"] {\r\n  position: relative;\r\n  height: var(--smart-editor-toolbar-item-height);\r\n  outline: none;\r\n}\r\n\r\n.smart-editor-toolbar-item[item-type="drop-down"]:after, .smart-editor-toolbar-item[item-type="color-input"] .smart-editor-item-drop-down-button::before, .smart-editor-toolbar-item:not([item-type="drop-down"])::before, .smart-editor-toolbar-item[item-name="clearformat"]::after, .smart-editor-toolbar-item[item-name="alignment"]::before, .smart-editor-toolbar-item[item-type="delimiter"]::before {\r\n  font-size: var(--smart-font-size);\r\n  font-family: var(--smart-font-family-icon);\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  width: 100%;\r\n  min-width: var(--smart-editor-addon-width);\r\n  height: 100%;\r\n  box-sizing: border-box;\r\n  pointer-events: none;\r\n}\r\n\r\n.smart-editor-toolbar-item[item-type="drop-down"]:after, .smart-editor-toolbar-item[item-type="color-input"] .smart-editor-item-drop-down-button::before {\r\n  content: var(--smart-icon-arrow-down);\r\n  width: var(--smart-editor-addon-width);\r\n  min-width: var(--smart-editor-addon-width);\r\n}\r\n\r\n.smart-editor-toolbar-item[item-type="drop-down"]:before {\r\n  font-size: var(--smart-font-size);\r\n  font-family: var(--smart-font-family-icon);\r\n  overflow: hidden;\r\n  text-overflow: ellipsis;\r\n  white-space: nowrap;\r\n  content: attr(item-value);\r\n  width: calc(100% - 30px);\r\n  padding: var(--smart-editor-label-padding);\r\n  padding-top: initial;\r\n  padding-right: initial;\r\n  padding-bottom: initial;\r\n  text-align: center;\r\n}\r\n\r\n[disabled].smart-editor-toolbar-item {\r\n  -moz-user-select: none;\r\n  -ms-user-select: none;\r\n  -webkit-user-select: none;\r\n  user-select: none;\r\n  opacity: 0.55;\r\n  cursor: default;\r\n  pointer-events: none;\r\n}\r\n\r\n.smart-editor {\r\n  display: block;\r\n  width: var(--smart-editor-default-width);\r\n  height: var(--smart-editor-default-height);\r\n  min-height: var(--smart-editor-input-min-height);\r\n  border: var(--smart-border-width) solid var(--smart-border);\r\n  border-radius: var(--smart-border-radius);\r\n  contain: content;\r\n}\r\n.smart-editor.smart-editor-iframe-body {\r\n  margin: initial;\r\n  border: initial;\r\n  min-height: initial;\r\n  border-radius: initial;\r\n  width: 100%;\r\n  height: 100%;\r\n}\r\n.smart-editor.smart-editor-iframe-body table {\r\n  font-size: var(--smart-font-size);\r\n  font-weight: var(--smart-font-weight);\r\n}\r\n.smart-editor.smart-editor-iframe-body * {\r\n  box-sizing: border-box;\r\n}\r\n.smart-editor > .smart-container {\r\n  display: grid;\r\n  grid-template-columns: 100%;\r\n  grid-template-rows: auto minmax(0, 1fr);\r\n  position: relative;\r\n  min-height: inherit;\r\n}\r\n.smart-editor .smart-toast-container.smart-toast-container-custom {\r\n  position: absolute;\r\n  top: 0;\r\n  right: 0;\r\n  height: auto;\r\n  max-height: 100%;\r\n}\r\n.smart-editor.full-screen-mode {\r\n  min-width: 100%;\r\n  max-width: 100%;\r\n  min-height: 100%;\r\n  max-height: 100%;\r\n  position: fixed !important;\r\n  left: 0 !important;\r\n  right: 0 !important;\r\n  top: 0 !important;\r\n  z-index: calc(var(--smart-editor-drop-down-z-index) - 1);\r\n}\r\n.smart-editor[readonly] .smart-editor-toolbar-items-primary,\r\n.smart-editor[readonly] .smart-editor-toolbar-items-secondary {\r\n  pointer-events: none;\r\n}\r\n.smart-editor[toolbar-mode="singleLineRibbon"] .smart-editor-toolbar[toolbar-tab-selected]:not([expanded]) .smart-editor-toolbar-toggle-button::before {\r\n  content: var(--smart-icon-window-pin);\r\n}\r\n.smart-editor[toolbar-mode="singleLineRibbon"] .smart-editor-toolbar-tab-selection-bar {\r\n  position: absolute;\r\n  bottom: 0;\r\n  height: calc(2* var(--smart-border-width));\r\n  background-color: var(--smart-primary);\r\n  transform: scaleX(1);\r\n}\r\n.smart-editor[toolbar-mode="singleLineRibbon"] .smart-editor-toolbar-tab-selection-bar.smart-visibility-hidden {\r\n  transform: scaleX(0);\r\n}\r\n.smart-editor[toolbar-mode="singleLineRibbon"] .smart-editor-toolbar-items-primary {\r\n  position: relative;\r\n}\r\n.smart-editor[toolbar-mode="singleLineRibbon"] .smart-editor-toolbar[expanded] .smart-editor-toolbar-items-primary,\r\n.smart-editor[toolbar-mode="singleLineRibbon"] .smart-editor-toolbar[expanded] .smart-editor-toolbar-toggle-button {\r\n  border-bottom: var(--smart-border-width) solid var(--smart-border);\r\n}\r\n.smart-editor[toolbar-mode="singleLineRibbon"] .smart-editor-toolbar:not(.smart-tooltip) .smart-editor-toolbar-items-secondary .smart-editor-toolbar-item {\r\n  margin-left: initial;\r\n}\r\n.smart-editor[toolbar-mode="singleLineRibbon"] .smart-editor-toolbar-items-secondary {\r\n  background-color: var(--smart-background);\r\n  padding-bottom: initial;\r\n  flex-wrap: initial;\r\n}\r\n.smart-editor[toolbar-mode="singleLineRibbon"] .smart-editor-toolbar-items-secondary.smart-drop-down {\r\n  border-bottom: var(--smart-border-width) solid var(--smart-border);\r\n  box-shadow: var(--smart-elevation-4);\r\n  overflow: hidden;\r\n}\r\n.smart-editor[toolbar-mode="singleLineRibbon"] .smart-editor-toolbar-items-secondary .smart-editor-toolbar-item {\r\n  margin-bottom: var(--smart-editor-toolbar-item-margin);\r\n}\r\n.smart-editor[toolbar-mode="singleLineRibbon"] .smart-editor-toolbar-items-secondary .smart-editor-toolbar-item:not(:last-of-type) {\r\n  margin-right: var(--smart-editor-toolbar-item-margin);\r\n}\r\n.smart-editor[toolbar-mode="singleLineRibbon"] .smart-editor-toolbar-tab {\r\n  -moz-user-select: none;\r\n  -ms-user-select: none;\r\n  -webkit-user-select: none;\r\n  user-select: none;\r\n  padding: var(--smart-tab-item-padding);\r\n}\r\n.smart-editor[toolbar-mode="singleLineRibbon"] .smart-editor-toolbar-tab:not([disabled]) {\r\n  cursor: pointer;\r\n}\r\n.smart-editor[toolbar-mode="singleLineRibbon"] .smart-editor-toolbar .smart-editor-toolbar-tab-group {\r\n  padding-top: initial;\r\n}\r\n.smart-editor[toolbar-mode="singleLineRibbon"] .smart-editor-toolbar-tab-group {\r\n  position: relative;\r\n  display: flex;\r\n  align-items: center;\r\n  flex-wrap: wrap;\r\n  height: 100%;\r\n  padding: var(--smart-editor-toolbar-item-margin);\r\n  padding-bottom: initial;\r\n}\r\n.smart-editor[toolbar-mode="singleLineRibbon"] .smart-editor-toolbar-tab-group:not(:first-of-type) {\r\n  border-left: var(--smart-border-width) solid var(--smart-border);\r\n}\r\n.smart-editor[toolbar-view-mode="multiRow"] .smart-editor-toolbar, .smart-editor[toolbar-view-mode="scroll"] .smart-editor-toolbar {\r\n  grid-template-areas: \'primary primary\' \'secondary secondary \';\r\n}\r\n.smart-editor[toolbar-view-mode="multiRow"] .smart-editor-toolbar .smart-editor-toolbar-toggle-button, .smart-editor[toolbar-view-mode="scroll"] .smart-editor-toolbar .smart-editor-toolbar-toggle-button {\r\n  display: none;\r\n}\r\n.smart-editor[toolbar-view-mode="multiRow"] .smart-editor-toolbar-items-primary, .smart-editor[toolbar-view-mode="scroll"] .smart-editor-toolbar-items-primary {\r\n  padding: 0 5px 5px 0;\r\n}\r\n.smart-editor[toolbar-view-mode="multiRow"] .smart-editor-toolbar-items-primary .smart-editor-toolbar-item, .smart-editor[toolbar-view-mode="scroll"] .smart-editor-toolbar-items-primary .smart-editor-toolbar-item {\r\n  margin-bottom: initial;\r\n}\r\n.smart-editor[toolbar-view-mode="multiRow"] > .smart-container {\r\n  grid-template-rows: auto minmax(0, 1fr);\r\n}\r\n.smart-editor[toolbar-view-mode="multiRow"] .smart-editor-toolbar .smart-editor-toolbar-items-primary {\r\n  height: auto;\r\n}\r\n.smart-editor[toolbar-view-mode="scroll"] > .smart-container {\r\n  grid-template-rows: auto minmax(0, 1fr);\r\n}\r\n.smart-editor[toolbar-view-mode="scroll"] .smart-editor-toolbar-items-primary {\r\n  overflow-y: auto;\r\n}\r\n.smart-editor:not([animation="none"]) .smart-editor-toolbar-tab-selection-bar {\r\n  transition: width 0.2s cubic-bezier(0.35, 0, 0.25, 1), left 0.2s cubic-bezier(0.35, 0, 0.25, 1), visibility 0.2s cubic-bezier(0.35, 0, 0.25, 1), transform 0.2s cubic-bezier(0.35, 0, 0.25, 1);\r\n}\r\n.smart-editor:not([animation="none"]) .smart-editor-search-bar, .smart-editor:not([animation="none"])[toolbar-mode="singleLineRibbon"] .smart-editor-toolbar-items-secondary {\r\n  animation: smart-drop-down-list-smart-animate-opening 0.2s ease-out;\r\n  transition: animation 0.2s ease-out, opacity 0.2s ease-out, visibility 0.2s ease-out;\r\n  -webkit-transform-origin: top;\r\n  transform-origin: top;\r\n}\r\n.smart-editor:not([animation="none"]) .smart-editor-search-bar.smart-visibility-hidden, .smart-editor:not([animation="none"])[toolbar-mode="singleLineRibbon"] .smart-editor-toolbar-items-secondary.smart-visibility-hidden {\r\n  animation: smart-drop-down-list-smart-animate-closing 0.2s ease-in;\r\n  transition: animation 0.2s ease-in, opacity 0.2s ease-in, visibility 0.2s ease-in;\r\n}\r\n.smart-editor:not([animation="none"]) .smart-editor-toolbar:not(.smart-tooltip),\r\n.smart-editor:not([animation="none"]) .smart-editor-content-container {\r\n  transition: height 0.2s ease-in-out;\r\n}\r\n.smart-editor:not([animation="none"]) .smart-editor-toolbar-item,\r\n.smart-editor:not([animation="none"]) .smart-editor-toolbar-toggle-button {\r\n  transition: background-color 0.2ms linear, border-color 0.2ms ease-in-out, color 0.2ms linear, box-shadow 0.2s ease-in-out;\r\n}\r\n.smart-editor:not([animation="none"]) .smart-editor-toolbar-toggle-button::before {\r\n  transition: transform 0.2s ease-in-out;\r\n}\r\n.smart-editor[edit-mode="markdown"] .smart-editor-toolbar-item[item-name="alignment"], .smart-editor[edit-mode="markdown"] .smart-editor-toolbar-item[item-name="indent"], .smart-editor[edit-mode="markdown"] .smart-editor-toolbar-item[item-name="outdent"], .smart-editor[edit-mode="markdown"] .smart-editor-toolbar-item[item-name="lowercase"], .smart-editor[edit-mode="markdown"] .smart-editor-toolbar-item[item-name="uppercase"], .smart-editor[edit-mode="markdown"] .smart-editor-toolbar-item[item-name="removelink"] {\r\n  -moz-user-select: none;\r\n  -ms-user-select: none;\r\n  -webkit-user-select: none;\r\n  user-select: none;\r\n  opacity: 0.55;\r\n  cursor: default;\r\n  pointer-events: none;\r\n}\r\n.smart-editor.preview-mode .smart-editor-toolbar-item:not([item-name="print"]):not([item-name="sourcecode"]):not([item-name="fullscreen"]):not([item-name="splitmode"]) {\r\n  -moz-user-select: none;\r\n  -ms-user-select: none;\r\n  -webkit-user-select: none;\r\n  user-select: none;\r\n  opacity: 0.55;\r\n  cursor: default;\r\n  pointer-events: none;\r\n}\r\n.smart-editor[hide-toolbar] > .smart-container {\r\n  grid-template-rows: minmax(auto, 1fr);\r\n}\r\n.smart-editor[hide-toolbar] .smart-editor-toolbar:not(.smart-tooltip) {\r\n  display: none;\r\n}\r\n.smart-editor .smart-editor-toolbar:not(.smart-tooltip) {\r\n  width: 100%;\r\n  height: 100%;\r\n  border-bottom: var(--smart-border-width) solid var(--smart-border);\r\n  background: var(--smart-surface);\r\n  display: grid;\r\n  grid-template-areas: \'primary toggleButton\' \'secondary secondary \';\r\n  grid-template-columns: minmax(0, 1fr) auto;\r\n  overflow: hidden;\r\n  position: relative;\r\n}\r\n.smart-editor .smart-editor-toolbar:not(.smart-tooltip)[expanded] .smart-editor-toolbar-toggle-button::before {\r\n  transform: rotate(180deg);\r\n}\r\n.smart-editor .smart-editor-toolbar:not(.smart-tooltip) .smart-editor-toolbar-item {\r\n  margin-left: var(--smart-editor-toolbar-item-margin);\r\n  margin-top: var(--smart-editor-toolbar-item-margin);\r\n}\r\n.smart-editor[toolbar-sticky] .smart-editor-toolbar {\r\n  position: sticky;\r\n  top: 0;\r\n  z-index: calc(var(--smart-editor-drop-down-z-index) - 1);\r\n}\r\n.smart-editor[edit-mode="markdown"] .smart-editor-toolbar-item[item-name="sourcecode"]::before {\r\n  content: var(--smart-icon-visibility);\r\n}\r\n.smart-editor .smart-editor-toolbar-toggle-button {\r\n  grid-area: toggleButton;\r\n  width: var(--smart-editor-toolbar-button-width);\r\n  height: var(--smart-editor-toolbar-height);\r\n  position: relative;\r\n  cursor: pointer;\r\n}\r\n.smart-editor .smart-editor-toolbar-toggle-button::before {\r\n  font-size: var(--smart-font-size);\r\n  font-family: var(--smart-font-family-icon);\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  height: 100%;\r\n  box-sizing: border-box;\r\n  pointer-events: none;\r\n  content: var(--smart-icon-arrow-down);\r\n  width: var(--smart-editor-addon-width);\r\n  min-width: var(--smart-editor-addon-width);\r\n}\r\n.smart-editor .smart-editor-toolbar-items-primary {\r\n  grid-area: primary;\r\n  height: var(--smart-editor-toolbar-height);\r\n  overflow: hidden;\r\n}\r\n.smart-editor .smart-editor-toolbar-items-primary .smart-editor-toolbar-item {\r\n  margin-bottom: var(--smart-editor-toolbar-item-margin);\r\n}\r\n.smart-editor .smart-editor-toolbar-items-secondary {\r\n  grid-area: secondary;\r\n  padding-bottom: var(--smart-editor-toolbar-item-margin);\r\n}\r\n.smart-editor .smart-editor-toolbar-items-secondary:empty {\r\n  display: none;\r\n}\r\n.smart-editor .smart-editor-toolbar-items-primary,\r\n.smart-editor .smart-editor-toolbar-items-secondary {\r\n  width: 100%;\r\n  display: flex;\r\n  align-items: center;\r\n  flex-wrap: wrap;\r\n}\r\n.smart-editor iframe {\r\n  width: 100%;\r\n  height: 100%;\r\n  min-height: var(--smart-editor-input-min-height);\r\n  border: initial;\r\n}\r\n.smart-editor .smart-editor-content-container {\r\n  display: grid;\r\n  width: 100%;\r\n  height: 100%;\r\n  position: relative;\r\n  overflow: hidden;\r\n  outline: none;\r\n  background: transparent;\r\n}\r\n.smart-editor .smart-editor-content-container[split-mode] {\r\n  display: grid;\r\n  grid-template-columns: minmax(0, 1fr) var(--smart-border-width) minmax(0, 1fr);\r\n  grid-template-rows: 100%;\r\n  grid-column-gap: 2px;\r\n}\r\n.smart-editor .smart-editor-content-container[split-mode] .smart-editor-editable {\r\n  order: 1;\r\n}\r\n.smart-editor .smart-editor-content-container[split-mode]::before {\r\n  content: \'\';\r\n  width: 100%;\r\n  height: 100%;\r\n  background-color: var(--smart-border);\r\n  order: 2;\r\n}\r\n.smart-editor .smart-editor-content-container[split-mode] textarea {\r\n  order: 3;\r\n}\r\n.smart-editor .smart-editor-content-container textarea {\r\n  resize: none;\r\n  outline: none;\r\n  border: initial;\r\n  min-height: var(--smart-editor-input-min-height);\r\n  font-size: inherit;\r\n  font-family: inherit;\r\n  color: inherit;\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-editable {\r\n  min-height: var(--smart-editor-input-min-height);\r\n  overflow: auto;\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-editable[show-placeholder]::before {\r\n  content: attr(placeholder);\r\n  width: 100%;\r\n  height: 100%;\r\n  position: absolute;\r\n  pointer-events: none;\r\n  color: var(--smart-disabled-color);\r\n  opacity: 0.9;\r\n  font-family: inherit;\r\n  font-size: inherit;\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-editable p:first-child {\r\n  margin-top: 0;\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-editable p:last-child {\r\n  margin-bottom: 0;\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-editable a {\r\n  display: inline-block;\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-editable [alignment="left"] {\r\n  text-align: left;\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-editable [alignment="center"] {\r\n  text-align: center;\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-editable [alignment="right"] {\r\n  text-align: right;\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-editable [alignment="justify"] {\r\n  text-align: justify;\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-editable[table-cell-resize="horizontal"] {\r\n  cursor: col-resize;\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-editable[table-cell-resize="horizontal"] table {\r\n  overflow: hidden;\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-editable[table-cell-resize="horizontal"] th[resizing],\r\n.smart-editor .smart-editor-content-container .smart-editor-editable[table-cell-resize="horizontal"] td[resizing] {\r\n  position: relative;\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-editable[table-cell-resize="horizontal"] th[resizing]::after,\r\n.smart-editor .smart-editor-content-container .smart-editor-editable[table-cell-resize="horizontal"] td[resizing]::after {\r\n  content: \'\';\r\n  position: absolute;\r\n  right: 0;\r\n  display: flex;\r\n  width: var(--smart-border-width);\r\n  height: 100%;\r\n  transform: scaleY(100);\r\n  background-color: var(--smart-primary);\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-editable[table-cell-resize="vertical"] {\r\n  cursor: row-resize;\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-editable[table-cell-resize="vertical"] tr[resizing] > th,\r\n.smart-editor .smart-editor-content-container .smart-editor-editable[table-cell-resize="vertical"] tr[resizing] > td {\r\n  border-bottom-color: var(--smart-primary);\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-editable[contenteditable="true"] img {\r\n  cursor: pointer;\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-editable font:empty {\r\n  min-width: 1px;\r\n  min-height: 1px;\r\n  display: inline-block;\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-editable font:empty::before {\r\n  content: \'a\';\r\n  opacity: 0;\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-editable pre {\r\n  padding: 10px;\r\n  background: var(--smart-surface);\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-editable blockquote {\r\n  border-left: calc(2 * var(--smart-border-width)) solid var(--smart-border);\r\n  padding: 20px 10px;\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-editable .find-and-replace-match {\r\n  background-color: var(--smart-editor-highlight);\r\n  opacity: 0.75;\r\n  color: var(--smart-editor-highlight-color);\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-editable .find-and-replace-match.selected {\r\n  background-color: var(--smart-editor-highlight);\r\n  opacity: 1;\r\n}\r\n.smart-editor .smart-editor-content-container img,\r\n.smart-editor .smart-editor-content-container .smart-editor-video-container video,\r\n.smart-editor .smart-editor-content-container .smart-editor-video-container iframe {\r\n  float: initial;\r\n  vertical-align: initial;\r\n  margin: auto;\r\n  min-width: 10px;\r\n  min-height: 10px;\r\n}\r\n.smart-editor .smart-editor-content-container img[display="block"],\r\n.smart-editor .smart-editor-content-container .smart-editor-video-container video[display="block"],\r\n.smart-editor .smart-editor-content-container .smart-editor-video-container iframe[display="block"] {\r\n  display: block;\r\n}\r\n.smart-editor .smart-editor-content-container img[display="block"][alignment="left"],\r\n.smart-editor .smart-editor-content-container .smart-editor-video-container video[display="block"][alignment="left"],\r\n.smart-editor .smart-editor-content-container .smart-editor-video-container iframe[display="block"][alignment="left"] {\r\n  margin-left: 0;\r\n}\r\n.smart-editor .smart-editor-content-container img[display="block"][alignment="right"],\r\n.smart-editor .smart-editor-content-container .smart-editor-video-container video[display="block"][alignment="right"],\r\n.smart-editor .smart-editor-content-container .smart-editor-video-container iframe[display="block"][alignment="right"] {\r\n  margin-right: 0;\r\n}\r\n.smart-editor .smart-editor-content-container img[show-resize-frame],\r\n.smart-editor .smart-editor-content-container .smart-editor-video-container video[show-resize-frame],\r\n.smart-editor .smart-editor-content-container .smart-editor-video-container iframe[show-resize-frame] {\r\n  box-shadow: 0 0 0 var(--smart-border-width) var(--smart-primary);\r\n}\r\n.smart-editor .smart-editor-content-container img:not([display="block"])[alignment="left"],\r\n.smart-editor .smart-editor-content-container .smart-editor-video-container video:not([display="block"])[alignment="left"],\r\n.smart-editor .smart-editor-content-container .smart-editor-video-container iframe:not([display="block"])[alignment="left"] {\r\n  float: left;\r\n}\r\n.smart-editor .smart-editor-content-container img:not([display="block"])[alignment="right"],\r\n.smart-editor .smart-editor-content-container .smart-editor-video-container video:not([display="block"])[alignment="right"],\r\n.smart-editor .smart-editor-content-container .smart-editor-video-container iframe:not([display="block"])[alignment="right"] {\r\n  float: right;\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-search-bar {\r\n  position: absolute;\r\n  top: var(--smart-editor-search-bar-offset);\r\n  right: var(--smart-editor-search-bar-offset);\r\n  padding: var(--smart-editor-search-bar-padding);\r\n  display: grid;\r\n  grid-template-columns: minmax(0, 1fr) repeat(3, auto);\r\n  grid-column-gap: 5px;\r\n  border: var(--smart-border-width) solid var(--smart-border);\r\n  box-shadow: var(--smart-elevation-4);\r\n  background: var(--smart-background);\r\n  border-top-left-radius: var(--smart-border-top-left-radius);\r\n  border-top-right-radius: var(--smart-border-top-right-radius);\r\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\r\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-search-bar .smart-search-input-container {\r\n  width: var(--smart-text-box-default-width);\r\n  display: flex;\r\n  align-items: center;\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-search-bar .smart-search-input-container::after {\r\n  content: attr(selected) "/" attr(matches);\r\n  margin: 0 var(--smart-editor-search-bar-offset);\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-search-bar .smart-search-input {\r\n  height: 100%;\r\n  outline: none;\r\n  border: initial;\r\n  padding: var(--smart-editor-label-padding);\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-search-bar .smart-search-input:focus {\r\n  border-color: var(--smart-outline);\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-search-bar .smart-search-button {\r\n  --smart-button-padding: 0;\r\n  border: initial;\r\n  height: var(--smart-editor-toolbar-button-width);\r\n  width: var(--smart-editor-toolbar-button-width);\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-search-bar .smart-search-button button::after {\r\n  font-size: var(--smart-font-size);\r\n  font-family: var(--smart-font-family-icon);\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  box-sizing: border-box;\r\n  pointer-events: none;\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-search-bar .smart-search-button.prev button::after {\r\n  content: var(--smart-icon-arrow-up);\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-search-bar .smart-search-button.next button::after {\r\n  content: var(--smart-icon-arrow-down);\r\n}\r\n.smart-editor .smart-editor-content-container .smart-editor-search-bar .smart-search-button.close button::after {\r\n  content: var(--smart-icon-close);\r\n}\r\n.smart-editor[show-char-count] .smart-editor-content-container::after {\r\n  content: attr(char-count);\r\n  position: absolute;\r\n  display: flex;\r\n  justify-content: flex-end;\r\n  bottom: var(--smart-editor-char-counter-offset);\r\n  right: var(--smart-editor-char-counter-offset);\r\n  box-sizing: border-box;\r\n  background: var(--smart-background);\r\n  border-radius: var(--smart-border-radius);\r\n  background-clip: content-box;\r\n  -webkit-background-clip: content-box;\r\n  font-family: inherit;\r\n  font-size: inherit;\r\n  pointer-events: none;\r\n  -moz-user-select: none;\r\n  -ms-user-select: none;\r\n  -webkit-user-select: none;\r\n  user-select: none;\r\n}\r\n.smart-editor[show-char-count] .smart-editor-content-container.char-count-error::after {\r\n  color: var(--smart-error);\r\n}\r\n.smart-editor[show-char-count] .smart-editor-content-container.char-count-warning::after {\r\n  color: var(--smart-warning);\r\n}\r\n.smart-editor[edit-mode="markdown"] .smart-editor-content-container[split-mode] .smart-editor-editable {\r\n  order: 3;\r\n}\r\n.smart-editor[edit-mode="markdown"] .smart-editor-content-container[split-mode] textarea {\r\n  order: 1;\r\n}\r\n.smart-editor .smart-editor-resize-frame {\r\n  -moz-user-select: none;\r\n  -ms-user-select: none;\r\n  -webkit-user-select: none;\r\n  user-select: none;\r\n  position: absolute;\r\n}\r\n.smart-editor .smart-editor-resize-frame span {\r\n  cursor: pointer;\r\n  position: absolute;\r\n  width: 10px;\r\n  height: 10px;\r\n  background: var(--smart-primary);\r\n  transform: translate(-50%, -50%);\r\n}\r\n.smart-editor .smart-editor-resize-frame span[position="top-left"], .smart-editor .smart-editor-resize-frame span[position="bottom-right"] {\r\n  cursor: se-resize;\r\n}\r\n.smart-editor .smart-editor-resize-frame span[position="top-right"], .smart-editor .smart-editor-resize-frame span[position="bottom-left"] {\r\n  cursor: sw-resize;\r\n}\r\n.smart-editor .smart-editor-resize-frame span[position="top-center"], .smart-editor .smart-editor-resize-frame span[position="bottom-center"] {\r\n  cursor: ns-resize;\r\n}\r\n.smart-editor .smart-editor-resize-frame span[position="left-center"], .smart-editor .smart-editor-resize-frame span[position="right-center"] {\r\n  cursor: ew-resize;\r\n}\r\n.smart-editor .smart-editor-image-container {\r\n  display: inline-block;\r\n}\r\n.smart-editor .smart-editor-image-container.smart-editor-video-container {\r\n  position: relative;\r\n}\r\n.smart-editor .smart-editor-image-container.smart-editor-video-container .smart-editor-video-white-space {\r\n  position: absolute;\r\n  opacity: 0;\r\n}\r\n.smart-editor .smart-editor-image-container.smart-editor-video-container[dragged]::before {\r\n  content: \'\';\r\n  position: absolute;\r\n  width: 100%;\r\n  height: 100%;\r\n  top: 0;\r\n  left: 0;\r\n}\r\n.smart-editor .smart-editor-image-container.smart-editor-video-container video,\r\n.smart-editor .smart-editor-image-container.smart-editor-video-container iframe {\r\n  width: 100%;\r\n  height: 100%;\r\n}\r\n.smart-editor .smart-editor-image-container.smart-editor-video-container > br[class] {\r\n  display: none;\r\n}\r\n.smart-editor .smart-editor-image-container.smart-editor-video-container::after {\r\n  content: var(--smart-icon-menu);\r\n  position: absolute;\r\n  font-family: var(--smart-font-family-icon);\r\n  font-size: var(--smart-font-size);\r\n  width: var(--smart-editor-toolbar-item-height);\r\n  height: var(--smart-editor-toolbar-item-height);\r\n  top: 0;\r\n  left: calc(50% - var(--smart-editor-toolbar-item-height)/2);\r\n  background: var(--smart-background);\r\n  border-radius: 50%;\r\n  display: inline-flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  visibility: hidden;\r\n  transform-origin: top;\r\n  transform: scale(0) translateY(-100%);\r\n  transition: transform 0.2s ease-in-out, visibility 0.2s ease-in-out;\r\n}\r\n.smart-editor .smart-editor-image-container.smart-editor-video-container:hover::after {\r\n  visibility: visible;\r\n  transform: scale(1) translateY(25%);\r\n}\r\n.smart-editor .smart-editor-image-container[display="block"] {\r\n  display: block;\r\n}\r\n.smart-editor .smart-editor-image-container[display="block"][alignment="left"] img {\r\n  margin-left: 0;\r\n}\r\n.smart-editor .smart-editor-image-container[display="block"][alignment="left"] .smart-editor-image-caption {\r\n  text-align: left;\r\n}\r\n.smart-editor .smart-editor-image-container[display="block"][alignment="right"] img {\r\n  margin-right: 0;\r\n}\r\n.smart-editor .smart-editor-image-container[display="block"][alignment="right"] .smart-editor-image-caption {\r\n  text-align: right;\r\n}\r\n.smart-editor .smart-editor-image-container:not([display="block"])[alignment="left"] {\r\n  float: left;\r\n}\r\n.smart-editor .smart-editor-image-container:not([display="block"])[alignment="right"] {\r\n  float: right;\r\n}\r\n.smart-editor .smart-editor-image-container .smart-editor-image-caption {\r\n  display: block;\r\n  text-align: center;\r\n  outline: none;\r\n}\r\n.smart-editor table {\r\n  width: 100%;\r\n  border-collapse: collapse;\r\n  empty-cells: show;\r\n  border-spacing: 0;\r\n  table-layout: fixed;\r\n}\r\n.smart-editor table td,\r\n.smart-editor table th {\r\n  border: var(--smart-border-width) solid var(--smart-border);\r\n  width: var(--smart-editor-table-column-width);\r\n  min-height: var(--smart-editor-table-cell-min-height);\r\n  min-width: var(--smart-editor-table-cell-min-width);\r\n  padding: 2px 5px;\r\n  vertical-align: middle;\r\n}\r\n.smart-editor table img {\r\n  max-width: 100%;\r\n}\r\n.smart-editor table table {\r\n  width: 100%;\r\n}\r\n.smart-editor table th {\r\n  background: var(--smart-surface);\r\n}\r\n.smart-editor table th:empty::before,\r\n.smart-editor table td:empty::before {\r\n  content: \'A\';\r\n  visibility: hidden;\r\n}\r\n.smart-editor table[dashed-borders] th, .smart-editor table[dashed-borders] td {\r\n  border-style: dashed;\r\n}\r\n.smart-editor table[alternation] tr:nth-child(2n) {\r\n  background-color: var(--smart-alternation-index0-background);\r\n}\r\n.smart-editor table [selected] {\r\n  box-shadow: 0 0 0 var(--smart-border-width) var(--smart-primary) inset;\r\n}\r\n.smart-editor[focus] .smart-editor-toolbar-item[item-type="button"][checked] {\r\n  color: var(--smart-ui-state-color-active);\r\n  border-color: var(--smart-ui-state-border-active);\r\n  background-color: var(--smart-ui-state-active);\r\n}\r\n\r\n.smart-editor-toolbar-item {\r\n  overflow: hidden;\r\n  text-overflow: ellipsis;\r\n  white-space: nowrap;\r\n  position: relative;\r\n  border-radius: var(--smart-editor-toolbar-item-border-radius);\r\n  cursor: pointer;\r\n}\r\n.smart-editor-toolbar-item:not([item-type="custom"]):hover {\r\n  color: var(--smart-ui-state-color-hover);\r\n  border-color: var(--smart-ui-state-border-hover);\r\n  background-color: var(--smart-ui-state-hover);\r\n  box-shadow: var(--smart-elevation-1);\r\n}\r\n.smart-editor-toolbar-item:not([item-type="custom"]):not([item-type="color-input"]):not([disabled]):active {\r\n  color: var(--smart-ui-state-color-active);\r\n  border-color: var(--smart-ui-state-border-active);\r\n  background-color: var(--smart-ui-state-active);\r\n}\r\n.smart-editor-toolbar-item[item-name="bold"]::before {\r\n  content: var(--smart-icon-bold);\r\n}\r\n.smart-editor-toolbar-item[item-name="italic"]::before {\r\n  content: var(--smart-icon-italic);\r\n}\r\n.smart-editor-toolbar-item[item-name="underline"]::before {\r\n  content: var(--smart-icon-underline);\r\n}\r\n.smart-editor-toolbar-item[item-name="strikethrough"]::before {\r\n  content: var(--smart-icon-strike-through);\r\n}\r\n.smart-editor-toolbar-item[item-name="caption"]::before {\r\n  content: var(--smart-icon-format-clear);\r\n}\r\n.smart-editor-toolbar-item[item-name="orderedlist"]::before {\r\n  content: var(--smart-icon-list-ordered);\r\n}\r\n.smart-editor-toolbar-item[item-name="unorderedlist"]::before {\r\n  content: var(--smart-icon-list-unordered);\r\n}\r\n.smart-editor-toolbar-item[item-name="subscript"]::before {\r\n  content: var(--smart-icon-subscript);\r\n}\r\n.smart-editor-toolbar-item[item-name="superscript"]::before {\r\n  content: var(--smart-icon-superscript);\r\n}\r\n.smart-editor-toolbar-item .smart-editor-item-action-button[item-name="backgroundcolor"]::before {\r\n  content: var(--smart-icon-color-background);\r\n}\r\n.smart-editor-toolbar-item .smart-editor-item-action-button[item-name="fontcolor"]::before {\r\n  content: var(--smart-icon-font);\r\n}\r\n.smart-editor-toolbar-item[item-name="delete"]::before {\r\n  content: var(--smart-icon-delete);\r\n}\r\n.smart-editor-toolbar-item[item-name="redo"]::before {\r\n  content: var(--smart-icon-reload);\r\n}\r\n.smart-editor-toolbar-item[item-name="undo"]::before {\r\n  content: var(--smart-icon-reload);\r\n}\r\n.smart-editor-toolbar-item[item-name="indent"]::before {\r\n  content: var(--smart-icon-indent-left);\r\n}\r\n.smart-editor-toolbar-item[item-name="outdent"]::before {\r\n  content: var(--smart-icon-indent-right);\r\n}\r\n.smart-editor-toolbar-item[item-name="createlink"]::before {\r\n  content: var(--smart-icon-link);\r\n}\r\n.smart-editor-toolbar-item[item-name="removelink"]::before {\r\n  content: var(--smart-icon-unlink);\r\n}\r\n.smart-editor-toolbar-item[item-name="hyperlink"]::before {\r\n  content: var(--smart-icon-link);\r\n}\r\n.smart-editor-toolbar-item[item-name="openlink"]::before {\r\n  content: var(--smart-icon-link-ext);\r\n}\r\n.smart-editor-toolbar-item[item-name="editlink"]::before {\r\n  content: var(--smart-icon-mode-edit);\r\n}\r\n.smart-editor-toolbar-item[item-name="image"]::before {\r\n  content: var(--smart-icon-image);\r\n}\r\n.smart-editor-toolbar-item[item-name="table"]::before {\r\n  content: var(--smart-icon-table);\r\n}\r\n.smart-editor-toolbar-item[item-name="lowercase"]::before {\r\n  content: var(--smart-icon-case-lower);\r\n}\r\n.smart-editor-toolbar-item[item-name="uppercase"]::before {\r\n  content: var(--smart-icon-case-upper);\r\n}\r\n.smart-editor-toolbar-item[item-name="print"]::before {\r\n  content: var(--smart-icon-print);\r\n}\r\n.smart-editor-toolbar-item[item-name="copy"]::before {\r\n  content: var(--smart-icon-copy-record);\r\n}\r\n.smart-editor-toolbar-item[item-name="paste"]::before {\r\n  content: var(--smart-icon-paste);\r\n}\r\n.smart-editor-toolbar-item[item-name="cut"]::before {\r\n  content: var(--smart-icon-cut);\r\n  transform: rotate(-90deg);\r\n}\r\n.smart-editor-toolbar-item[item-name="clearformat"]::before {\r\n  content: var(--smart-icon-format-clear);\r\n}\r\n.smart-editor-toolbar-item[item-name="fullscreen"]::before {\r\n  content: var(--smart-icon-resize-full);\r\n}\r\n.smart-editor-toolbar-item[item-name="sourcecode"]::before {\r\n  content: var(--smart-icon-source-code);\r\n}\r\n.smart-editor-toolbar-item[item-name="preview"]::before {\r\n  content: var(--smart-icon-visibility);\r\n}\r\n.smart-editor-toolbar-item[item-name="splitmode"]::before {\r\n  content: var(--smart-icon-split-mode);\r\n}\r\n.smart-editor-toolbar-item[item-name="tableheader"]::before {\r\n  content: var(--smart-icon-header);\r\n}\r\n.smart-editor-toolbar-item[item-name="tablerows"]::before {\r\n  content: var(--smart-icon-row);\r\n}\r\n.smart-editor-toolbar-item[item-name="tablecolumns"]::before {\r\n  content: var(--smart-icon-column);\r\n}\r\n.smart-editor-toolbar-item[item-name="tablevalign"]::before {\r\n  content: var(--smart-icon-vertical-align);\r\n}\r\n.smart-editor-toolbar-item[item-name="tablestyle"]::before {\r\n  content: var(--smart-icon-styles);\r\n}\r\n.smart-editor-toolbar-item[item-name="findandreplace"]::before {\r\n  content: var(--smart-icon-search);\r\n}\r\n.smart-editor-toolbar-item[item-name="video"]::before {\r\n  content: var(--smart-icon-video);\r\n}\r\n.smart-editor-toolbar-item[item-name="redo"]::before {\r\n  transform: scaleX(-1);\r\n}\r\n.smart-editor-toolbar-item[item-name="caption"]::before {\r\n  font-weight: 600;\r\n}\r\n.smart-editor-toolbar-item[item-name="clearformat"]::before {\r\n  font-style: italic;\r\n  font-weight: 600;\r\n}\r\n.smart-editor-toolbar-item[item-name="clearformat"]::after {\r\n  content: \'-\';\r\n  position: absolute;\r\n  top: 0;\r\n  font-weight: 600;\r\n  transform: scaleX(1.5);\r\n}\r\n.smart-editor-toolbar-item[item-name="alignment"][item-value="left"]::before {\r\n  content: var(--smart-icon-align-left);\r\n}\r\n.smart-editor-toolbar-item[item-name="alignment"][item-value="center"]::before {\r\n  content: var(--smart-icon-align-center);\r\n}\r\n.smart-editor-toolbar-item[item-name="alignment"][item-value="right"]::before {\r\n  content: var(--smart-icon-align-right);\r\n}\r\n.smart-editor-toolbar-item[item-name="alignment"][item-value="justify"]::before {\r\n  content: var(--smart-icon-align-justify);\r\n}\r\n.smart-editor-toolbar-item[item-type="toggle"][checked] {\r\n  color: var(--smart-ui-state-color-active);\r\n  border-color: var(--smart-ui-state-border-active);\r\n  background-color: var(--smart-ui-state-active);\r\n}\r\n.smart-editor-toolbar-item[item-type="button"], .smart-editor-toolbar-item[item-type="toggle"] {\r\n  width: var(--smart-editor-toolbar-button-width);\r\n}\r\n.smart-editor-toolbar-item[item-type="drop-down"], .smart-editor-toolbar-item[item-type="color-input"] {\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: space-between;\r\n  width: var(--smart-editor-toolbar-drop-down-width-small);\r\n}\r\n.smart-editor-toolbar-item[item-type="drop-down"][item-name="fontname"], .smart-editor-toolbar-item[item-type="drop-down"][item-name="formats"] {\r\n  width: var(--smart-editor-toolbar-drop-down-width-large);\r\n}\r\n.smart-editor-toolbar-item[item-type="drop-down"][item-name="tablerows"]:before {\r\n  transform: rotate(90deg);\r\n  padding: var(--smart-editor-label-padding);\r\n  padding-left: initial;\r\n  padding-right: initial;\r\n  padding-top: initial;\r\n}\r\n.smart-editor-toolbar-item[item-type="color-input"] .smart-editor-item-action-button {\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  position: relative;\r\n  width: calc(100% - var(--smart-editor-addon-width));\r\n  height: 100%;\r\n  min-width: var(--smart-editor-addon-width);\r\n  padding: var(--smart-editor-label-padding);\r\n  padding-top: initial;\r\n  padding-bottom: initial;\r\n}\r\n.smart-editor-toolbar-item[item-type="color-input"] .smart-editor-item-action-button::before {\r\n  font-size: var(--smart-font-size);\r\n  font-family: var(--smart-font-family-icon);\r\n  border-bottom: calc(3 * var(--smart-border-width)) solid var(--item-value);\r\n}\r\n.smart-editor-toolbar-item[item-type="color-input"] .smart-editor-item-drop-down-button {\r\n  position: relative;\r\n  height: 100%;\r\n}\r\n.smart-editor-toolbar-item[item-type="custom"] > :first-child {\r\n  width: 100%;\r\n  height: var(--smart-editor-toolbar-item-height);\r\n}\r\n.smart-editor-toolbar-item .smart-editor-item-action-button:hover,\r\n.smart-editor-toolbar-item .smart-editor-item-drop-down-button:hover {\r\n  color: var(--smart-ui-state-color-hover);\r\n  border-color: var(--smart-ui-state-border-hover);\r\n  background-color: var(--smart-ui-state-hover);\r\n  border-color: var(--smart-ui-state-focus);\r\n  background-color: var(--smart-ui-state-focus);\r\n}\r\n.smart-editor-toolbar-item .smart-editor-item-action-button:not([disabled]):active,\r\n.smart-editor-toolbar-item .smart-editor-item-drop-down-button:not([disabled]):active {\r\n  color: var(--smart-ui-state-color-active);\r\n  border-color: var(--smart-ui-state-border-active);\r\n  background-color: var(--smart-ui-state-active);\r\n}\r\n.smart-editor-toolbar-item[item-type="delimiter"] {\r\n  width: var(--smart-editor-toolbar-delimiter-width);\r\n  pointer-events: none;\r\n}\r\n.smart-editor-toolbar-item[item-type="delimiter"]::before {\r\n  content: attr(item-name);\r\n  transform: scaleY(1.5);\r\n  min-width: initial;\r\n}\r\n.smart-editor-toolbar-item .smart-ripple {\r\n  background-color: var(--smart-background-color);\r\n}\r\n.smart-editor-toolbar-item .smart-editor-item-drop-down {\r\n  position: absolute;\r\n  top: 0;\r\n  left: 0;\r\n  visibility: hidden;\r\n}\r\n\r\n/* --- Editor Color Input --- */\r\n.smart-color-input-drop-down-menu.smart-editor-color-input .grid-samples-container {\r\n  grid-template-columns: repeat(2, minmax(0, 1fr));\r\n}\r\n.smart-color-input-drop-down-menu.smart-editor-color-input:not([animation="none"]) .default-samples-container div {\r\n  transition: transform 0.2s ease-in-out;\r\n}\r\n.smart-color-input-drop-down-menu.smart-editor-color-input .default-samples-container div {\r\n  position: relative;\r\n  border-radius: 50%;\r\n  border: initial;\r\n  transform: scale(0.95);\r\n}\r\n.smart-color-input-drop-down-menu.smart-editor-color-input .default-samples-container div.selected {\r\n  transform: scale(1);\r\n}\r\n.smart-color-input-drop-down-menu.smart-editor-color-input .default-samples-container div.selected:not(.no-color):after {\r\n  content: var(--smart-icon-check);\r\n  width: 100%;\r\n  height: 100%;\r\n  position: absolute;\r\n  top: 0;\r\n  left: 0;\r\n  display: flex;\r\n  justify-content: center;\r\n  align-items: center;\r\n  font-family: var(--smart-font-family-icon);\r\n  color: var(--smart-secondary-color);\r\n  border-radius: inherit;\r\n}\r\n\r\n.smart-editor-color-input {\r\n  --smart-input-drop-down-menu-width: auto;\r\n}\r\n\r\n.smart-editor-color-input.smart-color-input-drop-down-menu .default-samples-container div.selected[value="#FFFFFF"]::after {\r\n  border: var(--smart-border-width) solid var(--smart-border);\r\n  color: var(--smart-ui-state-color-hover);\r\n  box-sizing: border-box;\r\n}\r\n\r\n/* --- Editor Input Drop Down --- */\r\n.smart-editor-input li .editor-icon::before {\r\n  font-size: var(--smart-font-size);\r\n  font-family: var(--smart-font-family-icon);\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  position: absolute;\r\n  left: 0;\r\n  width: var(--smart-column-icon-size);\r\n  line-height: 1rem;\r\n}\r\n.smart-editor-input li[value="left"] .editor-icon::before {\r\n  content: var(--smart-icon-align-left);\r\n}\r\n.smart-editor-input li[value="center"] .editor-icon::before {\r\n  content: var(--smart-icon-align-center);\r\n}\r\n.smart-editor-input li[value="right"] .editor-icon::before {\r\n  content: var(--smart-icon-align-right);\r\n}\r\n.smart-editor-input li[value="justify"] .editor-icon::before {\r\n  content: var(--smart-icon-align-justify);\r\n}\r\n.smart-editor-input li[value="insertRowBefore"] .editor-icon::before {\r\n  content: var(--smart-icon-row-before);\r\n}\r\n.smart-editor-input li[value="insertRowAfter"] .editor-icon::before {\r\n  content: var(--smart-icon-row-after);\r\n  transform: rotate(180deg);\r\n}\r\n.smart-editor-input li[value="deleteRow"] .editor-icon::before {\r\n  content: var(--smart-icon-row-delete);\r\n}\r\n.smart-editor-input li[value="insertColumnLeft"] .editor-icon::before {\r\n  content: var(--smart-icon-column-left);\r\n  transform: rotate(-90deg);\r\n}\r\n.smart-editor-input li[value="insertColumnRight"] .editor-icon::before {\r\n  content: var(--smart-icon-column-right);\r\n  transform: rotate(90deg);\r\n}\r\n.smart-editor-input li[value="deleteColumn"] .editor-icon::before {\r\n  content: var(--smart-icon-column-delete);\r\n}\r\n.smart-editor-input li[value="h1"] a {\r\n  font-size: 1.5rem;\r\n  font-weight: bold;\r\n}\r\n.smart-editor-input li[value="h2"] a {\r\n  font-size: 1.3rem;\r\n  font-weight: bold;\r\n}\r\n.smart-editor-input li[value="h3"] a {\r\n  font-size: 1.1rem;\r\n  font-weight: bold;\r\n}\r\n.smart-editor-input li[value="h4"] a {\r\n  font-size: 0.9rem;\r\n  font-weight: bold;\r\n}\r\n.smart-editor-input li[value="segueUi"] a {\r\n  font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;\r\n}\r\n.smart-editor-input li[value="arial"] a {\r\n  font-family: Arial, Helvetica, sans-serif;\r\n}\r\n.smart-editor-input li[value="georgia"] a {\r\n  font-family: Georgia, "Times New Roman", Times, serif;\r\n}\r\n.smart-editor-input li[value="impact"] a {\r\n  font-family: Impact, Haettenschweiler, "Arial Narrow Bold", sans-serif;\r\n}\r\n.smart-editor-input li[value="tahoma"] a {\r\n  font-family: Tahoma, Geneva, Verdana, sans-serif;\r\n}\r\n.smart-editor-input li[value="timesnewRoman"] a {\r\n  font-family: "Times New Roman", Times, serif;\r\n}\r\n.smart-editor-input li[value="verdana"] a {\r\n  font-family: Verdana, Geneva, Tahoma, sans-serif;\r\n}\r\n\r\n/* --- Editor Window --- */\r\n.smart-editor-window {\r\n  --smart-window-default-width: auto;\r\n  --smart-window-default-height: auto;\r\n  --smart-window-header-height: var(--smart-editor-window-header-height);\r\n  --smart-window-footer-height: var(--smart-editor-window-footer-height);\r\n  --smart-window-header-footer-padding: 10px;\r\n  --smart-window-header-background: transparent;\r\n  --smart-window-footer-padding: 10px;\r\n  --smart-window-content-padding: 20px;\r\n  max-width: 95vw;\r\n  max-height: 95vh;\r\n}\r\n.smart-editor-window.smart-window .smart-content-container > .smart-content {\r\n  padding: initial;\r\n  align-items: flex-start;\r\n}\r\n.smart-editor-window .smart-editor-window-button {\r\n  width: 100%;\r\n  height: 100%;\r\n  --smart-button-padding: 0.2rem 16px;\r\n}\r\n.smart-editor-window .smart-editor-window-button:not(:last-of-type) {\r\n  margin-right: 2.5%;\r\n}\r\n.smart-editor-window .smart-editor-window-content-wrapper {\r\n  grid-template-rows: auto minmax(auto, 1fr);\r\n  padding: var(--smart-window-content-padding);\r\n  width: 100%;\r\n}\r\n.smart-editor-window .smart-editor-window-content-wrapper > div {\r\n  display: grid;\r\n  width: var(--smart-box-width);\r\n  grid-row-gap: 10px;\r\n  justify-content: center;\r\n  grid-template-columns: 100%;\r\n}\r\n.smart-editor-window .smart-editor-window-editor {\r\n  display: grid;\r\n  grid-row-gap: 5px;\r\n  grid-column-gap: 10px;\r\n}\r\n.smart-editor-window .smart-editor-window-editor > .smart-input,\r\n.smart-editor-window .smart-editor-window-editor > .smart-list-box {\r\n  width: 100%;\r\n}\r\n.smart-editor-window .smart-editor-window-editor > .smart-check-box {\r\n  width: max-content;\r\n}\r\n.smart-editor-window .smart-editor-window-editor[multiple] .smart-editor-window-editor {\r\n  grid-template-columns: repeat(2, minmax(0, 1fr));\r\n}\r\n.smart-editor-window .smart-editor-window-editor[type="results"] label {\r\n  display: flex;\r\n  justify-content: space-between;\r\n}\r\n.smart-editor-window .smart-editor-window-editor[type="results"] label[matches]::after {\r\n  content: attr(selected) " of " attr(matches);\r\n}\r\n.smart-editor-window .smart-editor-window-editor[type="file"] .smart-drop-zone {\r\n  width: 100%;\r\n  height: 100px;\r\n  border: calc(2 * var(--smart-border-width)) dashed var(--smart-border);\r\n  border-radius: var(--smart-border-radius);\r\n}\r\n.smart-editor-window .smart-editor-window-editor[type="file"] .smart-file-upload {\r\n  --smart-file-upload-drop-zone-height: 100px;\r\n  width: 100%;\r\n  order: 1;\r\n  min-height: initial;\r\n}\r\n.smart-editor-window .smart-editor-window-editor[type="file"] .smart-file-upload .smart-browse-button {\r\n  margin: initial;\r\n}\r\n.smart-editor-window .smart-editor-window-editor[type="file"] .smart-file-upload .smart-item-upload-button {\r\n  display: none;\r\n}\r\n.smart-editor-window .smart-editor-window-editor[type="file"] .smart-file-upload .smart-file-upload-header {\r\n  margin-bottom: 5px;\r\n  padding: initial;\r\n}\r\n.smart-editor-window .smart-editor-window-editor[type="file"] .smart-file-upload .smart-file-upload-container {\r\n  padding: initial;\r\n}\r\n.smart-editor-window .smart-editor-window-editor[type="file"] .smart-file-upload .smart-selected-files {\r\n  padding: initial;\r\n}\r\n.smart-editor-window .smart-editor-window-editor[type="file"] .smart-file-upload .smart-selected-files .smart-file {\r\n  display: flex;\r\n  margin: initial;\r\n  border: var(--smart-border-width) solid var(--smart-border);\r\n  border-radius: var(--smart-border-radius);\r\n}\r\n.smart-editor-window .smart-editor-window-editor[type="file"] .smart-file-upload .smart-selected-files .smart-item-upload-button:after,\r\n.smart-editor-window .smart-editor-window-editor[type="file"] .smart-file-upload .smart-selected-files .smart-item-pause-button:after,\r\n.smart-editor-window .smart-editor-window-editor[type="file"] .smart-file-upload .smart-selected-files .smart-item-cancel-button:after {\r\n  position: initial;\r\n  left: initial;\r\n  top: initial;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n}\r\n.smart-editor-window .smart-editor-window-editor[type="file"] .smart-file-upload .smart-selected-files .smart-item-name {\r\n  width: 100%;\r\n}\r\n\r\n/* --- Editor Tooltip --- */\r\n.smart-tooltip .smart-tooltip-content {\r\n  display: flex;\r\n  background-color: var(--smart-background);\r\n  color: var(--smart-background-color);\r\n  border-color: var(--smart-background);\r\n  opacity: initial;\r\n}\r\n.smart-tooltip.smart-editor-context-menu:not([animation="none"]) {\r\n  transition: opacity 0.2s ease-in, visibility 0.2s ease-in, transform 0.2s ease-in;\r\n}\r\n.smart-tooltip.smart-editor-toolbar {\r\n  --smart-tooltip-padding: 5px;\r\n  --smart-tooltip-arrow-color: var(--smart-surface);\r\n}\r\n.smart-tooltip.smart-editor-toolbar .smart-tooltip-content {\r\n  background-color: var(--smart-surface);\r\n  color: var(--smart-surface-color);\r\n  border-color: var(--smart-surface);\r\n}\r\n.smart-tooltip.smart-editor-toolbar.smart-editor-inline-toolbar .smart-tooltip-content {\r\n  max-width: var(--smart-editor-inline-toolbar-max-width);\r\n  flex-wrap: wrap;\r\n}\r\n.smart-tooltip.smart-editor-toolbar:not([animation="none"]) .smart-editor-toolbar-item {\r\n  transition: background-color 0.2ms linear, border-color 0.2ms ease-in-out, color 0.2ms linear, box-shadow 0.2s ease-in-out;\r\n}\r\n.smart-tooltip.smart-editor-toolbar:not(.smart-editor-drop-down-toolbar) .smart-editor-toolbar-item:not(:first-of-type) {\r\n  margin-left: var(--smart-editor-toolbar-item-margin);\r\n}\r\n.smart-tooltip.smart-editor-context-menu {\r\n  opacity: 0.2;\r\n  transform: scale(0);\r\n  -webkit-transform-origin: 0 0;\r\n  transform-origin: 0 0;\r\n}\r\n.smart-tooltip.smart-editor-context-menu[visible] {\r\n  opacity: 1;\r\n  transform: scale(1);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container {\r\n  width: 100%;\r\n  height: 100%;\r\n  display: grid;\r\n  align-items: center;\r\n  justify-content: flex-start;\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item {\r\n  -moz-user-select: none;\r\n  -ms-user-select: none;\r\n  -webkit-user-select: none;\r\n  user-select: none;\r\n  height: var(--smart-list-item-height);\r\n  padding: var(--smart-list-item-padding);\r\n  border-top-left-radius: var(--smart-item-border-top-left-radius);\r\n  border-top-right-radius: var(--smart-item-border-top-right-radius);\r\n  border-bottom-left-radius: var(--smart-item-border-bottom-left-radius);\r\n  border-bottom-right-radius: var(--smart-item-border-bottom-right-radius);\r\n  white-space: nowrap;\r\n  text-overflow: ellipsis;\r\n  background: var(--smart-background);\r\n  color: var(--smart-background-color);\r\n  display: flex;\r\n  align-items: center;\r\n  position: relative;\r\n  padding-left: var(--smart-column-icon-size);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item::before {\r\n  font-size: var(--smart-font-size);\r\n  font-family: var(--smart-font-family-icon);\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  position: absolute;\r\n  left: 0;\r\n  width: var(--smart-column-icon-size);\r\n  line-height: 1rem;\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="insertRowBefore"]::before {\r\n  content: var(--smart-icon-row-before);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="insertRowAfter"]::before {\r\n  content: var(--smart-icon-row-after);\r\n  transform: rotate(180deg);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="deleteRow"]::before {\r\n  content: var(--smart-icon-row-delete);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="insertColumnLeft"]::before {\r\n  content: var(--smart-icon-column-left);\r\n  transform: rotate(-90deg);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="insertColumnRight"]::before {\r\n  content: var(--smart-icon-column-right);\r\n  transform: rotate(90deg);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="deleteColumn"]::before {\r\n  content: var(--smart-icon-column-delete);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="tableProperties"]::before {\r\n  content: var(--smart-icon-table);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="imageProperties"]::before {\r\n  content: var(--smart-icon-image);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="linkProperties"]::before {\r\n  content: var(--smart-icon-link);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="videoProperties"]::before {\r\n  content: var(--smart-icon-link);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="deleteTable"]::before {\r\n  content: var(--smart-icon-delete);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="copyImage"]::before {\r\n  content: var(--smart-icon-copy-record);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="copyVideo"]::before {\r\n  content: var(--smart-icon-copy-record);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="cutImage"]::before {\r\n  content: var(--smart-icon-cut);\r\n  transform: rotate(-90deg);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="cutVideo"]::before {\r\n  content: var(--smart-icon-cut);\r\n  transform: rotate(-90deg);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="deleteImage"]::before {\r\n  content: var(--smart-icon-delete);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="deleteVideo"]::before {\r\n  content: var(--smart-icon-delete);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="deleteLink"]::before {\r\n  content: var(--smart-icon-delete);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="createLink"]::before {\r\n  content: var(--smart-icon-link);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="deleteLink"]::before {\r\n  content: var(--smart-icon-unlink);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="caption"]::before {\r\n  content: var(--smart-icon-format-clear);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="selectAll"]::before {\r\n  content: var(--smart-icon-group);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="cut"]::before {\r\n  content: var(--smart-icon-cut);\r\n  transform: rotate(-90deg);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="copy"]::before {\r\n  content: var(--smart-icon-copy-record);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[value="paste"]::before {\r\n  content: var(--smart-icon-paste);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item:hover {\r\n  background: var(--smart-ui-state-hover);\r\n  color: var(--smart-ui-state-color-hover);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[selected] {\r\n  background-color: var(--smart-ui-state-selected);\r\n  border-color: var(--smart-ui-state-border-selected);\r\n  color: var(--smart-ui-state-color-selected);\r\n}\r\n.smart-tooltip .smart-editor-context-menu-item-container .smart-editor-context-menu-item[disabled] {\r\n  opacity: 0.55;\r\n  cursor: default;\r\n  pointer-events: none;\r\n}\r\n\r\n.smart-editor-drop-down-toolbar:not([animation="none"]) {\r\n  animation: smart-drop-down-list-smart-animate-closing 0.2s ease-in;\r\n  transition: animation 0.2s ease-in, opacity 0.2s ease-in, visibility 0.2s ease-in;\r\n}\r\n.smart-editor-drop-down-toolbar:not([animation="none"])[visible] {\r\n  animation: smart-drop-down-list-smart-animate-opening 0.2s ease-out;\r\n  transition: animation 0.2s ease-out, opacity 0.2s ease-out, visibility 0.2s ease-out;\r\n}\r\n.smart-editor-drop-down-toolbar:not([arrow-direction]), .smart-editor-drop-down-toolbar[arrow-direction="bottom"] {\r\n  -webkit-transform-origin: bottom;\r\n  transform-origin: bottom;\r\n}\r\n.smart-editor-drop-down-toolbar:not([arrow]), .smart-editor-drop-down-toolbar[arrow-direction="top"] {\r\n  -webkit-transform-origin: top;\r\n  transform-origin: top;\r\n}\r\n.smart-editor-drop-down-toolbar .smart-table-picker {\r\n  overflow: hidden;\r\n  display: block;\r\n  background: transparent;\r\n}\r\n.smart-editor-drop-down-toolbar .smart-table-picker .smart-table-picker-grid {\r\n  width: 100%;\r\n  display: flex;\r\n  flex-direction: column;\r\n  align-items: center;\r\n}\r\n.smart-editor-drop-down-toolbar .smart-table-picker .smart-table-picker-grid::before {\r\n  content: attr(value);\r\n  display: flex;\r\n  width: 100%;\r\n  justify-content: center;\r\n  align-items: center;\r\n  padding: 0.2rem 16px;\r\n  box-sizing: border-box;\r\n}\r\n.smart-editor-drop-down-toolbar .smart-table-picker .smart-table-picker-grid > div {\r\n  display: flex;\r\n}\r\n.smart-editor-drop-down-toolbar .smart-table-picker .smart-table-picker-cell {\r\n  width: 15px;\r\n  height: 15px;\r\n  border: var(--smart-border-width) solid var(--smart-border);\r\n  margin: 2px;\r\n  cursor: pointer;\r\n}\r\n.smart-editor-drop-down-toolbar .smart-table-picker .smart-table-picker-cell[selected] {\r\n  border-color: var(--smart-primary);\r\n  background: var(--smart-primary);\r\n}\r\n.smart-editor-drop-down-toolbar .smart-table-picker .smart-table-picker-separator {\r\n  width: 100%;\r\n  height: var(--smart-border-width);\r\n  background: var(--smart-border);\r\n  margin: 10px 0;\r\n}\r\n.smart-editor-drop-down-toolbar .smart-table-picker .smart-table-picker-button {\r\n  width: 100%;\r\n  background: transparent;\r\n  border: initial;\r\n}\r\n.smart-editor-drop-down-toolbar .smart-table-picker .smart-table-picker-button button::before {\r\n  font-size: var(--smart-font-size);\r\n  font-family: var(--smart-font-family-icon);\r\n  content: var(--smart-icon-table);\r\n  margin-right: 10px;\r\n  box-sizing: border-box;\r\n}\r\n\r\n/* .smart-editor */\r\n.smart-editor[right-to-left] .smart-editor-toolbar:not(.smart-tooltip) {\r\n  grid-template-areas: \'toggleButton primary\' \'secondary secondary\';\r\n  grid-template-columns: auto minmax(0, 1fr);\r\n}\r\n.smart-editor[right-to-left] .smart-editor-toolbar:not(.smart-tooltip) .smart-editor-toolbar-item {\r\n  margin-left: initial;\r\n  margin-right: var(--smart-editor-toolbar-item-margin);\r\n}\r\n.smart-editor[right-to-left] .smart-editor-content-container,\r\n.smart-editor[right-to-left] .smart-editor-toolbar-items-primary,\r\n.smart-editor[right-to-left] .smart-editor-toolbar-items-secondary,\r\n.smart-editor[right-to-left] .smart-editor-toolbar-item[item-type="drop-down"],\r\n.smart-editor[right-to-left] .smart-editor-toolbar-item[item-type="color-input"] {\r\n  direction: rtl;\r\n}\r\n.smart-editor[right-to-left] .smart-editor-resize-frame span {\r\n  transform: translate(50%, -50%);\r\n}\r\n.smart-editor[right-to-left] .smart-editor-resize-frame span[position="top-left"], .smart-editor[right-to-left] .smart-editor-resize-frame span[position="bottom-right"] {\r\n  cursor: sw-resize;\r\n}\r\n.smart-editor[right-to-left] .smart-editor-resize-frame span[position="top-right"], .smart-editor[right-to-left] .smart-editor-resize-frame span[position="bottom-left"] {\r\n  cursor: se-resize;\r\n}\r\n\r\n/* --- Editor Input Drop Down --- */\r\n.smart-editor-input[right-to-left] li .editor-icon::before {\r\n  right: 0;\r\n  left: initial;\r\n}\r\n\r\n/* --- Editor Tooltip --- */\r\n.smart-tooltip.smart-editor-toolbar[right-to-left]:not(.smart-editor-drop-down-toolbar) .smart-editor-toolbar-item:not(:first-of-type) {\r\n  margin-left: initial;\r\n  margin-right: var(--smart-editor-toolbar-item-margin);\r\n}\r\n\r\n.smart-editor-drop-down-toolbar .smart-table-picker[right-to-left] .smart-table-picker-grid {\r\n  direction: rtl;\r\n}\r\n.smart-editor-drop-down-toolbar .smart-table-picker[right-to-left] .smart-table-picker-button > button.smart-button {\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n}\r\n.smart-editor-drop-down-toolbar .smart-table-picker[right-to-left] .smart-table-picker-button > button.smart-button::before {\r\n  margin-right: initial;\r\n  margin-left: 10px;\r\n}\r\n',""]);const s=i},6751:(e,t,r)=>{"use strict";r.d(t,{Z:()=>s});var n=r(8081),o=r.n(n),a=r(3645),i=r.n(a)()(o());i.push([e.id,'smart-file-upload {\r\n  display: inline-block;\r\n  width: var(--smart-file-upload-default-width);\r\n  font-size: var(--smart-file-upload-font-size);\r\n  font-family: var(--smart-file-upload-font-family);\r\n  color: var(--smart-file-upload-color);\r\n  overflow: hidden;\r\n  box-sizing: border-box;\r\n  border: var(--smart-file-upload-border-width) dashed var(--smart-file-upload-border);\r\n  background-color: var(--smart-file-upload-background);\r\n  min-width: 200px;\r\n  min-height: 100px;\r\n}\r\nsmart-file-upload .smart-total-files.smart-hidden,\r\nsmart-file-upload .smart-selected-files .smart-file.smart-hidden {\r\n  display: none;\r\n}\r\nsmart-file-upload[disabled] {\r\n  opacity: 0.55;\r\n  cursor: default;\r\n}\r\nsmart-file-upload[show-progress] .smart-file smart-progress-bar {\r\n  display: none;\r\n}\r\nsmart-file-upload[show-progress] .smart-file smart-progress-bar[value] {\r\n  display: block;\r\n}\r\n\r\n.smart-file.smart-uploading-start:before {\r\n  width: 100%;\r\n  height: 100%;\r\n  position: absolute;\r\n  left: 0px;\r\n  top: 0px;\r\n  font-family: \'arial\';\r\n  content: var(--smart-file-upload-text-content-uploading-start);\r\n  background-color: #c1c1c169;\r\n  opacity: 1;\r\n  display: flex;\r\n  justify-content: flex-end;\r\n  flex-direction: column;\r\n  box-sizing: border-box;\r\n  font-size: 11px;\r\n  color: #737373;\r\n  padding: 0px 0px 2px 5px;\r\n  pointer-events: none;\r\n  z-index: 1;\r\n  animation: connecting 1s linear infinite;\r\n}\r\n.smart-file.smart-uploading:before {\r\n  font-family: \'arial\';\r\n  position: absolute;\r\n  left: 0px;\r\n  top: 0px;\r\n  content: var(--smart-file-upload-text-content-uploading);\r\n  width: 100%;\r\n  height: 100%;\r\n  background-color: #c1c1c169;\r\n  opacity: 1;\r\n  display: flex;\r\n  justify-content: flex-end;\r\n  flex-direction: column;\r\n  box-sizing: border-box;\r\n  font-size: 11px;\r\n  color: var(--smart-ui-state);\r\n  padding: 0px 0px 2px 5px;\r\n  pointer-events: none;\r\n  z-index: 1;\r\n}\r\n.smart-file.smart-uploading .smart-item-upload-button {\r\n  pointer-events: none;\r\n}\r\n.smart-file.smart-uploading .smart-item-name {\r\n  opacity: 0.2;\r\n  user-select: none;\r\n}\r\n.smart-file.smart-pause:before {\r\n  font-family: \'arial\';\r\n  position: absolute;\r\n  left: 0px;\r\n  top: 0px;\r\n  content: var(--smart-file-upload-text-content-pause);\r\n  width: 100%;\r\n  height: 100%;\r\n  background-color: #ff000030;\r\n  border-radius: 3px;\r\n  opacity: 0.8;\r\n  display: flex;\r\n  justify-content: flex-end;\r\n  flex-direction: column;\r\n  box-sizing: border-box;\r\n  font-size: 11px;\r\n  color: #8a0000;\r\n  padding: 0px 0px 2px 5px;\r\n  pointer-events: none;\r\n  z-index: 1;\r\n}\r\n.smart-file.smart-error:before {\r\n  font-family: \'arial\';\r\n  position: absolute;\r\n  left: 0px;\r\n  top: 0px;\r\n  content: var(--smart-file-upload-text-content-error);\r\n  width: 100%;\r\n  height: 100%;\r\n  background-color: var(--smart-error);\r\n  border-radius: var(--smart-error-border-radius);\r\n  opacity: 0;\r\n  display: flex;\r\n  justify-content: flex-end;\r\n  flex-direction: column;\r\n  box-sizing: border-box;\r\n  font-size: 11px;\r\n  color: var(--smart-on-error);\r\n  padding: 0px 0px 2px 5px;\r\n  pointer-events: none;\r\n  z-index: 1;\r\n  animation: error 6s linear 1;\r\n}\r\n.smart-file.smart-error smart-progress-bar {\r\n  opacity: 0.3;\r\n}\r\n.smart-file smart-progress-bar {\r\n  display: none;\r\n  width: 100%;\r\n  height: 4px;\r\n  position: absolute;\r\n  bottom: 0px;\r\n  left: 0px;\r\n}\r\n.smart-file smart-progress-bar .smart-container {\r\n  border-style: none;\r\n}\r\n.smart-file smart-progress-bar .smart-value {\r\n  background-color: orange;\r\n}\r\n\r\n.smart-file-upload .smart-file-upload-header,\r\n.smart-file-upload .smart-file-upload-container,\r\n.smart-file-upload .smart-file-upload-footer {\r\n  padding: 5px;\r\n  width: 100%;\r\n  box-sizing: border-box;\r\n}\r\n.smart-file-upload .smart-browse-button {\r\n  display: block;\r\n  margin: 4px;\r\n  width: var(--smart-file-upload-browse-button-width);\r\n  height: var(--smart-file-upload-browse-button-height);\r\n}\r\n.smart-file-upload .smart-upload-all-button,\r\n.smart-file-upload .smart-cancel-all-button,\r\n.smart-file-upload .smart-pause-all-button {\r\n  width: var(--smart-file-upload-footer-button-width);\r\n  height: var(--smart-file-upload-footer-button-height);\r\n  margin: 4px;\r\n}\r\n.smart-file-upload .smart-browse-input {\r\n  display: none;\r\n}\r\n.smart-file-upload .smart-drop-zone {\r\n  display: none;\r\n  width: 100%;\r\n  height: 100px;\r\n}\r\n.smart-file-upload .smart-total-files {\r\n  font-family: \'arial\';\r\n  font-size: 12px;\r\n  color: gray;\r\n  display: block;\r\n  box-sizing: border-box;\r\n  padding: 0px 0px 2px 5px;\r\n}\r\n.smart-file-upload .smart-total-files:empty {\r\n  display: none;\r\n}\r\n.smart-file-upload[disabled] .smart-file-upload-container {\r\n  pointer-events: none;\r\n  user-select: none;\r\n}\r\n.smart-file-upload[hide-footer] .smart-file-upload-footer {\r\n  display: none;\r\n}\r\n.smart-file-upload[drop-zone] .smart-drop-zone {\r\n  display: block;\r\n}\r\n.smart-file-upload[drop-zone] .smart-overflow .smart-drop-zone {\r\n  display: none;\r\n}\r\n\r\n.smart-drop-zone {\r\n  width: 100%;\r\n  height: 100%;\r\n  background-color: var(--smart-background);\r\n  position: relative;\r\n  box-sizing: border-box;\r\n  border: lightgray dotted 1px;\r\n}\r\n.smart-drop-zone:after {\r\n  font-family: var(--smart-font-family-icon);\r\n  overflow: hidden;\r\n  text-overflow: ellipsis;\r\n  display: flex;\r\n  justify-content: center;\r\n  flex-direction: column;\r\n  height: 100%;\r\n  width: 100%;\r\n  text-align: center;\r\n  content: var(--smart-file-upload-text-content-drop-zone);\r\n  color: var(--smart-ui-state);\r\n  box-sizing: border-box;\r\n  border: dashed 5px transparent;\r\n  transition: border 0.5s ease-out;\r\n}\r\n.smart-drop-zone.smart-drag-over:after {\r\n  content: var(--smart-file-upload-text-content-drop-zone-over);\r\n  font-size: 50px;\r\n  border: dashed 3px var(--smart-background-border);\r\n  transition: border 0.5s ease-out;\r\n  animation: drop-zone 1s ease-in infinite;\r\n}\r\n\r\n[data-theme="modern"] {\r\n  --smart-file-upload-text-content-drop-zone-over: "Drop here";\r\n}\r\n[data-theme="modern"] .smart-drop-zone {\r\n  border: 2px dashed var(--smart-surface);\r\n  width: 100%;\r\n  background-size: contain;\r\n  background-repeat: no-repeat;\r\n  background-position: bottom center;\r\n  padding: 10px;\r\n  display: flex;\r\n  justify-content: center;\r\n  align-items: center;\r\n}\r\n[data-theme="modern"] .smart-drop-zone:after {\r\n  font-family: "Verdana";\r\n  font-size: 0.875rem;\r\n  font-weight: 400;\r\n  line-height: 1.5;\r\n}\r\n[data-theme="modern"] .smart-drop-zone:hover {\r\n  border-color: var(--smart-primary);\r\n  background-color: rgba(var(--smart-primary-rgb), .1);\r\n}\r\n[data-theme="modern"] .smart-drop-zone.smart-drag-over:after {\r\n  border-color: transparent;\r\n  content: var(--smart-file-upload-text-content-drop-zone-over);\r\n  font-size: 2.5rem;\r\n  transition: border 0.5s ease-out;\r\n  animation: drop-zone 1s ease-in infinite;\r\n}\r\n\r\n.smart-selected-files {\r\n  width: 100%;\r\n  height: 100%;\r\n  display: block;\r\n  box-sizing: border-box;\r\n  padding: 2px;\r\n}\r\n.smart-selected-files .smart-file {\r\n  height: auto;\r\n  position: relative;\r\n  display: block;\r\n  box-sizing: border-box;\r\n  border: lightgray solid 1px;\r\n  padding: 10px;\r\n  border-radius: 3px;\r\n  margin-bottom: 1px;\r\n  background-color: #fafafa;\r\n  transition: border-color 0.5s ease;\r\n}\r\n.smart-selected-files .smart-file:hover {\r\n  transition: border-color 0.5s ease;\r\n  border-color: gray;\r\n}\r\n.smart-selected-files .smart-item-pause-button {\r\n  pointer-events: none;\r\n  box-sizing: border-box;\r\n  height: 16px;\r\n  position: relative;\r\n  width: 16px;\r\n  color: #999;\r\n  transition: color 0.5s ease;\r\n  display: none;\r\n}\r\n.smart-selected-files .smart-item-pause-button:after {\r\n  font-family: var(--smart-font-family-icon);\r\n  position: absolute;\r\n  left: 0px;\r\n  top: 0px;\r\n  font-size: 16px;\r\n  text-shadow: 2px 2px 2px lightgray;\r\n  content: var(--smart-icon-close);\r\n}\r\n.smart-selected-files .smart-item-cancel-button {\r\n  display: inline-block;\r\n  box-sizing: border-box;\r\n  height: 16px;\r\n  position: relative;\r\n  width: 16px;\r\n  color: #999;\r\n  transition: color 0.5s ease;\r\n}\r\n.smart-selected-files .smart-item-cancel-button:after {\r\n  font-family: var(--smart-font-family-icon);\r\n  position: absolute;\r\n  left: 0px;\r\n  top: 0px;\r\n  font-size: 16px;\r\n  text-shadow: 2px 2px 2px lightgray;\r\n  content: var(--smart-icon-close);\r\n}\r\n.smart-selected-files .smart-item-cancel-button:hover {\r\n  cursor: pointer;\r\n  transition: color 0.5s ease;\r\n  color: orange;\r\n}\r\n.smart-selected-files .smart-item-upload-button {\r\n  display: inline-block;\r\n  box-sizing: border-box;\r\n  height: 16px;\r\n  position: relative;\r\n  width: 16px;\r\n  color: #999;\r\n  transition: color 0.5s ease;\r\n}\r\n.smart-selected-files .smart-item-upload-button:after {\r\n  font-family: var(--smart-font-family-icon);\r\n  content: var(--smart-icon-up);\r\n  position: absolute;\r\n  left: 0px;\r\n  top: 0px;\r\n  font-size: 16px;\r\n  text-shadow: 2px 2px 2px lightgray;\r\n}\r\n.smart-selected-files .smart-item-upload-button:hover {\r\n  cursor: pointer;\r\n  color: var(--smart-success);\r\n  transition: color 0.5s ease;\r\n}\r\n.smart-selected-files .smart-item-name {\r\n  display: inline-block;\r\n  box-sizing: border-box;\r\n  position: relative;\r\n  width: calc(100% - 40px);\r\n  overflow: hidden;\r\n  text-overflow: ellipsis;\r\n  height: auto;\r\n}\r\n.smart-selected-files .smart-uploading .smart-item-name {\r\n  width: calc(100% - 60px);\r\n  overflow: hidden;\r\n  text-overflow: ellipsis;\r\n  height: auto;\r\n}\r\n.smart-selected-files .smart-uploading .smart-item-upload-button {\r\n  opacity: 0.3;\r\n}\r\n.smart-selected-files .smart-uploading .smart-item-pause-button {\r\n  display: inline-block;\r\n  cursor: pointer;\r\n  pointer-events: all;\r\n  transition: color 0.5s, opacity 0.5s ease;\r\n  color: #dc1919;\r\n  opacity: 0.5;\r\n}\r\n.smart-selected-files .smart-uploading .smart-item-pause-button:hover {\r\n  transition: color 0.5s, opacity 0.5s ease;\r\n  color: red;\r\n  opacity: 1;\r\n}\r\n.smart-selected-files .smart-uploading .smart-item-cancel-button {\r\n  display: inline-block;\r\n  cursor: pointer;\r\n  pointer-events: all;\r\n  transition: color 0.5s, opacity 0.5s ease;\r\n  opacity: 0.5;\r\n  color: darkorange;\r\n}\r\n.smart-selected-files .smart-uploading .smart-item-cancel-button:hover {\r\n  transition: color 0.5s, opacity 0.5s ease;\r\n  color: orange;\r\n  opacity: 1;\r\n}\r\n\r\n.smart-drop-zone-square {\r\n  position: relative;\r\n}\r\n.smart-drop-zone-square:before {\r\n  content: "";\r\n  display: block;\r\n  padding-bottom: 100%;\r\n}\r\n.smart-drop-zone-square .smart-drop-zone {\r\n  position: absolute;\r\n  top: 0;\r\n  bottom: 0;\r\n  left: 0;\r\n  right: 0;\r\n}\r\n.smart-drop-zone-square.smart-drop-zone-small {\r\n  min-width: 115px;\r\n}\r\n\r\n.smart-drop-zone-small {\r\n  position: relative;\r\n  width: auto;\r\n  display: inline-block;\r\n}\r\n.smart-drop-zone-small .smart-drop-zone.smart-drag-over:after {\r\n  font-size: 1.25rem;\r\n}\r\n\r\n.smart-drop-zone-images-only .smart-drop-zone {\r\n  display: flex;\r\n  align-items: center;\r\n  flex-flow: column;\r\n  justify-content: space-evenly;\r\n}\r\n.smart-drop-zone-images-only .smart-drop-zone:after {\r\n  height: auto;\r\n}\r\n.smart-drop-zone-images-only .smart-drop-zone:before {\r\n  display: block;\r\n  content: \'\';\r\n  background-image: url("../images/dropable_zone_image.svg");\r\n  width: 70px;\r\n  height: 55px;\r\n  background-size: contain;\r\n  background-position: center center;\r\n}\r\n\r\n@-webkit-keyframes connecting {\r\n  0% {\r\n    color: #73737350;\r\n  }\r\n  50% {\r\n    color: #73737399;\r\n  }\r\n  100% {\r\n    color: #73737350;\r\n  }\r\n}\r\n@-webkit-keyframes drop-zone {\r\n  0% {\r\n    color: #b1b1b100;\r\n  }\r\n  50% {\r\n    color: #b1b1b199;\r\n  }\r\n  100% {\r\n    color: #b1b1b100;\r\n  }\r\n}\r\n@-webkit-keyframes rotating {\r\n  from {\r\n    transform: rotate(0deg);\r\n  }\r\n  to {\r\n    transform: rotate(360deg);\r\n  }\r\n}\r\n@-webkit-keyframes error {\r\n  0% {\r\n    opacity: 0.8;\r\n    background-color: #ff000015;\r\n  }\r\n  3% {\r\n    background-color: #ff000040;\r\n  }\r\n  6% {\r\n    background-color: #ff000015;\r\n  }\r\n  9% {\r\n    background-color: #ff000040;\r\n  }\r\n  12% {\r\n    background-color: #ff000015;\r\n  }\r\n  80% {\r\n    opacity: 0.8;\r\n  }\r\n  100% {\r\n    opacity: 0;\r\n  }\r\n}\r\nsmart-file-upload[right-to-left] > .smart-container {\r\n  direction: rtl;\r\n}\r\n\r\n.smart-file[right-to-left] {\r\n  direction: rtl;\r\n}\r\n\r\n.smart-drop-zone[right-to-left] {\r\n  direction: rtl;\r\n}\r\n',""]);const s=i},8551:(e,t,r)=>{"use strict";r.d(t,{Z:()=>s});var n=r(8081),o=r.n(n),a=r(3645),i=r.n(a)()(o());i.push([e.id,'.smart-input-group {\r\n  position: relative;\r\n  display: -webkit-box;\r\n  display: -ms-flexbox;\r\n  display: flex;\r\n  -ms-flex-wrap: wrap;\r\n  flex-wrap: wrap;\r\n  -webkit-box-align: stretch;\r\n  -ms-flex-align: stretch;\r\n  align-items: stretch;\r\n  box-sizing: border-box;\r\n  font-family: var(--smart-font-family);\r\n}\r\n.smart-input-group smart-input .smart-drop-down-button {\r\n  border-left: none;\r\n}\r\n.smart-input-group smart-button[focus] {\r\n  z-index: 3;\r\n}\r\n.smart-input-group > .smart-input-group-prepend > smart-button,\r\n.smart-input-group > .smart-input-group-prepend > .smart-input-group-text {\r\n  border-top-right-radius: 0;\r\n  border-bottom-right-radius: 0;\r\n}\r\n.smart-input-group > .smart-input-group-prepend:first-child > smart-button:not(:first-child),\r\n.smart-input-group > .smart-input-group-prepend:first-child > .smart-input-group-text:not(:first-child) {\r\n  border-top-left-radius: 0;\r\n  border-bottom-left-radius: 0;\r\n}\r\n.smart-input-group > .smart-input-group-prepend:not(:first-child) > smart-button,\r\n.smart-input-group > .smart-input-group-prepend:not(:first-child) > .smart-input-group-text {\r\n  border-top-left-radius: 0;\r\n  border-bottom-left-radius: 0;\r\n}\r\n.smart-input-group > .smart-input-group-append > smart-button,\r\n.smart-input-group > .smart-input-group-append > .smart-input-group-text {\r\n  border-top-left-radius: 0;\r\n  border-bottom-left-radius: 0;\r\n}\r\n.smart-input-group > .smart-input-group-append:last-child > smart-button:not(:last-child):not(.dropdown-toggle),\r\n.smart-input-group > .smart-input-group-append:last-child > .smart-input-group-text:not(:last-child) {\r\n  border-top-right-radius: 0;\r\n  border-bottom-right-radius: 0;\r\n}\r\n.smart-input-group > .smart-input-group-append:not(:last-child) > smart-button,\r\n.smart-input-group > .smart-input-group-append:not(:last-child) > .smart-input-group-text {\r\n  border-top-right-radius: 0;\r\n  border-bottom-right-radius: 0;\r\n}\r\n.smart-input-group > .custom-file,\r\n.smart-input-group > .custom-select,\r\n.smart-input-group > .form-control {\r\n  position: relative;\r\n  flex: 1 1 auto;\r\n  width: 1%;\r\n  margin-bottom: 0;\r\n}\r\n.smart-input-group > .custom-file:focus,\r\n.smart-input-group > .custom-select:focus,\r\n.smart-input-group > .form-control:focus {\r\n  z-index: 3;\r\n}\r\n.smart-input-group > .custom-select:not(:first-child),\r\n.smart-input-group > .form-control:not(:first-child) {\r\n  border-top-left-radius: 0;\r\n  border-bottom-left-radius: 0;\r\n}\r\n.smart-input-group > .custom-select:not(:last-child),\r\n.smart-input-group > .form-control:not(:last-child) {\r\n  border-top-right-radius: 0;\r\n  border-bottom-right-radius: 0;\r\n}\r\n.smart-input-group > .form-control[focus] {\r\n  z-index: 3;\r\n}\r\n.smart-input-group > .custom-file + .custom-file,\r\n.smart-input-group > .custom-file + .custom-select,\r\n.smart-input-group > .custom-file + .form-control,\r\n.smart-input-group > .custom-select + .custom-file,\r\n.smart-input-group > .custom-select + .custom-select,\r\n.smart-input-group > .custom-select + .form-control,\r\n.smart-input-group > .form-control + .custom-file,\r\n.smart-input-group > .form-control + .custom-select,\r\n.smart-input-group > .form-control + .form-control {\r\n  margin-left: -1px;\r\n}\r\n\r\n.smart-input-group-append,\r\n.smart-input-group-prepend {\r\n  display: -webkit-box;\r\n  display: -ms-flexbox;\r\n  display: flex;\r\n  box-sizing: border-box;\r\n  height: auto;\r\n}\r\n.smart-input-group-append > smart-button,\r\n.smart-input-group-prepend > smart-button {\r\n  height: 100%;\r\n}\r\n.smart-input-group-append smart-button + smart-button,\r\n.smart-input-group-append smart-button + .smart-input-group-text,\r\n.smart-input-group-append .smart-input-group-text + smart-button,\r\n.smart-input-group-append .smart-input-group-text + .smart-input-group-text,\r\n.smart-input-group-prepend smart-button + smart-button,\r\n.smart-input-group-prepend smart-button + .smart-input-group-text,\r\n.smart-input-group-prepend .smart-input-group-text + smart-button,\r\n.smart-input-group-prepend .smart-input-group-text + .smart-input-group-text {\r\n  margin-left: -1px;\r\n}\r\n\r\n.smart-input-group-prepend {\r\n  margin-right: -1px;\r\n}\r\n\r\n.smart-input-group-append {\r\n  margin-left: -1px;\r\n}\r\n\r\n.smart-input-group-text {\r\n  border-radius: var(--smart-border-radius);\r\n  display: flex;\r\n  align-items: center;\r\n  padding: .375rem .75rem;\r\n  margin-bottom: 0;\r\n  font-size: 1rem;\r\n  font-weight: 400;\r\n  line-height: 1.5;\r\n  color: var(--smart-surface-color);\r\n  text-align: center;\r\n  white-space: nowrap;\r\n  background-color: var(--smart-surface);\r\n  border: 1px solid var(--smart-border);\r\n}\r\n\r\n.form-control {\r\n  border-radius: var(--smart-border-radius);\r\n  height: auto;\r\n  display: block;\r\n  width: 100%;\r\n  padding: .375rem .75rem;\r\n  font-size: var(--smart-font-size);\r\n  line-height: 1.5;\r\n  color: #495057;\r\n  background-color: var(--smart-background);\r\n  background-clip: padding-box;\r\n  -webkit-background-clip: padding-box;\r\n  border: 1px solid var(--smart-border);\r\n  transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out;\r\n}\r\n.form-control:focus, .form-control[focus] {\r\n  color: var(--smart-color);\r\n  background-color: var(--smart-background);\r\n  border-color: var(--smart-primary);\r\n  outline: 0;\r\n}\r\n\r\n.smart-form {\r\n  background: var(--smart-background);\r\n  color: var(--smart-background-color);\r\n  border: 0px solid var(--smart-border);\r\n  border-radius: var(--smart-border-radius);\r\n  box-sizing: border-box;\r\n  overflow: visible;\r\n  width: 600px;\r\n  font-family: var(--smart-font-family);\r\n  font-size: var(--smart-font-size);\r\n  display: block;\r\n}\r\n@media only screen and (max-width: 600px) {\r\n  .smart-form {\r\n    width: 350px;\r\n  }\r\n}\r\n\r\n.smart-form-row {\r\n  padding: 5px 0px;\r\n  box-sizing: border-box;\r\n}\r\n.smart-form-row .smart-form-control-label {\r\n  display: flex;\r\n  align-items: center;\r\n  white-space: nowrap;\r\n  text-overflow: ellipsis;\r\n  font-family: var(--smart-font-family);\r\n  font-size: calc(0.9 * var(--smart-font-size));\r\n}\r\n.smart-form-row .smart-form-control-label[required]:after {\r\n  content: \'*\';\r\n  color: #a94442;\r\n  font-size: 14px;\r\n  margin-left: 2px;\r\n  margin-right: 2px;\r\n}\r\n.smart-form-row .smart-form-control {\r\n  display: flex;\r\n  box-sizing: border-box;\r\n}\r\n.smart-form-row .smart-form-control + .smart-form-label[required]:before {\r\n  content: \'*\';\r\n  color: #a94442;\r\n  font-size: 14px;\r\n  margin-left: 2px;\r\n  margin-right: 2px;\r\n}\r\n.smart-form-row .smart-form-control + .smart-form-control-label[required]:after {\r\n  content: \'\';\r\n}\r\n\r\n.smart-form-row-flex {\r\n  display: flex;\r\n}\r\n\r\n.smart-form-control .smart-form-control-addon {\r\n  display: flex;\r\n  align-items: center;\r\n}\r\n.smart-form-control.left {\r\n  justify-content: flex-start;\r\n}\r\n.smart-form-control.center {\r\n  justify-content: center;\r\n}\r\n.smart-form-control.right {\r\n  justify-content: flex-end;\r\n}\r\n.smart-form-control[readonly] .smart-form-editor {\r\n  pointer-events: none;\r\n}\r\n.smart-form-control[readonly] .smart-form-editor .smart-drop-down-button,\r\n.smart-form-control[readonly] .smart-form-editor .smart-calendar-button {\r\n  visibility: hidden;\r\n}\r\n.smart-form-control[readonly] .smart-form-editor textarea,\r\n.smart-form-control[readonly] .smart-form-editor input,\r\n.smart-form-control[readonly] .smart-form-editor div,\r\n.smart-form-control[readonly] .smart-form-editor span {\r\n  border: none !important;\r\n}\r\n.smart-form-control[readonly] .smart-form-editor + div,\r\n.smart-form-control[readonly] .smart-form-editor + .smart-form-control-addon,\r\n.smart-form-control[readonly] .smart-form-editor + .smart-form-control-icon {\r\n  visibility: hidden;\r\n}\r\n\r\n.smart-form-control-icon:after {\r\n  content: attr(tooltip);\r\n  visibility: hidden;\r\n  white-space: nowrap;\r\n  margin-top: 25px;\r\n  position: absolute;\r\n  border-top-left-radius: var(--smart-border-top-left-radius);\r\n  border-top-right-radius: var(--smart-border-top-right-radius);\r\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\r\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\r\n  padding: 7px;\r\n  background-color: var(--smart-secondary);\r\n  color: var(--smart-secondary-color);\r\n  font-size: calc(var(--smart-font-size) - 2px);\r\n  opacity: 0;\r\n  transform: scale(0);\r\n  transition: opacity 0.2s ease-out, transform 0.1s ease-out;\r\n  z-index: 9;\r\n}\r\n.smart-form-control-icon:hover:after {\r\n  visibility: visible;\r\n  opacity: 0.9;\r\n  transform: scale(1);\r\n  color: var(--smart-secondary-color);\r\n  background: var(--smart-secondary);\r\n}\r\n\r\n.smart-form-control-label[readonly]:after {\r\n  visibility: hidden;\r\n}\r\n\r\n.smart-form-group .smart-form-group-content {\r\n  display: grid;\r\n  grid-template-columns: none;\r\n}\r\n.smart-form-group[columns="2"] > .smart-form-group-content {\r\n  grid-template-columns: 50% 50%;\r\n}\r\n.smart-form-group[columns="3"] > .smart-form-group-content {\r\n  grid-template-columns: 33% 33% 33%;\r\n}\r\n.smart-form-group[columns="4"] > .smart-form-group-content {\r\n  grid-template-columns: 25% 25% 25% 25%;\r\n}\r\n.smart-form-group[columns="5"] > .smart-form-group-content {\r\n  grid-template-columns: 20% 20% 20% 20% 20%;\r\n}\r\n.smart-form-group[columns="6"] > .smart-form-group-content {\r\n  grid-template-columns: 16.66% 16.66% 16.66% 16.66% 16.66% 16.66%;\r\n}\r\n\r\n.smart-form-group-label {\r\n  font-size: 20px;\r\n  font-family: var(--smart-font-family);\r\n  padding-top: 10px;\r\n  padding-bottom: 10px;\r\n  margin-bottom: 20px;\r\n  border-bottom: 1px solid var(--smart-border);\r\n}\r\n.smart-form-group-label.center {\r\n  display: flex;\r\n  justify-content: center;\r\n}\r\n.smart-form-group-label.right {\r\n  display: flex;\r\n  justify-content: flex-end;\r\n}\r\n\r\n.smart-form-group-buttons {\r\n  display: flex;\r\n  justify-content: flex-end;\r\n  padding-right: 30px;\r\n}\r\n.smart-form-group-buttons smart-button {\r\n  margin-left: 20px;\r\n}\r\n\r\n.smart-form-editor {\r\n  width: 100%;\r\n}\r\n.smart-form-editor.smart-validation-success:not(smart-check-box):not([focus]) > div.smart-container::after {\r\n  display: none;\r\n}\r\n.smart-form-editor.smart-validation-success:not(smart-check-box)[focus] > div.smart-container::after {\r\n  left: initial;\r\n  right: 0px;\r\n  z-index: 9;\r\n}\r\n.smart-form-editor.smart-validation-error:not(smart-check-box) > div.smart-container::after {\r\n  left: initial;\r\n  right: 0px;\r\n  z-index: 9;\r\n}\r\n.smart-form-editor.smart-numeric-text-box.smart-validation-success:not(smart-check-box)[focus] > div.smart-container input, .smart-form-editor.smart-numeric-text-box.smart-validation-error:not(smart-check-box) > div.smart-container input {\r\n  padding-right: 30px;\r\n}\r\n.smart-form-editor.smart-numeric-text-box[focus][spin-buttons].smart-validation-success[focus] input, .smart-form-editor.smart-numeric-text-box[focus][spin-buttons].smart-validation-error[focus] input, .smart-form-editor.smart-number-input[focus]:not([drop-down-button-position="none"]).smart-validation-success[focus] input, .smart-form-editor.smart-number-input[focus]:not([drop-down-button-position="none"]).smart-validation-error[focus] input {\r\n  padding-right: 30px;\r\n}\r\n.smart-form-editor.smart-numeric-text-box.smart-validation-success:not(smart-check-box)[focus] > div.smart-container::after, .smart-form-editor.smart-numeric-text-box.smart-validation-error:not(smart-check-box) > div.smart-container::after, .smart-form-editor.smart-number-input.smart-validation-success:not(smart-check-box)[focus] > div.smart-container::after, .smart-form-editor.smart-number-input.smart-validation-error:not(smart-check-box) > div.smart-container::after, .smart-form-editor.smart-combo-box.smart-validation-success:not(smart-check-box)[focus] > div.smart-container::after, .smart-form-editor.smart-combo-box.smart-validation-error:not(smart-check-box) > div.smart-container::after, .smart-form-editor.smart-date-time-picker.smart-validation-success:not(smart-check-box)[focus] > div.smart-container::after, .smart-form-editor.smart-date-time-picker.smart-validation-error:not(smart-check-box) > div.smart-container::after, .smart-form-editor.smart-drop-down-list.smart-validation-success:not(smart-check-box)[focus] > div.smart-container::after, .smart-form-editor.smart-drop-down-list.smart-validation-error:not(smart-check-box) > div.smart-container::after {\r\n  right: 20px;\r\n}\r\n.smart-form-editor.smart-invalid + .smart-error-label-like-after-element, .smart-form-editor.smart-valid + .smart-success-label-like-after-element {\r\n  left: initial;\r\n  right: 0px;\r\n  z-index: 9;\r\n}\r\n\r\ninput.smart-form-editor.smart-valid:not(:focus) + .smart-success-label-like-after-element {\r\n  display: none;\r\n}\r\ninput.smart-form-editor.smart-invalid + .smart-error-label-like-after-element, input.smart-form-editor.smart-valid + .smart-success-label-like-after-element {\r\n  right: 35px;\r\n}\r\n\r\n.smart-form-tab {\r\n  grid-row: 1;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  min-width: 0;\r\n  cursor: pointer;\r\n  font-family: var(--smart-font-family);\r\n  box-sizing: border-box;\r\n  transition: background-color 0.2s ease-in-out;\r\n}\r\n.smart-form-tab.selected {\r\n  border-bottom: 2px solid var(--smart-primary);\r\n  color: var(--smart-primary);\r\n}\r\n.smart-form-tab.smart-invalid {\r\n  border-bottom: 2px solid var(--smart-error);\r\n  color: var(--smart-error);\r\n}\r\n\r\n.smart-form-tab-strip {\r\n  display: grid;\r\n  grid-auto-columns: 1fr;\r\n  overflow: hidden;\r\n  border-bottom: var(--smart-border-width) solid var(--smart-border);\r\n  height: 30px;\r\n  margin-bottom: 10px;\r\n}\r\n.smart-form-tab-strip .smart-form-tab .smart-form-tab-label {\r\n  font-size: calc(var(--smart-font-size) + 1px);\r\n  min-width: 0;\r\n  overflow: hidden;\r\n  text-overflow: ellipsis;\r\n  white-space: nowrap;\r\n  padding: 5px;\r\n}\r\n.smart-form-tab-strip .smart-form-tab:hover {\r\n  background: var(--smart-ui-state-hover);\r\n  color: var(--smart-ui-state-color-hover);\r\n}\r\n.smart-form-tab-strip[vertical] {\r\n  display: flex;\r\n  height: auto;\r\n  flex-direction: column;\r\n  background: var(--smart-background);\r\n  border: none;\r\n  border-radius: initial;\r\n  padding-bottom: 1px;\r\n}\r\n.smart-form-tab-strip[vertical] .smart-form-tab {\r\n  background-color: var(--smart-surface);\r\n  color: var(--smart-surface-color);\r\n  overflow: hidden;\r\n  border: var(--smart-border-width) solid var(--smart-border);\r\n  border-radius: 0px;\r\n  padding: 10px;\r\n  margin-bottom: -1px;\r\n  justify-content: left;\r\n}\r\n.smart-form-tab-strip[vertical] .smart-form-tab .smart-form-tab-label {\r\n  width: 100%;\r\n}\r\n.smart-form-tab-strip[vertical] .smart-form-tab .smart-form-tab-button {\r\n  float: right;\r\n  transition: transform 0.3s ease-in-out;\r\n  transform: rotate(-180deg);\r\n  font-size: 17px;\r\n}\r\n.smart-form-tab-strip[vertical] .smart-form-tab.selected {\r\n  background: var(--smart-ui-state-focus);\r\n}\r\n.smart-form-tab-strip[vertical] .smart-form-tab.selected .smart-form-tab-button {\r\n  transform: rotate(0deg);\r\n}\r\n.smart-form-tab-strip[vertical] .smart-form-tab.smart-invalid {\r\n  color: var(--smart-error);\r\n  background-color: var(--smart-surface);\r\n}\r\n.smart-form-tab-strip[breadcrumb] {\r\n  border: none;\r\n}\r\n.smart-form-tab-strip[breadcrumb] .smart-form-tab {\r\n  border-bottom: none;\r\n}\r\n.smart-form-tab-strip[breadcrumb] .smart-form-tab .smart-form-tab-label {\r\n  display: flex;\r\n  align-items: center;\r\n}\r\n.smart-form-tab-strip[breadcrumb] .smart-form-tab .smart-form-tab-label .circle {\r\n  border-radius: 100%;\r\n  font-family: var(--smart-font-family);\r\n  width: 12px;\r\n  height: 12px;\r\n  padding: 5px;\r\n  margin-right: 10px;\r\n  background: var(--smart-secondary);\r\n  color: var(--smart-secondary-color);\r\n  align-items: center;\r\n  justify-content: center;\r\n  display: flex;\r\n}\r\n.smart-form-tab-strip[breadcrumb] .smart-form-tab.smart-invalid {\r\n  color: var(--smart-color);\r\n}\r\n.smart-form-tab-strip[breadcrumb] .smart-form-tab.selected .smart-form-tab-label .circle {\r\n  background: var(--smart-primary);\r\n  color: var(--smart-primary-color);\r\n}\r\n\r\n.smart-form-tab-control {\r\n  padding: 0;\r\n  display: none !important;\r\n}\r\n.smart-form-tab-control.selected {\r\n  margin-bottom: -1px;\r\n  display: grid !important;\r\n}\r\n.smart-form-tab-control.selected[vertical] {\r\n  padding: 10px;\r\n  border: 1px solid var(--smart-border);\r\n}\r\n\r\n.smart-form-options-horizontal {\r\n  display: flex;\r\n}\r\n',""]);const s=i},9181:(e,t,r)=>{"use strict";r.d(t,{Z:()=>s});var n=r(8081),o=r.n(n),a=r(3645),i=r.n(a)()(o());i.push([e.id,'/* smart-element */\n.smart-container {\n  box-sizing: border-box;\n  font-family: inherit;\n  font-size: inherit;\n  display: block;\n  width: 100%;\n  height: 100%;\n  outline: none;\n  margin: 0;\n  padding: 0;\n}\n.smart-container * {\n  box-sizing: border-box;\n}\n\n.smart-popup,\n.smart-drop-down {\n  position: absolute;\n  box-sizing: border-box;\n  margin: var(--smart-editor-drop-down-vertical-offset) 0px;\n  z-index: var(--smart-editor-drop-down-z-index);\n  list-style-type: none;\n}\n\n@font-face {\n  font-family: smart-icons;\n  src: local("../font/smart-icons"), url("../font/smart-icons.woff2") format("woff2"), url("../font/smart-icons.woff") format("woff"), url("../font/smart-icons.ttf") format("truetype"), url("../font/smart-icons.eot") format("embedded-opentype");\n  font-weight: normal;\n  font-style: normal;\n}\n.smart-arrow {\n  width: 100%;\n  height: 100%;\n  background-position: center;\n  background-repeat: no-repeat;\n  background-size: 1em 1em;\n}\n\n.smart-arrow-up:after,\n.smart-arrow-down:after,\n.smart-arrow-left:after,\n.smart-arrow-right:after,\n.smart-arrow-left-first:after,\n.smart-arrow-right-last:after {\n  width: 100%;\n  height: 100%;\n  font-family: var(--smart-font-family-icon);\n  font-style: normal;\n  font-weight: normal;\n  font-size: var(--smart-arrow-size);\n  color: inherit;\n  text-decoration: inherit;\n  font-variant: normal;\n  text-transform: none;\n  display: flex;\n  flex-wrap: wrap;\n  align-items: center;\n  justify-content: center;\n  position: relative;\n}\n\n.smart-arrow-up:after {\n  content: var(--smart-icon-arrow-up);\n  top: -1px;\n}\n\n.smart-arrow-down:after {\n  content: var(--smart-icon-arrow-down);\n}\n\n.smart-arrow-left:after {\n  content: var(--smart-icon-arrow-left);\n}\n\n.smart-arrow-left-first:after {\n  content: var(--smart-icon-first-page);\n}\n\n.smart-arrow-right-last:after {\n  content: var(--smart-icon-last-page);\n}\n\n.smart-arrow-right:after {\n  content: var(--smart-icon-arrow-right);\n}\n\n.drawContainer {\n  width: 100%;\n  height: 100%;\n  position: relative;\n}\n\n.smart-ripple {\n  display: block;\n  position: absolute;\n  border-radius: 50%;\n  transform: scale(0);\n  pointer-events: none;\n  -webkit-animation: ripple 0.35s linear;\n          animation: ripple 0.35s linear;\n  border: none;\n  opacity: 0.5;\n}\n.smart-ripple.smart-animate {\n  -webkit-animation: ripple 0.65s linear;\n          animation: ripple 0.65s linear;\n  position: absolute;\n}\n\n@-webkit-keyframes ripple {\n  100% {\n    opacity: 0;\n    transform: scale(2.5); /*scale the element to 250% to safely cover the entire link and fade it out*/\n  }\n}\n\n@keyframes ripple {\n  100% {\n    opacity: 0;\n    transform: scale(2.5); /*scale the element to 250% to safely cover the entire link and fade it out*/\n  }\n}\n.smart-overlay {\n  pointer-events: none;\n}\n\n.smart-unselectable {\n  -webkit-user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n}\n\n.smart-hidden {\n  display: none !important;\n}\n\n.smart-visibility-hidden {\n  visibility: hidden !important;\n}\n\n.smart-element-init {\n  visibility: hidden;\n}\n\n.smart-element-ready {\n  overflow: hidden;\n}\n\n.smart-shown {\n  display: block;\n}\n\n.smart-resize-trigger {\n  position: absolute;\n  left: 0;\n  top: 0;\n  transition: 0s;\n}\n\n.smart-resize-trigger-shrink {\n  position: absolute;\n  left: 0;\n  top: 0;\n  transition: 0s;\n  width: 200%;\n  height: 200%;\n}\n\n.smart-resize-trigger-container {\n  display: block;\n  position: relative;\n  top: -100%;\n  left: 0;\n  height: 100%;\n  width: 100%;\n  min-height: 1px;\n  overflow: hidden;\n  pointer-events: none;\n  z-index: -1;\n  visibility: hidden;\n}\n\nsmart-grid .smart-loader,\nsmart-list-box .smart-loader,\nsmart-list-menu .smart-loader,\n.smart-list-menu-view.smart-drop-down-repositioned .smart-loader,\nsmart-tree .smart-loader,\nsmart-card-view .smart-loader,\nsmart-table .smart-loader {\n  margin: inherit;\n  display: block;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  transform: translate(-50%, -50%);\n  opacity: 0.85;\n  text-align: left;\n  border: 6px solid rgba(43, 51, 63, 0.1);\n  box-sizing: border-box;\n  background-clip: padding-box;\n  border-radius: 50%;\n  z-index: 10;\n  width: calc(var(--smart-loader-size) + 10px);\n  height: calc(var(--smart-loader-size) + 10px);\n}\nsmart-grid .smart-loader:before, smart-grid .smart-loader:after,\nsmart-list-box .smart-loader:before,\nsmart-list-box .smart-loader:after,\nsmart-list-menu .smart-loader:before,\nsmart-list-menu .smart-loader:after,\n.smart-list-menu-view.smart-drop-down-repositioned .smart-loader:before,\n.smart-list-menu-view.smart-drop-down-repositioned .smart-loader:after,\nsmart-tree .smart-loader:before,\nsmart-tree .smart-loader:after,\nsmart-card-view .smart-loader:before,\nsmart-card-view .smart-loader:after,\nsmart-table .smart-loader:before,\nsmart-table .smart-loader:after {\n  content: "";\n  position: absolute;\n  margin: -6px;\n  box-sizing: inherit;\n  width: inherit;\n  height: inherit;\n  border-radius: inherit;\n  opacity: 1;\n  border: 6px solid transparent;\n  -webkit-animation-delay: 0.44s;\n          animation-delay: 0.44s;\n  -webkit-animation: smart-loader-spin 1.1s cubic-bezier(0.6, 0.2, 0, 0.8) infinite, smart-loader-spin-fade 1.1s linear infinite;\n          animation: smart-loader-spin 1.1s cubic-bezier(0.6, 0.2, 0, 0.8) infinite, smart-loader-spin-fade 1.1s linear infinite;\n}\nsmart-grid .smart-loader.smart-hidden,\nsmart-list-box .smart-loader.smart-hidden,\nsmart-list-menu .smart-loader.smart-hidden,\n.smart-list-menu-view.smart-drop-down-repositioned .smart-loader.smart-hidden,\nsmart-tree .smart-loader.smart-hidden,\nsmart-card-view .smart-loader.smart-hidden,\nsmart-table .smart-loader.smart-hidden {\n  display: none;\n}\n\nsmart-grid[loading-indicator-position=top] .smart-loader, smart-grid[loading-indicator-position=bottom] .smart-loader,\nsmart-list-box[loading-indicator-position=top] .smart-loader,\nsmart-list-box[loading-indicator-position=bottom] .smart-loader,\nsmart-list-menu[loading-indicator-position=top] .smart-loader,\nsmart-list-menu[loading-indicator-position=bottom] .smart-loader,\n.smart-list-menu-view.smart-drop-down-repositioned[loading-indicator-position=top] .smart-loader,\n.smart-list-menu-view.smart-drop-down-repositioned[loading-indicator-position=bottom] .smart-loader,\nsmart-tree[loading-indicator-position=top] .smart-loader,\nsmart-tree[loading-indicator-position=bottom] .smart-loader {\n  width: var(--smart-loader-size);\n  height: var(--smart-loader-size);\n  left: 20%;\n}\nsmart-grid[loading-indicator-position=top] .smart-loader-container, smart-grid[loading-indicator-position=bottom] .smart-loader-container,\nsmart-list-box[loading-indicator-position=top] .smart-loader-container,\nsmart-list-box[loading-indicator-position=bottom] .smart-loader-container,\nsmart-list-menu[loading-indicator-position=top] .smart-loader-container,\nsmart-list-menu[loading-indicator-position=bottom] .smart-loader-container,\n.smart-list-menu-view.smart-drop-down-repositioned[loading-indicator-position=top] .smart-loader-container,\n.smart-list-menu-view.smart-drop-down-repositioned[loading-indicator-position=bottom] .smart-loader-container,\nsmart-tree[loading-indicator-position=top] .smart-loader-container,\nsmart-tree[loading-indicator-position=bottom] .smart-loader-container {\n  display: block;\n  position: relative;\n  width: 100%;\n  height: 10%;\n  background-color: #F2F2F2;\n  overflow: hidden;\n  -webkit-animation: smart-loader-container-pop-up-down 0.3s linear;\n          animation: smart-loader-container-pop-up-down 0.3s linear;\n}\nsmart-grid[loading-indicator-position=top] .smart-loader-container.smart-hidden, smart-grid[loading-indicator-position=bottom] .smart-loader-container.smart-hidden,\nsmart-list-box[loading-indicator-position=top] .smart-loader-container.smart-hidden,\nsmart-list-box[loading-indicator-position=bottom] .smart-loader-container.smart-hidden,\nsmart-list-menu[loading-indicator-position=top] .smart-loader-container.smart-hidden,\nsmart-list-menu[loading-indicator-position=bottom] .smart-loader-container.smart-hidden,\n.smart-list-menu-view.smart-drop-down-repositioned[loading-indicator-position=top] .smart-loader-container.smart-hidden,\n.smart-list-menu-view.smart-drop-down-repositioned[loading-indicator-position=bottom] .smart-loader-container.smart-hidden,\nsmart-tree[loading-indicator-position=top] .smart-loader-container.smart-hidden,\nsmart-tree[loading-indicator-position=bottom] .smart-loader-container.smart-hidden {\n  display: none;\n}\nsmart-grid[loading-indicator-position=top] .smart-loader-label, smart-grid[loading-indicator-position=bottom] .smart-loader-label,\nsmart-list-box[loading-indicator-position=top] .smart-loader-label,\nsmart-list-box[loading-indicator-position=bottom] .smart-loader-label,\nsmart-list-menu[loading-indicator-position=top] .smart-loader-label,\nsmart-list-menu[loading-indicator-position=bottom] .smart-loader-label,\n.smart-list-menu-view.smart-drop-down-repositioned[loading-indicator-position=top] .smart-loader-label,\n.smart-list-menu-view.smart-drop-down-repositioned[loading-indicator-position=bottom] .smart-loader-label,\nsmart-tree[loading-indicator-position=top] .smart-loader-label,\nsmart-tree[loading-indicator-position=bottom] .smart-loader-label {\n  position: absolute;\n  display: block;\n  top: 50%;\n  transform: translate(-50%, -50%);\n  left: 60%;\n  font-family: inherit;\n  font-size: inherit;\n  vertical-align: middle;\n  white-space: nowrap;\n}\nsmart-grid[loading-indicator-position=top] .smart-loader-container,\nsmart-list-box[loading-indicator-position=top] .smart-loader-container,\nsmart-list-menu[loading-indicator-position=top] .smart-loader-container,\n.smart-list-menu-view.smart-drop-down-repositioned[loading-indicator-position=top] .smart-loader-container,\nsmart-tree[loading-indicator-position=top] .smart-loader-container {\n  top: 0;\n  position: absolute;\n  -webkit-animation: smart-loader-container-pop-up-top 0.3s linear;\n          animation: smart-loader-container-pop-up-top 0.3s linear;\n}\nsmart-grid[loading-indicator-position=bottom] .smart-loader-container,\nsmart-list-box[loading-indicator-position=bottom] .smart-loader-container,\nsmart-list-menu[loading-indicator-position=bottom] .smart-loader-container,\n.smart-list-menu-view.smart-drop-down-repositioned[loading-indicator-position=bottom] .smart-loader-container,\nsmart-tree[loading-indicator-position=bottom] .smart-loader-container {\n  top: -10%;\n}\nsmart-grid[loading-indicator-position=center] .smart-loader,\nsmart-list-box[loading-indicator-position=center] .smart-loader,\nsmart-list-menu[loading-indicator-position=center] .smart-loader,\n.smart-list-menu-view.smart-drop-down-repositioned[loading-indicator-position=center] .smart-loader,\nsmart-tree[loading-indicator-position=center] .smart-loader {\n  width: calc(var(--smart-loader-size) + 10px);\n  height: calc(var(--smart-loader-size) + 10px);\n}\n\nsmart-grid[disabled] .smart-loader:before, smart-grid[disabled] .smart-loader:after,\nsmart-list-box[disabled] .smart-loader:before,\nsmart-list-box[disabled] .smart-loader:after,\nsmart-list-menu[disabled] .smart-loader:before,\nsmart-list-menu[disabled] .smart-loader:after,\nsmart-tree[disabled] .smart-loader:before,\nsmart-tree[disabled] .smart-loader:after {\n  -webkit-animation: none;\n          animation: none;\n}\n\n@-webkit-keyframes smart-loader-container-pop-up-down {\n  0% {\n    top: 0;\n  }\n  20% {\n    top: -2%;\n  }\n  35% {\n    top: -6%;\n  }\n  60% {\n    top: -8%;\n  }\n  100% {\n    top: -10%;\n  }\n}\n\n@keyframes smart-loader-container-pop-up-down {\n  0% {\n    top: 0;\n  }\n  20% {\n    top: -2%;\n  }\n  35% {\n    top: -6%;\n  }\n  60% {\n    top: -8%;\n  }\n  100% {\n    top: -10%;\n  }\n}\n@-webkit-keyframes smart-loader-container-pop-up-top {\n  0% {\n    top: -10%;\n  }\n  20% {\n    top: -8%;\n  }\n  35% {\n    top: -6%;\n  }\n  60% {\n    top: -2%;\n  }\n  100% {\n    top: 0;\n  }\n}\n@keyframes smart-loader-container-pop-up-top {\n  0% {\n    top: -10%;\n  }\n  20% {\n    top: -8%;\n  }\n  35% {\n    top: -6%;\n  }\n  60% {\n    top: -2%;\n  }\n  100% {\n    top: 0;\n  }\n}\n@-webkit-keyframes smart-loader-spin {\n  100% {\n    transform: rotate(360deg);\n  }\n}\n@keyframes smart-loader-spin {\n  100% {\n    transform: rotate(360deg);\n  }\n}\n@-webkit-keyframes smart-loader-spin-fade {\n  0% {\n    border-top-color: #7A7A7A;\n  }\n  20% {\n    border-top-color: #7A7A7A;\n  }\n  35% {\n    border-top-color: transparent;\n  }\n  60% {\n    border-top-color: #7A7A7A;\n  }\n  100% {\n    border-top-color: #7A7A7A;\n  }\n}\n@keyframes smart-loader-spin-fade {\n  0% {\n    border-top-color: #7A7A7A;\n  }\n  20% {\n    border-top-color: #7A7A7A;\n  }\n  35% {\n    border-top-color: transparent;\n  }\n  60% {\n    border-top-color: #7A7A7A;\n  }\n  100% {\n    border-top-color: #7A7A7A;\n  }\n}\n.smart-right-to-left {\n  direction: rtl;\n}\n\n.smart-micro {\n  font-size: 9px;\n}\n\n.smart-caps {\n  text-transform: uppercase;\n  letter-spacing: 0.1em;\n}\n\n.smart-strong {\n  font-weight: 500;\n}\n\n.smart-truncate {\n  max-width: 100%;\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n}\n\n.smart-quiet {\n  opacity: 0.75;\n}\n\n.smart-flex {\n  display: flex;\n}\n\n.smart-flex-wrap {\n  display: flex;\n  flex-wrap: wrap;\n}\n\n.smart-dragging,\n.smart-dragging * {\n  cursor: move !important;\n}',""]);const s=i},8:(e,t,r)=>{"use strict";r.d(t,{Z:()=>s});var n=r(8081),o=r.n(n),a=r(3645),i=r.n(a)()(o());i.push([e.id,'/* smart-progress-bar */\r\nsmart-progress-bar.smart-element,\r\nsmart-circular-progress-bar.smart-element {\r\n  border: none;\r\n}\r\nsmart-progress-bar.smart-element:focus > .smart-container,\r\nsmart-circular-progress-bar.smart-element:focus > .smart-container {\r\n  border-color: var(--smart-outline);\r\n}\r\nsmart-progress-bar > .smart-container, smart-progress-bar.smart-container,\r\nsmart-circular-progress-bar > .smart-container,\r\nsmart-circular-progress-bar.smart-container {\r\n  border-top-left-radius: var(--smart-border-top-left-radius);\r\n  border-top-right-radius: var(--smart-border-top-right-radius);\r\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\r\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\r\n  overflow: hidden;\r\n  position: relative;\r\n  border-width: var(--smart-border-width);\r\n  border-style: solid;\r\n  border-color: var(--smart-border);\r\n  color: var(--smart-background-color);\r\n}\r\nsmart-progress-bar .smart-label,\r\nsmart-circular-progress-bar .smart-label {\r\n  top: 50%;\r\n  left: 50%;\r\n  transform: translate(-50%, -50%);\r\n  position: absolute;\r\n  text-align: center;\r\n  color: var(--smart-background-color);\r\n}\r\n\r\nsmart-progress-bar {\r\n  width: var(--smart-progress-bar-default-width);\r\n  height: var(--smart-progress-bar-default-height);\r\n}\r\nsmart-progress-bar .smart-label {\r\n  width: auto;\r\n  color: var(--smart-outline);\r\n}\r\nsmart-progress-bar .smart-value {\r\n  outline: none;\r\n  height: 100%;\r\n  width: 100%;\r\n  box-sizing: border-box;\r\n  position: absolute;\r\n  border: 1px solid var(--smart-ui-state-border-active);\r\n  background-color: var(--smart-ui-state-active);\r\n  transform-origin: left;\r\n}\r\nsmart-progress-bar .smart-value.smart-value-animation {\r\n  animation: indeterminate 3s infinite linear;\r\n}\r\nsmart-progress-bar.primary .smart-value {\r\n  border: 1px solid var(--smart-primary);\r\n  background-color: var(--smart-primary);\r\n}\r\nsmart-progress-bar.secondary .smart-value {\r\n  border: 1px solid var(--smart-secondary);\r\n  background-color: var(--smart-secondary);\r\n}\r\nsmart-progress-bar.success .smart-value {\r\n  border: 1px solid var(--smart-success);\r\n  background-color: var(--smart-success);\r\n}\r\nsmart-progress-bar.info .smart-value {\r\n  border: 1px solid var(--smart-info);\r\n  background-color: var(--smart-info);\r\n}\r\nsmart-progress-bar.warning .smart-value {\r\n  border: 1px solid var(--smart-warning);\r\n  background-color: var(--smart-warning);\r\n}\r\nsmart-progress-bar.error .smart-value {\r\n  border: 1px solid var(--smart-error);\r\n  background-color: var(--smart-error);\r\n}\r\nsmart-progress-bar.light .smart-value {\r\n  border: 1px solid var(--smart-light);\r\n  background-color: var(--smart-light);\r\n}\r\nsmart-progress-bar.dark .smart-value {\r\n  border: 1px solid var(--smart-dark);\r\n  background-color: var(--smart-dark);\r\n}\r\nsmart-progress-bar:not([animation=\'none\']) .smart-value {\r\n  transition: 0.2s ease-in-out;\r\n}\r\nsmart-progress-bar[orientation][inverted] .smart-value {\r\n  transform-origin: right;\r\n}\r\nsmart-progress-bar[inverted] .smart-value {\r\n  transform-origin: right;\r\n}\r\nsmart-progress-bar[inverted] .smart-value.smart-value-animation {\r\n  animation: indeterminate-inverted 3s infinite linear;\r\n}\r\nsmart-progress-bar[orientation] .smart-value {\r\n  transform-origin: left;\r\n}\r\nsmart-progress-bar[orientation="vertical"] {\r\n  width: var(--smart-progress-bar-default-height);\r\n  height: var(--smart-progress-bar-default-width);\r\n}\r\nsmart-progress-bar[orientation="vertical"][inverted] .smart-value {\r\n  transform-origin: left bottom;\r\n}\r\nsmart-progress-bar[orientation="vertical"] .smart-value {\r\n  transform-origin: left top;\r\n}\r\nsmart-progress-bar[orientation="vertical"] .smart-value.smart-value-animation {\r\n  animation: indeterminate-vertical 3s infinite linear;\r\n}\r\nsmart-progress-bar[orientation="vertical"] .smart-label {\r\n  width: 100%;\r\n}\r\nsmart-progress-bar[inverted][orientation="vertical"] .smart-value.smart-value-animation {\r\n  animation: indeterminate-vertical-inverted 3s infinite linear;\r\n}\r\n\r\nsmart-circular-progress-bar {\r\n  width: var(--smart-circular-progress-bar-default-size);\r\n  height: var(--smart-circular-progress-bar-default-size);\r\n}\r\nsmart-circular-progress-bar > .smart-container, smart-circular-progress-bar.smart-container {\r\n  border-radius: 50%;\r\n}\r\nsmart-circular-progress-bar .smart-value-animation-ms {\r\n  stroke-dashoffset: 114;\r\n}\r\nsmart-circular-progress-bar svg:first-of-type {\r\n  position: absolute;\r\n  border-radius: 50%;\r\n  pointer-events: none;\r\n}\r\nsmart-circular-progress-bar svg:first-of-type .smart-value.smart-value-animation {\r\n  animation: circle 2s infinite linear;\r\n}\r\nsmart-circular-progress-bar .smart-label-container {\r\n  position: absolute;\r\n  top: 50%;\r\n  left: 50%;\r\n  transform: translate(-50%, -50%);\r\n  overflow: hidden;\r\n  box-sizing: content-box;\r\n  border-radius: 50%;\r\n  background-color: transparent;\r\n  border-style: solid;\r\n  border-width: var(--smart-border-width);\r\n  border-color: var(--smart-border);\r\n  width: calc(100% - var(--smart-circular-progress-bar-fill-size));\r\n  height: calc(100% - var(--smart-circular-progress-bar-fill-size));\r\n}\r\nsmart-circular-progress-bar .smart-value,\r\nsmart-circular-progress-bar .smart-value-path {\r\n  stroke-width: var(--smart-circular-progress-bar-fill-size);\r\n  fill: transparent;\r\n  stroke-dasharray: 314.159;\r\n}\r\nsmart-circular-progress-bar .smart-value {\r\n  stroke: var(--smart-ui-state-active);\r\n}\r\nsmart-circular-progress-bar .smart-value-path {\r\n  stroke-dashoffset: 0;\r\n  stroke: transparent;\r\n}\r\nsmart-circular-progress-bar.primary .smart-value {\r\n  stroke: var(--smart-primary);\r\n}\r\nsmart-circular-progress-bar.secondary .smart-value {\r\n  stroke: var(--smart-secondary);\r\n}\r\nsmart-circular-progress-bar.success .smart-value {\r\n  stroke: var(--smart-success);\r\n}\r\nsmart-circular-progress-bar.info .smart-value {\r\n  stroke: var(--smart-info);\r\n}\r\nsmart-circular-progress-bar.warning .smart-value {\r\n  stroke: var(--smart-warning);\r\n}\r\nsmart-circular-progress-bar.error .smart-value {\r\n  stroke: var(--smart-error);\r\n}\r\nsmart-circular-progress-bar.light .smart-value {\r\n  stroke: var(--smart-light);\r\n}\r\nsmart-circular-progress-bar.dark .smart-value {\r\n  stroke: var(--smart-dark);\r\n}\r\nsmart-circular-progress-bar:not([animation=\'none\']) .smart-value {\r\n  transition: stroke-dashoffset 1s linear;\r\n}\r\nsmart-circular-progress-bar[inverted] svg:first-of-type .smart-value.smart-value-animation {\r\n  animation: circle-inverted 2s infinite linear;\r\n}\r\nsmart-circular-progress-bar[indeterminate][inverted] svg:first-of-type, smart-circular-progress-bar[value="null"][inverted] svg:first-of-type {\r\n  animation: rotate-circle-inverted 1s infinite linear;\r\n}\r\nsmart-circular-progress-bar[indeterminate] svg:first-of-type, smart-circular-progress-bar[value="null"] svg:first-of-type {\r\n  animation: rotate-circle 1s infinite linear;\r\n}\r\n\r\n/* Barber Shop */\r\n.barber-shop-effect .smart-value {\r\n  background-image: linear-gradient(45deg, rgba(0, 0, 0, 0.2) 25%, transparent 25%, transparent 50%, rgba(0, 0, 0, 0.2) 50%, rgba(0, 0, 0, 0.2) 75%, transparent 75%, transparent);\r\n  background-size: 5rem 5rem;\r\n  background-position: 0 -244rem;\r\n  animation: stripes 10s linear infinite;\r\n  animation-direction: normal;\r\n}\r\n.barber-shop-effect[inverted] .smart-value, .barber-shop-effect[orientation="vertical"] .smart-value {\r\n  animation-direction: reverse;\r\n}\r\n\r\n/* ANIMATION - BarberShop style */\r\n@keyframes stripes {\r\n  0% {\r\n    background-position: 0 0;\r\n  }\r\n  100% {\r\n    background-position: 60rem 0;\r\n  }\r\n}\r\n@keyframes indeterminate {\r\n  0% {\r\n    left: -100%;\r\n    transform: scaleX(0.4);\r\n    transform-origin: left;\r\n  }\r\n  20% {\r\n    left: -40%;\r\n    transform: scaleX(0.3);\r\n    transform-origin: left;\r\n  }\r\n  35% {\r\n    left: 35%;\r\n    transform: scaleX(0.4);\r\n    transform-origin: left;\r\n  }\r\n  50% {\r\n    left: 75%;\r\n    transform: scaleX(0.6);\r\n    transform-origin: left;\r\n  }\r\n  55% {\r\n    left: 100%;\r\n    transform: scaleX(0.7);\r\n    transform-origin: left;\r\n  }\r\n  55.99% {\r\n    left: 100%;\r\n    transform: scaleX(0);\r\n    transform-origin: left;\r\n  }\r\n  56% {\r\n    left: -100%;\r\n    transform: scaleX(0);\r\n    transform-origin: left;\r\n  }\r\n  56.99% {\r\n    left: -100%;\r\n    transform: scaleX(0.6);\r\n    transform-origin: left;\r\n  }\r\n  75% {\r\n    left: -5%;\r\n    transform: scaleX(0.6);\r\n    transform-origin: left;\r\n  }\r\n  80% {\r\n    left: 30%;\r\n    transform: scaleX(0.5);\r\n    transform-origin: left;\r\n  }\r\n  85% {\r\n    left: 50%;\r\n    transform: scaleX(0.4);\r\n    transform-origin: left;\r\n  }\r\n  90% {\r\n    left: 75%;\r\n    transform: scaleX(0.3);\r\n    transform-origin: left;\r\n  }\r\n  95% {\r\n    left: 95%;\r\n    transform: scaleX(0.2);\r\n    transform-origin: left;\r\n  }\r\n  98% {\r\n    left: 100%;\r\n    transform: scaleX(0.2);\r\n    transform-origin: left;\r\n  }\r\n  99.99% {\r\n    left: 100%;\r\n    transform: scaleX(0);\r\n    transform-origin: left;\r\n  }\r\n  100% {\r\n    left: -100%;\r\n    transform: scaleX(0);\r\n    transform-origin: left;\r\n  }\r\n}\r\n@keyframes indeterminate-vertical {\r\n  0% {\r\n    bottom: -100%;\r\n    transform: scaleY(0.4);\r\n    transform-origin: bottom;\r\n  }\r\n  20% {\r\n    bottom: -40%;\r\n    transform: scaleY(0.3);\r\n    transform-origin: bottom;\r\n  }\r\n  35% {\r\n    bottom: 35%;\r\n    transform: scaleY(0.4);\r\n    transform-origin: bottom;\r\n  }\r\n  50% {\r\n    bottom: 75%;\r\n    transform: scaleY(0.6);\r\n    transform-origin: bottom;\r\n  }\r\n  55% {\r\n    bottom: 100%;\r\n    transform: scaleY(0.7);\r\n    transform-origin: bottom;\r\n  }\r\n  55.99% {\r\n    bottom: 100%;\r\n    transform: scaleY(0);\r\n    transform-origin: bottom;\r\n  }\r\n  56% {\r\n    bottom: -100%;\r\n    transform: scaleY(0);\r\n    transform-origin: bottom;\r\n  }\r\n  56.99% {\r\n    bottom: -100%;\r\n    transform: scaleY(0.6);\r\n    transform-origin: bottom;\r\n  }\r\n  75% {\r\n    bottom: -5%;\r\n    transform: scaleY(0.6);\r\n    transform-origin: bottom;\r\n  }\r\n  80% {\r\n    bottom: 30%;\r\n    transform: scaleY(0.5);\r\n    transform-origin: bottom;\r\n  }\r\n  85% {\r\n    bottom: 50%;\r\n    transform: scaleY(0.4);\r\n    transform-origin: bottom;\r\n  }\r\n  90% {\r\n    bottom: 75%;\r\n    transform: scaleY(0.3);\r\n    transform-origin: bottom;\r\n  }\r\n  95% {\r\n    bottom: 95%;\r\n    transform: scaleY(0.2);\r\n    transform-origin: bottom;\r\n  }\r\n  98% {\r\n    bottom: 100%;\r\n    transform: scaleY(0.2);\r\n    transform-origin: bottom;\r\n  }\r\n  99.99% {\r\n    bottom: 100%;\r\n    transform: scaleY(0);\r\n    transform-origin: bottom;\r\n  }\r\n  100% {\r\n    bottom: -100%;\r\n    transform: scaleY(0);\r\n    transform-origin: bottom;\r\n  }\r\n}\r\n@keyframes circle {\r\n  0% {\r\n    stroke-dashoffset: 314;\r\n  }\r\n  5% {\r\n    stroke-dashoffset: 164;\r\n  }\r\n  25% {\r\n    stroke-dashoffset: 104;\r\n  }\r\n}\r\n@keyframes circle-inverted {\r\n  0% {\r\n    stroke-dashoffset: -314;\r\n  }\r\n  5% {\r\n    stroke-dashoffset: -164;\r\n  }\r\n  25% {\r\n    stroke-dashoffset: -104;\r\n  }\r\n}\r\n@keyframes rotate-circle {\r\n  50% {\r\n    transform: rotate(180deg);\r\n  }\r\n  75% {\r\n    transform: rotate(270deg);\r\n  }\r\n  100% {\r\n    transform: rotate(360deg);\r\n  }\r\n}\r\n@keyframes rotate-circle-inverted {\r\n  50% {\r\n    transform: rotate(-180deg);\r\n  }\r\n  75% {\r\n    transform: rotate(-270deg);\r\n  }\r\n  100% {\r\n    transform: rotate(-360deg);\r\n  }\r\n}\r\n/* smart-progress-bar */\r\nsmart-progress-bar[right-to-left] .smart-label,\r\nsmart-circular-progress-bar[right-to-left] .smart-label {\r\n  direction: rtl;\r\n}\r\n\r\nsmart-progress-bar[right-to-left]:not([orientation="vertical"]) .smart-value, smart-progress-bar[right-to-left][orientation="horizontal"] .smart-value {\r\n  transform-origin: right;\r\n}\r\nsmart-progress-bar[right-to-left]:not([orientation="vertical"])[inverted] .smart-value, smart-progress-bar[right-to-left][orientation="horizontal"][inverted] .smart-value {\r\n  transform-origin: left;\r\n}\r\nsmart-progress-bar[right-to-left][orientation="horizontal"] .smart-value.smart-value-animation, smart-progress-bar[right-to-left]:not([orientation="vertical"]) .smart-value.smart-value-animation {\r\n  animation: indeterminate-inverted 3s infinite linear;\r\n}\r\nsmart-progress-bar[right-to-left][inverted][orientation="horizontal"] .smart-value.smart-value-animation, smart-progress-bar[right-to-left][inverted]:not([orientation="vertical"]) .smart-value.smart-value-animation {\r\n  animation: indeterminate 3s infinite linear;\r\n}\r\n\r\nsmart-circular-progress-bar[right-to-left][inverted] svg:first-of-type .smart-value.smart-value-animation {\r\n  animation: circle 2s infinite linear;\r\n}\r\nsmart-circular-progress-bar[right-to-left] svg:first-of-type .smart-value.smart-value-animation {\r\n  animation: circle-inverted 2s infinite linear;\r\n}\r\nsmart-circular-progress-bar[right-to-left][indeterminate] svg:first-of-type, smart-circular-progress-bar[right-to-left][value="null"] svg:first-of-type {\r\n  animation: rotate-circle-inverted 1s infinite linear;\r\n}\r\nsmart-circular-progress-bar[right-to-left][indeterminate][inverted] svg:first-of-type, smart-circular-progress-bar[right-to-left][value="null"][inverted] svg:first-of-type {\r\n  animation: rotate-circle 1s infinite linear;\r\n}\r\n\r\n/* Barber Shop */\r\n.barber-shop-effect[right-to-left] .smart-value {\r\n  animation-direction: reverse;\r\n}\r\n.barber-shop-effect[right-to-left][inverted] .smart-value {\r\n  animation-direction: normal;\r\n}\r\n',""]);const s=i},176:(e,t,r)=>{"use strict";r.d(t,{Z:()=>s});var n=r(8081),o=r.n(n),a=r(3645),i=r.n(a)()(o());i.push([e.id,'smart-scheduler {\r\n  --smart-scheduler-event-size: var(--smart-scheduler-event-size-basic);\r\n  display: block;\r\n  width: var(--smart-scheduler-default-width);\r\n  height: var(--smart-scheduler-default-height);\r\n  contain: content;\r\n}\r\nsmart-scheduler > .smart-container, smart-scheduler.smart-container {\r\n  overflow: hidden;\r\n  display: grid;\r\n  grid-template-rows: var(--smart-scheduler-header-height) minmax(0, 1fr);\r\n  grid-template-columns: 100%;\r\n  margin-bottom: -2px;\r\n}\r\nsmart-scheduler > .smart-container[show-footer], smart-scheduler.smart-container[show-footer] {\r\n  grid-template-rows: var(--smart-scheduler-header-height) minmax(0, 1fr) var(--smart-scheduler-footer-height);\r\n}\r\nsmart-scheduler > .smart-container.hscroll .smart-scheduler-view, smart-scheduler.smart-container.hscroll .smart-scheduler-view {\r\n  height: calc(100% - var(--smart-scroll-bar-size));\r\n}\r\nsmart-scheduler > .smart-container.vscroll .smart-scheduler-view, smart-scheduler.smart-container.vscroll .smart-scheduler-view {\r\n  width: calc(100% - var(--smart-scroll-bar-size));\r\n}\r\nsmart-scheduler .smart-scheduler-nav[today], smart-scheduler .smart-scheduler-nav[prev], smart-scheduler .smart-scheduler-nav[current], smart-scheduler .smart-scheduler-nav[next] {\r\n  width: var(--smart-scheduler-header-navigation-button-size);\r\n  min-width: var(--smart-scheduler-header-navigation-button-size);\r\n  height: 100%;\r\n  position: relative;\r\n  font-size: initial;\r\n  display: inline-block;\r\n  font-weight: inherit;\r\n  font-family: var(--smart-font-family-icon);\r\n  border: var(--smart-border-width) solid var(--smart-border);\r\n  text-transform: initial;\r\n}\r\nsmart-scheduler .smart-scheduler-nav[current]:after, smart-scheduler .smart-scheduler-nav[prev]:after, smart-scheduler .smart-scheduler-nav[next]:after {\r\n  position: absolute;\r\n  top: 0;\r\n  left: 0;\r\n  width: 100%;\r\n  height: 100%;\r\n  font-family: var(--smart-font-family-icon);\r\n  font-size: var(--smart-arrow-size);\r\n  color: inherit;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  pointer-events: none;\r\n}\r\nsmart-scheduler .smart-scheduler-nav[current]:after {\r\n  width: var(--smart-editor-addon-width);\r\n  min-width: var(--smart-editor-addon-width);\r\n  left: initial;\r\n  right: 0;\r\n  content: var(--smart-icon-arrow-down);\r\n  background: transparent;\r\n  color: inherit;\r\n}\r\nsmart-scheduler .smart-scheduler-nav[today] {\r\n  width: var(--smart-scheduler-header-today-button-size);\r\n  --smart-button-padding: 0 10px 0 10px;\r\n  border-top-left-radius: var(--smart-item-border-top-left-radius);\r\n  border-bottom-left-radius: var(--smart-item-border-bottom-left-radius);\r\n  border-top-right-radius: var(--smart-item-border-top-right-radius);\r\n  border-bottom-right-radius: var(--smart-item-border-bottom-right-radius);\r\n  margin-right: 10px;\r\n}\r\nsmart-scheduler .smart-scheduler-nav[today] button {\r\n  text-overflow: ellipsis;\r\n  overflow: hidden;\r\n}\r\nsmart-scheduler .smart-scheduler-nav[prev][focus] button, smart-scheduler .smart-scheduler-nav[prev][focus] button, smart-scheduler .smart-scheduler-nav[next][focus] button, smart-scheduler .smart-scheduler-nav[next][focus] button {\r\n  background-color: var(--smart-background-focus);\r\n  outline: none;\r\n}\r\nsmart-scheduler .smart-scheduler-nav[prev] .smart-button, smart-scheduler .smart-scheduler-nav[next] .smart-button {\r\n  font-family: var(--smart-font-family-icon);\r\n  padding: 0px;\r\n  border-radius: 0px;\r\n  border: none;\r\n  min-height: initial;\r\n}\r\nsmart-scheduler .smart-scheduler-nav[prev]:after {\r\n  content: var(--smart-icon-arrow-left);\r\n}\r\nsmart-scheduler .smart-scheduler-nav[next]:after {\r\n  content: var(--smart-icon-arrow-right);\r\n}\r\nsmart-scheduler .smart-scheduler-header {\r\n  width: 100%;\r\n  height: var(--smart-scheduler-header-height);\r\n  display: grid;\r\n  grid-template-columns: minmax(0, 1fr) auto;\r\n  grid-template-rows: 100%;\r\n  grid-template-areas: "date view";\r\n  align-items: center;\r\n  justify-content: start;\r\n  background: var(--smart-surface);\r\n  border-bottom: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler .smart-scheduler-header:empty {\r\n  display: none;\r\n}\r\nsmart-scheduler .smart-scheduler-header[responsive-mode] {\r\n  grid-template-columns: repeat(2, auto);\r\n}\r\nsmart-scheduler .smart-scheduler-footer {\r\n  width: 100%;\r\n  height: var(--smart-scheduler-footer-height);\r\n  border-top: var(--smart-border-width) solid var(--smart-border);\r\n  justify-content: center;\r\n  align-items: center;\r\n  background: var(--smart-surface);\r\n}\r\nsmart-scheduler .smart-scheduler-footer:empty {\r\n  display: none;\r\n}\r\nsmart-scheduler .smart-scheduler-view {\r\n  text-align: center;\r\n  overflow: hidden;\r\n  height: 100%;\r\n  display: grid;\r\n  grid-template-rows: auto minmax(0, 1fr);\r\n  grid-template-areas: "hHeader hHeader" "vHeader content";\r\n  grid-template-columns: auto minmax(0, 1fr);\r\n  outline: none;\r\n  position: relative;\r\n}\r\nsmart-scheduler .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-cell[group-separator]:not(:last-of-type) {\r\n  border-bottom: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-view-header-vertical {\r\n  display: grid;\r\n  grid-template-columns: repeat(2, auto);\r\n}\r\nsmart-scheduler .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-view-header-groups-container {\r\n  flex-direction: row;\r\n}\r\nsmart-scheduler .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-cell[group-separator]:not(:last-of-type),\r\nsmart-scheduler .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-cell:not(.scale)[group-separator]:not(:last-of-type),\r\nsmart-scheduler .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-cell-container[group-separator]:not(:last-of-type),\r\nsmart-scheduler .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-cell[group-separator]:not(:last-of-type) {\r\n  border-bottom-color: var(--smart-scheduler-timeline-group-separator-background);\r\n  border-bottom-width: var(--smart-scheduler-timeline-group-separator-size);\r\n}\r\nsmart-scheduler .smart-scheduler-view[show-group-header="horizontal"] .smart-scheduler-view-header-groups-container {\r\n  flex-direction: column;\r\n}\r\nsmart-scheduler .smart-scheduler-view[show-group-header="horizontal"] .smart-scheduler-view-header-groups-container .smart-scheduler-cell-container:not(:last-of-type) > .smart-scheduler-cell {\r\n  border-bottom: var(--smart-scheduler-view-line-size) solid var(--smart-scheduler-view-horizontal-line-color);\r\n}\r\nsmart-scheduler .smart-scheduler-view[show-group-header="horizontal"] .smart-scheduler-cell[group-separator]:not(:last-of-type),\r\nsmart-scheduler .smart-scheduler-view[show-group-header="horizontal"] .smart-scheduler-cell:not(.scale)[group-separator]:not(:last-of-type),\r\nsmart-scheduler .smart-scheduler-view[show-group-header="horizontal"] .smart-scheduler-cell-container[group-separator]:not(:last-of-type) {\r\n  border-right-color: var(--smart-scheduler-timeline-group-separator-background);\r\n  border-right-width: var(--smart-scheduler-timeline-group-separator-size);\r\n  border-right-style: solid;\r\n}\r\nsmart-scheduler .smart-scheduler-view:focus .smart-scheduler-cell:not(.scale)[selected] {\r\n  background: var(--smart-ui-state-selected);\r\n  color: var(--smart-ui-state-color-selected);\r\n}\r\nsmart-scheduler .smart-scheduler-view:focus .smart-scheduler-cell:not(.scale)[selected="start"] {\r\n  background: var(--smart-ui-state-active);\r\n  color: var(--smart-ui-state-color-active);\r\n}\r\nsmart-scheduler .smart-scheduler-view[event-hovered="left"], smart-scheduler .smart-scheduler-view[event-hovered="right"], smart-scheduler .smart-scheduler-view[event-hovered="left"] .smart-scheduler-event-content, smart-scheduler .smart-scheduler-view[event-hovered="right"] .smart-scheduler-event-content {\r\n  cursor: e-resize;\r\n}\r\nsmart-scheduler .smart-scheduler-view[event-hovered="top"], smart-scheduler .smart-scheduler-view[event-hovered="bottom"], smart-scheduler .smart-scheduler-view[event-hovered="top"] .smart-scheduler-event-content, smart-scheduler .smart-scheduler-view[event-hovered="bottom"] .smart-scheduler-event-content {\r\n  cursor: n-resize;\r\n}\r\nsmart-scheduler .smart-scheduler-view[mobile] .smart-scheduler-content:not(.hide-overlay):after {\r\n  position: fixed;\r\n  content: \'\';\r\n  width: 100%;\r\n  height: 100%;\r\n  display: block;\r\n}\r\nsmart-scheduler .smart-scheduler-view[mobile] .smart-scheduler-event[collector] {\r\n  display: flex;\r\n  justify-content: center;\r\n  align-items: center;\r\n  border-radius: 50%;\r\n  overflow: hidden;\r\n}\r\nsmart-scheduler .smart-scheduler-view[mobile] .smart-scheduler-event[collector] .smart-scheduler-event-content {\r\n  width: var(--smart-scheduler-event-collector-mobile-size);\r\n  height: var(--smart-scheduler-event-collector-mobile-size);\r\n}\r\nsmart-scheduler .smart-scheduler-view-nav {\r\n  grid-area: view;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: flex-end;\r\n  height: 100%;\r\n  overflow: hidden;\r\n}\r\nsmart-scheduler .smart-scheduler-view-nav .smart-scheduler-nav[prev],\r\nsmart-scheduler .smart-scheduler-view-nav .smart-scheduler-nav[next] {\r\n  border: initial;\r\n  border-radius: initial;\r\n  --smart-background: transparent;\r\n  --smart-disabled: transparent;\r\n}\r\nsmart-scheduler .smart-scheduler-view-nav[show-menu] {\r\n  padding: var(--smart-scheduler-header-padding);\r\n}\r\nsmart-scheduler .smart-scheduler-view-nav.no-overflowing .smart-scheduler-items-container {\r\n  overflow: hidden;\r\n}\r\nsmart-scheduler .smart-scheduler-view-header {\r\n  box-shadow: var(--smart-scheduler-header-box-shadow);\r\n  position: relative;\r\n}\r\nsmart-scheduler .smart-scheduler-view-header-vertical {\r\n  height: 100%;\r\n  grid-area: vHeader;\r\n  display: grid;\r\n  grid-template-columns: repeat(2, auto);\r\n}\r\nsmart-scheduler .smart-scheduler-view-header-vertical .smart-scheduler-view-details {\r\n  width: var(--smart-scheduler-timeline-header-vertical-details-size);\r\n}\r\nsmart-scheduler .smart-scheduler-view-header-vertical .smart-scheduler-groups-container {\r\n  width: var(--smart-scheduler-timeline-header-vertical-group-size);\r\n}\r\nsmart-scheduler .smart-scheduler-view-header-vertical .smart-scheduler-cells {\r\n  width: var(--smart-scheduler-timeline-header-vertical-cells-size);\r\n  border: none;\r\n  background: var(--smart-background);\r\n  position: relative;\r\n}\r\nsmart-scheduler .smart-scheduler-view-header-vertical .smart-scheduler-cell {\r\n  width: 100%;\r\n  min-width: initial;\r\n  align-items: flex-start;\r\n}\r\nsmart-scheduler .smart-scheduler-view-header-vertical .smart-scheduler-cell > div {\r\n  overflow: hidden;\r\n  text-overflow: ellipsis;\r\n  background: inherit;\r\n  padding: var(--smart-scheduler-timeline-header-vertical-label-padding);\r\n}\r\nsmart-scheduler .smart-scheduler-view-header-vertical-content {\r\n  width: 100%;\r\n  height: 100%;\r\n  position: relative;\r\n  overflow: hidden;\r\n  display: flex;\r\n}\r\nsmart-scheduler .smart-scheduler-view-header-horizontal {\r\n  width: 100%;\r\n  display: grid;\r\n  grid-area: hHeader;\r\n}\r\nsmart-scheduler .smart-scheduler-view-header-horizontal .smart-scheduler-view-details {\r\n  height: var(--smart-scheduler-timeline-header-horizontal-details-size);\r\n}\r\nsmart-scheduler .smart-scheduler-view-header-horizontal .smart-scheduler-groups-container {\r\n  height: var(--smart-scheduler-timeline-header-horizontal-group-size);\r\n}\r\nsmart-scheduler .smart-scheduler-view-header-horizontal .smart-scheduler-view-time-container {\r\n  display: grid;\r\n  width: 100%;\r\n  overflow: hidden;\r\n  border-bottom: var(--smart-scheduler-view-line-size) solid var(--smart-scheduler-view-horizontal-line-color);\r\n  grid-template-columns: auto minmax(0, 1fr);\r\n}\r\nsmart-scheduler .smart-scheduler-view-header-horizontal .smart-scheduler-cells {\r\n  height: var(--smart-scheduler-timeline-header-horizontal-cells-size);\r\n  position: relative;\r\n  display: flex;\r\n  width: 100%;\r\n  min-height: inherit;\r\n}\r\nsmart-scheduler .smart-scheduler-view-header-horizontal .smart-scheduler-cells .smart-scheduler-cell {\r\n  width: 100%;\r\n  min-height: inherit;\r\n  display: flex;\r\n  height: 100%;\r\n  border-left: var(--smart-scheduler-view-line-size) solid var(--smart-scheduler-view-vertical-line-color);\r\n  border-right: var(--smart-scheduler-view-line-size) solid var(--smart-scheduler-view-vertical-line-color);\r\n}\r\nsmart-scheduler .smart-scheduler-view-header-horizontal .smart-scheduler-cells .smart-scheduler-cell > div {\r\n  overflow: hidden;\r\n  text-overflow: ellipsis;\r\n  padding: var(--smart-scheduler-timeline-header-horizontal-label-padding);\r\n}\r\nsmart-scheduler .smart-scheduler-view-header-horizontal .smart-scheduler-cells .smart-scheduler-cell:first-of-type {\r\n  border-left: none;\r\n}\r\nsmart-scheduler .smart-scheduler-view-header-horizontal .smart-scheduler-view-groups-content {\r\n  border-bottom: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler .smart-scheduler-view-header-horizontal-content {\r\n  width: 100%;\r\n  height: 100%;\r\n  position: relative;\r\n  overflow: hidden;\r\n  display: flex;\r\n  flex-direction: column;\r\n}\r\nsmart-scheduler .smart-scheduler-view-header-groups-container {\r\n  width: 100%;\r\n  display: flex;\r\n  position: relative;\r\n}\r\nsmart-scheduler .smart-scheduler-view-header-groups-container .smart-scheduler-cell-container {\r\n  position: relative;\r\n  width: 100%;\r\n  height: 100%;\r\n  min-height: initial;\r\n  min-width: initial;\r\n}\r\nsmart-scheduler .smart-scheduler-view-header-groups-container .smart-scheduler-cell {\r\n  height: 100%;\r\n  border-right: var(--smart-scheduler-view-line-size) solid var(--smart-scheduler-view-vertical-line-color);\r\n}\r\nsmart-scheduler .smart-scheduler-view-time {\r\n  display: flex;\r\n  position: relative;\r\n}\r\nsmart-scheduler .smart-scheduler-view-all-day {\r\n  grid-template-columns: auto minmax(0, 1fr);\r\n  border-bottom: var(--smart-scheduler-day-week-view-hour-size) solid var(--smart-scheduler-day-week-view-hour-color);\r\n  height: var(--smart-scheduler-timeline-header-all-day-cells-size);\r\n  display: grid;\r\n}\r\nsmart-scheduler .smart-scheduler-view-all-day .smart-scheduler-cell[all-day] {\r\n  height: 100%;\r\n  border-left: initial;\r\n}\r\nsmart-scheduler .smart-scheduler-view-all-day .smart-scheduler-event {\r\n  padding: var(--smart-scheduler-event-padding-all-day);\r\n  height: var(--smart-scheduler-event-size);\r\n}\r\nsmart-scheduler .smart-scheduler-view-all-day .smart-scheduler-event:after {\r\n  top: calc(50% - var(--smart-scheduler-event-resize-indicator-size) / 4);\r\n  left: calc(100% - var(--smart-scheduler-event-resize-indicator-size));\r\n}\r\nsmart-scheduler .smart-scheduler-view-all-day .smart-scheduler-event:before {\r\n  top: calc(50% - var(--smart-scheduler-event-resize-indicator-size) / 4);\r\n  left: 0;\r\n}\r\nsmart-scheduler .smart-scheduler-view-all-day .smart-scheduler-event .smart-scheduler-event-button {\r\n  display: none;\r\n}\r\nsmart-scheduler .smart-scheduler-view-all-day .smart-scheduler-event[repeating] .smart-scheduler-event-content[single-line] {\r\n  grid-template-columns: repeat(2, auto) var(--smart-scheduler-event-icon-size);\r\n}\r\nsmart-scheduler .smart-scheduler-view-all-day .smart-scheduler-event-content {\r\n  grid-template-columns: minmax(auto, 1fr);\r\n}\r\nsmart-scheduler .smart-scheduler-view-all-day .smart-scheduler-event-content[single-line] {\r\n  grid-template-columns: repeat(2, auto);\r\n  grid-template-rows: 100%;\r\n  grid-column-gap: 5px;\r\n  justify-content: space-between;\r\n}\r\nsmart-scheduler .smart-scheduler-view-all-day[exception] .smart-scheduler-event-content, smart-scheduler .smart-scheduler-view-all-day[repeating] .smart-scheduler-event-content {\r\n  grid-template-columns: minmax(auto, 1fr) var(--smart-scheduler-event-icon-size);\r\n}\r\nsmart-scheduler .smart-scheduler-view-all-day-content {\r\n  width: 100%;\r\n  height: 100%;\r\n  position: relative;\r\n  overflow: hidden;\r\n  display: flex;\r\n  flex-direction: column;\r\n}\r\nsmart-scheduler .smart-scheduler-view-all-day-label {\r\n  display: flex;\r\n  justify-content: center;\r\n  align-items: center;\r\n  text-overflow: ellipsis;\r\n  white-space: nowrap;\r\n  width: 100%;\r\n  height: 100%;\r\n  min-width: var(--smart-scheduler-timeline-header-vertical-cells-size);\r\n  font-weight: var(--smart-scheduler-timeline-all-day-label-font-weight);\r\n  padding: var(--smart-scheduler-timeline-header-cell-padding);\r\n}\r\nsmart-scheduler .smart-scheduler-view-all-day-label > div {\r\n  overflow: hidden;\r\n  text-overflow: ellipsis;\r\n}\r\nsmart-scheduler .smart-scheduler-view-all-day-label-container {\r\n  display: flex;\r\n  flex-direction: column;\r\n  overflow: hidden;\r\n}\r\nsmart-scheduler .smart-scheduler-view-details {\r\n  display: flex;\r\n  position: relative;\r\n}\r\nsmart-scheduler .smart-scheduler-view-details .smart-scheduler-cell {\r\n  border-bottom: var(--smart-border-width) solid var(--smart-border);\r\n  height: 100%;\r\n  min-height: inherit;\r\n  min-width: inherit;\r\n}\r\nsmart-scheduler .smart-scheduler-view-details .smart-scheduler-cell:not(:first-of-type) {\r\n  border-left: none;\r\n}\r\nsmart-scheduler .smart-scheduler-view-container {\r\n  position: relative;\r\n}\r\nsmart-scheduler .smart-scheduler-view-label-container {\r\n  display: flex;\r\n  height: 100%;\r\n}\r\nsmart-scheduler .smart-scheduler-view-groups-label-container {\r\n  display: flex;\r\n  height: 100%;\r\n}\r\nsmart-scheduler .smart-scheduler-view-groups-content {\r\n  width: 100%;\r\n  height: 100%;\r\n  position: relative;\r\n  overflow: hidden;\r\n  display: flex;\r\n}\r\nsmart-scheduler .smart-scheduler-view-items-button {\r\n  --smart-button-text-transform: initial;\r\n  transform: scale(1);\r\n  height: 100%;\r\n  width: var(--smart-scheduler-header-menu-button-size);\r\n  border-top-left-radius: var(--smart-item-border-top-left-radius);\r\n  border-bottom-left-radius: var(--smart-item-border-bottom-left-radius);\r\n  border-top-right-radius: var(--smart-item-border-top-right-radius);\r\n  border-bottom-right-radius: var(--smart-item-border-bottom-right-radius);\r\n  overflow: hidden;\r\n}\r\nsmart-scheduler .smart-scheduler-view-items-button:after {\r\n  position: absolute;\r\n  top: 0;\r\n  left: 0;\r\n  width: 100%;\r\n  height: 100%;\r\n  font-family: var(--smart-font-family-icon);\r\n  font-size: var(--smart-arrow-size);\r\n  color: inherit;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  pointer-events: none;\r\n  width: var(--smart-editor-addon-width);\r\n  min-width: var(--smart-editor-addon-width);\r\n  left: initial;\r\n  right: 0;\r\n  content: var(--smart-icon-arrow-down);\r\n  background: transparent;\r\n}\r\nsmart-scheduler .smart-scheduler-view-items-button button {\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  border-radius: initial;\r\n}\r\nsmart-scheduler .smart-scheduler-view-items-button button > span {\r\n  text-overflow: ellipsis;\r\n  overflow: hidden;\r\n}\r\nsmart-scheduler .smart-scheduler-view-items-button:not([active]) button:active {\r\n  color: inherit;\r\n  border-color: inherit;\r\n  background-color: inherit;\r\n}\r\nsmart-scheduler .smart-scheduler-view-items-button.smart-visibility-hidden {\r\n  transform: scale(0);\r\n}\r\nsmart-scheduler[hide-other-month-days] .smart-scheduler-cell[other-month] > div {\r\n  visibility: hidden;\r\n}\r\nsmart-scheduler .smart-scheduler-cells .smart-scheduler-cell:empty {\r\n  display: none;\r\n}\r\nsmart-scheduler .smart-scheduler-cells .smart-scheduler-cell:not(:first-of-type) {\r\n  border-left: none;\r\n}\r\nsmart-scheduler .smart-scheduler-cells div {\r\n  border-bottom-color: var(--smart-border);\r\n  white-space: nowrap;\r\n  pointer-events: none;\r\n}\r\nsmart-scheduler .smart-scheduler-cells-container .smart-scheduler-cell.scale {\r\n  position: relative;\r\n  width: 100%;\r\n  height: 100%;\r\n  min-height: initial;\r\n  min-width: initial;\r\n}\r\nsmart-scheduler .smart-scheduler-cells-container .smart-scheduler-cell:not(.scale)[restricted] {\r\n  background: var(--smart-scheduler-restricted-background);\r\n}\r\nsmart-scheduler .smart-scheduler-cells-container .smart-scheduler-cell[nonworking] {\r\n  background: var(--smart-scheduler-timeline-nonworking-color);\r\n}\r\nsmart-scheduler .smart-scheduler-cells-container .smart-scheduler-cell[nonworking] .smart-scheduler-cell {\r\n  background: var(--smart-scheduler-timeline-nonworking-color);\r\n}\r\nsmart-scheduler .smart-scheduler-cells-container .smart-scheduler-cell[weekend] {\r\n  background: var(--smart-scheduler-timeline-weekend-color);\r\n}\r\nsmart-scheduler .smart-scheduler-cells-container .smart-scheduler-cell-container {\r\n  width: 100%;\r\n  height: 100%;\r\n  overflow: hidden;\r\n  padding: initial;\r\n  display: flex;\r\n  flex-direction: column;\r\n}\r\nsmart-scheduler .smart-scheduler-cells-container .smart-scheduler-cell:not(.scale) {\r\n  width: 100%;\r\n  height: 100%;\r\n  min-height: initial;\r\n  min-width: initial;\r\n}\r\nsmart-scheduler .smart-scheduler-cell {\r\n  position: absolute;\r\n  display: flex;\r\n  justify-content: center;\r\n  align-items: center;\r\n  background: var(--smart-background);\r\n  color: var(--smart-surface-color);\r\n  text-overflow: ellipsis;\r\n  white-space: nowrap;\r\n  padding: var(--smart-scheduler-timeline-header-cell-padding);\r\n  border-bottom-color: transparent;\r\n  height: var(--smart-scheduler-timeline-cell-height);\r\n  min-height: var(--smart-scheduler-timeline-cell-min-height);\r\n  width: var(--smart-scheduler-timeline-cell-width);\r\n  min-width: var(--smart-scheduler-timeline-cell-min-size);\r\n}\r\nsmart-scheduler .smart-scheduler-cell.smart-scheduler-feedback:after {\r\n  content: \'\';\r\n  position: absolute;\r\n  top: 0;\r\n  left: 0;\r\n  width: 100%;\r\n  height: 100%;\r\n  box-sizing: border-box;\r\n  border: 2px dashed var(--smart-primary);\r\n  pointer-events: none;\r\n  background: var(--smart-scheduler-cell-feedback-background);\r\n}\r\nsmart-scheduler .smart-scheduler-cell[other-month] {\r\n  background: var(--smart-background);\r\n  color: var(--smart-background-color);\r\n  border-color: var(--smart-border);\r\n}\r\nsmart-scheduler .smart-scheduler-cell[other-month] > div {\r\n  opacity: 0.5;\r\n}\r\nsmart-scheduler .smart-scheduler-cell.smart-scheduler-view-header-cell-feedback {\r\n  width: initial;\r\n  height: initial;\r\n  visibility: hidden;\r\n}\r\nsmart-scheduler .smart-scheduler-cell-container {\r\n  position: absolute;\r\n  display: flex;\r\n  justify-content: center;\r\n  align-items: center;\r\n  background: var(--smart-background);\r\n  color: var(--smart-surface-color);\r\n  text-overflow: ellipsis;\r\n  white-space: nowrap;\r\n  padding: var(--smart-scheduler-timeline-header-cell-padding);\r\n  border-bottom-color: transparent;\r\n  height: var(--smart-scheduler-timeline-cell-height);\r\n  min-height: var(--smart-scheduler-timeline-cell-min-height);\r\n  width: var(--smart-scheduler-timeline-cell-width);\r\n  min-width: var(--smart-scheduler-timeline-cell-min-size);\r\n}\r\nsmart-scheduler .smart-scheduler-events-container .smart-scheduler-event .smart-scheduler-event-button {\r\n  display: none;\r\n}\r\nsmart-scheduler .smart-scheduler-event {\r\n  position: absolute;\r\n  padding: var(--smart-scheduler-event-padding-basic);\r\n  outline: none;\r\n  -webkit-tap-highlight-color: transparent;\r\n  border-radius: var(--smart-scheduler-event-border-radius);\r\n  -moz-user-select: none;\r\n  -ms-user-select: none;\r\n  -webkit-user-select: none;\r\n  user-select: none;\r\n}\r\nsmart-scheduler .smart-scheduler-event:after {\r\n  left: calc(50% - var(--smart-scheduler-event-resize-indicator-size) / 4);\r\n  top: calc(100% - var(--smart-scheduler-event-resize-indicator-size));\r\n}\r\nsmart-scheduler .smart-scheduler-event:before {\r\n  left: calc(50% - var(--smart-scheduler-event-resize-indicator-size) / 4);\r\n  top: 0;\r\n}\r\nsmart-scheduler .smart-scheduler-event[hover]:not([collector]):before, smart-scheduler .smart-scheduler-event[hover]:not([collector]):after, smart-scheduler .smart-scheduler-event[focus]:not([collector]):before, smart-scheduler .smart-scheduler-event[focus]:not([collector]):after {\r\n  transform: scale(1);\r\n}\r\nsmart-scheduler .smart-scheduler-event:not([resized])[focus] .smart-scheduler-event-content {\r\n  background: var(--smart-scheduler-event-focus);\r\n  color: var(--smart-scheduler-event-color-focus);\r\n}\r\nsmart-scheduler .smart-scheduler-event:not([resized])[hover] .smart-scheduler-event-content {\r\n  background: var(--smart-scheduler-event-hover);\r\n  color: var(--smart-scheduler-event-color-hover);\r\n}\r\nsmart-scheduler .smart-scheduler-event:not([collector]):after, smart-scheduler .smart-scheduler-event:not([collector]):before {\r\n  content: \'\';\r\n  width: var(--smart-scheduler-event-resize-indicator-size);\r\n  height: var(--smart-scheduler-event-resize-indicator-size);\r\n  position: absolute;\r\n  background-color: var(--smart-scheduler-event-resize-indicator-color);\r\n  box-shadow: 0 0 0 1px var(--smart-scheduler-event-resize-indicator-border-color);\r\n  transform: scale(0);\r\n  pointer-events: none;\r\n  z-index: 1;\r\n}\r\nsmart-scheduler .smart-scheduler-event .smart-scheduler-event-button {\r\n  display: none;\r\n}\r\nsmart-scheduler .smart-scheduler-event .smart-scheduler-event-label {\r\n  font-weight: var(--smart-scheduler-event-label-font-weight);\r\n  font-size: var(--smart-scheduler-event-label-font-size);\r\n  pointer-events: none;\r\n  white-space: nowrap;\r\n}\r\nsmart-scheduler .smart-scheduler-event .smart-scheduler-event-time {\r\n  font-weight: var(--smart-scheduler-event-time-font-weight);\r\n  font-size: var(--smart-scheduler-event-time-font-size);\r\n  opacity: var(--smart-scheduler-event-time-opacity);\r\n  pointer-events: none;\r\n  white-space: pre-wrap;\r\n}\r\nsmart-scheduler .smart-scheduler-event .smart-scheduler-event-content > div {\r\n  max-width: 100%;\r\n  max-height: 100%;\r\n  overflow: hidden;\r\n  text-overflow: ellipsis;\r\n  align-self: flex-start;\r\n}\r\nsmart-scheduler .smart-scheduler-event .smart-scheduler-event-content > div:first-of-type {\r\n  align-self: center;\r\n}\r\nsmart-scheduler .smart-scheduler-event .smart-scheduler-event-content:not([single-line]) > div:not(:first-of-type) {\r\n  grid-column: 1 / span 2;\r\n}\r\nsmart-scheduler .smart-scheduler-event .smart-scheduler-event-content[single-line] > div {\r\n  align-self: initial;\r\n}\r\nsmart-scheduler .smart-scheduler-event[resized] {\r\n  opacity: 0.75;\r\n  z-index: 10000;\r\n}\r\nsmart-scheduler .smart-scheduler-event[cut] .smart-scheduler-event-content {\r\n  opacity: 0.75;\r\n}\r\nsmart-scheduler .smart-scheduler-event[collector] {\r\n  width: var(--smart-scheduler-event-collector-size);\r\n  height: var(--smart-scheduler-event-collector-size);\r\n  border-radius: var(--smart-scheduler-event-collector-border-radius);\r\n}\r\nsmart-scheduler .smart-scheduler-event[collector] .smart-scheduler-event-content {\r\n  padding: 1px 5px;\r\n  justify-items: center;\r\n  background: var(--smart-scheduler-event-collector-background);\r\n  color: var(--smart-scheduler-event-collector-color);\r\n  grid-template-rows: minmax(0, 1fr);\r\n  grid-template-columns: minmax(0, 1fr);\r\n  grid-column-gap: 5px;\r\n}\r\nsmart-scheduler .smart-scheduler-event[collector] .smart-scheduler-event-content > div {\r\n  align-self: initial;\r\n  white-space: nowrap;\r\n}\r\nsmart-scheduler .smart-scheduler-event[collector][focus] .smart-scheduler-event-content {\r\n  background: var(--smart-scheduler-event-collector-focus);\r\n  color: var(--smart-scheduler-event-collector-color-focus);\r\n}\r\nsmart-scheduler .smart-scheduler-event[collector][hover] .smart-scheduler-event-content {\r\n  background: var(--smart-scheduler-event-collector-hover);\r\n  color: var(--smart-scheduler-event-collector-color-hover);\r\n}\r\nsmart-scheduler .smart-scheduler-event[repeating] .smart-scheduler-event-content:after {\r\n  content: var(--smart-icon-spin);\r\n  width: var(--smart-scheduler-event-icon-size);\r\n  position: absolute;\r\n  display: flex;\r\n  justify-content: center;\r\n  align-items: center;\r\n  top: 0;\r\n  right: 0;\r\n  font-family: var(--smart-font-family-icon);\r\n  font-size: var(--smart-font-size);\r\n  padding: var(--smart-scheduler-event-content-padding);\r\n  box-sizing: border-box;\r\n  line-height: 1rem;\r\n}\r\nsmart-scheduler .smart-scheduler-event[repeating] .smart-scheduler-event-content[single-line] {\r\n  grid-template-columns: repeat(2, auto) var(--smart-scheduler-event-icon-size);\r\n}\r\nsmart-scheduler .smart-scheduler-event[repeating][exception] .smart-scheduler-event-content:after {\r\n  content: var(--smart-icon-attention-circled);\r\n}\r\nsmart-scheduler .smart-scheduler-event[status] .smart-scheduler-event-content::before {\r\n  content: \'\';\r\n  position: absolute;\r\n  display: block;\r\n  width: var(--smart-scheduler-status-size);\r\n  height: 100%;\r\n  background: var(--smart-scheduler-status-background);\r\n  box-shadow: 0 0 0 0.5px var(--smart-background);\r\n  border: 1px solid var(--smart-border);\r\n  border-radius: 20px;\r\n  overflow: hidden;\r\n  box-sizing: border-box;\r\n}\r\nsmart-scheduler .smart-scheduler-event[status="free"] .smart-scheduler-event-content::before {\r\n  background: var(--smart-scheduler-status-free-background);\r\n}\r\nsmart-scheduler .smart-scheduler-event[status="busy"] .smart-scheduler-event-content::before {\r\n  background: var(--smart-scheduler-status-busy-background);\r\n}\r\nsmart-scheduler .smart-scheduler-event[status="outOfOffice"] .smart-scheduler-event-content::before {\r\n  background: var(--smart-scheduler-status-out-of-office-background);\r\n}\r\nsmart-scheduler .smart-scheduler-event[status="tentative"] .smart-scheduler-event-content::before {\r\n  background: var(--smart-scheduler-status-tentative-background);\r\n}\r\nsmart-scheduler .smart-scheduler-event[exception] .smart-scheduler-event-button, smart-scheduler .smart-scheduler-event[repeating] .smart-scheduler-event-button {\r\n  display: none;\r\n}\r\nsmart-scheduler .smart-scheduler-event[exception] .smart-scheduler-event-content, smart-scheduler .smart-scheduler-event[repeating] .smart-scheduler-event-content {\r\n  grid-template-columns: minmax(auto, 1fr) var(--smart-scheduler-event-icon-size);\r\n}\r\nsmart-scheduler .smart-scheduler-event:not([repeating]) .smart-scheduler-event-content:not([single-line]) > div {\r\n  grid-column: 1 / span 2;\r\n}\r\nsmart-scheduler .smart-scheduler-event-content {\r\n  width: 100%;\r\n  height: 100%;\r\n  max-height: 100%;\r\n  display: grid;\r\n  grid-template-rows: min-content minmax(auto, 1fr);\r\n  justify-content: flex-start;\r\n  justify-items: flex-start;\r\n  align-items: center;\r\n  overflow: hidden;\r\n  padding: var(--smart-scheduler-event-content-padding);\r\n  color: var(--smart-scheduler-event-color);\r\n  background: var(--smart-scheduler-event-background);\r\n  cursor: pointer;\r\n  position: relative;\r\n  border-radius: inherit;\r\n  grid-row-gap: 2px;\r\n  grid-template-columns: minmax(auto, 1fr);\r\n}\r\nsmart-scheduler .smart-scheduler-event-content[single-line] {\r\n  grid-template-columns: repeat(2, auto);\r\n  grid-template-rows: 100%;\r\n  grid-column-gap: 5px;\r\n  justify-content: space-between;\r\n}\r\nsmart-scheduler .smart-scheduler-date-nav {\r\n  grid-area: date;\r\n  display: flex;\r\n  align-items: center;\r\n  height: 100%;\r\n  padding: var(--smart-scheduler-header-padding);\r\n  background: var(--smart-surface);\r\n  background-clip: content-box;\r\n  overflow: hidden;\r\n}\r\nsmart-scheduler .smart-scheduler-date-nav .smart-scheduler-nav[current] {\r\n  --smart-button-padding: 0 10px 0 10px;\r\n  width: auto;\r\n  max-width: var(--smart-scheduler-header-date-button-max-size);\r\n  border-top-right-radius: var(--smart-item-border-top-right-radius);\r\n  border-bottom-right-radius: var(--smart-item-border-bottom-right-radius);\r\n  border-top-left-radius: var(--smart-item-border-top-left-radius);\r\n  border-bottom-left-radius: var(--smart-item-border-bottom-left-radius);\r\n}\r\nsmart-scheduler .smart-scheduler-date-nav .smart-scheduler-nav[current] .smart-button {\r\n  overflow: hidden;\r\n  text-overflow: ellipsis;\r\n  white-space: nowrap;\r\n}\r\nsmart-scheduler .smart-scheduler-time-zone {\r\n  width: var(--smart-scheduler-timeline-header-vertical-cells-size);\r\n  overflow: hidden;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  padding: var(--smart-scheduler-timeline-header-cell-padding);\r\n}\r\nsmart-scheduler .smart-scheduler-time-zone > div {\r\n  overflow: hidden;\r\n  text-overflow: ellipsis;\r\n}\r\nsmart-scheduler .smart-scheduler-time-zone-container {\r\n  display: flex;\r\n  height: 100%;\r\n  align-items: center;\r\n}\r\nsmart-scheduler .smart-scheduler-time-zone-container:empty {\r\n  display: none;\r\n}\r\nsmart-scheduler .smart-scheduler-current-time-indicator {\r\n  position: absolute;\r\n  pointer-events: none;\r\n  width: var(--smart-scheduler-current-time-indicator-size);\r\n  height: var(--smart-scheduler-current-time-indicator-size);\r\n  background: var(--smart-scheduler-current-time-indicator-background);\r\n}\r\nsmart-scheduler .smart-scheduler-items-container {\r\n  display: flex;\r\n  align-items: center;\r\n  height: 100%;\r\n  position: relative;\r\n  outline: none;\r\n}\r\nsmart-scheduler .smart-scheduler-items-container .smart-scheduler-item[selected] {\r\n  background: var(--smart-background);\r\n  border-left: var(--smart-border-width) solid var(--smart-border);\r\n  border-right: var(--smart-border-width) solid var(--smart-border);\r\n  border-top: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler .smart-scheduler-items-container:focus .smart-scheduler-item[selected] {\r\n  background-color: var(--smart-ui-state-focus);\r\n  border-color: var(--smart-ui-state-border-focus);\r\n  color: var(--smart-ui-state-color-focus);\r\n}\r\nsmart-scheduler .smart-scheduler-items-container .smart-scheduler-item {\r\n  position: relative;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  cursor: pointer;\r\n  height: 100%;\r\n  width: var(--smart-scheduler-item-size);\r\n  padding: var(--smart-scheduler-header-padding);\r\n  border: var(--smart-border-width) solid transparent;\r\n}\r\nsmart-scheduler .smart-scheduler-items-container .smart-scheduler-item:last-of-type {\r\n  border-right: none;\r\n}\r\nsmart-scheduler .smart-scheduler-item > div {\r\n  position: relative;\r\n  align-items: center;\r\n  overflow: hidden;\r\n  text-overflow: ellipsis;\r\n  white-space: nowrap;\r\n}\r\nsmart-scheduler .smart-scheduler-groups-container {\r\n  display: flex;\r\n  width: 100%;\r\n  height: 100%;\r\n  overflow: hidden;\r\n}\r\nsmart-scheduler .smart-scheduler-groups-container .smart-scheduler-cell {\r\n  font-weight: var(--smart-scheduler-timeline-all-day-label-font-weight);\r\n  white-space: var(--smart-scheduler-timeline-group-white-space);\r\n  min-height: inherit;\r\n  min-width: inherit;\r\n}\r\nsmart-scheduler .smart-scheduler-groups-container .smart-scheduler-cell > div {\r\n  overflow: hidden;\r\n  text-overflow: ellipsis;\r\n}\r\nsmart-scheduler .smart-scheduler-groups-container .smart-scheduler-cell:not(:first-of-type) {\r\n  border-left: none;\r\n}\r\nsmart-scheduler .smart-scheduler-scrollable-container {\r\n  width: 100%;\r\n  position: relative;\r\n  overflow: hidden;\r\n  display: grid;\r\n  grid-area: content;\r\n  height: 100%;\r\n  background: var(--smart-scheduler-view-background);\r\n}\r\nsmart-scheduler .smart-scheduler-content {\r\n  position: relative;\r\n  overflow: hidden;\r\n  width: 100%;\r\n  height: 100%;\r\n}\r\nsmart-scheduler .smart-scheduler-content .smart-scheduler-cell[nonworking] {\r\n  background: var(--smart-scheduler-timeline-nonworking-color);\r\n}\r\nsmart-scheduler .smart-scheduler-content .smart-scheduler-cell[weekend] {\r\n  background: var(--smart-scheduler-timeline-weekend-color);\r\n}\r\nsmart-scheduler .smart-scheduler-view-scroll-bar {\r\n  overflow: visible;\r\n  position: relative;\r\n  height: var(--smart-scroll-bar-size);\r\n  width: 100%;\r\n}\r\nsmart-scheduler .smart-scheduler-view-scroll-bar:after {\r\n  position: absolute;\r\n  content: \'\';\r\n  width: 100%;\r\n  height: var(--smart-scroll-bar-size);\r\n  background: var(--smart-scroll-bar-background);\r\n  left: 100%;\r\n  top: 0;\r\n}\r\nsmart-scheduler .smart-scheduler-view-scroll-bar.bottom-corner {\r\n  width: calc(100% - var(--smart-scroll-bar-size));\r\n}\r\nsmart-scheduler .smart-scheduler-view-scroll-bar[orientation="vertical"] {\r\n  position: absolute;\r\n  right: 0;\r\n  top: 0;\r\n  height: 100%;\r\n  width: var(--smart-scroll-bar-size);\r\n}\r\nsmart-scheduler .smart-scheduler-view-scroll-bar[orientation="vertical"].bottom-corner {\r\n  height: calc(100% - var(--smart-scroll-bar-size));\r\n}\r\nsmart-scheduler .smart-scheduler-tooltip {\r\n  pointer-events: none;\r\n  transform: scale(0);\r\n}\r\nsmart-scheduler .smart-toast-container-custom.smart-toast-container {\r\n  width: var(--smart-scheduler-toast-default-width);\r\n  top: 0;\r\n  right: 0;\r\n  max-width: 100%;\r\n  max-height: 100%;\r\n  height: auto;\r\n}\r\nsmart-scheduler .smart-toast-container-custom.smart-toast-container .smart-toast-item {\r\n  border-radius: 5px;\r\n  height: var(--smart-scheduler-toast-default-height);\r\n}\r\nsmart-scheduler .smart-toast-container-custom.smart-toast-container .smart-toast-item > .smart-container {\r\n  display: flex;\r\n  flex-direction: row-reverse;\r\n}\r\nsmart-scheduler .smart-toast-container-custom.smart-toast-container .smart-toast-item .smart-toast-item-container {\r\n  padding: initial;\r\n  top: initial;\r\n  width: 100%;\r\n}\r\nsmart-scheduler .smart-scheduler-legend {\r\n  width: 100%;\r\n  height: 100%;\r\n  display: flex;\r\n  grid-row-gap: 10px;\r\n  grid-column-gap: 10px;\r\n  grid-area: legend;\r\n}\r\nsmart-scheduler .smart-scheduler-legend .smart-scheduler-legend-list {\r\n  width: 30px;\r\n  background: transparent;\r\n  border: none;\r\n  font-family: var(--smart-font-family-icon);\r\n}\r\nsmart-scheduler .smart-scheduler-legend .smart-scheduler-legend-list input {\r\n  display: none;\r\n}\r\nsmart-scheduler .smart-scheduler-legend .smart-scheduler-legend-list .smart-container::before {\r\n  content: var(--smart-icon-menu);\r\n  background: var(--smart-surface);\r\n  position: absolute;\r\n  width: 100%;\r\n  height: 100%;\r\n  left: calc(50% - 8px);\r\n  top: calc(50% - 8px);\r\n}\r\nsmart-scheduler .smart-scheduler-legend .smart-scheduler-legend-item {\r\n  display: flex;\r\n  flex-direction: column;\r\n  justify-content: center;\r\n  max-width: 100%;\r\n  padding: var(--smart-scheduler-header-padding);\r\n  overflow: hidden;\r\n  grid-row-gap: 2px;\r\n}\r\nsmart-scheduler .smart-scheduler-legend .smart-scheduler-legend-res-items {\r\n  display: flex;\r\n  /* grid-column-gap: 20px; */\r\n  /* Safari does not support column-gap with Flexbox */\r\n}\r\nsmart-scheduler .smart-scheduler-legend .smart-scheduler-legend-res-item {\r\n  position: relative;\r\n  display: flex;\r\n  align-items: center;\r\n  grid-column-gap: 5px;\r\n  white-space: nowrap;\r\n  outline: initial;\r\n  overflow: hidden;\r\n}\r\nsmart-scheduler .smart-scheduler-legend .smart-scheduler-legend-res-item:hover {\r\n  color: var(--smart-ui-state-color-hover);\r\n}\r\nsmart-scheduler .smart-scheduler-legend .smart-scheduler-legend-res-item:before {\r\n  content: \'\';\r\n  width: var(--smart-check-box-default-size);\r\n  min-width: var(--smart-check-box-default-size);\r\n  height: var(--smart-check-box-default-size);\r\n  min-height: var(--smart-check-box-default-size);\r\n  display: flex;\r\n  border: var(--smart-border-width) solid var(--smart-border);\r\n  box-sizing: border-box;\r\n  background-color: var(--smart-scheduler-legend-item-background);\r\n  border-radius: var(--smart-border-radius);\r\n}\r\nsmart-scheduler .smart-scheduler-legend .smart-scheduler-legend-res-item:not(:first-of-type) {\r\n  margin-left: 20px;\r\n}\r\nsmart-scheduler .smart-scheduler-legend .smart-scheduler-legend-res-item > span {\r\n  overflow: hidden;\r\n  text-overflow: ellipsis;\r\n  pointer-events: none;\r\n}\r\n@media only screen and (min-device-width: 320px) and (max-device-width: 900px) {\r\n  smart-scheduler .smart-scheduler-legend .smart-scheduler-legend-res-item > span {\r\n    width: 0;\r\n  }\r\n}\r\nsmart-scheduler .smart-scheduler-window-modal {\r\n  position: absolute;\r\n  opacity: 0.5;\r\n  background-color: var(--smart-disabled);\r\n  top: 0;\r\n  left: 0;\r\n  width: 100%;\r\n  min-height: 100%;\r\n  z-index: calc(var(--smart-editor-drop-down-z-index) - 1);\r\n}\r\nsmart-scheduler .smart-scheduler-shade-section {\r\n  position: absolute;\r\n  pointer-events: none;\r\n  background: var(--smart-scheduler-shader-background);\r\n}\r\nsmart-scheduler .smart-scheduler-item > div,\r\nsmart-scheduler .smart-scheduler-view-header-horizontal .smart-scheduler-cell,\r\nsmart-scheduler .smart-scheduler-view-header-vertical .smart-scheduler-cell,\r\nsmart-scheduler .smart-scheduler-cells-container .smart-scheduler-cell:not(.scale) > div,\r\nsmart-scheduler .smart-scheduler-view-all-day-label {\r\n  -moz-user-select: none;\r\n  -ms-user-select: none;\r\n  -webkit-user-select: none;\r\n  user-select: none;\r\n}\r\nsmart-scheduler:not([animation="none"]) .smart-scheduler-legend .smart-scheduler-legend-res-item:before {\r\n  transition: background linear 0.2s, border linear 0.2s;\r\n}\r\nsmart-scheduler:not([animation="none"]) .smart-scheduler-event:after, smart-scheduler:not([animation="none"]) .smart-scheduler-event:before,\r\nsmart-scheduler:not([animation="none"]) .smart-scheduler-event:after,\r\nsmart-scheduler:not([animation="none"]) .smart-scheduler-event:before {\r\n  transition: transform 0.2s cubic-bezier(0.4, 0, 0.6, 1);\r\n}\r\nsmart-scheduler:not([animation="none"]) .smart-scheduler-view-items-button {\r\n  transition: transform 0.2s ease-in-out;\r\n}\r\nsmart-scheduler:not([animation="none"]) .smart-scheduler-items-container .smart-scheduler-item {\r\n  transition: border-top 0.2s ease-in-out;\r\n}\r\nsmart-scheduler:not([event-render-mode="classic"]) .smart-scheduler-event {\r\n  padding-right: initial;\r\n}\r\nsmart-scheduler:not([disable-date-menu]):not([right-to-left]) .smart-scheduler-nav[current] button {\r\n  padding-right: var(--smart-editor-addon-width);\r\n}\r\nsmart-scheduler:not([disable-view-menu]):not([right-to-left]) .smart-scheduler-view-items-button button {\r\n  padding-right: var(--smart-editor-addon-width);\r\n}\r\nsmart-scheduler:not([view-type^="timeline"]) .smart-scheduler-cells-container .smart-scheduler-cell:not(.scale):not(:last-of-type) {\r\n  border-right: var(--smart-scheduler-view-line-size) solid var(--smart-scheduler-view-vertical-line-color);\r\n}\r\nsmart-scheduler:not([view-type^="timeline"]) .smart-scheduler-cells-container .smart-scheduler-cell.scale:not(:last-of-type) {\r\n  border-bottom: var(--smart-border-width) solid rgba(var(--smart-border-rgb), .5);\r\n}\r\nsmart-scheduler:not([view-type^="timeline"]) .smart-scheduler-cells-container .smart-scheduler-cell-container:not(:last-of-type) {\r\n  border-bottom: var(--smart-scheduler-view-line-size) solid var(--smart-scheduler-view-horizontal-line-color);\r\n}\r\nsmart-scheduler:not([view-type^="timeline"]) .smart-scheduler-view-header-horizontal .smart-scheduler-time-zone {\r\n  width: var(--smart-scheduler-timeline-header-vertical-cells-size);\r\n  height: 100%;\r\n}\r\nsmart-scheduler:not([view-type^="timeline"]) .smart-scheduler-current-time-indicator:before {\r\n  left: 0;\r\n  top: calc(-1 * var(--smart-scheduler-current-time-indicator-arrow-size) + var(--smart-scheduler-current-time-indicator-size) / 2);\r\n  border-top: var(--smart-scheduler-current-time-indicator-arrow-size) solid transparent;\r\n  border-bottom: var(--smart-scheduler-current-time-indicator-arrow-size) solid transparent;\r\n  border-left: var(--smart-scheduler-current-time-indicator-arrow-size) solid var(--smart-scheduler-current-time-indicator-background);\r\n}\r\nsmart-scheduler:not([view-type^="timeline"]) .smart-scheduler-event {\r\n  width: var(--smart-scheduler-event-size);\r\n}\r\nsmart-scheduler:not([view-type="timelineDay"]) .smart-scheduler-view-header-horizontal .smart-scheduler-cells:not(:last-of-type) .smart-scheduler-cell {\r\n  border-bottom: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler:not([view-type="timelineWeek"]) .smart-scheduler-view-details {\r\n  display: none;\r\n}\r\nsmart-scheduler:not([view-type="timelineWeek"]) .smart-scheduler-view-details-label:empty {\r\n  display: none;\r\n}\r\nsmart-scheduler:not([view-type="day"]) .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-view-header-groups-container .smart-scheduler-cell-container:not(:last-of-type) > .smart-scheduler-cell {\r\n  border-right: var(--smart-scheduler-view-line-size) solid var(--smart-scheduler-view-vertical-line-color);\r\n}\r\nsmart-scheduler:not([view-type="day"]):not([view-type^="timeline"]) .smart-scheduler-view-label-container:empty, smart-scheduler:not([view-type="day"]):not([view-type="agenda"]) .smart-scheduler-view-header-vertical .smart-scheduler-cell,\r\nsmart-scheduler:not([view-type="day"]) .smart-scheduler-view-header-cell-feedback {\r\n  border-right: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler:not([view-type="month"]) .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-view-label-container:before {\r\n  content: \'\';\r\n  width: var(--smart-scheduler-timeline-header-vertical-group-size);\r\n  height: 100%;\r\n  display: flex;\r\n}\r\nsmart-scheduler:not([view-type="month"]) .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-view-all-day-label-container {\r\n  margin-left: var(--smart-scheduler-timeline-header-vertical-group-size);\r\n}\r\nsmart-scheduler:not([view-type="agenda"]) .smart-scheduler-view-header-vertical-content .smart-scheduler-cell:not(:first-of-type) > div {\r\n  transform: translateY(calc(-50% - var(--smart-scheduler-timeline-header-cell-padding)));\r\n}\r\nsmart-scheduler:not([view-type="agenda"]) .smart-scheduler-event[status] .smart-scheduler-event-content {\r\n  padding-left: calc(var(--smart-scheduler-status-size) + var(--smart-scheduler-status-padding));\r\n  border-top-left-radius: 5px;\r\n  border-bottom-left-radius: 5px;\r\n}\r\nsmart-scheduler:not([view-type="agenda"]) .smart-scheduler-cells-container .smart-scheduler-cell:not(.scale):hover,\r\nsmart-scheduler:not([view-type="agenda"]) .smart-scheduler-view-all-day .smart-scheduler-cell:hover {\r\n  background: var(--smart-ui-state-hover);\r\n  color: var(--smart-ui-state-color-hover);\r\n}\r\nsmart-scheduler:not([view-type="agenda"])[group-by-date] .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-view-header-vertical .smart-scheduler-view-time .smart-scheduler-cell:not([group-separator]) > div {\r\n  display: none;\r\n}\r\nsmart-scheduler[view-type]:not([view-type="day"]) .smart-scheduler-view-all-day-label, smart-scheduler[view-type]:not([view-type="day"]):not([view-type="agenda"]) .smart-scheduler-time-zone:last-of-type {\r\n  border-right: var(--smart-scheduler-view-line-size) solid var(--smart-scheduler-view-vertical-line-color);\r\n}\r\nsmart-scheduler[view-type^="timeline"] {\r\n  --smart-scheduler-event-size: var(--smart-scheduler-event-size-timeline);\r\n}\r\nsmart-scheduler[view-type^="timeline"] .smart-scheduler-view-label-container {\r\n  flex-direction: column;\r\n}\r\nsmart-scheduler[view-type^="timeline"] .smart-scheduler-cells .smart-scheduler-cell > div {\r\n  text-overflow: ellipsis;\r\n  overflow: hidden;\r\n}\r\nsmart-scheduler[view-type^="timeline"][group-by-date] .smart-scheduler-view-header-horizontal-content .smart-scheduler-cell {\r\n  overflow: initial;\r\n}\r\nsmart-scheduler[view-type^="timeline"] .smart-scheduler-time-zone {\r\n  height: var(--smart-scheduler-timeline-header-horizontal-cells-size);\r\n  border-right: var(--smart-scheduler-view-line-size) solid var(--smart-scheduler-view-vertical-line-color);\r\n}\r\nsmart-scheduler[view-type^="timeline"] .smart-scheduler-view:not([show-vertical-header]) {\r\n  --smart-scheduler-timeline-header-vertical-cells-size: 0;\r\n}\r\nsmart-scheduler[view-type^="timeline"] .smart-scheduler-view[show-vertical-header][show-group-header="horizontal"] .smart-scheduler-view-details-label {\r\n  border-right: var(--smart-scheduler-view-line-size) solid var(--smart-scheduler-view-vertical-line-color);\r\n}\r\nsmart-scheduler[view-type^="timeline"] .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-view-label-container {\r\n  border-right: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler[view-type^="timeline"] .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-view-header-vertical {\r\n  grid-template-columns: auto 0;\r\n}\r\nsmart-scheduler[view-type^="timeline"] .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-view-header-horizontal .smart-scheduler-view-time-container {\r\n  grid-template-columns: var(--smart-scheduler-timeline-header-vertical-group-size) minmax(0, 1fr);\r\n}\r\nsmart-scheduler[view-type^="timeline"] .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-current-time-indicator:not(:first-of-type)::before {\r\n  content: none;\r\n}\r\nsmart-scheduler[view-type^="timeline"] .smart-scheduler-time-zone-container {\r\n  height: auto;\r\n  flex-direction: column;\r\n}\r\nsmart-scheduler[view-type^="timeline"] .smart-scheduler-view-time {\r\n  flex-direction: column;\r\n}\r\nsmart-scheduler[view-type^="timeline"] .smart-scheduler-event {\r\n  padding: var(--smart-scheduler-event-padding-timeline);\r\n  height: var(--smart-scheduler-event-size);\r\n}\r\nsmart-scheduler[view-type^="timeline"] .smart-scheduler-event:after {\r\n  top: calc(50% - var(--smart-scheduler-event-resize-indicator-size) / 4);\r\n  left: calc(100% - var(--smart-scheduler-event-resize-indicator-size));\r\n}\r\nsmart-scheduler[view-type^="timeline"] .smart-scheduler-event:before {\r\n  top: calc(50% - var(--smart-scheduler-event-resize-indicator-size) / 4);\r\n  left: 0;\r\n}\r\nsmart-scheduler[view-type^="timeline"] .smart-scheduler-cells-container .smart-scheduler-cell.scale:not(:last-of-type) {\r\n  border-right: var(--smart-border-width) solid rgba(var(--smart-border-rgb), .5);\r\n}\r\nsmart-scheduler[view-type^="timeline"] .smart-scheduler-cells-container .smart-scheduler-cell-container {\r\n  flex-direction: row;\r\n}\r\nsmart-scheduler[view-type^="timeline"] .smart-scheduler-cells-container .smart-scheduler-cell-container:not(:last-of-type) {\r\n  border-right: var(--smart-scheduler-view-line-size) solid var(--smart-scheduler-view-vertical-line-color);\r\n}\r\nsmart-scheduler[view-type^="timeline"] .smart-scheduler-cells-container .smart-scheduler-cell:not(.scale):not(:last-of-type) {\r\n  border-bottom: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler[view-type^="timeline"] .smart-scheduler-current-time-indicator:before {\r\n  left: calc(-1 * var(--smart-scheduler-current-time-indicator-arrow-size) + var(--smart-scheduler-current-time-indicator-size) / 2);\r\n  border-right: var(--smart-scheduler-current-time-indicator-arrow-size) solid transparent;\r\n  border-left: var(--smart-scheduler-current-time-indicator-arrow-size) solid transparent;\r\n  border-top: var(--smart-scheduler-current-time-indicator-arrow-size) solid var(--smart-scheduler-current-time-indicator-background);\r\n}\r\nsmart-scheduler[view-type^="timeline"]:not([event-render-mode="classic"]) .smart-scheduler-event {\r\n  padding-bottom: 0;\r\n}\r\nsmart-scheduler[view-type^="timeline"] .smart-scheduler-view-all-day {\r\n  display: none;\r\n}\r\nsmart-scheduler[view-type="timelineWeek"] .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-view-details-label {\r\n  display: none;\r\n}\r\nsmart-scheduler[view-type="timelineWeek"] .smart-scheduler-view[show-vertical-header] .smart-scheduler-view-details-label {\r\n  border-right: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler[view-type="timelineWeek"] .smart-scheduler-view-label-container {\r\n  display: flex;\r\n  flex-direction: column;\r\n}\r\nsmart-scheduler[view-type="timelineWeek"] .smart-scheduler-view-details-label {\r\n  height: var(--smart-scheduler-timeline-header-horizontal-details-size);\r\n  width: 100%;\r\n}\r\nsmart-scheduler[view-type="timelineWeek"] .smart-scheduler-view-details:empty {\r\n  display: none;\r\n}\r\nsmart-scheduler[view-type="day"] .smart-scheduler-view {\r\n  grid-template-rows: auto minmax(0, 1fr);\r\n}\r\nsmart-scheduler[view-type="day"] .smart-scheduler-view[show-group-header="horizontal"] .smart-scheduler-current-time-indicator:not(:first-of-type)::before {\r\n  content: none;\r\n}\r\nsmart-scheduler[view-type="day"] .smart-scheduler-cells-container .smart-scheduler-cell:not(.scale):not(:last-of-type) {\r\n  border-right: var(--smart-scheduler-day-week-view-vertical-line-size) solid var(--smart-scheduler-day-week-view-vertical-line-color);\r\n}\r\nsmart-scheduler[view-type="day"] .smart-scheduler-cells-container .smart-scheduler-cell-container:not(:last-of-type) {\r\n  border-bottom: var(--smart-scheduler-day-week-view-hour-size) solid var(--smart-scheduler-day-week-view-hour-color);\r\n}\r\nsmart-scheduler[view-type="day"] .smart-scheduler-view-header-horizontal .smart-scheduler-view-time-container {\r\n  display: none;\r\n}\r\nsmart-scheduler[view-type="day"] .smart-scheduler-view-header-horizontal .smart-scheduler-cell {\r\n  border-right: var(--smart-scheduler-day-week-view-vertical-line-size) solid var(--smart-scheduler-day-week-view-vertical-line-color);\r\n}\r\nsmart-scheduler[view-type="day"] .smart-scheduler-view-header-horizontal .smart-scheduler-view-groups-label-container {\r\n  border-bottom: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler[view-type="week"] .smart-scheduler-cells-container .smart-scheduler-cell:not(.scale):not(:last-of-type) {\r\n  border-right: var(--smart-scheduler-day-week-view-vertical-line-size) solid var(--smart-scheduler-day-week-view-vertical-line-color);\r\n}\r\nsmart-scheduler[view-type="week"] .smart-scheduler-cells-container .smart-scheduler-cell-container:not(:last-of-type) {\r\n  border-bottom: var(--smart-scheduler-day-week-view-hour-size) solid var(--smart-scheduler-day-week-view-hour-color);\r\n}\r\nsmart-scheduler[view-type="week"] .smart-scheduler-view-header-horizontal .smart-scheduler-cell {\r\n  border-right: var(--smart-scheduler-day-week-view-vertical-line-size) solid var(--smart-scheduler-day-week-view-vertical-line-color);\r\n}\r\nsmart-scheduler[view-type="month"] .smart-scheduler-event {\r\n  height: var(--smart-scheduler-event-size);\r\n}\r\nsmart-scheduler[view-type="month"] .smart-scheduler-event:after {\r\n  top: calc(50% - var(--smart-scheduler-event-resize-indicator-size) / 4);\r\n  left: calc(100% - var(--smart-scheduler-event-resize-indicator-size));\r\n}\r\nsmart-scheduler[view-type="month"] .smart-scheduler-event:before {\r\n  top: calc(50% - var(--smart-scheduler-event-resize-indicator-size) / 4);\r\n  left: 0;\r\n}\r\nsmart-scheduler[view-type="month"] .smart-scheduler-view-header-horizontal .smart-scheduler-view-all-day,\r\nsmart-scheduler[view-type="month"] .smart-scheduler-view:not([show-group-header="vertical"]) .smart-scheduler-view-header-vertical,\r\nsmart-scheduler[view-type="month"] .smart-scheduler-view:not([show-group-header="vertical"]) .smart-scheduler-view-label-container {\r\n  display: none;\r\n}\r\nsmart-scheduler[view-type="month"]:not([event-render-mode="classic"]) .smart-scheduler-event {\r\n  padding-bottom: 0;\r\n}\r\nsmart-scheduler[view-type="month"] .smart-scheduler-view-header-vertical-content {\r\n  display: none;\r\n}\r\nsmart-scheduler[view-type="month"] .smart-scheduler-content {\r\n  grid-template-columns: 100%;\r\n}\r\nsmart-scheduler[view-type="month"] .smart-scheduler-content .smart-scheduler-cell[nonworking][other-month]:not([selected]) {\r\n  background: var(--smart-scheduler-timeline-nonworking-color);\r\n}\r\nsmart-scheduler[view-type="month"] .smart-scheduler-cells-container .smart-scheduler-cell:not(.scale) {\r\n  justify-content: flex-end;\r\n  align-items: flex-start;\r\n}\r\nsmart-scheduler[view-type="month"] .smart-scheduler-cells-container .smart-scheduler-cell:not(.scale)[today] > div:not([class]) {\r\n  border-radius: 50%;\r\n  background: var(--smart-primary);\r\n  color: var(--smart-primary-color);\r\n  box-shadow: 0 0 0 2px var(--smart-primary);\r\n  width: calc(var(--smart-scheduler-month-view-number-size) / 1.5);\r\n  height: calc(var(--smart-scheduler-month-view-number-size) / 1.5);\r\n}\r\nsmart-scheduler[view-type="month"] .smart-scheduler-scrollable-container {\r\n  grid-template-columns: 100%;\r\n}\r\nsmart-scheduler[view-type="month"] .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-view-header-vertical {\r\n  grid-template-columns: auto 0;\r\n}\r\nsmart-scheduler[view-type="month"] .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-view-header-horizontal .smart-scheduler-view-time-container {\r\n  grid-template-columns: var(--smart-scheduler-timeline-header-vertical-group-size) minmax(0, 1fr);\r\n}\r\nsmart-scheduler[view-type="month"] .smart-scheduler-view:not([mobile]) .smart-scheduler-event[collector] {\r\n  padding-right: calc(var(--smart-scheduler-month-view-number-size) + 5px);\r\n}\r\nsmart-scheduler[view-type="month"] .smart-scheduler-view:not([mobile]) .smart-scheduler-event[collector][first-month-day] {\r\n  padding-right: calc(var(--smart-scheduler-month-view-number-size) + 25px);\r\n}\r\nsmart-scheduler[view-type="month"] .smart-scheduler-view-header-horizontal .smart-scheduler-view-time-container,\r\nsmart-scheduler[view-type="month"] .smart-scheduler-view-all-day {\r\n  grid-template-columns: minmax(0, 1fr);\r\n}\r\nsmart-scheduler[view-type="agenda"] {\r\n  --smart-scheduler-timeline-header-vertical-label-padding: 0 0 0 25%;\r\n  --smart-scheduler-event-time-font-weight: 600;\r\n}\r\nsmart-scheduler[view-type="agenda"] .smart-scheduler-cells-container .smart-scheduler-cell-container {\r\n  overflow: initial;\r\n}\r\nsmart-scheduler[view-type="agenda"] .smart-scheduler-cells-container .smart-scheduler-cell-container:not([separator]) {\r\n  border: none;\r\n}\r\nsmart-scheduler[view-type="agenda"] .smart-scheduler-view-header-vertical .smart-scheduler-cell {\r\n  justify-content: flex-start;\r\n}\r\nsmart-scheduler[view-type="agenda"] .smart-scheduler-view-header-vertical .smart-scheduler-cell > div {\r\n  text-align: left;\r\n}\r\nsmart-scheduler[view-type="agenda"] .smart-scheduler-view-header-horizontal {\r\n  grid-template-rows: auto minmax(0, 1fr);\r\n}\r\nsmart-scheduler[view-type="agenda"] .smart-scheduler-view-header-horizontal .smart-scheduler-view-time-container {\r\n  height: 0;\r\n  border: none;\r\n}\r\nsmart-scheduler[view-type="agenda"] .smart-scheduler-view-header-horizontal .smart-scheduler-view-groups-label-container {\r\n  border-bottom: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler[view-type="agenda"] .smart-scheduler-view-header-horizontal .smart-scheduler-view-all-day {\r\n  display: none;\r\n}\r\nsmart-scheduler[view-type="agenda"] .smart-scheduler-view-header-vertical .smart-scheduler-cell[separator]:last-of-type > .smart-scheduler-cell:after,\r\nsmart-scheduler[view-type="agenda"] .smart-scheduler-cells-container .smart-scheduler-cell-container[separator]:last-of-type > .smart-scheduler-cell:after {\r\n  border-bottom: var(--smart-border-width) solid var(--smart-border);\r\n  content: \'\';\r\n  height: 100%;\r\n  width: 100%;\r\n  position: absolute;\r\n  top: var(--smart-border-width);\r\n  left: 0;\r\n  box-sizing: border-box;\r\n  pointer-events: none;\r\n}\r\nsmart-scheduler[view-type="agenda"] .smart-scheduler-view-header-vertical .smart-scheduler-cell[separator]:not(:last-of-type),\r\nsmart-scheduler[view-type="agenda"] .smart-scheduler-cells-container .smart-scheduler-cell-container[separator]:not(:last-of-type) {\r\n  border-bottom: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler[view-type="agenda"] .smart-scheduler-cell.smart-scheduler-view-header-cell-feedback {\r\n  padding: calc(2 * var(--smart-scheduler-timeline-header-cell-padding));\r\n}\r\nsmart-scheduler[view-type="agenda"] .smart-scheduler-view.no-agenda:after {\r\n  /* content: var(--smart-scheduler-no-agenda-placeholder); */\r\n  content: attr(agenda-placeholder);\r\n  width: 100%;\r\n  height: 100%;\r\n  position: absolute;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  pointer-events: none;\r\n  text-overflow: ellipsis;\r\n  overflow: hidden;\r\n}\r\nsmart-scheduler[view-type="agenda"] .smart-scheduler-event {\r\n  padding: var(--smart-scheduler-event-padding-agenda);\r\n}\r\nsmart-scheduler[view-type="agenda"] .smart-scheduler-event:not([collector]):not([disable-resize]):after, smart-scheduler[view-type="agenda"] .smart-scheduler-event:not([collector]):not([disable-resize]):before, smart-scheduler[view-type="agenda"] .smart-scheduler-event:not([collector]):not([disable-resize]):after, smart-scheduler[view-type="agenda"] .smart-scheduler-event:not([collector]):not([disable-resize]):before {\r\n  content: initial;\r\n}\r\nsmart-scheduler[view-type="agenda"] .smart-scheduler-event .smart-scheduler-event-time {\r\n  opacity: var(--smart-scheduler-event-time-opacity-agenda);\r\n  font-size: var(--smart-scheduler-event-time-font-size-agenda);\r\n  font-weight: var(--smart-scheduler-event-time-font-weight-agenda);\r\n}\r\nsmart-scheduler[view-type="agenda"] .smart-scheduler-event[status] .smart-scheduler-event-content::before {\r\n  content: initial;\r\n}\r\nsmart-scheduler[view-type="agenda"]:not([event-render-mode="classic"]) .smart-scheduler-event {\r\n  padding-bottom: 0;\r\n}\r\nsmart-scheduler:not([filterable]) .smart-scheduler-legend {\r\n  opacity: 0.55;\r\n  cursor: default;\r\n  pointer-events: none;\r\n}\r\nsmart-scheduler[filterable] .smart-scheduler-legend .smart-scheduler-legend-res-item {\r\n  cursor: pointer;\r\n  -moz-user-select: none;\r\n  -ms-user-select: none;\r\n  -webkit-user-select: none;\r\n  user-select: none;\r\n}\r\nsmart-scheduler[filterable] .smart-scheduler-legend .smart-scheduler-legend-res-item:hover:before {\r\n  border-color: var(--smart-ui-state-border-hover);\r\n}\r\nsmart-scheduler[filterable] .smart-scheduler-legend .smart-scheduler-legend-res-item:focus:before {\r\n  border-color: var(--smart-primary);\r\n}\r\nsmart-scheduler[filterable] .smart-scheduler-legend .smart-scheduler-legend-res-item[unselected]:before {\r\n  background: transparent;\r\n}\r\nsmart-scheduler[filterable] .smart-scheduler-legend .smart-scheduler-legend-res-item[disabled] {\r\n  opacity: 0.55;\r\n  cursor: default;\r\n  pointer-events: none;\r\n}\r\nsmart-scheduler[group-by-date] .smart-scheduler-view[show-group-header="horizontal"] .smart-scheduler-view-header-horizontal .smart-scheduler-view-time-container {\r\n  border-bottom: initial;\r\n}\r\nsmart-scheduler[group-by-date] .smart-scheduler-view[show-group-header="horizontal"] .smart-scheduler-view-header-horizontal .smart-scheduler-view-time .smart-scheduler-cell:not([show-label]) > div {\r\n  display: none;\r\n}\r\nsmart-scheduler[group-by-date] .smart-scheduler-view[show-group-header="horizontal"] .smart-scheduler-view-header-horizontal .smart-scheduler-view-time .smart-scheduler-cell:not([group-separator]) {\r\n  border-right: initial;\r\n}\r\nsmart-scheduler[group-by-date] .smart-scheduler-view[show-group-header="horizontal"] .smart-scheduler-cell[show-label] {\r\n  justify-content: flex-start;\r\n}\r\nsmart-scheduler[group-by-date] .smart-scheduler-view[show-group-header="horizontal"] .smart-scheduler-cell[show-label] > div {\r\n  transform: translateX(calc(-50% - var(--smart-scheduler-timeline-header-cell-padding)));\r\n}\r\nsmart-scheduler[group-by-date] .smart-scheduler-view[show-group-header="horizontal"] .smart-scheduler-cell[show-label="offset"] > div {\r\n  margin-left: var(--smart-scheduler-timeline-group-header-offset);\r\n}\r\nsmart-scheduler[group-by-date] .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-view-header-vertical .smart-scheduler-view-time .smart-scheduler-cell {\r\n  border-right: initial;\r\n}\r\nsmart-scheduler[group-by-date] .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-cell[show-label] > div {\r\n  transform: translateY(calc(-50% - var(--smart-scheduler-timeline-header-cell-padding)));\r\n}\r\nsmart-scheduler[group-by-date] .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-cell[show-label="offset"] > div {\r\n  margin-top: var(--smart-scheduler-timeline-group-header-offset);\r\n}\r\nsmart-scheduler[group-by-date] .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-groups-container .smart-scheduler-cell {\r\n  align-items: center;\r\n}\r\nsmart-scheduler[group-by-date] .smart-scheduler-view-header-horizontal .smart-scheduler-groups-container, smart-scheduler[group-by-date]:not([view-type^="timeline"]) .smart-scheduler-view-header-vertical .smart-scheduler-groups-container {\r\n  order: 1;\r\n}\r\nsmart-scheduler[group-by-date] .smart-scheduler-view-all-day {\r\n  order: 2;\r\n}\r\nsmart-scheduler[group-by-date] .smart-scheduler-view-header-horizontal .smart-scheduler-view-groups-label-container {\r\n  border-bottom: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler[group-by-date]:not([view-type="agenda"]) .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-groups-container .smart-scheduler-cell:not([group-separator]) {\r\n  border-bottom: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler[disable-resize] .smart-scheduler-event:not([collector]):after, smart-scheduler[disable-resize] .smart-scheduler-event:not([collector]):before {\r\n  content: initial;\r\n}\r\nsmart-scheduler[hide-today-button] .smart-scheduler-nav[today] {\r\n  display: none;\r\n}\r\nsmart-scheduler[current-time-indicator] .smart-scheduler-view-header-horizontal .smart-scheduler-cell[current] {\r\n  color: var(--smart-scheduler-current-time-indicator-background);\r\n  border-bottom: var(--smart-scheduler-current-time-indicator-header-size) solid var(--smart-scheduler-current-time-indicator-background);\r\n}\r\nsmart-scheduler[current-time-indicator] .smart-scheduler-view-header-vertical .smart-scheduler-cell[current] {\r\n  color: var(--smart-scheduler-current-time-indicator-background);\r\n  border-right: var(--smart-scheduler-current-time-indicator-header-size) solid var(--smart-scheduler-current-time-indicator-background);\r\n}\r\nsmart-scheduler[current-time-indicator] .smart-scheduler-current-time-indicator:before {\r\n  content: "";\r\n  position: absolute;\r\n}\r\nsmart-scheduler[resized] {\r\n  touch-action: none;\r\n}\r\nsmart-scheduler[resized] .smart-scheduler-cell[restricted]:hover {\r\n  cursor: no-drop;\r\n}\r\nsmart-scheduler[resized] .smart-scheduler-event {\r\n  pointer-events: none;\r\n}\r\nsmart-scheduler[dragged] {\r\n  touch-action: none;\r\n}\r\nsmart-scheduler[dragged] .smart-scheduler-events-container {\r\n  pointer-events: none;\r\n}\r\nsmart-scheduler[modal] .smart-scheduler-header,\r\nsmart-scheduler[modal] .smart-scheduler-view-container,\r\nsmart-scheduler[modal] .smart-scheduler-footer {\r\n  pointer-events: none;\r\n}\r\nsmart-scheduler[hide-all-day] .smart-scheduler-view-all-day {\r\n  display: none;\r\n}\r\nsmart-scheduler[disable-date-menu] .smart-scheduler-nav[current] {\r\n  cursor: initial;\r\n}\r\nsmart-scheduler[disable-date-menu] .smart-scheduler-nav[current]::after {\r\n  content: initial;\r\n}\r\nsmart-scheduler[disable-date-menu] .smart-scheduler-nav[current] .smart-ripple {\r\n  visibility: hidden;\r\n}\r\nsmart-scheduler[disable-date-menu] .smart-scheduler-nav[current][hover], smart-scheduler[disable-date-menu] .smart-scheduler-nav[current][focus],\r\nsmart-scheduler[disable-date-menu] .smart-scheduler-view-items-button[hover],\r\nsmart-scheduler[disable-date-menu] .smart-scheduler-view-items-button[focus] {\r\n  background: transparent;\r\n  color: var(--smart-background-color);\r\n}\r\nsmart-scheduler[disable-view-menu] .smart-scheduler-view-items-button {\r\n  border: initial;\r\n  cursor: initial;\r\n}\r\nsmart-scheduler[disable-view-menu] .smart-scheduler-view-items-button::after {\r\n  content: initial;\r\n}\r\nsmart-scheduler[disable-view-menu] .smart-scheduler-view-items-button .smart-ripple {\r\n  visibility: hidden;\r\n}\r\nsmart-scheduler[time-ruler-ticks][view-type="day"] .smart-scheduler-view-header-vertical .smart-scheduler-cells:last-of-type .smart-scheduler-cell:not(:last-of-type):after, smart-scheduler[time-ruler-ticks][view-type="week"] .smart-scheduler-view-header-vertical .smart-scheduler-cells:last-of-type .smart-scheduler-cell:not(:last-of-type):after {\r\n  content: \'\';\r\n  position: absolute;\r\n  bottom: 0;\r\n  right: 0;\r\n  width: var(--smart-scheduler-time-ruler-tick-size);\r\n  height: var(--smart-scheduler-day-week-view-hour-size);\r\n  background: var(--smart-scheduler-day-week-view-hour-color);\r\n}\r\nsmart-scheduler[legend-location="header"] {\r\n  --smart-scheduler-header-height: auto;\r\n}\r\nsmart-scheduler[legend-location="header"] .smart-scheduler-header {\r\n  grid-template-areas: "date view" "legend legend";\r\n  grid-template-rows: auto minmax(0, 1fr);\r\n}\r\nsmart-scheduler[legend-position="far"] .smart-scheduler-legend {\r\n  justify-content: flex-end;\r\n}\r\nsmart-scheduler[scroll-buttons-position="both"] .smart-scheduler-date-nav .smart-scheduler-nav[prev] {\r\n  order: 1;\r\n}\r\nsmart-scheduler[scroll-buttons-position="both"] .smart-scheduler-date-nav .smart-scheduler-nav[current] {\r\n  order: 2;\r\n}\r\nsmart-scheduler[scroll-buttons-position="both"] .smart-scheduler-date-nav .smart-scheduler-nav[next] {\r\n  order: 3;\r\n}\r\nsmart-scheduler[scroll-buttons-position="both"][header-navigation-style="raised"] .smart-scheduler-date-nav .smart-scheduler-nav[current] {\r\n  border-radius: initial;\r\n}\r\nsmart-scheduler[scroll-buttons-position="both"][header-navigation-style="raised"] .smart-scheduler-date-nav .smart-scheduler-nav[next] {\r\n  border-top-right-radius: var(--smart-item-border-top-right-radius);\r\n  border-bottom-right-radius: var(--smart-item-border-bottom-right-radius);\r\n}\r\nsmart-scheduler[scroll-buttons-position="both"][header-navigation-style="raised"] .smart-scheduler-date-nav .smart-scheduler-nav[next] {\r\n  border-top-left-radius: initial;\r\n  border-bottom-left-radius: initial;\r\n  border-left: initial;\r\n  border-right: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler[scroll-buttons-position="far"] .smart-scheduler-date-nav .smart-scheduler-nav[current] {\r\n  order: 1;\r\n}\r\nsmart-scheduler[scroll-buttons-position="far"] .smart-scheduler-date-nav .smart-scheduler-nav[next] {\r\n  order: 3;\r\n}\r\nsmart-scheduler[scroll-buttons-position="far"] .smart-scheduler-date-nav .smart-scheduler-nav[prev] {\r\n  order: 2;\r\n}\r\nsmart-scheduler[scroll-buttons-position="far"][header-navigation-style="raised"] .smart-scheduler-date-nav .smart-scheduler-nav[current] {\r\n  border-top-left-radius: var(--smart-item-border-top-left-radius);\r\n  border-bottom-left-radius: var(--smart-item-border-bottom-left-radius);\r\n  border-top-right-radius: initial;\r\n  border-bottom-right-radius: initial;\r\n}\r\nsmart-scheduler[scroll-buttons-position="far"][header-navigation-style="raised"] .smart-scheduler-date-nav .smart-scheduler-nav[prev], smart-scheduler[scroll-buttons-position="far"][header-navigation-style="raised"] .smart-scheduler-date-nav .smart-scheduler-nav[next] {\r\n  border-top-left-radius: initial;\r\n  border-bottom-left-radius: initial;\r\n  border-left: initial;\r\n  border-right: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler[scroll-buttons-position="far"][header-navigation-style="raised"] .smart-scheduler-date-nav .smart-scheduler-nav[next] {\r\n  border-top-right-radius: var(--smart-item-border-top-right-radius);\r\n  border-bottom-right-radius: var(--smart-item-border-bottom-right-radius);\r\n}\r\nsmart-scheduler[scroll-buttons-position="near"] .smart-scheduler-date-nav .smart-scheduler-nav[prev] {\r\n  order: 1;\r\n}\r\nsmart-scheduler[scroll-buttons-position="near"] .smart-scheduler-date-nav .smart-scheduler-nav[next] {\r\n  order: 2;\r\n}\r\nsmart-scheduler[scroll-buttons-position="near"][header-navigation-style="raised"] .smart-scheduler-date-nav .smart-scheduler-nav[current] {\r\n  order: 3;\r\n}\r\nsmart-scheduler[scroll-buttons-position="near"][header-navigation-style="raised"] .smart-scheduler-date-nav .smart-scheduler-nav[next] {\r\n  border-top-right-radius: initial;\r\n  border-bottom-right-radius: initial;\r\n  border-right: initial;\r\n  border-left: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler:not([header-navigation-style="raised"]) .smart-scheduler-date-nav .smart-scheduler-nav[prev], smart-scheduler:not([header-navigation-style="raised"]) .smart-scheduler-date-nav .smart-scheduler-nav[next] {\r\n  border-radius: 50%;\r\n}\r\nsmart-scheduler:not([header-navigation-style="raised"]) .smart-scheduler-date-nav .smart-scheduler-nav[current], smart-scheduler:not([header-navigation-style="raised"]) .smart-scheduler-date-nav .smart-scheduler-nav[prev], smart-scheduler:not([header-navigation-style="raised"]) .smart-scheduler-date-nav .smart-scheduler-nav[next] {\r\n  border: initial;\r\n}\r\nsmart-scheduler:not([header-navigation-style="raised"]) .smart-scheduler-date-nav .smart-scheduler-nav[current] {\r\n  margin-left: 10px;\r\n}\r\nsmart-scheduler:not([header-navigation-style="raised"]) .smart-scheduler-date-nav .smart-scheduler-nav[prev]:not([active]):not([focus]),\r\nsmart-scheduler:not([header-navigation-style="raised"]) .smart-scheduler-date-nav .smart-scheduler-nav[next]:not([active]):not([focus]),\r\nsmart-scheduler:not([header-navigation-style="raised"]) .smart-scheduler-date-nav .smart-scheduler-nav[current]:not([focus]),\r\nsmart-scheduler:not([header-navigation-style="raised"]) .smart-scheduler-nav[today]:not([focus]),\r\nsmart-scheduler:not([header-navigation-style="raised"]) .smart-scheduler-view-items-button:not([focus]) {\r\n  background: transparent;\r\n}\r\nsmart-scheduler[header-date-position="far"] .smart-scheduler-header {\r\n  grid-template-columns: 1fr auto;\r\n  grid-template-areas: "view date";\r\n}\r\nsmart-scheduler[header-view-position="near"] .smart-scheduler-view-nav {\r\n  justify-content: flex-start;\r\n}\r\nsmart-scheduler[header-view-position="near"] .smart-scheduler-view-items-button {\r\n  order: 2;\r\n}\r\nsmart-scheduler[header-view-position="near"] .smart-scheduler-items-container .smart-scheduler-item:first-of-type, smart-scheduler[header-view-position="near"] .smart-scheduler-items-container .smart-scheduler-item:first-of-type[selected] {\r\n  border-left: none;\r\n}\r\nsmart-scheduler[header-view-position="near"] .smart-scheduler-items-container .smart-scheduler-item[selected] {\r\n  border-left: var(--smart-border-width) solid var(--smart-border);\r\n  border-right: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler[header-navigation-style="raised"] .smart-scheduler-date-nav .smart-scheduler-nav[prev] {\r\n  border-top-left-radius: var(--smart-item-border-top-left-radius);\r\n  border-bottom-left-radius: var(--smart-item-border-bottom-left-radius);\r\n  border-top-right-radius: initial;\r\n  border-bottom-right-radius: initial;\r\n  border-right: initial;\r\n}\r\nsmart-scheduler[header-navigation-style="raised"] .smart-scheduler-date-nav .smart-scheduler-nav[next] {\r\n  border-top-left-radius: initial;\r\n  border-bottom-left-radius: initial;\r\n  border-top-right-radius: initial;\r\n  border-bottom-right-radius: initial;\r\n  border-right: initial;\r\n  border-left: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler[header-navigation-style="raised"] .smart-scheduler-date-nav .smart-scheduler-nav[current] {\r\n  border-radius: initial;\r\n  border-top-right-radius: var(--smart-item-border-top-right-radius);\r\n  border-bottom-right-radius: var(--smart-item-border-bottom-right-radius);\r\n}\r\nsmart-scheduler[header-navigation-style="raised"] .smart-scheduler-nav[today],\r\nsmart-scheduler[header-navigation-style="raised"] .smart-scheduler-view-items-button {\r\n  background: var(--smart-background);\r\n}\r\nsmart-scheduler[view-selector-type="tabs"] .smart-scheduler-view-items-button {\r\n  position: absolute;\r\n}\r\nsmart-scheduler[view-selector-type="tabs"] .smart-scheduler-header {\r\n  grid-template-areas: "date . view";\r\n}\r\nsmart-scheduler[view-selector-type="auto"] .smart-scheduler-header {\r\n  grid-template-areas: "date . view";\r\n}\r\nsmart-scheduler:not([right-to-left]) .smart-scheduler-view-header-horizontal .smart-scheduler-cell:last-of-type {\r\n  border-right: none;\r\n}\r\nsmart-scheduler[right-to-left] .smart-scheduler-header,\r\nsmart-scheduler[right-to-left] .smart-scheduler-view {\r\n  direction: rtl;\r\n}\r\nsmart-scheduler[right-to-left] .smart-scheduler-date-nav .smart-scheduler-nav[today] {\r\n  order: 1;\r\n}\r\nsmart-scheduler[right-to-left] .smart-scheduler-date-nav .smart-scheduler-nav[prev] {\r\n  order: 2;\r\n}\r\nsmart-scheduler[right-to-left] .smart-scheduler-date-nav .smart-scheduler-nav[prev]:after {\r\n  content: var(--smart-icon-arrow-right);\r\n}\r\nsmart-scheduler[right-to-left] .smart-scheduler-date-nav .smart-scheduler-nav[next] {\r\n  order: 3;\r\n}\r\nsmart-scheduler[right-to-left] .smart-scheduler-date-nav .smart-scheduler-nav[next]:after {\r\n  content: var(--smart-icon-arrow-left);\r\n}\r\nsmart-scheduler[right-to-left] .smart-scheduler-date-nav .smart-scheduler-nav[current] {\r\n  order: 4;\r\n}\r\nsmart-scheduler[right-to-left] > .smart-container.vscroll .smart-scheduler-view, smart-scheduler[right-to-left].smart-container.vscroll .smart-scheduler-view {\r\n  margin-left: var(--smart-scroll-bar-size);\r\n}\r\nsmart-scheduler[right-to-left] > .smart-container.vscroll .smart-scheduler-view-scroll-bar:not([orientation="vertical"]), smart-scheduler[right-to-left].smart-container.vscroll .smart-scheduler-view-scroll-bar:not([orientation="vertical"]) {\r\n  left: var(--smart-scroll-bar-size);\r\n}\r\nsmart-scheduler[right-to-left] .smart-scheduler-view-scroll-bar[orientation="vertical"] {\r\n  right: initial;\r\n  left: 0;\r\n}\r\nsmart-scheduler[right-to-left] .smart-scheduler-view-scroll-bar[orientation="vertical"]:before {\r\n  border-left: none;\r\n  border-right: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler[right-to-left] .smart-scheduler-view-scroll-bar[orientation="vertical"]:after {\r\n  right: 100%;\r\n  left: initial;\r\n  left: calc(-1 * var(--smart-scroll-bar-size));\r\n}\r\nsmart-scheduler[right-to-left][view-type="day"] .smart-scheduler-cells-container .smart-scheduler-cell:not(.scale):not(:last-of-type), smart-scheduler[right-to-left][view-type="week"] .smart-scheduler-cells-container .smart-scheduler-cell:not(.scale):not(:last-of-type) {\r\n  border-right: initial;\r\n  border-left: var(--smart-scheduler-day-week-view-vertical-line-size) solid var(--smart-scheduler-day-week-view-vertical-line-color);\r\n}\r\nsmart-scheduler[right-to-left]:not([view-type^="timeline"]) .smart-scheduler-cells-container .smart-scheduler-cell:not(.scale):not(:last-of-type) {\r\n  border-right: initial;\r\n  border-left: var(--smart-scheduler-view-line-size) solid var(--smart-scheduler-view-vertical-line-color);\r\n}\r\nsmart-scheduler[right-to-left][view-type]:not([view-type="day"]) .smart-scheduler-view-all-day-label, smart-scheduler[right-to-left][view-type^="timeline"] .smart-scheduler-view[show-vertical-header][show-group-header="horizontal"] .smart-scheduler-view-details-label, smart-scheduler[right-to-left][view-type^="timeline"] .smart-scheduler-time-zone, smart-scheduler[right-to-left][view-type]:not([view-type="day"]):not([view-type="agenda"]) .smart-scheduler-time-zone:last-of-type {\r\n  border-right: initial;\r\n  border-left: var(--smart-scheduler-view-line-size) solid var(--smart-scheduler-view-vertical-line-color);\r\n}\r\nsmart-scheduler[right-to-left]:not([view-type="day"]):not([view-type^="timeline"]) .smart-scheduler-view-label-container:empty, smart-scheduler[right-to-left]:not([view-type="day"]):not([view-type="agenda"]) .smart-scheduler-view-header-vertical .smart-scheduler-cell, smart-scheduler[right-to-left]:not([view-type="day"]) .smart-scheduler-view-header-cell-feedback, smart-scheduler[right-to-left][view-type^="timeline"] .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-view-label-container {\r\n  border-right: initial;\r\n  border-left: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler[right-to-left] .smart-scheduler-view-all-day .smart-scheduler-cell[all-day]:not(:last-of-type),\r\nsmart-scheduler[right-to-left] .smart-scheduler-view-header-horizontal .smart-scheduler-cell:not(:last-of-type),\r\nsmart-scheduler[right-to-left] .smart-scheduler-view-details .smart-scheduler-cell:not(:last-of-type) {\r\n  border-right: initial;\r\n  border-left: var(--smart-scheduler-day-week-view-vertical-line-size) solid var(--smart-scheduler-day-week-view-vertical-line-color);\r\n}\r\nsmart-scheduler[right-to-left] .smart-scheduler-view-all-day .smart-scheduler-cell[all-day]:last-of-type,\r\nsmart-scheduler[right-to-left] .smart-scheduler-view-header-horizontal .smart-scheduler-cell:last-of-type {\r\n  border-right: initial;\r\n}\r\nsmart-scheduler[right-to-left][view-type^="timeline"] .smart-scheduler-cells-container .smart-scheduler-cell-container:not(:last-of-type), smart-scheduler[right-to-left]:not([view-type="day"]) .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-view-header-groups-container .smart-scheduler-cell-container:not(:last-of-type) > .smart-scheduler-cell {\r\n  border-right: initial;\r\n  border-left: var(--smart-scheduler-view-line-size) solid var(--smart-scheduler-view-vertical-line-color);\r\n}\r\nsmart-scheduler[right-to-left] .smart-scheduler-view[show-group-header="horizontal"] .smart-scheduler-cell[group-separator]:not(:last-of-type),\r\nsmart-scheduler[right-to-left] .smart-scheduler-view[show-group-header="horizontal"] .smart-scheduler-cell:not(.scale)[group-separator]:not(:last-of-type),\r\nsmart-scheduler[right-to-left] .smart-scheduler-view[show-group-header="horizontal"] .smart-scheduler-cell-container[group-separator]:not(:last-of-type) {\r\n  border-right-color: initial;\r\n  border-right-width: initial;\r\n  border-left-color: var(--smart-scheduler-timeline-group-separator-background);\r\n  border-left-width: var(--smart-scheduler-timeline-group-separator-size);\r\n}\r\nsmart-scheduler[right-to-left][group-by-date] .smart-scheduler-view[show-group-header="horizontal"] .smart-scheduler-view-header-horizontal .smart-scheduler-view-time .smart-scheduler-cell:not([group-separator]) {\r\n  border-left: initial;\r\n}\r\nsmart-scheduler[right-to-left][group-by-date] .smart-scheduler-view[show-group-header="horizontal"] .smart-scheduler-view-header-horizontal .smart-scheduler-view-time .smart-scheduler-cell[show-label="offset"] > div {\r\n  margin-left: initial;\r\n  margin-right: var(--smart-scheduler-timeline-group-header-offset);\r\n}\r\nsmart-scheduler[right-to-left][group-by-date] .smart-scheduler-view[show-group-header="horizontal"] .smart-scheduler-view-header-horizontal .smart-scheduler-view-time .smart-scheduler-cell[show-label] > div {\r\n  transform: translateX(calc(50% + var(--smart-scheduler-timeline-header-cell-padding)));\r\n}\r\nsmart-scheduler[right-to-left] .smart-scheduler-nav[current]:after,\r\nsmart-scheduler[right-to-left] .smart-scheduler-view-items-button:after {\r\n  left: 0;\r\n  right: initial;\r\n}\r\nsmart-scheduler[right-to-left]:not([disable-date-menu]) .smart-scheduler-nav[current] button, smart-scheduler[right-to-left]:not([disable-view-menu]) .smart-scheduler-view-items-button button {\r\n  padding-left: var(--smart-editor-addon-width);\r\n}\r\nsmart-scheduler[right-to-left][view-type="agenda"] {\r\n  --smart-scheduler-timeline-header-vertical-label-padding: 0 25% 0 0;\r\n}\r\nsmart-scheduler[right-to-left][view-type="agenda"] .smart-scheduler-view-header-vertical .smart-scheduler-cell > div {\r\n  text-align: right;\r\n}\r\nsmart-scheduler[right-to-left][view-type="month"] .smart-scheduler-view:not([mobile]) .smart-scheduler-event[collector] {\r\n  padding-right: initial;\r\n  padding-left: calc(var(--smart-scheduler-month-view-number-size) + 5px);\r\n}\r\nsmart-scheduler[right-to-left][view-type="month"] .smart-scheduler-view:not([mobile]) .smart-scheduler-event[collector][first-month-day] {\r\n  padding-left: calc(var(--smart-scheduler-month-view-number-size) + 25px);\r\n}\r\nsmart-scheduler[right-to-left] .smart-toast-container-custom {\r\n  right: initial;\r\n  left: 0;\r\n}\r\nsmart-scheduler[right-to-left]:not([view-type="agenda"]) .smart-scheduler-event[status] .smart-scheduler-event-content {\r\n  padding-left: initial;\r\n  padding-right: calc(var(--smart-scheduler-status-size) + var(--smart-scheduler-status-padding));\r\n  border-top-left-radius: initial;\r\n  border-bottom-left-radius: initial;\r\n  border-top-right-radius: 5px;\r\n  border-bottom-right-radius: 5px;\r\n}\r\nsmart-scheduler[right-to-left]:not([view-type="month"]) .smart-scheduler-view[show-group-header="vertical"] .smart-scheduler-view-all-day-label-container {\r\n  margin-left: initial;\r\n  margin-right: var(--smart-scheduler-timeline-header-vertical-group-size);\r\n}\r\nsmart-scheduler[right-to-left][header-navigation-style="raised"] .smart-scheduler-date-nav .smart-scheduler-nav[current] {\r\n  border-top-right-radius: initial;\r\n  border-bottom-right-radius: initial;\r\n  border-top-left-radius: var(--smart-item-border-top-right-radius);\r\n  border-bottom-left-radius: var(--smart-item-border-bottom-right-radius);\r\n}\r\nsmart-scheduler[right-to-left][header-navigation-style="raised"] .smart-scheduler-date-nav .smart-scheduler-nav[prev] {\r\n  border-top-left-radius: initial;\r\n  border-bottom-left-radius: initial;\r\n  border-left: initial;\r\n}\r\nsmart-scheduler[right-to-left][header-navigation-style="raised"] .smart-scheduler-date-nav .smart-scheduler-nav[next] {\r\n  border-top-right-radius: var(--smart-item-border-top-left-radius);\r\n  border-bottom-right-radius: var(--smart-item-border-bottom-left-radius);\r\n  border-right: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler[right-to-left] .smart-scheduler-nav[today] {\r\n  margin-right: initial;\r\n  margin-left: 10px;\r\n}\r\nsmart-scheduler[right-to-left] .smart-scheduler-event[repeating] .smart-scheduler-event-content:after {\r\n  right: initial;\r\n  left: 0;\r\n}\r\nsmart-scheduler[right-to-left][view-type="timelineWeek"] .smart-scheduler-view[show-vertical-header] .smart-scheduler-view-details-label {\r\n  border-right: initial;\r\n  border-left: var(--smart-border-width) solid var(--smart-border);\r\n}\r\nsmart-scheduler[right-to-left] .smart-scheduler-items-container .smart-scheduler-item:last-of-type {\r\n  border-right: var(--smart-border-width) solid var(--smart-border);\r\n  border-left: none;\r\n}\r\nsmart-scheduler[right-to-left] .smart-scheduler-legend {\r\n  direction: rtl;\r\n}\r\n\r\n/* No need for view overlay on Mobile Firefox. */\r\n@-moz-document url-prefix() {\r\n  .smart-scheduler .smart-scheduler-view[mobile] .smart-scheduler-content:not(.hide-overlay):after {\r\n    display: none;\r\n  }\r\n}\r\n/* --- Scheduler Window --- */\r\n.smart-scheduler-window {\r\n  --smart-window-default-width: auto;\r\n  --smart-window-default-height: auto;\r\n  --smart-window-header-height: var(--smart-scheduler-window-header-height);\r\n  --smart-window-footer-height: var(--smart-scheduler-window-footer-height);\r\n  --smart-window-header-footer-padding: 10px;\r\n  --smart-window-header-background: transparent;\r\n  --smart-window-footer-padding: 10px;\r\n  --smart-window-content-padding: 20px;\r\n  max-width: 100vw;\r\n  max-height: 100vh;\r\n}\r\n.smart-scheduler-window[mobile] {\r\n  border-radius: initial;\r\n}\r\n.smart-scheduler-window.smart-window.confirm .smart-scheduler-confirm-label {\r\n  width: var(--smart-box-width);\r\n}\r\n.smart-scheduler-window.smart-window.confirm .smart-content-container > .smart-content {\r\n  width: 100%;\r\n  padding: var(--smart-window-content-padding);\r\n  justify-items: center;\r\n  /* Fallback if \'safe\' is not recognized by the browser */\r\n  justify-items: safe center;\r\n  grid-template-rows: auto minmax(auto, 1fr);\r\n  display: grid;\r\n  grid-row-gap: 10px;\r\n  justify-content: center;\r\n  grid-template-columns: 100%;\r\n  grid-row-gap: initial;\r\n}\r\n.smart-scheduler-window.smart-window .smart-scheduler-window-content-wrapper {\r\n  width: 100%;\r\n  padding: var(--smart-window-content-padding);\r\n  justify-items: center;\r\n  /* Fallback if \'safe\' is not recognized by the browser */\r\n  justify-items: safe center;\r\n  grid-template-rows: auto minmax(auto, 1fr);\r\n}\r\n.smart-scheduler-window.smart-window .smart-scheduler-window-content-wrapper,\r\n.smart-scheduler-window.smart-window .smart-scheduler-window-main,\r\n.smart-scheduler-window.smart-window .smart-scheduler-window-repeat {\r\n  display: grid;\r\n  grid-row-gap: 10px;\r\n  justify-content: center;\r\n  grid-template-columns: 100%;\r\n}\r\n.smart-scheduler-window.smart-window .smart-content-container > .smart-content {\r\n  padding: initial;\r\n  align-items: flex-start;\r\n}\r\n.smart-scheduler-window.smart-window .smart-scheduler-window-main,\r\n.smart-scheduler-window.smart-window .smart-scheduler-window-repeat {\r\n  width: var(--smart-box-width);\r\n}\r\n.smart-scheduler-window.smart-window[horizontal] .smart-scheduler-window-content-wrapper {\r\n  grid-template-columns: repeat(2, auto);\r\n  grid-column-gap: 20px;\r\n}\r\n.smart-scheduler-window.smart-window .smart-scheduler-window-repeat [multiple] {\r\n  grid-template-columns: minmax(0, 1fr);\r\n}\r\n.smart-scheduler-window.smart-window .smart-scheduler-window-repeat [multiple] .smart-scheduler-window-editor {\r\n  grid-template-columns: auto auto minmax(0, 1fr);\r\n}\r\n.smart-scheduler-window > .smart-container,\r\n.smart-scheduler-window .smart-content-container {\r\n  max-height: inherit;\r\n}\r\n.smart-scheduler-window [multiple] .smart-scheduler-window-editor {\r\n  align-items: center;\r\n  justify-content: flex-start;\r\n}\r\n.smart-scheduler-window [multiple] .smart-scheduler-window-editor[type="repeat"], .smart-scheduler-window [multiple] .smart-scheduler-window-editor:nth-child(even), .smart-scheduler-window [multiple] .smart-scheduler-window-editor:nth-child(odd):not(:first-of-type):not(:last-of-type) {\r\n  justify-content: flex-end;\r\n}\r\n.smart-scheduler-window .smart-content-container > .smart-footer {\r\n  display: flex;\r\n}\r\n@media not all and (min-resolution: 0.001dpcm) {\r\n  .smart-scheduler-window .smart-content-container > .smart-footer {\r\n    align-content: start;\r\n  }\r\n}\r\n.smart-scheduler-window .smart-content-container > .smart-footer smart-button {\r\n  width: 100%;\r\n  height: 100%;\r\n  --smart-button-padding: 0.2rem 16px;\r\n}\r\n.smart-scheduler-window .smart-content-container > .smart-footer smart-button:not(:first-of-type) {\r\n  margin-inline-start: 2%;\r\n}\r\n.smart-scheduler-window .smart-content-container > .smart-footer .smart-icon {\r\n  position: relative;\r\n  height: 100%;\r\n  font-family: var(--smart-font-family-icon);\r\n  font-size: 18px;\r\n  margin-right: 2.5px;\r\n}\r\n.smart-scheduler-window .smart-scheduler-window-button.ok .smart-icon::after {\r\n  content: var(--smart-icon-check);\r\n}\r\n.smart-scheduler-window .smart-scheduler-window-button.cancel {\r\n  grid-area: buttonCancel;\r\n}\r\n.smart-scheduler-window .smart-scheduler-window-button.cancel .smart-icon::after {\r\n  content: var(--smart-icon-cancel);\r\n}\r\n.smart-scheduler-window .smart-scheduler-window-button.delete .smart-icon::after {\r\n  content: var(--smart-icon-delete);\r\n}\r\n.smart-scheduler-window .smart-scheduler-window-editor {\r\n  display: grid;\r\n  grid-row-gap: 5px;\r\n  grid-column-gap: 10px;\r\n}\r\n.smart-scheduler-window .smart-scheduler-window-editor[type="allDay"], .smart-scheduler-window .smart-scheduler-window-editor[type="repeat"] {\r\n  grid-column-gap: initial;\r\n}\r\n.smart-scheduler-window .smart-scheduler-window-editor[type="conference"] label::before {\r\n  content: var(--smart-icon-video-camera);\r\n  font-family: var(--smart-font-family-icon);\r\n  font-size: 14px;\r\n  margin-right: 5px;\r\n  position: relative;\r\n  top: -3px;\r\n}\r\n.smart-scheduler-window .smart-scheduler-window-editor[type="notifications"] label::before {\r\n  content: var(--smart-icon-bell);\r\n  font-family: var(--smart-font-family-icon);\r\n  font-size: 14px;\r\n  margin-right: 5px;\r\n}\r\n.smart-scheduler-window .smart-scheduler-window-editor[multiple] {\r\n  grid-template-columns: repeat(2, minmax(0, 1fr));\r\n}\r\n.smart-scheduler-window .smart-scheduler-window-editor[multiple] .smart-color-input[event-editor] {\r\n  width: auto;\r\n  --smart-border-radius: 50%;\r\n}\r\n.smart-scheduler-window .smart-scheduler-window-editor .smart-drop-down-list,\r\n.smart-scheduler-window .smart-scheduler-window-editor .smart-date-time-picker {\r\n  width: 100%;\r\n}\r\n.smart-scheduler-window .smart-scheduler-window-editor .smart-switch-button {\r\n  margin: auto 10px;\r\n}\r\n.smart-scheduler-window .smart-scheduler-window-editor > b {\r\n  text-align: center;\r\n}\r\n.smart-scheduler-window .smart-scheduler-window-editor > .smart-input {\r\n  width: 100%;\r\n}\r\n.smart-scheduler-window .smart-scheduler-window-editor > .smart-number-input {\r\n  width: 100px;\r\n}\r\n.smart-scheduler-window .smart-scheduler-window-editor input:not(.smart-input) {\r\n  height: var(--smart-editor-height);\r\n}\r\n.smart-scheduler-window .smart-scheduler-window-editor .smart-input[disabled] {\r\n  opacity: 0.55;\r\n  cursor: default;\r\n  pointer-events: none;\r\n  -moz-user-select: none;\r\n  -ms-user-select: none;\r\n  -webkit-user-select: none;\r\n  user-select: none;\r\n}\r\n.smart-scheduler-window .smart-scheduler-window-main [multiple] .smart-scheduler-window-editor:not([type^="date"]):not([resource-type]) {\r\n  grid-template-columns: repeat(2, auto);\r\n}\r\n.smart-scheduler-window .smart-scheduler-window-repeat [multiple] .smart-scheduler-window-editor[type="repeatEnd"] {\r\n  grid-template-columns: initial;\r\n}\r\n\r\n/* --- Scheduler Tooltip --- */\r\n.smart-scheduler-tooltip {\r\n  --smart-tooltip-arrow-color: var(--smart-background);\r\n  --smart-tooltip-padding: 4px;\r\n}\r\n.smart-scheduler-tooltip.smart-tooltip .smart-tooltip-content {\r\n  opacity: initial;\r\n  background-color: var(--smart-background);\r\n  color: var(--smart-color);\r\n  border: none;\r\n}\r\n.smart-scheduler-tooltip .smart-calendar {\r\n  border: initial;\r\n  border-radius: initial;\r\n  direction: initial;\r\n}\r\n.smart-scheduler-tooltip .smart-calendar .smart-calendar-header {\r\n  border: var(--smart-border-width) solid var(--smart-border);\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-items-container {\r\n  flex-direction: column;\r\n  outline: none;\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-items-container:focus .smart-scheduler-item[selected] {\r\n  background-color: var(--smart-ui-state-focus);\r\n  border-color: var(--smart-ui-state-border-focus);\r\n  color: var(--smart-ui-state-color-focus);\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-item {\r\n  width: 100%;\r\n  cursor: pointer;\r\n  height: auto;\r\n  position: relative;\r\n  padding-right: calc(var(--smart-scheduler-shortcut-size) - 4px);\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-item:after {\r\n  content: attr(shortcut-key);\r\n  position: absolute;\r\n  height: 100%;\r\n  width: var(--smart-scheduler-shortcut-size);\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  box-sizing: border-box;\r\n  top: 0;\r\n  right: 0;\r\n  overflow: hidden;\r\n  white-space: nowrap;\r\n  opacity: 0.5;\r\n  margin: 0 6px 0 10px;\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-item:hover {\r\n  color: var(--smart-ui-state-color-hover);\r\n  background-color: var(--smart-ui-state-hover);\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-item[checkable]:after {\r\n  content: \'\';\r\n  opacity: initial;\r\n  left: 0;\r\n  right: initial;\r\n  margin: initial;\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-item[checkable] > div {\r\n  padding-left: var(--smart-scheduler-shortcut-size);\r\n  padding-right: initial;\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-item[checkable][checked]:after {\r\n  content: var(--smart-icon-check);\r\n  font-family: var(--smart-font-family-icon);\r\n  font-size: var(--smart-font-size);\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-item[separator] {\r\n  position: relative;\r\n  margin-top: 15px;\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-item[separator]:before {\r\n  content: \'\';\r\n  display: flex;\r\n  width: 100%;\r\n  border-bottom: var(--smart-border-width) solid var(--smart-border);\r\n  margin: 7px 0;\r\n  position: absolute;\r\n  left: 0;\r\n  bottom: 100%;\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-item > div {\r\n  position: relative;\r\n  align-items: center;\r\n  overflow: hidden;\r\n  text-overflow: ellipsis;\r\n  white-space: nowrap;\r\n  width: 100%;\r\n  padding: 10px var(--smart-scheduler-shortcut-size) 10px 12px;\r\n  display: flex;\r\n  flex-direction: row;\r\n  justify-content: space-between;\r\n  -moz-user-select: none;\r\n  -ms-user-select: none;\r\n  -webkit-user-select: none;\r\n  user-select: none;\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-event {\r\n  display: grid;\r\n  position: relative;\r\n  /* !important is nedded to keep the inline style of the event intact */\r\n  width: 100% !important;\r\n  height: var(--smart-scheduler-event-item-size) !important;\r\n  top: initial !important;\r\n  left: initial !important;\r\n  right: initial !important;\r\n  grid-template-columns: 20px minmax(0, 1fr) var(--smart-scheduler-event-button-size);\r\n  grid-column-gap: 10px;\r\n  justify-content: center;\r\n  padding: var(--smart-scheduler-event-content-padding);\r\n  cursor: pointer;\r\n  background: var(--smart-background);\r\n  color: var(--smart-background-color);\r\n  outline: none;\r\n  /* !important is nedded to keep the inline style of the event intact */\r\n  --smart-scheduler-event-focus: var(--smart-ui-state-focus);\r\n  --smart-scheduler-event-color-focus: var(--smart-ui-state-color-focus);\r\n  --smart-scheduler-event-hover: var(--smart-ui-state-hover);\r\n  --smart-scheduler-event-color-hover: var(--smart-ui-state-color-hover);\r\n  -moz-user-select: none;\r\n  -ms-user-select: none;\r\n  -webkit-user-select: none;\r\n  user-select: none;\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-event:before {\r\n  content: \'\';\r\n  width: 20px;\r\n  height: 20px;\r\n  display: flex;\r\n  background: var(--smart-scheduler-event-background);\r\n  justify-content: center;\r\n  align-items: center;\r\n  pointer-events: none;\r\n  box-sizing: border-box;\r\n  border-radius: 50%;\r\n  padding: var(--smart-scheduler-event-content-padding);\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-event:hover {\r\n  background: var(--smart-ui-state-hover);\r\n  color: var(--smart-ui-state-color-hover);\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-event[hover] .smart-scheduler-event-button:hover {\r\n  color: var(--smart-ui-state-color-focus);\r\n  background-color: var(--smart-ui-state-focus);\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-event .smart-scheduler-event-content {\r\n  position: relative;\r\n  width: 100%;\r\n  height: 100%;\r\n  display: flex;\r\n  flex-direction: column;\r\n  justify-content: space-between;\r\n  align-items: flex-start;\r\n  overflow: hidden;\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-event .smart-scheduler-event-content .meeting {\r\n  font-size: 12px;\r\n  color: var(--smart-primary);\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-event .smart-scheduler-event-content .meeting a {\r\n  color: var(--smart-primary);\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-event .smart-scheduler-event-content .meeting::before {\r\n  content: var(--smart-icon-video-camera);\r\n  font-family: var(--smart-font-family-icon);\r\n  font-size: 12px;\r\n  margin-right: 5px;\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-event .smart-scheduler-event-content > div {\r\n  max-width: 100%;\r\n  max-height: 100%;\r\n  overflow: hidden;\r\n  text-overflow: ellipsis;\r\n  align-self: flex-start;\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-context-menu {\r\n  width: 100%;\r\n  height: 100%;\r\n  display: grid;\r\n  align-items: center;\r\n  justify-content: flex-start;\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-context-menu .smart-scheduler-context-menu-item {\r\n  height: var(--smart-list-item-height);\r\n  padding: var(--smart-list-item-padding);\r\n  border-top-left-radius: var(--smart-item-border-top-left-radius);\r\n  border-top-right-radius: var(--smart-item-border-top-right-radius);\r\n  border-bottom-left-radius: var(--smart-item-border-bottom-left-radius);\r\n  border-bottom-right-radius: var(--smart-item-border-bottom-right-radius);\r\n  white-space: nowrap;\r\n  text-overflow: ellipsis;\r\n  background: var(--smart-background);\r\n  color: var(--smart-background-color);\r\n  display: flex;\r\n  align-items: center;\r\n  -moz-user-select: none;\r\n  -ms-user-select: none;\r\n  -webkit-user-select: none;\r\n  user-select: none;\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-context-menu .smart-scheduler-context-menu-item:hover {\r\n  background: var(--smart-ui-state-hover);\r\n  color: var(--smart-ui-state-color-hover);\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-item[selected],\r\n.smart-scheduler-tooltip .smart-scheduler-event[selected],\r\n.smart-scheduler-tooltip .smart-scheduler-context-menu .smart-scheduler-context-menu-item[selected] {\r\n  background-color: var(--smart-ui-state-selected);\r\n  border-color: var(--smart-ui-state-border-selected);\r\n  color: var(--smart-ui-state-color-selected);\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-item[disabled],\r\n.smart-scheduler-tooltip .smart-scheduler-event[disabled],\r\n.smart-scheduler-tooltip .smart-scheduler-context-menu .smart-scheduler-context-menu-item[disabled] {\r\n  opacity: 0.55;\r\n  cursor: default;\r\n  pointer-events: none;\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-collector-event-list {\r\n  width: 100%;\r\n  height: 100%;\r\n}\r\n.smart-scheduler-tooltip .smart-scroll-viewer {\r\n  --smart-scroll-viewer-max-height: var(--smart-scheduler-context-menu-max-height);\r\n  --smart-scroll-viewer-max-width: var(--smart-scheduler-context-menu-max-width);\r\n  --smart-list-box-default-height: auto;\r\n  width: auto;\r\n  border: initial;\r\n  padding: initial;\r\n  /* Since the ScrollViewer has width: auto; We need to add the vScroll width to the menu container */\r\n}\r\n.smart-scheduler-tooltip .smart-scroll-viewer .smart-scroll-viewer-container.vscroll .smart-scheduler-context-menu {\r\n  padding-right: var(--smart-scroll-bar-size);\r\n}\r\n.smart-scheduler-tooltip .smart-scroll-viewer .smart-scroll-viewer-container .smart-scroll-viewer-content-container {\r\n  padding: initial;\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-event-button {\r\n  position: relative;\r\n  width: var(--smart-scheduler-collector-item-button-size);\r\n  height: var(--smart-scheduler-collector-item-button-size);\r\n  display: flex;\r\n  justify-content: center;\r\n  align-items: center;\r\n  overflow: hidden;\r\n  border-color: var(--smart-border);\r\n  border-top-left-radius: var(--smart-border-top-left-radius);\r\n  border-top-right-radius: var(--smart-border-top-right-radius);\r\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\r\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\r\n  outline: none;\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-event-button:hover {\r\n  color: var(--smart-ui-state-color-hover);\r\n  background-color: var(--smart-ui-state-hover);\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-event-button:active {\r\n  color: var(--smart-ui-state-color-active);\r\n  background-color: var(--smart-ui-state-active);\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-event-button:focus {\r\n  color: var(--smart-ui-state-color-focus);\r\n  background-color: var(--smart-ui-state-focus);\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-event-button:before {\r\n  content: var(--smart-icon-delete);\r\n  font-family: var(--smart-font-family-icon);\r\n  position: absolute;\r\n  pointer-events: none;\r\n  box-sizing: border-box;\r\n  font-size: var(--smart-button-large-font-size);\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-event-label {\r\n  font-weight: var(--smart-scheduler-event-label-font-weight);\r\n  font-size: var(--smart-scheduler-event-label-font-size);\r\n  pointer-events: none;\r\n  white-space: nowrap;\r\n}\r\n.smart-scheduler-tooltip .smart-scheduler-event-time {\r\n  font-weight: var(--smart-scheduler-event-time-font-weight);\r\n  font-size: var(--smart-scheduler-event-time-font-size);\r\n  opacity: var(--smart-scheduler-event-time-opacity);\r\n  pointer-events: none;\r\n  white-space: nowrap;\r\n}\r\n.smart-scheduler-tooltip:not([animation="none"]) {\r\n  animation: smart-drop-down-list-smart-animate-closing 0.2s ease-in;\r\n  transition: animation 0.2s ease-in, opacity 0.2s ease-in, visibility 0.2s ease-in;\r\n}\r\n.smart-scheduler-tooltip:not([animation="none"])[visible] {\r\n  animation: smart-drop-down-list-smart-animate-opening 0.2s ease-out;\r\n  transition: animation 0.2s ease-out, opacity 0.2s ease-out, visibility 0.2s ease-out;\r\n}\r\n.smart-scheduler-tooltip:not([arrow-direction]), .smart-scheduler-tooltip[arrow-direction="bottom"] {\r\n  -webkit-transform-origin: bottom;\r\n  transform-origin: bottom;\r\n}\r\n.smart-scheduler-tooltip:not([arrow]), .smart-scheduler-tooltip[arrow-direction="top"] {\r\n  -webkit-transform-origin: top;\r\n  transform-origin: top;\r\n}\r\n.smart-scheduler-tooltip[right-to-left] .smart-scheduler-item {\r\n  padding-right: initial;\r\n  padding-left: calc(var(--smart-scheduler-shortcut-size) - 4px);\r\n}\r\n.smart-scheduler-tooltip[right-to-left] .smart-scheduler-item:after {\r\n  left: 0;\r\n  right: initial;\r\n  margin: 0 10px 0 6px;\r\n}\r\n.smart-scheduler-tooltip[right-to-left] .smart-scheduler-item > div {\r\n  padding: 10px 12px 10px var(--smart-scheduler-shortcut-size);\r\n}\r\n\r\n/* --- Scheduler Style Color Input --- */\r\n/* --- Scheduler Drag Feedback --- */\r\n.smart-scheduler-drag-feedback {\r\n  position: absolute;\r\n  outline: none;\r\n  -webkit-tap-highlight-color: transparent;\r\n  border-radius: var(--smart-scheduler-event-border-radius);\r\n  pointer-events: none;\r\n  padding: initial;\r\n  text-align: center;\r\n  box-sizing: border-box;\r\n  background: transparent;\r\n  box-shadow: var(--smart-elevation-8);\r\n  font-family: var(--smart-font-family);\r\n  font-size: var(--smart-font-size);\r\n  cursor: move;\r\n  opacity: 0.75;\r\n  z-index: 10000;\r\n}\r\n.smart-scheduler-drag-feedback .smart-scheduler-event-content {\r\n  box-sizing: border-box;\r\n  width: 100%;\r\n  height: 100%;\r\n  max-height: 100%;\r\n  display: grid;\r\n  grid-template-rows: min-content minmax(auto, 1fr);\r\n  justify-content: flex-start;\r\n  justify-items: flex-start;\r\n  align-items: center;\r\n  overflow: hidden;\r\n  padding: var(--smart-scheduler-event-content-padding);\r\n  color: var(--smart-scheduler-event-color);\r\n  background: var(--smart-scheduler-event-background);\r\n  cursor: pointer;\r\n  position: relative;\r\n  border-radius: inherit;\r\n  grid-row-gap: 2px;\r\n}\r\n.smart-scheduler-drag-feedback .smart-scheduler-event-content[single-line] {\r\n  grid-template-columns: repeat(2, auto);\r\n  grid-template-rows: 100%;\r\n  grid-column-gap: 5px;\r\n  justify-content: space-between;\r\n}\r\n.smart-scheduler-drag-feedback .smart-scheduler-event-content[single-line] > div {\r\n  align-self: initial;\r\n}\r\n.smart-scheduler-drag-feedback .smart-scheduler-event-content:not([single-line]) > div:not(:first-of-type) {\r\n  grid-column: 1 / span 2;\r\n}\r\n.smart-scheduler-drag-feedback .smart-scheduler-event-label {\r\n  font-weight: var(--smart-scheduler-event-label-font-weight);\r\n  font-size: var(--smart-scheduler-event-label-font-size);\r\n  pointer-events: none;\r\n  white-space: nowrap;\r\n}\r\n.smart-scheduler-drag-feedback .smart-scheduler-event-time {\r\n  font-weight: var(--smart-scheduler-event-time-font-weight);\r\n  font-size: var(--smart-scheduler-event-time-font-size);\r\n  opacity: var(--smart-scheduler-event-time-opacity);\r\n  pointer-events: none;\r\n  white-space: pre-wrap;\r\n}\r\n.smart-scheduler-drag-feedback .smart-scheduler-event-content {\r\n  grid-template-columns: minmax(auto, 1fr);\r\n}\r\n.smart-scheduler-drag-feedback .smart-scheduler-event-content > div {\r\n  max-width: 100%;\r\n  max-height: 100%;\r\n  overflow: hidden;\r\n  text-overflow: ellipsis;\r\n  align-self: flex-start;\r\n}\r\n.smart-scheduler-drag-feedback .smart-scheduler-event-content > div:first-of-type {\r\n  align-self: center;\r\n}\r\n.smart-scheduler-drag-feedback[status] .smart-scheduler-event-content:before {\r\n  content: \'\';\r\n  position: absolute;\r\n  display: block;\r\n  width: var(--smart-scheduler-status-size);\r\n  height: 100%;\r\n  background: var(--smart-scheduler-status-background);\r\n  box-shadow: 0 0 0 0.5px var(--smart-background);\r\n  border: 1px solid var(--smart-border);\r\n  border-radius: 20px;\r\n  overflow: hidden;\r\n  box-sizing: border-box;\r\n}\r\n.smart-scheduler-drag-feedback[status]:not([view-type="agenda"]) .smart-scheduler-event-content {\r\n  padding-left: calc(var(--smart-scheduler-status-size) + var(--smart-scheduler-status-padding));\r\n}\r\n.smart-scheduler-drag-feedback[status="free"] .smart-scheduler-event-content:before {\r\n  background: var(--smart-scheduler-status-free-background);\r\n}\r\n.smart-scheduler-drag-feedback[status="busy"] .smart-scheduler-event-content:before {\r\n  background: var(--smart-scheduler-status-busy-background);\r\n}\r\n.smart-scheduler-drag-feedback[status="outOfOffice"] .smart-scheduler-event-content:before {\r\n  background: var(--smart-scheduler-status-out-of-office-background);\r\n}\r\n.smart-scheduler-drag-feedback[status="tentative"] .smart-scheduler-event-content:before {\r\n  background: var(--smart-scheduler-status-tentative-background);\r\n}\r\n.smart-scheduler-drag-feedback[view-type="agenda"] .smart-scheduler-event-time {\r\n  opacity: var(--smart-scheduler-event-time-opacity-agenda);\r\n  font-size: var(--smart-scheduler-event-time-font-size-agenda);\r\n  font-weight: var(--smart-scheduler-event-time-font-weight-agenda);\r\n}\r\n.smart-scheduler-drag-feedback[view-type="agenda"] .smart-scheduler-event {\r\n  padding: var(--smart-scheduler-event-padding-agenda);\r\n}\r\n.smart-scheduler-drag-feedback[view-type="agenda"] .smart-scheduler-event-content > div {\r\n  padding: var(--smart-scheduler-event-padding-agenda);\r\n}\r\n.smart-scheduler-drag-feedback[view-type="agenda"][status] .smart-scheduler-event-content:before {\r\n  content: initial;\r\n}\r\n.smart-scheduler-drag-feedback:not([view-type^="timeline"]) {\r\n  width: var(--smart-scheduler-event-size);\r\n}\r\n.smart-scheduler-drag-feedback:not([view-type^="timeline"]) .smart-scheduler-event-content > div {\r\n  padding: var(--smart-scheduler-event-padding-basic);\r\n}\r\n.smart-scheduler-drag-feedback[view-type^="timeline"] .smart-scheduler-event-content > div {\r\n  padding: var(--smart-scheduler-event-padding-timeline);\r\n}\r\n.smart-scheduler-drag-feedback[mobile]:not([view-type^="timeline"]) {\r\n  min-width: var(--smart-scheduler-event-size-timeline);\r\n}\r\n.smart-scheduler-drag-feedback[exception] .smart-scheduler-event-content, .smart-scheduler-drag-feedback[repeating] .smart-scheduler-event-content {\r\n  grid-template-columns: minmax(auto, 1fr) var(--smart-scheduler-event-icon-size);\r\n}\r\n.smart-scheduler-drag-feedback:not([repeating]) .smart-scheduler-event-content:not([single-line]) > div {\r\n  grid-column: 1 / span 2;\r\n}\r\n.smart-scheduler-drag-feedback[repeating] .smart-scheduler-event-content:after {\r\n  content: var(--smart-icon-spin);\r\n  width: var(--smart-scheduler-event-icon-size);\r\n  position: absolute;\r\n  display: flex;\r\n  justify-content: center;\r\n  align-items: center;\r\n  top: 0;\r\n  right: 0;\r\n  font-family: var(--smart-font-family-icon);\r\n  font-size: var(--smart-font-size);\r\n  padding: var(--smart-scheduler-event-content-padding);\r\n  box-sizing: border-box;\r\n  line-height: 1rem;\r\n}\r\n.smart-scheduler-drag-feedback[repeating] .smart-scheduler-event-content[single-line] {\r\n  grid-template-columns: repeat(2, auto) var(--smart-scheduler-event-icon-size);\r\n}\r\n.smart-scheduler-drag-feedback[repeating][exception] .smart-scheduler-event-content:after {\r\n  content: var(--smart-icon-attention-circled);\r\n}\r\n.smart-scheduler-drag-feedback[right-to-left] {\r\n  direction: rtl;\r\n}\r\n.smart-scheduler-drag-feedback[right-to-left]:not([view-type="agenda"])[status] .smart-scheduler-event-content {\r\n  padding-left: initial;\r\n  padding-right: calc(var(--smart-scheduler-status-size) + var(--smart-scheduler-status-padding));\r\n}\r\n.smart-scheduler-drag-feedback[right-to-left][repeating] .smart-scheduler-event-content:after {\r\n  right: initial;\r\n  left: 0;\r\n}\r\n\r\n.smart-dragging-disabled {\r\n  cursor: no-drop;\r\n}\r\n\r\n/* smart-notificaiton-panel */\r\n.smart-notification-panel {\r\n  width: auto;\r\n  height: auto;\r\n  display: inline-block;\r\n  contain: content;\r\n  max-height: 100px;\r\n  /* Notification panel RTL */\r\n}\r\n.smart-notification-panel:focus {\r\n  border-color: var(--smart-outline);\r\n}\r\n.smart-notification-panel > .smart-container, .smart-notification-panel.smart-container {\r\n  padding: var(--smart-editor-label-padding);\r\n  overflow: auto;\r\n  max-height: inherit;\r\n}\r\n.smart-notification-panel .smart-notification-container {\r\n  display: flex;\r\n  width: 100%;\r\n  flex-direction: column;\r\n}\r\n.smart-notification-panel .smart-notification-container:empty {\r\n  display: none;\r\n}\r\n.smart-notification-panel .smart-notification-placeholder,\r\n.smart-notification-panel .smart-notification-item {\r\n  -moz-user-select: none;\r\n  -ms-user-select: none;\r\n  -webkit-user-select: none;\r\n  user-select: none;\r\n}\r\n.smart-notification-panel .smart-notification-item {\r\n  display: inline-grid;\r\n  grid-template-columns: repeat(4, minmax(0, 1fr)) var(--smart-editor-height);\r\n  grid-column-gap: 10px;\r\n  align-items: center;\r\n  padding: 0 0 var(--smart-editor-label-padding) 0;\r\n  justify-items: center;\r\n}\r\n.smart-notification-panel .smart-notification-item .smart-input {\r\n  width: 100%;\r\n  white-space: nowrap;\r\n  text-overflow: ellipsis;\r\n  overflow: hidden;\r\n  background: var(--smart-surface);\r\n  color: var(--smart-surface-color);\r\n  position: relative;\r\n  outline: none;\r\n  padding: var(--smart-editor-label-padding);\r\n  height: var(--smart-editor-height);\r\n  border-top-left-radius: var(--smart-border-top-left-radius);\r\n  border-top-right-radius: var(--smart-border-top-right-radius);\r\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\r\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\r\n  display: inline-flex;\r\n  align-items: center;\r\n  cursor: pointer;\r\n  font-family: var(--smart-font-family);\r\n  font-size: var(--smart-font-size);\r\n  border: var(--smart-border-width) solid transparent;\r\n}\r\n.smart-notification-panel .smart-notification-item .smart-input[interval]::before, .smart-notification-panel .smart-notification-item .smart-input[interval]::after, .smart-notification-panel .smart-notification-item .smart-input[type]::after {\r\n  content: var(--smart-icon-arrow-down);\r\n  display: flex;\r\n  overflow: hidden;\r\n  cursor: pointer;\r\n  font-family: var(--smart-font-family-icon);\r\n  justify-content: center;\r\n  align-items: center;\r\n  font-size: var(--smart-arrow-size);\r\n  outline: none;\r\n  width: var(--smart-editor-addon-width);\r\n  position: absolute;\r\n  top: 1px;\r\n  right: -1px;\r\n  height: 100%;\r\n  box-sizing: border-box;\r\n}\r\n.smart-notification-panel .smart-notification-item .smart-input[interval]::before {\r\n  content: var(--smart-icon-arrow-up);\r\n  top: 0;\r\n  height: 50%;\r\n  border-bottom: var(--smart-border-width) solid transparent;\r\n}\r\n.smart-notification-panel .smart-notification-item .smart-input[interval]::after {\r\n  content: var(--smart-icon-arrow-down);\r\n  bottom: 0;\r\n  top: initial;\r\n  height: 50%;\r\n}\r\n.smart-notification-panel .smart-notification-item .smart-button[delete] {\r\n  width: var(--smart-editor-height);\r\n  height: var(--smart-editor-height);\r\n  box-sizing: border-box;\r\n  display: flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n  opacity: 0.25;\r\n  font-size: 16px;\r\n  cursor: pointer;\r\n  position: relative;\r\n  border-radius: 50%;\r\n  outline: none;\r\n}\r\n.smart-notification-panel .smart-notification-item .smart-button[delete]:after {\r\n  content: var(--smart-icon-close);\r\n  display: flex;\r\n  justify-content: center;\r\n  align-items: center;\r\n  width: 100%;\r\n  height: 0;\r\n  cursor: pointer;\r\n  font-size: var(--smart-font-size);\r\n  font-family: var(--smart-font-family-icon);\r\n}\r\n.smart-notification-panel .smart-notification-item .smart-button[delete]:hover {\r\n  opacity: 0.6;\r\n  color: var(--smart-ui-state-color-hover);\r\n  background-color: var(--smart-ui-state-hover);\r\n}\r\n.smart-notification-panel .smart-notification-item .smart-button[delete]:active {\r\n  color: var(--smart-ui-state-color-hover);\r\n  background-color: var(--smart-ui-state-hover);\r\n  opacity: 1;\r\n}\r\n.smart-notification-panel .smart-notification-item .smart-input:focus,\r\n.smart-notification-panel .smart-notification-item .smart-button[delete]:focus {\r\n  box-shadow: 0 0 0 1px var(--smart-outline);\r\n}\r\n.smart-notification-panel .smart-notification-placeholder {\r\n  border-bottom: var(--smart-border-width) solid var(--smart-primary);\r\n  color: var(--smart-primary);\r\n  outline: none;\r\n  display: inline-flex;\r\n  align-items: center;\r\n  cursor: pointer;\r\n  font-family: var(--smart-font-family);\r\n  font-size: var(--smart-font-size);\r\n}\r\n.smart-notification-panel .smart-notification-placeholder .smart-input {\r\n  outline: none;\r\n  display: inline-flex;\r\n  align-items: center;\r\n  cursor: pointer;\r\n  font-family: var(--smart-font-family);\r\n  font-size: var(--smart-font-size);\r\n  border: var(--smart-border-width) solid transparent;\r\n}\r\n.smart-notification-panel .smart-notification-placeholder:hover {\r\n  color: var(--smart-ui-state-color-hover);\r\n}\r\n.smart-notification-panel .smart-notification-editor {\r\n  position: absolute;\r\n  background: var(--smart-background);\r\n  color: var(--smart-background-color);\r\n}\r\n.smart-notification-panel label {\r\n  display: inline-flex;\r\n  align-items: center;\r\n  justify-content: center;\r\n}\r\n.smart-notification-panel[right-to-left] .smart-notification-item .smart-input[interval], .smart-notification-panel[right-to-left] .smart-notification-item .smart-input[type] {\r\n  padding-left: var(--smart-editor-addon-width);\r\n}\r\n.smart-notification-panel[right-to-left] .smart-notification-item .smart-input[interval] {\r\n  padding-left: calc(var(--smart-editor-addon-width) + var(--smart-editor-label-padding));\r\n}\r\n.smart-notification-panel[right-to-left] .smart-notification-item .smart-input[interval]::before, .smart-notification-panel[right-to-left] .smart-notification-item .smart-input[interval]::after, .smart-notification-panel[right-to-left] .smart-notification-item .smart-input[type]::after {\r\n  right: initial;\r\n  left: -1px;\r\n}\r\n\r\n/* Loading Placeholder */\r\n.smart-scheduler-loading-container .smart-loader-label {\r\n  position: absolute;\r\n  top: 50%;\r\n  left: 50%;\r\n  z-index: 99;\r\n  transform: translate(-50%, -50%);\r\n  margin-top: calc(5px + var(--smart-loader-size));\r\n  margin-left: 5px;\r\n}\r\n\r\n.smart-scheduler-loader {\r\n  margin: inherit;\r\n  display: block;\r\n  position: absolute;\r\n  top: 50%;\r\n  left: 50%;\r\n  z-index: 99;\r\n  transform: translate(-50%, -50%);\r\n  opacity: 0.85;\r\n  text-align: left;\r\n  border: 6px solid rgba(43, 51, 63, 0.1);\r\n  box-sizing: border-box;\r\n  background-clip: padding-box;\r\n  border-radius: 50%;\r\n  width: calc(var(--smart-loader-size) + 10px);\r\n  height: calc(var(--smart-loader-size) + 10px);\r\n}\r\n.smart-scheduler-loader:after, .smart-scheduler-loader:before {\r\n  content: "";\r\n  position: absolute;\r\n  margin: -6px;\r\n  box-sizing: inherit;\r\n  width: inherit;\r\n  height: inherit;\r\n  border-radius: inherit;\r\n  opacity: 1;\r\n  border: inherit;\r\n  border-color: transparent;\r\n  border-top-color: transparent;\r\n  border-width: 6px;\r\n  animation-delay: 0.44s;\r\n  animation: smart-loader-spin 1.1s cubic-bezier(0.6, 0.2, 0, 0.8) infinite, smart-loader-spin-fade 1.1s linear infinite;\r\n}\r\n\r\n/* --- Editor Color Input --- */\r\n.smart-color-input-drop-down-menu.smart-scheduler-color-input .grid-samples-container {\r\n  grid-template-columns: repeat(2, minmax(0, 1fr));\r\n}\r\n.smart-color-input-drop-down-menu.smart-scheduler-color-input:not([animation="none"]) .default-samples-container div {\r\n  transition: transform 0.2s ease-in-out;\r\n}\r\n.smart-color-input-drop-down-menu.smart-scheduler-color-input .default-samples-container div {\r\n  position: relative;\r\n  border-radius: 50%;\r\n  border: initial;\r\n  transform: scale(0.95);\r\n}\r\n.smart-color-input-drop-down-menu.smart-scheduler-color-input .default-samples-container div.selected {\r\n  transform: scale(1);\r\n}\r\n.smart-color-input-drop-down-menu.smart-scheduler-color-input .default-samples-container div.selected:not(.no-color):after {\r\n  content: var(--smart-icon-check);\r\n  width: 100%;\r\n  height: 100%;\r\n  position: absolute;\r\n  top: 0;\r\n  left: 0;\r\n  display: flex;\r\n  justify-content: center;\r\n  align-items: center;\r\n  font-family: var(--smart-font-family-icon);\r\n  color: var(--smart-secondary-color);\r\n  border-radius: inherit;\r\n}\r\n\r\n.smart-scheduler-color-input {\r\n  --smart-input-drop-down-menu-width: auto;\r\n}\r\n',""]);const s=i},1971:(e,t,r)=>{"use strict";r.d(t,{Z:()=>s});var n=r(8081),o=r.n(n),a=r(3645),i=r.n(a)()(o());i.push([e.id,'/* smart-scroll-bar */\r\nsmart-scroll-bar {\r\n  display: block;\r\n  touch-action: none;\r\n  width: var(--smart-scroll-bar-default-width);\r\n  height: var(--smart-scroll-bar-default-height);\r\n}\r\nsmart-scroll-bar .smart-thumb {\r\n  position: absolute;\r\n  width: 40px;\r\n  background-clip: content-box;\r\n  padding: var(--smart-scroll-bar-thumb-padding) 0 var(--smart-scroll-bar-thumb-padding) 0;\r\n  height: var(--smart-scroll-bar-thumb-size);\r\n  cursor: default;\r\n  box-sizing: border-box;\r\n  border-width: 1px;\r\n  border-style: solid;\r\n  border-color: var(--smart-scroll-bar-thumb-border);\r\n  background-color: var(--smart-scroll-bar-thumb-background);\r\n  border-top-left-radius: var(--smart-scroll-bar-thumb-border-top-left-radius);\r\n  border-top-right-radius: var(--smart-scroll-bar-thumb-border-top-right-radius);\r\n  border-bottom-left-radius: var(--smart-scroll-bar-thumb-border-bottom-left-radius);\r\n  border-bottom-right-radius: var(--smart-scroll-bar-thumb-border-bottom-right-radius);\r\n}\r\nsmart-scroll-bar .smart-thumb:hover {\r\n  border-color: var(--smart-scroll-bar-thumb-border-hover);\r\n  background-color: var(--smart-scroll-bar-thumb-background-hover);\r\n}\r\nsmart-scroll-bar .smart-thumb:active {\r\n  border-color: var(--smart-scroll-bar-thumb-border-active);\r\n  background-color: var(--smart-scroll-bar-thumb-background-active);\r\n}\r\nsmart-scroll-bar .smart-track {\r\n  position: relative;\r\n  float: left;\r\n  height: 100%;\r\n  background-color: var(--smart-scroll-bar-track-background);\r\n  width: 100%;\r\n}\r\nsmart-scroll-bar .smart-scroll-button {\r\n  display: none;\r\n  float: left;\r\n  width: var(--smart-scroll-button-size);\r\n  height: 100%;\r\n  cursor: default;\r\n  background-color: var(--smart-scroll-bar-button-background);\r\n  color: var(--smart-scroll-bar-button-color);\r\n  border: 1px solid var(--smart-scroll-bar-button-border);\r\n  min-height: 0;\r\n  padding: 0;\r\n  border-radius: 0px;\r\n}\r\nsmart-scroll-bar .smart-scroll-button:hover {\r\n  background-color: var(--smart-scroll-bar-button-background-hover);\r\n  color: var(--smart-scroll-bar-button-color-hover);\r\n  border-color: var(--smart-scroll-bar-button-border-hover);\r\n}\r\nsmart-scroll-bar .smart-scroll-button:active {\r\n  background-color: var(--smart-scroll-bar-button-background-active);\r\n  color: var(--smart-scroll-bar-button-color-active);\r\n  border-color: var(--smart-scroll-bar-button-border-active);\r\n}\r\nsmart-scroll-bar[show-buttons] .smart-track {\r\n  width: calc(calc(100% - var(--smart-scroll-button-size) * 2));\r\n}\r\nsmart-scroll-bar[show-buttons] .smart-scroll-button {\r\n  display: block;\r\n}\r\nsmart-scroll-bar[spinner][show-buttons] .smart-track {\r\n  display: none;\r\n}\r\nsmart-scroll-bar[spinner][show-buttons] .smart-scroll-button {\r\n  width: 50%;\r\n}\r\nsmart-scroll-bar[discrete] {\r\n  --smart-scroll-button-size: 0px;\r\n  --smart-scroll-bar-size: 15px;\r\n  --smart-scroll-bar-thumb-border-top-right-radius: 6px;\r\n  --smart-scroll-bar-thumb-border-top-left-radius: 6px;\r\n  --smart-scroll-bar-thumb-border-bottom-left-radius: 6px;\r\n  --smart-scroll-bar-thumb-border-bottom-right-radius: 6px;\r\n  --smart-scroll-bar-thumb-size: 100%;\r\n  --smart-scroll-bar-thumb-padding: 3px;\r\n  --smart-scroll-bar-default-width: var(--smart-editor-width);\r\n  --smart-scroll-bar-default-height: var(--smart-scroll-bar-size);\r\n  --smart-scroll-bar-background: #fafafa;\r\n  --smart-scroll-bar-track-background: var(--smart-scroll-bar-background);\r\n  --smart-scroll-bar-border: #F1F1F1;\r\n  --smart-scroll-bar-thumb-background: #C1C1C1;\r\n  --smart-scroll-bar-thumb-border: transparent;\r\n}\r\nsmart-scroll-bar[orientation="vertical"] {\r\n  height: var(--smart-scroll-bar-default-width);\r\n  width: var(--smart-scroll-bar-default-height);\r\n}\r\nsmart-scroll-bar[orientation="vertical"] .smart-thumb {\r\n  width: var(--smart-scroll-bar-thumb-size);\r\n  padding: 0 var(--smart-scroll-bar-thumb-padding) 0 var(--smart-scroll-bar-thumb-padding);\r\n  height: 40px;\r\n  top: 0;\r\n}\r\nsmart-scroll-bar[orientation="vertical"] .smart-track {\r\n  float: none;\r\n  width: 100%;\r\n  height: 100%;\r\n}\r\nsmart-scroll-bar[orientation="vertical"] .smart-scroll-button {\r\n  float: none;\r\n  height: var(--smart-scroll-button-size);\r\n  width: 100%;\r\n}\r\nsmart-scroll-bar[orientation="vertical"][show-buttons] .smart-track {\r\n  height: calc(calc(100% - var(--smart-scroll-button-size) * 2));\r\n}\r\nsmart-scroll-bar[orientation="vertical"][spinner] .smart-scroll-button {\r\n  height: 50%;\r\n  width: 100%;\r\n  float: none;\r\n}\r\n',""]);const s=i},8554:(e,t,r)=>{"use strict";r.d(t,{Z:()=>s});var n=r(8081),o=r.n(n),a=r(3645),i=r.n(a)()(o());i.push([e.id,'/* smart-text-box */\ninput.smart-input {\n  border-width: var(--smart-border-width);\n  font-family: var(--smart-font-family);\n  font-size: var(--smart-font-size);\n  background: var(--smart-background);\n  border-style: solid;\n  border-color: var(--smart-border);\n  color: var(--smart-background-color);\n  border-top-left-radius: var(--smart-border-top-left-radius);\n  border-top-right-radius: var(--smart-border-top-right-radius);\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\n  padding-left: var(--smart-editor-label-padding);\n  padding-right: var(--smart-editor-label-padding);\n  padding-top: 0px;\n  padding-bottom: 0px;\n  height: var(--smart-editor-height);\n  outline: none;\n  text-align: var(--smart-text-box-text-align);\n  box-sizing: border-box;\n}\ninput.smart-input:focus {\n  border-color: var(--smart-outline);\n}\ninput.smart-input:hover {\n  border-color: var(--smart-ui-state-border-hover);\n}\ninput.smart-input:disabled {\n  border-color: var(--smart-disabled);\n  outline: none;\n}\ninput.smart-input::-moz-selection {\n  background: var(--smart-editor-selection);\n  color: var(--smart-editor-selection-color);\n}\ninput.smart-input::selection {\n  background: var(--smart-editor-selection);\n  color: var(--smart-editor-selection-color);\n}\n\ntextarea.smart-input::-moz-selection {\n  background: var(--smart-editor-selection);\n  color: var(--smart-editor-selection-color);\n}\n\ntextarea.smart-input::selection {\n  background: var(--smart-editor-selection);\n  color: var(--smart-editor-selection-color);\n}\n\n.smart-input-drop-down-menu {\n  display: block;\n  transform: scaleY(0);\n  transform-origin: top left;\n  opacity: 0;\n  position: absolute;\n  top: 100%;\n  left: 0;\n  z-index: var(--smart-editor-drop-down-z-index);\n  float: left;\n  padding: 2px;\n  margin: var(--smart-list-item-vertical-offset) var(--smart-list-item-horizontal-offset);\n  color: var(--smart-background-color);\n  background-color: var(--smart-background);\n  border: 1px solid var(--smart-border);\n  border-top-left-radius: var(--smart-border-top-left-radius);\n  border-top-right-radius: var(--smart-border-top-right-radius);\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\n  box-shadow: var(--smart-elevation-8);\n  font-size: var(--smart-font-size);\n  font-family: var(--smart-font-family);\n  overflow: hidden;\n  width: auto;\n  height: auto;\n  --smart-input-drop-down-menu-width: auto;\n  --smart-input-drop-down-menu-height: 200px;\n  /*min-width: 150px;*/\n  min-height: 0;\n}\n.smart-input-drop-down-menu[top] {\n  transform-origin: bottom;\n}\n.smart-input-drop-down-menu:not([animation=none]) {\n  transition: opacity 0.2s, transform 0.2s ease-out;\n}\n.smart-input-drop-down-menu.smart-container {\n  box-shadow: none;\n  padding: 0;\n  margin: 0;\n}\n.smart-input-drop-down-menu .smart-scroll-viewer-content-container,\n.smart-input-drop-down-menu .smart-scroll-viewer-container,\n.smart-input-drop-down-menu > .smart-container {\n  /*min-width: 150px;*/\n  width: var(--smart-input-drop-down-menu-width);\n  max-height: calc(var(--smart-input-drop-down-menu-height) - 6px);\n}\n.smart-input-drop-down-menu .smart-scroll-viewer-content-container {\n  padding: 0px;\n  max-height: initial;\n}\n.smart-input-drop-down-menu ul {\n  list-style: none;\n  padding: 0;\n  margin: 0;\n  width: 100%;\n  height: auto;\n}\n.smart-input-drop-down-menu ul.scroll {\n  width: calc(100% - var(--smart-scroll-bar-size) - 2px);\n}\n.smart-input-drop-down-menu ul li {\n  padding-bottom: 1px;\n}\n.smart-input-drop-down-menu ul li:last-child {\n  padding-bottom: 0;\n}\n.smart-input-drop-down-menu ul li a {\n  display: block;\n  padding: 8px 12px;\n  border-top-left-radius: var(--smart-item-border-top-left-radius);\n  border-top-right-radius: var(--smart-item-border-top-right-radius);\n  border-bottom-left-radius: var(--smart-item-border-bottom-left-radius);\n  border-bottom-right-radius: var(--smart-item-border-bottom-right-radius);\n  clear: both;\n  font-weight: normal;\n  white-space: nowrap;\n  color: var(--smart-background-color);\n  text-decoration: none;\n  -webkit-user-select: none;\n  -moz-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n}\n.smart-input-drop-down-menu ul li a:hover {\n  color: var(--smart-ui-state-color-hover);\n  background: var(--smart-ui-state-hover);\n}\n.smart-input-drop-down-menu ul li a.icon {\n  position: relative;\n  padding-left: var(--smart-column-icon-size);\n}\n.smart-input-drop-down-menu ul li a.icon:after {\n  content: "";\n  position: absolute;\n  left: 0;\n  top: 0;\n  width: var(--smart-column-icon-size);\n  height: 100%;\n  background-repeat: no-repeat;\n  background-position: center;\n}\n.smart-input-drop-down-menu:not(.smart-check-input-drop-down-menu) li.active a {\n  color: var(--smart-ui-state-color-focus);\n  background: var(--smart-ui-state-focus);\n  text-decoration: none;\n  outline: 0;\n}\n.smart-input-drop-down-menu[open] {\n  transform: scale(1);\n  opacity: 1;\n}\n\n.smart-multi-combo-input-scroll-viewer .smart-scroll-viewer-content-container {\n  width: var(--smart-input-drop-down-menu-width);\n  max-height: initial;\n}\n.smart-multi-combo-input-scroll-viewer .smart-scroll-viewer-container,\n.smart-multi-combo-input-scroll-viewer > .smart-container {\n  /*min-width: 150px;*/\n  width: var(--smart-input-drop-down-menu-width);\n  max-height: calc(var(--smart-input-drop-down-menu-height) - 6px);\n}\n\n.smart-drop-down smart-list-item[focus] .smart-overlay {\n  background-color: var(--smart-ui-state-focus);\n}\n.smart-drop-down smart-list-item[focus] .smart-content {\n  color: var(--smart-ui-state-color-focus);\n  border-color: var(--smart-ui-state-border-focus);\n}\n.smart-drop-down smart-list-item[focus][selected] .smart-overlay {\n  background-color: var(--smart-ui-state-selected);\n}\n.smart-drop-down smart-list-item[focus][selected] .smart-content {\n  color: var(--smart-ui-state-color-selected);\n  border-color: var(--smart-ui-state-border-selected);\n}\n\nsmart-text-box {\n  --smart-outline: var(--smart-primary);\n  display: inline-block;\n  border: none;\n  width: var(--smart-text-box-default-width);\n  height: var(--smart-text-box-default-height);\n  overflow: visible;\n  background: var(--smart-background);\n}\nsmart-text-box input::-moz-selection {\n  background: var(--smart-editor-selection);\n  color: var(--smart-editor-selection-color);\n}\nsmart-text-box input::selection {\n  background: var(--smart-editor-selection);\n  color: var(--smart-editor-selection-color);\n}\nsmart-text-box.smart-element {\n  background: var(--smart-background);\n}\nsmart-text-box[disabled] {\n  border-color: var(--smart-disabled);\n  outline: none;\n}\nsmart-text-box[hover] input, smart-text-box:focus input.hovered {\n  border-color: var(--smart-ui-state-border-hover);\n}\nsmart-text-box input:focus {\n  border-color: var(--smart-outline);\n}\nsmart-text-box input:hover {\n  border-color: var(--smart-ui-state-border-hover);\n}\n\n.smart-text-box input, .smart-text-box.smart-container {\n  width: 100%;\n  height: 100%;\n  color: inherit;\n  font-family: inherit;\n  position: relative;\n  overflow: visible;\n}\n.smart-text-box .smart-container {\n  width: 100%;\n  height: 100%;\n  color: inherit;\n  font-family: inherit;\n  position: relative;\n  overflow: visible;\n}\n.smart-text-box > .smart-container > .smart-content {\n  height: 100%;\n}\n.smart-text-box > .smart-container > .smart-content > div {\n  width: 100%;\n  height: 100%;\n  outline: none;\n  border-width: var(--smart-border-width);\n  border-style: solid;\n  border-color: var(--smart-border);\n  border-top-left-radius: var(--smart-border-top-left-radius);\n  border-top-right-radius: var(--smart-border-top-right-radius);\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\n  padding: var(--smart-editor-label-padding);\n  color: inherit;\n  font-family: inherit;\n  font-size: inherit;\n  background-color: transparent;\n  font-weight: inherit;\n  font-style: inherit;\n  overflow: hidden;\n}\n.smart-text-box > .smart-container > .smart-content > div > label {\n  color: transparent;\n}\n.smart-text-box > .smart-container > .smart-content > div:first-of-type {\n  position: absolute;\n  display: flex;\n  width: initial;\n  height: initial;\n  -webkit-user-select: none;\n     -moz-user-select: none;\n      -ms-user-select: none;\n          user-select: none;\n  pointer-events: none;\n  min-height: initial;\n  max-height: initial;\n  align-items: center;\n  padding-top: 1px;\n  padding-bottom: 1px;\n  opacity: 0.5;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  border: var(--smart-border-width);\n  border-style: solid;\n  border-color: transparent;\n}\n.smart-text-box[disabled] input, .smart-text-box[readonly] input {\n  user-select: none;\n  -webkit-user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n}\n.smart-text-box .smart-label,\n.smart-text-box .smart-hint {\n  display: none;\n  position: absolute;\n}\n.smart-text-box[label] .smart-label {\n  position: absolute;\n  left: 0;\n  bottom: 100%;\n  font-size: 12px;\n  width: 100%;\n  display: block;\n  padding: var(--smart-editor-label-padding);\n  pointer-events: none;\n  user-select: none;\n  -webkit-user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  text-align: initial;\n  line-height: initial;\n  vertical-align: initial;\n}\n.smart-text-box[hint] .smart-hint {\n  position: absolute;\n  left: 0;\n  bottom: 100%;\n  font-size: 12px;\n  width: 100%;\n  display: block;\n  padding: var(--smart-editor-label-padding);\n  pointer-events: none;\n  user-select: none;\n  -webkit-user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  text-align: initial;\n  line-height: initial;\n  vertical-align: initial;\n  opacity: 0;\n  transition: opacity 0.2s cubic-bezier(0.4, 0, 0.6, 1);\n  top: 100%;\n  bottom: initial;\n}\n.smart-text-box[hint][focus] .smart-hint {\n  opacity: 1;\n  transition: opacity 0.2s cubic-bezier(0.4, 0, 0.2, 1);\n}\n.smart-text-box .smart-drop-down {\n  font-family: inherit;\n}\n.smart-text-box:focus.hovered input {\n  border-color: var(--smart-ui-state-border-hover);\n}\n.smart-text-box[right-to-left] > .smart-container > .smart-content {\n  direction: rtl;\n}\n.smart-text-box[right-to-left] .smart-label,\n.smart-text-box[right-to-left] .smart-hint {\n  direction: rtl;\n}\n\nsmart-text-area {\n  --smart-outline: var(--smart-primary);\n  display: inline-block;\n  width: var(--smart-text-box-default-width);\n  overflow: visible;\n  background: var(--smart-background);\n  border: 1px solid var(--smart-border);\n  border-top-left-radius: var(--smart-border-top-left-radius);\n  border-top-right-radius: var(--smart-border-top-right-radius);\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\n  height: calc(1.5 * var(--smart-text-box-default-height));\n}\nsmart-text-area textarea {\n  margin: 0;\n  resize: none;\n}\nsmart-text-area textarea.smart-input {\n  border: none;\n  text-overflow: ellipsis;\n}\n\n.smart-text-area .smart-container {\n  width: 100%;\n  height: 100%;\n  color: inherit;\n  font-family: inherit;\n  position: relative;\n  overflow: visible;\n}\n.smart-text-area textarea.smart-input {\n  border-width: var(--smart-border-width);\n  font-family: var(--smart-font-family);\n  font-size: var(--smart-font-size);\n  background: var(--smart-background);\n  border-color: var(--smart-border);\n  color: var(--smart-background-color);\n  border-top-left-radius: var(--smart-border-top-left-radius);\n  border-top-right-radius: var(--smart-border-top-right-radius);\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\n  padding-left: var(--smart-editor-label-padding);\n  padding-right: var(--smart-editor-label-padding);\n  padding-top: 0px;\n  padding-bottom: 0px;\n  padding: var(--smart-editor-label-padding);\n  outline: none;\n  text-align: var(--smart-text-box-text-align);\n  box-sizing: border-box;\n  border: none;\n  height: 100%;\n  width: 100%;\n}\n\nsmart-input {\n  --smart-outline: var(--smart-primary);\n  display: inline-block;\n  width: var(--smart-text-box-default-width);\n  height: var(--smart-text-box-default-height);\n  overflow: visible;\n  background: var(--smart-background);\n  border: 1px solid var(--smart-border);\n  border-top-left-radius: var(--smart-border-top-left-radius);\n  border-top-right-radius: var(--smart-border-top-right-radius);\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\n}\nsmart-input > option {\n  display: none;\n}\nsmart-input > .smart-container {\n  display: flex;\n}\nsmart-input.smart-element {\n  background: var(--smart-background);\n}\nsmart-input input::-moz-selection {\n  background: var(--smart-editor-selection);\n  color: var(--smart-editor-selection-color);\n}\nsmart-input input::selection {\n  background: var(--smart-editor-selection);\n  color: var(--smart-editor-selection-color);\n}\nsmart-input input.smart-input {\n  border: none;\n  text-overflow: ellipsis;\n}\nsmart-input:focus {\n  border-color: var(--smart-outline);\n}\nsmart-input:hover {\n  border-color: var(--smart-ui-state-border-hover);\n}\nsmart-input[disabled] {\n  border-color: var(--smart-disabled);\n  outline: none;\n}\nsmart-input[drop-down-button-position=right] .smart-input {\n  width: calc(100% - var(--smart-editor-addon-width));\n}\n\n.smart-input.smart-container {\n  display: flex;\n}\n.smart-input.smart-container,\n.smart-input .smart-container {\n  width: 100%;\n  height: 100%;\n  color: inherit;\n  font-family: inherit;\n  position: relative;\n  overflow: visible;\n}\n.smart-input .smart-drop-down-button {\n  display: none;\n  width: var(--smart-editor-addon-width);\n  height: 100%;\n  flex-direction: column;\n  color: var(--smart-surface-color);\n  border-left: 1px solid var(--smart-border);\n  background: var(--smart-surface);\n  border-top-right-radius: var(--smart-border-top-right-radius);\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\n  outline: none;\n}\n.smart-input .smart-drop-down-button .arrow {\n  display: flex;\n  height: 100%;\n  overflow: hidden;\n  cursor: pointer;\n  font-family: var(--smart-font-family-icon);\n  justify-content: center;\n  align-items: center;\n  font-size: var(--smart-arrow-size);\n  outline: none;\n}\n.smart-input .smart-drop-down-button .arrow:after {\n  content: var(--smart-icon-arrow-down);\n  transition: opacity 0.2s, transform 0.2s ease-out;\n}\n.smart-input .smart-drop-down-button[open] .arrow:after {\n  transform: rotate(-180deg);\n}\n.smart-input .smart-input {\n  border: none;\n  padding: var(--smart-editor-label-padding);\n  height: 100%;\n  width: 100%;\n}\n.smart-input[drop-down-button-position=left] .smart-drop-down-button, .smart-input[drop-down-button-position=right] .smart-drop-down-button {\n  display: flex;\n}\n.smart-input[drop-down-button-position=left] .smart-input, .smart-input[drop-down-button-position=right] .smart-input {\n  width: calc(100% - var(--smart-editor-addon-width));\n}\n.smart-input[drop-down-button-position=left][disabled] .smart-drop-down-button, .smart-input[drop-down-button-position=right][disabled] .smart-drop-down-button {\n  opacity: 0.5;\n}\n.smart-input[drop-down-button-position=left] .smart-drop-down-button {\n  order: -1;\n  border-right: 1px solid var(--smart-border);\n  border-left: none;\n  border-top-right-radius: 0px;\n  border-bottom-right-radius: 0px;\n  border-top-left-radius: var(--smart-border-top-left-radius);\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\n}\n.smart-input[drop-down-button-position=left] .smart-input {\n  border-top-left-radius: 0px;\n  border-bottom-left-radius: 0px;\n}\n.smart-input[drop-down-button-position=left][readonly] .smart-drop-down-button {\n  border-right: none;\n}\n.smart-input[drop-down-button-position=right] .smart-input {\n  border-top-right-radius: 0px;\n  border-bottom-right-radius: 0px;\n}\n.smart-input[focus] {\n  border-color: var(--smart-outline);\n}\n.smart-input[focus]:not([disabled]) .smart-drop-down-button {\n  border-color: var(--smart-outline);\n}\n.smart-input[readonly] .smart-drop-down-button {\n  border-left: none;\n}\n.smart-input[readonly]:not(.underlined):not(.outlined) input.smart-input,\n.smart-input[readonly]:not(.underlined):not(.outlined) textarea.smart-input {\n  padding: 0;\n  cursor: pointer;\n  padding-left: var(--smart-editor-label-padding);\n  outline: none;\n}\n.smart-input[readonly]:not(.underlined):not(.outlined):not([opened]):not(:active) input.smart-input,\n.smart-input[readonly]:not(.underlined):not(.outlined):not([opened]):not(:active) textarea.smart-input {\n  background: var(--smart-surface);\n  color: var(--smart-surface-color);\n}\n.smart-input:not([disabled])[readonly]:hover .smart-input,\n.smart-input:not([disabled])[readonly]:hover .smart-drop-down-button {\n  background: var(--smart-ui-state-hover);\n  color: var(--smart-ui-state-color-hover);\n}\n.smart-input:not([disabled]) .smart-drop-down-button:hover {\n  background: var(--smart-ui-state-hover);\n  color: var(--smart-ui-state-color-hover);\n}\n.smart-input:not([disabled]) .smart-drop-down-button[open],\n.smart-input:not([disabled]) .smart-drop-down-button:active {\n  background: var(--smart-ui-state-active);\n  color: var(--smart-ui-state-color-active);\n}\n.smart-input:not([disabled])[readonly][open] .smart-input,\n.smart-input:not([disabled])[readonly][open] .smart-drop-down-button, .smart-input:not([disabled])[readonly]:active .smart-input,\n.smart-input:not([disabled])[readonly]:active .smart-drop-down-button {\n  background: var(--smart-ui-state-active);\n  color: var(--smart-ui-state-color-active);\n}\n.smart-input:not([disabled])[readonly][open] .smart-input::-webkit-input-placeholder, .smart-input:not([disabled])[readonly]:active .smart-input::-webkit-input-placeholder {\n  color: var(--smart-ui-state-color-active);\n}\n.smart-input:not([disabled])[readonly][open] .smart-input::-moz-placeholder, .smart-input:not([disabled])[readonly]:active .smart-input::-moz-placeholder {\n  color: var(--smart-ui-state-color-active);\n}\n.smart-input[disabled] .smart-drop-down-button .arrow {\n  cursor: initial;\n}\n.smart-input[right-to-left] .smart-input {\n  direction: rtl;\n}\n.smart-input[right-to-left][readonly] .smart-drop-down-button {\n  border-right: none;\n}\n.smart-input[right-to-left][readonly] .smart-input, .smart-input[right-to-left][readonly]:not(.underlined):not(.outlined) .smart-input {\n  padding-left: initial;\n  padding-right: var(--smart-editor-label-padding);\n}\n.smart-input[right-to-left][readonly] .smart-drop-down-button {\n  border-top-right-radius: 0px;\n  border-bottom-right-radius: 0px;\n}\n.smart-input[right-to-left][drop-down-button-position=right] .smart-input {\n  border-top-left-radius: 0px;\n  border-bottom-left-radius: 0px;\n}\n\n.smart-input-drop-down-menu[right-to-left] ul.scroll {\n  width: 100%;\n}\n.smart-input-drop-down-menu[right-to-left] li a.icon {\n  padding-left: initial;\n  padding-right: var(--smart-column-icon-size);\n}\n.smart-input-drop-down-menu[right-to-left] li a.icon:after {\n  left: initial;\n  right: 0;\n}\n\nsmart-number-input {\n  --smart-outline: var(--smart-primary);\n  display: inline-block;\n  width: var(--smart-text-box-default-width);\n  height: var(--smart-text-box-default-height);\n  overflow: visible;\n  background: var(--smart-background);\n  border: 1px solid var(--smart-border);\n  border-top-left-radius: var(--smart-border-top-left-radius);\n  border-top-right-radius: var(--smart-border-top-right-radius);\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\n  text-align: right;\n}\nsmart-number-input > .smart-container {\n  display: flex;\n}\nsmart-number-input.smart-element {\n  background: var(--smart-background);\n}\nsmart-number-input input.smart-input {\n  border: none;\n  text-overflow: ellipsis;\n}\nsmart-number-input[drop-down-button-position=right] .smart-input {\n  width: calc(100% - var(--smart-editor-addon-width));\n}\n\n.smart-number-input .nav {\n  display: flex;\n  width: var(--smart-editor-addon-width);\n  height: 100%;\n  flex-direction: column;\n  color: var(--smart-surface-color);\n  border-left: 1px solid var(--smart-border);\n  background: var(--smart-surface);\n}\n.smart-number-input .nav:hover, .smart-number-input .nav:active {\n  background: var(--smart-surface);\n  color: var(--smart-surface-color);\n}\n.smart-number-input .nav.smart-drop-down-button:hover, .smart-number-input .nav.smart-drop-down-button:active {\n  background: var(--smart-surface);\n  color: var(--smart-surface-color);\n}\n.smart-number-input .nav .up,\n.smart-number-input .nav .down {\n  display: flex;\n  height: 50%;\n  overflow: hidden;\n  cursor: pointer;\n  font-family: var(--smart-font-family-icon);\n  justify-content: center;\n  align-items: center;\n  outline: none;\n}\n.smart-number-input .nav .up:hover,\n.smart-number-input .nav .down:hover {\n  background: var(--smart-ui-state-hover);\n  color: var(--smart-ui-state-color-hover);\n}\n.smart-number-input .nav .up:active, .smart-number-input .nav .up[active],\n.smart-number-input .nav .down:active,\n.smart-number-input .nav .down[active] {\n  background: var(--smart-ui-state-active);\n  color: var(--smart-ui-state-color-active);\n}\n.smart-number-input .nav .up {\n  border-bottom: var(--smart-border-width) solid var(--smart-border);\n}\n.smart-number-input .nav .up:after {\n  content: var(--smart-icon-arrow-up);\n}\n.smart-number-input .nav .down:after {\n  content: var(--smart-icon-arrow-down);\n}\n.smart-number-input[disabled] .nav .up,\n.smart-number-input[disabled] .nav .down {\n  pointer-events: none;\n}\n.smart-number-input[right-to-left] > .smart-container {\n  direction: rtl;\n}\n.smart-number-input[right-to-left] .nav {\n  border-left: initial;\n  border-right: var(--smart-border-width) solid var(--smart-border);\n  border-top-left-radius: var(--smart-border-top-right-radius);\n  border-bottom-left-radius: var(--smart-border-bottom-right-radius);\n  border-top-right-radius: initial;\n  border-bottom-right-radius: initial;\n  order: initial;\n}\n.smart-number-input[right-to-left] .smart-input {\n  border-top-left-radius: initial;\n  border-bottom-left-radius: initial;\n  border-top-right-radius: var(--smart-border-top-right-radius);\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\n}\n.smart-number-input[right-to-left][focus] .nav {\n  border-color: var(--smart-outline);\n}\n\nsmart-password-input {\n  --smart-outline: var(--smart-primary);\n  display: inline-block;\n  width: var(--smart-text-box-default-width);\n  height: var(--smart-text-box-default-height);\n  overflow: visible;\n  background: var(--smart-background);\n  border: 1px solid var(--smart-border);\n  border-top-left-radius: var(--smart-border-top-left-radius);\n  border-top-right-radius: var(--smart-border-top-right-radius);\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\n}\nsmart-password-input > .smart-container {\n  display: flex;\n}\nsmart-password-input.smart-element {\n  background: var(--smart-background);\n}\nsmart-password-input input.smart-input {\n  border: none;\n  text-overflow: ellipsis;\n}\n\n.smart-password-input input::-ms-reveal,\n.smart-password-input input::-ms-clear {\n  display: none;\n}\n.smart-password-input .smart-container {\n  width: 100%;\n  height: 100%;\n  color: inherit;\n  font-family: inherit;\n  position: relative;\n  overflow: visible;\n}\n.smart-password-input .smart-drop-down-button {\n  background: transparent;\n  border-color: transparent;\n  display: block;\n  border-left: none;\n}\n.smart-password-input .smart-drop-down-button:hover, .smart-password-input .smart-drop-down-button:active, .smart-password-input .smart-drop-down-button[active] {\n  color: var(--smart-primary) !important;\n  background: transparent !important;\n  border-color: transparent !important;\n}\n.smart-password-input .smart-drop-down-button .arrow:after {\n  color: var(--smart-background-color);\n  content: var(--smart-icon-visibility);\n}\n.smart-password-input .smart-drop-down-button .arrow.off:after {\n  color: var(--smart-background-color);\n  content: var(--smart-icon-visibility-off);\n}\n\nsmart-multi-input {\n  --smart-outline: var(--smart-primary);\n  display: inline-block;\n  width: var(--smart-text-box-default-width);\n  height: var(--smart-text-box-default-height);\n  overflow: visible;\n  background: var(--smart-background);\n  border: 1px solid var(--smart-border);\n  border-top-left-radius: var(--smart-border-top-left-radius);\n  border-top-right-radius: var(--smart-border-top-right-radius);\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\n}\nsmart-multi-input > option {\n  display: none;\n}\nsmart-multi-input > .smart-container {\n  display: flex;\n}\nsmart-multi-input.smart-element {\n  background: var(--smart-background);\n}\nsmart-multi-input input::-moz-selection {\n  background: var(--smart-editor-selection);\n  color: var(--smart-editor-selection-color);\n}\nsmart-multi-input input::selection {\n  background: var(--smart-editor-selection);\n  color: var(--smart-editor-selection-color);\n}\nsmart-multi-input input.smart-input {\n  border: none;\n  text-overflow: ellipsis;\n}\nsmart-multi-input[focus], smart-multi-input:focus {\n  border-color: var(--smart-outline);\n}\nsmart-multi-input:hover {\n  border-color: var(--smart-ui-state-border-hover);\n}\nsmart-multi-input[disabled] {\n  border-color: var(--smart-disabled);\n  outline: none;\n}\nsmart-multi-input[drop-down-button-position=left] .smart-input, smart-multi-input[drop-down-button-position=right] .smart-input {\n  width: calc(100% - var(--smart-editor-addon-width));\n}\n\n.smart-multi-input .smart-container {\n  width: 100%;\n  height: 100%;\n  color: inherit;\n  font-family: inherit;\n  position: relative;\n  overflow: visible;\n}\n\n.smart-multi-input-drop-down-menu li a {\n  border-left: var(--smart-border-width) solid transparent;\n}\n.smart-multi-input-drop-down-menu:not(.smart-check-input-drop-down-menu) li.active a {\n  border-left: var(--smart-border-width) solid var(--smart-primary);\n  border-top-left-radius: 0;\n  border-bottom-left-radius: 0;\n  color: var(--smart-ui-state-color-selected);\n  background: var(--smart-ui-state-selected);\n}\n.smart-multi-input-drop-down-menu[right-to-left] li a {\n  border-left: none;\n  border-right: var(--smart-border-width) solid transparent;\n}\n.smart-multi-input-drop-down-menu[right-to-left]:not(.smart-check-input-drop-down-menu) li.active a {\n  border-left: var(--smart-border-width) solid transparent;\n  border-right: var(--smart-border-width) solid var(--smart-primary);\n  border-top-left-radius: var(--smart-border-top-left-radius);\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\n  border-top-right-radius: 0;\n  border-bottom-right-radius: 0;\n}\n\nsmart-multi-combo-input {\n  --smart-outline: var(--smart-primary);\n  display: inline-block;\n  width: var(--smart-text-box-default-width);\n  height: var(--smart-text-box-default-height);\n  overflow: visible;\n  background: var(--smart-background);\n  border: 1px solid var(--smart-border);\n  border-top-left-radius: var(--smart-border-top-left-radius);\n  border-top-right-radius: var(--smart-border-top-right-radius);\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\n}\nsmart-multi-combo-input > option {\n  display: none;\n}\nsmart-multi-combo-input > .smart-container {\n  display: flex;\n}\nsmart-multi-combo-input.smart-element {\n  background: var(--smart-background);\n}\nsmart-multi-combo-input input::-moz-selection {\n  background: var(--smart-editor-selection);\n  color: var(--smart-editor-selection-color);\n}\nsmart-multi-combo-input input::selection {\n  background: var(--smart-editor-selection);\n  color: var(--smart-editor-selection-color);\n}\nsmart-multi-combo-input input.smart-input {\n  border: none;\n  text-overflow: ellipsis;\n}\nsmart-multi-combo-input:hover {\n  border-color: var(--smart-ui-state-border-hover);\n}\nsmart-multi-combo-input[focus] {\n  border-color: var(--smart-outline);\n}\n\n.smart-multi-combo-input {\n  height: var(--smart-editor-height);\n  min-height: var(--smart-editor-height);\n}\n.smart-multi-combo-input:not([input-tags-mode=one]):not(.smart-grid-cell-editor) {\n  height: auto !important;\n}\n.smart-multi-combo-input .smart-container {\n  width: 100%;\n  height: 100%;\n  color: inherit;\n  font-family: inherit;\n  position: relative;\n  overflow: visible;\n}\n.smart-multi-combo-input > .smart-container {\n  min-height: var(--smart-editor-height);\n}\n.smart-multi-combo-input .smart-drop-down-button {\n  min-height: var(--smart-editor-height);\n}\n.smart-multi-combo-input .smart-drop-down-button .arrow {\n  min-height: var(--smart-editor-height);\n}\n.smart-multi-combo-input .smart-token {\n  position: relative;\n  white-space: nowrap;\n  text-overflow: ellipsis;\n  cursor: pointer;\n  -webkit-user-select: none;\n     -moz-user-select: none;\n      -ms-user-select: none;\n          user-select: none;\n  display: flex;\n  align-items: center;\n  padding: 1px 6px 1px 6px;\n  border-radius: 20px;\n  background-color: var(--smart-primary);\n  color: var(--smart-primary-color);\n  margin: 0;\n  height: 22px;\n}\n.smart-multi-combo-input .smart-token .smart-drop-down-list-selection-label {\n  text-overflow: ellipsis;\n  overflow: hidden;\n}\n.smart-multi-combo-input .smart-token .smart-drop-down-list-selection-image {\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  border-radius: 50%;\n  width: 20px;\n  height: 20px;\n  background-position: center;\n  background-repeat: no-repeat;\n  background-size: cover;\n  margin-right: 4px;\n}\n.smart-multi-combo-input .smart-action-button {\n  display: flex;\n  outline: 1px solid transparent;\n  height: 100%;\n  width: 100%;\n  flex-wrap: wrap;\n  overflow: hidden;\n  position: relative;\n  -webkit-user-select: none;\n     -moz-user-select: none;\n      -ms-user-select: none;\n          user-select: none;\n  border-top-left-radius: var(--smart-border-top-left-radius);\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\n  min-height: var(--smart-editor-height);\n  align-items: center;\n}\n.smart-multi-combo-input .smart-drop-down-list-unselect-button {\n  position: relative;\n  margin-left: 2px;\n  margin-right: -2px;\n}\n.smart-multi-combo-input .smart-drop-down-list-unselect-button:after {\n  content: var(--smart-icon-close);\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  transform-origin: center;\n  font-family: var(--smart-font-family-icon);\n  background: rgba(var(--smart-primary-rgb), 0.2);\n  border-radius: 50%;\n  width: 20px;\n  height: 20px;\n}\n.smart-multi-combo-input.smart-input .smart-input {\n  flex-grow: 1;\n  align-self: center;\n  width: var(--smart-editor-addon-width);\n  min-width: var(--smart-editor-addon-width);\n  min-height: 100%;\n  max-height: 1rem;\n  vertical-align: middle;\n  margin: 0;\n}\n.smart-multi-combo-input.smart-input .smart-drop-down-button {\n  height: initial;\n}\n.smart-multi-combo-input[drop-down-button-position=left] .smart-action-button, .smart-multi-combo-input[drop-down-button-position=right] .smart-action-button {\n  width: calc(100% - var(--smart-editor-addon-width));\n}\n.smart-multi-combo-input[input-tags-mode=one] .smart-action-button {\n  align-items: center;\n}\n.smart-multi-combo-input[readonly] .smart-input {\n  visibility: hidden;\n}\n.smart-multi-combo-input[readonly] .smart-action-button {\n  background: var(--smart-surface);\n  color: var(--smart-surface-color);\n}\n.smart-multi-combo-input[readonly][open] .smart-action-button,\n.smart-multi-combo-input[readonly][open] .smart-drop-down-button {\n  background: var(--smart-ui-state-hover) !important;\n  color: var(--smart-ui-state-color-hover) !important;\n}\n.smart-multi-combo-input[readonly]:hover .smart-action-button {\n  background: var(--smart-ui-state-hover);\n  color: var(--smart-ui-state-color-hover);\n}\n.smart-multi-combo-input[hide-input-tags-close-button] .smart-drop-down-list-unselect-button:after {\n  display: none;\n}\n.smart-multi-combo-input[right-to-left] .smart-token {\n  margin: var(--smart-editor-label-padding) var(--smart-editor-label-padding) 0 0;\n  padding: 1px 6px 1px 2px;\n}\n.smart-multi-combo-input[right-to-left] .smart-token:last-of-type {\n  margin: var(--smart-editor-label-padding) var(--smart-editor-label-padding) var(--smart-editor-label-padding) 0;\n}\n.smart-multi-combo-input[right-to-left] .smart-action-button {\n  direction: rtl;\n}\n.smart-multi-combo-input[right-to-left] .smart-drop-down-list-unselect-button {\n  margin: 0 5px 0 0;\n}\n\n.smart-multi-combo-input-drop-down-menu .smart-scroll-viewer {\n  width: inherit;\n  height: inherit;\n  padding: initial;\n  min-height: inherit;\n  border: initial;\n}\n.smart-multi-combo-input-drop-down-menu .close-button:after {\n  font-family: var(--smart-font-family-icon);\n  content: var(--smart-icon-close);\n  margin-left: 5px;\n}\n.smart-multi-combo-input-drop-down-menu .add-new-item {\n  display: grid;\n  grid-template-columns: 1fr var(--smart-text-box-default-height);\n  grid-column-gap: 5px;\n  margin-left: 7px;\n  margin-right: 7px;\n  height: 36px;\n}\n.smart-multi-combo-input-drop-down-menu .add-new-item input {\n  height: 30px;\n}\n.smart-multi-combo-input-drop-down-menu .add-new-item smart-button {\n  justify-content: center;\n  align-content: center;\n  height: 30px;\n}\n.smart-multi-combo-input-drop-down-menu .add-new-item button {\n  padding: 0;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n.smart-multi-combo-input-drop-down-menu .add-new-item button:after {\n  font-family: var(--smart-font-family-icon);\n  content: var(--smart-icon-plus);\n}\n.smart-multi-combo-input-drop-down-menu .smart-select-all {\n  height: auto;\n  border-bottom: var(--smart-border-width) solid var(--smart-border);\n}\n.smart-multi-combo-input-drop-down-menu[right-to-left] > ul {\n  direction: rtl;\n}\n.smart-multi-combo-input-drop-down-menu ul li a {\n  display: flex;\n  align-items: center;\n}\n.smart-multi-combo-input-drop-down-menu ul li a .smart-drop-down-list-selection-image {\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  width: 25px;\n  height: 25px;\n  background-position: center;\n  background-repeat: no-repeat;\n  background-size: cover;\n  margin-right: 4px;\n  border-radius: 50%;\n  border: 1px solid var(--smart-border);\n}\n.smart-multi-combo-input-drop-down-menu[single-select] ul li {\n  height: 36px;\n  margin-top: 1px;\n  cursor: pointer;\n}\n.smart-multi-combo-input-drop-down-menu[single-select] ul li a {\n  padding: 0px;\n  padding-left: 6px;\n  height: 100%;\n}\n.smart-multi-combo-input-drop-down-menu[single-select] ul li::after {\n  display: none;\n}\n.smart-multi-combo-input-drop-down-menu[single-select] ul li:hover, .smart-multi-combo-input-drop-down-menu[single-select] ul li.selected {\n  background: var(--smart-ui-state-hover);\n  border-color: var(--smart-ui-state-hover);\n  color: var(--smart-ui-state-color-hover);\n}\n.smart-multi-combo-input-drop-down-menu[single-select] ul li:hover:after, .smart-multi-combo-input-drop-down-menu[single-select] ul li.selected:after {\n  display: none;\n}\n.smart-multi-combo-input-drop-down-menu[pills] ul li {\n  height: 30px;\n  margin-top: 1px;\n}\n.smart-multi-combo-input-drop-down-menu[pills] ul li:before {\n  display: none;\n}\n.smart-multi-combo-input-drop-down-menu[pills] ul li:after {\n  display: none;\n}\n.smart-multi-combo-input-drop-down-menu[pills] ul li a {\n  padding: 2px 10px;\n  color: inherit;\n  display: inline-flex;\n  align-items: center;\n  border-radius: 15px !important;\n  margin-top: 5px;\n  margin-left: 5px;\n  height: auto;\n  background: var(--smart-primary);\n  border-color: var(--smart-primary);\n  color: var(--smart-primary-color);\n}\n.smart-multi-combo-input-drop-down-menu[pills] ul li a .smart-drop-down-list-selection-image {\n  height: 20px;\n  width: 20px;\n}\n.smart-multi-combo-input-drop-down-menu[pills] ul li.focused a {\n  background: var(--smart-primary) !important;\n  border-color: var(--smart-primary) !important;\n  color: var(--smart-primary-color) !important;\n}\n.smart-multi-combo-input-drop-down-menu[pills] ul li.focused, .smart-multi-combo-input-drop-down-menu[pills] ul li:hover, .smart-multi-combo-input-drop-down-menu[pills] ul li.selected {\n  background: var(--smart-ui-state-hover);\n  border-color: var(--smart-ui-state-hover);\n  color: var(--smart-ui-state-color-hover);\n}\n.smart-multi-combo-input-drop-down-menu[pills] ul li.focused:after, .smart-multi-combo-input-drop-down-menu[pills] ul li:hover:after, .smart-multi-combo-input-drop-down-menu[pills] ul li.selected:after {\n  display: none;\n}\n.smart-multi-combo-input-drop-down-menu[pills] ul li.active.selected:before {\n  display: none;\n}\n\nsmart-check-input {\n  --smart-outline: var(--smart-primary);\n  display: inline-block;\n  width: var(--smart-text-box-default-width);\n  height: var(--smart-text-box-default-height);\n  overflow: visible;\n  background: var(--smart-background);\n  border: 1px solid var(--smart-border);\n  border-top-left-radius: var(--smart-border-top-left-radius);\n  border-top-right-radius: var(--smart-border-top-right-radius);\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\n}\nsmart-check-input > option {\n  display: none;\n}\nsmart-check-input > .smart-container {\n  display: flex;\n}\nsmart-check-input.smart-element {\n  background: var(--smart-background);\n}\nsmart-check-input input::-moz-selection {\n  background: var(--smart-editor-selection);\n  color: var(--smart-editor-selection-color);\n}\nsmart-check-input input::selection {\n  background: var(--smart-editor-selection);\n  color: var(--smart-editor-selection-color);\n}\nsmart-check-input input.smart-input {\n  border: none;\n  text-overflow: ellipsis;\n}\nsmart-check-input:hover {\n  border-color: var(--smart-ui-state-border-hover);\n}\nsmart-check-input[disabled] {\n  border-color: var(--smart-disabled);\n  outline: none;\n}\nsmart-check-input[focus], smart-check-input:focus {\n  border-color: var(--smart-outline);\n}\nsmart-check-input[drop-down-button-position=left] .smart-input, smart-check-input[drop-down-button-position=right] .smart-input {\n  width: calc(100% - var(--smart-editor-addon-width));\n}\n\n.smart-check-input .smart-container {\n  width: 100%;\n  height: 100%;\n  color: inherit;\n  font-family: inherit;\n  position: relative;\n  overflow: visible;\n}\n\n.smart-check-input-drop-down-menu ul li {\n  position: relative;\n}\n.smart-check-input-drop-down-menu ul li:before {\n  content: "";\n  transform: scale(0);\n  background-color: white;\n}\n.smart-check-input-drop-down-menu ul li:after {\n  content: "";\n  position: absolute;\n  border: var(--smart-border-width) solid var(--smart-border);\n  border-top-left-radius: var(--smart-border-top-left-radius);\n  border-top-right-radius: var(--smart-border-top-right-radius);\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\n  width: var(--smart-check-box-default-size);\n  height: var(--smart-check-box-default-size);\n  padding: 1px;\n  margin-left: 10px;\n  font-family: var(--smart-font-family-icon);\n  justify-content: center;\n  align-items: center;\n  display: flex;\n  top: 50%;\n  transform: translateY(-50%);\n  pointer-events: none;\n  box-sizing: content-box;\n}\n.smart-check-input-drop-down-menu ul li a {\n  padding-left: calc(var(--smart-tree-indent) + 25px);\n}\n.smart-check-input-drop-down-menu ul li.selected:after {\n  content: var(--smart-icon-check);\n  background: var(--smart-primary);\n  border-color: var(--smart-primary);\n  color: var(--smart-primary-color);\n}\n.smart-check-input-drop-down-menu ul li.selected.color:after {\n  content: "";\n}\n.smart-check-input-drop-down-menu ul li.active.selected:before {\n  position: absolute;\n  content: "";\n  border-radius: 50%;\n  width: calc(var(--smart-check-box-default-size) + 16px);\n  height: calc(var(--smart-check-box-default-size) + 16px);\n  background: var(--smart-primary);\n  opacity: 0.3;\n  margin-left: 4px;\n  top: 50%;\n  transform: scale(1) translateY(-50%);\n  transform-origin: top;\n}\n.smart-check-input-drop-down-menu ul li.active.focused a {\n  border-left: var(--smart-border-width) solid var(--smart-primary);\n  border-top-left-radius: 0;\n  border-bottom-left-radius: 0;\n  color: var(--smart-ui-state-color-selected);\n  background: var(--smart-ui-state-selected);\n}\n.smart-check-input-drop-down-menu ul li[indeterminate]:after {\n  background-color: var(--smart-ui-state-selected);\n  padding: 2px;\n  background-clip: content-box;\n}\n.smart-check-input-drop-down-menu[inverted] ul li:after {\n  margin-left: initial;\n  margin-right: 10px;\n  right: 0;\n}\n.smart-check-input-drop-down-menu[inverted] ul li.selected:before {\n  right: 0;\n}\n.smart-check-input-drop-down-menu[inverted] ul li a {\n  padding-left: 10px;\n  padding-right: calc(var(--smart-tree-indent) + 25px);\n}\n.smart-check-input-drop-down-menu[inverted] ul li.active.selected:before {\n  margin-left: initial;\n  margin-right: 4px;\n}\n.smart-check-input-drop-down-menu:not([animation=none]) ul li:before {\n  transition: transform 0.25s ease-in-out;\n}\n.smart-check-input-drop-down-menu[right-to-left] ul li:after {\n  margin-left: initial;\n  margin-right: 10px;\n}\n.smart-check-input-drop-down-menu[right-to-left] ul li a {\n  padding-left: 10px;\n  padding-right: calc(var(--smart-tree-indent) + 25px);\n}\n.smart-check-input-drop-down-menu[right-to-left] ul li.active.focused a {\n  border-left: var(--smart-border-width) solid transparent;\n  border-right: var(--smart-border-width) solid var(--smart-primary);\n  border-top-left-radius: var(--smart-border-top-left-radius);\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\n  border-top-right-radius: 0;\n  border-bottom-right-radius: 0;\n}\n.smart-check-input-drop-down-menu[right-to-left] ul li.active.selected:before {\n  margin-left: initial;\n  margin-right: 4px;\n}\n.smart-check-input-drop-down-menu[right-to-left][pills] ul li a {\n  padding-right: initial;\n}\n\nsmart-color-input {\n  --smart-outline: var(--smart-primary);\n  display: inline-block;\n  border: none;\n  width: var(--smart-text-box-default-width);\n  height: var(--smart-text-box-default-height);\n  overflow: visible;\n  background: var(--smart-background);\n}\nsmart-color-input[value-display-mode=colorBox] .smart-action-button {\n  cursor: pointer;\n}\n\nsmart-time-input,\nsmart-date-input,\nsmart-date-range-input {\n  --smart-outline: var(--smart-primary);\n  display: inline-block;\n  width: var(--smart-text-box-default-width);\n  height: var(--smart-text-box-default-height);\n  background: var(--smart-background);\n  border: 1px solid var(--smart-border);\n  border-top-left-radius: var(--smart-border-top-left-radius);\n  border-top-right-radius: var(--smart-border-top-right-radius);\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\n  overflow: hidden;\n}\nsmart-time-input > .smart-container,\nsmart-date-input > .smart-container,\nsmart-date-range-input > .smart-container {\n  display: flex;\n}\nsmart-time-input.smart-element,\nsmart-date-input.smart-element,\nsmart-date-range-input.smart-element {\n  background: var(--smart-background);\n}\nsmart-time-input[drop-down-button-position=left] .smart-input, smart-time-input[drop-down-button-position=right] .smart-input,\nsmart-date-input[drop-down-button-position=left] .smart-input,\nsmart-date-input[drop-down-button-position=right] .smart-input,\nsmart-date-range-input[drop-down-button-position=left] .smart-input,\nsmart-date-range-input[drop-down-button-position=right] .smart-input {\n  width: calc(100% - var(--smart-editor-addon-width));\n}\n\nsmart-date-range-input input::-moz-selection {\n  background: var(--smart-editor-selection);\n  color: var(--smart-editor-selection-color);\n}\n\nsmart-date-range-input input::selection {\n  background: var(--smart-editor-selection);\n  color: var(--smart-editor-selection-color);\n}\nsmart-date-range-input input.smart-input {\n  border: none;\n  text-overflow: ellipsis;\n}\nsmart-date-range-input[focus], smart-date-range-input:focus {\n  border-color: var(--smart-outline);\n}\n\n.smart-time-box {\n  display: block;\n  height: auto;\n  width: 300px;\n  overflow: hidden;\n}\n.smart-time-box .smart-timepicker {\n  display: grid;\n  grid-template-columns: 60% 35%;\n  grid-column-gap: 5%;\n  background: var(--smart-background);\n  padding: 10px;\n  border-color: var(--smart-border);\n}\n.smart-time-box[right-to-left] .smart-timepicker {\n  direction: rtl;\n}\n\n.smart-time-input.smart-input .smart-drop-down-button .arrow:after,\n.smart-time-input.smart-input .smart-drop-down-button[open] .arrow:after {\n  content: var(--smart-icon-clock);\n  transform: rotate(0deg);\n}\n\n.smart-timepicker .minute-selection,\n.smart-timepicker .hour-selection {\n  display: grid;\n  grid-template-columns: repeat(5, 20%);\n  grid-template-rows: repeat(6, auto);\n  justify-content: center;\n  align-items: center;\n  justify-items: center;\n  position: relative;\n  cursor: default;\n}\n.smart-timepicker .minute-selection .smart-calendar-cell,\n.smart-timepicker .hour-selection .smart-calendar-cell {\n  margin: initial;\n  line-height: var(--smart-calendar-cell-size);\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  width: 32px;\n  height: 32px;\n  box-sizing: border-box;\n  border-radius: 100%;\n}\n.smart-timepicker .minute-selection .header,\n.smart-timepicker .hour-selection .header {\n  content: attr(header-label);\n  width: 100%;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  grid-row: 1/3;\n  grid-column: 1/6;\n  font-weight: 600;\n  height: var(--smart-calendar-cell-size);\n  line-height: calc(var(--smart-calendar-cell-size) - 2px);\n}\n.smart-timepicker .minute-selection {\n  border-left: initial;\n  border-right: var(--smart-border-width) solid var(--smart-border);\n  grid-template-columns: repeat(2, 50%);\n  border-left: var(--smart-border-width) solid var(--smart-border);\n}\n.smart-timepicker .minute-selection .header {\n  grid-column: span 2;\n}\n.smart-timepicker .hour-selection:before, .smart-timepicker .hour-selection:after {\n  content: attr(am-label);\n  width: 100%;\n  display: flex;\n  justify-content: center;\n  grid-column: 1;\n  font-weight: 600;\n  height: var(--smart-calendar-cell-size);\n  line-height: calc(var(--smart-calendar-cell-size) - 2px);\n}\n.smart-timepicker .hour-selection:after {\n  content: attr(pm-label);\n  grid-row: 4/9;\n}\n\n.smart-date-input.smart-input .smart-drop-down-button .arrow:after,\n.smart-date-input.smart-input .smart-drop-down-button[open] .arrow:after {\n  content: var(--smart-icon-calendar);\n  transform: rotate(0deg);\n}\n\n.smart-date-range-input.smart-input .smart-drop-down-button .arrow:after,\n.smart-date-range-input.smart-input .smart-drop-down-button[open] .arrow:after {\n  content: var(--smart-icon-calendar);\n  transform: rotate(0deg);\n}\n.smart-date-range-input .smart-container {\n  width: 100%;\n  height: 100%;\n  color: inherit;\n  font-family: inherit;\n  position: relative;\n  overflow: visible;\n}\n\n.smart-date-range-input-drop-down-menu smart-button:first-of-type {\n  margin-left: 5px;\n}\n.smart-date-range-input-drop-down-menu smart-button:last-of-type {\n  margin-right: 5px;\n}\n.smart-date-range-input-drop-down-menu .smart-calendar {\n  height: 100%;\n  min-width: 100%;\n  --smart-calendar-default-height: auto;\n  --smart-calendar-footer-height: 0px;\n}\n.smart-date-range-input-drop-down-menu .smart-done-button,\n.smart-date-range-input-drop-down-menu .smart-today-button,\n.smart-date-range-input-drop-down-menu .smart-clear-button {\n  height: auto;\n  --smart-button-padding: 5px;\n}\n.smart-date-range-input-drop-down-menu .smart-done-button,\n.smart-date-range-input-drop-down-menu .smart-today-button {\n  margin-right: 5px;\n}\n.smart-date-range-input-drop-down-menu .smart-calendar-footer {\n  flex-direction: column;\n}\n.smart-date-range-input-drop-down-menu .smart-timepicker-buttons,\n.smart-date-range-input-drop-down-menu .smart-button-controls {\n  display: none;\n}\n.smart-date-range-input-drop-down-menu .smart-date-range-input-footer-controls {\n  width: 100%;\n  height: 100%;\n}\n.smart-date-range-input-drop-down-menu .smart-timepicker-button {\n  position: relative;\n  white-space: nowrap;\n}\n.smart-date-range-input-drop-down-menu .smart-timepicker-button:empty {\n  display: none;\n}\n.smart-date-range-input-drop-down-menu .smart-timepicker-button:before {\n  content: var(--smart-icon-clock);\n  height: 100%;\n  font-family: var(--smart-font-family-icon);\n  font-weight: var(--smart-font-weight);\n  font-size: var(--smart-arrow-size);\n  margin: 0 var(--smart-editor-label-padding) 0 var(--smart-editor-label-padding);\n}\n.smart-date-range-input-drop-down-menu .smart-timepicker-button:hover {\n  color: var(--smart-ui-state-color-hover);\n  border-color: var(--smart-ui-state-hover);\n  background-color: var(--smart-ui-state-hover);\n  transition: background-color 100ms linear, color 100ms ease-in-out;\n  opacity: var(--smart-button-opacity-hover);\n  cursor: pointer;\n}\n.smart-date-range-input-drop-down-menu .smart-timepicker-button[selected] {\n  color: var(--smart-ui-state-color-selected);\n}\n.smart-date-range-input-drop-down-menu .smart-icon-today:before {\n  content: var(--smart-icon-calendar);\n}\n.smart-date-range-input-drop-down-menu .smart-icon-clear:before {\n  content: var(--smart-icon-cancel);\n}\n.smart-date-range-input-drop-down-menu .smart-timepicker {\n  position: absolute;\n  top: 0;\n  display: grid;\n  grid-template-columns: 60% 35%;\n  height: calc(100% - var(--smart-calendar-footer-height));\n  width: 100%;\n  grid-column-gap: 5%;\n  background: var(--smart-background);\n  box-sizing: border-box;\n  padding: 10px;\n  border-color: var(--smart-border);\n  border-top-left-radius: var(--smart-border-top-left-radius);\n  border-top-right-radius: var(--smart-border-top-right-radius);\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\n  border-width: var(--smart-border-width);\n  border-style: solid;\n  border-bottom: none;\n}\n.smart-date-range-input-drop-down-menu[icons] smart-calendar, .smart-date-range-input-drop-down-menu[timepicker] smart-calendar {\n  --smart-calendar-footer-height: 30px;\n}\n.smart-date-range-input-drop-down-menu[icons] .smart-timepicker-buttons, .smart-date-range-input-drop-down-menu[timepicker] .smart-timepicker-buttons {\n  display: flex;\n  justify-content: space-around;\n  width: 100%;\n  height: 100%;\n  align-items: center;\n}\n.smart-date-range-input-drop-down-menu[timepicker][icons] .smart-date-range-input-footer-controls {\n  display: grid;\n  grid-template-columns: 60% 38%;\n  grid-column-gap: 2%;\n  justify-items: center;\n}\n.smart-date-range-input-drop-down-menu.smart-input-drop-down-menu {\n  height: auto;\n  width: var(--smart-input-drop-down-menu-width);\n}\n.smart-date-range-input-drop-down-menu.smart-input-drop-down-menu.smart-date-input-drop-down-menu {\n  height: 250px;\n}\n.smart-date-range-input-drop-down-menu:not([timepicker]) .smart-timepicker-buttons {\n  display: none;\n}\n.smart-date-range-input-drop-down-menu:not([animation=none]) .smart-timepicker {\n  transition: transform 0.2s cubic-bezier(0.4, 0, 0.2, 1), visibility 0.2s cubic-bezier(0.4, 0, 0.2, 1);\n  transform: scale(1);\n}\n.smart-date-range-input-drop-down-menu:not([animation=none]) .smart-timepicker.smart-visibility-hidden {\n  transition: visibility 0.2s cubic-bezier(0.4, 0, 0.6, 1), transform 0.2s cubic-bezier(0.4, 0, 0.6, 1);\n  transform: scale(0);\n}\n.smart-date-range-input-drop-down-menu[right-to-left] .smart-timepicker {\n  direction: rtl;\n}\n\nsmart-phone-input,\nsmart-country-input {\n  --smart-outline: var(--smart-primary);\n  display: inline-block;\n  width: var(--smart-text-box-default-width);\n  height: var(--smart-text-box-default-height);\n  overflow: visible;\n  background: var(--smart-background);\n  border: 1px solid var(--smart-border);\n  border-top-left-radius: var(--smart-border-top-left-radius);\n  border-top-right-radius: var(--smart-border-top-right-radius);\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\n  border-bottom-right-radius: var(--smart-border-bottom-right-radius);\n}\nsmart-phone-input > .smart-container,\nsmart-country-input > .smart-container {\n  display: flex;\n}\nsmart-phone-input.smart-element,\nsmart-country-input.smart-element {\n  background: var(--smart-background);\n}\nsmart-phone-input input::-moz-selection, smart-country-input input::-moz-selection {\n  background: var(--smart-editor-selection);\n  color: var(--smart-editor-selection-color);\n}\nsmart-phone-input input::selection,\nsmart-country-input input::selection {\n  background: var(--smart-editor-selection);\n  color: var(--smart-editor-selection-color);\n}\nsmart-phone-input input.smart-input,\nsmart-country-input input.smart-input {\n  border: none;\n  text-overflow: ellipsis;\n}\nsmart-phone-input[focus], smart-phone-input:focus,\nsmart-country-input[focus],\nsmart-country-input:focus {\n  border-color: var(--smart-outline);\n}\nsmart-phone-input:hover,\nsmart-country-input:hover {\n  border-color: var(--smart-ui-state-border-hover);\n}\nsmart-phone-input[disabled],\nsmart-country-input[disabled] {\n  border-color: var(--smart-disabled);\n  outline: none;\n}\nsmart-phone-input[drop-down-button-position=left] .smart-input, smart-phone-input[drop-down-button-position=right] .smart-input,\nsmart-country-input[drop-down-button-position=left] .smart-input,\nsmart-country-input[drop-down-button-position=right] .smart-input {\n  width: calc(100% - var(--smart-editor-addon-width));\n}\n\n.smart-country-input .smart-container,\n.smart-phone-input .smart-container {\n  width: 100%;\n  height: 100%;\n  color: inherit;\n  font-family: inherit;\n  position: relative;\n  overflow: visible;\n  align-items: center;\n}\n\n.smart-phone-input {\n  --smart-editor-addon-width: 45px;\n}\n.smart-phone-input.invalid-number .smart-container::after {\n  color: var(--smart-error);\n}\n.smart-phone-input .smart-container::after {\n  font-family: var(--smart-font-family-icon);\n  content: var(--smart-icon-phone);\n  color: var(--smart-success);\n  padding-right: 5px;\n}\n.smart-phone-input .smart-drop-down-button {\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  flex-direction: row;\n  background: transparent;\n  border-right: none;\n  padding-left: 2px;\n}\n.smart-phone-input .smart-drop-down-button::after {\n  font-family: var(--smart-font-family-icon);\n  content: var(--smart-icon-arrow-down);\n}\n\n.smart-flag-box {\n  margin-right: 6px;\n}\n.smart-flag-box .flag {\n  width: 20px;\n}\n.smart-flag-box .flag.be {\n  width: 18px;\n}\n.smart-flag-box .flag.ch {\n  width: 15px;\n}\n.smart-flag-box .flag.mc {\n  width: 19px;\n}\n.smart-flag-box .flag.ne {\n  width: 18px;\n}\n.smart-flag-box .flag.np {\n  width: 13px;\n}\n.smart-flag-box .flag.va {\n  width: 15px;\n}\n@media (-webkit-min-device-pixel-ratio: 2), (min-resolution: 192dpi) {\n  .smart-flag-box .flag {\n    background-size: 5652px 15px;\n  }\n}\n.smart-flag-box .flag.ac {\n  height: 10px;\n  background-position: 0px 0px;\n}\n.smart-flag-box .flag.ad {\n  height: 14px;\n  background-position: -22px 0px;\n}\n.smart-flag-box .flag.ae {\n  height: 10px;\n  background-position: -44px 0px;\n}\n.smart-flag-box .flag.af {\n  height: 14px;\n  background-position: -66px 0px;\n}\n.smart-flag-box .flag.ag {\n  height: 14px;\n  background-position: -88px 0px;\n}\n.smart-flag-box .flag.ai {\n  height: 10px;\n  background-position: -110px 0px;\n}\n.smart-flag-box .flag.al {\n  height: 15px;\n  background-position: -132px 0px;\n}\n.smart-flag-box .flag.am {\n  height: 10px;\n  background-position: -154px 0px;\n}\n.smart-flag-box .flag.ao {\n  height: 14px;\n  background-position: -176px 0px;\n}\n.smart-flag-box .flag.aq {\n  height: 14px;\n  background-position: -198px 0px;\n}\n.smart-flag-box .flag.ar {\n  height: 13px;\n  background-position: -220px 0px;\n}\n.smart-flag-box .flag.as {\n  height: 10px;\n  background-position: -242px 0px;\n}\n.smart-flag-box .flag.at {\n  height: 14px;\n  background-position: -264px 0px;\n}\n.smart-flag-box .flag.au {\n  height: 10px;\n  background-position: -286px 0px;\n}\n.smart-flag-box .flag.aw {\n  height: 14px;\n  background-position: -308px 0px;\n}\n.smart-flag-box .flag.ax {\n  height: 13px;\n  background-position: -330px 0px;\n}\n.smart-flag-box .flag.az {\n  height: 10px;\n  background-position: -352px 0px;\n}\n.smart-flag-box .flag.ba {\n  height: 10px;\n  background-position: -374px 0px;\n}\n.smart-flag-box .flag.bb {\n  height: 14px;\n  background-position: -396px 0px;\n}\n.smart-flag-box .flag.bd {\n  height: 12px;\n  background-position: -418px 0px;\n}\n.smart-flag-box .flag.be {\n  height: 15px;\n  background-position: -440px 0px;\n}\n.smart-flag-box .flag.bf {\n  height: 14px;\n  background-position: -460px 0px;\n}\n.smart-flag-box .flag.bg {\n  height: 12px;\n  background-position: -482px 0px;\n}\n.smart-flag-box .flag.bh {\n  height: 12px;\n  background-position: -504px 0px;\n}\n.smart-flag-box .flag.bi {\n  height: 12px;\n  background-position: -526px 0px;\n}\n.smart-flag-box .flag.bj {\n  height: 14px;\n  background-position: -548px 0px;\n}\n.smart-flag-box .flag.bl {\n  height: 14px;\n  background-position: -570px 0px;\n}\n.smart-flag-box .flag.bm {\n  height: 10px;\n  background-position: -592px 0px;\n}\n.smart-flag-box .flag.bn {\n  height: 10px;\n  background-position: -614px 0px;\n}\n.smart-flag-box .flag.bo {\n  height: 14px;\n  background-position: -636px 0px;\n}\n.smart-flag-box .flag.bq {\n  height: 14px;\n  background-position: -658px 0px;\n}\n.smart-flag-box .flag.br {\n  height: 14px;\n  background-position: -680px 0px;\n}\n.smart-flag-box .flag.bs {\n  height: 10px;\n  background-position: -702px 0px;\n}\n.smart-flag-box .flag.bt {\n  height: 14px;\n  background-position: -724px 0px;\n}\n.smart-flag-box .flag.bv {\n  height: 15px;\n  background-position: -746px 0px;\n}\n.smart-flag-box .flag.bw {\n  height: 14px;\n  background-position: -768px 0px;\n}\n.smart-flag-box .flag.by {\n  height: 10px;\n  background-position: -790px 0px;\n}\n.smart-flag-box .flag.bz {\n  height: 14px;\n  background-position: -812px 0px;\n}\n.smart-flag-box .flag.ca {\n  height: 10px;\n  background-position: -834px 0px;\n}\n.smart-flag-box .flag.cc {\n  height: 10px;\n  background-position: -856px 0px;\n}\n.smart-flag-box .flag.cd {\n  height: 15px;\n  background-position: -878px 0px;\n}\n.smart-flag-box .flag.cf {\n  height: 14px;\n  background-position: -900px 0px;\n}\n.smart-flag-box .flag.cg {\n  height: 14px;\n  background-position: -922px 0px;\n}\n.smart-flag-box .flag.ch {\n  height: 15px;\n  background-position: -944px 0px;\n}\n.smart-flag-box .flag.ci {\n  height: 14px;\n  background-position: -961px 0px;\n}\n.smart-flag-box .flag.ck {\n  height: 10px;\n  background-position: -983px 0px;\n}\n.smart-flag-box .flag.cl {\n  height: 14px;\n  background-position: -1005px 0px;\n}\n.smart-flag-box .flag.cm {\n  height: 14px;\n  background-position: -1027px 0px;\n}\n.smart-flag-box .flag.cn {\n  height: 14px;\n  background-position: -1049px 0px;\n}\n.smart-flag-box .flag.co {\n  height: 14px;\n  background-position: -1071px 0px;\n}\n.smart-flag-box .flag.cp {\n  height: 14px;\n  background-position: -1093px 0px;\n}\n.smart-flag-box .flag.cr {\n  height: 12px;\n  background-position: -1115px 0px;\n}\n.smart-flag-box .flag.cu {\n  height: 10px;\n  background-position: -1137px 0px;\n}\n.smart-flag-box .flag.cv {\n  height: 12px;\n  background-position: -1159px 0px;\n}\n.smart-flag-box .flag.cw {\n  height: 14px;\n  background-position: -1181px 0px;\n}\n.smart-flag-box .flag.cx {\n  height: 10px;\n  background-position: -1203px 0px;\n}\n.smart-flag-box .flag.cy {\n  height: 14px;\n  background-position: -1225px 0px;\n}\n.smart-flag-box .flag.cz {\n  height: 14px;\n  background-position: -1247px 0px;\n}\n.smart-flag-box .flag.de {\n  height: 12px;\n  background-position: -1269px 0px;\n}\n.smart-flag-box .flag.dg {\n  height: 10px;\n  background-position: -1291px 0px;\n}\n.smart-flag-box .flag.dj {\n  height: 14px;\n  background-position: -1313px 0px;\n}\n.smart-flag-box .flag.dk {\n  height: 15px;\n  background-position: -1335px 0px;\n}\n.smart-flag-box .flag.dm {\n  height: 10px;\n  background-position: -1357px 0px;\n}\n.smart-flag-box .flag.do {\n  height: 14px;\n  background-position: -1379px 0px;\n}\n.smart-flag-box .flag.dz {\n  height: 14px;\n  background-position: -1401px 0px;\n}\n.smart-flag-box .flag.ea {\n  height: 14px;\n  background-position: -1423px 0px;\n}\n.smart-flag-box .flag.ec {\n  height: 14px;\n  background-position: -1445px 0px;\n}\n.smart-flag-box .flag.ee {\n  height: 13px;\n  background-position: -1467px 0px;\n}\n.smart-flag-box .flag.eg {\n  height: 14px;\n  background-position: -1489px 0px;\n}\n.smart-flag-box .flag.eh {\n  height: 10px;\n  background-position: -1511px 0px;\n}\n.smart-flag-box .flag.er {\n  height: 10px;\n  background-position: -1533px 0px;\n}\n.smart-flag-box .flag.es {\n  height: 14px;\n  background-position: -1555px 0px;\n}\n.smart-flag-box .flag.et {\n  height: 10px;\n  background-position: -1577px 0px;\n}\n.smart-flag-box .flag.eu {\n  height: 14px;\n  background-position: -1599px 0px;\n}\n.smart-flag-box .flag.fi {\n  height: 12px;\n  background-position: -1621px 0px;\n}\n.smart-flag-box .flag.fj {\n  height: 10px;\n  background-position: -1643px 0px;\n}\n.smart-flag-box .flag.fk {\n  height: 10px;\n  background-position: -1665px 0px;\n}\n.smart-flag-box .flag.fm {\n  height: 11px;\n  background-position: -1687px 0px;\n}\n.smart-flag-box .flag.fo {\n  height: 15px;\n  background-position: -1709px 0px;\n}\n.smart-flag-box .flag.fr {\n  height: 14px;\n  background-position: -1731px 0px;\n}\n.smart-flag-box .flag.ga {\n  height: 15px;\n  background-position: -1753px 0px;\n}\n.smart-flag-box .flag.gb {\n  height: 10px;\n  background-position: -1775px 0px;\n}\n.smart-flag-box .flag.gd {\n  height: 12px;\n  background-position: -1797px 0px;\n}\n.smart-flag-box .flag.ge {\n  height: 14px;\n  background-position: -1819px 0px;\n}\n.smart-flag-box .flag.gf {\n  height: 14px;\n  background-position: -1841px 0px;\n}\n.smart-flag-box .flag.gg {\n  height: 14px;\n  background-position: -1863px 0px;\n}\n.smart-flag-box .flag.gh {\n  height: 14px;\n  background-position: -1885px 0px;\n}\n.smart-flag-box .flag.gi {\n  height: 10px;\n  background-position: -1907px 0px;\n}\n.smart-flag-box .flag.gl {\n  height: 14px;\n  background-position: -1929px 0px;\n}\n.smart-flag-box .flag.gm {\n  height: 14px;\n  background-position: -1951px 0px;\n}\n.smart-flag-box .flag.gn {\n  height: 14px;\n  background-position: -1973px 0px;\n}\n.smart-flag-box .flag.gp {\n  height: 14px;\n  background-position: -1995px 0px;\n}\n.smart-flag-box .flag.gq {\n  height: 14px;\n  background-position: -2017px 0px;\n}\n.smart-flag-box .flag.gr {\n  height: 14px;\n  background-position: -2039px 0px;\n}\n.smart-flag-box .flag.gs {\n  height: 10px;\n  background-position: -2061px 0px;\n}\n.smart-flag-box .flag.gt {\n  height: 13px;\n  background-position: -2083px 0px;\n}\n.smart-flag-box .flag.gu {\n  height: 11px;\n  background-position: -2105px 0px;\n}\n.smart-flag-box .flag.gw {\n  height: 10px;\n  background-position: -2127px 0px;\n}\n.smart-flag-box .flag.gy {\n  height: 12px;\n  background-position: -2149px 0px;\n}\n.smart-flag-box .flag.hk {\n  height: 14px;\n  background-position: -2171px 0px;\n}\n.smart-flag-box .flag.hm {\n  height: 10px;\n  background-position: -2193px 0px;\n}\n.smart-flag-box .flag.hn {\n  height: 10px;\n  background-position: -2215px 0px;\n}\n.smart-flag-box .flag.hr {\n  height: 10px;\n  background-position: -2237px 0px;\n}\n.smart-flag-box .flag.ht {\n  height: 12px;\n  background-position: -2259px 0px;\n}\n.smart-flag-box .flag.hu {\n  height: 10px;\n  background-position: -2281px 0px;\n}\n.smart-flag-box .flag.ic {\n  height: 14px;\n  background-position: -2303px 0px;\n}\n.smart-flag-box .flag.id {\n  height: 14px;\n  background-position: -2325px 0px;\n}\n.smart-flag-box .flag.ie {\n  height: 10px;\n  background-position: -2347px 0px;\n}\n.smart-flag-box .flag.il {\n  height: 15px;\n  background-position: -2369px 0px;\n}\n.smart-flag-box .flag.im {\n  height: 10px;\n  background-position: -2391px 0px;\n}\n.smart-flag-box .flag.in {\n  height: 14px;\n  background-position: -2413px 0px;\n}\n.smart-flag-box .flag.io {\n  height: 10px;\n  background-position: -2435px 0px;\n}\n.smart-flag-box .flag.iq {\n  height: 14px;\n  background-position: -2457px 0px;\n}\n.smart-flag-box .flag.ir {\n  height: 12px;\n  background-position: -2479px 0px;\n}\n.smart-flag-box .flag.is {\n  height: 15px;\n  background-position: -2501px 0px;\n}\n.smart-flag-box .flag.it {\n  height: 14px;\n  background-position: -2523px 0px;\n}\n.smart-flag-box .flag.je {\n  height: 12px;\n  background-position: -2545px 0px;\n}\n.smart-flag-box .flag.jm {\n  height: 10px;\n  background-position: -2567px 0px;\n}\n.smart-flag-box .flag.jo {\n  height: 10px;\n  background-position: -2589px 0px;\n}\n.smart-flag-box .flag.jp {\n  height: 14px;\n  background-position: -2611px 0px;\n}\n.smart-flag-box .flag.ke {\n  height: 14px;\n  background-position: -2633px 0px;\n}\n.smart-flag-box .flag.kg {\n  height: 12px;\n  background-position: -2655px 0px;\n}\n.smart-flag-box .flag.kh {\n  height: 13px;\n  background-position: -2677px 0px;\n}\n.smart-flag-box .flag.ki {\n  height: 10px;\n  background-position: -2699px 0px;\n}\n.smart-flag-box .flag.km {\n  height: 12px;\n  background-position: -2721px 0px;\n}\n.smart-flag-box .flag.kn {\n  height: 14px;\n  background-position: -2743px 0px;\n}\n.smart-flag-box .flag.kp {\n  height: 10px;\n  background-position: -2765px 0px;\n}\n.smart-flag-box .flag.kr {\n  height: 14px;\n  background-position: -2787px 0px;\n}\n.smart-flag-box .flag.kw {\n  height: 10px;\n  background-position: -2809px 0px;\n}\n.smart-flag-box .flag.ky {\n  height: 10px;\n  background-position: -2831px 0px;\n}\n.smart-flag-box .flag.kz {\n  height: 10px;\n  background-position: -2853px 0px;\n}\n.smart-flag-box .flag.la {\n  height: 14px;\n  background-position: -2875px 0px;\n}\n.smart-flag-box .flag.lb {\n  height: 14px;\n  background-position: -2897px 0px;\n}\n.smart-flag-box .flag.lc {\n  height: 10px;\n  background-position: -2919px 0px;\n}\n.smart-flag-box .flag.li {\n  height: 12px;\n  background-position: -2941px 0px;\n}\n.smart-flag-box .flag.lk {\n  height: 10px;\n  background-position: -2963px 0px;\n}\n.smart-flag-box .flag.lr {\n  height: 11px;\n  background-position: -2985px 0px;\n}\n.smart-flag-box .flag.ls {\n  height: 14px;\n  background-position: -3007px 0px;\n}\n.smart-flag-box .flag.lt {\n  height: 12px;\n  background-position: -3029px 0px;\n}\n.smart-flag-box .flag.lu {\n  height: 12px;\n  background-position: -3051px 0px;\n}\n.smart-flag-box .flag.lv {\n  height: 10px;\n  background-position: -3073px 0px;\n}\n.smart-flag-box .flag.ly {\n  height: 10px;\n  background-position: -3095px 0px;\n}\n.smart-flag-box .flag.ma {\n  height: 14px;\n  background-position: -3117px 0px;\n}\n.smart-flag-box .flag.mc {\n  height: 15px;\n  background-position: -3139px 0px;\n}\n.smart-flag-box .flag.md {\n  height: 10px;\n  background-position: -3160px 0px;\n}\n.smart-flag-box .flag.me {\n  height: 10px;\n  background-position: -3182px 0px;\n}\n.smart-flag-box .flag.mf {\n  height: 14px;\n  background-position: -3204px 0px;\n}\n.smart-flag-box .flag.mg {\n  height: 14px;\n  background-position: -3226px 0px;\n}\n.smart-flag-box .flag.mh {\n  height: 11px;\n  background-position: -3248px 0px;\n}\n.smart-flag-box .flag.mk {\n  height: 10px;\n  background-position: -3270px 0px;\n}\n.smart-flag-box .flag.ml {\n  height: 14px;\n  background-position: -3292px 0px;\n}\n.smart-flag-box .flag.mm {\n  height: 14px;\n  background-position: -3314px 0px;\n}\n.smart-flag-box .flag.mn {\n  height: 10px;\n  background-position: -3336px 0px;\n}\n.smart-flag-box .flag.mo {\n  height: 14px;\n  background-position: -3358px 0px;\n}\n.smart-flag-box .flag.mp {\n  height: 10px;\n  background-position: -3380px 0px;\n}\n.smart-flag-box .flag.mq {\n  height: 14px;\n  background-position: -3402px 0px;\n}\n.smart-flag-box .flag.mr {\n  height: 14px;\n  background-position: -3424px 0px;\n}\n.smart-flag-box .flag.ms {\n  height: 10px;\n  background-position: -3446px 0px;\n}\n.smart-flag-box .flag.mt {\n  height: 14px;\n  background-position: -3468px 0px;\n}\n.smart-flag-box .flag.mu {\n  height: 14px;\n  background-position: -3490px 0px;\n}\n.smart-flag-box .flag.mv {\n  height: 14px;\n  background-position: -3512px 0px;\n}\n.smart-flag-box .flag.mw {\n  height: 14px;\n  background-position: -3534px 0px;\n}\n.smart-flag-box .flag.mx {\n  height: 12px;\n  background-position: -3556px 0px;\n}\n.smart-flag-box .flag.my {\n  height: 10px;\n  background-position: -3578px 0px;\n}\n.smart-flag-box .flag.mz {\n  height: 14px;\n  background-position: -3600px 0px;\n}\n.smart-flag-box .flag.na {\n  height: 14px;\n  background-position: -3622px 0px;\n}\n.smart-flag-box .flag.nc {\n  height: 10px;\n  background-position: -3644px 0px;\n}\n.smart-flag-box .flag.ne {\n  height: 15px;\n  background-position: -3666px 0px;\n}\n.smart-flag-box .flag.nf {\n  height: 10px;\n  background-position: -3686px 0px;\n}\n.smart-flag-box .flag.ng {\n  height: 10px;\n  background-position: -3708px 0px;\n}\n.smart-flag-box .flag.ni {\n  height: 12px;\n  background-position: -3730px 0px;\n}\n.smart-flag-box .flag.nl {\n  height: 14px;\n  background-position: -3752px 0px;\n}\n.smart-flag-box .flag.no {\n  height: 15px;\n  background-position: -3774px 0px;\n}\n.smart-flag-box .flag.np {\n  height: 15px;\n  background-position: -3796px 0px;\n}\n.smart-flag-box .flag.nr {\n  height: 10px;\n  background-position: -3811px 0px;\n}\n.smart-flag-box .flag.nu {\n  height: 10px;\n  background-position: -3833px 0px;\n}\n.smart-flag-box .flag.nz {\n  height: 10px;\n  background-position: -3855px 0px;\n}\n.smart-flag-box .flag.om {\n  height: 10px;\n  background-position: -3877px 0px;\n}\n.smart-flag-box .flag.pa {\n  height: 14px;\n  background-position: -3899px 0px;\n}\n.smart-flag-box .flag.pe {\n  height: 14px;\n  background-position: -3921px 0px;\n}\n.smart-flag-box .flag.pf {\n  height: 14px;\n  background-position: -3943px 0px;\n}\n.smart-flag-box .flag.pg {\n  height: 15px;\n  background-position: -3965px 0px;\n}\n.smart-flag-box .flag.ph {\n  height: 10px;\n  background-position: -3987px 0px;\n}\n.smart-flag-box .flag.pk {\n  height: 14px;\n  background-position: -4009px 0px;\n}\n.smart-flag-box .flag.pl {\n  height: 13px;\n  background-position: -4031px 0px;\n}\n.smart-flag-box .flag.pm {\n  height: 14px;\n  background-position: -4053px 0px;\n}\n.smart-flag-box .flag.pn {\n  height: 10px;\n  background-position: -4075px 0px;\n}\n.smart-flag-box .flag.pr {\n  height: 14px;\n  background-position: -4097px 0px;\n}\n.smart-flag-box .flag.ps {\n  height: 10px;\n  background-position: -4119px 0px;\n}\n.smart-flag-box .flag.pt {\n  height: 14px;\n  background-position: -4141px 0px;\n}\n.smart-flag-box .flag.pw {\n  height: 13px;\n  background-position: -4163px 0px;\n}\n.smart-flag-box .flag.py {\n  height: 11px;\n  background-position: -4185px 0px;\n}\n.smart-flag-box .flag.qa {\n  height: 8px;\n  background-position: -4207px 0px;\n}\n.smart-flag-box .flag.re {\n  height: 14px;\n  background-position: -4229px 0px;\n}\n.smart-flag-box .flag.ro {\n  height: 14px;\n  background-position: -4251px 0px;\n}\n.smart-flag-box .flag.rs {\n  height: 14px;\n  background-position: -4273px 0px;\n}\n.smart-flag-box .flag.ru {\n  height: 14px;\n  background-position: -4295px 0px;\n}\n.smart-flag-box .flag.rw {\n  height: 14px;\n  background-position: -4317px 0px;\n}\n.smart-flag-box .flag.sa {\n  height: 14px;\n  background-position: -4339px 0px;\n}\n.smart-flag-box .flag.sb {\n  height: 10px;\n  background-position: -4361px 0px;\n}\n.smart-flag-box .flag.sc {\n  height: 10px;\n  background-position: -4383px 0px;\n}\n.smart-flag-box .flag.sd {\n  height: 10px;\n  background-position: -4405px 0px;\n}\n.smart-flag-box .flag.se {\n  height: 13px;\n  background-position: -4427px 0px;\n}\n.smart-flag-box .flag.sg {\n  height: 14px;\n  background-position: -4449px 0px;\n}\n.smart-flag-box .flag.sh {\n  height: 10px;\n  background-position: -4471px 0px;\n}\n.smart-flag-box .flag.si {\n  height: 10px;\n  background-position: -4493px 0px;\n}\n.smart-flag-box .flag.sj {\n  height: 15px;\n  background-position: -4515px 0px;\n}\n.smart-flag-box .flag.sk {\n  height: 14px;\n  background-position: -4537px 0px;\n}\n.smart-flag-box .flag.sl {\n  height: 14px;\n  background-position: -4559px 0px;\n}\n.smart-flag-box .flag.sm {\n  height: 15px;\n  background-position: -4581px 0px;\n}\n.smart-flag-box .flag.sn {\n  height: 14px;\n  background-position: -4603px 0px;\n}\n.smart-flag-box .flag.so {\n  height: 14px;\n  background-position: -4625px 0px;\n}\n.smart-flag-box .flag.sr {\n  height: 14px;\n  background-position: -4647px 0px;\n}\n.smart-flag-box .flag.ss {\n  height: 10px;\n  background-position: -4669px 0px;\n}\n.smart-flag-box .flag.st {\n  height: 10px;\n  background-position: -4691px 0px;\n}\n.smart-flag-box .flag.sv {\n  height: 12px;\n  background-position: -4713px 0px;\n}\n.smart-flag-box .flag.sx {\n  height: 14px;\n  background-position: -4735px 0px;\n}\n.smart-flag-box .flag.sy {\n  height: 14px;\n  background-position: -4757px 0px;\n}\n.smart-flag-box .flag.sz {\n  height: 14px;\n  background-position: -4779px 0px;\n}\n.smart-flag-box .flag.ta {\n  height: 10px;\n  background-position: -4801px 0px;\n}\n.smart-flag-box .flag.tc {\n  height: 10px;\n  background-position: -4823px 0px;\n}\n.smart-flag-box .flag.td {\n  height: 14px;\n  background-position: -4845px 0px;\n}\n.smart-flag-box .flag.tf {\n  height: 14px;\n  background-position: -4867px 0px;\n}\n.smart-flag-box .flag.tg {\n  height: 13px;\n  background-position: -4889px 0px;\n}\n.smart-flag-box .flag.th {\n  height: 14px;\n  background-position: -4911px 0px;\n}\n.smart-flag-box .flag.tj {\n  height: 10px;\n  background-position: -4933px 0px;\n}\n.smart-flag-box .flag.tk {\n  height: 10px;\n  background-position: -4955px 0px;\n}\n.smart-flag-box .flag.tl {\n  height: 10px;\n  background-position: -4977px 0px;\n}\n.smart-flag-box .flag.tm {\n  height: 14px;\n  background-position: -4999px 0px;\n}\n.smart-flag-box .flag.tn {\n  height: 14px;\n  background-position: -5021px 0px;\n}\n.smart-flag-box .flag.to {\n  height: 10px;\n  background-position: -5043px 0px;\n}\n.smart-flag-box .flag.tr {\n  height: 14px;\n  background-position: -5065px 0px;\n}\n.smart-flag-box .flag.tt {\n  height: 12px;\n  background-position: -5087px 0px;\n}\n.smart-flag-box .flag.tv {\n  height: 10px;\n  background-position: -5109px 0px;\n}\n.smart-flag-box .flag.tw {\n  height: 14px;\n  background-position: -5131px 0px;\n}\n.smart-flag-box .flag.tz {\n  height: 14px;\n  background-position: -5153px 0px;\n}\n.smart-flag-box .flag.ua {\n  height: 14px;\n  background-position: -5175px 0px;\n}\n.smart-flag-box .flag.ug {\n  height: 14px;\n  background-position: -5197px 0px;\n}\n.smart-flag-box .flag.um {\n  height: 11px;\n  background-position: -5219px 0px;\n}\n.smart-flag-box .flag.un {\n  height: 14px;\n  background-position: -5241px 0px;\n}\n.smart-flag-box .flag.us {\n  height: 11px;\n  background-position: -5263px 0px;\n}\n.smart-flag-box .flag.uy {\n  height: 14px;\n  background-position: -5285px 0px;\n}\n.smart-flag-box .flag.uz {\n  height: 10px;\n  background-position: -5307px 0px;\n}\n.smart-flag-box .flag.va {\n  height: 15px;\n  background-position: -5329px 0px;\n}\n.smart-flag-box .flag.vc {\n  height: 14px;\n  background-position: -5346px 0px;\n}\n.smart-flag-box .flag.ve {\n  height: 14px;\n  background-position: -5368px 0px;\n}\n.smart-flag-box .flag.vg {\n  height: 10px;\n  background-position: -5390px 0px;\n}\n.smart-flag-box .flag.vi {\n  height: 14px;\n  background-position: -5412px 0px;\n}\n.smart-flag-box .flag.vn {\n  height: 14px;\n  background-position: -5434px 0px;\n}\n.smart-flag-box .flag.vu {\n  height: 12px;\n  background-position: -5456px 0px;\n}\n.smart-flag-box .flag.wf {\n  height: 14px;\n  background-position: -5478px 0px;\n}\n.smart-flag-box .flag.ws {\n  height: 10px;\n  background-position: -5500px 0px;\n}\n.smart-flag-box .flag.xk {\n  height: 15px;\n  background-position: -5522px 0px;\n}\n.smart-flag-box .flag.ye {\n  height: 14px;\n  background-position: -5544px 0px;\n}\n.smart-flag-box .flag.yt {\n  height: 14px;\n  background-position: -5566px 0px;\n}\n.smart-flag-box .flag.za {\n  height: 14px;\n  background-position: -5588px 0px;\n}\n.smart-flag-box .flag.zm {\n  height: 14px;\n  background-position: -5610px 0px;\n}\n.smart-flag-box .flag.zw {\n  height: 10px;\n  background-position: -5632px 0px;\n}\n.smart-flag-box .flag {\n  height: 15px;\n  box-shadow: 0px 0px 1px 0px #888;\n  background-image: url("../images/flags.png");\n  background-repeat: no-repeat;\n  background-color: #DBDBDB;\n  background-position: 20px 0;\n}\n.smart-flag-box .flag.np {\n  background-color: transparent;\n}\n\n.smart-country-input-drop-down-menu ul li a,\n.smart-phone-input-drop-down-menu ul li a {\n  border-left: var(--smart-border-width) solid transparent;\n  display: flex;\n  align-items: center;\n}\n.smart-country-input-drop-down-menu ul li .dial-code,\n.smart-phone-input-drop-down-menu ul li .dial-code {\n  margin-left: 6px;\n  opacity: 0.5;\n}\n.smart-country-input-drop-down-menu:not(.smart-check-input-drop-down-menu) li.active a,\n.smart-phone-input-drop-down-menu:not(.smart-check-input-drop-down-menu) li.active a {\n  border-left: var(--smart-border-width) solid var(--smart-primary);\n  border-top-left-radius: 0;\n  border-bottom-left-radius: 0;\n  color: var(--smart-ui-state-color-selected);\n  background: var(--smart-ui-state-selected);\n}\n.smart-country-input-drop-down-menu[right-to-left] li a,\n.smart-phone-input-drop-down-menu[right-to-left] li a {\n  border-left: none;\n  border-right: var(--smart-border-width) solid transparent;\n}\n.smart-country-input-drop-down-menu[right-to-left]:not(.smart-check-input-drop-down-menu) li.active a,\n.smart-phone-input-drop-down-menu[right-to-left]:not(.smart-check-input-drop-down-menu) li.active a {\n  border-left: var(--smart-border-width) solid transparent;\n  border-right: var(--smart-border-width) solid var(--smart-primary);\n  border-top-left-radius: var(--smart-border-top-left-radius);\n  border-bottom-left-radius: var(--smart-border-bottom-left-radius);\n  border-top-right-radius: 0;\n  border-bottom-right-radius: 0;\n}\n\nsmart-date-range-input.underlined,\nsmart-date-input.underlined,\nsmart-time-input.underlined {\n  overflow: visible;\n}\n\n.underlined.smart-input {\n  transition: border-bottom 0.2s, background-color 0.2s;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 0px;\n  border-top: none;\n  border-left: none;\n  border-right: none;\n}\n.underlined.smart-input .smart-hint {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  display: block !important;\n  box-sizing: border-box;\n  padding: var(--smart-editor-label-padding);\n  color: var(--smart-background-color);\n  pointer-events: none;\n  font-size: 75%;\n  opacity: 0;\n  transition: color 0.2s, font-size 0.2s, line-height 0.2s, margin-top 0.2s, opacity 0.3s, top 0.2s;\n  margin-top: calc(0px - var(--smart-font-size));\n}\n.underlined.smart-input .smart-hint:after {\n  content: "";\n  position: absolute;\n  left: 0;\n  bottom: -2px;\n  display: block;\n  width: 100%;\n  height: 2px;\n  background-color: var(--smart-primary);\n  transform-origin: bottom center;\n  transform: scaleX(0);\n  transition: transform 0.2s;\n}\n.underlined.smart-input[drop-down-button-position=left] .smart-drop-down-button {\n  border-bottom-left-radius: initial;\n}\n.underlined.smart-input[drop-down-button-position=right] .smart-drop-down-button {\n  border-bottom-right-radius: initial;\n}\n.underlined.smart-input .smart-drop-down-button {\n  border-top: none;\n  border-left: none;\n  border-right: none;\n}\n.underlined.smart-input[hover] {\n  border-bottom-color: var(--smart-background-color);\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 0px;\n}\n.underlined.smart-input[focus] .smart-hint {\n  color: var(--smart-primary);\n  opacity: 1;\n}\n.underlined.smart-input[focus] .smart-hint:before {\n  opacity: 0.12;\n}\n.underlined.smart-input[focus] .smart-hint:after {\n  transform: scale(1);\n}\n.underlined.smart-input .smart-input:not(:focus):-moz-placeholder-shown + .smart-hint {\n  font-size: inherit;\n  margin-top: 0px;\n}\n.underlined.smart-input .smart-input:not(:focus):-ms-input-placeholder + .smart-hint {\n  font-size: inherit;\n  margin-top: 0px;\n}\n.underlined.smart-input .smart-input:not(:focus):placeholder-shown + .smart-hint {\n  font-size: inherit;\n  margin-top: 0px;\n}\n.underlined.smart-input:not([readonly]) .smart-drop-down-button {\n  border-bottom-left-radius: initial;\n  border-bottom-right-radius: initial;\n}\n.underlined.smart-input:not([opened]) .smart-drop-down-button {\n  background-color: transparent;\n}\n.underlined.smart-input.smart-multi-combo-input:not([focus]) .smart-hint {\n  margin-top: 0px;\n}\n.underlined.smart-input.smart-date-range-input[opened][drop-down-button-position=right]:not([readonly]) {\n  border-bottom-left-radius: 0;\n  border-bottom-right-radius: 0;\n}\n.underlined.smart-input[readonly] .smart-input {\n  cursor: pointer;\n  background: var(--smart-background) !important;\n  color: var(--smart-background-color) !important;\n  opacity: 0.75;\n}\n.underlined.smart-input[drop-down-button-position=left] .smart-drop-down-button {\n  background: inherit;\n  color: inherit;\n  border-bottom-left-radius: initial;\n}\n.underlined.smart-input[drop-down-button-position=left] .smart-hint {\n  margin-left: var(--smart-editor-addon-width);\n}\n.underlined.smart-input[drop-down-button-position=left][focus] .smart-hint:after {\n  margin-left: calc(0px - var(--smart-editor-addon-width));\n  width: calc(100% + var(--smart-editor-addon-width));\n}\n.underlined.smart-input[drop-down-button-position=left][opened]:not([readonly]), .underlined.smart-input[drop-down-button-position=left][opened]:not([readonly]) input {\n  border-bottom-right-radius: 0;\n}\n.underlined.smart-input[drop-down-button-position=right] .smart-drop-down-button {\n  background: var(--smart-background);\n  color: var(--smart-background-color);\n  border-bottom-right-radius: initial;\n}\n.underlined.smart-input[drop-down-button-position=right][opened]:not([readonly]), .underlined.smart-input[drop-down-button-position=right][opened]:not([readonly]) input {\n  border-bottom-left-radius: 0;\n}\n.underlined.smart-input.smart-invalid {\n  border-bottom-color: rgba(var(--smart-error-rgb), 0.5);\n}\n.underlined.smart-input.smart-invalid .smart-hint:after {\n  background-color: var(--smart-error);\n}\n.underlined.smart-text-box input.smart-input {\n  border-top: none;\n  border-left: none;\n  border-right: none;\n  border-bottom-left-radius: initial;\n  border-bottom-right-radius: initial;\n}\n.underlined.smart-number-input .nav {\n  background: var(--smart-background);\n  color: var(--smart-background-color);\n}\n.underlined.smart-number-input .nav .up {\n  border-bottom: none;\n}\n.underlined.smart-element.smart-material {\n  --smart-border-top-left-radius: 0;\n  --smart-border-top-right-radius: 0;\n  --smart-border-bottom-left-radius: 0;\n  --smart-border-bottom-right-radius: 0;\n}\n.underlined.smart-element.smart-material.smart-valid {\n  --smart-border: #28a745;\n}\n.underlined.smart-element.smart-material.smart-invalid {\n  --smart-border: #dc3545;\n}\n.underlined.smart-element.smart-material .smart-hint {\n  opacity: 1;\n  transition: color 0.2s, opacity 0.1s, font-size 0.2s, line-height 0.2s, margin-top 0.2s, top 0.2s !important;\n  margin-top: 0;\n  font-size: 100%;\n}\n.underlined.smart-element.smart-material[focus][hover] .smart-hint, .underlined.smart-element.smart-material[focus] .smart-hint, .underlined.smart-element.smart-material[value]:not([value=""]) .smart-hint, .underlined.smart-element.smart-material.has-value .smart-hint {\n  margin-top: -20px;\n  font-size: 80% !important;\n}\n\nsmart-text-box.outlined,\nsmart-input.outlined,\nsmart-password-input.outlined,\nsmart-date-range-input.outlined,\nsmart-multi-input.outlined,\nsmart-multi-combo-input.outlined,\nsmart-check-input.outlined,\nsmart-masked-text-box.outlined,\nsmart-phone-input.outlined,\nsmart-password-text-box.outlined {\n  background-color: transparent;\n}\n\nsmart-date-range-input.outlined,\nsmart-date-input.outlined,\nsmart-phone-input.outlined,\nsmart-time-input.outlined {\n  overflow: visible;\n}\n\nsmart-phone-input.outlined .smart-drop-down-button {\n  margin-right: 0px;\n}\nsmart-phone-input.outlined .smart-container::after {\n  margin-left: -18px;\n  z-index: 9;\n}\n\n.outlined.smart-input {\n  position: relative;\n  display: inline-block;\n  font-family: var(--smart-font-family);\n  font-size: var(--smart-font-size);\n  line-height: 1.5;\n  height: 50px;\n  margin: 0px;\n  border: none;\n  border-radius: 0px;\n  padding-top: 6px;\n  overflow: hidden;\n}\n.outlined.smart-input .smart-input {\n  padding: 12px 13px 12px;\n  z-index: 5;\n  background: var(--smart-background);\n  border: 1px solid var(--smart-border);\n  transition: border-color 0.2s;\n}\n.outlined.smart-input.smart-valid[focus] .smart-input,\n.outlined.smart-input.smart-valid[focus] .smart-drop-down-button {\n  border-color: var(--smart-primary);\n}\n.outlined.smart-input.smart-valid[focus] .smart-drop-down-button {\n  color: var(--smart-primary);\n}\n.outlined.smart-input.smart-invalid .smart-input,\n.outlined.smart-input.smart-invalid .smart-drop-down-button {\n  border-color: rgba(var(--smart-error-rgb), 0.5);\n}\n.outlined.smart-input.smart-invalid[focus] .smart-input,\n.outlined.smart-input.smart-invalid[focus] .smart-drop-down-button {\n  border-color: var(--smart-error);\n}\n.outlined.smart-input.smart-invalid[focus] .smart-drop-down-button {\n  color: var(--smart-error);\n}\n.outlined.smart-input.smart-multi-combo-input .smart-input {\n  padding: 0;\n  border: none !important;\n  z-index: initial;\n}\n.outlined.smart-input.smart-multi-combo-input .smart-drop-down-button {\n  padding: 0 !important;\n}\n.outlined.smart-input.smart-multi-combo-input .smart-action-button {\n  border-right: none;\n  border-top: 1px solid var(--smart-border);\n  padding: 12px 13px 12px;\n  z-index: 5;\n  background: var(--smart-background);\n  border: 1px solid var(--smart-border);\n  transition: border-color 0.2s;\n}\n.outlined.smart-input.smart-multi-combo-input[hint] .smart-action-button {\n  border-top: 1px solid var(--smart-background);\n}\n.outlined.smart-input.smart-multi-combo-input[focus] .smart-action-button {\n  border-color: var(--smart-primary);\n  color: var(--smart-primary);\n}\n.outlined.smart-input.smart-multi-combo-input[focus][hint] .smart-action-button {\n  border-top-color: var(--smart-background);\n}\n.outlined.smart-input.smart-multi-combo-input.smart-valid[focus] .smart-action-button {\n  border-color: var(--smart-primary);\n}\n.outlined.smart-input.smart-multi-combo-input.smart-valid[focus] .smart-action-button.smart-valid {\n  color: var(--smart-primary);\n}\n.outlined.smart-input.smart-multi-combo-input.smart-invalid[focus] .smart-action-button.smart-invalid {\n  color: var(--smart-error);\n}\n.outlined.smart-input[drop-down-button-position=right] input {\n  border-right: none;\n}\n.outlined.smart-input[drop-down-button-position=right] .smart-drop-down-button {\n  padding: 10px 0px 9px 0px;\n  border-left: none;\n  border-bottom: 1px solid var(--smart-border);\n  border-right: 1px solid var(--smart-border);\n  border-top: 1px solid var(--smart-border);\n  background: inherit;\n  color: inherit;\n  z-index: 6;\n  cursor: pointer;\n}\n.outlined.smart-input[drop-down-button-position=left] input {\n  border-left: none;\n}\n.outlined.smart-input[drop-down-button-position=left] .smart-drop-down-button {\n  padding: 10px 0px;\n  border-right: none;\n  border-bottom: 1px solid var(--smart-border);\n  border-left: 1px solid var(--smart-border);\n  background: inherit;\n  color: inherit;\n  z-index: 6;\n  cursor: pointer;\n}\n.outlined.smart-input[hint] .smart-hint {\n  position: absolute;\n  top: 0;\n  left: 0;\n  display: flex !important;\n  border-color: var(--smart-border) !important;\n  width: 100%;\n  max-height: 100%;\n  color: var(--smart-background-color);\n  font-size: 75%;\n  line-height: 15px;\n  cursor: text;\n  margin-top: -6px;\n  z-index: 7;\n  white-space: nowrap;\n  transition: color 0.2s, z-index 0.2s, font-size 0.2s, opacity 0.3s, font-size 0.2s, line-height 0.2s;\n}\n.outlined.smart-input[hint] .smart-hint:before, .outlined.smart-input[hint] .smart-hint:after {\n  content: "";\n  display: block;\n  box-sizing: border-box;\n  margin-top: 6px;\n  border-top: solid 1px;\n  border-top-color: var(--smart-border) !important;\n  min-width: 10px;\n  height: 8px;\n  pointer-events: none;\n  box-shadow: inset 0 1px transparent;\n  transition: border-color 0.2s, box-shadow 0.2s;\n  z-index: 7;\n}\n.outlined.smart-input[hint] .smart-hint:before {\n  margin-right: 4px;\n  border-left: solid 1px transparent;\n  border-radius: 4px 0;\n}\n.outlined.smart-input[hint] .smart-hint:after {\n  flex-grow: 1;\n  margin-left: 4px;\n  border-right: solid 1px transparent;\n  border-radius: 0 4px;\n}\n.outlined.smart-input[hint][drop-down-button-position=left] .smart-hint:before {\n  width: var(--smart-editor-addon-width);\n  margin-right: 13px;\n}\n.outlined.smart-input[focus] {\n  border-color: var(--smart-primary);\n  border-top-color: transparent !important;\n  box-shadow: inset 1px 0 var(--smart-material-safari-helper1), inset -1px 0 var(--smart-material-safari-helper1), inset 0 -1px var(--smart-material-safari-helper1);\n  outline: none;\n}\n.outlined.smart-input[focus] .smart-input {\n  border-color: var(--smart-primary);\n}\n.outlined.smart-input[focus] .smart-drop-down-button {\n  color: var(--smart-primary);\n  border-color: var(--smart-primary);\n}\n.outlined.smart-input[focus][hint] .smart-input {\n  border-top-color: var(--smart-background);\n}\n.outlined.smart-input[focus][hint] .smart-hint {\n  color: var(--smart-primary);\n  opacity: 1;\n}\n.outlined.smart-input[focus][hint] .smart-hint:before, .outlined.smart-input[focus][hint] .smart-hint:after {\n  border-top-color: var(--smart-primary) !important;\n  box-shadow: none !important;\n}\n.outlined.smart-input[hover] {\n  border-color: var(--smart-border);\n  border-top-color: transparent;\n}\n.outlined.smart-input[hover][hint] .smart-hint:before {\n  border-top-color: var(--smart-border);\n}\n.outlined.smart-input[hover][hint] > input:not(:focus):-moz-placeholder-shown, .outlined.smart-input[hover][hint] > textarea:not(:focus):-moz-placeholder-shown {\n  border-color: var(--smart-border);\n}\n.outlined.smart-input[hover][hint] > input:not(:focus):-ms-input-placeholder, .outlined.smart-input[hover][hint] > textarea:not(:focus):-ms-input-placeholder {\n  border-color: var(--smart-border);\n}\n.outlined.smart-input[hover][hint] > input:not(:focus):placeholder-shown,\n.outlined.smart-input[hover][hint] > textarea:not(:focus):placeholder-shown {\n  border-color: var(--smart-border);\n}\n.outlined.smart-input[readonly] .smart-input {\n  background: var(--smart-background) !important;\n  color: var(--smart-background-color) !important;\n  opacity: 0.75;\n}\n.outlined.smart-input:not([focus]) .smart-input:not(:focus):-moz-placeholder-shown {\n  border-top: 1px solid var(--smart-border);\n  z-index: 5;\n}\n.outlined.smart-input:not([focus]) .smart-input:not(:focus):-ms-input-placeholder {\n  border-top: 1px solid var(--smart-border);\n  z-index: 5;\n}\n.outlined.smart-input:not([focus]) .smart-input:not(:focus):placeholder-shown,\n.outlined.smart-input:not([focus]) .smart-input {\n  border-top: 1px solid var(--smart-border);\n  z-index: 5;\n}\n.outlined.smart-input:not([focus]).smart-invalid .smart-input:not(:focus):-moz-placeholder-shown {\n  border-top: 1px solid rgba(var(--smart-error-rgb), 0.5);\n  z-index: 5;\n}\n.outlined.smart-input:not([focus]).smart-invalid .smart-input:not(:focus):-ms-input-placeholder {\n  border-top: 1px solid rgba(var(--smart-error-rgb), 0.5);\n  z-index: 5;\n}\n.outlined.smart-input:not([focus]).smart-invalid .smart-input:not(:focus):placeholder-shown,\n.outlined.smart-input:not([focus]).smart-invalid .smart-input {\n  border-top: 1px solid rgba(var(--smart-error-rgb), 0.5);\n  z-index: 5;\n}\n.outlined.smart-input[hint] .smart-input:not(:focus):-moz-placeholder-shown + .smart-hint {\n  font-size: var(--smart-font-size);\n  line-height: 60px;\n  z-index: 2;\n  -moz-user-select: none;\n       user-select: none;\n  pointer-events: none;\n}\n.outlined.smart-input[hint] .smart-input:not(:focus):-ms-input-placeholder + .smart-hint {\n  font-size: var(--smart-font-size);\n  line-height: 60px;\n  z-index: 2;\n  -ms-user-select: none;\n      user-select: none;\n  pointer-events: none;\n}\n.outlined.smart-input:not([focus]):not([value]).smart-multi-combo-input[hint] .smart-hint, .outlined.smart-input[hint] .smart-input:not(:focus):placeholder-shown + .smart-hint, .outlined.smart-input[hint]:not([focus]) .smart-hint {\n  font-size: var(--smart-font-size);\n  line-height: 60px;\n  z-index: 2;\n  -webkit-user-select: none;\n     -moz-user-select: none;\n      -ms-user-select: none;\n          user-select: none;\n  pointer-events: none;\n}\n.outlined.smart-input.smart-invalid[focus] {\n  border-color: var(--smart-error);\n}\n.outlined.smart-input.smart-invalid[focus][hint] .smart-hint {\n  color: var(--smart-error);\n}\n.outlined.smart-input.smart-invalid[focus][hint] .smart-hint:before, .outlined.smart-input.smart-invalid[focus][hint] .smart-hint:after {\n  border-top-color: var(--smart-error) !important;\n}\n.outlined.smart-input.smart-valid[focus] {\n  border-color: var(--smart-primary);\n}\n.outlined.smart-input.smart-valid[focus][hint] .smart-hint {\n  color: var(--smart-primary);\n}\n.outlined.smart-input.smart-valid[focus][hint] .smart-hint:before, .outlined.smart-input.smart-valid[focus][hint] .smart-hint:after {\n  border-top-color: var(--smart-primary) !important;\n}\n.outlined.smart-text-area[hint] .smart-input:not(:focus):-moz-placeholder-shown + .smart-hint {\n  font-size: var(--smart-font-size);\n  line-height: var(--smart-editor-height);\n  opacity: 0;\n  z-index: 2;\n}\n.outlined.smart-text-area[hint] .smart-input:not(:focus):-ms-input-placeholder + .smart-hint {\n  font-size: var(--smart-font-size);\n  line-height: var(--smart-editor-height);\n  opacity: 0;\n  z-index: 2;\n}\n.outlined.smart-text-area[hint] .smart-input:not(:focus):placeholder-shown + .smart-hint, .outlined.smart-text-area[hint]:not([focus]) .smart-hint {\n  font-size: var(--smart-font-size);\n  line-height: var(--smart-editor-height);\n  opacity: 0;\n  z-index: 2;\n}\n.outlined.smart-text-box input {\n  border: none;\n  padding: 7px;\n}\n.outlined.smart-number-input .nav {\n  background: var(--smart-background);\n  color: var(--smart-background-color);\n}\n.outlined.smart-number-input .nav .up {\n  border-bottom: none;\n}\n.outlined.smart-number-input[drop-down-button-position=right] .smart-drop-down-button, .outlined.smart-number-input[drop-down-button-position=left] .smart-drop-down-button {\n  padding: 0;\n}\n.outlined.smart-element.smart-material.smart-valid {\n  --smart-border: #28a745;\n}\n.outlined.smart-element.smart-material.smart-invalid {\n  --smart-border: #dc3545;\n}\n.outlined.smart-element.smart-material .smart-hint {\n  opacity: 1 !important;\n  transition: color 0.2s, opacity 0.1s, font-size 0.2s, line-height 0.2s, margin-top 0.2s, top 0.2s !important;\n  z-index: 7 !important;\n}\n.outlined.smart-element.smart-material[focus][hover], .outlined.smart-element.smart-material[focus], .outlined.smart-element.smart-material[value]:not([value=""]), .outlined.smart-element.smart-material.has-value {\n  border-color: var(--smart-primary);\n  border-top-color: transparent !important;\n  outline: none;\n}\n.outlined.smart-element.smart-material[focus][hover] .smart-input, .outlined.smart-element.smart-material[focus] .smart-input, .outlined.smart-element.smart-material[value]:not([value=""]) .smart-input, .outlined.smart-element.smart-material.has-value .smart-input {\n  border-top-color: var(--smart-background) !important;\n}\n.outlined.smart-element.smart-material[focus][hover] .smart-hint, .outlined.smart-element.smart-material[focus] .smart-hint, .outlined.smart-element.smart-material[value]:not([value=""]) .smart-hint, .outlined.smart-element.smart-material.has-value .smart-hint {\n  color: var(--smart-primary) !important;\n  opacity: 1 !important;\n  font-size: 75% !important;\n  line-height: 15px;\n  z-index: 7;\n  transition: color 0.2s, z-index 0.2s, font-size 0.2s, opacity 0.3s, font-size 0.2s, line-height 0.2s;\n}\n.outlined.smart-element.smart-material[focus][hover] .smart-container .smart-content, .outlined.smart-element.smart-material[focus] .smart-container .smart-content, .outlined.smart-element.smart-material[value]:not([value=""]) .smart-container .smart-content, .outlined.smart-element.smart-material.has-value .smart-container .smart-content {\n  border-top-color: transparent !important;\n}\n.outlined.smart-drop-down-box > .smart-container > .smart-content {\n  z-index: 7 !important;\n}\n\n.smart-invalid .outlined.smart-input.smart-multi-combo-input .smart-action-button {\n  border-color: rgba(var(--smart-error-rgb), 0.5);\n}\n.smart-invalid .outlined.smart-input.smart-multi-combo-input[focus] .smart-action-button {\n  border-color: var(--smart-error);\n}\n\n/* Faster transition in Safari for less noticable fractional font-size issue */\n@media not all and (-webkit-min-device-pixel-ratio: 0), not all and (min-resolution: 0.001dpcm) {\n  @supports (-webkit-appearance: none) {\n    .smart-input .smart-input,\n.smart-input .smart-hint,\n.smart-input .smart-hint::after {\n      transition-duration: 0.1s;\n    }\n  }\n}',""]);const s=i},8866:(e,t,r)=>{"use strict";r.d(t,{Z:()=>s});var n=r(8081),o=r.n(n),a=r(3645),i=r.n(a)()(o());i.push([e.id,'/* smart-check-box and smart-radio-button*/\r\n.smart-toggle-box {\r\n  display: inline-block;\r\n  outline: none;\r\n  height: var(--smart-editor-height);\r\n  cursor: pointer; }\r\n  .smart-toggle-box.smart-element {\r\n    border: none;\r\n    background: transparent; }\r\n  .smart-toggle-box .smart-container, .smart-toggle-box.smart-container {\r\n    position: relative;\r\n    display: flex;\r\n    align-items: center; }\r\n  .smart-toggle-box .smart-ripple {\r\n    background: var(--smart-primary); }\r\n  .smart-toggle-box .smart-overlay {\r\n    top: 0;\r\n    height: 100%;\r\n    background: var(--smart-primary);\r\n    width: var(--smart-editor-height);\r\n    position: absolute;\r\n    left: 2px;\r\n    border-radius: 100%;\r\n    padding: 0px;\r\n    opacity: 0;\r\n    box-sizing: content-box;\r\n    transition: opacity 280ms ease-in-out;\r\n    margin: 0px; }\r\n  .smart-toggle-box .smart-label {\r\n    color: var(--smart-background-color);\r\n    background: inherit;\r\n    font-size: inherit;\r\n    font-family: inherit;\r\n    margin: 0 8px 0 8px;\r\n    white-space: nowrap;\r\n    overflow: hidden;\r\n    text-overflow: ellipsis;\r\n    width: auto; }\r\n  .smart-toggle-box.smart-check-box .smart-input {\r\n    width: var(--smart-check-box-default-size);\r\n    min-width: var(--smart-check-box-default-size);\r\n    height: var(--smart-check-box-default-size);\r\n    min-height: var(--smart-check-box-default-size);\r\n    background-color: var(--smart-background);\r\n    box-sizing: initial;\r\n    border: var(--smart-border-width) solid var(--smart-border);\r\n    display: inline-block;\r\n    color: var(--smart-background-color);\r\n    border-top-left-radius: var(--smart-border-top-left-radius);\r\n    border-top-right-radius: var(--smart-border-top-right-radius);\r\n    border-bottom-left-radius: var(--smart-border-bottom-left-radius);\r\n    border-bottom-right-radius: var(--smart-border-bottom-right-radius);\r\n    margin: 0 0 0 8px;\r\n    transition: background linear 0.2s;\r\n    position: relative; }\r\n    .smart-toggle-box.smart-check-box .smart-input:after {\r\n      font-family: var(--smart-font-family-icon);\r\n      display: flex;\r\n      justify-content: center;\r\n      align-content: center;\r\n      height: 100%;\r\n      align-items: center; }\r\n  .smart-toggle-box.smart-check-box[checked] .smart-input:after {\r\n    font-weight: 100;\r\n    content: var(--smart-icon-check);\r\n    pointer-events: none; }\r\n  .smart-toggle-box.smart-check-box[checked="null"] .smart-input:after {\r\n    content: \'-\';\r\n    margin-top: -1px; }\r\n  .smart-toggle-box.smart-radio-button .smart-input {\r\n    width: var(--smart-radio-button-default-size);\r\n    min-width: var(--smart-radio-button-default-size);\r\n    height: var(--smart-radio-button-default-size);\r\n    min-height: var(--smart-radio-button-default-size);\r\n    background-color: var(--smart-background);\r\n    box-sizing: initial;\r\n    border-style: solid;\r\n    border-width: var(--smart-border-width);\r\n    border-color: var(--smart-border);\r\n    display: inline-block;\r\n    border-radius: 100%;\r\n    color: var(--smart-background-color);\r\n    margin: 0 0 0 8px;\r\n    position: relative; }\r\n    .smart-toggle-box.smart-radio-button .smart-input:after {\r\n      content: \'\';\r\n      position: absolute;\r\n      top: 50%;\r\n      left: 50%;\r\n      transform: translate(-50%, -50%);\r\n      width: 50%;\r\n      height: 50%;\r\n      font-style: normal;\r\n      text-decoration: inherit;\r\n      font-variant: normal;\r\n      text-transform: none;\r\n      color: inherit;\r\n      border-radius: 50%;\r\n      line-height: 100%; }\r\n  .smart-toggle-box.smart-radio-button[checked] .smart-input:after {\r\n    font-size: 15px;\r\n    font-weight: 100;\r\n    background: var(--smart-primary-color); }\r\n  .smart-toggle-box.smart-radio-button[checked][hover]:not([focus]) .smart-input::after {\r\n    background: var(--smart-ui-state-color-hover); }\r\n  .smart-toggle-box[active] .smart-input {\r\n    border-color: var(--smart-ui-state-border-active);\r\n    background-color: var(--smart-ui-state-active);\r\n    color: var(--smart-ui-state-color-active); }\r\n  .smart-toggle-box[active]:focus .smart-overlay, .smart-toggle-box[active][focus] .smart-overlay {\r\n    opacity: 0.4; }\r\n  .smart-toggle-box[checked] .smart-input {\r\n    border-color: var(--smart-ui-state-border-active);\r\n    background-color: var(--smart-ui-state-active);\r\n    color: var(--smart-ui-state-color-active); }\r\n  .smart-toggle-box[hover] .smart-input {\r\n    border-color: var(--smart-ui-state-border-hover);\r\n    background-color: var(--smart-ui-state-hover);\r\n    color: var(--smart-ui-state-color-hover); }\r\n  .smart-toggle-box:focus .smart-input, .smart-toggle-box[focus] .smart-input {\r\n    outline: none;\r\n    overflow: visible;\r\n    border-color: var(--smart-primary);\r\n    background-color: var(--smart-primary);\r\n    color: var(--smart-primary-color); }\r\n  .smart-toggle-box:focus .smart-overlay, .smart-toggle-box[focus] .smart-overlay {\r\n    opacity: 0.3; }\r\n  .smart-toggle-box[readonly] {\r\n    cursor: initial; }\r\n    .smart-toggle-box[readonly] .smart-input,\r\n    .smart-toggle-box[readonly] .smart-label {\r\n      cursor: initial; }\r\n  .smart-toggle-box[check-mode="input"] {\r\n    cursor: default; }\r\n    .smart-toggle-box[check-mode="input"] .smart-input {\r\n      cursor: pointer; }\r\n  .smart-toggle-box[check-mode="label"] .smart-label {\r\n    cursor: pointer; }\r\n\r\n/* smart-check-box and smart-radio-button*/\r\n.smart-toggle-box[right-to-left] .smart-container,\r\n.smart-toggle-box[right-to-left] .smart-hidden-input {\r\n  direction: rtl; }\r\n.smart-toggle-box[right-to-left] .smart-overlay {\r\n  left: initial;\r\n  right: 2px; }\r\n.smart-toggle-box[right-to-left] .smart-input {\r\n  margin: 0 8px 0 0; }\r\n',""]);const s=i},4612:(e,t,r)=>{"use strict";r.d(t,{Z:()=>s});var n=r(8081),o=r.n(n),a=r(3645),i=r.n(a)()(o());i.push([e.id,'/* .smart-tooltip */\r\nsmart-tooltip {\r\n  position: absolute;\r\n  text-align: center;\r\n  z-index: var(--smart-editor-drop-down-z-index);\r\n  font-family: var(--smart-font-family);\r\n  font-size: var(--smart-font-size);\r\n  visibility: hidden;\r\n  pointer-events: none; }\r\n  smart-tooltip.smart-element {\r\n    background: transparent;\r\n    overflow: visible; }\r\n  smart-tooltip .smart-tooltip-content {\r\n    overflow: hidden;\r\n    text-overflow: ellipsis;\r\n    padding: var(--smart-tooltip-padding);\r\n    background-color: var(--smart-secondary);\r\n    color: var(--smart-secondary-color);\r\n    border: var(--smart-border-width) solid var(--smart-secondary);\r\n    width: 100%;\r\n    height: 100%;\r\n    opacity: 0.9;\r\n    box-shadow: var(--smart-elevation-6);\r\n    font-family: var(--smart-font-family);\r\n    border-top-left-radius: var(--smart-border-top-left-radius);\r\n    border-bottom-left-radius: var(--smart-border-bottom-left-radius);\r\n    border-top-right-radius: var(--smart-border-top-right-radius);\r\n    border-bottom-right-radius: var(--smart-border-bottom-right-radius); }\r\n  smart-tooltip.auto {\r\n    height: auto; }\r\n    smart-tooltip.auto .smart-container {\r\n      height: auto; }\r\n    smart-tooltip.auto .smart-tooltip-content {\r\n      height: auto; }\r\n  smart-tooltip[visible] {\r\n    visibility: visible;\r\n    pointer-events: auto; }\r\n  smart-tooltip[arrow] {\r\n    padding-bottom: var(--smart-tooltip-arrow-width); }\r\n    smart-tooltip[arrow] .smart-tooltip-content:after {\r\n      content: "";\r\n      width: 0;\r\n      height: 0;\r\n      border-left: var(--smart-tooltip-arrow-width) solid transparent;\r\n      border-right: var(--smart-tooltip-arrow-width) solid transparent;\r\n      border-top: var(--smart-tooltip-arrow-width) solid var(--smart-tooltip-arrow-color);\r\n      position: absolute;\r\n      bottom: 0;\r\n      left: calc(100% / 2 - var(--smart-tooltip-arrow-width));\r\n      transform: translateX(var(--smart-tooltip-arrow-translate)); }\r\n    smart-tooltip[arrow][arrow-direction="bottom"] {\r\n      padding-bottom: var(--smart-tooltip-arrow-width); }\r\n      smart-tooltip[arrow][arrow-direction="bottom"] .smart-tooltip-content:after {\r\n        content: "";\r\n        width: 0;\r\n        height: 0;\r\n        border-left: var(--smart-tooltip-arrow-width) solid transparent;\r\n        border-right: var(--smart-tooltip-arrow-width) solid transparent;\r\n        border-top: var(--smart-tooltip-arrow-width) solid var(--smart-tooltip-arrow-color);\r\n        position: absolute;\r\n        bottom: 0;\r\n        left: calc(100% / 2 - var(--smart-tooltip-arrow-width));\r\n        transform: translateX(var(--smart-tooltip-arrow-translate)); }\r\n    smart-tooltip[arrow][arrow-direction="top"] {\r\n      padding-bottom: initial;\r\n      padding-top: var(--smart-tooltip-arrow-width); }\r\n      smart-tooltip[arrow][arrow-direction="top"] .smart-tooltip-content:after {\r\n        border-left: var(--smart-tooltip-arrow-width) solid transparent;\r\n        border-right: var(--smart-tooltip-arrow-width) solid transparent;\r\n        border-bottom: var(--smart-tooltip-arrow-width) solid var(--smart-tooltip-arrow-color);\r\n        border-top: initial;\r\n        top: 0;\r\n        bottom: calc(100% + var(--smart-tooltip-arrow-width));\r\n        transform: translateX(var(--smart-tooltip-arrow-translate)); }\r\n    smart-tooltip[arrow][arrow-direction="left"] {\r\n      padding-bottom: initial;\r\n      padding-left: var(--smart-tooltip-arrow-width); }\r\n      smart-tooltip[arrow][arrow-direction="left"] .smart-tooltip-content:after {\r\n        border-bottom: var(--smart-tooltip-arrow-width) solid transparent;\r\n        border-top: var(--smart-tooltip-arrow-width) solid transparent;\r\n        border-right: var(--smart-tooltip-arrow-width) solid var(--smart-tooltip-arrow-color);\r\n        border-left: initial;\r\n        left: 0;\r\n        top: calc(50% - var(--smart-tooltip-arrow-width));\r\n        transform: translateY(var(--smart-tooltip-arrow-translate)); }\r\n    smart-tooltip[arrow][arrow-direction="right"] {\r\n      padding-bottom: initial;\r\n      padding-right: var(--smart-tooltip-arrow-width); }\r\n      smart-tooltip[arrow][arrow-direction="right"] .smart-tooltip-content:after {\r\n        border-bottom: var(--smart-tooltip-arrow-width) solid transparent;\r\n        border-top: var(--smart-tooltip-arrow-width) solid transparent;\r\n        border-left: var(--smart-tooltip-arrow-width) solid var(--smart-tooltip-arrow-color);\r\n        border-right: initial;\r\n        left: calc(100% - var(--smart-tooltip-arrow-width));\r\n        top: calc(50% - var(--smart-tooltip-arrow-width));\r\n        transform: translateY(var(--smart-tooltip-arrow-translate)); }\r\n  smart-tooltip:not([animation=\'none\']) {\r\n    opacity: 0;\r\n    transition: opacity 0.5s ease-in-out; }\r\n    smart-tooltip:not([animation=\'none\'])[visible] {\r\n      opacity: 1; }\r\n\r\n/* .smart-tooltip */\r\nsmart-tooltip[right-to-left] .smart-tooltip-content {\r\n  direction: rtl; }\r\n',""]);const s=i},9495:(e,t,r)=>{"use strict";r.d(t,{Z:()=>s});var n=r(8081),o=r.n(n),a=r(3645),i=r.n(a)()(o());i.push([e.id,"/* CSS variables */\r\n\r\n:root {\r\n    --smart-primary-rgb: 0, 92, 153;\r\n    /* The r, g, and b components of the theme primary color */\r\n    --smart-primary: rgb(var(--smart-primary-rgb));\r\n    /* The theme primary color */\r\n    --smart-primary-color: #ffffff;\r\n    /* Text color on top of a primary background */\r\n\r\n    --smart-secondary-rgb: 45, 45, 48;\r\n    /* The r, g, and b components of the theme secondary color */\r\n    --smart-secondary: rgb(var(--smart-secondary-rgb));\r\n    /* The theme secondary color */\r\n    --smart-secondary-color: #ffffff;\r\n    /* Text color on top of a secondary background */\r\n\r\n    --smart-error-rgb: 176, 0, 32;\r\n    /* The theme error color */\r\n    --smart-error: rgb(var(--smart-error-rgb));\r\n    /* The theme error color */\r\n    --smart-error-color: #ffffff;\r\n    /* Text color on top of a error background */\r\n\r\n    --smart-success-rgb: 139, 195, 74;\r\n    /* The r, g, and b components of the theme success color */\r\n    --smart-success: rgb(var(--smart-success-rgb));\r\n    /* The theme success color */\r\n    --smart-success-color: #ffffff;\r\n    /* Text color on top of a success background */\r\n\r\n    --smart-info-rgb: 92, 192, 222;\r\n    /* The r, g, and b components of the theme info color */\r\n    --smart-info: rgb(var(--smart-info-rgb));\r\n    /* The theme info color */\r\n    --smart-info-color: #fff;\r\n    /* Text color on top of a info background */\r\n\r\n    --smart-warning-rgb: 240, 173, 78;\r\n    /* The r, g, and b components of the theme warning color */\r\n    --smart-warning: rgb(var(--smart-warning-rgb));\r\n    /* The theme warning color */\r\n    --smart-warning-color: #fff;\r\n    /* Text color on top of a warning background */\r\n\r\n    --smart-light-rgb: 255, 255, 255;\r\n    /* The r, g, and b components of the theme light color */\r\n    --smart-light: rgb(var(--smart-light-rgb));\r\n    /* The theme light color */\r\n    --smart-light-color: #222222;\r\n    /* Text color on top of a light background */\r\n\r\n    --smart-dark-rgb: 34, 34, 34;\r\n    /* The r, g, and b components of the theme dark color */\r\n    --smart-dark: rgb(var(--smart-dark-rgb));\r\n    /* The theme dark color */\r\n    --smart-dark-color: #ffffff;\r\n    /* Text color on top of a dark background */\r\n\r\n    --smart-background: #fefefe;\r\n    /* The theme background color. The background color appears behind scrollable content.*/\r\n    --smart-background-color: #5A5A5A;\r\n    /* Text color on top of a background background */\r\n\r\n    --smart-surface: #F5F5F5;\r\n    /* The theme surface color. Surface colors affect surfaces of components, such as cards, sheets, and menus. */\r\n    --smart-surface-color: #323232;\r\n    /* Text color on top of a surface surface */\r\n\r\n    --smart-disabled: #CCCCCC;\r\n    /* The theme primary color in disabled state. */\r\n    --smart-disabled-color: #555;\r\n    /* Text color on top of a theme background in disabled state */\r\n\r\n    --smart-ui-state-hover: #ebebeb;\r\n    /* Hover state background. */\r\n    --smart-ui-state-color-hover: #333;\r\n    /* Text color, when UI Element's state is 'hover'. */\r\n    --smart-ui-state-border-hover: var(--smart-ui-state-hover);\r\n    /* Border color, when UI Element's state is 'hover'. */\r\n    --smart-ui-state-active: var(--smart-primary);\r\n    /* Active state background. */\r\n    --smart-ui-state-color-active: var(--smart-primary-color);\r\n    /* Text color, when UI Element's state is 'active'. */\r\n    --smart-ui-state-border-active: var(--smart-primary);\r\n    /* Border color, when UI Element's state is 'active'. */\r\n    --smart-ui-state-focus: #e2e0e0;\r\n    /* Focus state background. */\r\n    --smart-ui-state-color-focus: #333;\r\n    /* Text color, when UI Element's state is 'focus'. */\r\n    --smart-ui-state-border-focus: var(--smart-ui-state-focus);\r\n    /* Border color, when UI Element's state is 'focus'. */\r\n    --smart-ui-state-selected: rgba(var(--smart-primary-rgb), .1);\r\n    /* Selected state background. */\r\n    --smart-ui-state-color-selected: var(--smart-primary);\r\n    /* Text color, when UI Element's state is 'selected'. */\r\n    --smart-ui-state-border-selected: rgba(var(--smart-primary-rgb), .1);\r\n    /* Border color, when UI Element's state is 'selected'. */\r\n    --smart-item-border-width: 1px;\r\n    /* Theme border-width */\r\n    --smart-item-border-radius: var(--smart-border-radius);\r\n    /* Border radius of items. */\r\n    --smart-item-border-top-left-radius: var(--smart-border-radius);\r\n    /* Border top-left radius of items. */\r\n    --smart-item-border-top-right-radius: var(--smart-border-radius);\r\n    /* Border top-right radius of items. */\r\n    --smart-item-border-bottom-left-radius: var(--smart-border-radius);\r\n    /* Border bottom-left radius of items. */\r\n    --smart-item-border-bottom-right-radius: var(--smart-border-radius);\r\n    /* Border bottom-right radius of items. */\r\n    --smart-font-size: 14px;\r\n    /* Theme font-size */\r\n    --smart-font-weight: inherit;\r\n    /* Theme font-weight */\r\n    --smart-font-style: inherit;\r\n    /* Theme font-style */\r\n    --smart-font-family: Roboto, \"Helvetica Neue\", sans-serif;\r\n    /* Theme font-family */\r\n    --smart-font-family-icon: smart-icons;\r\n    /* Theme icons font-family. */\r\n    --smart-font-family-icon-src: local('../font/smart-icons'), url('../font/smart-icons.woff2') format('woff2'), url('../font/smart-icons.woff') format('woff'), url('../font/smart-icons.ttf') format('truetype'), url('../font/smart-icons.eot') format('embedded-opentype');\r\n    /* The source of the theme icons font-family */\r\n    --smart-border-width: 1px;\r\n    /* Theme border-width */\r\n    --smart-border-radius: 4px;\r\n    /* Theme border-radius */\r\n    --smart-border-top-left-radius: var(--smart-border-radius);\r\n    /* Theme border-radius */\r\n    --smart-border-top-right-radius: var(--smart-border-radius);\r\n    /* Theme border-radius */\r\n    --smart-border-bottom-left-radius: var(--smart-border-radius);\r\n    /* Theme border-radius */\r\n    --smart-border-bottom-right-radius: var(--smart-border-radius);\r\n    /* Theme border-radius */\r\n    --smart-border: #E0E0E0;\r\n    /* The theme background border color */\r\n    --smart-border-rgb: 244, 224, 224;\r\n    /* The theme background border color */\r\n    --smart-outline: #b2b2b2;\r\n    /* The theme active element outline color */\r\n    --smart-editor-selection: var(--smart-primary);\r\n    /* Background color of the selected text. */\r\n    --smart-editor-selection-color: var(--smart-primary-color);\r\n    /* Color of the selected text. */\r\n    --smart-alternation-index0-color: var(--smart-surface-color);\r\n    /* Alternation color for index0 */\r\n    --smart-alternation-index0-border: var(--smart-surface);\r\n    /* Alternation border color for index0 */\r\n    --smart-alternation-index0-background: var(--smart-surface);\r\n    /* Alternation background color for index0 */\r\n    --smart-alternation-index1-color: #111;\r\n    /*Alternation color for index1 */\r\n    --smart-alternation-index1-border: #9BBB59;\r\n    /* Alternation border color for index1 */\r\n    --smart-alternation-index1-background: #9BBB59;\r\n    /* Alternation background color for index1 */\r\n    --smart-alternation-index2-color: #fff;\r\n    /*Alternation color for index2 */\r\n    --smart-alternation-index2-border: #FC3752;\r\n    /* Alternation border color for index2 */\r\n    --smart-alternation-index2-background: #FC3752;\r\n    /* Alternation background color for index2 */\r\n    --smart-tick-color: var(--smart-border);\r\n    /* Default tick color for smartTank, smartSlider and smartGauge */\r\n    --smart-tick-label-color: var(--smart-background-color);\r\n    /* Default tick label color for smartTank, smartSlider and smartGauge */\r\n    --smart-box-height: 450px;\r\n    /* Default height for Dialog, Gauge, Accordion, Tabs, Tree, Array */\r\n    --smart-box-width: 450px;\r\n    /* Default width for  Dialog, Gauge, Accordion, Tabs, Tree, Array */\r\n    --smart-bar-height: 48px;\r\n    /* Default height for headers and footers */\r\n    --smart-bar-width: 400px;\r\n    /* Default width for headers and footers */\r\n    --smart-editor-height: 30px;\r\n    /* Default height for editors */\r\n    --smart-editor-width: 250px;\r\n    /* Default width for editors */\r\n    --smart-editor-drop-down-width: 300px;\r\n    /* Default width for editors drop-down */\r\n    --smart-editor-drop-down-height: 400px;\r\n    /* Default height for editors drop-down */\r\n    --smart-editor-drop-down-padding-size: 3px;\r\n    /* smartDropDownList, smartComboBox drop down default height */\r\n    --smart-editor-drop-down-max-width: 800px;\r\n    /* smartDropDownList, smartComboBox, smartTextBox popup max width */\r\n    --smart-editor-drop-down-min-width: 100px;\r\n    /* smartDropDownList, smartComboBox, smartTextBox popup min width */\r\n    --smart-editor-drop-down-max-height: 400px;\r\n    /* smartDropDownList, smartComboBox, smartTextBox popup max height */\r\n    --smart-editor-drop-down-min-height: 50px;\r\n    /* smartDropDownList, smartComboBox, smartTextBox popup min height */\r\n    --smart-editor-drop-down-resize-bar-height: 15px;\r\n    /* smartDropDownList, smartComboBox, smartTextBox popup resize bar default height */\r\n    --smart-editor-drop-down-vertical-offset: 5px;\r\n    /* Vertical offset of editor drop downs */\r\n    --smart-editor-drop-down-z-index: 9999;\r\n    /* z-index of editor drop downs */\r\n    --smart-editor-label-padding: 4px;\r\n    /* Default padding for inputs */\r\n    --smart-editor-addon-width: 27px;\r\n    /* Default width for spin buttons, dropdown buttons. */\r\n    --smart-column-icon-size: 30px;\r\n    /* Default size of column icons */\r\n    --smart-icon-table: '\\e800';\r\n    /* Code of table icon */\r\n    --smart-icon-star: '\\e801';\r\n    /* Code of star icon */\r\n    --smart-icon-star-empty: '\\e802';\r\n    /* Code of empty star icon */\r\n    --smart-icon-plus: '\\e803';\r\n    /* Code of plus icon */\r\n    --smart-icon-minus: '\\e804';\r\n    /* Code of minus icon */\r\n    --smart-icon-attention-circled: '\\e805';\r\n    /* Code of circled attention icon */\r\n    --smart-icon-align-left: '\\e806';\r\n    /* Code of align left icon */\r\n    --smart-icon-align-right: '\\e807';\r\n    /* Code of align right icon */\r\n    --smart-icon-align-center: '\\e808';\r\n    /* Code of align center icon */\r\n    --smart-icon-align-justify: '\\e813';\r\n    /* Code of align justify icon */\r\n    --smart-icon-reload: '\\e809';\r\n    /* Code of reload icon */\r\n    --smart-icon-cloud: '\\e84d';\r\n    /* Code of cloud icon */\r\n    --smart-icon-cancel: '\\e80d';\r\n    /* Code of cancel icon */\r\n    --smart-icon-close: '\\e80d';\r\n    /* Code of close icon */\r\n    --smart-icon-cancel-circled: '\\e80e';\r\n    /* Code of Close icon Alt */\r\n    --smart-icon-cancel-alt: '\\E849';\r\n    /* Code of Close icon Alt */\r\n    --smart-icon-arrow-alt: '\\F105';\r\n    /* Code of circled cancel icon */\r\n    --smart-icon-plus-circled: '\\e810';\r\n    /* Code of circled plus icon */\r\n    --smart-icon-power: '\\e811';\r\n    /* Code of power icon */\r\n    --smart-icon-minus-circled: '\\e814';\r\n    /* Code of circled minus icon */\r\n    --smart-icon-arrow-up-alt: '\\e817';\r\n    /* Code of alternative up arrow icon */\r\n    --smart-icon-radio: '\\e818';\r\n    /* Code of radio icon */\r\n    --smart-icon-refresh: '\\e819';\r\n    /* Code of refresh icon */\r\n    --smart-icon-chart: '\\e81a';\r\n    /* Code of chart icon */\r\n    --smart-icon-check-squared: '\\e81b';\r\n    /* Code of squared check icon */\r\n    --smart-icon-resize-full: '\\e81c';\r\n    /* Code of full resize icon */\r\n    --smart-icon-resize-small: '\\e81d';\r\n    /* Code of small resize icon */\r\n    --smart-icon-resize-vertical: '\\e80c';\r\n    /* Code of vertical resize icon */\r\n    --smart-icon-resize-horizontal: '\\e80f';\r\n    /* Code of horizontal resize icon */\r\n    --smart-icon-lock: '\\e821';\r\n    /* Code of lock icon */\r\n    --smart-icon-sort: '\\e823';\r\n    /* Code of sort icon */\r\n    --smart-icon-delete: '\\e826';\r\n    /* Code of delete icon */\r\n    --smart-icon-search: '\\e828';\r\n    /* Code of search icon */\r\n    --smart-icon-calendar: '\\e829';\r\n    /* Code of calendar icon */\r\n    --smart-icon-edit: '\\e82a';\r\n    /* Code of edit icon */\r\n    --smart-icon-popup: '\\e82c';\r\n    /* Code of popup icon */\r\n    --smart-icon-lock-open: '\\e82e';\r\n    /* Code of open lock icon */\r\n    --smart-icon-add-filter: '\\e82f';\r\n    /* Code of add filter icon */\r\n    --smart-icon-block: '\\e832';\r\n    /* Code of block icon */\r\n    --smart-icon-settings: '\\e833';\r\n    /* Code of settings icon */\r\n    --smart-icon-duplicate: '\\e834';\r\n    /* Code of duplicate icon */\r\n    --smart-icon-copy-record: '\\e835';\r\n    /* Code of copy record icon */\r\n    --smart-icon-download-alt: '\\e836';\r\n    /* Code of alternative download icon */\r\n    --smart-icon-clock: '\\e837';\r\n    /* Code of clock icon */\r\n    --smart-icon-attention: '\\e838';\r\n    /* Code of attention icon */\r\n    --smart-icon-help-circled: '\\e839';\r\n    /* Code of circled help icon */\r\n    --smart-icon-mail: '\\e83c';\r\n    /* Code of mail icon */\r\n    --smart-icon-up: '\\e83f';\r\n    /* Code of up icon */\r\n    --smart-icon-first-page: '\\e900';\r\n    /* Code of first page icon */\r\n    --smart-icon-arrow-down: '\\e901';\r\n    /* Code of down arrow icon */\r\n    --smart-icon-arrow-left: '\\e902';\r\n    /* Code of left arrow icon */\r\n    --smart-icon-arrow-right: '\\e903';\r\n    /* Code of right arrow icon */\r\n    --smart-icon-arrow-up: '\\e904';\r\n    /* Code of up arrow icon */\r\n    --smart-icon-arrow-down-filled: '\\e812';\r\n    /* Code of filled down arrow icon */\r\n    --smart-icon-arrow-left-filled: '\\e816';\r\n    /* Code of filled left arrow icon */\r\n    --smart-icon-arrow-right-filled: '\\e81e';\r\n    /* Code of filled right arrow icon */\r\n    --smart-icon-arrow-up-filled: '\\e815';\r\n    /* Code of filled up arrow icon */\r\n    --smart-icon-last-page: '\\e905';\r\n    /* Code of last page icon */\r\n    --smart-icon-more-horiz: '\\e906';\r\n    /* Code of more icon */\r\n    --smart-icon-skip-next: '\\e907';\r\n    /* Code of skip next icon */\r\n    --smart-icon-check: '\\e908';\r\n    /* Code of check icon */\r\n    --smart-icon-mode-edit: '\\e909';\r\n    /* Code of edit mode icon */\r\n    --smart-icon-replay: '\\e90c';\r\n    /* Code of replay icon */\r\n    --smart-icon-visibility: '\\e90d';\r\n    /* Code of visibility icon */\r\n    --smart-icon-visibility-off: '\\e90e';\r\n    /* Code of visibility off icon */\r\n    --smart-icon-link: '\\e831';\r\n    /* Code of link icon */\r\n    --smart-icon-unlink: '\\f127';\r\n    /* Code of link icon */\r\n    --smart-icon-link-ext: '\\f08e';\r\n    /* Code of link icon */\r\n    --smart-icon-check-empty: '\\f096';\r\n    /* Code of empty check icon */\r\n    --smart-icon-filter: '\\f0b0';\r\n    /* Code of filter icon */\r\n    --smart-icon-resize-full-alt: '\\f0b2';\r\n    /* Code of full resize alternative icon */\r\n    --smart-icon-menu: '\\f0c9';\r\n    /* Code of menu icon */\r\n    --smart-icon-sort-1: '\\f0dc';\r\n    /* Code of sort alternative icon */\r\n    --smart-icon-paste: '\\f0ea';\r\n    /* Code of paste icon */\r\n    --smart-icon-circle-empty: '\\f10c';\r\n    /* Code of empty circle icon */\r\n    --smart-icon-circle: '\\f111';\r\n    /* Code of circle icon */\r\n    --smart-icon-ellipsis: '\\f141';\r\n    /* Code of ellipsis icon */\r\n    --smart-icon-minus-squared: '\\f146';\r\n    /* Code of squared minus icon */\r\n    --smart-icon-ok-squared: '\\f14a';\r\n    /* Code of squared ok icon */\r\n    --smart-icon-sort-name-up: '\\f15d';\r\n    /* Code of sort name up icon */\r\n    --smart-icon-sort-name-down: '\\f15e';\r\n    /* Code of sort name down icon */\r\n    --smart-icon-sort-alt-up: '\\f160';\r\n    /* Code of sort up alternative icon */\r\n    --smart-icon-sort-alt-down: '\\f161';\r\n    /* Code of sort down alternative icon */\r\n    --smart-icon-sort-number-up: '\\f162';\r\n    /* Code of sort number up icon */\r\n    --smart-icon-sort-number-down: '\\f163';\r\n    /* Code of sort number down icon */\r\n    --smart-icon-dot-circled: '\\f192';\r\n    /* Code of circled dot icon */\r\n    --smart-icon-toggle-off: '\\f204';\r\n    /* Code of toggle off icon */\r\n    --smart-icon-toggle-on: '\\f205';\r\n    /* Code of toggle on icon */\r\n    --smart-icon-group: '\\f247';\r\n    /* Code of group icon */\r\n    --smart-icon-ungroup: '\\f248';\r\n    /* Code of ungroup icon */\r\n    --smart-icon-window-maximize: '\\f2d0';\r\n    /* Code of maximize window icon */\r\n    --smart-icon-window-minimize: '\\f2d1';\r\n    /* Code of minimize window icon */\r\n    --smart-icon-window-restore: '\\f2d2';\r\n    /* Code of restore window icon */\r\n    --smart-icon-window-pin-alt: '\\e82d';\r\n    /* Code of pin window alternative icon */\r\n    --smart-icon-window-pin: '\\e80a';\r\n    /* Code of window pin icon */\r\n    --smart-icon-docs: '\\f0c5';\r\n    /* Code of docs icon */\r\n    --smart-icon-pdf: '\\f1c1';\r\n    /* Code of pdf icon */\r\n    --smart-icon-excel: '\\f1C3';\r\n    /* Code of excel icon */\r\n    --smart-icon-word: '\\f1C2';\r\n     /* Code of word icon */\r\n     --smart-icon-archive: '\\f1C6';\r\n      /* Code of zip icon */\r\n     --smart-icon-file: '\\e845';\r\n      /* Code of file icon */\r\n     --smart-icon-powerpoint: '\\f1c4';\r\n     /* Code of powerpoint icon */\r\n     --smart-icon-text: '\\f0f6';\r\n    /* Code of text icon */\r\n    --smart-icon-math: '\\f01a';\r\n    /* Code of math icon */\r\n    --smart-icon-spin: '\\e80b';\r\n    /* Code of spin icon */\r\n    --smart-icon-user: '\\e81f';\r\n    /* Code of user icon */\r\n    --smart-icon-font: '\\f031';\r\n    /* Code of font icon */\r\n    --smart-icon-fontsize: '\\f088';\r\n    /* Code of fontsize icon */\r\n    --smart-icon-contains: '\\f063';\r\n    /* Code of contains icon */\r\n    --smart-icon-starts_with: '\\f064';\r\n    /* Code of starts with icon */\r\n    --smart-icon-ends_with: '\\f065';\r\n    /* Code of ends with icon */\r\n    --smart-icon-does_not_contain: '\\f066';\r\n    /* Code of does not contain icon */\r\n    --smart-icon-equals: '\\f52c';\r\n    /* Code of equals icon */\r\n    --smart-icon-greater-than: '\\f531';\r\n    /* Code of greater than icon */\r\n    --smart-icon-greater-than-equal: '\\f532';\r\n    /* Code of greater than or equal icon */\r\n    --smart-icon-less-than: '\\f536';\r\n    /* Code of less than icon */\r\n    --smart-icon-less-than-equal: '\\f537';\r\n    /* Code of less than or equal icon */\r\n    --smart-icon-not-equal: '\\f53e';\r\n    /* Code of not equal icon */\r\n    --smart-icon-percentage: '\\f541';\r\n    /* Code of percentage icon */\r\n    --smart-icon-grip-vertical: '\\f58e';\r\n    /* Code of grip icon */\r\n    --smart-icon-between: '\\f06a';\r\n    /* Code of between icon */\r\n    --smart-icon-bold: '\\e820';\r\n    /* Code of bold icon */\r\n    --smart-icon-italic: '\\e822';\r\n    /* Code of italic icon */\r\n    --smart-icon-underline: '\\f0cd';\r\n    /* Code of underline icon */\r\n    --smart-icon-strike-through: '\\f0cc';\r\n    /* Code of strike-through icon */\r\n    --smart-icon-list-ordered: '\\f0cb';\r\n    /* Code of list numbered icon */\r\n    --smart-icon-list-unordered: '\\f0ca';\r\n    /* Code of list bullet icon */\r\n    --smart-icon-subscript: '\\f12c';\r\n    /* Code of subscript icon */\r\n    --smart-icon-superscript: '\\f12b';\r\n    /* Code of superscript icon */\r\n    --smart-icon-color-background: '\\e830';\r\n    /* Code of bucket icon */\r\n    --smart-icon-indent-right: '\\e824';\r\n    /* Code of indent icon */\r\n    --smart-icon-indent-left: '\\e825';\r\n    /* Code of outdent icon */\r\n    --smart-icon-image: '\\e827';\r\n    /* Code of image icon */\r\n    --smart-icon-case-lower: 'aa';\r\n    /* Code of lower case icon */\r\n    --smart-icon-case-upper: 'AA';\r\n    /* Code of upper case icon */\r\n    --smart-icon-print: '\\e82b';\r\n    /* Code of print icon */\r\n    --smart-icon-format-clear: 'T';\r\n    /* Code of clear format icon */\r\n    --smart-icon-source-code: '\\f121';\r\n    /* Code of source code icon */\r\n    --smart-icon-split-mode: '\\e83b';\r\n    /* Code of split mode icon */\r\n    --smart-icon-cut: '\\e83a';\r\n    /* Code of Cut icon */\r\n    --smart-icon-video: '\\f16a';\r\n    /* Code of YouTube video icon */\r\n    --smart-icon-video-camera: '\\e840';\r\n    /* Code of Bell  icon */\r\n    --smart-icon-bell: '\\f0f3';\r\n    /* Code of video icon */\r\n    --smart-icon-header: '\\f1dc';\r\n    /* Code of Table Header */\r\n    --smart-icon-row: '\\f0db';\r\n    /* Code of Table Row icon */\r\n    --smart-icon-row-before: '\\f2d0';\r\n    /* Code of Table Row icon */\r\n    --smart-icon-row-after: '\\f2d0';\r\n    /* Code of Table Row icon */\r\n    --smart-icon-row-delete: var(--smart-icon-cancel-circled);\r\n    /* Code of Table Row icon */\r\n    --smart-icon-column: '\\f0db';\r\n    /* Code of Table Column icon */\r\n    --smart-icon-column-left: '\\f2d0';\r\n    /* Code of Table Column left insert icon */\r\n    --smart-icon-column-right: '\\f2d0';\r\n    /* Code of Table Column right insert icon */\r\n    --smart-icon-column-delete: var(--smart-icon-cancel-circled);\r\n    /* Code of Table Column delete icon */\r\n    --smart-icon-vertical-align: '\\f06a \\e80c';\r\n    /* Code of Table Vertical Align icon */\r\n    --smart-icon-styles: '\\f1fc';\r\n    /* Code of Table Styles icon */\r\n    --smart-icon-comment: '\\F0E5';\r\n    /* Code of Comment icon */\r\n    --smart-icon-card: '\\E83E';\r\n    /* Code of Card icon */\r\n    --smart-icon-tasks: '\\F0AE';\r\n    /* Code of Tasks icon */\r\n    --smart-icon-phone: '\\E83D';\r\n    /* Code of Phone icon */\r\n    --smart-icon-kanban: '\\F181';\r\n    /* Code of Kanban icon */\r\n    --smart-icon-table-alt: '\\F0CE';\r\n    /* Code of Table icon */\r\n    --smart-icon-zoom-in: '\\E841';\r\n    /* Code of Zoom In icon */\r\n    --smart-icon-zoom-out: '\\E842';\r\n    /* Code of Zoom Out icon */\r\n    --smart-icon-move: '\\F047';\r\n    /* Code of Move icon */\r\n    --smart-icon-home: '\\E843';\r\n    /* Accordion */\r\n    --smart-accordion-animation-duration: 225ms;\r\n    /* smartAccordion animation duration */\r\n    --smart-accordion-default-width: var(--smart-box-width);\r\n    /* smartAccordion default width */\r\n    --smart-accordion-default-height: var(--smart-box-height);\r\n    /* smartAccordion default height */\r\n    --smart-accordion-expanded-content-height: 0px;\r\n    /* Determines expanded content's height */\r\n    --smart-accordion-expanded-content-local-height: 0px;\r\n    /* The height of an expanded item content part. Calculated dynamically for each item. Used in all modes except 'singleFitHeight'. */\r\n    --smart-accordion-item-header-height: var(--smart-bar-height);\r\n    /* Element's header height. Used in several calcilations related to items height. */\r\n    --smart-accordion-item-expanded-offset: 20px;\r\n    /* An offset below each expanded accordion item. */\r\n    /* Array */\r\n    --smart-array-default-width: var(--smart-box-width);\r\n    /* smartArray default width */\r\n    --smart-array-default-height: var(--smart-box-height);\r\n    /* smartArray default height */\r\n    --smart-array-element-gap: 3px;\r\n    /* smartArray element gap size */\r\n    /* Breadcrumb */\r\n    --smart-breadcrumb-default-width: 400px;\r\n    /* smartBreadcrumb default width */\r\n    --smart-breadcrumb-default-height: auto;\r\n    /* smartBreadcrumb default height */\r\n    --smart-breadcrumb-padding: 10px;\r\n    /* Padding of smart-breadcrumb and vertical offset between smartBreadcrumb items */\r\n    --smart-breadcrumb-drop-down-width: var(--smart-editor-drop-down-width);\r\n    /* Width of smartBreadcrumb dropdown in minimized mode */\r\n    --smart-breadcrumb-item-height: 40px;\r\n    /* Height of smartBreadcrumb items */\r\n    --smart-breadcrumb-horizontal-offset: 10px;\r\n    /* Horizontal offset between smartBreadcrumb items */\r\n    /* Button - Default */\r\n    --smart-button-text-transform: uppercase;\r\n    /* Controls the capitalization of button's text. Could be set as uppercase/lowercase/capitalize. */\r\n    --smart-button-padding: 8px 16px;\r\n    /* Sets button's paddings. */\r\n    --smart-button-large-padding: 10px 16px;\r\n    /* Sets large button's paddings. */\r\n    --smart-button-large-font-size: 18px;\r\n    /* Sets large button's font size. */\r\n    --smart-button-small-padding: 5px 10px;\r\n    /* Sets small button's paddings. */\r\n    --smart-button-small-font-size: 12px;\r\n    /* Sets small button's font size. */\r\n    --smart-button-very-small-padding: 3px 5px;\r\n    /* Sets very small button's paddings. */\r\n    --smart-button-very-small-font-size: 10px;\r\n    /* Sets very small button's font size. */\r\n    /* Button - Flat */\r\n    --smart-button-flat-color: var(--smart-background-color);\r\n    /* The color of the flat button. */\r\n    /* Button - Outlined */\r\n    --smart-button-outlined-color: var(--smart-background-color);\r\n    /* The color of the outlined button. */\r\n    --smart-button-outlined-border: var(--smart-border);\r\n    /* The border of the outlined button. */\r\n    /* Button Group */\r\n    --smart-button-group-default-width: auto;\r\n    --smart-button-group-default-height: auto;\r\n    /* Calendar */\r\n    --smart-calendar-header-height: calc(0.75 * var(--smart-bar-height));\r\n    /* Default height for smartCalendar's header section */\r\n    --smart-calendar-footer-height: calc(0.75 * var(--smart-bar-height));\r\n    /* Default height for smartCalendar's footer section */\r\n    --smart-calendar-title-height: calc(1.25 * var(--smart-bar-height));\r\n    /* Default height for calendar's title. */\r\n    --smart-calendar-cell-size: 30px;\r\n    /* Default size of calendar's cell. */\r\n    --smart-calendar-cell-spacing: 4px;\r\n    /* Defines calendar's cell spacing. */\r\n    --smart-calendar-default-width: calc(50px + var(--smart-calendar-cell-spacing) + 7 * (var(--smart-calendar-cell-spacing) + var(--smart-calendar-cell-size)));\r\n    /* smartCalendar default width */\r\n    --smart-calendar-default-height: calc(var(--smart-calendar-cell-spacing) + 7 * (var(--smart-calendar-cell-spacing) + var(--smart-calendar-cell-size)) + var(--smart-calendar-header-height));\r\n    /* smartCalendar default height */\r\n    --smart-calendar-title-text-transform: initial;\r\n    /* Controls the capitalization of the title text. */\r\n    --smart-calendar-week-title-text-transform: uppercase;\r\n    /* Controls the capitalization of the week title. */\r\n    --smart-calendar-header-text-transform: uppercase;\r\n    /* Controls the capitalization of the header text. */\r\n    --smart-calendar-footer-text-transform: uppercase;\r\n    /* Controls the capitalization of the footer text. */\r\n    --smart-calendar-cell-border-top-right-radius: 15px;\r\n    /* Defines cell's top-right border radius. */\r\n    --smart-calendar-cell-border-top-left-radius: 15px;\r\n    /* Defines cell's top-left border radius. */\r\n    --smart-calendar-cell-border-bottom-left-radius: 15px;\r\n    /* Defines cell's bottom-left border radius. */\r\n    --smart-calendar-cell-border-bottom-right-radius: 15px;\r\n    /* Defines cell's bottom-right border radius. */\r\n    --smart-calendar-title-padding: 10px;\r\n    /* Defines title's padding */\r\n    --smart-calendar-important-date-background: var(--smart-ui-state-hover);\r\n    /* Defines title's padding */\r\n    --smart-calendar-important-date-color: var(--smart-ui-state-color-hover);\r\n    /* Defines title's padding */\r\n    --smart-calendar-important-date-border-color: var(--smart-ui-state-border-hover);\r\n    /* Defines title's padding */\r\n    --smart-calendar-navigation-button-size: 30px;\r\n    /* Sets the size for the navigation buttons */\r\n    /* CardView */\r\n    --smart-card-view-default-width: 1200px;\r\n    /* Default width of CardView. */\r\n    --smart-card-view-default-height: 800px;\r\n    /* Default height of CardView. */\r\n    --smart-card-view-header-height: 30px;\r\n    /* Height of the CardView header */\r\n    --smart-card-view-cover-height: var(--smart-carousel-default-height);\r\n    /* Height of CardView cover (carousel). */\r\n    --smart-card-view-vertical-offset: 15px;\r\n    /* Vertical offset of CardView. */\r\n    --smart-card-view-column-min-width: 250px;\r\n    /* Min width of CardView visual columns. */\r\n    --smart-card-view-gap: 10px;\r\n    /* Gap between CardView cards. */\r\n    --smart-card-view-add-new-button-size: 60px;\r\n    /* Size of the 'Add new record' (+) button. */\r\n    /* Carousel */\r\n    --smart-carousel-default-width: 600px;\r\n    /* default width of the element */\r\n    --smart-carousel-default-height: 200px;\r\n    /* default height of the element */\r\n    --smart-carousel-3d-mode-slide-width: 400px;\r\n    /* default width of a slide in 3d mode */\r\n    --smart-carousel-3d-mode-slide-height: 400px;\r\n    /* default height of a slide in 3d mode */\r\n    --smart-carousel-multiple-mode-slide-width: 200px;\r\n    /* default width of a slide in multiple mode*/\r\n    /* Chart */\r\n    --smart-chart-default-width: 850px;\r\n    /* default width of the element */\r\n    --smart-chart-default-height: 500px;\r\n    /* default height of the element */\r\n    /* Check Box */\r\n    --smart-check-box-default-size: calc(1px + 1/2 * var(--smart-editor-height));\r\n    /* Default size for the check box used in smartCheckBox and smartListItem. */\r\n    /* ColorPanel*/\r\n    --smart-color-panel-default-width: auto;\r\n    /* smartColorPanel default width ; was 450px*/\r\n    --smart-color-panel-default-height: auto;\r\n    /* smartColorPanel default height ; was 370px */\r\n    --smart-color-panel-palette-size: 300px;\r\n    /* smartColorPanel palette size */\r\n    --smart-color-panel-grid-mode-item-size: 20px;\r\n    /* smartColorPanel item size */\r\n    /*was 40px*/\r\n    --smart-color-panel-grid-mode-column-count: 8;\r\n    /* smartColorPanel column count */\r\n    --smart-color-panel-grid-mode-columns-gap: 1px;\r\n    /* smartColorPanel column gap size */\r\n    --smart-color-panel-brightness: 0;\r\n    /* smartColorPanel brightness */\r\n    --smart-color-panel-default-mode-sections-gap: 8px;\r\n    /* smartColorPanel gap size in default mode */\r\n    --smart-color-panel-palette-width: var(--smart-color-panel-palette-size);\r\n    /* smartColorPanel palette width */\r\n    --smart-color-panel-palette-height: var(--smart-color-panel-palette-size);\r\n    /* smartColorPanel palette height */\r\n    --smart-color-panel-alpha-channel-color: white;\r\n    /* Used as a default color for the Alpha Scale */\r\n    /* ColorPicker*/\r\n    --smart-color-picker-default-width: var(--smart-editor-width);\r\n    /* smartColorPicker default width */\r\n    --smart-color-picker-default-height: var(--smart-editor-height);\r\n    /* smartColorPicker default height */\r\n    --smart-color-picker-drop-down-width: auto;\r\n    /* smartColorPicker default width */\r\n    --smart-color-picker-drop-down-height: auto;\r\n    /* smartColorPicker default height */\r\n    /* ComboBox */\r\n    --smart-combo-box-default-width: var(--smart-editor-width);\r\n    /* smartComboBox default width */\r\n    --smart-combo-box-default-height: var(--smart-editor-height);\r\n    /* smartComboBox default height */\r\n    --smart-combo-box-drop-down-width: auto;\r\n    /* smartComboBox default width */\r\n    --smart-combo-box-drop-down-height: auto;\r\n    /* smartComboBox default height */\r\n    /* Chip */\r\n    --smart-chip-default-height: var(--smart-editor-height);\r\n    /* Default chips height */\r\n    --smart-chip-avatar-background: var(--smart-secondary);\r\n    /* Default avatar background color */\r\n    /* Currency format panel */\r\n    --smart-currency-format-panel-currency-holder-width: 1fr;\r\n    --smart-currency-format-panel-apply-button-width: 125px;\r\n    --smart-currency-format-panel-header-holder-offset: 2%;\r\n    --smart-currency-format-panel-currency-holder-input-width: 1fr;\r\n    --smart-currency-format-panel-currency-holder-dropdown-width: 165px;\r\n    --smart-currency-format-panel-currency-holder-dropdown-button-width: 95%;\r\n    --smart-currency-format-panel-border-size: 1px;\r\n    --smart-currency-format-panel-border-color: #ccc;\r\n    --smart-currency-format-panel-border-radius: 4px;\r\n    --smart-currency-format-panel-currencies-margin-top: 15px;\r\n    --smart-currency-format-panel-currencies-max-height: 400px;\r\n    --smart-currency-format-panel-currencies-item-padding: 12px;\r\n    --smart-currency-format-panel-currency-holder-padding-left: 5px;\r\n    --smart-currency-format-panel-currency-holder-padding-top: 3px;\r\n    --smart-currency-format-panel-currency-holder-padding-bottom: 3px;\r\n    --smart-currency-format-panel-currency-input-width: 100%;\r\n    --smart-currency-format-panel-currencies-left-padding: 10px;\r\n    --smart-currency-format-panel-currencies-hover-background: #f1f1f1;\r\n    --smart-currency-format-panel-currencies-example-format-color: #777;\r\n    /* DataView - Common for CardView and Kanban */\r\n    --smart-data-view-padding: 10px;\r\n    /* Padding of the CardView and Kanban */\r\n    --smart-data-view-customize-panel-width: 320px;\r\n    /* Width of the CardView and Kanban customize panel (drop down). */\r\n    --smart-data-view-filter-panel-width: 550px;\r\n    /* Width of the CardView and Kanban filter panel (drop down). */\r\n    --smart-data-view-sort-panel-width: 470px;\r\n    /* Width of the CardView and Kanban sort panel (drop down). */\r\n    --smart-data-view-search-panel-width: 250px;\r\n    /* Width of the CardView and Kanban search panel (drop down). */\r\n    /* Date Format Panel */\r\n    --smart-date-format-panel-main-container-width: 960px;\r\n    /* Main container */\r\n    --smart-date-format-panel-main-container-padding: 15px;\r\n    --smart-date-format-panel-border-radius: 4px;\r\n    /* Default styles */\r\n    --smart-date-format-panel-border-size: 1px;\r\n    --smart-date-format-panel-border-color: #ccc;\r\n    --smart-date-format-panel-smart-inputs-container-width: 1fr;\r\n    /* Input and add format holder */\r\n    --smart-date-format-panel-apply-container-width: 150px;\r\n    --smart-date-format-panel-smart-input-buttons-column-gap: 2%;\r\n    --smart-date-format-panel-smart-inputs-holder-width: 94%;\r\n    /* Input and add format holder child */\r\n    --smart-date-format-panel-add-format-holder-width: 6%;\r\n    --smart-date-format-panel-smart-inputs-list-holder-offset: 2px;\r\n    --smart-date-format-panel-smart-input-format-width: 150px;\r\n    /* Smart inputs */\r\n    --smart-date-format-panel-smart-input-sign-width: 80px;\r\n    --smart-date-format-panel-smart-input-height: 25px;\r\n    --smart-date-format-panel-each-smart-input-offset: 4px;\r\n    --smart-date-format-panel-all-format-holders-width: 255px;\r\n    --smart-date-format-panel-add-format-holder-button: 120px;\r\n    --smart-date-format-panel-each-add-format-holder-width: 120px;\r\n    /* Add new format */\r\n    --smart-date-format-panel-add-new-format-dropdown-offset: 5px;\r\n    --smart-date-format-panel-date-time-format-list-offset-top: 15px;\r\n    /* Format list */\r\n    --smart-date-format-panel-date-time-format-list-max-height: 400px;\r\n    --smart-date-format-panel-each-date-time-format-offset: 12px;\r\n    /* Date Time Picker */\r\n    --smart-date-time-picker-default-width: var(--smart-editor-width);\r\n    /* smartDateTimePicker default width */\r\n    --smart-date-time-picker-default-height: var(--smart-editor-height);\r\n    /* smartDateTimePicker default height */\r\n    --smart-date-time-picker-header-opacity: 0.8;\r\n    /* Opacity of header elements */\r\n    --smart-date-time-picker-header-opacity-active: 1;\r\n    /* Opacity of header elements when selected */\r\n    --smart-date-time-picker-drop-down-width: var(--smart-editor-drop-down-height);\r\n    /* smartDropDownList drop down width */\r\n    --smart-date-time-picker-drop-down-height: auto;\r\n    /* smartDropDownList drop down height */\r\n    /*DockingLayout*/\r\n    --smart-docking-layout-default-width: 1000px;\r\n    /* smartDropDownList, smartComboBox default width */\r\n    --smart-docking-layout-default-height: 800px;\r\n    /* smartDropDownList, smartComboBox default height */\r\n    --smart-docking-layout-feedback-background-secondary-size: 7px;\r\n    /* The size of the arrows of the advanced snapping highlighters that show possible drop position of the dragged item. */\r\n    /*DropDownList*/\r\n    --smart-drop-down-list-default-width: var(--smart-editor-width);\r\n    /* smartDropDownList, smartComboBox default width */\r\n    --smart-drop-down-list-default-height: var(--smart-editor-height);\r\n    /* smartDropDownList, smartComboBox default height */\r\n    --smart-drop-down-list-drop-down-width: initial;\r\n    /* smartDropDownList drop down width */\r\n    --smart-drop-down-list-drop-down-height: auto;\r\n    /* smartDropDownList drop down height */\r\n    /* DropDownButton */\r\n    --smart-drop-down-button-default-width: auto;\r\n    /* smartDropDownButton default width */\r\n    --smart-drop-down-button-default-height: var(--smart-editor-height);\r\n    /* smartDropDownButton default height */\r\n    --smart-drop-down-button-drop-down-width: var(--smart-editor-drop-down-width);\r\n    /* smartDropDownButton drop down width */\r\n    --smart-drop-down-button-drop-down-height: var(--smart-editor-drop-down-height);\r\n    /* smartDropDownButton drop down height */\r\n    /* Editor */\r\n    --smart-editor-default-width: 100%;\r\n    /* smartEditor default width */\r\n    --smart-editor-default-height: 600px;\r\n    /* smartEditor default height */\r\n    --smart-editor-input-min-height: 100px;\r\n    /* smartEditor input min height */\r\n    --smart-editor-padding: 15px;\r\n    /* smartEditor padding */\r\n    --smart-editor-toolbar-item-margin: 5px;\r\n    /* smartEditor toolbar item margin */\r\n    --smart-editor-toolbar-button-width: 30px;\r\n    /* smartEditor toolbar button width */\r\n    --smart-editor-toolbar-delimiter-width: 5px;\r\n    /* smartEditor toolbar delimiter items width */\r\n    --smart-editor-toolbar-drop-down-width-large: 100px;\r\n    /* smartEditor wider drop down toolbar items like - format, fontname, etc. */\r\n    --smart-editor-toolbar-drop-down-width-small: 65px;\r\n    /* smartEditor all drop down toolbar items default width */\r\n    --smart-editor-window-header-height: var(--smart-scheduler-window-header-height);\r\n    /* smartEditor Dialog Window header height */\r\n    --smart-editor-window-footer-height: var(--smart-scheduler-window-footer-height);\r\n    /* smartEditor Dialog Window footer height */\r\n    --smart-editor-inline-toolbar-max-width: 80vw;\r\n    /* smartEditor Inline toolbar max width */\r\n    --smart-editor-table-column-width: initial;\r\n    /* smartEditor table column default width */\r\n    --smart-editor-table-cell-min-height: 20px;\r\n    /* smartEditor table cell defaut min height */\r\n    --smart-editor-table-cell-min-width: var(--smart-editor-table-cell-min-height);\r\n    /* smartEditor table cell default min width */\r\n    --smart-editor-char-counter-offset: 30px;\r\n    /* smartEditor char count offset from the edges of the element */\r\n    --smart-editor-toolbar-item-height: 30px;\r\n    /* smartEditor default toolbar item height */\r\n    --smart-editor-toolbar-item-border-radius: var(--smart-border-radius);\r\n    /* smartEditor toolbar item border radius */\r\n    --smart-editor-toolbar-height: calc(var(--smart-editor-toolbar-item-height) + 2 * var(--smart-editor-toolbar-item-margin));\r\n    /* smartEditor toolbar height */\r\n    --smart-editor-highlight: var(--smart-primary);\r\n    /* smartEditor Find and Replace highlight color */\r\n    --smart-editor-highlight-color: var(--smart-primary-color);\r\n    /* smartEditor highligh text color */\r\n    --smart-editor-search-bar-offset: 5px;\r\n    /* smartEditor search bar offset */\r\n    --smart-editor-search-bar-padding: 5px;\r\n    /* smartEditor search bar padding */\r\n    /* Filter Builder */\r\n    --smart-filter-builder-default-width: var(--smart-box-width);\r\n    /* Default width of the smartFilterBuilder*/\r\n    --smart-filter-builder-default-height: var(--smart-box-height);\r\n    /* Default height of the smartFilterBuilder*/\r\n    --smart-filter-builder-row-height: var(--smart-editor-height);\r\n    /* Default height of the smartFilterBuilder's rows*/\r\n    --smart-filter-builder-item-width: var(--smart-editor-width);\r\n    /* Default width of the smartFilterBuilder's button items*/\r\n    --smart-filter-builder-group-container-border: 4px;\r\n    --smart-filter-builder-item-margin: 20px;\r\n    --smart-filter-builder-group-condition-margin: 5px;\r\n    --smart-filter-builder-group-margin: 15px;\r\n    /* Filter Panel */\r\n    --smart-filter-panel-default-width: 300px;\r\n    /* Default width of the smartFilterPanel */\r\n    --smart-filter-panel-default-height: auto;\r\n    /* Default height of the smartFilterPanel */\r\n    --smart-filter-panel-padding: 10px;\r\n    /* padding of the smartFilterPanel */\r\n    --smart-filter-panel-border-top-right-radius: var(--smart-border-radius);\r\n    /* smartFilterPanel top-right border radius */\r\n    --smart-filter-panel-border-top-left-radius: var(--smart-border-radius);\r\n    /* smartFilterPanel top-left border radius */\r\n    --smart-filter-panel-border-bottom-left-radius: var(--smart-border-radius);\r\n    /* smartFilterPanel bottom-left border radius */\r\n    --smart-filter-panel-border-bottom-right-radius: var(--smart-border-radius);\r\n    /* smartFilterPanel bottom-right border radius */\r\n    --smart-filter-panel-border-width: var(--smart-border-width);\r\n    /* smartFilterPanel border width */\r\n    --smart-filter-panel-border: var(--smart-border);\r\n    /* smartFilterPanel border color */\r\n    --smart-filter-panel-background: var(--smart-background);\r\n    /* smartFilterPanel background color */\r\n    --smart-filter-panel-color: var(--smart-background-color);\r\n    /* smartFilterPanel text color */\r\n    --smart-filter-panel-vertical-offset: 10px;\r\n    /* Vertical offset between smartFilterPanel sub-elements */\r\n    --smart-filter-panel-main-element-height: 400px;\r\n    /* height of the smartTree inside the smartFilterPanel */\r\n    /* File Upload */\r\n    --smart-file-upload-default-width: var(--smart-editor-width);\r\n    /* Default width of the smartFileUpload*/\r\n    --smart-file-upload-browse-button-width: auto;\r\n    /* Default width of the browse button*/\r\n    --smart-file-upload-browse-button-height: auto;\r\n    /* Default height of the browse button*/\r\n    --smart-file-upload-footer-button-width: auto;\r\n    /* Default height of the smartFileUpload's footer buttons*/\r\n    --smart-file-upload-footer-button-height: auto;\r\n    /* Default height of the smartFileUpload's footer buttons*/\r\n    --smart-file-upload-text-content-uploading-start: \"Connecting ...\";\r\n    /* Default text content of the pseudo element shown when upload starts. */\r\n    --smart-file-upload-text-content-uploading: \"Uploading ...\";\r\n    /* Default text content of the pseudo element shown during the upload. */\r\n    --smart-file-upload-text-content-error: \"Upload error!\";\r\n    /* Default text content of the pseudo element shown on error. */\r\n    --smart-file-upload-text-content-pause: \"Upload paused!\";\r\n    /* Default text content of the pseudo element shown when upload is paused. */\r\n    --smart-file-upload-text-content-drop-zone: \"Drag files here\";\r\n    /* Default text content of the pseudo element shown where is the drop zone. */\r\n    --smart-file-upload-text-content-drop-zone-over: \"Drop here \\e824\";\r\n    /* Default text content of the pseudo element shown when dragged files are over the drop zone. */\r\n    --smart-file-upload-container-min-height: 60px;\r\n    /* Sets minimmum height of the drop zone and file zone containers. */\r\n    --smart-file-upload-total-files-min-height: 20px;\r\n    /* Sets min height of the container where total numbers of items is displayed. */\r\n    --smart-file-upload-drop-zone-height: 100%;\r\n    /* Sets min height of the container where total numbers of items is displayed. */\r\n    /* Gantt Chart */\r\n    --smart-gantt-chart-resource-splitter-bar-fit-size: calc(var(--smart-gantt-chart-resource-timeline-content-height) + var(--smart-gantt-chart-task-default-height));\r\n    /* The fit size of all Resource Splitter bar inside the Resource Panel of the element*/\r\n    --smart-gantt-chart-task-splitter-bar-fit-size: var(--smart-gantt-chart-task-timeline-content-height);\r\n    /* The fit size of all Splitter bar inside the element*/\r\n    --smart-gantt-chart-task-default-height: 30px;\r\n    /* The height of a Task inside the Timeline */\r\n    --smart-gantt-chart-header-height: var(--smart-gantt-chart-task-default-height);\r\n    /* The height of the header of the Task and Resource Panels */\r\n    --smart-gantt-chart-task-bar-fill-padding: 5px;\r\n    /* The padding of the Fill of the Task Bar */\r\n    --smart-gantt-chart-task-label-padding: 2px var(--smart-gantt-chart-task-bar-fill-padding);\r\n    /* */\r\n    --smart-gantt-chart-task-thumb-color: rgba(0, 0, 0, .55);\r\n    /* The color of the thumb */\r\n    --smart-gantt-chart-task-progress-color: rgba(0, 0, 0, .15);\r\n    /* #2d75f5 */\r\n    /* The default color of the progress fill of all Tasks inside the Timeline */\r\n    --smart-gantt-chart-project-color: #ffa558;\r\n    /* #38a238*/\r\n    /* The defaut color for all Project tasks */\r\n    --smart-gantt-chart-project-label-color: #333;\r\n    /* Determines the label color of the project tasks inside the Timeline. */\r\n    --smart-gantt-chart-project-label-color-selected: #000;\r\n    /* Determines the label color of the project tasks inside the Timeline when selected. */\r\n    --smart-gantt-chart-project-progress-color: var(--smart-gantt-chart-task-progress-color);\r\n    /* #008000 */\r\n    /* The default color of the progress fill for all Project tasks */\r\n    --smart-gantt-chart-task-color: rgb(43, 195, 190);\r\n    /* #6495ed */\r\n    /* The default color of a Task inside the Timeline */\r\n    --smart-gantt-chart-milestone-color: #800080;\r\n    /* The default color for all Milestones */\r\n    --smart-gantt-chart-timeline-task-background-color: transparent;\r\n    /* Determines the background color of the tasks(rows) inside the Timeline. */\r\n    --smart-gantt-chart-timeline-task-connection-feedback-color: #e6510a;\r\n    /* orange */\r\n    /* Determines the default color of the feedback that is shows when creating a connection between tasks inside the Timeline. */\r\n    --smart-gantt-chart-timeline-task-connection-feedback-width: 1px;\r\n    /* Determines the default width of the feedback that is shows when creating a connection between tasks inside the Timeline. */\r\n    --smart-gantt-chart-timeline-task-connection-feedback-style: dashed;\r\n    /* Determines the style of the feedback that is shows when creating a connection between tasks inside the Timeline. */\r\n    --smart-gantt-chart-timeline-task-connection-color: var(--smart-gantt-chart-timeline-task-connection-feedback-color);\r\n    /* Determines the color of the connections between Tasks inside the Timeline. */\r\n    --smart-gantt-chart-timeline-task-connection-color-hover: var(--smart-gantt-chart-timeline-task-connection-color);\r\n    /* Determines the color on hover of the connections between Tasks inside the Timeline. */\r\n    --smart-gantt-chart-timeline-task-connection-width: var(--smart-gantt-chart-timeline-task-connection-feedback-width);\r\n    /* Determines the width of the connections between the tasks inside the Timeline. */\r\n    --smart-gantt-chart-timeline-task-connection-style: solid;\r\n    /* Determines the style of the connections between the tasks inside the Timeline. */\r\n    --smart-gantt-chart-timeline-task-connection-arrow-type: solid;\r\n    /* Determines the border type of the arrow of the connections between Tasks inside the Timeline. */\r\n    --smart-gantt-chart-timeline-task-connection-arrow-width: 5px;\r\n    /* Determines the width of the arrow of the connections between Tasks inside the Timeline. */\r\n    --smart-gantt-chart-timeline-task-resize-indicator-width: 4px;\r\n    /* Determines the defualt width of the resize indicator of the Task bars inside the Timeline. */\r\n    --smart-gantt-chart-timeline-task-resize-indicator-color: #fff;\r\n    /* Determines the background-color of the resize indicators of the Task bars insinde the Timeline. */\r\n    --smart-gantt-chart-timeline-task-resize-indicator-border-color: #333;\r\n    /* Determines the border-color of the resize indicator of the Task bars inside the Timeline. */\r\n    --smart-gantt-chart-timeline-task-progress-thumb-size: 10px;\r\n    /* Determines the size of the thumb controlling the progress of a Task inside the Timeline. */\r\n    --smart-gantt-chart-timeline-cell-size: auto;\r\n    /* Determines the default width of the cells inside the Timeline. */\r\n    --smart-gantt-chart-timeline-cell-min-size: 70px;\r\n    /* Determines the default min-width of the cells inside the Timeline. */\r\n    --smart-gantt-chart-timeline-task-min-width: 5px;\r\n    /* Determines the default min-width of the Tasks insinde the Timeline. Not applicable to Milestone tasks. */\r\n    --smart-gantt-chart-timeline-weekend-color: #EFF5FD;\r\n    /* Determines the default background color of the 'weekend' cells insinde the Timeline. */\r\n    --smart-gantt-chart-timeline-nonworking-color: #F5F5F5;\r\n    /* Determines the default background-color of the nonworking days/hours inside the Timeline. */\r\n    --smart-gantt-chart-default-width: auto;\r\n    /* Determines the default width of the element. */\r\n    --smart-gantt-chart-default-height: 600px;\r\n    /* Determines the height of the element. */\r\n    --smart-gantt-chart-task-popup-window-default-width: 60vw;\r\n    /* Determines the width of the task editing popup windows of the element. */\r\n    --smart-gantt-chart-connection-popup-window-default-width: 300px;\r\n    /* Determines the width of the connection editing popup windows of the element. */\r\n    --smart-gantt-chart-confirm-popup-window-default-width: var(--smart-gantt-chart-connection-popup-default-width);\r\n    /* Determines the width of the confirm popup window of the element. */\r\n    --smart-gantt-chart-popup-window-header-height: 35px;\r\n    /* Determines the height of the header of the popup windows inside the element. */\r\n    --smart-gantt-chart-popup-window-footer-height: 50px;\r\n    /* Determines the height of the footer of the popup windows insinde the element. */\r\n    --smart-gantt-chart-header-placeholder: ' - ';\r\n    /* Placeholder for thea Header sections when there're no items */\r\n    --smart-gantt-chart-progress-label-padding: 0 10px 0 10px;\r\n    /* Task progress label padding */\r\n    --smart-gantt-chart-filter-row-height: 30px;\r\n    /* Sets a box shadow to the Task Timeline header */\r\n    --smart-gantt-chart-task-fill-border-radius: 0;\r\n    /* Sets the default border radius for the Timeline task bars */\r\n    --smart-gantt-chart-segment-link-color: var(--smart-gantt-chart-task-color);\r\n    /* Determines the color of the link between the task segments */\r\n    --smart-gantt-chart-segment-link-size: var(--smart-border-width);\r\n    /* Determines the height of the link between the task segments */\r\n    --smart-gantt-chart-date-marker-color: var(--smart-primary);\r\n    /* Determines the color of the date markers */\r\n    --smart-gantt-chart-date-marker-height: 25px;\r\n    /* Determines the background of the date markers */\r\n    --smart-gantt-chart-date-marker-width: var(--smart-border-width);\r\n    /* Determines the width of the date markers */\r\n    --smart-gantt-chart-date-marker-background: var(--smart-primary);\r\n    /* Determines the background of the date markers */\r\n    --smart-gantt-chart-date-marker-color: var(--smart-primary-color);\r\n    /* Determines the background of the date markers */\r\n    --smart-gantt-chart-date-marker-v-offset: 15%;\r\n    /* Determines the vertical position of the date markers */\r\n    --smart-gantt-chart-date-marker-h-offset: 10px;\r\n    /* Determines the horizontal offset of the date markers */\r\n    --smart-gantt-chart-indicator-icon: initial;\r\n    /* Determines the task indicator icon */\r\n    --smart-gantt-chart-deadline-icon: var(--smart-icon-attention-circled);\r\n    /* Determines the icon for the task deadline */\r\n    --smart-gantt-chart-deadline-color: var(--smart-error);\r\n    /* Determines the color for the task deadline icon */\r\n    --smart-gantt-chart-baseline-proportion: 2;\r\n    /* Determines the proportion of the baseline compared to the task height */\r\n    --smart-gantt-chart-baseline-background: rgba(166, 205, 87, .5);\r\n    /* Determines the background color of the task baseline */\r\n    --smart-gantt-chart-progress-label-width: 60px;\r\n    /* Determines the task progress label width */\r\n    --smart-gantt-chart-current-time-indicator-size: 1px;\r\n    /* Determines the current time indicator width */\r\n    --smart-gantt-chart-current-time-indicator-background: var(--smart-primary);\r\n    /* Determines the current time indicator background */\r\n    --smart-gantt-chart-current-time-indicator-arrow-size: 7px;\r\n    /* Determines the arrow size of the curernt time indicator */\r\n    --smart-gantt-chart-current-time-indicator-header-size: 2px;\r\n    /* Determines the current time indicator size inside the timeline header cell */\r\n    --smart-gantt-chart-shader-background: rgba(var(--smart-border-rgb), .5);\r\n    /* Determines the current time shader background color */\r\n\r\n    /* Gauge */\r\n    --smart-gauge-default-width: var(--smart-box-width);\r\n    /* smartGauge default width */\r\n    --smart-gauge-default-height: var(--smart-box-height);\r\n    /* smartgauge default height */\r\n    --smart-gauge-track-border: var(--smart-border);\r\n    /* Track's border color */\r\n    --smart-gauge-track-background: var(--smart-background);\r\n    /* Track's background color */\r\n    --smart-gauge-needle-background: var(--smart-primary);\r\n    /* Needle's background color */\r\n    --smart-gauge-label-fill-state: initial;\r\n    /* Fill color of labels */\r\n    --smart-gauge-label-stroke: initial;\r\n    /* Stroke color of labels */\r\n    /* Grid */\r\n    --smart-grid-default-width: 800px;\r\n    /* Used to set the default width. */\r\n    --smart-grid-default-height: 400px;\r\n    /* Used to set the default height. */\r\n    --smart-grid-footer-height: var(--smart-bar-height);\r\n    /* Sets footer height. */\r\n    --smart-grid-header-height: var(--smart-bar-height);\r\n    /* Sets header height. */\r\n    --smart-grid-group-header-height: var(--smart-bar-height);\r\n    /* Sets group header height. */\r\n    --smart-grid-row-height: 30px;\r\n    /* Sets rows height. */\r\n    --smart-grid-column-header-height: var(--smart-bar-height);\r\n    /* Sets columns height. */\r\n    --smart-grid-filter-footer-height: var(--smart-bar-height);\r\n    /* Sets filter row height. */\r\n    --smart-grid-aggregate-footer-height: var(--smart-bar-height);\r\n    /* Sets aggregates height. */\r\n    --smart-grid-header-background-freeze: var(--smart-surface);\r\n    /* Sets row/column header background, when row/column is frozen. */\r\n    --smart-grid-header-color-freeze: var(--smart-surface-color);\r\n    /* Sets row/column header text color, when row/column is frozen. */\r\n    --smart-grid-column-menu-width: 200px;\r\n    /* Sets column menu's width. */\r\n    --smart-grid-column-menu-height: auto;\r\n    /* Sets column menu's height. */\r\n    --smart-grid-column-buttons-width: 23px;\r\n    /* Sets column buttons width. */\r\n    --smart-grid-cell-color-freeze: var(--smart-surface-color);\r\n    /* Sets text color of cells, when row/column is frozen. */\r\n    --smart-grid-cell-background-freeze: var(--smart-surface);\r\n    /* Sets background color of cells, when row/column is frozen */\r\n    --smart-grid-cell-color-delete: #333;\r\n    /* Sets text color of cells, when row is deleted. */\r\n    --smart-grid-cell-background-delete: #FFDCDC;\r\n    /* Sets background color of cells, when row is deleted. */\r\n    --smart-grid-cell-color-update: #333;\r\n    /* Sets text color of cells, when cell is updated.. */\r\n    --smart-grid-cell-background-update: #D7F9C7;\r\n    /* Sets background color of cells, when cell is updated.. */\r\n    --smart-grid-cell-color-add: #333;\r\n    /* Sets text color of cells, when row is added.. */\r\n    --smart-grid-cell-background-add: #FED59B;\r\n    /* Sets background color of cells, when row is deleted.. */\r\n    --smart-grid-cell-color-unbound: var(--smart-surface-color);\r\n    /* Sets text color of cells, when row is unbound. */\r\n    --smart-grid-cell-background-unbound: var(--smart-surface);\r\n    /* Sets background color of cells, when row is unbound. */\r\n    --smart-grid-cell-color-sort: var(--smart-surface-color);\r\n    /* Sets text color of cells, when column is sorted. */\r\n    --smart-grid-cell-background-sort: #FEF3dd;\r\n    /* Sets background color of cells, when column is sorted. */\r\n    --smart-grid-cell-color-filter: var(--smart-surface-color);\r\n    /* Sets text color of cells, when column is filtered. */\r\n    --smart-grid-cell-background-filter: #E8F2DB;\r\n    /* Sets the view bar background colors */\r\n    --smart-grid-view-bar-background: #FCFCFC;\r\n    /* Sets background color of cells, when column is filtered. */\r\n    --smart-grid-group-row-vertical-offset: 5;\r\n    /* Sets grouped rows vertical offset. */\r\n    --smart-grid-group-row-horizontal-offset: 1;\r\n    /* Sets grouped rows horizontal offset. */\r\n    --smart-grid-template-columns: none;\r\n    /* Sets Template columns. */\r\n    --smart-grid-column-gap: 0px;\r\n    /* Sets the element's grid-column-gap (related to CSS Grid) */\r\n    --smart-grid-row-gap: 0px;\r\n    /* Sets the element's grid-row-gap (related to CSS Grid) */\r\n    --smart-grid-freeze-splitter-size: 1px;\r\n    /* Sets frozen split bar size. */\r\n    --smart-grid-resize-line-size: 1px;\r\n    /* Sets resize line size. */\r\n    /* Grid Layout */\r\n    --smart-grid-layout-col-gap: 10px;\r\n    --smart-grid-layout-row-gap: 10px;\r\n    --smart-grid-layout-width: 100%;\r\n    --smart-grid-layout-rows: none;\r\n    /* Group Panel, Sort Panel, Column Panel, Multi Column Filter Panel, Formatting Panel */\r\n    --smart-grid-panel-default-width: 450px;\r\n    /* Default width of the smartGroupPanel/smartSortPanel/smartColumnPanel/smartMultiColumnFilterPanel */\r\n    --smart-grid-panel-default-height: auto;\r\n    /* Default height of the smartGroupPanel/smartSortPanel/smartColumnPanel/smartMultiColumnFilterPanel */\r\n    --smart-grid-panel-padding: 10px;\r\n    /* padding of the smartGroupPanel/smartSortPanel/smartColumnPanel/smartMultiColumnFilterPanel */\r\n    --smart-grid-panel-vertical-offset: 10px;\r\n    /* Vertical offset between smartGroupPanel/smartSortPanel/smartColumnPanel/smartMultiColumnFilterPanel items */\r\n    --smart-grid-panel-item-height: 30px;\r\n    /* height of smartGroupPanel/smartSortPanel/smartColumnPanel/smartMultiColumnFilterPanel items */\r\n    --smart-column-panel-drop-down-height: 350px;\r\n    /* height of drop-downs */\r\n    --smart-multi-column-filter-panel-template-columns: 15px 60px 2fr 3fr 3fr;\r\n    /* smartMultiColumnFilterPanel grid-template-columns */\r\n    --smart-formatting-panel-default-width: 600px;\r\n    /* Default width of the smartFormattingPanel */\r\n    --smart-formatting-panel-row-height: 30px;\r\n    /* Height of rows in smartFormattingPanel */\r\n    --smart-formatting-panel-add-new-button-size: 40px;\r\n    /* Size of \"Add new\" (+) button in smartFormattingPanel */\r\n    --smart-formatting-panel-popup-width: 300px;\r\n    /* Width of smartFormattingPanel's pop-up */\r\n    --smart-formatting-panel-color-box-height: 20px;\r\n    /* Height of color boxes in smartFormattingPanel's pop-up */\r\n    /* Kanban */\r\n    --smart-kanban-default-width: 1200px;\r\n    /* Default width of Kanban */\r\n    --smart-kanban-default-height: 500px;\r\n    /* Default height of Kanban */\r\n    --smart-kanban-header-size: 35px;\r\n    /* Header size of Kanban (applies to header and column headers) */\r\n    --smart-kanban-task-min-width: 150px;\r\n    /* Min width for Kanban tasks in columns with horizontal orientation */\r\n    --smart-kanban-task-min-height: 80px;\r\n    /* Kanban task min height */\r\n    --smart-kanban-text-max-height: 200px;\r\n    /* Kanban task text part max height */\r\n    --smart-kanban-user-icon-size: 30px;\r\n    /* Kanban user icon size */\r\n    --smart-kanban-user-list-width: 150px;\r\n    /* Kanban user list width */\r\n    --smart-kanban-user-list-max-height: 500px;\r\n    /* Kanban user list max height */\r\n    --smart-kanban-comments-list-width: 350px;\r\n    /* Kanban comments list width */\r\n    --smart-kanban-comments-list-height: auto;\r\n    /* Kanban comments list height */\r\n    --smart-kanban-new-comment-height: 50px;\r\n    /* Height of new comment section */\r\n    --smart-kanban-new-comment-height-expanded: 175px;\r\n    /* Expanded height of new comment section */\r\n    --smart-kanban-send-button-height: 30px;\r\n    /* Height of Send button in new comment section */\r\n    --smart-kanban-color-band-width: 3px;\r\n    /* Kanban color band width (i.e. left border of tasks) */\r\n    --smart-kanban-add-new-column-width: 1fr;\r\n    /* Kanban \"+ New status\" column width */\r\n    /* ListBox */\r\n    --smart-list-box-default-width: var(--smart-editor-width);\r\n    /* smartListBox default width */\r\n    --smart-list-box-default-height: var(--smart-editor-width);\r\n    /* smartListBox default height */\r\n    --smart-list-item-group-header-text-transform: uppercase;\r\n    /* smartListBox item group header text transform */\r\n    --smart-list-item-horizontal-offset: 3px;\r\n    /* Defines list item's horizontal offset. */\r\n    --smart-list-item-vertical-offset: 3px;\r\n    /* Defines list item's vertical offset. */\r\n    --smart-list-item-height: 36px;\r\n    /* smartListBox item height */\r\n    --smart-list-item-check-box-radius: 2px;\r\n    /* smartListBox checkbox radius */\r\n    --smart-list-item-label-padding: 0;\r\n    /* smartListBox item label padding */\r\n    --smart-list-item-label-border-radius: 0;\r\n    /* smartListBox item label border radius */\r\n    --smart-list-item-padding: 9px 12px;\r\n    /* smartListBox item padding */\r\n    /* Loader */\r\n    --smart-loader-size: var(--smart-editor-height);\r\n    /* smartListBox loader size(width=height) */\r\n    /* LED */\r\n    --smart-led-default-width: var(--smart-editor-height);\r\n    /* smartLed default width */\r\n    --smart-led-default-height: var(--smart-editor-height);\r\n    /* smartLed default height */\r\n    /* List Menu */\r\n    --smart-list-menu-default-width: var(--smart-box-width);\r\n    /* smartListMenu default width */\r\n    --smart-list-menu-default-height: var(--smart-box-height);\r\n    /* smartListMenu default height */\r\n    --smart-list-menu-filter-input-vertical-offset: 5px;\r\n    /* Defines vertical offset of the ListMenu's filter input. */\r\n    --smart-list-menu-filter-input-horizontal-offset: 5px;\r\n    /* Defines horizontal offset of the ListMenu's filter input. */\r\n    /*Masked Text Box*/\r\n    --smart-masked-text-box-default-width: var(--smart-editor-width);\r\n    /* smartMasked default width */\r\n    --smart-masked-text-box-default-height: var(--smart-editor-height);\r\n    /* smartMasked default height */\r\n    /* Menu */\r\n    --smart-menu-default-width: var(--smart-bar-width);\r\n    /* smartMenu default width */\r\n    --smart-menu-default-height: var(--smart-bar-height);\r\n    /* smartMenu default height */\r\n    --smart-menu-vertical-default-width: calc(var(--smart-bar-width) / 2);\r\n    /* vertical and context smartMenu default width */\r\n    --smart-menu-vertical-default-height: var(--smart-bar-width);\r\n    /* vertical and context smartMenu default height */\r\n    --smart-menu-scroll-button-size: calc(var(--smart-bar-height) / 1.5);\r\n    /* smartMenu scroll buttons size. Horizontal Menu scroll buttons width = Vertical Menu scroll buttons height. */\r\n    /* Multiline Text Box */\r\n    --smart-multiline-text-box-default-width: var(--smart-editor-width);\r\n    /* Default width of the element. */\r\n    --smart-multiline-text-box-default-height: calc(10 * var(--smart-editor-height));\r\n    /* Default height of the element. */\r\n    /* Multi Split Button*/\r\n    --smart-multi-split-button-default-width: var(--smart-editor-width);\r\n    /* Element's default width. */\r\n    --smart-multi-split-button-default-height: var(--smart-editor-height);\r\n    /* Element's default height. */\r\n    /* Number format Panel */\r\n    --smart-number-format-panel-selected-format-width: 1fr;\r\n    --smart-number-format-panel-apply-button-width: 125px;\r\n    --smart-number-format-panel-header-holder-offset: 10px;\r\n    --smart-number-format-panel-border-size: 1px;\r\n    --smart-number-format-panel-border-color: #ccc;\r\n    --smart-number-format-panel-border-radius: 4px;\r\n    --smart-number-format-panel-sample-container-vertical-offset: 15px;\r\n    --smart-number-format-panel-sample-container-horizontal-offset: 5px;\r\n    --smart-number-format-panel-formats-list-margin-top: 15px;\r\n    --smart-number-format-panel-formats-list-max-height: 400px;\r\n    --smart-number-format-panel-formats-item-padding: 12px;\r\n    --smart-number-format-panel-selected-format-padding-left: 5px;\r\n    --smart-number-format-panel-selected-format-padding-top: 3px;\r\n    --smart-number-format-panel-selected-format-padding-bottom: 3px;\r\n    --smart-number-format-panel-header-input-width: 100%;\r\n    --smart-number-format-panel-formats-item-left-padding: 10px;\r\n    --smart-number-format-panel-formats-item-hover-background: #f1f1f1;\r\n    --smart-number-format-panel-formats-item-example-format-color: #777;\r\n    /* Numeric Text Box */\r\n    --smart-numeric-text-box-default-width: var(--smart-editor-width);\r\n    /* smartNumericTextBox default width */\r\n    --smart-numeric-text-box-default-height: var(--smart-editor-height);\r\n    /* smartNumericTextBox default height */\r\n    --smart-numeric-text-box-default-radix-display-width: 12%;\r\n    /* smartNumericTextBox default radix display button width*/\r\n    --smart-numeric-text-box-default-unit-display-width: var(--smart-editor-addon-width);\r\n    /* smartNumericTextBox default unit display width*/\r\n    --smart-numeric-text-box-text-align: right;\r\n    /* smartNumericTextBox input text align */\r\n    /* Path */\r\n    --smart-path-default-width: var(--smart-editor-width);\r\n    /* smartPath default width */\r\n    --smart-path-default-height: var(--smart-editor-height);\r\n    /* smartPath default height */\r\n    --smart-path-drop-down-width: auto;\r\n    /* smartPath drop down width */\r\n    --smart-path-drop-down-height: auto;\r\n    /* smartPath drop down height */\r\n    --smart-path-button-gap: 5px;\r\n    /* smartPath button gap */\r\n    --smart-path-text-align: start;\r\n    /* smartPath text align */\r\n    /* Power Button */\r\n    --smart-power-button-default-width: var(--smart-editor-height);\r\n    /* smartPowerButton default width */\r\n    --smart-power-button-default-height: var(--smart-editor-height);\r\n    /* smartPowerButton default height */\r\n    /* Progress Bar */\r\n    --smart-progress-bar-default-width: var(--smart-editor-width);\r\n    /* smartProgressBar default width */\r\n    --smart-progress-bar-default-height: var(--smart-editor-height);\r\n    /* smartProgressBar default height */\r\n    --smart-circular-progress-bar-default-size: var(--smart-editor-width);\r\n    /* smartCircularProgressBar default size (width = height) */\r\n    --smart-circular-progress-bar-fill-size: 20%;\r\n    /* smartCircularProgressBar ui-state size. The width of the ui-state. The middle container's width is calculated defaultd on this value. */\r\n    /* Query Builder */\r\n    --smart-query-builder-default-width: auto;\r\n    /* Default width of QueryBuilder. */\r\n    --smart-query-builder-default-height: auto;\r\n    /* Default height of QueryBuilder. */\r\n    --smart-query-builder-min-width: 100px;\r\n    /* Minimum width of QueryBuilder. */\r\n    --smart-query-builder-content-padding: 5px;\r\n    /* Padding of QueryBuilder. */\r\n    --smart-query-builder-editor-width: 125px;\r\n    /* Width of editors in QueryBuilder. */\r\n    /* Radio Button */\r\n    --smart-radio-button-default-size: calc(1px + 1/2 * var(--smart-editor-height));\r\n    /* Default size for the radio button. */\r\n    /* Sortable */\r\n    --smart-sortable-handle-size: 25px;\r\n    /* smartSortable handle size */\r\n    /* Splitter */\r\n    --smart-splitter-default-width: var(--smart-box-width);\r\n    /* smartSplitter default width */\r\n    --smart-splitter-default-height: var(--smart-box-height);\r\n    /* smartSplitter default height */\r\n    --smart-splitter-bar-size: 10px;\r\n    /* The width of the scrollbar when vertical and the height of the scrollbar when horizontal*/\r\n    --smart-splitter-bar-fit-size: 100%;\r\n    /* The size of the splitter according to the orientation of the Splitter. By 'default' a SplitterBar fits the size of the Splitter. */\r\n    --smart-splitter-item-padding: 0;\r\n    /* Splitter item padding */\r\n    --smart-splitter-item-content-padding: 0;\r\n    /* Splitter item content padding */\r\n    --smart-splitter-item-size: auto;\r\n    /* The default size of the Splitter Items */\r\n    /* Switch Button */\r\n    --smart-switch-button-default-width: calc(var(--smart-editor-height) + 10px);\r\n    /* Default width of the SwitchButton. */\r\n    --smart-switch-button-default-height: var(--smart-editor-height);\r\n    /* smartSwitchButton default height */\r\n    --smart-switch-button-thumb-size: calc(var(--smart-switch-button-default-height) - 8px);\r\n    /* smartSwitchButton thumb size */\r\n    /* Slider */\r\n    --smart-slider-default-width: var(--smart-editor-width);\r\n    /* smartSlider default width */\r\n    --smart-slider-default-height: 35px;\r\n    /* smartSlider default height*/\r\n    --smart-slider-track-size: 1px;\r\n    /* smartSlider track size. Horizontal track height = Vertical track width */\r\n    --smart-slider-thumb-width: 20px;\r\n    /* smartSlider thumb width*/\r\n    --smart-slider-thumb-height: 20px;\r\n    /* smartSlider thumb height*/\r\n    --smart-slider-tooltip-width: 60px;\r\n    /* smartSlider tooltip width */\r\n    --smart-slider-tooltip-height: 30px;\r\n    /* smartSlider tooltip height*/\r\n    --smart-slider-spin-button-width: 30px;\r\n    /* smartSlider spin buttons width*/\r\n    --smart-slider-spin-button-height: 30px;\r\n    /* smartSlider spin buttons height*/\r\n    --smart-slider-tick-size: 10px;\r\n    /* smartSlider tick size. Horizontal Slider tick height = Vertical Slider tick width.*/\r\n    --smart-slider-minor-tick-size: 5px;\r\n    /* smartSlider minor tick size. Horizontal Slider minor tick height = Vertical Slider minor tick width.*/\r\n    --smart-slider-thumb-border-top-right-radius: 15px;\r\n    /* Top-right border radius of smartSlider thumb */\r\n    --smart-slider-thumb-border-top-left-radius: 15px;\r\n    /* Top-left border radius of smartSlider thumb */\r\n    --smart-slider-thumb-border-bottom-left-radius: 15px;\r\n    /* Bottom-left border radius of smartSlider thumb */\r\n    --smart-slider-thumb-border-bottom-right-radius: 15px;\r\n    /* Bottom-right border radius of smartSlider thumb */\r\n    /* ScrollBar */\r\n    --smart-scroll-button-size: 16px;\r\n    /* smartScrollBar buttons size. Horizontal ScrollBar button width = Vertical ScrollBar button height. ScrollBar track is calculated defaultd on this value. */\r\n    --smart-scroll-bar-size: 18px;\r\n    /* Default scrollbar size */\r\n    --smart-scroll-bar-default-width: var(--smart-editor-width);\r\n    /* ScrollBar's default width. */\r\n    --smart-scroll-bar-default-height: var(--smart-scroll-bar-size);\r\n    /* ScrollBar's default height. */\r\n    --smart-scroll-bar-background: #F1F1F1;\r\n    /* Default ScrollBar's background color. */\r\n    --smart-scroll-bar-track-background: var(--smart-scroll-bar-background);\r\n    --smart-scroll-bar-border: #F1F1F1;\r\n    /* The border color of the ScrollBar */\r\n    --smart-scroll-bar-thumb-border-top-right-radius: 0px;\r\n    /* Default ScrollBar's top-right border radius. */\r\n    --smart-scroll-bar-thumb-border-top-left-radius: 0px;\r\n    /* Default ScrollBar's top-left border radius. */\r\n    --smart-scroll-bar-thumb-border-bottom-left-radius: 0px;\r\n    /* Default ScrollBar's bottom-left border radius. */\r\n    --smart-scroll-bar-thumb-border-bottom-right-radius: 0px;\r\n    /* Default ScrollBar's bottom-right border radius. */\r\n    --smart-scroll-bar-thumb-background: #C1C1C1;\r\n    /* The color of the ScrollBar's thumb. */\r\n    --smart-scroll-bar-thumb-border: transparent;\r\n    /* The color of the ScrollBar's thumb border. */\r\n    --smart-scroll-bar-thumb-size: 100%;\r\n    /* The size of the ScrollBar's thumb. */\r\n    --smart-scroll-bar-thumb-padding: 1px;\r\n    /* The padding of the ScrollBar's thumb. */\r\n    --smart-scroll-bar-thumb-background-hover: #A8A8A8;\r\n    /* The background color of the ScrollBar's thumb in hover state. */\r\n    --smart-scroll-bar-thumb-border-hover: transparent;\r\n    /* The border color of the ScrollBar's thumb in hover state. */\r\n    --smart-scroll-bar-thumb-background-active: #787878;\r\n    /* The background color of the ScrollBar's thumb in active state. */\r\n    --smart-scroll-bar-thumb-border-active: transparent;\r\n    /* The border color of the ScrollBar's thumb in active state. */\r\n    --smart-scroll-bar-button-background: #F1F1F1;\r\n    /* The background color of ScrollBar's navigation buttons. */\r\n    --smart-scroll-bar-button-border: #F1F1F1;\r\n    /* The border color of ScrollBar's navigation buttons. */\r\n    --smart-scroll-bar-button-color: #505050;\r\n    /* The color of ScrollBar's navigation buttons. */\r\n    --smart-scroll-bar-button-background-hover: #D2D2D2;\r\n    /* The background color of the hovered ScrollBar's buttons. */\r\n    --smart-scroll-bar-button-border-hover: #F1F1F1;\r\n    /* The border color of the hovered ScrollBar's buttons. */\r\n    --smart-scroll-bar-button-color-hover: #505050;\r\n    /* The color of the hovered ScrollBar's buttons. */\r\n    --smart-scroll-bar-button-background-active: #787878;\r\n    /* The background color of the ScrollBar's buttons in active state. */\r\n    --smart-scroll-bar-button-border-active: #F1F1F1;\r\n    /* The border color of the ScrollBar's buttons in active state. */\r\n    --smart-scroll-bar-button-color-active: #fff;\r\n    /* The color of the ScrollBar's buttons in active state. */\r\n    /* Table and PivotTable */\r\n    --smart-table-default-width: 100%;\r\n    /* smartTable default width */\r\n    --smart-table-default-height: auto;\r\n    /* smartTable default height */\r\n    --smart-table-header-footer-height: 56px;\r\n    /* smartTable height of header and footer */\r\n    --smart-table-column-header-height: var(--smart-table-header-footer-height);\r\n    /* smartTable height of column header */\r\n    --smart-table-row-height: 48px;\r\n    /* smartTable height of rows */\r\n    --smart-table-cell-padding: 12px;\r\n    /* smartTable cell padding */\r\n    --smart-table-row-detail-height: var(--smart-table-row-height);\r\n    /* smartTable row detail height */\r\n    --smart-table-indent: 30px;\r\n    /* smartTable hierarchical cell indent */\r\n    --smart-table-arrow-size: 16px;\r\n    /* smartTable arrow size */\r\n    --smart-table-arrow-margin: 5px;\r\n    /* smartTable arrow margin */\r\n    --smart-table-group-name-display: unset;\r\n    /* smartTable group header name display */\r\n    --smart-table-group-count-display: unset;\r\n    /* smartTable group header leaf count display */\r\n    --smart-pivot-table-cell-width: 200px;\r\n    /* smartPivotTable cell width */\r\n    --smart-pivot-table-secondary-group-width: calc(1.25 * var(--smart-pivot-table-cell-width));\r\n    /* smartPivotTable row group width */\r\n    --smart-pivot-panel-width: 300px;\r\n    /* smartPivotTable designer (smartPivotPanel) width */\r\n    --smart-pivot-panel-default-height: 800px;\r\n    /* Standalone smartPivotPanel default height */\r\n    --smart-pivot-panel-tab-item-height: 150px;\r\n    /* smartPivotTable designer (smartPivotPanel) tab item height */\r\n    --smart-pivot-panel-padding: 10px;\r\n    /* smartPivotTable designer (smartPivotPanel) padding */\r\n    /* Tank */\r\n    --smart-tank-default-width: var(--smart-editor-width);\r\n    /* smartTank default width */\r\n    --smart-tank-default-height: calc(10 * var(--smart-editor-height));\r\n    /* smartTank default height*/\r\n    --smart-tank-scale-size: 105px;\r\n    /* smartTank scale size*/\r\n    --smart-tank-thumb-width: 25px;\r\n    /* smartTank thumb width*/\r\n    --smart-tank-thumb-height: var(--smart-tank-thumb-width);\r\n    /* smartTank thumb height*/\r\n    --smart-tank-tooltip-width: 80px;\r\n    /* smartTank tooltip width*/\r\n    --smart-tank-tooltip-height: 30px;\r\n    /* smartTank thumb height*/\r\n    --smart-tank-tick-size: 10px;\r\n    /* smartTank tick size. Horizontal Tank tick height = Vertical Tank tick width. */\r\n    --smart-tank-minor-tick-size: 5px;\r\n    /* smartTank minor tick size. */\r\n    --smart-tank-minimum-track-size: 6px;\r\n    /* smartTank horizontal track min-height, vertical track min-width */\r\n    /* Tabs */\r\n    --smart-tabs-header-button-size: 20px;\r\n    /* smartTabs header buttons size. Horizontal Tabs header buttons width = Vertical Tab header buttons height. */\r\n    --smart-tabs-animation-duration: 0.5s;\r\n    /* smartTabs animation duration */\r\n    --smart-tabs-default-width: var(--smart-box-width);\r\n    /* smartTabs default width */\r\n    --smart-tabs-default-height: var(--smart-box-height);\r\n    /* smartTabs default height */\r\n    --smart-tabs-header-padding: 0px;\r\n    /* Defines Tabs header padding. */\r\n    --smart-tabs-header-offset: 0px;\r\n    /* Defines Tabs header offset. */\r\n    --smart-tab-item-padding: 12px 16px;\r\n    /* Defines vertical and horizontal padding of tab items. */\r\n    --smart-tab-item-offset: 5px;\r\n    /* Default tab item offset. */\r\n    --smart-tab-item-initial-offset: 5px;\r\n    /* Initial tab item offset. */\r\n    --smart-tab-item-text-transform: uppercase;\r\n    /* Tab item text capitalization. */\r\n    /* Time Picker */\r\n    --smart-time-picker-default-width: var(--smart-editor-width);\r\n    /* smartTimePicker default width */\r\n    --smart-time-picker-default-height: calc(12 * var(--smart-editor-height));\r\n    /* smartTimePicker default height */\r\n    /* Tooltip */\r\n    --smart-tooltip-arrow-width: 6px;\r\n    /* Default smartTooltip arrow width */\r\n    --smart-tooltip-arrow-color: var(--smart-secondary);\r\n    /* smartTooltip arrow color */\r\n    --smart-tooltip-arrow-translate: 0;\r\n    /* smartTooltip arrow translation (transformation) */\r\n    --smart-tooltip-padding: 4px 8px;\r\n    /* smartTooltip padding */\r\n    --smart-tooltip-content-shadow: none;\r\n    /* smartTooltip content box-shadow */\r\n    /* Toast */\r\n    --smart-toast-item-icon: '';\r\n    /* Code of toast item icon */\r\n    --smart-toast-container-default-width: var(--smart-bar-width);\r\n    /* Default width of the smartToast's containers, positioned top-left, top-right, bottom-left, bottom-right */\r\n    --smart-toast-header-height: 20px;\r\n    /* smartToast header height */\r\n    --smart-toast-info-background: var(--smart-info);\r\n    /* Background color for type info */\r\n    --smart-toast-info-color: var(--smart-info-color);\r\n    /* Text color for type info */\r\n    --smart-toast-warning-background: var(--smart-warning);\r\n    /* Background color for type warning */\r\n    --smart-toast-warning-color: var(--smart-warning-color);\r\n    /* Text color for type warning */\r\n    --smart-toast-error-background: var(--smart-error);\r\n    /* Background color for type error */\r\n    --smart-toast-error-color: var(--smart-error-color);\r\n    /* Text color for type error */\r\n    --smart-toast-success-background: var(--smart-success);\r\n    /* Background color for type success */\r\n    --smart-toast-success-color: var(--smart-success-color);\r\n    /* Text color for type success */\r\n    /* Tree */\r\n    --smart-tree-default-width: var(--smart-box-width);\r\n    /* smartTree default width */\r\n    --smart-tree-default-height: var(--smart-box-height);\r\n    /* smartTree default height */\r\n    --smart-tree-scroll-button-size: 20px;\r\n    /* smartTree scroll buttons size */\r\n    --smart-tree-lines-style: dashed;\r\n    /* Default style of the connecting tree lines. */\r\n    --smart-tree-indent: 16px;\r\n    /* Defines the indent(hierarchy offset) size of the tree items. */\r\n    --smart-tree-lines-color: var(--smart-border);\r\n    /* Defines the color of the connecting lines. */\r\n    --smart-tree-lines-width: 1px;\r\n    /* Defines the width of the connecting lines. */\r\n    --smart-tree-item-label-height: 36px;\r\n    /* Defines the height of tree item labels. */\r\n    --smart-tree-item-padding: 9px 12px;\r\n    /* Defines the padding of the tree items. */\r\n    --smart-tree-item-vertical-offset: 3px;\r\n    /* Defines the vertical offset of the tree items. */\r\n    --smart-tree-item-horizontal-offset: 3px;\r\n    /* Defines the horizontal offset of the tree items. */\r\n    /* Text Box */\r\n    --smart-text-box-default-width: var(--smart-editor-width);\r\n    /* Text Box default width. */\r\n    --smart-text-box-default-height: var(--smart-editor-height);\r\n    /* Text Box default height. */\r\n    /* Validation panel */\r\n    --smart-validation-panel-description-width: 20%;\r\n    --smart-validation-panel-content-width: 80%;\r\n    /* Validation panel - appearance */\r\n    --smart-validation-panel-appearance-vertical-offset: 10px;\r\n    --smart-validation-panel-appearance-reset-button-left-offset: 5px;\r\n    --smart-validation-panel-appearance-textbox-vertical-offset: 5px;\r\n    --smart-validation-panel-appearance-reset-button-color: var(--smart-primary);\r\n    /* Validation panel - Criteria container */\r\n    --smart-validation-panel-criteria-row-margin-top: 10px;\r\n    --smart-validation-panel-criteria-container-vertical-offset: 10px;\r\n    --smart-validation-panel-criteria-container-input-width: 180px;\r\n    --smart-validation-panel-criteria-container-input-horizontal-offset: 2px;\r\n    --smart-validation-panel-criteria-container-textbox-width: 80px;\r\n    --smart-validation-panel-criteria-container-textbox-horizontal-offset: 2px;\r\n    --smart-validation-panel-criteria-container-text-between-inputs-offset: 5px;\r\n    /* Validation panel - Invalid data */\r\n    --smart-validation-panel-invalid-data-vertical-offset: 10px;\r\n    /* Validation panel - Footer */\r\n    --smart-validation-panel-footer-button-color: #188038;\r\n    --smart-validation-panel-footer-button-background: white;\r\n    --smart-validation-panel-footer-vertical-offset: 20px;\r\n    --smart-validation-panel-footer-button-horizontal-offset: 5px;\r\n    --smart-validation-panel-footer-remove-validation-button-color: var(--smart-validation-panel-footer-button-color);\r\n    --smart-validation-panel-footer-cancel-button-color: var(--smart-validation-panel-footer-button-color);\r\n    --smart-validation-panel-footer-save-button-color: var(--smart-validation-panel-footer-button-background);\r\n    --smart-validation-panel-footer-save-button-background: var(--smart-validation-panel-footer-button-color);\r\n    /*Password Text Box*/\r\n    --smart-password-text-box-default-width: var(--smart-editor-width);\r\n    /* smartPasswordTextBox default width */\r\n    --smart-password-text-box-default-height: var(--smart-editor-height);\r\n    /* smartPasswordTextBox default height */\r\n    /* Pager */\r\n    --smart-pager-default-width: var(--smart-bar-width);\r\n    /* default pager width */\r\n    --smart-pager-default-height: var(--smart-bar-height);\r\n    /* default pager height */\r\n    --smart-pager-button-width: 'auto';\r\n    /* default pager button width */\r\n    --smart-pager-button-height: 32px;\r\n    /* default pager button height */\r\n    --smart-pager-page-size-selector-width: 60px;\r\n    /* Default page size selector width. */\r\n    --smart-pager-page-index-selector-width: 32px;\r\n    /* default pager item width */\r\n    --smart-pager-page-index-selector-height: 32px;\r\n    /* default pager item height */\r\n    --smart-pager-page-index-ellipsis-selector-width: 32px;\r\n    /* default pager ellipsis width */\r\n    --smart-pager-page-index-ellipsis-selector-height: 32px;\r\n    /* default pager ellipsis width */\r\n    --smart-pager-page-index-selector-horizontal-offset: 8px;\r\n    /* default pager ellipsis width */\r\n    --smart-pager-padding: 2px;\r\n    /* Default padding. */\r\n    --smart-pager-input-width: 50px;\r\n    /* Default width of the pager input. */\r\n    /*ScrollViewer*/\r\n    --smart-scroll-viewer-min-width: none;\r\n    --smart-scroll-viewer-max-width: none;\r\n    --smart-scroll-viewer-min-height: none;\r\n    --smart-scroll-viewer-max-height: none;\r\n    /*Scheduler*/\r\n    --smart-scheduler-default-height: auto;\r\n    /* Sets the default height of the smartScheduler */\r\n    --smart-scheduler-default-width: auto;\r\n    /* Sets the default width of the smartScheduler */\r\n    --smart-scheduler-item-size: auto;\r\n    /* Sets the default size of the view selection items insinde the Timeline Header */\r\n    --smart-scheduler-timeline-cell-width: auto;\r\n    /* Sets the default width of the cells inside the Timeline  */\r\n    --smart-scheduler-timeline-cell-height: 50px;\r\n    /* Sets the default height of the cells inside the Timeline  */\r\n    --smart-scheduler-timeline-cell-min-width: 70px;\r\n    /* Sets the default min-width of the cells inside the Timeline */\r\n    --smart-scheduler-timeline-cell-min-height: 35px;\r\n    /* Sets the min-height of the cells inside the Timeline */\r\n    --smart-scheduler-header-height: 50px;\r\n    /* Sets the height of the header */\r\n    --smart-scheduler-header-today-button-size: 70px;\r\n    /* Scheduler header Today Button width */\r\n    --smart-scheduler-header-date-button-max-size: auto;\r\n    /* Sets the size of the Header Date Selection Button*/\r\n    --smart-scheduler-header-navigation-button-size: 30px;\r\n    /* Sets the size of the header buttons */\r\n    --smart-scheduler-footer-height: var(--smart-scheduler-header-height);\r\n    /* The height of the footer */\r\n    --smart-scheduler-header-box-shadow: initial;\r\n    /* Sets a Box shadow to the Timeline header */\r\n    --smart-scheduler-header-padding: 10px;\r\n    /* Sets a the padding for the header/footer */\r\n    --smart-scheduler-timeline-header-cell-padding: 5px;\r\n    /* Sets a the padding for the header/footer cells */\r\n    --smart-scheduler-header-menu-button-size: auto;\r\n    /* Sets the size for the Header menu button */\r\n    --smart-scheduler-timeline-weekend-color: var(--smart-background);\r\n    /* Sets the background color for the weekend cells */\r\n    --smart-scheduler-timeline-nonworking-color: var(--smart-gantt-chart-timeline-nonworking-color);\r\n    /* Sets the background color for nonworking days/hours cells */\r\n    --smart-scheduler-timeline-all-day-label-font-weight: 600;\r\n    /* Sets a the font-weight of the All day label */\r\n    --smart-scheduler-timeline-header-horizontal-cells-size: 40px;\r\n    /* Sets a the horizontal header cells size */\r\n    --smart-scheduler-timeline-header-horizontal-label-padding: initial;\r\n    /* Sets a the horizontal header cells label padding */\r\n    --smart-scheduler-timeline-header-horizontal-details-size: var(--smart-scheduler-timeline-header-horizontal-cells-size);\r\n    /* Sets the size of the Horizontal Details Header */\r\n    --smart-scheduler-timeline-header-horizontal-group-size: var(--smart-scheduler-timeline-header-horizontal-cells-size);\r\n    /* Sets the size of the Horizontal Group Header */\r\n    --smart-scheduler-timeline-header-vertical-cells-size: 100px;\r\n    /* Sets the vertical header cell size */\r\n    --smart-scheduler-timeline-header-vertical-label-padding: initial;\r\n    /* Sets the vertical header cells padding */\r\n    --smart-scheduler-timeline-header-vertical-details-size: var(--smart-scheduler-timeline-header-vertical-cells-size);\r\n    /* Sets the size of the Vertical Details Header */\r\n    --smart-scheduler-timeline-header-vertical-group-size: var(--smart-scheduler-timeline-header-vertical-cells-size);\r\n    /* Sets the size of the Vertical Group Header  */\r\n    --smart-scheduler-timeline-header-all-day-cells-size: 75px;\r\n    /* Sets the All Day View height */\r\n    --smart-scheduler-timeline-group-separator-background: var(--smart-outline);\r\n    /* Sets the color for the group separator */\r\n    --smart-scheduler-timeline-group-separator-size: var(--smart-border-width);\r\n    /* Sets the group cell separator size */\r\n    --smart-scheduler-timeline-group-white-space: nowrap;\r\n    /* Sets the white-space property for the Header Group cells */\r\n    --smart-scheduler-timeline-group-header-offset: calc(-50% - var(--smart-scheduler-timeline-header-cell-padding));\r\n    /* Sets the label offset for the header cells when groupByDate is enabled */\r\n    --smart-scheduler-current-time-indicator-background: var(--smart-primary);\r\n    /* Current Time Indicator background-color*/\r\n    --smart-scheduler-current-time-indicator-size: 1px;\r\n    /* Current Time Indicator size(width/height depending on the view orientation) */\r\n    --smart-scheduler-current-time-indicator-header-size: 2px;\r\n    /* Current Time Indicator size(width/height) inside the Headers */\r\n    --smart-scheduler-current-time-indicator-arrow-size: 7px;\r\n    /* Current Time Indicator arrow size */\r\n    --smart-scheduler-shader-background: rgba(var(--smart-border-rgb), .5);\r\n    /* Shade Until Current Time background */\r\n    --smart-scheduler-view-background: transparent;\r\n    --smart-scheduler-view-line-size: var(--smart-border-width);\r\n    /* Timeline lines size */\r\n    --smart-scheduler-view-horizontal-line-color: var(--smart-border);\r\n    /* Horizontal timeline line color */\r\n    --smart-scheduler-view-vertical-line-color: var(--smart-border);\r\n    /* Vertical timeline line color */\r\n    --smart-scheduler-day-week-view-vertical-line-size: var(--smart-scheduler-view-line-size);\r\n    /* Vertical line size in 'day' and 'week' views */\r\n    --smart-scheduler-day-week-view-vertical-line-color: var(--smart-border);\r\n    /* Vertical timeline color in 'day' and 'week' views */\r\n    --smart-scheduler-day-week-view-hour-size: var(--smart-scheduler-view-line-size);\r\n    /* Horizontal line size for 'day', 'week'. Only the hour lines (excluding minutes) */\r\n    --smart-scheduler-day-week-view-hour-color: var(--smart-border);\r\n    /* Horizontal line color for 'day', 'week' views. Only the hour lines ( excluding the minutes) */\r\n    --smart-scheduler-time-ruler-tick-size: 10px;\r\n    /* Time ruler tick size. Applicable only to day/week views */\r\n    --smart-scheduler-event-background-rgb: 52, 121, 186;\r\n    /* Event background RGB */\r\n    --smart-scheduler-event-background: rgba(var(--smart-scheduler-event-background-rgb), 1);\r\n    /* Event background color */\r\n    --smart-scheduler-legend-item-background: var(--smart-scheduler-event-background);\r\n    /* The default background color for the legen items */\r\n    --smart-scheduler-event-color: var(--smart-primary-color);\r\n    /* Event color */\r\n    --smart-scheduler-event-focus: rgba(var(--smart-scheduler-event-background-rgb), .9);\r\n    /* Event focus background color */\r\n    --smart-scheduler-event-color-focus: var(--smart-scheduler-event-color);\r\n    /* Event focus color */\r\n    --smart-scheduler-event-hover: rgba(var(--smart-scheduler-event-background-rgb), .8);\r\n    /* Event hover background color */\r\n    --smart-scheduler-event-color-hover: var(--smart-scheduler-event-color);\r\n    /* Event hover color */\r\n    --smart-scheduler-event-padding-agenda: 5px;\r\n    /* Event padding in 'agenda' view only */\r\n    --smart-scheduler-event-padding-basic: 2px;\r\n    /* Event padding in all basic views */\r\n    --smart-scheduler-event-padding-timeline: 2px;\r\n    /* Event padding in all timeline views */\r\n    --smart-scheduler-event-padding-all-day: 2px;\r\n    /* Event padding for events inside AllDay container */\r\n    --smart-scheduler-event-content-padding: 5px;\r\n    /* Event content padding */\r\n    --smart-scheduler-event-label-font-size: var(--smart-font-size);\r\n    /* Event label font size */\r\n    --smart-scheduler-event-time-font-size: calc(var(--smart-font-size) - 3px);\r\n    /* Event time label font size */\r\n    --smart-scheduler-event-time-font-size-agenda: var(--smart-font-size);\r\n    /* Event time font size for 'agenda' view */\r\n    --smart-scheduler-event-time-font-weight-agenda: 600;\r\n    /* Event time label font weight for 'agenda' view */\r\n    --smart-scheduler-event-time-opacity-agenda: 1;\r\n    /* Event time label opacity for 'agenda' view */\r\n    --smart-scheduler-event-time-opacity: 0.7;\r\n    /* Event time label opacity */\r\n    --smart-scheduler-event-icon-size: 30px;\r\n    /* Event icon (repeating, exception icon) size */\r\n    --smart-scheduler-event-size: 30px;\r\n    /* Sets the size of the timeline events in all views. Main variable. Used this variable to change the size of the events. Used by the Scheduler internally !*/\r\n    --smart-scheduler-event-size-basic: var(--smart-scheduler-event-size);\r\n    /* Sets the size of the events only in Basic views */\r\n    --smart-scheduler-event-size-timeline: 60px;\r\n    /* Sests the size of the events only in Timeline views. Should only be in pixels. Do not use calc()! */\r\n    --smart-scheduler-event-collector-size: 24px;\r\n    /* Event collector size */\r\n    --smart-scheduler-event-collector-mobile-size: 28px;\r\n    /* Event collector size on mobile */\r\n    --smart-scheduler-event-collector-background: rgba(var(--smart-primary-rgb), 1);\r\n    /* Event collector background color */\r\n    --smart-scheduler-event-collector-color: var(--smart-primary-color);\r\n    /* Event collector color */\r\n    --smart-scheduler-event-collector-focus: rgba(var(--smart-primary-rgb), .9);\r\n    /* Event collector background color on focus */\r\n    --smart-scheduler-event-collector-color-focus: var(--smart-scheduler-event-collector-color);\r\n    /* Event collector color on focus */\r\n    --smart-scheduler-event-collector-hover: rgba(var(--smart-primary-rgb), .8);\r\n    /* Event collector background colot on hover */\r\n    --smart-scheduler-event-collector-color-hover: var(--smart-scheduler-event-collector-color);\r\n    /* Event collector color on hover */\r\n    --smart-scheduler-month-view-number-size: 24px;\r\n    /* The size of the day number in month view */\r\n    --smart-scheduler-status-size: 7px;\r\n    /* The size of the day number in month view */\r\n    --smart-scheduler-status-padding: 5px;\r\n    /* The paddng between the content of the event and the satus strip */\r\n    --smart-scheduler-status-background: transparent;\r\n    /* The size of the day number in month view */\r\n    --smart-scheduler-status-free-background: white;\r\n    /* Event Status 'free' background color */\r\n    --smart-scheduler-status-tentative-background: 0 -244rem / 5rem 5rem linear-gradient(45deg, #fd7e14 25%, rgba(0, 0, 0, .2) 25%, rgba(0, 0, 0, .2) 50%, #fd7e14 50%, #fd7e14 75%, rgba(0, 0, 0, .2) 75%, rgba(0, 0, 0, .2));\r\n    /* Event status 'tentative' background color */\r\n    --smart-scheduler-status-busy-background: #dc3545;\r\n    /* Event status 'busy' background color */\r\n    --smart-scheduler-status-out-of-office-background: #00a9e6;\r\n    /* Event status 'out-of-office' background color */\r\n    --smart-scheduler-cell-feedback-background: transparent;\r\n    /* Cell feedback background color on event drop  */\r\n    --smart-scheduler-event-resize-indicator-size: var(--smart-gantt-chart-timeline-task-resize-indicator-width);\r\n    /* Event resize indicator size */\r\n    --smart-scheduler-event-resize-indicator-color: var(--smart-gantt-chart-timeline-task-resize-indicator-color);\r\n    /* Event resize indicator color */\r\n    --smart-scheduler-event-resize-indicator-border-color: var(--smart-gantt-chart-timeline-task-resize-indicator-border-color);\r\n    /* Event resize indicator border color */\r\n    --smart-scheduler-restricted-background: 0 -245rem / 12px 12px linear-gradient(135deg, rgba(255, 0, 0, .15) 25%, transparent 25%, transparent 50%, rgba(255, 0, 0, .15) 50%, rgba(255, 0, 0, .15) 75%, transparent 75%, transparent);\r\n    /* Restricted cells background color */\r\n    --smart-scheduler-event-item-size: 50px;\r\n    /* Event menu item size(height) */\r\n    --smart-scheduler-event-button-size: 30px;\r\n    /* Event menu item button size(delete button) */\r\n    --smart-scheduler-event-border-radius: initial;\r\n    /* Event border radius */\r\n    --smart-scheduler-event-collector-border-radius: 20px;\r\n    /* Event collector border radius */\r\n    --smart-scheduler-context-menu-max-height: calc(4 * var(--smart-scheduler-event-item-size));\r\n    /* Context menu max-height */\r\n    --smart-scheduler-context-menu-max-width: 300px;\r\n    /* Context menu max-width */\r\n    --smart-scheduler-window-header-height: var(--smart-gantt-chart-popup-window-header-height);\r\n    /* Window editor header height */\r\n    --smart-scheduler-window-footer-height: var(--smart-gantt-chart-popup-window-footer-height);\r\n    /* Window editor footer height */\r\n    --smart-scheduler-event-label-font-weight: 300;\r\n    /* Event label font weight */\r\n    --smart-scheduler-event-time-font-weight: 300;\r\n    /* Event time label font weight */\r\n    --smart-scheduler-event-item-label-font-weight: 600;\r\n    /* Event menu item label font-weight */\r\n    --smart-scheduler-toast-default-width: 400px;\r\n    /* Toast(notifications) default width */\r\n    --smart-scheduler-toast-default-height: 50px;\r\n    /* Toast(notifications) default height */\r\n    --smart-scheduler-shortcut-size: 28px;\r\n    /* The width of the shortuct of the view items when placed inside a drop down */\r\n    /*Window*/\r\n    --smart-window-default-height: var(--smart-box-height);\r\n    /* smartWindow default height */\r\n    --smart-window-default-width: var(--smart-box-width);\r\n    /* smartWindow default width */\r\n    --smart-window-header-height: var(--smart-bar-height);\r\n    /* smartWindow header height */\r\n    --smart-window-footer-height: var(--smart-bar-height);\r\n    /* smartWindow footer height */\r\n    --smart-window-min-width: 250px;\r\n    /* smartWindow header width */\r\n    --smart-window-header-padding: 10px;\r\n    /* smartWindow header and footer padding */\r\n    --smart-window-footer-padding: 6.5px;\r\n    /* smartWindow header and footer padding */\r\n    --smart-window-header-button-size: 24px;\r\n    /* Sets the size of the header buttons */\r\n    --smart-window-header-icon-size: var(--smart-font-size);\r\n    /* Sets the size of the header button icons */\r\n    --smart-window-header-background: var(--smart-surface);\r\n    /* Sets the background of the header section */\r\n    --smart-window-footer-background: var(--smart-surface);\r\n    /* Sets the size of the background of the footer section */\r\n    --smart-window-footer-button-width: 100px;\r\n    /* Sets the width of the footer buttons */\r\n    --smart-window-content-padding: 10px;\r\n    /* Sets the content section padding */\r\n    /*Elevations*/\r\n    --smart-elevation-24: 0 24px 38px 3px rgba(0, 0, 0, .14), 0 9px 46px 8px rgba(0, 0, 0, .12), 0 11px 15px 0 rgba(0, 0, 0, .2);\r\n    --smart-elevation-16: 0 16px 24px 2px rgba(0, 0, 0, .14), 0 6px 30px 5px rgba(0, 0, 0, .12), 0 8px 10px 0 rgba(0, 0, 0, .2);\r\n    --smart-elevation-12: 0 12px 17px 2px rgba(0, 0, 0, .14), 0 5px 22px 4px rgba(0, 0, 0, .12), 0 7px 8px 0 rgba(0, 0, 0, .2);\r\n    --smart-elevation-8: 0 8px 10px 1px rgba(0, 0, 0, .14), 0 3px 14px 3px rgba(0, 0, 0, .12), 0 4px 15px 0 rgba(0, 0, 0, .2);\r\n    --smart-elevation-6: 0 6px 10px 0 rgba(0, 0, 0, .14), 0 1px 18px 0 rgba(0, 0, 0, .12), 0 3px 5px 0 rgba(0, 0, 0, .2);\r\n    --smart-elevation-4: 0 2px 4px 0 rgba(0, 0, 0, .14), 0 4px 5px 0 rgba(0, 0, 0, .12), 0 1px 10px 0 rgba(0, 0, 0, .2);\r\n    --smart-elevation-2: 0 3px 1px -2px rgba(0, 0, 0, .2), 0 2px 2px 0 rgba(0, 0, 0, .14), 0 1px 5px 0 rgba(0, 0, 0, .12);\r\n    --smart-elevation-1: 0 0 2px 0 rgba(0, 0, 0, .14), 0 2px 2px 0 rgba(0, 0, 0, .12), 0 1px 3px 0 rgba(0, 0, 0, .2);\r\n    --smart-elevation-0: none;\r\n    /* Breakpoints */\r\n    --breakpoint-xs: 0;\r\n    --breakpoint-sm: 576px;\r\n    --breakpoint-md: 768px;\r\n    --breakpoint-lg: 992px;\r\n    --breakpoint-xl: 1200px;\r\n    /*Misc*/\r\n    --pseudo-element-height: 0;\r\n}\r\n\r\nbody[theme=\"dark\"],\r\n.smart-ui-component[theme=\"dark\"] {\r\n    --smart-primary-rgb: 122, 202, 255;\r\n    --smart-primary: rgb(var(--smart-primary-rgb));\r\n    /* The theme primary color */\r\n    --smart-primary-color: #242424;\r\n    --smart-background: #242424;\r\n    /* The theme background color. The background color appears behind scrollable content.*/\r\n    --smart-background-color: #fff;\r\n    /* Text color on top of a background background */\r\n    --smart-surface: #333;\r\n    /* The theme surface color. Surface colors affect surfaces of components, such as cards, sheets, and menus. */\r\n    --smart-surface-color: #fff;\r\n    /* Text color on top of a surface surface */\r\n    --smart-disabled: #535353;\r\n    /* The theme primary color in disabled state. */\r\n    --smart-disabled-color: #fff;\r\n    /* Text color on top of a theme background in disabled state */\r\n    --smart-border: #464646;\r\n    /* The theme background border color */\r\n    --smart-editor-selection: var(--smart-primary);\r\n    --smart-editor-selection-color: var(--smart-primary-color);\r\n    --smart-ui-state-hover: #444;\r\n    --smart-ui-state-color-hover: #fff;\r\n    --smart-ui-state-border-hover: var(--smart-ui-state-hover);\r\n    --smart-ui-state-active: var(--smart-primary);\r\n    --smart-ui-state-color-active: var(--smart-primary-color);\r\n    --smart-ui-state-border-active: var(--smart-primary);\r\n    --smart-ui-state-focus: #555;\r\n    --smart-ui-state-color-focus: #fff;\r\n    --smart-ui-state-border-focus: #555;\r\n    --smart-ui-state-selected: rgba(var(--smart-primary-rgb), .1);\r\n    --smart-ui-state-color-selected: var(--smart-primary);\r\n    --smart-ui-state-border-selected: rgba(var(--smart-primary-rgb), .1);\r\n    --smart-alternation-index0-color: var(--smart-surface-color);\r\n    /* Alternation color for index0 */\r\n    --smart-alternation-index0-border: var(--smart-surface);\r\n    /* Alternation border color for index0 */\r\n    --smart-alternation-index0-background: var(--smart-surface);\r\n    /* Alternation background color for index0 */\r\n    --smart-alternation-index1-color: #111;\r\n    /*Alternation color for index1 */\r\n    --smart-alternation-index1-border: #9BBB59;\r\n    /* Alternation border color for index1 */\r\n    --smart-alternation-index1-background: #9BBB59;\r\n    /* Alternation background color for index1 */\r\n    --smart-alternation-index2-color: #fff;\r\n    /*Alternation color for index2 */\r\n    --smart-alternation-index2-border: #FC3752;\r\n    /* Alternation border color for index2 */\r\n    --smart-alternation-index2-background: #FC3752;\r\n    /* Alternation background color for index2 */\r\n    --smart-grid-cell-background-freeze: #242424;\r\n    --smart-grid-cell-color-freeze: #fff;\r\n    --smart-scroll-bar-background: #3E3E42;\r\n    --smart-scroll-bar-track-background: var(--smart-scroll-bar-background);\r\n    --smart-scroll-bar-border: #3E3E42;\r\n    --smart-scroll-bar-thumb-background: #686868;\r\n    --smart-scroll-bar-thumb-border: #686868;\r\n    --smart-scroll-bar-thumb-background-hover: #9E9E9E;\r\n    --smart-scroll-bar-thumb-border-hover: #9E9E9E;\r\n    --smart-scroll-bar-thumb-background-active: #444;\r\n    --smart-scroll-bar-thumb-border-active: #444;\r\n    --smart-scroll-bar-button-background: #3E3E42;\r\n    --smart-scroll-bar-button-border: #3E3E42;\r\n    --smart-scroll-bar-button-color: #999999;\r\n    --smart-scroll-bar-button-background-hover: #3E3E42;\r\n    --smart-scroll-bar-button-border-hover: #3E3E42;\r\n    --smart-scroll-bar-button-color-hover: var(--smart-primary);\r\n    --smart-scroll-bar-button-background-active: #3E3E42;\r\n    --smart-scroll-bar-button-border-active: #3E3E42;\r\n    --smart-scroll-bar-button-color-active: var(--smart-primary);\r\n    --smart-gantt-chart-timeline-nonworking-color: #3E3E42;\r\n    --smart-scheduler-timeline-weekend-color: var(--smart-background);\r\n    /* Sets the background color for the weekend cells */\r\n    --smart-scheduler-timeline-nonworking-color: var(--smart-gantt-chart-timeline-nonworking-color);\r\n    /* Sets the background color for nonworking days/hours cells */\r\n    --smart-scheduler-event-background-rgb: 103, 176, 245;\r\n    --smart-scheduler-event-background: rgba(var(--smart-scheduler-event-background-rgb), 1);\r\n    --smart-scheduler-event-color: var(--smart-primary-color);\r\n    --smart-scheduler-event-focus: rgba(var(--smart-scheduler-event-background-rgb), .9);\r\n    --smart-scheduler-event-color-focus: var(--smart-scheduler-event-color);\r\n    --smart-scheduler-event-hover: rgba(var(--smart-scheduler-event-background-rgb), .8);\r\n    --smart-scheduler-event-color-hover: var(--smart-scheduler-event-color);\r\n    --smart-scheduler-event-collector-background: rgba(var(--smart-primary-rgb), 1);\r\n    --smart-scheduler-event-collector-color: var(--smart-primary-color);\r\n    --smart-scheduler-event-collector-focus: rgba(var(--smart-primary-rgb), .9);\r\n    --smart-scheduler-event-collector-color-focus: var(--smart-scheduler-event-collector-color);\r\n    --smart-scheduler-event-collector-hover: rgba(var(--smart-primary-rgb), .8);\r\n    --smart-scheduler-event-collector-color-hover: var(--smart-scheduler-event-collector-color);\r\n    --smart-scheduler-status-free-background: white;\r\n    --smart-scheduler-status-tentative-background: 0 -244rem / 5rem 5rem linear-gradient(45deg, #fd7e14 25%, rgba(0, 0, 0, .2) 25%, rgba(0, 0, 0, .2) 50%, #fd7e14 50%, #fd7e14 75%, rgba(0, 0, 0, .2) 75%, rgba(0, 0, 0, .2));\r\n    --smart-scheduler-status-busy-background: #dc3545;\r\n    --smart-scheduler-status-out-of-office-background: #00a9e6;\r\n    --smart-scheduler-event-resize-indicator-color: var(--smart-gantt-chart-timeline-task-resize-indicator-color);\r\n    --smart-scheduler-event-resize-indicator-border-color: var(--smart-gantt-chart-timeline-task-resize-indicator-border-color);\r\n    --smart-scheduler-restricted-background: 0 -245rem / 12px 12px linear-gradient(135deg, rgba(255, 0, 0, .15) 25%, transparent 25%, transparent 50%, rgba(255, 0, 0, .15) 50%, rgba(255, 0, 0, .15) 75%, transparent 75%, transparent);\r\n}",""]);const s=i},5146:(e,t,r)=>{"use strict";r.d(t,{Z:()=>s});var n=r(8081),o=r.n(n),a=r(3645),i=r.n(a)()(o());i.push([e.id,'smart-window:not([opened]) {\r\n  opacity: 0; }\r\n\r\n/* smart-window */\r\n.smart-window {\r\n  /* .smart-wait-window */ }\r\n  .smart-window:not(.smart-container) {\r\n    position: absolute;\r\n    top: calc(50% - var(--smart-window-default-height) / 2);\r\n    left: calc(50% - var(--smart-window-default-width) / 2);\r\n    width: var(--smart-window-default-width);\r\n    height: var(--smart-window-default-height);\r\n    min-width: var(--smart-window-min-width);\r\n    min-height: var(--smart-window-header-height);\r\n    box-shadow: var(--smart-elevation-24);\r\n    z-index: calc(var(--smart-editor-drop-down-z-index) - 1);\r\n    display: block;\r\n    overflow: hidden; }\r\n  .smart-window > .smart-container:not(.smart-window) {\r\n    max-height: inherit; }\r\n  .smart-window .smart-content-container {\r\n    display: flex;\r\n    flex-direction: column;\r\n    font-family: inherit;\r\n    font-size: inherit;\r\n    width: 100%;\r\n    height: 100%;\r\n    outline: none;\r\n    max-height: inherit; }\r\n    .smart-window .smart-content-container > .smart-header-section {\r\n      display: flex;\r\n      justify-content: space-between;\r\n      cursor: move;\r\n      overflow: hidden;\r\n      align-items: center;\r\n      touch-action: none;\r\n      width: 100%;\r\n      font-family: inherit;\r\n      font-size: inherit;\r\n      user-select: none;\r\n      -webkit-user-select: none;\r\n      -ms-user-select: none;\r\n      -moz-user-select: none;\r\n      border-color: var(--smart-border);\r\n      color: var(--smart-surface-color);\r\n      line-height: initial;\r\n      height: var(--smart-window-header-height);\r\n      min-height: var(--smart-window-header-height);\r\n      background: var(--smart-window-header-background);\r\n      padding: var(--smart-window-header-padding); }\r\n      .smart-window .smart-content-container > .smart-header-section > .smart-buttons-container {\r\n        height: 100%;\r\n        display: flex;\r\n        justify-content: center;\r\n        align-items: center; }\r\n        .smart-window .smart-content-container > .smart-header-section > .smart-buttons-container button {\r\n          position: relative;\r\n          margin-left: 1px;\r\n          margin-right: 1px;\r\n          cursor: pointer;\r\n          height: var(--smart-window-header-button-size);\r\n          width: var(--smart-window-header-button-size);\r\n          padding: 0;\r\n          min-height: 0;\r\n          background: transparent;\r\n          color: inherit;\r\n          border: none;\r\n          outline: none; }\r\n          .smart-window .smart-content-container > .smart-header-section > .smart-buttons-container button:active {\r\n            outline: none;\r\n            background-color: initial; }\r\n    .smart-window .smart-content-container > .smart-content {\r\n      width: 100%;\r\n      height: calc(100% - var(--smart-window-header-height));\r\n      display: flex;\r\n      align-items: center;\r\n      overflow-y: auto;\r\n      padding: var(--smart-window-content-padding);\r\n      background: var(--smart-background);\r\n      flex-direction: column;\r\n      /* There\'s an issue with display:flex/grid and align-items: center */ }\r\n      @media not all and (min-resolution: 0.001dpcm) {\r\n        .smart-window .smart-content-container > .smart-content {\r\n          align-content: start; } }\r\n    .smart-window .smart-content-container > .smart-footer {\r\n      width: 100%;\r\n      min-height: var(--smart-window-footer-height);\r\n      font-family: inherit;\r\n      font-size: inherit;\r\n      user-select: none;\r\n      -webkit-user-select: none;\r\n      -ms-user-select: none;\r\n      -moz-user-select: none;\r\n      border-color: var(--smart-border);\r\n      color: var(--smart-surface-color);\r\n      line-height: initial;\r\n      position: relative;\r\n      background-color: initial;\r\n      display: flex;\r\n      justify-content: center;\r\n      height: var(--smart-window-footer-height);\r\n      background: var(--smart-window-footer-background);\r\n      padding: var(--smart-window-footer-padding); }\r\n      .smart-window .smart-content-container > .smart-footer:empty {\r\n        display: none; }\r\n    .smart-window .smart-content-container.smart-window-resizing-left, .smart-window .smart-content-container.smart-window-resizing-right, .smart-window .smart-content-container.smart-window-resizing-left > .smart-header-section, .smart-window .smart-content-container.smart-window-resizing-right > .smart-header-section {\r\n      cursor: e-resize; }\r\n    .smart-window .smart-content-container.smart-window-resizing-top, .smart-window .smart-content-container.smart-window-resizing-bottom, .smart-window .smart-content-container.smart-window-resizing-top > .smart-header-section, .smart-window .smart-content-container.smart-window-resizing-bottom > .smart-header-section {\r\n      cursor: ns-resize; }\r\n    .smart-window .smart-content-container.smart-window-resizing-top-left, .smart-window .smart-content-container.smart-window-resizing-bottom-right, .smart-window .smart-content-container.smart-window-resizing-top-left > .smart-header-section, .smart-window .smart-content-container.smart-window-resizing-bottom-right > .smart-header-section {\r\n      cursor: se-resize; }\r\n    .smart-window .smart-content-container.smart-window-resizing-top-right, .smart-window .smart-content-container.smart-window-resizing-bottom-left, .smart-window .smart-content-container.smart-window-resizing-top-right > .smart-header-section, .smart-window .smart-content-container.smart-window-resizing-bottom-left > .smart-header-section {\r\n      cursor: sw-resize; }\r\n  .smart-window .smart-header-section > .smart-buttons-container button:after {\r\n    position: absolute;\r\n    top: 0;\r\n    font-family: var(--smart-font-family-icon);\r\n    font-size: var(--smart-window-header-icon-size);\r\n    width: 100%;\r\n    height: 100%;\r\n    text-align: center;\r\n    display: flex;\r\n    align-items: center;\r\n    justify-content: center;\r\n    pointer-events: none; }\r\n  .smart-window .smart-header-section > .smart-buttons-container button:first-of-type {\r\n    margin-left: initial; }\r\n  .smart-window .smart-header-section > .smart-buttons-container button:last-of-type {\r\n    margin-right: initial; }\r\n  .smart-window .smart-header-section > .smart-buttons-container button.hover {\r\n    color: initial;\r\n    background-color: initial; }\r\n  .smart-window .smart-header-section .smart-close-button:after {\r\n    content: var(--smart-icon-close); }\r\n  .smart-window .smart-header-section .smart-collapse-button:after {\r\n    content: var(--smart-icon-arrow-down); }\r\n  .smart-window .smart-header-section .smart-maximize-button:after {\r\n    content: var(--smart-icon-window-maximize); }\r\n  .smart-window .smart-header-section .smart-pin-button:after {\r\n    content: var(--smart-icon-window-pin); }\r\n  .smart-window .smart-header-section .smart-minimize-button:after {\r\n    content: var(--smart-icon-window-minimize); }\r\n  .smart-window:focus, .smart-window[focus] {\r\n    outline: none;\r\n    border-color: var(--smart-primary);\r\n    box-shadow: var(--smart-elevation-24); }\r\n    .smart-window:focus .smart-content-container > .smart-header-section, .smart-window[focus] .smart-content-container > .smart-header-section {\r\n      background-color: var(--smart-primary);\r\n      color: var(--smart-primary-color); }\r\n  .smart-window[ontop] {\r\n    z-index: var(--smart-editor-drop-down-z-index); }\r\n  .smart-window:not([animation=\'none\']) {\r\n    transition: width 0.2s cubic-bezier(0.4, 0, 0.2, 1), height 0.25s cubic-bezier(0.4, 0, 0.2, 1), top 0.2s cubic-bezier(0.4, 0, 0.6, 1), left 0.2s cubic-bezier(0.4, 0, 0.6, 1), transform 0.2s cubic-bezier(0.4, 0, 0.2, 1), visibility 0.2s cubic-bezier(0.4, 0, 0.2, 1), min-height 0.25s cubic-bezier(0.4, 0, 0.2, 1), min-width 0.25s cubic-bezier(0.4, 0, 0.2, 1), opacity 0.25s cubic-bezier(0.4, 0, 0.2, 1);\r\n    transform: scale(1); }\r\n    .smart-window:not([animation=\'none\']) .smart-header-section .smart-collapse-button:after {\r\n      transition: transform 0.15s linear; }\r\n    .smart-window:not([animation=\'none\']) .smart-header-section .smart-pin-button:after {\r\n      transition: transform 0.15s linear; }\r\n    .smart-window:not([animation=\'none\']).no-transition, .smart-window:not([animation=\'none\']).no-transition.smart-visibility-hidden {\r\n      transition: none; }\r\n    .smart-window:not([animation=\'none\']).smart-visibility-hidden, .smart-window:not([animation=\'none\']).smart-visibility-hidden[maximized] {\r\n      transition: width 0.2s cubic-bezier(0.4, 0, 0.2, 1), height 0.2s cubic-bezier(0.4, 0, 0.2, 1), top 0.2s cubic-bezier(0.4, 0, 0.2, 1), left 0.2s cubic-bezier(0.4, 0, 0.2, 1), visibility 0.2s cubic-bezier(0.4, 0, 0.6, 1), transform 0.2s cubic-bezier(0.4, 0, 0.6, 1), min-height 0.25s cubic-bezier(0.4, 0, 0.2, 1), min-width 0.25s cubic-bezier(0.4, 0, 0.2, 1), opacity 0.25s cubic-bezier(0.4, 0, 0.2, 1);\r\n      transform: scale(0); }\r\n    .smart-window:not([animation=\'none\'])[dragged] {\r\n      opacity: 0.5;\r\n      z-index: calc(1 + var(--smart-editor-drop-down-z-index));\r\n      transition: none; }\r\n    .smart-window:not([animation=\'none\'])[minimized] {\r\n      transition: width 0.2s cubic-bezier(0.4, 0, 0.2, 1), height 0.2s cubic-bezier(0.4, 0, 0.2, 1), top 0.2s cubic-bezier(0.4, 0, 0.2, 1), left 0.2s cubic-bezier(0.4, 0, 0.2, 1), animation 0.2s cubic-bezier(0.4, 0, 0.6); }\r\n  .smart-window.smart-visibility-hidden {\r\n    transform: scale(0); }\r\n  .smart-window.smart-tabs-window[collapsed][header-position="left"], .smart-window.smart-tabs-window[collapsed][header-position="right"], .smart-window.smart-tabs-window[maximized][collapsed][header-position="right"], .smart-window.smart-tabs-window[maximized][collapsed][header-position="left"] {\r\n    width: var(--smart-window-header-height);\r\n    min-width: initial;\r\n    height: var(--smart-window-default-height); }\r\n  .smart-window.smart-tabs-window[dragged] {\r\n    pointer-events: none;\r\n    /* Need a way to detect what\'s under the header while dragging. That\'s why pointer-events is used ! */ }\r\n    .smart-window.smart-tabs-window[dragged] .smart-tabs-header-section,\r\n    .smart-window.smart-tabs-window[dragged] .smart-tab-label-container {\r\n      cursor: move; }\r\n  .smart-window.smart-tabs-window .smart-content-container > .smart-content {\r\n    width: 100%;\r\n    height: calc(100% - var(--smart-window-header-height));\r\n    overflow: hidden;\r\n    padding: 0;\r\n    background-color: var(--smart-background); }\r\n  .smart-window.smart-tabs-window .smart-content-container > .smart-header-section.smart-hidden,\r\n  .smart-window.smart-tabs-window .smart-content-container > .smart-footer.smart-hidden {\r\n    display: none; }\r\n  .smart-window.smart-tabs-window[dragged] .smart-content-container > .smart-header-section, .smart-window.smart-tabs-window[focus] .smart-content-container > .smart-header-section, .smart-window.smart-tabs-window[active] .smart-content-container > .smart-header-section {\r\n    background-color: var(--smart-primary);\r\n    color: var(--smart-primary-color); }\r\n  .smart-window.smart-tabs-window smart-tabs {\r\n    width: 100%;\r\n    height: 250px;\r\n    min-height: 100%;\r\n    border: initial;\r\n    outline: none;\r\n    padding: 0; }\r\n    .smart-window.smart-tabs-window smart-tabs .smart-tabs-header-items {\r\n      /*width: calc(100% - var(--smart-tabs-header-controls-size));*/\r\n      width: 100%; }\r\n    .smart-window.smart-tabs-window smart-tabs .smart-tabs-header-items {\r\n      width: 100%; }\r\n    .smart-window.smart-tabs-window smart-tabs[vertical] .smart-tabs-header-items {\r\n      width: auto;\r\n      height: 100%; }\r\n  .smart-window.smart-tabs-window .smart-tabs .smart-header {\r\n    border: none; }\r\n  .smart-window.smart-tabs-window .smart-tabs-content-section {\r\n    margin: initial;\r\n    border: none; }\r\n  .smart-window.smart-tabs-window[auto-hide] {\r\n    overflow: visible;\r\n    height: auto;\r\n    min-height: 0; }\r\n    .smart-window.smart-tabs-window[auto-hide] .smart-tabs-content-section,\r\n    .smart-window.smart-tabs-window[auto-hide] .smart-content-container > .smart-header-section {\r\n      display: none; }\r\n    .smart-window.smart-tabs-window[auto-hide] .smart-tabs {\r\n      min-width: 0;\r\n      height: auto;\r\n      min-height: 0; }\r\n    .smart-window.smart-tabs-window[auto-hide] .smart-content-container > .smart-content {\r\n      overflow: visible; }\r\n    .smart-window.smart-tabs-window[auto-hide] .smart-window {\r\n      width: auto;\r\n      height: auto; }\r\n    .smart-window.smart-tabs-window[auto-hide][tab-position="left"], .smart-window.smart-tabs-window[auto-hide][tab-position="right"], .smart-window.smart-tabs-window[auto-hide][tab-text-orientation="horizontal"][tab-position="left"], .smart-window.smart-tabs-window[auto-hide][tab-text-orientation="horizontal"][tab-position="right"], .smart-window.smart-tabs-window[auto-hide][tab-position="left"] smart-tabs, .smart-window.smart-tabs-window[auto-hide][tab-position="right"] smart-tabs, .smart-window.smart-tabs-window[auto-hide][tab-text-orientation="horizontal"][tab-position="left"] smart-tabs, .smart-window.smart-tabs-window[auto-hide][tab-text-orientation="horizontal"][tab-position="right"] smart-tab, .smart-window.smart-tabs-window[auto-hide][tab-text-orientation="vertical"][tab-position="left"], .smart-window.smart-tabs-window[auto-hide][tab-text-orientation="vertical"][tab-position="right"], .smart-window.smart-tabs-window[auto-hide][tab-text-orientation="vertical"][tab-position="left"] smart-tabs, .smart-window.smart-tabs-window[auto-hide][tab-text-orientation="vertical"][tab-position="right"] smart-tabs {\r\n      width: auto;\r\n      min-width: 0; }\r\n  .smart-window.smart-tabs-window[tab-position="hidden"] .smart-content-container > .smart-content {\r\n    height: 100%; }\r\n  .smart-window.smart-tabs-window smart-tab-item {\r\n    padding: 5px;\r\n    user-select: text;\r\n    -webkit-user-select: text; }\r\n  .smart-window[minimized] {\r\n    max-width: var(--smart-window-min-width);\r\n    min-height: var(--smart-window-header-height);\r\n    cursor: default; }\r\n    .smart-window[minimized] .smart-content-container > .smart-header-section {\r\n      cursor: default; }\r\n    .smart-window[minimized] .smart-content-container > .smart-content {\r\n      padding: initial; }\r\n    .smart-window[minimized] .smart-minimize-button:after {\r\n      content: var(--smart-icon-arrow-up-alt);\r\n      transform: rotate(-45deg);\r\n      margin-top: -1px; }\r\n  .smart-window[maximized] .smart-content-container > .smart-header-section {\r\n    cursor: initial; }\r\n  .smart-window[maximized] .smart-header-section .smart-maximize-button:after {\r\n    content: var(--smart-icon-window-restore);\r\n    font-size: 100%; }\r\n  .smart-window[maximized].smart-visibility-hidden {\r\n    transform: scale(0); }\r\n  .smart-window[pinned] .smart-content-container > .smart-header-section {\r\n    cursor: default; }\r\n  .smart-window[pinned] .smart-header-section .smart-pin-button:after {\r\n    content: var(--smart-icon-window-pin);\r\n    transform: rotate(-45deg); }\r\n  .smart-window[disabled] .smart-header-section > .smart-buttons-container button {\r\n    cursor: initial; }\r\n  .smart-window[collapsed] {\r\n    height: var(--smart-window-header-height); }\r\n    .smart-window[collapsed] .smart-header-section .smart-collapse-button:after {\r\n      transform: rotate(180deg) translateY(1px); }\r\n    .smart-window[collapsed] .smart-content-container.smart-window-resizing-top-left, .smart-window[collapsed] .smart-content-container.smart-window-resizing-top-right, .smart-window[collapsed] .smart-content-container.smart-window-resizing-bottom-left, .smart-window[collapsed] .smart-content-container.smart-window-resizing-bottom-right, .smart-window[collapsed] .smart-content-container.smart-window-resizing-top-left > .smart-header-section, .smart-window[collapsed] .smart-content-container.smart-window-resizing-top-right > .smart-header-section, .smart-window[collapsed] .smart-content-container.smart-window-resizing-bottom-left > .smart-header-section, .smart-window[collapsed] .smart-content-container.smart-window-resizing-bottom-right > .smart-header-section {\r\n      cursor: initial; }\r\n    .smart-window[collapsed].smart-window-snapped-left, .smart-window[collapsed].smart-window-snapped-right, .smart-window[collapsed].smart-window-snapped-top {\r\n      height: var(--smart-window-header-height); }\r\n    .smart-window[collapsed][header-position="top"].smart-window-snapped-left, .smart-window[collapsed][header-position="top"].smart-window-snapped-right, .smart-window[collapsed][header-position="top"].smart-window-snapped-top, .smart-window[collapsed][header-position="bottom"].smart-window-snapped-left, .smart-window[collapsed][header-position="bottom"].smart-window-snapped-right, .smart-window[collapsed][header-position="bottom"].smart-window-snapped-top {\r\n      height: var(--smart-window-header-height); }\r\n    .smart-window[collapsed][header-position="left"] .smart-content-container > .smart-header-section,\r\n    .smart-window[collapsed][header-position="left"] .smart-content-container > .smart-footer, .smart-window[collapsed][header-position="right"] .smart-content-container > .smart-header-section,\r\n    .smart-window[collapsed][header-position="right"] .smart-content-container > .smart-footer {\r\n      min-width: var(--smart-window-header-height); }\r\n    .smart-window[collapsed][header-position="left"].smart-window-snapped-left, .smart-window[collapsed][header-position="left"].smart-window-snapped-right, .smart-window[collapsed][header-position="left"].smart-window-snapped-top, .smart-window[collapsed][header-position="right"].smart-window-snapped-left, .smart-window[collapsed][header-position="right"].smart-window-snapped-right, .smart-window[collapsed][header-position="right"].smart-window-snapped-top {\r\n      height: 100%;\r\n      width: var(--smart-window-header-height);\r\n      min-width: initial; }\r\n    .smart-window[collapsed][maximized] {\r\n      height: var(--smart-window-header-height); }\r\n      .smart-window[collapsed][maximized][header-position="left"] .smart-content-container > .smart-header-section,\r\n      .smart-window[collapsed][maximized][header-position="left"] .smart-content-container > .smart-footer, .smart-window[collapsed][maximized][header-position="right"] .smart-content-container > .smart-header-section,\r\n      .smart-window[collapsed][maximized][header-position="right"] .smart-content-container > .smart-footer {\r\n        min-width: var(--smart-window-header-height); }\r\n  .smart-window[active] .smart-content-container > .smart-header-section {\r\n    background-color: var(--smart-primary);\r\n    color: var(--smart-primary-color); }\r\n  .smart-window[dragged] {\r\n    opacity: 0.5;\r\n    z-index: calc(1 + var(--smart-editor-drop-down-z-index));\r\n    transition: none; }\r\n    .smart-window[dragged] .smart-content-container {\r\n      user-select: none;\r\n      -webkit-user-select: none;\r\n      -ms-user-select: none;\r\n      -moz-user-select: none; }\r\n      .smart-window[dragged] .smart-content-container > .smart-header-section {\r\n        background-color: var(--smart-primary);\r\n        color: var(--smart-primary-color); }\r\n  .smart-window[resized] .smart-content-container {\r\n    user-select: none;\r\n    -webkit-user-select: none;\r\n    -ms-user-select: none;\r\n    -moz-user-select: none; }\r\n  .smart-window[resize-indicator] .smart-content-container:before {\r\n    width: 10px;\r\n    height: 10px;\r\n    font-family: var(--smart-font-family-icon);\r\n    content: var(--smart-icon-minus);\r\n    position: absolute;\r\n    top: calc(100% - 13px);\r\n    left: calc(100% - 10px);\r\n    transform: rotate(-45deg) scaleX(2);\r\n    font-size: 10px; }\r\n  .smart-window[resize-indicator] .smart-content-container:after {\r\n    width: 10px;\r\n    height: 10px;\r\n    font-family: var(--smart-font-family-icon);\r\n    content: var(--smart-icon-minus);\r\n    position: absolute;\r\n    top: calc(100% - 9px);\r\n    left: calc(100% - 8px);\r\n    transform: rotate(-45deg);\r\n    font-size: 10px; }\r\n  .smart-window[resize-indicator][resize-mode="top"] .smart-content-container:before, .smart-window[resize-indicator][resize-mode="left"] .smart-content-container:before {\r\n    top: 0;\r\n    left: 5px; }\r\n  .smart-window[resize-indicator][resize-mode="top"] .smart-content-container:after, .smart-window[resize-indicator][resize-mode="left"] .smart-content-container:after {\r\n    top: 4px;\r\n    left: 5px; }\r\n  .smart-window[resize-indicator][collapsed] .smart-content-container:before, .smart-window[resize-indicator][collapsed] .smart-content-container:after {\r\n    content: \'\'; }\r\n  .smart-window[header-position="none"] .smart-content-container > .smart-header-section {\r\n    display: none; }\r\n  .smart-window[header-position="none"] .smart-content-container > .smart-content {\r\n    height: 100%; }\r\n  .smart-window[header-position="bottom"] .smart-content-container {\r\n    flex-direction: column-reverse; }\r\n  .smart-window[header-position="left"] .smart-content-container {\r\n    flex-direction: row; }\r\n    .smart-window[header-position="left"] .smart-content-container .smart-header-section {\r\n      flex-direction: column; }\r\n      .smart-window[header-position="left"] .smart-content-container .smart-header-section .smart-collapse-button:after {\r\n        transform: rotate(275deg) translateY(1px); }\r\n      .smart-window[header-position="left"] .smart-content-container .smart-header-section > .smart-header {\r\n        writing-mode: vertical-lr; }\r\n    .smart-window[header-position="left"] .smart-content-container > .smart-header-section,\r\n    .smart-window[header-position="left"] .smart-content-container > .smart-footer {\r\n      width: var(--smart-window-header-height);\r\n      min-width: var(--smart-window-header-height);\r\n      height: 100%; }\r\n  .smart-window[header-position="left"][collapsed] .smart-content-container .smart-header-section .smart-collapse-button:after {\r\n    transform: rotate(90deg) translateY(1px); }\r\n  .smart-window[header-position="right"] .smart-content-container {\r\n    flex-direction: row-reverse; }\r\n    .smart-window[header-position="right"] .smart-content-container .smart-header-section {\r\n      flex-direction: column; }\r\n      .smart-window[header-position="right"] .smart-content-container .smart-header-section .smart-collapse-button:after {\r\n        transform: rotate(90deg) translateY(1px); }\r\n      .smart-window[header-position="right"] .smart-content-container .smart-header-section > .smart-header {\r\n        writing-mode: vertical-lr; }\r\n    .smart-window[header-position="right"] .smart-content-container > .smart-header-section,\r\n    .smart-window[header-position="right"] .smart-content-container > .smart-footer {\r\n      width: var(--smart-window-header-height);\r\n      min-width: var(--smart-window-header-height);\r\n      height: 100%; }\r\n  .smart-window[header-position="right"][collapsed] .smart-content-container .smart-header-section .smart-collapse-button:after {\r\n    transform: rotate(275deg) translateY(1px); }\r\n  .smart-window[header-position="left"], .smart-window[header-position="right"] {\r\n    min-width: var(--smart-window-header-height);\r\n    min-height: var(--smart-window-min-width); }\r\n    .smart-window[header-position="left"].smart-window-snapped-left, .smart-window[header-position="left"].smart-window-snapped-right, .smart-window[header-position="right"].smart-window-snapped-left, .smart-window[header-position="right"].smart-window-snapped-right {\r\n      height: 100%;\r\n      width: 50%; }\r\n    .smart-window[header-position="left"].smart-window-snapped-top, .smart-window[header-position="right"].smart-window-snapped-top {\r\n      height: 100%;\r\n      width: 100%; }\r\n    .smart-window[header-position="left"][minimized], .smart-window[header-position="left"][minimized], .smart-window[header-position="right"][minimized], .smart-window[header-position="right"][minimized] {\r\n      max-width: var(--smart-window-header-height); }\r\n    .smart-window[header-position="left"] .smart-content-container > .smart-content, .smart-window[header-position="right"] .smart-content-container > .smart-content {\r\n      height: 100%; }\r\n    .smart-window[header-position="left"] .smart-content-container > .smart-header-section .smart-buttons-container, .smart-window[header-position="right"] .smart-content-container > .smart-header-section .smart-buttons-container {\r\n      display: flex;\r\n      justify-content: center;\r\n      flex-direction: column;\r\n      height: initial; }\r\n      .smart-window[header-position="left"] .smart-content-container > .smart-header-section .smart-buttons-container button, .smart-window[header-position="right"] .smart-content-container > .smart-header-section .smart-buttons-container button {\r\n        margin-left: initial;\r\n        margin-top: 1px; }\r\n        .smart-window[header-position="left"] .smart-content-container > .smart-header-section .smart-buttons-container button:first-of-type, .smart-window[header-position="right"] .smart-content-container > .smart-header-section .smart-buttons-container button:first-of-type {\r\n          margin-top: initial; }\r\n  .smart-window[footer-position="none"] .smart-content-container > .smart-footer {\r\n    display: none; }\r\n  .smart-window[footer-template] .smart-content-container > .smart-content {\r\n    height: calc(100% - var(--smart-window-header-height) - var(--smart-window-footer-height)); }\r\n  .smart-window[footer-template="null"] .smart-content-container > .smart-content {\r\n    height: calc(100% - var(--smart-window-header-height)); }\r\n  .smart-window.smart-window-snapped-top, .smart-window.smart-window-snapped-left, .smart-window.smart-window-snapped-right {\r\n    height: 100%;\r\n    z-index: 9999;\r\n    box-shadow: none;\r\n    border: var(--smart-border-width) solid var(--smart-border); }\r\n    .smart-window.smart-window-snapped-top[ontop], .smart-window.smart-window-snapped-left[ontop], .smart-window.smart-window-snapped-right[ontop] {\r\n      z-index: 10000;\r\n      box-shadow: none; }\r\n  .smart-window.smart-window-snapped-left, .smart-window.smart-window-snapped-right {\r\n    width: 50%; }\r\n  .smart-window.smart-window-snapped-top {\r\n    width: 100%; }\r\n  .smart-window.smart-dialog-window .smart-content-container > .smart-footer .smart-button, .smart-window.smart-alert-window .smart-content-container > .smart-footer .smart-button, .smart-window.smart-prompt-window .smart-content-container > .smart-footer .smart-button, .smart-window.smart-multiline-prompt-window .smart-content-container > .smart-footer .smart-button, .smart-window.smart-progress-window .smart-content-container > .smart-footer .smart-button {\r\n    width: var(--smart-window-footer-button-width);\r\n    height: 100%;\r\n    text-align: center;\r\n    vertical-align: middle;\r\n    cursor: pointer;\r\n    text-transform: var(--smart-button-text-transform);\r\n    font-weight: 500;\r\n    letter-spacing: .08929em;\r\n    overflow: hidden;\r\n    border-color: var(--smart-border);\r\n    border-top-left-radius: var(--smart-border-top-left-radius);\r\n    border-top-right-radius: var(--smart-border-top-right-radius);\r\n    border-bottom-left-radius: var(--smart-border-bottom-left-radius);\r\n    border-bottom-right-radius: var(--smart-border-bottom-right-radius);\r\n    border-width: var(--smart-border-width);\r\n    border-style: solid; }\r\n    .smart-window.smart-dialog-window .smart-content-container > .smart-footer .smart-button:focus, .smart-window.smart-alert-window .smart-content-container > .smart-footer .smart-button:focus, .smart-window.smart-prompt-window .smart-content-container > .smart-footer .smart-button:focus, .smart-window.smart-multiline-prompt-window .smart-content-container > .smart-footer .smart-button:focus, .smart-window.smart-progress-window .smart-content-container > .smart-footer .smart-button:focus {\r\n      color: var(--smart-ui-state-color-focus);\r\n      border-color: var(--smart-ui-state-focus);\r\n      background-color: var(--smart-ui-state-focus);\r\n      opacity: var(--smart-button-opacity-focus); }\r\n  .smart-window.smart-dialog-window {\r\n    width: var(--smart-window-default-width);\r\n    height: var(--smart-window-default-height);\r\n    top: calc(50% - var(--smart-window-default-height) / 2);\r\n    left: calc(50% - var(--smart-window-default-width) / 2); }\r\n    .smart-window.smart-dialog-window .smart-content-container > .smart-footer button:first-child {\r\n      margin-right: 10px; }\r\n    .smart-window.smart-dialog-window[collapsed][header-position="left"], .smart-window.smart-dialog-window[collapsed][header-position="right"], .smart-window.smart-dialog-window[collapsed][maximized][header-position="left"], .smart-window.smart-dialog-window[collapsed][maximized][header-position="right"] {\r\n      height: var(--smart-window-default-height); }\r\n  .smart-window.smart-alert-window {\r\n    width: var(--smart-window-default-width);\r\n    height: var(--smart-window-default-height);\r\n    top: calc(50% - var(--smart-window-default-height) / 2);\r\n    left: calc(50% - var(--smart-window-default-width) / 2); }\r\n    .smart-window.smart-alert-window .smart-content-container > .smart-footer button:first-child {\r\n      margin-right: 10px; }\r\n    .smart-window.smart-alert-window .smart-cancel-button {\r\n      display: none; }\r\n    .smart-window.smart-alert-window[collapsed][header-position="left"], .smart-window.smart-alert-window[collapsed][header-position="right"], .smart-window.smart-alert-window[collapsed][maximized][header-position="left"], .smart-window.smart-alert-window[collapsed][maximized][header-position="right"] {\r\n      height: var(--smart-window-default-height); }\r\n  .smart-window.smart-prompt-window {\r\n    width: var(--smart-window-default-width);\r\n    height: var(--smart-window-default-height);\r\n    top: calc(50% - var(--smart-window-default-height) / 2);\r\n    left: calc(50% - var(--smart-window-default-width) / 2); }\r\n    .smart-window.smart-prompt-window .smart-content-container > .smart-content {\r\n      flex-direction: column-reverse;\r\n      align-items: flex-start; }\r\n    .smart-window.smart-prompt-window .smart-content-container > .smart-footer button:first-child {\r\n      margin-right: 10px; }\r\n    .smart-window.smart-prompt-window smart-text-box {\r\n      width: 100%;\r\n      margin-top: 5px; }\r\n    .smart-window.smart-prompt-window[collapsed][header-position="left"], .smart-window.smart-prompt-window[collapsed][header-position="right"], .smart-window.smart-prompt-window[collapsed][maximized][header-position="left"], .smart-window.smart-prompt-window[collapsed][maximized][header-position="right"] {\r\n      height: var(--smart-window-default-height); }\r\n  .smart-window.smart-multiline-prompt-window {\r\n    width: var(--smart-window-default-width);\r\n    height: var(--smart-window-default-height);\r\n    top: calc(50% - var(--smart-window-default-height) / 2);\r\n    left: calc(50% - var(--smart-window-default-width) / 2); }\r\n    .smart-window.smart-multiline-prompt-window smart-multiline-text-box {\r\n      width: 100%;\r\n      margin-top: 5px; }\r\n    .smart-window.smart-multiline-prompt-window .smart-content-container > .smart-content {\r\n      flex-direction: column-reverse;\r\n      align-items: flex-start; }\r\n    .smart-window.smart-multiline-prompt-window .smart-content-container > .smart-footer button:first-child {\r\n      margin-right: 10px; }\r\n    .smart-window.smart-multiline-prompt-window[collapsed][header-position="left"], .smart-window.smart-multiline-prompt-window[collapsed][header-position="right"], .smart-window.smart-multiline-prompt-window[collapsed][maximized][header-position="left"], .smart-window.smart-multiline-prompt-window[collapsed][maximized][header-position="right"] {\r\n      height: var(--smart-window-default-height); }\r\n  .smart-window.smart-progress-window {\r\n    width: var(--smart-window-default-width);\r\n    height: var(--smart-window-default-height);\r\n    top: calc(50% - var(--smart-window-default-height) / 2);\r\n    left: calc(50% - var(--smart-window-default-width) / 2); }\r\n    .smart-window.smart-progress-window smart-progress-bar .smart-value {\r\n      border: initial; }\r\n    .smart-window.smart-progress-window smart-progress-bar.smart-visibility-hidden {\r\n      transition: none; }\r\n    .smart-window.smart-progress-window .smart-content-container > .smart-content {\r\n      user-select: none;\r\n      -webkit-user-select: none;\r\n      -ms-user-select: none;\r\n      -moz-user-select: none; }\r\n    .smart-window.smart-progress-window .smart-content-container > .smart-footer smart-progress-bar {\r\n      width: 100%;\r\n      height: 100%;\r\n      box-shadow: initial;\r\n      background-color: var(--smart-surface);\r\n      transition: opacity 0.25s ease-in, visibility 0.25s cubic-bezier(0, 0, 0.2, 1); }\r\n      .smart-window.smart-progress-window .smart-content-container > .smart-footer smart-progress-bar > .smart-container {\r\n        border: initial; }\r\n      .smart-window.smart-progress-window .smart-content-container > .smart-footer smart-progress-bar.smart-visibility-hidden {\r\n        opacity: 0.5;\r\n        transition: opacity 0.25s ease-out, visibility 0.25s cubic-bezier(0, 0, 0.2, 1); }\r\n    .smart-window.smart-progress-window .smart-content-container > .smart-footer button.smart-button {\r\n      position: absolute;\r\n      width: calc(100% - 13px);\r\n      height: calc(100% - 13px);\r\n      top: 6.5px;\r\n      left: 6.5px;\r\n      text-align: center;\r\n      background-color: rgba(224, 224, 224, 0.5); }\r\n      .smart-window.smart-progress-window .smart-content-container > .smart-footer button.smart-button.smart-visibility-hidden {\r\n        top: 100%; }\r\n    .smart-window.smart-progress-window.smart-visibility-hidden smart-progress-bar {\r\n      transform: scale(0); }\r\n    .smart-window.smart-progress-window:not([animation=\'none\']) .smart-content-container > .smart-footer button {\r\n      transition: top 0.25s cubic-bezier(0, 0, 0.2, 1), visibility 0.25s cubic-bezier(0, 0, 0.2, 1); }\r\n      .smart-window.smart-progress-window:not([animation=\'none\']) .smart-content-container > .smart-footer button.smart-visibility-hidden {\r\n        transition: top 0.25s cubic-bezier(0, 0, 0.2, 1), visibility 0.25s cubic-bezier(0, 0, 0.2, 1); }\r\n    .smart-window.smart-progress-window[collapsed][header-position="left"], .smart-window.smart-progress-window[collapsed][header-position="right"], .smart-window.smart-progress-window[collapsed][maximized][header-position="left"], .smart-window.smart-progress-window[collapsed][maximized][header-position="right"] {\r\n      height: var(--smart-window-default-height); }\r\n  .smart-window.smart-wait-window {\r\n    width: var(--smart-window-default-width);\r\n    height: var(--smart-window-default-height);\r\n    top: calc(50% - var(--smart-window-default-height) / 2);\r\n    left: calc(50% - var(--smart-window-default-width) / 2); }\r\n    .smart-window.smart-wait-window .smart-content-container > .smart-header-section {\r\n      cursor: default; }\r\n    .smart-window.smart-wait-window .smart-content-container > .smart-content smart-progress-bar {\r\n      width: 100%;\r\n      height: 75%; }\r\n    .smart-window.smart-wait-window[collapsed][header-position="left"], .smart-window.smart-wait-window[collapsed][header-position="right"], .smart-window.smart-wait-window[collapsed][maximized][header-position="left"], .smart-window.smart-wait-window[collapsed][maximized][header-position="right"] {\r\n      height: var(--smart-window-default-height); }\r\n\r\nsmart-window.smart-window[collapsed][header-position="left"], smart-window.smart-window[collapsed][header-position="right"], smart-window.smart-window[collapsed][maximized][header-position="left"], smart-window.smart-window[collapsed][maximized][header-position="right"] {\r\n  width: var(--smart-window-header-height);\r\n  min-width: initial;\r\n  height: var(--smart-window-default-height); }\r\n\r\n.smart-modal {\r\n  position: absolute;\r\n  opacity: 0.5;\r\n  background-color: var(--smart-disabled);\r\n  top: 0;\r\n  left: 0;\r\n  width: 100%;\r\n  min-height: 100%; }\r\n\r\n.smart-window-resize-feedback {\r\n  position: absolute;\r\n  z-index: 10000;\r\n  pointer-events: none;\r\n  user-select: none;\r\n  -moz-user-select: none;\r\n  -webkit-user-select: none;\r\n  -ms-user-select: none;\r\n  border: 2.5px solid black;\r\n  box-sizing: border-box; }\r\n\r\nsmart-docking-layout .smart-window-resize-feedback {\r\n  border: 2.5px solid lightgray; }\r\n\r\n.smart-window-snap-right-feedback,\r\n.smart-window-snap-left-feedback,\r\n.smart-window-snap-top-feedback,\r\n.smart-window-snap-bottom-feedback {\r\n  position: absolute;\r\n  height: calc(100% - 10px);\r\n  top: 5px;\r\n  bottom: 5px;\r\n  opacity: 0.65;\r\n  box-shadow: 0 0 1px 1px #8a8a8a;\r\n  border-radius: 2px;\r\n  transition: all 0.05s cubic-bezier(0.4, 0, 0.6, 1);\r\n  animation: scaleIn 0.2s cubic-bezier(0.4, 0, 0.2, 1);\r\n  transform: scale(1);\r\n  pointer-events: none; }\r\n  .smart-window-snap-right-feedback.smart-visibility-hidden,\r\n  .smart-window-snap-left-feedback.smart-visibility-hidden,\r\n  .smart-window-snap-top-feedback.smart-visibility-hidden,\r\n  .smart-window-snap-bottom-feedback.smart-visibility-hidden {\r\n    transition: animation 0.2s cubic-bezier(0.4, 0, 0.6, 1), visibility 0.2s cubic-bezier(0.4, 0, 0.6, 1), top 0.2s cubic-bezier(0.4, 0, 0.2, 1), left 0.2s cubic-bezier(0.4, 0, 0.2, 1);\r\n    animation: scaleOut 0.2s cubic-bezier(0.4, 0, 0.6, 1);\r\n    transform: scale(0); }\r\n\r\n.smart-window-snap-right-feedback {\r\n  width: 50%;\r\n  left: calc(50% - 5px);\r\n  transform-origin: right; }\r\n\r\n.smart-window-snap-left-feedback {\r\n  width: 50%;\r\n  left: 5px;\r\n  transform-origin: left; }\r\n\r\n.smart-window-snap-top-feedback {\r\n  width: calc(100% - 10px);\r\n  left: 5px;\r\n  transform-origin: top; }\r\n\r\n.smart-window-snap-bottom-feedback {\r\n  width: calc(100% - 10px);\r\n  left: 5px;\r\n  transform-origin: top; }\r\n\r\n@keyframes scaleIn {\r\n  0% {\r\n    transform: scale(0); }\r\n  50% {\r\n    transform: scale(0.5);\r\n    opacity: 0.5; }\r\n  100% {\r\n    transform: scale(1);\r\n    opacity: 1; } }\r\n@keyframes scaleOut {\r\n  0% {\r\n    transform: scale(1);\r\n    opacity: 1; }\r\n  50% {\r\n    transform: scale(0.5);\r\n    opacity: 0.5; }\r\n  100% {\r\n    transform: scale(0); } }\r\n@keyframes scaleInRight {\r\n  0% {\r\n    transform: scale(0); }\r\n  50% {\r\n    transform: scale(0.5);\r\n    opacity: 0.5; }\r\n  100% {\r\n    transform: scale(1);\r\n    opacity: 1; } }\r\n.smart-window[right-to-left] .smart-content-container > .smart-header-section,\r\n.smart-window[right-to-left] .smart-content-container > .smart-content,\r\n.smart-window[right-to-left] .smart-content-container > .smart-footer {\r\n  direction: rtl; }\r\n.smart-window[right-to-left][header-position="left"] .smart-header-section > .smart-header, .smart-window[right-to-left][header-position="right"] .smart-header-section > .smart-header {\r\n  writing-mode: vertical-rl; }\r\n.smart-window[right-to-left].smart-dialog-window .smart-content-container > .smart-footer button:first-child, .smart-window[right-to-left].smart-alert-window .smart-content-container > .smart-footer button:first-child, .smart-window[right-to-left].smart-prompt-window .smart-content-container > .smart-footer button:first-child, .smart-window[right-to-left].smart-multiline-prompt-window .smart-content-container > .smart-footer button:first-child {\r\n  margin-left: 10px;\r\n  margin-right: initial; }\r\n\r\n.smart-tabs-window[right-to-left] .smart-content-container > .smart-content {\r\n  direction: initial; }\r\n',""]);const s=i},3645:e=>{"use strict";e.exports=function(e){var t=[];return t.toString=function(){return this.map((function(t){var r="",n=void 0!==t[5];return t[4]&&(r+="@supports (".concat(t[4],") {")),t[2]&&(r+="@media ".concat(t[2]," {")),n&&(r+="@layer".concat(t[5].length>0?" ".concat(t[5]):""," {")),r+=e(t),n&&(r+="}"),t[2]&&(r+="}"),t[4]&&(r+="}"),r})).join("")},t.i=function(e,r,n,o,a){"string"==typeof e&&(e=[[null,e,void 0]]);var i={};if(n)for(var s=0;s<this.length;s++){var l=this[s][0];null!=l&&(i[l]=!0)}for(var d=0;d<e.length;d++){var m=[].concat(e[d]);n&&i[m[0]]||(void 0!==a&&(void 0===m[5]||(m[1]="@layer".concat(m[5].length>0?" ".concat(m[5]):""," {").concat(m[1],"}")),m[5]=a),r&&(m[2]?(m[1]="@media ".concat(m[2]," {").concat(m[1],"}"),m[2]=r):m[2]=r),o&&(m[4]?(m[1]="@supports (".concat(m[4],") {").concat(m[1],"}"),m[4]=o):m[4]="".concat(o)),t.push(m))}},t}},8081:e=>{"use strict";e.exports=function(e){return e[1]}},1837:function(e){e.exports=function(){"use strict";function e(e,t){for(var r=0;r<t.length;r++){var n=t[r];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}function t(e,t){(null==t||t>e.length)&&(t=e.length);for(var r=0,n=new Array(t);r<t;r++)n[r]=e[r];return n}function r(e,r){var n;if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator])return(n=e[Symbol.iterator]()).next.bind(n);if(Array.isArray(e)||(n=function(e,r){if(e){if("string"==typeof e)return t(e,r);var n=Object.prototype.toString.call(e).slice(8,-1);return"Map"===(n="Object"===n&&e.constructor?e.constructor.name:n)||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?t(e,r):void 0}}(e))||r&&e&&"number"==typeof e.length){n&&(e=n);var o=0;return function(){return o>=e.length?{done:!0}:{done:!1,value:e[o++]}}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function n(e){return m[e]}var o,a=(function(e){function t(){return{baseUrl:null,breaks:!1,gfm:!0,headerIds:!0,headerPrefix:"",highlight:null,langPrefix:"language-",mangle:!0,pedantic:!1,renderer:null,sanitize:!1,sanitizer:null,silent:!1,smartLists:!1,smartypants:!1,tokenizer:null,walkTokens:null,xhtml:!1}}e.exports={defaults:t(),getDefaults:t,changeDefaults:function(t){e.exports.defaults=t}}}(o={exports:{}}),o.exports),i=/[&<>"']/,s=/[&<>"']/g,l=/[<>"']|&(?!#?\w+;)/,d=/[<>"']|&(?!#?\w+;)/g,m={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"},c=/&(#(?:\d+)|(?:#x[0-9A-Fa-f]+)|(?:\w+));?/gi;function u(e){return e.replace(c,(function(e,t){return"colon"===(t=t.toLowerCase())?":":"#"===t.charAt(0)?"x"===t.charAt(1)?String.fromCharCode(parseInt(t.substring(2),16)):String.fromCharCode(+t.substring(1)):""}))}var p=/(^|[^\[])\^/g,h=/[^\w:]/g,b=/^$|^[a-z][a-z0-9+.-]*:|^[?#]/i,g={},f=/^[^:]+:\/*[^/]*$/,v=/^([^:]+:)[\s\S]*$/,w=/^([^:]+:\/*[^/]*)[\s\S]*$/;function x(e,t){g[" "+e]||(f.test(e)?g[" "+e]=e+"/":g[" "+e]=y(e,"/",!0));var r=-1===(e=g[" "+e]).indexOf(":");return"//"===t.substring(0,2)?r?t:e.replace(v,"$1")+t:"/"===t.charAt(0)?r?t:e.replace(w,"$1")+t:e+t}function y(e,t,r){var n=e.length;if(0===n)return"";for(var o=0;o<n;){var a=e.charAt(n-o-1);if(a!==t||r){if(a===t||!r)break;o++}else o++}return e.substr(0,n-o)}var _=function(e,t){if(t){if(i.test(e))return e.replace(s,n)}else if(l.test(e))return e.replace(d,n);return e},k=u,C=function(e,t){e=e.source||e,t=t||"";var r={replace:function(t,n){return n=(n=n.source||n).replace(p,"$1"),e=e.replace(t,n),r},getRegex:function(){return new RegExp(e,t)}};return r},D=function(e,t,r){if(e){var n;try{n=decodeURIComponent(u(r)).replace(h,"").toLowerCase()}catch(e){return null}if(0===n.indexOf("javascript:")||0===n.indexOf("vbscript:")||0===n.indexOf("data:"))return null}t&&!b.test(r)&&(r=x(t,r));try{r=encodeURI(r).replace(/%25/g,"%")}catch(e){return null}return r},E={exec:function(){}},S=function(e){for(var t,r,n=1;n<arguments.length;n++)for(r in t=arguments[n])Object.prototype.hasOwnProperty.call(t,r)&&(e[r]=t[r]);return e},A=function(e,t){var r=e.replace(/\|/g,(function(e,t,r){for(var n=!1,o=t;0<=--o&&"\\"===r[o];)n=!n;return n?"|":" |"})).split(/ \|/),n=0;if(r.length>t)r.splice(t);else for(;r.length<t;)r.push("");for(;n<r.length;n++)r[n]=r[n].trim().replace(/\\\|/g,"|");return r},T=function(e,t){if(-1===e.indexOf(t[1]))return-1;for(var r=e.length,n=0,o=0;o<r;o++)if("\\"===e[o])o++;else if(e[o]===t[0])n++;else if(e[o]===t[1]&&--n<0)return o;return-1},z=function(e){e&&e.sanitize&&!e.silent&&console.warn("marked(): sanitize and sanitizer parameters are deprecated since version 0.7.0, should not be used and will be removed in the future. Read more here: https://marked.js.org/#/USING_ADVANCED.md#options")},L=function(e,t){if(t<1)return"";for(var r="";1<t;)1&t&&(r+=e),t>>=1,e+=e;return r+e},$=a.defaults,I=y,M=A,B=_,F=T;function H(e,t,r){var n=t.href,o=t.title?B(t.title):null;return t=e[1].replace(/\\([\[\]])/g,"$1"),"!"!==e[0].charAt(0)?{type:"link",raw:r,href:n,title:o,text:t}:{type:"image",raw:r,href:n,title:o,text:B(t)}}var O=function(){function e(e){this.options=e||$}var t=e.prototype;return t.space=function(e){if(e=this.rules.block.newline.exec(e))return 1<e[0].length?{type:"space",raw:e[0]}:{raw:"\n"}},t.code=function(e){var t=this.rules.block.code.exec(e);if(t)return e=t[0].replace(/^ {1,4}/gm,""),{type:"code",raw:t[0],codeBlockStyle:"indented",text:this.options.pedantic?e:I(e,"\n")}},t.fences=function(e){var t=this.rules.block.fences.exec(e);if(t){var r=t[0];return e=function(e,t){if(null===(e=e.match(/^(\s+)(?:```)/)))return t;var r=e[1];return t.split("\n").map((function(e){var t=e.match(/^\s+/);return null!==t&&t[0].length>=r.length?e.slice(r.length):e})).join("\n")}(r,t[3]||""),{type:"code",raw:r,lang:t[2]&&t[2].trim(),text:e}}},t.heading=function(e){var t=this.rules.block.heading.exec(e);if(t){var r=t[2].trim();return/#$/.test(r)&&(e=I(r,"#"),!this.options.pedantic&&e&&!/ $/.test(e)||(r=e.trim())),{type:"heading",raw:t[0],depth:t[1].length,text:r}}},t.nptable=function(e){if(e=this.rules.block.nptable.exec(e)){var t={type:"table",header:M(e[1].replace(/^ *| *\| *$/g,"")),align:e[2].replace(/^ *|\| *$/g,"").split(/ *\| */),cells:e[3]?e[3].replace(/\n$/,"").split("\n"):[],raw:e[0]};if(t.header.length===t.align.length){for(var r=t.align.length,n=0;n<r;n++)/^ *-+: *$/.test(t.align[n])?t.align[n]="right":/^ *:-+: *$/.test(t.align[n])?t.align[n]="center":/^ *:-+ *$/.test(t.align[n])?t.align[n]="left":t.align[n]=null;for(r=t.cells.length,n=0;n<r;n++)t.cells[n]=M(t.cells[n],t.header.length);return t}}},t.hr=function(e){if(e=this.rules.block.hr.exec(e))return{type:"hr",raw:e[0]}},t.blockquote=function(e){var t=this.rules.block.blockquote.exec(e);if(t)return e=t[0].replace(/^ *> ?/gm,""),{type:"blockquote",raw:t[0],text:e}},t.list=function(e){if(e=this.rules.block.list.exec(e)){for(var t,r,n,o,a,i,s=e[0],l=e[2],d=1<l.length,m={type:"list",raw:s,ordered:d,start:d?+l.slice(0,-1):"",loose:!1,items:[]},c=e[0].match(this.rules.block.item),u=!1,p=c.length,h=this.rules.block.listItemStart.exec(c[0]),b=0;b<p;b++){if(s=t=c[b],this.options.pedantic||(i=t.match(new RegExp("\\n\\s*\\n {0,"+(h[0].length-1)+"}\\S")))&&(r=t.length-i.index+c.slice(b+1).join("\n").length,m.raw=m.raw.substring(0,m.raw.length-r),s=t=t.substring(0,i.index),p=b+1),b!==p-1){if(n=this.rules.block.listItemStart.exec(c[b+1]),this.options.pedantic?n[1].length>h[1].length:n[1].length>=h[0].length||3<n[1].length){c.splice(b,2,c[b]+(!this.options.pedantic&&n[1].length<h[0].length&&!c[b].match(/\n$/)?"":"\n")+c[b+1]),b--,p--;continue}(!this.options.pedantic||this.options.smartLists?n[2][n[2].length-1]!==l[l.length-1]:d==(1===n[2].length))&&(r=c.slice(b+1).join("\n").length,m.raw=m.raw.substring(0,m.raw.length-r),b=p-1),h=n}n=t.length,~(t=t.replace(/^ *([*+-]|\d+[.)]) ?/,"")).indexOf("\n ")&&(n-=t.length,t=this.options.pedantic?t.replace(/^ {1,4}/gm,""):t.replace(new RegExp("^ {1,"+n+"}","gm"),"")),t=I(t,"\n"),b!==p-1&&(s+="\n"),n=u||/\n\n(?!\s*$)/.test(s),b!==p-1&&(u="\n\n"===s.slice(-2),n=n||u),n&&(m.loose=!0),this.options.gfm&&(a=void 0,(o=/^\[[ xX]\] /.test(t))&&(a=" "!==t[1],t=t.replace(/^\[[ xX]\] +/,""))),m.items.push({type:"list_item",raw:s,task:o,checked:a,loose:n,text:t})}return m}},t.html=function(e){if(e=this.rules.block.html.exec(e))return{type:this.options.sanitize?"paragraph":"html",raw:e[0],pre:!this.options.sanitizer&&("pre"===e[1]||"script"===e[1]||"style"===e[1]),text:this.options.sanitize?this.options.sanitizer?this.options.sanitizer(e[0]):B(e[0]):e[0]}},t.def=function(e){if(e=this.rules.block.def.exec(e))return e[3]&&(e[3]=e[3].substring(1,e[3].length-1)),{tag:e[1].toLowerCase().replace(/\s+/g," "),raw:e[0],href:e[2],title:e[3]}},t.table=function(e){if(e=this.rules.block.table.exec(e)){var t={type:"table",header:M(e[1].replace(/^ *| *\| *$/g,"")),align:e[2].replace(/^ *|\| *$/g,"").split(/ *\| */),cells:e[3]?e[3].replace(/\n$/,"").split("\n"):[]};if(t.header.length===t.align.length){t.raw=e[0];for(var r=t.align.length,n=0;n<r;n++)/^ *-+: *$/.test(t.align[n])?t.align[n]="right":/^ *:-+: *$/.test(t.align[n])?t.align[n]="center":/^ *:-+ *$/.test(t.align[n])?t.align[n]="left":t.align[n]=null;for(r=t.cells.length,n=0;n<r;n++)t.cells[n]=M(t.cells[n].replace(/^ *\| *| *\| *$/g,""),t.header.length);return t}}},t.lheading=function(e){if(e=this.rules.block.lheading.exec(e))return{type:"heading",raw:e[0],depth:"="===e[2].charAt(0)?1:2,text:e[1]}},t.paragraph=function(e){if(e=this.rules.block.paragraph.exec(e))return{type:"paragraph",raw:e[0],text:"\n"===e[1].charAt(e[1].length-1)?e[1].slice(0,-1):e[1]}},t.text=function(e){if(e=this.rules.block.text.exec(e))return{type:"text",raw:e[0],text:e[0]}},t.escape=function(e){if(e=this.rules.inline.escape.exec(e))return{type:"escape",raw:e[0],text:B(e[1])}},t.tag=function(e,t,r){if(e=this.rules.inline.tag.exec(e))return!t&&/^<a /i.test(e[0])?t=!0:t&&/^<\/a>/i.test(e[0])&&(t=!1),!r&&/^<(pre|code|kbd|script)(\s|>)/i.test(e[0])?r=!0:r&&/^<\/(pre|code|kbd|script)(\s|>)/i.test(e[0])&&(r=!1),{type:this.options.sanitize?"text":"html",raw:e[0],inLink:t,inRawBlock:r,text:this.options.sanitize?this.options.sanitizer?this.options.sanitizer(e[0]):B(e[0]):e[0]}},t.link=function(e){var t=this.rules.inline.link.exec(e);if(t){var r=t[2].trim();if(!this.options.pedantic&&/^</.test(r)){if(!/>$/.test(r))return;if(e=I(r.slice(0,-1),"\\"),(r.length-e.length)%2==0)return}else-1<(o=F(t[2],"()"))&&(a=(0===t[0].indexOf("!")?5:4)+t[1].length+o,t[2]=t[2].substring(0,o),t[0]=t[0].substring(0,a).trim(),t[3]="");var n,o=t[2],a="";return this.options.pedantic?(n=/^([^'"]*[^\s])\s+(['"])(.*)\2/.exec(o))&&(o=n[1],a=n[3]):a=t[3]?t[3].slice(1,-1):"",o=o.trim(),H(t,{href:(o=/^</.test(o)?this.options.pedantic&&!/>$/.test(r)?o.slice(1):o.slice(1,-1):o)&&o.replace(this.rules.inline._escapes,"$1"),title:a&&a.replace(this.rules.inline._escapes,"$1")},t[0])}},t.reflink=function(e,t){if((r=this.rules.inline.reflink.exec(e))||(r=this.rules.inline.nolink.exec(e))){if((e=t[(e=(r[2]||r[1]).replace(/\s+/g," ")).toLowerCase()])&&e.href)return H(r,e,r[0]);var r=r[0].charAt(0);return{type:"text",raw:r,text:r}}},t.emStrong=function(e,t,r){void 0===r&&(r="");var n=this.rules.inline.emStrong.lDelim.exec(e);if(n&&(!n[3]||!r.match(/(?:[0-9A-Za-z\xAA\xB2\xB3\xB5\xB9\xBA\xBC-\xBE\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0560-\u0588\u05D0-\u05EA\u05EF-\u05F2\u0620-\u064A\u0660-\u0669\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07C0-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u0860-\u086A\u08A0-\u08B4\u08B6-\u08C7\u0904-\u0939\u093D\u0950\u0958-\u0961\u0966-\u096F\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09E6-\u09F1\u09F4-\u09F9\u09FC\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A66-\u0A6F\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AE6-\u0AEF\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B66-\u0B6F\u0B71-\u0B77\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0BE6-\u0BF2\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C60\u0C61\u0C66-\u0C6F\u0C78-\u0C7E\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CE6-\u0CEF\u0CF1\u0CF2\u0D04-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D58-\u0D61\u0D66-\u0D78\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0DE6-\u0DEF\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E50-\u0E59\u0E81\u0E82\u0E84\u0E86-\u0E8A\u0E8C-\u0EA3\u0EA5\u0EA7-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0ED0-\u0ED9\u0EDC-\u0EDF\u0F00\u0F20-\u0F33\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F-\u1049\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u1090-\u1099\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1369-\u137C\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u17E0-\u17E9\u17F0-\u17F9\u1810-\u1819\u1820-\u1878\u1880-\u1884\u1887-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1946-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u19D0-\u19DA\u1A00-\u1A16\u1A20-\u1A54\u1A80-\u1A89\u1A90-\u1A99\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B50-\u1B59\u1B83-\u1BA0\u1BAE-\u1BE5\u1C00-\u1C23\u1C40-\u1C49\u1C4D-\u1C7D\u1C80-\u1C88\u1C90-\u1CBA\u1CBD-\u1CBF\u1CE9-\u1CEC\u1CEE-\u1CF3\u1CF5\u1CF6\u1CFA\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2070\u2071\u2074-\u2079\u207F-\u2089\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2150-\u2189\u2460-\u249B\u24EA-\u24FF\u2776-\u2793\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2CFD\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312F\u3131-\u318E\u3192-\u3195\u31A0-\u31BF\u31F0-\u31FF\u3220-\u3229\u3248-\u324F\u3251-\u325F\u3280-\u3289\u32B1-\u32BF\u3400-\u4DBF\u4E00-\u9FFC\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA7BF\uA7C2-\uA7CA\uA7F5-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA830-\uA835\uA840-\uA873\uA882-\uA8B3\uA8D0-\uA8D9\uA8F2-\uA8F7\uA8FB\uA8FD\uA8FE\uA900-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF-\uA9D9\uA9E0-\uA9E4\uA9E6-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA50-\uAA59\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB69\uAB70-\uABE2\uABF0-\uABF9\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF10-\uFF19\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]|\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDD07-\uDD33\uDD40-\uDD78\uDD8A\uDD8B\uDE80-\uDE9C\uDEA0-\uDED0\uDEE1-\uDEFB\uDF00-\uDF23\uDF2D-\uDF4A\uDF50-\uDF75\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF\uDFD1-\uDFD5]|\uD801[\uDC00-\uDC9D\uDCA0-\uDCA9\uDCB0-\uDCD3\uDCD8-\uDCFB\uDD00-\uDD27\uDD30-\uDD63\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC58-\uDC76\uDC79-\uDC9E\uDCA7-\uDCAF\uDCE0-\uDCF2\uDCF4\uDCF5\uDCFB-\uDD1B\uDD20-\uDD39\uDD80-\uDDB7\uDDBC-\uDDCF\uDDD2-\uDE00\uDE10-\uDE13\uDE15-\uDE17\uDE19-\uDE35\uDE40-\uDE48\uDE60-\uDE7E\uDE80-\uDE9F\uDEC0-\uDEC7\uDEC9-\uDEE4\uDEEB-\uDEEF\uDF00-\uDF35\uDF40-\uDF55\uDF58-\uDF72\uDF78-\uDF91\uDFA9-\uDFAF]|\uD803[\uDC00-\uDC48\uDC80-\uDCB2\uDCC0-\uDCF2\uDCFA-\uDD23\uDD30-\uDD39\uDE60-\uDE7E\uDE80-\uDEA9\uDEB0\uDEB1\uDF00-\uDF27\uDF30-\uDF45\uDF51-\uDF54\uDFB0-\uDFCB\uDFE0-\uDFF6]|\uD804[\uDC03-\uDC37\uDC52-\uDC6F\uDC83-\uDCAF\uDCD0-\uDCE8\uDCF0-\uDCF9\uDD03-\uDD26\uDD36-\uDD3F\uDD44\uDD47\uDD50-\uDD72\uDD76\uDD83-\uDDB2\uDDC1-\uDDC4\uDDD0-\uDDDA\uDDDC\uDDE1-\uDDF4\uDE00-\uDE11\uDE13-\uDE2B\uDE80-\uDE86\uDE88\uDE8A-\uDE8D\uDE8F-\uDE9D\uDE9F-\uDEA8\uDEB0-\uDEDE\uDEF0-\uDEF9\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3D\uDF50\uDF5D-\uDF61]|\uD805[\uDC00-\uDC34\uDC47-\uDC4A\uDC50-\uDC59\uDC5F-\uDC61\uDC80-\uDCAF\uDCC4\uDCC5\uDCC7\uDCD0-\uDCD9\uDD80-\uDDAE\uDDD8-\uDDDB\uDE00-\uDE2F\uDE44\uDE50-\uDE59\uDE80-\uDEAA\uDEB8\uDEC0-\uDEC9\uDF00-\uDF1A\uDF30-\uDF3B]|\uD806[\uDC00-\uDC2B\uDCA0-\uDCF2\uDCFF-\uDD06\uDD09\uDD0C-\uDD13\uDD15\uDD16\uDD18-\uDD2F\uDD3F\uDD41\uDD50-\uDD59\uDDA0-\uDDA7\uDDAA-\uDDD0\uDDE1\uDDE3\uDE00\uDE0B-\uDE32\uDE3A\uDE50\uDE5C-\uDE89\uDE9D\uDEC0-\uDEF8]|\uD807[\uDC00-\uDC08\uDC0A-\uDC2E\uDC40\uDC50-\uDC6C\uDC72-\uDC8F\uDD00-\uDD06\uDD08\uDD09\uDD0B-\uDD30\uDD46\uDD50-\uDD59\uDD60-\uDD65\uDD67\uDD68\uDD6A-\uDD89\uDD98\uDDA0-\uDDA9\uDEE0-\uDEF2\uDFB0\uDFC0-\uDFD4]|\uD808[\uDC00-\uDF99]|\uD809[\uDC00-\uDC6E\uDC80-\uDD43]|[\uD80C\uD81C-\uD820\uD822\uD840-\uD868\uD86A-\uD86C\uD86F-\uD872\uD874-\uD879\uD880-\uD883][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2E]|\uD811[\uDC00-\uDE46]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDE60-\uDE69\uDED0-\uDEED\uDF00-\uDF2F\uDF40-\uDF43\uDF50-\uDF59\uDF5B-\uDF61\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDE40-\uDE96\uDF00-\uDF4A\uDF50\uDF93-\uDF9F\uDFE0\uDFE1\uDFE3]|\uD821[\uDC00-\uDFF7]|\uD823[\uDC00-\uDCD5\uDD00-\uDD08]|\uD82C[\uDC00-\uDD1E\uDD50-\uDD52\uDD64-\uDD67\uDD70-\uDEFB]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99]|\uD834[\uDEE0-\uDEF3\uDF60-\uDF78]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFCB\uDFCE-\uDFFF]|\uD838[\uDD00-\uDD2C\uDD37-\uDD3D\uDD40-\uDD49\uDD4E\uDEC0-\uDEEB\uDEF0-\uDEF9]|\uD83A[\uDC00-\uDCC4\uDCC7-\uDCCF\uDD00-\uDD43\uDD4B\uDD50-\uDD59]|\uD83B[\uDC71-\uDCAB\uDCAD-\uDCAF\uDCB1-\uDCB4\uDD01-\uDD2D\uDD2F-\uDD3D\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD83C[\uDD00-\uDD0C]|\uD83E[\uDFF0-\uDFF9]|\uD869[\uDC00-\uDEDD\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF34\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEA1\uDEB0-\uDFFF]|\uD87A[\uDC00-\uDFE0]|\uD87E[\uDC00-\uDE1D]|\uD884[\uDC00-\uDF4A])/))){var o=n[1]||n[2]||"";if(!o||o&&(""===r||this.rules.inline.punctuation.exec(r))){var a,i=n[0].length-1,s=i,l=0,d="*"===n[0][0]?this.rules.inline.emStrong.rDelimAst:this.rules.inline.emStrong.rDelimUnd;for(d.lastIndex=0,t=t.slice(-1*e.length+i);null!=(n=d.exec(t));)if(a=n[1]||n[2]||n[3]||n[4]||n[5]||n[6])if(a=a.length,n[3]||n[4])s+=a;else if(!((n[5]||n[6])&&i%3)||(i+a)%3){if(!(0<(s-=a))){if(s+l-a<=0&&!t.slice(d.lastIndex).match(d)&&(a=Math.min(a,a+s+l)),Math.min(i,a)%2)return{type:"em",raw:e.slice(0,i+n.index+a+1),text:e.slice(1,i+n.index+a)};if(Math.min(i,a)%2==0)return{type:"strong",raw:e.slice(0,i+n.index+a+1),text:e.slice(2,i+n.index+a-1)}}}else l+=a}}},t.codespan=function(e){var t=this.rules.inline.code.exec(e);if(t){var r=t[2].replace(/\n/g," "),n=/[^ ]/.test(r);return e=/^ /.test(r)&&/ $/.test(r),n&&e&&(r=r.substring(1,r.length-1)),r=B(r,!0),{type:"codespan",raw:t[0],text:r}}},t.br=function(e){if(e=this.rules.inline.br.exec(e))return{type:"br",raw:e[0]}},t.del=function(e){if(e=this.rules.inline.del.exec(e))return{type:"del",raw:e[0],text:e[2]}},t.autolink=function(e,t){var r;if(e=this.rules.inline.autolink.exec(e))return t="@"===e[2]?"mailto:"+(r=B(this.options.mangle?t(e[1]):e[1])):r=B(e[1]),{type:"link",raw:e[0],text:r,href:t,tokens:[{type:"text",raw:r,text:r}]}},t.url=function(e,t){var r,n,o,a;if(r=this.rules.inline.url.exec(e)){if("@"===r[2])o="mailto:"+(n=B(this.options.mangle?t(r[0]):r[0]));else{for(;a=r[0],r[0]=this.rules.inline._backpedal.exec(r[0])[0],a!==r[0];);n=B(r[0]),o="www."===r[1]?"http://"+n:n}return{type:"link",raw:r[0],text:n,href:o,tokens:[{type:"text",raw:n,text:n}]}}},t.inlineText=function(e,t,r){if(e=this.rules.inline.text.exec(e))return r=t?this.options.sanitize?this.options.sanitizer?this.options.sanitizer(e[0]):B(e[0]):e[0]:B(this.options.smartypants?r(e[0]):e[0]),{type:"text",raw:e[0],text:r}},e}();A=E,T=C,E=S,(C={newline:/^(?: *(?:\n|$))+/,code:/^( {4}[^\n]+(?:\n(?: *(?:\n|$))*)?)+/,fences:/^ {0,3}(`{3,}(?=[^`\n]*\n)|~{3,})([^\n]*)\n(?:|([\s\S]*?)\n)(?: {0,3}\1[~`]* *(?:\n+|$)|$)/,hr:/^ {0,3}((?:- *){3,}|(?:_ *){3,}|(?:\* *){3,})(?:\n+|$)/,heading:/^ {0,3}(#{1,6})(?=\s|$)(.*)(?:\n+|$)/,blockquote:/^( {0,3}> ?(paragraph|[^\n]*)(?:\n|$))+/,list:/^( {0,3})(bull) [\s\S]+?(?:hr|def|\n{2,}(?! )(?! {0,3}bull )\n*|\s*$)/,html:"^ {0,3}(?:<(script|pre|style)[\\s>][\\s\\S]*?(?:</\\1>[^\\n]*\\n+|$)|comment[^\\n]*(\\n+|$)|<\\?[\\s\\S]*?(?:\\?>\\n*|$)|<![A-Z][\\s\\S]*?(?:>\\n*|$)|<!\\[CDATA\\[[\\s\\S]*?(?:\\]\\]>\\n*|$)|</?(tag)(?: +|\\n|/?>)[\\s\\S]*?(?:\\n{2,}|$)|<(?!script|pre|style)([a-z][\\w-]*)(?:attribute)*? */?>(?=[ \\t]*(?:\\n|$))[\\s\\S]*?(?:\\n{2,}|$)|</(?!script|pre|style)[a-z][\\w-]*\\s*>(?=[ \\t]*(?:\\n|$))[\\s\\S]*?(?:\\n{2,}|$))",def:/^ {0,3}\[(label)\]: *\n? *<?([^\s>]+)>?(?:(?: +\n? *| *\n *)(title))? *(?:\n+|$)/,nptable:A,table:A,lheading:/^([^\n]+)\n {0,3}(=+|-+) *(?:\n+|$)/,_paragraph:/^([^\n]+(?:\n(?!hr|heading|lheading|blockquote|fences|list|html| +\n)[^\n]+)*)/,text:/^[^\n]+/,_label:/(?!\s*\])(?:\\[\[\]]|[^\[\]])+/,_title:/(?:"(?:\\"?|[^"\\])*"|'[^'\n]*(?:\n[^'\n]+)*\n?'|\([^()]*\))/}).def=T(C.def).replace("label",C._label).replace("title",C._title).getRegex(),C.bullet=/(?:[*+-]|\d{1,9}[.)])/,C.item=/^( *)(bull) ?[^\n]*(?:\n(?! *bull ?)[^\n]*)*/,C.item=T(C.item,"gm").replace(/bull/g,C.bullet).getRegex(),C.listItemStart=T(/^( *)(bull) */).replace("bull",C.bullet).getRegex(),C.list=T(C.list).replace(/bull/g,C.bullet).replace("hr","\\n+(?=\\1?(?:(?:- *){3,}|(?:_ *){3,}|(?:\\* *){3,})(?:\\n+|$))").replace("def","\\n+(?="+C.def.source+")").getRegex(),C._tag="address|article|aside|base|basefont|blockquote|body|caption|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption|figure|footer|form|frame|frameset|h[1-6]|head|header|hr|html|iframe|legend|li|link|main|menu|menuitem|meta|nav|noframes|ol|optgroup|option|p|param|section|source|summary|table|tbody|td|tfoot|th|thead|title|tr|track|ul",C._comment=/<!--(?!-?>)[\s\S]*?(?:-->|$)/,C.html=T(C.html,"i").replace("comment",C._comment).replace("tag",C._tag).replace("attribute",/ +[a-zA-Z:_][\w.:-]*(?: *= *"[^"\n]*"| *= *'[^'\n]*'| *= *[^\s"'=<>`]+)?/).getRegex(),C.paragraph=T(C._paragraph).replace("hr",C.hr).replace("heading"," {0,3}#{1,6} ").replace("|lheading","").replace("blockquote"," {0,3}>").replace("fences"," {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list"," {0,3}(?:[*+-]|1[.)]) ").replace("html","</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|!--)").replace("tag",C._tag).getRegex(),C.blockquote=T(C.blockquote).replace("paragraph",C.paragraph).getRegex(),C.normal=E({},C),C.gfm=E({},C.normal,{nptable:"^ *([^|\\n ].*\\|.*)\\n {0,3}([-:]+ *\\|[-| :]*)(?:\\n((?:(?!\\n|hr|heading|blockquote|code|fences|list|html).*(?:\\n|$))*)\\n*|$)",table:"^ *\\|(.+)\\n {0,3}\\|?( *[-:]+[-| :]*)(?:\\n *((?:(?!\\n|hr|heading|blockquote|code|fences|list|html).*(?:\\n|$))*)\\n*|$)"}),C.gfm.nptable=T(C.gfm.nptable).replace("hr",C.hr).replace("heading"," {0,3}#{1,6} ").replace("blockquote"," {0,3}>").replace("code"," {4}[^\\n]").replace("fences"," {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list"," {0,3}(?:[*+-]|1[.)]) ").replace("html","</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|!--)").replace("tag",C._tag).getRegex(),C.gfm.table=T(C.gfm.table).replace("hr",C.hr).replace("heading"," {0,3}#{1,6} ").replace("blockquote"," {0,3}>").replace("code"," {4}[^\\n]").replace("fences"," {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list"," {0,3}(?:[*+-]|1[.)]) ").replace("html","</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|!--)").replace("tag",C._tag).getRegex(),C.pedantic=E({},C.normal,{html:T("^ *(?:comment *(?:\\n|\\s*$)|<(tag)[\\s\\S]+?</\\1> *(?:\\n{2,}|\\s*$)|<tag(?:\"[^\"]*\"|'[^']*'|\\s[^'\"/>\\s]*)*?/?> *(?:\\n{2,}|\\s*$))").replace("comment",C._comment).replace(/tag/g,"(?!(?:a|em|strong|small|s|cite|q|dfn|abbr|data|time|code|var|samp|kbd|sub|sup|i|b|u|mark|ruby|rt|rp|bdi|bdo|span|br|wbr|ins|del|img)\\b)\\w+(?!:|[^\\w\\s@]*@)\\b").getRegex(),def:/^ *\[([^\]]+)\]: *<?([^\s>]+)>?(?: +(["(][^\n]+[")]))? *(?:\n+|$)/,heading:/^(#{1,6})(.*)(?:\n+|$)/,fences:A,paragraph:T(C.normal._paragraph).replace("hr",C.hr).replace("heading"," *#{1,6} *[^\n]").replace("lheading",C.lheading).replace("blockquote"," {0,3}>").replace("|fences","").replace("|list","").replace("|html","").getRegex()}),(A={escape:/^\\([!"#$%&'()*+,\-./:;<=>?@\[\]\\^_`{|}~])/,autolink:/^<(scheme:[^\s\x00-\x1f<>]*|email)>/,url:A,tag:"^comment|^</[a-zA-Z][\\w:-]*\\s*>|^<[a-zA-Z][\\w-]*(?:attribute)*?\\s*/?>|^<\\?[\\s\\S]*?\\?>|^<![a-zA-Z]+\\s[\\s\\S]*?>|^<!\\[CDATA\\[[\\s\\S]*?\\]\\]>",link:/^!?\[(label)\]\(\s*(href)(?:\s+(title))?\s*\)/,reflink:/^!?\[(label)\]\[(?!\s*\])((?:\\[\[\]]?|[^\[\]\\])+)\]/,nolink:/^!?\[(?!\s*\])((?:\[[^\[\]]*\]|\\[\[\]]|[^\[\]])*)\](?:\[\])?/,reflinkSearch:"reflink|nolink(?!\\()",emStrong:{lDelim:/^(?:\*+(?:([punct_])|[^\s*]))|^_+(?:([punct*])|([^\s_]))/,rDelimAst:/\_\_[^_]*?\*[^_]*?\_\_|[punct_](\*+)(?=[\s]|$)|[^punct*_\s](\*+)(?=[punct_\s]|$)|[punct_\s](\*+)(?=[^punct*_\s])|[\s](\*+)(?=[punct_])|[punct_](\*+)(?=[punct_])|[^punct*_\s](\*+)(?=[^punct*_\s])/,rDelimUnd:/\*\*[^*]*?\_[^*]*?\*\*|[punct*](\_+)(?=[\s]|$)|[^punct*_\s](\_+)(?=[punct*\s]|$)|[punct*\s](\_+)(?=[^punct*_\s])|[\s](\_+)(?=[punct*])|[punct*](\_+)(?=[punct*])/},code:/^(`+)([^`]|[^`][\s\S]*?[^`])\1(?!`)/,br:/^( {2,}|\\)\n(?!\s*$)/,del:A,text:/^(`+|[^`])(?:(?= {2,}\n)|[\s\S]*?(?:(?=[\\<!\[`*_]|\b_|$)|[^ ](?= {2,}\n)))/,punctuation:/^([\spunctuation])/,_punctuation:"!\"#$%&'()+\\-.,/:;<=>?@\\[\\]`^{|}~"}).punctuation=T(A.punctuation).replace(/punctuation/g,A._punctuation).getRegex(),A.blockSkip=/\[[^\]]*?\]\([^\)]*?\)|`[^`]*?`|<[^>]*?>/g,A.escapedEmSt=/\\\*|\\_/g,A._comment=T(C._comment).replace("(?:--\x3e|$)","--\x3e").getRegex(),A.emStrong.lDelim=T(A.emStrong.lDelim).replace(/punct/g,A._punctuation).getRegex(),A.emStrong.rDelimAst=T(A.emStrong.rDelimAst,"g").replace(/punct/g,A._punctuation).getRegex(),A.emStrong.rDelimUnd=T(A.emStrong.rDelimUnd,"g").replace(/punct/g,A._punctuation).getRegex(),A._escapes=/\\([!"#$%&'()*+,\-./:;<=>?@\[\]\\^_`{|}~])/g,A._scheme=/[a-zA-Z][a-zA-Z0-9+.-]{1,31}/,A._email=/[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+(@)[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)+(?![-_])/,A.autolink=T(A.autolink).replace("scheme",A._scheme).replace("email",A._email).getRegex(),A._attribute=/\s+[a-zA-Z:_][\w.:-]*(?:\s*=\s*"[^"]*"|\s*=\s*'[^']*'|\s*=\s*[^\s"'=<>`]+)?/,A.tag=T(A.tag).replace("comment",A._comment).replace("attribute",A._attribute).getRegex(),A._label=/(?:\[(?:\\.|[^\[\]\\])*\]|\\.|`[^`]*`|[^\[\]\\`])*?/,A._href=/<(?:\\.|[^\n<>\\])+>|[^\s\x00-\x1f]*/,A._title=/"(?:\\"?|[^"\\])*"|'(?:\\'?|[^'\\])*'|\((?:\\\)?|[^)\\])*\)/,A.link=T(A.link).replace("label",A._label).replace("href",A._href).replace("title",A._title).getRegex(),A.reflink=T(A.reflink).replace("label",A._label).getRegex(),A.reflinkSearch=T(A.reflinkSearch,"g").replace("reflink",A.reflink).replace("nolink",A.nolink).getRegex(),A.normal=E({},A),A.pedantic=E({},A.normal,{strong:{start:/^__|\*\*/,middle:/^__(?=\S)([\s\S]*?\S)__(?!_)|^\*\*(?=\S)([\s\S]*?\S)\*\*(?!\*)/,endAst:/\*\*(?!\*)/g,endUnd:/__(?!_)/g},em:{start:/^_|\*/,middle:/^()\*(?=\S)([\s\S]*?\S)\*(?!\*)|^_(?=\S)([\s\S]*?\S)_(?!_)/,endAst:/\*(?!\*)/g,endUnd:/_(?!_)/g},link:T(/^!?\[(label)\]\((.*?)\)/).replace("label",A._label).getRegex(),reflink:T(/^!?\[(label)\]\s*\[([^\]]*)\]/).replace("label",A._label).getRegex()}),A.gfm=E({},A.normal,{escape:T(A.escape).replace("])","~|])").getRegex(),_extended_email:/[A-Za-z0-9._+-]+(@)[a-zA-Z0-9-_]+(?:\.[a-zA-Z0-9-_]*[a-zA-Z0-9])+(?![-_])/,url:/^((?:ftp|https?):\/\/|www\.)(?:[a-zA-Z0-9\-]+\.?)+[^\s<]*|^email/,_backpedal:/(?:[^?!.,:;*_~()&]+|\([^)]*\)|&(?![a-zA-Z0-9]+;$)|[?!.,:;*_~)]+(?!$))+/,del:/^(~~?)(?=[^\s~])([\s\S]*?[^\s~])\1(?=[^~]|$)/,text:/^([`~]+|[^`~])(?:(?= {2,}\n)|[\s\S]*?(?:(?=[\\<!\[`*~_]|\b_|https?:\/\/|ftp:\/\/|www\.|$)|[^ ](?= {2,}\n)|[^a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-](?=[a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-]+@))|(?=[a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-]+@))/}),A.gfm.url=T(A.gfm.url,"i").replace("email",A.gfm._extended_email).getRegex(),A.breaks=E({},A.gfm,{br:T(A.br).replace("{2,}","*").getRegex(),text:T(A.gfm.text).replace("\\b_","\\b_| {2,}\\n").replace(/\{2,\}/g,"*").getRegex()}),A={block:C,inline:A};var P=a.defaults,R=A.block,N=A.inline,V=L;function U(e){return e.replace(/---/g,"—").replace(/--/g,"–").replace(/(^|[-\u2014/(\[{"\s])'/g,"$1‘").replace(/'/g,"’").replace(/(^|[-\u2014/(\[{\u2018\s])"/g,"$1“").replace(/"/g,"”").replace(/\.{3}/g,"…")}function W(e){for(var t,r="",n=e.length,o=0;o<n;o++)t=e.charCodeAt(o),r+="&#"+(t=.5<Math.random()?"x"+t.toString(16):t)+";";return r}var j=function(){function t(e){this.tokens=[],this.tokens.links=Object.create(null),this.options=e||P,this.options.tokenizer=this.options.tokenizer||new O,this.tokenizer=this.options.tokenizer,this.tokenizer.options=this.options,e={block:R.normal,inline:N.normal},this.options.pedantic?(e.block=R.pedantic,e.inline=N.pedantic):this.options.gfm&&(e.block=R.gfm,this.options.breaks?e.inline=N.breaks:e.inline=N.gfm),this.tokenizer.rules=e}t.lex=function(e,r){return new t(r).lex(e)},t.lexInline=function(e,r){return new t(r).inlineTokens(e)};var r,n,o=t.prototype;return o.lex=function(e){return e=e.replace(/\r\n|\r/g,"\n").replace(/\t/g,"    "),this.blockTokens(e,this.tokens,!0),this.inline(this.tokens),this.tokens},o.blockTokens=function(e,t,r){var n,o,a,i;for(void 0===t&&(t=[]),void 0===r&&(r=!0),this.options.pedantic&&(e=e.replace(/^ +$/gm,""));e;)if(n=this.tokenizer.space(e))e=e.substring(n.raw.length),n.type&&t.push(n);else if(n=this.tokenizer.code(e))e=e.substring(n.raw.length),(i=t[t.length-1])&&"paragraph"===i.type?(i.raw+="\n"+n.raw,i.text+="\n"+n.text):t.push(n);else if(n=this.tokenizer.fences(e))e=e.substring(n.raw.length),t.push(n);else if(n=this.tokenizer.heading(e))e=e.substring(n.raw.length),t.push(n);else if(n=this.tokenizer.nptable(e))e=e.substring(n.raw.length),t.push(n);else if(n=this.tokenizer.hr(e))e=e.substring(n.raw.length),t.push(n);else if(n=this.tokenizer.blockquote(e))e=e.substring(n.raw.length),n.tokens=this.blockTokens(n.text,[],r),t.push(n);else if(n=this.tokenizer.list(e)){for(e=e.substring(n.raw.length),a=n.items.length,o=0;o<a;o++)n.items[o].tokens=this.blockTokens(n.items[o].text,[],!1);t.push(n)}else if(n=this.tokenizer.html(e))e=e.substring(n.raw.length),t.push(n);else if(r&&(n=this.tokenizer.def(e)))e=e.substring(n.raw.length),this.tokens.links[n.tag]||(this.tokens.links[n.tag]={href:n.href,title:n.title});else if(n=this.tokenizer.table(e))e=e.substring(n.raw.length),t.push(n);else if(n=this.tokenizer.lheading(e))e=e.substring(n.raw.length),t.push(n);else if(r&&(n=this.tokenizer.paragraph(e)))e=e.substring(n.raw.length),t.push(n);else if(n=this.tokenizer.text(e))e=e.substring(n.raw.length),(i=t[t.length-1])&&"text"===i.type?(i.raw+="\n"+n.raw,i.text+="\n"+n.text):t.push(n);else if(e){var s="Infinite loop on byte: "+e.charCodeAt(0);if(this.options.silent){console.error(s);break}throw new Error(s)}return t},o.inline=function(e){for(var t,r,n,o,a,i=e.length,s=0;s<i;s++)switch((a=e[s]).type){case"paragraph":case"text":case"heading":a.tokens=[],this.inlineTokens(a.text,a.tokens);break;case"table":for(a.tokens={header:[],cells:[]},n=a.header.length,t=0;t<n;t++)a.tokens.header[t]=[],this.inlineTokens(a.header[t],a.tokens.header[t]);for(n=a.cells.length,t=0;t<n;t++)for(o=a.cells[t],a.tokens.cells[t]=[],r=0;r<o.length;r++)a.tokens.cells[t][r]=[],this.inlineTokens(o[r],a.tokens.cells[t][r]);break;case"blockquote":this.inline(a.tokens);break;case"list":for(n=a.items.length,t=0;t<n;t++)this.inline(a.items[t].tokens)}return e},o.inlineTokens=function(e,t,r,n){var o;void 0===t&&(t=[]),void 0===r&&(r=!1),void 0===n&&(n=!1);var a,i,s,l=e;if(this.tokens.links){var d=Object.keys(this.tokens.links);if(0<d.length)for(;null!=(a=this.tokenizer.rules.inline.reflinkSearch.exec(l));)d.includes(a[0].slice(a[0].lastIndexOf("[")+1,-1))&&(l=l.slice(0,a.index)+"["+V("a",a[0].length-2)+"]"+l.slice(this.tokenizer.rules.inline.reflinkSearch.lastIndex))}for(;null!=(a=this.tokenizer.rules.inline.blockSkip.exec(l));)l=l.slice(0,a.index)+"["+V("a",a[0].length-2)+"]"+l.slice(this.tokenizer.rules.inline.blockSkip.lastIndex);for(;null!=(a=this.tokenizer.rules.inline.escapedEmSt.exec(l));)l=l.slice(0,a.index)+"++"+l.slice(this.tokenizer.rules.inline.escapedEmSt.lastIndex);for(;e;)if(i||(s=""),i=!1,o=this.tokenizer.escape(e))e=e.substring(o.raw.length),t.push(o);else if(o=this.tokenizer.tag(e,r,n)){e=e.substring(o.raw.length),r=o.inLink,n=o.inRawBlock;var m=t[t.length-1];m&&"text"===o.type&&"text"===m.type?(m.raw+=o.raw,m.text+=o.text):t.push(o)}else if(o=this.tokenizer.link(e))e=e.substring(o.raw.length),"link"===o.type&&(o.tokens=this.inlineTokens(o.text,[],!0,n)),t.push(o);else if(o=this.tokenizer.reflink(e,this.tokens.links))e=e.substring(o.raw.length),m=t[t.length-1],"link"===o.type?(o.tokens=this.inlineTokens(o.text,[],!0,n),t.push(o)):m&&"text"===o.type&&"text"===m.type?(m.raw+=o.raw,m.text+=o.text):t.push(o);else if(o=this.tokenizer.emStrong(e,l,s))e=e.substring(o.raw.length),o.tokens=this.inlineTokens(o.text,[],r,n),t.push(o);else if(o=this.tokenizer.codespan(e))e=e.substring(o.raw.length),t.push(o);else if(o=this.tokenizer.br(e))e=e.substring(o.raw.length),t.push(o);else if(o=this.tokenizer.del(e))e=e.substring(o.raw.length),o.tokens=this.inlineTokens(o.text,[],r,n),t.push(o);else if(o=this.tokenizer.autolink(e,W))e=e.substring(o.raw.length),t.push(o);else if(r||!(o=this.tokenizer.url(e,W))){if(o=this.tokenizer.inlineText(e,n,U))e=e.substring(o.raw.length),"_"!==o.raw.slice(-1)&&(s=o.raw.slice(-1)),i=!0,(c=t[t.length-1])&&"text"===c.type?(c.raw+=o.raw,c.text+=o.text):t.push(o);else if(e){var c="Infinite loop on byte: "+e.charCodeAt(0);if(this.options.silent){console.error(c);break}throw new Error(c)}}else e=e.substring(o.raw.length),t.push(o);return t},r=t,n=[{key:"rules",get:function(){return{block:R,inline:N}}}],(o=null)&&e(r.prototype,o),n&&e(r,n),t}(),q=a.defaults,G=D,X=_,Y=function(){function e(e){this.options=e||q}var t=e.prototype;return t.code=function(e,t,r){var n=(t||"").match(/\S*/)[0];return!this.options.highlight||null!=(t=this.options.highlight(e,n))&&t!==e&&(r=!0,e=t),e=e.replace(/\n$/,"")+"\n",n?'<pre><code class="'+this.options.langPrefix+X(n,!0)+'">'+(r?e:X(e,!0))+"</code></pre>\n":"<pre><code>"+(r?e:X(e,!0))+"</code></pre>\n"},t.blockquote=function(e){return"<blockquote>\n"+e+"</blockquote>\n"},t.html=function(e){return e},t.heading=function(e,t,r,n){return this.options.headerIds?"<h"+t+' id="'+this.options.headerPrefix+n.slug(r)+'">'+e+"</h"+t+">\n":"<h"+t+">"+e+"</h"+t+">\n"},t.hr=function(){return this.options.xhtml?"<hr/>\n":"<hr>\n"},t.list=function(e,t,r){var n=t?"ol":"ul";return"<"+n+(t&&1!==r?' start="'+r+'"':"")+">\n"+e+"</"+n+">\n"},t.listitem=function(e){return"<li>"+e+"</li>\n"},t.checkbox=function(e){return"<input "+(e?'checked="" ':"")+'disabled="" type="checkbox"'+(this.options.xhtml?" /":"")+"> "},t.paragraph=function(e){return"<p>"+e+"</p>\n"},t.table=function(e,t){return"<table>\n<thead>\n"+e+"</thead>\n"+(t=t&&"<tbody>"+t+"</tbody>")+"</table>\n"},t.tablerow=function(e){return"<tr>\n"+e+"</tr>\n"},t.tablecell=function(e,t){var r=t.header?"th":"td";return(t.align?"<"+r+' align="'+t.align+'">':"<"+r+">")+e+"</"+r+">\n"},t.strong=function(e){return"<strong>"+e+"</strong>"},t.em=function(e){return"<em>"+e+"</em>"},t.codespan=function(e){return"<code>"+e+"</code>"},t.br=function(){return this.options.xhtml?"<br/>":"<br>"},t.del=function(e){return"<del>"+e+"</del>"},t.link=function(e,t,r){return null===(e=G(this.options.sanitize,this.options.baseUrl,e))?r:(e='<a href="'+X(e)+'"',t&&(e+=' title="'+t+'"'),e+">"+r+"</a>")},t.image=function(e,t,r){return null===(e=G(this.options.sanitize,this.options.baseUrl,e))?r:(r='<img src="'+e+'" alt="'+r+'"',t&&(r+=' title="'+t+'"'),r+(this.options.xhtml?"/>":">"))},t.text=function(e){return e},e}(),K=function(){function e(){}var t=e.prototype;return t.strong=function(e){return e},t.em=function(e){return e},t.codespan=function(e){return e},t.del=function(e){return e},t.html=function(e){return e},t.text=function(e){return e},t.link=function(e,t,r){return""+r},t.image=function(e,t,r){return""+r},t.br=function(){return""},e}(),Z=function(){function e(){this.seen={}}var t=e.prototype;return t.serialize=function(e){return e.toLowerCase().trim().replace(/<[!\/a-z].*?>/gi,"").replace(/[\u2000-\u206F\u2E00-\u2E7F\\'!"#$%&()*+,./:;<=>?@[\]^`{|}~]/g,"").replace(/\s/g,"-")},t.getNextSafeSlug=function(e,t){var r=e,n=0;if(this.seen.hasOwnProperty(r))for(n=this.seen[e];r=e+"-"+ ++n,this.seen.hasOwnProperty(r););return t||(this.seen[e]=n,this.seen[r]=0),r},t.slug=function(e,t){void 0===t&&(t={});var r=this.serialize(e);return this.getNextSafeSlug(r,t.dryrun)},e}(),Q=a.defaults,J=k,ee=function(){function e(e){this.options=e||Q,this.options.renderer=this.options.renderer||new Y,this.renderer=this.options.renderer,this.renderer.options=this.options,this.textRenderer=new K,this.slugger=new Z}e.parse=function(t,r){return new e(r).parse(t)},e.parseInline=function(t,r){return new e(r).parseInline(t)};var t=e.prototype;return t.parse=function(e,t){void 0===t&&(t=!0);for(var r,n,o,a,i,s,l,d,m,c,u,p,h,b,g,f="",v=e.length,w=0;w<v;w++)switch((d=e[w]).type){case"space":continue;case"hr":f+=this.renderer.hr();continue;case"heading":f+=this.renderer.heading(this.parseInline(d.tokens),d.depth,J(this.parseInline(d.tokens,this.textRenderer)),this.slugger);continue;case"code":f+=this.renderer.code(d.text,d.lang,d.escaped);continue;case"table":for(s=m="",o=d.header.length,r=0;r<o;r++)s+=this.renderer.tablecell(this.parseInline(d.tokens.header[r]),{header:!0,align:d.align[r]});for(m+=this.renderer.tablerow(s),l="",o=d.cells.length,r=0;r<o;r++){for(s="",a=(i=d.tokens.cells[r]).length,n=0;n<a;n++)s+=this.renderer.tablecell(this.parseInline(i[n]),{header:!1,align:d.align[n]});l+=this.renderer.tablerow(s)}f+=this.renderer.table(m,l);continue;case"blockquote":l=this.parse(d.tokens),f+=this.renderer.blockquote(l);continue;case"list":for(m=d.ordered,x=d.start,c=d.loose,o=d.items.length,l="",r=0;r<o;r++)h=(p=d.items[r]).checked,b=p.task,u="",p.task&&(g=this.renderer.checkbox(h),c?0<p.tokens.length&&"text"===p.tokens[0].type?(p.tokens[0].text=g+" "+p.tokens[0].text,p.tokens[0].tokens&&0<p.tokens[0].tokens.length&&"text"===p.tokens[0].tokens[0].type&&(p.tokens[0].tokens[0].text=g+" "+p.tokens[0].tokens[0].text)):p.tokens.unshift({type:"text",text:g}):u+=g),u+=this.parse(p.tokens,c),l+=this.renderer.listitem(u,b,h);f+=this.renderer.list(l,m,x);continue;case"html":f+=this.renderer.html(d.text);continue;case"paragraph":f+=this.renderer.paragraph(this.parseInline(d.tokens));continue;case"text":for(l=d.tokens?this.parseInline(d.tokens):d.text;w+1<v&&"text"===e[w+1].type;)l+="\n"+((d=e[++w]).tokens?this.parseInline(d.tokens):d.text);f+=t?this.renderer.paragraph(l):l;continue;default:var x='Token with "'+d.type+'" type was not found.';if(this.options.silent)return void console.error(x);throw new Error(x)}return f},t.parseInline=function(e,t){t=t||this.renderer;for(var r,n="",o=e.length,a=0;a<o;a++)switch((r=e[a]).type){case"escape":case"text":n+=t.text(r.text);break;case"html":n+=t.html(r.text);break;case"link":n+=t.link(r.href,r.title,this.parseInline(r.tokens,t));break;case"image":n+=t.image(r.href,r.title,r.text);break;case"strong":n+=t.strong(this.parseInline(r.tokens,t));break;case"em":n+=t.em(this.parseInline(r.tokens,t));break;case"codespan":n+=t.codespan(r.text);break;case"br":n+=t.br();break;case"del":n+=t.del(this.parseInline(r.tokens,t));break;default:var i='Token with "'+r.type+'" type was not found.';if(this.options.silent)return void console.error(i);throw new Error(i)}return n},e}(),te=S,re=z,ne=_,oe=(_=a.getDefaults,a.changeDefaults);function ae(e,t,r){if(null==e)throw new Error("marked(): input parameter is undefined or null");if("string"!=typeof e)throw new Error("marked(): input parameter is of type "+Object.prototype.toString.call(e)+", string expected");if("function"==typeof t&&(r=t,t=null),t=te({},ae.defaults,t||{}),re(t),r){var n,o=t.highlight;try{n=j.lex(e,t)}catch(e){return r(e)}var a=function(e){var a;if(!e)try{a=ee.parse(n,t)}catch(a){e=a}return t.highlight=o,e?r(e):r(null,a)};if(!o||o.length<3)return a();if(delete t.highlight,!n.length)return a();var i=0;return ae.walkTokens(n,(function(e){"code"===e.type&&(i++,setTimeout((function(){o(e.text,e.lang,(function(t,r){return t?a(t):(null!=r&&r!==e.text&&(e.text=r,e.escaped=!0),void(0==--i&&a()))}))}),0))})),void(0===i&&a())}try{var s=j.lex(e,t);return t.walkTokens&&ae.walkTokens(s,t.walkTokens),ee.parse(s,t)}catch(e){if(e.message+="\nPlease report this to https://github.com/markedjs/marked.",t.silent)return"<p>An error occurred:</p><pre>"+ne(e.message+"",!0)+"</pre>";throw e}}return a=a.defaults,ae.options=ae.setOptions=function(e){return te(ae.defaults,e),oe(ae.defaults),ae},ae.getDefaults=_,ae.defaults=a,ae.use=function(e){var t,r=te({},e);e.renderer&&function(){var t,n=ae.defaults.renderer||new Y;for(t in e.renderer)!function(t){var r=n[t];n[t]=function(){for(var o=arguments.length,a=new Array(o),i=0;i<o;i++)a[i]=arguments[i];var s=e.renderer[t].apply(n,a);return!1===s?r.apply(n,a):s}}(t);r.renderer=n}(),e.tokenizer&&function(){var t,n=ae.defaults.tokenizer||new O;for(t in e.tokenizer)!function(t){var r=n[t];n[t]=function(){for(var o=arguments.length,a=new Array(o),i=0;i<o;i++)a[i]=arguments[i];var s=e.tokenizer[t].apply(n,a);return!1===s?r.apply(n,a):s}}(t);r.tokenizer=n}(),e.walkTokens&&(t=ae.defaults.walkTokens,r.walkTokens=function(r){e.walkTokens(r),t&&t(r)}),ae.setOptions(r)},ae.walkTokens=function(e,t){for(var n,o=r(e);!(n=o()).done;){var a=n.value;switch(t(a),a.type){case"table":for(var i=r(a.tokens.header);!(s=i()).done;){var s=s.value;ae.walkTokens(s,t)}for(var l,d=r(a.tokens.cells);!(l=d()).done;)for(var m=r(l.value);!(c=m()).done;){var c=c.value;ae.walkTokens(c,t)}break;case"list":ae.walkTokens(a.items,t);break;default:a.tokens&&ae.walkTokens(a.tokens,t)}}},ae.parseInline=function(e,t){if(null==e)throw new Error("marked.parseInline(): input parameter is undefined or null");if("string"!=typeof e)throw new Error("marked.parseInline(): input parameter is of type "+Object.prototype.toString.call(e)+", string expected");t=te({},ae.defaults,t||{}),re(t);try{var r=j.lexInline(e,t);return t.walkTokens&&ae.walkTokens(r,t.walkTokens),ee.parseInline(r,t)}catch(e){if(e.message+="\nPlease report this to https://github.com/markedjs/marked.",t.silent)return"<p>An error occurred:</p><pre>"+ne(e.message+"",!0)+"</pre>";throw e}},ae.Parser=ee,ae.parser=ee.parse,ae.Renderer=Y,ae.TextRenderer=K,ae.Lexer=j,ae.lexer=j.lex,ae.Tokenizer=O,ae.Slugger=Z,ae.parse=ae}()},8673:e=>{var t=function(e){"use strict";var t,r=Object.prototype,n=r.hasOwnProperty,o="function"==typeof Symbol?Symbol:{},a=o.iterator||"@@iterator",i=o.asyncIterator||"@@asyncIterator",s=o.toStringTag||"@@toStringTag";function l(e,t,r){return Object.defineProperty(e,t,{value:r,enumerable:!0,configurable:!0,writable:!0}),e[t]}try{l({},"")}catch(e){l=function(e,t,r){return e[t]=r}}function d(e,t,r,n){var o=t&&t.prototype instanceof g?t:g,a=Object.create(o.prototype),i=new A(n||[]);return a._invoke=function(e,t,r){var n=c;return function(o,a){if(n===p)throw new Error("Generator is already running");if(n===h){if("throw"===o)throw a;return z()}for(r.method=o,r.arg=a;;){var i=r.delegate;if(i){var s=D(i,r);if(s){if(s===b)continue;return s}}if("next"===r.method)r.sent=r._sent=r.arg;else if("throw"===r.method){if(n===c)throw n=h,r.arg;r.dispatchException(r.arg)}else"return"===r.method&&r.abrupt("return",r.arg);n=p;var l=m(e,t,r);if("normal"===l.type){if(n=r.done?h:u,l.arg===b)continue;return{value:l.arg,done:r.done}}"throw"===l.type&&(n=h,r.method="throw",r.arg=l.arg)}}}(e,r,i),a}function m(e,t,r){try{return{type:"normal",arg:e.call(t,r)}}catch(e){return{type:"throw",arg:e}}}e.wrap=d;var c="suspendedStart",u="suspendedYield",p="executing",h="completed",b={};function g(){}function f(){}function v(){}var w={};w[a]=function(){return this};var x=Object.getPrototypeOf,y=x&&x(x(T([])));y&&y!==r&&n.call(y,a)&&(w=y);var _=v.prototype=g.prototype=Object.create(w);function k(e){["next","throw","return"].forEach((function(t){l(e,t,(function(e){return this._invoke(t,e)}))}))}function C(e,t){function r(o,a,i,s){var l=m(e[o],e,a);if("throw"!==l.type){var d=l.arg,c=d.value;return c&&"object"==typeof c&&n.call(c,"__await")?t.resolve(c.__await).then((function(e){r("next",e,i,s)}),(function(e){r("throw",e,i,s)})):t.resolve(c).then((function(e){d.value=e,i(d)}),(function(e){return r("throw",e,i,s)}))}s(l.arg)}var o;this._invoke=function(e,n){function a(){return new t((function(t,o){r(e,n,t,o)}))}return o=o?o.then(a,a):a()}}function D(e,r){var n=e.iterator[r.method];if(n===t){if(r.delegate=null,"throw"===r.method){if(e.iterator.return&&(r.method="return",r.arg=t,D(e,r),"throw"===r.method))return b;r.method="throw",r.arg=new TypeError("The iterator does not provide a 'throw' method")}return b}var o=m(n,e.iterator,r.arg);if("throw"===o.type)return r.method="throw",r.arg=o.arg,r.delegate=null,b;var a=o.arg;return a?a.done?(r[e.resultName]=a.value,r.next=e.nextLoc,"return"!==r.method&&(r.method="next",r.arg=t),r.delegate=null,b):a:(r.method="throw",r.arg=new TypeError("iterator result is not an object"),r.delegate=null,b)}function E(e){var t={tryLoc:e[0]};1 in e&&(t.catchLoc=e[1]),2 in e&&(t.finallyLoc=e[2],t.afterLoc=e[3]),this.tryEntries.push(t)}function S(e){var t=e.completion||{};t.type="normal",delete t.arg,e.completion=t}function A(e){this.tryEntries=[{tryLoc:"root"}],e.forEach(E,this),this.reset(!0)}function T(e){if(e){var r=e[a];if(r)return r.call(e);if("function"==typeof e.next)return e;if(!isNaN(e.length)){var o=-1,i=function r(){for(;++o<e.length;)if(n.call(e,o))return r.value=e[o],r.done=!1,r;return r.value=t,r.done=!0,r};return i.next=i}}return{next:z}}function z(){return{value:t,done:!0}}return f.prototype=_.constructor=v,v.constructor=f,f.displayName=l(v,s,"GeneratorFunction"),e.isGeneratorFunction=function(e){var t="function"==typeof e&&e.constructor;return!!t&&(t===f||"GeneratorFunction"===(t.displayName||t.name))},e.mark=function(e){return Object.setPrototypeOf?Object.setPrototypeOf(e,v):(e.__proto__=v,l(e,s,"GeneratorFunction")),e.prototype=Object.create(_),e},e.awrap=function(e){return{__await:e}},k(C.prototype),C.prototype[i]=function(){return this},e.AsyncIterator=C,e.async=function(t,r,n,o,a){void 0===a&&(a=Promise);var i=new C(d(t,r,n,o),a);return e.isGeneratorFunction(r)?i:i.next().then((function(e){return e.done?e.value:i.next()}))},k(_),l(_,s,"Generator"),_[a]=function(){return this},_.toString=function(){return"[object Generator]"},e.keys=function(e){var t=[];for(var r in e)t.push(r);return t.reverse(),function r(){for(;t.length;){var n=t.pop();if(n in e)return r.value=n,r.done=!1,r}return r.done=!0,r}},e.values=T,A.prototype={constructor:A,reset:function(e){if(this.prev=0,this.next=0,this.sent=this._sent=t,this.done=!1,this.delegate=null,this.method="next",this.arg=t,this.tryEntries.forEach(S),!e)for(var r in this)"t"===r.charAt(0)&&n.call(this,r)&&!isNaN(+r.slice(1))&&(this[r]=t)},stop:function(){this.done=!0;var e=this.tryEntries[0].completion;if("throw"===e.type)throw e.arg;return this.rval},dispatchException:function(e){if(this.done)throw e;var r=this;function o(n,o){return s.type="throw",s.arg=e,r.next=n,o&&(r.method="next",r.arg=t),!!o}for(var a=this.tryEntries.length-1;a>=0;--a){var i=this.tryEntries[a],s=i.completion;if("root"===i.tryLoc)return o("end");if(i.tryLoc<=this.prev){var l=n.call(i,"catchLoc"),d=n.call(i,"finallyLoc");if(l&&d){if(this.prev<i.catchLoc)return o(i.catchLoc,!0);if(this.prev<i.finallyLoc)return o(i.finallyLoc)}else if(l){if(this.prev<i.catchLoc)return o(i.catchLoc,!0)}else{if(!d)throw new Error("try statement without catch or finally");if(this.prev<i.finallyLoc)return o(i.finallyLoc)}}}},abrupt:function(e,t){for(var r=this.tryEntries.length-1;r>=0;--r){var o=this.tryEntries[r];if(o.tryLoc<=this.prev&&n.call(o,"finallyLoc")&&this.prev<o.finallyLoc){var a=o;break}}a&&("break"===e||"continue"===e)&&a.tryLoc<=t&&t<=a.finallyLoc&&(a=null);var i=a?a.completion:{};return i.type=e,i.arg=t,a?(this.method="next",this.next=a.finallyLoc,b):this.complete(i)},complete:function(e,t){if("throw"===e.type)throw e.arg;return"break"===e.type||"continue"===e.type?this.next=e.arg:"return"===e.type?(this.rval=this.arg=e.arg,this.method="return",this.next="end"):"normal"===e.type&&t&&(this.next=t),b},finish:function(e){for(var t=this.tryEntries.length-1;t>=0;--t){var r=this.tryEntries[t];if(r.finallyLoc===e)return this.complete(r.completion,r.afterLoc),S(r),b}},catch:function(e){for(var t=this.tryEntries.length-1;t>=0;--t){var r=this.tryEntries[t];if(r.tryLoc===e){var n=r.completion;if("throw"===n.type){var o=n.arg;S(r)}return o}}throw new Error("illegal catch attempt")},delegateYield:function(e,r,n){return this.delegate={iterator:T(e),resultName:r,nextLoc:n},"next"===this.method&&(this.arg=t),b}},e}(e.exports);try{regeneratorRuntime=t}catch(e){Function("r","regeneratorRuntime = r")(t)}},7407:()=>{Smart("smart-button",class extends Smart.ContentElement{static get properties(){return{value:{type:"string"},name:{type:"string"},type:{value:"button",type:"string"},clickMode:{allowedValues:["hover","press","release","pressAndRelease"],type:"string",value:"release"}}}static get styleUrls(){return["smart.button.css"]}template(){return"<button class=\"smart-button smart-unselectable\" inner-h-t-m-l='[[innerHTML]]' id='button' type='[[type]]' name='[[name]]' value='[[value]]' disabled='[[disabled]]' role=\"presentation\"></button>"}refresh(){}static get listeners(){return{"button.down":"_downHandler","button.mouseenter":"_mouseEnterHandler","button.mouseleave":"_mouseLeaveHandler","button.touchend":"_touchEndHandler","button.click":"_clickHandler","button.up":"_upHandler",up:"_upHandler","button.focus":"_focusHandler","button.blur":"_blurHandler"}}focus(){const e=this;e.$.button?e.$.button.focus():HTMLElement.prototype.focus.call(e)}blur(){const e=this;e.$.button?e.$.button.blur():HTMLElement.prototype.blur.call(e)}_upHandler(e){const t=this;if(e.stopPropagation(),t.$.setAttributeValue("active",!1),t.dataset.target){const r=document.querySelector(t.dataset.target);let n=t.dataset.toggle;const o="smart-window".toLowerCase();if(r&&r.nodeName.toLowerCase()===o&&"modal"===n&&(n="openModal"),"tab"===n||"pill"===n||"list"===n){const e=this.closest(".nav, .list-group"),n='[data-toggle="tab"], [data-toggle="pill"], [data-toggle="list"]',o=!e||"UL"!==e.nodeName&&"OL"!==e.nodeName?e.children(".active"):e.querySelectorAll("li > .active");if(e){const r=e.querySelectorAll(n);for(let e=0;e<r.length;e++)r[e].classList.remove("primary");for(let e=0;e<o.length;e++)o[e].classList.remove("active");let a=t.parentNode;for(;a;){if("LI"===a.nodeName){a.classList.add("active");break}a=a.parentNode}t.classList.add("primary")}return r.parentNode.querySelectorAll(".active").forEach((e=>{e.classList.remove("active"),e.classList.add("smart-hidden")})),r.classList.add("active"),void r.classList.remove("smart-hidden")}n&&r&&!r[n]&&"collapse"===n&&(setTimeout((()=>{r.classList.contains("smart-hidden")?r.classList.remove("smart-hidden"):r.classList.add("smart-hidden")})),e.originalEvent.preventDefault()),n&&r&&!r[n]&&"dropdown"===n?(setTimeout((()=>{r.opened=!r.opened})),e.originalEvent.preventDefault()):n&&r&&r[n]&&(setTimeout((()=>{r[n]()}),50),e.originalEvent.preventDefault())}}_focusHandler(){this.$.setAttributeValue("focus",!0),this.$.fireEvent("focus")}_blurHandler(){this.$.setAttributeValue("focus",!1),this.$.fireEvent("blur")}_clickHandler(e){const t=this;("release"!==t.clickMode&&"pressAndRelease"!==t.clickMode||t.readonly)&&(e.preventDefault(),e.stopPropagation())}_downHandler(e){const t=this;if(!(t.disabled||(t.hasRippleAnimation&&Smart.Utilities.Animation.Ripple.animate(t,e.pageX,e.pageY),t.$.setAttributeValue("active",!0),"press"!==t.clickMode&&"pressAndRelease"!==t.clickMode||t.readonly))){if(t.hasAttribute("smart-blazor"))return void t.$.dispatchEvent(new Event("click"));const r="buttons"in e?e.buttons:e.which;t.$.fireEvent("click",{buttons:r,clientX:e.clientX,clientY:e.clientY,pageX:e.pageX,pageY:e.pageY,screenX:e.screenX,screenY:e.screenY})}}_mouseEnterHandler(e){const t=this;if(!t.readonly&&(t.$button.setAttributeValue("hover",!0),t.$.setAttributeValue("hover",!0),"hover"===t.clickMode)){const r="buttons"in e?e.buttons:e.which;if(t.hasAttribute("smart-blazor"))return void t.$.dispatchEvent(new Event("click"));t.$.fireEvent("click",{buttons:r,clientX:e.clientX,clientY:e.clientY,pageX:e.pageX,pageY:e.pageY,screenX:e.screenX,screenY:e.screenY})}}_touchEndHandler(){const e=this;setTimeout((function(){e.$button.setAttributeValue("hover",!1),e.$.setAttributeValue("hover",!1)}),300)}_mouseLeaveHandler(){this.$button.setAttributeValue("hover",!1),this.$.setAttributeValue("hover",!1)}propertyChangedHandler(e,t,r){super.propertyChangedHandler(e,t,r);const n=this;"disabled"===e?(n._setFocusable(),n.$button&&n.$button.setAttributeValue("hover",!1),n.$.setAttributeValue("hover",!1),n instanceof Smart.RepeatButton&&n._stopRepeat()):"unfocusable"===e&&n._setFocusable()}_setFocusable(){const e=this,t=e.$.button?e.$.button:e;if(e.disabled||e.unfocusable)return t.removeAttribute("tabindex"),void(t.tabIndex=-1);t.tabIndex=e.tabIndex>0?e.tabIndex:0}ready(){const e=this;super.ready(),e.setAttribute("role","button"),e._setFocusable(),e.enableShadowDOM&&e.$.hiddenInput&&e.appendChild(e.$.hiddenInput)}}),Smart("smart-repeat-button",class extends Smart.Button{static get properties(){return{delay:{value:50,type:"number"},initialDelay:{value:150,type:"number"}}}static get listeners(){return{"button.down":"_startRepeat","button.mouseenter":"_overriddenHandler","button.mouseleave":"_overriddenHandler","button.pointerenter":"_updateInBoundsFlag","button.pointerleave":"_updateInBoundsFlag","button.touchmove":"_touchmoveHandler","document.up":"_stopRepeat"}}_clickHandler(e){const t=this;("release"!==t.clickMode||t.preventDefaultClick||t.readonly||t.disabled)&&(e.preventDefault(),e.stopPropagation(),t.preventDefaultClick=!1)}_updateInBoundsFlag(e){const t=this;-1!==e.type.indexOf("leave")?(t._isPointerInBounds=!1,t.$button.setAttributeValue("hover",!1),t.$.setAttributeValue("hover",!1)):(t._isPointerInBounds=!0,t.$button.setAttributeValue("hover",!0),t.$.setAttributeValue("hover",!0));1!==("buttons"in e?e.buttons:e.which)&&t._stopRepeat(e)}_startRepeat(e){const t=this;t.setAttribute("active",""),t._initialTimer||t.readonly||(t._initialTimer=setTimeout((function(){t._repeatTimer=setInterval((()=>{if(t._isPointerInBounds){if(t.hasAttribute("smart-blazor"))return t.$.dispatchEvent(new Event("click")),void(t.preventDefaultClick=!0);const r="buttons"in e?e.buttons:e.which;t.$.fireEvent("click",{buttons:r,clientX:e.clientX,clientY:e.clientY,pageX:e.pageX,pageY:e.pageY,screenX:e.screenX,screenY:e.screenY}),t.preventDefaultClick=!0}}),t.delay)}),t.initialDelay))}_stopRepeat(e){const t=this;t.readonly||e&&("pointercancel"===e.type||e.originalEvent&&"pointercancel"===e.originalEvent.type)||(t.$.setAttributeValue("active",!1),t._repeatTimer&&(clearInterval(t._repeatTimer),t._repeatTimer=null),t._initialTimer&&(clearTimeout(t._initialTimer),t._initialTimer=null))}_touchmoveHandler(e){this.preventDefaultClick&&e.cancelable&&(e.preventDefault(),e.stopPropagation())}_overriddenHandler(){}}),Smart("smart-toggle-button",class extends Smart.Button{static get properties(){return{checked:{value:!1,type:"boolean?"},falseContent:{value:"",reflectToAttribute:!1,type:"string"},indeterminateContent:{value:"",reflectToAttribute:!1,type:"string"},indeterminate:{value:!1,type:"boolean"},trueContent:{value:"",reflectToAttribute:!1,type:"string"},indeterminateTemplate:{value:null,type:"any"},trueTemplate:{value:null,type:"any"},falseTemplate:{value:null,type:"any"},type:{value:"toggle",type:"string",defaultReflectToAttribute:!0,readonly:!0}}}static get listeners(){return{keydown:"_keyHandler",keyup:"_keyHandler",dragstart:"_dragStartHandler","button.click":"_buttonClickHandler","button.mouseenter":"_buttonMouseEnterHandler","button.mouseleave":"_buttonMouseLeaveHandler","document.up":"_documentUpHandler"}}ready(){super.ready(),this._setAriaState(),this._updateGroupValue()}_setAriaState(){const e=this,t=e.checked;null!==t?e.setAttribute("aria-pressed",t):e.setAttribute("aria-pressed","mixed")}_buttonClickHandler(){}_buttonMouseLeaveHandler(){this.removeAttribute("hover")}_buttonMouseEnterHandler(){const e=this;e.setAttribute("hover",""),e.disabled||e.readonly||"hover"!==e.clickMode||(e._changeCheckState("pointer"),e.focus(),e._updateHidenInputNameAndValue())}_documentUpHandler(e){const t=this;t._pressed&&(t._pressed=!1,t.disabled||t.readonly||"press"===t.clickMode||"pointercancel"===e.originalEvent.type||(t._changeCheckState("pointer"),t.focus(),t._updateHidenInputNameAndValue()))}_downHandler(e){const t=this;t.disabled||t.readonly||(t.hasRippleAnimation&&Smart.Utilities.Animation.Ripple.animate(t,e.pageX,e.pageY),t._pressed=!0,"press"!==t.clickMode&&"pressAndRelease"!==t.clickMode||(t._changeCheckState("pointer"),t.hasAttribute("smart-blazor")?t.$.dispatchEvent(new Event("click")):t.$.fireEvent("click"),t._updateHidenInputNameAndValue()),"press"===t.clickMode&&(e.preventDefault(),e.stopPropagation()))}_dragStartHandler(e){e.preventDefault()}_keyHandler(e){const t=this;if(!0!==t.disabled&&!t.readonly&&32===e.keyCode){if("keydown"===e.type)return void e.preventDefault();if("none"===t.switchMode)return;t._changeCheckState("keyboard"),t._updateHidenInputNameAndValue()}}_updateGroupValue(){const e=this;if(e.dataset.target){const t=document.querySelector(e.dataset.target);if(t){const r=document.querySelectorAll('[data-target="'+e.dataset.target+'"]'),n=[];if(e.checked){const r=e.dataset.property,n=e.dataset.value;if(r&&void 0!==t[r]){let e=n;"true"===e&&(e=!0),"false"===e&&(e=!1),t[r]=e}}for(let t=0;t<r.length;t++){const o=r[t];o.checked&&(o.name?(n.push(o.name),e.id&&o.setAttribute("data-id",e.id)):e.id&&n.push(e.id))}t.value=n.toString(),e._targetDispatchTimer&&clearTimeout(e._targetDispatchTimer),e._targetDispatchTimer=setTimeout((()=>{t.dispatchEvent(new Event("change"))}),100)}}}_changeCheckState(e){const t=this;let r=null;null===t.checked?t.checked=!0:(r=t.checked,t.checked=!t.checked),t._handleTextSelection(),t.$.fireEvent("change",{value:t.checked,oldValue:r,changeType:e}),t.checked?t.$.fireEvent("checkValue",{changeType:e}):t.$.fireEvent("uncheckValue",{changeType:e}),t._updateGroupValue(),t._setAriaState()}_handleTextSelection(){const e=this;e.$.addClass("smart-unselectable"),e.timer&&clearTimeout(e.timer),e.timer=setTimeout((()=>e.$.removeClass("smart-unselectable")),500)}propertyChangedHandler(e,t,r){super.propertyChangedHandler(e,t,r);const n=this;if("checked"===e)return n.$.fireEvent("change",{value:r,oldValue:t,changeType:"api"}),void n._setAriaState();switch(e){case"trueTemplate":n._handleTemplate(!0);break;case"falseTemplate":n._handleTemplate(!1);break;case"indeterminateTemplate":n._handleTemplate()}}_htmlBindOnInitialization(){const e=this;e._bindContentProperty("trueContent","smart-true-content"),e._bindContentProperty("falseContent","smart-false-content"),e._bindContentProperty("indeterminateContent","smart-indeterminate-content")}_bindContentProperty(e,t){const r=this;if(!r.$[e+"Container"])return;let n=document.createElement("div");n.innerHTML=r.innerHTML;let o,a=n.getElementsByClassName(t);if(a.length>0)for(let e=0;e<a.length;e++)o=a[e];""===r[e]&&(r[e]=void 0===o?"":o.outerHTML),r.$[e+"Container"].innerHTML=r[e]}_updateContentProperties(){const e=this;function t(t){e.$[t+"Container"]&&(e[t]=e.$[t+"Container"].innerHTML)}t("trueContent"),t("falseContent"),t("indeterminateContent")}_updateHidenInputValue(){const e=this;if(!e.$.hiddenInput)return;let t;t=null===e.checked?"null":!1===e.checked?"off":e.value||"on",e.$.hiddenInput.setAttribute("value",t)}_updateHidenInputName(){const e=this;if(!e.$.hiddenInput)return;let t=!1===e.checked?"":e.name||"";e.$.hiddenInput.setAttribute("name",t)}_updateHidenInputNameAndValue(){this._updateHidenInputName(),this._updateHidenInputValue()}_handleTemplate(e,t){const r=this;let n,o,a;if(!0===e?(n=r.trueTemplate,o=r.$.trueContentContainer,a=r.trueContent):!1===e?(n=r.falseTemplate,o=r.$.falseContentContainer,a=r.falseContent):(n=r.indeterminateTemplate,o=r.$.indeterminateContentContainer,a=r.indeterminateContent),t&&(o.innerHTML=a||""),null===n||!n)return;if("function"==typeof n)return void n(o,{value:a});if(!("content"in document.createElement("template")))return void r.error(r.localize("htmlTemplateNotSuported",{elementType:r.nodeName.toLowerCase()}));if(n=document.getElementById(n),null===n||!("content"in n))return void r.error(r.localize("invalidTemplate",{elementType:r.nodeName.toLowerCase(),property:"template"}));const i=n.content,s=i.childNodes.length,l=/{{\w+}}/g;let d,m=[];for(let e=0;e<s;e++)for(d=l.exec(i.childNodes[e].innerHTML);d;)m.push({childNodeIndex:e,bindingString:d[0]}),d=l.exec(i.childNodes[e].innerHTML);const c=m.length;let u,p,h=document.importNode(n.content,!0);for(let e=0;e<c;e++){u=h.childNodes[m[e].childNodeIndex],p=m.length;for(let t=0;t<p;t++)u.innerHTML=u.innerHTML.replace(m[e].bindingString,a)}o.innerHTML="";for(let e=0;e<h.childNodes.length;e++)h.childNodes[e].outerHTML&&(o.innerHTML+=h.childNodes[e].outerHTML)}})},5286:()=>{Smart("smart-check-box",class extends Smart.ToggleButton{static get properties(){return{checkMode:{value:"both",allowedValues:["both","input","label"],type:"string"},type:{value:"checkbox",type:"string",defaultReflectToAttribute:!0,readonly:!0}}}template(){return"<div id='container' class='smart-container' role=\"presentation\">\n                    <div class='smart-overlay' role=\"presentation\"></div>\n                    <span id='checkBoxInput' class='smart-input' aria-hidden=\"true\"></span>\n                    <span id='checkBoxLabel' inner-h-t-m-l='[[innerHTML]]' class='smart-label'><content></content></span>\n                    <input id='hiddenInput' class='smart-hidden-input' type='hidden'>\n                </div>"}static get listeners(){return{down:"_downHandler","document.up":"_documentUpHandler","checkBoxInput.mouseenter":"_mouseEnterHandler","checkBoxInput.mouseleave":"_mouseLeaveHandler",focus:"_focusHandler",blur:"_blurHandler"}}static get styleUrls(){return["smart.toggle.css"]}_focusHandler(){this.$.setAttributeValue("focus",!0)}_blurHandler(){this.$.setAttributeValue("focus",!1)}_mouseEnterHandler(){this.$.setAttributeValue("hover",!0)}_mouseLeaveHandler(){this.$.setAttributeValue("hover",!1)}ready(){const e=this;super.ready(),e.setAttribute("role","checkbox"),e.indeterminate&&(e._valueCache=e.checked,e.checked=null,e._setAriaState()),e.classList.add("smart-toggle-box"),e._updateHidenInputNameAndValue()}propertyChangedHandler(e,t,r){super.propertyChangedHandler(e,t,r);const n=this;switch(n._updateContentProperties(),e){case"indeterminate":r?(n._valueCache=n.checked,n.checked=null):n.checked=n._valueCache,n._setAriaState(),n._updateHidenInputNameAndValue();break;case"value":case"checked":n._updateHidenInputNameAndValue();break;case"name":n._updateHidenInputName()}}_documentUpHandler(e){const t=this;if(!t._pressed||"pointercancel"===e.originalEvent.type)return;const r=t.enableShadowDOM?e.originalEvent.composedPath()[0]:e.originalEvent.target;if(t._pressed=!1,t.$.setAttributeValue("active",!1),!(t.disabled||t.readonly||"input"===t.checkMode&&r!==t.$.checkBoxInput||"label"===t.checkMode&&r!==t.$.checkBoxLabel)){if("press"===t.clickMode)return e.preventDefault(),void e.stopPropagation();t._changeCheckState("pointer"),t.focus(),t._handleTextSelection(),t._updateHidenInputNameAndValue()}}_downHandler(e){const t=this,r=t.enableShadowDOM?e.originalEvent.composedPath()[0]:e.originalEvent.target;if(!(t.disabled||t.readonly||"input"===t.checkMode&&r!==t.$.checkBoxInput||"label"===t.checkMode&&r!==t.$.checkBoxLabel)){if(t.$.setAttributeValue("active",!0),t.hasRippleAnimation){const e=t.$.checkBoxInput.getBoundingClientRect(),r=window.scrollX||window.pageXOffset,n=window.scrollY||window.pageYOffset;Smart.Utilities.Animation.Ripple.animate(t.$.checkBoxInput,e.left+e.width/2+r,e.top+e.height/2+n)}t._pressed=!0,"press"!==t.clickMode&&"pressAndRelease"!==t.clickMode||(t._changeCheckState("pointer"),t.$.fireEvent("click"),t.focus(),t._updateHidenInputNameAndValue())}}_setAriaState(){const e=this,t=e.checked;null!==t?e.setAttribute("aria-checked",t):e.setAttribute("aria-checked","mixed")}})},4967:()=>{Smart("smart-color-input",class extends Smart.Input{static get properties(){return{dataSource:{type:"any",value:null},displayMode:{value:"default",allowedValues:["default","grid"],type:"string"},dropDownHeight:{type:"any",value:"auto"},messages:{value:{en:{standardColors:"Standard colors",themeShadeColors:"",themeColors:"Theme colors"}},type:"object",extend:!0},placeholder:{value:"Please Select Color",type:"string"},valueDisplayMode:{value:"default",allowedValues:["default","colorBox","colorCode"],type:"string"},valueFormat:{value:"hex",allowedValues:["rgb","rgba","hex"],type:"string"}}}static get listeners(){return{"input.focus":"_focusHandler","input.blur":"_blurHandler","input.keydown":"_keyDownHandler","input.keyup":"_keyUpHandler","input.keypress":"_keyPressHandler","input.select":"_inputSelectHandler","input.change":"_inputChangeHandler","dropDownButton.down":"_dropDownButtonDownHandler","inputContainer.down":"_downHandler","document.up":"_documentUpHandler"}}template(){return'<div id="inputContainer" role="presentation">\n                    <div class="smart-content">\n                        <div class="smart-buttons-container" role="presentation" id="buttonsContainer">\n                            <div class="smart-action-button" id="actionButton">\n                                <div id="colorSampleContainer" class="smart-color-box color-picker-sample-container" role="presentation">\n                                    <div id="colorSample" class="color-picker-sample"></div>\n                                </div>\n                                <input class="smart-input smart-color-input" id=\'input\' readonly=\'[[readonly]]\' placeholder=\'[[placeholder]]\' type=\'[[type]]\' name=\'[[name]]\'\n                                    value=\'[[value]]\' disabled=\'[[disabled]]\' aria-label="[[placeholder]]" spellcheck="false" />\n                            </div>\n                            <div id="dropDownButton" tabindex=-1 class="smart-drop-down-button" role="button" aria-label="Toggle popup">\n                                <div id="arrow" class="smart-drop-down-button-icon" aria-hidden="true"></div>\n                            </div>\n                        </div>\n                        <span id="hint" class="smart-hint smart-hidden" inner-h-t-m-l="[[hint]]"></span>\n                    </div>\n                </div>'}open(){const e=this;let t;e.dropDownDataSource?(e.query="",t="function"==typeof e.dataSource?e.dataSource(e.query):e.dataSource):t="function"==typeof e.dropDownDataSource?e.dropDownDataSource(e.query):e.dropDownDataSource,e._process(t);const r=e.$.menu.querySelector(".color-sample.selected");if(r){const t=e.$.input.dataValue,n=e.$.menu.querySelectorAll(".color-sample");for(let o=0;o<n.length;o++){const a=n[o],i=a.getAttribute("data-label"),s=a.getAttribute("value");if(void 0!==t&&s===t||void 0===t&&i===e.$.input.value){r.removeAttribute("aria-current"),r.classList.remove("selected"),a.classList.add("selected"),a.setAttribute("aria-current",!0),e._setActiveDescendant(a),e.$.input.dataValue=s;break}}}e.ensureVisible(),e.$.input.focus(),setTimeout((function(){e.$.input.focus()}),25)}_blurHandler(){const e=this;e.opened||(e.removeAttribute("focus"),e.$.actionButton.removeAttribute("focus"),e.$.dropDownButton.removeAttribute("focus")),delete e._preventLookup,e._isValidColor(e.value)||(e.$.input.value=e.$.input.dataValue=e.value="",e.$colorSampleContainer.addClass("no-color"))}_focusHandler(){const e=this;e.setAttribute("focus",""),e.$.actionButton.setAttribute("focus",""),e.$.dropDownButton.setAttribute("focus",""),e.readonly||0!==e.minLength||0!==e.$.input.value.length||e._preventLookup?delete e._preventLookup:e._lookup()}_lookup(e){const t=this;let r=[];t.query=t.$.input.value,t.$.input.readonly&&(t._incrementalSearchQuery||(t._incrementalSearchQuery=""),t._incrementalSearchQuery+=e.key,t._incrementalSearchTimer&&clearTimeout(t._incrementalSearchTimer),t.query=t._incrementalSearchQuery,t._incrementalSearchTimer=setTimeout((function(){t._incrementalSearchQuery=""}),700)),t.query.length<t.minLength?t.close():(r="function"==typeof t.dataSource?t.dataSource(t.query):t.dataSource,clearTimeout(t._autoCompleteTimeout),t._autoCompleteTimeout=setTimeout((function(){const e=t.context;t.context=t,t._process(r),t.context=e}),t.autoCompleteDelay))}_getDefaultColors(){let e=this._generateColors();if("grid"===this.displayMode)return e;let t=[];for(let r=0;r<e.length;r++)t=t.concat(Object.values(e[r])[0]);return t}_generateColors(){const e=this;return"default"===e.displayMode?e._defaultModeColors?e._defaultModeColors:e._defaultModeColors=[{themeColors:["#FFFFFF","#000000","#E6E6E6","#495469","#5671C2","#D48439","#A5A5A5","#EEC328","#7399D3","#85AA4C"]},{themeShadeColors:["#F2F2F2","#808080","#D0CECE","#D6DCE4","#DDEBF7","#FCE4D6","#EBEBEB","#FFF2CC","#DDE5F7","#E2EFDA","#D8D8D8","#595959","#AEAAAA","#ACB9CA","#BDD7EE","#F6CAAD","#DBDBDB","#FFE699","#B4C6E7","#C6E0B4","#BFBFBF","#404040","#757171","#8497B0","#9BC2E6","#F4B084","#C0C0C0","#FFD966","#8EA9DB","#A9D08E","#A6A6A6","#262626","#312F2F","#333F4F","#2F75B5","#C65911","#7B7B7B","#BF8F00","#305496","#548235","#808080","#0D0D0D","#161616","#222B35","#1F4E78","#833C0C","#525252","#806000","#203764","#375623"]},{standardColors:["#A52A0D","#DB3A15","#EEC328","#FEFE33","#A6CD57","#62AC54","#65ADEE","#3F6FBE","#10205F","#64379E"]}]:e._gridColors?e._gridColors:e._gridColors=["rgba(255, 255, 255, 0)","rgb(0, 0, 0)","rgb(153, 51, 0)","rgb(51, 51, 0)","rgb(0, 51, 0)","rgb(0, 51, 102)","rgb(0, 0, 128)","rgb(51, 51, 153)","rgb(51, 51, 51)","rgb(128, 0, 0)","rgb(255, 102, 0)","rgb(128, 128, 0)","rgb(0, 128, 0)","rgb(0, 128, 128)","rgb(0, 0, 255)","rgb(102, 102, 153)","rgb(128, 128, 128)","rgb(255, 0, 0)","rgb(255, 153, 0)","rgb(153, 204, 0)","rgb(51, 153, 102)","rgb(51, 204, 204)","rgb(51, 102, 255)","rgb(128, 0, 128)","rgb(153, 153, 153)","rgb(255, 0, 255)","rgb(255, 204, 0)","rgb(255, 255, 0)","rgb(0, 255, 0)","rgb(0, 255, 255)","rgb(0, 204, 255)","rgb(153, 51, 102)","rgb(192, 192, 192)","rgb(255, 153, 204)","rgb(255, 204, 153)","rgb(255, 255, 153)","rgb(204, 255, 204)","rgb(204, 255, 255)","rgb(153, 204, 255)","rgb(204, 153, 255)","rgb(255, 255, 255)"]}_downHandler(e){const t=this;(t.readonly||e.originalEvent.target.closest(".smart-color-box"))&&t._dropDownButtonDownHandler(e)}_documentUpHandler(e){const t=this,r=t.shadowRoot||t.isInShadowDOM?e.originalEvent.composedPath()[0]:e.originalEvent.target;r===t||r.closest&&r.closest(".smart-buttons-container")===t.$.buttonsContainer||(t.$.scrollView.contains(r.shadowParent||r)?t._isPointerDown&&(t._isPointerDown=!1,t.opened&&(t._preventLookup=!0),t.$.input.focus()):(t.opened&&(t._preventLookup=!0),t._isPointerDown=!1,"manual"!==t.dropDownOpenMode&&t.close()))}_formatValue(e){const t=this;if(!t._isValidColor(e))return"";const r=t._getRGBA(e);switch(t.valueFormat){case"hex":e=t._rgbArrayToHEX([r.r,r.g,r.b,r.a]);break;case"rgb":e="rgb("+r.r+", "+r.g+", "+r.b+")";break;case"rgba":e=null!==r.r&&null!==r.g&&null!==r.b?"rgba("+r.r+", "+r.g+", "+r.b+", "+r.a+")":null}return e||null}_getRGBA(e){const t=this,r=e||t.value;let n=1;r&&(t._isRGBA(r)&&/rgba\((\d*.\d+|\d+),(\d*.\d+|\d+),(\d*.\d+|\d+)\,(\d*.\d+|\d+)\)/gi.test(r.replace(/\s/g,""))?n=/rgba\((\d*.\d+|\d+),(\d*.\d+|\d+),(\d*.\d+|\d+)\,(\d*.\d+|\d+)\)/gi.exec(r.replace(/\s/g,""))[4]:t._isHEX(e)&&/(^#[0-9A-F]{8}$)/gi.test(e.replace(/\s/g,""))&&(n=parseInt(/(^#[0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2}$)/gi.exec(e.replace(/\s/g,""))[4],16)/255),n=Math.min(1,Math.max(0,parseFloat(n))),isNaN(n)&&(n=1)),e=t._HSVtoRGBA(t._colorToHSV(r),n);const o=/rgba\((\d*.\d+|\d+),(\d*.\d+|\d+),(\d*.\d+|\d+)\,(\d*.\d+|\d+)\)/gi.exec(e.replace(/\s/g,""));return{r:parseInt(o[1]),g:parseInt(o[2]),b:parseInt(o[3]),a:parseFloat(o[4])}}_colorToHSV(e){if(!this._isValidColor(e))return;e=this._toRGBA(e).replace(/\s/g,"");const t=/rgba\((\d*.\d+|\d+),(\d*.\d+|\d+),(\d*.\d+|\d+)\,(\d*.\d+|\d+)\)/gi.exec(e),r=Math.min(255,Math.max(0,parseFloat(t[1])))/255,n=Math.min(255,Math.max(0,parseFloat(t[2])))/255,o=Math.min(255,Math.max(0,parseFloat(t[3])))/255;let a={h:0,s:0,v:0},i=0,s=0;if(r>=n&&r>=o?(s=r,i=n>o?o:n):n>=o&&n>=r?(s=n,i=r>o?o:r):(s=o,i=n>r?r:n),a.v=s,a.s=s?(s-i)/s:0,a.s){const e=s-i;a.h=r===s?(n-o)/e:n===s?2+(o-r)/e:4+(r-n)/e,a.h=60*a.h,a.h<0&&(a.h+=360)}else a.h=0;return a.s=parseFloat(a.s),a.v=parseFloat(a.v),a}_rgbArrayToHEX(e){let t="#";if(Array.isArray(e)&&null===e[0])return null;for(let r=0;r<3;r++){let n=parseInt(e[r]).toString(16).toUpperCase();n=1===n.length?0+n:n,t+=n}let r=parseFloat(e[3]);return isNaN(r)||(r=parseInt(255*r).toString(16).toUpperCase(),"FF"!==r&&(t=t.slice(0,7)+(1===r.length?0+r:r))),t}_HSVtoRGBA(e,t){const r=(e=e||{h:0,s:0,v:0}).h,n=e.s,o=e.v;let a,i,s,l=o*n,d=r/60,m=l*(1-Math.abs(d%2-1));d>=0&&d<=1?[a,i,s]=[l,m,0]:d>=1&&d<=2?[a,i,s]=[m,l,0]:d>=2&&d<=3?[a,i,s]=[0,l,m]:d>=3&&d<=4?[a,i,s]=[0,m,l]:d>=4&&d<=5?[a,i,s]=[m,0,l]:d>=5&&d<=6&&([a,i,s]=[l,0,m]);const c=o-l;return"rgba("+Math.round(255*(a+c))+", "+Math.round(255*(i+c))+", "+Math.round(255*(s+c))+", "+(void 0!==t?t:this._getRGBA().a||0)+")"}_toRGBA(e,t){const r=this;let n=r.value;function o(e){const r=/^#(.)(.)(.)$/gi.exec(e),n=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})?$/i.exec(e),o=r?parseInt(r[1]+r[1],16):parseInt(n[1],16),a=r?parseInt(r[2]+r[2],16):parseInt(n[2],16),i=r?parseInt(r[3]+r[3],16):parseInt(n[3],16),s=r?parseInt(r[4]+r[4],16):parseInt(n[4],16);return t?"rgba("+o+", "+a+", "+i+", 1)":"rgba("+o+", "+a+", "+i+", "+(isNaN(s)?"1":s/255)+")"}if(r._isRGBA(e)){if(t){return"rgba("+e.match(/(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})/gi)+", 1)"}return e}if(r._isValidColorName(e))n=o(r._cssColorNamesHEX[e.trim().toLowerCase()]);else if(r._isHEX(e))n=o(e);else{if(!r._isRGB(e))return!1;n=e.toLowerCase(),n=n.replace("rgb","rgba"),n=n.replace(")",", 1)")}return n}_isHEX(e){return/(^#[0-9A-F]{3}$)|(^#[0-9A-F]{6}$)|(^#[0-9A-F]{8}$)/i.test(e)}_isRGB(e){return/rgb\((\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\)/i.test(e)}_isValidColorName(e){return!(!e||void 0===this._cssColorNamesHEX[e.trim().toLowerCase()])}_isRGBA(e){return/rgba\((\d*.\d+|\d+)\s*,\s*(\d*.\d+|\d+)\s*,\s*(\d*.\d+|\d+)\s*,\s*(\d*.\d+|\d+)\)/i.test(e)}_isValidColor(e){return this._isHEX(e)||this._isRGB(e)||this._isRGBA(e)||this._isValidColorName(e)}_performSelect(e){const t=this;let r,n,o;t.opened?(r=t.$.menu.querySelector(".selected")||t.$.menu.querySelector(".color-sample"),n=r.getAttribute("data-label"),o=r.getAttribute("value")):n=o=t.$.input.value;const a=e||t.value,i=t.$.input.dataValue;t.set("value",t.$.colorSample.style.backgroundColor=t._formatValue(n)),t.$.input.dataValue=o,t.setAttribute("data-value",o),t._isValidColor(t.value)?(t.$colorSampleContainer.removeClass("no-color"),t.$.colorSample.setAttribute("aria-label",t.value)):(t.$colorSampleContainer.addClass("no-color"),t.$.colorSample.setAttribute("aria-label","No color")),r&&(r.classList.add("selected"),r.setAttribute("aria-current",!0)),!t.isRendered||n===a&&o===i||(t.$.fireEvent("change",{value:o,label:n,oldValue:i,oldLabel:a}),t._updateTargetValue()),t.close()}_process(e){const t=this;if(e||(e=[]),"string"==typeof(e=e.slice(0))&&(e=t.$.deserialize(e,"array")),t.matcher)e=e.filter((e=>t.matcher(e)>-1));else if(t.query){let r=[];for(let e in t._cssColorNamesHEX)t._matcher(e,!0)>-1&&r.push(t._cssColorNamesHEX[e]);if(r.length)e=r;else if(e.length||null!==t.dataSource&&void 0!==t.dataSource)e=e.filter((e=>t._matcher(e)>-1));else{let r=t._generateColors();"default"===t.displayMode&&(r=[].concat.apply([],r.map((e=>Object.values(e)[0])))),e=r.filter((e=>t._matcher(e)>-1))}}!e.length&&t.opened&&t.close(),t.query.length>0&&!e.length||!e.length&&null!==t.dataSource&&void 0!==t.dataSource||(t.query.length>0?t._render(e.slice(0,t.items)):t._render(e),t._open(),t._refreshMenu(),t.ensureVisible())}_matcher(e,t){const r=this,n=r.query;if(e=t?e.label||e:r._formatValue(e.label||e),!n)return-1;switch(r.queryMode){case"startsWith":return e.startsWith(n);case"startsWithIgnoreCase":return e.toLowerCase().startsWith(n.toLowerCase());case"doesNotContain":return e.indexOf(n)<0;case"doesNotContainIgnoreCase":return e.toLowerCase().indexOf(n.toLowerCase())<0;case"contains":return e.indexOf(n)>-1;default:case"containsIgnoreCase":return e.toLowerCase().indexOf(n.toLowerCase());case"equals":return 0===e.localeCompare(n);case"equalsIgnoreCase":return 0===e.toLowerCase().localeCompare(n.toLowerCase());case"endsWith":return e.endsWith(n);case"endsWithIgnoreCase":return e.toLowerCase().endsWith(n.toLowerCase())}}_render(e){const t=this;if(t.$.menu.innerHTML="",e.length)t.$.menu.appendChild(t._createColorGroup(t._createColorSamples(e)));else if((null===t.dataSource||void 0===t.dataSource)&&!t.query.length)if(e=t._generateColors(),"default"===t.displayMode){const e=t._generateColors();for(let r=0;r<e.length;r++){const n=Object.keys(e[r])[0],o=Object.values(e[r])[0],a=document.createElement("div");a.classList.add("standard-colors-label"),a.innerHTML=t.localize(n),a.id=t.id+n+"Label",t.$.menu.appendChild(a),t.$.menu.appendChild(t._createColorGroup(t._createColorSamples(o),n+"Label"))}}else t.$.menu.appendChild(t._createColorGroup(t._createColorSamples(e)))}_createColorGroup(e,t){const r=this,n=document.createElement("div");function o(){const e=r.$.menu.getElementsByClassName("selected");e[0]&&(e[0].removeAttribute("aria-current"),e[0].classList.remove("selected")),this.classList.add("selected"),this.setAttribute("aria-current",!0),r._setActiveDescendant(this)}n.classList.add("grid-samples-container"),n.setAttribute("role","menu"),t&&n.setAttribute("aria-labelledby",r.id+t);for(let t=0;t<e.length;t++){const a=e[t];n.appendChild(a),a.onmouseenter=o,a.onclick=o,a.onmouseleave=function(){this.removeAttribute("aria-current"),this.classList.remove("selected"),r._setActiveDescendant(null)}}return n}_createColorSamples(e){const t=this;let r=[];for(let n=0;n<e.length;n++){const o=e[n];let a=o,i=o;"object"==typeof o&&(a=o.label,i=o.value||a);const s=document.createElement("div");s.id=t.id+"Item"+Math.floor(65536*(1+Math.random())).toString(16).substring(1),s.setAttribute("data-label",a),s.setAttribute("value",i),s.setAttribute("role","menuitem"),s.setAttribute("aria-label",a),s.classList.add("color-sample"),s.style.backgroundColor=a,"rgba(255, 255, 255, 255)"!==a&&"#FFFFFF"!==a&&"#FFFFFFFF"!==a||(s.style.borderColor="var(--smart-border)",s.style.borderStyle="solid",s.style.borderWidth="1px"),"rgba(255, 255, 255, 0)"===a||"#FFFFFF00"===a||"transparent"===a?s.setAttribute("transparent",""):s.removeAttribute("transparent"),s.classList[a||i?"remove":"add"]("no-color"),r.push(s)}if(r.length>0&&!t.$.menu.querySelector(".selected")){const n=Math.max(0,e.indexOf(t.value));r[n].classList.add("selected"),r[n].setAttribute("aria-current",!0),t._setActiveDescendant(r[0])}return r}ensureVisible(){this.$.menu.querySelector(".color-sample.selected")}_next(){const e=this,t=e.$.menu.querySelector(".color-sample.selected");if(!t){const t=e.$.menu.querySelector(".color-sample");return t.classList.add("selected"),t.setAttribute("aria-current",!0),void e._setActiveDescendant(t)}t.removeAttribute("aria-current"),t.classList.remove("selected");let r=t.nextElementSibling;if(!r){let n=t.parentElement.nextElementSibling;for(;n;){if(n.classList.contains("grid-samples-container")){r=n.children[0];break}n=n.nextElementSibling}r||(r=e.$.menu.querySelector(".color-sample"))}r.classList.add("selected"),r.setAttribute("aria-current",!0),e._setActiveDescendant(r),e.ensureVisible()}_prev(){const e=this,t=e.$.menu.querySelector(".color-sample.selected");if(!t){const t=e.$.menu.querySelector(".color-sample");return t.classList.add("selected"),t.setAttribute("aria-current",!0),void e._setActiveDescendant(t)}t.removeAttribute("aria-current"),t.classList.remove("selected");let r=t.previousElementSibling;if(!r){let n=t.parentElement.previousElementSibling;for(;n;){if(n.classList.contains("grid-samples-container")){r=n.children[n.children.length-1];break}n=n.previousElementSibling}r||(r=e.$.menu.querySelector(".grid-samples-container:last-of-type .color-sample:last-of-type"))}r.classList.add("selected"),r.setAttribute("aria-current",!0),e._setActiveDescendant(r),e.ensureVisible()}_move(e){const t=this;if(t.opened){switch(e.keyCode){case 9:case 13:case 27:e.preventDefault();break;case 37:case 38:e.preventDefault(),t[t.rightToLeft?"_next":"_prev"]();break;case 39:case 40:e.preventDefault(),t[t.rightToLeft?"_prev":"_next"]()}e.stopPropagation()}}_inputSelectHandler(){const e=this;e.readonly&&(e.$.input.selectionStart=e.$.input.selectionEnd)}_inputChangeHandler(e){e.stopPropagation(),this._performSelect()}_keyDownHandler(e){const t=this;t._suppressKeyPressRepeat=![37,38,39,40,9,13,27,16,17,18].includes(e.keyCode),e.shiftKey||e.ctrlKey||(e.altKey?"ArrowUp"===e.key?t.close():"ArrowDown"===e.key&&t.open():t._move(e))}_keyUpHandler(e){const t=this;if(!(e.shiftKey||e.altKey||e.ctrlKey))switch(e.keyCode){case 40:case 39:case 38:case 37:case 16:case 17:case 18:40===e.keyCode&&e.altKey&&t.open(),38===e.keyCode&&e.altKey&&t.close();break;case 9:case 13:if(!t.opened)return void(13===e.keyCode&&t.open());t._performSelect(),e.stopPropagation(),e.preventDefault();break;case 27:if(!t.opened)return;t.close(),e.stopPropagation(),e.preventDefault();break;default:if(t.readonly)return void(32!==e.keyCode||t.opened||t.open());t._lookup(e),!t.opened||e.ctrlKey||e.shiftKey||(e.stopPropagation(),e.preventDefault()),t.$.input.dataValue=t.$.input.value,t._isValidColor(t.value)||(t.$colorSampleContainer.addClass("no-color"),t.$.colorSample.setAttribute("aria-label","No color"),t.$.colorSample.style.backgroundColor="")}}propertyChangedHandler(e,t,r){const n=this;if("dropDownHeight"===e)n.$.scrollView.style.setProperty("--smart-input-drop-down-menu-height",n.dropDownHeight+"px");else if("opened"===e)n.opened=t,r?n.open():n.close();else if("placeholder"===e){if(n.readonly){const e=n.getAttribute("aria-label");if(e&&e!==t)return;r?n.setAttribute("aria-label",r):n.removeAttribute("aria-label")}}else"readonly"===e?n._setAriaRelations():"theme"===e?n.$.scrollView.setAttribute(e,r):"rightToLeft"===e?r?n.$.scrollView.setAttribute("right-to-left",""):n.$.scrollView.removeAttribute("right-to-left"):"valueFormat"===e?(n.value=n._formatValue(n.value),n.$.input.dataValue=n.value):"displayMode"===e?n.open():"value"===e?(n.$.input.value=r,n._performSelect(t)):super.propertyChangedHandler(e,t,r)}_createElement(){const e=this,t=document.createElement("div"),r=document.createElement("div");r.classList.add("smart-color-input-drop-down-menu","smart-color-panel"),r.setAttribute("theme",e.theme),e.$.scrollView=r,e.rightToLeft?e.$.scrollView.setAttribute("right-to-left",""):e.$.scrollView.removeAttribute("right-to-left"),e.$.menu=t,e.$.menu.classList.add("default-samples-container","grid-mode-container","smart-container"),e.$.scrollView.onclick=function(t){t.stopPropagation(),t.preventDefault(),e._performSelect(),e.$.input.focus()},e.classList.add("smart-drop-down-box","smart-color-picker"),e.value?(e.$colorSampleContainer.removeClass("no-color"),e.$.colorSample.setAttribute("aria-label",e.value)):(e.$colorSampleContainer.addClass("no-color"),e.$.colorSample.setAttribute("aria-label","No color")),e._cssColorNamesHEX={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4","indianred ":"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgrey:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",rebeccapurple:"#663399",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"},e._performSelect(e.value)}_setAriaRelations(){const e=this,t=e.getAttribute("aria-label");e.readonly?(e.setAttribute("role","button"),!t&&e.placeholder&&e.setAttribute("aria-label",e.placeholder),e.$.input.setAttribute("aria-hidden",!0),e.$.input.removeAttribute("aria-activedescendant"),e.$.input.removeAttribute("aria-controls"),e.$.dropDownButton.setAttribute("aria-hidden",!0)):(e.setAttribute("role","combobox"),t&&t===e.placeholder&&e.removeAttribute("aria-label"),e.$.input.setAttribute("role","searchbox"),e.$.input.removeAttribute("aria-hidden",!0),e.$.dropDownButton.removeAttribute("aria-hidden")),e.setAttribute("aria-expanded",e.opened),e.setAttribute("aria-haspopup","listbox"),e.$.scrollView.setAttribute("role","listbox")}})},8494:()=>{Smart("smart-editor",class extends Smart.ContentElement{static get properties(){return{autoLoad:{value:!1,type:"boolean"},autoSave:{value:!1,type:"boolean"},autoSaveInterval:{value:1e3,type:"number"},autoExpand:{value:!1,type:"boolean"},charCountFormatFunction:{value:null,type:"function?"},contentFiltering:{value:{attributes:{value:[],type:"array"},attributeFilterMode:{allowedValues:["blackList","whiteList"],value:"blackList",type:"string"},tags:{value:[],type:"array"},tagFilterMode:{allowedValues:["blackList","whiteList"],value:"blackList",type:"string"},styleAttributes:{value:[],type:"array"},styleAttributeFilterMode:{allowedValues:["blackList","whiteList"],value:"blackList",type:"string"}},type:"object"},contextMenu:{allowedValues:["default","browser","none"],value:"default",type:"string"},contextMenuDataSource:{value:null,type:"any",reflectToAttribute:!1},dataExport:{value:{style:{value:null,type:"object"},fileName:{value:"smartEditor",type:"string?"},pageOrientation:{value:"portrait",type:"string"}},type:"object"},disableEditing:{value:!1,type:"boolean"},disableSearchBar:{value:!1,type:"boolean"},editMode:{allowedValues:["html","markdown"],value:"html",type:"string"},enableHtmlEncode:{value:!1,type:"boolean"},enableTabKey:{value:!1,type:"boolean"},findAndReplaceTimeout:{value:50,type:"number"},hideToolbar:{value:!1,type:"boolean"},hideInlineToolbar:{value:!1,type:"boolean"},imageFormat:{allowedValues:["blob","base64"],value:"base64",type:"string"},imageName:{value:"userfile[]",type:"string"},innerHTML:{type:"string",validator:"_sanitize",reflectToAttribute:!1},inlineToolbarOffset:{value:[0,-5],type:"array"},iframeSettings:{value:{attributes:{value:null,type:"object?"},enabled:{value:!1,type:"boolean"},resources:{value:null,type:"object?"}},type:"object"},maxCharCount:{value:null,type:"number?"},messages:{extend:!0,value:{en:{invalidValue:"{{elementType}}: Invalid {{property}} value. {{property}} should be of type {{typeOne}} or {{typeTwo}}.",incorrectArgument:"{{elementType}}: Incorrect argument {{argumentName}} in method {{methodName}}.",permissionsRequired:"{{elementType}}: Permissions are required for the following action {{actionName}}.",timeout:"{{elementType}}: The import request has timed out.",importError:"{{elementType}}: The import request errored with the following status: {{status}}.",exportError:"{{elementType}}: The Export request errored with the following status: {{status}}.",ok:"Ok",cancel:"Cancel",alignLeft:"Align Left",alignCenter:"Align Center",alignRight:"Align Right",alignJustify:"Align Justify",segoeUi:"Segoe UI",arial:"Arial",georgia:"Georgia",impact:"Impact",tahoma:"Tahoma",timesNewRoman:"Times New Roman",verdana:"Verdana",p:"Paragraph",pre:"Code",code:"Code",blockquote:"Quotation",h1:"Heading 1",h2:"Heading 2",h3:"Heading 3",h4:"Heading 4",h5:"Heading 5",h6:"Heading 6",bold:"Bold",italic:"Italic",underline:"Underline",strikethrough:"Strikethrough",orderedlist:"Ordered List",unorderedlist:"Unordered List",subscript:"Subscript",superscript:"Superscript",alignment:"Alignments",fontname:"Font Name",fontsize:"Font Size",formats:"Formats",backgroundcolor:"Background Color",fontcolor:"Font Color",redo:"Redo",undo:"Undo",indent:"Indent",outdent:"Outdent",createlink:"Hyperlink",hyperlink:"Hyperlink",editlink:"Hyperlink",removelink:"Remove link",openlink:"Open link",image:"Image",video:"Video",table:"Table",lowercase:"Lower Case",uppercase:"Upper Case",print:" Print",cut:" Cut",copy:" Copy",paste:" Paste",clearformat:"Clear Format",fullscreen:"Full Screen",restore:"Restore Screen",sourcecode:"Source Code",preview:"Preview",splitmode:"Split Editor",address:"Web Address",text:"Display Text",addressPlaceholder:"http://example.com",textPlaceholder:"Enter Text",targetPlaceholder:"Select Target",titlePlaceholder:"Enter a Title",urlPlaceholder:"http://example.com/image.png",srcPlaceholder:"https://www.youtube.com/embed/video_link",thumbnail:"Or provide a URL as a video thumbnail",thumbnailPlaceholder:"https://www.link-to-thumbnail.jpg",videoUrl:"Video URL",videoUrlPlaceholder:"https://www.youtube.com/video_link",captionPlaceholder:"Caption",altPlaceholder:"Alternative Text",widthPlaceholder:"auto",heightPlaceholder:"auto",target:"Open Link in",linkBlankDescr:"New Window",linkSelfDescr:"Same Window",linkParentDescr:"Parent Frame",linkTopDescr:"Full Body of the Window",linkCustomDescr:"Custom Frame Name",title:"Title",url:"Or provide the URL to an image",src:"Or provide the URL to an embed video",width:"Width",height:"Height",alt:"Alternative Text",caption:"Caption",display:"Display",displayPlaceholder:"Display",displayBlock:"Block",displayInline:"Inline",draggable:"Enable Dragging",resizable:"Enable Resizing",browse:"Browse",connectionError:"{{elementType}}: File Upload requires connection to the server.",wrongItemIndex:"{{elementType}}: There is no file with such an index in the list of uploaded files.",tooLongFileName:"{{elementType}}: File name is too long.",totalFiles:"Total files: ",cancelFile:"Cancel File",dashedborders:"Dashed Borders",altrows:"Alternate Rows",insertRowBefore:"Insert Row Before",insertRowAfter:"Insert Row After",deleteRow:"Delete Row",insertColumnLeft:"Insert Column Left",insertColumnRight:"Insert Column Right",deleteColumn:"Delete Column",alignTop:"Align Top",alignMiddle:"Align Middle",alignBottom:"Align Bottom",delete:"Delete",tablerows:"Table Rows",tablecolumns:"Table Columns",tablevalign:"Table Cell Vertical Align",tablestyle:"Table Style",tableheader:"Table Header",buttonLabel:"Custom Table",pasteLabel:"Choose the paste format action:",cols:"Columns",rows:"Rows",alphabet:"abcdefghijklmnopqrstuvwxyz",header:"Header",column:"Column",plainText:"Plain Text",keepFormat:"Keep Format",cleanFormat:"Clean Format",roleDescription:"Text Editor",iframeTitle:"Editor Content is Encloused in it's own DOM inside an iFrame",toolbarButtonAriaLabel:"Toolbar Toggle Button",primaryToolbarAriaLabel:"Primary Toolbar",secondaryToolbarAriaLabel:"Secondary Toolbar",inputAriaLabel:"Enter Text",homeTab:"Home",viewTab:"View",insertTab:"Insert",layoutTab:"Layout",undoGroup:"Undo",clipboardGroup:"Clipboard",fontGroup:"Font",paragraphGroup:"Paragraph",editingGroup:"Editing",tableGroup:"Tables",imageGroup:"Images",videoGroup:"Videos",linkGroup:"Links",viewsGroup:"Views",deleteGroup:"Delete",findandreplace:"Find and Replace",requiredMessage:"The content of the Editor cannot be empty",tableProperties:"Table Properties",imageProperties:"Image Properties",videoProperties:"Video Properties",linkProperties:"Link Properties",selectAll:"Select All",deleteTable:"Delete Table",deleteImage:"Delete Image",deleteVideo:"Delete Video",createLink:"Create Link",deleteLink:"Delete Link",copyImage:"Copy",cutImage:"Cut",copyVideo:"Copy",cutVideo:"Cut",find:"Find",findPlaceholder:"",replace:"Replace",replaceWith:"Replace With",replaceAll:"Replace All",replacePlaceholder:"",results:"Results",resultsPlaceholder:"No match",matchCase:"Match Case",searchPlaceholder:"Search..."}}},name:{value:null,type:"string?"},pasteFormat:{allowedValues:["prompt","plainText","keepFormat","cleanFormat"],value:"keepFormat",type:"string"},postData:{value:null,type:"object"},placeholder:{value:"",type:"string"},removeStylesOnClearFormat:{value:!1,type:"boolean"},required:{value:!1,type:"boolean"},sanitized:{value:!1,type:"boolean"},showCharCount:{value:!1,type:"boolean"},splitModeRefreshTimeout:{value:100,type:"number"},toolbarItems:{value:["bold","italic","underline","|","formats","alignment","orderedList","unorderedList","|","hyperlink","image","video","|","sourceCode","undo","redo"],reflectToAttribute:!1,type:"array"},toolbarMode:{allowedValues:["menu","singleLineRibbon"],value:"menu",type:"string"},toolbarRibbonConfig:{value:[{name:"homeTab",groups:[{name:"undoGroup",items:["undo","redo"]},{name:"clipboardGroup",items:["cut","copy","paste"]},{name:"fontGroup",items:["fontName","fontSize","backgroundColor","fontColor","clearFormat","formats","bold","italic","underline","strikethrough","superscript","subscript"]},{name:"paragraphGroup",items:["orderedList","unorderedList","indent","outdent","alignment"]},{name:"editingGroup",items:["findAndReplace"]}]},{name:"insertTab",groups:[{name:"tableGroup",items:["table"]},{name:"imageGroup",items:["image"]},{name:"videoGroup",items:["video"]},{name:"linkGroup",items:["createLink","removeLink"]}]},{name:"viewTab",groups:[{name:"viewsGroup",items:["fullScreen","sourceCode","splitMode"]}]},{name:"layoutTab",hidden:!0,groups:[{name:"deleteGroup",items:["delete"]},{name:"tableGroup",items:["table","tableHeader","tableRows","tableColumns","tableVAlign","tableStyle",""]},{name:"imageGroup",items:["image","caption"]},{name:"videoGroup",items:["video","caption"]}]}],type:"array"},toolbarViewMode:{allowedValues:["toggle","multiRow","scroll"],value:"toggle",type:"string"},toolbarSticky:{value:!1,type:"boolean"},spellCheck:{value:!0,type:"boolean"},value:{value:"",type:"string",validator:"_sanitize",reflectToAttribute:!1},validateFile:{value:null,type:"function?",reflectToAttribute:!1},uploadUrl:{value:"",type:"string",reflectToAttribute:!1},removeUrl:{value:"",type:"string",reflectToAttribute:!1},onImageRemove:{value:null,type:"function?"},autoUpload:{value:!0,type:"boolean"},windowCustomizationFunction:{value:null,reflectToAttribute:!1,type:"function?"}}}static get listeners(){return{"document.down":"_documentDownHandler","document.move":"_documentMoveHandler","document.up":"_documentUpHandler","document.dragstart":"_dragStartHandler","document.selectstart":"_selectStartHandler","document.selectionchange":"_selectionChangeHandler","container.dragend":"_dragEndHandler","container.drop":"_dropHandler","container.change":"_changeHandler","container.beforeinput":"_beforeInputHandler","container.input":"_afterInputHandler","contentContainer.contextmenu":"_contextMenuHandler","contentContainer.keydown":"_editableElementKeyDownHandler","contentContainer.keyup":"_updateOnInputChange","contentContainer.paste":"_updateOnInputChange","input.focus":"_editableElementFocusHandler","input.blur":"_editableElementBlurHandler","input.change":"_inputChangeEvent","editableElement.focus":"_editableElementFocusHandler","editableElement.blur":"_editableElementBlurHandler","editableElement.wheel":"_editableElementWheelHandler","editableElement.move":"_editableElementMoveHandler",touchmove:"_touchmoveHandler",resize:"_resizeHandler"}}static get requires(){return{"Smart.Button":"smart.button.js","Smart.Window":"smart.window.js","Smart.Tooltip":"smart.tooltip.js"}}static get styleUrls(){return["smart.editor.css"]}template(){return'<div id="container" role="presentation">\n                    <div id="toolbar" class="smart-editor-toolbar" role="presentation">\n                        <div id="toolbarItemsPrimary" class="smart-editor-toolbar-items-primary" role="toolbar"></div>\n                        <div id="toolbarToggleButton" class="smart-editor-toolbar-toggle-button" role="button"></div>\n                        <div id="toolbarItemsSecondary" class="smart-editor-toolbar-items-secondary" role="toolbar"></div>\n                    </div>\n                    <div id="contentContainer" class="smart-editor-content-container" role="presentation">\n                        <div class="smart-editor-editable" contenteditable="true" id="editableElement" aria-placeholder="[[placeholder]]"\n                        inner-h-t-m-l="[[innerHTML]]" spellcheck="[[spellCheck]]" role="textbox" aria-multiline="true"><content></content></div>\n                        <textarea name="[[name]]" id="input" class="smart-hidden" placeholder="[[placeholder]]" aria-placeholder="[[placeholder]]"\n                        spellcheck="[[spellCheck]]" autocapitalize="none" autocomplete="off"></textarea>\n                    </div>\n                </div>'}propertyChangedHandler(e,t,r){const n=this;switch(e){case"contentFiltering":case"contentFiltering_attributes":case"contentFiltering_attributeFilterMode":case"contentFiltering_tags":case"contentFiltering_tagFilterMode":case"contentFiltering_styleAttributes":case"contentFiltering_styleAttributeFilterMode":n._handleContentFiltering();break;case"disabled":case"disableEditing":n.$.input.readonly=r,n.$.editableElement.setAttribute("contenteditable",!r),"disabled"===e&&n._setFocusable();break;case"disableSearchBar":n._closeSearchToolbar();break;case"enableHtmlEncode":{const e=n.$.input;e.classList.contains("smart-hidden")||(e.value=n._getInputValue());break}case"hideToolbar":r&&n._updateToolbarItems(void 0,n.$.toolbar);break;case"innerHTML":case"value":n._handleInputContent(e,r),n.$.fireEvent("change",{oldValue:n._value||t,value:n._value=n._getCurrentValue()});break;case"editMode":n._handleEditMode(r);break;case"hideInlineToolbar":{const e=n.$.inlineToolbar;e&&e.visible&&e.classList.contains("smart-editor-inline-toolbar")&&e.close();break}case"toolbarViewMode":n._toggleToolbar("toggle"===r);break;case"toolbarMode":case"toolbarRibbonConfig":n._handleToolbarMode();break;case"locale":delete n._toolbarItemsObj,delete n._inlineToolbarItemsObj,n._refreshToolbarItems(n._getToolbarItems()),n._closeToolbar(),n._closeWindow();break;case"iframeSettings":n._handleInputElement();break;case"maxCharCount":n._handleMaxCharCount(),n._setCharCount();break;case"name":r&&"markdown"!==n.editMode&&(n.$.input.value=n._getInputValue(n.$.editableElement.innerHTML.trim()));break;case"placeholder":n._handlePlaceholder();break;case"pasteFormat":n._closeWindow();break;case"readonly":n.$.input.readonly=r,n.$.editableElement.setAttribute("contenteditable","markdown"!==n.editMode&&!r),n._closePopups(),n._setResizeFrame(),n._closeWindow();break;case"showCharCount":n._setCharCount();break;case"rightToLeft":case"animation":case"theme":n._updateIframeBody();break;case"toolbarItems":n._handleToolbarItems();break;default:super.propertyChangedHandler(e,t,r)}}_handleToolbarItems(){const e=this,t=e.$.toolbarItemsPrimary,r=e.$.toolbarItemsSecondary;if(t.innerHTML=r.innerHTML="",delete e._toolbarItemsObj,delete e._inlineToolbarItemsObj,e._refreshToolbarItems(e._getToolbarItems()),"toggle"===e.toolbarViewMode){const n=e.$.toolbarToggleButton;t.scrollHeight!==t.offsetHeight||r.children.length?n.classList.remove("smart-visibility-hidden"):n.classList.add("smart-visibility-hidden")}}render(){const e=this,t=()=>0===e.offsetWidth||0===e.offsetHeight,r=()=>{e._isMobile=Smart.Utilities.Core.isMobile,e._isFireFox=Smart.Utilities.Core.Browser.Firefox,e._isSafari=Smart.Utilities.Core.Browser.Safari,e._isMacOS=(window.navigator.platform||"").indexOf("Mac")>-1,e._handleMaxCharCount(),e._handleInputContent(),e._setToolbarVisibility(),e._handleToolbarMode(),e._handleInputElement(),e._handleEditMode(),e._predefPropertyGetter(),e._setCharCount(),e._setFocusable(),e._setAriaSettings(),e.autoExpand&&e.expandToolbar(),e.isInitialized=!0,e.checkLicense()};if(t())return requestAnimationFrame((()=>{e.isInitialized||t()?e._createInterval=setInterval((()=>{e.isInitialized||t()||(r(),clearInterval(e._createInterval))}),100):r()})),void super.render();r(),super.render()}detached(){const e=this;super.detached(),delete e._dragDetails,delete e._resizeFrameObj,delete e._toolbarItemClick,e._endInlineToolbarClick(),e._closeWindow(),e._closeToolbarItemDropDown(e.$.inputPopup),e._closeToolbarItemDropDown(e.$.colorInputPopup),e._closeContextMenu(),e._closeToolbar(),e._handleTableSelection()}focus(){const e=this,t="markdown"===e.editMode?e.$.input:e.$.editableElement;t&&t.focus()}blur(){const e=this,t="markdown"===e.editMode?e.$.input:e.$.editableElement;t&&t.blur()}clearState(){const e=this;e.id?window.localStorage.removeItem("smartEditor"+e.id):e.warn(e.localize("noId"))}collapseToolbar(){this._toggleToolbar(!0)}disableToolbarItem(e){this._setToolbarItemAttr(e,"disabled",!0)}enableToolbarItem(e){this._setToolbarItemAttr(e,"disabled",!1)}expandToolbar(){this._toggleToolbar()}executeCommand(e,t){const r=this,n=r._getCurrentValue();r.$.editableElement.focus();const o=r.$.editableElement.getRootNode().execCommand(e,!1,t),a=r._getCurrentValue();return r.$.fireEvent("change",{value:a,oldValue:n}),o}exportData(e,t){this._handleDataExport(e,t)}importData(e,t){"string"==typeof e&&(e={url:e}),t||(t={}),this._ajax(e,t)}fullScreenMode(e){const t=this;t.$.fireEvent("actionStart",{name:"fullScreenMode"}).defaultPrevented||(t._handleFullScreenMode(t._toggleItem("fullscreen",e)),t.$.fireEvent("actionEnd",{name:"fullScreenMode"}))}getCharCount(){const e=this;if("html"===e.editMode){const t=e.$.editableElement,r=t.textContent.length,n=t.innerText.length;return n&&r?n:0}return e.$.input.value.length}getSelectionRange(){return this._selectionRange}clearContent(){const e=this;e._setResizeFrame(),e.$.editableElement.innerHTML=e.$.input.value=""}getHTML(){const e=this;if("markdown"===e.editMode){const t=e.$.input;return window.marked?window.marked(t.value):t.value}return e.$.editableElement.innerHTML}getText(){const e=this;if("markdown"===e.editMode){return e.$.input.value}return e.$.editableElement.textContent}loadState(e){const t=this;t.id?(e||(e=window.localStorage.getItem("smartEditor"+t.id)),"string"==typeof e&&(t.set("value",e),t.$.editableElement.innerHTML=t.$.input.value=e)):t.warn(t.localize("noId"))}showMessage(e,t){const r=this;if(!e||!r.isRendered)return;if(!Smart.Toast)return void r.error(r.localize("missingReference",{elementType:r.nodeName.toLowerCase(),methodName:"showMessage",files:"smart.toast.js"}));r._setToast();const n=r.$.toast;if(n){let o;if("object"==typeof t)for(let e in t)"iconType"===e?o=t[e]:n[e]=t[e];if(!r.$.container.contains(n)){const e=r.$toast;r._toastVisibilityHandler||(r._toastVisibilityHandler=e=>{const t=e.type;"close"===e.type&&e.detail.instance===r._requiredMessage&&delete r._requiredMessage,e.stopPropagation(),r.$.fireEvent("message"+t.slice(0,1).toUpperCase()+t.slice(1),e.detail)},e.listen("open",r._toastVisibilityHandler),e.listen("close",r._toastVisibilityHandler)),r.$.container.appendChild(n)}return n.open(e+"",o)}}hideMessage(e){const t=this.$.toast;t&&(void 0===e?t.closeAll():t.closeItem(e))}hideLastMessage(){const e=this.$.toast;e&&e.closeLast()}selectAll(){this._selectAll()}selectRange(e,t){const r=this,n=r.$.editableElement.getRootNode();if(!n)return;e=parseInt(e),t=parseInt(t),e=Math.min(e,t),t=Math.max(e,t);const o=r.$.input,a=r.$.editableElement,i="markdown"===r.editMode||r.$.editableElement.classList.contains("smart-hidden")?o:a,s=r.$.iframe,[l,d]=s?[s.contentWindow,s.contentDocument]:[window,document],m=l.getSelection();let c=n.activeElement;if((!c||c!==o&&c!==a||c.classList.contains("smart-hidden"))&&(i.focus(),c=i),m.removeAllRanges(),delete r._selectionRange,!isNaN(e)&&!isNaN(t)&&e!==t){if(c===o)o.setSelectionRange(e,t),r._selectionRange={selectionStart:e,selectionEnd:t};else{const n=r._getNodes(a,e,t).nodes;for(let e=0,t=n.length;e<t;e+=1){const{node:t,index:o,startIndex:a}=n[e],i=d.createRange();t.nodeType===Node.TEXT_NODE?(i.setStart(t,Math.max(0,a)),i.setEnd(t,Math.min(o,t.nodeValue.length))):i.selectNodeContents(t),m.addRange(i),r._selectionRange=i}}r._updateToolbarItems()}}saveState(){const e=this;e.id?window.localStorage.setItem("smartEditor"+e.id,e.$.editableElement.innerHTML):e.warn(e.localize("noId"))}splitMode(e){const t=this;t.$.fireEvent("actionStart",{name:"splitMode"}).defaultPrevented||(t._handleSplitMode(t._toggleItem("splitmode",e)),t.$.fireEvent("actionEnd",{name:"splitMode"}))}previewMode(e){const t=this;t.$.contentContainer.hasAttribute("split-mode")||t.$.fireEvent("actionStart",{name:"sourcecode"}).defaultPrevented||(t._handleSourceCodeMode(t._toggleItem("sourcecode",e)),t.$.fireEvent("actionEnd",{name:"sourcecode"}))}print(){this._handlePrint()}updateToolbarItem(e,t){const r=this,n=r.toolbarItems;let o;if("string"==typeof e?o=n.find((t=>t.name===e)):"number"==typeof e&&(o=n[e]),o){r._closePopups(),r._closeWindow(),delete r._toolbarItemsObj[o.name],delete r._inlineToolbarItemsObj[o.name];for(let e in t)o[e]=t[e];return r._refreshToolbarItems(r._getToolbarItems()),!0}}_toggleItem(e,t){const r=this._toolbarItemsObj;if(!r)return;const n=r[e],o=this.$.toolbar.querySelector(`.smart-editor-toolbar-item[item-name="${e}"]`);return n&&o?((t=n.value=void 0===t?!n.value:!!t)?(o.setAttribute("checked",""),o.setAttribute("aria-pressed",!0)):(o.removeAttribute("checked"),o.setAttribute("aria-pressed",!1)),o):void 0}_ajax(e,t={}){const r=this;let n="GET",o=e.url,a=null,i=!0;if(e.type&&(n=e.type),e.data)if("GET"===n){o+="?";for(let t in e.data)Object.prototype.hasOwnProperty.call(e.data,t)&&(o+=encodeURI(t+"="+e.data[t]+"&"));"&"===o.charAt(o.length-1)&&(o=o.slice(0,o.length-1))}else"POST"===n&&(a=JSON.stringify(e.data));t&&!1===t.async&&(i=!1),void 0!==window.fetch&&i?r._ajaxFetch(e,t,n,o,a):r._ajaxXMLHttpRequest(e,t,n,o,a,i)}_ajaxFetch(e,t,r,n,o){const a=this,i={method:r};let s,l,d;if(t&&t.contentType&&(i.headers=new Headers({"Content-Type":t.contentType})),null!==o&&(i.body=o),e.timeout&&(l=setTimeout((function(){d=!0}),e.timeout)),t.beforeSend){if(!1===t.beforeSend(i,t))return}fetch(n,i).then((function(e){if(d)throw s=408,a.error(a.localize("timeout",{elementType:a.nodeName.toLowerCase()}));if(l&&clearTimeout(l),s=e.status,!e.ok)throw a.error(a.localize("importError",{elementType:a.nodeName.toLowerCase(),status:e.statusText}));return e.text()})).then((e=>a._ajaxComplete(t,e,s))).catch((function(e){t&&t.loadError&&t.loadError(s,e)}))}_ajaxXMLHttpRequest(e,t,r,n,o,a){const i=new XMLHttpRequest,s=this;if(i.open(r,n,a),i.ontimeout=function(){t&&t.loadError&&t.loadError(408,"timeout")},i.onload=function(){if(4===i.readyState){const r=i.status;let n=i.response;r>=200&&r<=299?("json"===e.dataType&&(n=JSON.parse(n)),s._ajaxComplete(t,n,r)):t&&t.loadError&&t.loadError(r,n)}},i.onerror=function(){t&&t.loadError&&t.loadError(i.status,i.response)},t&&t.contentType&&i.setRequestHeader("Content-Type",t.contentType),a&&e.timeout&&(i.timeout=e.timeout),t.beforeSend){if(!1===t.beforeSend(i,t))return}i.send(o)}_ajaxComplete(e,t){if(e){if(e.beforeLoadComplete){const r=e.beforeLoadComplete(t);r&&(t=r)}this._handleInputContent("value",t)}}_afterInputHandler(e){const t=this,r=t._beforeInputObj,n=t.$.editableElement,o=!n.innerHTML;let a,i;if(r&&r.type&&(a=r.type,i=r.rangeDetails),delete t._beforeInputObj,o&&(t._setResizeFrame(),t._closeToolbar()),"insertParagraph"===a||o){let e=t._getSelectionRange().startContainer;if(e.nodeType===Node.TEXT_NODE&&(e=e.parentElement),e&&e.classList&&(e.closest(".smart-editor-image-caption")||e.closest(".smart-editor-editable table")))return;const r=t.$.iframe,[a,i]=r?[r.contentWindow,r.contentDocument]:[window,document];("div"===a.getSelection().anchorNode.nodeName.toLowerCase()||e===n&&o)&&i.execCommand("insertHTML",!1,"<p><br></p>")}else if(a&&i&&a.indexOf("delete")>-1){const e=t._resizeFrameObj;e&&e.target&&!n.contains(e.target)&&t._setResizeFrame()}n.textContent.length&&n.innerText.length?n.removeAttribute("show-placeholder"):n.setAttribute("show-placeholder",""),t.name&&e.target===t.$.editableElement&&"markdown"!==t.editMode&&(t.$.input.value=t._getInputValue(t.$.editableElement.innerHTML.trim())),t._setCharCount()}_beforeInputHandler(e){const t=this,r=t.$.iframe,n=t.$.contentContainer,o=t.$.editableElement,a=(r?r.contentWindow:window).getSelection().getRangeAt(0),i=e.inputType,s=a.startContainer;let l;if(i&&(l=i.indexOf("delete")>-1,t._beforeInputObj={type:i,rangeDetails:{startOffset:a.startOffset,endOffset:a.endOffset,startContainer:a.startContainer,endContainer:a.endContainer}}),l&&o.contains(s))if(s===a.endContainer&&a.startOffset===a.endOffset){const e=t._resizeFrameObj;let r=s;if(e&&e.target&&e.target.contains(s))return;if(r.nodeType!==Node.TEXT_NODE&&r.innerHTML.length){if(r===o)return}else{let e=r.parentElement,t=r.previousElementSibling;for(;!t&&e;)t=e.previousElementSibling,e=e.parentElement;o!==t&&o.contains(t)&&!t.innerHTML.length&&t.nodeName}}else a.deleteContents(),e.preventDefault();if(!n.classList.contains("char-count-maxed")||l){if("insertParagraph"===i){const r=t._getSelectionRange().startContainer;if(r.nodeType===Node.TEXT_NODE&&r.parentElement===o){if(-1!==t.$.editableElement.innerHTML.indexOf("<")){const r=document.createElement("p");r.innerHTML="&#8203;";const n=document.createElement("span");n.id="INSERTION_MARKER",n.innerHTML="&nbsp;";let a=t._getSelectionRange(),i=a.endContainer;i.parentElement.insertBefore(r,a.endContainer.nextSibling),i.parentElement.insertBefore(n,r.nextSibling),t.selectRange(a);const s=o.getRootNode().querySelector("#INSERTION_MARKER");return t._setSelectionRange(s.previousElementSibling),a=t._getSelectionRange(),a.collapse(),s.remove(),e.preventDefault&&e.preventDefault(),!1}o.getRootNode().execCommand("formatBlock",!1,"p")}}}else e.preventDefault()}_changeHandler(e){const t=this,r=e.target,n=e.detail,o=r.closest(".smart-editor-toolbar-item");if(e.stopPropagation(),t._toolbarItemsObj||t._inlineToolbarItemsObj)return o&&r===t.$.inputPopup||r===t.$.colorInputPopup?(t._ignoreSelectionChange=!0,t._updateToolbarItem(o,n),void delete t._ignoreSelectionChange):void 0}_contextMenuHandler(e){const t=this,r=t.contextMenu;"browser"!==r?(e.preventDefault(),"none"!==r?t._openContextMenu(e):t._closeContextMenu()):t._closeContextMenu()}_closeContextMenu(){const e=this.$.inlineToolbar,t=this.$.fireEvent("dropDownToolbarClosing",{target:e}).defaultPrevented;e&&e.visible&&e.classList.contains("smart-editor-context-menu")&&!t&&e.close()}_openContextMenu(e){const t=this,r=e.target;let n=t.$.inlineToolbar;n||(n=t._createToolbar());if(t.$.fireEvent("contextMenuOpening",{target:n}).defaultPrevented)return;t._setupToolbar(r,"context"),n.parentElement||t.getShadowRootOrBody().appendChild(n),n.clear(),t._setContextMenuContent(r);const o=t.getBoundingClientRect();n.style.left=Math.min(e.pageX+1,o.right+window.pageXOffset-n.offsetWidth)+"px",n.style.top=Math.min(e.pageY+1,o.bottom+window.pageYOffset-n.offsetHeight)+"px",n.open()}_setContextMenuContent(e){const t=this;if(!e)return;let r=t._contextList,n=t._getContextMenuTargetType(e),o=t._getContextMenuDataSource(e,n);r||(t._contextList=r=document.createElement("div"),r.classList.add("smart-editor-context-menu-item-container"));const a=document.createDocumentFragment(),i=o.length;let s=r.children;for(;s.length>i;)s[0].remove();s=Array.from(s);for(let r=0;r<i;r++){const i=o[r];let l,d,m=s[r];if("object"==typeof i?(l=i.label,d=i.value):l=d=i+"",m||(m=document.createElement("div"),m.classList.add("smart-editor-context-menu-item"),m.setAttribute("role","option")),m.removeAttribute("disabled"),"deleteLink"!==i||"image"!==n||e.closest(".smart-editor-editable a")){if("cut"===i||"copy"===i){const e=t._getSelectionRange();(void 0!==e.selectionStart?e.selectionStart:e.startOffset)===(void 0!==e.selectionEnd?e.selectionEnd:e.endOffset)&&m.setAttribute("disabled","")}}else m.setAttribute("disabled","");m.parentElement||a.appendChild(m),m.innerHTML=t.localize(l)||l,m.setAttribute("value",d)}r.appendChild(a),t.$.inlineToolbar.appendChild(r)}_getContextMenuTargetType(e){let t;return t=e.closest(".smart-editor-editable table")?"table":e.closest(".smart-editor-editable img")?"image":e.closest(".smart-editor-video-container")?"video":e.closest(".smart-editor-editable a")?"link":"text",t}_getContextMenuDataSource(e,t){if(!t)return[];const r=this.contextMenuDataSource;let n;switch(t){case"table":n=["tableProperties","insertRowAfter","insertRowBefore","insertColumnLeft","insertColumnRight","deleteRow","deleteColumn","deleteTable","selectAll"];break;case"image":n=["imageProperties","copyImage","cutImage","createLink","deleteLink","deleteImage","caption"];break;case"video":n=["videoProperties","copyVideo","cutVideo","deleteVideo","caption"];break;case"link":n=["linkProperties","deleteLink","selectAll"];break;default:n=["copy","cut","paste","selectAll"]}return r&&(n="function"==typeof r?r(e,t,n):Array.isArray(r)?r:[]),n}_updateToolbarItem(e,t){const r=this,n=r.editMode,o=e.getAttribute("item-name"),a=r.$.toolbarItemsPrimary,i=r.$.toolbarItemsSecondary,s=r.$.inlineToolbar,l="markdown"===n?r.$.input:r.$.editableElement,d=(e,n,o)=>{n&&(n.label=t["alignment"===n.name?"value":"label"],n.value=t.value,e&&r._setItemValue(e,n),o&&r._updateToolbarTarget(n))};if(s&&s.contains(e)?(d(e,r._inlineToolbarItemsObj[o],!0),r._toolbarItemsObj&&r._toolbarItemsObj[o]&&d(r.$.toolbar.querySelector(`.smart-editor-toolbar-item[item-name=${o}]`),r._toolbarItemsObj[o])):(a.contains(e)||i.contains(e))&&r._toolbarItemsObj&&(d(e,r._toolbarItemsObj[o],!0),s&&s.visible&&r._inlineToolbarItemsObj&&d(s.querySelector(`.smart-editor-toolbar-item[item-name=${o}]`),r._inlineToolbarItemsObj[o])),l.getRootNode().activeElement!==l){const e=r._selectionRange,t=l.scrollTop;e&&("markdown"===n?r._setSelectionRange(l,e.selectionStart,e.selectionEnd):r._setSelectionRange(e.startContainer,e.startOffset,e.endOffset)),l.focus({preventScroll:!0}),r._isSafari&&t&&(l.scrollTop=t)}}_updateToolbarTarget(e){const t=this,r=t._resizeFrameObj;if(!e)return;const n=t.$.inlineToolbar;let o;r&&r.target?o=r.target:n&&n.visible&&(o=n.selector,o=o.closest?o.closest(".smart-editor-editable img")||o.closest(".smart-editor-editable table"):void 0);const a=o?o.nodeName.toLowerCase():"";if(o&&"img"===a)return"alignment"===e.name&&(o.closest(".smart-editor-image-container")||o).setAttribute("alignment",e.value),t._setResizeFrame(o),void(n&&n.visible&&n.reposition());if(o&&"table"===a)return void t._handleTableToolbarAction(e,o);const i=t._getSelectionRange();if(i&&(i.startContainer||void 0!==i.selectionStart)){const r=e.name;if(t.$.fireEvent("actionStart",{name:r}).defaultPrevented)return;switch(r){case"backgroundcolor":t._handleBackgroundColor(e);break;case"fontcolor":t._handleFontColor(e);break;case"alignment":t._handleTextAlignment(e);break;case"fontsize":t._handleFontSize(e);break;case"fontname":t._handleFontName(e);break;case"formats":t._handleFormats(e);break;case"paste":t._handlePaste(e);break;default:{const t=i.startContainer.closest?i.startContainer:i.startContainer.parentElement;return void(t&&t.closest&&t.setAttribute(e.name,e.value))}}r&&t.$.fireEvent("actionEnd",{name:r})}}_setSelectionRange(e,t,r){const n=this,o=n.$.iframe,a=n.editMode;let i;if(n.disabled)return;if("markdown"===a||n.$.editableElement.classList.contains("smart-hidden")){i=n.$.input,n._selectionRange={selectionStart:void 0!==t?t:i.selectionStart,selectionEnd:void 0!==r?r:i.selectionEnd};const e=n._selectionRange;return void(n._selectionChangeFired||i.setSelectionRange(e.selectionStart,e.selectionEnd))}const s=(o?o.contentWindow:window).getSelection();let l;if(i=n.$.editableElement,e){if(l=document.createRange(),"number"==typeof t&&"number"==typeof r)try{l.setStart(e,parseInt(t)),l.setEnd(e,parseInt(r))}catch(t){l.selectNodeContents(e)}else"img"===e.nodeName.toLowerCase()||e.classList.contains("smart-editor-video-container")?(l.setStartBefore(e),l.setEndAfter(e),l.selectNode(e)):l.selectNodeContents(e);s.removeAllRanges(),s.addRange(l)}else s.rangeCount&&(l=s.getRangeAt(0));try{l&&l.startContainer&&i.contains(l.startContainer)&&(n._selectionRange=l)}catch(e){}n._selectionRange||(l=document.createRange(),l.selectNodeContents(i),l.collapse(!0),n._selectionRange=l)}_getSelectionRange(){const e=this,t=e.editMode;let r=e._selectionRange;return r&&("markdown"===t&&void 0===r.selectionStart||"html"===t&&void 0===r.startContainer)&&(delete e._selectionRange,r=void 0),r||e._setSelectionRange(),e._selectionRange}_setCharCount(){const e=this,t=e.$.contentContainer;if(!e.showCharCount)return void t.removeAttribute("char-count");const r=e.maxCharCount;let n,o;if("html"===e.editMode){const t=e.$.editableElement,r=t.textContent.length,n=t.innerText.length;o=n&&r?n:0}else o=e.$.input.value.length;if(n=e.charCountFormatFunction?e.charCountFormatFunction(o,r)+"":r?`${o} / ${r}`:o+"",t.setAttribute("char-count",n),null===r)return void t.classList.remove("char-count-low","char-count-medium");const a=parseFloat((o/r).toFixed(2));t.classList[a>=.7&&a<=.9?"add":"remove"]("char-count-warning"),t.classList[a>=.9?"add":"remove"]("char-count-error"),t.classList[o>=r?"add":"remove"]("char-count-maxed")}_documentDownHandler(e){const t=this,r=t.$.iframe,n=t.$.inlineToolbar,o=t.$.window,a=e.originalEvent||e,i=t.shadowRoot||t.isInShadowDOM?a.composedPath()[0]:a.target;if(n&&n.contains(i)){const e=i.closest(".smart-editor-toolbar-item");return t._handleToolbarItemDown(e,i),void a.preventDefault()}if(t.$.container.contains(i)||r&&r.contentDocument.body.contains(i))return void t._handleDownInside(a,i);const s=i.closest(".smart-input-drop-down-menu");let l;if(s&&(l=s.ownerElement),o&&o.opened&&!o.contains(l||i)&&o.close(),t._handleTableSelection(),l&&(t.$.toolbarItemsPrimary.contains(l)||t.$.toolbarItemsSecondary.contains(l)||n&&n.contains(l)))return t._toolbarItemClick={},void a.preventDefault();t._setResizeFrame(),t._closePopups()}_handleDownInside(e,t){const r=this,n=e.originalEvent||e,o=t.closest(".smart-editor-toolbar-item"),a=r.$.inlineToolbar,i=t.classList.contains("smart-editor-video-container")?t:null,s=r.$.window;let l=r._editorVideoItemClick;if(l&&(i&&l.dragElement&&l.dragElement.remove(),delete r._editorVideoItemClick,l=void 0),t===r.$.toolbarToggleButton)r._toolbarItemClick={},e.preventDefault();else{if(o)return r._handleToolbarItemDown(o,t),void e.preventDefault();if(t.closest(".smart-editor-toolbar-tab"))e.preventDefault();else if(i)l||(l=r._editorVideoItemClick={target:t,originalSelectionRange:r._selectionRange}),e.preventDefault(),!1!==i.getAttribute("draggable")&&i.querySelector("video")?(l.dragElement=r._createWhiteSpaceChar(t,i),r._setSelectionRange(t)):l.dragElement&&(l.dragElement.remove(),delete l.dragElement);else if(t.closest(".smart-editor-search-bar"))r._searchBarDown={target:t},t.closest(".smart-search-input")||e.preventDefault();else{const e={x:n.pageX+window.pageXOffset,y:n.pageY+window.pageYOffset};s&&s.opened&&s.close();const o=r._getInlineToolbarTarget(t,e);if(o){const t=r.$.contentContainer;t.contains(t.getRootNode().activeElement)||r._focusEditableElement(),r._handleInlineToolbarItemDown(o,e)}else!a||a.contains(t)&&a.classList.contains("smart-editor-drop-down-toolbar")||(r._closeToolbar(),r._handleTableSelection())}}r._closeToolbarItemDropDown(r.$.inputPopup),r._closeToolbarItemDropDown(r.$.colorInputPopup)}_handleToolbarItemDown(e,t){const r=this,n=r.$.inlineToolbar,o=r.$.window;if(!e)return;const a=e.getAttribute("item-type"),i=e.getAttribute("item-name");switch(!o||!o.opened||o._target&&o._target.item.name===i||o.close(),r._toolbarItemClick={toolbarItem:e},r._resizeFrameObj&&r._resizeFrameObj.target?r._toolbarItemClick.target=r._resizeFrameObj.target:r._setResizeFrame(),r._setSelectionRange(),a){case"button":["hyperlink","createlink","image","video"].includes(i)?r._toolbarItemClick.callback=r._toggleWindow:"table"===i&&(r._toolbarItemClick.callback=n&&n.contains(e)?r._toggleWindow:r._toggleDropDownToolbar);break;case"toggle":e.toggleAttribute("checked"),e.hasAttribute("checked")?e.setAttribute("aria-pressed",!0):e.setAttribute("aria-pressed",!1),r._closeToolbarItemDropDown(r.$.inputPopup),r._closeToolbarItemDropDown(r.$.colorInputPopup);break;case"drop-down":r._toolbarItemClick.callback=r._toggleItemDropDown;break;case"color-input":t.closest(".smart-editor-item-drop-down-button")&&(r._toolbarItemClick.callback=r._toggleItemDropDown)}}_handleInlineToolbarItemDown(e,t){const r=this,n=e.closest(".smart-editor-editable table"),o=r.$.editableElement;if(r._inlineToolbarClickObj&&r._inlineToolbarClickObj.target&&(r._inlineToolbarClickObj.target.removeAttribute("drag-id"),r._inlineToolbarClickObj.dragElement&&r._inlineToolbarClickObj.dragElement.removeAttribute("drag-id")),r._inlineToolbarClickObj={},e)if("img"===e.nodeName.toLowerCase())e.setAttribute("drag-id",Math.random().toString(36).substr(2,5));else if(e.classList.contains("smart-editor-video-container")){const t=e.querySelector("video, iframe");t&&(t.setAttribute("drag-id",Math.random().toString(36).substr(2,5)),r._inlineToolbarClickObj.dragElement=t)}if(n&&o.hasAttribute("table-cell-resize")){const a=o.getAttribute("table-cell-resize");r._inlineToolbarClickObj.resizeDetails={x:t.x,y:t.y,position:a,target:"vertical"===a?e.closest("tr"):e,table:n},e=void 0}r._handleTableSelection(e),r._inlineToolbarClickObj.target=e,r._inlineToolbarClickObj.dragTarget=e}_getInlineToolbarTarget(e,t){const r=this;let n,o=e.closest(".smart-editor-editable img")||e.closest(".smart-editor-editable a")||e.closest(".smart-editor-video-container");return o||(n=e.closest(".smart-editor-editable table"),n&&(o=e.closest(".smart-editor-editable td")||e.closest(".smart-editor-editable th"))),e.closest(".smart-editor-resize-frame")&&r._resizeFrameObj?(r._resizeFrameObj.resizeDetails={x:t.x,y:t.y,position:e.getAttribute("position")},o=r._resizeFrameObj.target):o&&(o&&"img"===o.nodeName.toLowerCase()||n||o.classList.contains("smart-editor-video-container"))||r._setResizeFrame(),o}_documentMoveHandler(e){const t=this,r=t._resizeFrameObj,n=t._inlineToolbarClickObj,o=e.originalEvent||e;r&&r.resizeDetails?t._handleFrameResize(o):n&&n.resizeDetails&&t._handleTableCellResize(o)}_touchmoveHandler(e){const t=this,r=t._resizeFrameObj;t._isMobile&&r&&r.target&&(r.resizeDetails?(e.preventDefault(),e.stopPropagation()):(t._closeToolbar(),t._setResizeFrame()))}_dragStartHandler(e){const t=this,r=t._resizeFrameObj,n=t._inlineToolbarClickObj;if(r&&r.resizeDetails||n&&n.resizeDetails)return e.preventDefault(),void delete t._dragDetails;if(!t.$.contentContainer.contains(e.target))return;if(!n||!n.target)return void e.preventDefault();const o=t._inlineToolbarClickObj.target;if(o&&(["img","table"].indexOf(o.nodeName.toLowerCase())>-1||o.classList.contains("smart-editor-video-container"))){if("false"===o.getAttribute("draggable"))return void e.preventDefault();const r=e.target,n=r.parentElement,a=r.closest(".smart-editor-image-container");t._closeToolbar(),t._setResizeFrame(),t._dragDetails={target:r,scrollTop:t.$.editableElement.scrollTop,container:a,anchor:n&&"a"===n.nodeName.toLowerCase()?n:void 0,caption:a?a.querySelector(".smart-editor-image-caption"):void 0}}}_dropHandler(){const e=this;e._isFireFox&&e._dragEndHandler()}_dragEndHandler(){const e=this,t=e.$.inlineToolbar,r=e._dragDetails;if(r){const n=r.target,o=r.container,a=e.$.editableElement,i=a.querySelector(`[drag-id="${n.getAttribute("drag-id")}"]`);if(i){const n=r.anchor;if(i.removeAttribute("drag-id"),o&&!o.contains(i)&&i.parentElement){const e=r.caption;let t=i.parentElement;if(t.classList.contains("smart-editor-video-container")){const e=t;t=t.parentElement,e.remove(),t.appendChild(i)}o.remove(),o.innerHTML="",t.insertBefore(o,i),o.appendChild(i),e&&o.appendChild(e)}n&&i.parentElement!==n&&(n.innerHTML="",i.parentElement.insertBefore(n,i),n.appendChild(i)),void 0!==r.scrollTop&&(a.scrollTop=r.scrollTop),requestAnimationFrame((()=>e._setResizeFrame(i)));const s=e._resizeFrameObj;if(e._editorVideoItemClick){const t=a.querySelectorAll('.smart-editor-video-white-space, div[pseudo="-webkit-media-controls"]');for(let e=0,r=t.length;e<r;e+=1)t[e].remove();delete e._editorVideoItemClick}(!t||t&&!t.visible)&&s&&s.target&&e._openInlineToolbar(s.target)}return void delete e._dragDetails}e._setSelectionRange();const n=e._getSelectionRange();n&&n.startOffset!==n.endOffset&&(e._handleInlineToolbar(n.startContainer),e._focusEditableElement())}_documentUpHandler(e){const t=this,r=t._resizeFrameObj,n=t.$.inlineToolbar,o=e.originalEvent||e,a=t.shadowRoot||t.isInShadowDOM?o.composedPath()[0]:o.target;if(r&&(r.resizeDetails&&r.target&&(r.target.removeAttribute("dragged"),t.$.fireEvent("resizeEnd",{target:r.target})),delete r.resizeDetails),t._dragDetails)return t._endInlineToolbarClick(),void delete t._toolbarItemClick;const i=t.$.iframe;if(t.$.container.contains(a)||n&&n.contains(a)||i&&i.contentDocument.body.contains(a)){const e=a.closest(".smart-editor-toolbar-item");e?t._handleToolbarUp(e):t._handleContentUp(o,a)}t._endInlineToolbarClick(),delete t._searchBarDown,delete t._dragDetails,delete t._toolbarItemClick}_handleToolbarUp(e){const t=this,r=t._toolbarItemClick,n=e.getAttribute("item-type");if(r&&r.toolbarItem===e){const e=r.toolbarItem;"custom"!==n&&(t._handleToolbarItemClick(event,e),t._focusEditableElement())}}_handleContentUp(e,t){const r=this,n=r._inlineToolbarClickObj,o=r.$.toolbarToggleButton,a=r._editorVideoItemClick,i=void 0!==e.button&&2===e.button;if(i||t!==o&&!o.contains(t))if(t.classList.contains("smart-editor-toolbar-tab"))r.$.toolbar.hasAttribute("expanded")?t.hasAttribute("checked")||r._selectToolbarTab(t):(r._selectToolbarTab(t),r._toggleSecondaryToolbar(t.hasAttribute("checked")));else if(a&&t.classList.contains("smart-editor-video-container")&&t===a.target)r._setResizeFrame(t),r._focusEditableElement();else if(n){const e=n.target;e&&(e===t||e.contains(t))&&(i?r._setResizeFrame(e):r._handleInlineToolbar(e),r._focusEditableElement())}else if(!i&&(r.$.editableElement.contains(t)||"markdown"===r.editMode&&t===r.$.input)){const e=r.$.iframe,t=e?e.contentWindow:window;requestAnimationFrame((()=>{e&&r._setSelectionRange();const n=r._getSelectionRange();if(n instanceof t.Range){let e=n.startContainer;n.startOffset!==n.endOffset&&(r._handleInlineToolbar(e),r._focusEditableElement())}}))}else!i&&t.closest(".smart-editor-search-bar")&&r._handleSearchButtonClick(t.closest(".smart-search-button"));else r._toggleToolbar(r.$.toolbar.hasAttribute("expanded"))}_toggleSecondaryToolbar(e){const t=this,r=t.$.toolbar,n=t.$.toolbarItemsPrimary,o=t.$.toolbarItemsSecondary,a=()=>{r.hasAttribute("expanded")?(o.classList.remove("smart-drop-down"),r.contains(o)||r.appendChild(o),o.style.top=""):(o.classList.add("smart-drop-down"),r.contains(o)&&r.parentElement.insertBefore(o,r.nextElementSibling),o.style.top=n.offsetTop+n.offsetHeight+"px")};if(!e&&(o.classList.add("smart-visibility-hidden"),t.hasAnimation))return o.addEventListener("transitionend",a,{once:!0}),void o.addEventListener("transitioncancel",a,{once:!0});a(),e&&(t._setToolbarGroupHeight(),o.classList.remove("smart-visibility-hidden"))}_setToolbarGroupHeight(){const e=this.$.toolbarItemsSecondary,t=e.children;if(e.style.height="","menu"===this.toolbarMode)return;let r;for(let e=0,n=t.length;e<n;e+=1){const n=t[e].offsetHeight;(void 0===r||r<n)&&(r=n)}void 0!==r&&(e.style.height=r+"px")}_endInlineToolbarClick(){const e=this,t=e._inlineToolbarClickObj;if(t){const r=t.resizeDetails;if(!e._dragDetails&&t.target&&(t.target.removeAttribute("drag-id"),t.dragElement&&t.dragElement.removeAttribute("drag-id")),r&&r.target){if("horizontal"===r.position){const e=r.cells,t=r.table.offsetWidth;e&&e.forEach((e=>{e.style.width&&(e.style.width=100*parseFloat((e.offsetWidth/t).toFixed(2))+"%")}))}e.$.editableElement.removeAttribute("table-cell-resize"),r.target.removeAttribute("resizing"),r.isInlineToolbarOpened&&e._handleInlineToolbar(r.target)}delete e._inlineToolbarClickObj}}_updateToolbarItems(e,t){const r=this;if(r._dragDetails||r.readonly||r.disabled)return;if("markdown"===r.editMode)return void r._updateToolbarItemsMarkdown(e);const n=r._getSelectionRange(),o=r.$.inlineToolbar;let a,i;if(!n)return;if(t||(t=r.$.toolbar),o&&t!==o&&!r.hideInlineToolbar&&o.visible&&(r._updateToolbarItems(e,o),a=!0),t!==r.$.toolbar||r.hideToolbar?a||r.hideInlineToolbar||(i=r._inlineToolbarItemsObj):i=r._toolbarItemsObj,!i)return;const s=r.$.editableElement;let l,d=n.startOffset>n.endOffset?n.endContainer:n.startContainer;if(d&&(d.closest||(d=d.parentElement),d&&d.closest)){e||(e=["alignment","bold","italic","strikethrough","underline","fontsize","fontname","formats","fontcolor","backgroundcolor","orderedlist","unorderedlist","subscript","superscript"]);for(let n=0,o=e.length;n<o;n+=1){const o=e[n],a=i[o];if(a){let e;if("alignment"===o)e=d.style.textAlign;else if("bold"===o)e=!!r._getNodeFromList(d,["b","strong","h1","h2","h3","h4","h5","h6"]);else if("italic"===o)e=!!r._getNodeFromList(d,["i"]);else if("underline"===o)e=!!r._getNodeFromList(d,["u"]);else if("strikethrough"===o)e=!!r._getNodeFromList(d,["strike"]);else if("fontsize"===o){const t=d.closest(".smart-editor-editable font");t&&(e=t.style.fontSize),e||(l||(l=window.getComputedStyle(d)),e=l.fontSize),e=parseInt(e),isNaN(e)&&(e="")}else if("fontname"===o){const t=d.closest(".smart-editor-editable font");t&&t.hasAttribute("face")?e=t.getAttribute("face"):(l||(l=window.getComputedStyle(d)),e=l.fontFamily.split(",")[0])}else if("formats"===o&&d!==s){const t=a.dataSource;if(e="",t){const n=t.map((e=>e.value));e=r._getNodeFromList(d,n)||""}}else if("fontcolor"===o){const t=d.closest(".smart-editor-editable font");t?e=t.color:(l||(l=window.getComputedStyle(d)),e=l.color)}else"backgroundcolor"===o?(e=r._getNodeBackgroundColor(d),e||(l||(l=window.getComputedStyle(d)),e=l.backgroundColor)):"orderedlist"===o||"unorderedlist"===o?e=!!d.closest(`.smart-editor-editable ${"orderedlist"===o?"ol":"ul"} li`):"subscript"===o?e=!!d.closest(".smart-editor-editable sub"):"superscript"===o&&(e=!!d.closest(".smart-editor-editable sup"));if(!e&&a.dataSource){const t=a.dataSource[0];t&&(e=t.value||t)}null!==e&&(a.value=e,r._setItemValue(t.querySelector(`.smart-editor-toolbar-item[item-name=${o}]`),a))}}}}_updateToolbarItemsMarkdown(e){const t=this,r=t._getSelectionRange();if(!r||void 0===r.selectionStart)return;const n=r.selectionStart;e||(e=["bold","italic","strikethrough","underline","formats","orderedlist","unorderedlist","subscript","superscript"]);for(let r=0,o=e.length;r<o;r+=1){const o=e[r],a=t._toolbarItemsObj[o];if(a){let e;if("bold"===o)e=!!t._getMarkdownItem(n,"**"),e||(e=!!t._getMarkdownItem(n,"__"));else if("italic"===o)e=!!t._getMarkdownItem(n,"*"),e||(e=!!t._getMarkdownItem(n,"_"));else if("strikethrough"===o)e=!!t._getMarkdownItem(n,"~~");else if("underline"===o)e=!!t._getMarkdownItem(n,"<ins>","</ins>");else if("formats"===o){const r=a.dataSource;if(e="",r){const o=r.map((e=>e.value));e:for(let r=0,a=o.length;r<a;r+=1)if(e=t._getMarkdownFormat(n,o[r]),e&&void 0!==e.formatName){e=e.formatName;break e}}}else"orderedlist"===o||"unorderedlist"===o?e=!!t._getMarkdownFormat(n,o):"subscript"===o?e=!!t._getMarkdownItem(n,"<sub>","</sub>"):"superscript"===o&&(e=!!t._getMarkdownItem(n,"<sup>","</sup>"));if(!e&&a.dataSource){const t=a.dataSource[0];t&&(e=t.value||t)}null!==e&&(a.value=e,t._setItemValue(t.$.toolbar.querySelector(`.smart-editor-toolbar-item[item-name=${o}]`),a))}}}_getMarkdownItem(e,t,r=t){const n=this.$.input.value,o=n.lastIndexOf(t,Math.max(0,e-1)),a=n.indexOf(r,o>-1?o+t.length:e);if(!(o<0||o>e||a<0||a<e||n.slice(o,e).indexOf("\n")>-1||n.slice(e,a).indexOf("\n")>-1))return" "!==n[o+1]&&n[o-1]!==t&&n[o+1]!==t&&" "!==n[a-1]&&n[a-1]!==t&&n[a+1]!==t?{startIndex:o,endIndex:a+r.length}:void 0}_getMarkdownFormat(e,t){const r=this.$.input.value,n=r.lastIndexOf("\n",Math.max(0,e-1))+1,o=r.slice(n,e);let a;switch(t){case"h1":a="# ";break;case"h2":a="## ";break;case"h3":a="### ";break;case"h4":a="#### ";break;case"h5":a="##### ";break;case"h6":a="###### ";break;case"code":case"pre":a="```";break;case"blockquote":a="> ";break;case"orderedlist":{const e=/^\s*([0-9]+\.{1}\s+)/gs.exec(o);return e?{formatName:t,occuranceIndex:n+e.input.indexOf(e[1])}:void 0}case"unorderedlist":{const e=/^\s*([-+*]{1}\s+)/gs.exec(o);return e?{formatName:t,occuranceIndex:n+e.input.indexOf(e[1])}:void 0}default:a=t+""}const i=o.indexOf(a);if(i>=0&&i<=3&&o.slice(i,a.length)===a)return{formatName:t,occuranceIndex:n+i,markdown:a}}_getNodeFromList(e,t){const r=this.$.editableElement;if(e&&t)for(;e&&e!==r;){const r=e.nodeName.toLocaleLowerCase();if(t.indexOf(r)>-1)return r;e=e.parentElement}}_getNodeBackgroundColor(e){const t=this.$.editableElement;for(;e&&e!==t;){const t=e.style.backgroundColor;if(t)return t;e=e.parentElement}}_editableElementBlurHandler(e){const t=this,r=t.$.editableElement,n=t.$.contentContainer;if(!t._toolbarItemClick&&!n.contains(n.getRootNode().activeElement)){const o=t._value,a=()=>{n.removeAttribute("required"),t._requiredMessage&&(t.hideMessage(t._requiredMessage),delete t._requiredMessage)},i=t._getCurrentValue();if(t.required){const e=t.$.editableElement;"markdown"===t.editMode&&!t.$.input.value||"markdown"!==t.editMode&&!e.textContent&&!e.querySelectorAll("img, table").length?(n.hasAttribute("required")||n.setAttribute("required",""),t._requiredMessage||(t._requiredMessage=t.showMessage(t.localize("requiredMessage"),{autoClose:!1,iconType:"error"}))):a()}else a();o!==i&&(t.$.fireEvent("change",{oldValue:o,value:i}),t.name&&e.target===r&&"markdown"!==t.editMode&&(t.$.input.value=t._getInputValue(r.innerHTML.trim()))),t.removeAttribute("focus"),t.removeAttribute("aria-activedescendant")}}_editableElementFocusHandler(e){const t=this,r=t.editMode,n="markdown"===r?t.$.input:t.$.editableElement;let o=t._autoSaveObj;t.setAttribute("focus",""),e.target.id&&t.setAttribute("aria-activedescendant",e.target.id),t._value=t._getCurrentValue(),t.autoSave?(o||(o=t._autoSaveObj={}),clearInterval(o.interval),o.interval=setInterval((()=>{n.getRootNode().activeElement!==n&&clearInterval(o.interval),window.localStorage.setItem("smartEditor"+t.id,"markdown"===r?n.value:n.innerHTML)}),t.autoSaveInterval)):o&&(clearInterval(o.interval),delete t._autoSaveObj)}_inputChangeEvent(e){e.stopPropagation()}_updateOnInputChange(e){const t=this,r=t.$.editableElement,n=e.target,o=t.$.input,a=n.classList.contains("smart-search-input"),i=()=>{const e=s===o?o.value:t.$.editableElement.innerHTML;void 0!==l&&e!==l&&t.$.fireEvent("changing",{value:e,oldValue:t._changingValue})};if("paste"===e.type&&r.contains(n)){const r=e.clipboardData;if(r&&r.types.length){const n=r.types.indexOf("text/html")>-1?"text/html":"text/plain",[o,a]=["\x3c!--StartFragment--\x3e","\x3c!--EndFragment--\x3e"];let i=r.getData(n);e.preventDefault();let s=(e.clipboardData||e.originalEvent.clipboardData).items,l=null;for(let e=0;e<s.length;e++)0===s[e].type.indexOf("image")&&(l=s[e].getAsFile());if(null!==l){let e=new FileReader;return e.onload=function(e){t.$.editableElement.getRootNode().execCommand("insertHTML",!1,`<img src="${e.target.result}"/>`)},void e.readAsDataURL(l)}i.indexOf(o)>-1&&i.indexOf(a)>-1&&(i=i.slice(i.indexOf(o),i.indexOf(a))),t._handlePasteAction(i,{advanced:!0,value:t.pasteFormat},n)}}const s=r.getRootNode().activeElement,l=t._changingValue;if(!t.$.contentContainer.hasAttribute("split-mode")){if(clearTimeout(t._refreshTimeout),delete t._refreshTimeout,a){const r=t.findAndReplaceTimeout,n=e.key;if(clearTimeout(t._findAndReplaceTimeout),!n||"enter"===n.toLowerCase())return;return void(r?t._findAndReplaceTimeout=setTimeout((()=>t._applySearching(e.target.value)),r):t._applySearching(e.target.value))}const r=t._resizeFrameObj?t._resizeFrameObj.target:void 0;return r&&!r.parentElement&&(t._setResizeFrame(),t._closeToolbar()),void i()}i(),clearTimeout(t._refreshTimeout);let d=t.$.input.value;t._refreshTimeout=setTimeout((()=>{clearTimeout(t._refreshTimeout),"markdown"===t.editMode?t.$.editableElement.innerHTML=window.marked?window.marked(d):d:s===o?t.$.editableElement.innerHTML=t._getInputValue(d,!0):t.$.input.value=t._getInputValue(t.$.editableElement.innerHTML.trim())}),t.splitModeRefreshTimeout)}_editableElementWheelHandler(){const e=this.$.inlineToolbar;this._setResizeFrame(),e&&e.visible&&e.close()}_editableElementKeyDownHandler(e){const t=this,r=t.$.editableElement,n=t.$.input,o=e.target.getRootNode().activeElement,a=e.key.toLowerCase(),i=t._isMacOS&&e.metaKey||e.ctrlKey;if(!t.disabled&&!t.readonly){switch(a){case"a":if(!i){t._changingValue=o===r?r.innerHTML:n.value;break}if(o.classList.contains("smart-editor-image-caption"))return e.preventDefault(),t._setSelectionRange(o),void t._handleInlineToolbar(t._getSelectionRange().startContainer);if(t._tableCell)return e.preventDefault(),t._setSelectionRange(t._tableCell),void t._handleInlineToolbar(t._getSelectionRange().startContainer);break;case"backspace":case"delete":{const a=t._resizeFrameObj?t._resizeFrameObj.target:void 0;a&&("img"===a.nodeName.toLowerCase()||a.classList.contains("smart-editor-video-container"))&&(e.preventDefault(),t._deleteResizeFrameTarget(a)),t._changingValue=o===r?r.innerHTML:n.value;break}case"enter":if(!t.disableSearchBar){const r=t._searchToolbar;r&&!r.classList.contains("smart-visibility-hidden")&&(e.preventDefault(),t._highlightSearchResult(!e.shiftKey))}break;case"escape":o===r?t._closeToolbar():o.classList.contains("smart-search-input")&&t._closeSearchToolbar();break;case"tab":t.enableTabKey&&(e.preventDefault(),t._handleTabInsert());break;default:t._handleToolbarShortcuts(e,o)}t._closeToolbar()}}_handleToolbarShortcuts(e,t){const r=this,n=r.$.editableElement,o=r.$.input,a=e.key,i=r._isMacOS&&e.metaKey||e.ctrlKey;if(!i)return void(r._changingValue=t===n?n.innerHTML:o.value);const s=r._resizeFrameObj;let l;switch(s&&s.target&&(l=s.target),a.toLocaleLowerCase()){case"b":e.preventDefault(),r._handleTextDecorations("bold");break;case"c":i&&l&&r._handleImageCopy(l);break;case"x":i&&l&&r._handleImageCut(l);break;case"k":e.preventDefault(),r._openWindow({name:"hyperlink"});break;case"i":e.shiftKey?(e.preventDefault(),r._openWindow({name:"image"},l)):(e.preventDefault(),r._handleTextDecorations("italic"));break;case"e":e.shiftKey?(e.preventDefault(),r._openWindow({name:"table"},l)):(e.preventDefault(),r._updateToolbarTarget({name:"alignment",value:"center"}));break;case"u":e.shiftKey?(e.preventDefault(),r._handleTextCase("uppercase")):(e.preventDefault(),r._handleTextDecorations("underline"));break;case"s":e.shiftKey&&(e.preventDefault(),r._handleTextDecorations("strikethrough"));break;case"l":e.shiftKey?(e.preventDefault(),r._handleTextCase("lowercase")):(e.preventDefault(),r._updateToolbarTarget({name:"alignment",value:"left"}));break;case"+":e.shiftKey&&(e.preventDefault(),r._handleSubSuperScript("superscript"));break;case"=":e.shiftKey?(e.preventDefault(),r._handleSubSuperScript("superscript")):(e.preventDefault(),r._handleSubSuperScript("subscript"));break;case"]":e.preventDefault(),r._handleIndentation("indent");break;case"[":e.preventDefault(),r._handleIndentation("outdent");break;case"h":if(e.shiftKey){const t=r._toolbarItemsObj.sourcecode;t&&(t.value=void 0===t.value||!t.value),e.preventDefault(),r._handleSourceCodeMode()}break;case"f":if(e.shiftKey){const t=r._toolbarItemsObj.fullscreen;t&&(t.value=void 0===t.value||!t.value),e.preventDefault(),r._handleFullScreenMode()}else!i||r.disableSearchBar||"html"!==r.editMode||n.classList.contains("smart-hidden")||(e.preventDefault(),r._openSearchBar());break;case"j":e.preventDefault(),r._updateToolbarTarget({name:"alignment",value:"justify"});break;case"r":e.shiftKey?(e.preventDefault(),r._handleClearFormat()):(e.preventDefault(),r._updateToolbarTarget({name:"alignment",value:"right"}));break;case"o":e.shiftKey?(e.preventDefault(),r._handleList("orderedlist")):e.altKey&&(e.preventDefault(),r._handleList("unorderedlist"))}}_editableElementMoveHandler(e){const t=this,r=t.$.editableElement,n=e.originalEvent||e,o=n.clientX,a=n.clientY,i=t.shadowRoot||t.isInShadowDOM?n.composedPath()[0]:n.target;if(e.stopPropagation(),!i||!i.closest||t._isMobile||"false"===r.getAttribute("contenteditable"))return void r.removeAttribute("table-cell-resize");const s=t._inlineToolbarClickObj;if(s&&s.resizeDetails||t._dragDetails)return;const l=i.tagName.toLowerCase();if(!i.closest(".smart-editor-editable table")||"td"!==l&&"th"!==l)return void r.removeAttribute("table-cell-resize");const d=i.getBoundingClientRect();a<d.bottom+5&&a>d.bottom-5?r.setAttribute("table-cell-resize","vertical"):o<d.right+5&&o>d.right-5&&i.nextElementSibling?r.setAttribute("table-cell-resize","horizontal"):r.removeAttribute("table-cell-resize")}_focusEditableElement(){const e=this,t=e.$.iframe,r=e.editMode;let n=e.$.editableElement;if(("markdown"===r||n.classList.contains("smart-hidden"))&&(n=e.$.input),t&&t.focus({preventScroll:!0}),n.getRootNode().activeElement!==n){const o=e._getSelectionRange(),a=n.scrollTop,i=t?t.contentWindow:window;if(n.focus({preventScroll:!0}),e._isSafari&&a&&(n.scrollTop=a),"markdown"===r||n.classList.contains("smart-hidden"))return void(void 0!==o.selectionStart&&e._setSelectionRange(o.selectionStart,o.selectionEnd));if(o instanceof i.Range){const e=(t?t.contentWindow:window).getSelection();e.removeAllRanges(),e.addRange(o)}}}_getTextFromCarret(){const e=this._getSelectionRange(),t=e.startContainer,r=t.textContent;let n,o;if(!e.toString()&&r.length>0&&r.indexOf(" ")>-1){const t=r.slice(0,e.startOffset).lastIndexOf(" ")+1;let a=r.slice(e.endOffset).indexOf(" ");a<0&&(a=r.length-1),n=t>-1?t:e.startOffset,o=Math.max(e.endOffset,e.endOffset+a)}else n=0,o=t.length;return{selectionStartIndex:n,selectionEndIndex:o}}_handleSearchButtonClick(e){const t=this;if(!e)return;const r=e.classList;r.contains("smart-search-button")&&(r.contains("prev")?t._highlightSearchResult():r.contains("next")?t._highlightSearchResult(!0):r.contains("close")&&t._closeSearchToolbar())}_highlightSearchResult(e){const t=this,r=t.$.contentContainer,n=t.$.editableElement.querySelectorAll(".find-and-replace-match"),o=r.querySelector(".smart-search-input-container"),a=n.length;for(let r=0,i=a;r<i;r+=1){const i=n[r];if(i.classList.contains("selected")){const s=e?Math.min(a-1,r+1):Math.max(0,r-1),l=n[s];return l&&(l.classList.add("selected"),o.setAttribute("selected",s+1),t._scrollToMarker(l)),void(l!==i&&i.classList.remove("selected"))}}}_handleToolbarItemClick(e,t){const r=this;if(!t)return;const n=r.$.inlineToolbar,o=r._toolbarItemClick,a=t.getAttribute("item-type"),i=t.getAttribute("item-name");let s,l;if(e&&(s=e.originalEvent||e,l=r.shadowRoot||r.isInShadowDOM?s.composedPath()[0]:s.target),"custom"!==a&&s&&(r.hasRippleAnimation&&"delimiter"!==a&&Smart.Utilities.Animation.Ripple.animate(l,s.pageX,s.pageY),o&&o.callback))return o.callback.call(r,t,o.target),void r.$.fireEvent("toobarItemClick",{value:i,originalEvent:s});r.$.fireEvent("actionStart",{name:i}).defaultPrevented||(r._handleToolbarItemAction(t),r._closeToolbarItemDropDown(r.$.inputPopup),r._closeToolbarItemDropDown(r.$.colorInputPopup),n&&n.close(),s&&r.$.fireEvent("toobarItemClick",{value:i,originalEvent:s}),i&&r.$.fireEvent("actionEnd",{name:i}))}_handleToolbarItemAction(e){const t=this,r=t._toolbarItemClick;if(!e)return;const n=e.getAttribute("item-type"),o=e.getAttribute("item-name");if("custom"!==n)switch(o){case"bold":case"italic":case"underline":case"strikethrough":t._handleTextDecorations(o);break;case"clearformat":t._handleClearFormat();break;case"redo":case"undo":t._handleUndoRedo(o);break;case"lowercase":case"uppercase":t._handleTextCase(o);break;case"backgroundcolor":t._handleBackgroundColor(e.getAttribute("item-value"));break;case"fontcolor":t._handleFontColor(e.getAttribute("item-value"));break;case"findandreplace":case"editlink":t._openWindow(e);break;case"openlink":{const r=t.$.inlineToolbar;if(r&&r.contains(e)){const e=r.selector;let t;e.nodeName!==Node.TEXT_NODE&&(t=e.closest(".smart-editor-editable a")),t&&window.open(t.href,t.target)}break}case"caption":{if(!r)break;const e=r.target;if(e&&"img"===e.nodeName.toLowerCase()){const r=e.closest(".smart-editor-image-container");let n;r&&r.querySelector(".smart-editor-image-caption")||(n=t.localize("captionPlaceholder")),t._handleImgCaption(e,{caption:n,focusCaption:!0})}else if(e.classList.contains("smart-editor-video-container")){const r=e.querySelectorAll(".smart-editor-video-container > video, .smart-editor-video-container > iframe");let n;e.querySelector(".smart-editor-image-caption")||(n=t.localize("captionPlaceholder")),t._handleVideoCaption(r[0]||r[1],{caption:n,focusCaption:!0})}break}case"cut":case"copy":case"paste":t._handleClipboardAction(o);break;case"delete":t._resizeFrameObj&&t._resizeFrameObj.target?t._deleteResizeFrameTarget(r.target):t._handleTextDelete();break;case"removelink":r&&t._handleLinkRemove(r.target);break;case"tableheader":case"tablerows":case"tablecolumns":case"tablevalign":case"tablestyle":t._handleTableToolbarAction(e);break;case"sourcecode":t._handleSourceCodeMode(e);break;case"splitmode":t._handleSplitMode(e);break;case"fullscreen":t._handleFullScreenMode(e);break;case"orderedlist":case"unorderedlist":t._handleList(o);break;case"indent":case"outdent":t._handleIndentation(o);break;case"subscript":case"superscript":t._handleSubSuperScript(o);break;case"print":t._handlePrint();break;default:t._inlineToolbarItemsObj?t._updateEditorViaWindow(t._inlineToolbarItemsObj[o]):t._toolbarItemsObj&&t._updateEditorViaWindow(t._toolbarItemsObj[o])}}_handleCommonToolbarAction(e,t){const r=this;if("html"===r.editMode){const n=r._getSelectionRange(),o=r.$.iframe,[a,i]=o?[o.contentDocument,o.contentWindow]:[document,window];let s,l=n.startContainer;if(!l)return;const d=e=>"string"==typeof e?("removeFormat"===e&&r.removeStylesOnClearFormat&&r._removeNodeStyles(n.commonAncestorContainer),a.execCommand(e)):"object"==typeof e?a.execCommand(e.name,!1,e.value):void 0;if(n.startOffset===n.endOffset&&l.nodeType===Node.TEXT_NODE){const{selectionStartIndex:e,selectionEndIndex:t}=r._getTextFromCarret();s=n.startOffset-e,r._setSelectionRange(l,e,t)}d(e)&&void 0!==s&&r._setSelectionRange(i.getSelection().focusNode,s,s),t&&r._updateToolbarItems(t)}}_handleClearFormat(){this._handleCommonToolbarAction("removeFormat")}_handleFontName(e){this._handleCommonToolbarAction(e)}_handleFontSize(e){const t=this;if("markdown"===t.editMode)return;const r=t._getSelectionRange();let n,o=r.startContainer;if(o){if(r.startOffset===r.endOffset){if(o.nodeType!==Node.TEXT_NODE){const n=document.createElement("font");return r.insertNode(n),t._setSelectionRange(n),void(n.style.fontSize=e.value+"px")}{const{selectionStartIndex:e,selectionEndIndex:a}=t._getTextFromCarret();n=r.startOffset-e,t._setSelectionRange(o,e,a)}}if((t.$.editableElement.getRootNode()||document).execCommand("fontSize",!1,3)){const o=t.$.iframe,a=o?o.contentWindow:window;if(r.commonAncestorContainer.closest){const t=r.commonAncestorContainer.querySelectorAll("font[size]");for(let r=0,n=t.length;r<n;r+=1){const n=t[r];n.removeAttribute("size"),n.style.fontSize=e.value+"px"}}else{const t=a.getSelection().focusNode;if(!t)return;const r=t.closest?t.closest(".smart-editor-editable font"):t.parentElement;"font"===r.nodeName.toLowerCase()&&(r.removeAttribute("size"),r.style.fontSize=e.value+"px")}void 0!==n&&t._setSelectionRange(a.getSelection().focusNode,n,n)}}}_handleFormats(e){const t=this;if("markdown"===t.editMode){let r;switch(e.value){case"h1":r="#";break;case"h2":r="##";break;case"h3":r="###";break;case"h4":r="####";break;case"h5":r="#####";break;case"h6":r="######";break;case"code":case"pre":r="```\n\n```";break;case"blockquote":r=">";break;case"p":r="";break;default:r=e.value}const n=e.dataSource,o=t.$.input.selectionStart;if(n){const e=n.map((e=>e.value));for(let r=0,n=e.length;r<n;r+=1){const n=t._getMarkdownFormat(o,e[r]);if(n&&void 0!==n.formatName){t._removeMarkDown(n.markdown,n.occuranceIndex,!0);break}}}return void(0===r.indexOf("#")||0===r.indexOf(">")?(r+=" ",t._insertMarkDown(r,t.$.input.selectionStart+r.length,!0)):t._insertMarkDown(r,t.$.input.selectionStart+r.length/2))}t._getSelectionRange().startContainer&&t.$.editableElement.getRootNode().execCommand("formatBlock",!1,e.value)}_handleSubSuperScript(e){const t=this;"markdown"!==t.editMode?t._handleCommonToolbarAction(e,["subscript","superscript"]):t._handleMarkdownItem(e)}_handleMarkdownItem(e){const t=this,r=t.$.input,n=t._getSelectionRange(),o=n.selectionStart,a=n.selectionEnd;let i,s,l,d=r.value;switch(e){case"bold":s="**",l="**";break;case"italic":s="*",l="*";break;case"underline":s="<ins>",l="</ins>";break;case"strikethrough":s="~~",l="~~";break;case"subscript":s="<sub>",l="</sub>";break;case"superscript":s="<sup>",l="</sup>"}if(void 0!==o&&o!==a){const e=s.length,n=l.length;if(i=d.slice(o,a),d.slice(o-e,o)===s&&d.slice(a,a+n)===l)return r.value=d.slice(0,o-e)+i+d.slice(a+n),t._refreshMarkdownPreview(),void t._setSelectionRange(r,o-e,a-e)}s&&l&&t._insertMarkDown(s+l,r.selectionStart+s.length)}_handleTextDecorations(e){const t=this;if("markdown"===t.editMode)return void t._handleMarkdownItem(e);const r=t._getSelectionRange();let n,o=r.startContainer;if(o){if(r.startOffset===r.endOffset&&o.nodeType===Node.TEXT_NODE){const{selectionStartIndex:e,selectionEndIndex:a}=t._getTextFromCarret();n=r.startOffset-e,t._setSelectionRange(o,e,a)}if((t.$.editableElement.getRootNode()||document).execCommand(e))if(void 0!==n){const e=t.$.iframe,r=e?e.contentWindow:window,o=r.getSelection().focusNode;o.textContent=o.textContent.trim(),t._setSelectionRange(r.getSelection().focusNode,n,n)}else t._setSelectionRange();t._updateToolbarItems([e])}}_handlePasteAction(e,t,r){if(!e)return;const n=this;if(t&&!t.name&&"prompt"===n.pasteFormat){const o={name:"paste",text:e,textType:r};return t&&(o.value=t.value,o.advanced=t.advanced),void n._openWindow(o)}n._handleTextPaste(e,t,r)}_handleTextPaste(e,t,r){const n=this,o=n.$.input;if(n.$.contentContainer.classList.contains("char-count-maxed"))return;if("markdown"===n.editMode)return n._insertMarkDown(e),void n._setCharCount();e=e.replace(/<!--StartFragment-->|<!--EndFragment-->/gi,"");let a,i,s=n.pasteFormat;if(t&&t.advanced&&(s=t.value),!r||"plainText"===s){const t=document.createElement("div");t.innerHTML=e,e=t.innerText}const l=e.toLocaleLowerCase();if(a=document.createElement("span"),a.innerHTML=e,l.indexOf("<video")>-1||l.indexOf("<iframe")>-1||l.indexOf("smart-editor-image-caption")>-1){const e=a.querySelectorAll("video, iframe"),t=a.querySelector(".smart-editor-image-caption"),r=e.length>0;let n=document.createDocumentFragment();for(let t=0,r=e.length;t<r;t+=1)n.appendChild(e[t]);if(t&&(t.removeAttribute("style"),n.appendChild(t)),r||t){const e=document.createElement("span");a.classList.add("smart-editor-image-container"),r&&a.classList.add("smart-editor-video-container"),a.setAttribute("contenteditable",!1),n.childElementCount&&(a.innerHTML="",a.appendChild(n)),e.appendChild(a),a=e}}if("cleanFormat"===s&&n._removeNodeStyles(a),r&&"text/plain"!==r||(a=document.createTextNode(a.innerHTML),i=Node.TEXT_NODE),o.getRootNode().activeElement===o){const e=o.value;return o.value=e.slice(0,o.selectionStart)+(i===Node.TEXT_NODE?a.textContent:a.innerHTML)+e.slice(o.selectionEnd),void n._setCharCount()}const d=n._getSelectionRange(),m=n.$.iframe,[c,u]=m?[m.contentWindow,m.contentDocument]:[window,document];if(!(d instanceof c.Range))return u.execCommand("paste"),void n._handleContentFiltering();if(d.deleteContents(),a.childNodes.length)for(;a.lastChild;)d.insertNode(a.lastChild);else d.insertNode(a);d.collapse(),n._handleContentFiltering()}_removeNodeStyles(e){if(e&&e.nodeType!==Node.TEXT_NODE){const t=e.querySelectorAll("style, [style]");for(let e=0,r=t.length;e<r;e+=1){const r=t[e];"style"===r.nodeName.toLowerCase()?r.remove():t[e].removeAttribute("style")}e.removeAttribute("style")}}_handlePaste(e){const t=this,r=navigator.clipboard,n=r.read?"read":"readText",o=()=>{r[n]&&r[n]().then((r=>{if(Array.isArray(r)&&r.length){const n=r[0],o=n.types.indexOf("text/html")>-1?"text/html":"text/plain";n.getType(o).then((r=>{r.text().then((r=>t._handlePasteAction(r,e,o)))}))}else"string"==typeof r&&t._handlePasteAction(r,e)}))};if(navigator.permissions&&navigator.permissions.query&&!t._isFireFox)try{navigator.permissions.query({name:"clipboard-read"}).then((e=>{("granted"===e.state||"prompt"===e.state&&r[n])&&o()}))}catch(e){t.error(t.localize("permissionsRequired",{elementType:t.nodeName.toLowerCase(),actionName:"paste"}))}else if(r[n])return void o();t.$.editableElement.getRootNode().execCommand("paste")}_handlePasteViaWindow(e){const t=this,r=t._getItemOptionsViaWindow(e);if(!e||"paste"!==e.name)return;let n=t.pasteFormat;for(let e in r)if(r[e]){n=e;break}e.value=n,t._handleTextPaste(e.text,e,e.textType)}_handleClipboardAction(e){const t=this,r=t.editMode,n=t.$.input;if("paste"===e)return void t._handlePaste();const o=t._getSelectionRange();if(("copy"===e||"cut"===e)&&(document.execCommand("copy"),"cut"===e))if("markdown"===r){const e=n.value,r=n.selectionStart;n.value=e.slice(0,r)+e.slice(n.selectionEnd),t._setSelectionRange(n,r,r),t._refreshMarkdownPreview()}else o.deleteContents()}_handleLinkRemove(e){const t=this;let r;if(e&&"img"===e.nodeName.toLowerCase())r=e.closest(".smart-editor-editable a"),r&&(r.parentElement.insertBefore(e,r),r.remove());else{const e=t.$.iframe;let r,n;e?(r=e.contentDocument,n=e.contentWindow):(r=document,n=window);const o=n.getSelection(),a=t._getSelectionRange();o.removeAllRanges(),o.addRange(a);const i=o.anchorNode?o.anchorNode.parentElement:void 0;if(!i||"a"!==i.nodeName.toLowerCase())return;a.selectNode(o.anchorNode),r.execCommand("unlink",!1,!1)}}_handleBackgroundColor(e){const t=this;if("markdown"===t.editMode)return;const r=t.$.iframe,n="string"==typeof e?e:e.value,[o,a]=r?[r.contentDocument,r.contentWindow]:[document,window],i=t.$.inlineToolbar,s=t._getSelectionRange(),l=i&&i.visible?i.selector:s.commonAncestorContainer;let d;if(l&&["th","td"].indexOf(l.nodeName.toLowerCase())>-1){if(s.startOffset===s.endOffset)return void(l.style.backgroundColor=n);d=l.style.backgroundColor}const m=s.startOffset,c=s.endOffset,u=s.startContainer;let p;if(u&&u.nodeType===Node.TEXT_NODE&&s.startOffset===s.endOffset){const{selectionStartIndex:e,selectionEndIndex:r}=t._getTextFromCarret();p=s.startOffset-e,t._setSelectionRange(u,e,r)}else u.closest&&m!==c&&t._setSelectionRange(u,m,c);const h=o.execCommand("hiliteColor",!1,n&&"transparent"!==n?n:"transparent");l&&d?l.style.backgroundColor=d:h&&void 0!==p&&t._setSelectionRange(a.getSelection().focusNode,p,p)}_handleFontColor(e){const t=this;if("markdown"===t.editMode)return;const r=t._getSelectionRange(),n="string"==typeof e?e:e.value,o=r.startContainer,a=t.$.iframe,i=n?"foreColor":"removeFormat",[s,l]=a?[a.contentDocument,a.contentWindow]:[document,window];let d;if(o&&o.nodeType===Node.TEXT_NODE&&r.startOffset===r.endOffset){const e=o.parentElement;if("font"===e.nodeName.toLocaleLowerCase())return void(e.color=n);const{selectionStartIndex:a,selectionEndIndex:i}=t._getTextFromCarret();d=r.startOffset-a,t._setSelectionRange(o,a,i)}s.execCommand(i,!1,n)&&void 0!==d&&t._setSelectionRange(l.getSelection().focusNode,d,d)}_handlePrint(){const e=this,t=e.dataExport.fileName;e.dataExport.fileName=null;const r=window.open("","","width=800,height=500"),n=r.document.open(),o='<!DOCTYPE html><html><head><meta charset="utf-8" /><title>'+t+"</title></head><body>"+e._handleDataExport("html")+"</body></html>";try{n.write(o),n.close(),setTimeout((function(){r.print(),r.close()}),100)}catch(e){}e.dataExport.fileName=t}_handleDataExport(e,t){const r=this;if(!Smart.Utilities.DataExporter)return void r.error(r.localize("missingReference",{elementType:r.nodeName.toLowerCase(),methodName:"exportData",files:"smart.export.js"}));try{new JSZip}catch(e){return void r.error(r.localize("missingReference",{elementType:r.nodeName.toLowerCase(),methodName:"exportData",files:"jszip.min.js"}))}if("pdf"===e&&!window.pdfMake)return void r.error(r.localize("missingReference",{elementType:r.nodeName.toLowerCase(),methodName:"exportData",files:"pdfMake.min.js"}));if("pdf"===e)return void r._exportToPDF(r.dataExport.fileName,e);let n;if("markdown"===r.editMode){const t=r.$.input;n="md"!==e&&window.marked?window.marked(t.value):t.value}else n=r.$.editableElement["pdf"===e?"textContent":"innerHTML"];const o=new Smart.Utilities.DataExporter({exportHeader:!1,pageOrientation:r.dataExport.pageOrientation,style:r.dataExport.style}),a=[{value:n}];return r._setExportStyles(o,e),o.exportData(a,e,r.dataExport.fileName,t)}_exportToPDF(e,t){const r=this,n=r.$.editableElement,o=window.getComputedStyle(r),a=r.dataExport.style,i={pageOrientation:r.pageOrientation||"portrait",info:{title:"smartEditor",creator:"Smart",producer:"Smart"}};if(a&&(i.styles=a),i.defaultStyle={fontSize:parseFloat(o.fontSize)},"markdown"===r.editMode){const e=r.$.input,o=document.createElement("div");let a;"md"!==t?n.classList.contains("smart-hidden")?(o.innerHTML=window.marked?window.marked(e.value):e.value,a=r._processHTMLAsPDFObject(o,[])):a=r._processHTMLAsPDFObject(n,[]):(o.innerHTML=e.value,a=r._processHTMLAsPDFObject(o,[])),i.content=a}else i.content=r._processHTMLAsPDFObject(r.$.editableElement,[]);try{pdfMake.createPdf(i).download(e)}catch(e){console.error(r.localize("exportError",{elementType:r.nodeName.toLowerCase(),status:e.toString()}))}}_processHTMLAsPDFObject(e,t,r){const n=this,o={},a=["left","center","right"],i=e.childNodes,s=["td","th"].indexOf(e.nodeName.toLowerCase())>-1;for(let r=0,l=i.length;r<l;r+=1){const l=i[r],d=l.nodeName.toLowerCase(),m=l.nodeType===Node.TEXT_NODE;let c;if("table"===d){const e=l.querySelectorAll("thead tr"),t=l.querySelectorAll("thead tr:last-of-type td, thead tr:last-of-type th"),r=l.querySelectorAll("tbody tr:last-of-type td, tbody tr:last-of-type th"),o=t.length?t:r,a=l.querySelectorAll("body tr");let i=e.length;if(!i)for(let e=0,t=a.length;e<t&&Array.from(a[e].children).every((e=>"th"===e.nodeName.toLowerCase()));e+=1)i++;c={table:{headerRows:i,widths:(()=>{const e=Math.round(100/o.length)+"%";let t=[];for(let r=0,n=o.length;r<n;r+=1)t.push(e);return t})(),body:(()=>{let e=[];for(let t=0,r=a.length;t<r;t+=1){const r=a[t],i=r.children;let s=[];for(let e=0,t=r.childElementCount;e<t;e+=1){const t=n._processHTMLAsPDFObject(i[e],[],!0);if(r.childElementCount<o.length){let e;for(e=Array.isArray(t)&&1===t.length?t[0]:{text:t},e.colSpan=Math.round(o.length/r.childElementCount),s.push(e);s.length<o.length;)s.push({text:""})}else s.push(1===t.length?t[0]:t)}e.push(s)}return e})()}}}else if("ul"===d)c={ul:n._processHTMLAsPDFObject(l,[])};else if("ol"===d)c={ol:n._processHTMLAsPDFObject(l,[])};else if("img"===d){const e=document.createElement("canvas"),t=e.getContext("2d");let r;e.width=l.naturalWidth||l.width,e.height=l.naturalHeight||l.height,t.drawImage(l,0,0);try{r=e.toDataURL("image/png")}catch(e){console.error(n.localize("exportError",{elementType:n.nodeName.toLowerCase(),status:e.toString()}));continue}if(r.indexOf("image/png")<0){console.error(n.localize("exportError",{elementType:n.nodeName.toLowerCase(),status:"Invalid image"}));continue}c={image:r,width:l.width,height:l.height}}else if("a"===d){if(c={},l.childElementCount){l.querySelector("img")&&(c=n._processHTMLAsPDFObject(l,[],!0)[0]||{})}else c.text=l.textContent;c.link=l.href}else l.childElementCount?t=t.concat(n._processHTMLAsPDFObject(l,[],!0)):c={text:l.textContent.trim()?l.textContent:"\n"};if(c){const r=window.getComputedStyle(m?e:l);if(!m||s){const e=r.backgroundColor,t=parseFloat(r.fontSize);isNaN(t)||(c.fontSize=t),c.alignment=o.alignment=a.indexOf(r.textAlign)>-1?r.textAlign:a[0],"rgba(0, 0, 0, 0)"!==e&&"transparent"!==e&&(c.fillColor=o.fillColor=n._RGBAtoHex(e)),parseInt(r.fontWeight)>500&&(c.bold=!0),"italic"===r.fontStyle&&(c.italics=!0)}c.inlineElement=m||r.display.indexOf("inline")>-1,c.color=o.color=n._RGBAtoHex(r.color),t.push(c)}}return 1===t.length?t:r||s?(o[t.every((e=>e.inlineElement&&!e.image))?"text":"stack"]=t,[o]):t}_RGBAtoHex(e){const t=/rgb[a]?\(\s*(\d+),\s*(\d+),\s*(\d+),?\s*(\d*.\d+|\d+)?\)/gi.exec(e.replace(/\s/g,""));if(null===t)return e;const r=parseFloat(t[1]).toString(16).toUpperCase(),n=parseFloat(t[2]).toString(16).toUpperCase(),o=parseFloat(t[3]).toString(16).toUpperCase();return"#"+"0".repeat(2-r.length)+r+"0".repeat(2-n.length)+n+"0".repeat(2-o.length)+o}_setExportStyles(e,t){const r=this;if(e.style)return;const n=window.getComputedStyle(r),o=n.getPropertyValue("--smart-border-width")||"1px",a=n.getPropertyValue("--smart-border")||"black",i=n.getPropertyValue("--smart-editor-table-column-width")||"initial",s=n.getPropertyValue("--smart-editor-table-cell-min-height")||"20px",l=n.getPropertyValue("--smart-editor-table-cell-min-width")||s,d=n.getPropertyValue("--smart-surface")||"#333",m=n.getPropertyValue("--smart-alternation-index0-background")||d;e.style={border:"initial",width:"100%",height:r.$.editableElement.scrollHeight+"px",removeDefault:!0,custom:`\n            ${"html"===t&&r.rightToLeft?"body { direction: rtl; }":""}\n\n          .column table {\n            width: 100%;\n            border-collapse: collapse;\n            empty-cells: show;\n            border-spacing: 0;\n            table-layout: fixed;\n          }\n          \n          .column td, .column th {\n            border: ${o} solid ${a};\n            width: ${i};\n            min-height: ${s};\n            min-width: ${l};\n            padding: 2px 5px;\n            vertical-align: middle;\n          }\n          \n          .column table img {\n            max-width: 100%;\n          }\n          \n          .column table table {\n            width: 100%;\n          }\n          \n          .column table th {\n            background: ${d};\n          }\n\n          .column th:empty::before,\n          .column td:empty::before {\n            content: 'A';\n            visibility: hidden;\n          }\n          \n          .column table[dashed-borders] th, .column table[dashed-borders] td {\n            border-style: dashed;\n          }\n          \n          .column table[alternation] tr:nth-child(2n) {\n            background-color: ${m};\n          }\n          \n          .column .smart-editor-image-container {\n            display: inline-block;\n          }\n          \n          .column .smart-editor-image-container[display="block"] {\n            display: block;\n          }\n          \n          .column .smart-editor-image-container[display="block"][alignment="left"] img {\n            margin-left: 0;\n          }\n          \n          .column .smart-editor-image-container[display="block"][alignment="left"] .smart-editor-image-caption {\n            text-align: left;\n          }\n          \n          .column .smart-editor-image-container[display="block"][alignment="right"] img {\n            margin-right: 0;\n          }\n          \n          .column .smart-editor-image-container[display="block"][alignment="right"] .smart-editor-image-caption {\n            text-align: right;\n          }\n          \n          .column .smart-editor-image-container:not([display="block"])[alignment="left"] {\n            float: left;\n          }\n          \n          .column .smart-editor-image-container:not([display="block"])[alignment="right"] {\n            float: right;\n          }\n          \n          .column .smart-editor-image-container .smart-editor-image-caption {\n            display: block;\n            text-align: center;\n            outline: none;\n          }`}}_handleSourceCodeMode(e){const t=this,r=t.editMode,n=t._toolbarItemsObj.sourcecode;let o;if(t.$.contentContainer.hasAttribute("split-mode"))return;e?o=e.hasAttribute("checked"):(o=n?n.value:!t.classList.contains("preview-mode"),e=t.$.toolbar.querySelector('.smart-editor-toolbar-item[item-name="sourcecode"]')),t._closePopups(),t._closeWindow(),t._closeSearchToolbar(),t._setResizeFrame(),t._handleTableSelection();const a=t.$.editableElement,i=t.$.input;"markdown"===r?o&&a.classList.contains("smart-hidden")?(a.innerHTML=window.marked?window.marked(i.value):i.value,a.classList.remove("smart-hidden"),i.classList.add("smart-hidden"),a.focus({preventScroll:!0})):!o&&i.classList.contains("smart-hidden")&&(a.classList.add("smart-hidden"),i.classList.remove("smart-hidden"),i.focus({preventScroll:!0})):o&&i.classList.contains("smart-hidden")?(i.value=t._getInputValue(a.innerHTML),a.classList.add("smart-hidden"),i.classList.remove("smart-hidden"),i.focus({preventScroll:!0})):!o&&a.classList.contains("smart-hidden")&&(a.innerHTML=t._getInputValue(i.value,!0),i.classList.add("smart-hidden"),a.classList.remove("smart-hidden"),a.focus({preventScroll:!0}),t._handleContentFiltering()),o?t.classList.add("preview-mode"):t.classList.remove("preview-mode"),n&&(n.value=o),e&&n&&(o?(e.setAttribute("checked",""),e.setAttribute("aria-pressed",!0)):(e.removeAttribute("checked"),e.setAttribute("aria-pressed",!1)),t._setTextSelection(),t._setToolbarItemAttr("sourcecode","disabled",n.disabled))}_setTextSelection(){const e=this,t=e.$.input,r=e.$.editableElement,n=e._selectionRange;if(!n)return;const o=n.commonAncestorContainer;if(o){if(t.classList.contains("smart-hidden"))return;const a=e._getParentCharDetails(n.startContainer,o),i=e._getParentCharDetails(n.endContainer,o),s=e._getSiblingsCharOffset(a.parentElement,i.parentElement),{charOffset:l}=e._getParentCharDetails(o,r),d=n.startOffset+a.charOffset+l,m=n.endOffset+i.charOffset+s+l;e._setSelectionRange(t,d,m)}else if(!r.classList.contains("smart-hidden")){const o=n.selectionStart,a=n.selectionEnd,i=t.value;if(void 0===o||void 0===a||o===a&&(i.length===o||0===o))return;if(0===o&&a===r.innerHTML.length)return void e._setSelectionRange(r);const s=e._getNodeByChartOffset(r.firstChild,o,a);if(!s)return;const{node:l,charOffset:d}=s;e._setSelectionRange(l,o-d,a-d)}}_getNodeByChartOffset(e,t,r){const n=this;let o=0;for(;e;){const a=e.outerHTML||e.textContent,i=a.length;if(o<=t&&o+i>=r){e.tagName&&(o+=e.outerHTML.slice(0,a.indexOf(e.innerHTML)).length);const i=n._getNodeByChartOffset(e.firstChild,t-o,r-o);return i?{node:i.node,charOffset:i.charOffset+o}:{node:e,charOffset:o}}e=e.nextSibling,o+=i}}_getParentCharDetails(e,t){let r=0;if(e===t)return{charOffset:r,parentElement:e.parentElement};let n=e,o=e.innerHTML||e.textContent,a=e.parentElement;for(;a&&a!==t&&t.contains(a);){const e=a.outerHTML;r+=e.indexOf(o),o=e,n=a,a=a.parentElement}return r+=(t.innerHTML||t.textContent).indexOf(o),{charOffset:r,parentElement:n}}_getPreSiblingOffset(e,t){let r=0,n=e.textContent,o=e.previousSibling;for(;o&&t.contains(o);){const e=o.outerHTML||o.textContent;n=e+n,r+=e.length,o=o.previousSibling}return r}_getSiblingsCharOffset(e,t){let r=0,n=e.nextSibling;if(e===t)return r;for(;n&&n!==t;)r+=(n.outerHTML||n.textContent).length,n=n.nextSibling;return r}_handleFullScreenMode(e){const t=this,r=t._toolbarItemsObj.fullscreen;let n;e?n=e.hasAttribute("checked"):(n=r?r.value:!t.classList.contains("full-screen-mode"),e=t.$.toolbar.querySelector('.smart-editor-toolbar-item[item-name="fullscreen"]')),t._closePopups(),t._setResizeFrame(),t._handleTableSelection(),n?(t.classList.add("full-screen-mode"),t._lastToolbarExpandedState=t.$.toolbar.hasAttribute("expanded")):(t.classList.remove("full-screen-mode"),t._lastToolbarExpandedState&&t._toggleToolbar()),r&&(r.value=n),e&&r&&(n?(e.setAttribute("cheched",""),e.setAttribute("aria-pressed",!0)):(e.removeAttribute("checked"),e.setAttribute("aria-pressed",!1)),r.disabled?(e.setAttribute("disabled",""),e.setAttribute("aria-disabled",!0)):(e.removeAttribute("disabled"),e.removeAttribute("aria-disabled")))}_handleSplitMode(e){const t=this,r=t.$.editableElement,n=t.$.input,o=t.$.contentContainer,a=t._toolbarItemsObj,i=a.splitmode,s=a.sourcecode,l=e?e.hasAttribute("checked"):!o.hasAttribute("split-mode"),d=t.editMode;t._closePopups(),l?("markdown"===d?r.innerHTML=window.marked?window.marked(n.value):n.value:n.value=r.innerHTML.trim(),o.setAttribute("split-mode",""),n.classList.remove("smart-hidden"),r.classList.remove("smart-hidden"),s&&t._setToolbarItemAttr("sourcecode","disabled",!0)):(o.removeAttribute("split-mode",""),"markdown"===d?r.classList.add("smart-hidden"):n.classList.add("smart-hidden"),s&&t._setToolbarItemAttr("sourcecode","disabled",!1)),i&&(i.value=l),e||(e=t.$.toolbar.querySelector('.smart-editor-toolbar-item[item-name="splitmode"]')),e&&(l?(e.setAttribute("checked",""),e.setAttribute("aria-pressed",!0)):(e.removeAttribute("checked"),e.setAttribute("aria-pressed",!1))),t._resizeFrameObj&&t._setResizeFrame(t._resizeFrameObj.target),t.classList.contains("preview-mode")&&t._handleSourceCodeMode()}_handleUndoRedo(e){this.$.editableElement.getRootNode().execCommand(e)}_handleTextCase(e){const t=this;if("markdown"===t.editMode)return;const r=t._getSelectionRange(),n=r.startContainer;if(!n)return;const o=n.textContent;let a,i,s,l,d=r.startOffset;n.nodeType===Node.TEXT_NODE&&r.startOffset===r.endOffset?(({selectionStartIndex:s,selectionEndIndex:l}=t._getTextFromCarret()),i=o.slice(s,l)):([s,l]=[d,r.endOffset],i=o.slice(d,r.endOffset),a=r.endOffset),i="lowercase"===e?i.toLowerCase():i.toUpperCase(),n.textContent=o.slice(0,s)+i+o.slice(l),t._setSelectionRange(n,d,a||d)}_handleList(e){const t=this;if(!e)return;if("markdown"===t.editMode){const r="orderedlist"===e?"1. ":"- ",n=t.$.input.selectionStart,o=t._getMarkdownFormat(n,"orderedlist"),a=t._getMarkdownFormat(n,"unorderedlist");if(o&&(t._removeMarkDown(r,o.occuranceIndex,"orderedlist"!==e),"orderedlist"===e))return;if(a&&(t._removeMarkDown(r,a.occuranceIndex,"unorderedlist"!==e),"unorderedlist"===e))return;return void t._insertMarkDown(r,t.$.input.selectionStart+r.length,!0)}let r,n,o=t._getSelectionRange();if(o.startContainer===o.endContainer&&(r=o.startOffset,n=o.endOffset),t.$.editableElement.getRootNode().execCommand("insert"+e,!1)){const e=t.$.iframe;o=(e?e.contentWindow:window).getSelection(),void 0!==n&&void 0!==n&&t._setSelectionRange(o.focusNode,r,n),t._updateToolbarItems(["orderedlist","unorderedlist"])}}_handleIndentation(e){"markdown"!==this.editMode&&this.$.editableElement.getRootNode().execCommand(e,!1)}_handleTextDelete(){this.$.editableElement.getRootNode().execCommand("delete")}_handleTabInsert(){this.$.editableElement.getRootNode().execCommand("insertHTML",!1,"&#009")}_handleTableToolbarAction(e,t){const r=this,n=r._toolbarItemClick;if(!t&&n&&(t=n.target),!t||"table"!==t.nodeName.toLowerCase()||!e)return;const o=e.getAttribute?e.getAttribute("item-name"):e.name,a=r.$.inlineToolbar;let i=e;if(i.closest){const e=r.$.inlineToolbar;i=(e&&e.contains(i)?r._inlineToolbarItemsObj:r._toolbarItemsObj)[o]}if(!n&&r.$.fireEvent("actionStart",{name:o}).defaultPrevented)return;switch(o){case"backgroundcolor":r._handleBackgroundColor(i);break;case"fontcolor":r._handleFontColor(i);break;case"fontsize":r._handleFontSize(i);break;case"tableheader":r._handleTableHeader(t);break;case"tablerows":r._handleTableRows(t,i);break;case"tablecolumns":r._handleTableColumns(t,i);break;case"tablevalign":r._handleTableVAlignment(t,i);break;case"alignment":r._handleTextAlignment(i);break;case"tablestyle":r._handleTableStyle(t,i);break;default:r._handleToolbarItemAction(e)}!n&&o&&r.$.fireEvent("actionEnd",{name:o}),a&&a.visible&&(r.$.editableElement.contains(a.selector)?a.reposition():r._closeToolbar());const s=r._getSelectionRange().startContainer;let l;if(s.nodeType===Node.TEXT_NODE){const e=s.parentElement;l=e.closest("th")||e.closest("td")}else l=["th","td"].indexOf(s.nodeName.toLowerCase())>-1;r._setResizeFrame(l&&t.contains(s)?t:void 0)}_handleTableHeader(e,t){let r,n,o=e.querySelector("th"),a=e.querySelector("tbody tr"),i=e.querySelector("thead");if(a&&(n=Array.from(a.children)),t||!i&&!o){if(void 0===t||!0===t){let t=e.querySelectorAll("tbody tr:first-of-type td").length;i||(i=document.createElement("thead")),r=i.querySelector("tr"),r||(r=document.createElement("tr"));const o=Array.from(r.children);for(;o.length>t;)o.pop().remove();for(let e=o.length;e<t;e+=1){const t=document.createElement("th");n[e]&&(t.style.width=n[e].style.width,n[e].style.width=""),r.appendChild(t)}i.appendChild(r),e.insertBefore(i,e.querySelector("tbody")||e.querySelector("tr"))}}else i&&i.remove(),o&&(r=o.closest("tr"),r&&r.remove(),Array.from(r.children).forEach(((e,t)=>n[t].style.width=e.style.width)))}_handleTableRows(e,t){if(!e)return;const r=this,n=r.$.inlineToolbar.selector,o=n.nodeName.toLocaleLowerCase();let a;if(!(n&&["th","td"].indexOf(o)>-1))return;if(a=n.closest("tr"),!a)return;const i=t.value,s=a.closest("thead");switch(i){case"insertRowAfter":case"insertRowBefore":{const t=document.createElement("tr"),r=a.parentElement;if(!r)break;const n=e.querySelector("tr").childElementCount,s="th"===o?"th":"td";for(let e=0;e<n;e+=1)t.appendChild(document.createElement(s));r.insertBefore(t,i.indexOf("Before")>-1?a:a.nextElementSibling);break}case"deleteRow":r._closeToolbar(),a.remove(),s&&!s.children.length&&s.remove()}const l=e.querySelectorAll("tr").length;l?(e.setAttribute("aria-rowcount",l),r._resizeFrameObj&&r._setResizeFrame(r._resizeFrameObj.target)):e.remove()}_handleTableColumns(e,t){if(!e)return;const r=this,n=r.$.inlineToolbar.selector;if(!(n&&["th","td"].indexOf(n.nodeName.toLowerCase())>-1))return;const o=t.value,a=Array.from(e.querySelectorAll("tr"));if(!a.length)return r._closeToolbar(),void e.remove();const i=Array.from(n.parentElement.children).indexOf(n);switch(o){case"insertColumnLeft":case"insertColumnRight":{const e=o.indexOf("Left")>-1;for(let t=0,r=a.length;t<r;t+=1){const r=a[t],n=r.children[i];if(n){const t="th"===n.tagName.toLowerCase()?"th":"td";r.insertBefore(document.createElement(t),e?n:n.nextElementSibling)}}break}case"deleteColumn":r._closeToolbar();for(let e=0,t=a.length;e<t;e+=1){const t=a[e].children[i];t&&t.remove()}}const s=a[0].children.length;s?(e.setAttribute("aria-colcount",s),r._resizeFrameObj&&r._setResizeFrame(r._resizeFrameObj.target)):e.remove()}_handleTextAlignment(e){if("markdown"===this.editMode)return;const t="justify"===e.value?"full":e.value;this.$.editableElement.getRootNode().execCommand("justify"+t.charAt(0).toUpperCase()+t.slice(1),!1,null)}_handleTableVAlignment(e,t){const r=this.$.inlineToolbar;if(!r)return;const n=r.selector;n&&["th","td"].indexOf(n.nodeName.toLowerCase())>-1&&(n.style.verticalAlign=t.value)}_handleTableStyle(e,t){const r=this.$.inlineToolbar.selector;if(r&&["th","td"].indexOf(r.nodeName.toLowerCase())>-1)switch(t.value){case"altrows":e.toggleAttribute("alternation");break;case"dashedborders":e.toggleAttribute("dashed-borders")}}_handleInlineToolbar(e){const t=this,r=e.nodeName.toLowerCase();"a"===r?(t._openInlineToolbar(e),t._refreshToolbarTabs()):"img"===r||["td","th"].indexOf(r)>-1?(t._setResizeFrame(e),t._openInlineToolbar(e),t._refreshToolbarTabs()):e.nodeType===Node.TEXT_NODE&&e.textContent.trim().length&&t._openInlineToolbar(e)}_handleTableCellResize(e){const t=this,r=t._inlineToolbarClickObj,n=r?r.resizeDetails:void 0;if(!n)return;const o=n.target,a=n.position,i=t.$.inlineToolbar;switch(n.started||t.$.fireEvent("resizeStart",{target:o}),o.setAttribute("resizing",""),n.started=!0,i&&i.visible&&(n.isInlineToolbarOpened=!0,t._closeToolbar()),a){case"horizontal":{const r=e.pageX+window.pageXOffset;if(t._setTableResizeDetails(n),!n.shrinkingCell)break;t._handleHorizontalTableCellResize(n,r);break}case"vertical":{const r=n.table;r.style.height&&(r.querySelectorAll("tr").forEach((e=>e.style.height=e.offsetHeight+"px")),r.style.height=""),t._resizeFrameObj&&t._resizeFrameObj.target&&t._setResizeFrame();const a=e.pageY+window.pageYOffset,i=n.y-a;let s=o.offsetHeight;s-=i,o.style.height=Math.max(1,s)+"px",s===o.offsetHeight&&(n.y=a+Math.abs(Math.min(0,s)));break}}}_setTableResizeDetails(e){const t=e.table,r=e.target;let n,o=e.expandingCell,a=e.shrinkingCell,i=e.isLastCell,s=e.areAllCellsResized;if(!o){const a=t.querySelector("tr"),i=Array.from(r.parentElement.children).indexOf(r);n=e.cells=Array.from(a.children),o=e.expandingCell=n[i]}e.shrinkingCell||(a=e.shrinkingCell=o.nextElementSibling,s=e.areAllCellsResized=!n.some((e=>e!==o&&e!==a&&!e.style.width)),i=e.isLastCell=s&&null===a.nextElementSibling,s&&!e.lastCell&&(e.lastCell=n[n.length-1]),i&&(a.style.width=""))}_handleHorizontalTableCellResize(e,t){const r=30,n=e.isLastCell;let o=e.expandingCell,a=e.shrinkingCell,i=o.offsetWidth,s=a.offsetWidth,l=e.x-t;const d=e.x-i+r,m=e.x+a.offsetWidth-r;if(n){const n=i+s-r;o.style.width=Math.min(Math.max(r,i-l),n)+"px",o.offsetWidth!==i&&(e.x=Math.min(m,Math.max(d,t)))}else{let n;l>0&&([o,a]=[a,o],[i,s]=[s,i],l*=-1),a.style.width=Math.max(r,s+l)+"px",n=a.offsetWidth-s,o.style.width=Math.max(r,o.offsetWidth-n)+"px",0!==n&&(e.x=Math.min(m,Math.max(d,t))),e.lastCell&&(e.lastCell.style.width="")}}_handleFrameResize(e){const t=this,r=t._resizeFrameObj;if(!r)return;t._closeToolbar();const n=r.resizableElement||r.target,o=r.resizeDetails,a=o.position,i=e.pageX+window.pageXOffset,s=e.pageY+window.pageYOffset,l=o.x-i,d=o.y-s;let m,c;m=n.offsetWidth,c=n.offsetHeight,o.started||(r.target.setAttribute("dragged",""),t.$.fireEvent("resizeStart",{target:n})),o.started=!0;const u=m,p=c,h=t.rightToLeft?-1:1;switch(a){case"top-left":n.style.width=Math.max(0,u+h*l)+"px",n.style.height=Math.max(0,p+d)+"px",m=n.offsetWidth,c=n.offsetHeight,u!==m&&(o.x-=h*(m-u)),p!==c&&(o.y-=c-p);break;case"bottom-left":n.style.width=Math.max(0,u+h*l)+"px",n.style.height=Math.max(0,p-d)+"px",m=n.offsetWidth,c=n.offsetHeight,u!==m&&(o.x-=h*(m-u)),p!==c&&(o.y+=c-p);break;case"bottom-right":n.style.width=Math.max(0,u-h*l)+"px",n.style.height=Math.max(0,p-d)+"px",m=n.offsetWidth,c=n.offsetHeight,u!==m&&(o.x+=h*(m-u)),p!==c&&(o.y+=c-p);break;case"top-right":n.style.width=Math.max(0,u+h*-l)+"px",n.style.height=Math.max(0,p+d)+"px",m=n.offsetWidth,c=n.offsetHeight,p!==c&&(o.y-=c-p),u!==m&&(o.x+=h*(m-u));break;case"top-center":n.style.height=Math.max(0,p+d)+"px",c=n.offsetHeight,p!==c&&(o.y-=c-p);break;case"bottom-center":n.style.height=Math.max(0,p-d)+"px",c=n.offsetHeight,p!==c&&(o.y+=c-p);break;case"left-center":n.style.width=Math.max(0,u+h*l)+"px",m=n.offsetWidth,u!==m&&(o.x-=h*(m-u));break;case"right-center":n.style.width=Math.max(0,u-h*l)+"px",m=n.offsetWidth,u!==m&&(o.x+=h*(m-u))}t._positionResizeHandles()}_deleteResizeFrameTarget(e){const t=this,r=t._getSelectionRange();if(e)if("img"===e.nodeName.toLowerCase()){const n=e.closest(".smart-editor-editable .smart-editor-image-container"),o=(n||e).parentElement,a=o&&"a"===o.nodeName.toLowerCase()?o:void 0;if(t._setResizeFrame(),(a||n||e).remove(),URL.revokeObjectURL(e.src),t.removeUrl){let i=new FormData,s=new XMLHttpRequest;const l=(e,t)=>{let r=e.split(","),n=r[0].match(/:(.*?);/)[1],o=atob(r[1]),a=o.length,i=new Uint8Array(a);for(;a--;)i[a]=o.charCodeAt(a);return new File([i],t,{type:n})};function d(e,t,r){var n=new Image;n.crossOrigin="Anonymous",n.onload=function(){var e=document.createElement("canvas"),n=e.getContext("2d");e.height=this.naturalHeight,e.width=this.naturalWidth,n.drawImage(this,0,0);var o=e.toDataURL("image/jpeg");r(l(o,t))},n.src=e}d(e.src,e.name,(e=>{i.append(t.imageName,e),s.open("POST",t.removeUrl),s.send(i)}))}t.onImageRemove&&t.onImageRemove(e.src)}else if(e.classList.contains("smart-editor-video-container")){const m=e.querySelector(".smart-editor-video-container video, .smart-editor-video-container > iframe");t._setResizeFrame(),e.remove(),m&&URL.revokeObjectURL(m.src)}else if("table"===e.nodeName.toLowerCase()){const c=e.closest(".smart-editor-editable table");c&&(t._setResizeFrame(),c.remove())}t._setCharCount(),t._setSelectionRange(r.startContainer,r.startOffset,r.endOffset),t._focusEditableElement()}_setResizeFrame(e,t){const r=this,n=r.$.editableElement;let o,a=e?e.nodeName.toLowerCase():"",i=r._resizeFrameObj;if("td"!==a&&"th"!==a||(e=e.closest(".smart-editor-editable table")),a=e?e.nodeName.toLowerCase():"",e&&e.parentElement&&("img"===a||"table"===a||e.classList.contains("smart-editor-video-container"))&&"false"!==n.getAttribute("contenteditable"))if(i?o=i.element:(i=r._resizeFrameObj={},o=i.element=document.createElement("span"),o.classList.add("smart-editor-resize-frame"),o.innerHTML='<span position="top-left"></span><span position="top-right"></span>\n                                     <span position="bottom-left"></span><span position="bottom-right"></span>\n                                     <span position="top-center"></span><span position="bottom-center"></span>\n                                     <span position="left-center"></span><span position="right-center"></span>'),i.target&&i.target.removeAttribute("show-resize-frame"),i.target=e,e.classList.contains("smart-editor-video-container")?i.resizableElement=e.querySelector("video, iframe"):delete i.resizableElement,r._refreshToolbarTabs(),"false"!==e.getAttribute("resizable")){if(e.setAttribute("show-resize-frame",""),r._positionResizeHandles(),o.parentElement||r.$.contentContainer.appendChild(o),!t&&"img"===a){const e=r.$.iframe;(e?e.contentWindow:window).getSelection().collapse(null),r._updateToolbarItems()}}else e.removeAttribute("show-resize-frame");else{if(i){if(i.element.remove(),i.target){const e=n.querySelectorAll("[show-resize-frame]");for(let t=0,r=e.length;t<r;t+=1)e[t].removeAttribute("show-resize-frame")}delete i.target}r._refreshToolbarTabs()}}_setToast(){const e=this;let t=e.$.toast;return t||(e.$.toast=t=document.createElement("smart-toast"),t.appendTo=e.$.container,t.showCloseButton=!0,t.itemClass="smart-editor-message",e.$toast=Smart.Utilities.Extend(t)),t.rightToLeft=e.rightToLeft,t.theme=e.theme,t.animation=e.animation,t}_positionResizeHandles(){const e=this,t=e._resizeFrameObj;if(!e._resizeFrameObj)return;const r=t.element,n=e.rightToLeft,o=n?"right":"left",a=(t.resizableElement||t.target).getBoundingClientRect(),i=r.children,s=i[0],l=i[1],d=i[2],m=i[3],c=i[4],u=i[5],p=i[6],h=i[7],b=e.$.editableElement,g=e.$.contentContainer.getBoundingClientRect(),f=a.top-g.top+b.offsetTop,v=a.width,w=a.height;let x;n?(x=g.right-a.right+(b.offsetLeft+b.offsetWidth-g.width),s.style.left=d.style.left=p.style.left=""):(x=a.left-g.left+b.offsetLeft,s.style.right=d.style.right=p.style.right=""),s.style.top=l.style.top=c.style.top=f+"px",s.style[o]=d.style[o]=p.style[o]=x+"px",d.style.top=m.style.top=u.style.top=f+w+"px",l.style[o]=m.style[o]=h.style[o]=v+x+"px",c.style[o]=u.style[o]=x+v/2+"px",p.style.top=h.style.top=f+w/2+"px"}_openInlineToolbar(e){const t=this,r=t.$.editableElement;let n=t.$.inlineToolbar;if(t._closeToolbarItemDropDown(t.$.inputPopup),t._closeToolbarItemDropDown(t.$.colorInputPopup),"false"===r.getAttribute("contenteditable")||t.hideInlineToolbar)return void(n&&n.visible&&n.close());n||(n=t._createToolbar());if(t.$.fireEvent("inlineToolbarOpening",{target:n}).defaultPrevented)return;t._setupToolbar(e,"inline"),n.parentElement||t.getShadowRootOrBody().appendChild(n);const o=t._getInlineToolbarContent(e);n.clear(),o instanceof DocumentFragment&&(n.appendChild(o),n.open(),t._setAriaOwns(n)),t._updateToolbarItems(void 0,n)}_closeToolbar(){const e=this,t=e.$.inlineToolbar;if(t){const r=t.classList,n=r.contains("smart-editor-context-menu")?"contextMenu":r.contains("smart-editor-inline-toolbar")?"inlineToolbar":"dropDownToolbar";if(e.$.fireEvent(n+"Closing",{target:t}).defaultPrevented)return;t.close()}}_closePopups(){const e=this;e._closeToolbar(),e._closeToolbarItemDropDown(e.$.inputPopup),e._closeToolbarItemDropDown(e.$.colorInputPopup)}_createToolbar(){const e=this;let t=e.$.inlineToolbar;return t||(t=document.createElement("smart-tooltip"),e.$.inlineToolbar=t,e.$inlineToolbar=Smart.Utilities.Extend(t),t)}_setupToolbar(e,t){const r=this,n=r.$.iframe,o=r.$.inlineToolbar,a=r.$inlineToolbar;if(!o.visible){const e=e=>r._tooltipVisibilityHandler.call(r,e),t=e=>r._tooltipVisibilityHandler.call(r,e),n=e=>r._tooltipChangeHandler.call(r,e),o=e=>r._tooltipClickHandler.call(r,e),i=e=>r._tooltipTransitionEndHandler.call(r,e);a.unlisten("open"),a.unlisten("close"),a.unlisten("change"),a.unlisten("click"),a.unlisten("transitionend"),a.listen("open",e),a.listen("close",t),a.listen("change",n),a.listen("click",o),a.listen("transitionend",i)}if(o.locale=r.locale,o.rightToLeft=r.rightToLeft,o.theme=r.theme,o.animation=r.animation,o.openMode="manual","inline"===t)o.position="auto",o.iframeRect=n?n.getBoundingClientRect():null,o.arrow=!0,o.align="center",o.offset=r.inlineToolbarOffset,o.classList.add("smart-editor-toolbar","smart-editor-inline-toolbar"),o.classList.remove("smart-editor-drop-down-toolbar","smart-editor-context-menu"),o.setAttribute("role","tooltip"),o.setAttribute("aria-label","Inline Toolbar");else{if("context"!==t)return o.position="auto",o.iframeRect=null,o.arrow=!1,o.align=r.rightToLeft?"right":"left",o.offset=[0,-5],o.selector=e,o.classList.add("smart-editor-toolbar","smart-editor-drop-down-toolbar"),o.classList.remove("smart-editor-inline-toolbar","smart-editor-context-menu"),o.setAttribute("role","tooltip"),void o.setAttribute("aria-label","Drop Down Toolbar");o.position="absolute",o.arrow=!1,o.classList.add("smart-editor-context-menu"),o.classList.remove("smart-editor-toolbar","smart-editor-drop-down-toolbar","smart-editor-inline-toolbar"),o.setAttribute("role","listbox"),o.setAttribute("aria-label","Context Menu")}if(o.selector&&!o.selector.closest&&delete o.selector.getBoundingClientRect,e.closest)o.selector=e;else{const t=e.parentElement,n=r._getSelectionRange();t.getBoundingClientRect=()=>n.getBoundingClientRect(),o.selector=t}}_getInlineToolbarContent(e){const t=this,r=t.$.inlineToolbar;if(r.innerHTML&&r.selector.nodeName===e.nodeName)return;let n;const o=t._toolbarItemsObj,a=e.nodeName.toLowerCase(),i=(e=[])=>{let t;for(let r=0,n=e.length;r<n;r+=1){const n=o[e[r]];if(n){t=n;break}}return t};let s;switch(a){case"a":s=i(["hyperlink","createlink"]);break;case"#text":s=i(["cut","copy","paste"]);break;case"img":s=i(["image"]);break;case"td":case"th":s=i(["table"]);break;default:return}return n=s&&Array.isArray(s.inlineToolbarItems)?s.inlineToolbarItems:t._getDefaultInlineToolbarItems(e,a),n.length?t._getToolbarItems(r,n):void 0}_getDefaultInlineToolbarItems(e,t){let r;switch(t){case"a":r=["openlink","editlink","removelink"];break;case"#text":r=["cut","copy","paste"];break;case"img":r=["image","alignment","createlink","delete","caption"],e.closest(".smart-editor-editable a")&&r.splice(r.indexOf("createlink")+1,0,"openlink","removelink");break;case"td":case"th":r=["table","tableheader","tablerows","tablecolumns","backgroundcolor","delete","alignment","tablevalign","tablestyle"];break;default:return[]}return r}_getNodes(e,t=0,r,n=0){const o=this,a=e.childNodes;let i=[];for(let e=0,s=a.length;e<s;e+=1){const s=a[e];if(s.childElementCount){const e=o._getNodes(s,t,r,n);if(n=e.index,e.nodes.length&&(i=i.concat(e.nodes)),n>=r)break}else if(s.nodeType===Node.TEXT_NODE){const e=s.nodeValue;if(!e.trim())continue;const o=e.length;if(n+o>t&&i.push({node:s,index:r-n,startIndex:Math.max(0,t-n)}),(n+=o)>r)break}else{if((n+=(s.textContent||s.innerText||s.innerHTML).length)>t&&i.push({node:s,index:n}),n>r)break}}return{nodes:i,index:n}}_tooltipChangeHandler(e){const t=this,r=e.target,n=t.$.inlineToolbar;n&&n.classList.contains("smart-editor-drop-down-toolbar")&&n.visible&&n.contains(r)?r.classList.contains("smart-table-picker")&&(t._handleTableInsert({cells:e.detail.value}),n.close()):t._changeHandler(e)}_tooltipClickHandler(e){const t=this,r=e.target,n=t.$.inlineToolbar;if(n&&n.classList.contains("smart-editor-drop-down-toolbar")&&n.contains(e.target)&&r.closest(".smart-table-picker-button")){const e=t._getSelectionRange();let r;return e.startContainer&&["th","td"].indexOf(e.startContainer.nodeName.toLowerCase())>-1&&(r=e.startContainer.closest(".smart-editor-editable table")),void t._openWindow(n.selector,r)}if(n&&n.classList.contains("smart-editor-context-menu")){const n=r.closest(".smart-editor-context-menu-item");if(n)return void t._handleContextMenuItemClick(e,n)}}_tooltipVisibilityHandler(e){const t=this,r=t.$.inlineToolbar,n=e.type;if(e.target!==r)return;const o=t.$.inlineToolbar,a=t.$inlineToolbar;let i;i=r.classList.contains("smart-editor-toolbar")?(r.classList.contains("smart-editor-drop-down-toolbar")?"inline":"dropDown")+"Toolbar":"contextMenu",e.stopPropagation(),"close"===e.type?(o.selector&&!o.selector.closest&&delete o.selector.getBoundingClientRect,o.hasAnimation||(a.unlisten(e.type),a.unlisten("change"),a.unlisten("click"),o.remove(),t._focusEditableElement()),t._setAriaOwns(r)):"open"===e.type&&t._setAriaOwns(r),t.$.fireEvent(i+n.slice(0,1).toUpperCase()+n.slice(1),Object.assign({target:e.target},e.detail))}_tooltipTransitionEndHandler(e){const t=this;if(!(e.target instanceof Smart.Tooltip))return;const r=t.$.inlineToolbar,n=t.$inlineToolbar;r.visible||(n.unlisten("transitionend"),r.style.top=r.style.left=0,r.remove(),t._setAriaOwns(r))}_toggleItemDropDown(e){const t=this,r=e.getAttribute("item-type");let n;if("drop-down"===r?(t.$.inputPopup||(t.$.inputPopup=document.createElement("smart-input")),n=t.$.inputPopup):"color-input"===r&&(t.$.colorInputPopup||(t.$.colorInputPopup=document.createElement("smart-color-input")),n=t.$.colorInputPopup),n.noRipple=!0,t.$.inputPopup&&n===t.$.colorInputPopup&&t.$.inputPopup.parentElement?t._closeToolbarItemDropDown(t.$.inputPopup):t.$.colorInputPopup&&n===t.$.inputPopup&&t.$.colorInputPopup.parentElement&&t._closeToolbarItemDropDown(t.$.colorInputPopup),n)if(n.locale=t.locale,n.rightToLeft=t.rightToLeft,n.theme=t.theme,n.animation=t.animation,e.contains(n)&&n.opened)t._closeToolbarItemDropDown(n);else{const r=t.$.inlineToolbar;r&&!r.contains(e)&&t._closeToolbar(),n.remove(),t._openToolbarItemDropDown(e,n)}}_toggleDropDownToolbar(e){const t=this;if(!e)return;if("table"!==e.getAttribute("item-name"))return;const r=t.$.inlineToolbar;if(r&&r.visible&&r.classList.contains("smart-editor-drop-down-toolbar")){if(r.contains(e)){const r=t._getSelectionRange();let n;return r.startContainer&&["th","td"].indexOf(r.startContainer.nodeName.toLowerCase())>-1&&(n=r.startContainer.closest(".smart-editor-editable table")),void t._openWindow(e,n)}r.classList.contains("smart-editor-drop-down-toolbar")&&r.close()}else t._closeToolbarItemDropDown(t.$.inputPopup),t._closeToolbarItemDropDown(t.$.colorInputPopup),t._openDropDownToolbar(e)}_openDropDownToolbar(e){const t=this;let r=t.$.inlineToolbar;r||(r=t._createToolbar());t.$.fireEvent("dropDownToolbarOpening",{target:r}).defaultPrevented||(t._setupToolbar(e,"dropDown"),r.parentElement||t.getShadowRootOrBody().appendChild(r),t._setDropDownToolbarContent(e),r.open(),t._setAriaControls(e,r))}_setDropDownToolbarContent(e){const t=this,r=t.$.inlineToolbar,n=e.getAttribute("item-name");let o=t._dropDownToolbarObj;o||(o=t._dropDownToolbarObj={});let a=o[n];a||(a=document.createElement("smart-table-picker"),o[n]=a),a.rightToLeft=t.rightToLeft,a.locale=t.locale,a.messages=t.messages,a.value=[],r.contains(a)||(r.clear(),r.appendChild(a))}_openSearchBar(){const e=this,t=e.$.editableElement,r=e.$.contentContainer;let n=e._searchToolbar;if(e.disableSearchBar||t.classList.contains("smart-hidden"))return void(n&&n.remove());n||(n=e._searchToolbar=document.createElement("div"),n.classList.add("smart-editor-search-bar"),n.innerHTML='<span class="smart-search-input-container">\n                                    <input class="smart-search-input"></input>\n                                </span>\n                                <smart-button class="smart-search-button prev"></smart-button>\n                                <smart-button class="smart-search-button next"></smart-button>\n                                <smart-button class="smart-search-button close"></smart-button>'),n.ontransitionend=null;const o=e.animation,a=e.theme,i=e.rightToLeft,s=n.children;let l;for(let t=0,r=s.length;t<r;t+=1){const r=s[t];if(r.classList.contains("smart-search-input-container")){const t=r.firstElementChild;t.placeholder=e.localize("searchPlaceholder"),l=t}r.animation=o,r.theme=a,r.rightToLeft=i}if(r.contains(n)||r.appendChild(n),n.classList.remove("smart-visibility-hidden"),l){const t=e.$.iframe,r=(t?t.contentWindow:window).getSelection().toString();l.value=r,l.focus({preventScroll:!0}),r&&e._applySearching(r)}delete e._lastSearchQuery}_closeSearchToolbar(){const e=this,t=e._searchToolbar;if(t&&!t.classList.contains("smart-visibility-hidden")){t.classList.add("smart-visibility-hidden"),t.ontransitionend=()=>{t.remove(),t.ontransitionend=null};const r=Array.from(e.$.editableElement.querySelectorAll(".find-and-replace-match"));for(let e=0,t=r.length;e<t;e+=1){const t=r[e];t.outerHTML=t.textContent}e._focusEditableElement()}}_toggleWindow(e,t){const r=this;if(!e)return;const n=e.getAttribute("item-name"),o=r.$.window;if(!o)return void r._openWindow(e,t);const a=o._target?o._target.item:void 0;!a||a.name!==n||a.name===n&&!o.opened?r._openWindow(e,t):o.close()}_openWindow(e,t){const r=this;if(!e||!r._toolbarItemsObj||r._window&&r._window.opened)return;let n;t&&t.classList.contains("smart-editor-video-container")&&(t=t.querySelector(".smart-editor-video-container > video, .smart-editor-video-container > iframe"));const o=r.$.editableElement;if(e.closest){if(!e.classList.contains("smart-editor-toolbar-item"))return;n=(e.closest(".smart-editor-inline-toolbar")?r._inlineToolbarItemsObj:r._toolbarItemsObj)[e.getAttribute("item-name")]}else"object"==typeof e&&"string"==typeof e.name&&(n=e);if(!n||"findandreplace"===n.name&&o.classList.contains("smart-hidden"))return;const a=r._createWindow(n);r.$.fireEvent("dialogOpening",{target:a,item:n}).defaultPrevented||(r._closeToolbarItemDropDown(r.$.inputPopup),r._closeToolbarItemDropDown(r.$.colorInputPopup),a._target={item:n,itemTarget:t,originalTarget:e},r._closeToolbar(),a.parentElement||r.getShadowRootOrBody().appendChild(a),a.isCompleted?r._setupWindow():a.whenReady((()=>r._setupWindow())))}_closeWindow(){const e=this,t=e.$.window;t&&t.opened&&(e.$.fireEvent("dialogClosing",{target:t,item:t._target.item}).defaultPrevented||t.close())}_setupWindow(){const e=this,t=e.$.window,r=t._target,n=r.item;function o(){e._positionWindow(),t.opened?(t.bringToFront(),t._handleActiveState(),t._onOpenCallback&&t._onOpenCallback()):t.open()}if(t.locale=e.locale,t.rightToLeft=e.rightToLeft,t.theme=e.theme,t.animation=e.animation,e.windowCustomizationFunction?e.windowCustomizationFunction(t,n):(e._setPopupWindowTemplate("header",n),e._setPopupWindowTemplate("footer",n),e._setPopupWindowTemplate("content",n)),!t.opened){const r=e.$window,n=t=>e._windowOpenHandler.call(e,t),o=t=>e._windowCloseHandler.call(e,t),a=t=>e._windowClickHandler.call(e,t),i=t=>e._windowChangeHandler.call(e,t),s=t=>e._windowKeyDownHandler.call(e,t),l=t=>e._windowKeyUpHandler.call(e,t),d=t=>e._windowTransitionendHandler.call(e,t),m=t=>e._fileUploadCompletedHandler.call(e,t),c=t=>e._fileUploadErrorHandler.call(e,t);r.unlisten("transitionend"),r.unlisten("open"),r.unlisten("close"),r.unlisten("click"),r.unlisten("change"),r.unlisten("keydown"),r.unlisten("keyup"),r.unlisten("uploadCompleted"),r.unlisten("uploadError"),t._onOpenCallback=()=>{((t.shadowRoot||t).querySelector(".smart-editor-window-editor:not(.smart-hidden) .smart-input.smart-element")||t).focus({preventScroll:!0})},t.hasAnimation&&r.listen("transitionend",d),r.listen("open",n),r.listen("close",o),r.listen("click",a),r.listen("change",i),r.listen("keydown",s),r.listen("keyup",l),r.listen("uploadCompleted",m),r.listen("uploadError",c)}t.shadowRoot?e._onShadowDomLoaded(t,"smart.window.css",o):o(),e._setAriaOwns(t),e._setAriaControls(r.originalTarget,t)}_setPopupWindowTemplate(e,t){const r=this,n=r.$.window;if(!n)return;if("content"===e)return void r._setWindowContent(t);n[e+"Template"]||(n[e+"Template"]=r._createWindowTemplate(e));const o=n._target.item;if("header"===e)n.label=r.localize(o.name)||"";else if("footer"===e){const e=(n.shadowRoot||n).querySelectorAll(".smart-editor-window-button"),o="findandreplace"===t.name;for(let t=0;t<e.length;t++){const n=e[t];n.innerHTML='<span class="smart-icon"></span>',n.theme=r.theme,n.rightToLeft=r.rightToLeft,n.animation=r.animation,n.classList.contains("ok")?o?(n.classList.add("replace"),n.innerHTML+=r.localize("replace"),n.setAttribute("aria-label","replace")):(n.classList.remove("replace"),n.innerHTML+=r.localize("ok"),n.setAttribute("aria-label","ok")):n.classList.contains("cancel")?(n.innerHTML+=r.localize("cancel"),n.setAttribute("aria-label","cancel")):o?(n.classList.contains("replace-all")&&(n.innerHTML+=r.localize("replaceAll"),n.setAttribute("aria-label","replaceAll")),n.classList.remove("smart-hidden")):n.classList.add("smart-hidden");const a=n.querySelector(".smart-ripple");a&&a.parentElement.removeChild(a)}}}_setWindowContent(e){const t=this,r=t.$.window,n=r._target.originalTarget,o=[].slice.call(r.getElementsByClassName("smart-editor-window-editor"));if((!r.innerHTML||o.length)&&n){switch(e.name){case"createlink":case"editlink":case"hyperlink":case"image":case"video":case"table":case"paste":case"findandreplace":t._createWindowEditors(e)}n.id&&r.setAttribute("aria-controls",n.id)}}_createWindowEditors(e){const t=this,r=t.$.window,n=e.name;let o,a=t._windowEditors,i=r.querySelector(".smart-editor-window-content-wrapper");i||(i=document.createElement("div"),i.classList.add("smart-editor-window-content-wrapper"),r.appendChild(i)),t._windowEditors||(a=t._windowEditors={}),a&&(o=a[n]),o||(o=document.createElement("div"),o.classList.add(`smart-editor-window-${n}`),o.innerHTML=t._getWindowEditorTemplate(n),a[n]=o),i.contains(o)||(i.innerHTML="",i.appendChild(o));const s=o.querySelectorAll(".smart-editor-window-editor[type]");for(let e=0;e<s.length;e++)t._setPopupWindowEditor(s[e])}_getWindowEditorTemplate(e){switch(e){case"createlink":case"editlink":case"hyperlink":return'\n                <div class="smart-editor-window-editor" type="address">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="text">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="title">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="target">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>';case"image":return'\n                <div class="smart-editor-window-editor" type="file">\n                    <smart-file-upload item-editor></smart-file-upload>\n                </div>\n                <div class="smart-editor-window-editor" type="url">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="width">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="height">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="alt">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="title">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="caption">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="display">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="alignment">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="draggable">\n                    <smart-check-box item-editor></smart-check-box>\n                </div>\n                <div class="smart-editor-window-editor" type="resizable">\n                    <smart-check-box item-editor></smart-check-box>\n                </div>';case"table":return'\n                    <div class="smart-editor-window-editor" type="cols">\n                        <label></label>\n                        <smart-number-input item-editor></smart-number-input>\n                    </div>\n                    <div class="smart-editor-window-editor" type="rows">\n                        <label></label>\n                        <smart-number-input item-editor></smart-number-input>\n                    </div>\n                    <div class="smart-editor-window-editor" type="width">\n                        <label></label>\n                        <smart-input item-editor></smart-input>\n                    </div>\n                    <div class="smart-editor-window-editor" type="height">\n                        <label></label>\n                        <smart-input item-editor></smart-input>\n                    </div>\n                    <div class="smart-editor-window-editor" type="tableheader">\n                        <smart-check-box item-editor></smart-check-box>\n                    </div>\n                    <div class="smart-editor-window-editor" type="altrows">\n                        <smart-check-box item-editor></smart-check-box>\n                    </div>\n                    <div class="smart-editor-window-editor" type="dashedborders">\n                        <smart-check-box item-editor></smart-check-box>\n                    </div>\n                    <div class="smart-editor-window-editor" type="resizable">\n                        <smart-check-box item-editor></smart-check-box>\n                    </div>';case"paste":return'\n                    <div class="smart-editor-window-editor" type="keepFormat">\n                        <label></label>\n                        <smart-radio-button checked group-name="editorPasteViaWindow" item-editor></smart-radio-button>\n                    </div>\n                    <div class="smart-editor-window-editor" type="cleanFormat">\n                        <smart-radio-button group-name="editorPasteViaWindow" item-editor></smart-radio-button>\n                    </div>\n                    <div class="smart-editor-window-editor" type="plainText">\n                        <smart-radio-button group-name="editorPasteViaWindow" item-editor></smart-radio-button>\n                    </div>';case"findandreplace":return'\n                <div class="smart-editor-window-editor" type="find">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="replaceWith">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="results">\n                    <label></label>\n                    <smart-list-box virtualized item-editor></smart-list-box>\n                </div>\n                <div class="smart-editor-window-editor" type="matchCase">\n                    <smart-check-box item-editor></smart-check-box>\n                </div>';case"video":return'\n                        <div class="smart-editor-window-editor" type="file">\n                            <smart-file-upload item-editor></smart-file-upload>\n                        </div>\n                        <div class="smart-editor-window-editor" type="src">\n                            <label></label>\n                            <smart-input item-editor></smart-input>\n                        </div>\n                        <div class="smart-editor-window-editor" type="width">\n                            <label></label>\n                            <smart-input item-editor></smart-input>\n                        </div>\n                        <div class="smart-editor-window-editor" type="height">\n                            <label></label>\n                            <smart-input item-editor></smart-input>\n                        </div>\n                        <div class="smart-editor-window-editor" type="thumbnail">\n                            <label></label>\n                            <smart-input item-editor></smart-input>\n                        </div>\n                        <div class="smart-editor-window-editor" type="videoUrl">\n                            <label></label>\n                            <smart-input item-editor></smart-input>\n                        </div>\n                        <div class="smart-editor-window-editor" type="alt">\n                            <label></label>\n                            <smart-input item-editor></smart-input>\n                        </div>\n                        <div class="smart-editor-window-editor" type="title">\n                            <label></label>\n                            <smart-input item-editor></smart-input>\n                        </div>\n                        <div class="smart-editor-window-editor" type="caption">\n                            <label></label>\n                            <smart-input item-editor></smart-input>\n                        </div>\n                        <div class="smart-editor-window-editor" type="display">\n                            <label></label>\n                            <smart-input item-editor></smart-input>\n                        </div>\n                        <div class="smart-editor-window-editor" type="alignment">\n                            <label></label>\n                            <smart-input item-editor></smart-input>\n                        </div>\n                        <div class="smart-editor-window-editor" type="draggable">\n                            <smart-check-box item-editor></smart-check-box>\n                        </div>\n                        <div class="smart-editor-window-editor" type="resizable">\n                            <smart-check-box item-editor></smart-check-box>\n                        </div>';default:return""}}_setPopupWindowEditor(e){const t=this,r=e.getAttribute("type"),n=e.querySelector("label"),o=t.$.window._target,a=o.item,i="markdown"===t.editMode,s=a.editor;let l,d=e.querySelector("[item-editor]");if(n&&("paste"===a.name?(n.id=t.id+"pasteLabel",n.innerHTML=t.localize("pasteLabel")||""):(n.id=t.id+r+"Label",n.innerHTML=t.localize(r)||"")),!d)return;const m=t._toolbarItemClick;let c;switch(c=m?m.target:o.itemTarget,a.name){case"hyperlink":case"createlink":case"editlink":{const n=t._getSelectionRange();let o=n.startContainer;o&&"a"!==o.nodeName.toLowerCase()&&(o=o.parentElement),o&&"a"===o.nodeName.toLowerCase()?"address"===r?l=o.getAttribute("href"):"text"===r?l=o.textContent:"title"===r?l=o.title:"target"===r&&(l=o.target):l="text"===r?i?t.$.input.value.slice(n.selectionStart,n.selectionEnd):n.toString():s&&void 0!==s[r]?s[r]+"":"","target"===r&&i||c&&"img"===c.nodeName.toLowerCase()&&["title","text"].indexOf(r)>-1?e.classList.add("smart-hidden"):e.classList.remove("smart-hidden");break}case"video":case"image":{const n=t._toolbarItemClick,d=n?n.target:o.itemTarget;if(d&&["img","video","iframe"].indexOf(d.nodeName.toLowerCase())>-1){const e=d.closest(".smart-editor-image-container");switch(r){case"file":d.file instanceof File&&(l=d.file);break;case"url":case"src":l=d.file instanceof File?"":d.getAttribute("src")||"";break;case"alt":l=d.alt;break;case"title":l=d.title;break;case"width":if(l=d.style.width||(e?e.style.width:""),!l){const e=d.getAttribute("width");e&&(l=e)}break;case"height":if(l=d.style.height||(e?e.style.height:""),!l){const e=d.getAttribute("height");e&&(l=e)}break;case"caption":if(e){const t=e.querySelector(".smart-editor-image-caption");t&&(l=t.textContent)}void 0===l&&(l="");break;case"alignment":l=(e||d).getAttribute("alignment")||"";break;case"display":l=(e||d).getAttribute("display")||"";break;case"draggable":case"resizable":{const t=("video"===a.name?e:d).getAttribute(r);l=null==t||"true"===t;break}}}else l=s?("draggable"===r||"resizable"===r)&&void 0===s[r]||(void 0!==s[r]?s[r]+"":""):"width"===r?480:"height"===r?270:"draggable"===r||"resizable"===r||"";i&&["file","url","videoUrl","alt","title","thumbnail"].indexOf(r)<0||!i&&"video"===a.name&&["alt","thumbnail","videoUrl"].indexOf(r)>-1?e.classList.add("smart-hidden"):e.classList.remove("smart-hidden");break}case"table":{const t=o.itemTarget&&"table"===o.itemTarget.nodeName.toLowerCase()?o.itemTarget:void 0;switch(r){case"width":case"height":l=t?t.style[r]:s&&void 0!==s[r]?s[r]:"";break;case"cols":l=t?t.querySelector("tbody > tr").children.length+"":s&&void 0!==s[r]?s[r]:"1";break;case"rows":l=t?t.querySelectorAll("tbody > tr").length+"":s&&void 0!==s[r]?s[r]:"1";break;case"tableheader":l=!!i||(t?null!==t.querySelector("thead"):!(!s||void 0===s[r])&&s[r]);break;case"altrows":l=t?t.hasAttribute("alternation"):!(!s||void 0===s[r])&&s[r];break;case"dashedborders":l=t?t.hasAttribute("dashed-borders"):!(!s||void 0===s[r])&&s[r];break;case"resizable":l=t?!("false"===t.getAttribute("resizable")):!s||void 0===s[r]||s[r]}i&&["cols","rows","tableheader"].indexOf(r)<0?e.classList.add("smart-hidden"):e.classList.remove("smart-hidden");break}case"paste":l=r===t.pasteFormat;break;case"findandreplace":l=s&&void 0!==s[r]?s[r]:""}t._setupEditorElement(d,r,l),t._setEditorCommonProperties(d)}_setupEditorElement(e,t,r){const n=this,o=n.$.window._target.item,a=o.editor,i="markdown"===n.editMode;if((e instanceof Smart.CheckBox||e instanceof Smart.RadioButton)&&(e.innerHTML=n.localize(t)||"",e.checked=!!r),e instanceof Smart.NumberInput)e.min=1,e.value=parseInt(r);else{if(e instanceof Smart.FileUpload)return"file"===t&&e.isCompleted&&(e.cancelAll(),r&&e.addFile(r)),e.uploadUrl="",e.removeUrl="",e.autoUpload=!1,n.postData?e.postData=n.postData:n.getAttribute("post-data")&&(e.postData=JSON.parse(n.getAttribute("post-data"))),n.uploadUrl&&(e.uploadUrl=n.uploadUrl,n._fileUpload=e,n._fileUpload.name=n.imageName,e.autoUpload=n.autoUpload),n.removeUrl&&(e.removeUrl=n.removeUrl),n.validateFile&&(e.validateFile=n.validateFile),a&&(a.uploadUrl&&(e.uploadUrl=a.uploadUrl,e.autoUpload=!0),a.removeUrl&&(e.removeUrl=a.removeUrl)),e.dropZone=e.parentElement,e.accept=o.allowedTypes||(i||"video"!==o.name?"image/*":"video/mp4,video/x-m4v,video/*"),void(e.hideFooter=!0);if(e instanceof Smart.ListBox)e.selectionMode="one",e.itemHeight=35;else{if("string"==typeof e.placeholder&&(e.placeholder=n.localize(t+"Placeholder")||""),e.dropDownClassList&&(e.dropDownClassList=["smart-editor-input"]),void 0!==e.dataSource){if("target"===t||"alignment"===t||"display"===t){e.dataSource.length||(e.dataSource=n._getDefaultDataSource(t)),"alignment"!==t||r||(r="center");const o=r?e.dataSource.find((e=>"object"==typeof e&&e.value===r)):void 0;o&&"object"==typeof o&&(r=o.label||r),e.readonly=!o&&!r||o&&""!==o.value}else e.dataSource=[];"string"==typeof e.dropDownButtonPosition&&(e.dropDownButtonPosition=e.dataSource.length?n.rightToLeft?"left":"right":"none")}e.value=void 0===r?"":r+""}}}_setEditorCommonProperties(e){const t=this;if(e){const r=e.messages,n=t.messages,o=t.locale;for(let e in r.en){const t=n[o][e];void 0!==t&&(r[o]||(r[o]={}),r[o][e]=t)}e.locale=t.locale,e.rightToLeft=t.rightToLeft,e.animation=t.animation,e.theme=t.theme}}_createWindow(){const e=this,t=e.$.window;if(t)return t;const r=document.createElement("smart-window");return r.classList.add("smart-editor-window"),r.id=e.id+"Window",r.setAttribute("smart-id","window"),e.$.window=r,e.$window=Smart.Utilities.Extend(r),r.rightToLeft=e.rightToLeft,r.theme=e.theme,r.animation=e.animation,r.disableSnap=!0,r.headerButtons=["close"],r}_createWindowTemplate(e){const t=this,r=t.animation,n=t.theme,o=t.rightToLeft;let a;return"footer"===e&&(a=document.createElement("template"),a.innerHTML=`<smart-button class="smart-editor-window-button primary replace replace-all smart-hidden"\n                    animation="${r}" theme="${n}" ${o?"right-to-left":""}>\n                </smart-button>\n                <smart-button class="smart-editor-window-button ok primary"\n                    animation="${r}" theme="${n}" ${o?"right-to-left":""}>\n                </smart-button>\n                <smart-button class="smart-editor-window-button cancel"\n                    animation="${r}" theme="${n}" ${o?"right-to-left":""}>\n                </smart-button>`),a}_positionWindow(){const e=this,t=e.getShadowRootOrBody(),r=e.$.window;if(!r||!t.contains(r))return;const n=e.getBoundingClientRect();r.opened||(r.style.left=r.style.top=""),r.style.left=Math.max(n.left+window.pageXOffset,n.left+window.pageXOffset+n.width/2-r.offsetWidth/2)+"px",r.style.top=Math.max(n.top+window.pageYOffset,n.top+window.pageYOffset+n.height/2-r.offsetHeight/2)+"px"}_windowChangeHandler(e){const t=this,r=e.detail,n=t.$.window._target.item;let o=(e.originalEvent||e).target;const a=o.closest(".smart-editor-window-editor");if(!o.hasAttribute("item-editor")||!n||!a)return;const i=a.getAttribute("type");if(n.name.indexOf("link")>0&&"target"===i&&o instanceof Smart.Input)o.readonly=!!r.value.length;else if(t._windowEditors&&n.name.indexOf("findandreplace")>-1)if("results"===i&&o instanceof Smart.ListBox)t._handleMarkerSelection(e.target);else if("matchCase"===i&&o instanceof Smart.CheckBox){const e=a.parentElement.querySelector('.smart-editor-window-editor[type="find"] [item-editor]');e&&t._findMatches(e.value)}}_windowClickHandler(e){const t=this;let r=(e.originalEvent||e).target;r.shadowRoot&&(r=(e.originalEvent||e).composedPath()[0]);const n=t.$.window,o=n._target,a=r.closest(".smart-editor-window-button");if(n&&a&&o){if("findandreplace"===o.item.name){const e=a.classList,r=a.classList.contains("replace-all");if(r||e.contains("ok"))return void t._replaceMatches(n._target.item,r)}else if(a.classList.contains("ok")&&!1===t._updateEditorViaWindow(o.item))return;n.close(),delete n._target}}_windowCloseHandler(e){const t=this,r=e.target;if(!r.classList.contains("smart-editor-window"))return;const n=t.$window;if(n){t.$.fireEvent("dialogClose",{target:e.target,item:e.target._target.item}),n.unlisten("close"),n.unlisten("click"),n.unlisten("change"),n.unlisten("keydown"),n.unlisten("uploadCompleted"),n.unlisten("uploadError"),t.hasAttribute("aria-owns")&&t.removeAttribute("aria-owns"),t.hasAnimation||(r.remove(),t._setAriaOwns(r));const o=r._target,a=o.itemTarget;if("findandreplace"===o.item.name&&t._findMatches(""),t._focusEditableElement(),a&&["img","th","td","table"].indexOf(a.nodeName.toLowerCase())>-1)return void t._setResizeFrame(a)}}_windowKeyDownHandler(e){const t=this,r=t.$.window;if("Enter"!==e.key||!r._target)return;const n=r._target.item,o=r.getRootNode().activeElement;if(n&&o.closest(".smart-editor-window-editor")){if(!1===t._updateEditorViaWindow(n))return;e.stopPropagation(),e.preventDefault(),r.close(),delete r._target}}_windowKeyUpHandler(e){const t=this,r=e.target;if(r.closest('.smart-editor-window-editor[type="find"]')){const e=r.closest("[item-editor]");if(e){const r=t.findAndReplaceTimeout;if(clearTimeout(t._findAndReplaceTimeout),"html"!==t.editMode)return;r?t._findAndReplaceTimeout=setTimeout((()=>t._findMatches(e.value)),r):t._findMatches(e.value)}}else;}_windowOpenHandler(e){const t=this,r=e.target;if(!r.classList.contains("smart-editor-window"))return;const n=t.$window;if(n){const o=r._target.item;if(t._setAriaOwns(r),t.$.fireEvent("dialogOpen",{target:e.target,item:o}),n.unlisten("open"),"findandreplace"===o.name){const e=r.querySelector('.smart-editor-window-editor[type="find"] [item-editor]');t._findMatches(e?e.value:"")}}}_windowTransitionendHandler(e){const t=this,r=e.target;r.classList.contains("smart-editor-window")&&(r.opened||"visibility"!==e.propertyName||(t.$window.unlisten("transitionend"),t.$.window.remove(),t._setAriaOwns(r)))}_updateEditorViaWindow(e){const t=this;if(!e||!t._windowEditors)return;const r=t.$.iframe,n=t.$.editableElement;let o,a;t.$.contentContainer.contains(n.getRootNode().activeElement)||t._focusEditableElement(),r?(o=r.contentWindow,a=o.getSelection()):(o=window,a=window.getSelection());const i=t._windowEditors[e.name],s=t._getSelectionRange();let l;if(i&&!t.$.fireEvent("actionStart",{name:e.name}).defaultPrevented){switch(s instanceof o.Range&&(a.removeAllRanges(),a.addRange(s)),e.name){case"editlink":case"createlink":case"hyperlink":l=t._handleLinksInsert(e);break;case"image":l=t._handleImageInsert(e);break;case"table":t._handleTableInsert(t._getItemOptionsViaWindow(e));break;case"paste":t._handlePasteViaWindow(e);break;case"video":l=t._handleVideoInsert(e)}return t.$.fireEvent("actionEnd",{name:e.name}),l?(l(),!1):void 0}}_focusFirstInputCallback(e,t){const r=this._windowEditors[e];if(r)return()=>{const e=r.querySelector(`.smart-editor-window-editor[type="${t}"] .smart-input[item-editor]`);e&&e.focus({preventScroll:!0})}}_fileUploadCompletedHandler(e){const t=this.$.window;let r;t&&t.opened&&t._target&&(r=t._target.item),e.stopPropagation(),this.$.fireEvent("imageUploadSuccess",Object.assign({target:e.target,toolbarItem:r},e.detail));const n=e.detail.fileURL,o=e.detail.serverResponse,a=t.querySelector('[type="url"] [item-editor]');n?(a.value=n,a._details=e.detail):o&&(Array.isArray(o)?e.detail.serverResponse[0].file_url?a.value=e.detail.serverResponse[0].file_url:e.detail.serverResponse[0].fileURL&&(a.value=e.detail.serverResponse[0].fileURL):e.detail.serverResponse.file_url?a.value=e.detail.serverResponse.file_url:e.detail.serverResponse.fileURL&&(a.value=e.detail.serverResponse.fileURL))}_fileUploadErrorHandler(e){const t=this.$.window;let r;t&&t.opened&&t._target&&(r=t._target.item),e.stopPropagation(),this.$.fireEvent("imageUploadFailed",Object.assign({target:e.target,toolbarItem:r},e.detail))}_replaceMatches(e,t){const r=this,n=r.$.editableElement;if(!e||!r._windowEditors||"html"!==r.editMode||n.classList.contains("smart-hidden"))return;const o=r._getItemOptionsViaWindow(e),a=r._windowEditors[e.name],i=a.querySelector('.smart-editor-window-editor[type="results"] smart-list-box[item-editor]'),s=a.querySelector('.smart-editor-window-editor[type="results"] label'),l=i.selectedIndexes;if(!o||!l||!l.length)return;const d=o.replaceWith,m=Array.from(n.querySelectorAll(".find-and-replace-match"));for(let e=0,r=m.length;e<r;e+=1){const r=m[e];(t||l.indexOf(e)>-1)&&(r.outerHTML=d)}t?i.dataSource=[]:l.forEach((e=>i.removeAt(e))),r._setFindAndReplaceLabel(s,i)}_findMatches(e){const t=this,r=t.$.editableElement,n=t._windowEditors,o=n?n.findandreplace:void 0,a=o.querySelector('.smart-editor-window-editor[type="results"] smart-list-box[item-editor]'),i=o.querySelector('.smart-editor-window-editor[type="results"] label'),s=o.querySelector('.smart-editor-window-editor[type="matchCase"] smart-check-box[item-editor]'),l=t.$.window.querySelectorAll(".smart-editor-window-button.replace");a&&"smart-list-box"===a.nodeName.toLowerCase()&&(a.dataSource=[]),t._findAndReplaceTimeout&&(clearTimeout(t._findAndReplaceTimeout),delete t._findAndReplaceTimeout);const d=Array.from(r.querySelectorAll(".find-and-replace-match"));for(let e=0,t=d.length;e<t;e+=1){const t=d[e];t.outerHTML=t.textContent}if("html"===t.editMode)if(e){a.dataSource=t._getFindMarkers(r,new RegExp(e,"gm"+(s.checked?"":"i")),[]),a.select("0"),t._setFindAndReplaceLabel(i,a);for(let e=0,t=l.length;e<t;e+=1)l[e].disabled=!1}else{t._setFindAndReplaceLabel(i);for(let e=0,t=l.length;e<t;e+=1)l[e].disabled=!0}}_clearSearchToolbar(){const e=this,t=e._searchToolbar;t&&!t.classList.contains("smart-visibility-hidden")&&(t.value="",delete e._lastSearchQuery)}_applySearching(e){const t=this,r=t.$.editableElement;if(t._lastSearchQuery===e||r.classList.contains("smart-hidden"))return;const n=t.$.contentContainer.querySelector(".smart-search-input-container");let o;t._findAndReplaceTimeout&&(clearTimeout(t._findAndReplaceTimeout),delete t._findAndReplaceTimeout);const a=Array.from(r.querySelectorAll(".find-and-replace-match"));for(let e=0,t=a.length;e<t;e+=1){const t=a[e];t.outerHTML=t.textContent}if("html"===t.editMode){if(e){o=t._getFindMarkers(r,new RegExp(e,"gmi"),[]).length;const n=r.querySelector(".find-and-replace-match");n&&(n.classList.add("selected"),t._scrollToMarker(n))}n&&(n.setAttribute("matches",o||0),n.setAttribute("selected",o?1:0)),t._lastSearchQuery=e}}_scrollToMarker(e){const t=this,r=t._searchToolbar,n=r&&!t._searchToolbar.classList.contains("smart-visibility-hidden")?r.offsetHeight:0,o=t.$.editableElement,a=o.getBoundingClientRect(),i=e.getBoundingClientRect(),s=o.scrollLeft,l=o.scrollTop,d=a.height,m=a.width,c=i.height,u=i.width,p=i.top-a.top+l,h=i.left-a.left+s;l+n>p||s>h?o.scrollTo(h-m,p-n-10):(l+d<p+c||s+m<h+u)&&o.scrollTo(h+u-m,p+c-d)}_setFindAndReplaceLabel(e,t){if(!e)return;const r=t?t.items.length:0;if(!t||!r)return e.removeAttribute("matches"),void e.removeAttribute("selected");if(e){const n=t.selectedIndexes[0];e.setAttribute("matches",r),e.setAttribute("selected",n?n+1:1)}}_getFindMarkers(e,t,r){const n=this,o=Array.from(e.childNodes);for(let e=0,a=o.length;e<a;e+=1){const a=o[e];if(a.childElementCount)n._getFindMarkers(a,t,r);else if(a.textContent){const e=document.createDocumentFragment(),n=a.textContent;let o,i=0;if(n.matchAll)o=Array.from(n.matchAll(t));else{let e;for(o=[];e=t.exec(n);)o.push(e)}if(o.forEach((t=>{const n=t.input,o=t.index,a=t[0],s=n.substring(i,o),l=r.length,d=document.createElement("span");s.length&&e.appendChild(document.createTextNode(s)),d.classList.add("find-and-replace-match"),d.setAttribute("match-id",l),d.textContent=a,e.appendChild(d);const m=n.substring(Math.max(0,o-10),o),c=n.substr(o+a.length,10);r.push({label:`${o>0?"...":""}${m}<b>${a}</b>${c}${o<n.length-1?"...":""}`,value:l}),i=o+a.length})),!e.childElementCount)continue;const s=a.textContent.substr(i);s&&e.appendChild(document.createTextNode(s)),a.nodeType===Node.TEXT_NODE?(a.parentElement.insertBefore(e,a),a.remove()):(a.innerHTML="",a.appendChild(e))}}return r}_handleMarkerSelection(e){const t=this,r=e.selectedValues[0],n=t.$.editableElement.querySelectorAll(`.find-and-replace-match.selected, .find-and-replace-match[match-id="${r}"]`);let o;for(let e=0,t=n.length;e<t;e+=1){const t=n[e];t.getAttribute("match-id")===r?(t.classList.add("selected"),o=t):t.classList.remove("selected")}o&&t._scrollToMarker(o);const a=t._windowEditors,i=a?a.findandreplace:void 0,s=i?i.querySelector('.smart-editor-window-editor[type="results"] label'):void 0;if(s){const t=e.selectedIndexes;s.setAttribute("selected",t.length?t[0]+1:0)}}_handleImageInsert(e){const t=this,r=t._getItemOptionsViaWindow(e),n=t.$.window;if(!n)return;let o,a,i,s,l,d=n._target.itemTarget;if(r.file.length?(s=r.file[0],o=URL.createObjectURL(s)):r.url&&(o=r.url+""),!o&&r)return t._focusFirstInputCallback(e.name,"url");if("markdown"===t.editMode)return a=r.title?` "${r.title}"`:"",void t._insertMarkDown(`![${r.alt}](${o}${a})`);const m=t.$.iframe,c=t.$.editableElement,u=m?m.contentDocument:document;if(!d||"img"!==d.nodeName.toLowerCase()){const e=t.id+"newImage"+Math.random().toString(36).substr(2,5);l=u.execCommand("insertHTML",!1,`<img id="${e}"></img>`),d=c.querySelector("#"+e)}if(d&&"img"===d.nodeName.toLowerCase()){const e="inline"===r.display.toLowerCase()?"inline":"block",n=r.width+"",a=r.height+"";if(t._handleImgCaption(d,r),l&&(d.id=""),URL.revokeObjectURL(d.src),d.src=o,s&&(d.file=s,"base64"===t.imageFormat)){const e=new FileReader;e.readAsDataURL(s),e.onload=()=>d.src=e.result}if(t.uploadUrl&&t._fileUpload&&(d.name=o.replace(t.uploadUrl+"/",""),!t.autoUpload)){const e=e=>{t.$.fireEvent("imageUploadSuccess",e.detail);const r=e.detail.fileURL,n=e.detail.serverResponse;r?d.src=r:n&&(Array.isArray(n)?e.detail.serverResponse[0].file_url?d.src=e.detail.serverResponse[0].file_url:e.detail.serverResponse[0].fileURL&&(d.src=e.detail.serverResponse[0].fileURL):e.detail.serverResponse.file_url?d.src=e.detail.serverResponse.file_url:e.detail.serverResponse.fileURL&&(d.src=e.detail.serverResponse.fileURL))};t._fileUpload.onuploadcompleted=e,t._fileUpload.onuploaderror=e=>{console.error(e.detail)},t._fileUpload.uploadAll()}if(d.removeAttribute("width"),d.removeAttribute("height"),d.style.width=n&&"auto"!==n?parseFloat(n)+(n.indexOf("%")>-1?"%":"px"):"",d.style.height=a&&"auto"!==a?parseFloat(a)+(a.indexOf("%")>-1?"%":"px"):"",r.alt&&(d.alt=r.alt),r.title&&(d.title=r.title),r.alignment){const e=r.alignment.toLowerCase();i=e.indexOf("left")>-1?"left":e.indexOf("right")>-1?"right":"center"}d.setAttribute("resizable",r.resizable),d.setAttribute("draggable",r.draggable);const m=d.closest(".smart-editor-image-container");m?(m.setAttribute("alignment",i),m.setAttribute("display",e),d.removeAttribute("alignment"),d.removeAttribute("display")):(d.setAttribute("alignment",i),d.setAttribute("display",e))}}_handleVideoInsert(e){const t=this,r=t._getItemOptionsViaWindow(e),n=t.$.window;if(!n)return;let o,a,i,s,l=n._target.itemTarget;if(r.file.length?(i=r.file[0],o=URL.createObjectURL(i),l&&"video"!==l.nodeName.toLowerCase()&&(l.remove(),l=void 0)):(r.src||r.videoUrl)&&(o=(r.src||r.videoUrl)+"",l&&"iframe"!==l.nodeName.toLowerCase()&&(l.remove(),l=void 0)),l&&l.file&&(i=l.file),!o&&!i&&r)return t._focusFirstInputCallback(e.name,"src");if("markdown"===t.editMode)return a=r.title?` "${r.title}"`:"",void t._insertMarkDown(`[![${r.alt}](${o||r.thumbnail||""})](${r.videoUrl} ${a})`);const d=t.$.iframe,m=t.$.editableElement,c=d?d.contentDocument:document;if(!i||l&&"video"===l.nodeName.toLowerCase()){if(!(i||l&&"iframe"===l.nodeName.toLowerCase())){const e=t.id+"newVideo"+Math.random().toString(36).substr(2,5);s=c.execCommand("insertHTML",!1,`<iframe id="${e}" frameborder="0" allowfullscreen></iframe>`),l=m.querySelector("#"+e)}}else{const e=t.id+"newVideo"+Math.random().toString(36).substr(2,5);s=c.execCommand("insertHTML",!1,`<video id="${e}"></video>`),l=m.querySelector("#"+e)}if(l){if(s&&l.removeAttribute("id"),URL.revokeObjectURL(l.src),l.controls=!0,l.frameborder=0,l.allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture",t._handleVideoCaption(l,r),void 0!==r.width){const e=r.width+"";l.style.width=e?e+(e.indexOf("%")<0?"px":""):""}if(void 0!==r.height){const e=r.height+"";l.style.height=e?e+(e.indexOf("%")<0?"px":""):""}if(i){if(l.file===i)return;if(l.file=i,"base64"===t.imageFormat){const e=new FileReader;e.readAsDataURL(i),e.onload=()=>l.src=e.result}}else l.src!==o&&(l.src=o)}}_insertMarkDown(e,t,r){const n=this;if("markdown"!==n.editMode)return;const o=n.$.input,a=n._getSelectionRange(),i=a.selectionStart,s=a.selectionEnd;let l,d=o.value;if(void 0!==i&&i!==s&&(l=d.slice(i,s)),r){let t=d.lastIndexOf("\n",i-1)+1;for(;" "===d[t+1];)t++;o.value=d.slice(0,t)+e+d.slice(t)}else o.value=d.slice(0,o.selectionStart)+e+d.slice(o.selectionEnd);void 0!==i&&(void 0===t&&(t=i+e.length),l?r?n._setSelectionRange(o,i+e.length,s+e.length):(d=o.value,o.value=d.slice(0,t)+l+d.slice(t),n._setSelectionRange(o,t,t+l.length)):n._setSelectionRange(o,t,t)),n._refreshMarkdownPreview()}_removeMarkDown(e,t,r){const n=this,o=n.$.input,a=o.value,i=n._getSelectionRange(),s=i.selectionStart,l=i.selectionEnd,d=e.length;o.value=a.slice(0,t)+a.slice(t+d),n._setSelectionRange(o,s-d,l-d),r||n._refreshMarkdownPreview()}_handleLinksInsert(e){const t=this,r=t.$.window,n=t.editMode,o=t._getItemOptionsViaWindow(e);if(!o.address)return t._focusFirstInputCallback(e.name,"address");if("markdown"===n){let e;return e=o.title?`[${o.text}](${o.address}, "${o.title}")`:`[${o.text}](${o.address})`,void t._insertMarkDown(e)}const a=t.$.iframe,[i,s]=a?[a.contentDocument,a.contentWindow]:[document,window],l=s.getSelection();let d,m,c=l.anchorNode?l.anchorNode.parentElement:void 0,u=r&&r._target?r._target.itemTarget:void 0;u&&"img"===u.nodeName.toLowerCase()?(d=r._target.itemTarget,c=d.parentElement,c&&"a"===c.nodeName.toLowerCase()||(c=document.createElement("a"),d.parentElement.insertBefore(c,d),c.appendChild(d))):c=l.anchorNode?l.anchorNode.parentElement:void 0,o.address&&"a"!==c.nodeName.toLowerCase()&&(m=i.execCommand("createLink",!1,o.address),c=l.anchorNode.parentElement),"a"===c.nodeName.toLowerCase()&&(o.address?m||c.setAttribute("href",o.address):c.setAttribute("href",""),o.text?c.textContent=o.text:c.innerHTML||(c.textContent=o.address||""),c.title=o.title||"",c.target=o.target||"",d||l.selectAllChildren(c))}_refreshMarkdownPreview(){const e=this,t=e.$.input;if(e.$.contentContainer.hasAttribute("split-mode")){let r=t.value;e.$.editableElement.innerHTML=window.marked?window.marked(r):r}}_handleImgCaption(e,t){const r=this;if(!t)return;let n,o=e.closest(".smart-editor-image-container");const a=e.nodeName.toLowerCase(),i="video"===a||"iframe"===a&&e.src.indexOf("/embed")>-1;if(t.caption||i){if(o||(o=document.createElement("span"),o.classList.add("smart-editor-image-container"),o.setAttribute("draggable",!1),o.setAttribute("contenteditable",!1),e.hasAttribute("alignment")&&o.setAttribute("alignment",e.getAttribute("alignment")),e.hasAttribute("display")&&o.setAttribute("display",e.getAttribute("display")),e.parentElement.insertBefore(o,e),o.appendChild(e)),o.classList[i?"add":"remove"]("smart-editor-video-container"),n=o.querySelector(".smart-editor-image-caption"),n||(n=document.createElement("span"),n.setAttribute("contenteditable",!0),n.classList.add("smart-editor-image-caption"),o.appendChild(n)),n.textContent=t.caption,t.focusCaption)return delete r._toolbarItemClick,r._setSelectionRange(n),r._setResizeFrame(),void r.$.editableElement.scrollTo(n.offsetLeft,n.offsetTop)}else!t.caption&&o&&(o.hasAttribute("alignment")&&e.setAttribute("alignment",o.getAttribute("alignment")),o.hasAttribute("display")&&e.setAttribute("display",o.getAttribute("display")),o.parentElement.insertBefore(e,o),o.remove());r._resizeFrameObj&&r._resizeFrameObj.target&&r._setResizeFrame(r._resizeFrameObj.target,!0)}_handleVideoCaption(e,t){const r=this,n=e?e.nodeName.toLowerCase():void 0;if(!t||"video"!==n&&"iframe"!==n)return;let o=e.closest(".smart-editor-video-container");if(o||(o=document.createElement("span"),o.classList.add("smart-editor-image-container","smart-editor-video-container"),o.setAttribute("contenteditable",!1),e.parentElement.insertBefore(o,e),o.appendChild(e)),o.setAttribute("resizable",t.resizable),!1===t.draggable?o.setAttribute("draggable",!1):o.removeAttribute("draggable"),t.title&&(e.title=t.title),t.alignment){let e=t.alignment.toLowerCase();e=e.indexOf("left")>-1?"left":e.indexOf("right")>-1?"right":"center",o.setAttribute("alignment",e)}if(t.display){const e="inline"===t.display.toLowerCase()?"inline":"block";o.setAttribute("display",e)}if(t.caption){let e=o.querySelector(".smart-editor-image-caption");if(e||(e=document.createElement("span"),e.setAttribute("contenteditable",!0),e.classList.add("smart-editor-image-caption"),o.appendChild(e)),e.textContent=t.caption,t.focusCaption)return delete r._toolbarItemClick,r._setSelectionRange(e),r._setResizeFrame(),void r.$.editableElement.scrollTo(e.offsetLeft,e.offsetTop)}else if(!t.caption){let e=o.querySelector(".smart-editor-image-caption");e&&e.remove()}r._resizeFrameObj&&r._resizeFrameObj.target&&r._setResizeFrame(r._resizeFrameObj.target,!0)}_handleTableInsert(e){const t=this,r=t.editMode;if(!e)return;if("markdown"===r)return void t._insertTableMarkdown(e);const n=t._getSelectionRange();let o,a,i,s;if(e.cells){const t=e.cells;[i,s]=[t[1],t[0]]}else{let t=n.startContainer;[i,s]=[parseInt(e.cols),parseInt(e.rows)],t.nodeType===Node.TEXT_NODE&&(t=t.parentElement),o=t&&t.closest&&t.closest(".smart-editor-editable table")}if(!o){const e=t.$.editableElement,r=t.$.iframe,i=(r?r.contentWindow:window).getSelection();i.removeAllRanges(),i.addRange(n);const s=t.id+"newTable"+Math.random().toString(36).substr(2,5);a=(r?r.contentDocument:document).execCommand("insertHTML",!1,`<table id="${s}"><tbody></tbody></table>`),o=e.querySelector("#"+s)}if(o&&"table"===o.nodeName.toLowerCase()){let r,n=o.querySelector("tbody");for(n?r=Array.from(n.children):(o.innerHTML="<tbody></tbody>",n=o.firstElementChild,r=[]);r.length>s;)r.pop().remove();for(let e=r.length,t=s;e<t;e+=1)r.push(document.createElement("tr"));for(let e=0,t=r.length;e<t;e+=1){const t=r[e],o=Array.from(t.children);for(;o.length>i;)o.pop().remove();for(let e=0,r=i;e<r;e+=1){let r=o[e];r||(r=t.appendChild(document.createElement("td")))}t.parentElement||n.appendChild(t)}void 0===e.tableheader?e.tableheader=!!o.querySelector("th"):void 0===e.altrows?e.altrows=o.hasAttribute("alternation"):void 0===e.dashedborders?e.dashedborders=o.hasAttribute("dashed-borders"):void 0===e.resizable&&(e.resizable="false"!==o.getAttribute("resizable")),t._handleTableHeader(o,e.tableheader),e.altrows?o.setAttribute("alternation",""):o.removeAttribute("alternation"),e.dashedborders?o.setAttribute("dashed-borders",""):o.removeAttribute("dashed-borders");const l=e.width,d=e.height;o.style.width=l?l+(l.indexOf("%")<0?"px":""):"",o.style.height=d?d+(d.indexOf("%")<0?"px":""):"",a&&o.removeAttribute("id"),o.setAttribute("aria-rowcount",s),o.setAttribute("aria-colcount",i),o.setAttribute("resizable",e.resizable)}t._setResizeFrame(o)}_insertTableMarkdown(e){const t=this,r=e.cells,[n,o]=r?[r[1],r[0]]:[parseInt(e.cols),parseInt(e.rows)],a=t.localize("alphabet"),i=t.localize("header"),s=t.localize("column");let l="";if(!1!==e.tableheader){let e="",t=Math.max(3,i.length)+3;for(;t>0;)e+="-",t--;for(let e=1;e<=n;e+=1)l+=`| ${i} ${e} `;l+="|\n";for(let t=0;t<n;t++)l+=`|${e} `;l+="|\n"}for(let e=0;e<o;e++){const t=a[Math.max(0,e-1)%a.length].toUpperCase();for(let e=1;e<=n;e+=1)l+=`| ${s} ${t} ${e} `;l+="|\n"}t._insertMarkDown(l)}_handleTableSelection(e){const t=this,r=t.$.editableElement;if(t._tableCell&&t._tableCell.removeAttribute("selected"),"false"!==r.getAttribute("contenteditable"))return e&&["th","td"].indexOf(e.nodeName.toLowerCase())>-1?(t._tableCell=e,void e.setAttribute("selected","")):void delete t._tableCell}_getItemOptionsViaWindow(e){const t=this._windowEditors[e.name];if(!t)return;const r=t.children;let n={};for(let e=0,t=r.length;e<t;e+=1){const t=r[e].getAttribute("type"),o=r[e].querySelector("[item-editor]");let a;if(t){if(o instanceof Smart.Input)if(void 0===o.$.input.dataValue&&o.dataSource&&o.dataSource.length){const e=o.dataSource[0];a="string"==typeof e?e:e.value||e.label}else a=o.$.input.dataValue||o.value;else o instanceof Smart.CheckBox||o instanceof Smart.RadioButton?a=o.checked:o instanceof Smart.FileUpload?a=o.value:o instanceof Smart.ListBox&&(a=o.selectedIndexes);n[t]=a}}return n}_closeToolbarItemDropDown(e){const t=this,r=()=>{e.opened||e.remove()};e&&(e.opened?(e.hasAnimation&&(e.removeEventListener("transitionend",r),e.addEventListener("transitionend",r,{once:!0})),e.close(),t._setAriaOwns(e)):r())}_openToolbarItemDropDown(e,t){const r=this,n=e.getBoundingClientRect();r._setupDropDown(e,t),t.style.width=n.width+"px",t.style.height=n.height+"px",e.contains(t)||e.appendChild(t),t.open(),r._setAriaOwns(t),r._setAriaControls(e,t)}_setupDropDown(e,t){const r=this,n=r.$.inlineToolbar,o=n&&n.contains(e)?r._inlineToolbarItemsObj:r._toolbarItemsObj,a=o?o[e.getAttribute("item-name")]:void 0;let i;if(a&&(i=a.dataSource),i||(i=[]),t instanceof Smart.ColorInput?t.dropDownClassList=["smart-editor-color-input"]:(t.dropDownClassList=["smart-editor-input"],t.dropDownHeight=310),t.classList.add("smart-editor-item-drop-down"),t.readonly=!0,t.dataSource=i,t.dropDownOpenMode="manual",t.dropDownButtonPosition=r.rightToLeft?"left":"right",void 0!==a.value){const e=a.name;t.value=e.indexOf("table")>-1||e.indexOf("paste")>-1?"":a.value+""}else t.value=""}_toggleToolbar(e){const t=this,r=t.$.toolbar,n=t.$.contentContainer,o=t.toolbarViewMode,a="toggle"===o,i=t.$.toolbarToggleButton,s=t.$.toolbarItemsPrimary,l=t.hasAnimation;r.style.transition=l&&a?"none":"",r.style.height="";const d=r.offsetHeight,m=n.offsetHeight;if(e&&"toggle"===o){if(i.removeAttribute("checked"),i.setAttribute("aria-pressed",!1),!r.hasAttribute("expanded"))return void(r.style.transition="");r.removeAttribute("expanded")}else{if(i.setAttribute("checked",""),i.setAttribute("aria-pressed",!0),r.hasAttribute("expanded"))return r.style.transition="",void(t.$.toolbarItemsSecondary.innerHTML&&t._refreshToolbarItems());"scroll"!==o?r.setAttribute("expanded",""):r.removeAttribute("expanded")}if(t._refreshToolbarItems(),"menu"!==t.toolbarMode){if(r.hasAttribute("expanded")){s.querySelector(".smart-editor-toolbar-tab[checked]")||t._selectToolbarTab(s.firstElementChild),t._toggleSecondaryToolbar(!0)}else t._selectToolbarTab(null),t._toggleSecondaryToolbar();return}if(!a)return;const c=r.offsetHeight,u=t.$.inlineToolbar;u&&u.visible&&u.reposition(),t._resizeFrameObj&&t._setResizeFrame(t._resizeFrameObj.target),r.style.height=d+"px",n.style.height=m+"px",l?requestAnimationFrame((()=>{r.style.transition="",r.style.height=c+"px",n.style.height=m+d-c+"px",requestAnimationFrame((()=>r.style.height=n.style.height=""))})):(r.style.transition="",r.style.height=c+"px",n.style.height=m+d-c+"px",requestAnimationFrame((()=>r.style.height=n.style.height="")))}_predefPropertyGetter(e="value"){const t=this;Object.defineProperty(t,e,{get:function(){return t.context===t?t.properties[e].value:t._getCurrentValue()},set(r){t._properties[e].value=t._getCurrentValue(),t.updateProperty(t,t._properties[e],r)}})}_getCurrentValue(){const e=this;if("markdown"===e.editMode)return e.$.input.value;let t=e.$.editableElement.innerHTML;return e.enableHtmlEncode&&(t=t.replaceAll("<","&lt;").replaceAll(">","&gt;")),t}_getInputValue(e,t){const r=this.$.input;return void 0===e&&(e=r.value),e=!t&&this.enableHtmlEncode?e.replaceAll("<","&lt;").replaceAll(">","&gt;"):e.replaceAll("&lt;","<").replaceAll("&gt;",">")}_handleEditMode(e){const t=this,r=t.$.input,n=t.$.editableElement,o=t.editMode,a=t._toolbarItemsObj.sourcecode,i=!!a&&a.value;t._closePopups(),"html"===e?i?r.value=n.innerHTML:n.innerHTML=r.value:"markdown"===e&&(i?n.innerHTML=window.marked?window.marked(r.value):r.value:r.value=n.textContent,t._closeSearchToolbar()),t.$.contentContainer.hasAttribute("split-mode")||("markdown"===o?i?(r.classList.add("smart-hidden"),n.classList.remove("smart-hidden")):(r.classList.remove("smart-hidden"),n.classList.add("smart-hidden")):i?(r.classList.remove("smart-hidden"),n.classList.add("smart-hidden")):(r.classList.add("smart-hidden"),n.classList.remove("smart-hidden"))),t.readonly||t.disableEditing||t.$.editableElement.setAttribute("contenteditable","markdown"!==o)}_handleInputContent(e,t){const r=this,n=r.$.editableElement,o=r.$.input,a=r.editMode;if(!r.isRendered&&r.autoLoad){const e=window.localStorage.getItem("smartEditor"+r.id);e&&r.set("value",e)}const i=r.value;void 0===t&&i&&(t=i),void 0!==t?"html"===a?r.$.editableElement.innerHTML=t:r.$.input.value=t:t||"markdown"!==a||(r.$.input.value=r.$.editableElement.textContent),r.$.contentContainer.hasAttribute("split-mode")?"markdown"===a?n.innerHTML=window.marked?window.marked(o.value):o.value:o.value=n.innerHTML.trim():r.classList.contains("preview-mode")&&("markdown"===a?n.innerHTML=window.marked?window.marked(o.value):o.value:o.value=n.innerHTML),n.textContent.length&&n.innerText.length?(n.removeAttribute("show-placeholder"),r._handleContentFiltering()):n.setAttribute("show-placeholder",""),r._clearSearchToolbar()}_sanitize(e,t){return this.sanitized?t.replaceAll(/(<[\/]?script[>]?)|([on].*=['"`]?.*['"`]?)|(SRC=['"`]?javascript:['"`]?)/gim,""):t}_handleContentFiltering(){const e=this,t=e.contentFiltering;if("html"===!e.editMode)return;const r=t.tags.map((e=>e.trim())),n=t.attributes.map((e=>e.trim())),o=t.styleAttributes.map((e=>e.trim()));if(!r.length&&!n.length&&!o.length)return;const a=t.tagFilterMode,i=t.attributeFilterMode,s=t.styleAttributeFilterMode;let l=e.$.editableElement.innerHTML;if(r.length){const e=new RegExp(/<\s*\/?\s*([a-z0-9]+).*?>/,"gmi");let t,n=[];for(;null!==(t=e.exec(l));){const e=t[1],o=r.indexOf(e)>-1;(o&&"blackList"===a||!o&&"whiteList"===a)&&n.push(t[0])}n.forEach((e=>l=l.replace(e,"")))}e.$.editableElement.innerHTML=l;const d=e.$.editableElement.querySelectorAll("*");for(let e=0,t=d.length;e<t;e+=1){const t=d[e];if(n.length){const e=Array.from(t.attributes);for(let r=0,o=e.length;r<o;r+=1){const o=e[r].name,a=n.indexOf(o)>-1;(a&&"blackList"===i||!a&&"whiteList"===i)&&t.removeAttribute(o)}}if(o.length){const e=t.getAttribute("style");if(!e)continue;const r=e.split(";");let n=[];for(let e=0,t=r.length;e<t;e+=1){const t=r[e],a=t.indexOf(":"),i=o.indexOf(t.slice(0,a>0?a:void 0))>-1;(i&&"whiteList"===s||!i&&"blackList"===s)&&n.push(t)}r.length&&(n.length?t.setAttribute("style",n.join(";")):t.removeAttribute("style"))}}e._setCharCount()}_handleContextMenuItemClick(e,t){if(!t||!t.classList.contains("smart-editor-context-menu-item"))return;const r=this,n=r.$.inlineToolbar,o=t.getAttribute("value");if(!n)return;const a=n.selector;switch(o){case"imageProperties":r._openWindow({name:"image"},a.closest(".smart-editor-editable img"));break;case"linkProperties":r._openWindow({name:"hyperlink"});break;case"tableProperties":r._openWindow({name:"table"},a.closest(".smart-editor-editable table"));break;case"videoProperties":{const e=a.closest(".smart-editor-video-container");if(e){const t=e.querySelectorAll(".smart-editor-video-container > video, .smart-editor-video-container > iframe");r._openWindow({name:"video"},t[0]||t[1])}break}case"insertRowAfter":case"insertRowBefore":case"deleteRow":r._handleTableRows(a.closest(".smart-editor-editable table"),{value:o});break;case"insertColumnLeft":case"insertColumnRight":case"deleteColumn":r._handleTableColumns(a.closest(".smart-editor-editable table"),{value:o});break;case"deleteImage":case"deleteTable":{const e=r._resizeFrameObj?r._resizeFrameObj.target:void 0;e&&r._deleteResizeFrameTarget(e);break}case"deleteVideo":{const e=a.closest(".smart-editor-video-container");if(e){const t=r._resizeFrameObj?r._resizeFrameObj.target:void 0;if(t===e){r._deleteResizeFrameTarget(t);break}e.remove()}break}case"createLink":r._openWindow({name:"hyperlink"},a.closest(".smart-editor-editable img"));break;case"deleteLink":r._handleLinkRemove(a);break;case"copyImage":r._handleImageCopy(a.closest(".smart-editor-editable img"));break;case"cutImage":r._handleImageCut(a.closest(".smart-editor-editable img"));break;case"copyVideo":r._handleImageCopy(a.closest(".smart-editor-video-container"));break;case"cutVideo":r._handleImageCut(a.closest(".smart-editor-video-container"));break;case"copy":case"cut":case"paste":r._handleClipboardAction(o);break;case"caption":{const e=a.closest(".smart-editor-editable img");let t;if(e&&"img"===e.nodeName.toLowerCase()){const n=e.closest(".smart-editor-image-container");n&&n.querySelector(".smart-editor-image-caption")||(t=r.localize("captionPlaceholder")),r._handleImgCaption(e,{caption:t,focusCaption:!0})}else if(a.classList.contains("smart-editor-video-container")){const e=a.querySelectorAll(".smart-editor-video-container > video, .smart-editor-video-container > iframe");a.querySelector(".smart-editor-image-caption")||(t=r.localize("captionPlaceholder")),r._handleVideoCaption(e[0]||e[1],{caption:t,focusCaption:!0})}break}case"selectAll":r._selectAll()}r.$.fireEvent("contextMenuItemClick",{originalEvent:e,value:o}),r._closeContextMenu()}_handleImageCopy(e){const t=this;if(!e||"img"!==e.nodeName.toLowerCase()&&!e.classList.contains("smart-editor-video-container"))return;const r=t._createWhiteSpaceChar(e,e.classList.contains("smart-editor-video-container")?e:void 0);t._setSelectionRange(e),t.$.editableElement.getRootNode().execCommand("copy"),r&&r.remove()}_handleImageCut(e){const t=this;if(!e||"img"!==e.nodeName.toLowerCase()&&!e.classList.contains("smart-editor-video-container"))return;const r=t._createWhiteSpaceChar(e,e.classList.contains("smart-editor-video-container")?e:void 0);t._setSelectionRange(e),t.$.editableElement.getRootNode().execCommand("cut"),t._setResizeFrame(),r&&r.remove()}_createWhiteSpaceChar(e,t){if(!t)return;const r=document.createElement("span");return r.innerHTML="&nbsp;",r.classList.add("smart-editor-video-white-space"),e.appendChild(r),r}_handleInputElement(){const e=this,t=e.iframeSettings,r=e.$.contentContainer,n=e.$.container,o=e.$.editableElement,a=e.$.input,i=e.readonly,s=e.disableEditing;if(o.contentEditable=!i&&!s,a.readonly=i||s,e._handlePlaceholder(),e._closePopups(),t.enabled?e._handleIframeSettings():n.contains(r)||(n.appendChild(r),o.setAttribute("contenteditable",!0),e.$.iframe&&(e.$.iframe.remove(),e._removeIframeEventListeners(),delete e.$.iframe)),"markdown"===e.editMode){const t=e.$.editableElement;e.$.input.classList.remove("smart-hidden"),t.classList.add("smart-hidden")}}_handleToolbarMode(){const e=this,t=e.$.toolbar,r=e.$.toolbarItemsSecondary,n=e.toolbarMode;e.$.toolbarItemsPrimary.innerHTML=r.innerHTML="","menu"===n?(r.classList.remove("smart-drop-down"),r.style.top=r.style.height="",t.contains(r)||t.appendChild(r),e._refreshToolbarItems(e._getToolbarItems())):(e._setToolbarTabs(),e._setToolbarItemGroups(),e._toolbarItemsObj||(e._toolbarItemsObj={}),e._refreshToolbarItems()),e._setToolbarGroupHeight()}_setToolbarTabs(){const e=this,t=e.toolbarRibbonConfig,r=e.$.toolbarToggleButton,n=e.$.toolbarItemsPrimary,o=n.querySelectorAll(".smart-editor-toolbar-tab"),a=document.createDocumentFragment();let i;for(let r=0,n=t.length;r<n;r+=1){const n=t[r];let s=o[r];s||(s=document.createElement("div")),s.classList.add("smart-editor-toolbar-tab"),s.setAttribute("tab-name",n.name),s.textContent=e.localize(n.name),!i&&s.hasAttribute("checked")&&(i=s),i!==s&&s.removeAttribute("checked"),s.classList[n.hidden?"add":"remove"]("smart-hidden"),a.appendChild(s)}r.hasAttribute("checked")&&!i&&a.children[0].setAttribute("checked",""),n.appendChild(a)}_setToolbarItemGroups(){const e=this,t=e.toolbarRibbonConfig,r=Array.from(e.$.toolbarItemsPrimary.querySelectorAll(".smart-editor-toolbar-tab")).find((e=>e.hasAttribute("checked")));if(!t||!r)return;const n=r.getAttribute("tab-name"),o=t.find((e=>e.name===n)),a=o?o.groups:null,i=e.$.toolbarItemsSecondary,s="singleLineRibbon"===e.toolbarMode;if(i.innerHTML="",!Array.isArray(a))return;const l=i.querySelectorAll(".smart-editor-toolbar-tab-group"),d=document.createDocumentFragment();for(let t=0,r=a.length;t<r;t+=1){const r=a[t],n=r.name;let o=l[t];if(o||(o=document.createElement("div")),s)o.innerHTML="",o.appendChild(e._getToolbarItems(e.$.toolbar,r.items));else{o.innerHTML='<div class="smart-editor-tab-group-container"></div><div class="smart-editor-tab-group-label"></div>';const t=o.firstElementChild;o.lastElementChild.innerHTML=e.localize(n),t.appendChild(e._getToolbarItems(e.$.toolbar,r.items))}o.classList.add("smart-editor-toolbar-tab-group"),o.setAttribute("group-name",n),d.appendChild(o)}i.appendChild(d),i.classList.remove("smart-visibility-hidden"),e._refreshToolbarTabs()}_refreshToolbarTabs(){const e=this,t=e._resizeFrameObj,r=Array.from(e.$.toolbarItemsPrimary.children).find((e=>"layouttab"===(e.getAttribute("tab-name")||"").toLowerCase()));if(!r)return;if(!t||!t.target||"singleLineRibbon"!==e.toolbarMode)return r.classList.add("smart-hidden"),void(r.hasAttribute("checked")&&e._selectToolbarTab(e.$.toolbarItemsPrimary.firstElementChild));const n=e.$.toolbarItemsSecondary.children,o=t.target,a=o.nodeName.toLowerCase();let i,s,l;for(let e=0,t=n.length;e<t;e+=1){const t=n[e],r=t.getAttribute("group-name");"tableGroup"===r?(s=t,s.classList.add("smart-hidden")):"imageGroup"===r?(i=t,i.classList.add("smart-hidden")):"videoGroup"===r&&(l=t,l.classList.add("smart-hidden"))}"table"===a?(r.classList.remove("smart-hidden"),s&&s.classList.remove("smart-hidden")):"img"===a?(r.classList.remove("smart-hidden"),i&&i.classList.remove("smart-hidden")):o.classList.contains("smart-editor-video-container")?(r.classList.remove("smart-hidden"),l&&l.classList.remove("smart-hidden")):r.classList.add("smart-hidden")}_handlePlaceholder(){const e=this.$.editableElement,t=this.placeholder;t?e.setAttribute("placeholder",t):e.removeAttribute("placeholder")}_handleIframeSettings(){const e=this;if(!e.iframeSettings.enabled)return;(()=>{let t=e.$.iframe;t||(t=e.$.iframe=document.createElement("iframe")),t.onload=()=>{e._handleIframeBody(),e._handleIframeAttributes(),e._handleIframeResources()},t.parentElement||e.$.container.appendChild(t),!t.contentWindow.marked&&window.marked&&(t.contentWindow.marked=window.marked)})()}_removeIframeEventListeners(){const e=this,t=e.$.iframe.contentDocument,r=e.$iframe;r&&(r.unlisten("down"),r.unlisten("move"),r.unlisten("up")),t.removeEventListener("dragstart",e._iframeDragStartHandler),t.removeEventListener("dragend",e._iframeDragEndHandler),t.removeEventListener("selectionchange",e._iframeSelectionChangeHandler)}_handleIframeBody(){const e=this,t=e.$.iframe.contentDocument,r=t.body;if(!r)return;let n=e.$iframe;r.classList.add("smart-editor","smart-element","smart-editor-iframe-body"),r.appendChild(e.$.contentContainer),e._updateIframeBody(),n||(n=e.$iframe=Smart.Utilities.Extend(r)),e._iframeDownHandler=t=>e._documentDownHandler.call(e,t),e._iframeMoveHandler=t=>e._documentMoveHandler.call(e,t),e._iframeUpHandler=t=>e._documentUpHandler.call(e,t),e._iframeDragStartHandler=t=>e._dragStartHandler.call(e,t),e._iframeDragEndHandler=t=>e._dragEndHandler.call(e,t),e._iframeSelectionChangeHandler=t=>e._selectionChangeHandler.call(e,t),e._removeIframeEventListeners(),n.listen("down",e._iframeDownHandler),n.listen("move",e._iframeMoveHandler),n.listen("up",e._iframeUpHandler),t.addEventListener("dragstart",e._iframeDragStartHandler),t.addEventListener("dragend",e._iframeDragEndHandler),t.addEventListener("selectionchange",e._iframeSelectionChangeHandler)}_updateIframeBody(){const e=this,t=e.$.iframe;if(!t)return;const r=t.contentDocument.body;r&&(e.rightToLeft?r.setAttribute("right-to-left",""):r.removeAttribute("right-to-left"),e.theme?r.setAttribute("theme",e.theme):r.removeAttribute("theme"),r.setAttribute("animation",e.animation))}_handleIframeAttributes(){const e=this,t=e.$.iframe,r=e.iframeSettings.attributes;if(!t)return;if(t.hasAttribute("title")||t.setAttribute("title",e.localize("iframeTitle")),!r||"object"!=typeof r)return;const n=e.$.editableElement;for(let e in r){const o=r[e];"readonly"===e?n.setAttribute("contenteditable",!o):t[e]=o}}_handleIframeResources(){const e=this.iframeSettings.resources,t=this.$.iframe;if(!t||"object"!=typeof e)return;const r=document.styleSheets,n=t.contentDocument,o=n.head,a=n.body;for(let e in r){const n=r[e],o=n.ownerNode;"text/css"===n.type&&o&&["link","style"].indexOf(o.nodeName.toLocaleLowerCase())>-1&&t.contentDocument.head.appendChild(n.ownerNode.cloneNode())}for(let t in e){const r=t,n=e[t];let i;if((r+"").indexOf("style")>-1||"link"===r?(i=document.createElement("link"),i.rel="stylesheet",i.type="text/css","string"==typeof n&&(i.href=n)):"script"===r&&(i=document.createElement("script"),i.type="text/javascript","string"==typeof n&&(i.src=n)),"object"==typeof n&&"[object Object]"===n.toString())for(let e in n)i[e]=n[e];"module"===i.type?a.appendChild(i):o.appendChild(i)}}_handleMaxCharCount(){const e=this,t=e.$.input;null!==e.maxCharCount?t.maxLength=e.maxCharCount:t.removeAttribute("maxlength")}_getToolbarItems(e,t){const r=this;e||(e=r.$.toolbar),t||(t=r.toolbarItems);const n=e===r.$.toolbar?"toolbar":"inlineToolbar",o=e.querySelectorAll(".smart-editor-toolbar-item"),a=document.createDocumentFragment();for(let e=0,i=t.length;e<i;e+=1){const i=r._getToolbarItemDetails(n,t[e]),s=i.name,l=i.type;let d=o[e];if(d?"custom"===d.getAttribute("item-type")&&(d.innerHTML=""):(d=document.createElement("div"),d.classList.add("smart-editor-toolbar-item")),"color-input"===l)d.innerHTML||(d.innerHTML=`<div class="smart-editor-item-action-button" item-name="${s}"></div>\n                                               <div class="smart-editor-item-drop-down-button"></div>`);else if("custom"===l){const e=i.template;d.innerHTML="",e&&e.closest&&!d.contains(e)?d.appendChild(e):"string"!=typeof e||d.innerHTML?"function"==typeof e&&e(d,i):d.innerHTML=e||""}else"toggle"===l&&(i.value?(d.setAttribute("checked",""),d.setAttribute("aria-pressed",!0)):(d.removeAttribute("checked"),d.setAttribute("aria-pressed",!1)),d.innerHTML&&(d.innerHTML=""));i.disabled||"paste"===s&&r._isFireFox?(d.setAttribute("disabled",""),d.setAttribute("aria-disabled",!0)):(d.removeAttribute("disabled"),d.removeAttribute("aria-disabled")),d.setAttribute("role","delimiter"===l?"separator":"button"),"color-input"===l||"drop-down"===l?d.setAttribute("aria-haspopup",!0):d.removeAttribute("aria-haspopup"),r._setItemValue(d,i),i.title?d.setAttribute("title",i.title):d.removeAttribute("title"),d.setAttribute("item-name",s),d.setAttribute("item-type",l),d.style.width=i.width||"",a.appendChild(d)}return a}_setItemValue(e,t){const r=this;let n=t.value;e&&t&&("button"===t.type?n?(e.setAttribute("checked",""),e.setAttribute("aria-pressed",!0)):(e.removeAttribute("checked"),e.setAttribute("aria-pressed",!1)):(n||"color-input"!==t.type?["fontname","formats"].indexOf(t.name)>-1&&(n=r.localize(t.value)||t.label||t.value):n="transparent",n?(e.setAttribute("item-value",n),e.style.setProperty("--item-value",n)):(e.removeAttribute("item-value"),e.style.removeProperty("--item-value"))))}_refreshToolbarItems(e){const t=this,r=t.$.toolbar,n=t.$.toolbarToggleButton,o=t.$.toolbarItemsPrimary,a=t.$.toolbarItemsSecondary;if("menu"===t.toolbarMode){if(o.scrollTop=o.scrollLeft=0,e)o.appendChild(e);else{const e=Array.from(a.children),t=document.createDocumentFragment(),r=e.length;for(let n=0;n<r;n+=1)t.appendChild(e[n]);r>0&&o.appendChild(t)}if("toggle"===t.toolbarViewMode){const e=o.offsetHeight;if(r.hasAttribute("expanded")){let t=[];e:for(;o.scrollHeight>e;){const e=o.lastElementChild;if(!e)break e;t.push(e),e.remove()}t.reverse();for(let e=0,r=t.length;e<r;e+=1)a.appendChild(t[e])}else o.scrollHeight===e&&n.classList.add("smart-visibility-hidden")}}else n.classList.remove("smart-visibility-hidden")}_resizeHandler(e){const t=this,r=t.$.inlineToolbar;if(e.target===t){if("toggle"===t.toolbarViewMode){const e=t.$.toolbarItemsPrimary,r=t.$.toolbarItemsSecondary;t.$.toolbar.hasAttribute("expanded")&&t._refreshToolbarItems();const n=t.$.toolbarToggleButton;e.scrollHeight!==e.offsetHeight||r.children.length?n.classList.remove("smart-visibility-hidden"):n.classList.add("smart-visibility-hidden")}if("menu"===t.toolbarMode||t.$.toolbarItemsSecondary.classList.contains("smart-visibility-hidden")||t._setToolbarGroupHeight(),r&&r.visible){const e=r.selector;e.classList.contains("smart-editor-toolbar-item")&&e.offsetTop>=t.$.toolbar.offsetHeight?r.close():r.reposition()}t._positionWindow(),t._resizeFrameObj&&t._setResizeFrame(t._resizeFrameObj.target)}}_setToolbarItemAttr(e,t,r){const n=this,o=n.$.toolbar,a=n.$.inlineToolbar,i=[n._toolbarItemsObj,n._inlineToolbarItemsObj];for(let n=0,s=i.length;n<s;n+=1){const s=i[n],l=s?s[e]:void 0;if(l){const n=s==s?o:a;if(l[t]=r,!n||!n.parentElement)continue;const i=n.querySelector(`.smart-editor-toolbar-item[item-name="${e}"]`);if(!i)continue;null==r||!1===r?(i.removeAttribute(t),"disabled"===t&&i.removeAttribute("aria-disabled")):(i.setAttribute(t,r),"disabled"===t&&i.setAttribute("aria-disabled",!0))}}}_setToolbarVisibility(){const e=this,t=e.$.toolbar,r=e.$.toolbarToggleButton;"toggle"!==e.toolbarViewMode||r.hasAttribute("checked")?t.setAttribute("expanded",""):t.removeAttribute("expanded")}_getToolbarItemDetails(e,t){const r=this;let n,o=r[`_${e}ItemsObj`];if(n="string"==typeof t?t:"object"==typeof t&&t.name?t.name+"":"",n=n.trim().toLowerCase(),o){if(void 0!==o[n])return o[n]}else o=r[`_${e}ItemsObj`]={};const a=o[n]={};return a.title=t.title||r.localize(n),a.name=n,a.toolbarName=e,a.advanced=!!t.advanced,a.inlineToolbarItems=t.inlineToolbarItems,r._setItemType(t,a,n),r._setItemData(t,a,n),r._setItemTemplate(t,a,n),r._setItemSpecifics(t,a,n),a}_setItemType(e,t,r){let n;if(t){switch(r){case"sourcecode":case"splitmode":case"fullscreen":n="toggle";break;case"alignment":case"fontname":case"fontsize":case"formats":case"tablerows":case"tablecolumns":case"tablevalign":case"tablestyle":n="drop-down";break;case"backgroundcolor":case"fontcolor":n="color-input";break;case"bold":case"italic":case"underline":case"strikethrough":case"delete":case"redo":case"undo":case"indent":case"outdent":case"openlink":case"editlink":case"createlink":case"removelink":case"hyperlink":case"cut":case"copy":case"image":case"video":case"lowercase":case"uppercase":case"print":case"caption":case"clearformat":case"table":case"tableheader":case"orderedlist":case"unorderedlist":case"subscript":case"superscript":case"findandreplace":n="button";break;case"paste":n=t.advanced?"drop-down":"button";break;default:n="string"==typeof e?"delimiter":"custom"}t.type=n}}_setItemData(e,t,r){const n=this;let o,a;if(!t||!e)return;const i=t.type;let s=e.width;if("drop-down"===i||"color-input"===i){if("object"==typeof e&&(o=e.dataSource,void 0!==e.value&&(a=e.value+"")),o&&Array.isArray(o)||(o=n._getDefaultDataSource(r,t)),void 0===a&&("fontsize"===t.name&&(a=parseInt(window.getComputedStyle(n.$.editableElement).fontSize)),isNaN(a)&&o.length)){const e=o[0];a=e["alignment"===r?"value":"label"]||e}r.indexOf("table")>-1&&(a="")}void 0!==s&&("number"==typeof s?s+="px":(s+="",s.includes("%")||(s=parseFloat(e.width),s=isNaN(s)?"":s+"px"))),t.dataSource=o,t.value=a,t.disabled=!!e.disabled,t.width=s}_setItemSpecifics(e,t,r){if(!t||"object"!=typeof e)return;let n=e.editor,o=t.editor;if(o||(o=t.editor={}),!n)return;let a=[],i=[];switch(r){case"createlink":case"removelink":case"hyperlink":a=["address","text","target"];break;case"image":a=["allowedTypes","uploadUrl","removeUrl","path","display"],i=["draggable","resizable"];break;case"table":a=["cols","rows","tableheader"],i=["altrows","dashedborders","resizable"]}for(let e in n){let t=n[e];void 0!==t&&(a.indexOf(e)>-1?"display"===e?t="block"===t?"block":"inline":t+="":i.indexOf(e)>-1?t=!!t:"width"!==e&&"height"!==e||"string"==typeof t||(t+="px"),o[e]=t)}}_getDefaultDataSource(e,t){const r=this;let n=[];switch(e){case"alignment":n=[{label:r.localize("alignLeft"),value:"left",icon:"editor-icon"},{label:r.localize("alignCenter"),value:"center",icon:"editor-icon"},{label:r.localize("alignRight"),value:"right",icon:"editor-icon"}],t&&"toolbar"===t.toolbarName&&n.push({label:r.localize("alignJustify"),value:"justify",icon:"editor-icon"});break;case"display":n=[{label:r.localize("displayInline"),value:"inline"},{label:r.localize("displayBlock"),value:"block"}];break;case"fontname":["segoeUi","arial","georgia","impact","tahoma","timesNewRoman","verdana"].forEach((e=>{n.push({label:r.localize(e),value:e})}));break;case"fontsize":["8","10","12","14","18","24","36"].forEach((e=>{n.push({label:e,value:e})}));break;case"formats":["p","pre","blockquote","h1","h2","h3","h4"].forEach((e=>{n.push({label:r.localize(e),value:e})}));break;case"backgroundcolor":case"fontcolor":["#000000","#FFFFFF","#D50000","#E67C73","#F4511E","#F6BF26","#33B679","#0B8043","#039BE5","#3F51B5","#7986CB","#8E24AA","#616161",""].forEach((e=>{n.push({label:e,value:e})}));break;case"paste":n=[{label:r.localize("plainText"),value:"plainText"},{label:r.localize("keepFormat"),value:"keepFormat"},{label:r.localize("cleanFormat"),value:"cleanFormat"}];break;case"target":n=[{label:r.localize("linkBlankDescr"),value:"_blank"},{label:r.localize("linkSelfDescr"),value:"_self"},{label:r.localize("linkParentDescr"),value:"_parent"},{label:r.localize("linkTopDescr"),value:"_top"},{label:r.localize("linkCustomDescr"),value:""}];break;case"tablerows":n=[{label:r.localize("insertRowBefore"),value:"insertRowBefore",icon:"editor-icon"},{label:r.localize("insertRowAfter"),value:"insertRowAfter",icon:"editor-icon"},{label:r.localize("deleteRow"),value:"deleteRow",icon:"editor-icon"}];break;case"tablecolumns":n=[{label:r.localize("insertColumnLeft"),value:"insertColumnLeft",icon:"editor-icon"},{label:r.localize("insertColumnRight"),value:"insertColumnRight",icon:"editor-icon"},{label:r.localize("deleteColumn"),value:"deleteColumn",icon:"editor-icon"}];break;case"tablevalign":n=[{label:r.localize("alignTop"),value:"top"},{label:r.localize("alignMiddle"),value:"middle"},{label:r.localize("alignBottom"),value:"bottom"}];break;case"tablestyle":n=[{label:r.localize("dashedborders"),value:"dashedborders"},{label:r.localize("altrows"),value:"altrows"}]}return n}_setItemTemplate(e,t){let r=e.template;t&&(r?(r&&r.closest?r="content"in r?document.importNode(r.content,!0):r:"function"==typeof r?r=r.bind(this):"string"==typeof r&&(r=document.getElementById(r)||r),t.template=r):delete t.template)}_setAriaSettings(){const e=this,t=e.$.input,r=e.$.editableElement;e.setAttribute("role","application"),e.setAttribute("aria-roledescription",e.localize("roleDescription")),e.$.toolbarToggleButton.setAttribute("aria-label",e.localize("toolbarButtonAriaLabel")),e.$.toolbarItemsPrimary.setAttribute("aria-label",e.localize("primaryToolbarAriaLabel")),e.$.toolbarItemsSecondary.setAttribute("aria-label",e.localize("secondaryToolbarAriaLabel")),t.setAttribute("aria-label",e.localize("inputAreaLabel")),t.id=e.id+"TextArea",r.id=e.id+"EditableElement",r.setAttribute("aria-label",e.localize("inputAriaLabel"))}_setAriaControls(e,t){const r=this;e&&e.nodeName&&(t.id||(t.id=r.id+"Popup"+Math.floor(65536*(1+Math.random())).toString(16).substring(1)),e.setAttribute("aria-controls",t.id))}_setAriaOwns(e){const t=this;if(!e)return;const r=e.id;let n=(t.getAttribute("aria-owns")||"").split(" ").filter((e=>e.length));const o=n.indexOf(r);if(o>-1){if(e.parentElement&&(e.opened||e.visible))return;n.splice(o,1)}else n.push(r);n.length?t.setAttribute("aria-owns",n.join(" ")):t.removeAttribute("aria-owns")}_setFocusable(){const e=this,t=e.$.editableElement;if(e.disabled||e.unfocusable)return void(t&&t.removeAttribute("tabindex"));const r=e.tabIndex>0?e.tabIndex:0;t&&(t.tabIndex=r)}_selectAll(){const e=this,t=e.$.input,r=e.$.editableElement;t.classList.contains("smart-hidden")||t.select(),r.classList.contains("smart-hidden")||e._setSelectionRange(r)}_selectStartHandler(e){const t=this._resizeFrameObj,r=this._inlineToolbarClickObj;(t&&t.resizeDetails||r&&r.resizeDetails)&&e.preventDefault()}_selectionChangeHandler(e){const t=this;if(t.disabled||!e.target.getSelection)return;const r=e.target.getSelection().focusNode;if(t.$.contentContainer.contains(r)){if(t._ignoreSelectionChange||r.classList&&r.classList.contains("smart-search-input"))return;t._selectionChangeFired=!0,t._setSelectionRange(),t._updateToolbarItems(),delete t._selectionChangeFired}}_selectToolbarTab(e){const t=this,r=t.$.toolbar,n=t.$.toolbarItemsPrimary,o=e&&!e.hasAttribute("checked"),a=n.querySelectorAll(".smart-editor-toolbar-tab");for(let t=0,r=a.length;t<r;t+=1){const r=a[t];e===r&&o?r.setAttribute("checked",""):r.removeAttribute("checked")}let i=t._tabSelectionBar;i||(t._tabSelectionBar=i=document.createElement("div"),i.classList.add("smart-editor-toolbar-tab-selection-bar")),i.classList.add("smart-visibility-hidden"),e&&e.hasAttribute("checked")?(r.setAttribute("toolbar-tab-selected",""),i.style.left=e.offsetLeft+"px",i.style.width=e.offsetWidth+"px",n.contains(i)||n.appendChild(i),t._setToolbarItemGroups(),requestAnimationFrame((()=>i.classList.remove("smart-visibility-hidden")))):r.removeAttribute("toolbar-tab-selected")}}),Smart("smart-table-picker",class extends Smart.BaseElement{static get properties(){return{columns:{value:10,type:"number"},messages:{extend:!0,value:{en:{buttonLabel:"Insert Table"}}},rows:{value:3,type:"number"},value:{value:[],type:"array"}}}static get listeners(){return{"tableGrid.mouseover":"_cellOver","tableGrid.mouseleave":"_cellLeave","tableGrid.click":"_cellOver"}}template(){return'<div id="container" role="presentation">\n                    <div id="tableGrid" class="smart-table-picker-grid" role="presentation"></div>\n                    <div class="smart-table-picker-separator" role="separator"></div>\n                    <smart-button id="tableButton" class="smart-table-picker-button" right-to-left="[[rightToLeft]]"></smart-button>\n                </div>'}propertyChangedHandler(e,t,r){const n=this;switch(e){case"value":n._selectCell(r,t,!0);break;case"rows":case"columns":n._createTableGrid();break;case"messages":n._setTableButton();break;default:super.propertyChangedHandler(e,t,r)}}render(){const e=this;e._isMobile=Smart.Utilities.Core.isMobile,e._createTableGrid(),e._setTableButton(),e._setAria(),super.render()}_setAria(){this.setAttribute("role","grid")}_createTableGrid(){const e=this,t=e.$.tableGrid,r=e.columns,n=e.rows,o=t.children,a=document.createDocumentFragment();let i=o.length;for(;i>n;){const e=o[0];if(!e)break;e.remove(),i--}for(let e=i,t=n;e<t;e+=1){const e=document.createElement("div");e.setAttribute("role","row"),a.appendChild(e)}a.children.length&&t.appendChild(a);for(let e=0,t=n;e<t;e+=1){const t=o[e],n=t.children;let a=n.length;for(;a>r;){if(!n[0])break;n[0].remove(),a--}for(let e=a,n=r;e<n;e+=1){const e=document.createElement("span");e.setAttribute("role","gridcell"),e.classList.add("smart-table-picker-cell"),t.appendChild(e)}}e._selectCell(e.value)}_cellOver(e){const t=this,r=e.target;let n=[];if(!t.$.tableGrid.contains(r))return void t._selectCell(t.value);const o=r.closest(".smart-table-picker-cell");if(o){const r=o.parentElement,a=Array.from(r.children);n[0]=Math.max(0,Array.from(t.$.tableGrid.children).indexOf(r)+1),n[1]=Math.max(0,a.indexOf(o)+1),t._selectCell(n,t.value,"click"===e.type)}}_cellLeave(){this._selectCell(this.value)}_selectCell(e,t,r){const n=this,o=n.$.tableGrid,a=Array.from(o.children),i=a.length;let s=0,l=0;e&&(s=e[0]||0,l=e[1]||0);for(let e=0,t=i;e<t;e+=1){const t=a[e].children;if(s<e+1)for(let e=0,r=t.length;e<r;e+=1)t[e].removeAttribute("selected");else for(let e=0,r=t.length;e<r;e+=1)l>=e+1?t[e].setAttribute("selected",""):t[e].removeAttribute("selected")}o.setAttribute("value",s+"x"+l),r&&(void 0===t&&(t=n.value),n.set("value",[s,l]),t[0]===s&&t[1]===l||n.$.fireEvent("change",{value:e,oldValue:t}))}_setTableButton(){this.$.tableButton.innerHTML=this.localize("buttonLabel")}})},180:()=>{!function(){const e="16.0.0",t=[];let r="Smart";if(window[r]&&window[r].Version){if(window[r].Version===e)return;if(window[r].Version!==e)r+=e;else{let e=2;for(;window[r];)r+=e.toString(),e++}}const n=navigator.userAgent.indexOf("Edge")>-1&&navigator.appVersion.indexOf("Edge")>-1;document.elementsFromPoint||(document.elementsFromPoint=document.msElementsFromPoint);class o{static isBoolean(e){return"boolean"==typeof e}static isFunction(e){return!!(e&&e.constructor&&e.call&&e.apply)}static isArray(e){return Array.isArray(e)}static isObject(e){return e&&("object"==typeof e||this.isFunction(e))||!1}static isDate(e){return e instanceof Date}static isString(e){return"string"==typeof e}static isNumber(e){return"number"==typeof e}static getType(e){const t=this,r=["Boolean","Number","String","Function","Array","Date","Object"].find((r=>{if(t["is"+r](e))return r}));return r?r.toLowerCase():void 0}}class a{static animate(e,t,n,o){const a=e;if(!a||a instanceof HTMLElement==!1)return;if(0===a.getElementsByClassName("smart-ripple").length){const e=document.createElement("span");e.classList.add("smart-ripple"),e.setAttribute("role","presentation");let t=!0,n=null;if(window[r].EnableShadowDOM&&a.enableShadowDOM&&!0!==a.isInShadowDOM){for(let e=0;e<a.shadowRoot.host.shadowRoot.children.length;e++)"link"!==a.shadowRoot.host.shadowRoot.children[e].tagName.toLowerCase()&&(n=a.shadowRoot.host.shadowRoot.children[e]);a.shadowRoot.host.shadowRoot.querySelector(".smart-ripple")&&(t=!1)}else n=a.firstElementChild;t&&(n&&!n.noRipple&&n.offsetHeight>0?n.appendChild(e):a.appendChild(e))}let i=null;if(i=window[r].EnableShadowDOM&&a.shadowRoot?a.shadowRoot.host.shadowRoot.querySelector(".smart-ripple"):a.getElementsByClassName("smart-ripple")[0],!i)return;i.innerHTML="",i.classList.remove("smart-animate"),i.style.height=i.style.width=Math.max(a.offsetHeight,a.offsetWidth)+"px";const s=window.getComputedStyle(i.parentElement),l=parseInt(s.borderLeftWidth)||0,d=parseInt(s.borderTopWidth)||0,m=a.getBoundingClientRect(),c=t-(m.left+window.pageXOffset)-i.offsetWidth/2-l,u=n-(m.top+window.pageYOffset)-i.offsetHeight/2-d;i.style.left=c+"px",i.style.top=u+"px",i.classList.add("smart-animate"),i.addEventListener("animationend",(function e(){i.parentElement&&i.parentElement.removeChild(i),o&&o(),i.removeEventListener("animationend",e),i.removeEventListener("animationcancel",e)})),i.addEventListener("animationcancel",(function e(){i.parentElement&&i.parentElement.removeChild(i),o&&o(),i.removeEventListener("animationcancel",e),i.removeEventListener("animationend",e)}))}}class i{static easeInQuad(e,t,r,n){return r*(e/=n)*e+t}static easeOutQuad(e,t,r,n){return-r*(e/=n)*(e-2)+t}static easeInOutQuad(e,t,r,n){return(e/=n/2)<1?r/2*e*e+t:-r/2*(--e*(e-2)-1)+t}static easeInCubic(e,t,r,n){return r*(e/=n)*e*e+t}static easeOutCubic(e,t,r,n){return r*((e=e/n-1)*e*e+1)+t}static easeInOutCubic(e,t,r,n){return(e/=n/2)<1?r/2*e*e*e+t:r/2*((e-=2)*e*e+2)+t}static easeInQuart(e,t,r,n){return r*(e/=n)*e*e*e+t}static easeOutQuart(e,t,r,n){return-r*((e=e/n-1)*e*e*e-1)+t}static easeInOutQuart(e,t,r,n){return(e/=n/2)<1?r/2*e*e*e*e+t:-r/2*((e-=2)*e*e*e-2)+t}static easeInQuint(e,t,r,n){return r*(e/=n)*e*e*e*e+t}static easeOutQuint(e,t,r,n){return r*((e=e/n-1)*e*e*e*e+1)+t}static easeInOutQuint(e,t,r,n){return(e/=n/2)<1?r/2*e*e*e*e*e+t:r/2*((e-=2)*e*e*e*e+2)+t}static easeInSine(e,t,r,n){return-r*Math.cos(e/n*(Math.PI/2))+r+t}static easeOutSine(e,t,r,n){return r*Math.sin(e/n*(Math.PI/2))+t}static easeInOutSine(e,t,r,n){return-r/2*(Math.cos(Math.PI*e/n)-1)+t}static easeInExpo(e,t,r,n){return 0===e?t:r*Math.pow(2,10*(e/n-1))+t}static easeOutExpo(e,t,r,n){return e===n?t+r:r*(1-Math.pow(2,-10*e/n))+t}static easeInOutExpo(e,t,r,n){return 0===e?t:e===n?t+r:(e/=n/2)<1?r/2*Math.pow(2,10*(e-1))+t:r/2*(2-Math.pow(2,-10*--e))+t}static easeInCirc(e,t,r,n){return-r*(Math.sqrt(1-(e/=n)*e)-1)+t}static easeOutCirc(e,t,r,n){return r*Math.sqrt(1-(e=e/n-1)*e)+t}static easeInOutCirc(e,t,r,n){return(e/=n/2)<1?-r/2*(Math.sqrt(1-e*e)-1)+t:r/2*(Math.sqrt(1-(e-=2)*e)+1)+t}static easeInElastic(e,t,r,n){let o=1.70158,a=0,i=r;return 0===e?t:1==(e/=n)?t+r:(a||(a=.3*n),i<Math.abs(r)?(i=r,o=a/4):o=a/(2*Math.PI)*Math.asin(r/i),-i*Math.pow(2,10*(e-=1))*Math.sin((e*n-o)*(2*Math.PI)/a)+t)}static easeOutElastic(e,t,r,n){let o=1.70158,a=0,i=r;return 0===e?t:1==(e/=n)?t+r:(a||(a=.3*n),i<Math.abs(r)?(i=r,o=a/4):o=a/(2*Math.PI)*Math.asin(r/i),i*Math.pow(2,-10*e)*Math.sin((e*n-o)*(2*Math.PI)/a)+r+t)}static easeInOutElastic(e,t,r,n){let o=1.70158,a=0,i=r;return 0===e?t:2==(e/=n/2)?t+r:(a||(a=n*(.3*1.5)),i<Math.abs(r)?(i=r,o=a/4):o=a/(2*Math.PI)*Math.asin(r/i),e<1?i*Math.pow(2,10*(e-=1))*Math.sin((e*n-o)*(2*Math.PI)/a)*-.5+t:i*Math.pow(2,-10*(e-=1))*Math.sin((e*n-o)*(2*Math.PI)/a)*.5+r+t)}static easeInBack(e,t,r,n,o){return void 0===o&&(o=1.70158),r*(e/=n)*e*((o+1)*e-o)+t}static easeOutBack(e,t,r,n,o){return void 0===o&&(o=1.70158),r*((e=e/n-1)*e*((o+1)*e+o)+1)+t}static easeInOutBack(e,t,r,n,o){return void 0===o&&(o=1.70158),(e/=n/2)<1?r/2*(e*e*((1+(o*=1.525))*e-o))+t:r/2*((e-=2)*e*((1+(o*=1.525))*e+o)+2)+t}static easeInBounce(e,t,r,n){return r-this.easeOutBounce(n-e,0,r,n)+t}static easeOutBounce(e,t,r,n){return(e/=n)<1/2.75?r*(7.5625*e*e)+t:e<2/2.75?r*(7.5625*(e-=1.5/2.75)*e+.75)+t:e<2.5/2.75?r*(7.5625*(e-=2.25/2.75)*e+.9375)+t:r*(7.5625*(e-=2.625/2.75)*e+.984375)+t}static easeInOutBounce(e,t,r,n){return e<n/2?.5*this.easeInBounce(2*e,0,r,n)+t:.5*this.easeOutBounce(2*e-n,0,r,n)+.5*r+t}}class s{static get isMobile(){const e=/(iphone|ipod|ipad|android|iemobile|blackberry|bada)/.test(window.navigator.userAgent.toLowerCase());return e||(["iPad Simulator","iPhone Simulator","iPod Simulator","iPad","iPhone","iPod"].includes(navigator.platform)||navigator.userAgent.includes("Mac")&&"ontouchend"in document)}static get Browser(){let e;const t=function(t){let r=t.indexOf(e);if(-1===r)return;const n=t.indexOf("rv:");return"Trident"===e&&-1!==n?parseFloat(t.substring(n+3)):parseFloat(t.substring(r+e.length+1))};let r={};return r[function(){const t=[{string:navigator.userAgent,subString:"Edge",identity:"Edge"},{string:navigator.userAgent,subString:"MSIE",identity:"IE"},{string:navigator.userAgent,subString:"Trident",identity:"IE"},{string:navigator.userAgent,subString:"Firefox",identity:"Firefox"},{string:navigator.userAgent,subString:"Opera",identity:"Opera"},{string:navigator.userAgent,subString:"OPR",identity:"Opera"},{string:navigator.userAgent,subString:"Chrome",identity:"Chrome"},{string:navigator.userAgent,subString:"Safari",identity:"Safari"}];for(let r=0;r<t.length;r++){let n=t[r].string;if(e=t[r].subString,-1!==n.indexOf(t[r].subString))return t[r].identity}return"Other"}()]=!0,r.version=t(navigator.userAgent)||t(navigator.appVersion)||"Unknown",r}static toCamelCase(e){return e.replace(/-([a-z])/g,(function(e){return e[1].toUpperCase()}))}static toDash(e){return e.split(/(?=[A-Z])/).join("-").toLowerCase()}static unescapeHTML(e){return(new DOMParser).parseFromString(e,"text/html").documentElement.textContent}static escapeHTML(e){const t={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;","/":"&#x2F;","`":"&#x60;","=":"&#x3D;"};return String(e).replace(/[&<>"'`=\/]/g,(e=>t[e]))}static sanitizeHTML(e){if(e&&(e.indexOf("onclick")>=0||e.indexOf("onload")>=0||e.indexOf("onerror")>=0))return this.escapeHTML(e);const t=new RegExp("<s*(applet|audio|base|bgsound|embed|form|iframe|isindex|keygen|layout|link|meta|object|script|svg|style|template|video)[^>]*>(.*?)<s*/s*(applet|audio|base|bgsound|embed|form|iframe|isindex|keygen|layout|link|meta|object|script|svg|style|template|video)>","ig");return String(e).replace(t,(e=>this.escapeHTML(e)))}static createGUID(){function e(){return Math.floor(65536*(1+Math.random())).toString(16).substring(1)}return e()+e()+"-"+e()+"-"+e()+"-"+e()+"-"+e()+e()+e()}static getScriptLocation(){if("./"!==window[r].BaseUrl)return window[r].BaseUrl;return function(){if(document.currentScript){let e=document.currentScript.src,t=e.lastIndexOf("/");return e=e.substring(0,t),e}const e=new Error;let t="(",r=")";if(Smart.Utilities.Core.Browser.Safari&&(t="@",r="\n"),e.fileName)return e.fileName.replace("/smart.element.js","");let n=e.stack.split(t);return n=n[1],n=n.split(r)[0],n=n.split(":"),n.splice(-2,2),n=n.join(":"),n.replace("/smart.element.js","")}()}static CSSVariablesSupport(){return window.CSS&&window.CSS.supports&&window.CSS.supports("(--fake-var: 0)")}static assign(e,t){const r=e=>e&&"object"==typeof e&&!Array.isArray(e)&&null!==e;let n=Object.assign({},e);return r(e)&&r(t)&&Object.keys(t).forEach((o=>{r(t[o])?o in e?n[o]=this.assign(e[o],t[o]):Object.assign(n,{[o]:t[o]}):Object.assign(n,{[o]:t[o]})})),n}static html(e,t){const r=this;let n="",o=e.childNodes;if(!t){for(let e,t=0,a=o.length;t<a&&(e=o[t]);t++){const t=["strong"];if(e instanceof HTMLElement||e.tagName&&t.indexOf(e.tagName.toLowerCase())>=0){const t=e.tagName.toLowerCase(),o=e.attributes;let a="<"+t;for(let e,t=0;e=o[t];t++)a+=" "+e.name+'="'+e.value.replace(/[&\u00A0"]/g,f.Core.escapeHTML)+'"';a+=">";["area","base","br","col","command","embed","hr","img","input","keygen","link","meta","param","source","track","wbr"][t]&&(n+=a),n=n+a+r.html(e)+"</"+t+">"}else{if(8===e.nodeType)continue;n+=e.textContent.replace(/[&\u00A0<>]/g,f.Core.escapeHTML)}}return n}{const r=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi;e.innerHTML=t.replace(r,"<$1></$2>")}}}let l=[];class d{static watch(e){switch(e.nodeName.toLowerCase()){case"smart-grid":case"smart-kanban":case"smart-table":case"smart-pivot-table":case"smart-scheduler":case"smart-tabs":case"smart-card-view":case"smart-list-box":case"smart-combo-box":case"smart-drop-down-list":case"smart-calendar":case"smart-gauge":case"smart-numeric-text-box":case"smart-menu":case"smart-tree":l.push(e);break;default:return}d.start()}static start(){d.isStarted||(d.isStarted=!0,d.interval&&clearInterval(d.interval),0===l.length||document.hidden?d.isStarted=!1:d.interval=setInterval((function(){d.observe()}),100))}static stop(){d.isStarted=!1,d.interval&&clearInterval(d.interval)}static observeElement(e){const t=e;if("test"===window.Smart.Mode||document.hidden)return void(d.interval&&clearInterval(d.interval));let r=e._computedStyle||"resize"!==t.hasStyleObserver?document.defaultView.getComputedStyle(t,null):{},n=!0,o="resize"!==t.hasStyleObserver?["paddingLeft","paddingRight","paddingTop","paddingBottom","borderLeftWidth","borderRightWidth","borderTopWidth","borderBottomWidth","display","visibility","font-size","font-family","font-style","font-weight","max-height","min-height","max-width","min-width","overflow","overflow-x","overflow-y"]:[];if(e.styleProperties&&(o=o.concat(e.styleProperties)),e.observableStyleProperties&&(o=e.observableStyleProperties),!t._styleInfo){t._styleInfo=[];for(let e=0;e<o.length;e++){const n=o[e],a=n.startsWith("--")?r.getPropertyValue(n):r[n];t._styleInfo[n]=a}return}if(e.isHidden||"none"!==r.display&&(0!==e.offsetWidth&&0!==e.offsetHeight||(e.isHidden=!0)),e.isHidden){if(e.visibilityChangedHandler(),e.isHidden)return;n=!1}let a=[];for(let e=0;e<o.length;e++){const n=o[e],i=n.startsWith("--")?r.getPropertyValue(n):r[n];t._styleInfo[n]!==i&&(a[n]={oldValue:t._styleInfo[n],value:i},a.length++),t._styleInfo[n]=i}a.length>0&&(t.$.fireEvent("styleChanged",{styleProperties:a},{bubbles:!1,cancelable:!0}),a.display&&n&&t.$.fireEvent("resize",t,{bubbles:!1,cancelable:!0}))}static observe(){for(let e=0;e<l.length;e++){const t=l[e];this.observeElement(t)}}static unwatch(e){d.stop();const t=l.indexOf(e);-1!==t&&l.splice(t,1),d.start()}}let m=[];const c=[],u=["resize","down","up","move","tap","taphold","swipeleft","swiperight","swipetop","swipebottom"];class p{constructor(e){const t=this;t.target=e,t.$target=new b(e),t.$document=e.$document?e.$document:new b(document),t.id=(Date.now().toString(36)+Math.random().toString(36).substr(2,5)).toUpperCase();let r={handlers:{},boundEventTypes:[],listen:t.listen.bind(t),unlisten:t.unlisten.bind(t)};return t.tapHoldDelay=750,t.swipeMin=10,t.swipeMax=5e3,t.swipeDelay=1e3,t.tapHoldDelay=750,t.inputEventProperties=["clientX","clientY","pageX","pageY","screenX","screenY"],u.forEach((e=>{r[e]=t=>{r.handlers[e]=t},t[e]=e=>{if(!r.handlers[e.type]){if(("mousemove"===e.type||"pointermove"===e.type||"touchmove"===e.type)&&r.handlers.move){const n=t.createEvent(e,"move");r.handlers.move(n)}return!0}return r.handlers[e.type](e)}})),t.listen(),t.handlers=r.handlers,r}listen(e){const t=this;if("resize"===e&&t.target!==document&&t.target!==window&&!1!==t.target.hasResizeObserver)if(Smart.Utilities.Core.Browser.Firefox){if(!t.target.resizeObserver){let e,r,n,o=!1,a=t.target.offsetWidth,i=t.target.offsetHeight;const s=new ResizeObserver((()=>{if(!o)return void(o=!0);const s=new CustomEvent("resize",{bubbles:!1,cancelable:!0});r=t.target.offsetWidth,n=t.target.offsetHeight,e=r!==a||n!==i,t.target.requiresLayout&&(e=!0),e&&(t.resize(s),t.target.requiresLayout=!1)}));s.observe(t.target),t.target.resizeObserver=s}}else if(!t.target.resizeTrigger){const e=document.createElement("div");e.className="smart-resize-trigger-container",e.innerHTML='<div class="smart-resize-trigger-container"><div class="smart-resize-trigger"></div></div><div class="smart-resize-trigger-container"><div class="smart-resize-trigger-shrink"></div></div>',e.setAttribute("aria-hidden",!0),window[r].EnableShadowDOM&&t.target.shadowRoot?t.target.shadowRoot.appendChild(e):t.target.appendChild(e),t.target.resizeTrigger=e;const n=e.childNodes[0],o=n.childNodes[0],a=e.childNodes[1],i=function(){o.style.width="100000px",o.style.height="100000px",n.scrollLeft=1e5,n.scrollTop=1e5,a.scrollLeft=1e5,a.scrollTop=1e5};let s,l,d,m,c=t.target.offsetWidth,u=t.target.offsetHeight;if(0===c||0===u){const e=function(){i(),t.target.removeEventListener("resize",e)};t.target.addEventListener("resize",e),i()}else i();t.target.resizeHandler=function(){l||(l=requestAnimationFrame((function(){if(l=0,d=t.target.offsetWidth,m=t.target.offsetHeight,s=d!==c||m!==u,t.target.requiresLayout&&(s=!0),!s)return;c=d,u=m;const e=new CustomEvent("resize",{bubbles:!1,cancelable:!0});t.resize(e),t.target.requiresLayout=!1}))),i()},n.addEventListener("scroll",t.target.resizeHandler),a.addEventListener("scroll",t.target.resizeHandler)}if(!t.isListening){if(t.isListening=!0,t.isPressed=!1,t.isReleased=!1,t.isInBounds=!1,window.PointerEvent)t.$target.listen("pointerdown.inputEvents"+t.id,t.pointerDown.bind(t)),t.$target.listen("pointerup.inputEvents"+t.id,t.pointerUp.bind(t)),t.$target.listen("pointermove.inputEvents"+t.id,t.pointerMove.bind(t)),t.$target.listen("pointercancel.inputEvents"+t.id,t.pointerCancel.bind(t));else{"ontouchstart"in window&&(t.$target.listen("touchmove.inputEvents"+t.id,t.touchMove.bind(t)),t.$target.listen("touchstart.inputEvents"+t.id,t.touchStart.bind(t)),t.$target.listen("touchend.inputEvents"+t.id,t.touchEnd.bind(t)),t.$target.listen("touchcancel.inputEvents"+t.id,t.touchCancel.bind(t))),t.$target.listen("mousedown.inputEvents"+t.id,t.mouseDown.bind(t)),t.$target.listen("mouseup.inputEvents"+t.id,t.mouseUp.bind(t)),t.$target.listen("mousemove.inputEvents"+t.id,t.mouseMove.bind(t)),t.$target.listen("mouseleave.inputEvents"+t.id,t.mouseLeave.bind(t))}t.target._handleDocumentUp||(t.target._handleDocumentUp=t.handleDocumentUp.bind(t),t.target._handleDocumentUpId=t.id,t.$document.listen("mouseup.inputEvents"+t.target._handleDocumentUpId,t.target._handleDocumentUp))}}unlisten(e){const t=this;if(t.isListening=!1,window.PointerEvent)t.$target.unlisten("pointerdown.inputEvents"+t.id),t.$target.unlisten("pointerup.inputEvents"+t.id),t.$target.unlisten("pointermove.inputEvents"+t.id),t.$target.unlisten("pointercancel.inputEvents"+t.id);else{"ontouchstart"in window&&(t.$target.unlisten("touchstart.inputEvents"+t.id),t.$target.unlisten("touchmove.inputEvents"+t.id),t.$target.unlisten("touchend.inputEvents"+t.id),t.$target.unlisten("touchcancel.inputEvents"+t.id)),t.$target.unlisten("mousedown.inputEvents"+t.id),t.$target.unlisten("mouseup.inputEvents"+t.id),t.$target.unlisten("mousemove.inputEvents"+t.id),t.$target.unlisten("mouseleave.inputEvents"+t.id)}if(t.target._handleDocumentUp&&(t.$document.unlisten("mouseup.inputEvents"+t.target._handleDocumentUpId,t.target._handleDocumentUp),delete t.target._handleDocumentUp,delete t.target._handleDocumentUpId),"resize"===e)if(Smart.Utilities.Core.Browser.Firefox)t.target.resizeObserver&&(t.target.resizeObserver.unobserve(t.target),delete t.target.resizeObserver);else if(t.target.resizeTrigger){const e=t.target.resizeTrigger,r=e.childNodes[0],n=e.childNodes[1];r.removeEventListener("scroll",t.target.resizeHandler),n.removeEventListener("scroll",t.target.resizeHandler),t.target.resizeHandler=null,e.parentNode.removeChild(e),delete t.target.resizeTrigger}}handleDocumentUp(e){const t=this;t.isPressed=!1,t.isReleased=!1,t.resetSwipe(e)}createEvent(e,t){const r=this,n=e.touches,o=e.changedTouches,a=n&&n.length?n[0]:o&&o.length?o[0]:void 0,i=new CustomEvent(t,{bubbles:!0,cancelable:!0,composed:void 0!==r.$target.element.getRootNode().host});if(i.originalEvent=e,a){for(let e=0;e<r.inputEventProperties.length;e++){const t=r.inputEventProperties[e];i[t]=a[t]}return i}for(let t in e)t in i||(i[t]=e[t]);return i}fireTap(e){const t=this;if(clearTimeout(this.tapHoldTimeout),!this.tapHoldFired&&this.isInBounds){const r=t.createEvent(e,"tap");t.tap(r)}}initTap(e){const t=this;t.isInBounds=!0,t.tapHoldFired=!1,t.tapHoldTimeout=setTimeout((function(){if(t.isInBounds){t.tapHoldFired=!0;const r=t.createEvent(e,"taphold");t.taphold(r)}}),t.tapHoldDelay)}pointerDown(e){return this.handleDown(e)}mouseDown(e){const t=this;if(!(t.isPressed||t.touchStartTime&&new Date-t.touchStartTime<500))return t.handleDown(e)}touchStart(e){const t=this;return t.touchStartTime=new Date,t.isTouchMoved=!0,t.handleDown(e)}mouseUp(e){const t=this;if(!(t.isReleased||t.touchEndTime&&new Date-t.touchEndTime<500))return t.handleUp(e)}handleDown(e){const t=this;t.isReleased=!1,t.isPressed=!0;const r=t.createEvent(e,"down");return(t.handlers.tap||t.handlers.taphold)&&t.initTap(r),(t.handlers.swipeleft||t.handlers.swiperight||t.handlers.swipetop||t.handlers.swipebottom)&&t.initSwipe(r),t.down(r)}handleUp(e){const t=this;t.isReleased=!0,t.isPressed=!1;const r=t.createEvent(e,"up"),n=t.up(r);return(t.handlers.tap||t.handlers.taphold)&&t.fireTap(r),t.resetSwipe(r),n}handleMove(e){const t=this;let r=t.move(e);return t.isPressed&&(t._maxSwipeVerticalDistance=Math.max(t._maxSwipeVerticalDistance,Math.abs(t._startY-e.pageY)),t._maxSwipeHorizontalDistance=Math.max(t._maxSwipeHorizontalDistance,Math.abs(t._startX-e.pageX)),r=t.handleSwipeEvents(e)),r}touchEnd(e){return this.touchEndTime=new Date,this.handleUp(e)}pointerUp(e){return this.handleUp(e)}pointerCancel(e){this.pointerUp(e)}touchCancel(e){this.touchEnd(e)}mouseLeave(){this.isInBounds=!1}mouseMove(e){if(!this.isTouchMoved)return this.handleMove(e)}pointerMove(e){return this.handleMove(e)}touchMove(e){const t=this,r=e.touches,n=e.changedTouches,o=r&&r.length?r[0]:n&&n.length?n[0]:void 0;for(let r=0;r<t.inputEventProperties.length;r++){const n=t.inputEventProperties[r];void 0===e[n]&&(e[n]=o[n])}return t.isTouchMoved=!0,t.handleMove(e)}handleSwipeEvents(e){const t=this;let r=!0;return(t.handlers.swipetop||t.handlers.swipebottom)&&(r=this.handleVerticalSwipeEvents(e)),!1===r||(t.handlers.swipeleft||t.handlers.swiperight)&&(r=this.handleHorizontalSwipeEvents(e)),r}handleVerticalSwipeEvents(e){let t,r;return t=e.pageY,r=t-this._startY,this.swiped(e,r,"vertical")}handleHorizontalSwipeEvents(e){let t,r;return t=e.pageX,r=t-this._startX,this.swiped(e,r,"horizontal")}swiped(e,t,r){const n=this;if(r=r||0,Math.abs(t)>=n.swipeMin&&!n._swipeEvent&&!n._swipeLocked){let o=t<0?"swipeleft":"swiperight";if("horizontal"===r?n._swipeEvent=n.createEvent(e,o):(o=t<0?"swipetop":"swipebottom",n._swipeEvent=n.createEvent(e,t<0?"swipetop":"swipebottom")),n[o]&&(n[o](this._swipeEvent),Math.abs(t)<=this.swipeMax))return e.stopImmediatePropagation(),!1}return!0}resetSwipe(){this._swipeEvent=null,clearTimeout(this._swipeTimeout)}initSwipe(e){const t=this;t._maxSwipeVerticalDistance=0,t._maxSwipeHorizontalDistance=0,t._startX=e.pageX,t._startY=e.pageY,t._swipeLocked=!1,t._swipeEvent=null,t._swipeTimeout=setTimeout((function(){t._swipeLocked=!0}),t.swipeDelay)}}class h{get scrollWidth(){const e=this;return e.horizontalScrollBar?e.horizontalScrollBar.max:-1}set scrollWidth(e){const t=this;e<0&&(e=0),t.horizontalScrollBar&&(t.horizontalScrollBar.max=e)}get scrollHeight(){const e=this;return e.verticalScrollBar?e.verticalScrollBar.max:-1}set scrollHeight(e){const t=this;e<0&&(e=0),t.verticalScrollBar&&(t.verticalScrollBar.max=e)}get scrollLeft(){const e=this;return e.horizontalScrollBar?e.horizontalScrollBar.value:-1}set scrollLeft(e){const t=this;e<0&&(e=0),t.horizontalScrollBar&&(t.horizontalScrollBar.value=e)}get scrollTop(){const e=this;return e.verticalScrollBar?e.verticalScrollBar.value:-1}set scrollTop(e){const t=this;e<0&&(e=0),t.verticalScrollBar&&(t.verticalScrollBar.value=e)}get vScrollBar(){return this.verticalScrollBar}get hScrollBar(){return this.horizontalScrollBar}constructor(e,t,r){const n=this;n.container=e,n.horizontalScrollBar=t,n.verticalScrollBar=r,n.disableSwipeScroll=!1,n.listen()}listen(){const e=this,t=s.isMobile,r=e.horizontalScrollBar,n=e.verticalScrollBar;e.inputEvents=new p(e.container);let o,a,i,l,d,m,c,u;const h=function(e){return{amplitude:0,delta:0,initialValue:0,min:0,max:e.max,previousValue:0,pointerPosition:0,targetValue:0,scrollBar:e,value:0,velocity:0}},b=h(r),g=h(n),v=function(){const t=e.container.touchVelocityCoefficient||50;m=Date.now(),c=m-l,l=m;const r=function(e){e.delta=e.value-e.previousValue,e.previousValue=e.value;let r=t*e.delta/(1+c);e.velocity=.8*r+.2*e.velocity};r(g),r(b)},w=function(e){return u.value=e>u.max?u.max:e<u.min?u.min:e,u.scrollBar.value=u.value,e>u.max?"max":e<u.min?"min":"value"};function x(){let t,r;u.amplitude&&(e.container.$.fireEvent("kineticScroll"),t=Date.now()-l,r=-u.amplitude*Math.exp(-t/500),r>5||r<-5?(w(u.targetValue+r),cancelAnimationFrame(a),a=0,a=requestAnimationFrame(x)):w(u.targetValue))}let y;e.inputEvents.down((function(r){if(!t)return;const n=r.originalEvent.target,a=n&&n.closest?n.closest("smart-scroll-bar"):void 0;if(a===e.horizontalScrollBar||a===e.verticalScrollBar)return;i=!0,o=!1;const s=function(e,t){e.amplitude=0,e.pointerPosition=t,e.previousValue=e.value,e.value=e.scrollBar.value,e.initialValue=e.value,e.max=e.scrollBar.max};s(g,r.clientY),s(b,r.clientX),l=Date.now(),clearInterval(d),d=setInterval(v,500)})),e.inputEvents.up((function(){if(!i)return!0;if(clearInterval(d),e.disableSwipeScroll)return void(i=!1);const t=function(e){u=e,e.amplitude=.8*e.velocity,e.targetValue=Math.round(e.value+e.amplitude),l=Date.now(),cancelAnimationFrame(a),a=requestAnimationFrame(x),e.velocity=0};g.velocity>10||g.velocity<-10?t(g):(b.velocity>10||b.velocity<-10)&&t(b),i=!1})),e.inputEvents.move((function(t){if(!i)return!0;if(e.disableSwipeScroll)return;if(o&&(t.originalEvent.preventDefault(),t.originalEvent.stopPropagation()),b.visible=e.scrollWidth>0,g.visible=e.scrollHeight>0,!i||!b.visible&&!g.visible)return;const r=e.container.touchScrollRatio,n=e.container;let a,s;r&&("number"==typeof r?(a=-r,s=-r):"function"==typeof r&&(a=r(g.max,n.offsetHeight),s=r(b.max,n.offsetWidth))),g.ratio=a||-g.max/n.offsetHeight,g.delta=(t.clientY-g.pointerPosition)*g.ratio,b.ratio=s||-b.max/n.offsetWidth,b.delta=(t.clientX-b.pointerPosition)*b.ratio;let l="value";const d=function(t,r,n){return t.delta>5||t.delta<-5?(u=t,l=t.initialValue+t.delta>u.max?"max":t.initialValue+t.delta<u.min?"min":"value","min"===l&&0===t.initialValue||("max"===l&&t.initialValue===t.max||(!t.visible||(e.container.$.fireEvent("kineticScroll"),w(t.initialValue+t.delta),v(),n.originalEvent.preventDefault(),n.originalEvent.stopPropagation(),o=!0,!1)))):null};let m=d(g,t.clientY,t);if(null!==m)return m;{let e=d(b,t.clientX,t);if(null!==e)return e}})),e.scrollTo=function(t,r){const n=!1===r?b:g;let o=!1;l||(l=Date.now()),y||(y=Date.now()),Math.abs(Date.now()-y)>375?l=Date.now():o=!0,y=Date.now(),n.value=n.scrollBar.value,n.delta=t-n.value,n.max=n.scrollBar.max,t<=n.min&&(t=n.min),t>=n.max&&(t=n.max),n.targetValue=t;const i=t;let s=n.value;n.velocity=100*n.delta/(1+n.max),n.from=s;const d=function(e){return n.value=e>n.max?n.max:e<n.min?n.min:e,n.scrollBar.value=n.value,e>n.max?"max":e<n.min?"min":"value"},m=function(){let r,c=Date.now()-y,u=Math.min(1e3,Date.now()-l),p=n.velocity*Math.exp(u/175);if(o)(p<0&&n.value<=t||p>0&&n.value>=t)&&(p=0),(n.value+p<=n.min||n.value+p>=n.max)&&(p=0),p>.5||p<-.5?(d(n.value+p),cancelAnimationFrame(a),a=0,a=requestAnimationFrame(m)):d(n.targetValue);else{if(c>=175)return cancelAnimationFrame(a),e.container.$.fireEvent("kineticScroll"),void(a=0);r=f.Animation.Easings.easeInSine(c,s,i-s,175),d(r),cancelAnimationFrame(a),a=0,a=requestAnimationFrame(m)}};cancelAnimationFrame(a),a=requestAnimationFrame(m)},e.inputEvents.listen()}unlisten(){const e=this;e.inputEvents&&e.inputEvents.unlisten(),delete e.inputEvents}}class b{constructor(e){this.events={},this.handlers={},this.element=e}hasClass(e){const t=this,r=e.split(" ");for(let e=0;e<r.length;e++){if(!t.element.classList.contains(r[e]))return!1}return!0}addClass(e){const t=this;if(t.hasClass(e))return;const r=e.split(" ");for(let e=0;e<r.length;e++)t.element.classList.add(r[e]);t.isNativeElement||d.observeElement(t.element)}removeClass(e){const t=this;if(0===arguments.length)return void t.element.removeAttribute("class");const r=e.split(" ");for(let e=0;e<r.length;e++)t.element.classList.remove(r[e]);""===t.element.className&&t.element.removeAttribute("class"),t.isNativeElement||d.observeElement(t.element)}get isCustomElement(){const e=this;return!!e.element.tagName.startsWith(r)||(e.element instanceof window[r].BaseElement==!0||"DIV"!==e.element.tagName&&"SPAN"!==e.element.tagName&&"BUTTON"!==e.element.tagName&&"INPUT"!==e.element.tagName&&"UL"!==e.element.tagName&&"LI"!==e.element.tagName&&document.createElement(e.element.nodeName)instanceof window[r].BaseElement==!0)}get isNativeElement(){return!this.isCustomElement}dispatch(e){const t=this,r=t.events[e.type];let n=!1;if(r.length>1)for(let e=0;e<r.length;e++){const t=r[e];if(t.namespace&&t.namespace.indexOf("_")>=0){n=!0;break}}n&&r.sort((function(e,t){let r=e.namespace,n=t.namespace;return r=-1===r.indexOf("_")?0:parseInt(r.substring(r.indexOf("_")+1)),n=-1===n.indexOf("_")?0:parseInt(n.substring(n.indexOf("_")+1)),r<n?-1:r>n?1:0}));for(let n=0;n<r.length;n++){const o=r[n];if(e.namespace=o.namespace,e.context=o.context,e.defaultPrevented)break;const a=o.handler.apply(t.element,[e]);if(void 0!==a&&(e.result=a,!1===a)){e.preventDefault(),e.stopPropagation();break}}return e.result}fireEvent(e,t,r){const n=this;r||(r={bubbles:!0,cancelable:!0,composed:null!==n.element.getRootNode().host}),r.detail=t||{};const o=new CustomEvent(e,r);return o.originalStopPropagation=o.stopPropagation,o.stopPropagation=function(){return o.isPropagationStopped=!0,o.originalStopPropagation()},n.dispatchEvent(o),o}get isPassiveSupported(){const e=this;if(void 0!==e.supportsPassive)return e.supportsPassive;e.supportsPassive=!1;try{let t=Object.defineProperty({},"passive",{get:function(){e.supportsPassive=!0}});window.addEventListener("testPassive",null,t),window.removeEventListener("testPassive",null,t)}catch(e){}return e.supportsPassive}dispatchEvent(e){const t=this,r=e.type,n=t.element.context,o=r.substring(0,1).toUpperCase()+r.substring(1);t.element.context=document,t.element["on"+o]?t.element["on"+o](e):t.element["on"+r.toLowerCase()]?t.element["on"+r.toLowerCase()](e):t.element.dispatchEvent(e),t.element.context=n}listen(e,t){const r=this,n=e.split("."),o=n.slice(1).join("."),a=n[0];r.events[a]||(r.events[a]=[]);const i={type:a,handler:t,context:r.element,namespace:o};u.indexOf(a)>=0&&(r.inputEvents||(r.inputEvents=new p(r.element)),r.inputEvents[a]((function(e){r.dispatchEvent(e)})),r.inputEvents.boundEventTypes.push(a),r.inputEvents.listen(a)),0===r.events[a].length&&(r.handlers[a]=r.dispatch.bind(r),"wheel"===a?r.element.addEventListener("wheel",r.handlers[a],!!r.isPassiveSupported&&{passive:!1}):"touchmove"===a||"touchstart"===a||"touchend"===a?r.element.addEventListener(a,r.handlers[a],!!r.isPassiveSupported&&{passive:!1}):r.element.addEventListener(a,r.handlers[a],!1)),r.events[a].push(i)}unlisten(e){const t=this,r=e.split("."),n=r.slice(1).join("."),o=r[0];let a=t.events[o];if(t.inputEvents&&t.inputEvents.boundEventTypes.indexOf(o)>=0&&(t.inputEvents.boundEventTypes.splice(t.inputEvents.boundEventTypes.indexOf(o),1),0===t.inputEvents.boundEventTypes.length&&t.inputEvents.unlisten(o)),a){for(let e=0;e<a.length;e++){if(""!==n){let e=a.findIndex((e=>e.namespace===n));a.splice(e,1);break}a=[]}0===a.length&&(t.element.removeEventListener(o,t.handlers[o]),t.events[o]=[],delete t.handlers[o])}}getAttributeValue(e,t){const r=this,n=r.element.getAttribute(e);if(r.isNativeElement)return r.deserialize(n,t);const o=r.element.propertyByAttributeName[e];return void 0===o.deserialize?r.deserialize(n,t,o.nullable):r.element[o.deserialize](n)}setAttributeValue(e,t,r){const n=this;let o,a=!1;if(n.isNativeElement){if(o=n.serialize(t,r),"boolean"===r){if(["checked","selected","async","autofocus","autoplay","controls","defer","disabled","hidden","ismap","loop","multiple","open","readonly","required","scoped"].indexOf(e)>=0)return void(t?n.element.setAttribute(e,""):n.element.removeAttribute(e))}}else{const i=n.element.propertyByAttributeName[e];a=!i||i.nullable,o=i&&i.serialize?n.element[i.serialize](t):n.serialize(t,r,a)}"array"!==r&&"object"!==r||"[]"!==o&&"{}"!==o?void 0===o?(n.element.removeAttribute(e),n.element.shadowRoot&&n.element.$.root&&n.element.$.root.removeAttribute(e)):(n.element.setAttribute(e,o),n.element.shadowRoot&&n.element.$.root&&n.element.$.root.setAttribute(e,o)):n.element.removeAttribute(e)}serialize(e,t,r){if(void 0===t&&(t=f.Types.getType(e)),void 0===e||!r&&null===e)return;if(r&&null===e)return"null";if("string"===t)return e;if("boolean"===t||"bool"===t){if(!0===e||"true"===e||1===e||"1"===e)return"";if(!1===e||"false"===e||0===e||"0"===e)return}if("array"===t)return JSON.stringify(e);return["string","number","int","integer","float","date","any","function"].indexOf(t)>=0?e.toString():"object"===t?JSON.stringify(e):void 0}deserialize(e,t,r){const n="null"===e;if(void 0!==e&&(!n||r)){if(n&&r)return null;if("boolean"===t||"bool"===t)return null!==e;if("number"===t||"float"===t)return"NaN"===e?NaN:"Infinity"===e?1/0:"-Infinity"===e?-1/0:parseFloat(e);if("int"===t||"integer"===t)return"NaN"===e?NaN:"Infinity"===e?1/0:"-Infinity"===e?-1/0:parseInt(e);if("string"===t)return e;if("any"===t)return e;if("date"===t)return new Date(e);if("function"===t){if("function"==typeof window[e])return window[e]}else if("array"===t||"object"===t)try{const t=JSON.parse(e);if(t)return t}catch(r){if(window[e]&&"object"==typeof window[e])return window[e];if("array"===t&&e.indexOf("[")>=0){if(e.indexOf("{")>=0){let t=e.replace(/{/gi,"").replace("[","").replace("]","").replace(/'/gi,"").replace(/"/gi,"").trim();t=t.split("},");for(let e=0;e<t.length;e++){let r={},n=t[e].trim().split(",");for(let e=0;e<n.length;e++){const t=n[e].split(":")[0].trim(),o=n[e].split(":")[1].trim();r[t]=o}t[e]=r}return t}return e.replace("[","").replace("]","").replace(/'/gi,"").replace(/"/gi,"").trim().split(",")}}}}}class g{static get Ripple(){return a}static get Easings(){return i}}class f{static get Types(){return o}static get Core(){return s}static get Animation(){return g}static get Scroll(){return h}static get InputEvents(){return p}static Extend(e){return new b(e)}static Assign(e,t){if(e.indexOf(".")>=0){const r=e.split(".");return f[r[0]]||(f[r[0]]={}),void(f[r[0]][r[1]]=t)}f[e]=t}}const v=f.Extend(document);let w=null;document.addEventListener("click",(()=>{d.start(),w&&clearTimeout(w),w=setTimeout((()=>{d.stop()}),1e4)})),document.addEventListener("mouseenter",(()=>{d.start()})),document.addEventListener("mouseleave",(()=>{d.stop()}));class x{}x.cache={};class y extends HTMLElement{static get properties(){return{animation:{value:"advanced",type:"string",allowedValues:["none","simple","advanced"]},unfocusable:{value:!1,type:"boolean"},disabled:{value:!1,type:"boolean"},dataContext:{value:null,reflectToAttribute:!1,type:"any"},debugMode:{value:!0,type:"boolean",reflectToAttribute:!1},locale:{value:"en",type:"string",reflectToAttribute:!1},localizeFormatFunction:{value:null,type:"any",reflectToAttribute:!1},messages:{value:{en:{propertyUnknownName:"Invalid property name: '{{name}}'!",propertyUnknownType:"'{{name}}' property is with undefined 'type' member!",propertyInvalidValue:"Invalid '{{name}}' property value! Actual value: '{{actualValue}}', Expected value: '{{value}}'!",propertyInvalidValueType:"Invalid '{{name}}' property value type! Actual type: '{{actualType}}', Expected type: '{{type}}'!",methodInvalidValueType:"Invalid '{{name}}' method argument value type! Actual type: '{{actualType}}', Expected type: '{{type}}' for argument with index: '{{argumentIndex}}'!",methodInvalidArgumentsCount:"Invalid '{{name}}' method arguments count! Actual arguments count: '{{actualArgumentsCount}}', Expected at least: '{{argumentsCount}}' argument(s)!",methodInvalidReturnType:"Invalid '{{name}}' method return type! Actual type: '{{actualType}}', Expected type: '{{type}}'!",elementNotInDOM:"Element does not exist in DOM! Please, add the element to the DOM, before invoking a method.",moduleUndefined:"Module is undefined.",missingReference:"{{elementType}}: Missing reference to '{{files}}'.",htmlTemplateNotSuported:"{{elementType}}: Web Browser doesn't support HTMLTemplate elements.",invalidTemplate:"{{elementType}}: '{{property}}' property accepts a string that must match the id of an HTMLTemplate element from the DOM."}},reflectToAttribute:!1,inherit:!0,type:"object"},props:{value:null,reflectToAttribute:!1,isHierarchicalProperty:!0,type:"any"},readonly:{value:!1,type:"boolean"},renderMode:{value:"auto",type:"string",reflectToAttribute:!1,allowedValues:["auto","manual"]},rightToLeft:{value:!1,type:"boolean"},rethrowError:{value:!0,type:"boolean",reflectToAttribute:!1},theme:{value:window[r].Theme,type:"string"},visibility:{value:"visible",allowedValues:["visible","collapsed","hidden"],type:"string"},wait:{value:!1,type:"boolean"}}}getBindings(e,t){const r=this;let n=0,o={},a=(e=>{if(e instanceof HTMLElement)return r.parseAttributes(e);{let t=r.parseProperty(e.data?e.data.trim():null,"textContent",e);if(t)return r&&e.parentNode===r.$.content&&(t.value=""!==r.$.html?r.$.html:void 0,r.innerHTML=""),{textContent:t}}})(e);a&&(o.data=a),t||(o.mapping=[],t=o),e.getAttribute&&(o.nodeId=e.getAttribute("smart-id"),t&&a&&(t.mapping[o.nodeId]=a)),o.node=e,e.firstChild&&(o.children={});for(let a=e.firstChild;a;a=a.nextSibling)o.children[n++]=r.getBindings(a,t);return o}_addRemovePropertyBinding(e,t,r,n,o){if(!e||!t||!r)return;const a=this,i=a.bindings,s=r.getAttribute("smart-id"),l=e.indexOf("{{")>=0;let d=!1;(e=e.replace("{{","").replace("}}","").replace("[[","").replace("]]","")).indexOf("!")>=0&&(e=e.replace("!",""),d=!0);const m=a._properties[e],c={name:e,reflectToAttribute:m.reflectToAttribute,twoWay:l,type:m.type,not:d};if(o&&!n){const r={},n={name:e,targetPropertyName:t,reflectToAttribute:m.reflectToAttribute,twoWay:l,type:m.type,not:d};r[e]=n,i.mapping[s]=r}const u=function(e){for(let o in e){const i=e[o];if(i.nodeId===s){i.data||(i.data={}),n?(i.data[t]=null,delete i.data[t]):i.data[t]=c;break}if(i.children)u(i.children);else if(i.node&&i.node.children&&i.node===r.parentElement){const e=i.node;if(!e.firstChild)continue;i.children={};let t=0;for(let r=e.firstChild;r;r=r.nextSibling)i.children[t++]=a.getBindings(r);u(i.children)}}};u(i.children),n?delete a.boundProperties[e]:a.boundProperties[e]=!0,a.updateBoundNodes(e)}addPropertyBinding(e,t,r,n){this._addRemovePropertyBinding(e,t,r,!1,n)}removePropertyBinding(e,t,r,n){this._addRemovePropertyBinding(e,t,r,!0,n)}parseAttributes(e){const t=this;let r;for(let n=0;n<e.attributes.length;n++){const o=e.attributes[n],a=o.name,i=o.value;x.cache["toCamelCase"+a]||(x.cache["toCamelCase"+a]=f.Core.toCamelCase(a));const s=x.cache["toCamelCase"+a];if(a.indexOf("(")>=0){let n=a.substring(1,a.length-1);if(t&&!t.dataContext){t.templateListeners[e.getAttribute("smart-id")+"."+n]=i,e.removeAttribute(a);continue}{r||(r={});const e=i.substring(0,i.indexOf("("));r[s]={isEvent:!0,name:n,value:e};continue}}let l=t.parseProperty(i,a,e);l&&(r||(r={}),r[s]=l)}return r}parseProperty(e,t){if(!e||!e.length)return;const r=this;let n,o=e.length,a=0,i=0,s=0,l=!0;for(;i<o;){a=e.indexOf("{{",i);let t=e.indexOf("[[",i),r="}}";if(t>=0&&(a<0||t<a)&&(a=t,l=!1,r="]]"),s=a<0?-1:e.indexOf(r,a+2),s<0)return;n=n||{};let o=e.slice(a+2,s).trim();n.name=o,i=s+2}const d=n.name,m=r?r._properties[d]:null;if(n.twoWay=l,n.ready=!1,r&&(d.indexOf("::")>=0?r.boundProperties[d.substring(0,d.indexOf("::"))]=!0:r.boundProperties[d]=!0),m)n.type=m.type,n.reflectToAttribute=m.reflectToAttribute;else{["checked","selected","async","autofocus","autoplay","controls","defer","disabled","hidden","ismap","loop","multiple","open","readonly","required","scoped"].indexOf(t)>=0?n.type="boolean":n.type="string",n.reflectToAttribute=!0}return n}updateTextNodes(){const e=this;e.updateTextNode(e.shadowRoot||e,e.bindings,e)}updateTextNode(e,t,r){const n=this;if(!t)return;let o=0;for(let a=e.firstChild;a&&t.children;a=a.nextSibling)n.updateTextNode(a,t.children[o++],r);if(t&&t.data)for(let e in t.data){const n=t.data[e],o=n.name;"textContent"===e&&n.twoWay&&!n.updating&&void 0!==n.value&&(r[o]=n.value)}}updateBoundProperty(e,t){if(t.updating)return;const r=this;t.updating=!0,r[e]=t.value,t.updating=!1}updateBoundNodes(e){const t=this;if(t.updateBoundNode(t.shadowRoot||t,t.bindings,t,e),t.detachedChildren.length>0)for(let r=0;r<t.detachedChildren.length;r++){const n=t.detachedChildren[r],o=n.getAttribute("smart-id"),a=function(e){if(e.nodeId===o)return e;for(let t in e.children){const r=e.children[t];if((r.getAttribute?r.getAttribute("smart-id"):"")===o)return e;if(r.children){const e=a(r);if(e)return e}}return null},i=a(t.bindings);if(i)t.updateBoundNode(n,i,t,e,!0);else if(n.getAttribute&&t.bindings.mapping){const r=t,n=t.bindings;if(n)for(let o in n.mapping){const a=r.querySelector('[smart-id="'+o+'"]');if(a){const i=n.mapping[o];t.updateBoundData(a,i,r,e)}}}}}updateBoundMappedNodes(){const e=this,t=e.bindings,r=e;if(t.mapping)for(let n in t.mapping){let o=r.querySelector('[smart-id="'+n+'"]');if(r.shadowRoot&&(o=r.querySelector('[id="'+n+'"]'),o||(o=r.shadowRoot.querySelector('[id="'+n+'"]')||r.shadowRoot.querySelector('[smart-id="'+n+'"]'))),o){const a=t.mapping[n];e.updateBoundData(o,a,r)}else if(r.getAttribute("aria-controls")){let a=document.getElementById(r.getAttribute("aria-controls"));if(!a&&r.shadowRoot&&(a=r.shadowRoot.getElementById(r.getAttribute("aria-controls"))),o=a.querySelector('[smart-id="'+n+'"]'),o){const a=t.mapping[n];e.updateBoundData(o,a,r)}}}}updateBoundNode(e,t,r,n,o){const a=this;if(!t)return;let i=0;if(o){if(o&&!t.data)for(let s=e.firstChild;s&&t.children;s=s.nextSibling)if(s.getAttribute){const e=s.getAttribute("smart-id"),o=function(){for(let r in t.children)if(t.children[r].nodeId===e)return t.children[r]}();a.updateBoundNode(s,o,r,n),i++}else a.updateBoundNode(s,t.children[i++],r,n,o)}else for(let o=e.firstChild;o&&t.children;o=o.nextSibling)if(o.getAttribute){const e=o.getAttribute("smart-id"),s=function(){for(let r in t.children)if(t.children[r].nodeId===e)return t.children[r]}();a.updateBoundNode(o,s,r,n),i++}else a.updateBoundNode(o,t.children[i++],r,n);if(!t||!t.data)return;const s=t.data;a.updateBoundData(e,s,r,n)}updateBoundData(e,t,r,n){const o=this;for(let a in t){const i=t[a];let s=i.name;if(!i.updating&&(s.indexOf("::")>=0&&(s=s.substring(0,s.indexOf("::"))),void 0===n||n===s)){if(s.indexOf("(")>=0){let e=s.substring(s.indexOf("("));const t=s.substring(0,s.indexOf("("));if(e=e.substring(1,e.length-1),e=e.replace(/ /gi,""),e=e.split(","),e.length>0&&""!==e[0]){let n=[];for(let t=0;t<e.length;t++)n.push(r[e[t]]);i.value=r[t].apply(r,n)}else i.value=r[t]();i.type=typeof i.value}else i.value=r[s];if("innerHTML"===s){if(e[a].toString().trim()!==r[s].toString().trim()){if(window.smartBlazor&&e[a].indexOf("\x3c!--")>=0){(i.ready||r._properties[s].defaultValue!==i.value)&&(e[a]=i.value.toString());continue}(i.ready||r._properties[s].defaultValue!==i.value)&&(e[a]=i.value.toString().trim())}}else i.not?(e[a]=!i.value,i.targetPropertyName&&(e[i.targetPropertyName]=!i.value)):(e[a]=i.value,i.targetPropertyName&&(e[i.targetPropertyName]=i.value));if(e.$&&e.$.isNativeElement){x.cache["toDash"+a]||(x.cache["toDash"+a]=f.Core.toDash(a));const t=x.cache["toDash"+a],r=e.$.getAttributeValue(t,i.type);!i.reflectToAttribute||r===i.value&&i.ready||e.$.setAttributeValue(t,i.value,i.type),i.reflectToAttribute||e.$.setAttributeValue(t,null,i.type)}if(!i.ready){if(e.$&&e.$.isCustomElement){x.cache["toDash"+a]||(x.cache["toDash"+a]=f.Core.toDash(a));const t=x.cache["toDash"+a];e._properties||(e._beforeCreatedProperties=e._properties=e.propertyByAttributeName=[]),e._properties[a]||(e._properties[a]={attributeName:t},e._beforeCreatedProperties&&(e._beforeCreatedProperties[a]=e._properties[a]),e.propertyByAttributeName[t]=e._properties[a]);const r=e._properties[a];r.isUpdating=!0,i.reflectToAttribute&&(i.not?e.$.setAttributeValue(r.attributeName,!i.value,i.type):e.$.setAttributeValue(r.attributeName,i.value,i.type)),i.reflectToAttribute||e.$.setAttributeValue(r.attributeName,null,i.type),r.isUpdating=!1}if(i.twoWay){const t=function(t){if(i.value=t,e.$&&e.$.isNativeElement){x.cache["toDash"+a]||(x.cache["toDash"+a]=f.Core.toDash(a));const t=x.cache["toDash"+a],r=e.$.getAttributeValue(t,i.type);i.reflectToAttribute&&r!==i.value&&e.$.setAttributeValue(t,i.value,i.type),i.reflectToAttribute||e.$.setAttributeValue(t,null,i.type)}};if(i.name.indexOf("::")>=0){const r=i.name.indexOf("::"),n=i.name.substring(r+2);o["$"+e.getAttribute("smart-id")].listen(n,(function(){t(e[a]);const r=i.name.substring(0,i.name.indexOf("::"));o.updateBoundProperty(r,i)}))}if(e.$&&e.$.isCustomElement){e._properties[a]&&(e._properties[a].notify=!0),x.cache["toDash"+a]||(x.cache["toDash"+a]=f.Core.toDash(a));const r=x.cache["toDash"+a];o["$"+e.getAttribute("smart-id")].listen(r+"-changed",(function(e){let r=e.detail;t(r.value);const n=o.context;e.context!==document&&(o.context=o),o.updateBoundProperty(i.name,i),o.context=n}))}}}i.ready=!0}}}static clearCache(){this.cache={}}addMessages(e,t){Object.assign(this.messages[e],t)}localize(e,t){const r=this;if(!r.messages||!r.messages[r.locale])return;let n=r.messages[r.locale][e];if(""===n)return"";if(!n){const n=r.messages.en;if(n){let r=n[e];if(r){for(let e in t){let n=t[e];r=r.replace(new RegExp("{{"+e+"}}","g"),n)}return r}return e}}const o=n;for(let e in t){let r=t[e];n=n.replace(new RegExp("{{"+e+"}}","g"),r)}if(r.localizeFormatFunction){const a=r.localizeFormatFunction(o,n,t,e);if(void 0!==a)return a}return n}static get requires(){return{}}static get listeners(){return{"theme-changed":function(e){this.theme=e.detail.newValue}}}static get methods(){return{}}get classNamesMap(){return{animation:"smart-animate",rippleAnimation:"smart-ripple"}}get hasAnimation(){return"none"!==this.animation}get hasRippleAnimation(){return"none"!==this.animation&&"advanced"===this.animation}static get modules(){return window[r].Modules}get properties(){const e=this;return e._properties||(e._properties=[]),e._properties}get parents(){const e=this;let t=[],n=e.parentNode;for(;n&&9!==n.nodeType;)n instanceof HTMLElement==!0&&t.push(n),n=n.parentNode;const o=e.getRootNode();if(o.host){const e=e=>{let t=[e],r=e.parentNode;for(;r&&9!==r.nodeType;)r instanceof HTMLElement==!0&&t.push(r),r=r.parentNode;return t};t=t.concat(e(o.host))}return window[r].EnableShadowDOM&&e.isInShadowDOM&&e.shadowParent&&(t=t.concat(e.shadowParent.parents)),t}log(e){this._logger("log",e)}warn(e){this._logger("warn",e)}error(e){this._logger("error",e)}_logger(e,t){if(this.debugMode){const r=t instanceof Error?t.message:t.toString();console[e](r)}if(this.rethrowError&&"error"===e)throw t}get focused(){return this.contains(document.activeElement)}template(){return"<div></div>"}registered(){const e=this;e.onRegistered&&e.onRegistered()}created(){const e=this;e.isReady=!1,e._initElement(e),e._setModuleState("created"),e.onCreated&&e.onCreated()}completed(){const e=this;e.isCompleted=!0,e._onCompleted&&e._onCompleted(),e.onCompleted&&e.onCompleted()}whenReady(e){const t=this;t.isCompleted?e():(t.whenReadyCallbacks||(t.whenReadyCallbacks=[]),t.whenReadyCallbacks.push(e))}whenRendered(e){const t=this;t.isRendered?e():(t.whenRenderedCallbacks||(t.whenRenderedCallbacks=[]),t.whenRenderedCallbacks.push(e))}addThemeClass(){const e=this;""!==e.theme&&e.classList.add("smart-"+e.theme)}addDefaultClass(){const e=this;e.classList.add(r.toLowerCase()+"-element"),e.classList.add(e.nodeName.toLowerCase())}_renderShadowRoot(){const e=this;if(e.shadowRoot){e.$.root.classList.add(e.nodeName.toLowerCase());for(let t=0;t<e.attributes.length;t++){const r=e.attributes[t];"class"===r.name||"id"===r.name||"style"===r.name||"tabindex"===r.name||r.name.indexOf("aria")>=0||e.$.root.setAttribute(r.name,r.value)}for(let t=0;t<e.classList.length;t++){const r=e.classList[t];"smart-element-init"!==r&&"smart-element"!==r&&"smart-hidden"!==r&&"smart-visibility-hidden"!==r&&e.$.root.classList.add(r)}}}render(){const e=this;if(!e.isRendered&&(e.isRendered=!0,e.isRendering=!1,e.context=document,e._renderShadowRoot(),e.whenRenderedCallbacks)){for(let t=0;t<e.whenRenderedCallbacks.length;t++)e.whenRenderedCallbacks[t]();e.whenRenderedCallbacks=[]}e.onRender&&e.onRender(),e.disabled&&e.setAttribute("aria-disabled",!0),e.readonly&&-1!==["checkbox","combobox","grid","gridcell","listbox","radiogroup","slider","spinbutton","textbox"].indexOf(e.getAttribute("role"))&&e.setAttribute("aria-readonly",!0)}ready(){const e=this;if(e._setId(),e.addThemeClass(),e.addDefaultClass(),"collapsed"===e.visibility?e.classList.add("smart-hidden"):"hidden"===e.visibility&&e.classList.add("smart-visibility-hidden"),e.dataContext&&e.applyDataContext(),e.onReady&&e.onReady(),e.shadowRoot&&Smart(e._selector)){if(Smart(e._selector).styleUrls){const t=Smart(e._selector).styleUrls;for(let r=0;r<t.length;r++)e.importStyle(t[r])}if(Smart(e._selector).styles){const t=document.createElement("style");t.innerHTML=Smart(e._selector).styles,e.shadowRoot.insertBefore(t,e.shadowRoot.firstChild)}}Smart(e._selector)&&Smart(e._selector).ready&&Smart(e._selector).ready()}_setId(){const e=this;if(!e.id){const t=e.elementName;e.id=t.slice(0,1).toLowerCase()+t.slice(1)+Math.floor(65536*(1+Math.random())).toString(16).substring(1)}}checkLicense(){const e=this;"Evaluation"===window[r].License&&-1===window.location.hostname.indexOf("htmlelements")&&(e.logWatermark(),e.logLicense(),window[r].License="")}logWatermark(){const e=document.createElement("a");e.href="https://www.htmlelements.com/",e.innerHTML="https://www.htmlelements.com/",e.style.position="absolute",e.style.right="5px",e.style.bottom="5px",e.style.color="#fff",e.style.padding="20px",e.style.borderRadius="5px",e.style.background="#0C3D78",e.style.cursor="pointer",e.style.zIndex="999999",e.style.display="block",e.style.fontSize="24px",e.style.textDecoration="none",e.style.fontWeight="bold",e.style.opacity=0,e.style.transition="opacity .35s ease-in-out",e.id="watermark",document.getElementById("watermark")||setTimeout((()=>{document.getElementById("watermark")||(document.body.appendChild(e),setTimeout((()=>{e.style.opacity=1})),setTimeout((()=>{e.style.opacity=0,setTimeout((()=>{e.parentNode.removeChild(e)}),350)}),6e3))}),1e3)}logLicense(){console.log("****************************************************************************************************************"),console.log("****************************************************************************************************************"),console.log("****************************************************************************************************************"),console.log("*jQWidgets License Key Not Found."),console.log("*This is an EVALUATION only Version, it is NOT Licensed for software projects intended for PRODUCTION."),console.log("*if you want to hide this message, please send an email to: sales@jqwidgets.com for a license."),console.log("****************************************************************************************************************"),console.log("****************************************************************************************************************"),console.log("****************************************************************************************************************")}get _selector(){const e=this;return e.id?"#"+e.id:e.classList.length>0?"."+e.classList[0]:""}applyDataContext(e){const t=this;let r="string"==typeof t.dataContext?window[t.dataContext]||document[t.dataContext]:t.dataContext;if(e&&(r=e,t.dataContext=e),r){if(!r._uid){r._uid=(Date.now().toString(36)+Math.random().toString(36).substr(2,5)).toUpperCase(),r._properties=[];for(let e in r){const n=r[e];"function"!=typeof n&&"_properties"!==e&&"_uid"!==e&&(r._properties[e]=n,Object.defineProperty(r,e,{configurable:!1,enumerable:!0,get:()=>r._properties[e],set(n){const o=r._properties[e];r._properties[e]=n;let a=[];a[e]={oldValue:o,value:n},a.length++,t.updatingDataContext=!0,v.fireEvent("dataContextPropertyChanged",{dataContext:r,properties:a},{bubbles:!1,cancelable:!0}),t.updatingDataContext=!1}}))}}if(t.dataContextProperties=t.parseAttributes(t),t.dataContextPropertiesMap={},t.dataContextListeners={},t.dataContextProperties){t.updatingDataContext=!0;for(let e in t.dataContextProperties){const n=t.dataContextProperties[e],o=n.name;if(n.propertyName=e,t.dataContextPropertiesMap[o]=e,x.cache["toDash"+e]||(x.cache["toDash"+e]=f.Core.toDash(o)),n.isEvent){const e=n.value;t.dataContextListeners[o]&&t.removeEventListener(o,t.dataContextListeners[o]),t.dataContextListeners[o]=function(t){r[e](t)},t.addEventListener(o,t.dataContextListeners[o])}if(o.indexOf(".")>=0){const n=o.split(".");let a=r[n[0]];for(let e=1;e<n.length;e++)a=a[n[e]];void 0!==a&&(t[e]=a)}else t[e]=r[o]}t.dataContextPropertyChangedHandler=function(e){const r=e.detail.properties;if(e.detail.dataContext===("string"==typeof t.dataContext?window[t.dataContext]||document[t.dataContext]:t.dataContext))for(let e in r){const n=t.dataContextPropertiesMap[e],o=t.context;n&&(t.context=document,t[n]=r[e].value,t.context=o)}},v.listen("dataContextPropertyChanged",t.dataContextPropertyChangedHandler),t.updatingDataContext=!1}else t.dataContextProperties=null}else{t.dataContextProperties=null;const e=function(){("string"==typeof t.dataContext?window[t.dataContext]||document[t.dataContext]:t.dataContext)&&(t.applyDataContext(),window.removeEventListener("load",e))};window.addEventListener("load",e)}}updateDataContextProperty(e){const t=this,r="string"==typeof t.dataContext?window[t.dataContext]||document[t.dataContext]:t.dataContext,n=t.dataContextProperties[e];if(!t.updatingDataContext&&n.twoWay){const o=n.name;if(o.indexOf(".")>=0){const n=o.split(".");let a=r[n[0]];for(let e=1;e<n.length;e++)a=a[n[e]];void 0!==a&&(a=t[e],m[r._uid]&&(m[r._uid][e]=a))}else r[o]=t[e],m[r._uid]&&(m[r._uid][e]=r[o])}}static get version(){return window[r].Version}initProperties(){const e=this;if(Smart(e._selector)&&Smart(e._selector).properties&&(e._initProperties=Smart(e._selector).properties),e.hasAttribute("props")&&!e.props?e._initProperties=window[e.getAttribute("props")]:e.props&&(e._initProperties=e.props),e._initProperties){const t=Object.keys(e._initProperties);for(let r=0;r<t.length;r++){const n=t[r],o=e._initProperties[n];if(void 0!==o){if(o.constructor===Smart.ObservableArray||o instanceof Smart.ObservableArray){e[n]=o.toArray();continue}if(o.constructor===Smart.DataAdapter||"smartDataAdapter"===o.constructor.name||"object"==typeof o&&Smart.DataAdapter&&o instanceof Smart.DataAdapter||o instanceof Smart.Observable||o.constructor===Smart.Observable||"object"!=typeof o||f.Types.isArray(o)||o instanceof Date){if(void 0===e[n]&&-1===["onReady","onAttached","onDetached","onCreated","onCompleted"].indexOf(n)){const t=e.localize("propertyUnknownName",{name:n});e.log(t)}e[n]=o;continue}}if("messages"!==n)if("dataSourceMap"!==n&&"rowCSSRules"!==n){if(o&&"object"==typeof o){const t=function(r,n){const o=Object.keys(r);for(let a=0;a<o.length;a++){const i=o[a],s=r[i],l=e._properties[n+"_"+i];if(l&&null===l.value){if(void 0===e[n+"_"+i]){const t=e.localize("propertyUnknownName",{name:n+"_"+i});e.log(t)}e[n+"_"+i]=s}else if("object"==typeof s&&!f.Types.isArray(s)&&s&&s.constructor!==Date)t(s,n+"_"+i);else{if(void 0===e[n+"_"+i]){const t=e.localize("propertyUnknownName",{name:n+"_"+i});e.log(t)}e[n+"_"+i]=s}}};t(o,n)}}else e[n]=o;else e[n]=Object.assign(e[n],o)}}}setProperties(e){const t=this,r=Object.keys(e);for(let n=0;n<r.length;n++){const o=r[n],a=e[o];if(a.constructor===Smart.ObservableArray||a instanceof Smart.ObservableArray)t[o]=a.toArray();else if(a.constructor===Smart.DataAdapter||"smartDataAdapter"===a.constructor.name||"object"==typeof a&&Smart.DataAdapter&&a instanceof Smart.DataAdapter||a instanceof Smart.Observable||a.constructor===Smart.Observable||"object"!=typeof a||f.Types.isArray(a)||a instanceof Date){if(void 0===t[o]&&-1===["onReady","onAttached","onDetached","onCreated","onCompleted"].indexOf(o))continue;const e=t._properties[o];"int"===e.type||"number"===e.type&&"string"==typeof subPropertyValue?"int"===e.type?t[o]=parseInt(a):t[o]=parseFloat(a):t[o]=a}else if("messages"!==o&&"dataSourceMap"!==o){if("object"==typeof a){const e=function(r,n){const o=Object.keys(r);for(let a=0;a<o.length;a++){const i=o[a],s=r[i],l=t._properties[n+"_"+i];if(l&&null===l.value){if(void 0===t[n+"_"+i])continue;const e=t._properties[n+"_"+i];"int"===e.type||"number"===e.type&&"string"==typeof s?"int"===e.type?t[n+"_"+i]=parseInt(s):t[n+"_"+i]=parseFloat(s):t[n+"_"+i]=s}else if("object"==typeof s&&!f.Types.isArray(s)&&s&&s.constructor!==Date)e(s,n+"_"+i);else{if(void 0===t[n+"_"+i])continue;const e=t._properties[n+"_"+i];"int"===e.type||"number"===e.type&&"string"==typeof s?"int"===e.type?t[n+"_"+i]=parseInt(s):t[n+"_"+i]=parseFloat(s):t[n+"_"+i]=s}}};e(a,o)}}else t[o]=a}}setup(){const e=this;if(e.context=this,e.isReady&&!e.isCompleted)return;if(e.isReady)return e._setModuleState("attached"),e.isAttached=!0,e.attached(),e._handleListeners("listen"),void(e.context=document);e.ownerElement&&e.ownerElement.detachedChildren.indexOf(e)>=0&&e.ownerElement.detachedChildren.splice(e.ownerElement.detachedChildren.indexOf(e),1),e.isReady=!0,e.methods=e.getStaticMember("methods"),e.initProperties();s.isMobile&&e.classList.add("smart-mobile");for(let t=0;t<e.attributes.length;t+=1){const r=e.propertyByAttributeName[e.attributes[t].name];if(!r)continue;let n=e.$.getAttributeValue(r.attributeName,r.type);const o=n?n.toString():"";if(!(o.indexOf("{{")>=0||o.indexOf("[[")>=0)&&(("object"===r.type||"array"===r.type||!(e.attributes[t].value.indexOf("{{")>=0||e.attributes[t].value.indexOf("[[")>=0))&&void 0!==n&&r.value!==n)){const o=f.Types.getType(n),a=e.attributes[t].value;if(("any"===r.type||"object"===r.type)&&""+e[r.name]===n)continue;if("array"===r.type&&e[r.name]&&JSON.stringify(e[r.name])===n)continue;if("number"===o&&isNaN(n)&&"NaN"!==a&&"Infinity"!==a&&"-Infinity"!==a){const t=e.localize("propertyInvalidValueType",{name:r.name,actualType:"string",type:r.type});e.log(t)}r.isUpdatingFromAttribute=!0,e[r.name]=n,r.isUpdatingFromAttribute=!1}}for(let t in e._properties){const r=e._properties[t];if("innerHTML"===t&&r.value===r.defaultValue&&(r.value=r.defaultValue=f.Core.html(e)),"boolean"!==r.type&&"bool"!==r.type||"false"===e.getAttribute(r.attributeName)&&(r.isUpdating=!0,e.setAttribute(r.attributeName,""),r.isUpdating=!1),r.defaultReflectToAttribute&&r.reflectToAttribute){if(r.defaultReflectToAttribute&&r.defaultReflectToAttributeConditions){let t=!0;for(let n=0;n<r.defaultReflectToAttributeConditions.length;n++){const o=r.defaultReflectToAttributeConditions[n];let a,i;for(let e in o)a=e,i=o[e];e._properties[a]&&e._properties[a].value!==i&&(t=!1)}if(!t)continue}r.isUpdating=!0,e.$.setAttributeValue(r.attributeName,r.value,r.type),r.isUpdating=!1}}const t=[];if(e.children.length>0)for(let r=0;r<e.children.length;r++){const n=e.children[r];f.Extend(n).isCustomElement&&t.push(n)}e.applyTemplate(),e.complete=function(){if(!e.templateBindingsReady){const t=e=>{e.templateBindingsReady||(e.templateBindingsReady=!0,e.updateTextNodes(),e.updateBoundNodes())};if(e.ownerElement){let r=e.ownerElement,n=[];for(;r;)n.push(r),r=r.ownerElement;for(let e=n.length-1;e>=0;e--)t(n[e]);t(e)}else t(e)}const t=()=>{if(e._setModuleState("ready"),e.ready(),"auto"!==e.renderMode||e.isRendered||e.render(),e.isAttached=!0,e._setModuleState("attached"),e.attached(),e._handleListeners("listen"),e.isHidden||0!==e.offsetWidth&&0!==e.offsetHeight||(e.isHidden=!0),e.completed(),e.isRendered&&(e.context=document),e.whenReadyCallbacks){for(let t=0;t<e.whenReadyCallbacks.length;t++)e.whenReadyCallbacks[t]();e.whenReadyCallbacks=[]}};if(e.wait)e.classList.add("smart-visibility-hidden");else if(e.classList.contains("smart-async"))requestAnimationFrame((()=>{t()}));else{const r=e.shadowParent;e.shadowParent=null;const n=e.parents;if(e.shadowParent=r,0===n.length)return;const o=()=>{let t=e.ownerElement,r=[];for(;t;)r.push(t),t=t.ownerElement;for(let e=r.length-1;e>=0;e--)r[e].updateBoundMappedNodes()};e.ownerElement&&"HTML"!==n[n.length-1].nodeName?e.getRootNode().host?t():e.ownerElement&&"HTML"===e.ownerElement.parents[e.ownerElement.parents.length-1].nodeName?(o(),t()):e.checkIsInDomInterval=setInterval((()=>{const r=e.parents;"HTML"===r[r.length-1].nodeName&&(clearInterval(e.checkIsInDomInterval),o(),t())}),100):t()}};let n=[].slice.call(e.querySelectorAll("[smart-id]")).concat(t);if(window[r].EnableShadowDOM&&!0!==e.isInShadowDOM&&(n=[].slice.call(e.shadowRoot.querySelectorAll("[smart-id]")).concat(t)),0===n.length)e.complete();else{e._completeListeners=0;for(let t=0;t<n.length;t++){const r=n[t];if(f.Extend(r).isCustomElement){const t=function(){e._completeListeners--,0===e._completeListeners&&(e.complete(),delete e._completeListeners)}.bind(e);r.isCompleted||r.isUtilityElement||!0===r.wait||(e._completeListeners++,r._onCompleted||(r.completeHandlers=[],r._onCompleted=function(){for(let e=0;e<r.completeHandlers.length;e++)r.completeHandlers[e]()}),r.completeHandlers.push(t))}}0===e._completeListeners&&e.complete()}}visibilityChangedHandler(){const e=this;e.isReady&&requestAnimationFrame((()=>{0===e.offsetWidth||0===e.offsetHeight?e.isHidden=!0:(e.isHidden=!1,e.$.fireEvent("resize",e,{bubbles:!1,cancelable:!0}))}))}attributeChangedCallback(e,t,r){const n=this,o=n.propertyByAttributeName[e];if("class"!==e&&"style"!==e||n.visibilityChangedHandler(),o||n.attributeChanged(e,t,r),n.onAttributeChanged&&n.onAttributeChanged(e,t,r),!o||o&&o.isUpdating)return;let a=n.$.getAttributeValue(o.attributeName,o.type);void 0!==r&&n[o.name]!==a&&(o.isUpdatingFromAttribute=!0,n[o.name]=void 0!==a?a:n._properties[o.name].defaultValue,o.isUpdatingFromAttribute=!1)}attributeChanged(e,t,r){}set hasStyleObserver(e){const t=this;void 0===t._hasStyleObserver&&(t._hasStyleObserver=e),e?d.watch(t):d.unwatch(t)}get hasStyleObserver(){const e=this;return void 0===e._hasStyleObserver||e._hasStyleObserver}attached(){const e=this;e.hasStyleObserver&&d.watch(e),e.onAttached&&e.onAttached(),Smart(e._selector)&&Smart(e._selector).attached&&Smart(e._selector).attached()}detached(){const e=this;e.hasStyleObserver&&d.unwatch(e),e._setModuleState("detached"),e.isAttached=!1,e.ownerElement&&-1===e.ownerElement.detachedChildren.indexOf(e)&&e.ownerElement.detachedChildren.push(e),e._handleListeners("unlisten"),e.onDetached&&e.onDetached(),Smart(e._selector)&&Smart(e._selector).detached&&Smart(e._selector).detached(),c&&c[e._selector]&&delete c[e._selector]}propertyChangedHandler(e,t,r){const n=this;t!==r&&("theme"===e&&(""!==t&&n.classList.remove("smart-"+t),""!==r&&n.classList.add("smart-"+r)),"visibility"===e?("collapsed"===t?n.classList.remove("smart-hidden"):"hidden"===t&&n.classList.remove("smart-visibility-hidden"),"collapsed"===r?n.classList.add("smart-hidden"):"hidden"===r&&n.classList.add("smart-visibility-hidden")):("disabled"===e||"readonly"===e)&&n._ariaPropertyChangedHandler(e,r),n.propertyChanged&&n.propertyChanged(e,t,r))}_ariaPropertyChangedHandler(e,t){const r=this;"readonly"===e&&-1===["checkbox","combobox","grid","gridcell","listbox","radiogroup","slider","spinbutton","textbox"].indexOf(r.getAttribute("role"))||(t?r.setAttribute("aria-"+e,!0):r.removeAttribute("aria-"+e))}_handleListeners(e){const t=this,r=t.tagName.toLowerCase(),n=n=>{for(let o in n){const a=o.split(".");let i=a[0],s=t.$;if(a[1])if(i=a[1],s=t["$"+a[0]],"document"===a[0]){let e=t.smartId;""===e&&(e=f.Core.toCamelCase(r)),i=i+"."+e}else t.smartId&&(i=i+"."+t.smartId+"_"+t.parents.length);else t.smartId&&(i=i+"."+t.smartId);const l=n[o],d=function(e){const r=t.context;t.context=t,t[l]&&t[l].apply(t,[e]),t.context=r};s&&s[e](i,d)}};n(t.getStaticMember("listeners")),n(t.templateListeners),Smart(t._selector)&&Smart(t._selector).properties&&n(Smart(t._selector).listeners)}parseTemplate(){const e=this,r=e.template(),o=document.createDocumentFragment();if(t[e.nodeName]&&!n)return t[e.nodeName].cloneNode(!0);if(""===r)return null;let a=document.createElement("div");o.appendChild(a),a.innerHTML=r;let i=a.childNodes;a.parentNode.removeChild(a);for(let e=0;e<i.length;e++)o.appendChild(i[e]);return t[e.nodeName]=o,n?o:o.cloneNode(!0)}applyTemplate(){const e=this,t=e.parseTemplate();if(!t)return;if(!t.hasChildNodes)return;const r=t.childNodes[0],n=(t,r)=>{e["$"+t]=r.$=f.Extend(r),e.$[t]=r,r.ownerElement=e};let o=r;if(r.getElementsByTagName("content").length>0){let e=r.getElementsByTagName("content")[0];o=e.parentNode,o.removeChild(e)}else{const e=t.querySelectorAll("[inner-h-t-m-l]");e&&e.length>0&&(o=e[0])}e.$.template="template"===r.nodeName.toLowerCase()?r:r.querySelector("template");let a=t.querySelectorAll("[id]");0===a.length&&(a=t.querySelectorAll("*")),n("root",r),n("content",o),e.$.html=e.innerHTML.toString().trim();for(let t=0;t<a.length;t+=1){let r=a[t];""===r.id&&(r.id="child"+t),n(r.id,r),r.setAttribute("smart-id",r.id),e.shadowRoot?r.shadowParent=e:r.removeAttribute("id")}for(!1!==e.hasTemplateBindings?e.bindings=e.getBindings(t):e.bindings=[],e.$root.addClass("smart-container");e.childNodes.length;)o.appendChild(e.firstChild);if(e.appendTemplate(t),e.$.template){const t=document.createElement("div");t.classList.add("smart-template-container"),e.$.templateContainer=t,e.$.template.parentNode.insertBefore(t,e.$.template),e.refreshTemplate()}}refreshTemplate(){const e=this;if(!e.$.templateContainer)return;e.templateDetached(e.$.templateContainer);const t=e.$.template.content.cloneNode(!0);e.templateBindings=e.getBindings(t),e.templateProperties=[];let r=document.createDocumentFragment();const n=function(t,r,o){for(let a in t){const i=t[a],s=i.node.cloneNode();r.appendChild(s);let l=[],d=!1;if(i.data)for(let t in i.data){const n=i.data[t],a=n.name;if(e.templateProperties[a]=!0,s.removeAttribute(f.Core.toDash(t)),"*items"===t)l=e[a],d=!0;else if(a.indexOf("item.")>=0&&void 0!==o)n.value=o[a.substring("item.".length)],s[t]=n.value;else if(a.indexOf("item")>=0&&void 0!==o)n.value=o,s[t]=n.value;else if("*if"===t)if(a.indexOf("(")>=0){let t,n=a.substring(a.indexOf("("));const o=a.substring(0,a.indexOf("("));if(n=n.substring(1,n.length-1),n=n.replace(/ /gi,""),n=n.split(","),n.length>0&&""!==n[0]){let r=[];for(let t=0;t<n.length;t++)r.push(e[n[t]]);t=e[o].apply(e,r)}else t=e[o]();!1===t&&r.removeChild(s)}else e[a]||r.removeChild(s);else e.updateBoundNode(s,i,e,a)}if(l.length>0||d){for(let e=0;e<l.length;e++)i.children&&n(i.children,s,l[e]);if("number"==typeof l)for(let e=0;e<l;e++)i.children&&n(i.children,s,e)}else i.children&&n(i.children,s,o)}};n(e.templateBindings.children,r),e.$.templateContainer.innerHTML="",e.$.templateContainer.appendChild(r),e.templateAttached(e.$.templateContainer)}templateAttached(){}templateDetached(){}appendTemplate(e){this.appendChild(e)}defineElementModules(){const e=this,t=e.constructor.prototype;if("BaseElement"===t.elementName){t.modules=e.constructor.modules;const r=t.modules;for(let t=0;t<r.length;t+=1)e.addModule(r[t])}else{const r=t.modules;if(!r)return;for(let t=0;t<r.length;t+=1){const n=r[t],o=n.prototype;e.defineElementMethods(o.methodNames,o),e.defineElementProperties(n.properties)}}}watch(e,t){const r=this;r._watch=null!==e&&null!==t?{properties:e,propertyChangedCallback:t}:null}unwatch(){this._watch=null}set(e,t,r){const n=this,o=n.context;n.context=!0===r?document:n,n[e]=t,n.context=o}get(e){return this[e]}_setModuleState(e,t){const r=this,n="is"+e.substring(0,1).toUpperCase()+e.substring(1),o="on"+e.substring(0,1).toUpperCase()+e.substring(1);for(let a=0;a<r.modulesList.length;a++){const i=r.modulesList[a];i[n]=!0,i[e]&&i[e](t),i[o]&&i[o](t)}}addModule(e,t){const r=this;if(!e)return;const n=r.modules.slice(0),o=e.prototype,a=Object.getPrototypeOf(e);a.name&&a.name!==e.name&&r.addModule(a),!e.moduleName&&e.name&&(e.moduleName=e.name),-1===n.findIndex((t=>e.moduleName===t.moduleName))&&n.push(e),r.defineModule(e),r.defineElementMethods(o.methodNames,o),r.defineElementProperties(e.properties);if(r.constructor.prototype.modules=n,t)for(let t in Smart.Elements.tagNames){const n=Smart.Elements.tagNames[t];let o=Object.getPrototypeOf(n),a=[];for(;o!==HTMLElement;)a.push(o.prototype),o=Object.getPrototypeOf(o);a.indexOf(r)>=0&&n!==r&&n.prototype.addModule(e)}}defineModule(e){if(e.isDefined)return;e.prototype._initModule=function(e){this.ownerElement=e};const t=e.properties||{},r=Object.keys(t),n=Object.getOwnPropertyNames(e.prototype);e.prototype.methodNames=n;for(let n=0;n<r.length;n+=1){const o=r[n],a=t[o];Object.defineProperty(e.prototype,o,{configurable:!1,enumerable:!0,get(){return this.ownerElement?this.ownerElement[o]:a.value},set(e){this.ownerElement[o]=e}})}e.isDefined=!0}getStaticMember(e,t){const n=window[r][this.elementName],o=n[e];t||(t="");let a="array"===t?[]:"string"===t?"":{},i=Object.getPrototypeOf(n),s=[];for(;i[e];)s.push(i[e]),i=Object.getPrototypeOf(i);for(let e=s.length-1;e>=0;e--)if("array"===t)for(let t=0;t<s[e].length;t++)-1===a.indexOf(s[e][t])&&a.push(s[e][t]);else"string"===t?-1===a.indexOf(s[e])&&(a+=s[e]):a=f.Core.assign(a,s[e]);if("array"===t){for(let e=0;e<o.length;e++)-1===a.indexOf(o[e])&&a.push(o[e]);return a}return"string"===t?(-1===a.indexOf(o)&&(a+=o),a):f.Core.assign(a,o)}defineElementHierarchicalProperties(e,t){const r=this,n=[];!function(e){const r=Object.keys(e);for(let o=0;o<r.length;o++){const a=r[o];if("messages"===a)continue;const i=e[a],s=Object.keys(i),l=s.indexOf("value")>=0&&s.indexOf("type")>=0&&"object"==typeof i.value;if("propertyObject"===i.type||l){const e=function(r,o){if(!r.value)return;const a=Object.keys(r.value);for(let i=0;i<a.length;i++){const s=a[i],l=r.value[s],d=o+"_"+s;if("object"!=typeof l||null===l)break;const m=Object.keys(l);if(!(m.indexOf("value")>=0&&m.indexOf("type")>=0))break;if("array"!==r.type&&(r.isHierarchicalProperty=!0),l.parentPropertyName=o,t){const e=t._properties[d];if(r.value.hasOwnProperty(s)){if(e.isDefined)continue;delete r.value[s]}e.isDefined=!0,Object.defineProperty(r.value,s,{configurable:!1,enumerable:!0,get:()=>t._properties[d].value,set(e){t.updateProperty(t,t._properties[d],e)}})}n[d]||(n[d]=l,n.length++),("propertyObject"===l.type||"object"==typeof l.value&&"array"!==l.type)&&e(t?t._properties[d]:l,d)}};e(i,a)}}}(e),n.length>0&&!t&&r.defineElementProperties(n)}defineElement(){const e=this,t=e.constructor.prototype,r=e.getStaticMember("properties"),n=Object.getOwnPropertyNames(t);t.extendedProperties={},t.boundProperties={},t.templateListeners={},e.defineElementModules(),e.defineElementMethods(n,t),e.defineElementProperties(r),e.defineElementHierarchicalProperties(e.extendedProperties),t._initElement=function(){const e=this,r=t.extendedProperties,n=Object.keys(r),o=e.modules;e.$=f.Extend(e),e.$document=v,e.smartId=(Date.now().toString(36)+Math.random().toString(36).substr(2,5)).toUpperCase(),e.isCreated||(e.modulesList=[],e._properties=[],e._beforeCreatedProperties&&(e._properties=e._beforeCreatedProperties,delete e._beforeCreatedProperties),e.detachedChildren=[],e.propertyByAttributeName=[]);for(let t=0;t<o.length;t+=1){let r=new(0,o[t]);r._initModule(e),e.modulesList.push(r)}for(let t=0;t<n.length;t+=1){const o=n[t],a=r[o];let i=a.value;if(e._properties[o]){if(void 0!==e._properties[o].notify)continue;delete e._properties[o]}if(D&&"innerHTML"===o&&delete e[o],-1===window.navigator.userAgent.indexOf("PhantomJS")&&e.hasOwnProperty(o)&&(i=e[o],delete e[o]),"array"===a.type&&null!=i&&(i=i.slice(0)),"object"===a.type&&null!=i&&(i=Array.isArray(i)?i.slice(0):Object.assign({},i)),e._properties[o]={name:o,notify:a.notify,allowedValues:a.allowedValues,type:a.type,nullable:a.nullable,reflectToAttribute:a.reflectToAttribute,defaultReflectToAttribute:a.defaultReflectToAttribute,defaultReflectToAttributeConditions:a.defaultReflectToAttributeConditions,value:i,readOnly:a.readOnly,defaultValue:i,attributeName:a.attributeName,observer:a.observer,inherit:a.inherit,extend:a.extend,validator:a.validator},e.propertyByAttributeName[a.attributeName]=e._properties[o],!a.hasOwnProperty("type")){const t=e.localize("propertyUnknownType",{name:o});e.log(t)}if("any"===a.type||"propertyObject"===a.type)continue;const s=f.Types.getType(i);if(null!=i&&a.type!==s&&!a.validator){if("object"===a.type&&"array"===s)continue;if("number"===s){if(["integer","int","float"].findIndex((e=>e===a.type))>=0)continue}const t=e.localize("propertyInvalidValueType",{name:o,actualType:s,type:a.type});e.log(t)}}e.defineElementHierarchicalProperties(e._properties,e),e.isCreated=!0},t.registered()}defineElementMethods(e,t){const r=this.constructor.prototype,n=function(e,t){const r=Array.prototype.slice.call(arguments,2);return function(){if(!this.isReady&&"localize"!==t&&"localize"!==t&&"cloneNode"!==t&&"importStyle"!==t&&"log"!==t&&"parseAttributes"!==t){const e=this.localize("elementNotInDOM");this.log(e)}let n=this;for(let e=0;e<this.modulesList.length;e++){let r=this.modulesList[e];if(t in r){n=r;break}}const o=this.context,a=r.concat(Array.prototype.slice.call(arguments));let i=null;const s=function(e,t){return e===t||("number"===e&&("int"===t||"integer"===t||"float"===t)||("bool"===e&&"boolean"===t||"boolean"===e&&"bool"===t||("object"===e&&"any"===t||void 0)))};if(this.methods){const e=this.methods[t];if(e){const r=e.split(":");i=r[r.length-1].trim();const n=[],o=e.substring(1+e.indexOf("("),e.lastIndexOf(")")).split(",");let l="";for(let e=0;e<o.length;e++){const t=o[e];l+=t,t.indexOf(":")>=0?(n.push(l),l=""):l+=","}let d=n.length;for(let e=0;e<n.length;e++){const r=n[e].trim().split(":"),o=r[0].split("=")[0].trim().indexOf("?")>=0,i=r[1].indexOf("?")>=0,l=r[1].replace(/\?/gi,"").trim(),m=l.split("|");let c=r[0].split("=")[1];const u=f.Types.getType(a[e]);if(void 0===a[e]&&c){switch(c=c.trim(),l[0]){case"date":{let e=c.substring(c.indexOf("(")+1,c.lastIndexOf(")"));e=e.length>0?e.split(",").map((e=>parseInt(e))):[],c=0===e.length?new Date:new Date(e[0],e[1],e[2]);break}case"bool":case"boolean":c="true"===c||"1"===c;break;case"int":case"integer":c=parseInt(c);break;case"float":case"number":c=parseFloat(c);break;case"any":case"object":c=c.indexOf("{")>=0?JSON.parse(c):c}a.push(c)}else o&&d--;if(l!==u&&u){let r=!0;for(let e=0;e<m.length;e++)if(s(u,m[e])){r=!1;break}if(r&&(null!==a[e]||!i)){const r=this.localize("methodInvalidValueType",{name:t,actualType:u,type:l,argumentIndex:e});this.log(r)}}if(a.length<d){const e=this.localize("methodInvalidArgumentsCount",{name:t,actualArgumentsCount:a.length,argumentsCount:d});this.log(e)}}}}this.context=this;const l=e.apply(n,a);if(i){const e=void 0===f.Types.getType(l)?"void":f.Types.getType(l);if(!s(e,i)){const r=this.localize("methodInvalidReturnType",{name:t,actualType:e,type:i});this.log(r)}}return this.context=o,l}},o=["constructor","ready","created","render","attached","detached","appendChild","insertBefore","removeChild","connect","disconnectedCallback","connectedCallback","attributeChangedCallback","propertyChangedHandler","enableShadowDOM","isInShadowDOM","addPropertyBindings"];for(let a in e){let i=e[a];i&&i.startsWith&&i.startsWith("_")||void 0!==o.find((e=>e===i))||(r.extendedProperties[i]||f.Types.isFunction(t[i])&&(r[i]=n(t[i],i)))}}defineElementProperties(e){if(!e)return;const t=this,r=t.constructor.prototype,n=Object.keys(e),o=t.getStaticMember("properties");Object.assign(r.extendedProperties,e),t.updateProperty=function(e,t,r){const n=e;if(!t||t.readOnly)return;if(t.allowedValues){let e=!1;for(let n=0;n<t.allowedValues.length;n++)if(t.allowedValues[n]===r){e=!0;break}if(!e){const e=JSON.stringify(t.allowedValues).replace(/\[|\]/gi,"").replace(",",", ").replace(/"/gi,"'"),o="'"+r+"'",a=n.localize("propertyInvalidValue",{name:t.name,actualValue:o,value:e});return void n.log(a)}}const o=t.name,a=n._properties[o].value;if(t.validator&&n[t.validator]){const e=n.context;n.context=n;const o=n[t.validator](a,r);void 0!==o&&(r=o),n.context=e}if(a===r)return;if(n.propertyChanging){const e=n.propertyChanging(o,a,r);if(!1===e||null===e)return}if(!t.hasOwnProperty("type")){const e=n.localize("propertyUnknownType",{name:o});n.log(e)}if("array"===t.type&&JSON.stringify(a)===JSON.stringify(r))return;if(null!=r&&"any"!==t.type&&"propertyObject"!==t.type&&t.type!==f.Types.getType(r)&&!t.validator||null===r&&!t.nullable){let e=!0;if("object"===t.type&&"array"===f.Types.getType(r)&&(e=!1),"number"===f.Types.getType(r)){["integer","int","float"].findIndex((e=>e===t.type))>=0&&(e=!1)}if(e){const e=n.localize("propertyInvalidValueType",{name:o,actualType:f.Types.getType(r),type:t.type});return void n.error(e)}}if(t.isUpdating=!0,t.isHierarchicalProperty){const e=function(t,r){if(!t)return;const o=Object.keys(t);for(let a=0;a<o.length;a++){const i=o[a],s=t[i];"object"==typeof s&&!f.Types.isArray(s)&&s&&s.constructor!==Date?e(s,r+"_"+i):n[r+"_"+i]=s}};e(r,o)}else n._properties[o].value=r;!t.isUpdatingFromAttribute&&t.reflectToAttribute&&n.$.setAttributeValue(t.attributeName,r,t.type);if(n.isReady&&(!n.ownerElement||n.ownerElement&&n.ownerElement.isReady)){if("wait"===o&&(r||!a||n.isCompleted||(n.classList.remove("smart-visibility-hidden"),n.ownerElement&&n.ownerElement.updateBoundMappedNodes(),n.updateBoundMappedNodes(),n.complete())),"renderMode"===o)return;if(n.context!==n&&!n.wait){const e=n.context;n.context=n,n.propertyChangedHandler(o,a,r),n.context=e,t.observer&&n[t.observer]&&(n.context=n,n[t.observer](a,r),n.context=document),n._watch&&n._watch.properties.indexOf(o)>=0&&n._watch.propertyChangedCallback(o,a,r)}const e=t.notify||n.boundProperties[o];e&&(n.$.fireEvent(t.attributeName+"-changed",{context:n.context,oldValue:a,value:n[o]}),n.boundProperties[o]&&n.updateBoundNodes(o)),e&&n.templateProperties&&n.templateProperties[o]&&n.refreshTemplate(),n.dataContextProperties&&("dataContext"===o?n.applyDataContext():n.dataContextProperties[o]&&n.updateDataContextProperty(o))}t.isUpdating=!1};for(let t=0;t<n.length;t+=1){const a=n[t],i=e[a],s=f.Core.toDash(a),l=i.type||"any",d=l.indexOf("?")>=0||"any"===l;d&&"any"!==l&&(i.type=l.substring(0,l.length-1)),i.nullable=d,i.attributeName=s.toLowerCase(),i.name=a,i.reflectToAttribute=void 0===i.reflectToAttribute||i.reflectToAttribute,i.inherit&&o[a]&&(i.value=o[a].value),i.extend&&o[a]&&f.Core.assign(i.value,o[a].value),r.hasOwnProperty(a)||Object.defineProperty(r,a,{configurable:!1,enumerable:!0,get(){if(this._properties[a])return this._properties[a].value},set(e){const t=this;t.updateProperty(t,t._properties[a],e)}})}}}let _=[],k=[],C=[],D=!1;const E=navigator.userAgent.match(/Chrom(e|ium)\/([0-9]+)\./);if(E){parseInt(E[2],10)<=50&&(D=!0)}class S{static register(e,t){const n=t.prototype;let o=s.toCamelCase(e).replace(/[a-z]+/,""),a=t.version||window[r].Version;if(window.customElements.get(e)&&window.customElements.get(e).version===a)return;let i=e;for(a=a.split(".");window.customElements.get(e);)e=i+"-"+a.join("."),a[2]=parseInt(a[2])+1;if(!_[e]){if(e.startsWith(r.toLowerCase()))_[e]=window[r][o]=window[r.toLowerCase()+o]=t;else{let n=e.split("-")[0];n=n.substring(0,1).toUpperCase()+n.substring(1),window[r][n]||(window[r][n]={}),_[e]=window[r][n][o]=window[n.toLowerCase()+o]=t,window[r][o]&&(o=s.toCamelCase(e)),window[r][o]=t}n.elementName=o,n.defineElement(),k[e]&&k[e](n),window.customElements.define(e,t)}}static registerElements(){const e=this;if(e.toRegister){e.isRegistering=!0;for(let t=0;t<e.toRegister.length;t++){const r=e.toRegister[t];e.register(r.tagName,r.element)}e.isRegistering=!1}}static get(e){if(_[e])return _[e]}static whenRegistered(e,t){if(!e)throw new Error("Syntax Error: Invalid tag name");const r=k[e],n=this.get(e),o=n?n.modules.length:3;try{r||n?!r&&n?(t(n.prototype),k[e]=void 0):r&&!n?k[e]=function(e){r(e),t(e)}:r&&n&&(n.proto&&(r(n.proto),t(n.proto)),k[e]=void 0):k[e]=function(e){try{t(e)}catch(e){const t=e instanceof Error?e.message:e.toString();console.log(t)}}}catch(e){const t=e instanceof Error?e.message:e.toString();console.log(t)}if(n&&o!==n.prototype.modules.length){const t=document.querySelectorAll(e);for(let e=0;e<t.length;e++){const r=t[e];r.isCreated&&r._initElement()}}}}S.lazyRegister=!1,S.tagNames=[];class A{constructor(){const e=this;e.name="observableArray",e.observables=arguments.length<3?null:arguments[2];const t=new Proxy(e,{deleteProperty:function(e,t){return delete e[t],!0},apply:function(e,t,r){return e.apply(t,r)},get:function(t,r){return t[r]||isNaN(parseInt(r))?t[r]:e.getItem(parseInt(r))},set:function(t,r,n){return t[r]||isNaN(parseInt(r))?(t[r]=n,!0):(e.setItem(parseInt(r),n),!0)}});if(e._addArgs={eventName:"change",object:t,action:"add",index:null,removed:new Array,addedCount:1},e._removeArgs={eventName:"change",object:t,action:"remove",index:null,removed:null,addedCount:0},arguments.length>=1&&Array.isArray(arguments[0])){e._array=[];const t=arguments[0];for(let r=0,n=t.length;r<n;r++){const n=e._getItem(e._array.length,t[r]);e._array.push(n)}}else e._array=Array.apply(null,arguments);return 2===arguments.length&&(e.notifyFn=arguments[1]),t}get canNotify(){const e=this;return void 0===e._canNotify&&(e._canNotify=!0),e._canNotify}set canNotify(e){this._canNotify=e}_notify(e){const t=this;t.canNotify&&t.notifyFn&&t.notifyFn(e)}notify(e){e&&(this.notifyFn=e)}toArray(){return this._array}_getItem(e,t){const r=this;if("string"==typeof t)return t;if("number"==typeof t)return t;if(void 0===t)return t;return new Proxy(t,{deleteProperty:function(e,t){return delete e[t],!0},set:function(t,n,o){const a=t[n];return t[n]=o,!r._canNotify||!1===t.canNotify||(r.observables&&!r.observables[n]||r._notify({eventNa