
/* Smart UI v15.2.0 (2023-04-20) 
Copyright (c) 2011-2023 jQWidgets. 
License: https://htmlelements.com/license/ */ //

Smart("smart-calendar",class extends Smart.BaseElement{static get properties(){return{animationSettings:{value:null,type:"object"},calendarMode:{value:"default",allowedValues:["default","classic"],type:"string"},dayNameFormat:{value:"firstTwoLetters",allowedValues:["narrow","firstTwoLetters","long","short"],type:"string"},dateFormatFunction:{value:null,type:"function"},disableAutoNavigation:{value:!1,type:"boolean"},displayMode:{value:"month",allowedValues:["month","year","decade"],type:"string"},displayModeView:{value:"table",allowedValues:["table","list"],type:"string"},dropDownHeight:{value:"200",type:"string"},dropDownWidth:{value:"",type:"string"},firstDayOfWeek:{value:0,type:"number",defaultValue:0,validator:"_firstDayOfWeekValidator"},footerTemplate:{value:null,type:"any"},headerTemplate:{value:null,type:"any"},hideDayNames:{value:!1,type:"boolean"},hideOtherMonthDays:{value:!1,type:"boolean"},hideTooltipArrow:{value:!1,type:"boolean"},importantDates:{value:[],type:"array",defaultValue:[]},importantDatesTemplate:{value:null,type:"any"},max:{value:new Date(2100,0,1),type:"any",defaultValue:new Date(2100,0,1)},min:{value:new Date(1900,0,1),type:"any",defaultValue:new Date(1900,0,1)},months:{value:1,type:"number",defaultValue:1,validator:"_monthsValidator"},monthNameFormat:{value:"long",allowedValues:["narrow","firstTwoLetters","long","short","2-digit","numeric"],type:"string"},name:{value:"",type:"string"},restrictedDates:{value:[],type:"array",defaultValue:[]},scrollButtonsNavigationMode:{value:"landscape",allowedValues:["portrait","landscape"],type:"string"},scrollButtonsPosition:{value:"both",allowedValues:["near","far","both"],type:"string"},selectedDates:{value:[],reflectToAttribute:!1,type:"array"},selectionMode:{value:"default",allowedValues:["none","default","one","oneExtended","many","zeroOrMany","oneOrMany","zeroOrOne","week","range"],type:"string"},spinButtonsDelay:{value:80,type:"number"},spinButtonsInitialDelay:{value:0,type:"number"},titleTemplate:{value:null,type:"any"},tooltip:{value:!1,type:"boolean"},tooltipArrow:{value:!0,type:"boolean"},tooltipArrowDirection:{allowedValues:["bottom","top","left","right","none"],value:"bottom",type:"string"},tooltipDelay:{value:100,type:"number"},tooltipOffset:{value:[],type:"array"},tooltipPosition:{value:"auto",allowedValues:["auto","bottom","top","left","right","absolute"],type:"string"},tooltipTemplate:{value:null,type:"any"},view:{value:"portrait",allowedValues:["landscape","portrait"],type:"string"},viewSections:{value:["header"],type:"array"},weekNumbers:{value:!1,type:"boolean"},weeks:{value:6,type:"number",defaultValue:6,validator:"_weeksValidator"},yearFormat:{value:"numeric",allowedValues:["2-digit","numeric"],type:"string"}}}static get listeners(){return{"container.down":"_downHandler","document.up":"_documentUpHandler","body.move":"_moveHandler","container.wheel":"_containerWheelHandler","body.focus":"_bodyFocusStateHandler","body.blur":"_bodyBlurStateHandler","header.click":"_headerClickHandler","header.change":"_headerChangeHandler",keydown:"_keyDownHandler",keyup:"_keyUpHandler",mouseenter:"_mouseEventsHandler",mouseleave:"_mouseEventsHandler","container.mouseover":"_mouseEventsHandler","container.mouseout":"_mouseEventsHandler","container.open":"_popupEventHandler","container.close":"_popupEventHandler"}}static get methods(){return{select:"select(date=new Date(): date|string): void",clearSelection:"clearSelection(): void",today:"today(): date",navigate:"navigate(step: date|string|int): bool"}}static get styleUrls(){return["smart.calendar.css"]}template(){return'<div id="container" role="presentation">\n                    <div id="title" class="smart-calendar-title" role="heading" aria-level="1">\n                        <div id="yearContainer" class="smart-calendar-year-container" role="button"></div>\n                        <div id="dateContainer" class="smart-calendar-date-container smart-calendar-selected" role="button"></div>\n                    </div>\n                    <div id="calendarContainer" class="smart-calendar-container">\n                        <div id="header" class="smart-calendar-header">\n                            <smart-repeat-button prev-month class="smart-calendar-button" id="previousMonthButton" animation="[[animation]]" initial-delay="[[spinButtonsInitialDelay]]" delay="[[spinButtonsDelay]]" disabled="[[disabled]]" readonly="[[readonly]]" right-to-left="[[rightToLeft]]" aria-label="Previous month">\n                                <span aria-hidden="true"></span>\n                            </smart-repeat-button>\n                            <div id="dateElement" class="smart-calendar-date-element" role="presentation">\n                                <div id="defaultHeaderDate" role="button"></div>\n                                <div id="classicHeaderDate">\n                                    <div id="monthElement" class="smart-calendar-month-element" disabled="[[disabled]]" role="presentation">\n                                    </div>\n                                    <input class="smart-calendar-year-element" id="yearElement" disabled="[[disabled]]" readonly="[[readonly]]" aria-label="Year" />\n                                    <span class="smart-calendar-year-elements">\n                                        <smart-repeat-button next-year class="smart-calendar-button" id="nextYearButton" animation="[[animation]]" initial-delay="[[spinButtonsInitialDelay]]" delay="[[spinButtonsDelay]]" disabled="[[disabled]]" readonly="[[readonly]]" right-to-left="[[rightToLeft]]" aria-label="Next year">\n                                            <span aria-hidden="true"></span>\n                                        </smart-repeat-button>\n                                        <smart-repeat-button prev-year class="smart-calendar-button" id="previousYearButton" animation="[[animation]]" initial-delay="[[spinButtonsInitialDelay]]" delay="[[spinButtonsDelay]]" disabled="[[disabled]]" readonly="[[readonly]]" right-to-left="[[rightToLeft]]" aria-label="Previous year">\n                                            <span aria-hidden="true"></span>\n                                        </smart-repeat-button>\n                                    </span>\n                                </div>\n                            </div>\n                            <smart-repeat-button next-month class="smart-calendar-button" id="nextMonthButton" animation="[[animation]]" initial-delay="[[spinButtonsInitialDelay]]" delay="[[spinButtonsDelay]]" disabled="[[disabled]]" readonly="[[readonly]]" right-to-left="[[rightToLeft]]" aria-label="Next month">\n                                <span aria-hidden="true"></span>\n                            </smart-repeat-button>\n                        </div>\n                        <div id="body" class="smart-content smart-calendar-body" role="presentation">\n                            <div id="monthsContainer" class="smart-calendar-months-container" role="presentation">\n                              <div id="month" class="smart-calendar-month" role="grid">\n                                   <div id="monthName" class="smart-calendar-month-name"></div>\n                                   <div id="weekTitles" class="smart-calendar-week-titles" role="row">\n                                       <div class="smart-calendar-week-title" role="columnheader"></div>\n                                       <div class="smart-calendar-week-title" role="columnheader"></div>\n                                       <div class="smart-calendar-week-title" role="columnheader"></div>\n                                       <div class="smart-calendar-week-title" role="columnheader"></div>\n                                       <div class="smart-calendar-week-title" role="columnheader"></div>\n                                       <div class="smart-calendar-week-title" role="columnheader"></div>\n                                       <div class="smart-calendar-week-title" role="columnheader"></div>\n                                       <div class="smart-calendar-week-title" role="columnheader"></div>\n                                   </div>\n                                   <div id="weeks" class="smart-calendar-weeks" role="rowgroup">\n                                        <div class="smart-calendar-week" role="row">\n                                           <div class="smart-calendar-week-number" role="rowheader"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"> </div>\n                                        </div>\n                                        <div class="smart-calendar-week" role="row">\n                                           <div class="smart-calendar-week-number" role="rowheader"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"> </div>\n                                           <div class="smart-calendar-cell" role="gridcell"> </div>\n                                           <div class="smart-calendar-cell" role="gridcell"> </div>\n                                       </div>\n                                       <div class="smart-calendar-week" role="row">\n                                           <div class="smart-calendar-week-number" role="rowheader"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"> </div>\n                                           <div class="smart-calendar-cell" role="gridcell"> </div>\n                                           <div class="smart-calendar-cell" role="gridcell"> </div>\n                                       </div>\n                                       <div class="smart-calendar-week" role="row">\n                                           <div class="smart-calendar-week-number" role="rowheader"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"> </div>\n                                           <div class="smart-calendar-cell" role="gridcell"> </div>\n                                           <div class="smart-calendar-cell" role="gridcell"> </div>\n                                       </div>\n                                       <div class="smart-calendar-week" role="row">\n                                           <div class="smart-calendar-week-number" role="rowheader"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"> </div>\n                                           <div class="smart-calendar-cell" role="gridcell"> </div>\n                                           <div class="smart-calendar-cell" role="gridcell"> </div>\n                                       </div>\n                                       <div class="smart-calendar-week" role="row">\n                                           <div class="smart-calendar-week-number" role="rowheader"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"></div>\n                                           <div class="smart-calendar-cell" role="gridcell"> </div>\n                                           <div class="smart-calendar-cell" role="gridcell"> </div>\n                                           <div class="smart-calendar-cell" role="gridcell"> </div>\n                                       </div>\n                                   </div>\n                                </div>\n                            </div>\n                            <div id="dateViewContainer" class="smart-calendar-date-view-container smart-hidden">\n                                    <div class="smart-calendar-cell" role="button"></div>\n                                    <div class="smart-calendar-cell" role="button"></div>\n                                    <div class="smart-calendar-cell" role="button"></div>\n                                    <div class="smart-calendar-cell" role="button"></div>\n                                    <div class="smart-calendar-cell" role="button"></div>\n                                    <div class="smart-calendar-cell" role="button"></div>\n                                    <div class="smart-calendar-cell" role="button"></div>\n                                    <div class="smart-calendar-cell" role="button"></div>\n                                    <div class="smart-calendar-cell" role="button"></div>\n                                    <div class="smart-calendar-cell" role="button"></div>\n                                    <div class="smart-calendar-cell" role="button"></div>\n                                    <div class="smart-calendar-cell" role="button"></div>\n                            </div>\n                            <div id="monthsSeparator" class="smart-calendar-month-separator"></div>\n                            <div id="nextMonthsContainer" class="smart-calendar-next-months-container" aria-hidden="true"></div>\n                            <div id="animationPanel" class="smart-calendar-animation-panel smart-hidden"></div>\n                        </div>\n                        <div id="footer" class="smart-calendar-footer smart-hidden">\n                            <div id="selectedDatesRange"></div>\n                        </div>\n                        <input id="hiddenInput" type="hidden" name="[[name]]">\n                    </div>\n                </div>'}_updateTargetValue(){const e=this;if(e.dataset.target){const t=document.querySelector(e.dataset.target);if(t){const a=e.dataset.property,n=e.selectedDates.toString();a&&void 0!==t[a]&&(t[a]=n)}}}propertyChangedHandler(e,t,a){super.propertyChangedHandler(e,t,a);const n=this;switch(e){case"animationSettings":n._applyAnimationSettings();break;case"disabled":case"unfocusable":n._setFocusable();break;case"calendarMode":case"dropDownWidth":case"dropDownHeight":n.displayMode="month",n._refreshHeaderElements(),n._refreshCalendarMode(),n._setDisplayModeContent();break;case"dayNameFormat":n._refreshDayOfWeekTitles(n.$.month);break;case"dateFormatFunction":{let e=n.$.monthsContainer.children;for(let t=0;t<e.length;t++)e[t].firstElementChild.innerHTML=a?a(e[t]._date):n._monthsNames[e[t]._date.getMonth()]+" "+e[t]._date.toLocaleDateString(n.locale,{year:n.yearFormat});n._refreshHeaderTitle();break}case"displayMode":if("classic"===n.calendarMode&&"month"!==a){n[e]="month";break}n._setDisplayMode(t,a);break;case"displayModeView":n._applyAnimationSettings(!0),"month"!==n.displayMode&&n._setDisplayModeContent();break;case"firstDayOfWeek":n._handleMonths(),n._refreshDayOfWeekTitles();break;case"hideTooltipArrow":n.$.tooltip&&(n.$.tooltip.arrow=!a);break;case"titleTemplate":case"headerTemplate":case"footerTemplate":n._handleLayoutTemplate(n.$[e.split(/[T]/)[0]],a),"titleTemplate"===e?n._refreshTitle():"headerTemplate"===e?n._refreshHeaderTitle():n._refreshFooter();break;case"importantDates":n.importantDates=n._getValidDates(a),n._refreshImportantDates();break;case"importantDatesTemplate":n._handleImportantDateTemplate(),n._refreshImportantDates();break;case"locale":n._refreshMonthNames(),n._refreshDayOfWeekTitles(),n._refreshHeaderTitle(),n._refreshTitle(),n._refreshFooter(),n.displayMode&&"month"!==n.displayMode&&n._setDisplayModeContent();break;case"max":case"min":n._validateMinMax(e,a,t),n._validateSelectedDates(),n._noFocusingRequired=!1,n._refreshHeaderElements();break;case"months":n._handleMonths();break;case"monthNameFormat":n._refreshCalendarMode(),n._refreshHeaderTitle();break;case"restrictedDates":n._setRestrictedDates(n.restrictedDates=n._getValidDates(a));break;case"rightToLeft":n._refreshDayOfWeekTitles(),n._handleMonths();break;case"scrollButtonsNavigationMode":n._setScrollButtonsNavigationMode();break;case"selectedDates":if(n._clearSelection(!0),n._validateSelectedDates(n._getValidDates(a)),n._applySelectionMode(!0),n._viewDates){let e=n.selectedDates[n.selectedDates.length-1];n._isDateInView(e)?n.selectedDates.map((e=>n._selectDate(e,!0,!0))):n._handleMonths(e)}n._refreshFooter(),n._setWeeksVisibility(n.$.monthsContainer),n.$.hiddenInput.value=n.selectedDates.toString(),n.isInitialized&&(n.$.fireEvent("change",{value:n.selectedDates}),n._updateTargetValue()),n._refreshTitle(),"month"!==n.displayMode&&n._setDisplayModeContent();break;case"selectionMode":n._applySelectionMode(!1,t),n._refreshTitle();break;case"tooltip":n._handleTooltip();break;case"tooltipArrow":case"tooltipArrowDirection":case"tooltipDelay":case"tooltipOffset":case"tooltipPosition":case"tooltipTemplate":if(n.$.tooltip){const t=e.replace("tooltip","");n.$.tooltip[t.charAt(0).toLowerCase()+t.slice(1)]=a}break;case"view":n._refreshTitle();break;case"viewSections":a.indexOf("title")>-1?n.$title.removeClass("smart-hidden"):n.$title.addClass("smart-hidden"),n._refreshTitle(),a.indexOf("header")>-1?n.$header.removeClass("smart-hidden"):n.$header.addClass("smart-hidden"),n._refreshHeaderTitle(),a.indexOf("footer")>-1?n.$footer.removeClass("smart-hidden"):n.$footer.addClass("smart-hidden"),n._refreshFooter(),n._setFocusable();break;case"weeks":n._setWeeksVisibility(n.$.monthsContainer);break;case"yearFormat":if(n._refreshCalendarMode(),n._refreshFooter(),n.months>1&&"month"===n.displayMode){let e=n._animationStarted?n.$.nextMonthsContainer.children:n.$.monthsContainer.children;for(let t=0;t<e.length;t++)e[t].firstElementChild.innerHTML=n.dateFormatFunction?n.dateFormatFunction(e[t]._date):n._monthsNames[e[t]._date.getMonth()]+" "+e[t]._date.toLocaleDateString(n.locale,{year:a})}n._refreshTitle(),n._refreshHeaderTitle()}}ready(){super.ready();const e=this;e._keysPressed={},e._applyAnimationSettings(),e.importantDates=e._getValidDates(e.importantDates),e.restrictedDates=e._getValidDates(e.restrictedDates)}render(){const e=this;e.setAttribute("role","dialog"),e._refreshMonthNames(),e._validateMinMax(),e._validateSelectedDates(e._getValidDates(e.selectedDates)),e._handleLayoutTemplate(e.$.title,e.titleTemplate),e._handleLayoutTemplate(e.$.header,e.headerTemplate),e._handleLayoutTemplate(e.$.footer,e.footerTemplate),e._handleImportantDateTemplate(),e._setFocusable(),e._refreshDayOfWeekTitles(),e._applySelectionMode(!0),e._handleMonths(0===e.selectedDates.length?new Date((new Date).setHours(0,0,0,0)):e.selectedDates[e.selectedDates.length-1]),e._handleTooltip(),e._updateViewSectionsVisibility(),e._setScrollButtonsNavigationMode(),e._refreshCalendarMode(),e._setDisplayMode(),e._refreshTitle(),e._refreshFooter(),e._refreshImportantDates(),e.$.monthElement&&e.$.monthElement._setDropDownSize&&e.$.monthElement._setDropDownSize(),e._changeEventFired=0,e.$.hiddenInput.value=e.selectedDates.toString(),e.shadowRoot&&e.appendChild(e.$.hiddenInput),e.isInitialized=!0,super.render()}refresh(){this.isInitialized&&this.render()}_updateViewSectionsVisibility(){const e=this;e.viewSections.indexOf("title")>-1?e.$title.removeClass("smart-hidden"):e.$title.addClass("smart-hidden"),e.viewSections.indexOf("header")>-1?e.$header.removeClass("smart-hidden"):e.$header.addClass("smart-hidden"),e.viewSections.indexOf("footer")>-1?e.$footer.removeClass("smart-hidden"):e.$footer.addClass("smart-hidden")}clearSelection(){this._clearSelection()}_setFocusable(){const e=this;let t=e.tabIndex>0?e.tabIndex:0;function a(e,a){if(a)return e&&e instanceof a?("function"==typeof e._setFocusable&&e.isCompleted?e.unfocusable=t<=-1:e.setAttribute("tabindex",t),e):e||void 0}(e.disabled||e.unfocusable)&&(t=-1),e.$.previousMonthButton=a(e.$.previousMonthButton,Smart.Button),e.$.nextMonthButton=a(e.$.nextMonthButton,Smart.Button),e.$.nextYearButton=a(e.$.nextYearButton,Smart.Button),e.$.previousYearButton=a(e.$.previousYearButton,Smart.Button),e.$.monthElement=a(e.$.monthElement,Smart.Input),e.$.yearElement=a(e.$.yearElement,HTMLInputElement),e.viewSections.indexOf("title")>-1&&(e.$.dateContainer.setAttribute("tabindex",t),e.$.yearContainer.setAttribute("tabindex",t)),e.$.body.setAttribute("tabindex",t),"default"===e.calendarMode?e.$.dateElement.setAttribute("tabindex",t):e.$.dateElement.removeAttribute("tabindex"),e.unfocusable?e.removeAttribute("tabindex"):e.tabIndex=e.readonly&&!e.disabled?e.tabIndex>0?e.tabIndex:0:t}static get requires(){return{"Smart.DropDownList":"smart.dropdownlist.js","Smart.ListBox":"smart.listbox.js","Smart.RepeatButton":"smart.button.js","Smart.Tooltip":"smart.tooltip.js"}}navigate(e){const t=this;let a,n,l;if(e){if("number"==typeof e){if(e=parseInt(e),isNaN(e)||0===e)return!1;if(6!==t.weeks&&0!==t.weeks&&"month"===t.displayMode){let l,i;t._focusedCell||t._focusCell();const s=[].slice.call(t._focusedCell.closest(".smart-calendar-weeks").children).filter((e=>!e.classList.contains("smart-hidden")));e<0?(i=s[0].querySelectorAll(".smart-calendar-cell"),l=t.rightToLeft?i[i.length-1]:i[0]):(i=s[s.length-1].querySelectorAll(".smart-calendar-cell"),l=t.rightToLeft?i[0]:i[i.length-1]),n=new Date(l.value),n.setDate(n.getDate()+e),a=n}else a=t._getNextDate(e)}else{if(a=e=t._getValidDate(e),l=!0,isNaN(a.getTime()))return!1;const i=t._viewDates[0];if(i&&a.getMonth()===i.getMonth()&&a.getFullYear()===i.getFullYear())return!1;6!==t.weeks&&0!==t.weeks&&"month"===t.displayMode&&(n=a)}return!(!a||t.$.fireEvent("navigationChanging",{value:new Date(a),type:t.displayMode}).defaultPrevented||("month"!==t.displayMode?(!l&&t.hasAnimation?(t.$nextMonthsContainer.addClass("smart-calendar-date-view-container"),"list"===t.displayModeView?t._setDisplayModeContent(a):t._navigationDate&&t._navigationDate.getTime()===a.getTime()||t._animateNavigation(a,e)):t._setDisplayModeContent(a),t.$.fireEvent("navigationChange",{value:new Date(a),type:t.displayMode}),0):(t.hasAnimation?(t._animateNavigation(a,e),t.$nextMonthsContainer.hasClass("smart-date-view-container")&&t.$nextMonthsContainer.removeClass("smart-date-view-container")):(t._handleMonths(a),t._refreshHeaderElements(),t._refreshHeaderTitle()),n&&(t._focusCell(t._getCellByDate(n,t._animationStarted?t.$.nextMonthsContainer:void 0),!0),t._updateWeeksVisibility(e)),t.$.fireEvent("navigationChange",{value:new Date(a),type:t.displayMode}),0)))}}set value(e){this._select(e)}get value(){return this.selectedDates&&this.selectedDates.length>0?this.selectedDates[0]:null}select(e){this._select(e)}_select(e){const t=this;t._viewDates&&void 0!==t._viewDates[0]&&"none"!==t.selectionMode&&e&&(e=t._getValidDate(e))instanceof Date&&("one"===t.selectionMode&&t.selectedDates.map(Number).indexOf(e.getTime())>-1||e.getTime()<t.min.getTime()||e.getTime()>t.max.getTime()||("one"!==t.selectionMode&&"default"!==t.selectionMode&&"zeroOrOne"!==t.selectionMode||t._clearSelection(!0),t._selectDate(e),1!==t.selectedDates.length||t._isDateInView(t.selectedDates[0])||t._handleMonths(t.selectedDates[0])))}today(){const e=this;let t=new Date;return t.setHours(0,0,0,0),t.getTime()<e.min.getTime()||t.getTime()>e.max.getTime()?t=new Date(e.max):e._selectDate(t),e._handleMonths(t),t}_animateNavigation(e,t,a){const n=this;n._navigationDate=e,n._animationSettings||n._applyAnimationSettings(),n.$animationPanel.addClass("smart-hidden"),n.$.dateViewContainer.style.transform="",n.$.dateViewContainer.style.opacity="",n.$.monthsContainer.style.transform="",n.$.monthsContainer.style.opacity="";const l="month"!==n.displayMode?n.$.dateViewContainer:n.$.monthsContainer,i=n.$.body[n._animationSettings.scrollMax]-n.$.body[n._animationSettings.size];n._scrollStep=n.$.body[n._animationSettings.size]*n._animationSettings.startSpeed,n._animationStarted&&n._getMonthCells(n.$.monthsContainer,n.rightToLeft).map((e=>{n._setCellState(e,"restricted",!1),n._setCellState(e,"selected",!1),n._setCellState(e,"otherMonth",!1),n._setCellState(e,"focus",!1),n._setCellState(e,"important",!1),n._setCellState(e,"today",!1),n._setCellState(e,"disabled",!1),n._setCellState(e,"hover",!1)})),n._animationStarted=!0,"month"!==n.displayMode?(n._setCellState(n._focusedCell,"focus",!1),n._setDisplayModeContent(e,n.$.nextMonthsContainer)):n._handleMonths(e,n.$.nextMonthsContainer),n.rightToLeft&&(t*=-1),a||(t>0?(l.style.order=1,n.$.nextMonthsContainer.style.order=3,(!n._animationStarted||n._animationStarted&&n.$.body[n._animationSettings.scrollSize]>n.$.body[n._animationSettings.scrollMax]*n._animationSettings.resetThreshold*2)&&(n.$.body[n._animationSettings.scrollSize]=0)):(l.style.order=3,n.$.nextMonthsContainer.style.order=1,(!n._animationStarted||n._animationStarted&&n.$.body[n._animationSettings.scrollSize]<n.$.body[n._animationSettings.scrollMax]*n._animationSettings.resetThreshold)&&(n.$.body[n._animationSettings.scrollSize]=n.$.body[n._animationSettings.scrollMax]))),cancelAnimationFrame(n._animationId),n._animationId=requestAnimationFrame((function e(){let a=t>0?n.$.body[n._animationSettings.scrollSize]>=i:0===n.$.body[n._animationSettings.scrollSize],l=n._scrollStep/2;a?n._animateNavigationCompleted():(t>0&&n.$.body[n._animationSettings.scrollSize]>i*n._animationSettings.easeThreshold?(l=Math.max(n.$.body[n._animationSettings.scrollSize]/n._animationSettings.stepEaseSize,Math.abs(l-(i-n.$.body[n._animationSettings.scrollSize])*n._animationSettings.step)),n._scrollStep=n._scrollStep*n._animationSettings.step+l):t<0&&n.$.body[n._animationSettings.scrollSize]<i*n._animationSettings.easeThreshold&&(l=Math.max(n.$.body[n._animationSettings.scrollMax]/n._animationSettings.stepEaseSize,Math.abs(l-n.$.body[n._animationSettings.scrollSize]*n._animationSettings.step)),n._scrollStep=n._scrollStep*n._animationSettings.step+l),n.$.body[n._animationSettings.scrollSize]+=t>0?n._scrollStep:-n._scrollStep,n._animationId=requestAnimationFrame(e))}))}_animateNavigationCompleted(){const e=this;let t,a,n,l="month"!==e.displayMode?e.$.dateViewContainer:e.$.monthsContainer;if(cancelAnimationFrame(e._animationId),"month"!==e.displayMode){let i=[].slice.call(l.children).indexOf(e._focusedCell);l.innerHTML=e.$.nextMonthsContainer.innerHTML;let s,o=l.children[i];a=l.children,n=e.$.nextMonthsContainer.children;for(let t=0;t<a.length;t++)a[t].value=n[t].value,a[t].restricted=n[t].restricted,a[t].important=n[t].important,a[t].otherMonth=n[t].otherMonth,a[t].value.getTime()<=e.max.getTime()&&(s=a[t]);t=o&&o.value.getTime()>=e.max.getTime()?s.value:e._focusedCell?e._focusedCell.value:void 0}else{let i=l.children,s=e.$.nextMonthsContainer.children;e._focusedCell&&e.$.nextMonthsContainer.contains(e._focusedCell)&&(t=e._focusedCell.value);for(let t=0;t<i.length&&s[t]._date;t++){i[t]._date=s[t]._date,i[t].innerHTML=s[t].innerHTML,a=e._getMonthCells(i[t]),n=e._getMonthCells(s[t]);for(let e=0;e<a.length;e++)a[e].value=n[e].value,a[e].restricted=n[e].restricted,a[e].important=n[e].important,a[e].otherMonth=n[e].otherMonth,a[e].removeAttribute("focus")}e._selectedCells.length>0&&(e._selectedCells=e._selectedCells.map((t=>e._getCellByDate(t.value))).filter((e=>void 0!==e)))}e._focusCell(e._getCellByDate(t)),l.style.order=1,e.$.nextMonthsContainer.style.order=3,e.$.body[e._animationSettings.scrollSize]=0,e._animationStarted=!1,delete e._navigationDate}_applyAnimationSettings(e){const t=this;t._animationSettings=t.animationSettings?t.animationSettings:t._animationSettings||{},"portrait"===t.scrollButtonsNavigationMode?(t._animationSettings.scrollMax="scrollHeight",t._animationSettings.size="offsetHeight",t._animationSettings.scrollSize="scrollTop"):(t._animationSettings.scrollMax="scrollWidth",t._animationSettings.size="offsetWidth",t._animationSettings.scrollSize="scrollLeft"),e||(t._animationSettings.startSpeed=t._animationSettings.startSpeed?t._animationSettings.startSpeed:.2,t._animationSettings.easeThreshold=t._animationSettings.easeThreshold?t._animationSettings.easeThreshold:.5,t._animationSettings.step=t._animationSettings.step?t._animationSettings.step:.25,t._animationSettings.stepEaseSize=t._animationSettings.stepEaseSize?t._animationSettings.stepEaseSize:200,t._animationSettings.resetThreshold=t._animationSettings.resetThreshold?t._animationSettings.resetThreshold:.2)}_applySelectionMode(e,t){const a=this;let n=[],l=!!e,i=a.selectionMode;function s(e,t){const n=a.$.monthsContainer.children;for(let l=0;l<n.length;l++)a._getMonthCells(n[l]).map((n=>{a._setCellState(n,e,t)}))}switch("many"===i&&"range"===i||s("hover",!1),a._newRangeSelectionStarted=a.selectedDates.length>0&&"range"===i,-1!==["default","many","zeroOrMany","oneOrMany","week","range"].indexOf(i)?Array.from(a.getElementsByClassName("smart-calendar-month")).forEach((e=>e.setAttribute("aria-multiselectable",!0))):Array.from(a.getElementsByClassName("smart-calendar-month")).forEach((e=>e.removeAttribute("aria-multiselectable"))),"none"!==i&&"none"!==t||s("selected",!1),i){case"none":return void a._clearSelection(l);case"range":return void(a.selectedDates.length>1&&a._selectMultipleDates(a.selectedDates[0],a.selectedDates[a.selectedDates.length-1]));case"many":case"default":case"oneOrMany":if(0===a.selectedDates.length){n.push(new Date(Math.min(Math.max(a.min.getTime(),(new Date).setHours(0,0,0,0)),a.max.getTime())));break}return;case"oneExtended":case"one":if(1===a.selectedDates.length)return;a.selectedDates.length>1?(n.push(a.selectedDates[a.selectedDates.length-1]),a._clearSelection(l)):n.push(new Date(Math.min(Math.max(a.min.getTime(),(new Date).setHours(0,0,0,0)),a.max.getTime())));break;case"zeroOrOne":if(a.selectedDates.length>1){n.push(a.selectedDates[a.selectedDates.length-1]),a._clearSelection(l);break}return;case"zeroOrMany":return;case"week":if(a.selectedDates.length>=1){let e=a.selectedDates[a.selectedDates.length-1];for(let t=0;t<7;t++)n.push(new Date(e)),e.setDate(e.getDate()+1);a._clearSelection(l)}}if(a.selectedDates=[],e)return void(a.selectedDates=n);const o=n.length;for(let e=0;e<o;e++)a._selectDate(n[e],e<o-1)}_clearSelection(e){const t=this,a=t.selectedDates.slice(0),n=t.selectionMode;if(t.isRendered){if(t._selectedCells&&t._selectedCells.map((e=>{t._setCellState(e,"selected",!1)})),t.selectedDates=[],t._selectedCells=[],"many"===n||"range"===n){const e=t.$.monthsContainer.children;for(let a=0;a<e.length;a++)t._getMonthCells(e[a]).map((e=>{t._setCellState(e,"hover",!1)}))}t.$.footer&&t._refreshFooter(),t.$.hiddenInput.value=t.selectedDates.toString(),!e&&t.isInitialized&&a.length&&(t.$.fireEvent("change",{value:[]}),t._updateTargetValue()),t.$.title&&t._refreshTitle()}else t.set("selectedDates",[])}_bodyBlurStateHandler(e){this._bodyStateHandler(e),this.$.fireEvent("blur")}_bodyFocusStateHandler(e){this._bodyStateHandler(e),this.$.fireEvent("focus")}_bodyStateHandler(e){const t=this;if(t._focusedCell){if("blur"===e.type||"focus"===e.type&&t._noFocusingRequired)return t._noFocusingRequired=!1,void t._setCellState(t._focusedCell,"focus",!1);if("month"!==t.displayMode)return void("focus"!==e.type||t.$.dateViewContainer.querySelector("smart-calendar-cell[focus]")||t._setCellState(t._focusedCell||t.$.dateViewContainer.querySelector(".smart-calendar-cell"),"focus",!0))}"focus"===e.type&&t._focusCell()}_containerWheelHandler(e){const t=this;if(t.disabled||t.readonly||"month"!==t.displayMode&&"list"===t.displayModeView)return;let a,n;n=document.activeElement,t.shadowRoot?n=t.shadowRoot.activeElement:t.isInShadowDOM&&(n=t.getRootNode().activeElement),t.$.yearElement===n&&(a=12),(n&&t.shadowRoot||n.closest("smart-calendar")===t)&&(a=e.target===t.$.yearElement?12:1),a&&(e.preventDefault(),a=12===a?a:a*t.months,e.deltaY>0?t.navigate(-a):t.navigate(a))}_downHandler(e){const t=this;let a=e.originalEvent.target;if(t._dragStartDetails=void 0,t.disabled||t.readonly)return;if(t.hasRippleAnimation&&(a.value instanceof Date||a.parentElement&&a.parentElement.classList.contains("smart-calendar-title")||a.parentElement===t.$.dateElement)&&Smart.Utilities.Animation.Ripple.animate(a,e.pageX,e.pageY),a=e.originalEvent.target.closest(".smart-calendar-header"),e.originalEvent.target.closest(".smart-calendar-year-container")&&"decade"!==t.displayMode){if("classic"===t.calendarMode)return;return void t._showDateView("year")}if(e.originalEvent.target.closest(".smart-calendar-date-container")&&"month"!==t.displayMode){if("classic"===t.calendarMode)return;return void t._displayModeHandler("list"===t.displayModeView?t.$.listViewContainer.querySelector("li.active"):t._focusedCell,"month")}if(t._animationStarted&&t._animateNavigationCompleted(),Smart.Utilities.Core.isMobile&&e.originalEvent.target.closest(".smart-calendar-body")===t.$.body)return void(t._dragStartDetails={x:e.pageX,y:e.pageY,startTime:Date.now(),target:e.originalEvent.target});if(a=e.originalEvent.target,a.closest(".smart-calendar-week")||a.parentElement===t.$.dateViewContainer){for(;a&&!(a.value instanceof Date);)a=a.parentElement;return void(a&&("month"!==t.displayMode?t._displayModeHandler(a):t._weeksDownHandler(e,a)))}if(a.closest(".smart-calendar-month-element"))return;if(e.originalEvent.stopPropagation(),"list"===t.displayModeView&&"month"!==t.displayMode)return a=(t.shadowRoot||t.isInShadowDOM?e.originalEvent.composedPath()[0]:e.originalEvent.target).closest("smart-list-item"),void(a&&t._displayModeHandler(a));const n=document.scrollingElement||document.documentElement,l=n.scrollLeft,i=n.scrollTop;t.unfocusable||t.focus(),window.scrollTo(l,i)}_displayModeHandler(e,t){const a=this;if(a._animationStarted&&a._animateNavigationCompleted(),e instanceof HTMLElement&&e.closest(".smart-calendar-week")&&e.otherMonth){if("decade"===a.displayMode&&(e.value.getFullYear()<a.min.getFullYear()||e.value.getFullYear()>a.max.getFullYear()))return;if("year"===a.displayMode&&(e.value.getFullYear()<a.min.getFullYear()||e.value.getFullYear()===a.min.getFullYear()&&e.value.getMonth()<a.min.getMonth()||e.value.getFullYear()>a.max.getFullYear()||e.value.getFullYear()===a.max.getFullYear()&&e.value.getMonth()>a.max.getMonth()))return}switch(t=t||a.displayMode){case"year":t="month";break;case"decade":t="year"}if(a.displayMode===t)return;const n=a.$.listViewContainer,l=n&&n.contains(e);a.$.fireEvent("displayModeChanging",{oldDisplayMode:a.displayMode,newDisplayMode:t}).defaultPrevented||(a.set("displayMode",t),a.$nextMonthsContainer.removeClass("smart-calendar-date-view-container"),e.parentElement!==a.$.dateViewContainer||e.disabled||e.restricted||a._focusCell(e),a.hasAnimation?(l&&e instanceof HTMLLIElement?e.offsetHeight?a.$.animationPanel.style.transformOrigin=e.offsetWidth/2+"px "+(e.offsetTop+e.offsetHeight/2)+"px":a.$.animationPanel.style.transformOrigin=n.offsetLeft+n.offsetWidth/2+"px "+(n.offsetTop+n.offsetHeight/2)+"px":(a.$.dateViewContainer.style.order=1,a.$.nextMonthsContainer.style.order=3,e=a._focusedCell,a.$.animationPanel.style.transformOrigin=e.offsetLeft+e.offsetWidth/2+"px "+(e.offsetTop+e.offsetHeight/2)+"px"),a._animateView(1,e)):a._setDisplayModeContent(e.value instanceof Date?e.value:new Date(e.getAttribute("value")||e.value)))}_animateView(e,t){const a=this;let n,l,i=t instanceof Date?t:new Date(t.getAttribute("value")||t.value),s=!1,o=1,r=1;const d=a.$.listViewContainer;"list"===a.displayModeView?n=d.contains(t)?d:l="month"!==a.displayMode?a.$.monthsContainer:d:t.value instanceof Date||(t=a._focusedCell?a._focusedCell:a._selectedCells.length>0?a._selectedCells[a._selectedCells.length-1]:a._getCellByDate(new Date)),n||(n=t.parentElement===a.$.dateViewContainer?a.$.dateViewContainer:a.$.monthsContainer),l||(l="month"===a.displayMode?a.$.monthsContainer:"list"===a.displayModeView?d:a.$.dateViewContainer),l.style.transformOrigin=a.$.animationPanel.style.transformOrigin,n===d?(a.$.animationPanel.innerHTML="",a.$.animationPanel.appendChild(n.cloneNode(!0))):a.$.animationPanel.innerHTML=n.innerHTML,a._setDisplayModeContent(i),n.style.order=1,a.$.nextMonthsContainer.style.order=3,a.$.body[a._animationSettings.scrollSize]=0,a.$.animationPanel.style.width=a.$.body.offsetWidth+"px",a.$.animationPanel.style.height=a.$.body.offsetHeight+"px",a.$.animationPanel.style.transform="scale(1)",a.$.animationPanel.style.opacity=1,a.$animationPanel.removeClass("smart-hidden"),l.style.opacity="0",l.style.transform="scale(3.5)",n.$.hasClass("smart-calendar-date-view-container")?a.$animationPanel.addClass("smart-calendar-date-view-container"):a.$animationPanel.removeClass("smart-calendar-date-view-container"),cancelAnimationFrame(a._animationId),a._animationId=requestAnimationFrame((function t(){if((e>0&&o>=3.5||e<0&&o<=0)&&(s=!0),s){if(cancelAnimationFrame(a._animationId),a.$animationPanel.addClass("smart-hidden"),a.$.animationPanel.style.transform="",a.$.animationPanel.style.opacity="",n.style.order=1,a.$.nextMonthsContainer.style.order=3,a.$.body[a._animationSettings.scrollSize]=0,l.style.transform="",l.style.opacity="",a.unfocusable)return;"month"===a.displayMode?a.$.body.focus():"list"===a.displayModeView&&a.focus()}else a.$.animationPanel.style.opacity=r,l.style.opacity=1-r,r-=.05,e>0?(a.$.animationPanel.style.transform="scale("+o+")",l.style.transform="scale("+Math.min((o-1)/2,1)+")",o+=.125):(a.$.animationPanel.style.transform="scale("+Math.max(o,0)+")",l.style.transform="scale("+Math.max(1+o,1)+")",o-=.06),a._animationId=requestAnimationFrame(t)}))}_documentUpHandler(e){const t=this;let a=e.originalEvent.target;if((t.isInShadowDOM||t.shadowRoot&&a===t)&&(a=e.originalEvent.composedPath()[0]),t._newRangeSelectionStarted&&!t.$.container.contains(a)&&delete t._newRangeSelectionStarted,a&&a.classList&&a.classList.contains("smart-calendar-cell")&&t._dragStartDetails&&(e.originalEvent.stopPropagation(),e.originalEvent.preventDefault(),e.preventDefault()),!Smart.Utilities.Core.isMobile||!t._dragStartDetails||e.originalEvent.target.closest(".smart-calendar-list-view"))return;delete t._previousIteration;const n=Date.now();let l={};(t.isInShadowDOM||t.shadowRoot&&a===t)&&(a=e.originalEvent.composedPath()[0]),"portrait"===t.scrollButtonsNavigationMode?(l.coordinate="y",l.direction="pageY"):(l.coordinate="x",l.direction="pageX");const i=t._dragStartDetails.step*(t.rightToLeft?-1:1);if(Math.abs(t._dragStartDetails[l.coordinate]-e[l.direction])<=10){if(a="list"===t.displayModeView&&"month"!==t.displayMode?a.closest("smart-list-item"):a,!a)return void(t._dragStartDetails=void 0);if("month"!==t.displayMode)return t._displayModeHandler(a),"portrait"===t.scrollButtonsNavigationMode?t.$.body.scrollTop=0:t.$.body.scrollLeft=0,void(t._dragStartDetails=void 0);if(t._weeksDownHandler(e,a),!t.disableAutoNavigation&&a.otherMonth)return}else{const a=Math.abs((e[l.direction]-t._dragStartDetails[l.coordinate])/(n-t._dragStartDetails.startTime));if(a>1){const e=parseInt(a);for(let a=0;a<e;a++)if(!t.navigate(i)){t._cancelAnimation();break}return void(t._dragStartDetails=void 0)}}if(!t.hasAnimation)return t.navigate(t._dragStartDetails.step),void(t._dragStartDetails=void 0);let s=("month"!==t.displayMode?t.$.dateViewContainer[t._animationSettings.scrollMax]:t.$.monthsContainer[t._animationSettings.scrollMax])+t.$.monthsSeparator[t._animationSettings.size];if(t._dragStartDetails.step>0&&t.$.body[t._animationSettings.scrollSize]>s*t._animationSettings.easeThreshold||t._dragStartDetails.step<0&&t.$.body[t._animationSettings.scrollSize]<s*t._animationSettings.easeThreshold)return t._animateNavigation(t._dragStartDetails.navigationDate,i,!0),6!==t.weeks&&0!==t.weeks&&"month"===t.displayMode&&t._updateWeeksVisibility(i,t._getCellByDate(t._dragStartDetails.navigationDate,t.$.nextMonthsContainer)),t.$.fireEvent("navigationChange",{value:new Date(t._dragStartDetails.navigationDate),type:t.displayMode}),void(t._dragStartDetails=void 0);t._cancelAnimation(),t._dragStartDetails=void 0}_cancelAnimation(){const e=this,t="month"!==e.displayMode?e.$.dateViewContainer:e.$.monthsContainer;let a=e.$.animationPanel.style.transform,n=e.$.animationPanel.style.opacity;a&&(a=parseFloat(a.substring(a.indexOf("(")+1||0,a.indexOf(")")))),t.style.order=1,e.$.nextMonthsContainer.style.order=3,e.$.body[e._animationSettings.scrollSize]=0,e._animationId=requestAnimationFrame((function t(){if(!a||a>=3.5){cancelAnimationFrame(e._animationId),e.$animationPanel.addClass("smart-hidden"),e.$.animationPanel.style.transform="",e.$.animationPanel.style.opacity="";const t="month"===e.displayMode?e.$.monthsContainer:e.$.listViewContainer;return t.style.transform="",t.style.opacity="",e.unfocusable||("month"===e.displayMode?e.$.body.focus():"list"===e.displayModeView&&e.focus()),void(e._animationStarted=!1)}e.$.animationPanel.style.opacity=n-=.25,e.$.animationPanel.style.transform="scale("+(a+=.5)+")",e._animationId=requestAnimationFrame(t)}))}_focusCell(e,t){const a=this;if(a._focusedCell&&a._setCellState(a._focusedCell,"focus",!1),a.disabled||a.readonly)return;if(e){if("month"!==a.displayMode)return a._setCellState(e,"focus",!0),void(a._focusedCell=e);if(e.disabled||e.restricted)return;return t||a._setCellState(e,"focus",!0),void(a._focusedCell=e)}if("month"!==a.displayMode&&0===a.$.monthsContainer.offsetHeight)return;const n=a._selectedCells[a._selectedCells.length-1];if(n&&n.offsetHeight)a._setCellState(n,"focus",!0),a._focusedCell=n;else{const e=a.$.monthsContainer.children;if(!e[0]._date||a.min.getTime<e[0]._date.getTime())return;const t=a._getMonthCells(e[0],a.rightToLeft);for(let e=0;e<t.length;e++){const n=t[e];if(!n.otherMonth){if(n.disabled||n.restricted||!n.offsetHeight)continue;a._focusedCell=n;break}}}a._focusedCell&&a._setCellState(a._focusedCell,"focus",!0)}_getDays(e,t){const a=t.length;let n=[];if(a>0)for(let l=0;l<a;l++)t[l].getFullYear()===e.getFullYear()&&t[l].getMonth()===e.getMonth()&&n.push(t[l].getDate());return n}_getCellByDate(e,t){const a=this;if(!(e instanceof Date))return;if(t||(t=a.$.monthsContainer),"month"!==a.displayMode){if("list"===a.displayModeView)return;let t=arguments[1]?a.$.nextMonthsContainer.children:a.$.dateViewContainer.children;for(let n=0;n<t.length;n++)if("year"!==a.displayMode){if(t[n].value.getFullYear()===e.getFullYear())return t[n]}else if(t[n].value.getMonth()===e.getMonth())return t[n];return}let n,l,i=t.children;for(let t=0;t<i.length;t++)if(e.getFullYear()===i[t]._date.getFullYear()&&e.getMonth()===i[t]._date.getMonth()){n=i[t];break}if(n){l=a._getMonthCells(n);for(let t=0;t<l.length;t++)if((!l[t].otherMonth||l[t].hover)&&l[t].value.getMonth()===e.getMonth()&&l[t].value.getDate()===e.getDate())return l[t]}}_getMonthCells(e,t){const a=e.getElementsByClassName("smart-calendar-week");let n=[];if(t)for(let e=0;e<a.length;e++){let t=a[e].children;for(let e=t.length-1;e>0;e--)t[e].classList.contains("smart-calendar-cell")&&n.push(t[e])}else for(let e=0;e<a.length;e++){let t=a[e].children;for(let e=1;e<t.length;e++)t[e].classList.contains("smart-calendar-cell")&&n.push(t[e])}return n}_getWeekNumber(e){const t=this;let a,n=new Date(e.getFullYear(),0,1),l=Math.round((e.getTime()-n.getTime()-6e4*(e.getTimezoneOffset()-n.getTimezoneOffset()))/864e5)+1,i=n.getDay()-t.firstDayOfWeek;return i=i>=0?i:i+7,i<4?(a=Math.floor((l+i-1)/7)+1,a>52&&(n=new Date(e.getFullYear()+1,0,1),i=n.getDay()-t.firstDayOfWeek,i=i>=0?i:i+7,a=i<4?1:53)):a=Math.round((l+i-1)/7),a}_handleDateSelection(e){const t=this;if(void 0!==e&&!e.disabled&&!e.restricted)switch(t.selectionMode){case"none":t._focusCell(e);break;case"oneExtended":case"one":case"default":if(t._keysPressed.Control)return t.selectedDates.length>1||1===t.selectedDates.length&&!e.selected?void t._selectDate(e.value):void t._focusCell(e);if(t._keysPressed.Shift)return void t._selectMultipleDates(new Date(t.selectedDates[0]),e);t._clearSelection(!0),t._selectDate(e.value,t._selectedCells.indexOf(e.value)>-1);break;case"many":{if(0===t.selectedDates.length)return void t._selectDate(e.value);const a=t.selectedDates[t.selectedDates.length-1];let n=new Date(t.selectedDates[0]);if(e.value.getTime()===n.getTime()||e.value.getTime()===a.getTime())return t._clearSelection(),void t._focusCell(e);t.selectedDates.length>0&&t._selectMultipleDates(n,e);break}case"range":{if(t.selectedDates.length>1&&!t._keysPressed.Control&&!t._newRangeSelectionStarted&&t._clearSelection(!0),0===t.selectedDates.length||t._keysPressed.Control&&t.selectedDates.length>1&&!t._newRangeSelectionStarted){if(e.value&&t.selectedDates.find((t=>t.getTime()===e.value.getTime())))return;return t._newRangeSelectionStarted=!0,void t._selectDate(e.value)}const a=t.selectedDates[t.selectedDates.length-1];let n=t._keysPressed.Control||t._newRangeSelectionStarted?a:new Date(t.selectedDates[0]);t.selectedDates.length>0&&t._selectMultipleDates(n,e),delete t._newRangeSelectionStarted;break}case"zeroOrMany":t._selectDate(e.value);break;case"oneOrMany":if(1===t.selectedDates.length&&e.selected)return void t._focusCell(e);t._selectDate(e.value);break;case"zeroOrOne":if(1===t.selectedDates.length&&e.selected)return void t._selectDate(e.value);t._clearSelection(!0),t._selectDate(e.value);break;case"week":{if(e.selected&&(e.value.getTime()===t.selectedDates[0].getTime()||e.value.getTime()===t.selectedDates[t.selectedDates.length-1].getTime()))return t._clearSelection(),void t._focusCell(e);t._clearSelection(!0);let a=new Date(e.value);t._selectDate(a);for(let e=1;e<7;e++)a.setDate(a.getDate()+1),t._selectDate(a);t._isDateInView(a)||t.navigate(1);break}}}_handleImportantDateTemplate(){const e=this;if(e._importantDatesTemplate=e._validateTemplate("importantDatesTemplate",e.importantDatesTemplate),!e._importantDatesTemplate||!e._importantDatesTemplate.content)return;let t=e._importantDatesTemplate.content;const a=t.childNodes.length,n=/{{\w+}}/g;let l;e._bindingDetails=[];for(let i=0;i<a;i++)if(l=n.exec(t.childNodes[i].innerHTML),l)return void e._bindingDetails.push({childNodeIndex:i,bindingString:l[0]})}_handleLayoutTemplate(e,t){const a=this,n=a._validateTemplate(e.$.hasClass("smart-header")?"headerTemplate":e.$.hasClass("smart-calendar-footer")?"footerTemplate":"titleTemplate",t);if(!n||!n.content)return void("function"==typeof t&&t(e,{}));a._layoutTemplates||(a._layoutTemplates=[]);let l=document.importNode(n.content,!0);e.innerHTML="";const i=l.childNodes.length,s=/{{\w+}}/g;let o,r=[];for(let e=0;e<i;e++)o=s.exec(l.childNodes[e].innerHTML),o&&r.push({childNodeIndex:e,bindingString:o[0]});if(a._layoutTemplates=a._layoutTemplates.filter((t=>t.selector!==e)),a._layoutTemplates.push({selector:e,template:n,bindings:r}),a.shadowRoot)return e.innerHTML="<slot></slot>",void a.appendChild(l);e.appendChild(l)}_handleCalendarCellHover(e,t){const a=this;if(!a._animationStarted){if("month"===a.displayMode)if("mouseover"===e.type&&("many"===a.selectionMode||"range"===a.selectionMode&&a._newRangeSelectionStarted)&&a.selectedDates.length>0){const e=a.$.monthsContainer.children;for(let t=0;t<e.length;t++)a._getMonthCells(e[t]).map((e=>{a._setCellState(e,"hover",!1)}));let n=new Date("range"===a.selectionMode?a.selectedDates[a.selectedDates.length-1]:a.selectedDates[0]),l=new Date(t.value),i=t;const s=n.getTime()>l.getTime()?-1:1,o=function(){i=a._getCellByDate(n),!i||i.selected||i.restricted||a._setCellState(i,"hover",!0)};if(n.getTime()!==l.getTime()){for(n.setDate(n.getDate()+s);n.getTime()!==l.getTime();)o(),n.setDate(n.getDate()+s);o()}}else a._setCellState(t,"hover",!1);"mouseover"!==e.type||t.otherMonth?a._setCellState(t,"hover",!1):a._setCellState(t,"hover",!0)}}_handleMonths(e,t){const a=this;let n;function l(e){let t,n=e.children.length,l=document.createDocumentFragment();for(;n<a.months;n++)t=a.$.month.cloneNode(!1),t.innerHTML=a.$.month.innerHTML,l.appendChild(t);return l}function i(t){let n=t.children;for(let t=0;t<n.length;t++)a._setMonth(e,n[t]),e.setMonth(e.getMonth()+1);a._setWeeksVisibility(t),a._refreshHeaderElements(),a._refreshHeaderTitle(),a.tooltip&&a.$.tooltip&&a.$.tooltip.close(),a.$.body===document.activeElement&&a._focusCell()}if(e||(e=a._viewDates&&a._viewDates.length>0?a._viewDates[0]:new Date),e=new Date(Math.min(Math.max(a.min.getTime(),e.getTime()),a.max.getTime())),t||(t=a.$.monthsContainer),a._selectedCells=[],a.hasAnimation){for(n=a.$.nextMonthsContainer.children,n.length>0&&n[0].value instanceof Date&&(a.$.nextMonthsContainer.innerHTML="");a.$.nextMonthsContainer.childElementCount<a.months;)a.$.nextMonthsContainer.appendChild(l(a.$.nextMonthsContainer));for(;a.$.nextMonthsContainer.childElementCount>a.months;)a.$.nextMonthsContainer.removeChild(n[a.$.nextMonthsContainer.childElementCount-1]);if(arguments[1]===a.$.nextMonthsContainer)return void i(a.$.nextMonthsContainer)}if(n=a.$.monthsContainer.children,n.length>a.months){for(;a.$.monthsContainer.childElementCount>a.months;)a.$.monthsContainer.removeChild(n[a.$.monthsContainer.childElementCount-1]),a._viewDates.pop();i(a.$.monthsContainer)}else a.$.monthsContainer.children.length!==a.months?(a._viewDates=[],a.$.monthsContainer.appendChild(l(a.$.monthsContainer)),i(a.$.monthsContainer)):i(a.$.monthsContainer)}_headerChangeHandler(e){const t=this;if(e.stopPropagation(),t.disabled||t.readonly)return;if(e.target.ownerElement===t.$.monthElement&&0!==t._changeEventFired)return void t._changeEventFired--;const a=t.displayMode;e.target===t.$.yearElement&&(t._viewDates[0].setFullYear(Math.min(Math.max(t.min.getFullYear(),isNaN(parseInt(t.$.yearElement.value))?0:parseInt(t.$.yearElement.value)),t.max.getFullYear())),t._handleMonths(t._viewDates[0])),!t.$.monthElement||e.target!==t.$.monthElement&&e.target.ownerElement!==t.$.monthElement||(t._handleMonths(new Date(t.$.monthsContainer.children[0]._date.getFullYear(),t.$.monthElement.selectedIndex,1)),"month"!==a&&t._setDisplayMode(t.displayMode,t.displayMode="month"))}_headerClickHandler(e){const t=this;if(t.disabled||t.readonly)return;let a=e.target.closest("smart-repeat-button");if(!a||!a.disabled){switch(a){case t.$.previousMonthButton:return t._isInteractiveNavigation=!0,void t.navigate(-1*t.months*(t.rightToLeft?-1:1));case t.$.nextMonthButton:return t._isInteractiveNavigation=!0,void t.navigate(1*t.months*(t.rightToLeft?-1:1));case t.$.previousYearButton:return void t.navigate(-12);case t.$.nextYearButton:return void t.navigate(12)}"classic"!==t.calendarMode&&e.target.closest(".smart-calendar-date-element")&&(t._animationStarted&&t._animateNavigationCompleted(),t._isInteractiveNavigation=!0,t._showDateView())}}_selectMultipleDates(e,t){const a=this;if(t instanceof HTMLElement&&(t=t.value),a._newRangeSelectionStarted?a._selectDate(e,!0):a._clearSelection(!0),"range"!==a.selectionMode||t.getTime()!==e.getTime()){if((e=new Date(e)).getTime()<t.getTime())for(;e.getTime()<=t.getTime();)a.selectedDates.find((t=>t.getTime()===e.getTime()))||a._selectDate(e,!0),e.setDate(e.getDate()+1);else if(e.getTime()>t.getTime())for(;e.getTime()>=t.getTime();)a.selectedDates.find((t=>t.getTime()===e.getTime()))||a._selectDate(e,!0),e.setDate(e.getDate()-1);else a._selectDate(t,!0);a.$.hiddenInput.value=a.selectedDates.toString(),a._refreshFooter(),a.isInitialized&&(a.$.fireEvent("change",{value:a.selectedDates}),a._updateTargetValue()),a._refreshTitle()}}_setDisplayMode(e,t,a){const n=this;if(n.$nextMonthsContainer.removeClass("smart-calendar-date-view-container"),0!==arguments.length&&n.hasAnimation)if(n._animationStarted&&(n.displayMode=e,n._animateNavigationCompleted(),n.displayMode=t),"month"===e&&"year"===t||"year"===e&&"decade"===t)n.displayMode=e,n._showDateView(a?void 0:n.displayMode);else if("month"===e&&"decade"===t)n._showDateView(n.displayMode="year");else{let e;"list"===n.displayModeView?(e=n.$.listViewContainer.querySelector("li.active"),n.$.animationPanel.style.transformOrigin=e.offsetLeft+e.offsetWidth/2+"px "+(e.offsetTop>0?e.offsetTop-e.offsetHeight/2:e.offsetTop+e.offsetHeight/2)+"px"):(n.$.dateViewContainer.style.order=1,n.$.nextMonthsContainer.style.order=3,e=n._focusedCell,n.$.animationPanel.style.transformOrigin=e.offsetLeft+e.offsetWidth/2+"px "+(e.offsetTop+e.offsetHeight/2)+"px"),n._animateView(1,e)}else{if("classic"===n.calendarMode)return void(n.displayMode="month");if("month"!==n.displayMode&&(n.$monthsContainer.addClass("smart-hidden"),n.$dateViewContainer.hasClass("smart-hidden")&&n.$dateViewContainer.removeClass("smart-hidden")),!n.isCompleted&&"month"===n.displayMode)return;n._setDisplayModeContent()}}_setDisplayModeContent(e,t){const a=this;let n=e&&"Invalid Date"!==e.toString()?e:a.selectedDates.length>0?a.selectedDates[a.selectedDates.length-1]:new Date;n.setTime(Math.min(Math.max(n.getTime(),a.min.getTime()),a.max.getTime())),n.setHours(0,0,0,0);const l=a._prepareView(n);if(!l)return;let i;t?(a.$.nextMonthsContainer.innerHTML=a.$.dateViewContainer.innerHTML,i=a.$.nextMonthsContainer):i=a.$.dateViewContainer;const s=i.children;let o;for(let e=0;e<s.length;e++){const t=s[e];t.innerHTML=l.viewContent[e],t.value=l.dates[e],"year"===a.displayMode?(t.value.getFullYear()<a.min.getFullYear()||t.value.getFullYear()===a.min.getFullYear()&&t.value.getMonth()<a.min.getMonth()||t.value.getFullYear()>a.max.getFullYear()||t.value.getFullYear()===a.max.getFullYear()&&t.value.getMonth()>a.max.getMonth()?a._setCellState(t,"otherMonth",!0):a._setCellState(t,"otherMonth",!1),n.getFullYear()===t.value.getFullYear()&&n.getMonth()===t.value.getMonth()&&(o=t)):"decade"===a.displayMode&&(0===e||e===s.length-1||t.value.getFullYear()<a.min.getFullYear()||t.value.getFullYear()>a.max.getFullYear()?a._setCellState(t,"otherMonth",!0):a._setCellState(t,"otherMonth",!1),n.getFullYear()===t.value.getFullYear()&&(o=t)),a._setCellState(t,"hover",!1),a._setCellState(t,"focus",!1)}if(o.otherMonth)for(let e=0;e<s.length;e++)if(!s[e].otherMonth){o=s[e];break}a._mobileScrolling||(a._focusedCell&&a._setCellState(a._focusedCell,"focus",!1),a._focusedCell=o,a._focusCell(a._focusedCell),a._refreshHeaderTitle(),a._refreshHeaderElements(),a.$.fireEvent("displayModeChange"),a._isInteractiveNavigation?a._isInteractiveNavigation=void 0:(a._setCellState(o,"focus",!0),setTimeout((function(){a.unfocusable||(a.$.body.focus(),a._focusCell(a._focusedCell))}),0)))}_prepareView(e){const t=this,a=t.$.listViewContainer;let n,l,i=[],s=[];function o(e,t,a){let n=new Date(e,t+1,0),l=n.getDate();return a>l?n.setDate(l):n.setDate(a),n}if("month"===t.displayMode)return t.$nextMonthsContainer.hasClass("smart-date-view-container")&&t.$nextMonthsContainer.removeClass("smart-date-view-container"),a&&a.classList.add("smart-hidden"),t.$dateViewContainer.hasClass("smart-visibility-hidden")&&t.$dateViewContainer.removeClass("smart-visibility-hidden"),t._isDateInView(e)||t._handleMonths(e),t.$header.hasClass("smart-hidden")&&t.$header.removeClass("smart-hidden"),t.$body.hasClass("smart-calendar-list-view")&&t.$body.removeClass("smart-calendar-list-view"),t.$dateContainer.addClass("smart-calendar-selected"),t.$yearContainer.removeClass("smart-calendar-selected"),t.$dateViewContainer.addClass("smart-hidden"),t.$monthsContainer.removeClass("smart-hidden"),t._refreshHeaderTitle(),t.$.body.setAttribute("tabindex",t.tabIndex>0?t.tabIndex:0),t._refreshHeaderElements(),t.unfocusable||t.$.body.focus(),t._focusCell(t._getCellByDate(e)),void t.$.fireEvent("displayModeChange");if("list"===t.displayModeView)return t._setDisplayModeListContent(e),void t.$.fireEvent("displayModeChange");if(t.$header.hasClass("smart-hidden")&&t.$header.removeClass("smart-hidden"),t.$dateViewContainer.hasClass("smart-visibility-hidden")&&t.$dateViewContainer.removeClass("smart-visibility-hidden"),a&&a.classList.add("smart-hidden"),t.$.body.setAttribute("tabindex",t.tabIndex>0?t.tabIndex:0),"year"===t.displayMode){let a=new Date;for(let n=0;n<12;n++)a=o(a.getFullYear(),n,a.getDate()),i.push(a.toLocaleDateString(t.locale,{month:"short"})),s.push(o(e.getFullYear(),n,e.getDate()))}else{n=e?e.getFullYear():t._viewDates[0].getFullYear(),l=n%10,0!==l&&(n-=l),n-=1;for(let t=0;t<12;t++)i.push(n+""),s.push(new Date(n,e.getMonth(),e.getDate())),++n}return{viewContent:i,dates:s}}_setDisplayModeListContent(e){const t=this;let a=[];function n(e,t,a){let n=new Date(e,t+1,0),l=n.getDate();return a>l?n.setDate(l):n.setDate(a),n}if(t.$dateViewContainer.addClass("smart-visibility-hidden"),"year"===t.displayMode){let l=new Date;for(let i=0;i<12;i++)l=n(l.getFullYear(),i,l.getDate()),a.push({label:l.toLocaleDateString(t.locale,{month:"short"}),value:n(e.getFullYear(),i,e.getDate()).toDateString()});t.$yearContainer.removeClass("smart-calendar-selected"),t.$dateContainer.addClass("smart-calendar-selected")}else{let n=t.min.getFullYear(),l=t.max.getFullYear();l=Math.min(t.max.getFullYear(),e.getFullYear()+10),n=Math.max(t.min.getFullYear(),l-10);for(let t=n;t<l;t++)a.push({label:t.toString(),value:new Date(t,e.getMonth(),e.getDate()).toDateString()});t.$yearContainer.addClass("smart-calendar-selected"),t.$dateContainer.removeClass("smart-calendar-selected")}t._prepareListViewer(a,e.toDateString()),t._refreshHeaderTitle(),t._refreshHeaderElements(),t.unfocusable||t.focus()}_prepareListViewer(e=[],t){const a=this,n=a.$.body;let l=a.$.listViewContainer;l||(a.$.listViewContainer=l=document.createElement("smart-scroll-viewer"),l.classList.add("smart-input-drop-down-menu","smart-calendar-list-view"),l.ensureVisible=a._listViewerEnsureVisible.bind(a),l._handleKeyStrokes=a._listViewerKeyStrokesHandler.bind(a),l._setActiveDescendant=a._listViewerSetActiveDescendant.bind(a));let i=l.querySelector("ul");i||(i=document.createElement("ul"),i.onclick=a._listViewContainerItemClickHandler.bind(a),l.appendChild(i)),n.contains(l)&&n.removeChild(l),i.innerHTML="";for(let a=0;a<e.length;a++){const n=e[a],s=n.label,o=n.value,r=document.createElement("li"),d=document.createElement("a");t===o?(r.setAttribute("aria-selected",!0),r.classList.add("active"),t=r):r.setAttribute("aria-selected",!1),r.id=l.id+"Item"+Math.floor(65536*(1+Math.random())).toString(16).substring(1),r.setAttribute("value",o),r.setAttribute("role","option"),r.setAttribute("aria-label",s),d.innerHTML=s,d.setAttribute("aria-hidden",!0),r.appendChild(d),i.appendChild(r)}l.classList.remove("smart-hidden"),n.classList.add("smart-calendar-list-view"),n.removeAttribute("tabindex"),n.insertBefore(l,a.$.animationPanel),l.refresh(),l.ensureVisible()}_listViewerEnsureVisible(){const e=this.$.listViewContainer,t=e.querySelector(".active");if(!t)return;const a=Array.from(e.querySelectorAll("li"));t.offsetTop+t.offsetHeight>=e.scrollTop+e.offsetHeight&&(e.scrollTop=t.offsetTop+t.offsetHeight),(t.offsetTop<=e.scrollTop||t.offsetTop>=e.scrollTop+e.offsetHeight)&&(e.scrollTop=t.offsetTop),0===a.indexOf(t)?e.scrollTop=0:a.indexOf(t)===a.length-1&&(e.scrollTop=e.scrollHeight)}_listViewerKeyStrokesHandler(e){if(["ArrowUp","ArrowDown"].indexOf(e)<0)return;event.preventDefault();const t=this.$.listViewContainer,a=t.querySelector(".active");if(!a){const e=t.querySelector("li");return e.classList.add("active"),void t._setActiveDescendant(e)}const n=a["ArrowDown"===e?"nextElementSibling":"previousElementSibling"];n&&(a.classList.remove("active"),n.classList.add("active"),t._setActiveDescendant(n),t.ensureVisible())}_listViewerSetActiveDescendant(e){const t=this.$.listViewContainer;e?t.setAttribute("aria-activedescendant",e.id):t.removeAttribute("aria-activedescendant")}_listViewContainerItemClickHandler(e){const t=this,a=e.target.closest("li");a&&"list"===t.displayModeView&&"month"!==t.displayMode&&t._displayModeHandler(a)}_isDateInView(e){const t=this;if(!e)return!1;for(let a=0;a<t._viewDates.length;a++)if(e.getFullYear()===t._viewDates[a].getFullYear()&&e.getMonth()===t._viewDates[a].getMonth()){let a=t._getCellByDate(e,t._animationStarted?t.$.nextMonthsContainer:void 0);if(!a)return;return!(a.otherMonth||!a.offsetHeight||a.classList.contains("smart-visibility-hidden"))}return!1}_keyDownHandler(e){const t=this;if(t.disabled||t.readonly)return;const a=(t.shadowRoot||t.getRootNode()).activeElement||document.activeElement;switch(a){case t.$.yearElement:"Escape"===e.key&&t._refreshHeaderElements();break;case t.$.dateElement:if("default"===t.calendarMode&&" "===e.key||"Enter"===e.key)return e.preventDefault(),t._isInteractiveNavigation=!0,void t._showDateView();t._focusedCell||t._focusCell(),e.key.indexOf("Arrow")>-1&&t.$.dateElement===a&&!t.unfocusable&&t.$.body.focus(),t._navigateDays(e);break;case t.$.body:" "===e.key&&e.preventDefault(),t._navigateDays(e);break;case t.$.yearContainer:if(" "!==e.key&&"Enter"!==e.key||"decade"===t.displayMode||(e.preventDefault(),t._isInteractiveNavigation=!0,t._showDateView("year")),e.key.indexOf("Arrow")>-1){if(e.preventDefault(),t._focusedCell||t._focusCell(),"month"!==t.displayMode&&"list"===t.displayModeView)return t.unfocusable||t.focus(),void t.$.listViewContainer._handleKeyStrokes(e.key);t._navigateDays(e)}break;case t.$.dateContainer:if(" "!==e.key&&"Enter"!==e.key||"month"===t.displayMode||(e.preventDefault(),t._displayModeHandler("list"===t.displayModeView?t.$.listViewContainer.querySelector("li.active"):t._focusedCell,"month")),e.key.indexOf("Arrow")>-1){if(t._focusedCell||t._focusCell(),"month"!==t.displayMode&&"list"===t.displayModeView)return t.unfocusable||t.focus(),void t.$.listViewContainer._handleKeyStrokes(e.key);t._navigateDays(e)}break;default:if("month"!==t.displayMode&&"list"===t.displayModeView)return["Arrow","End","Home","Page"].indexOf(e.key)&&e.preventDefault()," "===e.key||"Enter"===e.key||e.ctrlKey&&("ArrowUp"===e.key||"ArrowDown"===e.key)?void t._navigateDays(e):void t.$.listViewContainer._handleKeyStrokes(e.key);e.key.indexOf("Arrow")>-1&&(t._focusedCell||t._focusCell(),t._navigateDays(e))}}_showDateView(e){const t=this;switch(e=e||t.displayMode){case"month":e="year";break;case"year":e="decade"}if(t.displayMode===e)return;if(t.$.fireEvent("displayModeChanging",{oldDisplayMode:t.displayMode,newDisplayMode:e}).defaultPrevented)return;let a;if(t.displayMode=e,"list"===t.displayModeView&&"month"!==t.displayMode){t._setDisplayModeListContent(t._focusedCell?t._focusedCell.value:t._viewDates[0]);const e=t.$.listViewContainer;e.classList.remove("smart-hidden"),a=e.querySelector("li.active"),a.offsetHeight?t.$.animationPanel.style.transformOrigin=a.offsetLeft+a.offsetWidth/2+"px "+(a.offsetTop>0?a.offsetTop-a.offsetHeight/2:a.offsetTop+a.offsetHeight/2)+"px":t.$.animationPanel.style.transformOrigin=e.offsetLeft+e.offsetWidth/2+"px "+(a.offsetTop>0?a.offsetTop-a.offsetHeight/2:e.offsetTop+e.offsetHeight/2)+"px"}else t._focusedCell||t._focusCell(),a=t._focusedCell,t.$.animationPanel.style.transformOrigin=a.offsetLeft+a.offsetWidth/2+"px "+(a.offsetTop+a.offsetHeight/2)+"px";t.$monthsContainer.addClass("smart-hidden"),t.$dateViewContainer.hasClass("smart-hidden")&&t.$dateViewContainer.removeClass("smart-hidden"),"decade"===t.displayMode&&(t.$yearContainer.addClass("smart-calendar-selected"),t.$dateContainer.removeClass("smart-calendar-selected")),t.hasAnimation?t._animateView(-1,a):t._setDisplayModeContent(t._focusedCell?t._focusedCell.value:t._viewDates[0])}_keyUpHandler(e){const t=this;t.disabled||t.readonly||"default"!==t.selectionMode&&"range"!==t.selectionMode||"Shift"!==e.key&&"Control"!==e.key||(t._keysPressed[e.key]=!1)}_handleTooltip(){const e=this,t=e.tooltip;let a=e.$.tooltip;t?(a||(a=document.createElement("smart-tooltip"),a.tooltipTemplate=e.tooltipTemplate,a.arrow=e.tooltipArrow,a.arrowDirection=e.tooltipArrowDirection,a.offset=e.tooltipOffset,a.position=e.tooltipPosition,a.delay=e.tooltipDelay,a.rightToLeft=e.rightToLeft,a.openMode="manual",e.$.tooltip=a),a.parentElement||e.$.calendarContainer.appendChild(a)):a&&a.remove()}_mouseEventsHandler(e){const t=this;if(t.disabled||t.readonly)return;const a=t.$.tooltip;if("mouseenter"===e.type)return void t.$.setAttributeValue("hover",!0);if("mouseleave"===e.type){if(t.$.setAttributeValue("hover",!1),t._newRangeSelectionStarted&&"range"===t.selectionMode){const e=t.$.monthsContainer.children;for(let a=0;a<e.length;a++)t._getMonthCells(e[a]).map((e=>{t._setCellState(e,"hover",!1)}))}return void(t.tooltip&&a&&a.close())}const n=t.shadowRoot||t.isInShadowDOM?e.composedPath()[0]:e.target;if(!n.closest(".smart-calendar-week"))return void(t.tooltip&&a&&(clearTimeout(t._tooltipAutoCloseTimeout),a[a.contains(n)?"open":"close"]()));const l=n.closest(".smart-calendar-cell");if(!l)return;if(Smart.Utilities.Core.isMobile||t._handleCalendarCellHover(e,l),!t.tooltip&&a)return void a.close();const i=l.hasAttribute("important");if(clearTimeout(t._tooltipAutoCloseTimeout),i&&a&&"mouseover"===e.type)return a.selector=l,void(a.selector!==l?a.close():(t.tooltipTemplate||(a.innerHTML=0===a.innerHTML.trim().length?"Important day!":a.innerHTML),a.open(),t.$.fireEvent("open",{target:a,value:new Date(l.value)})));t._tooltipAutoCloseTimeout=setTimeout(function(){!a||"mouseout"!==e.type&&l&&i||a.close(),clearTimeout(t._tooltipAutoCloseTimeout)}.bind(t),t.tooltipDelay)}_popupEventHandler(e){const t=this,a=t.$.tooltip;if(e.stopPropagation(),e.target!==t.$.monthElement)if(e.target===a)if("close"!==e.type);else{const e=a.selector;t.$.fireEvent("close",{target:a,value:e?new Date(e.value):null})}else t.$.fireEvent(e.type,{target:e.target})}_moveHandler(e){const t=this;if(!Smart.Utilities.Core.isMobile||!t._dragStartDetails||"list"===t.displayModeView&&"month"!==t.displayMode)return;e.originalEvent.preventDefault(),e.preventDefault(),e.stopPropagation();const a={x:Math.round(e.pageX),y:Math.round(e.pageY)};let n,l,i;if(n="portrait"===t.scrollButtonsNavigationMode?a.y>t._dragStartDetails.y?-1*t.months:1*t.months:a.x<t._dragStartDetails.x?1*t.months:-1*t.months,t._previousIteration&&n===t._previousIteration.step)l=t._previousIteration.date;else if(6!==t.weeks&&0!==t.weeks&&"month"===t.displayMode){let e,a;t._focusedCell||t._focusCell();const i=[].slice.call(t._focusedCell.closest(".smart-calendar-weeks").children).filter((e=>!e.classList.contains("smart-hidden")));if(i.length){let s;!t.rightToLeft&&n<0||t.rightToLeft&&n>0?(s=i[0].querySelectorAll(".smart-calendar-cell"),a=t.rightToLeft?s[s.length-1]:s[0]):(s=i[i.length-1].querySelectorAll(".smart-calendar-cell"),a=t.rightToLeft?s[0]:s[s.length-1]),e=new Date(a.value),e.setDate(e.getDate()+n*(t.rightToLeft?-1:1)),l=e}else l=t._getNextDate(n*(t.rightToLeft?-1:1))}else l=t._getNextDate(n*(t.rightToLeft?-1:1));if(!l)return;if(!t._dragStartDetails.navigationDate&&t.$.fireEvent("navigationChanging",{value:new Date(l),type:t.displayMode}).defaultPrevented)return t._cancelAnimation(),void(t._dragStartDetails=void 0);if(t._dragStartDetails.step=n,t._dragStartDetails.navigationDate=new Date(l),!t.hasAnimation)return;if(t._previousIteration={step:n,date:l},t._mobileScrolling=!0,"month"!==t.displayMode)t.$nextMonthsContainer.addClass("smart-calendar-date-view-container"),i=t.$.dateViewContainer,t.$.nextMonthsContainer.children[0].value instanceof Date&&t.$.nextMonthsContainer.children[1].value.getFullYear()===l.getFullYear()||t._setDisplayModeContent(l,t.$.nextMonthsContainer);else if(t.$nextMonthsContainer.hasClass("smart-calendar-date-view-container")&&t.$nextMonthsContainer.removeClass("smart-calendar-date-view-container"),i=t.$.monthsContainer,!t.$.nextMonthsContainer.children[0]._date||t.$.nextMonthsContainer.children[0]._date.getTime()!==l.getTime()){let e=t.$.nextMonthsContainer.children;for(let a=0;a<e.length;a++)l.setMonth(t._dragStartDetails.navigationDate.getMonth()+a*(t.rightToLeft?-1:1)),t._setMonth(new Date(l),e[a],!0)}6!==t.weeks&&0!==t.weeks&&"month"===t.displayMode&&t._updateWeeksVisibility(n*(t.rightToLeft?-1:1),t._getCellByDate(l,t.$.nextMonthsContainer)),delete t._mobileScrolling,n<0?(i.style.order=3,t.$.nextMonthsContainer.style.order=1,t.$.body[t._animationSettings.scrollSize]=t.$.body[t._animationSettings.scrollMax]):(i.style.order=1,t.$.nextMonthsContainer.style.order=3,t.$.body[t._animationSettings.scrollSize]=0);const s="portrait"===t.scrollButtonsNavigationMode?"y":"x";Math.abs(t._dragStartDetails[s]-a[s])>5&&(t.$.body[t._animationSettings.scrollSize]+=2*-(a[s]-t._dragStartDetails[s]))}_getNextDate(e){const t=this;let a;if("month"!==t.displayMode){let n;const l=t._focusedCell&&t._focusedCell.value.getFullYear();if("list"===t.displayModeView)a=new Date(t.$.listViewContainer.querySelector("li").getAttribute("value"));else{let e=t._animationStarted?t.$.nextMonthsContainer:t.$.dateViewContainer;a=new Date("year"===t.displayMode?e.children[0].value:e.children[1].value)}n="year"===t.displayMode?1:0!==e?10:1,a.setFullYear(a.getFullYear()+(e>0?n:-n)),a.getTime()<t.min.getTime()&&(a=t.min),a.getTime()>t.max.getTime()&&(a=t.max);const i="month"!==t.displayMode&&"list"===t.displayModeView;if(a.getFullYear()<t.min.getFullYear()||a.getFullYear()>t.max.getFullYear()||!i&&l===a.getFullYear())return}else{let n=t._viewDates[0];if(a=new Date(n),a.setDate(1),a.setMonth(a.getMonth()+e),a.setTime(Math.min(Math.max(a.getTime(),t.min.getTime()),t.max.getTime())),n.getMonth()===a.getMonth()&&n.getFullYear()===a.getFullYear())return}return a}_navigateDays(e){const t=this;let a="ArrowUp"===e.key||"ArrowDown"===e.key?7:1,n="ArrowUp"===e.key||"ArrowLeft"===e.key||"PageUp"===e.key?-1:1;switch(e.key){case"ArrowUp":case"ArrowLeft":case"ArrowDown":case"ArrowRight":if(!t._handleArrowKeys(e,a,n))return;break;case" ":case"Enter":{if("month"!==t.displayMode)return void t._displayModeHandler("list"===t.displayModeView?t.$.listViewContainer.querySelector("li.active"):t._focusedCell);const e=t._focusedCell;if("oneExtended"===t.selectionMode&&e)return t._clearSelection(!0),void t._selectDate(e.value,t._selectedCells.indexOf(e.value)>-1);break}case"Control":case"Shift":return"default"===t.selectionMode&&(t._keysPressed[e.key]=!0),void("range"===t.selectionMode&&(t._keysPressed[e.key]="Control"===e.key));case"Home":case"End":{e.preventDefault();let a,n=function(t){if("Home"===e.key){for(let e=0;e<t.length;e++)if(!t[e].otherMonth&&(!t[e].disabled||!t[e].restricted)&&t[e].offsetHeight)return t[e]}else for(let e=t.length-1;e>=0;e--)if(!t[e].otherMonth&&(!t[e].disabled||!t[e].restricted)&&t[e].offsetHeight)return t[e]};if(a="month"!==t.displayMode?n(t.$.dateViewContainer.children):n(t._getMonthCells(t._focusedCell.closest(".smart-calendar-month"),t.rightToLeft)),!a)return;if(t._focusCell(a),"month"!==t.displayMode)return;break}case"PageUp":case"PageDown":if(!t._handlePageUpDownKeys(e,n))return;break;default:return}"oneExtended"!==t.selectionMode&&t._focusedCell&&t._handleDateSelection(t._focusedCell)}_handleArrowKeys(e,t,a){const n=this;let l;if("month"!==n.displayMode||n._animationStarted||n.unfocusable||n.$.body.focus(),n._focusedCell||n._focusCell(n._getCellByDate(new Date)),e.altKey)return;if(e.ctrlKey){if("ArrowDown"===e.key||"ArrowUp"===e.key){if("classic"===n.calendarMode)return;let t;switch(n.displayMode){case"month":t="ArrowDown"===e.key?"month":"year";break;case"year":t="ArrowDown"===e.key?"month":"decade";break;case"decade":t="ArrowDown"===e.key?"year":"decade"}if(t!==n.displayMode){const e=n.displayMode;n.displayMode=t,n._setDisplayMode(e,t,"month"===e),n._keysPressed&&delete n._keysPressed.Control}}return}if(e.preventDefault(),!n.rightToLeft||"ArrowLeft"!==e.key&&"ArrowRight"!==e.key||(a*=-1),"month"!==n.displayMode&&"list"!==n.displayModeView){const i=n._animationStarted?n.$.nextMonthsContainer.children:n.$.dateViewContainer.children;if(t="ArrowUp"===e.key||"ArrowDown"===e.key?4:1,"year"===n.displayMode){const e=n._focusedCell.value.getMonth()+a*t;let i=new Date(n._focusedCell.value.getFullYear(),e+1,0);n._focusedCell.value.getDate()<=i.getDate()&&(i=n._focusedCell.value),l=new Date(n._focusedCell.value.getFullYear(),e,i.getDate())}else l=new Date(n._focusedCell.value.getFullYear()+a*t,n._focusedCell.value.getMonth(),n._focusedCell.value.getDate());if("year"===n.displayMode){if(l.getFullYear()<n.min.getFullYear()||l.getFullYear()===n.min.getFullYear()&&l.getMonth()<n.min.getMonth()||l.getFullYear()>n.max.getFullYear()||l.getFullYear()===n.max.getFullYear()&&l.getMonth()>n.max.getMonth())return;l.getTime()>i[i.length-1].value.getTime()?n.navigate(1):l.getTime()<i[0].value.getTime()&&n.navigate(-1)}else{if(l.getFullYear()<n.min.getFullYear()||l.getFullYear()>n.max.getFullYear())return;if(l.getFullYear()<i[1].value.getFullYear()||l.getFullYear()>i[10].value.getFullYear()){let t=n._focusedCell;n.navigate(a),"ArrowUp"!==e.key&&"ArrowDown"!==e.key||(t===i[3]||t===i[4]||t===i[7]||t===i[8]?l.setFullYear(l.getFullYear()+2*a):l.setFullYear(l.getFullYear()-2*a))}}return void n._focusCell(n._getCellByDate(l,n._animationStarted?n.$.nextMonthsContainer:void 0))}if(!n._focusedCell)return;const i=n.restrictedDates.map(Number);for(l=new Date(n._focusedCell.value.getFullYear(),n._focusedCell.value.getMonth(),n._focusedCell.value.getDate()+a*t,0,0,0,0);i.indexOf(l.getTime())>-1;)l.setDate(l.getDate()+a);if(l.getTime()<n.min.getTime()||l.getTime()>n.max.getTime())return;n._isDateInView(l)||n.navigate(a*n.months);let s=n._getCellByDate(l,n._animationStarted?n.$.nextMonthsContainer:void 0);return n._focusCell(s),n._updateWeeksVisibility(a),!(["zeroOrMany","oneOrMany","none","many","week","range"].indexOf(n.selectionMode)>-1)||void 0}_handlePageUpDownKeys(e,t){const a=this;let n;if(e.preventDefault(),"month"!==a.displayMode){if(n=a._focusedCell,!a.navigate(t))return;for(;n&&n.classList.contains("smart-visibility-hidden");)n=null===n.previousElementSibling?n.nextElementSibling:n.previousElementSibling;return a._focusCell(n),void(a.hasAnimation&&"decade"===a.displayMode&&a._focusedCell.value.setFullYear(a._focusedCell.value.getFullYear()+10*t))}n=new Date(a._focusedCell.value.getFullYear(),a._focusedCell.value.getMonth()+t,1,0,0,0,0);let l=new Date(n.getFullYear(),n.getMonth()+1,0).getDate();return a._focusedCell.value.getDate()>l?n.setDate(l):n.setDate(a._focusedCell.value.getDate()),a._isDateInView(n)||a.navigate(n),a._animationStarted?a._focusCell(a._getCellByDate(n,a.$.nextMonthsContainer)):a._focusCell(a._getCellByDate(n)),!0}_selectDate(e,t,a){const n=this;if(void 0===n._viewDates||"none"===n.selectionMode)return;let l,i=n.selectedDates.slice(0),s=n._getCellByDate(e,n._animationStarted?n.$.nextMonthsContainer:void 0);s&&n._selectCell(s),(e=new Date(e)).setHours(0,0,0,0),l=i.map(Number).indexOf(e.getTime()),n.restrictedDates.map(Number).indexOf(e.getTime())>-1||e.getTime()<n.min.getTime()||e.getTime()>n.max.getTime()||(l>-1?i.splice(l,1):i.push(e),a||(n.selectedDates=i),n._refreshFooter(),n.$.hiddenInput.value=n.selectedDates.toString(),!t&&n.isInitialized&&(n.$.fireEvent("change",{value:[e]}),n._updateTargetValue()),n._refreshTitle())}_selectCell(e){const t=this;if(!e||t.restrictedDates.map(Number).indexOf(e.value.getTime())>-1||t.disableAutoNavigation&&!1===e.otherMonth||e.value.getTime()<t.min.getTime()||e.value.getTime()>t.max.getTime())return;const a=t._selectedCells.indexOf(e);a>-1?(t._setCellState(e,"selected",!1),t._selectedCells.splice(a,1)):(t._setCellState(e,"selected",!0),t._selectedCells.push(e)),t._focusCell(e)}_refreshDayOfWeekTitles(){const e=this;let t,a=[],n=new Date;function l(t){let a;return"firstTwoLetters"===e.dayNameFormat?(a=new Intl.DateTimeFormat(e.locale,{weekday:"long"}).format(t),a=8206===a.charCodeAt(0)?a.substring(1,3):a.substring(0,2)):a=new Intl.DateTimeFormat(e.locale,{weekday:e.dayNameFormat}).format(t),a}for(let e=1;e<8;e++)n.setDate(e),t={number:n.getDay(),name:l(n)},a.push(t);a.sort(((e,t)=>e.number>t.number?1:-1));const i=e.$.monthsContainer.children;let s,o;for(let t=0;t<i.length;t++)if(s=i[t].getElementsByClassName("smart-calendar-week-titles")[0].children,o=e.firstDayOfWeek>6?0:e.firstDayOfWeek,e.rightToLeft)for(let e=s.length-1;e>=1;e--)s[e].textContent=a[o++].name,o=o>6?0:o;else for(let e=1;e<s.length;e++)s[e].textContent=a[o++].name,o=o>6?0:o;if(e.hasAnimation){const t=e.$.monthsContainer.getElementsByClassName("smart-calendar-week-titles")[0].innerHTML,a=e.$.nextMonthsContainer.getElementsByClassName("smart-calendar-week-titles");for(let e=0;e<a.length;e++)a[e].innerHTML=t}}_refreshCalendarMode(){const e=this;if(!e.headerTemplate)if(e._refreshMonthNames(),"default"===e.calendarMode){e.$classicHeaderDate.addClass("smart-hidden"),e.$defaultHeaderDate.removeClass("smart-hidden");const t=e._viewDates.slice(0).sort(((e,t)=>e.getTime()-t.getTime())),a=t[0],n=t[t.length-1];a.setDate(2);let l=e.monthNameFormat;"firstTwoLetters"===l&&(l="long");let i=a.toLocaleDateString(e.locale,{year:e.yearFormat,month:l});e.months>1&&(n.setDate(2),i+=" - "+n.toLocaleDateString(e.locale,{year:e.yearFormat,month:l})),e.$.defaultHeaderDate.innerHTML=i,e.unfocusable||e.$.dateElement.setAttribute("tabindex",e.tabIndex>0?e.tabIndex:0)}else e.$defaultHeaderDate.addClass("smart-hidden"),e.$classicHeaderDate.removeClass("smart-hidden"),e.$.dateElement.removeAttribute("tabindex")}_refreshFooter(){const e=this;if(!(e.viewSections.indexOf("footer")<0||0===e.$.footer.offsetHeight))if(e.footerTemplate){if("function"==typeof e.footerTemplate)return;let a=e._layoutTemplates.filter((t=>t.selector===e.$.footer))[0],n=document.importNode(a.template.content,!0);if(a.bindings.length>0){let e=n.childNodes[a.bindings[0].childNodeIndex];a.selector.childNodes[a.bindings[0].childNodeIndex].innerHTML=e.innerHTML.replace(a.bindings[0].bindingString,t())}}else e.$.selectedDatesRange.innerHTML=t();function t(){if(0===e.selectedDates.length)return"";if(1===e.selectedDates.length)return e.selectedDates[0].toLocaleDateString(e.locale,{year:e.yearFormat,weekday:"short",month:"short",day:"numeric"});{let t=e.selectedDates.slice(0).sort(((e,t)=>e.getTime()-t.getTime()));return t[0].toLocaleDateString(e.locale,{year:e.yearFormat,weekday:"short",month:"short",day:"numeric"})+" - "+t[t.length-1].toLocaleDateString(e.locale,{year:e.yearFormat,weekday:"short",month:"short",day:"numeric"})}}}_refreshImportantDates(){const e=this;if("month"===e.displayMode){e._clearImportantDates();for(let t=0;t<e.importantDates.length;t++)e._setImportantDate(e.importantDates[t])}}_clearImportantDates(){const e=this,t=e.$.monthsContainer.children;for(let a=0;a<t.length;a++)e._getMonthCells(t[a]).map((t=>{e._setCellState(t,"important",!1)}))}_setImportantDate(e,t){const a=this,n=a._getCellByDate(e);t||(t=n),t&&(a._setCellState(t,"important",!0),a._applyImportantDateTemplate(t))}_applyImportantDateTemplate(e){const t=this;if(!t._importantDatesTemplate)return"function"==typeof t.importantDatesTemplate?void t.importantDatesTemplate(e,{value:e.value}):void(e.innerHTML=e.value.getDate()+"");let a=document.importNode(t._importantDatesTemplate.content,!0);if(t._bindingDetails&&t._bindingDetails.length>0){let n=a.childNodes[t._bindingDetails[0].childNodeIndex];n.innerHTML=n.innerHTML.replace(t._bindingDetails[0].bindingString,e.value.getDate())}e.innerHTML="";for(let t=0;t<a.childNodes.length;t++)a.childNodes[t].outerHTML&&(e.innerHTML+=a.childNodes[t].outerHTML)}_setMonth(e,t,a){const n=this,l=n._getDays(e,n.selectedDates),i=n._getDays(e,n.importantDates),s=n._getDays(e,n.restrictedDates);e.setDate(1),t||(t=n.$.month),t._date=new Date(e),a||((!n._viewDates||n._viewDates.length>=n.months)&&(n._viewDates=[]),n._viewDates.push(new Date(e)));let o=((e=new Date(e)).getDay()-n.firstDayOfWeek+7)%7;e.setDate(0);let r=e.getDate();if(e.setDate(32),e.setDate(1),e.setDate(32),n._selectedCells)for(let e=0;e<n._selectedCells.length;e++)n._selectedCells[e].closest(".smart-calendar-month")===t&&n._setCellState(n._selectedCells[e],"selected",!1);n._setMonthContent(e,t,{previusMonthDays:r,firstDayOfWeek:o,selectedDates:l,importantDates:i,restrictedDates:s})}_setMonthContent(e,t,a){const n=this,l=32-e.getDate(),i=n._getMonthCells(t,n.rightToLeft),s=t._date.getMonth(),o=t._date.getFullYear(),r=new Date;let d,c=1,m=1;r.setHours(0,0,0,0),i.map((e=>{n._setCellState(e,"restricted",!1),n._setCellState(e,"selected",!1),n._setCellState(e,"otherMonth",!1),n._setCellState(e,"focus",!1),n._setCellState(e,"important",!1),n._setCellState(e,"today",!1),n._setCellState(e,"disabled",!1),n._setCellState(e,"hover",!1)}));for(let e=0;e<i.length;e++){const h=i[e];e===a.firstDayOfWeek&&m<=l?(h.className="smart-calendar-cell",h.value=new Date(o,s,m),h.innerHTML=h.value.getDate().toString(),a.restrictedDates.indexOf(m)>-1||h.value.getTime()<n.min.getTime()||h.value.getTime()>n.max.getTime()?n._setCellState(h,"restricted",!0):a.selectedDates.indexOf(m)>-1&&(n._setCellState(h,"selected",!0),n._selectedCells.indexOf(h)<0&&n._selectedCells.push(h)),a.importantDates.indexOf(m)>-1&&(n._setImportantDate(h.value,h),a.importantDates.splice(a.importantDates.indexOf(m),1)),h.value.getTime()===r.getTime()&&n._setCellState(h,"today",!0),a.firstDayOfWeek++,m++):(1===m?(h.value=new Date(o,s-1,++a.previusMonthDays-a.firstDayOfWeek),d=!!(h.value.getTime()<n.min.getTime()||t.previousElementSibling)):(h.value=new Date(o,s+1,c++),d=!!(h.value.getTime()>n.max.getTime()||t.nextElementSibling)),h.innerHTML=h.value.getDate().toString(),n._setCellState(h,"otherMonth",!0),d?h.classList.add("smart-visibility-hidden"):h.classList.remove("smart-visibility-hidden"))}n.months>1&&(t.firstElementChild.innerHTML=n.dateFormatFunction?n.dateFormatFunction(t._date):n._monthsNames[s]+" "+t._date.toLocaleDateString(n.locale,{year:n.yearFormat})),n._setMonthWeekNumbers(t)}_refreshMonthNames(){const e=this;let t,a=new Date;function n(t){let a=e.monthNameFormat;"firstTwoLetters"===a&&(a="long");let n=new Intl.DateTimeFormat(e.locale,{month:a}).format(t);return"firstTwoLetters"===e.monthNameFormat&&(n=8206===n.charCodeAt(0)?n.substring(0,2):n.substring(1,3)),n}a.setDate(1),e._monthsNames=[];for(let l=0;l<12;l++)a.setMonth(l),t=n(a),e._monthsNames.push(t);if("classic"===e.calendarMode&&e.$.monthElement){let t=e.$.monthsContainer.children;if(e.$.monthElement.dataSource&&(e._changeEventFired=1),e.shadowRoot?e._setMonthElementPropertyInShadowDOM("dataSource",e._monthsNames):e.$.monthElement.dataSource=e._monthsNames,e._viewDates){for(let a=0;a<t.length;a++)t[a].firstElementChild.textContent=e._monthsNames[t[a]._date.getMonth()]+" "+t[a]._date.getFullYear();e._changeEventFired=1,e.shadowRoot?e._setMonthElementPropertyInShadowDOM("selectedIndex",e._viewDates.map((e=>e.getMonth()))[0]):e.$.monthElement.selectedIndex=e._viewDates.map((e=>e.getMonth()))[0]}}}_setMonthWeekNumbers(e){const t=this,a=function(e){for(let t=1;t<e.children.length;t++)if(!e.children[t].classList.contains("smart-visibility-hidden"))return!0};let n=e.getElementsByClassName("smart-calendar-week");n=[].slice.call(n);for(let l=0;l<n.length;l++){if(!a(n[l])){n[l].children[0].innerHTML="";continue}const i=n[l].children[1],s=i.otherMonth?i.value.getTime()>e._date.getTime()?1:-1:0;n[l].children[0].innerHTML=t._getWeekNumber(new Date(e._date.getFullYear(),e._date.getMonth()+s,i.value.getDate()))}}_setRestrictedDates(e){const t=this,a=t.$.monthsContainer.children;for(let e=0;e<a.length;e++)t._getMonthCells(a[e]).map((e=>{t._setCellState(e,"restricted",!1)}));if(t._viewDates){const a=function(e){for(let a=0;a<t._viewDates.length;a++)if(t._viewDates[a].getFullYear()===e.getFullYear()&&t._viewDates[a].getMonth()===e.getMonth())return!0};for(let n=0;n<e.length;n++)if(a(e[n])){const a=t._getCellByDate(e[n]);t._setCellState(a,"restricted",!0)}}}_setScrollButtonsNavigationMode(){const e=this;"landscape"!==e.scrollButtonsNavigationMode?(e.$.previousMonthButton&&(e.$.previousMonthButton.$.button.firstElementChild.className="smart-arrow-down smart-arrow"),e.$.nextMonthButton&&(e.$.nextMonthButton.$.button.firstElementChild.className="smart-arrow-up smart-arrow")):(e.$.previousMonthButton&&(e.$.previousMonthButton.$.button.firstElementChild.className="smart-arrow-left smart-arrow"),e.$.nextMonthButton&&(e.$.nextMonthButton.$.button.firstElementChild.className="smart-arrow-right smart-arrow")),e._applyAnimationSettings(!0)}_refreshTitle(){const e=this;let t=e.selectedDates.length>0?e.selectedDates[e.selectedDates.length-1]:new Date;if(e.titleTemplate){if("function"==typeof e.titleTemplate)return;let a=e._layoutTemplates.filter((t=>t.selector===e.$.title))[0],n=document.importNode(a.template.content,!0);if(a.bindings.length>0){let l=n.childNodes[a.bindings[0].childNodeIndex];return t=t.toLocaleDateString(e.locale,{year:e.yearFormat,weekday:"short",month:"short",day:"numeric"}),void(a.selector.childNodes[a.bindings[0].childNodeIndex].innerHTML=l.innerHTML.replace(a.bindings[0].bindingString,t))}}e.$.title.children[0].innerHTML=t.toLocaleDateString(e.locale,{year:e.yearFormat}),e.$.title.children[1].innerHTML="landscape"===e.view?t.toLocaleDateString(e.locale,{weekday:"short"})+",</br>"+t.toLocaleDateString(e.locale,{month:"short",day:"numeric"}):t.toLocaleDateString(e.locale,{weekday:"short"})+", "+t.toLocaleDateString(e.locale,{month:"short",day:"numeric"})}_setWeeksVisibility(e){const t=this,a=e.children;let n;function l(e){(function(e){for(let t=1;t<e.children.length;t++)if(!e.children[t].classList.contains("smart-visibility-hidden"))return!1;return!0})(e)||n>=t.weeks?e.classList.add("smart-hidden"):n<t.weeks&&(e.classList.remove("smart-hidden"),n++)}for(let e=0;e<a.length;e++){let i=a[e].getElementsByClassName("smart-calendar-week");i=[].slice.call(i);let s=t._selectedCells.filter((t=>t.closest(".smart-calendar-month")===a[e]));if(6!==t.weeks)if(n=0,s.length>0){let e=s[s.length-1],t=i.indexOf(e.parentElement);for(let e=t;e<i.length;e++)l(i[e]);for(let e=t-1;e>=0;e--)l(i[e])}else for(let e=0;e<i.length;e++)l(i[e]);else i.map((e=>e.classList.remove("smart-hidden")))}}_refreshHeaderElements(){const e=this,t=document.activeElement.closest("smart-calendar")===e,a=e._animationStarted?e.$.nextMonthsContainer:e.$.dateViewContainer;let n,l,i=e._viewDates[e._viewDates.length-1],s=e._viewDates.map((e=>e.getFullYear()));if("month"===e.displayMode||"list"!==e.displayModeView){if("classic"===e.calendarMode&&e.$.monthElement&&e.$.monthElement instanceof HTMLDivElement){const t=document.createElement("smart-input");t.setAttribute("smart-id","monthElement"),t.classList.add("smart-calendar-month-element"),t.dropDownPosition="bottom",t.selectionMode="one",t.disabled=e.disabled,t.rightToLeft=e.rightToLeft,t.theme=e.theme,t.dropDownWidth=e.dropDownWidth,t.dropDownHeight=e.dropDownHeight,t.readonly=!0,t.dropDownButtonPosition="right";const a=e.$.monthElement;e.$.monthElement.parentNode.insertBefore(t,e.$.monthElement),e.$.monthElement=t,a.remove()}if(e.$.previousMonthButton&&!e.disabled&&("month"!==e.displayMode&&e.$.dateViewContainer.children[0].value?l="year"===e.displayMode?a.children[0].value.getFullYear()-1:a.children[1].value.getFullYear()-1:e._viewDates[0].getMonth()-1<0?(n=11,l=e._viewDates[0].getFullYear()-1):(n=e._viewDates[0].getMonth()-1,l=e._viewDates[0].getFullYear()),e.$.previousMonthButton.disabled=l<e.min.getFullYear()||l===e.min.getFullYear()&&n<e.min.getMonth(),e.$.previousMonthButton.disabled&&t&&e.$.body.focus()),e.$.nextMonthButton&&!e.disabled&&("month"!==e.displayMode&&e.$.dateViewContainer.children[0].value?l="year"===e.displayMode?a.children[0].value.getFullYear()+1:a.children[1].value.getFullYear()+11:i.getMonth()+1>11?(n=0,l=i.getFullYear()+1):(n=i.getMonth()+1,l=i.getFullYear()),e.$.nextMonthButton.disabled=l>e.max.getFullYear()||l===e.max.getFullYear()&&n>e.max.getMonth(),e.$.nextMonthButton.disabled&&t&&e.$.body.focus()),"classic"===e.calendarMode&&e.$.monthElement){let t=[...e._monthsNames];if(s.indexOf(e.min.getFullYear())>-1)for(let a=0;a<e.min.getMonth();a++)t[a]="";if(s.indexOf(e.max.getFullYear())>-1)for(let a=e.max.getMonth()+1;a<t.length;a++)t[a]="";t=t.filter((e=>""!==e));const a=Math.max(0,e.$.monthElement.selectedIndex);e.$.monthElement.dataSource=t,e._changeEventFired=0!==e.$.monthElement.selectedIndex,e.shadowRoot?e._setMonthElementPropertyInShadowDOM("selectedIndex",e._viewDates[0].getMonth()):e.$.monthElement.selectedIndex=a,e._changeEventFired=0}e.$.previousYearButton&&!e.disabled&&(l=e._viewDates[0].getFullYear()-1,e.$.previousYearButton.disabled=l<e.min.getFullYear(),e.$.previousYearButton.disabled&&t&&e.$.body.focus()),e.$.nextYearButton&&!e.disabled&&(l=i.getFullYear()+1,e.$.nextYearButton.disabled=l>e.max.getFullYear(),e.$.nextYearButton.disabled&&t&&e.$.body.focus()),e.$.yearElement&&(e.$.yearElement.value=s[0],e.$.yearElement.disabled=i.getFullYear()+1>e.max.getFullYear()&&e._viewDates[0].getFullYear()-1<e.min.getFullYear())}}_setMonthElementPropertyInShadowDOM(e,t){const a=this.$.monthElement,n=a.context;a.context=document,this.$.monthElement[e]=t,a.context=n}_refreshHeaderTitle(){const e=this;let t;function a(){if("month"!==e.displayMode){if("list"===e.displayModeView){const a=e.$.listViewContainer;if(!a)return;const n=a.querySelectorAll("li");if(!n.length)return"";let l;a.querySelector("li.active")&&(l=a.querySelector("li.active").getAttribute("value")),t="year"===e.displayMode?new Date(l||n[0].getAttribute("value")).getFullYear():new Date(n[0].getAttribute("value")).getFullYear()+" - "+new Date(n[n.length-1].getAttribute("value")).getFullYear()}else if(e.$.dateViewContainer.children[0].value){let a=e._animationStarted?e.$.nextMonthsContainer.children:e.$.dateViewContainer.children;t="year"===e.displayMode?a[0].value.getFullYear():a[1].value.getFullYear()+" - "+a[a.length-2].value.getFullYear()}if(t)return t}const a=e._viewDates.slice(0).sort(((e,t)=>e.getTime()-t.getTime())),n=a[0],l=a[a.length-1];n.setDate(2);let i=e.monthNameFormat;return"firstTwoLetters"===i&&(i="long"),t=n.toLocaleDateString(e.locale,{year:e.yearFormat,month:i}),e.months>1&&(l.setDate(2),t+=" - "+l.toLocaleDateString(e.locale,{year:e.yearFormat,month:i})),t}if("default"===e.calendarMode&&(e.$.defaultHeaderDate.innerHTML=a()),"function"==typeof e.headerTemplate||!e._layoutTemplates)return;let n=e._layoutTemplates.filter((t=>t.selector===e.$.header))[0];if(!n)return;let l=document.importNode(n.template.content,!0);if(n.bindings.length>0){const t=l.childNodes[n.bindings[0].childNodeIndex];(e.shadowRoot?e:n.selector).childNodes[n.bindings[0].childNodeIndex].innerHTML=t.innerHTML.replace(n.bindings[0].bindingString,e.dateFormatFunction?e.dateFormatFunction(e._viewDates):a())}}_updateWeeksVisibility(e,t){const a=this;let n=(t||a._focusedCell).parentElement;function l(){for(let e=o;e<s.length;e++)if(s[e].classList.contains("smart-hidden")&&!r(s[e])&&(s[e].classList.remove("smart-hidden"),d++,d===a.weeks))return!0}function i(){for(let e=o;e>=0;--e)if(s[e].classList.contains("smart-hidden")&&!r(s[e])&&(s[e].classList.remove("smart-hidden"),d++,d===a.weeks))return!0}if(!t&&!n.classList.contains("smart-hidden"))return;const s=[].slice.call(n.parentElement.children),o=s.indexOf(n),r=function(e){for(let t=1;t<e.children.length;t++)if(!e.children[t].classList.contains("smart-visibility-hidden"))return!1;return!0};let d=0;if(s.map((e=>e.classList.add("smart-hidden"))),e>0){if(l())return;i()}else{if(i())return;l()}}_getValidDates(e){let t=[];function a(e){if(e instanceof Date)return e;if(Smart.Utilities.DateTime&&e instanceof Smart.Utilities.DateTime)return e.toDate();if("string"==typeof e){if("new Date()"===e.trim()||"new Smart.Utilities.DateTime()"===e.trim())return new Date;let t=/(\d+[,-.\/]{1}\s*\d+[,-.\/]{1}\s*\d+)/;const a=()=>(e=e.replace(/[,-.\/]/g,",").split(",")).length>2?e=new Date(parseInt(e[0]),parseInt(e[1])-1,parseInt(e[2])):new Date;return t.test(e)&&(e=t.exec(e)[0].replace(/[,-.\/]/g,",").split(","))?new Date(parseInt(e[0]),parseInt(e[1])-1,parseInt(e[2])):a()}}if(void 0===e)return null;if(Array.isArray(e))for(let n=0;n<e.length;n++)t.push(a(e[n]));else t.push(a(e));return t=t.filter((e=>e&&"Invalid Date"!==e.toDateString())),t.map((e=>e.setHours(0,0,0,0))),t}_getValidDate(e){const t=this._getValidDates(e);return t.length>0?t[0]:null}_validateSelectedDates(e){const t=this;let a=[];e||(e=t.selectedDates);let n=e.slice(0),l=function(e){for(let a=0;a<t.restrictedDates.length;a++)if(t.restrictedDates[a].getTime()===e.getTime())return!0};t.selectedDates=n.filter((function(e){if(e.getTime()>=t.min.getTime()&&e.getTime()<=t.max.getTime()&&!l(e))return!0;a.push(e)})),t._viewDates&&(a.map((e=>t._selectDate(e))),t._focusCell())}_validateMinMax(e,t,a){const n=this;switch(e){case"min":t=n._getValidDate(n[e]),n.min=t||a||n.properties.min.defaultValue;break;case"max":t=n._getValidDate(n[e]),n.max=t||a||n.properties.max.defaultValue;break;default:t=n._getValidDate(n.min),n.min=t||a||n.properties.min.defaultValue,t=n._getValidDate(n.max),n.max=t||a||n.properties.max.defaultValue}n.min=n.min.getTime()>n.max.getTime()?n.max:n.min,n.min.setHours(0,0,0,0),n.max.setHours(0,0,0,0);let l,i=n.$.monthsContainer.children;if(n._viewDates){if(n._viewDates[0].getTime()>n.max.getTime()||n._viewDates[0].getTime()<n.min.getTime())return void n._handleMonths();for(let e=0;e<i.length;e++){l=n._getMonthCells(i[e]);for(let t=0;t<l.length;t++){const a=l[t];if(a.value.getTime()>=n.min.getTime()&&a.value.getTime()<=n.max.getTime())n._setCellState(a,"restricted",!1),a.value.getMonth()===i[e]._date.getMonth()?a.classList.remove("smart-visibility-hidden"):n.hideOtherMonthDays||(n._setCellState(a,"otherMonth",!0),a.classList.remove("smart-visibility-hidden")),"month"!==n.displayMode&&n._setCellState(a,"otherMonth",!1);else{if(a.otherMonth){if(a.classList.contains("smart-visibility-hidden")){n._setCellState(a,"restricted",!1);continue}}else n._setCellState(a,"restricted",!0);"month"!==n.displayMode&&(a.classList.remove("smart-visibility-hidden"),n._setCellState(a,"otherMonth",!0))}}}}}_setCellState(e,t,a){e[t]=a;const n=Smart.Utilities.Core.toDash(t);a?(e.setAttribute(n,""),"selected"===t?e.setAttribute("aria-selected",!0):"today"===t?e.setAttribute("aria-current","date"):"restricted"===t?e.removeAttribute("aria-selected"):"disabled"===t&&(e.removeAttribute("aria-selected"),e.setAttribute("aria-disabled",!0))):(e.removeAttribute(n),"selected"===t?"none"===this.selectionMode||e.restricted||e.disabled?e.removeAttribute("aria-selected"):e.setAttribute("aria-selected",!1):"today"===t?e.removeAttribute("aria-current"):"restricted"!==t||e.disabled?"disabled"===t&&(e.removeAttribute("aria-disabled"),e.restricted||e.setAttribute("aria-selected",!1)):e.setAttribute("aria-selected",!1))}_validateTemplate(e,t){if(null===t||!t)return;if("function"==typeof t)return;const a=this;if("content"in document.createElement("template")){if("string"==typeof t&&(t=document.getElementById(t)),null!==t&&"content"in t)return t;a.error(a.localize("invalidTemplate",{elementType:a.nodeName.toLowerCase(),property:e}))}else a.error(a.localize("htmlTemplateNotSuported",{elementType:a.nodeName.toLowerCase()}))}_weeksDownHandler(e,t){const a=this,n=t.value;let l;if(a.$.body.contains(t))if(t.otherMonth&&(l=t.value.getTime()>t.closest(".smart-calendar-month")._date.getTime()?1:-1),n&&a.hasRippleAnimation&&Smart.Utilities.Animation.Ripple.animate(t,e.pageX,e.pageY),l){if(a._isDateInView(n))return;a.disableAutoNavigation||a.navigate(l*a.months)}else(t=a._getCellByDate(n))&&(t.disabled||t.restricted)||a._handleDateSelection(t)}_firstDayOfWeekValidator(e,t){return Math.min(Math.max(0,isNaN(t)?6:t),6)}_weeksValidator(e,t){return Math.min(Math.max(1,isNaN(t)?6:t),6)}_monthsValidator(e,t){return Math.min(Math.max(1,isNaN(t)?1:t),12)}});