
/* Smart UI v15.2.0 (2023-04-20) 
Copyright (c) 2011-2023 jQWidgets. 
License: https://htmlelements.com/license/ */ //

Smart("smart-card-view",class extends Smart.DataView{static get properties(){return{cardHeight:{value:null,type:"number?"},cellOrientation:{value:"vertical",allowedValues:["horizontal","vertical"],type:"string"},coverField:{value:null,type:"string?"},coverMode:{value:"crop",allowedValues:["fit","crop"],type:"string"},messages:{value:{en:{addImage:"Add",coverField:"Cover field",crop:"Crop",customize:"Customize cards",dateTabLabel:"DATE",draggedRecord:"Record {{id}}",fit:"Fit",imageUrl:"New image URL:",incorrectStructure:'"dataSource" must be an instance of Smart.DataAdapter or an array of objects with key-value pairs.',nextRecord:"Next record",noCoverField:"No cover field",noData:"No data to display",noMatches:"No matched records",now:"Now",previousRecord:"Previous record",removeImage:"Remove",timeTabLabel:"TIME",toggleVisibility:"Toggle field visibility"}}},scrolling:{value:"physical",allowedValues:["physical","virtual","infinite","deferred"],type:"string"},titleField:{value:null,type:"string?"}}}static get listeners(){return{click:"_clickHandler",move:"_moveHandler","addNewButton.click":"_addNewButtonClickHandler","cardContainer.down":"_cardContainerDownHandler","scrollViewer.touchmove":"_scrollViewerTouchmoveHandler"}}static get requires(){return{"Smart.Button":"smart.button.js","Smart.Card":"smart.card.js","Smart.Carousel":"smart.carousel.js","Smart.CheckBox":"smart.checkbox.js","Smart.ColumnPanel":"smart.gridpanel.js","Smart.DataAdapter":"smart.data.js","Smart.DateTimePicker":"smart.datetimepicker.js","Smart.Input":"smart.input.js","Smart.NumericTextBox":"smart.numerictextbox.js","Smart.ScrollBar":"smart.scrollbar.js","Smart.SwitchButton":"smart.switchbutton.js","Smart.Window":"smart.window.js","Smart.Utilities.DateTime":"smart.date.js"}}get hasStyleObserver(){return!1}get editInfo(){return this._editInfo}static get styleUrls(){return["smart.cardview.css"]}template(){return'<div id="container" role="presentation">\n                    <div id="header" class="smart-data-view-header" role="toolbar">\n                        <div id="customizeButton" class="smart-data-view-header-button smart-data-view-customize-button smart-unselectable" role="button" aria-expanded="false" aria-haspopup="dialog" aria-label="Customize cards"><div role="presentation"></div></div>\n                        <div id="filterButton" class="smart-data-view-header-button smart-data-view-filter-button smart-unselectable" role="button" aria-expanded="false" aria-haspopup="dialog" aria-label="Filter"><div role="presentation"></div></div>\n                        <div id="sortButton" class="smart-data-view-header-button smart-data-view-sort-button smart-unselectable" role="button" aria-expanded="false" aria-haspopup="dialog" aria-label="Sort"><div role="presentation"></div></div>\n                        <div id="searchButton" class="smart-data-view-header-button smart-data-view-search-button smart-unselectable" role="button" aria-expanded="false" aria-haspopup="dialog" aria-label="Search"></div>\n                        <div id="headerDropDown" class="smart-data-view-header-drop-down smart-visibility-hidden" role="dialog">\n                            <div id="customize" class="smart-hidden" role="presentation"></div>\n                            <div id="filter" class="smart-hidden" role="presentation"></div>\n                            <div id="sort" class="smart-hidden" role="presentation"></div>\n                            <div id="search" class="smart-data-view-search-box smart-hidden" role="presentation">\n                                <input type="text" id="searchInput" spellcheck="false" aria-label="Search" />\n                                <div id="searchLabel" class="smart-data-view-search-label smart-unselectable"></div>\n                                <div id="searchPrev" class="smart-data-view-search-prev" role="button" aria-label="Previous"></div>\n                                <div id="searchNext" class="smart-data-view-search-next" role="button" aria-label="Next"></div>\n                                <div id="searchClose" class="smart-data-view-search-close" role="button" aria-label="Close search box"></div>\n                            </div>\n                        </div>\n                    </div>\n                    <smart-scroll-viewer id="scrollViewer" animation="[[animation]]" horizontal-scroll-bar-visibility="hidden" right-to-left="[[rightToLeft]]">\n                        <div id="cardContainer" class="smart-card-container" role="list"></div>\n                    </smart-scroll-viewer>\n                    <div id="loadingIndicatorContainer" class="smart-loader-container smart-hidden" aria-label="Loading">\n                        <span id="loadingIndicator" class="smart-loader" role="presentation"></span>\n                    </div>\n                    <div id="addNewButton" class="smart-add-new-button" role="button" aria-label="Add new card"></div>\n                </div>'}attached(){const e=this;super.attached(),e.isCompleted&&e._editInfo&&(e._addWindowHandlers(),document.body.appendChild(e._editInfo.window))}detached(){const e=this;if(super.detached(),!e._editInfo)return;const t=e._editInfo.window;t.removeEventListener("open",e._windowEventHandler),t.removeEventListener("closing",e._windowEventHandler),t.removeEventListener("close",e._windowEventHandler),t.removeEventListener("click",e._windowClickHandler),t.removeEventListener("prev",e._prevNextHandler),t.removeEventListener("next",e._prevNextHandler),t.remove()}ready(){super.ready()}render(){const e=this,t=e.dataSource,a=e.scrolling,i=getComputedStyle(e);Smart.Utilities.NumberRenderer&&(e._numericFormatter=new Smart.Utilities.NumberRenderer),e.shadowRoot&&(e.importStyle(Smart.Utilities.Core.getScriptLocation()+Smart.StyleBaseUrl.replace("/scoped/","/smart.scrollviewer.css")),e.importStyle(Smart.Utilities.Core.getScriptLocation()+Smart.StyleBaseUrl.replace("/scoped/","/smart.carousel.css")),e.importStyle(Smart.Utilities.Core.getScriptLocation()+Smart.StyleBaseUrl.replace("/scoped/","/smart.button.css")),e.importStyle(Smart.Utilities.Core.getScriptLocation()+Smart.StyleBaseUrl.replace("/scoped/","/smart.sortable.css"))),e._gap=parseFloat(i.getPropertyValue("--smart-card-view-gap")),e._verticalOffset=parseFloat(i.getPropertyValue("--smart-card-view-vertical-offset")),e._cards=[],e._collapsed={},e._collapsedRows={},e._numberOfCollapsedRows=0,e._cardScrolling={},e._cardSelectedCover={},e._cardHeight=e.cardHeight,e._autoCardHeight=null===e._cardHeight,e._cachedWidth=e.offsetWidth,e._cachedHeight=e.offsetHeight,e._appliedFiltering={filterGroups:[],filters:[],operator:"and"},e._appliedSorting={dataFields:[],dataTypes:[],orderBy:[]},e._start={view:0,data:0},e._autoScrollCoefficient=Smart.Utilities.Core.Browser.Firefox?8:Smart.Utilities.Core.Browser.Edge?16:4,e._normalizeDataSource(),e._getVisibleRecords(),e._normalizeColumns(),e._handleHeaderPosition(e.$.scrollViewer),e._localizeHeader(),e._getInnerElementMessages(),"deferred"===a?e.$.scrollViewer.$.verticalScrollBar.mechanicalAction="switchWhenReleased":"virtual"!==a&&"infinite"!==a||!t||void 0!==t.onVirtualDataSourceRequested||(e.scrolling="physical"),e._createTemplate(),"infinite"===a?e._requestInitialCards():e._createCards(),e.$.scrollViewer._verticalScrollbarHandler=e._onVerticalChange.bind(e),e.$.scrollViewer.hasStyleObserver=!1,e.$.scrollViewer.$.verticalScrollBar.hasStyleObserver=!1,e.$.scrollViewer.$.horizontalScrollBar.hasStyleObserver=!1,super.render()}addRecord(e,t={},a="last"){const i=this,r=i.dataSource,l=i.scrolling;if("object"!=typeof t)return;if(0===i.dataSource.dataFields.length){const e=[t];return i.dataSource=e,void i.propertyChangedHandler("dataSource",null,e)}const o=r.id;if(o&&(null!=e&&""!==e?t[o]=e:void 0===t[o]&&(r[0]&&!r[0].$.isEmpty&&"number"==typeof r[0].$.id?t[o]=Math.floor(Math.random()*(1e6-r.length))+r.length:t[o]=Math.random().toString(36).substring(7))),"physical"===l||"deferred"===l)return"first"!==a?(a="last",r.insert(r.length,t),r!==i._visibleSource&&i._visibleSource.push(r[r.length-1])):(r.insert(0,t),r!==i._visibleSource&&i._visibleSource.unshift(r[0])),i._closeSearchPanel(),void i._fullRefresh();i._requestVirtualDataSource("add",t,(function(e){return e}))}beginEdit(e){const t=this;if(!t.editable||t.disabled)return;if(!t._visibleSource.find((t=>t.$.id===e)))return;const a=t.ensureVisible(e);"virtual"!==t.scrolling?t._openEditDialog(a.dataId):t._beginEditOnLoad=e}cancelEdit(){const e=this._editInfo;e&&e.window.opened&&e.window.close()}endEdit(){const e=this._editInfo;e&&e.window.opened&&(e.ok=!0,e.window.close())}ensureVisible(e){const t=this,a=t._visibleSource,i=a.find((t=>t.$.id===e));if(!i)return;const r=a.indexOf(i),l=t._cardsPerRow,o=t._cardHeight+t._gap,s=t.$.scrollViewer.$.verticalScrollBar,n=Math.floor(r/l),d=Math.max(0,n*l);let c,u,h=0;if(t._numberOfCollapsedRows>0){const e=Math.floor((a.length-1)/l)+1;for(let a=0;a<e;a++){const e=a;if(e===n)break;t._collapsedRows[e]?h+=o-t._cardContentHeight:h+=o}}else h=Math.floor(d/l)*o;return h=Math.min(h,s.max),Math.abs(s.value-h)<t.$.scrollViewer.$.scrollViewerContainer.offsetHeight/50?(c=t._cards.filter((e=>e.dataId===r&&!e.classList.contains("smart-hidden"))),u=c[c.length-1],u):(s.value=h,t._onVerticalChange({detail:{value:h}}),c=t._cards.filter((e=>e.dataId===r&&!e.classList.contains("smart-hidden"))),u=c[c.length-1],u)}hideColumn(e){this._toggleColumn(e,!1)}openCustomizePanel(){const e=this,t=e.dataSource;if(!t||0===t.length||e.disabled||"none"===e.headerPosition)return;const a=e.$.customize,i=e.columns.map((t=>{const a=Object.assign({},t);return-1!==[e.coverField,e.titleField].indexOf(a.dataField)?a.disableToggle=!0:a.disableToggle=!1,a})),r=[e.localize("noCoverField")].concat(e.columns.filter((e=>e.image)));let l,o,s;if(e._closeDialog(),e.$.headerDropDown.classList.add("customize-panel"),e.$.headerDropDown.classList.remove("filter-panel","sort-panel","search-panel"),a.classList.remove("smart-hidden"),e.$.filter.classList.add("smart-hidden"),e.$.sort.classList.add("smart-hidden"),e.$.search.classList.add("smart-hidden"),e._closeSearchPanel(),e._customizePartCreated)l=a.getElementsByTagName("smart-switch-button")[0],l.rightToLeft=e.rightToLeft,o=a.getElementsByTagName("smart-input")[0],o.dataSource=r,o.rightToLeft=e.rightToLeft,delete o.$.input.dataValue,s=a.children[1],s.set("dataSource",i),s.propertyChangedHandler("dataSource",void 0,i),s.rightToLeft=e.rightToLeft;else{const t=document.createDocumentFragment(),a=document.createElement("div"),n=document.createElement("div"),d=document.createElement("div");l=document.createElement("smart-switch-button"),o=document.createElement("smart-input"),s=document.createElement("smart-column-panel"),d.id=e.id+"CoverFieldLabel",d.innerHTML=e.localize("coverField"),l.rightToLeft=e.rightToLeft,l.setAttribute("crop",e.localize("crop")),l.setAttribute("fit",e.localize("fit")),l.setAttribute("aria-labelledby",d.id),l.inverted=!0,l.animation=e.animation,l.theme=e.theme,o.dataSource=r,o.dropDownButtonPosition="right",o.rightToLeft=e.rightToLeft,o.readonly=!0,o.animation=e.animation,o.theme=e.theme,s.rightToLeft=e.rightToLeft,s.animation=e.animation,s.dataSource=i,s.locale=e.locale,s.messages=e._innerElementMessages.columnPanel,s.theme=e.theme,n.appendChild(d),n.appendChild(l),a.classList.add("smart-card-view-customize-top"),a.appendChild(n),a.appendChild(o),t.appendChild(a),t.appendChild(s),e.$.customize.appendChild(t),e._customizePartCreated=!0}l.checked="fit"===e.coverMode,o.value=e.coverField?e.columns.find((t=>t.dataField===e.coverField)).label:e.localize("noCoverField"),e._changedVisibility=new Map,e._openHeaderDropDown(e.$.customizeButton)}openFilterPanel(){const e=this.dataSource,t=this.columns.map((t=>{const a=Object.assign({},t);return a.dataType=e.dataFields.find((e=>e.name===a.dataField)).dataType,a}));super.openFilterPanel(t,null)}openSortPanel(){const e=this,t=e.dataSource,a=e.columns.map((a=>{const i=Object.assign({},a),r=e._appliedSorting.dataFields.indexOf(i.dataField);return i.dataType=t.dataFields.find((e=>e.name===i.dataField)).dataType,i.sortIndex=r,-1!==r&&(i.sortDirection=e._appliedSorting.orderBy[r]),i}));super.openSortPanel(a)}removeRecord(e){const t=this,a=t.scrolling,i=t.dataSource;let r=i.find((t=>t.$.id===e));if("physical"!==a&&"deferred"!==a){if(!r){if(!i.id)return;r={},r[i.id]=e}t._requestVirtualDataSource("remove",r,(function(e){return e}))}else!function(){if(!r)return;const e=i.indexOf(r),a=t._visibleSource.indexOf(r);if(i.removeAt(e),i!==t._visibleSource){if(-1===a)return;t._visibleSource.splice(a,1)}t._closeSearchPanel(),t._fullRefresh()}()}showColumn(e){this._toggleColumn(e,!0)}propertyChangedHandler(e,t,a){super.propertyChangedHandler(e,t,a);const i=this;switch(e){case"allowDrag":case"coverMode":break;case"addNewButton":a&&0===i.dataSource.dataFields.length&&(i.addNewButton=!1);break;case"animation":case"theme":if(i._cards.forEach((t=>{const i=t.getElementsByTagName("smart-carousel");i&&(i[e]=a)})),i._editInfo){i._editInfo.window[e]=a,Array.from(i._editInfo.window.$.footer.children).forEach((t=>t[e]=a));for(let t in i._editInfo.editors)i._editInfo.editors[t].element[e]=a}i._customizePartCreated&&(i.$.customize.firstElementChild.firstElementChild.children[1][e]=a,i.$.customize.firstElementChild.children[1][e]=a,i.$.customize.children[1][e]=a),i._filterPartCreated&&(i.$.filter.firstElementChild[e]=a),i._sortPartCreated&&(i.$.sort.firstElementChild[e]=a);break;case"disabled":i.closePanel(),i._editInfo&&(i._editInfo.window.disabled=a);break;case"cardHeight":i._updateCardHeight(a);break;case"cellOrientation":case"collapsible":if(!i.dataSource||0===i.dataSource.length)return;i._fullRefresh();break;case"columns":i._updateColumns();break;case"coverField":case"titleField":if(null!==a){const r=i.columns.find((e=>e.dataField===a));if(!r||"coverField"===e&&!r.image)return void(i[e]=t)}if(i._createTemplate(),!i.dataSource||0===i.dataSource.length)return;i._fullRefresh();break;case"dataSource":i._close(),i._normalizeDataSource(),i._getVisibleRecords(),i._clearFilterAndSortUI(),i._normalizeColumns(),i._createTemplate(),i._fullRefresh(!1);break;case"editable":a||i._closeDialog();break;case"headerPosition":i._handleHeaderPosition(i.$.scrollViewer),("none"===a||"none"===t)&&i.dataSource&&i.dataSource.length>0&&i._partialRefresh();break;case"locale":case"messages":if(i.closePanel(),i._localizeHeader(),i._getInnerElementMessages(),i._editInfo){const e=i._editInfo.window;e.$.buttonsContainer.firstElementChild.title=i.localize("previousRecord"),e.$.buttonsContainer.children[1].title=i.localize("nextRecord"),e.$.footer.firstElementChild.innerHTML=i.localize("ok"),e.$.footer.children[1].innerHTML=i.localize("cancel"),Array.from(e.getElementsByClassName("toggle-visibility")).forEach((e=>e.title=i.localize("toggleVisibility"))),Array.from(e.querySelectorAll(".smart-card-view-editor.image")).forEach((e=>{Array.from(e.firstElementChild.children).forEach((e=>e.title=i.localize("removeImage"))),e.children[1].innerHTML=i.localize("imageUrl"),e.children[2].children[1].title=i.localize("addImage")})),Array.from(e.getElementsByTagName("smart-date-time-picker")).forEach((e=>{e.messages=i._innerElementMessages.dateTimePicker,e.locale=i.locale}))}if(i._customizePartCreated){const e=i.$.customize.getElementsByTagName("smart-switch-button")[0];i.$.customize.firstElementChild.firstElementChild.firstElementChild.innerHTML=i.localize("coverField"),i.$.customize.children[1].messages=i._innerElementMessages.columnPanel,i.$.customize.children[1].locale=i.locale,e.setAttribute("crop",i.localize("crop")),e.setAttribute("fit",i.localize("fit"))}i._filterPartCreated&&(i.$.filter.firstElementChild.messages=i._innerElementMessages.multiColumnFilterPanel,i.$.filter.firstElementChild.locale=i.locale,i.$.filter.firstElementChild.editorPlaceholder=i.localize("filterValuePlaceholder")),i._sortPartCreated&&(i.$.sort.firstElementChild.messages=i._innerElementMessages.sortPanel,i.$.sort.firstElementChild.locale=i.locale);break;case"rightToLeft":i._editInfo&&!i._editInfo.updateWindowContent&&(i._editInfo.window.rightToLeft=a,Array.from(i._editInfo.window.$.footer.children).forEach((e=>e.rightToLeft=a)),i.columns.forEach((function(e){const t=i._editInfo.editors[e.dataField],r=t.element;"date"===t.type?r.calendarButtonPosition=a?"left":"right":"number"===t.type?a?(r.spinButtonsPosition="left",r.radixDisplayPosition="right"):(r.spinButtonsPosition="right",r.radixDisplayPosition="left"):"string"===t.type&&r instanceof HTMLTextAreaElement&&(i.rightToLeft?r.setAttribute("right-to-left",""):r.removeAttribute("right-to-left")),r.rightToLeft=i.rightToLeft}))),i.closePanel();break;case"scrolling":{const e=["virtual","infinite"];if(-1!==e.indexOf(a)||-1!==e.indexOf(t))return void(i.scrolling=t);i.$.scrollViewer.$.verticalScrollBar.mechanicalAction="deferred"===a?"switchWhenReleased":"switchWhileDragging";break}}}_updateColumns(){const e=this;e._normalizeColumns(),e._createTemplate(),e._fullRefresh()}_addNewButtonClickHandler(){this._openEditDialog()}_clickHandler(e){const t=this,a=t.isInShadowDOM||t.shadowRoot?e.composedPath()[0]:e.target;if(t.$.header.contains(a))return void t._headerClickHandler(a,t.$.cardContainer);const i=a.closest("smart-card");if(!i||a.classList.contains("smart-indicator")||t._dragDetails&&t._dragDetails.feedbackShown)return;if(t._dragDetails&&(delete t._dragDetails,t.$.scrollViewer._scrollView.disableSwipeScroll=!1),!a.classList.contains("smart-arrow-up"))return void(t.editable&&!t._clickToDrag&&t._openEditDialog(i.dataId));const r=i.getElementsByClassName("smart-card-view-content")[0],l=t._visibleSource[i.dataId].$.id;r.removeEventListener("transitionend",t._transitionendHandlerExpand),r.removeEventListener("transitionend",t._transitionendHandlerCollapse),t._collapsed[l]?(delete t._collapsed[l],t._getNumberOfCollapsedRows(),t.hasAnimation?t._expandDataContainer(r):(i.classList.remove("collapsed"),a.classList.remove("collapsed"),r.classList.remove("smart-visibility-hidden"),t._partialRefresh()),window.getSelection().removeAllRanges()):(t._collapsed[l]=!0,t._getNumberOfCollapsedRows(),i.classList.add("collapsed"),a.classList.add("collapsed"),t.hasAnimation?t._collapseDataContainer(r):(r.classList.add("smart-visibility-hidden"),t._partialRefresh()))}_windowClickHandler(e){const t=this,a=t.ownerElement,i=e.target.shadowRoot?e.composedPath()[0]:e.target;if(i.closest(".ok"))a._editInfo.ok=!0,t.close();else if(i.closest(".cancel"))t.close();else if(i.closest(".add")){const e=i.closest(".container"),t=e.firstElementChild;if(""!==t.value.trim()){const i=document.createElement("div");i.className="thumbnail",i.style.backgroundImage=`url("${t.value}")`,i.title=a.localize("removeImage"),e.parentElement.firstElementChild.appendChild(i),t.value=""}}else if(i.classList.contains("thumbnail"))i.parentElement.removeChild(i);else if(i.classList.contains("toggle-visibility")){const e=a.columns.find((e=>i.parentElement.getAttribute("data-field")===e.dataField));i.classList.toggle("hidden"),a._changedVisibility.set(e,!i.classList.contains("hidden"))}}_expandDataContainer(e){const t=this,a=e.style.height,i=t._cardContentHeight-t._verticalOffset+"px";e.style.height=i,e.classList.remove("smart-visibility-hidden"),e.previousElementSibling.children[1].classList.remove("collapsed"),a!==i&&(parseFloat(a)||parseFloat(i))?e.addEventListener("transitionend",t._transitionendHandlerExpand):t._transitionendHandlerExpand(t,e)}_transitionendHandlerExpand(){let e,t;1===arguments.length?(t=this,e=e=t.closest("smart-card-view")||(t.getRootNode()&&t.getRootNode().host?t.getRootNode().host.closest("smart-card-view"):void 0)):(e=arguments[0],t=arguments[1]),t.removeEventListener("transitionend",e._transitionendHandlerExpand),t.style.height=null,t.parentElement.parentElement.parentElement.classList.remove("collapsed"),e._partialRefresh()}_collapseDataContainer(e){const t=this,a=t._cardContentHeight-t._verticalOffset+"px";e.style.transition="none",requestAnimationFrame((function(){e.style.height=a,e.style.transition=null,requestAnimationFrame((function(){e.style.height="0px",e.classList.add("smart-visibility-hidden"),"0px"===a&&t._transitionendHandlerCollapse(t,e)}))})),e.addEventListener("transitionend",t._transitionendHandlerCollapse)}_transitionendHandlerCollapse(){let e,t;1===arguments.length?(t=this,e=t.closest("smart-card-view")||(t.getRootNode()&&t.getRootNode().host?t.getRootNode().host.closest("smart-card-view"):void 0)):(e=arguments[0],t=arguments[1]),t.removeEventListener("transitionend",e._transitionendHandlerCollapse),t.style.height=null,e._partialRefresh()}_getNumberOfCollapsedRows(){const e=this,t=e._visibleSource,a=e._cardsPerRow,i=[],r={};let l=0;for(let o in e._collapsed){const s=t.findIndex?t.findIndex((e=>e.$.id.toString()===o)):t.boundSource.findIndex((e=>e.$.id.toString()===o)),n=Math.floor(s/a);if(-1!==i.indexOf(n))continue;const d=Math.max(0,n*a);let c=!0;i.push(n);for(let i=0;i<a;i++){const a=t[i+d];if(!a)break;if(!e._collapsed[a.$.id]){c=!1;break}}c&&(r[n]=!0,l++)}e._collapsedRows=r,e._numberOfCollapsedRows=l}_openEditDialog(e){const t=this,a=t._visibleSource[e];if(t.$.fireEvent("opening",{record:a}).defaultPrevented)return;if(t.$.container.setAttribute("modal",""),t.closePanel(),t._changedVisibility=new Map,t._editInfo&&!t._editInfo.updateWindowContent)return void t._updateEditedView(e,!0);const i=document.createDocumentFragment(),r={};if(t.columns.forEach((function(e){const l=e.dataField,o=a?a[l]:"",s=document.createElement("div");let n;if(s.className="smart-card-view-label"+(e.icon?" icon "+e.icon:""),s.setAttribute("data-field",l),s.innerHTML=`${e.label}<span class="toggle-visibility${!1===e.visible?" hidden":""}${l===t.coverField||l===t.titleField?" smart-hidden":""}" title="${t.localize("toggleVisibility")}" role="button" aria-label="Toggle field visibility"></span>`,i.appendChild(s),e.image)return n=document.createElement("div"),n.className="smart-card-view-editor image",n.setAttribute("aria-label",e.label),n.innerHTML=`<div>${t._updateImgThumbNails(o)}</div>\n<div class="label">${t.localize("imageUrl")}</div>\n<div class="container" role="presentation">\n    <smart-input aria-label="New image URL"></smart-input>\n    <smart-button class="add" title="${t.localize("addImage")}" aria-label="Add image">+</smart-button>\n</div>`,i.appendChild(n),void(r[l]={element:n,type:"image"});const d=t.dataSource.dataFields.find((t=>t.name===e.dataField)).dataType;"date"===d?(n=document.createElement("smart-date-time-picker"),n.calendarButton=!0,n.calendarButtonPosition=t.rightToLeft?"left":"right",n.dropDownAppendTo="body",n.dropDownDisplayMode="auto",n.dropDownPosition="bottom",n.locale=t.locale,n.messages=t._innerElementMessages.dateTimePicker,n.nullable=!0,n.value=o||null,e.formatSettings&&e.formatSettings.formatString&&(n.formatString=e.formatSettings.formatString)):"number"===d?(n=document.createElement("smart-numeric-text-box"),n.inputFormat="floatingPoint",n.spinButtons=!0,n.nullable=!0,t.rightToLeft&&(n.spinButtonsPosition="left",n.radixDisplayPosition="right"),n.value=null!=o?o:null,e.formatSettings&&e.formatSettings.formatString&&(n.outputFormatString=e.formatSettings.formatString)):"boolean"===d?(n=document.createElement("smart-check-box"),n.checked=o||!1):("string"==typeof o&&o.length>50?(n=document.createElement("textarea"),t.rightToLeft&&n.setAttribute("right-to-left","")):n=document.createElement("smart-input"),n.value=null!=o?o.toString():""),n.className="smart-card-view-editor",n.setAttribute("aria-label",e.label),n.animation=t.animation,n.theme=t.theme,n.rightToLeft=t.rightToLeft,i.appendChild(n),r[l]={element:n,type:d}})),t._editInfo&&t._editInfo.updateWindowContent)return t._editInfo.window.clear(),t._editInfo.window.appendChild(i),t._openWindow(),t._editInfo.dataId=e,t._editInfo.editors=r,void delete t._editInfo.updateWindowContent;const l=document.createElement("smart-window"),o=document.createElement("template"),s=` animation="${t.animation}"${this.rightToLeft?" right-to-left":""} theme="${t.theme}"${t.unfocusable?" unfocusable":""}`;o.innerHTML=`<smart-button class="ok primary"${s}>${t.localize("ok")}</smart-button>\n                                    <smart-button class="cancel"${s}>${t.localize("cancel")}</smart-button>`,l.classList.add("smart-card-view-window","smart-visibility-hidden"),l.footerTemplate=o,l.headerButtons=["close","next","prev"],l.label=a?a[t.titleField]:"",l.animation=t.animation,l.rightToLeft=t.rightToLeft,l.theme=t.theme,l.ownerElement=t,l.appendChild(i),document.body.appendChild(l),t._editInfo={dataId:e,editors:r,window:l},t._addWindowHandlers(),l.whenRendered((()=>{t.setAttribute("aria-owns",l.id),l.$.buttonsContainer.firstElementChild.title=t.localize("previousRecord"),l.$.buttonsContainer.children[1].title=t.localize("nextRecord"),t._openWindow()}))}_openWindow(){const e=this._editInfo.window,t=document.documentElement.clientWidth,a=document.documentElement.clientHeight,i=window.pageXOffset,r=window.pageYOffset;e.style.top=(a-e.offsetHeight)/2+r+"px",e.style.left=(t-e.offsetWidth)/2+i+"px",e.open()}_addWindowHandlers(){const e=this,t=e._editInfo.window;t.addEventListener("open",e._windowEventHandler),t.addEventListener("closing",e._windowEventHandler),t.addEventListener("close",e._windowEventHandler),t.addEventListener("click",e._windowClickHandler),t.addEventListener("prev",e._prevNextHandler),t.addEventListener("next",e._prevNextHandler)}_windowEventHandler(e){const t=this.ownerElement,a=e.type,i=t.context;e.target===this&&(t.context=t,"open"===a?t.$.fireEvent("open"):"closing"===a?t.$.fireEvent("closing").defaultPrevented&&e.preventDefault():"close"===a&&(t.$.fireEvent("close"),t._windowCloseHandler(e)),t.context=i)}_updateEditedView(e,t){const a=this,i=a._visibleSource[e];i&&i.$.isEmpty||(a._editInfo.dataId=e,a.columns.forEach((function(e){const t=e.dataField,r=i?i[t]:"",l=a._editInfo.editors[t];"image"===l.type?l.element.firstElementChild.innerHTML=a._updateImgThumbNails(r):"boolean"===l.type?l.element.checked=r||!1:"date"===l.type?l.element.value=r||null:"number"===l.type?l.element.value=null!=r?r:null:(l.element instanceof HTMLTextAreaElement&&(a.rightToLeft?l.element.setAttribute("right-to-left",""):l.element.removeAttribute("right-to-left")),l.element.value=null!=r?r.toString():""),l.element.rightToLeft=a.rightToLeft})),a._editInfo.window.label=i?i[a.titleField]:"",t&&a._openWindow())}_updateImgThumbNails(e){if(""===e.trim())return"";const t=e.split(",").map((e=>e.trim()));let a="";return t.forEach((e=>a+=`<div class="thumbnail" style="background-image: url('${e}');" title="${this.localize("removeImage")}" role="img"></div>`)),a}_moveHandler(e){"touchmove"===e.originalEvent.type&&e.originalEvent.preventDefault()}_prevNextHandler(e){const t=this.ownerElement,a=t.context,i=t._editInfo.dataId,r="prev"===e.type?i-1:i+1;t._visibleSource[r]&&!t._visibleSource[r].$.isEmpty&&(t.context=t,t._saveChanges(),t._updateEditedView(r),t.context=a)}_saveChanges(){const e=this,t=e._editInfo.dataId,a=e.dataSource&&e.dataSource.virtualDataSource;let i,r;if(void 0!==t)if(i=e._visibleSource[t],a)i=Object.assign({},i);else{const a=e._cards.filter((e=>e.dataId===t));r=a[a.length-1]}else i={};e.columns.forEach((function(t){const a=t.dataField,l=e._editInfo.editors[a],o=l.element;if("image"===l.type){const t=[];if(Array.from(l.element.getElementsByClassName("thumbnail")).forEach((e=>{t.push(e.style.backgroundImage.replace(/url\(["'](.+)["']\)/g,"$1"))})),i[a]=t.join(","),r&&a===e.coverField)return void(r.firstElementChild.firstElementChild.dataSource=t)}else"boolean"===l.type?i[a]=o.checked:"date"===l.type?i[a]=o.value?o.value.toDate():null:i[a]=o.value;if(r)if(a===e.titleField)r.getElementsByClassName("smart-card-view-title")[0].firstElementChild.innerHTML=e._formatValue(i[a],i,t);else if(t.visible){const l=r.querySelector(`[data-field="${a}"] > .smart-card-view-value`);l&&(l.innerHTML=e._formatValue(i[a],i,t))}})),void 0===t?e.addRecord(null,i):a&&e._requestVirtualDataSource("update",i,(function(e){return e}))}_close(){this.closePanel(),this._closeDialog()}_closeDialog(){const e=this;e._editInfo&&e._editInfo.window.close()}_resizeHandler(){this.refresh()}refresh(){const e=this;e._suppressResizeHandler||e.hasAttribute("empty")||e.hasAttribute("no-matches")||(clearTimeout(e._resizeTimeout),e.$.loadingIndicatorContainer.classList.remove("smart-hidden"),e._resizeTimeout=setTimeout((function(){if(e.$.loadingIndicatorContainer.classList.add("smart-hidden"),e._cards.length!==e._visibleSource.length){if(e.offsetHeight!==e._cachedHeight&&(e._cachedHeight=e.offsetHeight,Math.abs(e._refreshedAtDimensions.height-e._cachedHeight)>=20?(e._dataSourceProcessed=!0,e._partialRefresh(),delete e._dataSourceProcessed):e.$.scrollViewer.$.verticalScrollBar.max=Math.max(0,e._scrollHeight-e.$.scrollViewer.$.scrollViewerContainer.offsetHeight-e._numberOfCollapsedRows*e._cardContentHeight)),e.offsetWidth!==e._cachedWidth){const t=e._cardsPerRow;e._cachedWidth=e.offsetWidth,e._getCardsPerRow(),t!==e._cardsPerRow&&(e._dataSourceProcessed=!0,e._partialRefresh(),delete e._dataSourceProcessed)}}else{if(e.offsetWidth!==e._cachedWidth){const t=e._cardsPerRow;e._getCardsPerRow(),t!==e._cardsPerRow&&e._getNumberOfCollapsedRows(),e._cachedWidth=e.offsetWidth}else e._cachedHeight=e.offsetHeight;e._cards.length>0&&(e._autoCardHeight&&e._updateCardHeight(null),e.$.scrollViewer.refresh())}}),75))}_windowCloseHandler(){const e=this;if(e.$.container.removeAttribute("modal"),e._editInfo.ok)return e._updateColumnsVisibility((function(){e._saveChanges()})),void delete e._editInfo.ok;e._changedVisibility.forEach((function(t,a){a.visible!==t&&e._editInfo.window.querySelector(`[data-field="${a.dataField}"]`).firstElementChild.classList.toggle("hidden")}))}_updateColumnsVisibility(e,t){const a=this;let i=!1;a._changedVisibility.forEach((function(r,l){if(!0!==t&&l.visible===r)return;const o=l.dataField;l.visible=r,r?(a._cardContent=a._cardContent.replace(`class="smart-card-view-cell smart-hidden" data-field="${o}"`,`class="smart-card-view-cell" data-field="${o}"`),!e&&a._editInfo&&a._editInfo.window.querySelector(`[data-field="${o}"]`).firstElementChild.classList.remove("hidden")):(a._cardContent=a._cardContent.replace(`class="smart-card-view-cell" data-field="${o}"`,`class="smart-card-view-cell smart-hidden" data-field="${o}"`),!e&&a._editInfo&&a._editInfo.window.querySelector(`[data-field="${o}"]`).firstElementChild.classList.add("hidden")),a._cards.forEach((e=>{const t=e.querySelector(`[data-field="${o}"]`);if(t.classList.toggle("smart-hidden"),r){const i=a._visibleSource[e.dataId];t.children[1].innerHTML=a._formatValue(i[o],i,l)}})),i=!0})),e&&e(),a._autoCardHeight&&i&&a._updateCardHeight(null)}_applyHandler(e){const t=this,a=e.target,i=e.detail,r=t.$.customize,l=t.columns;if(r.contains(a)){const e=r.getElementsByTagName("smart-switch-button")[0],a=r.getElementsByTagName("smart-input")[0],o=e.checked?"fit":"crop";let s=l.find((e=>e.label===a.value))||null,n=!1;o!==t.coverMode&&(t.coverMode=o),s&&(s=s.dataField),s!==t.coverField&&(t.coverField=s,n=!0),n||i.positionChanged?(i.positionChanged&&(t.columns=i.value),t._createTemplate(),t._fullRefresh(),i.positionChanged&&t._editInfo&&(t._editInfo.updateWindowContent=!0)):(i.value.forEach((e=>{const a=l.find((t=>t.dataField===e.dataField));a.visible!==e.visible&&t._changedVisibility.set(a,e.visible)})),t._updateColumnsVisibility())}else t.$.filter.contains(a)?t.addFilter(i.filters,i.operator,i.value):t.$.sort.contains(a)&&t.addSort(i.sortByInfo);t.closePanel()}_fullRefresh(e=!0,t){const a=this,i=a.$.cardContainer;let r;for(e&&(r=a._getFractionOfMax()),a._suppressResizeHandler=!0;i.firstChild;)i.removeChild(i.firstChild);a._cards=[],a._createCards(t),0===a._visibleSource.length&&a.$.scrollViewer.refresh(),a._setFractionOfMax(r)}_normalizeDataSource(){const e=this;let t=e.dataSource;function a(){if(0===e.columns.length)return e.addNewButton=!1,[];const t=[];return e.columns.forEach((e=>{try{t.push({name:e.dataField||e.label||e,dataType:e.dataType||"string"})}catch(e){return}})),t}if(t instanceof Smart.DataAdapter)return 0===t.dataFields.length&&(t.dataFields=a()),void(t.observable||(t.observable=!0,t.dataBind()));if(t){if(!Array.isArray(t)){if(!("object"==typeof t&&Object.keys(t).length>0))return void e.error(e.localize("incorrectStructure"));t=[t]}}else t=[];let i=[];if(0===t.length)i=a();else{let e=0,r=t[e],l=Object.keys(r);for(;r&&0===l.length;)e++,r=t[e],l=Object.keys(r);0===l.length?i=a():l.forEach((e=>{const t=r[e];let a;a="boolean"==typeof t?"boolean":isNaN(t)||null===t||""===t?(t.indexOf("-")>=0||t.indexOf("/")>=0||t.indexOf(":")>=0)&&"Invalid Date"!==new Date(t).toString()?"date":"string":"number",i.push(`${e}: ${a}`)}))}e.dataSourceSettings.dataFields&&e.dataSourceSettings.dataFields.length>0?e.dataSource=new Smart.DataAdapter({dataSource:t,dataSourceType:e.dataSourceSettings.dataSourceType,dataFields:e.dataSourceSettings.dataFields,keyDataField:e.dataSourceSettings.keyDataField,parentDataField:e.dataSourceSettings.parentDataField,childrenDataField:e.dataSourceSettings.childrenDataField,groupBy:e.dataSourceSettings.groupBy,mapChar:e.dataSourceSettings.mapChar,root:e.dataSourceSettings.root,record:e.dataSourceSettings.record,autoGenerateColumns:e.autoGenerateColumns,id:e.dataSourceSettings.id||e.dataRowId,expandHierarchy:e.expandHierarchy,virtualDataSource:e.dataSourceSettings.virtualDataSource,virtualDataSourceOnExpand:e.dataSourceSettings.virtualDataSourceOnExpand}):e.dataSource=new Smart.DataAdapter({dataSource:t,dataFields:i,id:e.dataRowId||e.dataSourceSettings.id,dataSourceType:e.dataSourceSettings.dataSourceType,keyDataField:e.dataSourceSettings.keyDataField,parentDataField:e.dataSourceSettings.parentDataField,childrenDataField:e.dataSourceSettings.childrenDataField,groupBy:e.dataSourceSettings.groupBy,mapChar:e.dataSourceSettings.mapChar,root:e.dataSourceSettings.root,record:e.dataSourceSettings.record,autoGenerateColumns:e.autoGenerateColumns,expandHierarchy:e.expandHierarchy,virtualDataSource:e.dataSourceSettings.virtualDataSource,virtualDataSourceOnExpand:e.dataSourceSettings.virtualDataSourceOnExpand})}_normalizeColumns(){const e=this,t=e.columns,a=e.dataSource.dataFields,i=[];(Array.isArray(t)||t instanceof Smart.ObservableArray)&&(t.forEach((t=>{let a,r,l,o,s,n,d,c;"object"==typeof t?(a=t.dataField,r=t.formatFunction,l=t.formatSettings,o=t.icon,s=t.image||!1,n=t.label||a,d=t.template,c=a===e.titleField||a===e.coverField||void 0===t.visible||t.visible):"string"==typeof t&&(a=t,s=!1,n=a,c=!0),i.push({dataField:a,formatFunction:r,formatSettings:l,icon:o,image:s,label:n,template:d,visible:c})})),0===i.length&&a.forEach((e=>{i.push({dataField:e.name,image:!1,label:e.name,visible:!0})})),i.find((t=>t.dataField===e.titleField))||(e.titleField=null),i.find((t=>t.dataField===e.coverField&&t.image))||(e.coverField=null),e.columns=new Smart.ObservableArray(i),e.columns.canNotify=!0,e.columns.notify((function(t){if(e.context!==e&&t.newValue!==t.oldValue){if(e._close(),"update"===t.action){const a=t.target;switch(t.propertyName){case"dataField":e._updateColumns();break;case"formatFunction":case"formatSettings":case"template":e._createTemplate(),e._fullRefresh();break;case"icon":case"label":a.dataField!==e.coverField&&a.dataField!==e.titleField&&(e._createTemplate(),e._fullRefresh());break;case"image":t.newValue||e.coverField!==a.dataField?(e._createTemplate(),e._fullRefresh()):(e.coverField=null,e.propertyChangedHandler("coverField",a.dataField,null));break;case"visible":{const i=a.dataField;if(!t.newValue&&(i===e.coverField||i===e.titleField))return void(a.visible=!0);e._toggleColumn(i,t.newValue,!0);break}}}else e._updateColumns();e._editInfo&&(e._editInfo.updateWindowContent=!0)}else"add"!==t.action&&"remove"!==t.action&&"insert"!==t.action||(e._close(),e._updateColumns(),e._editInfo&&(e._editInfo.updateWindowContent=!0))})),e._editInfo&&(e._editInfo.updateWindowContent=!0))}_localizeHeader(){const e=this;super._localizeHeader(),e.$.cardContainer.setAttribute("no-data",e.localize("noData")),e.$.cardContainer.setAttribute("no-matches",e.localize("noMatches"))}_openSearchPanel(){const e=this;let t;if(e.$.headerDropDown.classList.add("search-panel"),e.$.headerDropDown.classList.remove("customize-panel","filter-panel","sort-panel"),e.$.search.classList.remove("smart-hidden"),e.$.customize.classList.add("smart-hidden"),e.$.filter.classList.add("smart-hidden"),e.$.sort.classList.add("smart-hidden"),e._openHeaderDropDown(e.$.searchButton),Array.isArray(e._visibleSource))t=new Smart.DataAdapter({dataSource:e._visibleSource,dataFields:e.dataSource.dataFields,id:"_id"});else{const a=e._appliedSorting;let i=e._visibleSource.id;if(i)t=e._visibleSource;else{i="id",t=[];for(let a=0;a<e._visibleSource.length;a++){const i=e._visibleSource[a];t.push(Object.assign({id:i.$.id},i))}}t=new Smart.DataAdapter({dataSource:t,dataFields:e.dataSource.dataFields,id:i}),a.dataFields.length>0&&t.sortBy(a.dataFields,a.dataTypes,a.orderBy)}e._searchInfo={source:t,stringDataFields:e.dataSource.dataFields.filter((t=>"string"===t.dataType&&e.columns.find((e=>e.dataField===t.name&&!e.image)))).map((e=>e.name))},""!==e.$.searchInput.value&&e._search(e.$.searchInput.value,!1)}_createTemplate(){const e=this,t=e.titleField;let a="";a+=t?`<div class="smart-card-view-title" data-field="${t}" role="heading" aria-level="1"><div>{{${t}}}</div><div class="smart-arrow-up" role="button" aria-label="Toggle card"></div></div>`:'<div class="smart-card-view-title empty" role="heading" aria-level="1"><div>&nbsp;</div><div class="smart-arrow-up" role="button" aria-label="Toggle card"></div></div>',a+='<div class="smart-card-view-content" role="grid">',e.columns.forEach((i=>{const r=i.dataField;!1!==i.visible&&(i.visible=!0),r!==t&&r!==e.coverField&&(a+=`<div class="smart-card-view-cell${i.visible?"":" smart-hidden"}" data-field="${r}" role="row"><div class="smart-card-view-label${i.icon?" icon "+i.icon:""}" role="rowheader">${i.label}</div>\n<div class="smart-card-view-value" role="gridcell">{{${r}}}</div></div>`)})),a+="</div>",e._cardContent=a}_requestInitialCards(){const e=this;let t=1/0,a=1/0;"virtual"===e.scrolling&&(t=0,a=0),e.setAttribute("loading",""),e.$.loadingIndicatorContainer.classList.remove("smart-hidden"),e.dataSource.onVirtualDataSourceRequested((function(){e._createCards(!0),e.removeAttribute("loading"),e.$.loadingIndicatorContainer.classList.add("smart-hidden")}),{first:t,last:a,sorting:[],filtering:[],grouping:[],action:"dataBind"})}_createCards(e){const t=this,a=t._visibleSource;if(!a||0===a.length)return void(a&&a.virtualDataSource&&!e&&t._requestInitialCards());const i=t.scrolling,r="virtual"===i,l=t.$.scrollViewer.$.scrollViewerContainer.offsetHeight;let o,s=a.length,n=1,d=0,c=0;t._ignoreVerticalChange=!0,t.removeAttribute("empty"),r&&!e&&t.setAttribute("loading","");for(let e=0;e<s;e++){const i=t._createCard(a[e],e);if(t._cards.push(i),t.$.cardContainer.appendChild(i),t.$.scrollViewer.refresh(),t._autoCardHeight&&(c=Math.max(i.offsetHeight,c)),i.offsetTop>d&&(n++,d=i.offsetTop,o||(t._getCardsPerRow(),o=t._cardsPerRow)),n>=3&&t._cards.length%o==0&&t.$.cardContainer.offsetHeight>l+2*(t.cardHeight||c)&&t._cards.length+5<s)break}if(o=o||t._cards.length,"infinite"===i)for(;t._cards.length%o!=0;)t._createEmptyCard();t._autoCardHeight&&(t._cardHeight=c,t._cards.forEach((e=>e.style.height=c+"px"))),t._cardContentHeight=t._cards[0].getElementsByClassName("smart-card-view-content")[0].offsetHeight+t._verticalOffset,t._cards.forEach((e=>t._toggleCard(e,e.firstElementChild.lastElementChild,t._visibleSource[e.dataId].$.id)));const u=Math.ceil(s/o),h=(t._cardHeight+t._gap)*u-t._gap;t.$.scrollViewer.$.scrollViewerContentContainer.style.top=0,t.$.scrollViewer.$.verticalScrollBar.max=Math.max(0,h-l-t._numberOfCollapsedRows*t._cardContentHeight),t._cardsPerRow=o,t._scrollHeight=h,t._refreshedAtDimensions={width:t._cachedWidth,height:t._cachedHeight},t._getNumberOfCollapsedRows(),delete t._ignoreVerticalChange,delete t._suppressResizeHandler,r&&!e&&(t.$.loadingIndicatorContainer.classList.remove("smart-hidden"),t.dataSource.onVirtualDataSourceRequested(t._virtualDataSourceRequestedCallback.bind(t,0,0,!0),{first:0,last:t._cards.length,sorting:[],filtering:[],grouping:[],action:""}))}_virtualDataSourceRequestedCallback(e,t,a){const i=this;if(i._ignoreVerticalChange=!0,i.$.loadingIndicatorContainer.classList.add("smart-hidden"),i._updateVisibleCards(e,t,a),i.removeAttribute("loading"),delete i._ignoreVerticalChange,i._beginEditOnLoad){const e=i._cards.filter((e=>e.dataId===i._beginEditOnLoad)),t=e[e.length-1];t&&i._openEditDialog(t.dataId),delete i._beginEditOnLoad}}_createCard(e={},t){const a=this,i=a.coverField,r=a._visibleSource,l=document.createElement("smart-card"),o=document.createElement("div");if(requestAnimationFrame((()=>l.hasStyleObserver=!1)),l.setAttribute("aria-setsize",r.length),l.setAttribute("aria-posinset",t+1),l.dataId=t,l.whenRendered((function(){l.setAttribute("role","listitem"),l.firstElementChild.onscroll=function(){const e=r[this.parentElement.dataId].$.id;a._cardScrolling[e]=this.scrollTop}})),a._autoCardHeight||(l.style.height=a._cardHeight+"px"),o.className="smart-card-data-container",o.setAttribute("role","presentation"),a._applyTemplate(e,l,o,!0),i){const t=document.createElement("smart-carousel");let o=e[i];a.shadowRoot&&(t._isInShadowDOM=!0),o="string"==typeof o?o.split(",").map((e=>e.trim())):[],t.dataSource=o,t.hideArrows=!0,t.unfocusable=!0,t.animation=a.animation,t.theme=a.theme,t.rightToLeft=a.rightToLeft,t.onIndexChange=function(e){a._cardSelectedCover[r[l.dataId].$.id]=e},t.whenReady((function(){t.hasStyleObserver=!1,t.$.arrowLeft.hasStyleObserver=!1,t.$.arrowRight.hasStyleObserver=!1})),l.appendChild(t)}return l.appendChild(o),l}_toggleCard(e,t,a){e.setAttribute("updating",""),this._collapsed[a]?(e.classList.add("collapsed"),t.firstElementChild.children[1].classList.add("collapsed"),t.children[1].classList.add("smart-visibility-hidden")):(e.classList.remove("collapsed"),t.firstElementChild.children[1].classList.remove("collapsed"),t.children[1].classList.remove("smart-visibility-hidden")),setTimeout((function(){e.removeAttribute("updating")}),100)}_createEmptyCard(e=!0){const t=this,a=t._createCard({});e&&a.classList.add("smart-hidden"),a.style.height=t._cardHeight+"px",t._cards.push(a),t.$.cardContainer.appendChild(a)}_applyTemplate(e,t,a,i){const r=this,l=r.columns,o=r.titleField;if(i){let i=r._cardContent;for(let t=0;t<l.length;t++){const a=l[t];if(!a.visible)continue;const o=a.dataField,s=new RegExp(`{{${o}}}`,"g"),n=r._formatValue(e[o],e,a);i=i.replace(s,n)}if(a.innerHTML=i.replace(/{{\w+}}/g,""),o){const i=r.id+"Title"+(e.$&&void 0!==e.$.id?e.$.id:"Empty"+Math.floor(1e3*Math.random()));a.firstElementChild.firstElementChild.id=i,t.setAttribute("aria-labelledby",i)}}else for(let t=0;t<l.length;t++){const i=l[t];if(!i.visible)continue;const s=i.dataField,n=a.querySelector(`[data-field="${s}"]`);if(n){const t=r._formatValue(e[s],e,i);s===o?n.firstElementChild.innerHTML=t:n.children[1].innerHTML=t}}}_formatValue(e,t,a){const i=this;if(0===Object.keys(t).length)return"";const r={column:a,record:t,template:a.template,value:e};if(a.formatFunction){const e=a.formatFunction(r);e&&e instanceof Promise&&e.then((e=>{const r=i.querySelector(`[aria-posinset="${1+t.$.id}"]`);if(r){const l=r.querySelector(`[data-field="${a.dataField}"]`);l&&e&&e.template&&(l.children[1].innerHTML=i._applyCellTemplate(e.template,e,t,a))}}))}if(e=r.value,r.template)return i._applyCellTemplate(r.template,e,t,a);if(a.formatSettings){let t="";return a.formatSettings.prefix&&(t+=a.formatSettings.prefix),a.formatSettings.formatString&&null!=e&&(e.constructor===Date?e=new Smart.Utilities.DateTime(e).toString(a.formatSettings.formatString):e instanceof Smart.Utilities.DateTime?e=e.toString(a.formatSettings.formatString):!isNaN(e)&&i._numericFormatter&&(e=i._numericFormatter.formatNumber(e,a.formatSettings.formatString))),t+=e,a.formatSettings.sufix&&(t+=a.formatSettings.sufix),t}return e}_applyCellTemplate(e,t="",a,i){let r="";if("function"==typeof e){const r={column:i,record:a,template:null,value:t};if(e(r),t=r.value,null===r.template)return t;e=r.template}if(e.startsWith("#")){const i=document.querySelector(e);if(i&&i instanceof HTMLTemplateElement){const e=i.content.cloneNode(!0),l=document.createElement("div");return l.appendChild(e),t=(t=(t=t.toString()).replace(/'/gi,"\\'")).replace(/"/gi,'\\"'),r=l.innerHTML.replace(/{{value}}/gi,t).replace(/{{id}}/gi,a.$.id),r.indexOf("{{value=")>=0&&(t?(r=r.substring(0,r.indexOf("{{value="))+t+r.substring(r.indexOf("}")),r=r.replace(/}/gi,""),r=r.replace(/{/gi,"")):(r=r.replace(/{{value=/gi,""),r=r.replace(/}}/gi,""))),r}}return r=e.replace(/{{value}}/gi,t).replace(/{{id}}/gi,a.$.id),r}_getCardsPerRow(){const e=this,t=e._cards;if(0===t.length)return void(e._cardsPerRow=0);let a=t[0].offsetTop,i=1;for(let e=1;e<t.length&&!(t[e].offsetTop>a);e++)i++;e._cardsPerRow=i}_onVerticalChange(e){const t=this;if(t._ignoreVerticalChange)return;const a=t._visibleSource,i=t.scrolling,r=t._cardHeight+t._gap,l=t._cardsPerRow;let o,s,n=e.detail.value;if(t._cards.length===a.length){const e=Math.floor(n/r)*l;return t._start={view:e,data:e},t._dataSourceProcessed&&t._refreshCardContent(),t.$.scrollViewer.$.scrollViewerContentContainer.style.top=-n+"px",void("infinite"===i&&t.$.scrollViewer.$.verticalScrollBar.value===t.$.scrollViewer.$.verticalScrollBar.max&&t._onScrollBottomReached(e,e))}if(clearTimeout(t._scrollingTimeout),t._numberOfCollapsedRows>0){const e=Math.floor((a.length-1)/l)+1;let i,d=0;o=l;for(let a=0;a<e;a++){const e=a,o=d;if(t._collapsedRows[e]?d+=r-t._cardContentHeight:d+=r,void 0===s&&n<=d){s=e*l,i=n-o;break}}n=i+r}else{for(n=n%(2*r)+r,n<r&&(n+=r);n+t.$.scrollViewer.$.scrollViewerContainer.offsetHeight>t.$.cardContainer.offsetHeight;)n-=r;o=Math.floor(n/r)*l,s=Math.floor(e.detail.value/r)*l,o<0&&(s-=o,o=0)}const d=Math.min(s+t._cards.length-o-1,a.length-1);if("virtual"===i&&(a[s].$.isEmpty||a[d].$.isEmpty)){const e=d-s;let i,r;for(let e=s;e<=d;e++)if(a[e].$.isEmpty){i=e,r=i;break}for(;a[r+1]&&a[r+1].$.isEmpty&&r-i<e;)r++;return t.setAttribute("loading",""),t.$.loadingIndicatorContainer.classList.remove("smart-hidden"),t.$.scrollViewer.$.scrollViewerContentContainer.style.top=-n+"px",void(t._scrollingTimeout=setTimeout((function(){t.dataSource.onVirtualDataSourceRequested(t._virtualDataSourceRequestedCallback.bind(t,o,s),{first:i,last:r,sorting:[],filtering:[],grouping:[],action:""})}),300))}t.$.scrollViewer.$.scrollViewerContentContainer.style.top=-n+"px",t._updateVisibleCards(o,s),"virtual"===i?(t.removeAttribute("loading"),t.$.loadingIndicatorContainer.classList.add("smart-hidden")):"infinite"===i&&t.$.scrollViewer.$.verticalScrollBar.value===t.$.scrollViewer.$.verticalScrollBar.max&&t._onScrollBottomReached(o,s)}_onScrollBottomReached(e,t){const a=this;a.$.loadingIndicatorContainer.classList.remove("smart-hidden");const i=a._visibleSource.boundSource.toArray();a.dataSource.onVirtualDataSourceRequested((function(){a._updateVisibleCards(e,t),a._visibleSource.insert(0,i);const r=Math.ceil(a._visibleSource.length/a._cardsPerRow),l=(a._cardHeight+a._gap)*r-a._gap,o=a.$.scrollViewer.$.scrollViewerContainer.offsetHeight;a.$.scrollViewer.$.verticalScrollBar.max=Math.max(0,l-o-a._numberOfCollapsedRows*a._cardContentHeight),a._scrollHeight=l,a.$.loadingIndicatorContainer.classList.add("smart-hidden")}),{first:1/0,last:1/0,sorting:[],filtering:[],grouping:[],action:""})}_updateVisibleCards(e,t,a){const i=this,r=t-e,l=i._visibleSource.length;for(let t=0;t<e;t++){const e=i._cards[t];e.setAttribute("aria-hidden",!0),e.classList.contains("collapsed")&&i._toggleCard(e,e.firstElementChild.lastElementChild)}let o=0;for(let t=e;t<i._cards.length;t++){const e=i._cards[t];let s=r+t;"virtual"===i.scrolling&&(s=o++),e.removeAttribute("aria-hidden"),s<i._visibleSource.length?(e.classList.remove("smart-hidden"),e.setAttribute("aria-setsize",l),e.setAttribute("aria-posinset",s+1),(e.dataId!==s||a||i._dataSourceProcessed)&&i._updateVirtualCard(e,s)):e.classList.add("smart-hidden")}i._start={view:e,data:t}}_toggleColumn(e,t,a){const i=this,r=i._visibleSource;if(!e||"string"!=typeof e||e===i.coverField||e===i.titleField||!r||0===r.length)return;const l=i.columns.find((t=>t.dataField===e));l&&(i._close(),i._changedVisibility=new Map,i._changedVisibility.set(l,t),i._updateColumnsVisibility(void 0,a))}_updateVirtualCard(e,t){const a=this,i=a._visibleSource[t],r=i.$.id,l=e.firstElementChild.lastElementChild,o=a.coverField;if(e.dataId=t,a._applyTemplate(i,e,l),e.firstElementChild.scrollTop=a._cardScrolling[r]||0,a._dragDetails&&(e.dataId===a._dragDetails.index?e.classList.add("dragged"):e.classList.remove("dragged")),a._searchInfo&&(a._searchInfo.foundIdsObject[r]?(e.classList.add("smart-data-view-found"),a._searchInfo.highlighted===r?e.classList.add("smart-data-view-highlighted"):e.classList.remove("smart-data-view-highlighted")):e.classList.remove("smart-data-view-found","smart-data-view-highlighted")),a._toggleCard(e,l,r),o){const t=e.firstElementChild.firstElementChild;let l=i[o];if(l="string"==typeof l?l.split(",").map((e=>e.trim())):[],t.set("dataSource",l),l.length>0){const e=a._cardSelectedCover[r]||0;t._generateIndicators(),t._indicators[e].classList.add("smart-active"),t._generateItems(),t._items[e].classList.add("smart-active"),t._currentIndex=e}}}_updateCardHeight(e){const t=this,a=t._cards;if(null===e){let e=0,i=[];if(t._autoCardHeight=!0,0===t._cards.length)return;if(a.forEach((e=>{e.style.height=null,e.classList.contains("collapsed")&&(e.setAttribute("updating",""),e.classList.remove("collapsed"),e.getElementsByClassName("smart-card-view-content")[0].classList.remove("smart-visibility-hidden"),i.push(e))})),a.forEach((t=>e=Math.max(t.offsetHeight,e))),a.forEach((t=>t.style.height=e+"px")),t._cardContentHeight=t._cards[0].getElementsByClassName("smart-card-view-content")[0].offsetHeight+t._verticalOffset,i.length>0&&(i.forEach((e=>{e.classList.add("collapsed"),e.getElementsByClassName("smart-card-view-content")[0].classList.add("smart-visibility-hidden")})),setTimeout((function(){i.forEach((e=>e.removeAttribute("updating")))}),100)),t._cardHeight===e)return;t._cardHeight=e}else{const i=t._cards[0];let r;if(t._autoCardHeight=!1,t._cardHeight===e)return;if(t._cardHeight=e,!i)return;a.forEach((t=>t.style.height=e+"px")),i.classList.contains("collapsed")&&(i.setAttribute("updating",""),i.classList.remove("collapsed"),i.getElementsByClassName("smart-card-view-content")[0].classList.remove("smart-visibility-hidden"),r=!0),t._cardContentHeight=t._cards[0].getElementsByClassName("smart-card-view-content")[0].offsetHeight+t._verticalOffset,r&&(i.classList.add("collapsed"),i.getElementsByClassName("smart-card-view-content")[0].classList.add("smart-visibility-hidden"),setTimeout((function(){i.removeAttribute("updating")}),100))}t._partialRefresh()}_partialRefresh(){const e=this;if(e._refreshedAtDimensions={width:e._cachedWidth,height:e._cachedHeight},e._cards.length===e._visibleSource.length)return e._dataSourceProcessed&&e._refreshCardContent(),void e.$.scrollViewer.refresh();e._getCardsPerRow();const t=e.$.scrollViewer.$.scrollViewerContainer.offsetHeight,a=e._cardHeight+e._gap,i=Object.keys(e._collapsed).length;let r=e._cardsPerRow;function l(){let l=(t+2*a)/a*r;for(l=l-l%r+r;i>0&&l*(a-e._cardContentHeight)<t+2*a;)l++;for(l=Math.min(l,e._visibleSource.length);e._cards.length<l;)e._createEmptyCard(!1);for(;e._cards.length>l;)e._cards[e._cards.length-1].remove(),e._cards.pop();for(;"infinite"===e.scrolling&&e._cards.length%r!=0;)e._createEmptyCard()}l(),e._getCardsPerRow(),r!==e._cardsPerRow&&(r=e._cardsPerRow,l()),e._getNumberOfCollapsedRows();const o=e._getFractionOfMax(),s=Math.ceil(e._visibleSource.length/e._cardsPerRow),n=a*s-e._gap,d=Math.max(0,n-t-e._numberOfCollapsedRows*e._cardContentHeight);e.$.scrollViewer.$.verticalScrollBar.max=d,e._scrollHeight=n,0===d&&e.$.scrollViewer.refresh(),e._setFractionOfMax(o)}_getFractionOfMax(){const e=this.$.scrollViewer.$.verticalScrollBar;return 0===e.max?0:e.value/e.max}_setFractionOfMax(e){const t=this.$.scrollViewer.$.verticalScrollBar,a=t.max*e;t.value=a,this._onVerticalChange({detail:{value:a}})}_refreshCardContent(){const e=this;e._updateVisibleCards(e._start.view,e._start.data,!0)}_getVisibleRecords(){const e=this,t=e.dataSource;if(0===e._appliedFiltering.filters.length)e._visibleSource=t;else{e._visibleSource=[];for(let a=0;a<t.length;a++){const t=e.dataSource[a];!1!==t.$.filtered&&(e._visibleSource.push(t),e._visibleSource[e._visibleSource.length-1]._id=t.$.id)}}t&&0!==t.length?(e.removeAttribute("empty"),0===e._visibleSource.length?e.setAttribute("no-matches",""):e.removeAttribute("no-matches")):(e.setAttribute("empty",""),e.removeAttribute("no-matches"))}_search(e,t=!0){const a=this;if(a._searchInfo.query=e,a._cards.forEach((e=>e.classList.remove("smart-data-view-found","smart-data-view-highlighted"))),""===e)return a.$.search.classList.remove("matches","no-matches"),delete a._searchInfo.foundIdsArray,delete a._searchInfo.foundIdsObject,void delete a._searchInfo.highlighted;const i=a._searchInfo.source,r=[],l=[],o={};a._searchInfo.stringDataFields.forEach((t=>{const a=new Smart.Utilities.FilterGroup,i=a.createFilter("string",e,"CONTAINS");a.addFilter("or",i),r.push([t,a])})),i._filter(r,"or");for(let e=0;e<i.length;e++){const t=i[e];!1!==t.$.filtered&&(l.push(t.$.id),o[t.$.id]=!0)}let s=l[0];if(a._searchInfo.foundIdsArray=l,a._searchInfo.foundIdsObject=o,l.length>0)return t&&(a._searchInfo.highlighted=s,a.ensureVisible(s)),a._cards.forEach((e=>{const i=a._visibleSource[e.dataId].$.id;o[i]&&(t&&s===i&&e.classList.add("smart-data-view-highlighted"),e.classList.add("smart-data-view-found"))})),a.$.search.classList.remove("no-matches"),a.$.search.classList.add("matches"),void(a.$.searchLabel.innerHTML=a.localize("found",{nth:t?1:0,n:l.length}));a.$.search.classList.remove("matches"),a.$.search.classList.add("no-matches"),a.$.searchLabel.innerHTML=a.localize("found",{nth:0,n:0})}_closeSearchPanel(){const e=this;e._searchInfo&&(e._cards.forEach((e=>e.classList.remove("smart-data-view-found","smart-data-view-highlighted"))),delete e._searchInfo)}_cardContainerDownHandler(e){const t=this;if(delete t._clickToDrag,!t.allowDrag||!t._isMobile&&0!==e.button)return;const a=e.originalEvent.target;if(a.closest(".smart-indicator")||a.closest(".smart-arrow-up"))return void(t._isMobile&&(t.$.scrollViewer._scrollView.disableSwipeScroll=!0));const i=e.originalEvent.target.closest("smart-card");i&&(t._dragDetails={card:i,coords:{x:e.pageX,y:e.pageY},index:i.dataId,originalEvent:e,record:t._visibleSource[i.dataId],startTime:new Date},t.$.scrollViewer._scrollView.disableSwipeScroll=!0,window.getSelection().removeAllRanges())}_documentMoveHandler(e){const t=this,a=t._dragDetails;if(!a)return;if(!a.feedbackShown){const i=(new Date).getTime()-a.startTime.getTime()>500,r=Math.abs(a.coords.x-e.pageX)>5||Math.abs(a.coords.y-e.pageY)>5;if(!r||!(!t._isMobile||t._isMobile&&i))return void(t._isMobile&&r&&!i&&(delete t._dragDetails,t.$.scrollViewer._scrollView.disableSwipeScroll=!1));if(!t._startDragging(e))return}const i=a.card,r=a.record,l=e.clientY,o=e.clientX;let s=e.originalEvent.target;if(t.$.fireEvent("dragging",{card:i,originalEvent:e,record:r}),a.feedback.style.left=e.pageX+10+"px",a.feedback.style.top=e.pageY+10+"px",t._isMobile){const e=document.elementFromPoint(o,l);e&&(s=e)}clearInterval(t._dragInterval),t._dragInterval=setInterval((function(){const e=t.$.scrollViewer.getBoundingClientRect();t.$.scrollViewer.scrollHeight>0&&e.left<=o&&e.left+e.width>=o?l>=e.top&&l<=e.top+36?t.$.scrollViewer.scrollTop-=t._autoScrollCoefficient:l>=e.top+e.height-36&&l<=e.top+e.height?t.$.scrollViewer.scrollTop+=t._autoScrollCoefficient:clearInterval(t._dragInterval):clearInterval(t._dragInterval)}),2);let n,d=s.closest("smart-card");if(a.hoveredCard&&(a.hoveredCard.classList.remove("drop-target","left","right"),delete a.hoveredCard),!d||d.dataId!==a.index){if(d){const e=d.getBoundingClientRect(),t=Math.abs(o-e.left),a=Math.abs(o-e.right);n=t<a?"left":"right"}else{if(s===t.$.addNewButton)return;{let e,i;if(t._cards.forEach((t=>{const a=t.getBoundingClientRect(),r=Math.abs(l-a.top),s=Math.abs(l-a.bottom),d=Math.min(r,s),c=Math.abs(o-a.left),u=Math.abs(o-a.right),h=Math.min(c,u),m=Math.sqrt(Math.pow(h,2)+Math.pow(d,2));(void 0===i||m<i)&&(e=t,i=m,n=c<u?"left":"right")})),d=e,d.dataId===a.index)return}}d&&(d.classList.add(n,"drop-target"),a.hoveredCard=d,a.side=n)}}_startDragging(e){const t=this,a=t._dragDetails,i=a.card,r=a.record;return t.$.fireEvent("dragStart",{card:i,originalEvent:e,record:r}).defaultPrevented?(delete t._dragDetails,t.$.scrollViewer._scrollView.disableSwipeScroll=!1,!1):(a.feedback=t._addDragFeedback(r),a.feedbackShown=!0,t.setAttribute("dragging",""),i.classList.add("dragged"),t.closePanel(),t._clickToDrag=!0,!0)}_addDragFeedback(e){const t=this,a=document.createElement("div");let i="";return a.className="smart-card-view-drag-feedback",t.theme&&a.setAttribute("theme",t.theme),t.coverField&&(i+=`<div class="drag-feedback-thumbnail" style="background-image: url('${e[t.coverField].split(",")[0].trim()}');"></div>`),t.titleField?i+=`<div class="drag-feedback-label">${e[t.titleField]}</div>`:t.coverField||(i+=`<div class="drag-feedback-label">${t.localize("draggedRecord",{id:e.$.id})}</div>`),a.innerHTML=i,t.rightToLeft&&a.setAttribute("right-to-left",""),document.body.appendChild(a),a}_documentUpHandler(e){const t=this,a=t._dragDetails;if(t.$.scrollViewer._scrollView.disableSwipeScroll=!1,!a){let a=e.originalEvent.target;const i=t.$.header;if(t.shadowRoot&&a===t&&(a=e.originalEvent.composedPath()[0]),!("none"===t.headerPosition||t.$.headerDropDown.classList.contains("smart-visibility-hidden")||t.$.headerDropDown.classList.contains("search-panel")||a!==i&&i.contains(a))){const e=a.closest("smart-scroll-viewer"),r=a.closest(".smart-drop-down");e&&i.contains(e.ownerElement)||r&&(!r.ownerElement||i.contains(r.ownerElement))||t.closePanel()}return}const i=a.card,r=a.record,l=a.hoveredCard;if(delete t._dragDetails,!t.hasAttribute("dragging"))return;const o=t.$.cardContainer.getElementsByClassName("dragged");if(Array.from(o).forEach((e=>e.classList.remove("dragged"))),t.removeAttribute("dragging"),a.feedback.remove(),clearInterval(t._dragInterval),window.getSelection().removeAllRanges(),!l)return void t.$.fireEvent("dragEnd",{card:i,originalEvent:e,record:r});const s=t._visibleSource[l.dataId],n=t.$.fireEvent("dragEnd",{card:i,originalEvent:e,record:r,targetCard:l,targetRecord:s,targetSide:a.side});if(l.classList.remove("drop-target","left","right"),n.defaultPrevented)return;const d=t.dataSource;let c,u;for(let e=0;e<d.length;e++){const t=d[e];if(!t.$.isEmpty&&(t===r?c=e:t===s&&(u=e),void 0!==c&&void 0!==u))break}(!t.rightToLeft&&"right"===a.side||t.rightToLeft&&"left"===a.side)&&u++,d.move(c,u),t._getVisibleRecords(),t._dataSourceProcessed=!0,t._partialRefresh(),delete t._dataSourceProcessed}_scrollViewerTouchmoveHandler(e){this._dragDetails&&e.cancelable&&(e.preventDefault(),e.stopPropagation())}_applyFilter(e,t){const a=this;if(a.dataSource&&a.dataSource.virtualDataSource)a._requestVirtualDataSource("filter");else{try{a.dataSource._filter(e,t)}catch(e){return}a._getVisibleRecords(),a._fullRefresh()}}_applySort(){const e=this,t=e._appliedSorting;e.dataSource&&e.dataSource.virtualDataSource?e._requestVirtualDataSource("sort"):(e.dataSource.sortBy(t.dataFields,t.dataTypes,t.orderBy),e._getVisibleRecords(),e._refreshCardContent())}_requestVirtualDataSource(e,t,a){const i=this,r=[],l=[],o={},s=i._appliedFiltering;let n=null;if(i._closeSearchPanel(),i.setAttribute("loading",""),i.$.loadingIndicatorContainer.classList.remove("smart-hidden"),s&&s.filterGroups.length>0&&(s.filterGroups.forEach((e=>l[e[0]]=e[1])),l.length=s.filterGroups.length,n=s.operator),i._appliedSorting&&i._appliedSorting.dataFields.length>0&&(i._appliedSorting.dataFields.forEach(((e,t)=>{let a=i._appliedSorting.orderBy[t].replace("ending","");r[e]={sortOrder:a,sortIndex:t}})),r.length=i._appliedSorting.dataFields.length),void 0!==t){const e=Object.assign({},t);i.columns.forEach((function(t){e[t.dataField]instanceof Date&&(e[t.dataField]=e[t.dataField].toISOString().slice(0,10))})),o.row=e}i.dataSource.onVirtualDataSourceRequested((function(t){let r=!0;-1!==["add","update","remove"].indexOf(e)&&a&&(r=a(t.result)),i.$.loadingIndicatorContainer.classList.add("smart-hidden"),i.removeAttribute("loading"),r&&i._fullRefresh(!0,!0)}),{first:0,last:0,sorting:r,filtering:l,filterOperator:n,grouping:[],edit:o,action:e})}});