
/* Smart UI v15.2.0 (2023-04-20) 
Copyright (c) 2011-2023 jQWidgets. 
License: https://htmlelements.com/license/ */ //

Smart("smart-color-panel",class extends Smart.BaseElement{static get properties(){return{applyValueMode:{value:"instantly",allowedValues:["instantly","useButtons"],type:"string"},columnCount:{value:8,type:"number?"},displayMode:{value:"default",allowedValues:["default","grid","palette","radial","hexagonal","spectrumGrid","materialGrid"],type:"string"},disableUndo:{value:!1,type:"boolean"},editAlphaChannel:{value:!1,type:"boolean"},enableCustomColors:{value:!1,type:"boolean"},gridThemeColors:{value:null,type:"array?",reflectToAttribute:!1},gridShadeColors:{value:null,type:"array?",reflectToAttribute:!1},gridStandardColors:{value:null,type:"array?",reflectToAttribute:!1},hideAlphaEditor:{value:!1,type:"boolean"},hideContentToFit:{value:["RGB","HEX","alpha","previewContainer"],type:"array"},hideHEXEditor:{value:!1,type:"boolean"},hidePreviewContainer:{value:!1,type:"boolean"},hideRGBEditor:{value:!1,type:"boolean"},inverted:{value:!1,type:"boolean"},messages:{value:{en:{redPrefix:"R:",greenPrefix:"G:",bluePrefix:"B:",hexPrefix:"#:",alphaPrefix:"Alpha:",ok:"OK",cancel:"CANCEL",customColor:"CUSTOM COLOR",standardColors:"Standard colors",themeColors:"Theme colors"}},type:"object",extend:!0},name:{value:"",type:"string"},palette:{value:"default",allowedValues:["default","gray","red","green","blue","custom"],type:"string"},paletteColors:{value:null,type:"array?",reflectToAttribute:!1},paletteCustomColors:{value:null,type:"array?",reflectToAttribute:!1},tooltipDisplayMode:{value:"hex",allowedValues:["none","rgba","rgb","hex"],type:"string"},value:{value:null,type:"string?"},valueFormat:{value:"default",allowedValues:["rgb","rgba","hex","default"],type:"string"},valueMember:{value:"value",type:"string?"}}}static get listeners(){return{"container.click":"_containerClickHandler","container.mouseover":"_handleGridModeCellHover","paletteModeContainer.down":"_paletteDownHandler","container.change":"_handleInputChange","document.move":"_moveThumbHandler","document.up":"_releaseThumbUpHandler","paletteModeContainer.wheel":"_inputWheelHandler",resize:"_hideControlsByPriority","hexModeResizeTrigger.resize":"_resizeHoneycombItems","paletteModeContainer.move":"_paletteModeContainerMoveHandler"}}static get requires(){return{"Smart.Utilities.Draw":"smart.draw.js","Smart.Button":"smart.button.js","Smart.Tooltip":"smart.tooltip.js"}}static get styleUrls(){return["smart.button.css","smart.tooltip.css","smart.colorpanel.css"]}template(){return'<div id="container" role="presentation">\n                    <div id="gridModeContainer" class="grid-mode-container" role="presentation"></div>\n                    <div id="paletteModeContainer" class="palette-mode-container" role="presentation">\n                        <div id="colorPaletteContainer" class="color-palette-container" role="presentation">\n                            <div id="colorPalette" class="color-palette no-touch" aria-label="Color palette">\n                                <div id="colorPaletteThumb" class="color-palette-thumb" role="presentation"></div>\n                            </div>\n                            <div id="hueScale" class="hue-scale no-touch" aria-label="Hue scale" role="slider" aria-valuemin="0" aria-valuemax="360">\n                                <div id="hueScaleThumb" class="hue-scale-thumb" role="presentation"></div>\n                            </div>\n                            <div id="colorPaletteRadial" class="color-palette-radial no-touch" aria-label="Radial color palette">\n                                <span class="white-radial-gradient" role="presentation"></span>\n                                <div id="colorPaletteRadialThumb" class="color-palette-radial-thumb" role="presentation"></div>\n                            </div>\n                            <div id="colorPaletteHexagonal" class="color-palette-hexagonal" aria-label="Hexagonal color palette"></div>\n                            <div id="brightnessScale" class="brightness-scale no-touch" aria-label="Brightness scale" role="slider" aria-valuemin="0" aria-valuemax="1">\n                                <div id="brightnessScaleThumb" class="brightness-scale-thumb" role="presentation"></div>\n                            </div>\n                            <span id="hexModeResizeTrigger" class="color-sample hex-mode-resize-trigger"></span>\n                            <div id="colorControlsContainer" class="color-controls-container" role="presentation"></div>\n                        </div>\n                        <div id="alphaChannelContainer" class="alpha-channel-container"></div>\n                    </div>\n                    <div id="buttonsContainer" class="buttons-container"></div>\n                    <input id="hiddenInput" type="hidden" name="[[name]]">\n                </div>'}propertyChangedHandler(e,a,t){const l=this;switch(e){case"applyValueMode":"instantly"!==t||l.value||(l._HSV={h:0,s:0,v:1},l._selectedItem&&l._selectedItem.classList.contains("selected")&&(l._selectedItem.classList.remove("selected"),l._selectedItem.removeAttribute("aria-current"),l._selectedItem.style.stroke=null)),"palette"!==l.displayMode&&"radial"!==l.displayMode&&"hexagonal"!==l.displayMode||l._handleCancelButtonClick(),"useButtons"===t&&l._createApplyValueButtons();break;case"paletteColors":l._customPalette=l._mapDataSourceToPalette(),r(l.displayMode);break;case"inverted":{if(-1===["hexagonal","radial","spectrumGrid"].indexOf(l.displayMode))return;const e=l.value,a=l.$.hueScaleThumb.offsetHeight,o=l._validateInRange(a/2,0,l.$.hueScale.offsetHeight-a)/l.$.brightnessScale.offsetHeight;if(isNaN(o))return void l._generateGridStructures();t?(l._HSV.v=l._HSV.s,l._HSV.s=1-o):(l._HSV.s=l._HSV.v,l._HSV.v=1-o),l.value=l._HSVtoRGBA(l._HSV),l.$.colorPaletteRadial.style.setProperty("--smart-color-panel-brightness",l.$.brightnessScaleThumb.s||0),r(l.displayMode),l.value!==e&&l.$.fireEvent("change",{oldValue:e,value:l.value});break}case"palette":r(l.displayMode),l._updatePreviewContainerValues(l.value);break;case"displayMode":case"gridThemeColors":case"gridShadeColors":case"gridStandardColors":if("displayMode"===e){const e=l.value;if(l.$.container.className.indexOf("custom-color-selection")>-1&&l._handleCancelButtonClick(),null!==l.value&&"palette"!==t&&"hexagonal"!==t&&"radial"!==t){!l.editAlphaChannel&&l.$.alphaChannelThumb&&(l.$.alphaChannelThumb.style[l.rightToLeft?"left":"right"]="",l.$.alphaChannelThumb.style[l.rightToLeft?"right":"left"]=0,l.$.alphaChannelThumb.a=l._RGBA.a=1,l.$.alphaChannelScale.setAttribute("aria-valuenow",1)),l.value=l._getValue(l.valueFormat),r(),l.$.fireEvent("change",{oldValue:e,value:l.value});break}if(null===l.value&&("palette"===t||"hexagonal"===t||"radial"===t)){l._RGBA={r:255,g:255,b:255,a:1},l._HSV={h:0,s:0,v:1},l.value=l._getValue(l.valueFormat),r(),l.$.fireEvent("change",{oldValue:e,value:l.value});break}if(l.value=l._getValue(l.valueFormat),Smart.Utilities.Core.Browser.Firefox&&"radial"===a){const e=l.$.colorPaletteRadial.querySelector("canvas");e&&e.remove()}}r(l.displayMode);break;case"locale":case"messages":l._localizeLabels();break;case"paletteCustomColors":l._userPalette=t||[],(l.displayMode.toLowerCase().indexOf("grid")>-1||"default"===l.displayMode)&&l._generatePaletteUserColorGrid(!0);break;case"editAlphaChannel":{if(!t&&(l._RGBA.a=1),t&&l._createAlphaChannel(),!l.value)return;const e=l.value;l.value=l._getValue(l.valueFormat),l.value!==e&&l.$.fireEvent("change",{oldValue:e,value:l.value});break}case"value":if(t="string"==typeof t?t.trim():t,!l._isValidColor(t))return void l._reset();l._applyValue(t),l.value=l._getValue(l.valueFormat),"hexagonal"===l.displayMode&&l._generateHoneycomb(l.columnCount,l.inverted?{s:l._HSV.s}:{v:l._HSV.v}),a!==l.value&&l.$.fireEvent("change",{oldValue:a,value:l.value});break;case"columnCount":{const e=l.$.container.style;null===t||isNaN(t)?e.removeProperty("--smart-color-panel-grid-mode-column-count"):e.setProperty("--smart-color-panel-grid-mode-column-count",t),l._generatePaletteUserColorGrid(),"spectrumGrid"===l.displayMode?l._generateSpectrumGrid(parseInt(t)):"hexagonal"===l.displayMode&&l._generateHoneycomb(t,l._HSV)}break;case"valueFormat":{if(!l.value)return;const e=l.value;l.value=l._getValue(t),l.$.fireEvent("change",{oldValue:e,value:l.value});break}case"tooltipDisplayMode":if(!l.$.tooltip)return;"none"===t?(l.$.tooltip.close(),l.$.tooltip.disabled=!0):l.$.tooltip.disabled=!1;break;default:if(super.propertyChangedHandler(e,a,t),"disabled"===e){const a=l.getElementsByClassName("color-input");for(let t=0;t<a.length;t++)a[t][e]}"disabled"!==e&&"theme"!==e&&"animation"!==e||(l.$.buttonOk&&(l.$.buttonOk[e]=t),l.$.buttonCancel&&(l.$.buttonCancel[e]=t),l.$.buttonCustom&&(l.$.buttonCustom[e]=t),l.$.tooltip&&(l.$.tooltip[e]=t))}function r(){l._generateGridStructures(),l._applyValue(l.value)}}ready(){super.ready()}render(){const e=this;e.setAttribute("role","dialog"),e._initializeBaseVars(),null===e.columnCount||isNaN(e.columnCount)?e.$.container.style.removeProperty("--smart-color-panel-grid-mode-column-count"):e.$.container.style.setProperty("--smart-color-panel-grid-mode-column-count",e.columnCount),"useButtons"===e.applyValueMode&&e._createApplyValueButtons(),e.editAlphaChannel&&e._createAlphaChannel(),e._generateGridStructures(),e._localizeLabels(),e.value||"hexagonal"!==e.displayMode&&"radial"!==e.displayMode&&"palette"!==e.displayMode||(e.value=e._getValue(e.valueFormat)),e._applyValue(e.value),e._hideControlsByPriority(),e.enableShadowDOM&&e.appendChild(e.$.hiddenInput),super.render()}_createApplyValueButtons(e){const a=this;function t(e){let t=document.createElement("smart-button");return t.classList.add(e),t.classList.add("primary"),t.rightToLeft=a.rightToLeft,t.disabled=a.disabled,t.theme=a.theme,t.animation=a.animation,a.$.buttonsContainer.appendChild(t),t}(e||"useButtons"===a.applyValueMode)&&(a.$.buttonsContainer.innerHTML.trim()||(a.$.buttonOk=t("button-ok"),a.$.buttonCancel=t("button-cancel"),a.$.buttonOk.content=a.localize("ok"),a.$.buttonCancel.content=a.localize("cancel")))}_createAlphaChannel(){const e=this;!e.editAlphaChannel||e.editAlphaChannel&&e.$.alphaChannelContainer.innerHTML.trim()||(e.$.alphaChannelContainer.innerHTML=`\n                            <div class="alpha-channel-scale no-touch" aria-label="Alpha channel scale" role="slider">\n                                <div class="alpha-channel-thumb" aria-hidden="true"></div>\n                            </div>\n                            <label for="${e.id}aChannelInput" class="a-channel"></label>\n                            <input type="number" step="0.01" id="${e.id}aChannelInput" class="color-input a-channel" value="1" min="0" max="1">`,e.$.alphaChannelScale=e.$.alphaChannelContainer.querySelector(".alpha-channel-scale"),e.$.alphaChannelThumb=e.$.alphaChannelContainer.querySelector(".alpha-channel-thumb"),e.$.alphaChannelScale.setAttribute("role","slider"),e.$.alphaChannelScale.setAttribute("aria-valuemin",0),e.$.alphaChannelScale.setAttribute("aria-valuemin",1),e.$.alphaChannelContainer.querySelector("input").disabled=e.disabled,e._localizeLabels(),e._applyAlphaValue(e._RGBA.a,"alphaScale"))}_createGridModeComponents(){const e=this,a=e.id;if(["radial","palette","hexagonal"].indexOf(e.displayMode)>-1)return!1;if(e.$.gridModeContainer.innerHTML.trim())return;const t=e.$.gridModeContainer;t.innerHTML=`\n                        <div id="${a}defaultSamplesContainer" class="default-samples-container"></div>\n                        <div id="${a}gridSamplesContainer" class="grid-samples-container"></div>\n                        <div id="${a}materialGridSamplesContainer" class="material-grid-samples-container" role="menu"></div>\n                        <div id="${a}spectrumGridSamplesContainer" class="spectrum-grid-samples-container"></div>\n                        <smart-button id="${a}buttonCustom" class="button-custom-color primary"></smart-button>\n                        <div id="${a}userSamplesContainer" class="user-samples-container" aria-label="User colors"></div>\n                        <smart-tooltip id="${a}tooltip" arrow position="auto"></smart-tooltip>`,e.$.defaultSamplesContainer=t.querySelector(".default-samples-container"),e.$.gridSamplesContainer=t.querySelector(".grid-samples-container"),e.$.materialGridSamplesContainer=t.querySelector(".material-grid-samples-container"),e.$.materialGridSamplesContainer.$=Smart.Utilities.Extend(e.$.materialGridSamplesContainer),e.$.spectrumGridSamplesContainer=t.querySelector(".spectrum-grid-samples-container"),e.$.userSamplesContainer=t.querySelector(".user-samples-container"),e.$.buttonCustom=t.querySelector("smart-button"),e.$.tooltip=t.querySelector("smart-tooltip"),e.$.buttonCustom.disabled=e.disabled,e.$.buttonCustom.rightToLeft=e.rightToLeft,e.$.buttonCustom.animation=e.animation,e.$.buttonCustom.theme=e.theme,e.$.buttonCustom.content=e.localize("customColor"),e.$.tooltip.disabled=e.disabled||"none"===e.tooltipDisplayMode,e.$.tooltip.rightToLeft=e.rightToLeft,e.$.tooltip.animation=e.animation,e.$.tooltip.theme=e.theme}_createColorControls(e){const a=this,t=a.id;if(!e&&["radial","palette","hexagonal"].indexOf(a.displayMode)<0)return!1;const l=a.$.colorControlsContainer;if(l.innerHTML.trim())return;l.innerHTML=`<div id="${t}previewContainer" class="preview-container gradient-background" aria-label="Preview"><span class="preview-container-top" aria-label="Current color"></span><span class="preview-container-bottom" aria-label="New color"></span></div><label for="${t}rChannelInput" id="${t}rChannelLabel" class="r-channel"></label><input type="number" min="0" max="255" id="${t}rChannelInput" class="color-input r-channel" value="255"><label for="${t}gChannelInput" id="${t}gChannelLabel" class="g-channel"></label><input type="number" min="0" max="255" id="${t}gChannelInput" class="color-input g-channel" value="255"><label for="${t}bChannelInput" id="${t}bChannelLabel" class="b-channel"></label><input type="number" min="0" max="255" id="${t}bChannelInput" class="color-input b-channel" value="255"><label for="${t}hexInput" id="${t}hexLabel" class="hex"></label><input type="text" id="${t}hexInput" class="color-input hex" value="FFFFFF" maxlength="6">`;const r=l.getElementsByClassName("color-input");for(let e=0;e<r.length;e++)r[e].disabled=a.disabled;a._localizeLabels()}_containerClickHandler(e){const a=this;if(a.disabled||a.readonly||!e.target)return;if(e.target.classList.contains("color-sample"))return void a._handleSampleClick(e);const t=e.target.closest("smart-button");if(t!==a.$.buttonCancel)return t===a.$.buttonCustom?(a.$container.addClass("custom-color-selection"),a._createApplyValueButtons(!0),a._createColorControls(!0),a._applyValueInPaletteMode(),a._customColorSelection=!0,1===a._RGBA.a&&a.$.alphaChannelThumb&&(a.$.alphaChannelThumb.style[a.rightToLeft?"left":"right"]="",a.$.alphaChannelThumb.style[a.rightToLeft?"right":"left"]=0,a.$.alphaChannelThumb.a=a._RGBA.a,a.$.alphaChannelScale.setAttribute("aria-valuenow",a._RGBA.a)),void a.$.fireEvent("customColorSelection",{value:!0})):void(t!==a.$.buttonOk?e.target!==(a.shadowRoot||a).querySelector(".preview-container-top")||"useButtons"!==a.applyValueMode||a.disableUndo||a._applyValue(a.value):a._handleOkButtonClick(!0));a._handleCancelButtonClick(!0)}_reset(e=this.value){const a=this;a._RGBA={r:255,g:255,b:255,a:1},a._HSV={h:0,s:0,v:1},a.$.hueScaleThumb.h=0,a.$.colorPaletteThumb.s=0,a.$.colorPaletteThumb.v=1,a.$.colorPaletteRadialThumb.h=0,a.$.colorPaletteRadialThumb.s=0,a.$.brightnessScaleThumb.v=1,a.$.brightnessScaleThumb.s=0,"hexagonal"!==a.displayMode&&"radial"!==a.displayMode&&"palette"!==a.displayMode?(a.value=null,a._selectedItem&&a._selectedItem.classList.contains("selected")&&(a._selectedItem.classList.remove("selected"),a._selectedItem.removeAttribute("aria-current"),a._selectedItem.style.stroke=null)):a.value=a._getValue(a.valueFormat),a._applyValue(a.value),a.$.fireEvent("change",{oldValue:e,value:a.value})}_handleColorPaletteDown(e){const a=this,t=a._getXYcoordinates(e);if(!t)return;const l="palette"===a.displayMode||"grid"===a.displayMode?a.$.colorPaletteThumb:a.$.colorPaletteRadialThumb;if(a._activeComponent=t.container,"palette"===a.displayMode||a.$.container.className.indexOf("custom-color-selection")>-1){if(l.s=a._HSV.s=t.x/t.container.offsetWidth,l.v=a._HSV.v=1-t.y/t.container.offsetHeight,"grid"===a.displayMode)return a._moveThumbHandler(e,!0),void a._applyValueInPaletteMode(e)}else if("radial"===a.displayMode){const e=a.$.colorPaletteRadial.offsetWidth,r=t.x-e/2,o=t.y-e/2;l.h=a._HSV.h=a._calcHueAngle(r,o)<0?360+a._calcHueAngle(r,o):a._calcHueAngle(r,o);const n=a.$.brightnessScaleThumb,s=a.$.brightnessScale,i=a._validateInRange(2*a._calcSatDistance(r,o)/e,0,1),d=s.offsetHeight-n.offsetHeight,c=a._validateInRange(n.offsetTop,0,d)/d;a.inverted?(l.v=a._HSV.v=i,l.s=a._HSV.s=1-c):(l.s=a._HSV.s=i,l.v=a._HSV.v=1-c)}a._applyValue(a._HSVtoRGBA(a._HSV),e),a._instantUpdate()}_handleScalesDown(e){const a=this,t=a._getXYcoordinates(e);t&&(a._activeComponent=t.container,t.container===a.$.hueScale?a._updateHueScale(t):t.container===a.$.brightnessScale?(a._updateBrightnessScale(t),"hexagonal"===a.displayMode&&a._generateHoneycomb(a.columnCount,a._HSV)):a.$.alphaChannelScale&&(a.$.alphaChannelThumb.a=a._RGBA.a=parseFloat(((t.container.offsetWidth-t.x)/t.container.offsetWidth).toFixed(2)),a.rightToLeft&&(a.$.alphaChannelThumb.a=a._RGBA.a=(1-a._RGBA.a).toFixed(2)),a._applyAlphaValue(a._RGBA.a,"alphaScale")),a._applyValue(a._HSVtoRGBA(a._HSV),e),a._instantUpdate())}_updateBrightnessScale(e){const a=this,t=e.y-a.$.brightnessScaleThumb.offsetHeight/2,l=a.$.brightnessScale.offsetHeight-a.$.brightnessScaleThumb.offsetHeight,r=Math.min(Math.max(parseFloat(t),0),parseFloat(l))/l;a.inverted?a.$.brightnessScaleThumb.s=a._HSV.s=1-r:a.$.brightnessScaleThumb.v=a._HSV.v=1-r,a.$.brightnessScale.setAttribute("aria-valuenow",a._HSV.v),a.$.brightnessScaleThumb.style.top=l*r+"px",a.$.colorPaletteRadial.style.setProperty("--smart-color-panel-brightness",r)}_updateHueScale(e){const a=this,t=e.y-a.$.hueScaleThumb.offsetHeight/2,l=a.$.hueScale.offsetHeight,r=l-a.$.hueScaleThumb.offsetHeight;a.$.hueScaleThumb.h=a._HSV.h=360*(l-e.y)/l,a.$.hueScale.setAttribute("aria-valuenow",a.$.hueScaleThumb.h),a.$.hueScaleThumb.style.top=r*Math.min(Math.max(parseFloat(t),0),parseFloat(r))/r+"px"}_paletteModeContainerMoveHandler(e){Smart.Utilities.Core.isMobile||e.stopPropagation(),"touchmove"===e.originalEvent.type&&this._dragDetails&&e.originalEvent.preventDefault()}_moveThumbHandler(e,a){const t=this,l=e.pageX-window.pageXOffset,r=e.pageY-window.pageYOffset;if(t.disabled||t.readonly||!t._activeComponent||!t._dragDetails||t._dragDetails.x===l&&t._dragDetails.y===r&&!a)return;const o=t._getXYcoordinates(e);if(!o)return;const n=t._activeComponent.offsetWidth,s=t._activeComponent.offsetHeight;switch(t._activeComponent){case t.$.colorPalette:t.$.colorPaletteThumb.style.left=100*o.x/n+"%",t.$.colorPaletteThumb.style.top=100*o.y/s+"%",t.$.colorPaletteThumb.s=t._HSV.s=o.x/n,t.$.colorPaletteThumb.v=t._HSV.v=1-o.y/s;break;case t.$.colorPaletteRadial:{const e=n,a=o.x-e/2,l=o.y-e/2;t.$.colorPaletteRadialThumb.h=t._HSV.h=t._calcHueAngle(a,l)<0?360+t._calcHueAngle(a,l):t._calcHueAngle(a,l),t.inverted?t.$.colorPaletteRadialThumb.v=t._HSV.v=t._validateInRange(2*t._calcSatDistance(a,l)/e,0,1):t.$.colorPaletteRadialThumb.s=t._HSV.s=t._validateInRange(2*t._calcSatDistance(a,l)/e,0,1);const r=(t.shadowRoot||t).querySelector(".preview-container-bottom");r&&(r.style.backgroundColor=t._HSVtoRGBA());break}case t.$.hueScale:t._updateHueScale(o);break;case t.$.brightnessScale:t._updateBrightnessScale(o),"hexagonal"===t.displayMode&&t._generateHoneycomb(t.columnCount,t.inverted?{s:t._HSV.s}:{v:t._HSV.v});break;case t.$.alphaChannelScale:t.$.alphaChannelThumb.a=t._RGBA.a=parseFloat(((n-o.x)/n).toFixed(2)),t.rightToLeft&&(t.$.alphaChannelThumb.a=t._RGBA.a=(1-t._RGBA.a).toFixed(2))}t._applyValue(t._HSVtoRGBA(t._HSV),e),t._instantUpdate()}_releaseThumbUpHandler(){const e=this,a=!!e._activeComponent;e._activeComponent=null,e.disabled||e.readonly||!a||e._dragDetails&&e._dragDetails.isPalettePressed||e._instantUpdate()}_handleCancelButtonClick(e){const a=this,t=a.value;switch("palette"!==a.displayMode&&"radial"!==a.displayMode&&"hexagonal"!==a.displayMode?(a.value=t,a._HSV=a._getValue("hsv",a.value)||{h:1,s:0,v:1},a._RGBA=a._getValue("HSVtoRGBAarray",a.value)):(a._HSV=a._getValue("hsv",a.value)||{h:1,s:0,v:1},a._RGBA=a._getValue("HSVtoRGBAarray",a.value),a.value=a._getValue(a.valueFormat)),a._applyValue(a.value),a.displayMode){case"radial":a._generateRadialCanvas();break;case"hexagonal":a._generateHoneycomb(a.columnCount,a._HSV)}if(null===a.value&&a._selectedItem&&a._selectedItem.classList.contains("selected")&&(a._selectedItem.classList.remove("selected"),a._selectedItem.removeAttribute("aria-current")),t!==a.value&&a.$.fireEvent("change",{oldValue:t,value:a.value}),a.$.container.className.indexOf("custom-color-selection")>-1&&a._applyValueInPaletteMode(),e&&a.$.fireEvent("cancelButtonClick"),!1===a._customColorSelection){a._updatePreviewContainerValues(a.value);let e=("hexagonal"===a.displayMode?a.$.colorPaletteHexagonal:a.$.gridModeContainer).getElementsByClassName("selected");for(let t=0;t<e.length;t++)!e[t]||a.value&&a._equalValues(e[t].colorCode,a.value)||(e[t].style.stroke=null,e[t].classList.remove("selected"),e[t].removeAttribute("aria-current"))}else a.$container.removeClass("custom-color-selection"),a.$.fireEvent("customColorSelection",{value:!1});if(a._customColorSelection=!1,a._customTempColor=void 0,"palette"===a.displayMode||"radial"===a.displayMode){const e=(a.shadowRoot||a).querySelector(".preview-container-top");e&&(e.style.backgroundColor=a.value)}}_handleOkButtonClick(e){const a=this,t=a.value;if(!1!==a._customColorSelection&&void 0!==a._customColorSelection){const l=a._getValue(a.valueFormat);return"useButtons"!==a.applyValueMode&&(a.value=l),a._userPalette.unshift(l),a._generatePaletteUserColorGrid(),a._customColorSelection=!1,t!==a.value&&a.$.fireEvent("change",{oldValue:t,value:a.value}),e&&a.$.fireEvent("okButtonClick",{}),void a.$container.removeClass("custom-color-selection")}if(a._customTempColor&&(a._userPalette.unshift(a._customTempColor),a._generatePaletteUserColorGrid(),a._generateNewPalette=!1,a._customTempColor=""),"palette"===a.displayMode||"radial"===a.displayMode||"hexagonal"===a.displayMode||a._selectedItem&&a._selectedItem.classList.contains("selected")?a.value=a._getValue(a.valueFormat):a.value=null,null===a.value)if("palette"===a.displayMode)a._applyValue(a._HSVtoRGBA(a._HSV),event);else{let e=a.$.gridModeContainer.getElementsByClassName("selected");for(let a=0;a<e.length;a++)e[a]&&(e[a].classList.remove("selected"),e[a].removeAttribute("aria-current"))}t!==a.value&&a.$.fireEvent("change",{oldValue:t,value:a.value}),e&&a.$.fireEvent("okButtonClick",{}),a._customColorSelection=!1,"useButtons"!==a.applyValueMode||a._equalValues(a.value,a._HSVtoRGBA())||a._updatePreviewContainerValues(a._getValue("rgba"),!0)}_handleInputChange(e){const a=this,t=a.value,l=e.target;if(a.disabled||a.readonly)return;e.preventDefault(),e.stopPropagation();const r=["r-channel","g-channel","b-channel"].find((e=>l.className.indexOf(e)>-1)),o=l.classList.contains("a-channel");if(r||o)l.value=r?Math.min(255,Math.max(0,l.value)):Math.min(1,Math.max(0,parseFloat(l.value)||0)),a._RGBA=a._getRGBAFromInputs(),a._HSV=a._getValue("hsv","rgba("+a._RGBA.r+", "+a._RGBA.g+", "+a._RGBA.b+", "+a._RGBA.a+")");else if(l.classList.contains("hex")){const e=a.value?a._getValue("hex"):null,t="#"+l.value;a._isHEX(t)?(a._RGBA.a=1,a._applyValue(a.editAlphaChannel?a._toRGBA(t):a._toHEX(t))):l.value=e?e.substring(1):"ffffff"}a._applyValue(a.editAlphaChannel?a._getValue("rgba"):a._getValue("hex")),"useButtons"===a.applyValueMode||a.$.container.className.indexOf("custom-color-selection")>-1||(a.value=a._getValue(a.valueFormat),a.$.fireEvent("change",{oldValue:t,value:a.value}))}_applyValue(e,a){const t=this;if(!e||null===e||"rgba(NaN, NaN, NaN, 1)"===e)return t._RGBA={r:255,g:255,b:255,a:1},void(t.$.hiddenInput.value=t.value);t._HSVRGBArefresh(e.trim()),"palette"===t.displayMode||t.$.container.className.indexOf("custom-color-selection")>-1?t._applyValueInPaletteMode(a):"radial"===t.displayMode?t._applyValueInRadialMode(a):"hexagonal"===t.displayMode?t._applyValueInHexagonalMode(a):t._applyValueInAnyGridMode(e.trim()),t._applyAlphaValue(t._RGBA.a),t.$.hiddenInput.value=t.value}_applyAlphaValue(e,a){const t=this;if(e=parseFloat(e),t.$.alphaChannelScale){if("alphaScale"!==a){const a=t.$.alphaChannelThumb.offsetWidth,l=t.$.alphaChannelScale.offsetWidth,r=(1-e)*l>a?(1-e)*a:0;t.$.alphaChannelThumb.style[t.rightToLeft?"left":"right"]="",t.$.alphaChannelThumb.style[t.rightToLeft?"right":"left"]=(1-e)*l-r+"px"}"alphaInput"!==a&&(t.$.alphaChannelContainer.querySelector("input.a-channel").value=e),t.$.alphaChannelScale.setAttribute("aria-valuenow",e)}t._RGBA.a=e,t._updatePreviewContainerValues(t._getValue("rgba"))}_applyValueInPaletteMode(e){const a=this,t=a._getValue("hex"),l=a.$.hueScale.offsetHeight,r=a.$.hueScaleThumb.offsetHeight,o=a._HSV.h?l*((360-a._HSV.h)/360):0,n=(a.shadowRoot||a).querySelector("input.hex");if(a._setRGBAToInputs(),n&&(n.value=t.substring(1)),a.$.alphaChannelContainer.style.setProperty("--smart-color-panel-alpha-channel-color",a._rgbArrayToHEX([a._RGBA.r,a._RGBA.g,a._RGBA.b,1])),!a._activeComponent){if(a.$.alphaChannelThumb){const e=a.$.alphaChannelThumb.offsetWidth,t=a.$.alphaChannelScale.offsetWidth,l=(1-a._RGBA.a)*t>e?(1-a._RGBA.a)*e:0;a.$.alphaChannelThumb.style[a.rightToLeft?"left":"right"]="",a.$.alphaChannelThumb.style[a.rightToLeft?"right":"left"]=(1-a._RGBA.a)*t-l+"px",a.$.alphaChannelScale.setAttribute("aria-valuenow",a._RGBA.a)}a.$.hueScaleThumb.style.top=Math.max(0,Math.min(l-r,o-r/2))+"px",a._setPalettePointerXYPosition()}a._activeComponent===a.$.hueScale&&(a.$.colorPalette.style.backgroundColor=a._rgbaToRGB(a._HSVtoRGBA({h:a.$.hueScaleThumb.h,s:1,v:1}))),a._activeComponent&&a._activeComponent!==a.$.colorPalette||a._setPalettePointerXYPosition(e),a.event?a._HSV.h=a.$.hueScaleThumb.h:(a.$.hueScaleThumb.h=a._HSV.h,a.$.colorPalette.style.backgroundColor=a._rgbaToRGB(a._HSVtoRGBA({h:a._HSV.h,s:1,v:1}))),a._updatePreviewContainerValues(a._getValue("rgba")),a.$.hueScale.setAttribute("aria-valuenow",a.$.hueScaleThumb.h)}_applyValueInRadialMode(e){const a=this,t=a._getValue("hex"),l=(a.shadowRoot||a).querySelector("input.hex");if(a._setRGBAToInputs(),l&&(l.value=t.substring(1)),a.$.alphaChannelContainer.style.setProperty("--smart-color-panel-alpha-channel-color",a._rgbArrayToHEX([a._RGBA.r,a._RGBA.g,a._RGBA.b,1])),!a._activeComponent){const e=a.$.brightnessScale.offsetHeight-a.$.brightnessScaleThumb.offsetHeight;if(a.$.alphaChannelThumb){const e=a.$.alphaChannelThumb.offsetWidth,t=a.$.alphaChannelScale.offsetWidth,l=(1-a._RGBA.a)*t>e?(1-a._RGBA.a)*e:0;a.$.alphaChannelThumb.style[a.rightToLeft?"left":"right"]="",a.$.alphaChannelThumb.style[a.rightToLeft?"right":"left"]=(1-a._RGBA.a)*t-l+"px",a.$.alphaChannelScale.setAttribute("aria-valuenow",a._RGBA.a)}const t=a.inverted?a._HSV.v:1-a._HSV.v;a.$.brightnessScale.setAttribute("aria-valuenow",a._HSV.v),a.$.brightnessScaleThumb.style.top=e*t+"px",a.$.colorPaletteRadial.style.setProperty("--smart-color-panel-brightness",t)}if(a._activeComponent&&a._activeComponent!==a.$.colorPaletteRadial||a._setPalettePointerXYPosition(e),a._updatePreviewContainerValues(a._getValue("rgba")),a.inverted){const e=null===a.value?"black":a._HSVtoRGBA({h:a._HSV.h,s:1,v:a._HSV.v});a.$.brightnessScale.style.backgroundImage="linear-gradient("+e+", white)"}else{const e=null===a.value?"white":a._HSVtoRGBA({h:a._HSV.h,s:a._HSV.s,v:1});a.$.brightnessScale.style.backgroundImage="linear-gradient("+e+", black)"}}_applyValueInHexagonalMode(){const e=this,a=e._getValue("hex"),t=(e.shadowRoot||e).querySelector("input.hex");if(e._setRGBAToInputs(),t&&(t.value=a?a.substring(1):null),e.$.alphaChannelContainer.style.setProperty("--smart-color-panel-alpha-channel-color",e._rgbArrayToHEX([e._RGBA.r,e._RGBA.g,e._RGBA.b,1])),!e._activeComponent&&!e._targetItem){const a=e.$.brightnessScale.offsetHeight-e.$.brightnessScaleThumb.offsetHeight;if(e.$.alphaChannelThumb){const a=e.$.alphaChannelThumb.offsetWidth,t=e.$.alphaChannelScale.offsetWidth,l=(1-e._RGBA.a)*t>a?(1-e._RGBA.a)*a:0;e.$.alphaChannelThumb.style[e.rightToLeft?"left":"right"]="",e.$.alphaChannelThumb.style[e.rightToLeft?"right":"left"]=(1-e._RGBA.a)*t-l+"px",e.$.alphaChannelScale.setAttribute("aria-valuenow",e._RGBA.a)}const t=e.inverted?e._HSV.v:1-e._HSV.v;e.$.brightnessScale.setAttribute("aria-valuenow",e._HSV.v),e.$.brightnessScaleThumb.style.top=a*t+"px"}const l=e._getValue("rgba");if(e._updatePreviewContainerValues(l||e._getValue("hex")),e.inverted){const a=e._HSVtoRGBA({h:e._HSV.h,s:1,v:e._HSV.v},1);e.$.brightnessScale.style.backgroundImage="linear-gradient("+a+", white)"}else{const a=e._HSVtoRGBA({h:e._HSV.h,s:e._HSV.s,v:1},1);e.$.brightnessScale.style.backgroundImage="linear-gradient("+a+", black)"}e._applyValueInAnyGridMode(a,e.$.colorPaletteHexagonal)}_radialThumbPoint(e,a,t,l){return{x:Math.round(Math.cos(t*Math.PI/180)*l*e+e),y:Math.round(Math.sin(t*Math.PI/180)*l*e+a)}}_updatePreviewContainerValues(e,a){const t=this,l=(t.shadowRoot||t).querySelector(".preview-container");l&&(("instantly"===t.applyValueMode||a)&&(l.firstElementChild.style.backgroundColor=e),l.lastElementChild.style.backgroundColor=e)}_applyValueInAnyGridMode(e,a){const t=this;if(!e&&null!==e)return;if(!a)switch(t.displayMode){case"default":a=t.$.defaultSamplesContainer;break;case"grid":a=t.$.gridSamplesContainer;break;case"materialGrid":a=t.$.materialGridSamplesContainer;break;case"spectrumGrid":a=t.$.spectrumGridSamplesContainer;break;default:a=t.$.gridModeContainer}if(!a)return;const l=Array.from(a.getElementsByClassName("color-sample"));let r=t._targetItem;if(null==r)for(let a=0;a<l.length;a++){const o=l[a];if(t._equalValues(o.colorCode,e)){r=l[a];break}}t.$.container.className.indexOf("custom-color-selection")>-1&&t._HSV.h&&t._applyValueInPaletteMode(),t._changeSampleSelection(r)}_generatePaletteGrid(){const e=this;if(!e.$.gridSamplesContainer)return;const a=e["_"+e.palette+"Palette"];let t=document.createDocumentFragment();for(let l=0;l<a.length;l++){const r=document.createElement("span"),o=a[l];r.setAttribute("role","menuitem"),r.setAttribute("aria-label",o),r.className="color-sample",r.colorCode=o,r.style.backgroundColor=o,"rgba(255, 255, 255, 0)"===e._toRGBA(o)||"#FFFFFF00"===e._toHEX(e._toRGBA(o))||"transparent"===o?r.setAttribute("transparent",""):r.removeAttribute("transparent"),t.appendChild(r)}e.$.gridSamplesContainer.setAttribute("role","menu"),e.$.gridSamplesContainer.innerHTML="",e.$.gridSamplesContainer.appendChild(t)}_generatePaletteUserColorGrid(e){const a=this;if(!a.$.userSamplesContainer)return;if(!a._userPalette||!a._userPalette.length)return void(a.$.userSamplesContainer.innerHTML="");let t,l=a._userPalette.filter((e=>""!==e)).slice(0,a.columnCount||1),r=document.createDocumentFragment();l=[...new Set(l)];for(let e=0;e<l.length;e++)if(l[e]){const o=a._createColorSample(l[e],"user-color");r.appendChild(o),t||(t=o)}a.$.userSamplesContainer.innerHTML="",a.$.userSamplesContainer.appendChild(r),a.$.userSamplesContainer.setAttribute("role","menu"),!e&&t&&t.colorCode&&a._changeSampleSelection(t),a.paletteCustomColors=a._userPalette.slice(0)}_initializeBaseVars(){const e=this;void 0===e._RGBA&&(e._RGBA={r:255,g:255,b:255,a:1},e._HSV={h:0,s:0,v:1},e.$.hueScaleThumb.h=0,e.$.colorPaletteThumb.s=0,e.$.colorPaletteThumb.v=1,e.$.colorPaletteRadialThumb.h=0,e.$.colorPaletteRadialThumb.s=0,e._defaultPalette=["rgba(255, 255, 255, 0)","rgb(0, 0, 0)","rgb(153, 51, 0)","rgb(51, 51, 0)","rgb(0, 51, 0)","rgb(0, 51, 102)","rgb(0, 0, 128)","rgb(51, 51, 153)","rgb(51, 51, 51)","rgb(128, 0, 0)","rgb(255, 102, 0)","rgb(128, 128, 0)","rgb(0, 128, 0)","rgb(0, 128, 128)","rgb(0, 0, 255)","rgb(102, 102, 153)","rgb(128, 128, 128)","rgb(255, 0, 0)","rgb(255, 153, 0)","rgb(153, 204, 0)","rgb(51, 153, 102)","rgb(51, 204, 204)","rgb(51, 102, 255)","rgb(128, 0, 128)","rgb(153, 153, 153)","rgb(255, 0, 255)","rgb(255, 204, 0)","rgb(255, 255, 0)","rgb(0, 255, 0)","rgb(0, 255, 255)","rgb(0, 204, 255)","rgb(153, 51, 102)","rgb(192, 192, 192)","rgb(255, 153, 204)","rgb(255, 204, 153)","rgb(255, 255, 153)","rgb(204, 255, 204)","rgb(204, 255, 255)","rgb(153, 204, 255)","rgb(204, 153, 255)","rgb(255, 255, 255)"],e._grayPalette=e._generateShades(40,"gray"),e._redPalette=e._generateShades(40,"red"),e._greenPalette=e._generateShades(40,"green"),e._bluePalette=e._generateShades(40,"blue"),e._customPalette=e._mapDataSourceToPalette(),e._userPalette=e.paletteCustomColors||[],e._colorPalette={},e._cssColorNamesHEX={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4","indianred ":"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgrey:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",rebeccapurple:"#663399",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"},e._defaultModeThemeColors=null===e.gridThemeColors?["#FFFFFF","#000000","#E6E6E6","#495469","#5671C2","#D48439","#A5A5A5","#EEC328","#7399D3","#85AA4C"]:e.gridThemeColors,e._defaultModeStandardColors=null===e.gridStandardColors?["#A52A0D","#DB3A15","#EEC328","#FEFE33","#A6CD57","#62AC54","#65ADEE","#3F6FBE","#10205F","#64379E"]:e.gridStandardColors,e._defaultModeShadesColors=null===e.gridShadeColors?["#F2F2F2","#808080","#D0CECE","#D6DCE4","#DDEBF7","#FCE4D6","#EBEBEB","#FFF2CC","#DDE5F7","#E2EFDA","#D8D8D8","#595959","#AEAAAA","#ACB9CA","#BDD7EE","#F6CAAD","#DBDBDB","#FFE699","#B4C6E7","#C6E0B4","#BFBFBF","#404040","#757171","#8497B0","#9BC2E6","#F4B084","#C0C0C0","#FFD966","#8EA9DB","#A9D08E","#A6A6A6","#262626","#312F2F","#333F4F","#2F75B5","#C65911","#7B7B7B","#BF8F00","#305496","#548235","#808080","#0D0D0D","#161616","#222B35","#1F4E78","#833C0C","#525252","#806000","#203764","#375623"]:e.gridShadeColors,e._materialColors={Red:{50:"rgb(255, 235, 238)",100:"rgb(255, 205, 210)",200:"rgb(239, 154, 154)",300:"rgb(229, 115, 115)",400:"rgb(239, 83, 80)",500:"rgb(244, 67, 54)",600:"rgb(229, 57, 53)",700:"rgb(211, 47, 47)",800:"rgb(198, 40, 40)",900:"rgb(183, 28, 28)","A 100":"rgb(255, 138, 128)","A 200":"rgb(255, 82, 82)","A 400":"rgb(255, 23, 68)","A 700":"rgb(213, 0, 0)"},Pink:{50:"rgb(252, 228, 236)",100:"rgb(248, 187, 208)",200:"rgb(244, 143, 177)",300:"rgb(240, 98, 146)",400:"rgb(236, 64, 122)",500:"rgb(233, 30, 99)",600:"rgb(216, 27, 96)",700:"rgb(194, 24, 91)",800:"rgb(173, 20, 87)",900:"rgb(136, 14, 79)","A 100":"rgb(255, 128, 171)","A 200":"rgb(255, 64, 129)","A 400":"rgb(245, 0, 87)","A 700":"rgb(197, 17, 98)"},Purple:{50:"rgb(243, 229, 245)",100:"rgb(225, 190, 231)",200:"rgb(206, 147, 216)",300:"rgb(186, 104, 200)",400:"rgb(171, 71, 188)",500:"rgb(156, 39, 176)",600:"rgb(142, 36, 170)",700:"rgb(123, 31, 162)",800:"rgb(106, 27, 154)",900:"rgb(74, 20, 140)","A 100":"rgb(234, 128, 252)","A 200":"rgb(224, 64, 251)","A 400":"rgb(213, 0, 249)","A 700":"rgb(170, 0, 255)"},"Deep Purple":{50:"rgb(237, 231, 246)",100:"rgb(209, 196, 233)",200:"rgb(179, 157, 219)",300:"rgb(149, 117, 205)",400:"rgb(126, 87, 194)",500:"rgb(103, 58, 183)",600:"rgb(94, 53, 177)",700:"rgb(81, 45, 168)",800:"rgb(69, 39, 160)",900:"rgb(49, 27, 146)","A 100":"rgb(179, 136, 255)","A 200":"rgb(124, 77, 255)","A 400":"rgb(101, 31, 255)","A 700":"rgb(98, 0, 234)"},Indigo:{50:"rgb(232, 234, 246)",100:"rgb(197, 202, 233)",200:"rgb(159, 168, 218)",300:"rgb(121, 134, 203)",400:"rgb(92, 107, 192)",500:"rgb(63, 81, 181)",600:"rgb(57, 73, 171)",700:"rgb(48, 63, 159)",800:"rgb(40, 53, 147)",900:"rgb(26, 35, 126)","A 100":"rgb(140, 158, 255)","A 200":"rgb(83, 109, 254)","A 400":"rgb(61, 90, 254)","A 700":"rgb(48, 79, 254)"},Blue:{50:"rgb(227, 242, 253)",100:"rgb(187, 222, 251)",200:"rgb(144, 202, 249)",300:"rgb(100, 181, 246)",400:"rgb(66, 165, 245)",500:"rgb(33, 150, 243)",600:"rgb(30, 136, 229)",700:"rgb(25, 118, 210)",800:"rgb(21, 101, 192)",900:"rgb(13, 71, 161)","A 100":"rgb(130, 177, 255)","A 200":"rgb(68, 138, 255)","A 400":"rgb(41, 121, 255)","A 700":"rgb(41, 98, 255)"},"Light Blue":{50:"rgb(225, 245, 254)",100:"rgb(179, 229, 252)",200:"rgb(129, 212, 250)",300:"rgb(79, 195, 247)",400:"rgb(41, 182, 246)",500:"rgb(3, 169, 244)",600:"rgb(3, 155, 229)",700:"rgb(2, 136, 209)",800:"rgb(2, 119, 189)",900:"rgb(1, 87, 155)","A 100":"rgb(128, 216, 255)","A 200":"rgb(64, 196, 255)","A 400":"rgb(0, 176, 255)","A 700":"rgb(0, 145, 234)"},Cyan:{50:"rgb(224, 247, 250)",100:"rgb(178, 235, 242)",200:"rgb(128, 222, 234)",300:"rgb(77, 208, 225)",400:"rgb(38, 198, 218)",500:"rgb(0, 188, 212)",600:"rgb(0, 172, 193)",700:"rgb(0, 151, 167)",800:"rgb(0, 131, 143)",900:"rgb(0, 96, 100)","A 100":"rgb(132, 255, 255)","A 200":"rgb(24, 255, 255)","A 400":"rgb(0, 229, 255)","A 700":"rgb(0, 184, 212)"},Teal:{50:"rgb(224, 242, 241)",100:"rgb(178, 223, 219)",200:"rgb(128, 203, 196)",300:"rgb(77, 182, 172)",400:"rgb(38, 166, 154)",500:"rgb(0, 150, 136)",600:"rgb(0, 137, 123)",700:"rgb(0, 121, 107)",800:"rgb(0, 105, 92)",900:"rgb(0, 77, 64)","A 100":"rgb(167, 255, 235)","A 200":"rgb(100, 255, 218)","A 400":"rgb(29, 233, 182)","A 700":"rgb(0, 191, 165)"},Green:{50:"rgb(232, 245, 233)",100:"rgb(200, 230, 201)",200:"rgb(165, 214, 167)",300:"rgb(129, 199, 132)",400:"rgb(102, 187, 106)",500:"rgb(76, 175, 80)",600:"rgb(67, 160, 71)",700:"rgb(56, 142, 60)",800:"rgb(46, 125, 50)",900:"rgb(27, 94, 32)","A 100":"rgb(185, 246, 202)","A 200":"rgb(105, 240, 174)","A 400":"rgb(0, 230, 118)","A 700":"rgb(0, 200, 83)"},"Light Green":{50:"rgb(241, 248, 233)",100:"rgb(220, 237, 200)",200:"rgb(197, 225, 165)",300:"rgb(174, 213, 129)",400:"rgb(156, 204, 101)",500:"rgb(139, 195, 74)",600:"rgb(124, 179, 66)",700:"rgb(104, 159, 56)",800:"rgb(85,139,47)",900:"rgb(51,105,30)","A 100":"rgb(204,255,144)","A 200":"rgb(178,255,89)","A 400":"rgb(118,255,3)","A 700":"rgb(100, 221, 23)"},Lime:{50:"rgb(249, 251, 231)",100:"rgb(255, 249, 196)",200:"rgb(255, 245, 157)",300:"rgb(255, 241, 118)",400:"rgb(255, 238, 88)",500:"rgb(255, 235, 59)",600:"rgb(253, 216, 53)",700:"rgb(251, 192, 45)",800:"rgb(249, 168, 37)",900:"rgb(245, 127, 23)","A 100":"rgb(244, 255, 129)","A 200":"rgb(238, 255, 65)","A 400":"rgb(198, 255, 0)","A 700":"rgb(174, 234, 0)"},Yellow:{50:"rgb(255, 253, 231)",100:"rgb(255, 249, 196)",200:"rgb(255, 245, 157)",300:"rgb(255, 241, 118)",400:"rgb(255, 238, 88)",500:"rgb(255, 235, 59)",600:"rgb(253, 216, 53)",700:"rgb(251, 192, 45)",800:"rgb(249, 168, 37)",900:"rgb(245, 127, 23)","A 100":"rgb(255, 255, 141)","A 200":"rgb(255, 255, 0)","A 400":"rgb(255, 234, 0)","A 700":"rgb(255, 214, 0)"},Amber:{50:"rgb(255, 248, 225)",100:"rgb(255, 236, 179)",200:"rgb(255, 224, 130)",300:"rgb(255, 213, 79)",400:"rgb(255, 202, 40)",500:"rgb(255, 193, 7)",600:"rgb(255, 179, 0)",700:"rgb(255, 160, 0)",800:"rgb(255, 143, 0)",900:"rgb(255, 111, 0)","A 100":"rgb(255, 229, 127)","A 200":"rgb(255, 215, 64)","A 400":"rgb(255, 196, 0)","A 700":"rgb(255, 171, 0)"},Orange:{50:"rgb(255, 243, 224)",100:"rgb(255, 224, 178)",200:"rgb(255, 204, 128)",300:"rgb(255, 183, 77)",400:"rgb(255, 167, 38)",500:"rgb(255, 152, 0)",600:"rgb(251, 140, 0)",700:"rgb(245, 124, 0)",800:"rgb(239, 108, 0)",900:"rgb(230, 81, 0)","A 100":"rgb(255, 209, 128)","A 200":"rgb(255, 171, 64)","A 400":"rgb(255, 145, 0)","A 700":"rgb(255, 109, 0)"},"Deep Orange":{50:"rgb(251, 233, 231)",100:"rgb(255, 204, 188)",200:"rgb(255, 171, 145)",300:"rgb(255, 138, 101)",400:"rgb(255, 112, 67)",500:"rgb(255, 87, 34)",600:"rgb(244, 81, 30)",700:"rgb(230, 74, 25)",800:"rgb(216, 67, 21)",900:"rgb(191, 54, 12)","A 100":"rgb(255, 158, 128)","A 200":"rgb(255, 110, 64)","A 400":"rgb(255, 61, 0)","A 700":"rgb(221, 44, 0)"},Brown:{50:"rgb(239, 235, 233)",100:"rgb(215, 204, 200)",200:"rgb(188, 170, 164)",300:"rgb(161, 136, 127)",400:"rgb(141, 110, 99)",500:"rgb(121, 85, 72)",600:"rgb(109, 76, 65)",700:"rgb(93, 64, 55)",800:"rgb(78, 52, 46)",900:"rgb(62, 39, 35)","A 100":"","A 200":"","A 400":"","A 700":""},Grey:{50:"rgb(250, 250, 250)",100:"rgb(245, 245, 245)",200:"rgb(238, 238, 238)",300:"rgb(224, 224, 224)",400:"rgb(189, 189, 189)",500:"rgb(158, 158, 158)",600:"rgb(117, 117, 117)",700:"rgb(97, 97, 97)",800:"rgb(66, 66, 66)",900:"rgb(33, 33, 33)","A 100":"","A 200":"","A 400":"","A 700":""},"Blue Grey":{50:"rgb(236, 239, 241)",100:"rgb(207, 216, 220)",200:"rgb(176, 190, 197)",300:"rgb(144, 164, 174)",400:"rgb(120, 144, 156)",500:"rgb(96, 125, 139)",600:"rgb(84, 110, 122)",700:"rgb(69, 90, 100)",800:"rgb(55, 71, 79)",900:"rgb(38, 50, 56)","A 100":"","A 200":"","A 400":"","A 700":""}})}_mapDataSourceToPalette(){const e=this;let a=[];if(!e.paletteColors||!Array.isArray(e.paletteColors)||0===e.paletteColors.length)return[];for(let t=0;t<e.paletteColors.length;t++){let l=e.paletteColors[t];"object"==typeof l&&l[e.valueMember]&&"string"==typeof l[e.valueMember]&&(l=l[e.valueMember]),l+="",e._isValidColor(l)&&a.push(l)}return a}_handleSampleClick(e){const a=this,t=e.target,l=a.value;let r=t.colorCode;"hexagonal"===a.displayMode?(r=a._HSVtoRGBA({h:t.h,s:t.s,v:t.v},a._RGBA.a),a._hexagonItems.indexOf(t)>-1&&(a._HSV.h=t.h,a.inverted,a._HSV.s=t.s,a._HSV.v=t.v,a._targetItem=t,a._applyValue(a._HSVtoRGBA(a._HSV),e),delete a._targetItem)):a._changeSampleSelection(t),a._HSVRGBArefresh(t.classList.contains("selected")?r:null),"instantly"===a.applyValueMode&&(a.$.hiddenInput.value=a.value=a._getValue(a.valueFormat,t.classList.contains("selected")?r:null),a.value!==l&&a.$.fireEvent("change",{oldValue:l,value:a.value}))}_changeSampleSelection(e){const a=this;if(a._selectedItem&&"radial"!==a.displayMode&&"hexagonal"!==a.displayMode&&(!e||a._selectedItem===e&&e.classList.contains("selected")))return;if(!e)return;const t=a._getContrastColor(a._rgbaToHEX(a._toRGBA(e.colorCode))),l=e.closest("svg");return Array.from((a.shadowRoot||a).querySelectorAll(".selected")).forEach((e=>{e.classList.remove("selected"),e.removeAttribute("aria-current"),e.style.stroke=null})),e.classList.add("selected"),e.setAttribute("aria-current",!0),a._selectedItem=e,l&&(e.style.stroke=t,l.appendChild(e)),!0}_getContrastColor(e){if(void 0===e)return;let a=(t=e.slice(1,3),l=e.slice(3,5),r=e.slice(5,7),[parseInt(t,16),parseInt(l,16),parseInt(r,16)]);var t,l,r;return(.299*a[0]+.61*a[1]+.114*a[2])/255>.6?"#000000":"#FFFFFF"}_getXYcoordinates(e){if(!e)return;const a=this,t=a._activeComponent||(e.originalEvent||e).target;if(!t.closest)return;const l=t.closest(".color-palette")||t.closest(".color-palette-radial")||t.closest(".hue-scale")||t.closest(".brightness-scale")||t.closest(".alpha-channel-scale");if(!l||a.disabled||a.readonly)return;const r=l.getBoundingClientRect();let o=e.pageX-window.pageXOffset-r.left,n=e.pageY-window.pageYOffset-r.top;return o<0?o=0:o>l.offsetWidth&&(o=l.offsetWidth),n<0?n=0:n>l.offsetHeight&&(n=l.offsetHeight),{x:o,y:n,container:l}}_inputWheelHandler(e){const a=this,t=a.value,l=e.target;if(!(e.target instanceof HTMLInputElement)||e.target.classList.contains("hex"))return;let r;e.preventDefault(),l.classList.contains("a-channel")?(r=parseFloat(l.value)||0,r=e.deltaY<0?r+.01:r-.01,l.value=a._toFixed(a._validateInRange(r,0,1)),a._RGBA=a._getRGBAFromInputs(),a._applyAlphaValue(a._RGBA.a,"alphaInput")):(r=parseInt(l.value)||0,r=e.deltaY<0?r+1:r-1,l.value=a._validateInRange(r,0,255),a._RGBA=a._getRGBAFromInputs(),a._HSV=a._getValue("hsv","rgba("+a._RGBA.r+", "+a._RGBA.g+", "+a._RGBA.b+", "+a._RGBA.a+")")),a._updatePreviewContainerValues(a._getValue(a.valueFormat)),a._setPalettePointerXYPosition(),"useButtons"===a.applyValueMode&&("palette"===a.displayMode?a._applyValueInPaletteMode():"radial"===a.displayMode?a._applyValueInRadialMode():"hexagonal"===a.displayMode&&a._generateHoneycomb(a.columnCount,a._HSV)),a.$.container.className.indexOf("custom-color-selection")>-1?a._applyValue(a._HSVtoRGBA(a._HSV)):"useButtons"!==a.applyValueMode&&(a.value=a._getValue(a.valueFormat),a._applyValue(a.value,e),a.$.fireEvent("change",{oldValue:t,value:a.value}))}_paletteDownHandler(e){const a=this;if(!Smart.Utilities.Core.isMobile&&0!==e.button||a.disabled||a.readonly)return;a._dragDetails={x:e.pageX-window.pageXOffset,y:e.pageY-window.pageYOffset};const t=(e.originalEvent||e).target;if(t&&t.closest){if(a._dragDetails.target=t.closest(".color-palette")||t.closest(".color-palette-radial"),t.closest(".color-palette")||t.closest(".color-palette-radial"))return a._handleColorPaletteDown(e.originalEvent),void(a._dragDetails.isPalettePressed=!0);(t.closest(".hue-scale")||t.closest(".alpha-channel-scale")||t.closest(".brightness-scale"))&&a._handleScalesDown(e.originalEvent)}}_setPalettePointerXYPosition(e){const a=this;let t;if("palette"===a.displayMode||a.$.container.className.indexOf("custom-color-selection")>-1)t=a._getXYcoordinates(e),a.$.colorPaletteThumb.style.left=e&&t&&t.x?100*t.x/t.container.offsetWidth+"%":100*a._HSV.s+"%",a.$.colorPaletteThumb.style.top=e&&t&&t.y?100*t.y/t.container.offsetHeight+"%":100*(1-a._HSV.v)+"%";else if("radial"===a.displayMode){if(e){if(t=a._getXYcoordinates(e),!t)return;const l=t.container.offsetWidth?t.container.offsetWidth:a.$.colorPaletteRadial.offsetWidth,r=t.container.offsetHeight?t.container.offsetHeight:a.$.colorPaletteRadial.offsetHeight,o=Math.round(Math.cos(a._HSV.h*Math.PI/180)*l/2+l/2),n=Math.round(Math.sin(a._HSV.h*Math.PI/180)*l/2+r/2);return Math.abs(l/2-t.x)<5?(a.$.colorPaletteRadialThumb.style.left=100*t.x/a.$.colorPaletteRadial.offsetWidth+"%",void(a.$.colorPaletteRadialThumb.style.top=100*t.y/a.$.colorPaletteRadial.offsetHeight+"%")):(a.$.colorPaletteRadialThumb.style.left=100*(t.x<l/2?Math.max(o,t.x):Math.min(o,t.x))/l+"%",void(a.$.colorPaletteRadialThumb.style.top=100*(t.y<r/2?Math.max(n,t.y):Math.min(n,t.y))/r+"%"))}{const e=a._radialThumbPoint(a.$.colorPaletteRadial.offsetWidth/2,a.$.colorPaletteRadial.offsetHeight/2,a._HSV.h,a._HSV.s);a.$.colorPaletteRadialThumb.style.left=100*e.x/a.$.colorPaletteRadial.offsetWidth+"%",a.$.colorPaletteRadialThumb.style.top=100*e.y/a.$.colorPaletteRadial.offsetHeight+"%"}}}_handleGridModeCellHover(e){const a=this,t=e.target.closest(".color-sample");if(a.disabled||!t||"none"===a.tooltipDisplayMode||!a.$.tooltip)return;if(a.$.tooltip.arrow="hexagonal"!==a.displayMode,!a._isValidColor(t.colorCode))return void(a.$.tooltip.disabled=!0);a.$.tooltip.disabled=!1,a.$.tooltip.selector=t;const l=t.h&&t.s&&t.v?a._HSVtoRGBA({h:t.h,s:t.s,v:t.v},a._RGBA.a):a._toRGBA(t.colorCode);switch(a.tooltipDisplayMode){case"rgba":a.$.tooltip.value=l||"";break;case"rgb":a.$.tooltip.value=a._rgbaToRGB(l)||"";break;case"hex":a.$.tooltip.value=a._rgbaToHEX(l)||""}}_localizeLabels(){const e=this,a=(e.shadowRoot||e).querySelector("label.r-channel"),t=(e.shadowRoot||e).querySelector("label.g-channel"),l=(e.shadowRoot||e).querySelector("label.b-channel"),r=(e.shadowRoot||e).querySelector("label.a-channel"),o=(e.shadowRoot||e).querySelector("label.hex");if(a&&(a.innerHTML=e.localize("redPrefix")),t&&(t.innerHTML=e.localize("greenPrefix")),l&&(l.innerHTML=e.localize("bluePrefix")),r&&(r.innerHTML=e.localize("alphaPrefix")),o&&(o.innerHTML=e.localize("hexPrefix")),e.$.buttonCustom&&(e.$.buttonCustom.content=e.localize("customColor")),e.$.buttonOk&&(e.$.buttonOk.content=e.localize("ok")),e.$.buttonCancel&&(e.$.buttonCancel.content=e.localize("cancel")),e.$.defaultSamplesContainer){const a=e.$.defaultSamplesContainer.querySelector(".theme-colors-label"),t=e.$.defaultSamplesContainer.querySelector(".standard-colors-label");a&&(a.innerHTML=e.localize("themeColors")),t&&(t.innerHTML=e.localize("standardColors"))}}_generateHoneycomb(e,a){const t=this,l=parseInt(getComputedStyle(t).getPropertyValue("--smart-color-panel-grid-mode-item-size"))/4,r=Math.sqrt(5*Math.pow(l,2)),o=e%2==0?parseInt(e)+1:parseInt(e),n=a&&void 0!==a.s?a.s:1,s=a&&void 0!==a.v?a.v:1,i=t._calculateHexagonCoords(o,r,1),d=i[Math.floor(i.length/2)],c=t._getHoneycomb30degDimmensions(i.length,r,1);t._draw||(t._draw=new Smart.Utilities.Draw(t.$.colorPaletteHexagonal)),t._draw.clear(),t.$.colorPaletteHexagonal.firstElementChild.setAttribute("role","presentation"),t.$.colorPaletteHexagonal.firstElementChild.firstElementChild.setAttribute("role","menu"),t._hexagonItems=[],t.$.materialGridSamplesContainer&&t.$.materialGridSamplesContainer.$.addClass("smart-hidden");for(let e=0;e<i.length;e++){const a=i[e].x-d.x,l=i[e].y-d.y,o=t._validateInRange(t._calcSatDistance(a,l)/d.x,0,1);let c,u,h=t._calcHueAngle(a,l)<0?360+t._calcHueAngle(a,l):t._calcHueAngle(a,l);switch(t.inverted?(c=n,u=o):(c=o,u=s),t.palette){case"red":h=0;break;case"green":h=120;break;case"blue":h=240;break;case"gray":c=0,u=t.inverted?o:1-o}const g={offsetX:i[e].x,offsetY:i[e].y,style:{fill:t._HSVtoRGBA({h,s:c,v:u},1),class:"color-sample"}};let b=t._hexagon(r,g);b.colorCode=t._HSVtoRGBA({h,s:c,v:u}),b.h=h,b.s=c,b.v=u,b.setAttribute("role","menuitem"),b.setAttribute("aria-label",b.colorCode),t._hexagonItems.push(b)}t._draw.host.style.width=c.width+"px",t._draw.host.style.height=c.height+"px",t.$.container.style.setProperty("--smart-color-panel-palette-width",c.width+"px"),t.$.container.style.setProperty("--smart-color-panel-palette-height",c.height+"px"),t._applyValueInHexagonalMode(),t._hideControlsByPriority()}_hexagon(e,a){const t=this._shortStepHexagon(e),l=2*t,r=l+(a.offsetX||0),o=a.offsetY||0,n=r+l,s=o+t,i=s+e,d=n-l,c=i+t,u=d-l,h=c-t,g="M "+r+","+o+" L "+n+","+s+" L "+n+","+i+" L "+d+","+c+" L "+u+","+h+" L "+u+","+(h-e)+" Z";return this._draw.path(g,a.style||{class:"color-sample"})}_shortStepHexagon(e){return Math.sqrt(Math.pow(e,2)/5)}_getHoneycomb30degDimmensions(e,a,t){const l=.5*(1+Math.sqrt(1-(1-e)/3*4)),r=this._shortStepHexagon(a);return{width:4*r*(2*l-1)+2*l*2*t,height:(2*l-1)*a+2*l*r+2*l*t}}_generateShades(e,a){const t=this,l=a||"gray";let r,o=[];const n=255/((e=Math.max(parseInt(e),2))-1);for(let a=0;a<e;a++){let e=Math.max(parseInt(255-a*n),0);switch(t.inverted&&(e=255-e),l){case"red":r="rgb("+e+", 0, 0)";break;case"green":r="rgb(0, "+e+", 0)";break;case"blue":r="rgb(0, 0, "+e+")";break;default:r="rgb("+e+", "+e+", "+e+")"}o.push(r)}return o}_generateColorSpectrum(e){const a=this;let t=[];const l=360/((e=Math.max(parseInt(e),2))-1),r=2/e;let o=0,n=1,s=1;for(let i=0;i<e;i++){a.inverted?0===i?n=1:i<e/2?n=Math.max(n-r,r/2):i<e-1?(s=Math.max(s-r,r/2),n=Math.min(n+r,1)):(s=Math.max(s-r,r/2),n=Math.min(n+r/4,1)):0===i?s=1:i<e/2?s=Math.max(s-r,r/2):i<e-1?(n=Math.max(n-r,r/2),s=Math.min(s+r,1)):(n=Math.max(n-r,r/2),s=Math.min(s+r/4,1));for(let r=0;r<e;r++)o=parseInt(l*r),o=360===o?360-l/2:o,t.push(a._HSVtoRGBA({h:o,s:n,v:s},1))}return t}_generateSpectrumGrid(e){const a=this;if(!a.$.spectrumGridSamplesContainer)return;const t=Math.pow(e,2),l=document.createDocumentFragment(),r={},o=a._generateShades(e,"gray"),n=a._customPalette;let s;["grayShadesBox","spectrumBox","customColorsBox"].forEach((e=>{const a=document.createElement("div");let t=Smart.Utilities.Core.toDash(e).split("-").join(" ");r[e]=a,a.className=Smart.Utilities.Core.toDash(e),a.setAttribute("role","menu"),a.setAttribute("aria-label",t.slice(0,1).toUpperCase()+t.slice(1)),l.appendChild(a)})),s="default"===a.palette?a._generateColorSpectrum(e):["gray","red","green","blue"].indexOf(a.palette)>-1?a._generateShades(t,a.palette):a._generateColorSpectrum(e);for(let t=0;t<e;t++){const e=a._createColorSample(o[t],"gray-shade");r.grayShadesBox.appendChild(e)}for(let e=0;e<t;e++){const t=a._createColorSample(s[e],"spectrum");r.spectrumBox.appendChild(t)}for(let t=0;t<e;t++){const e=n[t];if(!e)break;const l=a._createColorSample(e,"custom-color");r.customColorsBox.appendChild(l)}a.$.spectrumGridSamplesContainer.innerHTML="",a.$.spectrumGridSamplesContainer.appendChild(l)}_generateDefaultGrid(){const e=this;if(!e.$.defaultSamplesContainer)return;const a={},t=null===e.gridThemeColors?e._defaultModeThemeColors:e.gridThemeColors,l=null===e.gridShadeColors?e._defaultModeShadesColors:e.gridShadeColors,r=null===e.gridStandardColors?e._defaultModeStandardColors:e.gridStandardColors,o=document.createDocumentFragment();["themeColorsLabel","themeColorsBox","themeShadesBox","standardColorsLabel","standardColorsBox"].forEach((t=>{const l=document.createElement("div");a[t]=l,l.className=Smart.Utilities.Core.toDash(t),-1!==t.indexOf("Box")?l.setAttribute("role","menu"):-1!==t.indexOf("Label")&&(l.id=e.id+t),o.appendChild(l)})),a.themeColorsLabel.innerHTML=e.localize("themeColors"),a.standardColorsLabel.innerHTML=e.localize("standardColors"),a.themeColorsBox.setAttribute("aria-labelledby",e.id+"themeColorsLabel"),a.themeShadesBox.setAttribute("aria-labelledby",e.id+"themeColorsLabel"),a.standardColorsBox.setAttribute("aria-labelledby",e.id+"standardColorsLabel");for(let t=0;t<e._defaultModeShadesColors.length;t++)a.themeShadesBox.appendChild(e._createColorSample(l[t],"shades-color"));for(let l=0;l<10;l++)a.themeColorsBox.appendChild(e._createColorSample(t[l],"theme-color")),a.standardColorsBox.appendChild(e._createColorSample(r[l],"standard-color"));e.$.defaultSamplesContainer.innerHTML="",e.$.defaultSamplesContainer.appendChild(o)}_mixColors(e,a,t){const l=e=>parseInt(e,16);let r,o="#";t=void 0!==t?t:.5,e=e.replace(/#/g,""),a=a.replace(/#/g,"");for(let n=0;n<=5;n+=2){const s=l(e.substr(n,2)),i=l(a.substr(n,2));for(r=Math.round(i+(s-i)*t).toString(16);r.length<2;)r="0"+r;o+=r}return o}_generateMaterialGrid(){const e=this;if(!e.$.materialGridSamplesContainer)return;const a=document.createDocumentFragment();e.$.materialGridSamplesContainer.$.removeClass("smart-hidden"),a.appendChild(e._createColorSample("rgb(255, 255, 255, 0)","material-color label-column")),Object.entries(e._materialColors.Red).forEach((t=>{const l=e._createColorSample("rgb(255, 255, 255, 0)","material-color header");l.textContent=t[0],a.appendChild(l)})),Object.entries(e._materialColors).forEach((t=>{const l=e._createColorSample("rgb(255, 255, 255, 0)","material-color label-column");l.textContent=t[0],a.appendChild(l),Object.entries(t[1]).forEach((t=>{a.appendChild(e._createColorSample(t[1],"material-color"))}))})),e.$.materialGridSamplesContainer.innerHTML="",e.$.materialGridSamplesContainer.appendChild(a)}_createColorSample(e,a){const t=document.createElement("div"),l=e?"":" empty";return e&&-1===a.indexOf("label-column")&&-1===a.indexOf("header")&&(t.setAttribute("role","menuitem"),t.setAttribute("aria-label",e)),t.className="color-sample "+a+l,a.indexOf("header")>-1||a.indexOf("label-column")>-1||(t.colorCode=e,t.style.backgroundColor=e),t}_calculateHexagonCoords(e,a,t){const l=e,r=function(e){return((e=e%2==0?e+1:e)+1)/2}(e),o=this._shortStepHexagon(a),n=4*o+2*t,s=2*o+t,i=a+o+t,d=s*(l-1)/2;let c=[];for(let a=0;a<l;a++){const t=a<r?r+a:e-1-(a-r),l=a<r?d-a*s:d-(e-a-1)*s,o=a*i;for(let e=0;e<t;e++){const a=l+e*n;c.push({x:a,y:o})}}return c}_generateGridStructures(){const e=this,a=e.displayMode;if(!e._initializeOnOpening){if(void 0===e._createGridModeComponents()){switch(a){case"spectrumGrid":e._generateSpectrumGrid(e.columnCount);break;case"materialGrid":e._generateMaterialGrid();break;case"default":e._generateDefaultGrid();break;case"grid":e._generatePaletteGrid()}return e._generatePaletteUserColorGrid(),void t()}switch(e._createColorControls(),a){case"radial":e._generateRadialCanvas();break;case"hexagonal":e._generateHoneycomb(e.columnCount,e._HSV)}t()}function t(){switch(a){case"default":case"grid":e.$.colorPaletteRadial.setAttribute("aria-hidden",!0),e.$.brightnessScale.setAttribute("aria-hidden",!0);break;case"hexagonal":e.$.colorPaletteRadial.setAttribute("aria-hidden",!0),e.$.brightnessScale.removeAttribute("aria-hidden");break;case"materialGrid":e.$.colorPaletteRadial.removeAttribute("aria-hidden"),e.$.brightnessScale.removeAttribute("aria-hidden");break;case"palette":e.$.colorPaletteRadial.removeAttribute("aria-hidden"),e.$.brightnessScale.setAttribute("aria-hidden",!0)}}}_generateRadialCanvas(){const e=this;if("radial"!==e.displayMode||"radial"===e.displayMode&&!Smart.Utilities.Core.Browser.Firefox)return;const a=e.$.colorPaletteRadial.offsetWidth,t=a/2;let l=e.$.colorPaletteRadial.querySelector("canvas");l||(l=document.createElement("canvas"),l.setAttribute("role","presentation"));let r=l.getContext("2d"),o=r.createImageData(a,a),n=o.data;l.width=l.height=a;for(let a=-t;a<t;a++)for(let l=-t;l<t;l++){let[r,o]=e._xy2polar(a,l);if(r>t)continue;let s=4*(a+t+(l+t)*(2*t)),i=e._rad2deg(o),d=1,c=1;const[u,h,g]=e._hsv2rgb(i,d,c);n[s]=u,n[s+1]=h,n[s+2]=g,n[s+3]=255}r.putImageData(o,0,0),e.$.colorPaletteRadial.appendChild(l)}_xy2polar(e,a){return[Math.sqrt(e*e+a*a),Math.atan2(a,e)]}_rad2deg(e){return(e+Math.PI)/(2*Math.PI)*360}_hsv2rgb(e,a,t){let l,r,o,n=t*a,s=e/60,i=n*(1-Math.abs(s%2-1));s>=0&&s<=1?[l,r,o]=[n,i,0]:s>=1&&s<=2?[l,r,o]=[i,n,0]:s>=2&&s<=3?[l,r,o]=[0,n,i]:s>=3&&s<=4?[l,r,o]=[0,i,n]:s>=4&&s<=5?[l,r,o]=[i,0,n]:s>=5&&s<=6&&([l,r,o]=[n,0,i]);let d=t-n,[c,u,h]=[l+d,r+d,o+d];return[255*c,255*u,255*h]}_hideControlsByPriority(){const e=this,a=(e.shadowRoot||e).querySelector(".color-controls-container");if(!a.innerHTML.trim())return;function t(a){const t=e.getElementsByClassName(a);for(let e=0;e<t.length;e++)t[e].classList.add("smart-hidden")}const l=e.hideContentToFit.slice().reverse(),r=["hex","r-channel","g-channel","b-channel","a-channel","preview-container"];let o=l.length;for(r.forEach((a=>{const t=e.getElementsByClassName(a);for(let e=0;e<t.length;e++)t[e].classList.remove("smart-hidden")}));a.scrollHeight>a.offsetHeight&&o>0;)switch(o--,l[o]){case"HEX":t(r[0]);break;case"RGB":r.slice(1,4).forEach((e=>t(e)));break;case"previewContainer":t(r[5]);break;case"alpha":t(r[4])}e._generateRadialCanvas()}_resizeHoneycombItems(){const e=this;"hexagonal"===e.displayMode&&e._generateHoneycomb(e.columnCount,e._HSV)}_getValue(e,a){const t=this,l=t._RGBA;let r,o=null;switch(e){case"hex":o=t._rgbArrayToHEX([l.r,l.g,l.b,l.a]);break;case"rgb":o="rgb("+l.r+", "+l.g+", "+l.b+")";break;case"rgba":o=null!==l.r&&null!==l.g&&null!==l.b?"rgba("+l.r+", "+l.g+", "+l.b+", "+l.a+")":null;break;case"HSVtoRGBAarray":{let e="hexagonal"===t.displayMode||"radial"===t.displayMode||"palette"===t.displayMode?t._RGBA.a:1;a&&(t._isRGBA(a)&&/rgba\((\d*.\d+|\d+),(\d*.\d+|\d+),(\d*.\d+|\d+)\,(\d*.\d+|\d+)\)/gi.test(a.replace(/\s/g,""))?e=/rgba\((\d*.\d+|\d+),(\d*.\d+|\d+),(\d*.\d+|\d+)\,(\d*.\d+|\d+)\)/gi.exec(a.replace(/\s/g,""))[4]:t._isHEX(a)&&/(^#[0-9A-F]{8}$)/gi.test(a.replace(/\s/g,""))&&(e=parseInt(/(^#[0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2}$)/gi.exec(a.replace(/\s/g,""))[4],16)/255),e=Math.min(1,Math.max(0,parseFloat(e))),isNaN(e)&&(e=t._RGBA.a)),o=t._HSVtoRGBA(t._HSV,e),r=/rgba\((\d*.\d+|\d+),(\d*.\d+|\d+),(\d*.\d+|\d+)\,(\d*.\d+|\d+)\)/gi.exec(o.replace(/\s/g,"")),o={r:parseInt(r[1]),g:parseInt(r[2]),b:parseInt(r[3]),a:parseFloat(r[4])};break}case"hsv":a&&t._isValidColor(a)&&(o=t._colorToHSV(a));break;default:"radial"===t.displayMode||"hexagonal"===t.displayMode||"palette"===t.displayMode?(o="rgba("+l.r+", "+l.g+", "+l.b+", "+l.a+")",t.editAlphaChannel||(o=t._rgbaToRGB(o))):o=null!==a?t._rgbArrayToHEX([l.r,l.g,l.b,l.a]):null}return o||null}_instantUpdate(){const e=this,a=e.value;"instantly"!==e.applyValueMode||e.$.container.className.indexOf("custom-color-selection")>-1||(e.value=e._getValue(e.valueFormat),e.$.fireEvent("change",{oldValue:a,value:e.value}))}_equalValues(e,a){return e===a||!(!e||!a)&&this._toRGBA(e,!0)===this._toRGBA(a,!0)}_toHEX(e){const a=this;return a._isHEX(e)?e:(a._isRGB(e)&&(e=e.toLowerCase().replace("rgb","rgba"),e=a.editAlphaChannel?e.replace(")",", "+(a._RGBA.a||1)+")"):e.replace(")",", 1)")),a._isRGBA(e)?a._rgbaToHEX(e):void 0)}_toRGBA(e,a){const t=this;let l=t.value;if(t._isRGBA(e))return a?"rgba("+e.match(/(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})/gi)+", 1)":e;if(t._isValidColorName(e))l=r(t._cssColorNamesHEX[e.trim().toLowerCase()]);else if(t._isHEX(e))l=r(e);else{if(!t._isRGB(e))return!1;l=e.toLowerCase(),l=l.replace("rgb","rgba"),l=t.editAlphaChannel?l.replace(")",", "+(t._RGBA.a||1)+")"):l.replace(")",", 1)")}return l;function r(e){const t=/^#(.)(.)(.)$/gi.exec(e),l=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})?$/i.exec(e),r=t?parseInt(t[1]+t[1],16):parseInt(l[1],16),o=t?parseInt(t[2]+t[2],16):parseInt(l[2],16),n=t?parseInt(t[3]+t[3],16):parseInt(l[3],16),s=t?parseInt(t[4]+t[4],16):parseInt(l[4],16);return a?"rgba("+r+", "+o+", "+n+", 1)":"rgba("+r+", "+o+", "+n+", "+(isNaN(s)?"1":s/255)+")"}}_rgbaToRGB(e){const a=/rgba\((\d*.\d+|\d+),(\d*.\d+|\d+),(\d*.\d+|\d+)\,(\d*.\d+|\d+)\)/gi.exec(e.replace(/\s/g,""));return"rgb("+a[1].trim()+", "+a[2].trim()+", "+a[3].trim()+")"}_rgbaToHEX(e){const a=/rgba\((\d*.\d+|\d+),(\d*.\d+|\d+),(\d*.\d+|\d+)\,(\d*.\d+|\d+)\)/gi.exec(e.replace(/\s/g,""));return this._rgbArrayToHEX([a[1],a[2],a[3],a[4]])}_rgbArrayToHEX(e){let a="#";if(Array.isArray(e)&&null===e[0])return null;for(let t=0;t<3;t++){let l=parseInt(e[t]).toString(16).toUpperCase();l=1===l.length?0+l:l,a+=l}let t=parseFloat(e[3]);return isNaN(t)||(t=parseInt(255*t).toString(16).toUpperCase(),"FF"!==t&&(a=a.slice(0,7)+(1===t.length?0+t:t))),a}_colorToHSV(e){const a=this;if(!a._isValidColor(e))return;e=a._toRGBA(e).replace(/\s/g,"");const t=/rgba\((\d*.\d+|\d+),(\d*.\d+|\d+),(\d*.\d+|\d+)\,(\d*.\d+|\d+)\)/gi.exec(e),l=Math.min(255,Math.max(0,parseFloat(t[1])))/255,r=Math.min(255,Math.max(0,parseFloat(t[2])))/255,o=Math.min(255,Math.max(0,parseFloat(t[3])))/255;let n={h:0,s:0,v:0},s=0,i=0;if(l>=r&&l>=o?(i=l,s=r>o?o:r):r>=o&&r>=l?(i=r,s=l>o?o:l):(i=o,s=r>l?l:r),n.v=i,n.s=i?(i-s)/i:0,n.s){const e=i-s;n.h=l===i?(r-o)/e:r===i?2+(o-l)/e:4+(l-r)/e,n.h=60*n.h,n.h<0&&(n.h+=360)}else n.h=a._HSV.h?a._HSV.h:0;return n.s=parseFloat(n.s),n.v=parseFloat(n.v),n}_HSVtoRGBA(e,a){const t=this,l=(e=e||{h:0,s:0,v:0})&&e.h>=0?e.h:t._HSV.h,r=e&&e.s>=0?e.s:t._HSV.s,o=e&&e.v>=0?e.v:t._HSV.v;let n,s,i,d=o*r,c=l/60,u=d*(1-Math.abs(c%2-1));c>=0&&c<=1?[n,s,i]=[d,u,0]:c>=1&&c<=2?[n,s,i]=[u,d,0]:c>=2&&c<=3?[n,s,i]=[0,d,u]:c>=3&&c<=4?[n,s,i]=[0,u,d]:c>=4&&c<=5?[n,s,i]=[u,0,d]:c>=5&&c<=6&&([n,s,i]=[d,0,u]);const h=o-d;return"rgba("+Math.round(255*(n+h))+", "+Math.round(255*(s+h))+", "+Math.round(255*(i+h))+", "+(void 0!==a?a:t._RGBA.a||0)+")"}_HSVRGBArefresh(e){const a=this;a._HSV=a._getValue("hsv",e)||{h:1,s:0,v:1},a._RGBA=a._getValue("HSVtoRGBAarray",e)}_toFixed(e,a){return parseFloat(parseFloat(e).toFixed(a||2))}_validateInRange(e,a,t){return Math.min(Math.max(parseFloat(e),parseFloat(a)),parseFloat(t))}_isHEX(e){return/(^#[0-9A-F]{3}$)|(^#[0-9A-F]{6}$)|(^#[0-9A-F]{8}$)/i.test(e)}_isRGB(e){return/rgb\((\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\)/i.test(e)}_isRGBA(e){return/rgba\((\d*.\d+|\d+)\s*,\s*(\d*.\d+|\d+)\s*,\s*(\d*.\d+|\d+)\s*,\s*(\d*.\d+|\d+)\)/i.test(e)}_isValidColorName(e){return!(!e||void 0===this._cssColorNamesHEX[e.trim().toLowerCase()])}_isValidColor(e){return this._isHEX(e)||this._isRGB(e)||this._isRGBA(e)||this._isValidColorName(e)}_getRGBAFromInputs(){const e=this;let a=(e.shadowRoot||e).querySelector("input.r-channel"),t=(e.shadowRoot||e).querySelector("input.g-channel"),l=(e.shadowRoot||e).querySelector("input.b-channel"),r=(e.shadowRoot||e).querySelector("input.a-channel");return a=a?a.value:e._RGBA.r,t=t?t.value:e._RGBA.g,l=l?l.value:e._RGBA.b,r=r?r.value:e._RGBA.a,{r:parseInt(a),g:parseInt(t),b:parseInt(l),a:r}}_setRGBAToInputs(){const e=this;Object.entries(e._RGBA).forEach((a=>{const t=(e.shadowRoot||e).querySelector("input."+a[0]+"-channel");t&&(t.value=e._RGBA[a[0]])}))}_calcHueAngle(e,a){return 180*Math.atan2(a,e)/Math.PI}_calcSatDistance(e,a){return Math.sqrt(Math.pow(e,2)+Math.pow(a,2))}});