
/* Smart UI v15.2.0 (2023-04-20) 
Copyright (c) 2011-2023 jQWidgets. 
License: https://htmlelements.com/license/ */ //

Smart("smart-date-time-picker",class extends Smart.BaseElement{static get properties(){return{animationSettings:{value:null,type:"object"},autoClose:{value:!1,type:"boolean"},autoCloseDelay:{value:0,type:"number"},autoSwitchToMinutes:{value:!1,type:"boolean"},calendarButton:{value:!1,type:"boolean"},calendarButtonPosition:{value:"right",allowedValues:["left","right"],type:"string"},calendarMode:{value:"default",allowedValues:["default","classic"],type:"string"},dayNameFormat:{value:"firstTwoLetters",allowedValues:["narrow","firstTwoLetters","long","short"],type:"string"},disableAutoNavigation:{value:!1,type:"boolean"},displayKind:{value:"unspecified",allowedValues:["UTC","local","unspecified"],type:"string"},displayModeView:{value:"table",allowedValues:["table","list"],type:"string"},displayMode:{allowedValues:["outlined","filled","underlined"],value:"outlined",type:"string"},dropDownAppendTo:{value:null,type:"any"},dropDownDisplayMode:{value:"default",allowedValues:["default","classic","calendar","timePicker","auto"],type:"string"},dropDownOverlay:{value:!1,type:"boolean"},dropDownPosition:{value:"auto",allowedValues:["auto","bottom","overlay-top","overlay-center","overlay-bottom","top","center-bottom","center-top"],type:"string"},editMode:{value:"default",allowedValues:["default","full","partial"],type:"string"},enableMouseWheelAction:{value:!1,type:"boolean"},firstDayOfWeek:{value:0,type:"number"},footerTemplate:{value:null,type:"any"},footer:{value:!1,type:"boolean"},formatString:{value:"dd-MMM-yy HH:mm:ss.fff",type:"string"},headerTemplate:{value:null,type:"any"},hideDayNames:{value:!1,type:"boolean"},hideOtherMonthDays:{value:!1,type:"boolean"},hideTooltipArrow:{value:!1,type:"boolean"},hint:{value:"",type:"string"},importantDates:{value:[],type:"array"},importantDatesTemplate:{value:null,type:"any"},interval:{value:new Smart.Utilities.TimeSpan(0,0,1),type:"any"},label:{value:"",type:"string"},max:{value:new Smart.Utilities.DateTime(3001,1,1),type:"any"},messages:{value:{en:{now:"Now",dateTabLabel:"DATE",timeTabLabel:"TIME"}},type:"object",extend:!0},min:{value:new Smart.Utilities.DateTime(1600,1,1),type:"any"},name:{value:"",type:"string"},nullable:{value:!1,type:"boolean"},opened:{value:!1,type:"boolean"},placeholder:{value:"Enter date",type:"string"},restrictedDates:{value:[],type:"array"},spinButtons:{value:!1,type:"boolean"},spinButtonsDelay:{value:75,type:"number"},spinButtonsInitialDelay:{value:0,type:"number"},spinButtonsPosition:{value:"right",allowedValues:["left","right"],type:"string"},tooltip:{value:!1,type:"boolean"},tooltipDelay:{value:100,type:"number"},tooltipPosition:{value:"top",allowedValues:["bottom","top","left","right","absolute"],type:"string"},tooltipTemplate:{value:null,type:"any"},validation:{value:"strict",allowedValues:["strict","interaction"],type:"string"},value:{defaultReflectToAttribute:!0,value:new Smart.Utilities.DateTime,type:"any"},weekNumbers:{value:!1,type:"boolean"},weeks:{value:6,type:"number"},yearCutoff:{value:1926,type:"number"}}}static get listeners(){return{"container.mouseout":"_mouseoutHandler","container.mouseover":"_mouseoverHandler","calendarButton.click":"_calendarButtonClickHandler","calendarDropDown.change":"_calendarDropDownChangeHandler","calendarDropDown.click":"_calendarDropDownClickHandler","downButton.click":"_spinButtonsClickHandler","input.blur":"_inputBlurHandler","input.change":"_inputChangeHandler","input.dragstart":"_inputDragstartHandler","input.focus":"_inputFocusHandler","input.keydown":"_inputKeydownHandler","input.down":"_inputDownHandler","input.paste":"_inputPasteHandler","input.select":"_inputSelectHandler","input.up":"_inputUpHandler","input.wheel":"_inputWheelHandler","dropDownContainer.keydown":"_dropDownKeydownHandler","dropDownContainer.transitionend":"_dropDownTransitionendHandler","dropDownHeader.click":"_dropDownHeaderClickHandler","upButton.click":"_spinButtonsClickHandler","document.up":"_documentUpHandler"}}static get requires(){return{"Smart.Utilities.DateTime":"smart.date.js","Smart.Utilities.Draw":"smart.draw.js","Smart.Utilities.BigNumber":"smart.math.js","Smart.Utilities.NumericProcessor":"smart.numeric.js","Smart.RepeatButton":"smart.button.js","Smart.Calendar":"smart.calendar.js","Smart.TimePicker":"smart.timepicker.js"}}static get styleUrls(){return["smart.datetimepicker.css"]}template(){return'<div id="container" role="presentation">\n                    <span id="label" class="smart-label">[[label]]</span>\n                    <div id="content" class="smart-content">\n                        <input id="input" class="smart-input smart-date-time-input" type="text" readonly="[[readonly]]" disabled="[[disabled]]" placeholder="[[placeholder]]" name="[[name]]" aria-label="[[placeholder]]" />\n                        <div id="spinButtonsContainer" class="smart-spin-buttons-container" role="presentation">\n                            <smart-repeat-button initial-delay="[[spinButtonsInitialDelay]]" animation="[[animation]]" delay="[[spinButtonsDelay]]" readonly="[[readonly]]"  unfocusable id="upButton" right-to-left="[[rightToLeft]]" class="smart-spin-button" aria-label="Increment">\n                                <div class="smart-arrow smart-arrow-up" aria-hidden="true"></div>\n                            </smart-repeat-button>\n                            <smart-repeat-button initial-delay="[[spinButtonsInitialDelay]]" animation="[[animation]]" delay="[[spinButtonsDelay]]" readonly="[[readonly]]" unfocusable id="downButton" right-to-left="[[rightToLeft]]" class="smart-spin-button" aria-label="Decrement">\n                                <div class="smart-arrow smart-arrow-down" aria-hidden="true"></div>\n                            </smart-repeat-button>\n                        </div>\n                        <div id="calendarButton" class="smart-drop-down-button smart-calendar-button" role="button" aria-haspopup="dialog" aria-label="Toggle popup"></div>\n                        <div id="dropDownContainer" class="smart-drop-down smart-date-time-drop-down smart-drop-down-container smart-visibility-hidden" role="dialog">\n                            <div id="dropDownHeader" class="smart-drop-down-header smart-hidden" role="heading" aria-level="1">\n                                <div id="selectDate" class="smart-selected" role="button"></div>\n                                <div id="selectTime" role="button"></div>\n                            </div>\n                            <div id="dropDownContent" class="smart-drop-down-content" role="presentation">\n                                <smart-calendar id="calendarDropDown" class="smart-hidden"\n                                              animation="[[animation]]"\n                                              animation-settings="[[animationSettings]]"\n                                              calendar-mode="[[calendarMode]]"\n                                              day-name-format="[[dayNameFormat]]"\n                                              disable-auto-navigation="[[disableAutoNavigation]]"\n                                              display-mode-view="[[displayModeView]]"\n                                              first-day-of-week="[[firstDayOfWeek]]"\n                                              header-template="[[headerTemplate]]"\n                                              hide-day-names="[[hideDayNames]]"\n                                              hide-other-month-days="[[hideOtherMonthDays]]"\n                                              hide-tooltip-arrow="[[hideTooltipArrow]]"\n                                              important-dates="[[importantDates]]"\n                                              important-dates-template="[[importantDatesTemplate]]"\n                                              locale="[[locale]]"\n                                              right-to-left="[[rightToLeft]]"\n                                              selection-mode="one"\n                                              spin-buttons-delay="[[spinButtonsDelay]]"\n                                              spin-buttons-initial-delay="[[spinButtonsInitialDelay]]"\n                                              theme="[[theme]]"\n                                              tooltip="[[tooltip]]"\n                                              tooltip-delay="[[tooltipDelay]]"\n                                              tooltip-position="[[tooltipPosition]]"\n                                              tooltip-template="[[tooltipTemplate]]"\n                                              unfocusable="[[unfocusable]]"\n                                              view-sections=\'["header", "footer"]\'\n                                              week-numbers="[[weekNumbers]]"\n                                              weeks="[[weeks]]"></smart-calendar>\n                            </div>\n                        </div>\n                    </div>\n                    <span id="hint" inner-h-t-m-l="[[hint]]" class="smart-hint smart-hidden"></span>\n                </div>'}attached(){const e=this;super.attached(),e.isCompleted&&(e._defaultFooterTemplateApplied&&e._addCalendarFooterListeners(),e.$.timePickerDropDown&&e._addTimePickerListener(),e._positionDetection&&e._positionDetection.dropDownAttached())}detached(){const e=this;if(super.detached(),e.close(),e._defaultFooterTemplateApplied){const t=e.$.calendarDropDown.$footer;t.unlisten("change"),t.unlisten("click"),t.unlisten("wheel")}e.$.timePickerDropDown&&e.$.timePickerDropDown.$.unlisten("change"),e._positionDetection&&e._positionDetection.dropDownDetached()}ready(){super.ready();const e=this;e._edgeMacFF=Smart.Utilities.Core.Browser.Edge||Smart.Utilities.Core.Browser.Firefox&&-1!==navigator.platform.toLowerCase().indexOf("mac"),e._iOS=!!navigator.platform&&/iPad|iPhone|iPod/.test(navigator.platform),e._edgeMacFF&&e.$dropDownContainer.addClass("not-in-view"),e._defaultFooterTemplate=document.createElement("template"),e._defaultFooterTemplate.innerHTML='<div class="smart-date-time-picker-footer">\n                <div class="smart-footer-component smart-footer-component-hour" role="presentation">\n                    <input type="text" class="smart-hour-element" aria-label="Hours" />\n                    <span role="presentation">\n                        <smart-repeat-button initial-delay="0" delay="75" aria-label="Increment hours">\n                            <span class="smart-arrow smart-arrow-up" aria-hidden="true"></span>\n                        </smart-repeat-button>\n                        <smart-repeat-button  initial-delay="0" delay="75" aria-label="Decrement hours">\n                            <span class="smart-arrow smart-arrow-down" aria-hidden="true"></span>\n                        </smart-repeat-button>\n                    </span>\n                </div>\n                <div class="smart-footer-component smart-footer-component-minute" role="presentation">\n                    <input class="smart-minute-element" aria-label="Minutes" />\n                    <span role="presentation">\n                        <smart-repeat-button initial-delay="0" delay="75" aria-label="Increment minutes">\n                            <span class="smart-arrow smart-arrow-up" aria-hidden="true"></span>\n                        </smart-repeat-button>\n                        <smart-repeat-button initial-delay="0" delay="75" aria-label="Decrement minutes">\n                            <span class="smart-arrow smart-arrow-down" aria-hidden="true"></span>\n                        </smart-repeat-button>\n                    </span>\n                </div>\n                <div class="smart-footer-component smart-footer-component-ampm" role="presentation">\n                    <input type="text" class="smart-am-pm-element" aria-label="AM/PM" />\n                </div>\n                <div class="smart-footer-component smart-footer-component-today" role="presentation">\n                    <div tabindex="-1" class="smart-today-element" role="button" aria-label="Now"></div>\n                </div>\n            </div>',e._codeToMethod={y:"addYears",yy:"addYears",yyyy:"addYears",yyyyy:"addYears",M:"addMonths",MM:"addMonths",MMM:"addMonths",MMMM:"addMonths",d:"addDays",dd:"addDays",ddd:"addDays",dddd:"addDays",H:"addHours",HH:"addHours",h:"addHours",hh:"addHours",m:"addMinutes",mm:"addMinutes",s:"addSeconds",ss:"addSeconds",f:"addDeciseconds",ff:"addCentiseconds",fff:"addMilliseconds",u:"addMicroseconds",uu:"addMicroseconds",n:"addNanoseconds",nn:"addNanoseconds",p:"addPicoseconds",pp:"addPicoseconds",e:"addFemtoseconds",ee:"addFemtoseconds",a:"addAttoseconds",aa:"addAttoseconds",x:"addZeptoseconds",xx:"addZeptoseconds",o:"addYoctoseconds",oo:"addYoctoseconds"},e._codeToIndex={y:0,yy:0,yyyy:0,yyyyy:0,M:1,MM:1,MMM:1,MMMM:1,d:2,dd:2,ddd:2,dddd:2,H:3,HH:3,h:3,hh:3,m:4,mm:4,s:5,ss:5,f:6,ff:6,fff:6,u:7,uu:7,n:8,nn:8,p:9,pp:9,e:10,ee:10,a:11,aa:11,x:12,xx:12,o:13,oo:13},e._getLocalizedNames(),e.checkLicense()}render(){const e=this;e.rightToLeft&&(e.calendarButtonPosition="right"===e.calendarButtonPosition?"left":"right"),e._positionDetection=new Smart.Utilities.PositionDetection(e,e.$.dropDownContainer,e.$.content,"close"),e._positionDetection.customPositionDropDown=e._positionExternalDropDown,e._positionDetection.getDropDownParent(!0),e._positionDetection.setDropDownPosition(),e.$.dropDownContainer.style.left=null,e._positionDetection.handleAutoPositioning(),e._setIds(),e._validateInitialPropertyValues(),e._setFocusable(),e.setAttribute("role","presentation"),e.$.input.setAttribute("aria-describedby",e.$.hint.id),e.$.input.setAttribute("aria-labelledby",e.$.label.id),e.$.calendarButton.setAttribute("aria-owns",e.$.dropDownContainer.id),e.$.dropDownContainer.setAttribute("animation",e.animation),e.$.dropDownContainer.setAttribute("drop-down-display-mode",e.dropDownDisplayMode),super.render(),e.isInitialized=!0}close(){this.opened&&this._close()}focus(){this.$.input.focus()}select(){this.$.input.select()}open(){this.opened||this._open()}_handleFooter(){const e=this;if(e.footer){e.$.dropDownContainer.setAttribute("footer","");const t=e.$.calendarDropDown;"default"===e._dropDownDisplayMode?t.viewSections=["title","header","footer"]:"classic"===e._dropDownDisplayMode?t.viewSections=["header","footer"]:"calendar"===e._dropDownDisplayMode&&(t.viewSections=["title","header","footer"])}else e.$.dropDownContainer.removeAttribute("footer")}propertyChangedHandler(e,t,a){super.propertyChangedHandler(e,t,a);const n=this;switch(e){case"animation":case"theme":n.$.timePickerDropDown&&(n.$.timePickerDropDown[e]=a),"animation"===e&&(n.$.dropDownContainer.setAttribute("animation",n.animation),n._defaultFooterTemplateApplied&&Array.from(n.$.calendarDropDown.$.footer.getElementsByTagName("smart-repeat-button")).forEach((function(e){e.animation=a})));break;case"calendarButton":n.$.dropDownContainer.style.transition="none",a||n.close();break;case"calendarButtonPosition":n.$.dropDownContainer.style.transition="none",n.close(),"left"===a?n.$.content.insertBefore(n.$.calendarButton,n.$.content.firstElementChild):null===n._dropDownParent?n.$.content.insertBefore(n.$.calendarButton,n.$.dropDownContainer):n.$.content.appendChild(n.$.calendarButton);break;case"disabled":a?(n.close(),n.$.upButton.disabled=!0,n.$.downButton.disabled=!0):n._disableSpinButtons(),n._setFocusable(),n._positionDetection.handleAutoPositioning();break;case"displayKind":{const e=n._outputTimeZone;switch(a){case"unspecified":n._outputTimeZone=n._inputTimeZone;break;case"UTC":n._outputTimeZone="UTC";break;case"local":n._outputTimeZone="Local"}if(n._outputTimeZone===e)return;null!==n._value&&(n.close(),n._toSync=!0,n._value=n._value.toTimeZone(n._outputTimeZone),n._applyFormatString()),n.min=n.min.toTimeZone(n._outputTimeZone),n.max=n.max.toTimeZone(n._outputTimeZone);for(let e=0;e<n.restrictedDates.length;e++){let t=n.restrictedDates[e];t=t.toTimeZone(n._outputTimeZone)}break}case"dropDownAppendTo":n._positionDetection.dropDownAppendToChangedHandler();break;case"dropDownDisplayMode":n._changeDropDownDisplayMode();break;case"dropDownOverlay":a||n._positionDetection.removeOverlay();break;case"dropDownPosition":n._positionDetection.dropDownPositionChangedHandler();break;case"footer":n._handleFooter();break;case"footerTemplate":if(null!==a){n._defaultFooterTemplateApplied=!1;const e=n.$.calendarDropDown.$footer;e.unlisten("change"),e.unlisten("click"),e.unlisten("wheel"),n.$.calendarDropDown.footerTemplate=a}else{n._setDefaultFooterTemplate();const e=n._value;n._hourElement.value=e.toString("hh"),n._minuteElement.value=e.toString("mm"),n._ampmElement.value=e.toString("tt")}n._handleFooter();break;case"formatString":""===a&&(n.formatString="dd-MMM-yy HH:mm:ss.fff"),n._getFormatStringRegExp(),n._applyFormatString(),"auto"===n.dropDownDisplayMode&&n._changeDropDownDisplayMode(),n._timePickerInitialized&&(n.$.timePickerDropDown.format=n._formatStringRegExp.groups.find((e=>-1!==e.indexOf("H")))?"24-hour":"12-hour");break;case"interval":n._validateInterval(t);break;case"locale":case"messages":if(n.$.selectDate.innerHTML=n.localize("dateTabLabel"),n.$.selectTime.innerHTML=n.localize("timeTabLabel"),n._defaultFooterTemplateApplied&&(n._todayElement.title=n.localize("now")),"messages"===e)return;n._getLocalizedNames(),n.min.calendar.days=n._localizedDays,n.min.calendar.months=n._localizedMonths,n.min.calendar.locale=n.locale,n.max.calendar.days=n._localizedDays,n.max.calendar.months=n._localizedMonths,n.max.calendar.locale=n.locale,null!==n.value&&(n._value.calendar.days=n._localizedDays,n._value.calendar.months=n._localizedMonths,n._value.calendar.locale=n.locale,n.value.calendar.days=n._localizedDays,n.value.calendar.months=n._localizedMonths,n.value.calendar.locale=n.locale),Smart.Utilities.DateTime.cache=[],n._applyFormatString();break;case"max":case"min":n._validateMinMax(e,t),"strict"===n.validation?n._validateValue():n._minMaxChanged=!0;break;case"nullable":!0===t&&null===n._value&&n._validateValue(n._now(),null);break;case"opened":a?n._open():n._close();break;case"readonly":case"unfocusable":a&&n.close(),"unfocusable"===e&&n._setFocusable();break;case"restrictedDates":n._validateRestrictedDates(),n._validateValue();break;case"spinButtonsPosition":"right"===a?n.$.content.insertBefore(n.$.spinButtonsContainer,n.$.input.nextElementSibling):n.$.content.insertBefore(n.$.spinButtonsContainer,n.$.input);break;case"validation":"strict"===a&&(delete n._minMaxChanged,n._validateValue());break;case"value":{let e;null!==a?(e=Smart.Utilities.DateTime.validateDate(a,n._now(),n.formatString),e=e.toTimeZone(n._outputTimeZone)):e=null,n._validateValue(e,n._value,void 0,!0);break}}}setDate(e){const t=this;let a;null!==e?(a=Smart.Utilities.DateTime.validateDate(e,t._now(),t.formatString),a=a.toTimeZone(t._outputTimeZone)):a=null,t._validateValue(a,t._value,void 0,!0)}getDate(){return this.value&&this.value.toDate?this.value.toDate():null}_addCalendarFooterListeners(){const e=this,t=e.$.calendarDropDown.$footer;t.listen("change",e._footerChangeHandler.bind(e)),t.listen("click",e._footerClickHandler.bind(e)),t.listen("wheel",e._footerWheelHandler.bind(e))}_updateTargetValue(){const e=this;if(e.dataset.target){const t=document.querySelector(e.dataset.target);if(t){const a=e.dataset.property,n=e.value;a&&void 0!==t[a]&&(t[a]=n)}}}_addTimePickerListener(){const e=this;e.$.timePickerDropDown.$.listen("change",(function(t){const a=e.context,n=t.detail.value,i=Smart.Utilities.DateTime.getConstructorParameters(null!==e._value?e._value:e._now());e.context=e,i[3]=n.getHours(),i[4]=n.getMinutes(),e._timePickerInitiatedChange=!0,i.unshift(null),e._validateValue(new(Function.prototype.bind.apply(Smart.Utilities.DateTime,i))),e._timePickerInitiatedChange=!1,e.context=a}))}_applyFormatString(){const e=this;null!==e.value&&(e.$.input.value=e._value.toString(e.formatString))}_calendarButtonClickHandler(e){const t=this;t._highlightedTimePart=void 0,t.disabled||t.readonly||(t.hasRippleAnimation&&Smart.Utilities.Animation.Ripple.animate(t.$.calendarButton,e.pageX,e.pageY),t.opened?t._close():t._open())}_calendarDropDownChangeHandler(e){const t=this;if(e.stopPropagation(),t._disregardCalendarChangeEvent)t._disregardCalendarChangeEvent=!1;else if(this.$.calendarDropDown.selectedDates.length>0){const a=e.detail.value[0],n=null!==t._value?t._value:t._now(),i=Smart.Utilities.DateTime.getConstructorParameters(n);if(i[0]=a.getFullYear(),i[1]=a.getMonth()+1,i[2]=a.getDate(),t._calendarInitiatedChange=!0,i.unshift(null),t._validateValue(new(Function.prototype.bind.apply(Smart.Utilities.DateTime,i))),t._defaultFooterTemplateApplied){const e=t._value;""===t._hourElement.value&&(t._hourElement.value=e.toString("hh")),""===t._ampmElement.value&&(t._ampmElement.value=e.toString("tt")),""===t._minuteElement.value&&(t._minuteElement.value=e.toString("mm"))}t._calendarInitiatedChange=!1}else t._setNullValue()}_calendarDropDownClickHandler(e){const t=this;t.autoClose&&e.target.closest(".smart-calendar-cell")&&(clearTimeout(t._autoCloseTimeout),t._autoCloseTimeout=setTimeout((function(){t.close()}),t.autoCloseDelay))}_changeDropDownDisplayMode(){function e(e,a,n,i){t.$dropDownHeader[e]("smart-hidden"),t.$calendarDropDown[a]("smart-hidden"),t._timePickerInitialized&&t.$.timePickerDropDown.$[n]("smart-hidden"),i&&(t.opened?t.$.calendarDropDown._refreshTitle():t._toSync=!0)}const t=this,a=t._dropDownDisplayMode;t._detectDisplayMode(),t._dropDownDisplayMode!==a&&("default"===t._dropDownDisplayMode?(t.calendarMode="default",t.$.calendarDropDown.viewSections=["title","header"],t.$selectDate.addClass("smart-selected"),t.$selectTime.removeClass("smart-selected"),e("removeClass","removeClass","addClass",!0)):"classic"===t._dropDownDisplayMode?(t.calendarMode="classic",t.$.calendarDropDown.viewSections=["header","footer"],e("addClass","removeClass","addClass")):"calendar"===t._dropDownDisplayMode?(t.calendarMode="default",t.$.calendarDropDown.viewSections=["title","header"],e("addClass","removeClass","addClass",!0)):(t.calendarMode="default",e("addClass","addClass","removeClass"),t._timePickerInitialized||t._initializeTimePicker()),t.$.dropDownContainer.setAttribute("drop-down-display-mode",t.dropDownDisplayMode))}_cloneValue(){const e=this;return null!==e._value?e._value.clone():null}_close(){const e=this;if(e.$.fireEvent("closing").defaultPrevented)e.opened=!0;else{e.$.calendarDropDown.disabled=!0,e.$calendarButton.removeClass("smart-calendar-button-pressed"),e.$.calendarButton.removeAttribute("active"),e.$dropDownContainer.addClass("smart-visibility-hidden");const t=e.$.calendarDropDown.$.container.querySelector(".smart-calendar-cell[hover]");t&&t.removeAttribute("hover"),e.opened=!1,e._positionDetection.removeOverlay(!0),e.$.fireEvent("close"),e._edgeMacFF&&!e.hasAnimation&&(e.$.dropDownContainer.style.top=null,e.$.dropDownContainer.style.left=null,e.$dropDownContainer.addClass("not-in-view")),e.$.input.focus()}e.$.calendarButton.setAttribute("aria-expanded",e.opened)}_detectDisplayMode(){const e=this;"auto"!==e.dropDownDisplayMode?e._dropDownDisplayMode=e.dropDownDisplayMode:e._dropDownDisplayMode=Smart.Utilities.DateTime.detectDisplayMode(e.value||e.min,e.formatString,e._formatStringRegExp),"timePicker"===e._dropDownDisplayMode?(e.$calendarButton.addClass("time"),"Enter date"===e.placeholder&&(e.placeholder="Enter time")):(e.$calendarButton.removeClass("time"),"Enter time"===e.placeholder&&(e.placeholder="Enter date")),"default"===e._dropDownDisplayMode?e.$dropDownContent.removeClass("partial"):e.$dropDownContent.addClass("partial")}_disableSpinButtons(){const e=this;if(e.disabled)return;const t=null===e._value;e.$.upButton.disabled=t,e.$.downButton.disabled=t}_documentUpHandler(e){const t=this,a=(t.shadowRoot||t.getRootNode()).activeElement||document.activeElement,n=t.shadowRoot||t.isInShadowDOM?e.originalEvent.composedPath()[0]:e.originalEvent.target;Smart.Utilities.Core.isMobile||a!==t.$.input||"partial"!==t.editMode||null===t._value||n===t.$.input&&t.$.input.selectionStart!==t.$.input.selectionEnd?n===t.$.calendarButton||t.$.dropDownContainer.contains(n)||t.$.dropDownContainer.contains(t._getRootShadowHost(n))||(t.close(),a===t.$.input||t.contains(n)||(t._highlightedTimePart=void 0)):(t._highlightedTimePartEdit=!1,t._validateValue(t.$.input.value,t._cloneValue(),!1),t._highlightTimePartBasedOnCursor()),t._mouseFocus=!1}_getRootShadowHost(e){const t=this;if(!t.shadowRoot&&!t.isInShadowDOM)return;let a,n=e.getRootNode().host;for(;n&&n!==t&&n!==document;)a=n,n=n.getRootNode().host;return a}_dropDownHeaderClickHandler(e){const t=this;if(e.target===t.$.selectDate){if(t.$selectDate.hasClass("smart-selected"))return;t.$selectDate.addClass("smart-selected"),t.$selectTime.removeClass("smart-selected"),t.$.timePickerDropDown.$.addClass("smart-hidden"),t.$calendarDropDown.removeClass("smart-hidden")}else{if(t.$selectTime.hasClass("smart-selected"))return;t.$selectDate.removeClass("smart-selected"),t.$selectTime.addClass("smart-selected"),t.$calendarDropDown.addClass("smart-hidden"),t._timePickerInitialized?t.$.timePickerDropDown.$.removeClass("smart-hidden"):t._initializeTimePicker()}}_dropDownKeydownHandler(e){const t=this,a=e.key,n=t.shadowRoot?t.shadowRoot.activeElement:document.activeElement;!t.$.dropDownHeader.contains(n)||"Enter"!==a&&" "!==a?"Escape"===a||e.altKey&&"ArrowUp"===a?(e.preventDefault(),t.close(),t.$.input.focus()):"Enter"!==a&&" "!==a||!n.classList.contains("smart-footer-component-today")?"Enter"===a&&(n===t.$.calendarDropDown.$.body&&t.$.calendarDropDown.querySelectorAll(".smart-calendar-cell[selected][focus]").length>0||t._timePickerInitialized&&n===t.$.timePickerDropDown.$.picker)&&(e.preventDefault(),t.close()):(e.preventDefault(),t._validateValue(t._now()),t.close()):(e.preventDefault(),t._dropDownHeaderClickHandler({target:n}))}_dropDownTransitionendHandler(){const e=this;if(e.hasAnimation)return e.opened&&e._toFocus?(e._toFocus.focus(),delete e._toFocus,void(e._timePickerInitialized&&!e.$.timePickerDropDown.classList.contains("smart-hidden")&&requestAnimationFrame((()=>e.$.timePickerDropDown._highlightLabel())))):e._edgeMacFF&&!e.opened?(e.$.dropDownContainer.style.top=null,e.$.dropDownContainer.style.left=null,void e.$dropDownContainer.addClass("not-in-view")):void 0}_footerChangeHandler(e){const t=this,a=t.context,n=e.target,i=null!==t._value?t._value:t._now();let o,l=n.value;if(t.context=t,e.stopPropagation(),n.classList.contains("smart-hour-element")){if(l=parseInt(l,10),isNaN(l)||l<0||l>12)return void(n.value=i.toString("hh"));l>0&&l<12&&"PM"===i.toString("tt")&&(l+=12),o="hh"}else{if(!n.classList.contains("smart-minute-element")){if(null===t._value)return void(n.value="");const e=i.toString("tt");return l=l.toLowerCase(),void("PM"===e&&("a"===l||"am"===l)||"AM"===e&&("p"===l||"pm"===l)?(t._incrementDecrement(void 0,"tt"),n.value=t._value.toString("tt")):n.value=e)}if(l=parseInt(l,10),isNaN(l)||l<0||l>59)return void(n.value=i.toString("mm"));o="mm"}const r=Smart.Utilities.DateTime.getConstructorParameters(i);r[t._codeToIndex[o]]=l,r.unshift(null),t._validateValue(new(Function.prototype.bind.apply(Smart.Utilities.DateTime,r))),n.value=t._value.toString(o),t.context=a}_footerClickHandler(e){const t=this,a=t.context,n=e.target;if(t.context=t,n.classList.contains("smart-today-element"))t._validateValue(t._now()),t.autoClose&&(clearTimeout(t._autoCloseTimeout),t._autoCloseTimeout=setTimeout((function(){t.close()}),t.autoCloseDelay));else{const e=n.closest("smart-repeat-button");if(null!==e){const a=e===e.parentElement.children[1],n=e.closest(".smart-footer-component").classList.contains("smart-footer-component-hour")?"hh":"mm";t._incrementDecrement(a,n)}}t.context=a}_footerWheelHandler(e){const t=this,a=t.shadowRoot?t.shadowRoot.activeElement:document.activeElement;if(t.enableMouseWheelAction&&e.target instanceof HTMLInputElement&&a===e.target){const a=t.context,n=e.target;t.context=t,n.classList.contains("smart-hour-element")?t._incrementDecrement(e.deltaY>0,"hh"):n.classList.contains("smart-minute-element")?t._incrementDecrement(e.deltaY>0,"mm"):t._incrementDecrement(void 0,"tt"),t.context=a,e.stopPropagation()}}_getAndHighlightTimePart(e,t,a){const n=this;n._programmaticSelection=!0,n.$.input.selectionStart!==e||n.$.input.selectionEnd!==t?n.$.input.setSelectionRange(e,t):setTimeout((function(){n.$.input.setSelectionRange(e,t)}),200),n._highlightedTimePart={code:n._formatStringRegExp.groups[a],index:a,from:e,to:t}}_getFormatStringRegExp(){const e=this;e._formatStringRegExp=e.min.getParseRegExp(e.min.calendar,e.formatString.replace(/y+/g,"yyyyy")),e._formatStringRegExp.regExp=new RegExp(e._formatStringRegExp.regExp)}_getLocalizedNames(){const e=this,t=Smart.Utilities.DateTime.getLocalizedNames(e.locale);e._localizedDays=t.days,e._localizedMonths=t.months,e.$.selectDate.innerHTML=e.localize("dateTabLabel"),e.$.selectTime.innerHTML=e.localize("timeTabLabel")}_handleManualTimePartEdit(e){const t=this,a=Smart.Utilities.DateTime.getConstructorParameters(t._value);if(e=e[t._highlightedTimePart.index+1],isNaN(e)){if(1===t._codeToIndex[t._highlightedTimePart.code]){let n=-1;if(e.length>1&&t._localizedMonths.names.some((function(t,a){if(-1!==t.toLowerCase().indexOf(e.toLowerCase()))return n=a,!0})),-1===n)return void t._applyFormatString();a[1]=n+1}}else{if("f"===t._highlightedTimePart.code)e=100*parseInt(e,10);else if("ff"===t._highlightedTimePart.code)e=10*parseInt(e,10);else if(-1!==t._highlightedTimePart.code.indexOf("y")&&e.length<3){const a=t.yearCutoff.toString(),n=parseInt(a.slice(2),10);let i=parseInt(a.slice(0,2),10);(e=parseInt(e,10))<n&&i++,e=e.toString(),e=i+""+"0".repeat(2-e.length)+e}else if(-1!==t._highlightedTimePart.code.indexOf("h")){const a=t._value.hour();e=parseInt(e,10),a>11&&e<=11&&(e+=12)}a[t._codeToIndex[t._highlightedTimePart.code]]=parseInt(e,10)}try{a.unshift(null),t._validateValue(new(Function.prototype.bind.apply(Smart.Utilities.DateTime,a)))}catch(e){t._applyFormatString()}}_highlightTimePartBasedOnCursor(e){const t=this,a=t.$.input.value,n=t._formatStringRegExp.regExp.exec(a);function i(){return void 0===e?t.$.input.selectionStart:e}if(null===n)return void(t._highlightedTimePart=void 0);t._iOS||void 0!==e||(e=t.$.input.selectionStart);let o,l=n.index;for(let e=1;e<n.length;e++){const r=n[e];if(o=a.indexOf(r,l),l=o+r.length,1===e&&i()<o){t._getAndHighlightTimePart(o,l,0);break}if(i()>=o&&i()<=l){t._getAndHighlightTimePart(o,l,e-1);break}const s=n[e+1];if(!s){t._programmaticSelection=!0,t.$.input.setSelectionRange(o,l),t._highlightedTimePart={code:t._formatStringRegExp.groups[e-1],index:e-1,from:o,to:l};break}{const n=a.indexOf(s,l);if(i()>l&&i()<n){i()-l<=n-i()?t._getAndHighlightTimePart(o,l,e-1):(t._formatStringRegExp.groups[e],t._programmaticSelection=!0,t.$.input.setSelectionRange(n,n+s.length));break}}}}_highlightTimePartBasedOnIndex(e){const t=this,a=t.$.input.value,n=t._formatStringRegExp.regExp.exec(a);if(null===n)return t._validateValue(void 0,t._cloneValue(),!1),void t._highlightTimePartBasedOnIndex(e);let i,o=n.index;const l=t.shadowRoot?t.shadowRoot.activeElement:document.activeElement;if(!(e<0||e>=n.length)){t.$.input!==l&&t.$.input.focus();for(let l=1;l<n.length;l++){const r=n[l];if(i=a.indexOf(r,o),o=i+r.length,e===l-1){t._getAndHighlightTimePart(i,o,e);break}}}}_incrementDecrement(e,t){const a=this,n=a._cloneValue();if(a._minMaxChanged&&(a._value=a._rangeValidation(a._value),delete a._minMaxChanged),void 0===t&&a._highlightedTimePart&&(t=a._highlightedTimePart.code),void 0!==t){if("z"===t||"zz"===t||"zzz"===t)return void a._highlightTimePartBasedOnIndex(a._highlightedTimePart.index);a._value="t"===t||"tt"===t?a._value.addHours(a._value.hour()<12?12:-12,!0):a._value[a._codeToMethod[t]](e?-1:1,!0),a._validateValue(void 0,n,!1),a._highlightedTimePart&&a._highlightTimePartBasedOnIndex(a._highlightedTimePart.index)}else a._value=a._value.add(e?a.interval.negate():a.interval,void 0,!0),a._validateValue(void 0,n,!1);0!==n.compare(a._value)&&a.isInitialized&&(a.$.fireEvent("change",{oldValue:n.toTimeZone(a._inputTimeZone),value:a.value}),a._updateTargetValue())}_initializeTimePicker(){const e=this,t=document.createElement("smart-time-picker");t.rightToLeft=e.rightToLeft,t.animation=e.animation,t.autoSwitchToMinutes=e.autoSwitchToMinutes,t.format=e._formatStringRegExp.groups.find((e=>-1!==e.indexOf("H")))?"24-hour":"12-hour",t.theme=e.theme,t.value=null!==e._value?e._value.toDate():e._now(),e.$.timePickerDropDown=t,t.$=Smart.Utilities.Extend(t),e.$.dropDownContent.appendChild(t),e._timePickerInitialized=!0,e._addTimePickerListener()}_inputBlurHandler(){const e=this;e.removeAttribute("focus"),e._fullEdit=!1,e._highlightedTimePartEdit=!1,e.$.fireEvent("blur")}_inputChangeHandler(e){const t=this;if(e&&e.stopPropagation(),""!==t.$.input.value){if(t._fullEdit||null===t._value)t._fullEdit=!1,t._validateValue(t.$.input.value),t._highlightTimePartBasedOnCursor();else if(t._highlightedTimePartEdit){t._highlightedTimePartEdit=!1;let e=t._formatStringRegExp.regExp.exec(t.$.input.value);null!==e?t._handleManualTimePartEdit(e):t._applyFormatString()}}else t._setNullValue()}_inputDragstartHandler(e){e.preventDefault()}_inputFocusHandler(){const e=this;if(e.setAttribute("focus",""),"full"!==e.editMode){const t=Smart.Utilities.Core.isMobile?10:0;setTimeout((function(){e._iOS?e._highlightTimePartBasedOnCursor():!0!==e._mouseFocus&&(void 0===e._highlightedTimePart?e._highlightTimePartBasedOnCursor(e._iOS?void 0:0):e._highlightTimePartBasedOnIndex(e._highlightedTimePart.index))}),t)}e.$.fireEvent("focus")}_inputKeydownHandler(e){const t=this,a=t.editMode,n=e.key;if("Tab"!==n){if(e.altKey&&"ArrowDown"===n)return e.preventDefault(),void t.open();if("Escape"===n||e.altKey&&"ArrowUp"===n)return e.preventDefault(),void t.close();if("full"!==a){if("partial"===a){if("Delete"===n)return void(null!==t._value&&(t._setNullValue(),e.preventDefault()));if(null===t._value&&(t._validateValue(t._now(),null,!1),t._highlightTimePartBasedOnIndex(0)),-1!==["/",".","-",","," "].indexOf(n))return t._inputChangeHandler(),t._navigateToNextTimePart(),void e.preventDefault();if("Backspace"===n)return t._resetTimePart(),t._highlightedTimePart.index>0?t._navigateToPreviousTimePart():t._highlightTimePartBasedOnIndex(0),void e.preventDefault()}else if(t._fullEdit||t._highlightedTimePartEdit||t.readonly||-1!==["Alt","Control","Shift"].indexOf(n)||e.altKey||e.ctrlKey)return;if(-1!==["End","Home","ArrowLeft","ArrowUp","ArrowRight","ArrowDown"].indexOf(n)){if(e.preventDefault(),"partial"===a&&t._highlightedTimePartEdit&&t._inputChangeHandler(),null!==t._value)switch(n){case"End":t._highlightTimePartBasedOnIndex(t._formatStringRegExp.groups.length-1);break;case"Home":t._highlightTimePartBasedOnIndex(0);break;case"ArrowLeft":t._navigateToPreviousTimePart();break;case"ArrowUp":t._incrementDecrement();break;case"ArrowRight":t._navigateToNextTimePart();break;case"ArrowDown":t._incrementDecrement(!0)}}else if(t._highlightedTimePart){if("partial"!==a&&t._highlightedTimePart.to-t._highlightedTimePart.from!=t.$.input.selectionEnd-t.$.input.selectionStart)return void(t._fullEdit=!0);const i=t._highlightedTimePart.code;if("ddd"===i||"dddd"===i||"z"===i||"zz"===i||"zzz"===i||"t"===i||"tt"===i)return void e.preventDefault();if("partial"===a&&"MMM"!==i&&"MMMM"!==i&&!1===new RegExp(/^\d+$/).test(n))return void((n.length<2||"F"!==n.charAt(0))&&e.preventDefault());t._highlightedTimePartEdit=!0}}else t._fullEdit=!0}}_inputDownHandler(){const e=this;e._fullEdit||e._highlightedTimePartEdit||"full"===e.editMode||Smart.Utilities.Core.isMobile||setTimeout((function(){e._mouseFocus=!0,e._highlightTimePartBasedOnCursor()}),0)}_inputPasteHandler(e){"partial"===this.editMode?e.preventDefault():this._fullEdit=!0}_inputSelectHandler(){const e=this,t=e.shadowRoot?e.shadowRoot.activeElement:document.activeElement;"partial"===e.editMode&&t===e.$.input&&(!0===e._programmaticSelection?e._programmaticSelection=!1:e._highlightedTimePart?e._highlightTimePartBasedOnIndex(e._highlightedTimePart.index):e._highlightTimePartBasedOnIndex(0))}_inputUpHandler(){const e=this;Smart.Utilities.Core.isMobile&&(e._iOS?(e._mouseFocus=!0,setTimeout((function(){document.activeElement===e.$.input&&e._highlightTimePartBasedOnCursor()}),50)):setTimeout((function(){e._mouseFocus=!0,e._highlightTimePartBasedOnCursor()}),10))}_inputWheelHandler(e){const t=this;(t.shadowRoot?t.shadowRoot.activeElement:document.activeElement)!==t.$.input||!t.enableMouseWheelAction||t.disabled||t.readonly||(e.preventDefault(),t._incrementDecrement(e.deltaY>0))}_isRestricted(e){const t=this.restrictedDates;let a=!1;for(let n=0;n<t.length;n++)if(e.equalDateParts(t[n])){a=!0;break}return a}_mouseoutHandler(e){const t=this,a=e.target;t.disabled||a!==t.$.input&&a!==t.$.calendarButton||(a.removeAttribute("hover"),t.removeAttribute("hover"))}_mouseoverHandler(e){const t=this,a=e.target;t.disabled||a!==t.$.input&&a!==t.$.calendarButton||(a.setAttribute("hover",""),t.setAttribute("hover",""))}_navigateToNextTimePart(){this._highlightTimePartBasedOnIndex(this._highlightedTimePart.index+1)}_navigateToPreviousTimePart(){this._highlightTimePartBasedOnIndex(this._highlightedTimePart.index-1)}_now(){const e=this,t=new Smart.Utilities.DateTime("today","Local");return"Local"!==e._outputTimeZone?t.toTimeZone(e._outputTimeZone):t}_open(e){const t=this;if(t.disabled||t.readonly)return t.opened=!1,void t.$.calendarButton.setAttribute("aria-expanded",!1);if(t.$.fireEvent("opening").defaultPrevented)return t.opened=!1,void t.$.calendarButton.setAttribute("aria-expanded",!1);t._edgeMacFF&&t.$dropDownContainer.removeClass("not-in-view");const a=t.$.dropDownContainer;a.style.marginLeft=null,e||(a.style.transition=""),t.$.calendarDropDown.disabled=!1,t.$calendarButton.addClass("smart-calendar-button-pressed"),t.$.calendarButton.setAttribute("active",""),("default"!==t._dropDownDisplayMode&&"timePicker"!==t._dropDownDisplayMode||!t._timePickerInitialized||t._timePickerInitialized&&t.$.timePickerDropDown.$.hasClass("smart-hidden"))&&t.$calendarDropDown.removeClass("smart-hidden"),t.opened=!0,t.$.calendarButton.setAttribute("aria-expanded",!0),t._positionDetection.placeOverlay(),t._positionDetection.checkBrowserBounds("vertically"),t._positionDetection.positionDropDown(),t.$dropDownContainer.removeClass("smart-visibility-hidden");const n=1===window.devicePixelRatio?document.documentElement.clientWidth:window.innerWidth,i=a.getBoundingClientRect();if(i.left<0?a.style.marginLeft=-1*i.left+"px":i.right>n&&(a.style.marginLeft=n-i.right+"px"),t.$.fireEvent("open"),t._toSync){const e=t._value;if(null!==e)t._disregardCalendarChangeEvent=!0,t.$.calendarDropDown.selectedDates=[e.toDate()],t._defaultFooterTemplateApplied&&(t._hourElement.value=e.toString("hh"),t._minuteElement.value=e.toString("mm"),t._ampmElement.value=e.toString("tt")),t._timePickerInitialized&&(t.$.timePickerDropDown.value=e.toDate()),t._disregardCalendarChangeEvent=!1;else{const e=t.$.calendarDropDown.context;t.$.calendarDropDown.context=t.$.calendarDropDown,t.$.calendarDropDown._clearSelection(!0),t.$.calendarDropDown.context=e,t._defaultFooterTemplateApplied&&(t._hourElement.value="",t._minuteElement.value="",t._ampmElement.value="")}t._toSync=!1}let o;switch(t._dropDownDisplayMode){case"default":o=t.$selectDate.hasClass("smart-selected")?t.$.calendarDropDown:t.$.timePickerDropDown.$.picker;break;case"classic":case"calendar":o=t.$.calendarDropDown;break;case"timePicker":o=t.$.timePickerDropDown.$.picker}t.hasAnimation?(t._toFocus=o,function e(){t._toFocus&&(0===t.$.dropDownContainer.getBoundingClientRect().height?requestAnimationFrame(e):t._dropDownTransitionendHandler())}()):o.focus()}_positionExternalDropDown(e){const t=this.context,a=!t.calendarButton||"right"===t.calendarButtonPosition,n=t._dropDownListPosition,i=t.$.dropDownContainer;let o,l=a?e.right-i.offsetWidth:e.left;switch(n){case"bottom":o=e.bottom;break;case"overlay-top":o=e.bottom-i.offsetHeight;break;case"overlay-center":o=e.top+e.height/2-i.offsetHeight/2;break;case"overlay-bottom":o=e.top;break;case"top":o=e.top-i.offsetHeight;break;case"center-bottom":case"center-top":o="center-bottom"===n?e.bottom+5:e.top-5-i.offsetHeight,l=a?e.right-i.offsetWidth/2-t.$.calendarButton.offsetWidth/2:e.left-i.offsetWidth/2+t.$.calendarButton.offsetWidth/2}return{left:l,top:o}}_rangeValidation(e){const t=this;return-1===e.compare(t.min)?t.min.clone():1===e.compare(t.max)?t.max.clone():e}_resetTimePart(){const e=this,t=e._highlightedTimePart.code,a=e._codeToIndex[t],n=Smart.Utilities.DateTime.getConstructorParameters(e._value);let i;i=a>2?0:a>0?1:e.min.year(),n[a]=i,n.unshift(null),e._validateValue(new(Function.prototype.bind.apply(Smart.Utilities.DateTime,n)))}_setIds(){const e=this;e.$.label.id||(e.$.label.id=e.id+"Label"),e.$.input.id||(e.$.input.id=e.id+"Input"),e.$.calendarButton.id||(e.$.calendarButton.id=e.id+"CalendarButton"),e.$.dropDownContainer.id||(e.$.dropDownContainer.id=e.id+"DropDownContainer"),e.$.hint.id||(e.$.hint.id=e.id+"Hint")}_setDefaultFooterTemplate(e){const t=this;t.$.calendarDropDown.footerTemplate=t._defaultFooterTemplate,e&&t.$.calendarDropDown._handleLayoutTemplate(t.$.calendarDropDown.$.footer,t._defaultFooterTemplate),t._hourElement=t.$.calendarDropDown.getElementsByClassName("smart-hour-element")[0],t._minuteElement=t.$.calendarDropDown.getElementsByClassName("smart-minute-element")[0],t._ampmElement=t.$.calendarDropDown.getElementsByClassName("smart-am-pm-element")[0],t._todayElement=t.$.calendarDropDown.getElementsByClassName("smart-today-element")[0],t._todayElement.title=t.localize("now"),Array.from(t.$.calendarDropDown.$.footer.getElementsByTagName("smart-repeat-button")).forEach((function(e){e.animation=t.animation})),t._addCalendarFooterListeners(),t._defaultFooterTemplateApplied=!0}_setFocusable(){const e=this;if(e.disabled||e.unfocusable)return e.$.input.tabIndex=-1,e.$.selectDate.removeAttribute("tabindex"),e.$.selectTime.removeAttribute("tabindex"),void(e._defaultFooterTemplateApplied&&(e._hourElement.tabIndex=-1,e._ampmElement.tabIndex=-1,e._minuteElement.tabIndex=-1));const t=e.tabIndex>0?e.tabIndex:0;e.$.input.removeAttribute("tabindex"),e.$.selectDate.tabIndex=t,e.$.selectTime.tabIndex=t,e._defaultFooterTemplateApplied&&(e._hourElement.removeAttribute("tabindex"),e._ampmElement.removeAttribute("tabindex"),e._minuteElement.removeAttribute("tabindex"),e.$.calendarDropDown.getElementsByClassName("smart-footer-component-today")[0].tabIndex=t)}_setNullValue(e){const t=this;if(void 0===e&&(e=t._cloneValue()),t.nullable){if(t._value=null,t.value=null,t._highlightedTimePart=void 0,t.$.input.value="",null!==e){if(t.opened){if(!t._calendarInitiatedChange){const e=t.$.calendarDropDown.context;t.$.calendarDropDown.context=t.$.calendarDropDown,t.$.calendarDropDown._clearSelection(!0),t.$.calendarDropDown.context=e}t._defaultFooterTemplateApplied&&(t._hourElement.value="",t._ampmElement.value="",t._minuteElement.value=""),t._toSync=!1}else t._toSync=!0;t.isInitialized&&(t.$.fireEvent("change",{oldValue:e.toTimeZone(t._inputTimeZone),value:null}),t._updateTargetValue())}t._disableSpinButtons()}else t._validateValue(t._now(),e)}_spinButtonsClickHandler(e){const t=this;null===t._value||t.disabled||t.readonly||t._incrementDecrement(t.$.downButton.contains(e.target))}_validateInitialPropertyValues(){const e=this,t=e.$.calendarDropDown;"left"===e.calendarButtonPosition&&e.$.content.insertBefore(e.$.calendarButton,e.$.input),"left"===e.spinButtonsPosition&&e.$.content.insertBefore(e.$.spinButtonsContainer,e.$.input),e.disabled&&(e.$.upButton.disabled=!0,e.$.downButton.disabled=!0),e.opened&&(e.disabled||e.readonly?e.opened=!1:(e.$.dropDownContainer.style.transition="none",e._open(!0))),e.$.calendarButton.setAttribute("aria-expanded",e.opened),null===e.footerTemplate?e._setDefaultFooterTemplate(!0):(t.footerTemplate=e.footerTemplate,t._handleLayoutTemplate(t.$.footer,e.footerTemplate)),""===e.formatString&&(e.formatString="dd-MMM-yy HH:mm:ss.fff");const a=e.displayKind;let n;if("UTC"===a?e._outputTimeZone="UTC":"local"===a&&(e._outputTimeZone="Local"),null!==e.value?(n=Smart.Utilities.DateTime.validateDate(e.value,new Smart.Utilities.DateTime,e.formatString),e._inputTimeZone=n.timeZone,"unspecified"!==a&&e._inputTimeZone!==e._outputTimeZone?n=n.toTimeZone(e._outputTimeZone):"unspecified"===a&&(e._outputTimeZone=e._inputTimeZone)):(n=null,e._inputTimeZone="Local"),e._validateRestrictedDates(),e._validateMinMax("both"),e._validateValue(n,e._now(),!1,!0),e._validateInterval(new Smart.Utilities.TimeSpan(0,0,1)),e._getFormatStringRegExp(),e._defaultFooterTemplateApplied&&""===e._hourElement.value&&null!==e.value){const t=e.value;e._hourElement.value=t.toString("hh"),e._ampmElement.value=t.toString("tt"),e._minuteElement.value=t.toString("mm")}e._detectDisplayMode();const i=e._dropDownDisplayMode;"default"===i||"calendar"===i?(t.viewSections=["title","header"],t.$title.hasClass("smart-hidden")&&t.propertyChangedHandler("viewSections",["header","footer"],["title","header"]),"default"===i&&e.$dropDownHeader.removeClass("smart-hidden")):"timePicker"===i&&(e.$calendarDropDown.addClass("smart-hidden"),e._initializeTimePicker()),e.footer&&e._handleFooter()}_validateInterval(e){const t=this,a=t.interval;let n=a;if(a instanceof Smart.Utilities.TimeSpan)n=a;else if("string"==typeof a){const i=a.indexOf("TimeSpan("),o=a.indexOf(")");if(-1!==i&&-1!==o&&(n=a.slice(i+9,o),n=n.replace(/'/g,"").replace(/"/g,"").replace(/^\s+|\s+$|\s+(?=\s)/g,""),new RegExp(/(^(\d+)(,\s*\d+)*$)/g).test(n)&&(n=n.replace(/\s/g,""),n=n.split(","),n.map((function(e,t){n[t]=parseInt(e)})),n.unshift(null),n=new(Function.prototype.bind.apply(Smart.Utilities.TimeSpan,n)))),n instanceof Smart.Utilities.TimeSpan==0){if(""===n.trim())return void(t.interval=e);isNaN(n)||(n=1e4*parseInt(n,10));try{n=new Smart.Utilities.TimeSpan(n)}catch(a){return void(t.interval=e)}}}else{if("number"!=typeof a)return void(t.interval=e);n=new Smart.Utilities.TimeSpan(a)}0===n._ticks?t.interval=e:t.interval=n}_validateMinMax(e,t){const a=this;let n=!1;"max"!==e&&(a.min=Smart.Utilities.DateTime.validateDate(a.min,t||new Smart.Utilities.DateTime(1600,1,1),a.formatString),a.min=a.min.toTimeZone(a._outputTimeZone),n=!0),"min"!==e&&(a.max=Smart.Utilities.DateTime.validateDate(a.max,t||new Smart.Utilities.DateTime(3001,1,1),a.formatString),a.max=a.max.toTimeZone(a._outputTimeZone),a.max.calendar.days=a._localizedDays,a.max.calendar.months=a._localizedMonths,a.max.calendar.locale=a.locale,a.$.calendarDropDown.max=a.max.toDate()),a.min.compare(a.max)>0&&(a.min=a.max.clone(),n=!0),n&&(a.min.calendar.days=a._localizedDays,a.min.calendar.months=a._localizedMonths,a.min.calendar.locale=a.locale,a.$.calendarDropDown.min=a.min.toDate())}_validateRestrictedDates(){const e=this,t=[],a=[];for(let n=0;n<e.restrictedDates.length;n++){const i=e.restrictedDates[n];let o=Smart.Utilities.DateTime.validateDate(i,"invalid",e.formatString);"invalid"!==o&&(o=o.toTimeZone(e._outputTimeZone),t.push(o),a.push(o.toDate()))}e.restrictedDates=t,e.$.calendarDropDown.restrictedDates=a}_validateValue(e,t,a,n){const i=this,o=void 0!==t?t:i._cloneValue();if(null===e||""===e)return void i._setNullValue(o);if(e&&"string"==typeof e)if(-1===e.indexOf("-")&&-1===e.indexOf("/")&&-1===e.indexOf(".")){if(i.formatString){let t="",a=0;for(let n=0;n<i.formatString.length;n++)"-"===i.formatString[n]||"/"===i.formatString[n]||"."===i.formatString[n]?t+=i.formatString[n]:e[a]?(t+=e[a],a++):t+=i.formatString[n];if(t.indexOf("y")>=0){let e=t.substring(t.indexOf("y")-2);const a=i.yearCutoff.toString(),n=parseInt(a.slice(2),10);let o=parseInt(a.slice(0,2),10);e=parseInt(e,10),e<n&&o++,e=e.toString(),"NaN"!==e?(e=o+""+"0".repeat(2-e.length)+e,t=t.substring(0,t.indexOf("y")-2)+e):t=null}e=t}}else{let t=e.indexOf("-")>=0?"-":"";if(""===t&&(t=e.indexOf("/")>=0?"/":""),""===t&&(t=e.indexOf(".")>=0?".":""),t&&i.formatString.indexOf("yyyy")>=0){const a=e.split(t);let n=a[a.length-1];if(n.length<4){const o=i.yearCutoff.toString(),l=parseInt(o.slice(2),10);let r=parseInt(o.slice(0,2),10);n=parseInt(n,10),n<l&&r++,n=n.toString(),n=r+""+"0".repeat(2-n.length)+n,a[a.length-1]=n,e=a.join(t)}}}if(void 0!==e&&(i._value=Smart.Utilities.DateTime.validateDate(e,o,i.formatString)),null===i._value)return void i._setNullValue(o);let l=i._value;for(;!0===i._isRestricted(l);)l.addDays(1,!1);const r=i._rangeValidation(l);n&&"strict"!==i.validation?!1===l.equals(r)&&(i._minMaxChanged=!0):(i._value=r,delete i._minMaxChanged),i.value=i._value.toTimeZone(i._inputTimeZone);const s=i._value;if(s.calendar.days=i._localizedDays,s.calendar.months=i._localizedMonths,s.calendar.locale=i.locale,i._applyFormatString(),i._disableSpinButtons(),(null===o||null===s)&&o!==s||null!==o&&null!==s&&0!==o.compare(s)){if(!1!==a&&i.isInitialized&&!n&&(i.$.fireEvent("change",{oldValue:null!==o?o.toTimeZone(i._inputTimeZone):null,value:i.value}),i._updateTargetValue()),i._calendarInitiatedChange)return;i.opened?(null!==o&&0!==i.$.calendarDropDown.selectedDates.length&&o.year()===s.year()&&o.month()===s.month()&&o.day()===s.day()&&i.$.calendarDropDown._isDateInView(s.toDate())||(i._disregardCalendarChangeEvent=!0,i.$.calendarDropDown.selectedDates=[s.toDate()]),i._defaultFooterTemplateApplied&&(null!==o&&o.hour()===s.hour()||(i._hourElement.value=s.toString("hh"),i._ampmElement.value=s.toString("tt")),null!==o&&o.minute()===s.minute()||(i._minuteElement.value=s.toString("mm"))),i._timePickerInitialized&&!i._timePickerInitiatedChange&&(i.$.timePickerDropDown.value=s.toDate()),i._toSync=!1):i._toSync=!0}}});